(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9672,        323]
NotebookOptionsPosition[      7592,        256]
NotebookOutlinePosition[      8684,        286]
CellTagsIndexPosition[      8641,        283]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Reference Counts and Memory Management in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#14400"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Reference Counts and Memory Management in .NET/Link User Guide\
\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ReleaseNETObject" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/ReleaseNETObject"], 
          "BeginNETBlock" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/BeginNETBlock"], 
          "EndNETBlock" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/EndNETBlock"], 
          "LoadedNETObjects" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/LoadedNETObjects"], 
          "KeepNETObject" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/KeepNETObject"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ReleaseNETObject\"\>", 
       2->"\<\"BeginNETBlock\"\>", 3->"\<\"EndNETBlock\"\>", 
       4->"\<\"LoadedNETObjects\"\>", 
       5->"\<\"KeepNETObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/CallingExternalPrograms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Calling External Programs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NETBlock", "ObjectName",
 CellID->25889],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NETBlock", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]causes all new .NET objects returned to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " during the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to be released when ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " finishes."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14833]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["It is an error to refer to a released object.", "Notes",
 CellID->20618],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"NETBlock", " "}]], "InlineFormula"],
 "only affects new objects, not additional references to ones that have \
previously been seen."
}], "Notes",
 CellID->252201441],

Cell[TextData[{
 Cell[BoxData["NETBlock"], "InlineFormula"],
 " is a way to mark a set of objects as temporary so they can be \
automatically cleaned up on both the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and .NET sides."
}], "Notes",
 CellID->356051780]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->9690],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReleaseNETObject",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/ReleaseNETObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BeginNETBlock",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/BeginNETBlock"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EndNETBlock",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/EndNETBlock"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LoadedNETObjects",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/LoadedNETObjects"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KeepNETObject",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/KeepNETObject"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3420]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->2703],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Reference Counts and Memory Management in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#14400"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#14400"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#14400"]
}], "Tutorials",
 CellID->2028983154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->112854630],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->155643810]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NETBlock - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "NETBlock", "summary" -> 
    "NETBlock[expr] causes all new .NET objects returned to Mathematica \
during the evaluation of expr to be released when expr finishes.", "uri" -> 
    "NETLink/ref/NETBlock", "type" -> "Symbol", "label" -> 
    "N E T Link Symbol", "paclet" -> "NETLink", "context" -> "NETLink`", 
    "keywords" -> {}, "synonyms" -> {}, "status" -> "None", "built" -> 
    "{2007, 4, 18, 11, 14, 29.8469434}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2668, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3291, 93, 46, 1, 70, "ObjectName",
 CellID->25889],
Cell[3340, 96, 673, 21, 70, "Usage",
 CellID->14833]
}, Open  ]],
Cell[CellGroupData[{
Cell[4050, 122, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4509, 138, 78, 1, 70, "Notes",
 CellID->20618],
Cell[4590, 141, 208, 6, 70, "Notes",
 CellID->252201441],
Cell[4801, 149, 269, 8, 70, "Notes",
 CellID->356051780]
}, Closed]],
Cell[CellGroupData[{
Cell[5107, 162, 49, 1, 70, "SeeAlsoSection",
 CellID->9690],
Cell[5159, 165, 1283, 44, 70, "SeeAlso",
 CellID->3420]
}, Open  ]],
Cell[CellGroupData[{
Cell[6479, 214, 52, 1, 70, "TutorialsSection",
 CellID->2703],
Cell[6534, 217, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[6815, 228, 477, 12, 70, "Tutorials",
 CellID->2028983154]
}, Open  ]],
Cell[CellGroupData[{
Cell[7329, 245, 58, 1, 70, "MoreAboutSection",
 CellID->112854630],
Cell[7390, 248, 160, 3, 70, "MoreAbout",
 CellID->155643810]
}, Open  ]],
Cell[7565, 254, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

