(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12337,        397]
NotebookOptionsPosition[      9587,        320]
NotebookOutlinePosition[     11283,        358]
CellTagsIndexPosition[     11240,        355]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Getting Information about Types and Objects in .NET/Link User \
Guide" :> Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#25375"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Getting Information about Types and Objects in .NET/Link User \
Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NETType" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/NETType"], 
          "NETAssembly" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/NETAssembly"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"NETType\"\>", 
       2->"\<\"NETAssembly\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/CallingExternalPrograms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Calling External Programs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NETTypeInfo", "ObjectName",
 CellID->32351],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NETTypeInfo", "[", 
       StyleBox["type", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints information about the specified type, including \
its inheritance hierarchy, assembly name, and its public members \
(constructors, methods, properties, and so on). "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NETTypeInfo", "[", 
       StyleBox["obj", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]prints information about the object's type."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NETTypeInfo", "[", 
       StyleBox["assembly", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]prints information about the types in the assembly \
specified by the given ",
     Cell[BoxData[
      ButtonBox["NETAssembly",
       BaseStyle->"Link",
       ButtonData->"paclet:NETLink/ref/NETAssembly"]], "InlineFormula"],
     " expression."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NETTypeInfo", "[", 
       RowBox[{
        StyleBox["type", "TI"], ",", 
        StyleBox["members", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]prints information about only the specified members, \
which can be any of the following strings (or a list of them): \"",
     StyleBox["Type", "MR"],
     "\", \"",
     StyleBox["Constructors", "MR"],
     "\", \"",
     StyleBox["Methods", "MR"],
     "\", \"",
     StyleBox["Fields", "MR"],
     "\", \"",
     StyleBox["Properties", "MR"],
     "\", or \"",
     StyleBox["Events", "MR"],
     "\". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NETTypeInfo", "[", 
       RowBox[{
        StyleBox["type", "TI"], ",", 
        StyleBox["members", "TI"], ",", 
        StyleBox["pattern", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]prints only the members whose names match the given \
string pattern."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->15347]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->20173],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LanguageSyntax",
     BaseStyle->"Link",
     ButtonData->"paclet:NETLink/ref/LanguageSyntax"], "\"\<CSharp\>\"", Cell[
    TextData[{
     "the language syntax in which output should be formatted (must be ",
     Cell[BoxData["\"\<CSharp\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData["\"\<VisualBasic\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Inherited",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Inherited"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to include inherited members", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["IgnoreCase",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/IgnoreCase"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to ignore case in matching names to a string pattern", 
     "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->14959],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["type", "TI"]], "InlineFormula"],
 " argument can be a fully qualified type name given as a string, or a ",
 Cell[BoxData[
  ButtonBox["NETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETType"]], "InlineFormula"],
 " expression."
}], "Notes",
 CellID->144769183],

Cell[TextData[{
 "When calling ",
 Cell[BoxData["NETTypeInfo"], "InlineFormula"],
 " on a ",
 Cell[BoxData[
  ButtonBox["NETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETAssembly"]], "InlineFormula"],
 " expression, the ",
 Cell[BoxData[
  StyleBox["members", "TI"]], "InlineFormula"],
 " argument must be any of the following strings (or a list of them): \"",
 StyleBox["Classes", "MR"],
 "\", \"",
 StyleBox["Interfaces", "MR"],
 "\", \"",
 StyleBox["Structures", "MR"],
 "\", \"",
 StyleBox["Delegates", "MR"],
 "\", or \"",
 StyleBox["Enumerations", "MR"],
 "\"."
}], "Notes",
 CellID->1760017384]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->27943],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NETType",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/NETType"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NETAssembly",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/NETAssembly"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10604]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->13862],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Getting Information about Types and Objects in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#25375"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#25375"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#25375"]
}], "Tutorials",
 CellID->17818]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->67438906],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->401022804]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NETTypeInfo - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "NETTypeInfo", "summary" -> 
    "NETTypeInfo[type] prints information about the specified type, including \
its inheritance hierarchy, assembly name, and its public members \
(constructors, methods, properties, and so on). NETTypeInfo[obj] prints \
information about the object's type.  NETTypeInfo[assembly] prints \
information about the types in the assembly specified by the given \
NETAssembly expression.  NETTypeInfo[type, members] prints information about \
only the specified members, which can be any of the following strings (or a \
list of them): \"Type\", \"Constructors\", \"Methods\", \"Fields\", \
\"Properties\", or \"Events\". NETTypeInfo[type, members, pattern] prints \
only the members whose names match the given string pattern.", "uri" -> 
    "NETLink/ref/NETTypeInfo", "type" -> "Symbol", "label" -> 
    "N E T Link Symbol", "paclet" -> "NETLink", "context" -> "NETLink`", 
    "keywords" -> {}, "synonyms" -> {"type info"}, "status" -> "None", 
    "built" -> "{2007, 4, 18, 11, 14, 44.8809594}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2224, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2847, 85, 49, 1, 70, "ObjectName",
 CellID->32351],
Cell[2899, 88, 2163, 63, 70, "Usage",
 CellID->15347]
}, Open  ]],
Cell[CellGroupData[{
Cell[5099, 156, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5558, 172, 68, 1, 70, "Notes",
 CellID->20173],
Cell[5629, 175, 1283, 35, 70, "3ColumnTableMod",
 CellID->14959],
Cell[6915, 212, 332, 11, 70, "Notes",
 CellID->144769183],
Cell[7250, 225, 626, 23, 70, "Notes",
 CellID->1760017384]
}, Closed]],
Cell[CellGroupData[{
Cell[7913, 253, 50, 1, 70, "SeeAlsoSection",
 CellID->27943],
Cell[7966, 256, 471, 17, 70, "SeeAlso",
 CellID->10604]
}, Open  ]],
Cell[CellGroupData[{
Cell[8474, 278, 53, 1, 70, "TutorialsSection",
 CellID->13862],
Cell[8530, 281, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[8811, 292, 477, 12, 70, "Tutorials",
 CellID->17818]
}, Open  ]],
Cell[CellGroupData[{
Cell[9325, 309, 57, 1, 70, "MoreAboutSection",
 CellID->67438906],
Cell[9385, 312, 160, 3, 70, "MoreAbout",
 CellID->401022804]
}, Open  ]],
Cell[9560, 318, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

