(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8107,        273]
NotebookOptionsPosition[      6162,        213]
NotebookOutlinePosition[      7340,        244]
CellTagsIndexPosition[      7297,        241]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Reference Counts and Memory Management in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#14400"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Reference Counts and Memory Management in .NET/Link User Guide\
\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NETBlock" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/NETBlock"], 
          "BeginNETBlock" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/BeginNETBlock"], 
          "EndNETBlock" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/EndNETBlock"], 
          "LoadedNETObjects" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/LoadedNETObjects"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"NETBlock\"\>", 
       2->"\<\"BeginNETBlock\"\>", 3->"\<\"EndNETBlock\"\>", 
       4->"\<\"LoadedNETObjects\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ReleaseNETObject", "ObjectName",
 CellID->501],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReleaseNETObject", "[", 
       StyleBox["obj", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]tells the .NET memory-management system to forget any \
references to the specified ",
     Cell[BoxData["NETObject"], "InlineFormula"],
     " that are being maintained solely for the sake of ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5591]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData["NETObject"], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is no longer valid after the call."
}], "Notes",
 CellID->1685520545],

Cell[TextData[{
 "Call ",
 Cell[BoxData["ReleaseNETObject"], "InlineFormula"],
 " when you are completely finished with an object in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and want to allow it to be garbage-collected in .NET."
}], "Notes",
 CellID->6367]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->26362],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NETBlock",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/NETBlock"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BeginNETBlock",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/BeginNETBlock"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EndNETBlock",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/EndNETBlock"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LoadedNETObjects",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/LoadedNETObjects"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12196]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->1006],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Reference Counts and Memory Management in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#14400"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#14400"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#14400"]
}], "Tutorials",
 CellID->2028983154]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReleaseNETObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "ReleaseNETObject", "summary" -> 
    "ReleaseNETObject[obj] tells the .NET memory-management system to forget \
any references to the specified NETObject that are being maintained solely \
for the sake of Mathematica.", "uri" -> "NETLink/ref/ReleaseNETObject", 
    "type" -> "Symbol", "label" -> "N E T Link Symbol", "paclet" -> "NETLink",
     "context" -> "NETLink`", "keywords" -> {}, 
    "synonyms" -> {"release object"}, "status" -> "None", "built" -> 
    "{2007, 4, 18, 11, 14, 59.5644154}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1905, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2528, 74, 52, 1, 70, "ObjectName",
 CellID->501],
Cell[2583, 77, 622, 18, 70, "Usage",
 CellID->5591]
}, Open  ]],
Cell[CellGroupData[{
Cell[3242, 100, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3701, 116, 201, 8, 70, "Notes",
 CellID->1685520545],
Cell[3905, 126, 270, 8, 70, "Notes",
 CellID->6367]
}, Closed]],
Cell[CellGroupData[{
Cell[4212, 139, 50, 1, 70, "SeeAlsoSection",
 CellID->26362],
Cell[4265, 142, 1005, 35, 70, "SeeAlso",
 CellID->12196]
}, Open  ]],
Cell[CellGroupData[{
Cell[5307, 182, 52, 1, 70, "TutorialsSection",
 CellID->1006],
Cell[5362, 185, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[5643, 196, 477, 12, 70, "Tutorials",
 CellID->2028983154]
}, Open  ]],
Cell[6135, 211, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

