(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8135,        267]
NotebookOptionsPosition[      6093,        204]
NotebookOutlinePosition[      7258,        234]
CellTagsIndexPosition[      7215,        231]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Returning Objects \[OpenCurlyDoubleQuote]By Value\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]By Reference\
\[CloseCurlyDoubleQuote] in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#18481"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Returning Objects \[OpenCurlyDoubleQuote]By Value\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]By Reference\
\[CloseCurlyDoubleQuote] in .NET/Link User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NETObjectToExpression" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/ref/NETObjectToExpression"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NETObjectToExpression\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ReturnAsNETObject", "ObjectName",
 CellID->10504],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReturnAsNETObject", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]causes a .NET call during the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to return its result as an object reference (i.e., a ",
     Cell[BoxData["NETObject"], "InlineFormula"],
     " expression), not a value."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23662]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Most .NET objects are returned as references, but those that have a \
meaningful ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " representation are returned \"by value\", such as strings, arrays, and \
so-called \"boxed\" values like System.Int32."
}], "Notes",
 CellID->25581],

Cell[TextData[{
 Cell[BoxData["ReturnAsNETObject"], "InlineFormula"],
 " overrides the normal behavior and forces any object returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to be sent only as a reference."
}], "Notes",
 CellID->35497658],

Cell[TextData[{
 Cell[BoxData["ReturnAsNETObject"], "InlineFormula"],
 " is typically used to avoid needlessly sending large arrays of numbers back \
and forth between .NET and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->38144141],

Cell[TextData[{
 "You can use ",
 Cell[BoxData["ReturnAsNETObject"], "InlineFormula"],
 " to cause only a reference to be sent; then you can use the ",
 Cell[BoxData[
  ButtonBox["NETObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETObjectToExpression"]], 
  "InlineFormula"],
 " function at the end if the final value is needed."
}], "Notes",
 CellID->554571296]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->19427],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["NETObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETObjectToExpression"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->5237]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->20368],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Returning Objects \[OpenCurlyDoubleQuote]By Value\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]By Reference\
\[CloseCurlyDoubleQuote] in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#18481"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#18481"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#18481"]
}], "Tutorials",
 CellID->23131]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReturnAsNETObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "ReturnAsNETObject", "summary" -> 
    "ReturnAsNETObject[expr] causes a .NET call during the evaluation of expr \
to return its result as an object reference (i.e., a NETObject expression), \
not a value.", "uri" -> "NETLink/ref/ReturnAsNETObject", "type" -> "Symbol", 
    "label" -> "N E T Link Symbol", "paclet" -> "NETLink", "context" -> 
    "NETLink`", "keywords" -> {}, "synonyms" -> {"return as object"}, 
    "status" -> "None", "built" -> "{2007, 4, 18, 11, 15, 4.4321914}", 
    "index" -> True}, "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1755, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2378, 71, 55, 1, 70, "ObjectName",
 CellID->10504],
Cell[2436, 74, 625, 17, 70, "Usage",
 CellID->23662]
}, Open  ]],
Cell[CellGroupData[{
Cell[3098, 96, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3557, 112, 302, 8, 70, "Notes",
 CellID->25581],
Cell[3862, 122, 256, 7, 70, "Notes",
 CellID->35497658],
Cell[4121, 131, 265, 8, 70, "Notes",
 CellID->38144141],
Cell[4389, 141, 394, 11, 70, "Notes",
 CellID->554571296]
}, Closed]],
Cell[CellGroupData[{
Cell[4820, 157, 50, 1, 70, "SeeAlsoSection",
 CellID->19427],
Cell[4873, 160, 229, 6, 70, "SeeAlso",
 CellID->5237]
}, Open  ]],
Cell[CellGroupData[{
Cell[5139, 171, 53, 1, 70, "TutorialsSection",
 CellID->20368],
Cell[5195, 174, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[5476, 185, 575, 14, 70, "Tutorials",
 CellID->23131]
}, Open  ]],
Cell[6066, 202, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

