(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7906,        274]
NotebookOptionsPosition[      5816,        210]
NotebookOutlinePosition[      7023,        241]
CellTagsIndexPosition[      6980,        238]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\".NET/Link User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AddEventHandler" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/AddEventHandler"], 
          "NETNewDelegate" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/NETNewDelegate"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"AddEventHandler\"\>", 
       2->"\<\"NETNewDelegate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SendDelegateArguments", "ObjectName",
 CellID->9914],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["SendDelegateArguments"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["AddEventHandler",
       BaseStyle->"Link",
       ButtonData->"paclet:NETLink/ref/AddEventHandler"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["NETNewDelegate",
       BaseStyle->"Link",
       ButtonData->"paclet:NETLink/ref/NETNewDelegate"]], "InlineFormula"],
     " that specifies which of the delegate arguments you want to be passed \
to your ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " callback function."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7942]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default value is ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->610356638],

Cell[TextData[{
 "A list of numbers that represent argument indices can be used to specify \
which arguments to send. For example, ",
 Cell[BoxData[
  RowBox[{"SendDelegateArguments", "->", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}]], "InlineFormula"],
 " means to only send the first and third arguments."
}], "Notes",
 CellID->315225418],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 " to specify that no arguments should be sent."
}], "Notes",
 CellID->646047317],

Cell[TextData[{
 "By default, all the arguments in the delegate's signature are sent to the \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function assigned to the delegate. If you are not interested in some or \
all of the arguments, you can make the callback more efficient by using ",
 Cell[BoxData["SendDelegateArguments"], "InlineFormula"],
 " to eliminate some of the arguments."
}], "Notes",
 CellID->1087012238],

Cell["\<\
Efficiency is generally only a concern for arguments that are objects, not \
primitive types like integers or strings.\
\>", "Notes",
 CellID->155562081]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->18972],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AddEventHandler",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/AddEventHandler"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NETNewDelegate",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/NETNewDelegate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6335]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->13484],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SendDelegateArguments - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "SendDelegateArguments", "summary" -> 
    "SendDelegateArguments is an option to AddEventHandler and NETNewDelegate \
that specifies which of the delegate arguments you want to be passed to your \
Mathematica callback function.", "uri" -> "NETLink/ref/SendDelegateArguments",
     "type" -> "Symbol", "label" -> "N E T Link Symbol", "paclet" -> 
    "NETLink", "context" -> "NETLink`", "keywords" -> {}, 
    "synonyms" -> {"send delegate arguments"}, "status" -> "None", "built" -> 
    "{2007, 4, 18, 11, 15, 14.0175034}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1390, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2013, 65, 58, 1, 70, "ObjectName",
 CellID->9914],
Cell[2074, 68, 826, 24, 70, "Usage",
 CellID->7942]
}, Open  ]],
Cell[CellGroupData[{
Cell[2937, 97, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3396, 113, 188, 8, 70, "Notes",
 CellID->610356638],
Cell[3587, 123, 351, 9, 70, "Notes",
 CellID->315225418],
Cell[3941, 134, 282, 11, 70, "Notes",
 CellID->646047317],
Cell[4226, 147, 429, 10, 70, "Notes",
 CellID->1087012238],
Cell[4658, 159, 163, 4, 70, "Notes",
 CellID->155562081]
}, Closed]],
Cell[CellGroupData[{
Cell[4858, 168, 50, 1, 70, "SeeAlsoSection",
 CellID->18972],
Cell[4911, 171, 492, 17, 70, "SeeAlso",
 CellID->6335]
}, Open  ]],
Cell[CellGroupData[{
Cell[5440, 193, 53, 1, 70, "TutorialsSection",
 CellID->13484],
Cell[5496, 196, 278, 9, 70, "Tutorials",
 CellID->608907033]
}, Open  ]],
Cell[5789, 208, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

