(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39263,       1318]
NotebookOptionsPosition[     27409,        919]
NotebookOutlinePosition[     34842,       1140]
CellTagsIndexPosition[     34360,       1121]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Tutorial"
    }], "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Calling ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from .NET"
}], "Title",
 CellID->509267359],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellTags->"nlug:4.0",
 CellID->23842],

Cell[TextData[{
 ButtonBox["Calling .NET from ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica"],
  FontSlant->"Italic"],
 " describes using ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " to allow you to call from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " into .NET, thereby extending the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " environment to include the functionality in all existing and future .NET \
classes. ",
 ButtonBox["Calling ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingMathematicaFromNET"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingMathematicaFromNET"],
  FontSlant->"Italic"],
 ButtonBox[" from .NET",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingMathematicaFromNET"],
 " shows you how to use ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " in the opposite direction, as a means to write .NET programs that use the \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel as a computational engine."
}], "Text",
 CellTags->"nlug:1.0",
 CellID->11721],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " uses ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ", Wolfram Research\[CloseCurlyQuote]s protocol for sending data and \
commands between programs. Many of the concepts and techniques in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " programming are the same as those for programming with the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C-language API. The ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " documentation is not intended to be an encyclopedic compendium of \
everything you need to know to write .NET programs that use ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". Programmers may have to rely a little on the general documentation of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programming. The Tutorial is divided into two major sections along the \
same lines as this documentation. You will want to read the second part. Many \
of the functions ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " provides have C-language counterparts that are identical or nearly so."
}], "Text",
 CellTags->"nlug:4.0",
 CellID->8787],

Cell[TextData[{
 "You should at least skim the tutorial ",
 ButtonBox["Calling .NET from ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica"],
  FontSlant->"Italic"],
 " at some point. Your .NET \[OpenCurlyDoubleQuote]front end\
\[CloseCurlyDoubleQuote] can use the same techniques for calling .NET methods \
from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code and passing .NET objects as arguments that programmers use when \
running the kernel from the notebook front end. This allows you to have a \
very high-level interface between .NET and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". When you are writing ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs in C, you have to think about passing and returning simple things \
like strings and integers. With ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " you can pass .NET objects back and forth between .NET and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:4.0",
 CellID->19109],

Cell[TextData[{
 "The sections below merely provide an overview of topics in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " programming. The main class-by-class reference for ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " is the ",
 ButtonBox["API documentation",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/net/NETLink"],
 StyleBox[".",
  FontSlant->"Italic"],
 " You should also look at the ",
 ButtonBox["example programs",
  BaseStyle->"Hyperlink",
  Evaluator->Automatic,
  ButtonData:>{
    URL[
     ToFileName[{$InstallationDirectory, "SystemFiles", "Links", "NETLink", 
       "Examples", "Part2"}]], None}],
 "."
}], "Text",
 CellTags->"nlug:4.0",
 CellID->21389],

Cell[TextData[{
 "When you are reading this text, or programming in .NET or ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", remember that the entire source code for ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " is provided. If you want to see how anything works (or why it doesn\
\[CloseCurlyQuote]t), you can always consult the source code directly."
}], "Text",
 CellTags->"nlug:4.0",
 CellID->14383]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "What Is ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "?"
}], "Section",
 CellTags->"nlug:4.1",
 CellID->15721],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is a platform-independent protocol for communicating between programs. In \
more concrete terms, it is a means to send and receive ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is the means by which the notebook front end and kernel communicate with \
each other. It is also used by a large number of commercial and freeware \
applications and utilities that link ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and other programs or languages. It is implemented as a library of \
C-language functions. ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " brings the capabilities of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " into .NET in a way that is simpler to use and much more powerful than the \
raw C-level API."
}], "Text",
 CellTags->"nlug:4.1",
 CellID->16587]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Overview of the Main ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " Interfaces and Classes"
}], "Section",
 CellID->2337],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
 CellTags->"nlug:4.2.0",
 CellID->19435],

Cell[TextData[{
 "The ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " class library is written in an object-oriented style intended to maximize \
its extensibility in the future without requiring users' code to change. This \
requires a clean separation between interface and implementation. This is \
accomplished by exposing the main link functionality through interfaces, not \
classes. The names of the concrete classes that implement these interfaces \
will hardly be mentioned because programmers do not need to know or care what \
they are. Rather, you will use objects that belong to one of the interface \
types. You do not need to know what the actual classes are because you will \
never create an instance directly; instead, you use a \"factory method\" to \
create an instance of a link class. This will become clear further on."
}], "Text",
 CellTags->"nlug:4.2.0",
 CellID->30990],

Cell[TextData[{
 "This section gives a brief overview of the main interfaces and classes. \
They will be discussed in more detail later. In addition, there is full \
documentation for the class library in the ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " ",
 ButtonBox["API documentation",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/net/NETLink"],
 StyleBox[".",
  FontSlant->"Italic"],
 " Most of these classes and interfaces are in the ",
 StyleBox["Wolfram.NETLink", "MR"],
 " namespace; others are in ",
 StyleBox["Wolfram.NETLink.UI", "MR"],
 "."
}], "Text",
 CellTags->"nlug:4.2.0",
 CellID->27797]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMathLink and IKernelLink", "Subsection",
 CellTags->"nlug:4.2.1",
 CellID->20192],

Cell[TextData[{
 "The two most important link interfaces you need to know about are ",
 Cell[BoxData[
  ButtonBox["IMathLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IMathLink"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  ButtonBox["IMathLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IMathLink"]], "InlineFormula"],
 " interface is essentially a port of the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C API into .NET. Most of the method names will be familiar to experienced \
",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programmers. ",
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 " extends ",
 Cell[BoxData[
  ButtonBox["IMathLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IMathLink"]], "InlineFormula"],
 " and adds some important high-level convenience methods that are only \
meaningful if the other side of the link is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel (for example, the method ",
 StyleBox["WaitForAnswer()", "MR"],
 ", which assumes the other side of the link will respond with a defined \
series of packets)."
}], "Text",
 CellTags->"nlug:4.2.1",
 CellID->10317],

Cell[TextData[{
 "The basic idea is that the ",
 Cell[BoxData[
  ButtonBox["IMathLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IMathLink"]], "InlineFormula"],
 " interface encompasses all the operations that can be performed on a link \
without making any assumptions about what program is on the other side of the \
link. ",
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 " adds the assumption that the other side is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel."
}], "Text",
 CellTags->"nlug:4.2.1",
 CellID->13903],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 " is the most important interface, as most programmers will work exclusively \
with ",
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 ". Of course, since ",
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 " extends ",
 Cell[BoxData[
  ButtonBox["IMathLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IMathLink"]], "InlineFormula"],
 ", many of the methods you will use on your ",
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 " objects are declared and documented in the ",
 Cell[BoxData[
  ButtonBox["IMathLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IMathLink"]], "InlineFormula"],
 " interface."
}], "Text",
 CellTags->"nlug:4.2.1",
 CellID->11230],

Cell[TextData[{
 "The most important class that implements ",
 Cell[BoxData[
  ButtonBox["IMathLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IMathLink"]], "InlineFormula"],
 " is ",
 StyleBox["NativeLink", "MR"],
 ", so named because it calls directly into Wolfram \
Research\[CloseCurlyQuote]s ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library. In the future, other classes could be added that do not rely on \
native methods\[LongDash]for example, one that uses .NET remoting to \
communicate across a network. As discussed above, programmers do not need to \
be concerned about what these classes are, because they will never type a \
link class name in their code."
}], "Text",
 CellTags->"nlug:4.2.1",
 CellID->24865]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathLinkFactory", "Subsection",
 CellTags->"nlug:4.2.2",
 CellID->24952],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathLinkFactory",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/MathLinkFactory"]], "InlineFormula"],
 " is the class that you use to create link objects. It contains the static \
methods ",
 StyleBox["CreateMathLink()", "MR"],
 ", ",
 StyleBox["CreateKernelLink()", "MR"],
 ", and ",
 StyleBox["CreateLoopbackLink()", "MR"],
 ", which take various argument sequences. These are the equivalents of \
calling ",
 StyleBox["MLOpen", "MR"],
 " in a C program."
}], "Text",
 CellTags->"nlug:4.2.2",
 CellID->6719]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathLinkException", "Subsection",
 CellTags->"nlug:4.2.3",
 CellID->13297],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/MathLinkException"]], 
  "InlineFormula"],
 " is the exception class that is thrown by many of the methods in ",
 Cell[BoxData[
  ButtonBox["IMathLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IMathLink"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 ". The ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " API uses exceptions to indicate errors, rather than function return values \
like the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C API. In C, you write code that checks the return values like this:"
}], "Text",
 CellTags->"nlug:4.2.3",
 CellID->1654],

Cell["\<\
\t// C code
\tif (!MLPutInteger(link, 42)) {
\t\t// was error; print message and clean up.
\t}\
\>", "Program",
 CellTags->"nlug:4.2.3",
 CellID->11528],

Cell[TextData[{
 "In ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", you can wrap ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " calls in a ",
 StyleBox["try", "MR"],
 " block and catch ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/MathLinkException"]], 
  "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:4.2.3",
 CellID->10274]
}, Open  ]],

Cell[CellGroupData[{

Cell["Expr", "Subsection",
 CellTags->"nlug:4.2.4",
 CellID->20183],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/Expr"]], "InlineFormula"],
 " class provides a direct representation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions in .NET. ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/Expr"]], "InlineFormula"],
 " has a number of methods that provide information about the structure of \
the expression and that let you extract components. These methods have names \
and behaviors that will be familiar to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programmers\[LongDash]for example, ",
 StyleBox["Length()", "MR"],
 ", ",
 StyleBox["Part()", "MR"],
 ", ",
 StyleBox["NumberQ()", "MR"],
 ", ",
 StyleBox["VectorQ()", "MR"],
 ", ",
 StyleBox["Take()", "MR"],
 ", ",
 StyleBox["Delete()", "MR"],
 ", and so on. When reading from a link, instead of using the low-level ",
 Cell[BoxData[
  ButtonBox["IMathLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IMathLink"]], "InlineFormula"],
 " interface methods for discovering the structure and properties of the \
incoming expression, you can just read an entire expression from the link \
using ",
 StyleBox["GetExpr()", "MR"],
 ", and then use ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/Expr"]], "InlineFormula"],
 " methods to inspect it or decompose it. For writing to a link, ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/Expr"]], "InlineFormula"],
 " objects can be used as arguments to some of the most important ",
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 " methods."
}], "Text",
 CellTags->"nlug:4.2.4",
 CellID->9561]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathKernel", "Subsection",
 CellTags->"nlug:4.2.5",
 CellID->18913],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathKernel",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/MathKernel"]], "InlineFormula"],
 " is a non-visual component that provides a very high-level interface for \
interacting with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It is especially intended for use in visual programming environments, as \
it is highly configurable via properties. For many types of .NET programs \
that use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for computations, the ",
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 " interface provides ideal functionality. For some types of programs, \
however, programmers might find the ",
 Cell[BoxData[
  ButtonBox["MathKernel",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/MathKernel"]], "InlineFormula"],
 " object even easier to use. This is especially true for programs that want \
to capture not just the result of a computation, but also messages, ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " output, or graphics generated as side effects of the computation. "
}], "Text",
 CellTags->"nlug:4.2.5",
 CellID->3154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathPictureBox", "Subsection",
 CellTags->"nlug:4.2.6",
 CellID->31824],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["MathPictureBox",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/MathPictureBox"]], "InlineFormula"],
 " class provides an easy way to display ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics and typeset expressions. This class is often used from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code, but it is just as useful in .NET programs."
}], "Text",
 CellTags->"nlug:4.2.6",
 CellID->28698]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sample Program", "Section",
 CellTags->"nlug:4.3",
 CellID->15020],

Cell[TextData[{
 "The ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " distribution includes a ",
 ButtonBox["SimpleLink",
  BaseStyle->"Hyperlink",
  Evaluator->Automatic,
  ButtonData:>{
    URL[
     ToFileName[{$InstallationDirectory, "SystemFiles", "Links", "NETLink", 
       "Examples", "Part2", "SimpleLink"}]], None}],
 " sample program that demonstrates simple techniques for launching ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and performing computations. The code is available in both C# and Visual \
Basic .NET."
}], "Text",
 CellTags->"nlug:4.3",
 CellID->16303]
}, Open  ]],

Cell[CellGroupData[{

Cell["Building and Deploying Programs", "Section",
 CellID->17569],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " Assembly"
}], "Subsection",
 CellTags->"nlug:4.4.0",
 CellID->739],

Cell[TextData[{
 "The ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " assembly file is ",
 StyleBox["Wolfram.NETLink.dll", "MR"],
 ", and it is found in the ",
 StyleBox["<", "MR"],
 StyleBox["Mathematica", "MR",
  FontSlant->"Italic"],
 StyleBox[" dir>\\SystemFiles\\Links\\NETLink", "MR"],
 " directory. When you compile .NET programs that use ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", you will need to add a reference to this file. In previous versions of ",
 StyleBox[".NET/Lin",
  FontSlant->"Italic"],
 "k, this assembly was placed into the .NET global assembly cache (GAC) by \
the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installer. Starting with ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " 1.2, however, the ",
 StyleBox["Wolfram.NETLink.dll", "MR"],
 " assembly is no longer strong-named and therefore cannot be placed into the \
GAC. .NET programs that use ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " will therefore need to have a copy of this assembly in their application \
directory (that is, right next to their ",
 StyleBox[".exe", "MR"],
 " file). Alternatively, the ",
 StyleBox["Wolfram.NETLink.dll", "MR"],
 " assembly can be located in a subdirectory of the application\
\[CloseCurlyQuote]s directory, according to the standard rules for how .NET \
probes for assemblies that are not strong-named."
}], "Text",
 CellTags->"nlug:4.4.0",
 CellID->29968],

Cell[TextData[{
 "A consequence of the fact that ",
 StyleBox["Wolfram.NETLink.dll", "MR"],
 " is not strong-named is that you can replace your application\
\[CloseCurlyQuote]s copy with an updated version, and the updated version \
will be used without requiring the application to be recompiled. In contrast, \
strong-named assemblies in .NET are strictly versioned, so that when a \
program is compiled against a specific version of the assembly, the program \
can only run with that precise version. Of course, this strict versioning is \
touted as a benefit of .NET, and it is advantageous in certain circumstances, \
but for various technical reasons it is not desirable for ",
 StyleBox["Wolfram.NETLink.dll", "MR"],
 " to be strong-named."
}], "Text",
 CellTags->"nlug:4.4.0",
 CellID->15837]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compiling from the Command Line", "Subsection",
 CellTags->"nlug:4.4.1",
 CellID->21224],

Cell["\<\
The .NET Framework SDK includes command-line compilers for several .NET \
languages, including C# and Visual Basic .NET. You can use these free tools \
without purchasing Visual Studio .NET, and you might want to use them to \
build simple programs even if you do have Visual Studio .NET.\
\>", "Text",
 CellTags->"nlug:4.4.1",
 CellID->7456],

Cell[TextData[{
 "The command-line compilers rely on several DOS environment variables being \
set correctly, so the .NET Framework SDK comes with a batch file named ",
 StyleBox["sdkvars.bat", "MR"],
 " that you can run in your DOS session to set these variables. If you own \
Visual Studio .NET and want to use any command-line tools, use the ",
 StyleBox["Microsoft Visual Studio .NET/Visual Studio .NET Tools/Visual \
Studio .NET Command Prompt", "SR"],
 " item on the Windows ",
 StyleBox["Start", "SR"],
 " menu to launch a DOS session with all the required settings."
}], "Text",
 CellTags->"nlug:4.4.1",
 CellID->23388],

Cell[TextData[{
 "It is convenient to place a copy of ",
 StyleBox["Wolfram.NETLink.dll", "MR"],
 " into your build directory before you compile, as you would otherwise need \
to include the full path to this assembly on the compiler command line, and \
you will need a copy of it to be present in the program\[CloseCurlyQuote]s \
directory anyway. The examples below assume that you have copied (not moved!) \
the ",
 StyleBox["Wolfram.NETLink.dll", "MR"],
 " file from ",
 StyleBox["<", "MR"],
 StyleBox["Mathematica", "MR",
  FontSlant->"Italic"],
 StyleBox[" dir>\\SystemFiles\\Links\\NETLink", "MR"],
 " into the directory in which you are performing the build. Here is a sample \
command for a C# program:"
}], "Text",
 CellTags->"nlug:4.4.1",
 CellID->24366],

Cell["\<\
csc /target:winexe /reference:Wolfram.NETLink.dll MyProgram.cs\
\>", "Program",
 CellTags->"nlug:4.4.1",
 CellID->6296],

Cell["Here is a comparable example for Visual Basic .NET:", "Text",
 CellTags->"nlug:4.4.1",
 CellID->23658],

Cell["\<\
vbc /target:winexe /reference:Wolfram.NETLink.dll MyProgram.vb\
\>", "Program",
 CellTags->"nlug:4.4.1",
 CellID->17586],

Cell[TextData[{
 "Either of the above commands will result in the creation of a ",
 StyleBox["MyProgram.exe", "MR"],
 " file in the current directory. This program will need to have a copy of ",
 StyleBox["Wolfram.NETLink.dll", "MR"],
 " alongside it to run."
}], "Text",
 CellTags->"nlug:4.4.1",
 CellID->9420]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using Visual Studio .NET", "Subsection",
 CellTags->"nlug:4.4.2",
 CellID->23832],

Cell[TextData[{
 "Programs that use ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " need to have a reference to the ",
 StyleBox["Wolfram.NETLink.dll", "MR"],
 " assembly in their project settings. You add a reference to an assembly by \
selecting ",
 StyleBox["Add Reference", "SR"],
 " from the ",
 StyleBox["Project", "SR"],
 " menu. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installer makes the necessary settings so that the ",
 StyleBox["Wolfram.NETLink.dll", "MR"],
 " assembly shows up in the ",
 StyleBox["Add Reference", "SR"],
 " dialog box. It will be listed as ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " 1.3 in the ",
 StyleBox[".NET", "SR"],
 " tab. If for some reason it does not show up there, you can simply use the \
",
 StyleBox["Browse", "SR"],
 " button to locate the file manually (it will be in the ",
 StyleBox["<", "MR"],
 StyleBox["Mathematica", "MR",
  FontSlant->"Italic"],
 StyleBox[" dir>\\SystemFiles\\Links\\NETLink", "MR"],
 " directory, or perhaps in another more convenient location if you put a \
copy elsewhere)."
}], "Text",
 CellTags->"nlug:4.4.2",
 CellID->25],

Cell[TextData[{
 "When Visual Studio .NET builds your program it will automatically place a \
copy of ",
 StyleBox["Wolfram.NETLink.dll", "MR"],
 " in the output directory, alongside your ",
 StyleBox[".exe", "MR"],
 " file. Your program will require a copy of ",
 StyleBox["Wolfram.NETLink.dll", "MR"],
 " alongside it to run, so if you deploy your program to another location or \
distribute it to other users, you must keep the ",
 StyleBox["Wolfram.NETLink.dll", "MR"],
 " file with it."
}], "Text",
 CellTags->"nlug:4.4.2",
 CellID->29276]
}, Open  ]],

Cell[CellGroupData[{

Cell["Deploying Programs", "Subsection",
 CellTags->"nlug:4.4.3",
 CellID->3309],

Cell[TextData[{
 "If you build a .NET program that uses ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " and want to distribute it to others, you will need to include a copy of \
the ",
 StyleBox["Wolfram.NETLink.dll", "MR"],
 " assembly alongside your application\[CloseCurlyQuote]s ",
 StyleBox[".exe", "MR"],
 " file. Alternatively, you can put ",
 StyleBox["Wolfram.NETLink.dll", "MR"],
 " in a subdirectory of the application\[CloseCurlyQuote]s directory, \
according to the standard rules for how .NET probes for assemblies that are \
not strong-named."
}], "Text",
 CellTags->"nlug:4.4.3",
 CellID->8091]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Calling Mathematica from .NET - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "Calling Mathematica from .NET", "summary" -> 
    "Calling .NET from Mathematica describes using .NET/Link to allow you to \
call from Mathematica into .NET, thereby extending the Mathematica \
environment to include the functionality in all existing and future .NET \
classes. Calling Mathematica from .NET shows you how to use .NET/Link in the \
opposite direction, as a means to write .NET programs that use the \
Mathematica kernel as a computational engine. .NET/Link uses MathLink, \
Wolfram Research's protocol for sending data and commands between programs. \
Many of the concepts and techniques in .NET/Link programming are the same as \
those for programming with the MathLink C-language API. The .NET/Link \
documentation is not intended to be an encyclopedic compendium of everything \
you need to know to write .NET programs that use MathLink. Programmers may \
have to rely a little on the general documentation of MathLink programming. \
The Tutorial is divided into two major sections along the same lines as this \
documentation. You will want to read the second part. Many of the functions \
.NET/Link provides have C-language counterparts that are identical or nearly \
so. You should at least skim the tutorial Calling .NET from Mathematica at \
some point. Your .NET 'front end' can use the same techniques for calling \
.NET methods from Mathematica code and passing .NET objects as arguments that \
programmers use when running the kernel from the notebook front end. This \
allows you to have a very high-level interface between .NET and Mathematica. \
When you are writing MathLink programs in C, you have to think about passing \
and returning simple things like strings and integers. With .NET/Link you can \
pass .NET objects back and forth between .NET and Mathematica.", "uri" -> 
    "NETLink/tutorial/CallingMathematicaFromNET", "type" -> "Tutorial", 
    "label" -> "N E T Link Tutorial", "paclet" -> "NETLink", "context" -> "", 
    "keywords" -> {}, "synonyms" -> {}, "status" -> "None", "built" -> 
    "{2007, 4, 18, 11, 15, 33.7289914}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "nlug:4.0"->{
  Cell[954, 44, 70, 2, 70, "Section",
   CellTags->"nlug:4.0",
   CellID->23842],
  Cell[2311, 89, 1142, 31, 70, "Text",
   CellTags->"nlug:4.0",
   CellID->8787],
  Cell[3456, 122, 1177, 32, 70, "Text",
   CellTags->"nlug:4.0",
   CellID->19109],
  Cell[4636, 156, 696, 24, 70, "Text",
   CellTags->"nlug:4.0",
   CellID->21389],
  Cell[5335, 182, 417, 11, 70, "Text",
   CellTags->"nlug:4.0",
   CellID->14383]},
 "nlug:1.0"->{
  Cell[1027, 48, 1281, 39, 70, "Text",
   CellTags->"nlug:1.0",
   CellID->11721]},
 "nlug:4.1"->{
  Cell[5789, 198, 133, 7, 70, "Section",
   CellTags->"nlug:4.1",
   CellID->15721],
  Cell[5925, 207, 925, 26, 70, "Text",
   CellTags->"nlug:4.1",
   CellID->16587]},
 "nlug:4.2.0"->{
  Cell[7057, 248, 75, 2, 70, "Subsection",
   CellTags->"nlug:4.2.0",
   CellID->19435],
  Cell[7135, 252, 900, 16, 70, "Text",
   CellTags->"nlug:4.2.0",
   CellID->30990],
  Cell[8038, 270, 623, 19, 70, "Text",
   CellTags->"nlug:4.2.0",
   CellID->27797]},
 "nlug:4.2.1"->{
  Cell[8698, 294, 88, 2, 70, "Subsection",
   CellTags->"nlug:4.2.1",
   CellID->20192],
  Cell[8789, 298, 1427, 43, 70, "Text",
   CellTags->"nlug:4.2.1",
   CellID->10317],
  Cell[10219, 343, 649, 19, 70, "Text",
   CellTags->"nlug:4.2.1",
   CellID->13903],
  Cell[10871, 364, 1120, 34, 70, "Text",
   CellTags->"nlug:4.2.1",
   CellID->11230],
  Cell[11994, 400, 754, 19, 70, "Text",
   CellTags->"nlug:4.2.1",
   CellID->24865]},
 "nlug:4.2.2"->{
  Cell[12785, 424, 78, 2, 70, "Subsection",
   CellTags->"nlug:4.2.2",
   CellID->24952],
  Cell[12866, 428, 568, 18, 70, "Text",
   CellTags->"nlug:4.2.2",
   CellID->6719]},
 "nlug:4.2.3"->{
  Cell[13471, 451, 80, 2, 70, "Subsection",
   CellTags->"nlug:4.2.3",
   CellID->13297],
  Cell[13554, 455, 838, 26, 70, "Text",
   CellTags->"nlug:4.2.3",
   CellID->1654],
  Cell[14395, 483, 162, 7, 70, "Program",
   CellTags->"nlug:4.2.3",
   CellID->11528],
  Cell[14560, 492, 409, 18, 70, "Text",
   CellTags->"nlug:4.2.3",
   CellID->10274]},
 "nlug:4.2.4"->{
  Cell[15006, 515, 67, 2, 70, "Subsection",
   CellTags->"nlug:4.2.4",
   CellID->20183],
  Cell[15076, 519, 1892, 58, 70, "Text",
   CellTags->"nlug:4.2.4",
   CellID->9561]},
 "nlug:4.2.5"->{
  Cell[17005, 582, 73, 2, 70, "Subsection",
   CellTags->"nlug:4.2.5",
   CellID->18913],
  Cell[17081, 586, 1332, 35, 70, "Text",
   CellTags->"nlug:4.2.5",
   CellID->3154]},
 "nlug:4.2.6"->{
  Cell[18450, 626, 77, 2, 70, "Subsection",
   CellTags->"nlug:4.2.6",
   CellID->31824],
  Cell[18530, 630, 485, 15, 70, "Text",
   CellTags->"nlug:4.2.6",
   CellID->28698]},
 "nlug:4.3"->{
  Cell[19064, 651, 72, 2, 70, "Section",
   CellTags->"nlug:4.3",
   CellID->15020],
  Cell[19139, 655, 593, 19, 70, "Text",
   CellTags->"nlug:4.3",
   CellID->16303]},
 "nlug:4.4.0"->{
  Cell[19860, 684, 141, 7, 70, "Subsection",
   CellTags->"nlug:4.4.0",
   CellID->739],
  Cell[20004, 693, 1421, 40, 70, "Text",
   CellTags->"nlug:4.4.0",
   CellID->29968],
  Cell[21428, 735, 800, 15, 70, "Text",
   CellTags->"nlug:4.4.0",
   CellID->15837]},
 "nlug:4.4.1"->{
  Cell[22265, 755, 94, 2, 70, "Subsection",
   CellTags->"nlug:4.4.1",
   CellID->21224],
  Cell[22362, 759, 352, 7, 70, "Text",
   CellTags->"nlug:4.4.1",
   CellID->7456],
  Cell[22717, 768, 627, 13, 70, "Text",
   CellTags->"nlug:4.4.1",
   CellID->23388],
  Cell[23347, 783, 765, 18, 70, "Text",
   CellTags->"nlug:4.4.1",
   CellID->24366],
  Cell[24115, 803, 129, 4, 70, "Program",
   CellTags->"nlug:4.4.1",
   CellID->6296],
  Cell[24247, 809, 108, 2, 70, "Text",
   CellTags->"nlug:4.4.1",
   CellID->23658],
  Cell[24358, 813, 130, 4, 70, "Program",
   CellTags->"nlug:4.4.1",
   CellID->17586],
  Cell[24491, 819, 311, 8, 70, "Text",
   CellTags->"nlug:4.4.1",
   CellID->9420]},
 "nlug:4.4.2"->{
  Cell[24839, 832, 87, 2, 70, "Subsection",
   CellTags->"nlug:4.4.2",
   CellID->23832],
  Cell[24929, 836, 1132, 35, 70, "Text",
   CellTags->"nlug:4.4.2",
   CellID->25],
  Cell[26064, 873, 544, 14, 70, "Text",
   CellTags->"nlug:4.4.2",
   CellID->29276]},
 "nlug:4.4.3"->{
  Cell[26645, 892, 80, 2, 70, "Subsection",
   CellTags->"nlug:4.4.3",
   CellID->3309],
  Cell[26728, 896, 615, 16, 70, "Text",
   CellTags->"nlug:4.4.3",
   CellID->8091]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"nlug:4.0", 30125, 965},
 {"nlug:1.0", 30555, 981},
 {"nlug:4.1", 30654, 985},
 {"nlug:4.2.0", 30840, 992},
 {"nlug:4.2.1", 31117, 1002},
 {"nlug:4.2.2", 31569, 1018},
 {"nlug:4.2.3", 31762, 1025},
 {"nlug:4.2.4", 32129, 1038},
 {"nlug:4.2.5", 32323, 1045},
 {"nlug:4.2.6", 32517, 1052},
 {"nlug:4.3", 32709, 1059},
 {"nlug:4.4.0", 32896, 1066},
 {"nlug:4.4.1", 33176, 1076},
 {"nlug:4.4.2", 33884, 1101},
 {"nlug:4.4.3", 34162, 1111}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 180, 7, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[805, 34, 124, 6, 70, "Title",
 CellID->509267359],
Cell[CellGroupData[{
Cell[954, 44, 70, 2, 70, "Section",
 CellTags->"nlug:4.0",
 CellID->23842],
Cell[1027, 48, 1281, 39, 70, "Text",
 CellTags->"nlug:1.0",
 CellID->11721],
Cell[2311, 89, 1142, 31, 70, "Text",
 CellTags->"nlug:4.0",
 CellID->8787],
Cell[3456, 122, 1177, 32, 70, "Text",
 CellTags->"nlug:4.0",
 CellID->19109],
Cell[4636, 156, 696, 24, 70, "Text",
 CellTags->"nlug:4.0",
 CellID->21389],
Cell[5335, 182, 417, 11, 70, "Text",
 CellTags->"nlug:4.0",
 CellID->14383]
}, Open  ]],
Cell[CellGroupData[{
Cell[5789, 198, 133, 7, 70, "Section",
 CellTags->"nlug:4.1",
 CellID->15721],
Cell[5925, 207, 925, 26, 70, "Text",
 CellTags->"nlug:4.1",
 CellID->16587]
}, Open  ]],
Cell[CellGroupData[{
Cell[6887, 238, 145, 6, 70, "Section",
 CellID->2337],
Cell[CellGroupData[{
Cell[7057, 248, 75, 2, 70, "Subsection",
 CellTags->"nlug:4.2.0",
 CellID->19435],
Cell[7135, 252, 900, 16, 70, "Text",
 CellTags->"nlug:4.2.0",
 CellID->30990],
Cell[8038, 270, 623, 19, 70, "Text",
 CellTags->"nlug:4.2.0",
 CellID->27797]
}, Open  ]],
Cell[CellGroupData[{
Cell[8698, 294, 88, 2, 70, "Subsection",
 CellTags->"nlug:4.2.1",
 CellID->20192],
Cell[8789, 298, 1427, 43, 70, "Text",
 CellTags->"nlug:4.2.1",
 CellID->10317],
Cell[10219, 343, 649, 19, 70, "Text",
 CellTags->"nlug:4.2.1",
 CellID->13903],
Cell[10871, 364, 1120, 34, 70, "Text",
 CellTags->"nlug:4.2.1",
 CellID->11230],
Cell[11994, 400, 754, 19, 70, "Text",
 CellTags->"nlug:4.2.1",
 CellID->24865]
}, Open  ]],
Cell[CellGroupData[{
Cell[12785, 424, 78, 2, 70, "Subsection",
 CellTags->"nlug:4.2.2",
 CellID->24952],
Cell[12866, 428, 568, 18, 70, "Text",
 CellTags->"nlug:4.2.2",
 CellID->6719]
}, Open  ]],
Cell[CellGroupData[{
Cell[13471, 451, 80, 2, 70, "Subsection",
 CellTags->"nlug:4.2.3",
 CellID->13297],
Cell[13554, 455, 838, 26, 70, "Text",
 CellTags->"nlug:4.2.3",
 CellID->1654],
Cell[14395, 483, 162, 7, 70, "Program",
 CellTags->"nlug:4.2.3",
 CellID->11528],
Cell[14560, 492, 409, 18, 70, "Text",
 CellTags->"nlug:4.2.3",
 CellID->10274]
}, Open  ]],
Cell[CellGroupData[{
Cell[15006, 515, 67, 2, 70, "Subsection",
 CellTags->"nlug:4.2.4",
 CellID->20183],
Cell[15076, 519, 1892, 58, 70, "Text",
 CellTags->"nlug:4.2.4",
 CellID->9561]
}, Open  ]],
Cell[CellGroupData[{
Cell[17005, 582, 73, 2, 70, "Subsection",
 CellTags->"nlug:4.2.5",
 CellID->18913],
Cell[17081, 586, 1332, 35, 70, "Text",
 CellTags->"nlug:4.2.5",
 CellID->3154]
}, Open  ]],
Cell[CellGroupData[{
Cell[18450, 626, 77, 2, 70, "Subsection",
 CellTags->"nlug:4.2.6",
 CellID->31824],
Cell[18530, 630, 485, 15, 70, "Text",
 CellTags->"nlug:4.2.6",
 CellID->28698]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19064, 651, 72, 2, 70, "Section",
 CellTags->"nlug:4.3",
 CellID->15020],
Cell[19139, 655, 593, 19, 70, "Text",
 CellTags->"nlug:4.3",
 CellID->16303]
}, Open  ]],
Cell[CellGroupData[{
Cell[19769, 679, 66, 1, 70, "Section",
 CellID->17569],
Cell[CellGroupData[{
Cell[19860, 684, 141, 7, 70, "Subsection",
 CellTags->"nlug:4.4.0",
 CellID->739],
Cell[20004, 693, 1421, 40, 70, "Text",
 CellTags->"nlug:4.4.0",
 CellID->29968],
Cell[21428, 735, 800, 15, 70, "Text",
 CellTags->"nlug:4.4.0",
 CellID->15837]
}, Open  ]],
Cell[CellGroupData[{
Cell[22265, 755, 94, 2, 70, "Subsection",
 CellTags->"nlug:4.4.1",
 CellID->21224],
Cell[22362, 759, 352, 7, 70, "Text",
 CellTags->"nlug:4.4.1",
 CellID->7456],
Cell[22717, 768, 627, 13, 70, "Text",
 CellTags->"nlug:4.4.1",
 CellID->23388],
Cell[23347, 783, 765, 18, 70, "Text",
 CellTags->"nlug:4.4.1",
 CellID->24366],
Cell[24115, 803, 129, 4, 70, "Program",
 CellTags->"nlug:4.4.1",
 CellID->6296],
Cell[24247, 809, 108, 2, 70, "Text",
 CellTags->"nlug:4.4.1",
 CellID->23658],
Cell[24358, 813, 130, 4, 70, "Program",
 CellTags->"nlug:4.4.1",
 CellID->17586],
Cell[24491, 819, 311, 8, 70, "Text",
 CellTags->"nlug:4.4.1",
 CellID->9420]
}, Open  ]],
Cell[CellGroupData[{
Cell[24839, 832, 87, 2, 70, "Subsection",
 CellTags->"nlug:4.4.2",
 CellID->23832],
Cell[24929, 836, 1132, 35, 70, "Text",
 CellTags->"nlug:4.4.2",
 CellID->25],
Cell[26064, 873, 544, 14, 70, "Text",
 CellTags->"nlug:4.4.2",
 CellID->29276]
}, Open  ]],
Cell[CellGroupData[{
Cell[26645, 892, 80, 2, 70, "Subsection",
 CellTags->"nlug:4.4.3",
 CellID->3309],
Cell[26728, 896, 615, 16, 70, "Text",
 CellTags->"nlug:4.4.3",
 CellID->8091]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[27382, 917, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

