(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    681819,      23139]
NotebookOptionsPosition[    487903,      16285]
NotebookOutlinePosition[    589326,      19644]
CellTagsIndexPosition[    586563,      19563]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Tutorial"
    }], "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Calling .NET from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Title",
 CellID->509267359],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellTags->"nlug:3.0",
 CellID->26930],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " provides ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users with the ability to interact with arbitrary .NET types directly from \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can create objects and call methods and properties directly in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language. You do not need to write any .NET code, or prepare in any way \
the .NET types you want to use. You also do not need to know anything about \
",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". In effect, all of .NET becomes a transparent extension to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", almost as if every existing and future .NET type were written in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language itself."
}], "Text",
 CellTags->"nlug:3.0",
 CellID->3826],

Cell[TextData[{
 "We call this facility \[OpenCurlyDoubleQuote]installable .NET\
\[CloseCurlyDoubleQuote] because it generalizes the ability that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has always had to plug in extensions written in other languages through \
the ",
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 " function. Compared to other languages like C or C++, however, .NET",
 StyleBox["/Link",
  FontSlant->"Italic"],
 " makes the intermediate steps go away completely, which is why we say that \
.NET becomes a ",
 StyleBox["transparent",
  FontSlant->"Italic"],
 " extension to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.0",
 CellID->2852],

Cell[TextData[{
 "Although .NET is sometimes referred to as an interpreted environment, this \
is really a misnomer. To use .NET you must write a complete program in a \
language like C#, compile it, and then execute it. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users have the luxury of working in a true interpreted, interactive \
environment that lets them experiment with functions and build and test \
programs a line at a time. ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " brings this same productive environment to .NET programmers. You could say \
that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " becomes a scripting language for .NET."
}], "Text",
 CellTags->"nlug:3.0",
 CellID->5675],

Cell[TextData[{
 "To ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users, then, the \[OpenCurlyDoubleQuote]installable .NET\
\[CloseCurlyDoubleQuote] feature of ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " opens up the universe of .NET types as an extension to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "; for .NET users, it allows the extraordinarily powerful and versatile ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " environment to be used as a shell for interactively developing, \
experimenting with, and testing .NET programs."
}], "Text",
 CellTags->"nlug:3.0",
 CellID->24177],

Cell[TextData[{
 "This guide discusses calling from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " into the .NET runtime. You will see how to load .NET assemblies and types \
into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", create objects of these types, call methods and properties, and so on. \
You will also learn how to use ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " to call COM objects as well as standard C-style DLL functions."
}], "Text",
 CellTags->"nlug:3.0",
 CellID->20734],

Cell[TextData[StyleBox["Simple Examples:",
 FontWeight->"Bold"]], "Text",
 CellTags->"nlug:3.0",
 CellID->16620],

Cell[TextData[ButtonBox["ProcessPriority.nb",
 BaseStyle->"Link",
 ButtonData->"paclet:NETLink/example/Part1/ProcessPriority"]], "Text",
 CellTags->"nlug:3.0",
 CellID->23893],

Cell[TextData[StyleBox["GUI Examples:",
 FontWeight->"Bold"]], "Text",
 CellTags->"nlug:3.0",
 CellID->15023],

Cell[TextData[ButtonBox["Circumcircle.nb",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NETLink/example/Part1/WindowsAndDialogs/Circumcircle"]], "Text",
 CellTags->"nlug:3.0",
 CellID->25940],

Cell[TextData[ButtonBox["PackageHelper.nb",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NETLink/example/Part1/WindowsAndDialogs/PackageHelper"]], "Text",
 CellTags->"nlug:3.0",
 CellID->19959],

Cell[TextData[ButtonBox["SimpleAnimationWindow.nb",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NETLink/example/Part1/WindowsAndDialogs/SimpleAnimationWindow"]], \
"Text",
 CellTags->"nlug:3.0",
 CellID->2118],

Cell[TextData[ButtonBox["RealTimeAlgebra.nb",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NETLink/example/Part1/WindowsAndDialogs/RealTimeAlgebra"]], "Text",
 CellTags->"nlug:3.0",
 CellID->13028],

Cell[TextData[ButtonBox["AsteroidsGame.nb",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NETLink/example/Part1/WindowsAndDialogs/AsteroidsGame"]], "Text",
 CellTags->"nlug:3.0",
 CellID->17376],

Cell[TextData[StyleBox["Calling DLLs:",
 FontWeight->"Bold"]], "Text",
 CellTags->"nlug:3.0",
 CellID->17945],

Cell[TextData[ButtonBox["BZip2Compression.nb",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NETLink/example/Part1/CallingDLLs/BZip2Compression"]], "Text",
 CellTags->"nlug:3.0",
 CellID->10453],

Cell[TextData[ButtonBox["EnumWindows.nb",
 BaseStyle->"Link",
 ButtonData->"paclet:NETLink/example/Part1/CallingDLLs/EnumWindows"]], "Text",\

 CellTags->"nlug:3.0",
 CellID->27035],

Cell[TextData[ButtonBox["WindowsAPI.nb",
 BaseStyle->"Link",
 ButtonData->"paclet:NETLink/example/Part1/CallingDLLs/WindowsAPI"]], "Text",
 CellTags->"nlug:3.0",
 CellID->15565],

Cell[TextData[StyleBox["Calling COM Objects:",
 FontWeight->"Bold"]], "Text",
 CellTags->"nlug:3.0",
 CellID->20826],

Cell[TextData[ButtonBox["ExcelPieChart.nb",
 BaseStyle->"Link",
 ButtonData->"paclet:NETLink/example/Part1/CallingCOM/ExcelPieChart"]], "Text",\

 CellTags->"nlug:3.0",
 CellID->15670]
}, Open  ]],

Cell[CellGroupData[{

Cell["Loading the NETLink` Package", "Section",
 CellTags->"nlug:3.1.0",
 CellID->23489],

Cell[TextData[{
 "You must load the ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " package before you can use ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.1.0",
 CellID->4497],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NETLink`\>\"", "]"}]], "Input",
 CellTags->"nlug:3.1.0",
 CellID->25338]
}, Open  ]],

Cell[CellGroupData[{

Cell["Launching the .NET Runtime", "Section",
 CellTags->"nlug:3.1.1",
 CellID->25576],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["InstallNET",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/InstallNET"]], "InlineFormula"],
 " function is used to launch the .NET runtime."
}], "Text",
 CellTags->"nlug:3.1.1",
 CellID->22674],

Cell[BoxData[
 RowBox[{
  RowBox[{"InstallNET", "[", "]"}], ";"}]], "Input",
 CellTags->"nlug:3.1.1",
 CellID->20325],

Cell[TextData[{
 "If you are actively developing .NET classes and other types to use in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you will need to restart the .NET runtime before you can reload a \
modified version of a class. Use the ",
 Cell[BoxData[
  ButtonBox["ReinstallNET",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReinstallNET"]], "InlineFormula"],
 " function to quit and restart the .NET runtime. Most users will have no \
need to ever quit or restart .NET and should avoid calling ",
 Cell[BoxData[
  ButtonBox["ReinstallNET",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReinstallNET"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["UninstallNET",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/UninstallNET"]], "InlineFormula"],
 ". Remember that the .NET runtime is shared by potentially many programs in \
your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. Shutting down or restarting the .NET runtime could have \
unexpected consequences for those programs."
}], "Text",
 CellTags->"nlug:3.1.1",
 CellID->31465],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["InstallNET",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/InstallNET"], "[", "]"}], Cell[
    TextData[{
     "launch the .NET runtime and prepare it for use from ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ReinstallNET",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/ReinstallNET"], "[", "]"}], Cell[
    "quit and restart the .NET runtime", "TableText"]},
   {
    RowBox[{
     ButtonBox["NETLink",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETLink"], "[", "]"}], Cell[TextData[{
     "give the ",
     StyleBox[ButtonBox["LinkObject",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkObject"], "InlineCode"],
     " that is being used to communicate with the .NET runtime"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.1.1",
 CellID->23829],

Cell["Launching the .NET runtime.", "Caption",
 CellTags->"nlug:3.1.1",
 CellID->2650]
}, Open  ]],

Cell[CellGroupData[{

Cell["Loading .NET Assemblies and Types", "Section",
 CellTags->{"Loading .NET Assemblies and Types", "nlug:3.1.2"},
 CellID->1113],

Cell[CellGroupData[{

Cell[".NET Assemblies", "Subsection",
 CellTags->{"Loading .NET Assemblies", "nlug:3.1.2"},
 CellID->20646],

Cell[TextData[{
 "Programs and libraries for .NET are packaged into units called ",
 StyleBox["assemblies",
  FontSlant->"Italic"],
 ". An assembly can be defined as a versioned, self-describing binary (DLL or \
EXE) containing a collection of types (classes, interfaces, structs, and so \
on) and optional resources. An assembly can span multiple files (a ",
 StyleBox["multi-file assembly",
  FontSlant->"Italic"],
 "), or a single file can contain more than one assembly, but in the typical \
case an assembly consists of a single DLL or EXE file. Although .NET \
assemblies can have the DLL extension, internally they are quite different \
from old C-style DLLs. Conceptually, though, a .NET DLL is similar to a \
C-style DLL in that they are both libraries of code intended to be loaded and \
called by other programs. An EXE assembly is an executable program that can \
be launched directly, but it also can export types like a DLL for use by \
other programs."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->25443],

Cell[TextData[{
 "Assemblies can be located anywhere on your system. The .NET Framework \
maintains a special location on your system where assemblies can be stored so \
that they can easily be found by all .NET programs on the system. This \
location is called the Global Assembly Cache (GAC), and is found in the ",
 StyleBox["assembly", "MR"],
 " subdirectory of your root Windows directory. The assemblies that are part \
of the .NET Framework itself are located in the GAC, and many .NET programs \
that you install will put assemblies there. There is no requirement that an \
assembly be placed into the GAC, and ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " can use assemblies located anywhere on your system."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->28914],

Cell[TextData[{
 "Because all .NET types are packaged into assemblies, to load a type into ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "you first need to load its assembly. You use the ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 " function to load an assembly into ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ". Assemblies can be loaded by specifying various types of information about \
the assembly, such as a full path to the assembly file, or by a full or \
partial name of the assembly. Assembly names will be discussed in more detail \
later, but for now it suffices to say that assembly names are assigned by \
their creators, and may bear no resemblance to the name of the actual \
assembly file. An example of a simple assembly name is ",
 StyleBox["System.XML", "MR"],
 ", which is the assembly in the .NET Framework that handles XML-related \
functionality. Assemblies are often named after the most important namespace \
they define. The actual file name of the ",
 StyleBox["System.XML", "MR"],
 " assembly is ",
 StyleBox["System.XML.dll", "MR"],
 ", and it is located somewhere nested deep down inside the GAC."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->12515],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " does not need to be explicitly instructed to load all assemblies. It will \
automatically load any of the .NET Framework assemblies, meaning all of the \
assemblies containing types whose names start with ",
 StyleBox["System", "MR"],
 ". (e.g., ",
 StyleBox["System.Windows.Forms.Form", "MR"],
 ", ",
 StyleBox["System.Drawing.Rectangle", "MR"],
 ", ",
 StyleBox["System.Data.DataSet", "MR"],
 ", and so on). Most of the types that you will use in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " programming are found in the system assemblies. You will have to manually \
load other assemblies. The ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 " function, described later in this tutorial, is the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function you use to load assemblies into ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " and prepare them to be used from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->18787]
}, Open  ]],

Cell[CellGroupData[{

Cell[".NET Types", "Subsection",
 CellTags->"nlug:3.1.2",
 CellID->90],

Cell[TextData[{
 "A ",
 StyleBox["type",
  FontSlant->"Italic"],
 " is the fundamental unit of .NET programming. Every type falls into one of \
the following categories: classes, interfaces, structs (\"value types\"), \
enumerations, and delegates. Every object in .NET is an instance of some \
type. Although the set of types is broader than just classes, you might find \
it easier to think of types as being classes."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->32197],

Cell[TextData[{
 "Types are defined in assemblies. To load and use a type in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", you must first load the assembly in which it resides and then load the \
type itself. Often these steps can be combined into a single operation. ",
 Cell[BoxData[
  ButtonBox["LoadNETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFormula"],
 ", described later , is the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function that you use to load types into ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " so they can be used from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->29569]
}, Open  ]],

Cell[CellGroupData[{

Cell["LoadNETAssembly", "Subsection",
 CellTags->"nlug:3.1.2",
 CellID->2433],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 " is the function you use to load assemblies into ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " so that the types they contain can be used from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 " has a number of different argument sequences. Although all these different \
possible arguments might seem confusing, the basic principle is to allow \
virtually any way of specifying enough information about the assembly so that \
",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " can locate it. "
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->24148],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LoadNETAssembly",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/LoadNETAssembly"], "[", 
     StyleBox["assemblyName", "TI"], "]"}], Cell["\<\
load the specified assembly based on its name, such as \"System.Web\"\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["LoadNETAssembly",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/LoadNETAssembly"], "[", 
     StyleBox["path", "TI"], "]"}], Cell[
    "load the assembly based on its full file path", "TableText"]},
   {
    RowBox[{
     ButtonBox["LoadNETAssembly",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/LoadNETAssembly"], "[", 
     StyleBox["url", "TI"], "]"}], Cell[
    "load the assembly pointed to by this URL", "TableText"]},
   {
    RowBox[{
     ButtonBox["LoadNETAssembly",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/LoadNETAssembly"], "[", 
     RowBox[{
      StyleBox["assemblyName", "TI"], ",", 
      StyleBox["dir", "TI"]}], "]"}], Cell["\<\
load the assembly based on its name and the directory in which it resides\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["LoadNETAssembly",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/LoadNETAssembly"], "[", 
     RowBox[{
      StyleBox["assemblyName", "TI"], ",", 
      StyleBox["context`", "TI"]}], "]"}], Cell["\<\
load the assembly based on its name and the application context in which it \
resides
\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["LoadNETAssembly",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/LoadNETAssembly"], "[", 
     StyleBox["dir", "TI"], "]"}], Cell[
    "load all the assemblies in this directory", "TableText"]},
   {
    RowBox[{
     ButtonBox["LoadNETAssembly",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/LoadNETAssembly"], "[", 
     StyleBox["context`", "TI"], "]"}], Cell[
    "load all the assemblies in this application context", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.1.2",
 CellID->26130],

Cell["Loading assemblies.", "Caption",
 CellTags->"nlug:3.1.2",
 CellID->7204],

Cell[TextData[{
 "Here is an example of using ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 " to load an assembly that is part of the .NET Framework."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->12862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadNETAssembly", "[", "\"\<System.Web\>\"", "]"}]], "Input",
 CellTags->"nlug:3.1.2",
 CellLabel->"In[3]:=",
 CellID->9836],

Cell[BoxData[
 RowBox[{"NETAssembly", "[", 
  RowBox[{"\<\"System.Web\"\>", ",", "1"}], "]"}]], "Output",
 CellTags->"nlug:3.1.2",
 CellLabel->"Out[3]=",
 CellID->18460]
}, Open  ]],

Cell[TextData[{
 "The return value of ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["NETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETAssembly"]], "InlineFormula"],
 " expression. This is not a .NET object itself, just a special expression \
that can be used in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " to refer to a loaded assembly in various functions that take an assembly \
specification as an argument."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->17230],

Cell[TextData[{
 "The name used in the previous example is the ",
 StyleBox["simple name",
  FontSlant->"Italic"],
 " of the assembly. The actual ",
 StyleBox["full name",
  FontSlant->"Italic"],
 ", or ",
 StyleBox["display name",
  FontSlant->"Italic"],
 ", of the assembly is longer and contains version information, among other \
things. You can use the full name if you want to force a certain version to \
be loaded (note that if you execute this on your machine, it will fail unless \
you have exactly the same version of the .NET Framework installed)."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->24611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadNETAssembly", "[", 
  "\"\<System.Web, Version=1.0.5000.0, Culture=neutral, \
PublicKeyToken=b03f5f7f11d50a3a\>\"", "]"}]], "Input",
 CellTags->"nlug:3.1.2",
 CellLabel->"In[4]:=",
 CellID->4309],

Cell[BoxData[
 RowBox[{"NETAssembly", "[", 
  RowBox[{"\<\"System.Web\"\>", ",", "1"}], "]"}]], "Output",
 CellTags->"nlug:3.1.2",
 CellLabel->"Out[4]=",
 CellID->4568]
}, Open  ]],

Cell["\<\
We were able to load this assembly based on only its name, without any \
location information, because it is located in the GAC.\
\>", "Text",
 CellTags->"nlug:3.1.2",
 CellID->7030],

Cell[TextData[{
 "As another example of ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 ", say you have obtained an assembly or created one of your own in some .NET \
language and want to load it into ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " to use from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The assembly is in the file ",
 StyleBox["c:\\MyProgram\\Bin\\Debug\\MyAssembly.dll", "MR"],
 ". Here is how you would load it."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->18138],

Cell[BoxData[
 RowBox[{"LoadNETAssembly", "[", 
  "\"\<c:\\\\MyProgram\\\\Bin\\\\Debug\\\\MyAssembly.dll\>\"", "]"}]], "Input",\

 CellTags->"nlug:3.1.2",
 CellID->24932],

Cell["\<\
Loading an assembly by specifying its path is useful for assemblies that you \
have created yourself.\
\>", "Text",
 CellTags->"nlug:3.1.2",
 CellID->7001],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 " can also load assemblies from an ",
 StyleBox["assembly", "MR"],
 " subdirectory in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " application directory. This is intended for developers who are creating \
applications that use ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ". If you have a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " application directory called ",
 StyleBox["MyApp", "MR"],
 ", and it is installed into one of the standard locations for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applications (e.g., ",
 StyleBox["<", "MR"],
 StyleBox["Mathematica", "MR",
  FontSlant->"Italic"],
 StyleBox[" dir>\\AddOns\\Applications", "MR"],
 "), you can give the ",
 StyleBox["MyApp", "MR"],
 " directory a subdirectory named ",
 StyleBox["assembly", "MR"],
 " and place all the extra assemblies that your application needs into the ",
 StyleBox["assembly", "MR"],
 " directory. Your application\[CloseCurlyQuote]s ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code can then load one of these application assemblies by supplying the \
assembly name and the context that corresponds to your application."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->29102],

Cell[BoxData[
 RowBox[{"LoadNETAssembly", "[", 
  RowBox[{"\"\<My.Special.Assembly\>\"", ",", "\"\<MyApp`\>\""}], 
  "]"}]], "Input",
 CellTags->"nlug:3.1.2",
 CellID->16191],

Cell["\<\
In this way, application developers can bundle private assemblies in their \
application layout and not require that their users perform any special \
installation steps such as copying assemblies into the GAC.\
\>", "Text",
 CellTags->"nlug:3.1.2",
 CellID->3406]
}, Open  ]],

Cell[CellGroupData[{

Cell["LoadNETType", "Subsection",
 CellTags->"nlug:3.1.2",
 CellID->17804],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LoadNETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFormula"],
 " is the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function that loads .NET types so that they can be used from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It is often not necessary to explicitly call ",
 Cell[BoxData[
  ButtonBox["LoadNETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFormula"],
 ". Whenever a .NET object is returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", its type is loaded. This means that if you want to create a new object of \
a certain type, you can just call ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 " and the type will be loaded when the object is returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The most common reason for calling ",
 Cell[BoxData[
  ButtonBox["LoadNETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFormula"],
 " directly is if you want to use a static method or property from a type. In \
that case, you are not creating an object with ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 ", so you must manually load the type."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->8579],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LoadNETType",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/LoadNETType"], "[", 
     StyleBox["typeName", "TI"], "]"}], Cell[
    "load the specified type", "TableText"]},
   {
    RowBox[{
     ButtonBox["LoadNETType",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/LoadNETType"], "[", 
     RowBox[{
      StyleBox["typeName", "TI"], ",", 
      StyleBox["assemblyName", "TI"]}], "]"}], Cell[
    "load the type from the specified assembly", "TableText"]},
   {
    RowBox[{
     ButtonBox["LoadNETType",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/LoadNETType"], "[", 
     RowBox[{
      StyleBox["typeName", "TI"], ",", 
      StyleBox["NETAssembly", "TI"]}], "]"}], Cell[TextData[{
     "load the type from the assembly identified by a ",
     ButtonBox["NETAssembly",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETAssembly"],
     " expression"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LoadNETType",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/LoadNETType"], "[", 
     RowBox[{
      StyleBox["typeName", "TI"], ",", 
      StyleBox["assemblyName", "TI"], ",", 
      StyleBox["context`", "TI"]}], "]"}], Cell["\<\
load the type from the specified assembly residing in the specified \
application context\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {{
      Scaled[0.5]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellTags->"nlug:3.1.2",
 CellID->31673],

Cell["Loading types.", "Caption",
 CellTags->"nlug:3.1.2",
 CellID->28210],

Cell[TextData[{
 "Here is a simple example of ",
 Cell[BoxData[
  ButtonBox["LoadNETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->28965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadNETType", "[", "\"\<System.Windows.Forms.Form\>\"", 
  "]"}]], "Input",
 CellTags->"nlug:3.1.2",
 CellLabel->"In[5]:=",
 CellID->37],

Cell[BoxData[
 RowBox[{"NETType", "[", 
  RowBox[{"\<\"System.Windows.Forms.Form\"\>", ",", "1"}], "]"}]], "Output",
 CellTags->"nlug:3.1.2",
 CellLabel->"Out[5]=",
 CellID->22219]
}, Open  ]],

Cell[TextData[{
 "The return value of ",
 Cell[BoxData[
  ButtonBox["LoadNETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["NETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETType"]], "InlineFormula"],
 " expression. This is not a .NET object itself, just a special expression \
that can be used in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " to refer to a .NET type in various functions that take a type \
specification as an argument."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->9818],

Cell[TextData[{
 "Note that you must supply the full type name, including the namespace \
prefix (",
 StyleBox["System.Windows.Forms", "MR"],
 " in this example). For the load to succeed, the assembly in which the type \
resides must be already loaded using ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 ". As mentioned earlier, assemblies for all System types are automatically \
loaded as needed by ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", so there was no need to load the ",
 StyleBox["System.Windows.Forms", "MR"],
 " assembly manually in the previous example."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->25049]
}, Open  ]],

Cell[CellGroupData[{

Cell["Viewing Loaded Assemblies and Types", "Subsection",
 CellTags->"nlug:3.1.2",
 CellID->712],

Cell[TextData[{
 "You can use the utility functions ",
 Cell[BoxData[
  ButtonBox["LoadedNETAssemblies",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadedNETAssemblies"]], "InlineFormula"],
 ". and ",
 Cell[BoxData[
  ButtonBox["LoadedNETTypes",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadedNETTypes"]], "InlineFormula"],
 " to see what assemblies and types have been loaded into the current ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. These are intended mainly for debugging purposes."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->28646],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LoadedNETAssemblies",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/LoadedNETAssemblies"], "[", "]"}], Cell[
    TextData[{
     "return a list of all assemblies loaded into ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LoadedNETTypes",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/LoadedNETTypes"], "[", "]"}], Cell[
    TextData[{
     "return a list of all types loaded into ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {{
      Scaled[0.5]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellTags->"nlug:3.1.2",
 CellID->6718],

Cell["Viewing loaded assemblies and types.", "Caption",
 CellTags->"nlug:3.1.2",
 CellID->25038]
}, Open  ]],

Cell[CellGroupData[{

Cell["Contexts and Visibility of Static Type Members", "Subsection",
 CellTags->"nlug:3.1.2",
 CellID->9289],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LoadNETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFormula"],
 " has two options that let you control the naming and visibility of static \
methods and fields. To understand these options, you need to understand the \
problems they help to solve. We have to get a bit ahead of ourselves to \
explain the issues, since we have not yet discussed how to call .NET methods. \
When a type is loaded, definitions are created in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that allow you to call methods, properties, and fields of objects of that \
class. Static members are treated quite differently from nonstatic ones. Say \
you have a class named ",
 StyleBox["MyClass", "MR"],
 " in the namespace ",
 StyleBox["MyCompany.Utilities", "MR"],
 ", and this class contains a static method named ",
 StyleBox["Foo", "MR"],
 ". When you load this class, a definition must be set up for ",
 StyleBox["Foo", "MR"],
 " so that it can be called by name, something like ",
 StyleBox["Foo[args]", "MR"],
 ". The question becomes: In what context do you want the symbol ",
 StyleBox["Foo", "MR"],
 " defined, and do you want this context to be visible (i.e., on ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ")?"
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->2690],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " always creates a definition for ",
 StyleBox["Foo", "MR"],
 " in a context that mirrors its fully qualified classname: ",
 StyleBox["MyCompany`Utilities`MyClass`Foo", "MR"],
 ". This is done to avoid conflicting with symbols named ",
 StyleBox["Foo", "MR"],
 " that might be present in other contexts. However, you might find it clumsy \
to have to call ",
 StyleBox["Foo", "MR"],
 " by typing the full context name every time, as in ",
 StyleBox["MyCompany`Utilities`MyClass`Foo[args]", "MR"],
 ". The option ",
 StyleBox["AllowShortContext->", "MR"],
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " (this is the default setting) causes ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " to also make definitions for ",
 StyleBox["Foo", "MR"],
 " accessible in a shortened context, one that consists of just the class \
name without the hierarchical namespace prefix. In our example, this means \
that you could call ",
 StyleBox["Foo", "MR"],
 " as simply ",
 StyleBox["MyClass`Foo[args]", "MR"],
 ". If you need to avoid use of the short context because there is already a \
context of the same name in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, you can use ",
 StyleBox["AllowShortContext->", "MR"],
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". This forces all names to be put only in the \[OpenCurlyDoubleQuote]deep\
\[CloseCurlyDoubleQuote] context. Note that even with ",
 StyleBox["AllowShortContext->", "MR"],
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", names for statics are also put into the deep context, so you can always \
use the deep context to refer to a symbol if you desire."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->9033],

Cell[TextData[{
 StyleBox["AllowShortContext", "MR"],
 ", then, lets you control the context where the symbol names are defined. \
The other option, ",
 StyleBox["StaticsVisible", "MR"],
 ", controls whether this context is made visible (put on ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ") or not. The default is ",
 StyleBox["StaticsVisible->", "MR"],
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", so you have to use a context name when referring to a symbol, as in ",
 StyleBox["MyClass`Foo[args]", "MR"],
 ". With ",
 StyleBox["StaticsVisible->", "MR"],
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 StyleBox[", MyClass`", "MR"],
 " will be put on ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ", so you could just write ",
 StyleBox["Foo[args]", "MR"],
 ". Having the default be ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " would be a bit dangerous\[LongDash]every time you load a class a \
potentially large number of names would suddenly be created and made visible \
in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, opening up the possibility for all sorts of \
\[OpenCurlyDoubleQuote]shadowing\[CloseCurlyDoubleQuote] problems if symbols \
of the same names were already present (see ",
 ButtonBox["Contexts",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Contexts"],
 " for a discussion of contexts and shadowing problems)."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->14672],

Cell[TextData[{
 "For these reasons ",
 StyleBox["StaticsVisible->", "MR"],
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " is recommended only for classes that you have written, or ones whose \
contents you are familiar with. In such cases, it can save you some typing, \
make your code more readable, and prevent the all-too-easy bug of forgetting \
to type the classname prefix. A classic example would be implementing the \
venerable \[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " example program. In C#, it might look like this."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->19989],

Cell["\<\
public class AddTwo {
\tpublic static int AddTwo(int i, int j) {return i + j;}
}\
\>", "Program",
 CellTags->"nlug:3.1.2",
 CellID->25453],

Cell[TextData[{
 "With the default ",
 StyleBox["StaticsVisible->", "MR"],
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", you would have to call addtwo as ",
 StyleBox["AddTwo`AddTwo[3, 4]", "MR"],
 ". Setting",
 StyleBox[" StaticsVisible->", "MR"],
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " lets you write the more obvious ",
 StyleBox["AddTwo[3, 4]", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->24544],

Cell[TextData[{
 "Be reminded that these options are only for ",
 StyleBox["static",
  FontSlant->"Italic"],
 " methods and fields. As discussed later, ",
 "nonstatic",
 "s are handled in a way that makes context and visibility issues go away \
completely."
}], "Text",
 CellTags->"nlug:3.1.2",
 CellID->20165],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StaticsVisible",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/StaticsVisible"], "\[Rule]", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell["\<\
make static methods and fields accessible by just their names, not in a \
special context\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["AllowShortContext",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/AllowShortContext"], "\[Rule]", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}], Cell["\<\
make static methods and fields accessible only in the context that mirrors \
the full hierarchical namespace name\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.1.2",
 CellID->18503],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["LoadNETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"nlug:3.1.2",
 CellID->28770]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Conversion of Types Between .NET and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "Section",
 CellTags->{"Conversion of Types Between .NET and Mathematica", "nlug:3.1.3"},
 
 CellID->31571],

Cell[TextData[{
 "Before we encounter the operations of creating .NET objects and calling \
methods, we should examine the mapping of types between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and .NET. When a .NET method returns a result to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the result is automatically converted into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. For example, .NET integer types (e.g., ",
 StyleBox["Int32", "MR"],
 ", ",
 StyleBox["Byte", "MR"],
 ", and so on), are converted into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " integers, and .NET real number types (",
 StyleBox["Single", "MR"],
 ", ",
 StyleBox["Double", "MR"],
 ") are converted into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " reals. The table below shows the complete set of conversions. These \
conversions work both ways\[LongDash]for example, when a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " integer is sent to a .NET method that requires a ",
 StyleBox["Byte", "MR"],
 " value, the integer is automatically converted to a .NET ",
 StyleBox["Byte", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.1.3",
 CellID->15060],

Cell[TextData[{
 "Note that this table gives type names as they are used in the .NET \
Framework. Different languages often have their own keywords that map to \
these underlying types. In C#, for example, the keyword ",
 StyleBox["int", "MR"],
 " is an alias to the ",
 StyleBox["Int32", "MR"],
 " type, and in Visual Basic .NET the ",
 StyleBox["Int32", "MR"],
 " type is called ",
 StyleBox["Integer", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.1.3",
 CellID->12104],

Cell[BoxData[GridBox[{
   {Cell[".NET type", "TableHeader"], Cell[
    "Mathematica type", "TableHeader"]},
   {
    RowBox[{
    "Byte", ",", " ", "SByte", ",", " ", "Char", ",", " ", "Int16", ",", " ", 
     "UInt16", ",", " ", "Int32", ",", " ", "UInt32", ",", " ", "Int64", ",", 
     " ", "UInt64"}], 
    ButtonBox["Integer",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integer"]},
   {"Decimal", 
    RowBox[{
     ButtonBox["Integer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integer"], "or", " ", 
     ButtonBox["Real",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Real"]}]},
   {
    RowBox[{"Single", ",", " ", "Double"}], 
    ButtonBox["Real",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Real"]},
   {"Boolean", 
    RowBox[{
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], " ", "or", " ", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}]},
   {"String", 
    ButtonBox["String",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/String"]},
   {"Array", 
    ButtonBox["List",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/List"]},
   {
    RowBox[{"controlled", " ", "by", " ", "user"}], 
    ButtonBox["Complex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Complex"]},
   {"Object", Cell["NETObject"]},
   {"Expr", Cell["any expression"]},
   {"null", 
    ButtonBox["Null",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Null"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"nlug:3.1.3",
 CellID->1716],

Cell[TextData[{
 "Corresponding types in .NET and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Caption",
 CellTags->"nlug:3.1.3",
 CellID->14597],

Cell[TextData[{
 ".NET arrays are mapped to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " lists of the appropriate depth. Thus, when you call a method that takes a \
",
 StyleBox["double[]", "MR"],
 " (in C# notation), you might pass it ",
 StyleBox["{1.0, 2.0, N[Pi], 1.23}", "MR"],
 ". Similarly, a method that returns a two-deep array of integers (",
 StyleBox["int[,]", "MR"],
 " in C# notation) might return to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " the expression ",
 StyleBox["{{1, 2, 3}, {5, 3, 1}}", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.1.3",
 CellID->13188]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating Objects", "Section",
 CellTags->"nlug:3.1.4",
 CellID->7716],

Cell[TextData[{
 "To construct .NET objects, use the ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 " function. The first argument to ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 " is the object\[CloseCurlyQuote]s type, specified either as a ",
 Cell[BoxData[
  ButtonBox["NETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETType"]], "InlineFormula"],
 " expression returned from ",
 Cell[BoxData[
  ButtonBox["LoadNETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFormula"],
 " or as a string giving the fully qualified type name (i.e., including the \
namespace prefix). If you wish to supply any arguments to the object\
\[CloseCurlyQuote]s constructor, they follow as a sequence after the type."
}], "Text",
 CellTags->"nlug:3.1.4",
 CellID->25756],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NETNew",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETNew"], "[", 
     StyleBox["typeName", "TI"], ",", 
     StyleBox["arg1", "TI"], ",", 
     StyleBox["...", "TI"], "]"}], Cell[TextData[{
     "construct a new object of the specified class and return it to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NETNew",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETNew"], "[", 
     StyleBox["NETType", "TI"], ",", 
     StyleBox["arg1", "TI"], ",", 
     StyleBox["...", "TI"], "]"}], Cell[TextData[{
     "construct a new object of the specified class and return it to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.1.4",
 CellID->28],

Cell["Constructing .NET objects.", "Caption",
 CellTags->"nlug:3.1.4",
 CellID->6929],

Cell[TextData[{
 "For example, this will create a new ",
 StyleBox["Form", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.1.4",
 CellID->4930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"form", "=", 
  RowBox[{
  "NETNew", "[", "\"\<System.Windows.Forms.Form\>\"", "]"}]}]], "Input",
 CellTags->"nlug:3.1.4",
 CellLabel->"In[6]:=",
 CellID->23346],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", "[", "\<\"System.Windows.Forms.Form\"\>", 
    "]"}], "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$100663297]], "Output",
 CellTags->"nlug:3.1.4",
 CellLabel->"Out[6]=",
 CellID->3787]
}, Open  ]],

Cell[TextData[{
 "The return value from ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 " is a strange expression that looks like it has the head ",
 StyleBox["NETObject", "MR"],
 ", except that it is enclosed in angle brackets. The angle brackets are used \
to indicate that the form in which the expression is displayed is quite \
different from its internal representation. These expressions will be \
referred to as ",
 StyleBox["NETObject", "MR"],
 " expressions. ",
 StyleBox["NETObject", "MR"],
 " expressions are displayed in a way that shows their type name, but you \
should consider them opaque, meaning that you cannot pick them apart or peer \
into their insides. You can only use them in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " functions that take ",
 StyleBox["NETObject", "MR"],
 " expressions."
}], "Text",
 CellTags->"nlug:3.1.4",
 CellID->15094],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 " invokes a .NET constructor appropriate for the types of the arguments \
being passed in, and then returns to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " what is, in effect, a reference to the object. That is how you should \
think of ",
 StyleBox["NETObject", "MR"],
 " expressions\[LongDash]as references to .NET objects very much like object \
references in a .NET language like C# or Visual Basic .NET. What is returned \
to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is not large no matter what type of object you are constructing. In \
particular, the object\[CloseCurlyQuote]s data (that is, its fields) are not \
sent back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The actual object remains on the .NET side, and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gets a reference to it."
}], "Text",
 CellTags->"nlug:3.1.4",
 CellID->26114],

Cell[TextData[{
 "The previous examples specified the class by giving its name as a string. \
You can also use a ",
 Cell[BoxData[
  ButtonBox["NETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETType"]], "InlineFormula"],
 " expression, which is a special expression returned by ",
 Cell[BoxData[
  ButtonBox["LoadNETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFormula"],
 " that identifies a class. When you specify the class name as a string, the \
class is loaded if it has not already been."
}], "Text",
 CellTags->"nlug:3.1.4",
 CellID->2278],

Cell[BoxData[{
 RowBox[{
  RowBox[{"formType", "=", 
   RowBox[{"LoadNETType", "[", "\"\<System.Windows.Forms.Form\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"form", "=", 
   RowBox[{"NETNew", "[", "formType", "]"}]}], ";"}]}], "Input",
 CellTags->"nlug:3.1.4",
 CellLabel->"In[7]:=",
 CellID->23568],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 " is not the only way to get a reference to a .NET object in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Many methods and properties return objects, and when you call such a \
method or property, a ",
 StyleBox["NETObject", "MR"],
 " expression is created. Such objects can be used in the same way as ones \
you explicitly construct with ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.1.4",
 CellID->30533]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calling Methods, Properties, and Fields", "Section",
 CellTags->"nlug:3.1.5",
 CellID->9847],

Cell[CellGroupData[{

Cell["Syntax", "Subsection",
 CellTags->"nlug:3.1.5",
 CellID->31622],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " syntax for calling .NET methods and accessing fields is very similar to \
the syntax used in C# and Visual Basic .NET. The box below compares the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and C# ways of calling constructors, methods, properties, fields, static \
methods, static properties, and static fields. You can see that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs that use .NET are written in almost exactly the same way as C# \
(or VB .NET) programs, except ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses [] instead of () for arguments and @ instead of the . (dot) as the \
\[OpenCurlyDoubleQuote]member access\[CloseCurlyDoubleQuote] operator."
}], "Text",
 CellTags->"nlug:3.1.5",
 CellID->13925],

Cell[TextData[{
 "An exception is that for static methods, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the context mark ` in place of the dot used by C# and VB. This \
parallels the usage in those languages also, as their use of the dot in this \
circumstance is really as a scope resolution operator (like :: in C++). \
Although ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not use this terminology, its scope resolution operator is the \
context mark. .NET namespace names map directly to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s hierarchical contexts."
}], "Text",
 CellTags->"nlug:3.1.5",
 CellID->10002],

Cell[BoxData[GridBox[{
   {" ", Cell["Constructors", "TableHeader"]},
   {
    StyleBox[
     RowBox[{
      RowBox[{"C", "#"}], ":"}], "TR"], Cell[
    "MyClass obj = new MyClass(args);", "TableText"]},
   {
    StyleBox[
     RowBox[{"Mathematica", ":"}], "TR"], Cell[
    "obj = NETNew[\"MyClass\", args];", "TableText"]},
   {" ", 
    StyleBox["Methods", "TableHeader"]},
   {
    StyleBox[
     RowBox[{
      RowBox[{"C", "#"}], ":"}], "TR"], Cell[
    "obj.MethodName(args);", "TableText"]},
   {
    StyleBox[
     RowBox[{"Mathematica", ":"}], "TR"], Cell[
    "obj@MethodName[args]", "TableText"]},
   {" ", 
    StyleBox[
     RowBox[{"Properties", " ", "and", " ", "fields"}], "TableHeader"]},
   {
    StyleBox[
     RowBox[{
      RowBox[{"C", "#"}], ":"}], "TR"], Cell["\<\
obj.PropertyOrFieldName = 1;
value = obj.PropertyOrFieldName;\
\>", "TableText"]},
   {
    StyleBox[
     RowBox[{"Mathematica", ":"}], "TR"], Cell["\<\
obj@PropertyOrFieldName = 1;
value = obj@PropertyOrFieldName;\
\>", "TableText"]},
   {" ", 
    StyleBox[
     RowBox[{"Static", " ", "methods"}], "TableHeader"]},
   {
    StyleBox[
     RowBox[{
      RowBox[{"C", "#"}], ":"}], "TR"], Cell[
    "MyClass.StaticMethod(args);", "TableText"]},
   {
    StyleBox[
     RowBox[{"Mathematica", ":"}], "TR"], Cell[
    "MyClass`StaticMethod[args];", "TableText"]},
   {" ", 
    StyleBox[
     RowBox[{"Static", " ", "properties", " ", "and", " ", "fields"}], 
     "TableHeader"]},
   {
    StyleBox[
     RowBox[{
      RowBox[{"C", "#"}], ":"}], "TR"], Cell["\<\
MyClass.StaticPropertyOrField = 1;
value = MyClass.StaticPropertyOrField;\
\>", "TableText"]},
   {
    StyleBox[
     RowBox[{"Mathematica", ":"}], "TR"], Cell["\<\
MyClass`StaticPropertyOrField = 1;
value = MyClass`StaticPropertyOrField;\
\>", "TableText"]}
  },
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {
     False, False, False, True, False, False, True, False, False, True, False,
       False, True, {False}, False}, "RowsIndexed" -> {}}]], "DefinitionBox",
 CellTags->"nlug:3.1.5",
 CellID->17120],

Cell[TextData[{
 "C# and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " syntax comparison."
}], "Caption",
 CellTags->"nlug:3.1.5",
 CellID->28899],

Cell[TextData[{
 "You may already be familiar with ",
 StyleBox["@", "MR"],
 " as a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " operator for applying a function to an argument: ",
 StyleBox["f @ x ", "MR"],
 "is equivalent to the more commonly used ",
 StyleBox["f[x]", "MR"],
 ". ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " does not usurp ",
 StyleBox["@", "MR"],
 " for some special operation\[LongDash]it is really just normal function \
application slightly disguised. This means that you do not have to use @ at \
all. The following are equivalent ways of invoking a method."
}], "Text",
 CellTags->"nlug:3.1.5",
 CellID->16834],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"These", " ", "are", " ", "equivalent"}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"obj", "@", 
     RowBox[{"Method", "[", "args", "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"obj", "[", 
     RowBox[{"Method", "[", "args", "]"}], "]"}], ";"}]}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.1.5",
 CellID->24804],

Cell[TextData[{
 "The first form preserves the natural mapping of the syntax of most .NET \
languages into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and will be used exclusively in this manual."
}], "Text",
 CellTags->"nlug:3.1.5",
 CellID->9969],

Cell[TextData[{
 "When you call methods, properties, or fields and get results back, .",
 StyleBox["NET",
  FontSlant->"Italic"],
 StyleBox["/Link",
  FontSlant->"Italic"],
 " automatically converts arguments and results to and from their ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " representations according to the table presented earlier."
}], "Text",
 CellTags->"nlug:3.1.5",
 CellID->8283],

Cell[TextData[{
 "In object-oriented languages, method and field names are scoped by the \
object on which they are called. In other words, when you write ",
 StyleBox["obj.Meth()", "MR"],
 ", .NET languages know that you are calling the method named ",
 StyleBox["Meth", "MR"],
 " that resides in ",
 StyleBox["obj", "MR"],
 "\[CloseCurlyQuote]s class, even though there may be other methods named ",
 StyleBox["Meth", "MR"],
 " in other classes. ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " preserves this scoping for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbols so that there is never a conflict with existing symbols of the \
same name. When you write ",
 StyleBox["obj@Meth[]", "MR"],
 ", there is no conflict with any other symbols named ",
 StyleBox["Meth", "MR"],
 " in the system\[LongDash]the symbol ",
 StyleBox["Meth", "MR"],
 " used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in the evaluation of this call is the one set up by ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " for this class. Here is an example using a field. First, we create a ",
 StyleBox["Point", "MR"],
 " object."
}], "Text",
 CellTags->"nlug:3.1.5",
 CellID->28568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pt", "=", 
  RowBox[{"NETNew", "[", "\"\<System.Drawing.Point\>\"", "]"}]}]], "Input",
 CellTags->"nlug:3.1.5",
 CellLabel->"In[9]:=",
 CellID->13538],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", "[", "\<\"System.Drawing.Point\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$1]], "Output",
 CellTags->"nlug:3.1.5",
 CellLabel->"Out[9]=",
 CellID->23474]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Point", "MR"],
 " class has fields named ",
 StyleBox["X", "MR"],
 " and ",
 StyleBox["Y", "MR"],
 ", which hold its coordinates. A user\[CloseCurlyQuote]s session might also \
have symbols named ",
 StyleBox["X", "MR"],
 " or ",
 StyleBox["Y", "MR"],
 " in it, however. Let us set up a definition for ",
 StyleBox["X", "MR"],
 " that will tell us when it is evaluated."
}], "Text",
 CellTags->"nlug:3.1.5",
 CellID->5156],

Cell[BoxData[
 RowBox[{"X", ":=", 
  RowBox[{"Print", "[", "\"\<gotcha\>\"", "]"}]}]], "Input",
 CellTags->"nlug:3.1.5",
 CellLabel->"In[10]:=",
 CellID->29017],

Cell[TextData[{
 "Now set a value for the field named ",
 StyleBox["X", "MR"],
 " (this would be written as ",
 StyleBox["pt.X = 42", "MR"],
 " in C# or VB)."
}], "Text",
 CellTags->"nlug:3.1.5",
 CellID->24200],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{"pt", "@", "X"}], "=", "42"}], ";"}], "MB"]], "Input",
 CellTags->"nlug:3.1.5",
 CellLabel->"In[11]:=",
 CellID->32579],

Cell[TextData[{
 "You will notice that \[OpenCurlyDoubleQuote]gotcha\[CloseCurlyDoubleQuote] \
was not printed. There is no conflict between the symbol ",
 StyleBox["X", "MR"],
 " in the ",
 StyleBox["Global`", "MR"],
 " context that has the ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " definition and the symbol ",
 StyleBox["X", "MR"],
 " that is used during the evaluation of this line of code. ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " protects the names of members on the right-hand side of ",
 StyleBox["@", "MR"],
 " so that they do not conflict with, or rely on, any definitions that might \
exist for these symbols in visible contexts. "
}], "Text",
 CellTags->"nlug:3.1.5",
 CellID->16432],

Cell[TextData[{
 "In summary, for nonstatic methods, properties, and fields, you never have \
to worry about name conflicts and shadowing, no matter what context you are \
in or what the ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " is at the moment. This is not true for static members, however. Static \
methods and fields are called by their full name, without an object \
reference, so there is no object out front to scope the name. Here is a \
simple example of a static method call that invokes the .NET garbage \
collector. We need to call ",
 Cell[BoxData[
  ButtonBox["LoadNETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFormula"],
 " before we call a static method to make sure the class has been loaded."
}], "Text",
 CellTags->"nlug:3.1.5",
 CellID->16448],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadNETType", "[", "\"\<System.GC\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"GC`Collect", "[", "]"}], ";"}]}], "Input",
 CellTags->"nlug:3.1.5",
 CellLabel->"In[12]:=",
 CellID->13047],

Cell[TextData[{
 "The name scoping issue is not usually a problem with static members because \
they are defined in their own contexts (",
 StyleBox["GC`", "MR"],
 " in this example). These contexts are usually not on ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ", so you do not have to worry that there is a symbol of the same name in \
the ",
 StyleBox["Global`", "MR"],
 " context or in a package that has been read. If there is already a context \
named ",
 StyleBox["GC`", "MR"],
 " in your session, and it has its own function ",
 StyleBox["Collect", "MR"],
 ", you can always avoid a conflict by using the fully-hierarchical context \
name that corresponds to the full type name for a static member."
}], "Text",
 CellTags->"nlug:3.1.5",
 CellID->4044],

Cell[BoxData[
 RowBox[{
  RowBox[{"System`GC`Collect", "[", "]"}], ";"}]], "Input",
 CellTags->"nlug:3.1.5",
 CellLabel->"In[14]:=",
 CellID->29009]
}, Open  ]],

Cell[CellGroupData[{

Cell["Underscores in .NET Names", "Subsection",
 CellTags->"nlug:3.1.5",
 CellID->24546],

Cell[TextData[{
 ".NET names can have characters in them that are not legal in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbols. The only common one is the underscore. ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " maps underscores in type, method, property, and field names to \
\[OpenCurlyQuote]U\[CloseCurlyQuote]. Note that this mapping is only used \
where it is necessary\[LongDash]when names are used in symbolic form, not as \
strings. For example, assume you have a class named ",
 StyleBox["My_Class", "MR"],
 ". When you refer to this class name as a string, you use the underscore:"
}], "Text",
 CellTags->"nlug:3.1.5",
 CellID->10556],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadNETType", "[", "\"\<My_Class\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"NETNew", "[", "\"\<My_Class\>\"", "]"}], ";"}]}], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.1.5",
 CellID->25270],

Cell["\<\
But when you call a static method in such a class, the hierarchical context \
name is symbolic, so you must convert the underscore to U.\
\>", "Text",
 CellTags->"nlug:3.1.5",
 CellID->14241],

Cell[BoxData[
 RowBox[{
  RowBox[{"MyUClass`StaticMethod", "[", "]"}], ";"}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.1.5",
 CellID->12039],

Cell[TextData[{
 "The same rule applies to method and field names. To refer to such names in \
code, use the U. Here is how to call a property named ",
 StyleBox["Some_Property", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.1.5",
 CellID->14293],

Cell[BoxData[
 RowBox[{"obj", "@", "SomeUProperty"}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.1.5",
 CellLabel->"In[1]:=",
 CellID->7196]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Getting Information About Types and Objects", "Section",
 CellTags->"nlug:3.1.6",
 CellID->25375],

Cell[CellGroupData[{

Cell["NETTypeInfo", "Subsection",
 CellTags->"nlug:3.1.6",
 CellID->667],

Cell[TextData[{
 "It is often convenient to be able to quickly display information about the \
methods, properties, fields, and so on that exist in a given .NET type. ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " provides the ",
 Cell[BoxData[
  ButtonBox["NETTypeInfo",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETTypeInfo"]], "InlineFormula"],
 " function to obtain this information."
}], "Text",
 CellTags->"nlug:3.1.6",
 CellID->25392],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NETTypeInfo",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETTypeInfo"], "[", 
     StyleBox["typeName", "TI"], "]"}], Cell[
    "print information about all the members in the given type", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["NETTypeInfo",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETTypeInfo"], "[", 
     RowBox[{
      StyleBox["typeName", "TI"], ",", 
      StyleBox["members", "TI"]}], "]"}], Cell["\<\
print information about just the desired types of members in the given type\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["NETTypeInfo",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETTypeInfo"], "[", 
     RowBox[{
      StyleBox["typeName", "TI"], ",", 
      StyleBox["members", "TI"], ",", 
      StyleBox["\"\<pat\>\"", "TI"]}], "]"}], Cell["\<\
print information about the desired types of members whose names match a \
string pattern\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["NETTypeInfo",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETTypeInfo"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell["\<\
print information about all the members in the object's type
\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["NETTypeInfo",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETTypeInfo"], "[", 
     StyleBox["NETAssembly", "TI"], "]"}], Cell[
    "print information about all the types in the given assembly", 
     "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.1.6",
 CellID->12032],

Cell["Getting information about types and objects.", "Caption",
 CellTags->"nlug:3.1.6",
 CellID->17108],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NETTypeInfo",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETTypeInfo"]], "InlineFormula"],
 " will load the type if it has not already been loaded."
}], "Text",
 CellTags->"nlug:3.1.6",
 CellID->8641],

Cell[TextData[{
 "This will display a lot of information about the ",
 StyleBox["Process", "MR"],
 " class."
}], "Text",
 CellTags->"nlug:3.1.6",
 CellID->29998],

Cell[BoxData[
 RowBox[{"NETTypeInfo", "[", "\"\<System.Diagnostics.Process\>\"", 
  "]"}]], "Input",
 CellTags->"nlug:3.1.6",
 CellID->11258],

Cell[TextData[{
 "The second argument to ",
 Cell[BoxData[
  ButtonBox["NETTypeInfo",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETTypeInfo"]], "InlineFormula"],
 " is an optional list of the members you want to see displayed. The possible \
values are ",
 StyleBox["\"Type\"", "MR"],
 " (gives general info about the type itself), ",
 StyleBox["\"Constructors\"", "MR"],
 ", ",
 StyleBox["\"Methods\"", "MR"],
 ", ",
 StyleBox["\"Properties\"", "MR"],
 ", ",
 StyleBox["\"Fields\"", "MR"],
 ", and ",
 StyleBox["\"Events\"", "MR"],
 ". This will show just the properties and methods."
}], "Text",
 CellTags->"nlug:3.1.6",
 CellID->12113],

Cell[BoxData[
 RowBox[{"NETTypeInfo", "[", 
  RowBox[{"\"\<System.Diagnostics.Process\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Methods\>\"", ",", "\"\<Properties\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"nlug:3.1.6",
 CellID->15693],

Cell["\<\
This will show just properties with names that begin with \"Peak\".\
\>", "Text",
 CellTags->"nlug:3.1.6",
 CellID->24001],

Cell[BoxData[
 RowBox[{"NETTypeInfo", "[", 
  RowBox[{
  "\"\<System.Diagnostics.Process\>\"", ",", "\"\<Properties\>\"", ",", 
   "\"\<Peak*\>\""}], "]"}]], "Input",
 CellTags->"nlug:3.1.6",
 CellID->9687],

Cell[TextData[{
 "The default behavior is to display the members in C# syntax. If you want to \
see them in Visual Basic .NET syntax, use the ",
 StyleBox["LanguageSyntax", "MR"],
 " option."
}], "Text",
 CellTags->"nlug:3.1.6",
 CellID->30516],

Cell[BoxData[
 RowBox[{"NETTypeInfo", "[", 
  RowBox[{"\"\<System.Diagnostics.Process\>\"", ",", 
   RowBox[{"LanguageSyntax", "\[Rule]", "\"\<VisualBasic\>\""}]}], 
  "]"}]], "Input",
 CellTags->"nlug:3.1.6",
 CellID->21618],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    StyleBox["LanguageSyntax", "MR"], 
    StyleBox["\"\<CSharp\>\"", "MR"], Cell["\<\
the language syntax in which output should be formatted must be \"CSharp\" or \
\"VisualBasic\"\
\>", "TableText"]},
   {
    StyleBox["Inherited", "MR"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to include inherited members", "TableText"]},
   {
    ButtonBox["IgnoreCase",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/IgnoreCase"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to ignore case in matching names to a string pattern", 
     "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"nlug:3.1.6",
 CellID->7718],

Cell[TextData[{
 "Options to ",
 StyleBox["NETTypeInfo", "MR"],
 ". "
}], "Caption",
 CellTags->"nlug:3.1.6",
 CellID->23668],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NETTypeInfo",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETTypeInfo"]], "InlineFormula"],
 " is also useful for seeing what types are in an assembly. To investigate an \
assembly, pass a ",
 Cell[BoxData[
  ButtonBox["NETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETAssembly"]], "InlineFormula"],
 " expression as the first argument. The easiest way to get a ",
 Cell[BoxData[
  ButtonBox["NETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETAssembly"]], "InlineFormula"],
 " expression is to call ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 " (even if the assembly is already loaded). The following line will show a \
lot of types."
}], "Text",
 CellTags->"nlug:3.1.6",
 CellID->20536],

Cell[BoxData[
 RowBox[{"NETTypeInfo", "[", 
  RowBox[{"LoadNETAssembly", "[", "\"\<System.Data\>\"", "]"}], 
  "]"}]], "Input",
 CellTags->"nlug:3.1.6",
 CellID->9747],

Cell[TextData[{
 "When acting on a ",
 Cell[BoxData[
  ButtonBox["NETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETAssembly"]], "InlineFormula"],
 ", the second argument to ",
 Cell[BoxData[
  ButtonBox["NETTypeInfo",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETTypeInfo"]], "InlineFormula"],
 " is an optional list of the types you want to see displayed. The possible \
values are ",
 StyleBox["\"Classes\"", "MR"],
 ", ",
 StyleBox["\"Interfaces\"", "MR"],
 ", ",
 StyleBox["\"Structures\"", "MR"],
 ", ",
 StyleBox["\"Delegates\"", "MR"],
 ", and ",
 StyleBox["\"Enums\"", "MR"],
 ". This will show just the classes and interfaces with the word \"Data\" in \
their names."
}], "Text",
 CellTags->"nlug:3.1.6",
 CellID->6523],

Cell[BoxData[
 RowBox[{"NETTypeInfo", "[", 
  RowBox[{
   RowBox[{"LoadNETAssembly", "[", "\"\<System.Data\>\"", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Classes\>\"", ",", "\"\<Interfaces\>\""}], "}"}], ",", 
   "\"\<*Data*\>\""}], "]"}]], "Input",
 CellTags->"nlug:3.1.6",
 CellID->1797]
}, Open  ]],

Cell[CellGroupData[{

Cell["Other Useful Functions", "Subsection",
 CellTags->"nlug:3.1.6",
 CellID->13073],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NETObjectQ",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETObjectQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "return ",
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"],
     " if ",
     StyleBox["expr",
      FontSlant->"Italic"],
     " is a valid reference to a .NET object, ",
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"],
     " otherwise"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InstanceOf",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/InstanceOf"], "[", 
     RowBox[{
      StyleBox["obj", "TI"], ",", 
      StyleBox["type", "TI"]}], "]"}], Cell[TextData[{
     "return ",
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"],
     " if this object is an instance of type, ",
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"],
     " otherwise"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GetTypeObject",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/GetTypeObject"], "[", 
     StyleBox["NETType", "TI"], "]"}], Cell[TextData[{
     "return the ",
     StyleBox["Type", "MR"],
     " object corresponding to a ",
     ButtonBox["NETType",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETType"],
     " expression"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GetAssemblyObject",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/GetAssemblyObject"], "[", 
     StyleBox["NETAssembly", "TI"], "]"}], Cell[TextData[{
     "return the ",
     StyleBox["Assembly", "MR"],
     " object corresponding to a ",
     ButtonBox["NETAssembly",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETAssembly"],
     " expression"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.1.6",
 CellID->11552],

Cell["Utility functions for objects and types. ", "Caption",
 CellTags->"nlug:3.1.6",
 CellID->28615],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NETObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETObjectQ"]], "InlineFormula"],
 " is convenient when you need to test whether an expression is a .NET object \
reference. It is often used as a pattern test in function definitions."
}], "Text",
 CellTags->"nlug:3.1.6",
 CellID->21256],

Cell["f[x_?NETObjectQ] := ...", "Input",
 Evaluatable->False,
 CellTags->"nlug:3.1.6",
 CellID->11928],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " uses special expressions with heads ",
 Cell[BoxData[
  ButtonBox["NETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETType"]], "InlineFormula"],
 " (returned by ",
 Cell[BoxData[
  ButtonBox["LoadNETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFormula"],
 ") and ",
 Cell[BoxData[
  ButtonBox["NETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETAssembly"]], "InlineFormula"],
 " (returned by ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 ") to represent .NET types and assemblies in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". As noted earlier, you can pass these expressions to functions that take \
types or assemblies as arguments (such as ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 "). There are times when you might want not a ",
 Cell[BoxData[
  ButtonBox["NETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETType"]], "InlineFormula"],
 " expression, but an actual .NET ",
 StyleBox["Type", "MR"],
 " object reference for a given type, and likewise for an assembly. You can \
use ",
 Cell[BoxData[
  ButtonBox["GetTypeObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/GetTypeObject"]], "InlineFormula"],
 " to get the ",
 StyleBox["Type", "MR"],
 " object corresponding to a ",
 Cell[BoxData[
  ButtonBox["NETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETType"]], "InlineFormula"],
 " expression, and ",
 Cell[BoxData[
  ButtonBox["GetAssemblyObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/GetAssemblyObject"]], "InlineFormula"],
 " to get the .NET ",
 StyleBox["Assembly", "MR"],
 " object."
}], "Text",
 CellTags->"nlug:3.1.6",
 CellID->14115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"netType", "=", 
  RowBox[{"LoadNETType", "[", "\"\<System.Data.DataRow\>\"", "]"}]}]], "Input",\

 CellTags->"nlug:3.1.6",
 CellLabel->"In[1]:=",
 CellID->2619],

Cell[BoxData[
 RowBox[{"NETType", "[", 
  RowBox[{"\<\"System.Data.DataRow\"\>", ",", "1"}], "]"}]], "Output",
 CellTags->"nlug:3.1.6",
 CellLabel->"Out[1]=",
 CellID->20343]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"typeObj", "=", 
  RowBox[{"GetTypeObject", "[", "netType", "]"}]}]], "Input",
 CellTags->"nlug:3.1.6",
 CellLabel->"In[2]:=",
 CellID->30248],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", "[", "\<\"System.RuntimeType\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$2130356660600833]], "Output",
 CellTags->"nlug:3.1.6",
 CellLabel->"Out[2]=",
 CellID->18710]
}, Open  ]],

Cell[TextData[{
 "Notice above that the ",
 Cell[BoxData[
  ButtonBox["NETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETType"]], "InlineFormula"],
 " expression is much more informative about what type it represents than the \
",
 StyleBox["Type", "MR"],
 " object. This is one reason why ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " uses special ",
 Cell[BoxData[
  ButtonBox["NETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETType"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETAssembly"]], "InlineFormula"],
 " expressions instead of just ",
 StyleBox["Type", "MR"],
 " and ",
 StyleBox["Assembly", "MR"],
 " objects."
}], "Text",
 CellTags->"nlug:3.1.6",
 CellID->15544],

Cell[TextData[{
 "Once you have a ",
 StyleBox["Type", "MR"],
 " object, you can use methods and properties of the ",
 StyleBox["Type", "MR"],
 " class to learn about it."
}], "Text",
 CellTags->"nlug:3.1.6",
 CellID->6210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"typeObj", "@", "FullName"}]], "Input",
 CellTags->"nlug:3.1.6",
 CellLabel->"In[3]:=",
 CellID->302071484],

Cell[BoxData["\<\"System.Data.DataRow\"\>"], "Output",
 CellTags->"nlug:3.1.6",
 CellLabel->"Out[3]=",
 CellID->18040]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"typeObj", "@", "IsSerializable"}]], "Input",
 CellTags->"nlug:3.1.6",
 CellLabel->"In[4]:=",
 CellID->8337],

Cell[BoxData["True"], "Output",
 CellTags->"nlug:3.1.6",
 CellLabel->"Out[4]=",
 CellID->22012]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reference Counts and Memory Management", "Section",
 CellTags->"nlug:3.2.0",
 CellID->14400],

Cell[CellGroupData[{

Cell[TextData[{
 "Object References in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Subsection",
 CellTags->"nlug:3.2.0",
 CellID->861],

Cell[TextData[{
 "In our earlier treatment of ",
 StyleBox["NETObject", "MR"],
 " expressions we avoided discussing deeper issues such as reference counts \
and uniqueness. Every time a .NET object reference is returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", either as a result of a method or property or an explicit call to ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 ", ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " looks to see if a reference to this object has been sent previously in \
this session. If not, it creates a ",
 StyleBox["NETObject", "MR"],
 " expression in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and sets up a number of definitions for it. This is a comparatively \
time-consuming process. If this object has already been sent to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", in most cases ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " simply creates a ",
 StyleBox["NETObject", "MR"],
 " expression that is identical to the one created previously, which is a \
much faster operation."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->13463],

Cell[TextData[{
 "There are some exceptions to this last rule, meaning that sometimes when an \
object is returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " a new and different ",
 StyleBox["NETObject", "MR"],
 " expression is created for it, even though this same object has previously \
been sent to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Specifically, any time an object\[CloseCurlyQuote]s hash value (as \
determined by the object\[CloseCurlyQuote]s built-in ",
 StyleBox["GetHashCode()", "MR"],
 " method) has changed since the last time it was seen in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the ",
 StyleBox["NETObject", "MR"],
 " expression created will be different. You do not really need to be \
concerned with the details of this, except to remember that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s ",
 Cell[BoxData[
  ButtonBox["SameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SameQ"]], "InlineFormula"],
 " function is not a valid way to compare ",
 StyleBox["NETObject", "MR"],
 " expressions to decide whether they refer to the same object. You must use \
the ",
 Cell[BoxData[
  ButtonBox["SameObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/SameObjectQ"]], "InlineFormula"],
 " function."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->17255],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SameObjectQ",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/SameObjectQ"], "[", 
     RowBox[{
      StyleBox["obj1", "TI"], ",", 
      StyleBox["obj2", "TI"]}], "]"}], Cell[TextData[{
     "return ",
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"],
     " if the ",
     StyleBox["NETObject", "MR"],
     " expressions ",
     StyleBox["obj1",
      FontSlant->"Italic"],
     " and ",
     StyleBox["obj2",
      FontSlant->"Italic"],
     " refer to the same .NET object, return ",
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"],
     " otherwise"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.2.0",
 CellID->24814],

Cell[TextData[{
 "Comparing ",
 StyleBox["NETObject", "MR"],
 " expressions. "
}], "Caption",
 CellTags->"nlug:3.2.0",
 CellID->22050],

Cell["Here is an example.", "Text",
 CellTags->"nlug:3.2.0",
 CellID->18968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pt", " ", "=", 
  RowBox[{"NETNew", "[", 
   RowBox[{"\"\<System.Drawing.Point\>\"", ",", " ", "1", ",", " ", "1"}], 
   "]"}]}]], "Input",
 CellTags->"nlug:3.2.0",
 CellLabel->"In[1]:=",
 CellID->31926],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", "[", "\<\"System.Drawing.Point\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$3]], "Output",
 CellTags->"nlug:3.2.0",
 CellLabel->"Out[1]=",
 CellID->24017]
}, Open  ]],

Cell[TextData[{
 "The variable ",
 StyleBox["pt", "MR"],
 " refers to a .NET ",
 StyleBox["Point", "InlineCode"],
 " object. Now put it into a container so you can get it back out later."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->8785],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vec", " ", "=", " ", 
   RowBox[{"NETNew", "[", "\"\<System.Collections.ArrayList\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"vec", "@", 
   RowBox[{"Add", "[", "pt", "]"}]}], ";"}]}], "Input",
 CellTags->"nlug:3.2.0",
 CellLabel->"In[2]:=",
 CellID->25932],

Cell[TextData[{
 "Now change the value of one of its coordinates. For a ",
 StyleBox["Point", "InlineCode"],
 " object, this changes its hash value."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->21270],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"pt", "@", "X"}], " ", "=", " ", "2"}], ";"}]], "Input",
 CellTags->"nlug:3.2.0",
 CellLabel->"In[4]:=",
 CellID->27894],

Cell[TextData[{
 "Now compare the ",
 StyleBox["NETObject", "MR"],
 " expression given by ",
 StyleBox["pt", "MR"],
 " and the ",
 StyleBox["NETObject", "MR"],
 " expression created when you ask for the first element of the ",
 StyleBox["ArrayList", "MR"],
 " to be returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Even though these are both references to the same .NET object, the ",
 StyleBox["NETObject", "MR"],
 " expressions are different. Recall that the ",
 StyleBox["ArrayList", "MR"],
 " class defines an indexer (in C# terminology), so you can use the ",
 StyleBox["[]", "MR"],
 " notation to refer to an element by index."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->8012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pt", "===", 
  RowBox[{"vec", "[", "0", "]"}]}]], "Input",
 CellTags->"nlug:3.2.0",
 CellLabel->"In[5]:=",
 CellID->19292],

Cell[BoxData["False"], "Output",
 CellTags->"nlug:3.2.0",
 CellLabel->"Out[5]=",
 CellID->29984]
}, Open  ]],

Cell[TextData[{
 "Because you cannot use ",
 Cell[BoxData[
  ButtonBox["SameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SameQ"]], "InlineFormula"],
 " (",
 StyleBox["===", "MR"],
 ") to decide whether two object references in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " refer to the same .NET object, ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " provides the ",
 Cell[BoxData[
  ButtonBox["SameObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/SameObjectQ"]], "InlineFormula"],
 " function for this purpose."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->18536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SameObjectQ", "[", 
  RowBox[{"pt", ",", 
   RowBox[{"vec", "[", "0", "]"}]}], "]"}]], "Input",
 CellTags->"nlug:3.2.0",
 CellLabel->"In[6]:=",
 CellID->3461],

Cell[BoxData["True"], "Output",
 CellTags->"nlug:3.2.0",
 CellLabel->"Out[6]=",
 CellID->12102]
}, Open  ]],

Cell[TextData[{
 "You may be wondering why the ",
 Cell[BoxData[
  ButtonBox["SameObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/SameObjectQ"]], "InlineFormula"],
 " function is useful. Can\[CloseCurlyQuote]t you just call an object\
\[CloseCurlyQuote]s ",
 StyleBox["Equals()", "MR"],
 " method? It certainly gives the correct result for this example."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->11499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pt", "@", 
  RowBox[{"Equals", "[", 
   RowBox[{"vec", "[", "0", "]"}], "]"}]}]], "Input",
 CellTags->"nlug:3.2.0",
 CellLabel->"In[7]:=",
 CellID->10417],

Cell[BoxData["True"], "Output",
 CellTags->"nlug:3.2.0",
 CellLabel->"Out[7]=",
 CellID->16109]
}, Open  ]],

Cell[TextData[{
 "The problem with this technique is that ",
 StyleBox["Equals()", "MR"],
 " does not always compare object references. Any class is free to override \
",
 StyleBox["Equals()", "MR"],
 " to provide any desired behavior for comparing two objects of that class. \
Some classes make ",
 StyleBox["Equals()", "MR"],
 " compare the \[OpenCurlyDoubleQuote]contents\[CloseCurlyDoubleQuote] of the \
objects, such as the ",
 StyleBox["String", "MR"],
 " class, which uses it for string comparison. The function that provides the \
correct test is the static method ",
 StyleBox["ReferenceEquals()", "MR"],
 ". "
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->26752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Point`ReferenceEquals", "[", 
  RowBox[{"pt", ",", 
   RowBox[{"vec", "[", "0", "]"}]}], "]"}]], "Input",
 CellTags->"nlug:3.2.0",
 CellLabel->"In[8]:=",
 CellID->19490],

Cell[BoxData["True"], "Output",
 CellTags->"nlug:3.2.0",
 CellLabel->"Out[8]=",
 CellID->20638]
}, Open  ]],

Cell[TextData[{
 "You can think of ",
 Cell[BoxData[
  ButtonBox["SameObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/SameObjectQ"]], "InlineFormula"],
 " as a convenience function that does the same thing as explicitly calling \
",
 StyleBox["ReferenceEquals()", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->944],

Cell[TextData[{
 "In an unusual case where you need to compare object references for equality \
a very large number of times, the slowness of ",
 Cell[BoxData[
  ButtonBox["SameObjectQ",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/SameObjectQ"]], "InlineFormula"],
 " compared to ",
 Cell[BoxData[
  ButtonBox["SameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SameQ"]], "InlineFormula"],
 " could become an issue. The only thing that could cause two ",
 StyleBox["NETObject", "MR"],
 " expressions that refer to the exact same .NET object to not be ",
 Cell[BoxData[
  ButtonBox["SameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SameQ"]], "InlineFormula"],
 " is if the hash value of the object changed between the times that the two \
",
 StyleBox["NETObject", "MR"],
 " expressions were created. If you know this has not happened, you can \
safely use ",
 Cell[BoxData[
  ButtonBox["SameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SameQ"]], "InlineFormula"],
 " to test whether they refer to the same object."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->31966]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReleaseNETObject", "Subsection",
 CellTags->"nlug:3.2.0",
 CellID->7770],

Cell[TextData[{
 "The .NET runtime has a built-in facility called \
\[OpenCurlyDoubleQuote]garbage collection\[CloseCurlyDoubleQuote] for freeing \
up memory occupied by objects that are no longer in use by a program. Objects \
become eligible for garbage collection when no references to them exist \
anywhere, except perhaps in other objects that are also unreferenced. When an \
object is returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", either as a result of a call to ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 " or as the return value of a method or property, the ",
 StyleBox[".NET/Lin",
  FontSlant->"Italic"],
 "k code holds a special reference to the object on the .NET side to ensure \
that it cannot be garbage-collected while it is in use by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If you know that you no longer need to use a given .NET object in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, you can explicitly tell ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " to release its reference. The function that does this is ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 ". In addition to releasing the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-specific reference in .NET, ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 " clears out internal definitions that were created in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for the object. Any subsequent attempt to use this object in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will fail."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->1603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"frm", "=", 
  RowBox[{
  "NETNew", "[", "\"\<System.Windows.Forms.Form\>\"", "]"}]}]], "Input",
 CellTags->"nlug:3.2.0",
 CellLabel->"In[9]:=",
 CellID->20255],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", "[", "\<\"System.Windows.Forms.Form\"\>", 
    "]"}], "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$184549377]], "Output",
 CellTags->"nlug:3.2.0",
 CellLabel->"Out[9]=",
 CellID->437]
}, Open  ]],

Cell[TextData[{
 "Now tell .NET that you no longer need to use this object from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->21922],

Cell[BoxData[
 RowBox[{"ReleaseNETObject", "[", "frm", "]"}]], "Input",
 CellTags->"nlug:3.2.0",
 CellLabel->"In[10]:=",
 CellID->7487],

Cell[TextData[{
 "It is now an error to refer to ",
 StyleBox["frm", "MR"],
 " because the object\[CloseCurlyQuote]s symbolic representation has been \
removed from the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. This is what you see if you try to use the released object."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->10477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"frm", "@", "Text"}]], "Input",
 CellTags->"nlug:3.2.0",
 CellLabel->"In[11]:=",
 CellID->6209],

Cell[BoxData[
 RowBox[{
  TagBox[
   RowBox[{"Removed", "[", "\<\"NETObject$83886081\"\>", "]"}],
   False,
   Editable->False], "[", "Text", "]"}]], "Output",
 CellTags->"nlug:3.2.0",
 CellLabel->"Out[11]=",
 CellID->9563]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ReleaseNETObject",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/ReleaseNETObject"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[TextData[{
     "let .NET know that you are done using ",
     StyleBox["obj", "TI"],
     " in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NETBlock",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETBlock"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "all novel .NET objects returned to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " during the evaluation of ",
     StyleBox["expr", "TI"],
     " will be released when ",
     StyleBox["expr", "TI"],
     " finishes"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BeginNETBlock",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/BeginNETBlock"], "[", "]"}], Cell[
    TextData[{
     "all novel .NET objects returned to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " between now and the matching ",
     ButtonBox["EndNETBlock",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/EndNETBlock"],
     "[] will be released"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EndNETBlock",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/EndNETBlock"], "[", "]"}], Cell[
    TextData[{
     "release all novel objects seen since the matching ",
     ButtonBox["BeginNETBlock",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/BeginNETBlock"],
     "[]"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LoadedNETObjects",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/LoadedNETObjects"], "[", "]"}], Cell[
    TextData[{
     "return a list of all objects that are in use in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.2.0",
 CellID->30273],

Cell["Memory management functions.", "Caption",
 CellTags->"nlug:3.2.0",
 CellID->16031],

Cell[TextData[{
 "Calling ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 " will not necessarily cause the object to be garbage-collected. It is quite \
possible that other references to it exist in .NET. ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 " does not tell .NET to throw the object away, only that it does not need to \
be kept around solely for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s sake."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->2372],

Cell[TextData[{
 "An important fact about the references ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " maintains for objects sent to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that only one reference is kept for each object, no matter how many \
times it is returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It is your responsibility to make sure that after you call ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 ", you never attempt to use that object through any reference that might \
exist to it in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->32586],

Cell[BoxData[{
 RowBox[{
  RowBox[{"frm1", "=", 
   RowBox[{"NETNew", "[", "\"\<System.Windows.Forms.Form\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"frm2", " ", "=", " ", "frm1"}], ";"}]}], "Input",
 CellTags->"nlug:3.2.0",
 CellLabel->"In[3]:=",
 CellID->6091],

Cell[TextData[{
 "If you call ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 StyleBox["[frm1]", "MR"],
 ", it is not the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbol ",
 StyleBox["frm1", "MR"],
 " that is affected but the .NET object that ",
 StyleBox["frm1", "MR"],
 " refers to. Therefore, using ",
 StyleBox["frm2", "MR"],
 " is also an error (or any other way to refer to this same ",
 StyleBox["Form", "MR"],
 " object)."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->10558],

Cell[TextData[{
 "Calling ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 " is often unnecessary in casual use. If you are not making heavy use of \
.NET in your session, then you will not usually need to be concerned about \
keeping track of what objects may or may not be needed anymore\[LongDash]you \
can just let them pile up. There are times, though, when memory use in .NET \
will be important, and you may need the extra control that ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 " provides."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->17392]
}, Open  ]],

Cell[CellGroupData[{

Cell["NETBlock", "Subsection",
 CellTags->"nlug:3.2.0",
 CellID->9963],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 " is provided mainly for developers who are writing code for others to use. \
Because it is not possible to predict how code will be used, developers \
should always be sure that their code cleans up any unnecessary references it \
creates. Probably the most useful function for this is ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->17462],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 " automates the process of releasing objects encountered during the \
evaluation of an expression. Often, a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program will need to create some .NET objects with ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 "; operate with them, perhaps causing other objects to be returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as the results of method calls; and finally return some result such as a \
number or string. Every .NET object encountered by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " during this operation is needed only during the lifetime of the program, \
much like the local variables provided in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 ", and in C#, C++, Java, and many other languages by block scoping \
constructs (e.g., {}). ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 " allows you to mark a block of code as having the property that any new \
objects returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " during the evaluation are to be treated as temporary and released when ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 " finishes."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->15183],

Cell[TextData[{
 "It is important to note that the preceding sentence said \
\[OpenCurlyDoubleQuote]new objects.\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 " will not cause every object encountered during the evaluation to be \
released\[LongDash]only those that are being encountered for the first time. \
Objects that have already been seen by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will not be affected. This means that you do not have to worry that ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 " will aggressively release an object that is not truly temporary to that \
evaluation."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->17415],

Cell[TextData[{
 "It is not enough simply to call ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 " on every object you create with ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 ", because many .NET methods and properties return objects. You might not be \
interested in these return values. You might never assign them to a named \
variable because they may be chained together with other calls (as in ",
 StyleBox["obj@ReturnsObject[]@Foo[]", "MR"],
 "), but you still need to release them. Using ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 " is an easy way to be sure that all novel objects are released when a block \
of code finishes."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->3848],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 StyleBox["[expr]", "MR"],
 " returns whatever ",
 StyleBox["expr", "MR"],
 " returns."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->12535],

Cell[TextData[{
 "Many ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs will have the following structure."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->27397],

Cell[BoxData[
 RowBox[{
  RowBox[{"MyFunc", "[", "args__", "]"}], ":=", "\[IndentingNewLine]", "\t", 
  RowBox[{"NETBlock", "[", "\[IndentingNewLine]", "\t\t", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "locals", "}"}], ",", "\[IndentingNewLine]", "\t\t\t", 
     "..."}], "\t\t", "\[IndentingNewLine]", "\t\t", "]"}], 
   "\[IndentingNewLine]", "\t", "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.0",
 CellID->9025],

Cell[TextData[{
 "It is very common to write a function that creates a number of ",
 StyleBox["NETObject", "MR"],
 " expressions and then returns one of them, the rest being temporary. To \
facilitate this, if the return value of a ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 " is a single ",
 StyleBox["NETObject", "MR"],
 ", it will not be released."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->13707],

Cell[BoxData[
 RowBox[{
  RowBox[{"MyOtherFunc", "[", "args__", "]"}], ":=", "\n", "\t", 
  RowBox[{"NETBlock", "[", "\n", "\t\t", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "obj", "}"}], ",", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"...", "\n", "\t\t\t", "obj"}], "=", 
         RowBox[{"NETNew", "[", "\"\<System.Windows.Forms.Form\>\"", "]"}]}], 
        ";"}], "\n", "\t\t\t", "..."}], " ", "\n", "\t\t\t", 
      RowBox[{"Return", "[", "obj", "]"}]}]}], "  ", 
    RowBox[{"(*", " ", 
     RowBox[{"OK", ":", " ", 
      RowBox[{
      "obj", " ", "will", " ", "not", " ", "be", " ", "released", " ", "when",
        " ", "NETBlock", " ", 
       RowBox[{"finishes", "."}]}]}], " ", "*)"}], "\n", "\t\t", "]"}], "\n", 
   "\t", "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.0",
 CellID->17184],

Cell[TextData[{
 "If you want more control over which objects are allowed to escape from a ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 ", you can use the ",
 Cell[BoxData[
  ButtonBox["KeepNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/KeepNETObject"]], "InlineFormula"],
 " function. Calling ",
 Cell[BoxData[
  ButtonBox["KeepNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/KeepNETObject"]], "InlineFormula"],
 " on a single object or sequence of objects means they will not be released \
when the first enclosing ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 " ends. If there is an outer enclosing ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 ", the objects will be freed when ",
 StyleBox["it",
  FontSlant->"Italic"],
 " ends, however, so if you want the objects to escape a nested set of ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 "s, you must call ",
 Cell[BoxData[
  ButtonBox["KeepNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/KeepNETObject"]], "InlineFormula"],
 " at each level. Alternatively, you can call ",
 Cell[BoxData[
  ButtonBox["KeepNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/KeepNETObject"]], "InlineFormula"],
 StyleBox["[obj, Manual]", "MR"],
 ", where the ",
 StyleBox["Manual", "MR"],
 " argument tells ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " that the object should not be released by any enclosing ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 "s. The only way such object will be released is if you manually call ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 " on it."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->11444],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["KeepNETObject",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/KeepNETObject"], "[", 
     RowBox[{
      StyleBox["obj1", "TI"], ",", 
      StyleBox["obj2", "TI"], ",", 
      StyleBox["...", "TI"]}], "]"}], Cell[TextData[{
     "do not release the given objects when the ",
     ButtonBox["NETBlock",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETBlock"],
     " ends"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["KeepNETObject",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/KeepNETObject"], "[", 
     RowBox[{
      StyleBox["obj1", "TI"], ",", "Manual"}], "]"}], Cell[TextData[{
     "do not release the given object when any ",
     ButtonBox["NETBlock",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETBlock"],
     " ends"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.2.0",
 CellID->23022],

Cell[TextData[{
 "Keeping .NET objects after a ",
 StyleBox["NETBLock", "MR"],
 " ends."
}], "Caption",
 CellTags->"nlug:3.2.0",
 CellID->29073],

Cell[TextData[{
 "Here is an example that uses ",
 Cell[BoxData[
  ButtonBox["KeepNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/KeepNETObject"]], "InlineFormula"],
 " to allow you to return a list of two objects without releasing them."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->29994],

Cell["\<\
MyOtherFunc[args__] :=
\tModule[{obj1, obj2, obj3}, 
\t\tNETBlock[
\t\t\tobj1 = NETNew[\"System.Windows.Forms.Form\"; 
\t\t\tobj2 = NETNew[\"System.Windows.Forms.Button\"]; 
     \t\tobj3 = NETNew[\"SomeTemporaryObject\"];
     \t\t...
     \t\tKeepNETObject[obj1, obj2];
     \t\t{obj1, obj2}
     \t]
     ]\
\>", "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.0",
 CellID->20873],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BeginNETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/BeginNETBlock"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EndNETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/EndNETBlock"]], "InlineFormula"],
 " can be used to provide the same functionality as ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 " across more than one evaluation. ",
 Cell[BoxData[
  ButtonBox["EndNETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/EndNETBlock"]], "InlineFormula"],
 " releases all novel .NET objects returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " since the previous matching ",
 Cell[BoxData[
  ButtonBox["BeginNETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/BeginNETBlock"]], "InlineFormula"],
 ". These functions are mainly of use during development, when you might want \
to set a mark in your session, do some work, and then release all novel \
objects returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " since that point. ",
 Cell[BoxData[
  ButtonBox["BeginNETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/BeginNETBlock"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EndNETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/EndNETBlock"]], "InlineFormula"],
 " can be nested. Every ",
 Cell[BoxData[
  ButtonBox["BeginNETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/BeginNETBlock"]], "InlineFormula"],
 " should have a matching ",
 Cell[BoxData[
  ButtonBox["EndNETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/EndNETBlock"]], "InlineFormula"],
 ", although it is not a serious error to forget to call ",
 Cell[BoxData[
  ButtonBox["EndNETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/EndNETBlock"]], "InlineFormula"],
 ", even if you have nested levels of them\[LongDash]you will only fail to \
release some objects."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->29404]
}, Open  ]],

Cell[CellGroupData[{

Cell["LoadedNETObjects", "Subsection",
 CellTags->"nlug:3.2.0",
 CellID->26559],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LoadedNETObjects",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadedNETObjects"]], "InlineFormula"],
 StyleBox["[]", "MR"],
 " returns a list of all .NET objects that are currently referenced in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This includes all objects explicitly created with ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 " and all those that were returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as the result of a .NET method or property. It does not include objects \
that have been released with ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 " or through ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["LoadedNETObjects",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadedNETObjects"]], "InlineFormula"],
 " is intended mainly for debugging. It is very useful to call it before and \
after some function you are working on. If the list grows, your function \
leaks references, and you need to examine its use of ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 " and/or ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.2.0",
 CellID->18929]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Enums", "Section",
 CellTags->{"Enums", "nlug:3.2.1"},
 CellID->27357],

Cell[TextData[{
 "Enumerations in .NET are a special kind of class, with each member of the \
enumeration represented as a static constant field in the class. Although the \
values of enumeration constants are integers, ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " does not convert them into integers when they are returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This is because enum values are probably only going to be passed back \
into some other .NET method\[LongDash]it is not likely that you will want to \
operate on them as integers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In this case, it is more meaningful to have them appear in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as objects of a class instead of just cryptic integer values."
}], "Text",
 CellTags->"nlug:3.2.1",
 CellID->32532],

Cell[TextData[{
 "Suppose you have a ",
 StyleBox["Button", "MR"],
 " object ",
 StyleBox["btn", "MR"],
 " that you want to anchor in a form so that it stays in a fixed position \
with respect to one or more edges as the form is resized. To do this, you set \
the button\[CloseCurlyQuote]s ",
 StyleBox["Anchor", "MR"],
 " property to a value from the ",
 StyleBox["AnchorStyles", "MR"],
 " enum. First load the ",
 StyleBox["AnchorStyles", "MR"],
 " type, as is always necessary when you want to access a static member of \
the type."
}], "Text",
 CellTags->"nlug:3.2.1",
 CellID->16703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadNETType", "[", "\"\<System.Windows.Forms.AnchorStyles\>\"", 
  "]"}]], "Input",
 CellTags->"nlug:3.2.1",
 CellLabel->"In[16]:=",
 CellID->11962],

Cell[BoxData[
 RowBox[{"NETType", "[", 
  RowBox[{"\<\"System.Windows.Forms.AnchorStyles\"\>", ",", "6"}], 
  "]"}]], "Output",
 CellTags->"nlug:3.2.1",
 CellLabel->"Out[16]=",
 CellID->30982]
}, Open  ]],

Cell["\<\
You refer to a member of this enum just like any other static field.\
\>", "Text",
 CellTags->"nlug:3.2.1",
 CellID->5596],

Cell[CellGroupData[{

Cell[BoxData["AnchorStyles`Top"], "Input",
 CellTags->"nlug:3.2.1",
 CellLabel->"In[17]:=",
 CellID->28759],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", 
    "[", "\<\"System.Windows.Forms.AnchorStyles\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$16777217]], "Output",
 CellTags->"nlug:3.2.1",
 CellLabel->"Out[17]=",
 CellID->8541]
}, Open  ]],

Cell[TextData[{
 "The enum is represented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by a strongly typed object reference that is more meaningful to a \
programmer than the raw integer value, which happens to be 1. We can use the  \
",
 Cell[BoxData[
  ButtonBox["NETObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETObjectToExpression"]], 
  "InlineFormula"],
 " function to convert the object reference to its integer value."
}], "Text",
 CellTags->"nlug:3.2.1",
 CellID->4761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NETObjectToExpression", "[", "AnchorStyles`Top", "]"}]], "Input",
 CellTags->"nlug:3.2.1",
 CellLabel->"In[18]:=",
 CellID->8425],

Cell[BoxData["1"], "Output",
 CellTags->"nlug:3.2.1",
 CellLabel->"Out[18]=",
 CellID->117436566]
}, Open  ]],

Cell["Now apply it to the button.", "Text",
 CellTags->"nlug:3.2.1",
 CellID->23415],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"btn", "@", "Anchor"}], "=", "AnchorStyles`Top"}], ";"}]], "Input",\

 CellTags->"nlug:3.2.1",
 CellLabel->"In[19]:=",
 CellID->8752],

Cell["\<\
For any argument that is typed as an enum, you can pass either an instance of \
the enum class or a raw integer value. This means that the above line could \
also be written as the following, although it is obviously much less \
readable.\
\>", "Text",
 CellTags->"nlug:3.2.1",
 CellID->14524],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"btn", "@", "Anchor"}], "=", "1"}], ";"}]], "Input",
 CellTags->"nlug:3.2.1",
 CellLabel->"In[21]:=",
 CellID->10018],

Cell[TextData[{
 "Some enums have the ",
 StyleBox["[Flags]", "MR"],
 " attribute, which indicates that its values can be combined by a bitwise ",
 StyleBox["OR", "MR"],
 ". The ",
 StyleBox["AnchorStyles", "MR"],
 " enum has this attribute because you might want to anchor a component to \
more than one edge of its parent container. Here is an  example of what that \
looks like in C#."
}], "Text",
 CellTags->"nlug:3.2.1",
 CellID->12093],

Cell["\<\
// C# code
btn.Anchor = AnchorStyles.Top | AnchorStyles.Left;\
\>", "Program",
 CellTags->"nlug:3.2.1",
 CellID->8374],

Cell[TextData[{
 "To do this in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you need to get the integer values of the enum, so you use ",
 Cell[BoxData[
  ButtonBox["NETObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETObjectToExpression"]], 
  "InlineFormula"],
 ". (This is just about the only case where you would want to operate on enum \
values as integers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". )"
}], "Text",
 CellTags->"nlug:3.2.1",
 CellID->25569],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"btn", "@", "Anchor"}], "=", 
   RowBox[{"BitOr", "[", 
    RowBox[{
     RowBox[{"NETObjectToExpression", "[", "AnchorStyles`Top", "]"}], ",", 
     RowBox[{"NETObjectToExpression", "[", "AnchorStyles`Left", "]"}]}], 
    "]"}]}], ";"}]], "Input",
 CellTags->"nlug:3.2.1",
 CellLabel->"In[20]:=",
 CellID->29899]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["\[OpenCurlyDoubleQuote]", "TB"],
 "Out",
 StyleBox["\[CloseCurlyDoubleQuote]", "TB"],
 " and ",
 StyleBox["\[OpenCurlyDoubleQuote]", "TB"],
 "Ref",
 StyleBox["\[CloseCurlyDoubleQuote]", "TB"],
 " Parameters"
}], "Section",
 CellTags->{"Out and Ref Parameters", "nlug:3.2.2"},
 CellID->15993],

Cell[TextData[{
 ".NET allows parameters to be passed by reference, so that changes to their \
values can be propagated back to the caller. Such \
\[OpenCurlyDoubleQuote]by-reference\[CloseCurlyDoubleQuote] parameters are \
very rarely used in the .NET Framework classes, but are used more commonly in \
some third-party libraries. In C# notation, such parameters are marked as ",
 StyleBox["out", "MR"],
 " or ",
 StyleBox["ref", "MR"],
 ", the difference being that a ",
 StyleBox["ref", "MR"],
 " parameter needs an initial value on entry to the method, whereas an ",
 StyleBox["out", "MR"],
 " parameter does not. In Visual Basic .NET, the keyword ",
 StyleBox["ByRef", "MR"],
 " is used to indicate a parameter passed by reference. ",
 StyleBox["ByRef", "MR"],
 " parameters in Visual Basic are like ",
 StyleBox["ref", "MR"],
 " parameters in C#; there is no notion of an ",
 StyleBox["out", "MR"],
 "-only parameter in Visual Basic. In IDL notation, ",
 StyleBox["ref", "MR"],
 " parameters are written as ",
 StyleBox["[in, out]", "MR"],
 " and ",
 StyleBox["out", "MR"],
 "-only parameters are written as ",
 StyleBox["[out]", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.2.2",
 CellID->13947],

Cell[TextData[{
 "Here is an example of a ",
 StyleBox["ref", "MR"],
 " parameter in a method from the ",
 StyleBox["System.Uri", "MR"],
 " class."
}], "Text",
 CellTags->"nlug:3.2.2",
 CellID->6361],

Cell["\<\
// C#
public static char HexUnescape(string pattern, ref int index);

// Visual Basic
Public Shared Function HexUnescape(ByVal pattern As String, ByRef index As \
Integer) As Char\
\>", "Program",
 CellTags->"nlug:3.2.2",
 CellID->28928],

Cell[TextData[{
 "This method takes a string (the ",
 StyleBox["pattern", "MR"],
 " parameter) and a starting ",
 StyleBox["index", "MR"],
 " and reads the next character in the string, decoding a %xx-format \
hexadecimal representation if necessary. It also advances the ",
 StyleBox["index", "MR"],
 " value to just past the end of the decoded character. Like most methods \
that use ",
 StyleBox["ref", "MR"],
 " or ",
 StyleBox["out", "MR"],
 " parameters, this method needs to return more than one piece of information\
\[LongDash]the decoded character and also the next position in the string. \
Because the ",
 StyleBox["index", "MR"],
 " parameter's starting value is used by the method, it must be a ",
 StyleBox["ref", "MR"],
 " parameter and not merely an ",
 StyleBox["out", "MR"],
 " parameter."
}], "Text",
 CellTags->"nlug:3.2.2",
 CellID->3959],

Cell[TextData[{
 "You call methods with ",
 StyleBox["out", "MR"],
 " or ",
 StyleBox["ref", "MR"],
 " parameters from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in exactly the same way they are called from most .NET languages, \
including C# and Visual Basic .NET. For a ",
 StyleBox["ref", "MR"],
 " parameter, you call the method with a symbol that has an initial value of \
the correct type (an integer in this case). When the method returns, the \
symbol will have a new value assigned to it. "
}], "Text",
 CellTags->"nlug:3.2.2",
 CellID->4415],

Cell["\<\
This decodes the %20 character (the familiar encoding for a space character \
[decimal 32] in a URL).\
\>", "Text",
 CellTags->"nlug:3.2.2",
 CellID->16016],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadNETType", "[", "\"\<System.Uri\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pos", "=", "3"}], ";"}], "\n", 
 RowBox[{"Uri`HexUnescape", "[", 
  RowBox[{"\"\<abc%20def\>\"", ",", "pos"}], "]"}]}], "Input",
 CellTags->"nlug:3.2.2",
 CellLabel->"In[50]:=",
 CellID->15],

Cell[BoxData["32"], "Output",
 CellTags->"nlug:3.2.2",
 CellLabel->"Out[52]=",
 CellID->31466]
}, Open  ]],

Cell[TextData[{
 "Because pos was passed to a ",
 StyleBox["ref", "MR"],
 " parameter slot, it has been assigned a new value, that of the index of the \
first character after the %20."
}], "Text",
 CellTags->"nlug:3.2.2",
 CellID->14662],

Cell[CellGroupData[{

Cell[BoxData["pos"], "Input",
 CellTags->"nlug:3.2.2",
 CellLabel->"In[53]:=",
 CellID->27292],

Cell[BoxData["6"], "Output",
 CellTags->"nlug:3.2.2",
 CellLabel->"Out[53]=",
 CellID->26058]
}, Open  ]],

Cell[TextData[{
 "A common mistake when calling ",
 StyleBox["ref", "MR"],
 " parameters is to forget to assign an initial value. Here is an example of \
this error."
}], "Text",
 CellTags->"nlug:3.2.2",
 CellID->2398],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "pos", "]"}], ";"}], "\n", 
 RowBox[{"Uri`HexUnescape", "[", 
  RowBox[{"\"\<abc%20def\>\"", ",", "pos"}], "]"}]}], "Input",
 CellTags->"nlug:3.2.2",
 CellLabel->"In[54]:=",
 CellID->22331],

Cell[BoxData[
 RowBox[{
  RowBox[{"NET", "::", "\<\"methodargs\"\>"}], ":", 
  " ", "\<\"Improper arguments supplied for method named \
HexUnescape.\"\>"}]], "Message", "MSG",
 CellTags->"nlug:3.2.2",
 CellLabel->"From In[54]:=",
 CellID->7179],

Cell[BoxData["$Failed"], "Output",
 CellTags->"nlug:3.2.2",
 CellLabel->"Out[55]=",
 CellID->31188]
}, Open  ]],

Cell[TextData[{
 "If a parameter is marked as ",
 StyleBox["out", "MR"],
 " instead of ",
 StyleBox["ref", "MR"],
 ", the initial value is ignored, so it doesn\[CloseCurlyQuote]t matter what \
value, if any, the symbol had upon entering the method. As mentioned above, \
Visual Basic .NET has no notion of an ",
 StyleBox["out", "MR"],
 "-only parameter, so ",
 StyleBox["ByRef", "MR"],
 " parameters in methods written in Visual Basic will always need an initial \
value of the correct type, even if the method does not use the incoming \
value."
}], "Text",
 CellTags->"nlug:3.2.2",
 CellID->30073],

Cell[TextData[{
 "Like Visual Basic .NET (but unlike C#), ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " allows you to pass a literal value instead of a symbol to an ",
 StyleBox["out", "MR"],
 " or ",
 StyleBox["ref", "MR"],
 " parameter. In such cases, any changes made to the parameter\
\[CloseCurlyQuote]s value are lost. Here is an example."
}], "Text",
 CellTags->"nlug:3.2.2",
 CellID->13946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Uri`HexUnescape", "[", 
  RowBox[{"\"\<abc%20def\>\"", ",", "3"}], "]"}]], "Input",
 CellTags->"nlug:3.2.2",
 CellLabel->"In[56]:=",
 CellID->16089],

Cell[BoxData["32"], "Output",
 CellTags->"nlug:3.2.2",
 CellLabel->"Out[56]=",
 CellID->19980]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Returning Objects ",
 StyleBox["\[OpenCurlyDoubleQuote]", "TB"],
 "By Value",
 StyleBox["\[CloseCurlyDoubleQuote]", "TB"],
 " and ",
 StyleBox["\[OpenCurlyDoubleQuote]", "TB"],
 "By Reference\[CloseCurlyDoubleQuote]"
}], "Section",
 CellTags->"nlug:3.2.3",
 CellID->18481],

Cell[CellGroupData[{

Cell["References and Values", "Subsection",
 CellTags->"nlug:3.2.3",
 CellID->16500],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " provides a mapping between certain ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions and their .NET counterparts. What this means is that these ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions are automatically converted to and from their .NET \
counterparts as they are passed between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and .NET. For example, .NET integer types (",
 StyleBox["Int32", "MR"],
 ", ",
 StyleBox["Int16", "MR"],
 ", ",
 StyleBox["Byte", "MR"],
 ", and so on) are converted to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " integers and .NET real types (",
 StyleBox["Single", "MR"],
 " and ",
 StyleBox["Double", "MR"],
 ") are converted to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " real numbers. Another mapping is that .NET objects are converted to ",
 StyleBox["NETObject", "MR"],
 " expressions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". These ",
 StyleBox["NETObject", "MR"],
 " expressions are ",
 StyleBox["references",
  FontSlant->"Italic"],
 " to .NET objects\[LongDash]they have no meaning in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " except as they are manipulated by ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ". However, some .NET objects are things that have meaningful values in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and these objects are by default converted to values. Examples of such \
objects are strings and arrays."
}], "Text",
 CellTags->"nlug:3.2.3",
 CellID->18880],

Cell[TextData[{
 "You could say, then, that .NET objects are by default returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \[OpenCurlyDoubleQuote]by reference,\[CloseCurlyDoubleQuote] except for a \
few special cases. These special cases are numbers, strings, arrays, and \
booleans. You could say that these exceptional cases are returned \
\[OpenCurlyDoubleQuote]by value.\[CloseCurlyDoubleQuote] The table under ",
 ButtonBox["Conversion of Types Between .NET and ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#31571"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#31571"],
  FontSlant->"Italic"],
 " shows how these special .NET object types are mapped into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " values."
}], "Text",
 CellTags->"nlug:3.2.3",
 CellID->9487],

Cell[TextData[{
 "In summary, every .NET object that has a meaningful value representation in \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is converted into this value, simply because that is the most useful \
behavior. There are times, however, when you might want to override this \
default behavior. Probably the most common reason for doing this is to avoid \
unnecessary traffic of large expressions over ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.2.3",
 CellID->1341],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ReturnAsNETObject",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/ReturnAsNETObject"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "a .NET object returned by ",
     StyleBox["expr", "TI"],
     " will be in the form of a reference"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NETObjectToExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETObjectToExpression"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[TextData[{
     "give the value of the .NET object as a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.2.3",
 CellID->18261],

Cell[TextData[{
 StyleBox["\[OpenCurlyDoubleQuote]", "TR"],
 "By reference",
 StyleBox["\[CloseCurlyDoubleQuote]", "TR"],
 " and ",
 StyleBox["\[OpenCurlyDoubleQuote]", "TR"],
 "by value",
 StyleBox["\[CloseCurlyDoubleQuote]", "TR"],
 " control."
}], "Caption",
 CellTags->"nlug:3.2.3",
 CellID->28241]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReturnAsNETObject", "Subsection",
 CellTags->"nlug:3.2.3",
 CellID->12798],

Cell[TextData[{
 "Consider the case where you have a static method in class ",
 StyleBox["MyClass", "MR"],
 " called ",
 StyleBox["arrayAbs()", "MR"],
 " that takes an array of doubles and returns a new array where each element \
is the absolute value of the corresponding element in the argument array. The \
declaration of this method in C# syntax thus looks like ",
 StyleBox["double[] ArrayAbs(double[] a)", "MR"],
 ". This is how you would call such a method from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.2.3",
 CellID->31689],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadJNETType", "[", 
   RowBox[{"\"\<MyClass\>\"", ",", 
    RowBox[{"StaticsVisible", "\[Rule]", "True"}]}], "]"}], ";"}], "\n", 
 RowBox[{"ArrayAbs", "[", 
  RowBox[{"{", 
   RowBox[{"1.", ",", 
    RowBox[{"-", "2."}], ",", "3.", ",", "4."}], "}"}], "]"}]}], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.3",
 CellLabel->"In[1]:=",
 CellID->25573],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"1.", ",", "2.", ",", "3.", ",", "4."}], "}"}], "MR"]], "Output",
 CellTags->"nlug:3.2.3",
 CellLabel->"Out[2]=",
 CellID->3908]
}, Open  ]],

Cell[TextData[{
 "The above example is how you probably want the method to work: you pass a \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list and get back a list. Now assume you have another method named ",
 StyleBox["ArraySqrt()", "MR"],
 " that acts like ",
 StyleBox["ArrayAbs()", "MR"],
 " except that it performs the S",
 StyleBox["qrt()", "MR"],
 " function instead of ",
 StyleBox["Abs()", "MR"],
 ". "
}], "Text",
 CellTags->"nlug:3.2.3",
 CellID->1409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArraySqrt", "[", 
  RowBox[{"ArrayAbs", "[", 
   RowBox[{"{", 
    RowBox[{"1.", ",", 
     RowBox[{"-", "2."}], ",", "3.", ",", "4."}], "}"}], "]"}], 
  "]"}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.3",
 CellLabel->"In[3]:=",
 CellID->3950],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"1.", ",", "1.41421", ",", "1.73205", ",", "2."}], "}"}], 
  "MR"]], "Output",
 CellTags->"nlug:3.2.3",
 CellLabel->"Out[3]=",
 CellID->27308]
}, Open  ]],

Cell[TextData[{
 "In this computation, the original list is sent over ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " to .NET and a .NET array is created with these values. That array is \
passed as an argument to ",
 StyleBox["ArrayAbs()", "MR"],
 ", which itself creates and returns another array. This array is then sent \
back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " via ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " to create a list, which is then promptly sent back to .NET as the argument \
for ",
 StyleBox["ArraySqrt()", "MR"],
 ". You can see that it was a waste of time to send the array data back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[LongDash]you had a perfectly good array (the one returned by the ",
 StyleBox["ArrayAbs()", "MR"],
 " method) living on the .NET side, ready to be passed to ",
 StyleBox["ArraySqrt()", "MR"],
 ", but instead you sent its contents back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " only to have it immediately come back to .NET again as a new array with \
the same values! For this example, the cost is negligible, but what if the \
array had 200,000 elements?"
}], "Text",
 CellTags->"nlug:3.2.3",
 CellID->28941],

Cell[TextData[{
 "What is needed is a way to let the array data remain in .NET and return \
only a reference to the array, not the actual data itself. This can be \
accomplished with the ",
 Cell[BoxData[
  ButtonBox["ReturnAsNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReturnAsNETObject"]], "InlineFormula"],
 " function."
}], "Text",
 CellTags->"nlug:3.2.3",
 CellID->19467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReturnAsNETObject", "[", 
  RowBox[{"ArrayAbs", "[", 
   RowBox[{"{", 
    RowBox[{"1.", ",", 
     RowBox[{"-", "2."}], ",", "3.", ",", "4."}], "}"}], "]"}], 
  "]"}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.3",
 CellLabel->"In[4]:=",
 CellID->3425],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]NETObject", "[", "\<\"System.Double[]\"\>", "]"}],
    "\[RightGuillemet]"}],
  JLink`Objects`JavaObject4579100917761]], "Output",
 CellTags->"nlug:3.2.3",
 CellLabel->"Out[4]=",
 CellID->15450]
}, Open  ]],

Cell[TextData[{
 "Here is how the computation looks using ",
 Cell[BoxData[
  ButtonBox["ReturnAsNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReturnAsNETObject"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.2.3",
 CellID->22704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArraySqrt", "[", 
  RowBox[{"ReturnAsNETObject", "[", 
   RowBox[{"ArrayAbs", "[", 
    RowBox[{"{", 
     RowBox[{"1.", ",", 
      RowBox[{"-", "2."}], ",", "3.", ",", "4."}], "}"}], "]"}], "]"}], 
  "]"}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.3",
 CellLabel->"In[5]:=",
 CellID->16736],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"1.", ",", "1.41421", ",", "1.73205", ",", "2."}], "}"}], 
  "MR"]], "Output",
 CellTags->"nlug:3.2.3",
 CellLabel->"Out[5]=",
 CellID->25067]
}, Open  ]],

Cell[TextData[{
 "Earlier you saw ",
 StyleBox["ArraySqrt()", "MR"],
 " being called with an argument that was a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list of reals. Here it is being called with a reference to a .NET object \
that is a one-dimensional array of doubles. All arguments can be called from \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with either a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " value or a reference to a .NET object of the appropriate type."
}], "Text",
 CellTags->"nlug:3.2.3",
 CellID->30054],

Cell[TextData[{
 "In summary, the ",
 Cell[BoxData[
  ButtonBox["ReturnAsNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReturnAsNETObject"]], "InlineFormula"],
 " function causes methods and properties that return objects that would \
normally be converted into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " values to return references instead. It is often used as an optimization \
to avoid unnecessarily passing large amounts of data between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and .NET, and as such it will be useful primarily for very large arrays \
and strings. Objects of most .NET types have no meaningful \
\[OpenCurlyDoubleQuote]by value\[CloseCurlyDoubleQuote] representation in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and they are always returned \"by reference.\" ",
 Cell[BoxData[
  ButtonBox["ReturnAsNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReturnAsNETObject"]], "InlineFormula"],
 " is redundant these cases."
}], "Text",
 CellTags->"nlug:3.2.3",
 CellID->3285]
}, Open  ]],

Cell[CellGroupData[{

Cell["NETObjectToExpression", "Subsection",
 CellTags->"nlug:3.2.3",
 CellID->32085],

Cell[TextData[{
 "In the previous section, you saw how the ",
 Cell[BoxData[
  ButtonBox["ReturnAsNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReturnAsNETObject"]], "InlineFormula"],
 " function can be used to cause objects normally returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by value to be returned by reference. It is necessary to have a function \
that does the reverse\[LongDash]takes a reference and converts it to its \
value representation. That function is ",
 Cell[BoxData[
  ButtonBox["NETObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETObjectToExpression"]], 
  "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.2.3",
 CellID->16921],

Cell[TextData[{
 "Keep in mind that almost always when you are dealing with a .NET object \
that has a meaningful \[OpenCurlyDoubleQuote]value\[CloseCurlyDoubleQuote] \
representation in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the object will be automatically converted to this value when it is sent \
to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". There are some exceptions to this rule, and these are where ",
 Cell[BoxData[
  ButtonBox["NETObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETObjectToExpression"]], 
  "InlineFormula"],
 " becomes useful. You saw earlier that the ",
 Cell[BoxData[
  ButtonBox["ReturnAsNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReturnAsNETObject"]], "InlineFormula"],
 " function can be used to force an object to be returned as a reference. \
Another way to get a reference is to call ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["MakeNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/MakeNETObject"]], "InlineFormula"],
 ", as these functions always return an object reference. Here we create a ",
 StyleBox["String", "MR"],
 " object explicitly."
}], "Text",
 CellTags->"nlug:3.2.3",
 CellID->16628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NETNew", "[", 
  RowBox[{"\"\<System.String\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"65", ",", " ", "66", ",", " ", "67"}], "}"}]}], "]"}]], "Input",
 CellTags->"nlug:3.2.3",
 CellLabel->"In[1]:=",
 CellID->27935],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]NETObject", "[", "\<\"System.String\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$3245443265855490]], "Output",
 CellTags->"nlug:3.2.3",
 CellLabel->"Out[1]=",
 CellID->32215]
}, Open  ]],

Cell[TextData[{
 "This converts the string reference to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string."
}], "Text",
 CellTags->"nlug:3.2.3",
 CellID->7604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NETObjectToExpression", "[", "%", "]"}]], "Input",
 CellTags->"nlug:3.2.3",
 CellLabel->"In[2]:=",
 CellID->21244],

Cell[BoxData["\<\"ABC\"\>"], "Output",
 CellTags->"nlug:3.2.3",
 CellLabel->"Out[2]=",
 CellID->5050]
}, Open  ]],

Cell[TextData[{
 "The section on ",
 ButtonBox["Overloaded Operators ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#18254"],
 "introduces the ",
 Cell[BoxData[
  ButtonBox["MakeNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/MakeNETObject"]], "InlineFormula"],
 " function, which is easier than using ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 " to construct .NET objects out of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " strings, numbers, and arrays."
}], "Text",
 CellTags->"nlug:3.2.3",
 CellID->4655],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NETObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETObjectToExpression"]], 
  "InlineFormula"],
 " also converts into their value representations some object types that are \
normally returned by reference: enumerations and collections (objects that \
implement the ",
 StyleBox["ICollection", "MR"],
 " interface). Enumeration types are discussed in the ",
 ButtonBox["Enums",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#27357"],
 " section. Collections can be usefully operated on in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as lists, but unlike arrays, collections might be expensive to iterate \
through, so ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " leaves them as references and does not automatically convert them to \
lists. If you want a list, use ",
 Cell[BoxData[
  ButtonBox["NETObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETObjectToExpression"]], 
  "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.2.3",
 CellID->28019],

Cell["This creates a collection object:", "Text",
 CellTags->"nlug:3.2.3",
 CellID->19881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"arrayList", "=", 
  RowBox[{
  "NETNew", "[", "\"\<System.Collections.ArrayList\>\"", "]"}]}]], "Input",
 CellTags->"nlug:3.2.3",
 CellLabel->"In[1]:=",
 CellID->13619],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", "[", "\<\"System.Collections.ArrayList\"\>", 
    "]"}], "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$100663297]], "Output",
 CellTags->"nlug:3.2.3",
 CellLabel->"Out[1]=",
 CellID->2948]
}, Open  ]],

Cell["Now populate it with values.", "Text",
 CellTags->"nlug:3.2.3",
 CellID->12656],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"arrayList", "[", 
     RowBox[{"Add", "[", "#1", "]"}], "]"}], "&"}], "/@", 
   RowBox[{"Range", "[", "10", "]"}]}], ";"}]], "Input",
 CellTags->"nlug:3.2.3",
 CellLabel->"In[2]:=",
 CellID->5631],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NETObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETObjectToExpression"]], 
  "InlineFormula"],
 " converts the object reference to a list."
}], "Text",
 CellTags->"nlug:3.2.3",
 CellID->12941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NETObjectToExpression", "[", "arrayList", "]"}]], "Input",
 CellTags->"nlug:3.2.3",
 CellLabel->"In[3]:=",
 CellID->22178],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10"}], "}"}]], "Output",
 CellTags->"nlug:3.2.3",
 CellLabel->"Out[3]=",
 CellID->13273]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Overloaded Operators", "Section",
 CellTags->{"Overloaded Operators", "nlug:3.2.4"},
 CellID->18254],

Cell[TextData[{
 "Some .NET languages allow you to define overloaded operators such as ",
 StyleBox["+", "MR"],
 ", ",
 StyleBox[">", "MR"],
 ", and so on for a class. Support for overloading of operators is not \
required in a .NET language. C# and C++ allow it; Visual Basic .NET does not. \
An example of a class that defines a number of overloaded operators is ",
 StyleBox["System.TimeSpan", "MR"],
 ". For instance, it defines a ",
 StyleBox["+", "MR"],
 " operator so that you can add two ",
 StyleBox["TimeSpan", "MR"],
 " objects just like they were numbers. Here is what it looks like in C# \
code."
}], "Text",
 CellTags->"nlug:3.2.4",
 CellID->618],

Cell["\<\
// C# code
TimeSpan t1 = new TimeSpan(2, 45, 55);  // 2 hrs, 45 mins, 55 secs.
TimeSpan t2 = new TimeSpan(3, 10, 25);  // 3 hrs, 10 mins, 25 secs.
TimeSpan sum = t1 + t2;\
\>", "Program",
 CellTags->"nlug:3.2.4",
 CellID->16800],

Cell[TextData[{
 "Because .NET languages are not required to support overloaded operators, \
any class that defines them should always provide some other means to \
accomplish the same operation, generally via a method call. The ",
 StyleBox["TimeSpan", "MR"],
 " class provides an ",
 StyleBox["Add()", "MR"],
 " method that you can use in languages like Visual Basic .NET that do not \
allow overloaded operators."
}], "Text",
 CellTags->"nlug:3.2.4",
 CellID->4429],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " does not support overloaded operators in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " syntax, so you should seek out the method that performs the same \
operation. Here is the ",
 StyleBox["Add()", "MR"],
 " method to add two ",
 StyleBox["TimeSpan", "MR"],
 " objects."
}], "Text",
 CellTags->"nlug:3.2.4",
 CellID->7561],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"t1", "=", 
   RowBox[{"NETNew", "[", 
    RowBox[{"\"\<System.TimeSpan\>\"", ",", "2", ",", "4", ",", "55"}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"t2", "=", 
   RowBox[{"NETNew", "[", 
    RowBox[{"\"\<System.TimeSpan\>\"", ",", "3", ",", "10", ",", "25"}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sum", "=", 
   RowBox[{"t1", "@", 
    RowBox[{"Add", "[", "t2", "]"}]}]}], ";"}], "\n", 
 RowBox[{"sum", "@", 
  RowBox[{"ToString", "[", "]"}]}]}], "Input",
 CellTags->"nlug:3.2.4",
 CellLabel->"In[63]:=",
 CellID->23932],

Cell[BoxData["\<\"05:15:20\"\>"], "Output",
 CellTags->"nlug:3.2.4",
 CellLabel->"Out[66]=",
 CellID->11358]
}, Open  ]],

Cell[TextData[{
 "Even if the class author ignored the .NET guidelines and failed to provide \
an alternative method for accomplishing the same operation as an overloaded \
operator, you could still invoke the operation from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This is because overloaded operators in C# and C++ are achieved \
internally through special static methods with names like ",
 StyleBox["op_XXX", "MR"],
 " where ",
 StyleBox["XXX", "MR"],
 " is the name of the operation. The class author does not write these \
methods directly\[LongDash]they are created by the compiler. Nonetheless, \
they can be called directly from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " like any other method. Here are all these cryptically-named methods in the \
",
 StyleBox["TimeSpan", "MR"],
 " class."
}], "Text",
 CellTags->"nlug:3.2.4",
 CellID->7546],

Cell[CellGroupData[{

Cell["NETTypeInfo[\"System.TimeSpan\", \"Methods\", \"op_*\"]", "Input",
 CellTags->"nlug:3.2.4",
 CellLabel->"In[60]:=",
 CellID->21260],

Cell[BoxData[GridBox[{
   {""},
   {Cell[BoxData[
     RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Methods",
       FontSize->18,
       FontWeight->"Bold",
       FontSlant->"Italic"], "\<\" (matching string pattern op_*)\"\>"}]]]},
   {
    RowBox[{"static", " ", "\<\"TimeSpan\"\>", " ", 
     StyleBox["op_Addition",
      FontWeight->"Bold"], "\<\"(TimeSpan t1, TimeSpan t2)\"\>"}]},
   {
    RowBox[{"static", " ", "\<\"bool\"\>", " ", 
     StyleBox["op_Equality",
      FontWeight->"Bold"], "\<\"(TimeSpan t1, TimeSpan t2)\"\>"}]},
   {
    RowBox[{"static", " ", "\<\"bool\"\>", " ", 
     StyleBox["op_GreaterThan",
      FontWeight->"Bold"], "\<\"(TimeSpan t1, TimeSpan t2)\"\>"}]},
   {
    RowBox[{"static", " ", "\<\"bool\"\>", " ", 
     StyleBox["op_GreaterThanOrEqual",
      FontWeight->"Bold"], "\<\"(TimeSpan t1, TimeSpan t2)\"\>"}]},
   {
    RowBox[{"static", " ", "\<\"bool\"\>", " ", 
     StyleBox["op_Inequality",
      FontWeight->"Bold"], "\<\"(TimeSpan t1, TimeSpan t2)\"\>"}]},
   {
    RowBox[{"static", " ", "\<\"bool\"\>", " ", 
     StyleBox["op_LessThan",
      FontWeight->"Bold"], "\<\"(TimeSpan t1, TimeSpan t2)\"\>"}]},
   {
    RowBox[{"static", " ", "\<\"bool\"\>", " ", 
     StyleBox["op_LessThanOrEqual",
      FontWeight->"Bold"], "\<\"(TimeSpan t1, TimeSpan t2)\"\>"}]},
   {
    RowBox[{"static", " ", "\<\"TimeSpan\"\>", " ", 
     StyleBox["op_Subtraction",
      FontWeight->"Bold"], "\<\"(TimeSpan t1, TimeSpan t2)\"\>"}]},
   {
    RowBox[{"static", " ", "\<\"TimeSpan\"\>", " ", 
     StyleBox["op_UnaryNegation",
      FontWeight->"Bold"], "\<\"(TimeSpan t)\"\>"}]},
   {
    RowBox[{"static", " ", "\<\"TimeSpan\"\>", " ", 
     StyleBox["op_UnaryPlus",
      FontWeight->"Bold"], "\<\"(TimeSpan t)\"\>"}]}
  },
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}},
  GridBoxItemSize->{
   "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.2}}, 
    "RowsIndexed" -> {}}]], "Output",
 AutoSpacing->False,
 CellTags->"nlug:3.2.4",
 CellID->28943]
}, Open  ]],

Cell[TextData[{
 "Even if there was no ",
 StyleBox["Add()", "MR"],
 " method in the ",
 StyleBox["TimeSpan", "MR"],
 " class, you could still add them together by invoking the ",
 StyleBox["op_Addition()", "MR"],
 " method. Note that as always when calling .NET names from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you map the underscore character to a U because underscore is not a legal \
character in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbol."
}], "Text",
 CellTags->"nlug:3.2.4",
 CellID->3723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"TimeSpan`opUAddition", "[", 
   RowBox[{"t1", ",", "t2"}], "]"}], "@", 
  RowBox[{"ToString", "[", "]"}]}]], "Input",
 CellTags->"nlug:3.2.4",
 CellLabel->"In[62]:=",
 CellID->29817],

Cell[BoxData["\<\"05:15:20\"\>"], "Output",
 CellTags->"nlug:3.2.4",
 CellLabel->"Out[62]=",
 CellID->22712]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Casting", "Section",
 CellTags->{"Casting", "nlug:3.2.5"},
 CellID->16712],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
 CellTags->"nlug:3.2.5",
 CellID->20880],

Cell[TextData[{
 ".NET programs often include ",
 StyleBox["casts",
  FontSlant->"Italic"],
 ", where an object of one type is converted to another type. A typical \
example is where a programmer has a variable of type ",
 Cell[BoxData["Object"], "InlineFormula"],
 ", probably obtained as the result of a method call typed to return ",
 Cell[BoxData["Object"], "InlineFormula"],
 ", and wants to cast it to a derived type so that methods from that type can \
be called on it. This often occurs when dealing with collection classes, as \
they can hold objects of any type and thus their methods are typed to return \
nothing more specific than ",
 Cell[BoxData["Object"], "InlineFormula"],
 ". Here is the signature of the ",
 Cell[BoxData[
  RowBox[{"IList", ".", "Item"}]], "InlineFormula"],
 " property, which extracts from a list the object at a given index."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->12526],

Cell["\<\
' Visual Basic .NET
Default Property Item(index As Integer) As Object

// C#
object this[int index] {get; set;}\
\>", "Program",
 CellTags->"nlug:3.2.5",
 CellID->28959],

Cell[TextData[{
 "In C# the ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " property is the indexer for the class, so it can be written with the above \
unusual syntax or as a property named ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 ", like in Visual Basic. If you are putting, say, strings into an ",
 Cell[BoxData["IList"], "InlineFormula"],
 " and later extract one using the ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " property, you would have to cast it to a string to be able to assign it to \
a string variable."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->10460],

Cell["\<\
// C#
ArrayList aList = new ArrayList;
aList.Add(\"abc\");
...
string s = (string) aList[0];

' Visual Basic .NET
Dim aList As New ArrayList
aList.Add(\"abc\")
...
Dim s as String
s = CType(aList(0), String)\
\>", "Program",
 CellTags->"nlug:3.2.5",
 CellID->7977],

Cell[TextData[{
 "In Visual Basic .NET, a cast is performed using the ",
 Cell[BoxData[
  RowBox[{"CType", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " function, and it is only necessary if ",
 Cell[BoxData[
  RowBox[{"Option", " ", "Strict"}]], "InlineFormula"],
 " is set."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->4200],

Cell[TextData[{
 "This type of cast is called a ",
 StyleBox["downcast",
  FontSlant->"Italic"],
 " because you are casting down the inheritance hierarchy (from a parent type \
to a derived type). Such downcasting is probably the most common form of \
casting (aside from the casting used to convert numbers of one type to \
another, such as ",
 Cell[BoxData["int"], "InlineFormula"],
 " to ",
 Cell[BoxData["byte"], "InlineFormula"],
 ")."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->31274],

Cell[TextData[{
 "Although you will see downcasting scattered throughout the C# and Visual \
Basic .NET programs that you might be trying to duplicate in ",
 StyleBox[".NET/Lin",
  FontSlant->"Italic"],
 StyleBox["k",
  FontSlant->"Italic"],
 ", downcasting is virtually ",
 StyleBox["never",
  FontSlant->"Italic"],
 " relevant in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ". This is because casting between reference types is primarily a \
compile-time operation. In the above sample code, the programmer is telling \
the compiler that they know the object they just extracted from the ",
 Cell[BoxData["ArrayList"], "InlineFormula"],
 " is a string, and they want the compiler to allow them to treat it as one. \
But in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " objects are always returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as their true runtime types, so when you call the ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " property, you get back an object of type ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 ". It is completely irrelevant that the ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " property is typed to return ",
 Cell[BoxData["Object"], "InlineFormula"],
 ". In effect, downcasting is irrelevant and even impossible in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " because every object has its true runtime type\[LongDash]there is no type \
further down the inheritance hierarchy to cast an object to!"
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->5783],

Cell[TextData[{
 "The point of this preamble is to make it clear that the vast majority of \
casts you see in .NET programs are irrelevant in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ". They are either conversions between numeric types (which are easily done \
in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by other means if they are even necessary at all), or downcasts from some \
general type, like ",
 Cell[BoxData["Object"], "InlineFormula"],
 ", to a more specific type (which are pointless because they are done for \
the sake of the compiler and there is no compilation stage in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ")."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->15781],

Cell[TextData[{
 "There are some places in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", however, where casting is necessary. One case is when working with COM \
objects. This is discussed in the ",
 ButtonBox["COM ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
 "section and will not be dealt with here. All the other cases where casting \
is necessary in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " are ",
 StyleBox["upcasts",
  FontSlant->"Italic"],
 ", where you are casting an object to a parent class or interface. The three \
situations where upcasting is necessary are as follows."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->30506],

Cell["to call a hidden parent-class implementation of a method", \
"BulletedText",
 CellTags->"nlug:3.2.5",
 CellID->4987],

Cell["\<\
to call methods written using so-called \[OpenCurlyDoubleQuote]explicit \
interface implementation\[CloseCurlyDoubleQuote]\
\>", "BulletedText",
 CellTags->"nlug:3.2.5",
 CellID->522560435],

Cell[CellGroupData[{

Cell["\<\
to call methods on a private class that implements a public interface\
\>", "BulletedText",
 CellTags->"nlug:3.2.5",
 CellID->803030715],

Cell[TextData[{
 "Note that these are relatively rare circumstances, and many programmers \
will never encounter them. Although these are nontrivial aspects of .NET \
programming, there is really no extra complexity introduced by ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 "\[LongDash]these are precisely the cases where upcasting is required in C#, \
Visual Basic .NET, and other .NET languages. These three cases will be \
discussed individually in the following sections."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->9501],

Cell[TextData[{
 "The function that casts a .NET object reference is ",
 Cell[BoxData[
  ButtonBox["CastNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CastNETObject"]], "InlineFormula"],
 ". You will see examples in the following sections. ",
 Cell[BoxData[
  ButtonBox["CastNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CastNETObject"]], "InlineFormula"],
 " does not create a new object reference, just an \
\[OpenCurlyDoubleQuote]alias\[CloseCurlyDoubleQuote] of an existing object \
reference. This means that if you call ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 " on an object, the object and all casted references to it are freed. In \
other words, an object and its casted versions are really just different ways \
of viewing the same object, not separate references."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->14568],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CastNETObject",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/CastNETObject"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["\"\<type\>\"", "TI"], "]"}], Cell[TextData[{
     "cast the object ",
     StyleBox["obj", "TI"],
     " to the given type, specified as a string"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CastNETObject",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/CastNETObject"], "[", 
     RowBox[{
      StyleBox["obj", "TI"], ",", 
      StyleBox["NETType", "TI"]}], "]"}], Cell[TextData[{
     "cast the object ",
     StyleBox["obj", "TI"],
     " to the given type, specified as a ",
     ButtonBox["NETType",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETType"],
     " expression"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.2.5",
 CellID->28192],

Cell[TextData[{
 "Casting ",
 Cell[BoxData["NETObject"], "InlineFormula"],
 " expressions. "
}], "Caption",
 CellTags->"nlug:3.2.5",
 CellID->23714],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["CastNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CastNETObject"]], "InlineFormula"],
 " function was introduced in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " 1.1."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->1741]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calling Hidden Members from a Parent Class", "Subsection",
 CellTags->"nlug:3.2.5",
 CellID->1705],

Cell[TextData[{
 "A child class can hide members of its parent class by declaring members \
with the same name using the ",
 Cell[BoxData["new"], "InlineFormula"],
 " keyword (in C#) or ",
 Cell[BoxData["Shadows"], "InlineFormula"],
 " keyword (in Visual Basic .NET). Consider the following classes."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->11694],

Cell["\<\
// C# code
public class Parent {
\tpublic string Foo() { return \"from parent\"; }
}

public class Child : Parent {
\tpublic new string Foo() { return \"from child\"; }
}\
\>", "Program",
 CellTags->"nlug:3.2.5",
 CellID->8130],

Cell[TextData[{
 "If you had an instance of the ",
 Cell[BoxData["Child"], "InlineFormula"],
 " class, but wanted to call the ",
 Cell[BoxData["Parent"], "InlineFormula"],
 " implementation of ",
 Cell[BoxData[
  RowBox[{"Foo", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ", you could do this by casting the ",
 Cell[BoxData["Child"], "InlineFormula"],
 " instance to the ",
 Cell[BoxData["Parent"], "InlineFormula"],
 " class."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->373435199],

Cell["\<\
// C# code
Child c = new Child();
string s1 = c.Foo();             // s1 gets the value \"from child\"
string s2 = ((Parent) c).Foo();  // s2 gets the value \"from parent\"\
\>", "Program",
 CellTags->"nlug:3.2.5",
 CellID->7614],

Cell[TextData[{
 "The behavior is the same whether the ",
 Cell[BoxData[
  RowBox[{"Foo", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " method is declared ",
 Cell[BoxData["virtual"], "InlineFormula"],
 " or not in the ",
 Cell[BoxData["Parent"], "InlineFormula"],
 " class. Note that the ",
 Cell[BoxData["new"], "InlineFormula"],
 " keyword (",
 Cell[BoxData["Shadows"], "InlineFormula"],
 " in Visual Basic .NET) is not strictly required, although the compiler will \
generate a warning if it is left out."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->26598],

Cell[TextData[{
 "To call the ",
 Cell[BoxData["Parent"], "InlineFormula"],
 " class implementation of ",
 Cell[BoxData[
  RowBox[{"Foo", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " using ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", use ",
 Cell[BoxData[
  ButtonBox["CastNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CastNETObject"]], "InlineFormula"],
 " to cast the object to the ",
 Cell[BoxData["Parent"], "InlineFormula"],
 " class, exactly as was done in the C# code."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->17139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"child", "=", 
  RowBox[{"NETNew", "[", "\"\<Child\>\"", "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.5",
 CellLabel->"In[1]:=",
 CellID->29546],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]NETObject", "[", "\<\"Child\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$2067774557913089]], "Output",
 CellTags->"nlug:3.2.5",
 CellLabel->"Out[1]=",
 CellID->4762]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parentCast", "=", 
  RowBox[{"CastNETObject", "[", 
   RowBox[{"child", ",", "\"\<Parent\>\""}], "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.5",
 CellLabel->"In[2]:=",
 CellID->767],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]NETObject", "[", "\<\"Parent\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$2067774557913089]], "Output",
 CellTags->"nlug:3.2.5",
 CellLabel->"Out[2]=",
 CellID->26854]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parentCast", "@", 
  RowBox[{"Foo", "[", "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.5",
 CellLabel->"In[3]:=",
 CellID->28448],

Cell[BoxData[
 RowBox[{"from", " ", "parent"}]], "Output",
 CellTags->"nlug:3.2.5",
 CellLabel->"Out[3]=",
 CellID->23828]
}, Open  ]],

Cell["Of course the two references refer to the same object.", "Text",
 CellTags->"nlug:3.2.5",
 CellID->22530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SameObjectQ", "[", 
  RowBox[{"parentCast", ",", "child"}], "]"}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.5",
 CellLabel->"In[4]:=",
 CellID->1224],

Cell[BoxData["True"], "Output",
 CellTags->"nlug:3.2.5",
 CellLabel->"Out[4]=",
 CellID->8692]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Explicit Interface Implementation", "Subsection",
 CellTags->"nlug:3.2.5",
 CellID->11114],

Cell[TextData[{
 "If a class implements two interfaces that each have a method of the same \
name, it can choose to give each interface member a separate implementation. \
This is called ",
 StyleBox["explicit interface implementation",
  FontSlant->"Italic"],
 ". This technique is generally only used when the methods from the two \
interfaces are so different conceptually that there is no way to provide a \
single implementation that satisfies the contracts of both interfaces. Here \
is a simplified example from the .NET SDK documentation. The ",
 Cell[BoxData[
  ButtonBox["Box",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Box"]], "InlineFormula"],
 " class implements ",
 Cell[BoxData["IEnglishDimensions"], "InlineFormula"],
 " and ",
 Cell[BoxData["IMetricDimensions"], "InlineFormula"],
 ", which both have a ",
 Cell[BoxData[
  RowBox[{"Length", "(", ")"}]], "InlineFormula"],
 " method, and of course there is no single implementation of ",
 Cell[BoxData[
  RowBox[{"Length", "(", ")"}]], "InlineFormula"],
 " that can work for both interfaces."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->18887],

Cell["\<\
// C# code

interface IEnglishDimensions {
   double Length();
}

interface IMetricDimensions {
   double Length();
}

class Box : IEnglishDimensions, IMetricDimensions {

   double lengthInches;
   
   public Box(double length) {
      lengthInches = length;
   }
   
   // Explicitly implement for IEnglishDimensions:
   double IEnglishDimensions.Length() {
      return lengthInches;
   }

   // Explicitly implement for IMetricDimensions:
   double IMetricDimensions.Length() {
      return lengthInches * 2.54;
   }
}\
\>", "Program",
 CellTags->"nlug:3.2.5",
 CellID->25960],

Cell[TextData[{
 "Here is how you would call these methods. You must cast the ",
 Cell[BoxData[
  ButtonBox["Box",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Box"]], "InlineFormula"],
 " object to either the ",
 Cell[BoxData["IMetricDimensions"], "InlineFormula"],
 " or ",
 Cell[BoxData["IEnglishDimensions"], "InlineFormula"],
 " interface before you can call the ",
 Cell[BoxData[
  RowBox[{"Length", "(", ")"}]], "InlineFormula"],
 " method."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->31114],

Cell["\<\
Box myBox = new Box(30.0);
double englishLength = ((IEnglishDimensions) myBox).Length();
double metricLength = ((IMetricDimensions) myBox).Length();\
\>", "Program",
 CellTags->"nlug:3.2.5",
 CellID->26245],

Cell[TextData[{
 "Here is how you would do the same thing in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->18464],

Cell[BoxData[{
 RowBox[{
  RowBox[{"myBox", "=", 
   RowBox[{"NETNew", "[", "\"\<Box\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"englishLength", "=", 
   RowBox[{
    RowBox[{"CastNETObject", "[", 
     RowBox[{"myBox", ",", "\"\<IEnglishDimensions\>\""}], "]"}], "@", 
    RowBox[{"Length", "[", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"metricLength", "=", 
   RowBox[{
    RowBox[{"CastNETObject", "[", 
     RowBox[{"myBox", ",", "\"\<IMetricDimensions\>\""}], "]"}], "@", 
    RowBox[{"Length", "[", "]"}]}]}], ";"}]}], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.5",
 CellID->31643],

Cell[TextData[{
 "Here is a real-world example. The ",
 Cell[BoxData[
  ButtonBox["Array",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Array"]], "InlineFormula"],
 " class (which is the parent class for all arrays in .NET) uses explicit \
interface implementation for methods from the ",
 Cell[BoxData["IList"], "InlineFormula"],
 " interface. If a class uses explicit interface implementation for some of \
its methods this should be mentioned clearly in the documentation, and this \
is true for the ",
 Cell[BoxData[
  ButtonBox["Array",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Array"]], "InlineFormula"],
 " class. One method from the ",
 Cell[BoxData["IList"], "InlineFormula"],
 " interface is ",
 Cell[BoxData[
  RowBox[{"Contains", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ". You cannot call this directly on an array object, even though ",
 Cell[BoxData[
  ButtonBox["Array",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Array"]], "InlineFormula"],
 " implements ",
 Cell[BoxData["IList"], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->8819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"arr", "=", 
  RowBox[{"MakeNETObject", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "6", ",", "8"}], "}"}], "]"}]}]], "Input",
 CellTags->"nlug:3.2.5",
 CellLabel->"In[6]:=",
 CellID->19326],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]NETObject", "[", "\<\"System.Int32[]\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$100663297]], "Output",
 CellTags->"nlug:3.2.5",
 CellLabel->"Out[6]=",
 CellID->4948]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"arr", "@", 
  RowBox[{"Contains", "[", "6", "]"}]}]], "Input",
 CellTags->"nlug:3.2.5",
 CellLabel->"In[9]:=",
 CellID->3188015],

Cell[BoxData[
 RowBox[{
  RowBox[{"NET", "::", "\<\"nomethod\"\>"}], ":", 
  " ", "\<\"No public instance method named Contains exists for the .NET type \
System.Int32[].\"\>"}]], "Message", "MSG",
 CellTags->"nlug:3.2.5",
 CellLabel->"From In[9]:=",
 CellID->1863],

Cell[BoxData["$Failed"], "Output",
 CellTags->"nlug:3.2.5",
 CellLabel->"Out[9]=",
 CellID->15970]
}, Open  ]],

Cell[TextData[{
 "It works if you cast to ",
 Cell[BoxData["IList"], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->21455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CastNETObject", "[", 
   RowBox[{"arr", ",", "\"\<System.Collections.IList\>\""}], "]"}], "@", 
  RowBox[{"Contains", "[", "6", "]"}]}]], "Input",
 CellTags->"nlug:3.2.5",
 CellLabel->"In[10]:=",
 CellID->23360],

Cell[BoxData["True"], "Output",
 CellTags->"nlug:3.2.5",
 CellLabel->"Out[10]=",
 CellID->17908]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Private Class, Public Interface", "Subsection",
 CellTags->"nlug:3.2.5",
 CellID->14898],

Cell[TextData[{
 "A final case where upcasting is necessary in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " can occur when you have a method that is typed to return an interface, and \
the implementation of the method returns an object of a  ",
 StyleBox["non-public",
  FontSlant->"Italic"],
 " class that implements that interface. This is perfectly legal, but it can \
cause problems for ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ". When you reflect on a non-public class to obtain all its public members \
(",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " calls all methods via reflection), you only see the methods that are \
implemented by some public parent class. Just because a class implements a \
public interface does not mean that you can call those methods on an instance \
of that class. If the class itself is not public, even though its methods are \
public, you can call them only on an instance of the class that is typed as a \
public parent class or interface."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->23063],

Cell[TextData[{
 "This may sound confusing, so consider the following example. Assume an \
interface called ",
 Cell[BoxData["IFoo"], "InlineFormula"],
 " and an internal class that implements ",
 Cell[BoxData["IFoo"], "InlineFormula"],
 " (internal classes are visible only to other types within the same \
assembly)."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->30584],

Cell["\<\
interface IFoo {
\tint Foo();
}

internal class InternalIFooImpl : IFoo {
\tpublic int Foo() { return 42; }
}\
\>", "Program",
 CellTags->"nlug:3.2.5",
 CellID->3925],

Cell[TextData[{
 "Now assume there is some other class that has a method type to return ",
 Cell[BoxData["IFoo"], "InlineFormula"],
 " that returns an instance of the ",
 Cell[BoxData["InternalIFooImpl"], "InlineFormula"],
 " class."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->558],

Cell["\<\
public class FooFactory {
\tpublic static IFoo CreateIFoo() { return new InternalIFooImpl(); }
}\
\>", "Program",
 CellTags->"nlug:3.2.5",
 CellID->6914],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadNETType", "[", "\"\<FooFactory\>\"", "]"}], ";"}], "\n", 
 RowBox[{"foo", "=", 
  RowBox[{"FooFactory`CreateIFoo", "[", "]"}]}]}], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.5",
 CellLabel->"In[1]:=",
 CellID->23130],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", "[", "\<\"InternalIFooImpl\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$2067774557913089]], "Output",
 CellTags->"nlug:3.2.5",
 CellLabel->"Out[2]=",
 CellID->9479]
}, Open  ]],

Cell[TextData[{
 "It doesn\[CloseCurlyQuote]t work to call the ",
 Cell[BoxData[
  RowBox[{"Foo", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " method on the ",
 Cell[BoxData["foo"], "InlineFormula"],
 " object because it is typed as a non-public class. "
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->30803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"foo", "@", 
  RowBox[{"Foo", "[", "]"}]}]], "Input",
 CellTags->"nlug:3.2.5",
 CellLabel->"In[3]:=",
 CellID->15399],

Cell[BoxData[
 RowBox[{
  RowBox[{"NET", "::", "\<\"nomethod\"\>"}], ":", 
  " ", "\<\"No public instance method named Foo exists for the .NET type \
InternalIFooImpl.\"\>"}]], "Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellTags->"nlug:3.2.5",
 CellLabel->"From In[3]:=",
 CellID->28785],

Cell[BoxData["$Failed"], "Output",
 CellTags->"nlug:3.2.5",
 CellLabel->"Out[3]=",
 CellID->27000]
}, Open  ]],

Cell[TextData[{
 "The error message isn\[CloseCurlyQuote]t very accurate \
above\[LongDash]there ",
 StyleBox["is",
  FontSlant->"Italic"],
 " a public method named ",
 Cell[BoxData[
  RowBox[{"Foo", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " in the ",
 Cell[BoxData["InternalIFooImpl"], "InlineFormula"],
 " class, it just cannot be seen via reflection because the class itself is \
not public. This sort of thing never shows up in C# or Visual Basic .NET \
because the variable that holds the result of ",
 Cell[BoxData[
  RowBox[{"CreateIFoo", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " will be typed as the public interface ",
 Cell[BoxData["IFoo"], "InlineFormula"],
 ". The programmer would never have any reason to see or even know about the \
",
 Cell[BoxData["InternalIFooImpl"], "InlineFormula"],
 " class. The code looks like the following."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->15651],

Cell["\<\
// C# code
IFoo foo = FooFactory`CreateIFoo();
int result = foo.Foo();\
\>", "Program",
 CellTags->"nlug:3.2.5",
 CellID->17554],

Cell[TextData[{
 "In ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", however, objects are seen by default as their true runtime types, so we \
end up with an instance of an object that is typed as a non-public class. The \
solution is to do what is done in C# and Visual Basic .NET: upcast the object \
to the ",
 Cell[BoxData["IFoo"], "InlineFormula"],
 " interface."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->10980],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ifoo", "=", 
   RowBox[{"CastNETObject", "[", 
    RowBox[{"foo", ",", "\"\<IFoo\>\""}], "]"}]}], ";"}], "\n", 
 RowBox[{"ifoo", "@", 
  RowBox[{"Foo", "[", "]"}]}]}], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.5",
 CellLabel->"In[3]:=",
 CellID->13888],

Cell[BoxData["42"], "Output",
 CellTags->"nlug:3.2.5",
 CellLabel->"Out[4]=",
 CellID->31908]
}, Open  ]],

Cell[TextData[{
 "The \[OpenCurlyDoubleQuote]factory\[CloseCurlyDoubleQuote] design pattern \
in the above example is relatively common. A special object-creation method \
returns objects typed only as some interface. This allows the designer of the \
library to document an interface only, and hide the implementation details in \
private classes. Clients of the library write only to the interface and are \
kept completely isolated from details like the actual names of the \
implementation classes. This suggests that the need for upcasting a \
non-public class to an interface type would not be rare for ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " programmers. In practice, however, it is often the case that the \
non-public class inherits implementations of at least some of its methods \
from a public parent class. If this is the case, these methods will be found \
and can be invoked on the non-public child class without casting."
}], "Text",
 CellTags->"nlug:3.2.5",
 CellID->17852]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Indexers", "Section",
 CellTags->"nlug:3.2.6",
 CellID->24524],

Cell[TextData[{
 "Some .NET classes define a special member that permits instances of the \
class to be accessed in the same way as arrays. This special member is called \
an ",
 StyleBox["indexer",
  FontSlant->"Italic"],
 " in C# terminology, and a ",
 StyleBox["default parameterized property",
  FontSlant->"Italic"],
 " in Visual Basic .NET terminology. Here are skeleton definitions of example \
members in C# and Visual Basic .NET."
}], "Text",
 CellTags->"nlug:3.2.6",
 CellID->18442],

Cell["\<\
// C# indexer
public int this(int i) {
\tget { ... }
\tset { ... }
}

// VB default parameterized property
Default Public Property Item(ByVal i As Integer) As Integer
    Get
    \t...
    End Get
    Set(ByVal Value As Integer)
    \t...
    End Set
End Property\
\>", "Program",
 CellTags->"nlug:3.2.6",
 CellID->21154],

Cell[TextData[{
 "Indexers allow a class to act as if it were an array even though it is not. \
Most of the .NET collection classes (classes that implement the ",
 StyleBox["ICollection", "MR"],
 " interface) support an indexer so that elements can be set and retrieved \
using a simple array-like syntax. If a class had a definition like one of the \
above, you could access the \[OpenCurlyDoubleQuote]",
 StyleBox["i",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " element\[CloseCurlyDoubleQuote] using code like the following."
}], "Text",
 CellTags->"nlug:3.2.6",
 CellID->19217],

Cell["\<\
// C#
int firstElement = obj[0];

' VB
firstElement = obj(0)\
\>", "Program",
 CellTags->"nlug:3.2.6",
 CellID->12940],

Cell[TextData[{
 "If a class defines an indexer, you can call the indexer in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using function brackets."
}], "Text",
 CellTags->"nlug:3.2.6",
 CellID->32112],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Call", " ", "indexer"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"firstElement", "=", 
    RowBox[{"obj", "[", "0", "]"}]}], ";"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.6",
 CellID->32184],

Cell[TextData[{
 "Note that there is no method or property name in the above \
code\[LongDash]just an \
\[OpenCurlyDoubleQuote]argument\[CloseCurlyDoubleQuote] to the object itself, \
as if it were a function. It could be argued that ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 "-based syntax (i.e., using ",
 StyleBox["obj[[0]]", "MR"],
 ") would be more suitable for calling indexers in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", as it is the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " equivalent of array access, but that syntax was rejected for various \
philosophical and technical reasons."
}], "Text",
 CellTags->"nlug:3.2.6",
 CellID->27449],

Cell[TextData[{
 "Here is another example of calling an indexer using the ",
 StyleBox["BitArray", "MR"],
 " class, which is a collection of true/false values that is stored in a very \
compact way. This class defines an indexer so that it can be treated like an \
array."
}], "Text",
 CellTags->"nlug:3.2.6",
 CellID->25628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bitArray", "=", 
  RowBox[{"NETNew", "[", 
   RowBox[{"\"\<System.Collections.BitArray\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False", ",", "True"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"nlug:3.2.6",
 CellLabel->"In[1]:=",
 CellID->20463],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", "[", "\<\"System.Collections.BitArray\"\>", 
    "]"}], "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$100663297]], "Output",
 CellTags->"nlug:3.2.6",
 CellLabel->"Out[1]=",
 CellID->30963]
}, Open  ]],

Cell["\<\
This calls the indexer to get the second element (because it is a zero-based \
index).\
\>", "Text",
 CellTags->"nlug:3.2.6",
 CellID->10397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bitArray", "[", "1", "]"}]], "Input",
 CellTags->"nlug:3.2.6",
 CellLabel->"In[2]:=",
 CellID->2287],

Cell[BoxData["False"], "Output",
 CellTags->"nlug:3.2.6",
 CellLabel->"Out[2]=",
 CellID->3000]
}, Open  ]],

Cell[TextData[{
 "If you write a class in C# and give it an indexer, the compiler creates a \
public property named ",
 StyleBox["Item", "MR"],
 " for you. This is a parameterized property, meaning that it takes an \
argument like a method call. The indexer syntax is just a shorthand for \
calling the ",
 StyleBox["Item", "MR"],
 " property. If you are writing in Visual Basic .NET, the convention is that \
your default parameterized property should be named ",
 StyleBox["Item", "MR"],
 ", but this is not a requirement. Whatever the default parameterized \
property is named, you can skip the indexer-style syntax and call the ",
 "property",
 " directly from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " if you wish."
}], "Text",
 CellTags->"nlug:3.2.6",
 CellID->786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bitArray", "@", 
  RowBox[{"Item", "[", "1", "]"}]}]], "Input",
 CellTags->"nlug:3.2.6",
 CellLabel->"In[3]:=",
 CellID->7443],

Cell[BoxData["False"], "Output",
 CellTags->"nlug:3.2.6",
 CellLabel->"Out[3]=",
 CellID->4438]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exceptions", "Section",
 CellTags->{"Exceptions", "nlug:3.2.7"},
 CellID->4946],

Cell[CellGroupData[{

Cell["How Exceptions Are Handled", "Subsection",
 CellTags->"nlug:3.2.7",
 CellID->11921],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " handles .NET exceptions automatically. If an uncaught exception is thrown \
during any call into .NET, you will get a message in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Here is an example that tries to format a real number as an integer."
}], "Text",
 CellTags->"nlug:3.2.7",
 CellID->21680],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadNETType", "[", "\"\<System.Int32\>\"", "]"}], ";"}], "\n", 
 RowBox[{"Int32`Parse", "[", "\"\<1234.5\>\"", "]"}]}], "Input",
 CellTags->"nlug:3.2.7",
 CellLabel->"In[26]:=",
 CellID->14636],

Cell[BoxData[
 RowBox[{
  RowBox[{"NET", "::", "\<\"netexcptn\"\>"}], ":", 
  " ", "\<\"A .NET exception occurred: System.FormatException: Input string \
was not in a correct format.\\n   at System.Number.ParseInt32(String s, \
NumberStyles style, NumberFormatInfo info)\\n   at System.Int32.Parse(String \
s, NumberStyles style, IFormatProvider provider)\\n   at \
System.Int32.Parse(String s).\"\>"}]], "Message", "MSG",
 CellTags->"nlug:3.2.7",
 CellLabel->"From In[26]:=",
 CellID->3036],

Cell[BoxData["$Failed"], "Output",
 CellTags->"nlug:3.2.7",
 CellLabel->"Out[27]=",
 CellID->17745]
}, Open  ]],

Cell[TextData[{
 "If an exception is thrown, the result of the call will be ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.2.7",
 CellID->11925],

Cell[TextData[{
 "If the .NET code was compiled with debugging information included, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " message you get as a result of an exception will show the full stack trace \
to the point where the exception occurred, with the exact line numbers in \
each file."
}], "Text",
 CellTags->"nlug:3.2.7",
 CellID->29523]
}, Open  ]],

Cell[CellGroupData[{

Cell["GetNETException", "Subsection",
 CellTags->"nlug:3.2.7",
 CellID->7976],

Cell[TextData[{
 "You can use the function ",
 Cell[BoxData[
  ButtonBox["GetNETException",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/GetNETException"]], "InlineFormula"],
 " to get the ",
 StyleBox["Exception", "MR"],
 " object for the exception thrown in the last call from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to .NET. It returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " if no exception was thrown. Most programmers will have no use for this \
function, but you could use it to implement a special exception-handling \
feature in your programs. Below you see the exception thrown by the previous \
call to ",
 StyleBox["Int32.Parse()", "MR"],
 ". You can see that most exceptions that occur will come back wrapped in a \
special ",
 Cell[BoxData["CallNETException"], "InlineFormula"],
 " object that wraps the actual exception thrown using the standard .NET \
design pattern for \[OpenCurlyDoubleQuote]inner exceptions\
\[CloseCurlyDoubleQuote]."
}], "Text",
 CellTags->"nlug:3.2.7",
 CellID->31342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exc", "=", 
  RowBox[{"GetNETException", "[", "]"}]}]], "Input",
 CellTags->"nlug:3.2.7",
 CellLabel->"In[28]:=",
 CellID->9599],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", 
    "[", "\<\"Wolfram.NETLink.Internal.CallNETException\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$369098753]], "Output",
 CellTags->"nlug:3.2.7",
 CellLabel->"Out[28]=",
 CellID->8724]
}, Open  ]],

Cell[TextData[{
 "To get the actual exception thrown, you must examine the ",
 StyleBox["InnerException", "MR"],
 " property."
}], "Text",
 CellTags->"nlug:3.2.7",
 CellID->21929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"innerExc", "=", 
  RowBox[{"exc", "@", "InnerException"}]}]], "Input",
 CellTags->"nlug:3.2.7",
 CellLabel->"In[29]:=",
 CellID->5851],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", 
    "[", "\<\"System.Reflection.TargetInvocationException\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$385875969]], "Output",
 CellTags->"nlug:3.2.7",
 CellLabel->"Out[29]=",
 CellID->30628]
}, Open  ]],

Cell["\<\
In this example the .NET reflection system has wrapped the exception in \
another exception, so you have to dig one level deeper to see the \
\[OpenCurlyDoubleQuote]real\[CloseCurlyDoubleQuote] one.\
\>", "Text",
 CellTags->"nlug:3.2.7",
 CellID->32667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"innerExc", "@", "InnerException"}]], "Input",
 CellTags->"nlug:3.2.7",
 CellLabel->"In[30]:=",
 CellID->25198],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", "[", "\<\"System.FormatException\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$402653185]], "Output",
 CellTags->"nlug:3.2.7",
 CellLabel->"Out[30]=",
 CellID->7357]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Custom Exception Handling", "Subsection",
 CellTags->"nlug:3.2.7",
 CellID->3241],

Cell[TextData[{
 "Very advanced programmers might want to implement their own system for \
exception handling and/or reporting. For example, you might want to use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " functions to handle .NET exceptions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code, using the same programming style that is used in .NET languages. An \
even simpler example is the desire to silence exception messages in a certain \
block of code."
}], "Text",
 CellTags->"nlug:3.2.7",
 CellID->19150],

Cell[TextData[{
 "To implement custom handling for .NET exceptions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", use the symbol ",
 Cell[BoxData[
  ButtonBox["$NETExceptionHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/$NETExceptionHandler"]], "InlineFormula"],
 ". The value of ",
 Cell[BoxData[
  ButtonBox["$NETExceptionHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/$NETExceptionHandler"]], "InlineFormula"],
 " is treated as a function that will be passed three arguments: the symbol \
associated with the message (this will usually be the symbol ",
 StyleBox["NET", "MR"],
 "), the message tag (this will typically be the string \
\[OpenCurlyDoubleQuote]netexcptn\[CloseCurlyDoubleQuote]), and the \
descriptive string of text associated with the message."
}], "Text",
 CellTags->"nlug:3.2.7",
 CellID->26452],

Cell[TextData[{
 "You will usually set ",
 Cell[BoxData[
  ButtonBox["$NETExceptionHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/$NETExceptionHandler"]], "InlineFormula"],
 " within a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"], "MR"]], "InlineFormula"],
 " so that its effect will be limited to a precisely defined segment of code, \
as in the following example that silences messages."
}], "Text",
 CellTags->"nlug:3.2.7",
 CellID->19149],

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$NETExceptionHandler", "=", 
     RowBox[{"Null", "&"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"obj", "@", 
    RowBox[{"Method", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellTags->"nlug:3.2.7",
 CellID->31600],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["GetNETException",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/GetNETException"]], "InlineFormula"],
 " within your handler function to obtain the actual .NET exception object \
that was thrown. Here is an example."
}], "Text",
 CellTags->"nlug:3.2.7",
 CellID->1491],

Cell["\<\
   exceptionThrower = Throw[GetNETException[]]&;

   Block[{$NETExceptionHandler = exceptionThrower},
      ... code that calls .NET ...
   ]\
\>", "Input",
 CellTags->"nlug:3.2.7",
 CellID->18811],

Cell[TextData[{
 "You should avoid setting ",
 Cell[BoxData[
  ButtonBox["$NETExceptionHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/$NETExceptionHandler"]], "InlineFormula"],
 " outside of a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"], "MR"]], "InlineFormula"],
 ", as you are almost sure to inadvertently create situations where its value \
does not get cleared, leaving users scratching their heads wondering why \
their exceptions are not being handled like they expect."
}], "Text",
 CellTags->"nlug:3.2.7",
 CellID->28414]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nested Types", "Section",
 CellTags->"nlug:3.2.8",
 CellID->25949],

Cell["\<\
Some .NET types have declarations of other types nested within them. Here is \
an example in C#.\
\>", "Text",
 CellTags->"nlug:3.2.8",
 CellID->12926],

Cell["\<\
namespace SomeNamespace {
\t
\tpublic class Outer {
\t
\t\tpublic int Foo() { return 42; }
\t\tpublic static int StaticFoo() { return 42; }
\t\t
\t\tpublic class Inner {
\t\t\tpublic int InnerFoo() { return 42; }
\t\t\tpublic static int StaticInnerFoo() { return 42; }
\t\t}
\t}
}\
\>", "Program",
 CellTags->"nlug:3.2.8",
 CellID->224963599],

Cell[TextData[{
 "In .NET, the ",
 StyleBox["+", "MR"],
 " character is used in a type name to separate the name of an inner class \
from its outer class. In the above example, the actual type name of the ",
 StyleBox["Inner", "MR"],
 " class is ",
 StyleBox["SomeNamespace.Outer+Inner", "MR"],
 ". This is the name you must use in ",
 Cell[BoxData[
  ButtonBox["LoadNETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.2.8",
 CellID->21591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"innerClass", "=", 
  RowBox[{
  "LoadNETType", "[", "\"\<SomeNamespace.Outer+Inner\>\"", "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.8",
 CellLabel->"In[1]:=",
 CellID->12848],

Cell[BoxData[
 RowBox[{"NETType", "[", 
  RowBox[{"\<\"SomeNamespace.Outer+Inner\"\>", ",", "25"}], "]"}]], "Output",
 CellTags->"nlug:3.2.8",
 CellLabel->"Out[1]=",
 CellID->5035]
}, Open  ]],

Cell[TextData[{
 "You also use type names in ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 ". Here is how you construct an instance of the ",
 StyleBox["Inner", "MR"],
 " class."
}], "Text",
 CellTags->"nlug:3.2.8",
 CellID->17691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"innerObj", "=", 
  RowBox[{
  "NETNew", "[", "\"\<SomeNamespace.Outer+Inner\>\"", "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.8",
 CellLabel->"In[2]:=",
 CellID->6744],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", "[", "\<\"SomeNamespace.Outer+Inner\"\>", 
    "]"}], "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$436207618]], "Output",
 CellTags->"nlug:3.2.8",
 CellLabel->"Out[2]=",
 CellID->23658]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["+", "MR"],
 " character only appears in type ",
 StyleBox["names",
  FontSlant->"Italic"],
 ". When referring to a nested type in ",
 StyleBox["code",
  FontSlant->"Italic"],
 ", use the standard scope resolution operator (the period in C# and Visual \
Basic .NET) to separate the inner class from the outer class."
}], "Text",
 CellTags->"nlug:3.2.8",
 CellID->5512],

Cell["\<\
// C# code
Outer.Inner obj = new Outer.Inner();\
\>", "Program",
 CellTags->"nlug:3.2.8",
 CellID->24098],

Cell[TextData[{
 "Although most .NET languages allow the above syntax for nested types, keep \
in mind that the actual type names use the ",
 StyleBox["+", "MR"],
 " character to separate the inner type from the outer one. In ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", whenever you enter a type name ",
 StyleBox["as a string",
  FontSlant->"Italic"],
 ", you must use the ",
 StyleBox["+", "MR"],
 " notation."
}], "Text",
 CellTags->"nlug:3.2.8",
 CellID->4772],

Cell["\<\
You call instance methods on objects of nested types in the usual way.\
\>", "Text",
 CellTags->"nlug:3.2.8",
 CellID->19355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"innerObj", "@", 
  RowBox[{"InnerFoo", "[", "]"}]}]], "Input",
 CellTags->"nlug:3.2.8",
 CellLabel->"In[3]:=",
 CellID->22771],

Cell[BoxData["42"], "Output",
 CellTags->"nlug:3.2.8",
 CellLabel->"Out[3]=",
 CellID->5409]
}, Open  ]],

Cell[TextData[{
 "Here is how to call a static member. Notice that as in C# and Visual Basic \
.NET, the ",
 StyleBox["+", "MR"],
 " character disappears and is replaced by the scope resolution operator (",
 StyleBox["`", "MR"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ")."
}], "Text",
 CellTags->"nlug:3.2.8",
 CellID->19753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer`Inner`StaticInnerFoo", "[", "]"}]], "Input",
 CellTags->"nlug:3.2.8",
 CellLabel->"In[4]:=",
 CellID->21448],

Cell[BoxData["42"], "Output",
 CellTags->"nlug:3.2.8",
 CellLabel->"Out[4]=",
 CellID->5745]
}, Open  ]],

Cell[TextData[{
 "Another point to note about the above line is that you cannot refer to a \
static member of a nested class using simply the inner class name, as in ",
 StyleBox["Inner`StaticInnerFoo[", "MR"],
 StyleBox["]", "MR"],
 ". This is to be expected, since you cannot do this in other .NET languages \
either. You always need to prefix the inner class name with the outer one."
}], "Text",
 CellTags->"nlug:3.2.8",
 CellID->25304],

Cell[TextData[{
 "Here is a real-world example. The ",
 StyleBox["System.Environment", "MR"],
 " class has a nested enum called ",
 StyleBox["SpecialFolder", "MR"],
 ". This enum contains constants that designate special locations within the \
Windows operating system (it has values that include ",
 StyleBox["ProgramFiles", "MR"],
 ", ",
 StyleBox["Recent", "MR"],
 ", ",
 StyleBox["System", "MR"],
 ", ",
 StyleBox["StartMenu", "MR"],
 ", and so on). Here is how to determine the path to the user\
\[CloseCurlyQuote]s Favorites folder. You need to call static members from \
the ",
 StyleBox["System.Environment", "MR"],
 " class and the ",
 StyleBox["System.Environment.SpecialFolder", "MR"],
 " enum (members of an enum are static), so first you load these two types. \
Note the ",
 StyleBox["+", "MR"],
 " in the type name."
}], "Text",
 CellTags->"nlug:3.2.8",
 CellID->14512],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadNETType", "[", "\"\<System.Environment\>\"", "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
  "LoadNETType", "[", "\"\<System.Environment+SpecialFolder\>\"", "]"}], 
  ";"}]}], "Input",
 CellTags->"nlug:3.2.8",
 CellLabel->"In[5]:=",
 CellID->23916],

Cell[TextData[{
 "The ",
 StyleBox["GetFolderPath()", "MR"],
 " method takes members of the ",
 StyleBox["SpecialFolder", "MR"],
 " enumeration and gets the appropriate path as a string. Note how we refer \
to the ",
 StyleBox["Favorites", "MR"],
 " member of the ",
 StyleBox["SpecialFolder", "MR"],
 " enum."
}], "Text",
 CellTags->"nlug:3.2.8",
 CellID->13855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Environment`GetFolderPath", "[", 
  "Environment`SpecialFolder`Favorites", "]"}]], "Input",
 CellTags->"nlug:3.2.8",
 CellLabel->"In[7]:=",
 CellID->27198],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\tgayley\\\\Favorites\"\>"], \
"Output",
 CellTags->"nlug:3.2.8",
 CellLabel->"Out[7]=",
 CellID->6762]
}, Open  ]],

Cell[TextData[{
 "In summary, the important point to remember about nested types is that when \
you need to refer to the name of one in a ",
 StyleBox["string",
  FontSlant->"Italic"],
 ", you use the ",
 StyleBox["+", "MR"],
 " character to separate the outer type from the inner type. When you refer \
to a type in ",
 StyleBox["code",
  FontSlant->"Italic"],
 ", you go back to using the familiar ",
 StyleBox["`", "MR"],
 " to separate the outer and inner names."
}], "Text",
 CellTags->"nlug:3.2.8",
 CellID->20157]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeNETObject", "Section",
 CellTags->"nlug:3.2.9",
 CellID->17016],

Cell[TextData[{
 "The most common way to create a .NET object is to call a constructor via ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 ". Sometimes, however, you have a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression that you want to convert into a .NET object but the class does \
not have a convenient constructor. A common example is if you want to create \
an array object out of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list. You can call an array constructor via ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 ", but you cannot initialize the array with values via the constructor. This \
example creates an array object with ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 " and fills it manually."
}], "Text",
 CellTags->"nlug:3.2.9",
 CellID->18664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"intArray", "=", 
  RowBox[{"NETNew", "[", 
   RowBox[{"\"\<System.Int32[]\>\"", ",", "3"}], "]"}]}]], "Input",
 CellTags->"nlug:3.2.9",
 CellLabel->"In[1]:=",
 CellID->9859],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]NETObject", "[", "\<\"System.Int32[]\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$234881025]], "Output",
 CellTags->"nlug:3.2.9",
 CellLabel->"Out[1]=",
 CellID->22686]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"intArray", "[", 
   RowBox[{"SetValue", "[", 
    RowBox[{"42", ",", "0"}], "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"intArray", "[", 
   RowBox[{"SetValue", "[", 
    RowBox[{"43", ",", "1"}], "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"intArray", "[", 
   RowBox[{"SetValue", "[", 
    RowBox[{"44", ",", "2"}], "]"}], "]"}], ";"}]}], "Input",
 CellTags->"nlug:3.2.9",
 CellLabel->"In[2]:=",
 CellID->18551],

Cell[TextData[{
 "You can do this much more easily using ",
 Cell[BoxData[
  ButtonBox["MakeNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/MakeNETObject"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.2.9",
 CellID->29087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"intArray2", "=", 
  RowBox[{"MakeNETObject", "[", 
   RowBox[{"{", 
    RowBox[{"42", ",", "43", ",", "44"}], "}"}], "]"}]}]], "Input",
 CellTags->"nlug:3.2.9",
 CellLabel->"In[5]:=",
 CellID->10872],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]NETObject", "[", "\<\"System.Int32[]\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$251658241]], "Output",
 CellTags->"nlug:3.2.9",
 CellLabel->"Out[5]=",
 CellID->18345]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MakeNETObject",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/MakeNETObject"], "[", 
     StyleBox["val", "TI"], "]"}], Cell[TextData[{
     "construct an object of the appropriate type to represent the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression ",
     StyleBox["val", "TI"],
     " (numbers, strings, list, and so on)."
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MakeNETObject",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/MakeNETObject"], "[", 
     RowBox[{
      StyleBox["val", "TI"], ",", 
      StyleBox["type", "TI"]}], "]"}], Cell[
    "construct an object of the specified type", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.2.9",
 CellID->10963],

Cell[TextData[{
 StyleBox["MakeNETObject", "MR"],
 "."
}], "Caption",
 CellTags->"nlug:3.2.9",
 CellID->23376],

Cell[TextData[{
 "Keep in mind that you rarely have to call ",
 Cell[BoxData[
  ButtonBox["MakeNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/MakeNETObject"]], "InlineFormula"],
 ". When you call a method that takes an array, for example, you can just \
pass a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list and ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " will create the .NET array for you. There are times, however, when you \
want to explicitly create a .NET object that must be populated with data from \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and there is no convenient constructor. An example of a circumstance where \
",
 Cell[BoxData[
  ButtonBox["MakeNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/MakeNETObject"]], "InlineFormula"],
 " is useful is the following method, which reverses a list passed in as an \
argument. Note that it does not return the reversed list, but rather reverses \
it in place."
}], "Text",
 CellTags->"nlug:3.2.9",
 CellID->23901],

Cell["public static void ReverseArray(int[] a);", "Program",
 CellTags->"nlug:3.2.9",
 CellID->30813],

Cell[TextData[{
 "You could call this method with a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list, but there would be no way to get back the reversed list. The way \
around this problem is to create an array object populated with the initial \
list values, pass the object reference, let its internal data be reversed, \
and then convert the object reference back to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list."
}], "Text",
 CellTags->"nlug:3.2.9",
 CellID->28889],

Cell[BoxData[
 RowBox[{"MyClass`ReverseArray", "[", "intArray2", "]"}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.9",
 CellLabel->"In[7]:=",
 CellID->25632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NETObjectToExpression", "[", "intArray2", "]"}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.9",
 CellLabel->"In[8]:=",
 CellID->2188],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"44", ",", "43", ",", "42"}], "}"}]], "Output",
 CellTags->"nlug:3.2.9",
 CellLabel->"Out[8]=",
 CellID->9012]
}, Open  ]],

Cell[TextData[{
 "Another case where is useful is if you need to give ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " a little help in choosing the correct signature of an overloaded method. \
Consider the following two overloads of a method."
}], "Text",
 CellTags->"nlug:3.2.9",
 CellID->29539],

Cell["\<\
public void Foo(byte b);
public void Foo(long l);\
\>", "Program",
 CellTags->"nlug:3.2.9",
 CellID->14990],

Cell[TextData[{
 "If you called ",
 StyleBox["Foo()", "MR"],
 " from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with an integer, the overload with the ",
 StyleBox["long", "MR"],
 " parameter would be called. This is because ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " generally tries to call the method with the widest possible type at each \
slot (but there is no formal guarantee, especially in complicated cases). If \
you want to call the ",
 StyleBox["byte", "MR"],
 " version, you can do this by creating a .NET object of the ",
 StyleBox["Byte", "MR"],
 " type, because ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " always gives preference to a method signature that is an exact match for \
the incoming argument types."
}], "Text",
 CellTags->"nlug:3.2.9",
 CellID->13657],

Cell[BoxData[
 RowBox[{"obj", "@", 
  RowBox[{"Foo", "[", 
   RowBox[{"MakeNETObject", "[", 
    RowBox[{"42", ",", "\"\<System.Byte\>\""}], "]"}], "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.9",
 CellID->11718],

Cell[TextData[{
 "Remember that ",
 Cell[BoxData[
  ButtonBox["MakeNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/MakeNETObject"]], "InlineFormula"],
 " is a rarely used function. You do not need to explicitly construct .NET \
objects from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " strings, arrays, and so on, just to pass them to .NET methods\[LongDash]",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " does this automatically for you. There are a few special circumstances \
outlined above where it is useful."
}], "Text",
 CellTags->"nlug:3.2.9",
 CellID->15615]
}, Open  ]],

Cell[CellGroupData[{

Cell["Complex Numbers", "Section",
 CellTags->"nlug:3.2.10",
 CellID->21660],

Cell[TextData[{
 ".NET number types (e.g., ",
 StyleBox["byte", "MR"],
 ", ",
 StyleBox["int", "MR"],
 ", ",
 StyleBox["double", "MR"],
 ") are returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as integers and reals, and integers and reals are converted to the \
appropriate types when sent as arguments to .NET. What about complex numbers? \
It would be nice to have a .NET type representing complex numbers that mapped \
directly to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " type, so that automatic conversions would occur as they were passed back \
and forth between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and .NET. .NET does not have a standard type for complex numbers, so ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " lets you name the type that you want to participate in this mapping."
}], "Text",
 CellTags->"nlug:3.2.10",
 CellID->27829],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SetComplexType",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/SetComplexType"], "[", "\"\<\!\(\*
StyleBox[\"classname\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "set the class to be mapped to complex numbers in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GetComplexType",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/GetComplexType"], "[", "]"}], Cell[
    "return the class currently used for complex numbers", "TableText"]}
  }]], "DefinitionBox",
 CellID->1790203360],

Cell["Setting the type for complex numbers.", "Caption",
 CellID->1701977050],

Cell["\<\
You can use any class or struct you like as long as it has the following \
properties:\
\>", "Text",
 CellTags->"nlug:3.2.10",
 CellID->17065],

Cell["\<\
A public constructor that takes two doubles or two floats (the real and \
imaginary parts, in that order)\
\>", "ItemizedText",
 CellTags->"nlug:3.2.10",
 CellID->29881],

Cell[CellGroupData[{

Cell["\<\
Public methods, properties, or fields for the real and imaginary parts, \
having one of the following signatures:\
\>", "ItemizedText",
 CellTags->"nlug:3.2.10",
 CellID->16474],

Cell[TextData[{
 StyleBox["One of:\n",
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\tdouble Re()\n\tdouble Real()\n\tfloat Re()\n\tfloat Real()\n\n",
 StyleBox["And one of:",
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["\n",
  FontFamily->"Times New Roman"],
 "\n\tdouble Im()\n\tdouble Imag()\n\tdouble Imaginary()\n\tfloat Im()\n\t\
float Imag()\n\tfloat Imaginary()\n\n",
 StyleBox["Or a property or field:",
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["\n",
  FontFamily->"Times New Roman"],
 "\n\tdouble Re\n\tdouble Real\n\tfloat Re\n\tfloat Real\n\n",
 StyleBox["And one of:",
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["\n",
  FontFamily->"Times New Roman"],
 "\n\tdouble Im\n\tdouble Imag\n\tdouble Imaginary\n\tfloat Im\n\tfloat Imag\n\
\tfloat Imaginary"
}], "Program",
 CellTags->"nlug:3.2.10",
 CellID->19380],

Cell["Here is a trivial complex number class in C#.", "Text",
 CellTags->"nlug:3.2.10",
 CellID->25570],

Cell["\<\
namespace MyCompany {

\tpublic struct Complex {

\t\tpublic double Re, Im;

\t\tpublic Complex(double re, double im) {
\t\t\tRe = re;
\t\t\tIm = im;
\t\t}

\t\tpublic Complex Add(Complex c) {
\t\t\treturn this + c;
\t\t}

\t\tpublic static Complex operator+(Complex a, Complex b) {
\t\t\treturn new Complex(a.Re + b.Re, a.Im + b.Im);
\t\t}
\t}
}\
\>", "Program",
 CellTags->"nlug:3.2.10",
 CellID->7639],

Cell[TextData[{
 "Assume that you compiled this class into the assembly ",
 StyleBox["MyCompany.Complex.dll", "MR"],
 ". Here is an example of using it."
}], "Text",
 CellTags->"nlug:3.2.10",
 CellID->5352],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "LoadNETAssembly", "[", "\"\<c:\\\\MyCompany.Complex.dll\>\"", "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"SetComplexType", "[", "\"\<MyCompany.Complex\>\"", "]"}], 
  ";"}]}], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.10",
 CellLabel->"In[1]:=",
 CellID->31641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c", "=", 
  RowBox[{"NETNew", "[", 
   RowBox[{"\"\<MyCompany.Complex\>\"", ",", "2", ",", "1"}], 
   "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.10",
 CellLabel->"In[3]:=",
 CellID->29644],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", "[", "\<\"MyCompany.Complex\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$18014398509481985]], "Output",
 CellTags->"nlug:3.2.10",
 CellLabel->"Out[3]=",
 CellID->5775]
}, Open  ]],

Cell[TextData[{
 "Once you have used ",
 Cell[BoxData[
  ButtonBox["SetComplexType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/SetComplexType"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NETObjectToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETObjectToExpression"]], 
  "InlineFormula"],
 " will convert object references of that type to complex numbers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " (objects of type ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " will normally be converted to complex numbers when returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", but a call to a constructor always returns a ",
 StyleBox["NETObject", "MR"],
 ")."
}], "Text",
 CellTags->"nlug:3.2.10",
 CellID->7072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NETObjectToExpression", "[", "c", "]"}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.10",
 CellLabel->"In[4]:=",
 CellID->22033],

Cell[BoxData[
 RowBox[{"46.`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellTags->"nlug:3.2.10",
 CellLabel->"Out[4]=",
 CellID->21694]
}, Open  ]],

Cell[TextData[{
 "Here are three examples of calling the ",
 StyleBox["Add()", "MR"],
 " method. This method takes one argument of type ",
 StyleBox["Complex", "MR"],
 ". Note that you can pass a ",
 StyleBox["Complex", "MR"],
 " object, a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " complex number, or a real number for this argument. ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " handles any necessary conversions."
}], "Text",
 CellTags->"nlug:3.2.10",
 CellID->28141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c", "@", 
  RowBox[{"Add", "[", "c", "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.10",
 CellLabel->"In[5]:=",
 CellID->17709],

Cell[BoxData[
 RowBox[{"4.`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellTags->"nlug:3.2.10",
 CellLabel->"Out[5]=",
 CellID->28595]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c", "@", 
  RowBox[{"Add", "[", 
   RowBox[{"42", "+", 
    RowBox[{"15", " ", "\[ImaginaryI]"}]}], "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.10",
 CellLabel->"In[6]:=",
 CellID->21826],

Cell[BoxData[
 RowBox[{"44.`", "\[InvisibleSpace]", "+", 
  RowBox[{"16.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellTags->"nlug:3.2.10",
 CellLabel->"Out[6]=",
 CellID->21345]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c", "@", 
  RowBox[{"Add", "[", "42", "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.10",
 CellLabel->"In[7]:=",
 CellID->29204],

Cell[BoxData[
 RowBox[{"44.`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellTags->"nlug:3.2.10",
 CellLabel->"Out[7]=",
 CellID->6777]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Complex", "MR"],
 " class has an overloaded ",
 StyleBox["+", "MR"],
 " operator, and overloaded operators would be expected in any real \
implementation of a complex number class. As discussed in the ",
 ButtonBox["Overloaded Operators",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#18254"],
 " section, you can call these operators from ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " by using the special static method equivalents that always exist in the \
class. For the ",
 StyleBox["+", "MR"],
 " operator, the special method is called ",
 StyleBox["op_Addition()", "MR"],
 ". Here is how to call it (note the required _ to U conversion)."
}], "Text",
 CellTags->"nlug:3.2.10",
 CellID->25789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complex`opUAddition", "[", 
  RowBox[{"c", ",", "c"}], "]"}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.10",
 CellLabel->"In[8]:=",
 CellID->2250],

Cell[BoxData[
 RowBox[{"4.`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellTags->"nlug:3.2.10",
 CellLabel->"Out[8]=",
 CellID->27778]
}, Open  ]],

Cell[TextData[{
 "Because some .NET languages (such as Visual Basic .NET) do not support \
overloaded operators, class designers usually provide a documented \
alternative method, such as the ",
 StyleBox["Add()", "MR"],
 " method in the ",
 StyleBox["Complex", "MR"],
 " class."
}], "Text",
 CellTags->"nlug:3.2.10",
 CellID->2160]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The .NET Console Window", "Section",
 CellTags->{".NET Console", "nlug:3.2.11"},
 CellID->9196],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " provides a convenient means to display the .NET \
\[OpenCurlyDoubleQuote]console\[CloseCurlyDoubleQuote] window. Any output \
written to the standard ",
 StyleBox["Console.Out", "MR"],
 " and ",
 StyleBox["Console.Error", "MR"],
 " streams will be directed to this window. If you are calling .NET code that \
writes diagnostic information to the console, then you can see this output \
while your program runs. Like most ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " features, the console window can be used easily from either ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " or .NET programs (its use from .NET code is described in ",
 ButtonBox["Calling ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/guide/CallingMathematicaFromNET"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/guide/CallingMathematicaFromNET"],
  FontSlant->"Italic"],
 ButtonBox[" from .NET",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/guide/CallingMathematicaFromNET"],
 "). To use it from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", call the ",
 Cell[BoxData[
  ButtonBox["ShowNETConsole",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ShowNETConsole"]], "InlineFormula"],
 " function."
}], "Text",
 CellTags->"nlug:3.2.11",
 CellID->19418],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ShowNETConsole",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/ShowNETConsole"], "[", "]"}], Cell[
    TextData[{
     "display the .NET console window and begin capturing output written to ",
     
     StyleBox["Console.Out", "MR"],
     " and ",
     StyleBox["Console.Error", "MR"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ShowNETConsole",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/ShowNETConsole"], "[", "\"\<\!\(\*
StyleBox[\"stream\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "display the .NET console window and begin capturing output written to \
the specified stream, which should be \"stdout\" for ",
     StyleBox["Console.Out", "MR"],
     " or \"stderr\" for ",
     StyleBox["Console.Error", "MR"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ShowNETConsole",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/ShowNETConsole"], "[", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"], "]"}], Cell[
    "stop all capturing of output", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.2.11",
 CellID->9164],

Cell["Showing the console window.", "Caption",
 CellTags->"nlug:3.2.11",
 CellID->6704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShowNETConsole", "[", "]"}]], "Input",
 CellTags->"nlug:3.2.11",
 CellLabel->"In[1]:=",
 CellID->13318],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", 
    "[", "\<\"Wolfram.NETLink.UI.ConsoleWindow\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$452984833]], "Output",
 CellTags->"nlug:3.2.11",
 CellLabel->"Out[1]=",
 CellID->18545]
}, Open  ]],

Cell[TextData[{
 "Capturing of output only begins when you call ",
 Cell[BoxData[
  ButtonBox["ShowNETConsole",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ShowNETConsole"]], "InlineFormula"],
 ". When the window first appears, it will not have any content that might \
have been previously written to ",
 StyleBox["Console.Out", "MR"],
 " or ",
 StyleBox["Console.Error", "MR"],
 ". Calling ",
 Cell[BoxData[
  ButtonBox["ShowNETConsole",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ShowNETConsole"]], "InlineFormula"],
 " when the window is already open will cause it to come to the foreground."
}], "Text",
 CellTags->"nlug:3.2.11",
 CellID->6813],

Cell[TextData[{
 "The next example writes some output from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If you executed the ",
 Cell[BoxData[
  ButtonBox["ShowNETConsole",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ShowNETConsole"]], "InlineFormula"],
 StyleBox["[]", "MR"],
 " above, then you will see \[OpenCurlyDoubleQuote]Hello from .NET\
\[CloseCurlyDoubleQuote] printed in the window. "
}], "Text",
 CellTags->"nlug:3.2.11",
 CellID->5695],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadNETType", "[", "\"\<System.Console\>\"", "]"}], ";"}], "\n", 
 RowBox[{"Console`Out", "@", 
  RowBox[{"WriteLine", "[", "\"\<Hello from .NET\>\"", "]"}]}]}], "Input",
 CellTags->"nlug:3.2.11",
 CellLabel->"In[2]:=",
 CellID->11154],

Cell[TextData[{
 "Although it is convenient to demonstrate writing to the window using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code like this, this is typically done instead from .NET code that writes \
diagnostic information to the console."
}], "Text",
 CellTags->"nlug:3.2.11",
 CellID->30433]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Distributing Applications that Use ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"]
}], "Section",
 CellTags->{"Distributing Applications", "nlug:3.2.12"},
 CellID->20220],

Cell[TextData[{
 "This tutorial discusses some issues relevant to ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " developers who are creating add-ons for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.2.12",
 CellID->21891],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " is designed to make it easy for application developers to distribute \
applications that have parts of their implementation in .NET. If you \
structure your application directory properly, your users will be able to \
install it simply by copying it into any standard location for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applications. In particular, ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " will be able to find your .NET assemblies without users having to perform \
any special operations or even restart the .NET runtime. "
}], "Text",
 CellTags->"nlug:3.2.12",
 CellID->15323],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applications are typically deployed as single directories (with \
subdirectories), installed into one of several standard locations where ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expects to find them. These standard locations can be written as ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 StyleBox["\\AddOns\\Applications", "MR"],
 ", ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 StyleBox["\\Applications", "MR"],
 ", and ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 StyleBox["\\Applications", "MR"],
 ", where ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " refer to the locations given by these built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbols."
}], "Text",
 CellTags->"nlug:3.2.12",
 CellID->29246],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " applications might include .NET assemblies or legacy Windows DLLs (which \
can be called from .NET as described in the ",
 ButtonBox["Calling DLLs from ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#32076"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#32076"],
  FontSlant->"Italic"],
 " section. If your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " application uses ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " and includes its own .NET assemblies, you should create an ",
 StyleBox["assembly", "MR"],
 " subdirectory in your application directory. You can place any assemblies \
that your application needs into this ",
 StyleBox["assembly", "MR"],
 " subdirectory. Legacy Windows DLLs (so-called \
\[OpenCurlyDoubleQuote]unmanaged\[CloseCurlyDoubleQuote] DLLs) should be \
placed into into a ",
 StyleBox["Libraries\\Windows", "MR"],
 " subdirectory of your application directory."
}], "Text",
 CellTags->"nlug:3.2.12",
 CellID->19778],

Cell[TextData[{
 "Here is an example directory structure for an application that uses ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.2.12",
 CellID->21089],

Cell["\<\
\t\tMyApp/
\t\t\t... other files and directories used by the application ...
\t\t\tassembly/
\t\t\t\tMyAssembly.dll
\t\t\tLibraries/
\t\t\t\tWindows/
\t\t\t\t\tMyLegacyDLL.dll\
\>", "Program",
 CellTags->"nlug:3.2.12",
 CellID->3698],

Cell[TextData[{
 "Remember that even if you use the above directory structure, your \
application code will still have to load its assemblies explicitly. All \
assemblies, other than ones that make up the .NET Framework itself, must be \
manually loaded before they can be used, as described in the ",
 ButtonBox["Loading .NET Assemblies and Types",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#1113"],
 " section. Having the assemblies in the proper location merely means that \
they can be found by ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 " when only a filename or assembly name is supplied."
}], "Text",
 CellTags->"nlug:3.2.12",
 CellID->3616],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadNETAssembly", "[", "\"\<MyAssembly.dll\>\"", "]"}], 
  "\[IndentingNewLine]", "         ", 
  RowBox[{"(*", " ", "or", " ", "*)"}]}], "\n", 
 RowBox[{"LoadNETAssembly", "[", "\"\<My.Assembly.Name\>\"", "]"}]}], "Input",\

 Evaluatable->False,
 CellTags->"nlug:3.2.12",
 CellID->28900]
}, Open  ]],

Cell[CellGroupData[{

Cell["Version Information", "Section",
 CellTags->"nlug:3.2.13",
 CellID->12578],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " provides three symbols that supply version information. These symbols \
provide the same type of information as their counterparts in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " itself, except that they are in the ",
 StyleBox["NETLink`Information`", "MR"],
 " context, which is not on ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ", so you must specify them by their full names. "
}], "Text",
 CellTags->"nlug:3.2.13",
 CellID->30959],

Cell[BoxData[GridBox[{
   {
    StyleBox["NETLink`Information`$Version", "MR"], Cell[
    "a string giving full version information", "TableText"]},
   {
    StyleBox["NETLink`Information`$VersionNumber", "MR"], Cell[
    "a real number giving the current version number", "TableText"]},
   {
    StyleBox["NETLink`Information`$ReleaseNumber", "MR"], Cell["\<\
an integer giving the release number (the last digit in a full x.x.x version \
specification\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ShowNETConsole",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/ShowNETConsole"], "[", "]"}], Cell[
    TextData[{
     "the console window will show version information for the ",
     StyleBox[".NET/Link",
      FontSlant->"Italic"],
     " assembly"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.2.13",
 CellID->12953],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " version information."
}], "Caption",
 CellTags->"nlug:3.2.13",
 CellID->12059],

Cell[CellGroupData[{

Cell[BoxData["NETLink`Information`$Version"], "Input",
 CellTags->"nlug:3.2.13",
 CellLabel->"In[1]:=",
 CellID->26368],

Cell[BoxData["\<\"NET/Link Version 1.2.0 (September, 2004)\"\>"], "Output",
 CellTags->"nlug:3.2.13",
 CellLabel->"Out[1]=",
 CellID->31041]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["NETLink`Information`$VersionNumber"], "Input",
 CellTags->"nlug:3.2.13",
 CellLabel->"In[2]:=",
 CellID->3617],

Cell[BoxData["1.2"], "Output",
 CellTags->"nlug:3.2.13",
 CellLabel->"Out[2]=",
 CellID->16460]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["NETLink`Information`$ReleaseNumber"], "Input",
 CellTags->"nlug:3.2.13",
 CellLabel->"In[3]:=",
 CellID->7253],

Cell[BoxData["0"], "Output",
 CellTags->"nlug:3.2.13",
 CellLabel->"Out[3]=",
 CellID->8650]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ShowNETConsole",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ShowNETConsole"]], "InlineFormula"],
 StyleBox["[]", "MR"],
 " function, described in ",
 ButtonBox["The .NET Console Window",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#9196"],
 " section, will display the version number of the ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " assembly file. This version should match the version of the ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-language component. "
}], "Text",
 CellTags->"nlug:3.2.13",
 CellID->12586]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating User Interfaces", "Section",
 CellID->17034],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
 CellTags->"nlug:3.3.0",
 CellID->3744],

Cell[TextData[{
 "One application of ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " is to write user interfaces for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs. Examples of such interfaces would be a progress bar monitoring \
the completion of a computation, a window that displays an image or \
animation, a dialog box that prompts users for input or helps them compose a \
proper call of an unfamiliar function, or a mini-application that leads users \
through the steps of an analysis. These types of user interfaces are distinct \
from what you might write for a .NET program that uses ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in the background in that they \[OpenCurlyDoubleQuote]pop up\
\[CloseCurlyDoubleQuote] when the user invokes some ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. These user interfaces do not replace the notebook front end; they \
just augment it. In this way, they are like an extension of the palettes and \
other specialty notebook elements that you can create in the front end."
}], "Text",
 CellTags->"nlug:3.3.0",
 CellID->3217],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with",
 StyleBox[" .NET/Link",
  FontSlant->"Italic"],
 " is an extremely powerful and productive environment for creating user \
interfaces. The complexity of user interface code is ideally suited to the \
interactive line-at-a-time nature of ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " development. You can build, modify, and experiment with your user \
interface ",
 StyleBox["while",
  FontSlant->"Italic"],
 " it is running",
 "."
}], "Text",
 CellTags->"nlug:3.3.0",
 CellID->26068],

Cell[TextData[{
 "You can use either ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " or ",
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 " to build user interfaces for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " has the advantage of being cross-platform, so your interface will run on \
all ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " systems. ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " integrates more tightly with Windows than ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " does, so if you only need your users interfaces to work on Windows \
machines, then ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " is probably the best choice."
}], "Text",
 CellTags->"nlug:3.3.0",
 CellID->13235],

Cell[TextData[{
 "If you have used ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " to build user ",
 "interfaces",
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", please note that there are significant differences between ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " and ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " in this area. ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " is generally simpler than ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", not because of any superiority of .NET over Java, but because ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " is a second-generation design. The design simplifications in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " will eventually be brought to ",
 StyleBox["J/Link.",
  FontSlant->"Italic"]
}], "Text",
 CellTags->"nlug:3.3.0",
 CellID->1104],

Cell[TextData[{
 "Anyone considering writing user interfaces for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs should also look at the ",
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 " add-on, which is bundled with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5.1 and later, and available for download for users with earlier versions \
of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " is built on top of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", and provides an extremely high-level means of creating interfaces. "
}], "Text",
 CellTags->"nlug:3.3.0",
 CellID->20032]
}, Open  ]],

Cell[CellGroupData[{

Cell["Modal versus Modeless Operation", "Subsection",
 CellTags->{"Modal versus Modeless", "nlug:3.3.1"},
 CellID->15816],

Cell[TextData[{
 "Writing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs that display .NET user interface elements, such as windows or \
buttons, requires some knowledge of special issues that are not present in \
typical ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions, where only the notebook front end is being used to communicate \
with the kernel. To help understand these special issues, it is useful to \
examine some basic considerations about the kernel\[CloseCurlyQuote]s \
\[OpenCurlyDoubleQuote]main loop\[CloseCurlyDoubleQuote] in which it acquires \
input, evaluates it, and sends off any output."
}], "Text",
 CellTags->"nlug:3.3.1",
 CellID->876873929],

Cell[TextData[{
 "When the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel is being used from the front end, it spends most of its life \
waiting for input to arrive on the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " that it uses to communicate with the front end. This ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is given by ",
 Cell[BoxData[
  ButtonBox["$ParentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ParentLink"]], "InlineFormula"],
 ", and it is therefore ",
 Cell[BoxData[
  ButtonBox["$ParentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ParentLink"]], "InlineFormula"],
 " that has the kernel\[CloseCurlyQuote]s attention. When input arrives on ",
 Cell[BoxData[
  ButtonBox["$ParentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ParentLink"]], "InlineFormula"],
 ", it is evaluated, any results are sent back on the link, and the kernel \
goes back to waiting for more input on ",
 Cell[BoxData[
  ButtonBox["$ParentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ParentLink"]], "InlineFormula"],
 ". When ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " is being used, the kernel has another ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " open\[LongDash]the one that connects to the .NET runtime. When you execute \
some code that calls into .NET, the kernel sends something to .NET and then \
blocks waiting for the return value from .NET. During this period when the \
kernel is waiting for a return value from .NET, the .NET link has the kernel\
\[CloseCurlyQuote]s attention. It is only during this period of time that the \
kernel is paying attention to the .NET link. A more general way of saying \
this is that the kernel is only listening for input arriving from .NET when \
it has been specifically instructed to do so. The rest of the time it is \
listening only to ",
 Cell[BoxData[
  ButtonBox["$ParentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ParentLink"]], "InlineFormula"],
 ", which is typically the notebook front end."
}], "Text",
 CellTags->"nlug:3.3.1",
 CellID->13197],

Cell[TextData[{
 "Consider what happens when the user clicks a button in your .NET window and \
that button tries to execute some code that calls into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The .NET side sends something to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and then waits for the result, but the kernel will never get the request \
because it is only paying attention to the notebook front end link, not the \
.NET link. It is necessary to use some means to tell the kernel to look for \
input arriving on the .NET link. ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " provides two main ways to manage the kernel\[CloseCurlyQuote]s attention \
to the .NET link and thereby control its readiness to accept requests for \
evaluations initiated by the .NET side."
}], "Text",
 CellTags->"nlug:3.3.1",
 CellID->2146],

Cell[TextData[{
 "These two ways can be called \[OpenCurlyDoubleQuote]modal\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]modeless.\
\[CloseCurlyDoubleQuote] In modal interaction, characterized by the use of \
the ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function, the kernel is pointed at the .NET link until the .NET side \
releases it. The kernel is a complete slave to the .NET side, and is \
unavailable for any other computations. In modeless interaction, \
characterized by the use of the ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function, the kernel is kept in a state where it is receptive to \
evaluation requests arriving from either the notebook front end or .NET, \
evenly sharing its attention between these two programs."
}], "Text",
 CellTags->"nlug:3.3.1",
 CellID->24853],

Cell[TextData[{
 "A common type of user interface element is analogous to a modal dialog: \
once it is displayed, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program hangs waiting for the user to dismiss the window. Typically, this \
is because the window returns a result to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", so it is not meaningful for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to continue until the window is closed. An example of such a window is a \
simple input window that asks the user for some value, which it returns to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " when the ",
 StyleBox["OK", "SR"],
 " button is clicked."
}], "Text",
 CellTags->"nlug:3.3.1",
 CellID->27223],

Cell[TextData[{
 "It is important to understand the slightly generalized use of the term \
\[OpenCurlyDoubleQuote]modal\[CloseCurlyDoubleQuote] to describe these \
windows. They may not be modal in the traditional sense that they must be \
dismissed before anything else can be done in the user interface. Rather, \
they are modal with respect to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel\[LongDash]the kernel cannot do anything else until they are closed. \
A .NET window that you create might not be modal with respect to other .NET \
windows on the screen, but it ties up the kernel\[CloseCurlyQuote]s attention \
until it is dismissed."
}], "Text",
 CellTags->"nlug:3.3.1",
 CellID->2478],

Cell[TextData[{
 "Another type of user interface element is analogous to a modeless dialog: \
after it is displayed, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program that created it will finish, leaving the window visible and usable \
while the user continues working in the notebook front end. An example would \
be a window that lets users load packages into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by selecting them from a scrolling list. You write a ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " program that creates this window, displays it, and returns. The window is \
left open and usable until the user clicks its close box. In the meantime, \
the user is free to continue working in the front end, going back to use this \
.NET window whenever it is convenient."
}], "Text",
 CellTags->"nlug:3.3.1",
 CellID->23233],

Cell[TextData[{
 "Such a window is almost like another type of notebook or palette window in \
the front end. You can have any number of front end or .NET modeless windows \
open and active at once, meaning that they can be used to initiate \
computations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". They are each their own little interface onto the same kernel. What is \
different about the .NET window is that it is much more general than a \
notebook window, and, importantly, it exists in a different application layer \
than the front end. This last fact makes the .NET window, in effect, a second \
front end, rather than an extension of the notebook front end. To accommodate \
such a second front end, the kernel must be kept in a special state that \
allows it to handle requests for evaluations arriving from either the \
notebook front end or .NET. "
}], "Text",
 CellTags->"nlug:3.3.1",
 CellID->30962],

Cell[TextData[{
 "Before presenting examples of how to implement modal and modeless windows, \
it is necessary to jump ahead a little bit and explain the mechanism by which \
.NET user interface elements communicate events to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.3.1",
 CellID->19990]
}, Open  ]],

Cell[CellGroupData[{

Cell["Handling Events", "Subsection",
 CellTags->{"Handling Events", "nlug:3.3.2"},
 CellID->21428],

Cell[TextData[{
 "User interface elements typically have active components such as buttons, \
scrollbars, menus, and text fields, that need to trigger certain actions when \
they are used. In the .NET event model, components fire events in response to \
user actions, and other components indicate their interest in these events by \
supplying a delegate that connects an event with its handler. The concept of \
a delegate is covered in detail in the .NET Framework documentation, but ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " users can generally ignore the details of delegates because you use a very \
simple syntax for assigning a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function to be called when an event fires."
}], "Text",
 CellTags->"nlug:3.3.2",
 CellID->14124],

Cell[TextData[{
 "It is useful to compare the ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " technique for assigning event handler functions with the C# and Visual \
Basic .NET techniques. The following shows C# and Visual Basic .NET syntax \
for adding an event handler to the ",
 StyleBox["KeyPress", "MR"],
 " event in a ",
 StyleBox["TextBox", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.3.2",
 CellID->25981],

Cell["\<\
// C#
myTextBox.KeyPress += new KeyEventHandler(MyKeyPressHandlerMethod);

' Visual Basic .NET
AddHandler myTextBox.KeyPress, AddressOf MyKeyPressHandlerMethod\
\>", "Program",
 CellTags->"nlug:3.3.2",
 CellID->28489],

Cell[TextData[{
 "After executing either of the above lines, the ",
 StyleBox["MyKeyPressHandlerMethod()", "MR"],
 " method will be called whenever a key is pressed while the ",
 StyleBox["myTextBox", "MR"],
 " component has the focus. The C# syntax is a little cryptic, as the ",
 StyleBox["+=", "MR"],
 " operator is overloaded for adding a delegate to an event."
}], "Text",
 CellTags->"nlug:3.3.2",
 CellID->30425],

Cell[TextData[{
 "The preceding code does not show the definition of ",
 StyleBox["MyKeyPressHandlerMethod()", "MR"],
 ". The signature of this method must be the same as the delegate that \
corresponds to the ",
 StyleBox["KeyPress", "MR"],
 " event. As you can see in the C# code, the delegate type is ",
 StyleBox["KeyEventHandler", "MR"],
 ", and here is the declaration."
}], "Text",
 CellTags->"nlug:3.3.2",
 CellID->1984],

Cell["\<\
public delegate void KeyEventHandler(object sender, KeyEventArgs eventArgs);\
\>", "Program",
 CellTags->"nlug:3.3.2",
 CellID->23286],

Cell[TextData[{
 "Because ",
 StyleBox["MyKeyPressHandlerMethod()", "MR"],
 " must have the same signature, it would look something like this."
}], "Text",
 CellTags->"nlug:3.3.2",
 CellID->6535],

Cell["\<\
void MyKeyPressHandlerMethod(object sender, KeyEventArgs eventArgs) {
\t// Here you respond to the event in some way. The sender object
\t// will be the TextBox, and eventArgs will tell you about the event
\t// (such as what key was pressed).
}\
\>", "Program",
 CellTags->"nlug:3.3.2",
 CellID->5996],

Cell[TextData[{
 "Here is what it looks like in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to assign a ",
 StyleBox["myKeyPressHandler", "MR"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function to the ",
 StyleBox["KeyPress", "MR"],
 " event."
}], "Text",
 CellTags->"nlug:3.3.2",
 CellID->2662],

Cell[BoxData[
 RowBox[{"AddEventHandler", "[", 
  RowBox[{
   RowBox[{"myTextBox", "@", "KeyPress"}], ",", "myKeyPressHandler"}], 
  "]"}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.3.2",
 CellID->24363],

Cell[TextData[{
 "Note that it looks almost exactly like the Visual Basic .NET version. Once \
you have executed the line above, whenever a key is pressed while ",
 StyleBox["myTextBox", "MR"],
 " has the input focus, .NET will call back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and execute the ",
 StyleBox["myKeyPressHandler", "MR"],
 " function. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function will be called with the same arguments as the ",
 StyleBox["KeyEventHandler", "MR"],
 " delegate, and it should return the same type of value (although most event \
handlers return ",
 StyleBox["void", "MR"],
 ", so the return value is ignored). Here is what it might look like."
}], "Text",
 CellTags->"nlug:3.3.2",
 CellID->15535],

Cell[BoxData[
 RowBox[{
  RowBox[{"myKeyPressHandler", "[", 
   RowBox[{"sender_", ",", "keyEventArgs_"}], "]"}], ":=", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<The \>\"", "<>", 
    RowBox[{"keyEventArgs", "@", 
     RowBox[{"KeyCode", "@", 
      RowBox[{"ToString", "[", "]"}]}]}], "<>", "\"\<key was pressed\>\""}], 
   "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.3.2",
 CellID->8667],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["AddEventHandler",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/AddEventHandler"], "[", 
     StyleBox[
      RowBox[{"obj", "@", "eventName"}], "TI"], ",", 
     StyleBox["funcName", "TI"], "]"}], Cell[TextData[{
     "set the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " function that will be called when the object ",
     StyleBox["obj", "TI"],
     " fires the ",
     StyleBox["eventName", "TI"],
     " event"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RemoveEventHandler",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/RemoveEventHandler"], "[", 
     StyleBox["delegate", "TI"], "]"}], Cell[TextData[{
     "remove an event handler assigned by a previous call to ",
     StyleBox[ButtonBox["AddEventHandler",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/AddEventHandler"], "InlineCode"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.3.2",
 CellID->1437],

Cell[TextData[{
 "Assigning the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function that will be called in response to an event notification."
}], "Caption",
 CellTags->"nlug:3.3.2",
 CellID->15155],

Cell[TextData[{
 "Wiring up your application\[CloseCurlyQuote]s event logic via calls to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions is vastly more flexible than writing a traditional application \
in .NET. When you write in a compiled .NET language, or use a drag-and-drop \
GUI builder, you hard code the event logic. You have to decide at compile \
time what every click, scroll, and keystroke will do. But when you use ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", you decide how your program is wired together at run time. You can even \
change the behavior on the fly simply by typing a few lines of code."
}], "Text",
 CellTags->"nlug:3.3.2",
 CellID->26575],

Cell[TextData[{
 "You can remove an event handler using the ",
 Cell[BoxData[
  ButtonBox["RemoveEventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/RemoveEventHandler"]], "InlineFormula"],
 " function. When you call ",
 Cell[BoxData[
  ButtonBox["AddEventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/AddEventHandler"]], "InlineFormula"],
 ", it returns a ",
 StyleBox["NETObject", "MR"],
 ". This object is the delegate created for you by the internals of ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ". You can save this object and later pass it into ",
 Cell[BoxData[
  ButtonBox["RemoveEventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/RemoveEventHandler"]], "InlineFormula"],
 " to remove the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " callback that it represents. This is just about the only use you would \
have for the return value of ",
 Cell[BoxData[
  ButtonBox["AddEventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/AddEventHandler"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.3.2",
 CellID->27154],

Cell["\<\
dlg = AddEventHandler[myTextBox@KeyPress, myKeyPressHandler];
...
RemoveEventHandler[dlg];\
\>", "Input",
 Evaluatable->False,
 CellTags->"nlug:3.3.2",
 CellID->14970],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " event handler functions called in response to events are automatically \
wrapped in ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 ". This means that the objects sent as arguments to the function, as well as \
any new objects you create during the execution of the function, are released \
after the function returns. You do not have to use ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 " manually. If you want an object from your handler function to persist in \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " after the function returns, you must use ",
 Cell[BoxData[
  ButtonBox["KeepNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/KeepNETObject"]], "InlineFormula"],
 " to allow it to escape the unseen ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 " that wraps the function call. Here is a modified version of ",
 StyleBox["myKeyPressHandler", "MR"],
 " that stores the ",
 StyleBox["KeyCode", "MR"],
 " objects in a list for later inspection."
}], "Text",
 CellTags->"nlug:3.3.2",
 CellID->13663],

Cell[BoxData[
 RowBox[{
  RowBox[{"myKeyPressHandler2", "[", 
   RowBox[{"sender_", ",", "keyEventArgs_"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "keyCode", "}"}], " ", ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"keyCode", "=", 
      RowBox[{"keyEventArgs", "@", "KeyCode"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"AppendTo", "[", 
      RowBox[{"keysPressed", ",", "keyCode"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"KeepNETObject", "[", "keyCode", "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.3.2",
 CellID->27460],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AddEventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/AddEventHandler"]], "InlineFormula"],
 " takes two options that control its behavior. ",
 StyleBox["SendDelegateArguments", "MR"],
 " allows you to specify which of the delegate arguments you want to send to \
your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " handler function and in which order. By default, ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " sends all the delegate arguments, but as an optimization, you might not \
want to send them all. Creation of a new ",
 StyleBox["NETObject", "MR"],
 " expression in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is comparatively expensive, and the arguments to most event delegates are \
objects. In the case of the ",
 StyleBox["KeyPress", "MR"],
 " event example above, the first argument is the ",
 StyleBox["TextBox", "MR"],
 " object, which probably already exists in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", so it is not a significant optimization to avoid sending it. The ",
 StyleBox["KeyEventArgs", "MR"],
 " object, however, is definitely new to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", so you might want to avoid sending it if you do not need it. Here is an \
example of setting up an event handler that sends only the first argument to \
the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " callback function."
}], "Text",
 CellTags->"nlug:3.3.2",
 CellID->21763],

Cell[BoxData[
 RowBox[{"AddEventHandler", "[", 
  RowBox[{
   RowBox[{"myTextBox", "@", "KeyPress"}], ",", "myKeyPressHandler3", ",", 
   RowBox[{"SendDelegateArguments", "\[Rule]", 
    RowBox[{"{", "1", "}"}]}]}], "]"}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.3.2",
 CellID->14316],

Cell[TextData[{
 "This is what the ",
 StyleBox["myKeyPressHandler3", "MR"],
 " function would look like."
}], "Text",
 CellTags->"nlug:3.3.2",
 CellID->10094],

Cell[BoxData[
 RowBox[{
  RowBox[{"myKeyPressHandler3", "[", "sender_", "]"}], ":=", 
  RowBox[{"Print", "[", "\"\<A key was pressed\>\"", "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.3.2",
 CellID->26147],

Cell[TextData[{
 "The values you can specify for the ",
 Cell[BoxData[
  ButtonBox["SendDelegateArguments",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/SendDelegateArguments"]], 
  "InlineFormula"],
 " option are ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"], "MR"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"], "MR"]], "InlineFormula"],
 ", or a list of integers giving the indices of the arguments you want to \
send."
}], "Text",
 CellTags->"nlug:3.3.2",
 CellID->16518],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["SendDelegateArguments",
     BaseStyle->"Link",
     ButtonData->"paclet:NETLink/ref/SendDelegateArguments"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[TextData[{
     "which delegate arguments to send to the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " event handler function"
    }], "TableText"]},
   {
    StyleBox["CallsUnshare", "MR"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether or not your event handler function calls the advanced function \
",
     StyleBox["UnshareKernel", "MR"]
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"nlug:3.3.2",
 CellID->29509],

Cell["Options to AddEventHandler. ", "Caption",
 CellTags->"nlug:3.3.2",
 CellID->17664],

Cell[TextData[{
 "The ",
 StyleBox["CallsUnshare", "MR"],
 " option is for advanced programmers who are using the ",
 StyleBox["ShareKernel", "MR"],
 " and ",
 StyleBox["UnshareKernel", "MR"],
 " functions to manually control kernel sharing, instead of using ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 ". The sharing functions are discussed in ",
 ButtonBox["Manually Sharing the Kernel and Front End with .NET",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#27606"],
 ". If your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " callback function calls ",
 StyleBox["UnshareKernel", "MR"],
 ", you must set ",
 StyleBox["CallsUnshare", "MR"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " in the call to ",
 Cell[BoxData[
  ButtonBox["AddEventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/AddEventHandler"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.3.2",
 CellID->17112],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AddEventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/AddEventHandler"]], "InlineFormula"],
 " is a convenience function that allows you to easily assign a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function that will be called when an event fires. As part of its \
operation, ",
 Cell[BoxData[
  ButtonBox["AddEventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/AddEventHandler"]], "InlineFormula"],
 " creates a .NET delegate object that is assigned to the event, and whose \
action is to call the specified ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function. In some cases, you might want to create such a delegate object \
manually, but not attach it to an event. ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " provides the ",
 Cell[BoxData[
  ButtonBox["NETNewDelegate",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNewDelegate"]], "InlineFormula"],
 " function for this purpose. ",
 Cell[BoxData[
  ButtonBox["NETNewDelegate",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNewDelegate"]], "InlineFormula"],
 " creates a delegate of the specified type whose action is to call the \
designated ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function. The main use for ",
 Cell[BoxData[
  ButtonBox["NETNewDelegate",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNewDelegate"]], "InlineFormula"],
 " is to create a delegate object that will be supplied to an external C \
function invoked via .NET\[CloseCurlyQuote]s PInvoke facilities. It is often \
used in conjunction with ",
 Cell[BoxData[
  ButtonBox["DefineNETDelegate",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineNETDelegate"]], "InlineFormula"],
 " for this purpose. The ",
 ButtonBox["EnumWindows.nb",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/example/Part1/CallingDLLs/EnumWindows"],
 " example file demonstrates using ",
 Cell[BoxData[
  ButtonBox["DefineNETDelegate",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineNETDelegate"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NETNewDelegate",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNewDelegate"]], "InlineFormula"],
 " to call a C function that takes a callback function pointer as an \
argument."
}], "Text",
 CellTags->"nlug:3.3.2",
 CellID->7524],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NETNewDelegate",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/NETNewDelegate"], "[", 
     StyleBox["type", "TI"], ",", 
     StyleBox["funcName", "TI"], "]"}], Cell[TextData[{
     "create a new instance of the specified delegate type whose action is to \
call the specified ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " function"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DefineNETDelegate",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/DefineNETDelegate"], "[", 
     RowBox[{
      StyleBox["name", "TI"], ",", " ", 
      StyleBox["returnType", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["argType", "TI"], ",", 
        StyleBox["...", "TI"]}], "}"}]}], "]"}], Cell["\<\
create a new delegate type, for when there is no existing .NET delegate of \
the appropriate signature\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.3.2",
 CellID->18934],

Cell[TextData[{
 "Creating delegate objects that call ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Caption",
 CellTags->"nlug:3.3.2",
 CellID->9806],

Cell[TextData[{
 "Now that you have seen how to specify ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " event handler callbacks, recall that the kernel must be in a special state \
to be receptive to calls originating from user events in .NET. The two main \
ways of doing this are the functions ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 ", discussed in the next sections."
}], "Text",
 CellTags->"nlug:3.3.2",
 CellID->26381]
}, Open  ]],

Cell[CellGroupData[{

Cell["Modal Windows", "Subsection",
 CellTags->{"Modal Windows", "nlug:3.3.3"},
 CellID->28590],

Cell[TextData[{
 "The basic concepts of modal and modeless ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " interfaces are discussed in the earlier section ",
 ButtonBox["Modal versus Modeless Operation",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#15816"],
 ". Here is an example of a simple modal window. The window is a simple ",
 StyleBox["Form", "MR"],
 " object that changes its background color to a new random color each time \
it is clicked."
}], "Text",
 CellTags->"nlug:3.3.3",
 CellID->20634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"frm", "=", 
  RowBox[{
  "NETNew", "[", "\"\<System.Windows.Forms.Form\>\"", "]"}]}]], "Input",
 CellTags->"nlug:3.3.3",
 CellLabel->"In[1]:=",
 CellID->27415],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", "[", "\<\"System.Windows.Forms.Form\"\>", 
    "]"}], "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$83886081]], "Output",
 CellTags->"nlug:3.3.3",
 CellLabel->"Out[1]=",
 CellID->6862]
}, Open  ]],

Cell[TextData[{
 "Note that simply creating a new ",
 StyleBox["Form", "MR"],
 " object does not make it visible. Use the ",
 Cell[BoxData[
  ButtonBox["ShowNETWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ShowNETWindow"]], "InlineFormula"],
 " function to make a window visible and to bring it in front of all other \
windows. The ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " function, used later, will make a form visible, but ",
 Cell[BoxData[
  ButtonBox["ShowNETWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ShowNETWindow"]], "InlineFormula"],
 " is useful while you are just tinkering with an interface, before you want \
to actually run it modally."
}], "Text",
 CellTags->"nlug:3.3.3",
 CellID->10580],

Cell[BoxData[
 RowBox[{
  RowBox[{"ShowNETWindow", "[", "frm", "]"}], ";"}]], "Input",
 CellTags->"nlug:3.3.3",
 CellLabel->"In[2]:=",
 CellID->4919],

Cell[TextData[{
 "At this point, you should see a small frame window centered on the screen. \
Drag it to the side so that it is not hidden by ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "windows when you bring the current notebook window to the foreground. A \
huge advantage of using ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " for user interface development, compared to a typical compiled .NET \
language, is that you can experiment with your interface while it is running. \
Now change the color of the background."
}], "Text",
 CellTags->"nlug:3.3.3",
 CellID->2526],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadNETType", "[", "\"\<System.Drawing.Color\>\"", "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"frm", "@", "BackColor"}], " ", "=", " ", "Color`Red"}], 
  ";"}]}], "Input",
 CellTags->"nlug:3.3.3",
 CellLabel->"In[3]:=",
 CellID->27370],

Cell[TextData[{
 "Now add a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " handler for the form\[CloseCurlyQuote]s ",
 StyleBox["Click", "MR"],
 " event."
}], "Text",
 CellTags->"nlug:3.3.3",
 CellID->4850],

Cell[BoxData[
 RowBox[{
  RowBox[{"AddEventHandler", "[", 
   RowBox[{
    RowBox[{"frm", "@", "Click"}], ",", " ", "onClick"}], "]"}], 
  ";"}]], "Input",
 CellTags->"nlug:3.3.3",
 CellLabel->"In[5]:=",
 CellID->10944],

Cell[TextData[{
 "This is the definition of the ",
 StyleBox["onClick", "MR"],
 " function. It sets the form\[CloseCurlyQuote]s ",
 StyleBox["BackColor", "MR"],
 " property to a random color. This function ignores the event arguments, but \
you can learn what they are from the signature of the ",
 StyleBox["Click", "MR"],
 " event."
}], "Text",
 CellTags->"nlug:3.3.3",
 CellID->8018],

Cell[BoxData[
 RowBox[{
  RowBox[{"onClick", "[", "args___", "]"}], " ", ":=", "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{"frm", "@", "BackColor"}], " ", "=", "\[IndentingNewLine]", " ", 
   RowBox[{"Color`FromArgb", "[", 
    RowBox[{
     RowBox[{"Random", "[", 
      RowBox[{"Integer", ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "255"}], "}"}]}], "]"}], ",", 
     RowBox[{"Random", "[", 
      RowBox[{"Integer", ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "255"}], "}"}]}], "]"}], ",", 
     RowBox[{"Random", "[", 
      RowBox[{"Integer", ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "255"}], "}"}]}], "]"}]}], "]"}]}]}]], "Input",\

 CellTags->"nlug:3.3.3",
 CellLabel->"In[6]:=",
 CellID->2716],

Cell[TextData[{
 "At this point, if you click the form, you will get a beep and nothing will \
happen to the color. When the ",
 StyleBox["Click", "MR"],
 " event fires, .NET tries to call ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to execute the ",
 StyleBox["onClick", "MR"],
 " function, but it is not safe to make this call because ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is not listening for input on the .NET link. The call to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " would hang forever. ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " knows the kernel is not ready, so it refuses to make the call and issues a \
beep warning instead."
}], "Text",
 CellTags->"nlug:3.3.3",
 CellID->14061],

Cell[TextData[{
 "What you need is a way to put the kernel into a state where it is \
continuously reading from the .NET link. This is what makes the window \
\[OpenCurlyDoubleQuote]modal\[CloseCurlyDoubleQuote]\[LongDash]the kernel \
cannot do anything else until the window is closed. The function that \
implements this modal state is ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 ". The first argument to ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " is a top-level window object (in the .NET Framework, this means a ",
 StyleBox["System.Windows.Forms.Form", "MR"],
 " or any class that inherits from it)."
}], "Text",
 CellTags->"nlug:3.3.3",
 CellID->19422],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DoNETModal",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/DoNETModal"], "[", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "put the kernel into a state where its attention is solely directed at \
the .NET link until the specified ",
     StyleBox["form", "TI"],
     " window is closed"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DoNETModal",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/DoNETModal"], "[", 
     RowBox[{
      StyleBox["form", "TI"], ",", " ", 
      StyleBox["returnValue", "TI"]}], "]"}], Cell[TextData[{
     "run the ",
     StyleBox["form", "TI"],
     " modally and return the result of the ",
     StyleBox["returnValue", "TI"],
     " computation (this is executed before the window is destroyed)"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.3.3",
 CellID->21006],

Cell["Running modal windows.", "Caption",
 CellTags->"nlug:3.3.3",
 CellID->30826],

Cell["\<\
Now that everything is ready, you can enter the modal state and use the \
window.\
\>", "Text",
 CellTags->"nlug:3.3.3",
 CellID->703],

Cell[BoxData[
 RowBox[{"DoNETModal", "[", "form", "]"}]], "Input",
 CellTags->"nlug:3.3.3",
 CellLabel->"In[7]:=",
 CellID->13039],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " will not return until the .NET form window is closed. Click the window a \
few times to see the color change, then click the close box in the title bar \
to destroy the form and cause ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " to return."
}], "Text",
 CellTags->"nlug:3.3.3",
 CellID->7810],

Cell[TextData[{
 "You often want to get some information from a modal dialog box when it is \
closed, such as the value from a text box, or whether the form was closed by \
clicking an ",
 StyleBox["OK", "SR"],
 " or ",
 StyleBox["Cancel", "SR"],
 " button. When ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " returns, the form object has been destroyed, so it is too late to call \
methods on it. If you need to get some information out of a form before it is \
destroyed, use the optional second argument ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 ". This argument specifies a computation that will be executed just before \
the form is destroyed (it is held unevaluated until this time). ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " will return the result of this computation. The ",
 ButtonBox["PackageHelper.nb",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NETLink/example/Part1/WindowsAndDialogs/PackageHelper"],
 " example file shows how to use the second argument to ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " to determine whether a form was closed by clicking the ",
 StyleBox["OK", "SR"],
 " or ",
 StyleBox["Cancel", "SR"],
 " button."
}], "Text",
 CellTags->"nlug:3.3.3",
 CellID->27214],

Cell["\<\
Here is how the entire example looks when packaged into a single program.\
\>", "Text",
 CellTags->"nlug:3.3.3",
 CellID->4751],

Cell[BoxData[
 RowBox[{
  RowBox[{"SimpleModal", "[", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"NETBlock", "[", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"frm", ",", "onClick"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"frm", "=", 
       RowBox[{"NETNew", "[", "\"\<System.Windows.Forms.Form\>\"", "]"}]}], 
      ";", 
      RowBox[{"LoadNETType", "[", "\"\<System.Drawing.Color\>\"", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"frm", "@", "BackColor"}], "=", "Color`Red"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"AddEventHandler", "[", 
       RowBox[{
        RowBox[{"frm", "@", "Click"}], ",", "onClick"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"onClick", "[", "args___", "]"}], ":=", 
       RowBox[{
        RowBox[{"frm", "@", "BackColor"}], "=", 
        RowBox[{"Color`FromArgb", "[", 
         RowBox[{
          RowBox[{"Random", "[", 
           RowBox[{"Integer", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "255"}], "}"}]}], "]"}], ",", 
          RowBox[{"Random", "[", 
           RowBox[{"Integer", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "255"}], "}"}]}], "]"}], ",", 
          RowBox[{"Random", "[", 
           RowBox[{"Integer", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "255"}], "}"}]}], "]"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"DoNETModal", "[", "frm", "]"}]}]}], "\[IndentingNewLine]", 
    "]"}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"nlug:3.3.3",
 CellLabel->"In[8]:=",
 CellID->4432],

Cell[TextData[{
 "The .NET Framework documentation discusses how to implement modal windows \
using the ",
 StyleBox["ShowDialog()", "MR"],
 " method. There are some advantages and disadvantages to using this \
technique instead of ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 ". One disadvantage is that a .NET window is not guaranteed to come in front \
of notebook windows if you use ",
 StyleBox["ShowDialog()", "MR"],
 ". However, this failure seems to happen only for the very first window \
displayed in a session. Windows displayed with ",
 StyleBox["ShowDialog()", "MR"],
 " are truly modal in the sense that other .NET windows cannot be used until \
the modal one is closed. The ",
 StyleBox["ShowDialog()", "MR"],
 " method makes it easy to determine how the window was closed (whether the \
",
 StyleBox["OK", "SR"],
 " or ",
 StyleBox["Cancel", "SR"],
 " button was clicked), because it returns one of the ",
 StyleBox["DialogResult", "MR"],
 " enumeration values. You can get the same result by using the second \
argument to ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.3.3",
 CellID->7985],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Returns", " ", "the", " ", "DialogResult", " ", 
    RowBox[{"value", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"DoNETModal", "[", 
   RowBox[{"someFormWindow", ",", 
    RowBox[{"someFormWindow", "@", "DialogResult"}]}], "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.3.3",
 CellID->17684],

Cell[TextData[{
 "The ",
 ButtonBox["PackageHelper.nb",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NETLink/example/Part1/WindowsAndDialogs/PackageHelper"],
 " example file demonstrates a classic modal dialog with ",
 StyleBox["OK", "SR"],
 " and ",
 StyleBox["Cancel", "SR"],
 " buttons implemented with ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.3.3",
 CellID->23301],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " takes one option, ",
 Cell[BoxData[
  ButtonBox["FormStartPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/FormStartPosition"]], "InlineFormula"],
 ", that specifies the position in which the window will appear on screen. \
The possible values are ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Center",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Center"], "MR"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"], "MR"]], "InlineFormula"],
 " (the form will have the Windows default location), and ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manual"], "MR"]], "InlineFormula"],
 " (the form will appear at a location specified elsewhere, for example, by \
setting the form\[CloseCurlyQuote]s ",
 StyleBox["Location", "MR"],
 " property)."
}], "Text",
 CellTags->"nlug:3.3.3",
 CellID->24535],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["FormStartPosition",
     BaseStyle->"Link",
     ButtonData->"paclet:NETLink/ref/FormStartPosition"], 
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"], Cell[
    "the position in which the window will be displayed on screen", 
     "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"nlug:3.3.3",
 CellID->9502],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"nlug:3.3.3",
 CellID->8963]
}, Open  ]],

Cell[CellGroupData[{

Cell["Modeless Windows", "Subsection",
 CellTags->{"Modeless Windows", "nlug:3.3.4"},
 CellID->9564],

Cell[TextData[{
 "The previous section demonstrated how to use the ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " function to display and run modal windows, which cause the kernel to \
remain busy until the window is closed. Another type of window, which could \
be called modeless, remains open and usable without completely tying up the \
kernel. The basic concepts of modal and modeless ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " interfaces are discussed in more detail in the earlier section ",
 ButtonBox["Modal Versus Modeless Operation",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#15816"],
 "."
}], "Text",
 CellTags->"nlug:3.3.4",
 CellID->15012],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " provides the ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " function to run a window modelessly. The first argument to ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " is a top-level window (specifically, a ",
 StyleBox["Form", "MR"],
 " or any class that inherits from it). The window is made visible and \
brought in front of all notebook windows."
}], "Text",
 CellTags->"nlug:3.3.4",
 CellID->13440],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DoNETModeless",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/DoNETModeless"], "[", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "display the specified ",
     StyleBox["Form", "MR"],
     " window and return immediately, leaving the window active"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.3.4",
 CellID->11711],

Cell["Modeless windows.", "Caption",
 CellTags->"nlug:3.3.4",
 CellID->4537],

Cell[TextData[{
 "Here is the ",
 StyleBox["SimpleModal", "MR"],
 " example from the previous section implemented as a modeless window."
}], "Text",
 CellTags->"nlug:3.3.4",
 CellID->10778],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SimpleModeless", "[", "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"NETBlock", "[", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "frm", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"frm", "=", 
        RowBox[{"NETNew", "[", "\"\<System.Windows.Forms.Form\>\"", "]"}]}], 
       ";", 
       RowBox[{"LoadNETType", "[", "\"\<System.Drawing.Color\>\"", "]"}], ";",
        "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"frm", "@", "BackColor"}], "=", "Color`Red"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"AddEventHandler", "[", 
        RowBox[{
         RowBox[{"frm", "@", "Click"}], ",", "onClick"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"DoNETModeless", "[", "frm", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}], "\[IndentingNewLine]", "]"}]}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"onClick", "[", 
    RowBox[{"sender_", ",", "eventArgs_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"sender", "@", "BackColor"}], "=", 
    RowBox[{"Color`FromArgb", "[", 
     RowBox[{
      RowBox[{"Random", "[", 
       RowBox[{"Integer", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "255"}], "}"}]}], "]"}], ",", 
      RowBox[{"Random", "[", 
       RowBox[{"Integer", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "255"}], "}"}]}], "]"}], ",", 
      RowBox[{"Random", "[", 
       RowBox[{"Integer", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "255"}], "}"}]}], "]"}]}], "]"}]}]}], 
  ";"}]}], "Input",
 CellTags->"nlug:3.3.4",
 CellLabel->"In[1]:=",
 CellID->14781],

Cell[TextData[{
 "Executing ",
 StyleBox["SimpleModeless[]", "MR"],
 " will make the window visible and then return immediately. You can click \
the window to change its background color and also continue to use the kernel \
for other computations via the notebook front end."
}], "Text",
 CellTags->"nlug:3.3.4",
 CellID->20334],

Cell[BoxData[
 RowBox[{"SimpleModeless", "[", "]"}]], "Input",
 CellTags->"nlug:3.3.4",
 CellLabel->"In[2]:=",
 CellID->5051],

Cell[TextData[{
 "There are several important differences in the code of ",
 StyleBox["SimpleModeless", "MR"],
 " and ",
 StyleBox["SimpleModal", "MR"],
 ", beyond the obvious call to ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " instead of ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 ". These differences revolve around the fact that the form runs after the ",
 StyleBox["SimpleModeless", "MR"],
 " function returns. The ",
 StyleBox["onClick", "MR"],
 " function must be not be local to the Module, because the function\
\[CloseCurlyQuote]s definition would be cleared when the ",
 StyleBox["Module", "MR"],
 " ends. A ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 " is used to automatically release all .NET objects created when ",
 StyleBox["SimpleModeless", "MR"],
 " runs, but that means that you cannot refer to ",
 StyleBox["frm", "MR"],
 " by name in the code for ",
 StyleBox["onClick", "MR"],
 ", because the ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 " has ended by the time ",
 StyleBox["onClick", "MR"],
 " is executed (the symbol ",
 StyleBox["frm", "MR"],
 " is also local to the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"], "MR"]], "InlineFormula"],
 " so its value is cleared anyway). The first argument to the ",
 StyleBox["onClick", "MR"],
 " function is the object that fired the event, which is the ",
 StyleBox["Form", "MR"],
 " object, so you can use the first argument to refer to it instead of the \
symbol ",
 StyleBox["frm", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.3.4",
 CellID->32040],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " is very useful during development, even for a window that will be run \
modally in its final form. Because ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " does not return until the window is closed, you cannot modify your event \
logic or anything else about your window while it is running. You can use ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " to make your event callbacks \[OpenCurlyDoubleQuote]live\
\[CloseCurlyDoubleQuote] without tying up the kernel, so that you can tinker \
with your window while it is being displayed. When you are satisfied that it \
works as desired, you can package a complete program that runs with ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.3.4",
 CellID->2710],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["FormStartPosition",
     BaseStyle->"Link",
     ButtonData->"paclet:NETLink/ref/FormStartPosition"], 
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"], Cell[
    "the position in which the window will be displayed on screen", 
     "TableText"]},
   {
    ButtonBox["ActivateWindow",
     BaseStyle->"Link",
     ButtonData->"paclet:NETLink/ref/ActivateWindow"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to make the window visible", "TableText"]},
   {
    StyleBox["ShareFrontEnd", "MR"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether the front end in addition to the kernel should be shared with .NET\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"nlug:3.3.4",
 CellID->32538],

Cell["Options for DoNETModeless.", "Caption",
 CellTags->"nlug:3.3.4",
 CellID->7507],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " takes several options. ",
 Cell[BoxData[
  ButtonBox["FormStartPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/FormStartPosition"]], "InlineFormula"],
 " specifies the position in which the window will appear on screen. The \
possible values are ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Center",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Center"], "MR"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"], "MR"]], "InlineFormula"],
 " (the form will be in the Windows default location), and ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manual"], "MR"]], "InlineFormula"],
 " (the form will appear at a location specified elsewhere, for example, by \
setting the form\[CloseCurlyQuote]s ",
 StyleBox["Location", "MR"],
 " property). ",
 Cell[BoxData[
  ButtonBox["ActivateWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ActivateWindow"]], "InlineFormula"],
 " controls whether the window should be made visible and brought to the \
foreground. Set ",
 Cell[BoxData[
  ButtonBox["ActivateWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ActivateWindow"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " in the rare cases where you want to call ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " to enter the modeless state, but only later make the window visible."
}], "Text",
 CellTags->"nlug:3.3.4",
 CellID->6349],

Cell[TextData[{
 "The final option, ",
 StyleBox["ShareFrontEnd", "MR"],
 ", is used to allow .NET interfaces to interact with the notebook front end. \
The functions ",
 StyleBox["ShareKernel", "MR"],
 " and ",
 StyleBox["ShareFrontEnd", "MR"],
 " are discussed in the next section, and programmers using ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " are generally shielded from those low-level functions. ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " is essentially a means of encapsulating calls to ",
 StyleBox["ShareKernel", "MR"],
 " and ",
 StyleBox["UnshareKernel", "MR"],
 ", starting sharing when the window first appears and ending it when the \
window is closed. If you want your modeless interface to cause actions in the \
notebook front end (such as printing some text or making graphics appear), \
you need to force ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " to turn on front end as well as kernel sharing. This can be done by \
setting the ",
 StyleBox["ShareFrontEnd", "MR"],
 " option to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.3.4",
 CellID->1951],

Cell[TextData[{
 "One common circumstance where the ",
 StyleBox["ShareFrontEnd", "MR"],
 " option is useful is when you want to debug your program by inserting ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " statements in event handler functions. In a modeless interface, ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " output and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " warning messages triggered by event handler functions are sent to the .NET \
side and therefore do not appear in the notebook. If you want to see this \
information, setting ",
 StyleBox["ShareFrontEnd", "MR"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " will cause it to appear in the frontmost notebook window. If you use this \
option during development, but do not need it in the final version of your \
program, be sure to remove it, as front end sharing is expensive to turn on \
and off, and can delay the initial appearance of your window."
}], "Text",
 CellTags->"nlug:3.3.4",
 CellID->11350]
}, Open  ]],

Cell[CellGroupData[{

Cell["Manually Sharing the Kernel and Front End with .NET", "Subsection",
 CellTags->{"Sharing the Kernel", "nlug:3.3.5"},
 CellID->27606],

Cell[TextData[{
 StyleBox["Note:",
  FontWeight->"Bold"],
 " In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5.1 and later, the kernel is always shared with the .NET link. This means \
that the functions ",
 StyleBox["ShareKernel", "MR"],
 " and ",
 StyleBox["UnshareKernel", "MR"],
 " are not necessary and, in fact, do nothing at all. If you are writing \
programs that only need to run in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5.1 and later, you never need to call ",
 StyleBox["ShareKernel", "MR"],
 " or ",
 StyleBox["UnshareKernel", "MR"],
 ". If your programs need to work on all versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then you will need to use these functions as described below."
}], "Text",
 CellTags->"nlug:3.3.5",
 CellID->24795],

Cell[TextData[{
 "The previous sections described the ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " functions, which are ways of putting the kernel into a state where it is \
receptive to calls from events originating in .NET. Most programmers will \
only need to use those two functions to display and run .NET windows. Recall \
that ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " makes the kernel receptive to input either from .NET or from the notebook \
front end. In effect, the kernel is \[OpenCurlyDoubleQuote]shared\
\[CloseCurlyDoubleQuote] between the front end and .NET. In some \
circumstances you might want to initiate kernel sharing, but find that ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " is not appropriate for your needs. You can take direct control of kernel \
sharing by calling the ",
 StyleBox["ShareKernel", "MR"],
 " function."
}], "Text",
 CellTags->"nlug:3.3.5",
 CellID->29171],

Cell[TextData[{
 StyleBox["ShareKernel", "MR"],
 " was introduced with ",
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ", and is defined in the ",
 StyleBox["JLink`", "MR"],
 " context. Loading ",
 StyleBox["NETLink`", "MR"],
 " loads ",
 StyleBox["JLink`", "MR"],
 ", so you do not have to worry about the different contexts unless you are \
using ",
 StyleBox["ShareKernel", "MR"],
 " or related functions in your own package. When you call ",
 Cell[BoxData[
  ButtonBox["BeginPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BeginPackage"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " only makes available to the code in your package the contexts explicitly \
named in the ",
 Cell[BoxData[
  ButtonBox["BeginPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BeginPackage"]], "InlineFormula"],
 " statement, not other contexts that are needed by those packages. This \
means that for every symbol that you want to use within a package, you must \
always explicitly include that symbol\[CloseCurlyQuote]s context in your ",
 Cell[BoxData[
  ButtonBox["BeginPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BeginPackage"]], "InlineFormula"],
 " statement. Here is an outline of a package that uses ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " and also calls ",
 StyleBox["ShareKernel", "MR"],
 " directly."
}], "Text",
 CellTags->"nlug:3.3.5",
 CellID->3621],

Cell["\<\
BeginPackage[\"SomePackageThatUsesSharing`\", {\"NETLink`\", \"JLink`\"}]

... code that calls ShareKernel/UnshareKernel/ShareFrontEnd/UnshareFrontEnd \
...

EndPackage[]\
\>", "Program",
 CellTags->"nlug:3.3.5",
 CellID->11088],

Cell[TextData[{
 "The ",
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
 " discusses ",
 StyleBox["ShareKernel", "InlineCode"],
 " and ",
 StyleBox["ShareFrontEnd", "InlineCode"],
 " in detail, and you should refer to those sections for full information. \
One thing to remember about using ",
 StyleBox["ShareKernel", "MR"],
 " or ",
 StyleBox["ShareFrontEnd", "MR"],
 " with .NET is that you must supply the link to .NET as the argument, \
otherwise they will use the Java link by default."
}], "Text",
 CellTags->"nlug:3.3.5",
 CellID->7675],

Cell[BoxData[
 RowBox[{
  RowBox[{"tok", "=", 
   RowBox[{"ShareKernel", "[", 
    RowBox[{"NETLink", "[", "]"}], "]"}]}], ";"}]], "Input",
 CellTags->"nlug:3.3.5",
 CellID->18725],

Cell[TextData[{
 "Always save the result from ",
 StyleBox["ShareKernel", "MR"],
 " to later pass into ",
 StyleBox["UnshareKernel", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.3.5",
 CellID->22807],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnshareKernel", "[", "tok", "]"}], ";"}]], "Input",
 CellTags->"nlug:3.3.5",
 CellID->677939434],

Cell[TextData[{
 "As mentioned earlier, ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " calls ",
 StyleBox["ShareKernel", "MR"],
 " to initiate sharing, and arranges for ",
 StyleBox["UnshareKernel", "MR"],
 " to be called when the window is closed. In ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", programmers have to call ",
 StyleBox["ShareKernel", "MR"],
 " and ",
 StyleBox["UnshareKernel", "MR"],
 " directly to create a modeless window. Having a special function like ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " that turns sharing on and off automatically is much simpler."
}], "Text",
 CellTags->"nlug:3.3.5",
 CellID->1265],

Cell[TextData[{
 "One example of a program that needs to call ",
 StyleBox["ShareKernel", "MR"],
 " directly is presented in ",
 ButtonBox["Handling COM Events",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#23007"],
 ". That program sets up event handlers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for COM events fired by the Internet Explorer application. There is no \
top-level .NET ",
 StyleBox["Form", "MR"],
 " window to pass into ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 ", so sharing has to be managed explicitly."
}], "Text",
 CellTags->"nlug:3.3.5",
 CellID->17786]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Displaying ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Graphics and Typeset Expressions"
}], "Subsection",
 CellTags->{"ShowNETWindow", "nlug:3.3.6"},
 CellID->8373],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " includes a special subclass of the standard ",
 StyleBox["PictureBox", "MR"],
 " class, called ",
 StyleBox["Wolfram.NETLink.UI.MathPictureBox", "MR"],
 ", that makes it easy to display ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics or typeset expressions in a .NET window. The example file ",
 ButtonBox["SimpleAnimationWindow.nb",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NETLink/example/Part1/WindowsAndDialogs/SimpleAnimationWindow"],
 " demonstrates how to use it. You will find complete documentation for this \
class in the ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " ",
 ButtonBox["API documentation",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/net/NETLink"],
 StyleBox[".",
  FontSlant->"Italic"]
}], "Text",
 CellTags->"nlug:3.3.6",
 CellID->26289]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bringing .NET Windows to the Foreground", "Subsection",
 CellTags->{"ShowNETWindow", "nlug:3.3.7"},
 CellID->17185],

Cell[TextData[{
 "If you are creating a .NET window with a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program, you probably want that window to pop up in front of the notebook \
the user is working in so that its presence becomes apparent. The functions \
",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " automatically make the form visible and bring it to the foreground. You \
might expect that the ",
 StyleBox["Show()", "MR"],
 " or ",
 StyleBox["Activate()", "MR"],
 " methods of the ",
 StyleBox["Form", "MR"],
 " class would also do this for you, but they do not always work because the \
.NET windows live in a different application than the notebook front end."
}], "Text",
 CellTags->"nlug:3.3.7",
 CellID->16981],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " provides a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function, ",
 Cell[BoxData[
  ButtonBox["ShowNETWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ShowNETWindow"]], "InlineFormula"],
 ", that performs all the necessary steps to make a .NET window visible and \
appear in front of all other windows. You do not need to call ",
 Cell[BoxData[
  ButtonBox["ShowNETWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ShowNETWindow"]], "InlineFormula"],
 " if you are using ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 ", as it is called automatically. Even when using ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 ", however, ",
 Cell[BoxData[
  ButtonBox["ShowNETWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ShowNETWindow"]], "InlineFormula"],
 " can be useful to bring a window back to the foreground if the user has \
brought other windows in front of it since it was first displayed."
}], "Text",
 CellTags->"nlug:3.3.7",
 CellID->26655],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ShowNETWindow",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/ShowNETWindow"], "[", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "make the specified .NET ",
     StyleBox["form", "TI"],
     " window visible and bring it in front of all other windows, including \
notebook windows"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.3.7",
 CellID->10687],

Cell["Bringing a .NET window to the foreground.", "Caption",
 CellTags->"nlug:3.3.7",
 CellID->13394],

Cell[TextData[{
 "Like ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ShowNETWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ShowNETWindow"]], "InlineFormula"],
 " takes the ",
 Cell[BoxData[
  ButtonBox["FormStartPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/FormStartPosition"]], "InlineFormula"],
 " option, which specifies the position in which the window will appear on \
screen. The possible values are ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Center",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Center"], "MR"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"], "MR"]], "InlineFormula"],
 " (the form will be in the Windows default location), and ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manual"], "MR"]], "InlineFormula"],
 " (the form will appear at a location specified elsewhere, for example, by \
setting the form\[CloseCurlyQuote]s ",
 StyleBox["Location", "MR"],
 " property)."
}], "Text",
 CellTags->"nlug:3.3.7",
 CellID->11506]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example Files", "Subsection",
 CellTags->"nlug:3.3.8",
 CellID->9716],

Cell[TextData[{
 "The following GUI example programs are included with ",
 StyleBox[".NET/Link.",
  FontSlant->"Italic"]
}], "Text",
 CellTags->"nlug:3.3.8",
 CellID->20091],

Cell[TextData[ButtonBox["Circumcircle.nb",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NETLink/example/Part1/WindowsAndDialogs/Circumcircle"]], "Text",
 CellTags->"nlug:3.3.8",
 CellID->9651],

Cell[TextData[ButtonBox["PackageHelper.nb",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NETLink/example/Part1/WindowsAndDialogs/PackageHelper"]], "Text",
 CellTags->"nlug:3.3.8",
 CellID->19287],

Cell[TextData[ButtonBox["SimpleAnimationWindow.nb",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NETLink/example/Part1/WindowsAndDialogs/SimpleAnimationWindow"]], \
"Text",
 CellTags->"nlug:3.3.8",
 CellID->16242],

Cell[TextData[ButtonBox["RealTimeAlgebra.nb",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NETLink/example/Part1/WindowsAndDialogs/RealTimeAlgebra"]], "Text",
 CellTags->"nlug:3.3.8",
 CellID->16182],

Cell[TextData[ButtonBox["AsteroidsGame.nb",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NETLink/example/Part1/WindowsAndDialogs/AsteroidsGame"]], "Text",
 CellTags->"nlug:3.3.8",
 CellID->18971]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Writing Your Own .NET Types to Use from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Section",
 CellID->18804],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
 CellTags->"nlug:3.4.0",
 CellID->12190],

Cell[TextData[{
 "This documentation has shown you how to load and use existing .NET types. \
This gives ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programmers immediate access to the entire universe of .NET types. \
Sometimes, though, existing types are not enough, and you need to write your \
own."
}], "Text",
 CellTags->"nlug:3.4.0",
 CellID->1381],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " essentially obliterates the boundary between .NET and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", allowing you to pass expressions of any type back and forth and use .NET \
objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in a meaningful way. This means that when writing your own .NET types to \
call from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you usually do not need to do anything special. You write the code in \
exactly the same way you would if you wanted to use the type only from .NET, \
and you can use any .NET language you like."
}], "Text",
 CellTags->"nlug:3.4.0",
 CellID->28910],

Cell[TextData[{
 "In some cases, you might want to exert more direct control over the \
interaction with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". For example, you might want a method to send a result to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that is different from what the method actually returns. Or you might want \
the method to not only return something, but also trigger a side effect in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[LongDash]for example, printing something or displaying a message under \
certain conditions. You can even have an extended \
\[OpenCurlyDoubleQuote]dialog\[CloseCurlyDoubleQuote] with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " before your method returns, perhaps invoking multiple computations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and reading their results. You might also want to write code that calls \
into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as the result of some event triggered in .NET."
}], "Text",
 CellTags->"nlug:3.4.0",
 CellID->5798],

Cell[TextData[{
 "If you do not want to do any of these things, then you can happily ignore \
this tutorial. The whole point of ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " is to make concern about the interaction with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " through ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " unnecessary. Most programmers who want to write .NET types to be used from \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will just write .NET types, period, without thinking about ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " or ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ". For those programmers who want more control or want to know more about \
the possibilities available with ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", read on."
}], "Text",
 CellTags->"nlug:3.4.0",
 CellID->8117],

Cell[TextData[{
 "One point to remember when creating your own types to use with ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " is that you must use ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 " to load the assembly that contains the types. Assemblies must always be \
loaded before the types they contain can be used in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", but it is easy to forget this because ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " automatically loads assemblies that are part of the .NET Framework as they \
are needed."
}], "Text",
 CellTags->"nlug:3.4.0",
 CellID->15444]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Manually Returning a Result to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Subsection",
 CellTags->"nlug:3.4.1",
 CellID->3012],

Cell[TextData[{
 "The default behavior of a .NET method or property called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is to return to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " exactly what the method or property itself returns. There are times, \
however, when you want to return something else. For example, you might want \
to return an integer in some circumstances and a symbol in others. Or you \
might want a method to return one thing when it is being called from .NET but \
return something different when called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In these cases, you will need to manually send a result to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " before the method returns."
}], "Text",
 CellTags->"nlug:3.4.1",
 CellID->1914],

Cell[TextData[{
 "Say you are writing a file-reading class that you want to call from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Because you want behavior that is almost identical to the standard class \
",
 StyleBox["System.IO.StreamReader", "MR"],
 ", your class will be a subclass of it. The only changes you want to make \
are to provide some more ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-like behavior. One example is that you want the ",
 StyleBox["Read()", "MR"],
 " method to return not -1 when it reaches the end of the file, but rather \
the symbol ",
 StyleBox["EndOfFile", "MR"],
 ", which is what ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s built-in file-reading functions return."
}], "Text",
 CellTags->"nlug:3.4.1",
 CellID->2164],

Cell["\<\
// C# code
using System.IO;
using Wolfram.NETLink;

public class MyFileReader : StreamReader {

\t... constructors, other methods deleted ...

\tpublic override int Read() {

\t\tint i = base.Read();
\t\tif (i == -1) {
\t\t\tIKernelLink link = StdLink.Link;
\t\t\tif (link != null) {
\t\t\t\tlink.BeginManual();
\t\t\t\tlink.PutSymbol(\"EndOfFile\");
\t\t\t}
\t\t}
\t\treturn i;
\t}
}\
\>", "Program",
 CellTags->"nlug:3.4.1",
 CellID->406552679],

Cell[TextData[{
 "If the file has reached the end, ",
 StyleBox["i", "MR"],
 " will be -1, and you want to manually return something to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The first thing you need to do is get an ",
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 " object that can be used to communicate with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This is obtained by calling the static property ",
 StyleBox["StdLink.Link", "MR"],
 ". If you have written installable ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs in C, you will recognize the choice of names here. A C program \
has a global variable named ",
 StyleBox["stdlink", "MR"],
 " that holds the link back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " has a ",
 StyleBox["StdLink", "MR"],
 " class that has a few methods related to this link object."
}], "Text",
 CellTags->"nlug:3.4.1",
 CellID->20593],

Cell[TextData[{
 "The next thing you do is check whether ",
 StyleBox["Link", "MR"],
 " returns ",
 StyleBox["null", "MR"],
 ". It will never be ",
 StyleBox["null", "MR"],
 " if the method is being called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", so you can use this test to determine whether the method is being called \
from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", or as part of a normal .NET program. In this way, you can have a method \
that can be used from .NET in the usual way when a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel is nowhere in sight."
}], "Text",
 CellTags->"nlug:3.4.1",
 CellID->14059],

Cell[TextData[{
 "Once you have verified that a link back to the kernel exists, the first \
thing you do is inform ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " that you will be sending the result back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " yourself, so it should not try to automatically send the method\
\[CloseCurlyQuote]s return value. This is accomplished by calling the ",
 StyleBox["BeginManual()", "MR"],
 " method on the ",
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 " object. "
}], "Text",
 CellTags->"nlug:3.4.1",
 CellID->17657],

Cell[TextData[{
 "You must call ",
 StyleBox["BeginManual()", "MR"],
 " before you send any part of a result back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If you fail to do this, the link will get out of sync and the next ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " call you make from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will probably hang. It is safe to call ",
 StyleBox["BeginManual()", "MR"],
 " more than once, so you do not have to worry that your method might be \
called from another method that has already called ",
 StyleBox["BeginManual()", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.4.1",
 CellID->29386],

Cell[TextData[{
 "Returning to the example program, the next thing after ",
 StyleBox["BeginManual()", "MR"],
 " is to make the required \
\[OpenCurlyDoubleQuote]put\[CloseCurlyDoubleQuote]-type calls to send the \
result back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " (in this case, just a single ",
 StyleBox["PutSymbol()", "MR"],
 "). The internal ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " code that wraps all method calls will handle the cleanup and recovery from \
any ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " error that might have occurred calling ",
 StyleBox["PutSymbol()", "MR"],
 ". You do not need to do anything for ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/MathLinkException"]], 
  "InlineFormula"],
 " exceptions that occur while you are putting a result \
manually\[LongDash]the method call will return ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically."
}], "Text",
 CellTags->"nlug:3.4.1",
 CellID->19479]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Requesting Evaluations by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Subsection",
 CellTags->"nlug:3.4.2",
 CellID->6115],

Cell[TextData[{
 "So far, you have seen only cases where a .NET method has a very simple \
interaction with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It is called and returns a result, either automatically or manually. \
There are many circumstances, however, where you might want to have a more \
complex interaction with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You might want a message to appear in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", or some ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " output, or you might want to have ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " evaluate something and return the answer to you. This is a completely \
separate issue from what you want to return to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " at the ",
 StyleBox["end",
  FontSlant->"Italic"],
 " of your method\[LongDash]you can request evaluations during the body of a \
method whether it returns its final result manually or not."
}], "Text",
 CellTags->"nlug:3.4.2",
 CellID->28056],

Cell[TextData[{
 "In some sense, when you perform this type of interaction with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " you are turning the tables on ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", reversing the \[OpenCurlyDoubleQuote]master\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]slave\[CloseCurlyDoubleQuote] roles for a moment. When \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " calls into .NET, the .NET code is acting as the slave, performing a \
computation and returning control to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In the middle of a .NET method, however, you can call back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", temporarily turning it into a computational server for the .NET side. \
Thus you would expect to encounter essentially all the same issues that are \
discussed in ",
 ButtonBox["Calling ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/guide/CallingMathematicaFromNET"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/guide/CallingMathematicaFromNET"],
  FontSlant->"Italic"],
 ButtonBox[" from .NET",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/guide/CallingMathematicaFromNET"],
 ", and you would need to understand the full ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " API as seen by .NET programmers."
}], "Text",
 CellTags->"nlug:3.4.2",
 CellID->16540],

Cell[TextData[{
 "The full treatment of the ",
 Cell[BoxData[
  ButtonBox["IMathLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IMathLink"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 " interfaces is presented in ",
 ButtonBox["Calling ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/guide/CallingMathematicaFromNET"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/guide/CallingMathematicaFromNET"],
  FontSlant->"Italic"],
 ButtonBox[" from .NET",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/guide/CallingMathematicaFromNET"],
 ". Here we will discuss a few special methods in ",
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 " interface that are specifically intended for use by \
\[OpenCurlyDoubleQuote]installed\[CloseCurlyDoubleQuote] methods. You have \
already seen one, the ",
 StyleBox["BeginManual()", "MR"],
 " method. This section will present the ",
 StyleBox["Message()", "MR"],
 ", ",
 StyleBox["Print()", "MR"],
 ", and ",
 StyleBox["Evaluate()", "MR"],
 " methods."
}], "Text",
 CellTags->"nlug:3.4.2",
 CellID->3282],

Cell[TextData[{
 "The tasks of issuing a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " message from a .NET method or triggering some ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " output are so commonly done that the ",
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 " interface has special methods for these operations. The method ",
 StyleBox["Message()", "MR"],
 " performs all the steps of issuing a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " message."
}], "Text",
 CellTags->"nlug:3.4.2",
 CellID->21339],

Cell["void Message(string symtag, params string[] args);", "Program",
 CellTags->"nlug:3.4.2",
 CellID->19827],

Cell[TextData[{
 "The ",
 StyleBox["Print()", "MR"],
 " method performs all the steps necessary to invoke ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " function."
}], "Text",
 CellTags->"nlug:3.4.2",
 CellID->18566],

Cell["public void Print(string s);", "Program",
 CellTags->"nlug:3.4.2",
 CellID->25582],

Cell[TextData[{
 "Here is an example method that uses both. Assume that the following \
messages are defined in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.4.2",
 CellID->20931],

Cell[TextData[StyleBox["Foo::arg = \"The `1` argument to foo must be greater \
than or equal to 0.\"", "MR"]], "Program",
 CellTags->"nlug:3.4.2",
 CellID->22090],

Cell["Here is the C# code.", "Text",
 CellTags->"nlug:3.4.2",
 CellID->29713],

Cell["\<\
public static double Foo(double x, double y) {

\tIKernelLink link = StdLink.Link;
\tif (link != null) {
\t\tlink.Print(\"inside foo\");
\t\tif (x < 0) 
\t\t\tlink.Message(\"Foo::arg\", \"first\");
\t\tif (y < 0) 
\t\t\tlink.Message(\"Foo::arg\", \"second\");
\t}
\treturn Math.Sqrt(x) * Math.Sqrt(y);
}\
\>", "Program",
 CellTags->"nlug:3.4.2",
 CellID->6231],

Cell[TextData[{
 "Note that ",
 StyleBox["Print()", "MR"],
 " and ",
 StyleBox["Message()", "MR"],
 " send the required code to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and also read the result from the link (it will always be the symbol ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ")."
}], "Text",
 CellTags->"nlug:3.4.2",
 CellID->29604],

Cell[TextData[{
 "Here is what happens when you call ",
 StyleBox["Foo()", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.4.2",
 CellID->1684],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "LoadNETAssembly", "[", "\"\<c:\\\\path\\\\to\\\\FooAssembly\>\"", "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"LoadNETType", "[", "\"\<FooClass\>\"", "]"}], ";"}], "\n", 
 RowBox[{"FooClass`Foo", "[", 
  RowBox[{"1.0", ",", 
   RowBox[{"-", "2.0"}]}], "]"}]}], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.4.2",
 CellID->10158],

Cell[BoxData[
 RowBox[{"inside", " ", "foo"}]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellTags->"nlug:3.4.2",
 CellID->7504],

Cell[BoxData[
 RowBox[{"Foo", "::", 
  RowBox[{"arg", ":", 
   RowBox[{
   "The", " ", "second", " ", "argument", " ", "to", " ", "foo", " ", "must", 
    " ", "be", " ", "greater", " ", "than", " ", "or", " ", "equal", " ", 
    "to", " ", "0."}]}]}]], "Message", "MSG",
 CellTags->"nlug:3.4.2",
 CellID->15748],

Cell[BoxData[
 StyleBox["Indeterminate", "MR"]], "Output",
 CellTags->"nlug:3.4.2",
 CellID->30158]
}, Open  ]],

Cell[TextData[{
 "Note that you automatically get ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " when a floating-point result from .NET is NaN \
(\[OpenCurlyDoubleQuote]Not-a-Number\[CloseCurlyDoubleQuote])."
}], "Text",
 CellTags->"nlug:3.4.2",
 CellID->28083],

Cell[TextData[{
 "The methods ",
 StyleBox["Print()", "MR"],
 " and ",
 StyleBox["Message()", "MR"],
 " are convenience functions for two special cases of the more general notion \
of sending intermediate evaluations to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " before your method returns a result. The general means of doing this is to \
wrap whatever you send to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "MR"]], "InlineFormula"],
 ", which is a signal to the kernel that this is not the final result, but \
rather something that it should evaluate and send the result back to .NET. \
You can explicitly send the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "MR"]], "InlineFormula"],
 " head, or you can use one of the methods in ",
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 " that uses ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "MR"]], "InlineFormula"],
 " for you. These methods are ",
 StyleBox["Evaluate()", "MR"],
 ", ",
 StyleBox["EvaluateToInputForm()", "MR"],
 ", ",
 StyleBox["EvaluateToOutputForm()", "MR"],
 ", ",
 StyleBox["EvaluateToImage()", "MR"],
 ", and ",
 StyleBox["EvaluateToTypeset()", "MR"],
 ". They are discussed in detail in the ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " ",
 ButtonBox["API documentation",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/ref/net/NETLink"],
 StyleBox[".",
  FontSlant->"Italic"]
}], "Text",
 CellTags->"nlug:3.4.2",
 CellID->8552],

Cell["Here is a simple example.", "Text",
 CellTags->"nlug:3.4.2",
 CellID->31498],

Cell["\<\
public static double Foo(double x, double y) {

\tIKernelLink link = StdLink.Link;
\tif (link != null) {
\t\tlink.Evaluate(\"2+2\");
\t\t// Wait for, and then read, the answer.
\t\tlink.WaitForAnswer();
\t\tint sum1 = link.GetInteger();
\t\t\t
\t\t// EvaluateToOutputForm makes the result come back as a
\t\t// string formatted in OutputForm, and all in one step
\t\t// (no WaitForAnswer call needed).
\t\tstring s = link.EvaluateToOutputForm(\"3+3\", 0);
\t\tint sum2 = Int32.Parse(s);

\t\t// If you want, put the whole evaluation piece by piece,
\t\t// including the EvaluatePacket head.
\t\tlink.PutFunction(\"EvaluatePacket\");
\t\tlink.PutFunction(\"Plus\", 2);
\t\tlink.Put(4);
\t\tlink.Put(4);
\t\tlink.WaitForAnswer();
\t\tint sum3 = link.GetInteger();
\t}
\treturn Math.Sqrt(x) * Math.Sqrt(y);
}
\
\>", "Program",
 CellTags->"nlug:3.4.2",
 CellID->31507]
}, Open  ]],

Cell[CellGroupData[{

Cell["Throwing Exceptions", "Subsection",
 CellTags->"nlug:3.4.3",
 CellID->21153],

Cell[TextData[{
 "Any exceptions that your method throws will be handled gracefully by ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", resulting in the printing of a message in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " describing the exception. This is discussed in ",
 ButtonBox["Exceptions",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#4946"],
 ". If you are sending computations to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", as described in the previous section, you need to make sure that an \
exception does not interrupt your code unexpectedly. In other words, if you \
start a transaction with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", make sure you complete it or you will leave the link out of sync and \
future calls to .NET will probably hang."
}], "Text",
 CellTags->"nlug:3.4.3",
 CellID->2474]
}, Open  ]],

Cell[CellGroupData[{

Cell["Making a Method Interruptible", "Subsection",
 CellTags->"nlug:3.4.4",
 CellID->7522],

Cell[TextData[{
 "If you are writing a method that may take a while to complete, you should \
consider making it interruptible from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In C ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs, a global variable named ",
 StyleBox["MLAbort", "MR"],
 " is provided for this purpose. In ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " programs, you call the ",
 StyleBox["WasInterrupted", "MR"],
 " property in the ",
 Cell[BoxData[
  ButtonBox["IKernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/net/IKernelLink"]], "InlineFormula"],
 " interface."
}], "Text",
 CellTags->"nlug:3.4.4",
 CellID->8685],

Cell[TextData[{
 "Here is an example method that performs a long computation, checking every \
100 iterations whether the user tried to abort it (using the ",
 StyleBox[ButtonBox["Interrupt Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/InterruptEvaluation"], "MenuName"],
 " or ",
 StyleBox[ButtonBox["Abort Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/AbortEvaluation"], "MenuName"],
 " commands in the ",
 StyleBox["Evaluation", "MenuName"],
 " menu)."
}], "Text",
 CellTags->"nlug:3.4.4",
 CellID->22184],

Cell["\<\
public int Foo() {

\tIKernelLink link = StdLink.Link;
\tfor (int i = 0; i < 10000, i++) {
\t\t... perform one step ...
\t\tif (i % 100 == 0 && link.WasInterrupted)
\t\t\treturn 0;  // Return value will not be seen by Mathematica.
\t}
\treturn 42;
}\
\>", "Program",
 CellTags->"nlug:3.4.4",
 CellID->11541],

Cell[TextData[{
 "This method returns 0 if it detects an attempt by the user to abort, but \
this value will never be seen by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This is because ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " causes a method, property, or constructor call that is aborted to return \
",
 Cell[BoxData[
  ButtonBox["Abort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abort"]], "InlineFormula"],
 StyleBox["[]", "MR"],
 ", whether or not you detect the abort in your code. Therefore, if you \
detect an abort and want to honor the user\[CloseCurlyQuote]s request, just \
return some value right away. When ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Abort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abort"]], "InlineFormula"],
 StyleBox["[]", "MR"],
 ", the user\[CloseCurlyQuote]s entire computation is aborted, just as if the \
",
 Cell[BoxData[
  ButtonBox["Abort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abort"]], "InlineFormula"],
 StyleBox["[]", "MR"],
 " was embedded in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. This means that you do not have to be concerned with any details of \
propagating the abort back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[LongDash]all you have to do is return prematurely if you detect an abort \
request, and the rest is handled for you."
}], "Text",
 CellTags->"nlug:3.4.4",
 CellID->22755],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " makes no distinction between an interrupt request and an abort request; \
they each cause ",
 StyleBox["WasInterrupted", "MR"],
 " to return ",
 StyleBox["true", "MR"],
 ". Recall that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has separate commands for interrupting and aborting computations. The \
\[OpenCurlyDoubleQuote]Abort\[CloseCurlyDoubleQuote] operation (\[AltKey]-. \
on Windows) causes the entire computation to end as soon as possible and \
return ",
 Cell[BoxData[
  ButtonBox["$Aborted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Aborted"]], "InlineFormula"],
 ". The \[OpenCurlyDoubleQuote]Interrupt\[CloseCurlyDoubleQuote] operation (\
\[AltKey]-, on Windows) brings up a dialog box with further choices. If this \
Interrupt dialog box is triggered when a .NET method is executing, it has a \
different set of buttons than when normal ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code is executing. One of the options is ",
 StyleBox["Send Abort to Linked Program", "SR"],
 " and another is ",
 StyleBox["Send Interrupt to Linked Program", "SR"],
 ". Both of these choices have the same effect for .NET methods, which is to \
cause ",
 StyleBox["WasInterrupted", "MR"],
 " to return ",
 StyleBox["true", "MR"],
 " and the call to return ",
 Cell[BoxData[
  ButtonBox["Abort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abort"]], "InlineFormula"],
 StyleBox["[]", "MR"],
 " when it completes. The third button is ",
 StyleBox["Kill Linked Program", "SR"],
 ", which will cause the .NET runtime to quit. If you call a .NET method that \
is not interruptible, killing the .NET runtime in this way is the only way to \
make the method call terminate. You can also kill the .NET runtime using the \
Windows Task Manager."
}], "Text",
 CellTags->"nlug:3.4.4",
 CellID->24939],

Cell[TextData[{
 "Sometimes you might want a .NET method to detect an abort and do something \
other than cause the entire ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " computation to abort. For example, you might want a loop to stop and \
return its results up to that point. Note that this is not generally \
recommended. Users expect a program to abort and return ",
 Cell[BoxData[
  ButtonBox["$Aborted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Aborted"]], "InlineFormula"],
 " when they issue an abort request. In some cases, however, especially if \
the code is not intended for use by a large community, you might find it \
useful to use an abort as a \[OpenCurlyDoubleQuote]message\
\[CloseCurlyDoubleQuote] to communicate some information to your .NET code \
instead of just having the computation aborted. This idea is similar to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s ",
 Cell[BoxData[
  ButtonBox["CheckAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckAbort"]], "InlineFormula"],
 " function, which allows you to detect an abort and absorb it so that it \
does not propagate further and abort the entire computation. To \
\[OpenCurlyDoubleQuote]absorb\[CloseCurlyDoubleQuote] the abort in your .NET \
code so that ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " does not return ",
 Cell[BoxData[
  ButtonBox["Abort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abort"]], "InlineFormula"],
 StyleBox["[]", "MR"],
 ", simply reset the ",
 StyleBox["WasInterrupted", "MR"],
 " property to ",
 StyleBox["false", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.4.4",
 CellID->6253],

Cell["Here is an example.", "Text",
 CellTags->"nlug:3.4.4",
 CellID->25676],

Cell["\<\
public int Foo() {

\tIKernelLink link = StdLink.Link;
\tfor (int i = 0; i < 10000, i++) {
\t\t... perform one step ...
\t\tif (i % 100 == 0 && link.WasInterrupted) {
\t\t\tlink.WasInterrupted = false;
\t\t\treturn resultSoFar; // This is the value that will be returned to \
Mathematica
\t\t}
\t}
\t...
\treturn 42;
}\
\>", "Program",
 CellTags->"nlug:3.4.4",
 CellID->17903]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writing Your Own Event Handler Code", "Subsection",
 CellTags->"nlug:3.4.5",
 CellID->18803],

Cell[TextData[{
 ButtonBox["Handling Events",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#21428"],
 " introduced the topic of triggering calls into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as a response to events fired in .NET, such as clicking a button. The ",
 Cell[BoxData[
  ButtonBox["AddEventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/AddEventHandler"]], "InlineFormula"],
 " function provides an easy means of setting up event handlers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You are not required to use ",
 Cell[BoxData[
  ButtonBox["AddEventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/AddEventHandler"]], "InlineFormula"],
 ", of course. You can create your own delegates in any .NET language to \
handle events and insert calls into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " directly into their code. If you choose to do this, there is one very \
important rule that must be adhered to when writing event handler code that \
calls into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You must always call ",
 StyleBox["StdLink.RequestTransaction()", "MR"],
 " before sending a computation to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 StyleBox["RequestTransaction()", "MR"],
 " will throw an exception if ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is not in a state where it is receptive to calls originating in .NET. You \
can catch this exception if you wish, or you can ignore it and ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " will catch it for you and issue a warning beep. In other words, ",
 StyleBox["RequestTransaction()", "MR"],
 " prevents you from interfering with the internals of ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " by trying to call the kernel when the kernel and ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " are not ready."
}], "Text",
 CellTags->"nlug:3.4.5",
 CellID->7434],

Cell[TextData[{
 "To be precise, ",
 StyleBox["RequestTransaction()", "MR"],
 " will throw an exception unless one of the following conditions holds."
}], "Text",
 CellTags->"nlug:3.4.5",
 CellID->16782],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5.1 or later is being used (in 5.1 and later the kernel is always shared \
with .NET)"
}], "BulletedText",
 CellTags->"nlug:3.4.5",
 CellID->2331],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is executing ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"]
}], "BulletedText",
 CellTags->"nlug:3.4.5",
 CellID->6746],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is executing ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 ", and the kernel is not busy servicing a computation from the front end"
}], "BulletedText",
 CellTags->"nlug:3.4.5",
 CellID->22870],

Cell[TextData[{
 "Kernel sharing has been turned on via ",
 StyleBox["ShareKernel", "MR"],
 " or  ",
 StyleBox["ShareFrontEnd", "MR"],
 ", and the kernel is not busy with another computation"
}], "BulletedText",
 CellTags->"nlug:3.4.5",
 CellID->1255],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is already in the middle of a call to .NET"
}], "BulletedText",
 CellTags->"nlug:3.4.5",
 CellID->18064],

Cell[CellGroupData[{

Cell[TextData[{
 ".NET is not being used from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " (that is, the code is called in a standalone .NET program that is using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for computations; ",
 Cell[BoxData[
  ButtonBox["InstallNET",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/InstallNET"]], "InlineFormula"],
 " has not been called)"
}], "BulletedText",
 CellTags->"nlug:3.4.5",
 CellID->31410],

Cell[TextData[{
 "The fifth bullet point above warrants further discussion. Recall that \
whenever ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has called into .NET, it is reading from the .NET link and therefore is \
receptive to calls that arrive from .NET. This means that callbacks to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from code that is itself called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " do not need to call ",
 StyleBox["RequestTransaction()", "MR"],
 " (although it is harmless to do so). Event handlers, however, are typically \
called as the result of some user action on the .NET side, and thus they \
originate in .NET."
}], "Text",
 CellTags->"nlug:3.4.5",
 CellID->24680],

Cell["\<\
The code below shows a prototypical event handler method written in C#.\
\>", "Text",
 CellTags->"nlug:3.4.5",
 CellID->8360],

Cell["\<\
// Add a delegate to the KeyPress event.
myTextBox.KeyPress += new KeyEventHandler(MyKeyPressHandler);
...

// Elsewhere, define MyKeyPressHandler as follows.
public void MyKeyPressHandler(object sender, KeyEventArgs eventArgs) { 

\tIKernelLink ml = StdLink.Link;
\tStdLink.RequestTransaction();
\t// Send a single computation to Mathematica to react to the KeyPress event.
\tml.PutFunction(\"EvaluatePacket\", 1);
\t... code to put rest of expression to evaluate goes here ...
\tml.EndPacket();
\tml.WaitAndDiscardAnswer();
}\
\>", "Program",
 CellTags->"nlug:3.4.5",
 CellID->25778]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Debugging Your .NET Classes", "Subsection",
 CellTags->"nlug:3.4.6",
 CellID->16227],

Cell[TextData[{
 "You can use your favorite debugger to debug .NET code that is called from \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The only issue is that you typically have to launch a .NET program inside \
the debugger to do this. The .NET program that you need to launch is ",
 StyleBox["InstallableNET.exe", "MR"],
 ", which is the program that is normally launched for you when you call ",
 Cell[BoxData[
  ButtonBox["InstallNET",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/InstallNET"]], "InlineFormula"],
 ". This program resides in the ",
 StyleBox["NETLink", "MR"],
 " directory right next to the ",
 StyleBox["Wolfram.NETLink.dll", "MR"],
 " assembly file."
}], "Text",
 CellTags->"nlug:3.4.6",
 CellID->23382],

Cell[TextData[{
 "If you are using Visual Studio .NET and you want to debug a class library \
project that you are using with ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", the exact steps depend on the language you are using. Select the project, \
and choose ",
 StyleBox["Properties", "SR"],
 " from the ",
 StyleBox["Project", "SR"],
 " menu. In the ",
 StyleBox["Debugging", "SR"],
 " panel of the ",
 StyleBox["Configuration Properties", "SR"],
 " section, set the startup application to be the ",
 StyleBox["InstallableNET.exe", "MR"],
 " program. Set the command-line arguments to something like ",
 StyleBox["-linkmode listen -linkname foo", "MR"],
 ". Then start the debugger. The ",
 StyleBox["InstallableNET", "MR"],
 " program will launch and wait for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to connect. In your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, execute the following."
}], "Text",
 CellTags->"nlug:3.4.6",
 CellID->25110],

Cell["InstallNET[LinkConnect[\"foo\"]]", "Input",
 Evaluatable->False,
 CellTags->"nlug:3.4.6",
 CellID->25087],

Cell[TextData[{
 "This works because ",
 Cell[BoxData[
  ButtonBox["InstallNET",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/InstallNET"]], "InlineFormula"],
 " can take a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkObject"], "MR"]], "InlineFormula"],
 " as its argument, in which case it will not try to launch .NET itself. This \
allows you to manually establish the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection between .NET and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then feed that link to ",
 Cell[BoxData[
  ButtonBox["InstallNET",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/InstallNET"]], "InlineFormula"],
 " and let it do the rest of the work of preparing the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and .NET sides to interact with each other."
}], "Text",
 CellTags->"nlug:3.4.6",
 CellID->31230]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Calling DLLs from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "Section",
 CellID->32076],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
 CellTags->{"Calling DLLS from Mathematica", "nlug:3.5.0"},
 CellID->24729],

Cell[TextData[{
 "This section describes how you can use ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " to call DLL functions from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". These are traditional Windows DLLs, typically C-language libraries \
(although many languages have the capability to create such DLLs). In .NET \
terminology, these types of DLLs are called \[OpenCurlyDoubleQuote]unmanaged\
\[CloseCurlyDoubleQuote] because they do not execute within the .NET runtime. \
Although the task of calling unmanaged functions does not appear to have \
anything to do with .NET, ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " can leverage existing facilities in .NET for calling such functions. In \
other words, because .NET can call DLLs, and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can call .NET, you can now easily call DLLs in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.5.0",
 CellID->5413],

Cell[TextData[{
 "The capability to easily call external C functions from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " means that Windows programmers have virtually no reason to ever write \
another so-called \[OpenCurlyDoubleQuote]template\[CloseCurlyDoubleQuote] ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program that wraps an external function and directly handles ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " communication. Other tutorials have shown how ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " eliminates the need for special programming to call .NET code. In this \
tutorial we see how ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " also eliminates those extra steps for calling legacy DLLs."
}], "Text",
 CellTags->"nlug:3.5.0",
 CellID->16603],

Cell[TextData[{
 "Many programming languages allow you to call DLL functions by simply \
\[OpenCurlyDoubleQuote]declaring\[CloseCurlyDoubleQuote] them with a line of \
code. Here are examples of such a declaration in several languages. The \
function is ",
 StyleBox["GetTickCount()", "MR"],
 ", which is part of the Windows API that is defined in ",
 StyleBox["kernel32.dll", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.5.0",
 CellID->29591],

Cell[TextData[{
 StyleBox["// Visual Basic 6\nDeclare Function GetTickCount Lib \"kernel32\" \
() As Long \n\n// Visual Basic .NET\n",
  FormatType->InputForm],
 "<DLLImport(\"kernel32.dll\")>\nShared Function GetTickCount() As Integer \n\
\n// C#",
 StyleBox["\n",
  FormatType->InputForm],
 "[DllImport(\"kernel32.dll\")]\nstatic extern int GetTickCount();"
}], "Program",
 CellTags->"nlug:3.5.0",
 CellID->17403],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 " is analogous to the above declarations. You specify the name of the DLL, \
the name of the function, and the types of the return value and arguments."
}], "Text",
 CellTags->"nlug:3.5.0",
 CellID->14964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"getTickCount", "=", 
  RowBox[{"DefineDLLFunction", "[", 
   RowBox[{
   "\"\<GetTickCount\>\"", ",", "\"\<kernel32.dll\>\"", ",", "\"\<int\>\"", 
    ",", 
    RowBox[{"{", "}"}]}], "]"}]}]], "Input",
 CellTags->"nlug:3.5.0",
 CellLabel->"In[142]:=",
 CellID->31695],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"Null", ",", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"NETLink`DLL`Private`checkArgCount", "[", 
      RowBox[{"\<\"GetTickCount\"\>", ",", 
       RowBox[{"{", "##1", "}"}], ",", "0"}], "]"}], ",", 
     RowBox[{
     "Wolfram`NETLink`DynamicDLLNamespace`DLLWrapper2`GetTickCount", "[", 
      "##1", "]"}], ",", "$Failed"}], "]"}], ",", 
   RowBox[{"{", "HoldAll", "}"}]}], "]"}]], "Output",
 CellTags->"nlug:3.5.0",
 CellLabel->"Out[142]=",
 CellID->30298]
}, Open  ]],

Cell[TextData[{
 "Note that ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 " returns a function. You should assign it to a symbol and then use that \
symbol as the name of the function:"
}], "Text",
 CellTags->"nlug:3.5.0",
 CellID->1042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"getTickCount", "[", "]"}]], "Input",
 CellTags->"nlug:3.5.0",
 CellLabel->"In[147]:=",
 CellID->30540],

Cell[BoxData["789292652"], "Output",
 CellTags->"nlug:3.5.0",
 CellLabel->"Out[147]=",
 CellID->19245]
}, Open  ]],

Cell[TextData[{
 "There are four arguments to ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 ". The first argument is the name of the function in the DLL. The second \
argument is the name of the DLL, and you can give either the full pathname to \
the DLL or just its filename. (",
 ButtonBox["How DLLs are Found",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#9297"],
 " discusses in detail how DLLs are found by ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ".) The third argument is the return type, given as a string. The fourth \
argument is a list of the types of the arguments. If the function takes zero \
arguments, like ",
 StyleBox["GetTickCount()", "MR"],
 ", you specify an empty list. The type specifications are strings, and ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " supports a number of ways to specify types. Type specifications are \
discussed in greater detail in the section ",
 ButtonBox["Specifying Arguments and Return Values",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#20321"],
 "."
}], "Text",
 CellTags->"nlug:3.5.0",
 CellID->32464],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DefineDLLFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/DefineDLLFunction"], "[", 
     StyleBox["\"\<funcName\>\"", "TI"], ",", 
     StyleBox["\"\<dllName\>\"", "TI"], ",", 
     StyleBox["returnType", "TI"], ",", "{", 
     StyleBox["argType", "TI"], ",", 
     StyleBox["...", "TI"], "}", "]"}], Cell[TextData[{
     "create a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " function suitable for calling the named function from the named DLL"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DefineDLLFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/DefineDLLFunction"], "[", 
     StyleBox["\"\<declaration\>\"", "TI"], "]"}], Cell["\<\
create a Mathematica function from a complete external function delcaration \
given in C# syntax\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->28222],

Cell["Defining DLL functions.", "Caption",
 CellID->30815],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 " supports several options. The first is ",
 Cell[BoxData[
  ButtonBox["CallingConvention",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CallingConvention"]], "InlineFormula"],
 ", which you need to use if the DLL function uses a calling convention \
different from the standard convention, which is \
\[OpenCurlyDoubleQuote]stdcall\[CloseCurlyDoubleQuote] on versions of Windows \
other than Windows CE. In rare cases, functions use the \
\[OpenCurlyDoubleQuote]cdecl\[CloseCurlyDoubleQuote] calling convention. The \
\[OpenCurlyDoubleQuote]thiscall\[CloseCurlyDoubleQuote] convention can be \
used when calling methods in C++ classes. See the .NET Framework \
documentation for the ",
 StyleBox["System.Runtime.InteropServices.CallingConvention", "MR"],
 " enumeration for more information on these values. For most uses, you leave \
the ",
 Cell[BoxData[
  ButtonBox["CallingConvention",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CallingConvention"]], "InlineFormula"],
 " option at its default setting."
}], "Text",
 CellTags->"nlug:3.5.0",
 CellID->10860],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["MarshalStringsAs",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/MarshalStringsAs"]], "InlineFormula"],
 " option is discussed in the section ",
 ButtonBox["Strings",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#16463"],
 ". The ",
 Cell[BoxData[
  ButtonBox["ReferencedAssemblies",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReferencedAssemblies"]], "InlineFormula"],
 " option is discussed in the section ",
 ButtonBox["Declarations Requiring Special Attributes",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#11743"],
 "."
}], "Text",
 CellTags->"nlug:3.5.0",
 CellID->21989],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["CallingConvention",
     BaseStyle->"Link",
     ButtonData->"paclet:NETLink/ref/CallingConvention"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
the calling convention expected by the DLL function (possible values are \
\"StdCall\", \"CDecl\", \"ThisCall\", and Automatic.\
\>", "TableText"]},
   {
    ButtonBox["MarshalStringsAs",
     BaseStyle->"Link",
     ButtonData->"paclet:NETLink/ref/MarshalStringsAs"], Cell[
    "\"ANSI\"", "MR"], Cell["\<\
how string arguments (char*, string, String) should be marshaled to and from \
the DLL function (possible values are \"ANSI\", \"Unicode\", and Automatic)\
\>", "TableText"]},
   {
    ButtonBox["ReferencedAssemblies",
     BaseStyle->"Link",
     ButtonData->"paclet:NETLink/ref/ReferencedAssemblies"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
a list of the names of assemblies referenced by your declaration\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"nlug:3.5.0",
 CellID->13770],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"nlug:3.5.0",
 CellID->14749]
}, Open  ]],

Cell[CellGroupData[{

Cell["How DLLs are Found", "Subsection",
 CellTags->{"How DLLs are Found", "nlug:3.5.1"},
 CellID->9297],

Cell[TextData[{
 "The second argument to ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 " is the name of the DLL in which the function resides. You can specify a \
full pathname to the DLL or just give the filename and rely on ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s automatic search mechanism to find it. DLLs can be \
found by just their filename if they are located on your system\
\[CloseCurlyQuote]s ",
 StyleBox["PATH", "MR"],
 " or if they are in special subdirectories within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " application directories. This automatic search of application directories \
allows you to distribute ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applications that include one or more DLLs without requiring your users to \
install the DLL files in a separate location outside your application \
directory."
}], "Text",
 CellTags->"nlug:3.5.1",
 CellID->8091],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applications are typically deployed as single directories (with \
subdirectories), installed into one of several standard locations where ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expects to find them. These standard locations can be written as ",
 StyleBox["$InstallationDirectory\\AddOns\\Applications", "InlineCode"],
 ", ",
 StyleBox["$BaseDirectory\\Applications", "MR"],
 ", and ",
 StyleBox["$UserBaseDirectory\\Applications", "MR"],
 ", where ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$InstallationDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$InstallationDirectory"], "MR"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$BaseDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$BaseDirectory"], "MR"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$UserBaseDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$UserBaseDirectory"], "MR"]], "InlineFormula"],
 " refer to the locations given by these built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbols. If your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " application includes DLLs that are intended to be called via ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", your application directory needs to be installed into one of these \
standard locations, and the DLLs need to be placed into a ",
 StyleBox["Libraries\\Windows", "MR"],
 " subdirectory of your application directory. ",
 ButtonBox["Distributing Applications that use ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#20220"],
 StyleBox[ButtonBox[".NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#20220"],
  FontSlant->"Italic"],
 " discusses the layout of an application directory in more detail."
}], "Text",
 CellTags->"nlug:3.5.1",
 CellID->25024],

Cell[TextData[{
 "When you call ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 ", no attempt is made to locate the DLL\[LongDash]that happens only when the \
function is first called. This means that if ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " cannot find the DLL or the named function within it, you will see an error \
message only when the function is called, not when it is defined."
}], "Text",
 CellTags->"nlug:3.5.1",
 CellID->3252]
}, Open  ]],

Cell[CellGroupData[{

Cell["Specifying Arguments and Return Values", "Subsection",
 CellTags->{"Specifying Arguments and Return Values", "nlug:3.5.2"},
 CellID->20321],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
 CellTags->"nlug:3.5.2",
 CellID->13740],

Cell[TextData[{
 "To specify the types of the return value and arguments you use strings such \
as \[OpenCurlyDoubleQuote]int\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]double\[CloseCurlyDoubleQuote], and \
\[OpenCurlyDoubleQuote]void\[CloseCurlyDoubleQuote].  You can use type names \
that conform to the syntax of whichever language you are most comfortable \
with (C, C#, or Visual Basic .NET). You can also use many type names used in \
the Windows API, such as \[OpenCurlyDoubleQuote]WORD\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]BOOL\[CloseCurlyDoubleQuote], and \
\[OpenCurlyDoubleQuote]LPSTR\[CloseCurlyDoubleQuote]. In most cases, you will \
be working from a function prototype in the C language, and it will be most \
convenient to use the names directly from the prototype. For example, \
consider the following declaration for the ",
 StyleBox["floor()", "MR"],
 " function from the ",
 StyleBox["math.h", "MR"],
 " header file in the Standard C library."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->19713],

Cell["double floor(double x);", "Program",
 CellTags->"nlug:3.5.2",
 CellID->26835],

Cell[TextData[{
 "It is not likely that you would want to call this particular mathematical \
function from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", but it serves as a simple example from a DLL that everyone will have. On \
Windows, the C runtime library is in the DLL ",
 StyleBox["msvcrt.dll", "MR"],
 ". Here is one way to use ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 " to create a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function that calls the ",
 StyleBox["floor()", "MR"],
 " function."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->28316],

Cell[BoxData[
 RowBox[{
  RowBox[{"externalFloor", "=", 
   RowBox[{"DefineDLLFunction", "[", 
    RowBox[{
    "\"\<floor\>\"", ",", "\"\<msvcrt.dll\>\"", ",", "\"\<double\>\"", ",", 
     RowBox[{"{", "\"\<double\>\"", "}"}]}], "]"}]}], ";"}]], "Input",
 CellTags->"nlug:3.5.2",
 CellLabel->"In[158]:=",
 CellID->5489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"externalFloor", "[", "4.2", "]"}]], "Input",
 CellTags->"nlug:3.5.2",
 CellLabel->"In[161]:=",
 CellID->27796],

Cell[BoxData["4.`"], "Output",
 CellTags->"nlug:3.5.2",
 CellLabel->"Out[161]=",
 CellID->26548]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 " allows you to use the C type names directly, which is handy when you are \
looking at a C-language prototype from a header file. The following are \
equivalent ways of making the same definition."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->2664],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Using", " ", "Visual", " ", "Basic"}], "-", 
    RowBox[{"style", " ", 
     RowBox[{"names", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"DefineDLLFunction", "[", 
     RowBox[{
     "\"\<floor\>\"", ",", "\"\<msvcrt.dll\>\"", ",", "\"\<Double\>\"", ",", 
      RowBox[{"{", "\"\<Double\>\"", "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Using", " ", "Visual", " ", "Basic"}], "-", 
     RowBox[{
     "style", " ", "names", " ", "with", " ", "full", " ", "VB", " ", 
      RowBox[{"syntax", "."}]}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"DefineDLLFunction", "[", 
     RowBox[{
     "\"\<floor\>\"", ",", "\"\<msvcrt.dll\>\"", ",", "\"\<Double\>\"", ",", 
      RowBox[{"{", "\"\<ByVal d As Double\>\"", "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Using", ".", "NET"}], " ", "Framework", " ", 
     RowBox[{"names", "."}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"DefineDLLFunction", "[", 
     RowBox[{
     "\"\<floor\>\"", ",", "\"\<msvcrt.dll\>\"", ",", "\"\<System.Double\>\"",
       ",", 
      RowBox[{"{", "\"\<System.Double\>\"", "}"}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellTags->"nlug:3.5.2",
 CellID->25858],

Cell[TextData[{
 "Using C# or Visual Basic .NET syntax for type names is convenient if you \
are copying an external function declaration from some sample code in one of \
those languages. In fact, the easiest way to use ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 " is to find an existing declaration for the external function in some C# or \
Visual Basic .NET sample code, and just copy the type names used in that \
declaration. Here is what declarations for ",
 StyleBox["floor()", "MR"],
 " would look like in those languages."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->20543],

Cell[TextData[{
 StyleBox["// Visual Basic .NET\n",
  FormatType->InputForm],
 "<DLLImport(\"msvcrt.dll\")>\nShared Function floor(ByVal d As Double) As \
Double \n\n// C#",
 StyleBox["\n",
  FormatType->InputForm],
 "[DllImport(\"msvcrt.dll\")]\nstatic extern double floor(double);"
}], "Program",
 CellTags->"nlug:3.5.2",
 CellID->5081],

Cell[TextData[{
 "You can also use a Visual Basic 6 ",
 StyleBox["Declare Function", "MR"],
 " statement as a guide to the correct type names, but keep in mind some \
important differences between VB 6 and VB .NET. First, in VB 6 parameters are \
",
 StyleBox["ByRef", "MR"],
 " by default (they are ",
 StyleBox["ByVal", "MR"],
 " by default in VB .NET), so a type name like ",
 StyleBox["Double", "MR"],
 " in a VB 6 declaration should be translated to ",
 StyleBox["ByRef Double", "MR"],
 ". Also, ",
 StyleBox["Integer", "MR"],
 " in VB 6 is equivalent to ",
 StyleBox["Short", "MR"],
 " in VB .NET, and ",
 StyleBox["Long", "MR"],
 " in VB 6 is equivalent to ",
 StyleBox["Integer", "MR"],
 " in VB .NET. You must use type names that are appropriate for VB .NET."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->5580],

Cell["\<\
The following subsections discuss allowed type names in greater detail.\
\>", "Text",
 CellTags->"nlug:3.5.2",
 CellID->21407]
}, Open  ]],

Cell[CellGroupData[{

Cell["Primitive Types", "Subsubsection",
 CellTags->"nlug:3.5.2",
 CellID->4436],

Cell[TextData[{
 "The following table shows what type names are legal to use for primitive \
types (i.e., integers, reals, booleans) and what types they map to in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->27670],

Cell[BoxData[GridBox[{
   {Cell["Type in External Function Declaration", "TableHeader"], Cell[
    "Mathematica Type", "TableHeader"]},
   {
    StyleBox[
     RowBox[{"C", "-", "language", " ", "names", ":"}],
     FontSlant->"Italic"], 
    ButtonBox["Integer",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integer"]},
   {
    RowBox[{"    ", 
     RowBox[{"char", ",", " ", "int", ",", " ", "short", ",", "\n", "\t", 
      RowBox[{"long", " ", 
       RowBox[{"(", 
        RowBox[{"and", " ", "unsigned", " ", "versions"}], ")"}]}]}]}], ""},
   {
    StyleBox[
     RowBox[{"C", "#", " ", "names", ":"}],
     FontSlant->"Italic"], ""},
   {
    RowBox[{"    ", 
     RowBox[{
     "byte", ",", " ", "sbyte", ",", " ", "char", ",", " ", "short", ",", 
      "\n", "\t", 
      RowBox[{"int", " ", 
       RowBox[{"(", 
        RowBox[{"and", " ", "unsigned", " ", "versions"}], ")"}]}]}]}], ""},
   {
    StyleBox[
     RowBox[{"Visual", " ", "Basic", " ", ".", "NET", " ", "names", ":"}],
     FontSlant->"Italic"], ""},
   {
    RowBox[{"    ", 
     RowBox[{"Short", ",", " ", "Integer", ",", "\n", "\t", 
      RowBox[{"Long", "   ", 
       RowBox[{"(", 
        RowBox[{"these", " ", "are", " ", "all", " ", "ByVal"}], ")"}]}]}]}], 
    ""},
   {
    StyleBox[
     RowBox[{".", "NET", " ", "Framework", " ", "names", ":"}],
     FontSlant->"Italic"], ""},
   {
    RowBox[{"    ", 
     RowBox[{
     "Byte", ",", " ", "SByte", ",", " ", "Char", ",", " ", "Int16", ",", " ",
       "UInt16", ",", " ", "\n", "    ", "Int32", ",", " ", "UInt32", ",", 
      " ", "Int64", ",", " ", "UInt64"}]}], ""},
   {
    StyleBox[
     RowBox[{"Win32", " ", "API", " ", "names", ":"}],
     FontSlant->"Italic"], ""},
   {
    RowBox[{"    ", 
     RowBox[{
     "BOOL", ",", " ", "BYTE", ",", " ", "SHORT", ",", " ", "INT", ",", " ", 
      "UINT", ",", "\n", "    ", "LONG", ",", " ", "WORD", ",", " ", "DWORD", 
      ",", " ", "LPARAM", ",", " ", "WPARAM"}]}], ""},
   {" ", " "},
   {
    RowBox[{
    "float", ",", " ", "double", ",", " ", "Single", ",", " ", "Double"}], 
    ButtonBox["Real",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Real"]},
   {" ", " "},
   {
    RowBox[{"bool", ",", " ", "Boolean"}], 
    RowBox[{
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], " ", "or", " ", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}]},
   {" ", " "},
   {
    RowBox[{"void", ",", " ", "Void"}], 
    RowBox[{
     ButtonBox["Null",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Null"], ",", " ", "when", " ", "used", " ", 
     "for", " ", "a", " ", "return", " ", "value", ";", " ", "for", " ", 
     "zero", "-", "argument", " ", "functions", ",", " ", "use", " ", "{", 
     "}", " ", "as", " ", "the", " ", "argument", " ", "type", " ", "list"}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], False, False, False, False, False, False, False, 
     False, False, False, True, False, True, False, True, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.55], {
      Scaled[0.45]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellTags->"nlug:3.5.2",
 CellID->29662],

Cell[TextData[{
 "Legal type specifications for primitive types in ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"nlug:3.5.2",
 CellID->22863],

Cell[TextData[{
 "The use of the above type names should be straightforward. Note that \
\[OpenCurlyDoubleQuote]long\[CloseCurlyDoubleQuote] means a standard Windows \
C long (4 bytes), not the C# long, which is 8 bytes. Also, the Windows API ",
 StyleBox["BOOL", "MR"],
 " type is mapped to an integer (0 and non-zero) rather than ",
 StyleBox["True", "MR"],
 " and ",
 StyleBox["False", "MR"],
 ". Pointers to, and arrays of, primitive types are discussed in a later \
subsection."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->9166]
}, Open  ]],

Cell[CellGroupData[{

Cell["Strings", "Subsubsection",
 CellTags->{"strings in DLLs", "nlug:3.5.2"},
 CellID->16463],

Cell[TextData[{
 "There are some subtleties you need to be aware of when calling DLL \
functions that take and return strings. These center on how the DLL function \
expects strings to be represented: either as ANSI-style, single-byte, \
null-terminated strings or as Unicode, double-byte, null-terminated strings. \
The process of converting data from one representation to another as it moves \
across system boundaries is called ",
 StyleBox["marshaling",
  FontSlant->"Italic"],
 ". The default behavior of .NET when calling unmanaged code is to marshal \
strings as single-byte, null-terminated strings, because most DLL functions \
are written to handle this common C string format. If you need different \
behavior than the default, you can use the ",
 Cell[BoxData[
  ButtonBox["MarshalStringsAs",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/MarshalStringsAs"]], "InlineFormula"],
 " option to ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->29055],

Cell[TextData[{
 "Here are examples of two DLL functions from the Windows C runtime library \
that operate on different types of strings. Each converts a string to \
lowercase; the ",
 StyleBox["_strlwr()", "MR"],
 " function takes an ANSI string and the ",
 StyleBox["_wcslwr()", "MR"],
 " function takes a wide-character string."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->6598],

Cell["\<\
char *_strlwr(char *string);

wchar_t *_wcslwr(wchar_t *string);\
\>", "Program",
 CellTags->"nlug:3.5.2",
 CellID->15772],

Cell[TextData[{
 "Here are calls to ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 " for both of these functions. Because the ",
 StyleBox["_wcslwr()", "MR"],
 " function takes and returns a wide-character string, you need to override \
the default marshaling of strings."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->19331],

Cell[BoxData[{
 RowBox[{
  RowBox[{"strlwr", "=", 
   RowBox[{"DefineDLLFunction", "[", 
    RowBox[{
    "\"\<_strlwr\>\"", ",", "\"\<msvcrt.dll\>\"", ",", "\"\<string\>\"", ",", 
     
     RowBox[{"{", "\"\<string\>\"", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"wcslwr", "=", 
   RowBox[{"DefineDLLFunction", "[", 
    RowBox[{
    "\"\<_wcslwr\>\"", ",", "\"\<msvcrt.dll\>\"", ",", "\"\<string\>\"", ",", 
     
     RowBox[{"{", "\"\<string\>\"", "}"}], ",", 
     RowBox[{"MarshalStringsAs", "\[Rule]", "\"\<Unicode\>\""}]}], "]"}]}], 
  ";"}]}], "Input",
 CellTags->"nlug:3.5.2",
 CellLabel->"In[197]:=",
 CellID->1861],

Cell["\<\
Both functions behave identically on a string with characters that fit into a \
single byte.\
\>", "Text",
 CellTags->"nlug:3.5.2",
 CellID->28300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"strlwr", "[", "\"\<ABC\>\"", "]"}], "\[Equal]", 
  RowBox[{"wcslwr", "[", "\"\<ABC\>\"", "]"}], "\[Equal]", 
  "\"\<abc\>\""}]], "Input",
 CellTags->"nlug:3.5.2",
 CellLabel->"In[199]:=",
 CellID->18493],

Cell[BoxData["True"], "Output",
 CellTags->"nlug:3.5.2",
 CellLabel->"Out[199]=",
 CellID->12041]
}, Open  ]],

Cell[TextData[{
 "As expected, the ",
 StyleBox["strlwr", "MR"],
 " function fails on a string with characters that require two bytes. Note \
that the \[Pi] character is truncated to a single byte (in this example the \
truncation occurs as the string is passed from .NET into the DLL, but it \
would also happen on the way back out of the DLL)."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->30649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"strlwr", "[", "\"\<A\[Pi]B\>\"", "]"}]], "Input",
 CellTags->"nlug:3.5.2",
 CellLabel->"In[200]:=",
 CellID->23644],

Cell[BoxData["\<\"apb\"\>"], "Output",
 CellTags->"nlug:3.5.2",
 CellLabel->"Out[200]=",
 CellID->4237]
}, Open  ]],

Cell["Things work when you call the wide-character version:", "Text",
 CellTags->"nlug:3.5.2",
 CellID->13082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"wcslwr", "[", "\"\<A\[Pi]B\>\"", "]"}]], "Input",
 CellTags->"nlug:3.5.2",
 CellLabel->"In[202]:=",
 CellID->7619],

Cell[BoxData["\<\"a\[Pi]b\"\>"], "Output",
 CellTags->"nlug:3.5.2",
 CellLabel->"Out[202]=",
 CellID->30667]
}, Open  ]],

Cell[TextData[{
 "If you have more than one string as a parameter or return type and the \
strings must be marshaled differently, then you cannot use the ",
 Cell[BoxData[
  ButtonBox["MarshalStringsAs",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/MarshalStringsAs"]], "InlineFormula"],
 " option, as this applies to all strings in the function. You can use the \
special \[OpenCurlyDoubleQuote]full declaration\[CloseCurlyDoubleQuote] form \
for ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 ", as discussed in ",
 ButtonBox["Declarations Requiring Special Attributes",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#11743"],
 "."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->10463],

Cell[BoxData[GridBox[{
   {Cell["Type in External Function Declaration", "TableHeader"], Cell[
    "Mathematica Type", "TableHeader"]},
   {
    StyleBox[
     RowBox[{"C", "-", "language", " ", "names", ":"}],
     FontSlant->"Italic"], 
    ButtonBox["String",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/String"]},
   {
    RowBox[{"    ", 
     RowBox[{"char", "*"}]}], ""},
   {
    StyleBox[
     RowBox[{"C", "#", " ", "names", ":"}],
     FontSlant->"Italic"], ""},
   {
    RowBox[{"    ", "string"}], ""},
   {
    StyleBox[
     RowBox[{"Visual", " ", "Basic", " ", ".", "NET", " ", "names", ":"}],
     FontSlant->"Italic"], ""},
   {
    RowBox[{"    ", "String"}], ""},
   {
    StyleBox[
     RowBox[{".", "NET", " ", "Framework", " ", "names", ":"}],
     FontSlant->"Italic"], ""},
   {
    RowBox[{"    ", "String"}], ""},
   {
    StyleBox[
     RowBox[{"Win32", " ", "API", " ", "names", ":"}],
     FontSlant->"Italic"], ""},
   {
    RowBox[{"    ", 
     RowBox[{"LPSTR", ",", " ", "LPCSTR"}]}], ""}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.45], {
      Scaled[0.55]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellTags->"nlug:3.5.2",
 CellID->28816],

Cell[TextData[{
 "Legal type specifications for strings in ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 ". These are all equivalent."
}], "Caption",
 CellTags->"nlug:3.5.2",
 CellID->32610],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 " for ",
 StyleBox["_strlwr()", "MR"],
 " and ",
 StyleBox["_wcslwr()", "MR"],
 ", we used the type name \[OpenCurlyDoubleQuote]string,\
\[CloseCurlyDoubleQuote] which is C# syntax, to indicate a string. As the \
table above shows, the following are completely equivalent declarations."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->32042],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"C", " ", 
    RowBox[{"syntax", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"DefineDLLFunction", "[", 
     RowBox[{
     "\"\<_strlwr\>\"", ",", "\"\<msvcrt.dll\>\"", ",", "\"\<char*\>\"", ",", 
      
      RowBox[{"{", "\"\<char*\>\"", "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"C", "#", " ", 
     RowBox[{"syntax", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DefineDLLFunction", "[", 
     RowBox[{
     "\"\<_strlwr\>\"", ",", "\"\<msvcrt.dll\>\"", ",", "\"\<string\>\"", ",",
       
      RowBox[{"{", "\"\<string\>\"", "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"VB", ".", "NET"}], " ", 
     RowBox[{"syntax", ":"}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"DefineDLLFunction", "[", 
     RowBox[{
     "\"\<_strlwr\>\"", ",", "\"\<msvcrt.dll\>\"", ",", "\"\<String\>\"", ",",
       
      RowBox[{"{", "\"\<String\>\"", "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Alternate", " ", 
     RowBox[{"VB", ".", "NET"}], " ", 
     RowBox[{"syntax", ":"}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"DefineDLLFunction", "[", 
     RowBox[{
     "\"\<_strlwr\>\"", ",", "\"\<msvcrt.dll\>\"", ",", "\"\<String\>\"", ",",
       
      RowBox[{"{", "\"\<ByVal d As String\>\"", "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{".", "NET"}], " ", "Framework", " ", 
     RowBox[{"names", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DefineDLLFunction", "[", 
     RowBox[{
     "\"\<_strlwr\>\"", ",", "\"\<msvcrt.dll\>\"", ",", 
      "\"\<System.String\>\"", ",", 
      RowBox[{"{", "\"\<System.String\>\"", "}"}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellTags->"nlug:3.5.2",
 CellID->12619],

Cell[TextData[{
 "So far we have only ",
 "discussed",
 " strings used as \[OpenCurlyDoubleQuote][in]\[CloseCurlyDoubleQuote] \
parameters to functions\[LongDash]that is, where character data is being sent \
",
 StyleBox["into",
  FontSlant->"Italic"],
 " the function. Some functions that are typed to take ",
 StyleBox["char*", "MR"],
 " use the string as an \[OpenCurlyDoubleQuote][out]\[CloseCurlyDoubleQuote] \
parameter, meaning that it is actually a buffer that is written into by the \
function. Functions that use strings as [out] parameters typically require \
you to pass in an extra argument that gives the length of the string buffer \
you have allocated, or they have a documented maximum number of characters \
that they will write into your buffer. An example of a function that writes \
data into a string is the familiar Standard C library function ",
 StyleBox["sprintf()", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->18413],

Cell["\<\
int sprintf(char *buffer, const char *format [,argument] ...);\
\>", "Program",
 CellTags->"nlug:3.5.2",
 CellID->30880],

Cell[TextData[{
 "The ",
 StyleBox["buffer", "MR"],
 " argument is a string into which the function writes. It is an [out] \
parameter, and although you could pass a string of data into this function to \
be overwritten  (provided it was long enough so that the written data did not \
overrun the length of the string), you would have no way of ",
 "getting",
 " the modified string back out. The .NET runtime supports a special trick \
for working with [out] string parameters, which is to use an instance of the \
",
 StyleBox["System.Text.StringBuilder", "MR"],
 " class. A ",
 StyleBox["StringBuilder", "MR"],
 " is marshaled to an unmanaged function as a character buffer. After the \
function returns, the ",
 StyleBox["StringBuilder", "MR"],
 " object will hold the data that was written into the buffer. You can \
extract the data as a string using the ",
 StyleBox["StringBuffer.ToString()", "MR"],
 " method."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->8108],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s see how this is done with the ",
 StyleBox["sprintf()", "MR"],
 " function. This function takes a variable argument count, but ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 " cannot handle that, so we will define a version specifically for the case \
of one integer argument after the format string (three total arguments). "
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->31306],

Cell[BoxData[
 RowBox[{
  RowBox[{"sprintf", "=", 
   RowBox[{"DefineDLLFunction", "[", 
    RowBox[{
    "\"\<sprintf\>\"", ",", "\"\<msvcrt.dll\>\"", ",", "\"\<int\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<System.Text.StringBuilder\>\"", ",", "\"\<const char*\>\"", ",", 
       "\"\<int\>\""}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellTags->"nlug:3.5.2",
 CellLabel->"In[222]:=",
 CellID->18847],

Cell[TextData[{
 "One small point to note in the above call to ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 " is that you can specify a ",
 StyleBox["const", "MR"],
 " qualifier on any argument slot. It is ignored by ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " because it is not relevant for ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s purposes, but you can use it if you think it makes your \
declarations more self-documenting or if you are just blindly copying a C \
function prototype."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->4806],

Cell[TextData[{
 "To call ",
 StyleBox["sprintf", "MR"],
 " you first create a ",
 StyleBox["StringBuilder", "MR"],
 " object that has a buffer large enough to hold all the data that might be \
written into it. This example will use a small string, so 20 bytes is more \
than enough."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->21452],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sb", "=", 
   RowBox[{"NETNew", "[", 
    RowBox[{"\"\<System.Text.StringBuilder\>\"", ",", "20"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sprintf", "[", 
  RowBox[{"sb", ",", "\"\<xxx%daaa\>\"", ",", "42"}], "]"}]}], "Input",
 CellTags->"nlug:3.5.2",
 CellLabel->"In[223]:=",
 CellID->13696],

Cell[BoxData["8"], "Output",
 CellTags->"nlug:3.5.2",
 CellLabel->"Out[224]=",
 CellID->29571]
}, Open  ]],

Cell[TextData[{
 "The return value is the number of characters written into the buffer. To \
see the string, call ",
 StyleBox["ToString()", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->23500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sb", "@", 
  RowBox[{"ToString", "[", "]"}]}]], "Input",
 CellTags->"nlug:3.5.2",
 CellLabel->"In[225]:=",
 CellID->6377],

Cell[BoxData["\<\"xxx42xxx\"\>"], "Output",
 CellTags->"nlug:3.5.2",
 CellLabel->"Out[225]=",
 CellID->10456]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Arrays and Pointers", "Subsubsection",
 CellTags->"nlug:3.5.2",
 CellID->26535],

Cell[TextData[{
 "When dealing with functions that take or return pointers or arrays, you \
need to be a little careful and make sure you understand how the parameter is \
treated by the function you are calling. For example, if you see a parameter \
of type ",
 StyleBox["int*", "MR"],
 ", it could be any of the following:"
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->21011],

Cell["\<\
an array of integers passed in to the function (an [in] array)\
\>", "BulletedText",
 CellTags->"nlug:3.5.2",
 CellID->1587],

Cell["\<\
an array of integers that will be written into by the function (an [out] \
array), that possibly also requires initial values in the array (an [in, out] \
array)\
\>", "BulletedText",
 CellTags->"nlug:3.5.2",
 CellID->225412227],

Cell[CellGroupData[{

Cell["\<\
the address of an integer variable that will have a value written into it by \
the function (an [out] int), that possibly also requires an initial value (an \
[in, out] int)\
\>", "BulletedText",
 CellTags->"nlug:3.5.2",
 CellID->130001283],

Cell[TextData[{
 "Each of these possibilities requires a different type specification in ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 ". As an example, consider the ",
 StyleBox["modf()", "MR"],
 " function from the Standard C library:"
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->6102],

Cell["double modf(double d, double* pint);", "Program",
 CellTags->"nlug:3.5.2",
 CellID->84],

Cell[TextData[{
 "This function breaks up the double ",
 StyleBox["d", "MR"],
 " into an integer plus a fraction. The fraction is the return value, and the \
integer value is stored in the double pointed to by ",
 StyleBox["pint", "MR"],
 ". From this description you can see that the ",
 StyleBox["double*", "MR"],
 " parameter is not an array, but the address of a double that will get \
written into (an [out] ",
 StyleBox["double", "MR"],
 "). Try calling ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 " using the type names directly from the prototype and see what you get."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->14423],

Cell["\<\
modf = DefineDLLFunction[\"modf\", \"msvcrt.dll\", \"double\", {\"double\", \
\"double*\"}];\
\>", "Input",
 CellTags->"nlug:3.5.2",
 CellLabel->"In[251]:=",
 CellID->7883],

Cell[TextData[{
 "When you use a pointer type like ",
 StyleBox["double*", "MR"],
 " directly in ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 ", as in the above example, ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " assumes that the parameter is an [in, out] ",
 StyleBox["double", "MR"],
 " (the last item in the bullet list above). In C# notation this type of \
parameter is called ",
 StyleBox["ref double", "MR"],
 ", and in Visual Basic .NET notation it is ",
 StyleBox["ByRef As Double", "MR"],
 ". From ",
 ButtonBox["\[OpenCurlyDoubleQuote]Out\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]Ref\[CloseCurlyDoubleQuote] Parameters",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#15993"],
 ", you know that what you need to pass to a ",
 StyleBox["ref", "MR"],
 " parameter slot is a symbol that has a value of the correct type going in, \
and that this symbol will also be assigned a possibly modified value on the \
way out. This means that to call ",
 StyleBox["modf", "MR"],
 " and have it assign the second argument to a symbol called ",
 StyleBox["integerPart", "MR"],
 ", we need to give ",
 StyleBox["integerPart", "MR"],
 " a numerical value before the call or ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " will complain about bad arguments."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->22313],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"integerPart", "=", "0"}], ";"}], "\n", 
 RowBox[{"modf", "[", 
  RowBox[{"3.5", ",", "integerPart"}], "]"}]}], "Input",
 CellTags->"nlug:3.5.2",
 CellLabel->"In[253]:=",
 CellID->9003469],

Cell[BoxData["0.5`"], "Output",
 CellTags->"nlug:3.5.2",
 CellLabel->"Out[254]=",
 CellID->26079]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["integerPart"], "Input",
 CellTags->"nlug:3.5.2",
 CellLabel->"In[255]:=",
 CellID->12582],

Cell[BoxData["3.`"], "Output",
 CellTags->"nlug:3.5.2",
 CellLabel->"Out[255]=",
 CellID->16000]
}, Open  ]],

Cell[TextData[{
 "This is not ideal because the second argument is conceptually an [out] ",
 StyleBox["double", "MR"],
 ", not an [in, out] ",
 StyleBox["double", "MR"],
 "\[LongDash]its value going into the function is not used, so there is no \
point in having to give it any value before the call. To improve the \
definition you can use ",
 StyleBox["\"out double\"", "MR"],
 " instead of ",
 StyleBox["\"double*\"", "MR"],
 " as the type specification."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->1616],

Cell[BoxData[
 RowBox[{
  RowBox[{"betterModf", "=", 
   RowBox[{"DefineDLLFunction", "[", 
    RowBox[{
    "\"\<modf\>\"", ",", "\"\<msvcrt.dll\>\"", ",", "\"\<double\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<double\>\"", ",", "\"\<out double\>\""}], "}"}]}], "]"}]}],
   ";"}]], "Input",
 CellTags->"nlug:3.5.2",
 CellLabel->"In[256]:=",
 CellID->26358],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "integerPart", "]"}], ";"}], "\n", 
 RowBox[{"betterModf", "[", 
  RowBox[{"3.5", ",", "integerPart"}], "]"}], "\n", "integerPart"}], "Input",
 CellTags->"nlug:3.5.2",
 CellID->17843],

Cell[BoxData["0.5`"], "Output",
 CellTags->"nlug:3.5.2",
 CellLabel->"Out[258]=",
 CellID->27807],

Cell[BoxData["3.`"], "Output",
 CellTags->"nlug:3.5.2",
 CellLabel->"Out[259]=",
 CellID->7909]
}, Open  ]],

Cell[TextData[{
 "In summary, if you use a pointer type directly in ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 ", ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " will treat this as a ",
 StyleBox["ref", "MR"],
 " (C# notation) or ",
 StyleBox["ByRef", "MR"],
 " (VB notation) parameter. If this does not correctly capture the use of the \
parameter, you should use a different type specification. I prefer to use C# \
notation for type names, so that an ",
 StyleBox["int*", "MR"],
 " parameter that is treated as an address of an integer that will be written \
into is specified as ",
 StyleBox["\"out int\"", "MR"],
 ". If the value is both read and written by the function it is a ",
 StyleBox["\"ref int\"", "MR"],
 ". Visual Basic .NET does not have a syntax for a \
\[OpenCurlyDoubleQuote]pure\[CloseCurlyDoubleQuote] [out] parameter, so using \
C# notation is the best choice for that case."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->415],

Cell[TextData[{
 "So far we have not considered the case of an array parameter. In a C \
function prototype, ",
 StyleBox["int*", "MR"],
 " could mean an array of ",
 StyleBox["int", "MR"],
 "s, although this would often be written as ",
 StyleBox["int[]", "MR"],
 ". If you need to pass an array of data to a DLL function, the parameter \
type must be written with array brackets, as in ",
 StyleBox["\"int[]\"", "MR"],
 ", not as ",
 StyleBox["\"int*\"", "MR"],
 " (you have already seen how ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 " treats types declared explicitly as pointers). Consider the following two \
(fictitious) DLL function prototypes."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->24765],

Cell["\<\
int SumArray(int[] array, int length);

void ReverseArray(int[] array, int length);\
\>", "Program",
 CellTags->"nlug:3.5.2",
 CellID->4530],

Cell[TextData[{
 "The ",
 StyleBox["SumArray()", "MR"],
 " function takes an array of integers and the length of the array, and it \
returns the sum. Here is how you would write ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 " and the call to the function."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->10072],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SumArray", "=", 
    RowBox[{"DefineDLLFunction", "[", 
     RowBox[{
     "\"\<SumArray\>\"", ",", "\"\<SomeDLL.dll\>\"", ",", "\"\<int\>\"", ",", 
      
      RowBox[{"{", 
       RowBox[{"\"\<int[]\>\"", ",", "\"\<int\>\""}], "}"}]}], "]"}]}], ";"}],
   "\[IndentingNewLine]", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Alternate", " ", "version", " ", "using", " ", 
      RowBox[{"VB", " ", ".", "NET"}], " ", 
      RowBox[{"syntax", ":", "\[IndentingNewLine]", "SumArray"}]}], " ", "=", 
     " ", 
     RowBox[{"DefineDLLFunction", "[", 
      RowBox[{
      "\"\<SumArray\>\"", ",", "     ", "\"\<SomeDLL.dll\>\"", ",", " ", 
       "\"\<Integer\>\"", ",", " ", 
       RowBox[{"{", 
        RowBox[{"\"\<x() As Integer\>\"", ",", " ", "\"\<Integer\>\""}], 
        "}"}]}], "]"}]}], ";"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result", "=", 
   RowBox[{"SumArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "4", ",", "6", ",", "8", ",", "10"}], "}"}], ",", 
     "5"}], "]"}]}], ";"}]}], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.5.2",
 CellID->29317],

Cell[TextData[{
 "Note that bracket notation is used to indicate an array passed into the \
function, and you call it from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a list of integers."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->7058],

Cell[TextData[{
 "The ",
 StyleBox["ReverseArray()", "MR"],
 " function is quite different. It reverses the array of data ",
 StyleBox["in place",
  FontSlant->"Italic"],
 ", so the array is used as an [in, out] parameter. You can define it as \
follows:"
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->13281],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReverseArray", "=", 
   RowBox[{"DefineDLLFunction", "[", 
    RowBox[{
    "\"\<ReverseArray\>\"", ",", "\"\<SomeDLL.dll\>\"", ",", "\"\<void\>\"", 
     ",", 
     RowBox[{"{", 
      RowBox[{"\"\<int[]\>\"", ",", "\"\<int\>\""}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.5.2",
 CellID->22272],

Cell["But consider what would happen if you called it like this:", "Text",
 CellTags->"nlug:3.5.2",
 CellID->30257],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReverseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "6", ",", "8", ",", "10"}], "}"}], ",", 
    "5"}], "]"}], ";"}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.5.2",
 CellID->22757],

Cell[TextData[{
 "This would succeed in the sense that the DLL function would receive an \
array of ",
 StyleBox["int", "MR"],
 "s and reverse it, but there is no way to propagate the modified array back \
out of the function. You might guess that ",
 StyleBox["\"ref int[]\"", "MR"],
 " would be the correct type to use, but that actually translates to ",
 StyleBox["(int[])*", "MR"],
 " because adding ",
 StyleBox["ref", "MR"],
 " or ",
 StyleBox["out", "MR"],
 " to a type is effectively adding a level of indirection. The trick is to \
create a .NET array object and pass that object into the function. After the \
function returns, you can get the array data as a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list. This works because anywhere in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " if you have an argument slot typed to take an array you can call it from \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with either a list or a reference to a .NET object that is an array of the \
appropriate type. Here is the proper way to call a DLL function that writes \
into an array:"
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->8740],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"This", " ", "creates", " ", 
     RowBox[{"a", ".", "NET"}], " ", "object", " ", "of", " ", "type", " ", 
     RowBox[{"Int32", "[", "]"}], " ", "and", " ", "fills", " ", "it", " ", 
     "with", " ", "the", " ", 
     RowBox[{"data", ".", " ", "If"}], " ", "you", " ", 
     RowBox[{"didn", "'"}], "t", " ", "care", " ", "about", " ", "the", " ", 
     "initial", " ", "values", " ", "in", " ", "the", " ", "array"}], ",", 
    RowBox[{"you", " ", "could", " ", "use", " ", 
     RowBox[{
      RowBox[{"NETNew", "[", 
       RowBox[{"\"\<System.Int32[]\>\"", ",", " ", "5"}], "]"}], "."}]}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"intArray", "=", 
     RowBox[{"MakeNETObject", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4", ",", "6", ",", "8", ",", "10"}], "}"}], "]"}]}],
     ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ReverseArray", "[", 
     RowBox[{"intArray", ",", "5"}], "]"}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "converts", " ", "the", " ", "object", " ", "reference", " ",
      "to", " ", "its", " ", "value", " ", "as", " ", "a", " ", "Mathematica",
      " ", 
     RowBox[{"list", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"NETObjectToExpression", "[", "intArray", "]"}]}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.5.2",
 CellID->7107],

Cell["But consider what would happen if you called it like this:", "Text",
 CellTags->"nlug:3.5.2",
 CellID->29311],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReverseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "4", ",", "6", ",", "8", ",", "10"}], "}"}], ",", 
    "5"}], "]"}], ";"}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.5.2",
 CellID->6257],

Cell[TextData[{
 "The ",
 ButtonBox["example files",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#19628"],
 " include more pointer-related techniques, including the use of the .NET \
Framework ",
 StyleBox["IntPtr", "MR"],
 " type to represent a generic pointer."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->2393]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function Pointers", "Subsubsection",
 CellTags->"nlug:3.5.2",
 CellID->10971],

Cell[TextData[{
 "Some DLL functions take a callback function pointer as an argument. .NET \
maps function pointers to delegates, so you pass a delegate object of the \
appropriate type for a function pointer argument. ",
 ButtonBox["Handling Events",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#21428"],
 " introduces the ",
 Cell[BoxData[
  ButtonBox["NETNewDelegate",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNewDelegate"]], "InlineFormula"],
 " function, and its main use is for creating delegate objects for function \
pointers in DLL calls. It is often the case that there is no existing .NET \
delegate type with the correct signature for the function pointer. You can \
use the ",
 Cell[BoxData[
  ButtonBox["DefineNETDelegate",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineNETDelegate"]], "InlineFormula"],
 " function to create a .NET delegate type with the appropriate signature. \
The ",
 ButtonBox["EnumWindows.nb",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/example/Part1/CallingDLLs/EnumWindows"],
 " example file demonstrates using ",
 Cell[BoxData[
  ButtonBox["DefineNETDelegate",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineNETDelegate"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NETNewDelegate",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNewDelegate"]], "InlineFormula"],
 " to call a DLL function that takes a callback function pointer as an \
argument."
}], "Text",
 CellTags->"nlug:3.5.2",
 CellID->21587]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Declarations Requiring Special Attributes", "Subsection",
 CellTags->{"Declarations Requiring Special Attributes", "nlug:3.5.3"},
 CellID->11743],

Cell[TextData[{
 "The .NET runtime supports a large number of attributes to control precisely \
how a function is called and how arguments are marshaled. The ",
 Cell[BoxData[
  ButtonBox["CallingConvention",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CallingConvention"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MarshalStringsAs",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/MarshalStringsAs"]], "InlineFormula"],
 " options to ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 " give you some control over these aspects, but they do not support anywhere \
near all of the available attributes. Here is an example from the .NET \
Framework documentation of a complicated C# declaration for the ",
 StyleBox["MoveFile()", "MR"],
 " function from the Windows API. Although this declaration was made \
deliberately over-complicated, it demonstrates some of the possible \
attributes."
}], "Text",
 CellTags->"nlug:3.5.3",
 CellID->24468],

Cell["\<\
[DllImport(\"KERNEL32.DLL\", EntryPoint=\"MoveFileW\", SetLastError=true,
CharSet=CharSet.Unicode, ExactSpelling=true,
CallingConvention=CallingConvention.StdCall)]
public static extern bool MoveFile(String src, String dst);\
\>", "Program",
 CellTags->"nlug:3.5.3",
 CellID->3802],

Cell[TextData[{
 "When faced with the need to specify attributes beyond what can be done with \
options to ",
 Cell[BoxData[
  ButtonBox["DefineDLLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DefineDLLFunction"]], "InlineFormula"],
 ", you can use an alternative form where you specify a full declaration as a \
string in C# syntax."
}], "Text",
 CellTags->"nlug:3.5.3",
 CellID->30088],

Cell[BoxData[
 RowBox[{
  RowBox[{"MoveFile", "=", 
   RowBox[{
   "DefineDLLFunction", "[", 
    "\"\<[DllImport(\\\"KERNEL32.DLL\\\", EntryPoint=\\\"MoveFileW\\\", \
SetLastError=true, CharSet=CharSet.Unicode, \
ExactSpelling=true,\\nCallingConvention=CallingConvention.StdCall)] public \
static extern bool MoveFile(String src, String dst);\>\"", "]"}]}], 
  ";"}]], "Input",
 CellTags->"nlug:3.5.3",
 CellID->24298],

Cell[TextData[{
 "In this version of ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", only C# syntax is supported not Visual Basic .NET."
}], "Text",
 CellTags->"nlug:3.5.3",
 CellID->6582],

Cell["\<\
Another example of a function that would need this type of full declaration \
would be one that had two string arguments that needed separate marshaling \
conventions.\
\>", "Text",
 CellTags->"nlug:3.5.3",
 CellID->22252],

Cell["void TwoStrings(char* ansiString, wchar_t* unicodeString);", "Program",
 CellTags->"nlug:3.5.3",
 CellID->113305141],

Cell[TextData[{
 "Here is how you would define it in ",
 StyleBox["Mathematica.",
  FontSlant->"Italic"]
}], "Text",
 CellTags->"nlug:3.5.3",
 CellID->11457],

Cell[BoxData[
 RowBox[{
  RowBox[{"TwoStrings", "=", 
   RowBox[{
   "DefineDLLFunction", "[", 
    "\"\<[DllImport(\\\"SomeDLL.dll\\\")] public static extern void \
TwoStrings([MarshalAs(UnmanagedType.LPStr)] string ansiString, \
[MarshalAs(UnmanagedType.LPWStr)] string unicodeString);\>\"", "]"}]}], 
  ";"}]], "Input",
 CellTags->"nlug:3.5.3",
 CellID->24385],

Cell[TextData[{
 "If your DLL declaration uses a type that is not in the System assembly, you \
need to use the ",
 Cell[BoxData[
  ButtonBox["ReferencedAssemblies",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReferencedAssemblies"]], "InlineFormula"],
 " option to specify its assembly. This is analogous to adding a reference to \
an assembly in a Visual Studio project. Here is an example of using this \
option. The ",
 StyleBox["Rectangle", "MR"],
 " class is found in the ",
 StyleBox["System.Drawing", "MR"],
 " assembly, so you will get an error unless you explicitly name it as a \
referenced assembly."
}], "Text",
 CellTags->"nlug:3.5.3",
 CellID->19293],

Cell[BoxData[
 RowBox[{
  RowBox[{"GetWindowRect", "=", 
   RowBox[{"DefineDLLFunction", "[", 
    RowBox[{
    "\"\<GetWindowRect\>\"", ",", "\"\<user32.dll\>\"", ",", "\"\<BOOL\>\"", 
     ",", 
     RowBox[{"{", 
      RowBox[{"\"\<HWND\>\"", ",", "\"\<ref System.Drawing.Rectangle\>\""}], 
      "}"}], ",", 
     RowBox[{"ReferencedAssemblies", "\[Rule]", 
      RowBox[{"{", "\"\<System.Drawing.dll\>\"", "}"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"nlug:3.5.3",
 CellID->31716]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example Files", "Subsection",
 CellTags->{"DLL Example Files", "nlug:3.5.4"},
 CellID->19628],

Cell[TextData[{
 "The following example programs, included with ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", demonstrate calling C-style DLLs from ",
 StyleBox["Mathematica.",
  FontSlant->"Italic"]
}], "Text",
 CellTags->"nlug:3.5.4",
 CellID->12394],

Cell[TextData[ButtonBox["BZip2Compression.nb",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NETLink/example/Part1/CallingDLLs/BZip2Compression"]], "Text",
 CellTags->"nlug:3.5.4",
 CellID->19291],

Cell[TextData[ButtonBox["WindowsAPI.nb",
 BaseStyle->"Link",
 ButtonData->"paclet:NETLink/example/Part1/CallingDLLs/WindowsAPI"]], "Text",
 CellTags->"nlug:3.5.4",
 CellID->3771],

Cell[TextData[ButtonBox["EnumWindows.nb",
 BaseStyle->"Link",
 ButtonData->"paclet:NETLink/example/Part1/CallingDLLs/EnumWindows"]], "Text",\

 CellTags->"nlug:3.5.4",
 CellID->5107]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Calling COM from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "Section",
 CellTags->"COM",
 CellID->7475],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
 CellTags->{"COM Introduction", "nlug:3.6.0"},
 CellID->8879],

Cell[TextData[{
 "The .NET runtime has many features that support interoperability with COM \
(the Component Object Model, also referred to as ActiveX). Although the \
arrival of .NET makes COM/ActiveX officially a \"legacy\" technology, there \
are still a huge number of COM objects and libraries in use, and COM remains \
an important part of the Windows programming world. Because COM objects are \
easily called from .NET, they are easily called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " via ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.6.0",
 CellID->11858],

Cell["\<\
COM programming is a complex subject (one reason, no doubt, that Microsoft \
replaced it with .NET), and readers are assumed to have some familiarity with \
the basics of COM. There is considerable discussion of COM and .NET \
interoperability issues in the .NET SDK documentation.\
\>", "Text",
 CellTags->"nlug:3.6.0",
 CellID->18583],

Cell["\<\
The central element in .NET-to-COM interoperability is a special proxy object \
called a Runtime Callable Wrapper. Whenever you create a COM object and want \
to import it into the .NET environment, the .NET runtime creates an RCW \
object that represents the COM object in the .NET environment. The RCW \
mediates calls from .NET into COM, marshaling arguments and return values \
back and forth between the .NET and COM worlds. You will see examples of RCW \
objects in the sections that follow.\
\>", "Text",
 CellTags->"nlug:3.6.0",
 CellID->19946],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " provides two main ways of calling COM objects from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The first technique is to use so-called COM Automation (late binding). \
This is convenient because it requires no preparation, but it is not ideal \
for various reasons discussed later. The second, preferred, technique is to \
create or obtain an ",
 "interop assembly",
 " for the COM objects you want to call. An interop assembly is a special \
.NET assembly that wraps a COM library and makes that library\
\[CloseCurlyQuote]s types and interfaces look like native .NET types. These \
two methods for calling COM objects are discussed in the next two sections."
}], "Text",
 CellTags->"nlug:3.6.0",
 CellID->24187]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using Automation (Late Binding)", "Subsection",
 CellTags->"nlug:3.6.1",
 CellID->13407],

Cell[TextData[{
 "A COM interface is essentially just a table of function pointers. This is \
ideal for C++ programmers to use, but there needs to be a way for scripting \
languages, which have no compilation stage and no access to C++ header files, \
to use COM objects. The solution to this problem is a special COM interface \
called ",
 StyleBox["IDispatch", "MR"],
 ". A COM object that implements ",
 StyleBox["IDispatch", "MR"],
 " allows the user of the object to determine at runtime the methods and \
properties available, and then invoke them. ",
 StyleBox["IDispatch", "MR"],
 " is the COM equivalent to the \"reflection\" capabilities in .NET. Using  \
COM objects via their ",
 StyleBox["IDispatch", "MR"],
 " interface is often referred to as late binding, Automation, or Dispatch. \
We will use the term Automation."
}], "Text",
 CellTags->"nlug:3.6.1",
 CellID->8288],

Cell[TextData[{
 "Not all COM objects support Automation but many do, including all those \
that want to be usable from the widest variety of programming languages and \
environments. Visual Basic 6 is capable of using COM objects via either \
Automation or early binding (discussed later). Most scripting languages, \
including VBScript, however, can only use Automation. ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " can use either Automation or early binding. Early binding is the preferred \
technique, and it is discussed in the next section. Here, we focus on \
Automation. Using COM objects via Automation in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " is almost exactly like using Automation in Visual Basic or VBScript. If \
you can find sample code in either of those languages that uses the COM \
objects you are interested in, then you can generally translate that code \
verbatim into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.6.1",
 CellID->17925],

Cell[TextData[{
 "As an example of a COM library, this section will use the Microsoft Speech \
API. Although Microsoft will eventually move all its APIs to pure .NET \
implementations, many are still available only as COM objects, and the Speech \
API is an example. (Note that Microsoft has a .NET-based speech tool called \
the Speech Application SDK. This is targeted at ASP .NET developers creating \
telephony applications and should not be confused with the older COM-based \
Speech API, which will be used in the next examples.) You do not need to have \
the Speech API installed to understand this section, as you can simply read \
the inputs and outputs, but if you want to reevaluate the input or play \
around yourself, you can download the Speech API from ",
 ButtonBox["http://www.microsoft.com/speech/download/sdk51/",
  BaseStyle->"Hyperlink",
  Evaluator->Automatic,
  ButtonData:>{
    URL["http://www.microsoft.com/speech/download/sdk51/"], None}],
 ". If the line that calls ",
 Cell[BoxData[
  ButtonBox["CreateCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CreateCOMObject"]], "InlineFormula"],
 " fails, you do not have the Speech API installed."
}], "Text",
 CellTags->"nlug:3.6.1",
 CellID->16395],

Cell[TextData[{
 "The basic function for creating COM objects for control via Automation is \
",
 Cell[BoxData[
  ButtonBox["CreateCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CreateCOMObject"]], "InlineFormula"],
 ". This function is analogous to the ",
 StyleBox["CreateObject()", "MR"],
 " function in Visual Basic. The argument to ",
 Cell[BoxData[
  ButtonBox["CreateCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CreateCOMObject"]], "InlineFormula"],
 " is a string that provides either the ProgID or CLSID of a COM coclass. A \
ProgID is a human-readable string, such as \"Excel.Application\", whereas the \
CLSID is a sequence of hex digits, such as \
\"{000208d5-0000-0000-c000-000000000046}\". You can obtain the CLSID or \
ProgID of a COM object from its documentation, or, even better, from some \
sample code in Visual Basic that uses it."
}], "Text",
 CellTags->"nlug:3.6.1",
 CellID->22860],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CreateCOMObject",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/CreateCOMObject"], "[", 
     StyleBox["\"\<ProgID\>\"", "TI"], "]"}], Cell["\<\
create a COM object with the given ProgID (e.g., Excel.Application)\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["CreateCOMObject",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/CreateCOMObject"], "[", 
     StyleBox["\"\<CLSID\>\"", "TI"], "]"}], Cell["\<\
create a COM object with the given CLSID (e.g., \
{000208d5-0000-0000-c000-000000000046})\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["GetActiveCOMObject",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/GetActiveCOMObject"], "[", 
     StyleBox["\"\<ProgID\>\"", "TI"], "]"}], Cell["\<\
acquire a reference to an already-active COM object with the given ProgID \
(e.g., Excel.Application)\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["GetActiveCOMObject",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/GetActiveCOMObject"], "[", 
     StyleBox["\"\<CLSID\>\"", "TI"], "]"}], Cell["\<\
acquire a reference to an already-active COM object with the given CLSID \
(e.g., {000208d5-0000-0000-c000-000000000046})\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.6.1",
 CellID->24320],

Cell["Obtaining COM objects. ", "Caption",
 CellTags->"nlug:3.6.1",
 CellID->25390],

Cell["This creates an instance of the SpVoice COM object.", "Text",
 CellTags->"nlug:3.6.1",
 CellID->14767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"voice", "=", 
  RowBox[{"CreateCOMObject", "[", "\"\<Sapi.SpVoice\>\"", "]"}]}]], "Input",
 CellTags->"nlug:3.6.1",
 CellLabel->"In[1]:=",
 CellID->25656],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]NETObject", "[", 
    RowBox[{"COMInterface", "[", "\<\"SpeechLib.ISpeechVoice\"\>", "]"}], 
    "]"}], "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$802588947$134217729]], "Output",
 CellTags->"nlug:3.6.1",
 CellLabel->"Out[1]=",
 CellID->5354]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["voice", "MR"],
 " object is unlike any .NET object you have seen yet. This object is a \
Runtime Callable Wrapper (RCW), a class of objects that was mentioned in the \
",
 ButtonBox["Introduction",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#19946"],
 ". You can think of it as a proxy object that represents the COM object in \
the .NET world. For most .NET objects, the string inside the brackets in the \
",
 StyleBox["OutputForm", "MR"],
 " representation of the object gives the name of the \
object\[CloseCurlyQuote]s .NET type. The ",
 StyleBox["voice", "MR"],
 " object is different\[LongDash]the string shows the name of the default COM \
interface supported by the object (",
 StyleBox["SpeechLib.ISpeechVoice", "MR"],
 "). Here is the actual type name of the object."
}], "Text",
 CellTags->"nlug:3.6.1",
 CellID->672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"voice", "@", 
  RowBox[{
   RowBox[{"GetType", "[", "]"}], "@", 
   RowBox[{"ToString", "[", "]"}]}]}]], "Input",
 CellTags->"nlug:3.6.1",
 CellLabel->"In[2]:=",
 CellID->18446],

Cell[BoxData["\<\"System.__ComObject\"\>"], "Output",
 CellTags->"nlug:3.6.1",
 CellLabel->"Out[2]=",
 CellID->25156]
}, Open  ]],

Cell[TextData[{
 "As you might have guessed, ",
 StyleBox["System.__ComObject", "MR"],
 " is the name of the RCW class. Seeing a .NET object represented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as ",
 StyleBox["<<NETObject[System.__ComObject]>>", "MR"],
 " would not be very informative, as this could be ",
 "any",
 " COM object and thus tells you nothing about the object. When ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " returns an RCW object to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", it tries to determine the name of the default COM interface that the \
object supports. If this is successful, then ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " reports the object as ",
 StyleBox["<<NETObject[COMInterface[Default.COM.Interface]]>>", "MR"],
 ". Remember that this is the name of a COM interface and has no meaning \
whatsoever to .NET or ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ". It is displayed simply to help you know something about the COM object \
that this .NET object represents. For ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " to be able to determine the default COM interface name, the object must \
provide sufficiently detailed type information via a COM type library. Most \
COM objects provide this feature, so you will often see RCW objects formatted \
with a COM interface name. In some cases, however, the search for a default \
interface name will fail, and you will see a COM object formatted only as ",
 StyleBox["<<NETObject[System.__ComObject]>>", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.6.1",
 CellID->20879],

Cell[TextData[{
 "One drawback to using COM objects via Automation is that you cannot get \
information about COM methods and properties using ",
 Cell[BoxData[
  ButtonBox["NETTypeInfo",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETTypeInfo"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.6.1",
 CellID->4500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NETTypeInfo", "[", "voice", "]"}]], "Input",
 CellTags->"nlug:3.6.1",
 CellLabel->"In[3]:=",
 CellID->4293],

Cell[BoxData[
 RowBox[{
  RowBox[{"NETTypeInfo", "::", "\<\"com\"\>"}], ":", 
  " ", "\<\"Type information is not currently available for \\\"raw\\\" COM \
objects.\"\>"}]], "Message", "MSG",
 CellTags->"nlug:3.6.1",
 CellLabel->"From In[3]:=",
 CellID->23203],

Cell[BoxData[
 InterpretationBox[
  InterpretationBox["\<\"\"\>",
   {}],
  TableForm[{}]]], "Output",
 CellTags->"nlug:3.6.1",
 CellLabel->"Out[3]//TableForm=",
 CellID->22309]
}, Open  ]],

Cell[TextData[{
 "Although you can call methods and properties on the COM object, you cannot \
see these methods directly from .NET. For information about methods and \
properties and their arguments, you will need to turn to the documentation \
for the COM object. Often you can find sample code in Visual Basic for using \
a COM object, and using it from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " via ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " will look almost exactly the same."
}], "Text",
 CellTags->"nlug:3.6.1",
 CellID->508],

Cell[TextData[{
 "The ",
 StyleBox["ISpeechVoice", "MR"],
 " COM interface includes a property called ",
 StyleBox["Volume", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.6.1",
 CellID->21585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"voice", "@", "Volume"}]], "Input",
 CellTags->"nlug:3.6.1",
 CellLabel->"In[4]:=",
 CellID->2289],

Cell[BoxData["100"], "Output",
 CellTags->"nlug:3.6.1",
 CellLabel->"Out[4]=",
 CellID->15271]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Speak()", "MR"],
 " method speaks a string of text. Here is the declaration for the ",
 StyleBox["Speak()", "MR"],
 " method from the IDL file for the ",
 StyleBox["SpeechLib", "MR"],
 " type library."
}], "Text",
 CellTags->"nlug:3.6.1",
 CellID->30580],

Cell["\<\
long Speak([in] BSTR Text, [in, optional, defaultvalue(0)] \
SpeechVoiceSpeakFlags Flags);\
\>", "Program",
 CellTags->"nlug:3.6.1",
 CellID->14127],

Cell[TextData[{
 "Experienced COM programmers will recognize the elements of this \
declaration. The first argument is a ",
 StyleBox["BSTR", "MR"],
 ", which is a string in the COM world. Such arguments are called with a \
string from .NET, and thus with a string from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The second argument is marked as optional, with a default value of 0. \
This means that the ",
 StyleBox["Speak()", "MR"],
 " method can be called without the second argument."
}], "Text",
 CellTags->"nlug:3.6.1",
 CellID->4550],

Cell[BoxData[
 RowBox[{
  RowBox[{"voice", "@", 
   RowBox[{
   "Speak", "[", 
    "\"\<This is an example of using the SpVoice object via Automation\>\"", 
    "]"}]}], ";"}]], "Input",
 CellTags->"nlug:3.6.1",
 CellLabel->"In[5]:=",
 CellID->6941],

Cell[TextData[{
 "The second argument is listed as being of the type ",
 StyleBox["SpeechVoiceSpeakFlags", "MR"],
 ", which is a COM enumeration containing constants that control how the text \
is spoken. One drawback to using COM objects via Automation is that there is \
no way to access COM enumerations. To use the second argument, you have to \
supply an integer value that corresponds to the correct value of the enum. \
You can get this information from the documentation or from the type library \
itself using a tool like OLE View, which is bundled with Microsoft Visual \
Studio. To speak the voice asynchronously, meaning the ",
 StyleBox["Speak()", "MR"],
 " method will return before the text finishes speaking, you use the flag ",
 StyleBox["SVSFlagsAsync", "MR"],
 ", which has the value 1."
}], "Text",
 CellTags->"nlug:3.6.1",
 CellID->16502],

Cell[BoxData[
 RowBox[{
  RowBox[{"voice", "@", 
   RowBox[{"Speak", "[", 
    RowBox[{
    "\"\<This is an example of using the SpVoice object via Automation. This \
text is spoken asynchronously\>\"", ",", "1"}], "]"}]}], ";"}]], "Input",
 CellTags->"nlug:3.6.1",
 CellLabel->"In[6]:=",
 CellID->9793],

Cell[CellGroupData[{

Cell["Drawbacks to Using Automation", "Subsubsection",
 CellTags->"nlug:3.6.1",
 CellID->25994],

Cell[TextData[{
 "You have seen how ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " allows you to use COM objects via their ",
 StyleBox["IDispatch", "MR"],
 " interface. This has the advantage of requiring no preparation at all, but \
there are several drawbacks:"
}], "Text",
 CellTags->"nlug:3.6.1",
 CellID->16157],

Cell["\<\
You can only call methods on an object\[CloseCurlyQuote]s default interface.\
\>", "BulletedText",
 CellTags->"nlug:3.6.1",
 CellID->28621],

Cell[TextData[{
 "You cannot use ",
 Cell[BoxData[
  ButtonBox["NETTypeInfo",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETTypeInfo"]], "InlineFormula"],
 " to get information about the methods and properties of an object."
}], "BulletedText",
 CellTags->"nlug:3.6.1",
 CellID->300129566],

Cell["You cannot access COM enumerations or structs.", "BulletedText",
 CellTags->"nlug:3.6.1",
 CellID->112225757],

Cell[CellGroupData[{

Cell["You cannot use COM events.", "BulletedText",
 CellTags->"nlug:3.6.1",
 CellID->716654330],

Cell[TextData[{
 "These drawbacks are the same as you would encounter using COM from a pure \
scripting language like VBScript. The next section discusses a better way to \
use COM with ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.6.1",
 CellID->23156]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using an Interop Assembly (Early Binding)", "Subsection",
 CellTags->{"Interop Assembly", "nlug:3.6.2"},
 CellID->17803],

Cell[TextData[{
 "The previous section described using COM objects in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " via their ",
 StyleBox["IDispatch", "MR"],
 " interface, often called late binding or Automation. There are drawbacks to \
that technique, but luckily .NET supports calling COM objects via a more \
sophisticated and efficient technique called early binding. This is similar \
to how COM objects are used in C++, as method dispatch happens via the vtable \
interface, not ",
 StyleBox["IDispatch", "MR"],
 ". To use early binding in .NET, you must first create or find a so-called \
",
 "interop assembly",
 ". An interop assembly is a special assembly that contains metadata that \
describes the types and methods in a COM type library. Once you have an \
interop assembly, it can be loaded and used like any other .NET assembly, and \
the COM types it describes look like native .NET types to clients."
}], "Text",
 CellTags->"nlug:3.6.2",
 CellID->24466],

Cell[TextData[{
 "Interop assemblies can be created with a tool called ",
 StyleBox["tlbimp.exe", "MR"],
 " (\"type library importer\"), which is included with the .NET Framework \
SDK, and also with Visual Studio .NET. You will find ample documentation on \
how to run ",
 StyleBox["tlbimp", "MR"],
 ", and you will see an example later. It is also possible to create an \
interop assembly programmatically, and ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " provides the ",
 Cell[BoxData[
  ButtonBox["LoadCOMTypeLibrary",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadCOMTypeLibrary"]], "InlineFormula"],
 " function for this purpose. ",
 Cell[BoxData[
  ButtonBox["LoadCOMTypeLibrary",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadCOMTypeLibrary"]], "InlineFormula"],
 " takes a COM type library, creates an interop ",
 "assembly",
 " from it, and loads this assembly into ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ". You can think of it as analogous to ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 ", except that it takes a path to a COM type library instead."
}], "Text",
 CellTags->"nlug:3.6.2",
 CellID->10828],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LoadCOMTypeLibrary",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/LoadCOMTypeLibrary"], "[", 
     StyleBox["typeLibPath", "TI"], "]"}], Cell["\<\
create an interop assembly from the given type library and load it\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.6.2",
 CellID->16288],

Cell["Loading COM  type libraries.", "Caption",
 CellTags->"nlug:3.6.2",
 CellID->343302148],

Cell["\<\
Earlier you used the COM-based Microsoft Speech API via Automation. The \
preferred method is to load the type library to allow early binding.\
\>", "Text",
 CellTags->"nlug:3.6.2",
 CellID->24764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"speechAsm", "=", 
  RowBox[{
  "LoadCOMTypeLibrary", "[", 
   "\"\<C:\\\\Program Files\\\\Common Files\\\\Microsoft \
Shared\\\\Speech\\\\sapi.dll\>\"", "]"}]}]], "Input",
 CellTags->"nlug:3.6.2",
 CellLabel->"In[7]:=",
 CellID->31935],

Cell[BoxData[
 RowBox[{"NETAssembly", "[", 
  RowBox[{"\<\"interop.SpeechLib\"\>", ",", "25"}], "]"}]], "Output",
 CellTags->"nlug:3.6.2",
 CellLabel->"Out[7]=",
 CellID->17072]
}, Open  ]],

Cell[TextData[{
 "Interop assemblies created by ",
 Cell[BoxData[
  ButtonBox["LoadCOMTypeLibrary",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadCOMTypeLibrary"]], "InlineFormula"],
 " are created with default rules for naming of namespaces and types, and it \
is useful to use ",
 Cell[BoxData[
  ButtonBox["NETTypeInfo",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETTypeInfo"]], "InlineFormula"],
 " on the assembly to see what types are available. For each coclass in the \
COM type library, a class will be created in the interop assembly with the \
name of the coclass with the word \"Class\" appended. You saw earlier that \
there was a coclass called ",
 StyleBox["SpVoice", "MR"],
 ", so you expect to find a .NET class called ",
 StyleBox["SpVoiceClass", "MR"],
 " in the interop assembly. There are a lot of types in this assembly; this \
shows just the classes."
}], "Text",
 CellTags->"nlug:3.6.2",
 CellID->12833],

Cell[CellGroupData[{

Cell["NETTypeInfo[speechAsm, \"Classes\"]", "Input",
 CellTags->"nlug:3.6.2",
 CellLabel->"In[8]:=",
 CellID->12920],

Cell[BoxData[GridBox[{
   {
    RowBox[{"Assembly", ":", " ", 
     StyleBox["\<\"interop.SpeechLib\"\>",
      FontWeight->"Bold"]}]},
   {"\<\"Full Name: interop.SpeechLib, Version=5.0.0.0\"\>"},
   {
    RowBox[{"Location", ":", " "}]},
   {""},
   {Cell[BoxData[
     RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Classes",
       FontSize->18,
       FontWeight->"Bold",
       FontSlant->"Italic"]}]]]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox[
      RowBox[{"_ISpeechRecoContextEvents", "_SinkHelper"}],
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox[
      RowBox[{"_ISpeechVoiceEvents", "_SinkHelper"}],
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpAudioFormatClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpCompressedLexiconClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpCustomStreamClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpeechConstants",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpeechStringConstants",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpFileStreamClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpInProcRecoContextClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpInprocRecognizerClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpLexiconClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpMemoryStreamClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpMMAudioEnumClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpMMAudioInClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpMMAudioOutClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpNotifyTranslatorClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpNullPhoneConverterClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpObjectTokenCategoryClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpObjectTokenClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpPhoneConverterClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpPhraseInfoBuilderClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpRecPlayAudioClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpResourceManagerClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpSharedRecoContextClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpSharedRecognizerClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpStreamClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpStreamFormatConverterClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpTextSelectionInformationClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpUnCompressedLexiconClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpVoiceClass",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"class", " ", "\<\"SpeechLib.\"\>", 
     StyleBox["SpWaveFormatExClass",
      FontWeight->"Bold"]}]}
  },
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}},
  GridBoxItemSize->{
   "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.2}}, 
    "RowsIndexed" -> {}}]], "Output",
 AutoSpacing->False,
 CellTags->"nlug:3.6.2",
 CellID->20002]
}, Open  ]],

Cell[TextData[{
 "You will find ",
 Cell[BoxData[
  ButtonBox["NETTypeInfo",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETTypeInfo"]], "InlineFormula"],
 " very useful when exploring an interop assembly. When creating a COM object \
earlier using Automation, you used the ",
 Cell[BoxData[
  ButtonBox["CreateCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CreateCOMObject"]], "InlineFormula"],
 " function. Now that you have .NET classes that represent the COM coclasses, \
you can call ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 " instead."
}], "Text",
 CellTags->"nlug:3.6.2",
 CellID->19202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"voice", "=", 
  RowBox[{"NETNew", "[", "\"\<SpeechLib.SpVoiceClass\>\"", "]"}]}]], "Input",
 CellTags->"nlug:3.6.2",
 CellLabel->"In[9]:=",
 CellID->13048],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", "[", "\<\"SpeechLib.SpVoiceClass\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$100663297]], "Output",
 CellTags->"nlug:3.6.2",
 CellLabel->"Out[9]=",
 CellID->13506]
}, Open  ]],

Cell[TextData[{
 "You use this object just like any other .NET object. Here is the ",
 StyleBox["Speak()", "MR"],
 " method. For some reason, the optional nature of the second argument is not \
preserved in the interop assembly, so you have to call ",
 StyleBox["Speak()", "MR"],
 " with two arguments."
}], "Text",
 CellTags->"nlug:3.6.2",
 CellID->16913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"voice", "@", 
  RowBox[{"Speak", "[", 
   RowBox[{
   "\"\<Using COM objects is easier with an interop assembly\>\"", ",", "1"}],
    "]"}]}]], "Input",
 CellTags->"nlug:3.6.2",
 CellLabel->"In[10]:=",
 CellID->25361],

Cell[BoxData["1"], "Output",
 CellTags->"nlug:3.6.2",
 CellLabel->"Out[10]=",
 CellID->25210]
}, Open  ]],

Cell[TextData[{
 "When using Automation, you saw that the second argument is a COM \
enumeration called ",
 StyleBox["SpeechVoiceSpeakFlags", "MR"],
 ". When using Automation, however, there is no way to access an enumeration, \
so you had to pass an integer value. But with an interop assembly there is a \
.NET enumeration you can use to make your code more readable."
}], "Text",
 CellTags->"nlug:3.6.2",
 CellID->17784],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "LoadNETType", "[", "\"\<SpeechLib.SpeechVoiceSpeakFlags\>\"", "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"voice", "@", 
   RowBox[{"Speak", "[", 
    RowBox[{
    "\"\<Using COM objects is easier with an interop assembly\>\"", ",", 
     "SpeechVoiceSpeakFlags`SVSFlagsAsync"}], "]"}]}], ";"}]}], "Input",
 CellTags->"nlug:3.6.2",
 CellLabel->"In[11]:=",
 CellID->8064],

Cell[TextData[{
 "One great advantage of having an interop assembly is that you can use ",
 Cell[BoxData[
  ButtonBox["NETTypeInfo",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETTypeInfo"]], "InlineFormula"],
 " to get information about the methods and properties supported by objects. \
This shows the properties of the ",
 StyleBox["voice", "MR"],
 " object."
}], "Text",
 CellTags->"nlug:3.6.2",
 CellID->18771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NETTypeInfo", "[", 
  RowBox[{"voice", ",", "\"\<Properties\>\""}], "]"}]], "Input",
 CellTags->"nlug:3.6.2",
 CellLabel->"In[12]:=",
 CellID->23392],

Cell[BoxData[GridBox[{
   {""},
   {Cell[BoxData[
     RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Properties",
       FontSize->18,
       FontWeight->"Bold",
       FontSlant->"Italic"]}]]]},
   {
    RowBox[{"virtual", " ", "\<\"SpeechLib.SpeechVoiceEvents\"\>", " ", 
     StyleBox["AlertBoundary",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"virtual", " ", "\<\"bool\"\>", " ", 
     StyleBox["AllowAudioOutputFormatChangesOnNextSet",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"virtual", " ", "\<\"SpeechLib.SpObjectToken\"\>", " ", 
     StyleBox["AudioOutput",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"virtual", " ", "\<\"SpeechLib.ISpeechBaseStream\"\>", " ", 
     StyleBox["AudioOutputStream",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"virtual", " ", "\<\"SpeechLib.SpeechVoiceEvents\"\>", " ", 
     StyleBox["EventInterests",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"virtual", " ", "\<\"SpeechLib.SpeechVoicePriority\"\>", " ", 
     StyleBox["Priority",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"virtual", " ", "\<\"int\"\>", " ", 
     StyleBox["Rate",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"virtual", " ", "\<\"SpeechLib.ISpeechVoiceStatus\"\>", " ", 
     StyleBox["Status",
      FontWeight->"Bold"], "  ", 
     RowBox[{"[", 
      RowBox[{"read", " ", "only"}], "]"}]}]},
   {
    RowBox[{"virtual", " ", "\<\"int\"\>", " ", 
     StyleBox["SynchronousSpeakTimeout",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"virtual", " ", "\<\"SpeechLib.SpObjectToken\"\>", " ", 
     StyleBox["Voice",
      FontWeight->"Bold"]}]},
   {
    RowBox[{"virtual", " ", "\<\"int\"\>", " ", 
     StyleBox["Volume",
      FontWeight->"Bold"]}]}
  },
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}},
  GridBoxItemSize->{
   "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.2}}, 
    "RowsIndexed" -> {}}]], "Output",
 AutoSpacing->False,
 CellTags->"nlug:3.6.2",
 CellID->4012]
}, Open  ]],

Cell[TextData[{
 "Note that once an interop assembly is loaded for a type library, if you \
call ",
 Cell[BoxData[
  ButtonBox["CreateCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CreateCOMObject"]], "InlineFormula"],
 " with the name of a COM coclass, you get back a native .NET object of the \
class that corresponds to the COM coclass, not a raw RCW as before. This \
means that ",
 Cell[BoxData[
  ButtonBox["CreateCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CreateCOMObject"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 " become equivalent ways of creating an instance of a COM coclass."
}], "Text",
 CellTags->"nlug:3.6.2",
 CellID->14938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"voice2", "=", 
  RowBox[{"CreateCOMObject", "[", "\"\<Sapi.SpVoice\>\"", "]"}]}]], "Input",
 CellTags->"nlug:3.6.2",
 CellLabel->"In[13]:=",
 CellID->3789],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", "[", "\<\"SpeechLib.SpVoiceClass\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$83886081]], "Output",
 CellTags->"nlug:3.6.2",
 CellLabel->"Out[13]=",
 CellID->21101]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["SaveAssemblyAs",
     BaseStyle->"Link",
     ButtonData->"paclet:NETLink/ref/SaveAssemblyAs"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "a full pathname to the assembly file you want created", "TableText"]},
   {
    ButtonBox["SafeArrayAsArray",
     BaseStyle->"Link",
     ButtonData->"paclet:NETLink/ref/SafeArrayAsArray"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to marshal ",
     StyleBox["SAFEARRAY", "MR"],
     " types as ",
     StyleBox["System.Array", "MR"]
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"nlug:3.6.2",
 CellID->18769],

Cell[TextData[{
 "Options to ",
 Cell[BoxData[
  ButtonBox["LoadCOMTypeLibrary",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadCOMTypeLibrary"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"nlug:3.6.2",
 CellID->20809],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LoadCOMTypeLibrary",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadCOMTypeLibrary"]], "InlineFormula"],
 " takes two options that control the assembly-creation process. The first is \
",
 Cell[BoxData[
  ButtonBox["SaveAssemblyAs",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/SaveAssemblyAs"]], "InlineFormula"],
 ", which allows you to specify a filename into which you want the created \
assembly saved. ",
 Cell[BoxData[
  ButtonBox["LoadCOMTypeLibrary",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadCOMTypeLibrary"]], "InlineFormula"],
 " can take a while to execute, so it is useful to save the assembly in a \
file and load it using ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 " in the future. This makes ",
 Cell[BoxData[
  ButtonBox["LoadCOMTypeLibrary",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadCOMTypeLibrary"]], "InlineFormula"],
 " the programmatic equivalent to running the ",
 StyleBox["tlbimp.exe", "MR"],
 " tool, in that it can write out the generated assembly. The second option \
to ",
 Cell[BoxData[
  ButtonBox["LoadCOMTypeLibrary",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadCOMTypeLibrary"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["SafeArrayAsArray",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/SafeArrayAsArray"]], "InlineFormula"],
 ", which specifies whether to import all COM ",
 StyleBox["SAFEARRAY", "MR"],
 "'s as the ",
 StyleBox["System.Array", "MR"],
 " class rather than a typed, single dimensional managed array. The default \
is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". See the .NET Framework documentation for the ",
 StyleBox["System.Runtime.InteropServices.TypeLibImporterFlags", "MR"],
 " enumeration for more details on this advanced option. If you need more \
control over the generated assembly, use the ",
 StyleBox["tlbimp.exe", "MR"],
 " tool as described in the next section."
}], "Text",
 CellTags->"nlug:3.6.2",
 CellID->7588],

Cell[TextData[{
 "In the earlier discussion of using COM objects via Automation, the role of \
the RCW was described. You saw that the class name of a \"raw\" RCW is ",
 StyleBox["System.__ComObject", "MR"],
 ". It is important to remember that all COM objects are represented in .NET \
as RCWs, even when using an interop assembly. You can see below that the ",
 StyleBox["SpVoiceClass", "MR"],
 " derives from ",
 StyleBox["__ComObject", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.6.2",
 CellID->19774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NETTypeInfo", "[", 
  RowBox[{"voice", ",", "\"\<Type\>\""}], "]"}]], "Input",
 CellTags->"nlug:3.6.2",
 CellLabel->"In[14]:=",
 CellID->31774],

Cell[BoxData[GridBox[{
   {Cell[BoxData[
     RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Type",
       FontSize->18,
       FontWeight->"Bold",
       FontSlant->"Italic"]}]]]},
   {
    RowBox[{"class", " ", 
     StyleBox["\<\"SpeechLib.SpVoiceClass\"\>",
      FontWeight->"Bold"]}]},
   {GridBox[{
      {
       RowBox[{"Inheritance", ":"}]},
      {
       RowBox[{"   ", "   ", "\<\"System.Object\"\>"}]},
      {
       RowBox[{"   ", "   ", "   ", "\<\"System.MarshalByRefObject\"\>"}]},
      {
       RowBox[{"   ", "   ", "   ", "   ", "\<\"System.__ComObject\"\>"}]},
      {
       RowBox[{"   ", "   ", "   ", "   ", "   ", 
        StyleBox["\<\"SpeechLib.SpVoiceClass\"\>",
         FontWeight->"Bold"]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]},
   {
    RowBox[{
     RowBox[{"Interfaces", " ", 
      RowBox[{"Implemented", ":", " ", "\<\"SpeechLib.ISpeechVoice\"\>"}]}], 
     ",", " ", "\<\"SpeechLib.SpVoice\"\>", ",", 
     " ", "\<\"SpeechLib._ISpeechVoiceEvents_Event\"\>", ",", 
     " ", "\<\"SpeechLib.ISpVoice\"\>", ",", 
     " ", "\<\"SpeechLib.ISpEventSource\"\>", ",", 
     " ", "\<\"SpeechLib.ISpNotifySource\"\>"}]},
   {"\<\"Assembly-Qualified Name: SpeechLib.SpVoiceClass, interop.SpeechLib, \
Version=5.0.0.0\"\>"},
   {
    RowBox[{"Assembly", " ", 
     RowBox[{"Location", ":", " ", 
      RowBox[{"Dynamically", " ", "generated"}]}]}]}
  },
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}},
  GridBoxItemSize->{
   "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.2}}, 
    "RowsIndexed" -> {}}]], "Output",
 AutoSpacing->False,
 CellTags->"nlug:3.6.2",
 CellID->867]
}, Open  ]],

Cell["Here is another way to prove the inheritance relationship.", "Text",
 CellTags->"nlug:3.6.2",
 CellID->2838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstanceOf", "[", 
  RowBox[{"voice", ",", "\"\<System.__ComObject\>\""}], "]"}]], "Input",
 CellTags->"nlug:3.6.2",
 CellLabel->"In[15]:=",
 CellID->20456],

Cell[BoxData["True"], "Output",
 CellTags->"nlug:3.6.2",
 CellLabel->"Out[15]=",
 CellID->4198]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using tlbimp.exe to Create an Interop Assembly", "Subsubsection",
 CellTags->"nlug:3.6.2",
 CellID->31228],

Cell[TextData[{
 "As mentioned earlier, the .NET Framework SDK includes a tool called ",
 StyleBox["tlbimp.exe", "MR"],
 " (type library importer) that creates an interop assembly from a COM type \
library. You can use this tool to create an interop assembly and load it \
using ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 ", instead of using the ",
 Cell[BoxData[
  ButtonBox["LoadCOMTypeLibrary",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadCOMTypeLibrary"]], "InlineFormula"],
 " function. The ",
 StyleBox["tlbimp", "MR"],
 " program has many options to control how the assembly is generated, so if \
you need this level of control, you will definitely want to run it manually. \
The .NET Framework SDK documentation describes how to use ",
 StyleBox["tlbimp", "MR"],
 " in detail, but here is an example of how it could be used to create an \
interop assembly for the ",
 StyleBox["SpeechLib", "MR"],
 " type library."
}], "Text",
 CellTags->"nlug:3.6.2",
 CellID->29753],

Cell["\<\
tlbimp \"C:\\Program Files\\Common Files\\Microsoft \
Shared\\Speech\\sapi.dll\"  /out:c:\\interop.SpeechLib.dll \
\>", "Program",
 CellTags->"nlug:3.6.2",
 CellID->30709],

Cell["\<\
Once the assembly has been created, load it like any other assembly.\
\>", "Text",
 CellTags->"nlug:3.6.2",
 CellID->3864],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "LoadNETAssembly", "[", "\"\<c:\\\\interop.SpeechLib.dll\>\"", "]"}], 
  ";"}]], "Input",
 CellTags->"nlug:3.6.2",
 CellID->13720]
}, Open  ]],

Cell[CellGroupData[{

Cell["Primary Interop Assemblies", "Subsubsection",
 CellTags->"nlug:3.6.2",
 CellID->17809],

Cell[TextData[{
 "A primary interop assembly (PIA) is a special interop assembly that is \
signed by the vendor and given a strong name so that it can be placed into \
the global assembly cache (GAC). The idea behind a PIA is that a vendor of a \
COM type library will create an \"official\" interop assembly that represents \
the ideal interface to their type library. The .NET runtime recognizes PIAs \
as being special \"blessed\" assemblies, and it will load one automatically \
when you call ",
 Cell[BoxData[
  ButtonBox["CreateCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CreateCOMObject"]], "InlineFormula"],
 " on a coclass for which the associated PIA has been installed. If you are \
using a COM library, you should check to see if the vendor has created a PIA \
for it. If so, you should install it."
}], "Text",
 CellTags->"nlug:3.6.2",
 CellID->30125],

Cell[TextData[{
 "A good example of PIAs is the set created by Microsoft to accommodate the \
Office XP suite, which exposes a rich object model for Automation. Anyone \
trying to control an Office XP component like Word or Excel from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should obtain the Office PIAs from ",
 ButtonBox["http://msdn.microsoft.com/library/default.asp?url=/downloads/list/\
office.asp",
  BaseStyle->"Hyperlink",
  Evaluator->Automatic,
  ButtonData:>{
    URL["http://msdn.microsoft.com/library/default.asp?url=/downloads/list/\
office.asp"], None}],
 ". These PIAs are installed by default with Office 2003, but you can install \
them for use with Office XP and perhaps earlier versions of Office as well."
}], "Text",
 CellTags->"nlug:3.6.2",
 CellID->17905],

Cell[TextData[{
 "The ",
 ButtonBox["ExcelPieChart.nb",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/example/Part1/CallingCOM/ExcelPieChart"],
 " example file shows how to call Excel from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ". That example will work whether or not you have the Office PIAs installed, \
but if the PIAs are present, you have the advantages of working with strongly \
typed .NET objects instead of raw RCW objects. If the PIAs are installed on \
your machine, and ",
 Cell[BoxData[
  ButtonBox["CreateCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CreateCOMObject"]], "InlineFormula"],
 " is called to start an instance of Excel, it automatically returns a .NET \
type from the Excel interop assembly, not a raw RCW like ",
 StyleBox["<<NETObject[COMInterface[Excel._Application]]>>", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.6.2",
 CellID->29007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"excel", "=", 
  RowBox[{
  "CreateCOMObject", "[", "\"\<Excel.Application\>\"", "]"}]}]], "Input",
 Evaluatable->False,
 CellTags->"nlug:3.6.2",
 CellLabel->"In[16]:=",
 CellID->8418],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", 
    "[", "\<\"Microsoft.Office.Interop.Excel.ApplicationClass\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$134217729]], "Output",
 CellTags->"nlug:3.6.2",
 CellLabel->"Out[16]=",
 CellID->10900]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Releasing COM Resources", "Subsection",
 CellTags->"nlug:3.6.3",
 CellID->31728],

Cell[TextData[{
 "One of the roles of the RCW object in .NET is to manage the life cycle of \
the COM object it wraps. The COM object is destroyed when the RCW object is \
freed by the .NET garbage collector. Often, this level of control over the \
lifetime of the COM object is fine. Remember, though, that the .NET ",
 "garbage",
 " collector may run infrequently, and generally only when the .NET memory \
space (the \"managed\" heap) fills up. RCW objects have a small footprint in \
the managed heap, but they may hold onto very large objects (such as an \
instance of Excel) in the unmanaged COM world. In some COM usage scenarios, \
the .NET garbage collector may not run even though there are a large number \
of unfreed and unused RCW objects that are keeping alive a large amount of \
memory and other resources in the COM world. For this reason, it is important \
to have a function that forces the COM resources held by an object to be \
released. That function is ",
 Cell[BoxData[
  ButtonBox["ReleaseCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseCOMObject"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.6.3",
 CellID->21878],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ReleaseCOMObject",
      BaseStyle->"Link",
      ButtonData->"paclet:NETLink/ref/ReleaseCOMObject"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[
    "releases the COM resource owned by the given COM object"]}
  }]], "DefinitionBox",
 CellTags->"nlug:3.6.3",
 CellID->21827],

Cell["Releasing COM resources.", "Caption",
 CellTags->"nlug:3.6.3",
 CellID->4403],

Cell[TextData[{
 "Every COM object in .NET is represented by a single unique RCW. If you \
acquire a reference to the same COM object through two different means, you \
will get the same RCW each time. This sole RCW keeps a reference count on the \
COM object. This reference count is internal to COM and should not be \
confused with the reference count of a .NET object. Calling ",
 Cell[BoxData[
  ButtonBox["ReleaseCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseCOMObject"]], "InlineFormula"],
 " does not actually force the immediate release of COM \
resources\[LongDash]it just decrements this internal COM reference count. \
Often this count will be just one, ",
 Cell[BoxData[
  ButtonBox["ReleaseCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseCOMObject"]], "InlineFormula"],
 " will cause it to go to zero, and then the resources will be freed. ",
 Cell[BoxData[
  ButtonBox["ReleaseCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseCOMObject"]], "InlineFormula"],
 " returns the new reference count, so you can see if it has gone to zero \
yet."
}], "Text",
 CellTags->"nlug:3.6.3",
 CellID->18955],

Cell["\<\
Here is an example of acquiring multiple references to the same COM object. \
The following line launches a new instance of Excel. It will not become \
visible, but you can see it in the Task Manager listing of processes.\
\>", "Text",
 CellTags->"nlug:3.6.3",
 CellID->15739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"excel1", "=", 
  RowBox[{
  "CreateCOMObject", "[", "\"\<Excel.Application\>\"", "]"}]}]], "Input",
 CellTags->"nlug:3.6.3",
 CellLabel->"In[17]:=",
 CellID->7540],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", 
    "[", "\<\"Microsoft.Office.Interop.Excel.ApplicationClass\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$83886081]], "Output",
 CellTags->"nlug:3.6.3",
 CellLabel->"Out[17]=",
 CellID->21019]
}, Open  ]],

Cell[TextData[{
 "Now acquire two more references to that same instance of Excel. The ",
 Cell[BoxData[
  ButtonBox["GetActiveCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/GetActiveCOMObject"]], "InlineFormula"],
 " function is like ",
 Cell[BoxData[
  ButtonBox["CreateCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CreateCOMObject"]], "InlineFormula"],
 " except that instead of creating a new object, it acquires an \
already-active one. It is analogous to the ",
 StyleBox["GetActiveObject()", "MR"],
 " function in the COM API and Visual Basic 6. The ",
 StyleBox["Pause", "MR"],
 " is necessary here because COM apparently needs to catch its breath a bit \
between calls to ",
 StyleBox["GetActiveObject()", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.6.3",
 CellID->27680],

Cell[BoxData[{
 RowBox[{
  RowBox[{"excel2", "=", 
   RowBox[{"GetActiveCOMObject", "[", "\"\<Excel.Application\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Pause", "[", "1", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"excel3", "=", 
   RowBox[{"GetActiveCOMObject", "[", "\"\<Excel.Application\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"nlug:3.6.3",
 CellLabel->"In[18]:=",
 CellID->5393],

Cell[TextData[{
 "If you called ",
 Cell[BoxData[
  ButtonBox["ReleaseCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseCOMObject"]], "InlineFormula"],
 StyleBox["[excel1]", "MR"],
 " now, you probably would not want Excel to quit, because there are other \
outstanding references to Excel via the ",
 StyleBox["excel2", "MR"],
 " and ",
 StyleBox["excel3", "MR"],
 " objects. Note how calling ",
 Cell[BoxData[
  ButtonBox["ReleaseCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseCOMObject"]], "InlineFormula"],
 " decrements the COM reference count on the instance of Excel until it \
finally goes to zero. Only when it reaches zero will the Excel process quit."
}], "Text",
 CellTags->"nlug:3.6.3",
 CellID->42467692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ReleaseCOMObject", "[", "excel1", "]"}], ",", 
   RowBox[{"ReleaseCOMObject", "[", "excel2", "]"}], ",", 
   RowBox[{"ReleaseCOMObject", "[", "excel3", "]"}]}], "}"}]], "Input",
 CellTags->"nlug:3.6.3",
 CellLabel->"In[21]:=",
 CellID->10792],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", "0"}], "}"}]], "Output",
 CellTags->"nlug:3.6.3",
 CellLabel->"Out[21]=",
 CellID->7726]
}, Open  ]],

Cell[TextData[{
 "You have now seen how to use ",
 Cell[BoxData[
  ButtonBox["ReleaseCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseCOMObject"]], "InlineFormula"],
 " to force the timely release of COM resources. It is never strictly \
necessary to do this, as the .NET garbage collector will get around to it \
eventually, but often it is not timely enough. An alternative to using ",
 Cell[BoxData[
  ButtonBox["ReleaseCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseCOMObject"]], "InlineFormula"],
 " is simply to make sure that you use ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 " to allow the .NET objects you create to be released. Then you can manually \
force the .NET garbage collector to run. This is especially convenient if you \
have code that creates a lot of COM objects. Rather than keeping track of all \
of them and calling ",
 Cell[BoxData[
  ButtonBox["ReleaseCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseCOMObject"]], "InlineFormula"],
 " on each one, it is easier to use ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 " to ensure that the objects all have .NET reference counts of zero when you \
are done with them, and then call the garbage collector. Here is an outline \
of what that looks like."
}], "Text",
 CellTags->"nlug:3.6.3",
 CellID->657145216],

Cell["\<\
SomeFunction[args__] :=
\tModule[{result},
\t\tNETBlock[
\t\t\t... some code here that creates and manipulates COM objects
\t\t\tresult = ...
\t\t];
\t\tLoadNETType[\"System.GC\"];
\t\tGC`Collect[];
\t\tresult
\t]\
\>", "Input",
 Evaluatable->False,
 CellTags->"nlug:3.6.3",
 CellID->12359]
}, Open  ]],

Cell[CellGroupData[{

Cell["Casting COM Objects", "Subsection",
 CellTags->"nlug:3.6.4",
 CellID->1539],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["CastNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CastNETObject"]], "InlineFormula"],
 " function is described in ",
 ButtonBox["Casting",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#16712"],
 ". This function is rarely used for normal .NET objects, but it has special \
duties with respect to COM objects. The following example requires that you \
have the Microsoft Office XP primary interop assemblies installed on your \
machine. The next line will create a new instance of the Excel application, \
although it will not be visible."
}], "Text",
 CellTags->"nlug:3.6.4",
 CellID->22981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"excel", "=", 
  RowBox[{
  "NETNew", "[", "\"\<Microsoft.Office.Interop.Excel.ApplicationClass\>\"", 
   "]"}]}]], "Input",
 CellTags->"nlug:3.6.4",
 CellLabel->"In[22]:=",
 CellID->17552],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", 
    "[", "\<\"Microsoft.Office.Interop.Excel.ApplicationClass\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$318767105]], "Output",
 CellTags->"nlug:3.6.4",
 CellLabel->"Out[22]=",
 CellID->25383]
}, Open  ]],

Cell["Now create a new workbook.", "Text",
 CellTags->"nlug:3.6.4",
 CellID->30442],

Cell[BoxData[
 RowBox[{
  RowBox[{"excel", "@", 
   RowBox[{"Workbooks", "@", 
    RowBox[{"Add", "[", "]"}]}]}], ";"}]], "Input",
 CellTags->"nlug:3.6.4",
 CellLabel->"In[23]:=",
 CellID->1979],

Cell[TextData[{
 "The ",
 StyleBox["ApplicationClass", "MR"],
 " class has a property called ",
 StyleBox["ActiveSheet", "MR"],
 " that will return the worksheet in the workbook you just created."
}], "Text",
 CellTags->"nlug:3.6.4",
 CellID->24807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"activeSheet", "=", 
  RowBox[{"excel", "@", "ActiveSheet"}]}]], "Input",
 CellTags->"nlug:3.6.4",
 CellLabel->"In[24]:=",
 CellID->8889],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]NETObject", "[", 
    RowBox[{"COMInterface", "[", "\<\"Excel._Worksheet\"\>", "]"}], "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$1892867373$369098753]], "Output",
 CellTags->"nlug:3.6.4",
 CellLabel->"Out[24]=",
 CellID->25780]
}, Open  ]],

Cell[TextData[{
 "Notice that the result from ",
 StyleBox["ActiveSheet", "MR"],
 " is a raw RCW object, not a strongly typed .NET object (recall that raw RCW \
objects are of the class ",
 StyleBox["System.__ComObject", "MR"],
 ", and ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " tries to format them with the name of the default COM interface that they \
support). There is a ",
 StyleBox["Microsoft.Office.Interop.Excel.WorksheetClass", "MR"],
 " class in the Excel interop assembly that represents worksheets, so why was \
the result of ",
 StyleBox["ActiveSheet", "MR"],
 " not an instance of that class? To see the answer, look at the declaration \
of the ",
 StyleBox["ActiveSheet", "MR"],
 " property."
}], "Text",
 CellTags->"nlug:3.6.4",
 CellID->31265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NETTypeInfo", "[", 
  RowBox[{"excel", ",", "\"\<Properties\>\"", ",", "\"\<ActiveSheet\>\""}], 
  "]"}]], "Input",
 CellTags->"nlug:3.6.4",
 CellLabel->"In[25]:=",
 CellID->4783],

Cell[BoxData[GridBox[{
   {""},
   {Cell[BoxData[
     RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Properties",
       FontSize->18,
       FontWeight->"Bold",
       FontSlant->
        "Italic"], "\<\" (matching string pattern ActiveSheet)\"\>"}]]]},
   {
    RowBox[{"virtual", " ", "\<\"object\"\>", " ", 
     StyleBox["ActiveSheet",
      FontWeight->"Bold"], "  ", 
     RowBox[{"[", 
      RowBox[{"read", " ", "only"}], "]"}]}]}
  },
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}},
  GridBoxItemSize->{
   "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.2}}, 
    "RowsIndexed" -> {}}]], "Output",
 AutoSpacing->False,
 CellTags->"nlug:3.6.4",
 CellID->15794]
}, Open  ]],

Cell[TextData[{
 "Note that this property is typed to return only ",
 StyleBox["object", "MR"],
 ", not ",
 StyleBox["WorksheetClass", "MR"],
 ". That is because the active sheet could be a chart or a worksheet, and \
these are different classes. In an interop assembly, methods or properties \
that are typed to return ",
 StyleBox["object", "MR"],
 " will return a raw RCW. This reminds you that COM objects in .NET are \
different animals than normal .NET objects. When any object is marshaled from \
COM into .NET, it always arrives as a raw RCW. With the help of type \
information from an interop assembly, the .NET runtime can cast a raw RCW to \
a specific managed type. For example, if a method is typed to return class ",
 StyleBox["X", "MR"],
 ", and the method returns a COM object (as an RCW), .NET casts the RCW to \
the type ",
 StyleBox["X", "MR"],
 " before returning it from the method. If a method is typed to return only \
",
 StyleBox["object", "MR"],
 ", like the ",
 StyleBox["ActiveSheet", "MR"],
 " property, then there is no type information that .NET can use to cast the \
object, so you end up with a raw RCW."
}], "Text",
 CellTags->"nlug:3.6.4",
 CellID->8463],

Cell[TextData[{
 "You can use the object returned by ",
 StyleBox["ActiveSheet", "MR"],
 ", but you will be calling it via late binding because it has no type \
information. If you want to make a strongly typed object that you can call \
via early binding, then you do exactly what you would do in C# or Visual \
Basic .NET\[LongDash]you cast the object to the desired type. Once you have \
cast to the desired managed type, you once again have all the advantages that \
come from using an interop assembly instead of using late binding. In this \
example, you know that the active sheet is a worksheet, so you can cast it to \
",
 StyleBox["WorksheetClass", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.6.4",
 CellID->17013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"activeSheet", "=", 
  RowBox[{"CastNETObject", "[", 
   RowBox[{
    RowBox[{"excel", "@", "ActiveSheet"}], ",", 
    "\"\<Microsoft.Office.Interop.Excel.WorksheetClass\>\""}], 
   "]"}]}]], "Input",
 CellTags->"nlug:3.6.4",
 CellLabel->"In[26]:=",
 CellID->20925],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", 
    "[", "\<\"Microsoft.Office.Interop.Excel.WorksheetClass\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$402653185]], "Output",
 CellTags->"nlug:3.6.4",
 CellLabel->"Out[262]=",
 CellID->1961]
}, Open  ]],

Cell["\<\
If this sounds confusing, remember that this is exactly what is done in C# or \
Visual Basic .NET. Here is what it would look like in C#.\
\>", "Text",
 CellTags->"nlug:3.6.4",
 CellID->16397],

Cell["\<\
ApplicationClass excel = new ApplicationClass();
excel.Workbooks.Add();
WorksheetClass activeSheet = (WorksheetClass) excel.ActiveSheet;\
\>", "Program",
 CellTags->"nlug:3.6.4",
 CellID->14361],

Cell[TextData[{
 "If the COM object cannot be cast to the specified managed type, ",
 Cell[BoxData[
  ButtonBox["CastNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CastNETObject"]], "InlineFormula"],
 " will issue a message and return ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Failed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Failed"], "MR"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"nlug:3.6.4",
 CellID->7485],

Cell[TextData[{
 "In ",
 ButtonBox["Casting",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#16712"],
 " , it was stated that there is never a need to downcast in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", because objects always have their true runtime type\[LongDash]there is \
never a type lower in the inheritance hierarchy to downcast to. This rule \
does not apply for casting COM objects, because in some sense the runtime \
type of all COM objects is just the raw RCW class ",
 StyleBox["__ComObject", "MR"],
 ". In the presence of type information, the .NET runtime can downcast \
automatically to more derived managed types. When a property or method is \
typed to return only ",
 StyleBox["object", "MR"],
 ", you can downcast the object yourself, provided you know the correct \
type."
}], "Text",
 CellTags->"nlug:3.6.4",
 CellID->13095]
}, Open  ]],

Cell[CellGroupData[{

Cell["Handling COM Events", "Subsection",
 CellTags->{"Handling COM Events", "nlug:3.6.5"},
 CellID->23007],

Cell[TextData[{
 "The .NET runtime knows how to map COM events to .NET events, which means \
that responding to events fired by COM objects is just like responding to \
events fired by .NET objects. You must use an ",
 ButtonBox["interop assembly",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#17803"],
 " to handle COM events in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code\[LongDash]you cannot use late binding."
}], "Text",
 CellTags->"nlug:3.6.5",
 CellID->17156],

Cell[TextData[{
 "The following example shows how to handle COM events fired by Internet \
Explorer. Internet Explorer supports a rich object model for the content of \
an HTML window. This is called the document object model, and it is exposed \
to clients via the ",
 StyleBox["mshtml", "MR"],
 " COM library. Microsoft bundles with the .NET Framework a primary interop \
assembly for ",
 StyleBox["mshtml", "MR"],
 ", to make it easier to use from .NET programs. Presumably, there will \
eventually be a native .NET version of Internet Explorer and ",
 StyleBox["mshtml", "MR"],
 ", but for now, as with many other COM-based Microsoft technologies, you use \
them from .NET via an interop assembly. The example developed below will \
display a web page in an Internet Explorer window, and as the user moves the \
mouse over elements in the page, the elements will have their font size \
changed randomly."
}], "Text",
 CellTags->"nlug:3.6.5",
 CellID->27544],

Cell[TextData[{
 "The ",
 StyleBox["mshtml", "MR"],
 " COM component and its associated primary interop assembly only manage the \
content of an Internet Explorer window. The Internet Explorer application is \
a separate COM object that must be created in the usual way for raw COM \
objects."
}], "Text",
 CellTags->"nlug:3.6.5",
 CellID->4605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ie", "=", 
  RowBox[{
  "CreateCOMObject", "[", "\"\<InternetExplorer.Application\>\"", 
   "]"}]}]], "Input",
 CellTags->"nlug:3.6.5",
 CellLabel->"In[27]:=",
 CellID->6624],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]NETObject", "[", 
    RowBox[{"COMInterface", "[", "\<\"SHDocVw.IWebBrowser2\"\>", "]"}], "]"}],
    "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$16336286$14008975361]], "Output",
 CellTags->"nlug:3.6.5",
 CellLabel->"Out[27]=",
 CellID->16056]
}, Open  ]],

Cell[TextData[{
 "The fact that this object is formatted with ",
 StyleBox["COMInterface[...", "MR"],
 "] indicates that it is a raw RCW and you can only interact with it via \
Automation. This is fine, as only a few simple properties are needed. To get \
documentation for COM objects, look them up in the MSDN Library, either \
online or in the Visual Studio help system."
}], "Text",
 CellTags->"nlug:3.6.5",
 CellID->20892],

Cell["First, navigate to a URL.", "Text",
 CellTags->"nlug:3.6.5",
 CellID->12250],

Cell[BoxData[
 RowBox[{"ie", "@", 
  RowBox[{
  "navigate", "[", "\"\<www.wolfram.com/solutions/mathlink\>\"", 
   "]"}]}]], "Input",
 CellTags->"nlug:3.6.5",
 CellLabel->"In[28]:=",
 CellID->16085],

Cell["\<\
Now make the browser window visible and loop until the page has completely \
loaded.\
\>", "Text",
 CellTags->"nlug:3.6.5",
 CellID->2420],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ie", "@", "Visible"}], "=", "True"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"ie", "@", "Busy"}], ",", 
    RowBox[{"Pause", "[", "1", "]"}]}], "]"}], ";"}]}], "Input",
 CellTags->"nlug:3.6.5",
 CellLabel->"In[29]:=",
 CellID->9431],

Cell["\<\
You want to interact not with the Internet Explorer application but with the \
document object that it contains, so acquire that object. \
\>", "Text",
 CellTags->"nlug:3.6.5",
 CellID->31516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"doc", "=", 
  RowBox[{"ie", "@", "Document"}]}]], "Input",
 CellTags->"nlug:3.6.5",
 CellLabel->"In[31]:=",
 CellID->28786],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", "[", "\<\"mshtml.HTMLDocumentClass\"\>", 
    "]"}], "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$1157627905]], "Output",
 CellTags->"nlug:3.6.5",
 CellLabel->"Out[31]=",
 CellID->5034]
}, Open  ]],

Cell["\<\
Note that this object is a strongly typed .NET object, not a raw RCW. Because \
there is a primary interop assembly for the document object model, whenever \
such a COM object is imported into .NET it can be automatically wrapped in \
the .NET class that is mapped to the document COM coclass. You are now in the \
cozy world of using strongly typed objects from an interop assembly.\
\>", "Text",
 CellTags->"nlug:3.6.5",
 CellID->7491],

Cell[TextData[{
 "COM events fired by an object are mapped to .NET events in the interop \
assembly. You will see a .NET event member for each method in every ",
 StyleBox["[source]", "MR"],
 " COM interface that a .NET class implements. You can use ",
 Cell[BoxData[
  ButtonBox["NETTypeInfo",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETTypeInfo"]], "InlineFormula"],
 " to see the events that are fired by the ",
 StyleBox["HTMLDocumentClass", "MR"],
 " class. There are quite a few for this class, so this just shows the one \
you need."
}], "Text",
 CellTags->"nlug:3.6.5",
 CellID->28647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NETTypeInfo", "[", 
  RowBox[{"doc", ",", "\"\<Events\>\"", ",", "\"\<*onmouseover*\>\""}], 
  "]"}]], "Input",
 CellTags->"nlug:3.6.5",
 CellLabel->"In[32]:=",
 CellID->365266020],

Cell[BoxData[GridBox[{
   {""},
   {Cell[BoxData[
     RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Events",
       FontSize->18,
       FontWeight->"Bold",
       FontSlant->
        "Italic"], "\<\" (matching string pattern *onmouseover*)\"\>"}]]]},
   {
    RowBox[{
    "virtual", " ", "event", 
     " ", "\<\"mshtml.HTMLDocumentEvents2_onmouseoverEventHandler\"\>", " ", 
     StyleBox[
      RowBox[{"HTMLDocumentEvents2_Event", "_onmouseover"}],
      FontWeight->
       "Bold"], "\<\"  [arguments to delegate: \"\>", \
"\<\"(mshtml.IHTMLEventObj pEvtObj)\"\>", "\<\"]\"\>"}]},
   {
    RowBox[{
    "virtual", " ", "event", 
     " ", "\<\"mshtml.HTMLDocumentEvents_onmouseoverEventHandler\"\>", " ", 
     StyleBox[
      RowBox[{"HTMLDocumentEvents_Event", "_onmouseover"}],
      FontWeight->
       "Bold"], "\<\"  [arguments to delegate: \"\>", "\<\"()\"\>", \
"\<\"]\"\>"}]}
  },
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}},
  GridBoxItemSize->{
   "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.2}}, 
    "RowsIndexed" -> {}}]], "Output",
 AutoSpacing->False,
 CellTags->"nlug:3.6.5",
 CellID->947]
}, Open  ]],

Cell[TextData[{
 "There are two ",
 StyleBox["onmouseover", "MR"],
 " events inherited from two different interfaces. You want to use the one \
named ",
 StyleBox["HTMLDocumentEvents2_Event_onmouseover", "MR"],
 ", which supplies an argument. There is no separate documentation for the ",
 StyleBox["mshtml", "MR"],
 " primary interop assembly, so you have to use the documentation for the COM \
version and make the appropriate mental translations, which are usually quite \
straightforward. You can find full documentation on the ",
 StyleBox["mshtml", "MR"],
 " component at ",
 ButtonBox["http://msdn.microsoft.com/library/default.asp?url=/workshop/\
browser/mshtml/reference/reference.asp",
  BaseStyle->"Hyperlink",
  Evaluator->Automatic,
  ButtonData:>{
    URL["http://msdn.microsoft.com/library/default.asp?url=/workshop/browser/\
mshtml/reference/reference.asp"], None}],
 "."
}], "Text",
 CellTags->"nlug:3.6.5",
 CellID->14889],

Cell[TextData[{
 ButtonBox["Handling Events",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#21428"],
 " shows you how to use the ",
 Cell[BoxData[
  ButtonBox["AddEventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/AddEventHandler"]], "InlineFormula"],
 " function to assign ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions to be called when events are fired in .NET. You use the same \
function for COM events, as they are made to look just like .NET events by \
the interop assembly. Note that as always you must change ",
 StyleBox["_", "MR"],
 " characters to ",
 StyleBox["U", "MR"],
 " when using .NET names as symbols."
}], "Text",
 CellTags->"nlug:3.6.5",
 CellID->31092],

Cell[BoxData[
 RowBox[{
  RowBox[{"AddEventHandler", "[", 
   RowBox[{
    RowBox[{"doc", "@", "HTMLDocumentEvents2UEventUonmouseover"}], ",", 
    "onMouseOver"}], "]"}], ";"}]], "Input",
 CellTags->"nlug:3.6.5",
 CellLabel->"In[33]:=",
 CellID->23296],

Cell[TextData[{
 "Now define the ",
 StyleBox["onMouseOver", "MR"],
 " function. The ",
 Cell[BoxData[
  ButtonBox["NETTypeInfo",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETTypeInfo"]], "InlineFormula"],
 " call above told you that the argument to the event is of interface type ",
 StyleBox["mshtml.IHTMLEventObj", "MR"],
 ". This is the managed equivalent of the ",
 StyleBox["IHTMLEventObj", "MR"],
 " COM interface, and from the documentation for that interface you can cook \
up the following simple function that wraps every element in a ",
 StyleBox["<FONT>", "MR"],
 " element that specifies a random font size."
}], "Text",
 CellTags->"nlug:3.6.5",
 CellID->163936306],

Cell[BoxData[
 RowBox[{
  RowBox[{"onMouseOver", "[", "evt_", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "element", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"element", "=", 
      RowBox[{"evt", "@", "srcElement"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"element", "@", "innerHTML"}], "=", 
      RowBox[{"\"\<<FONT size='\>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"Random", "[", 
         RowBox[{"Integer", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "7"}], "}"}]}], "]"}], "]"}], "<>", "\"\<'>\>\"",
        "<>", 
       RowBox[{"element", "@", "innerHTML"}], "<>", "\"\<</FONT>\>\""}]}], 
     ";"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"nlug:3.6.5",
 CellLabel->"In[34]:=",
 CellID->28223],

Cell[TextData[{
 "Before you actually try moving the mouse over the web page, there is one \
more detail that must be handled. ",
 ButtonBox["Manually Sharing the Kernel and Front End with .NET",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#27606"],
 " shows how to use the ",
 StyleBox["ShareKernel", "MR"],
 " function to put the kernel into a state where it was receptive to calls \
arriving from .NET. ",
 StyleBox["ShareKernel", "MR"],
 " is not often needed in ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", because you can usually enter and leave the sharing state automatically \
using the  ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " function. ",
 Cell[BoxData[
  ButtonBox["DoNETModeless",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModeless"]], "InlineFormula"],
 " requires a top-level window as its argument, however. Here you have no \
such window, just an instance of Internet Explorer. Therefore you have to use \
",
 StyleBox["ShareKernel", "MR"],
 " to manually enter the sharing state. As always, you save the result from \
",
 StyleBox["ShareKernel", "MR"],
 " to pass into ",
 StyleBox["UnshareKernel", "MR"],
 " later."
}], "Text",
 CellTags->"nlug:3.6.5",
 CellID->32172],

Cell[BoxData[
 RowBox[{
  RowBox[{"tok", "=", 
   RowBox[{"ShareKernel", "[", 
    RowBox[{"NETLink", "[", "]"}], "]"}]}], ";"}]], "Input",
 CellTags->"nlug:3.6.5",
 CellLabel->"In[35]:=",
 CellID->11048],

Cell["\<\
Now bring the Internet Explorer window to the foreground and move the mouse \
over it (without pressing the mouse button). It might take a second or two \
for the first font effect to occur.\
\>", "Text",
 CellTags->"nlug:3.6.5",
 CellID->23],

Cell["Make sure you clean things up when you are done.", "Text",
 CellTags->"nlug:3.6.5",
 CellID->22291],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ie", "@", 
   RowBox[{"Quit", "[", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"UnshareKernel", "[", "tok", "]"}], ";"}]}], "Input",
 CellTags->"nlug:3.6.5",
 CellLabel->"(sharing) In[36]:=",
 CellID->18166],

Cell[TextData[{
 "This is a frivolous example, but you can imagine many more useful and \
sophisticated ways to interact with a browser window using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:3.6.5",
 CellID->30261]
}, Open  ]],

Cell[CellGroupData[{

Cell["Displaying ActiveX Controls", "Subsection",
 CellTags->"nlug:3.6.6",
 CellID->4981],

Cell[TextData[{
 "Many COM objects have a visual representation, such as a toolbar, grid box, \
or other window element. Although the term \"ActiveX control\" is really just \
a synonym for \"COM object,\" visual COM objects are usually referred to as \
ActiveX controls. If you want to display an ActiveX control in a .NET \
program, you must create a special type of interop assembly for the control. \
This assembly is created with the ",
 StyleBox["aximp.exe", "MR"],
 " tool (ActiveX importer), which is similar to the ",
 StyleBox["tlbimp", "MR"],
 " tool discussed earlier, except that it is specific to ActiveX controls \
that must be hosted within a .NET window. If a control is to be hosted within \
a .NET window, it needs a special wrapper class that inherits from ",
 StyleBox["System.Windows.Forms.Control", "MR"],
 ". The ",
 StyleBox["aximp", "MR"],
 " tool creates this wrapper class."
}], "Text",
 CellTags->"nlug:3.6.6",
 CellID->941],

Cell[TextData[{
 "There is full documentation for ",
 StyleBox["aximp", "MR"],
 " in the .NET Framework SDK, but here is a simple example. Say you want to \
use the Microsoft Calendar Control in a .NET window (you probably have this \
control installed on your machine). Assume that the type library for this \
control is in the file ",
 StyleBox["d:\\OfficeXP\\Office10\\mscal.ocx", "MR"],
 " on your machine. (One way to get information like this is by looking up \
the control using the OLE View tool that is bundled with Visual Studio.) The \
following command line runs ",
 StyleBox["aximp", "MR"],
 " (of course, ",
 StyleBox["aximp.exe", "MR"],
 " has to be on your ",
 StyleBox["PATH", "MR"],
 " for this to work as written)."
}], "Text",
 CellTags->"nlug:3.6.6",
 CellID->16461],

Cell["c:\\> aximp d:\\OfficeXp\\Office10\\mscal.ocx", "Program",
 CellTags->"nlug:3.6.6",
 CellID->29443],

Cell[TextData[{
 "The above invocation of ",
 StyleBox["aximp", "MR"],
 " creates two assemblies in the current directory: ",
 StyleBox["MSACAL.dll", "MR"],
 " and ",
 StyleBox["AxMSACAL.dll", "MR"],
 " (the \"MSACAL\" comes from the ",
 StyleBox["library MSACAL", "MR"],
 " statement in the control\[CloseCurlyQuote]s type library definition). The \
",
 StyleBox["MSACAL.dll", "MR"],
 " assembly contains managed types for the ",
 StyleBox["ICalendar", "MR"],
 " interface and ",
 StyleBox["CalendarClass", "MR"],
 " class, along with a few others. This is the same interop assembly that \
would be created by using the ",
 StyleBox["tlbimp", "MR"],
 " tool. The second assembly, ",
 StyleBox["AxMSACAL.dll", "MR"],
 ", contains the special wrapper class that makes the Calendar control into a \
.NET control that can be hosted in a .NET window. This wrapper class is \
called ",
 StyleBox["AxCalendar", "MR"],
 ", named according to the convention \"Ax\" followed by the name of the COM \
coclass (Calendar). The ",
 StyleBox["ildasm.exe", "MR"],
 " tool (intermediate language disassembler) is very useful for examining the \
created assemblies. The ",
 StyleBox["ildasm.exe", "MR"],
 " program is bundled with the .NET Framework SDK and resides in the same \
directory as ",
 StyleBox["aximp.exe", "MR"],
 " and ",
 StyleBox["tlbimp.exe", "MR"],
 "."
}], "Text",
 CellTags->"nlug:3.6.6",
 CellID->12245],

Cell[TextData[{
 "When you load the ",
 StyleBox["AxMSACAL.dll", "MR"],
 " assembly, the ",
 StyleBox["MSACAL.dll", "MR"],
 " assembly will be loaded as well, because ",
 StyleBox["AxMSACAL.dll", "MR"],
 " is dependent on it and it resides in the same directory. "
}], "Text",
 CellTags->"nlug:3.6.6",
 CellID->3696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadNETAssembly", "[", "\"\<c:\\\\AxMSACAL.dll\>\"", "]"}]], "Input",\

 CellTags->"nlug:3.6.6",
 CellLabel->"In[1]:=",
 CellID->14229],

Cell[BoxData[
 RowBox[{"NETAssembly", "[", 
  RowBox[{"\<\"AxMSACAL\"\>", ",", "1"}], "]"}]], "Output",
 CellTags->"nlug:3.6.6",
 CellLabel->"Out[1]=",
 CellID->123827466]
}, Open  ]],

Cell[TextData[{
 "Now create an instance of the ",
 StyleBox["AxCalendar", "MR"],
 " wrapper class. This class has all the methods and properties of the \
Calendar COM object, and it also inherits from the ",
 StyleBox["System.Windows.Forms.Control", "MR"],
 " class, so it can be used like any other .NET control."
}], "Text",
 CellTags->"nlug:3.6.6",
 CellID->23900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cal", "=", 
  RowBox[{"NETNew", "[", "\"\<AxMSACAL.AxCalendar\>\"", "]"}]}]], "Input",
 CellTags->"nlug:3.6.6",
 CellLabel->"In[2]:=",
 CellID->3650],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]NETObject", "[", "\<\"AxMSACAL.AxCalendar\"\>", "]"}], 
   "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$83886081]], "Output",
 CellTags->"nlug:3.6.6",
 CellLabel->"Out[2]=",
 CellID->6703]
}, Open  ]],

Cell[TextData[{
 "Now create a .NET form to host the control and display it. The ",
 Cell[BoxData[
  ButtonBox["DoNETModal",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/DoNETModal"]], "InlineFormula"],
 " function at the end will display the form and return the calendar\
\[CloseCurlyQuote]s ",
 StyleBox["Value", "MR"],
 " property when the form is closed. This property will hold the date the \
user selected."
}], "Text",
 CellTags->"nlug:3.6.6",
 CellID->24828],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"form", "=", 
   RowBox[{"NETNew", "[", "\"\<System.Windows.Forms.Form\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"cal", "@", "Parent"}], "=", "form"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"LoadNETType", "[", "\"\<System.Windows.Forms.DockStyle\>\"", "]"}],
   ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"cal", "@", "Dock"}], "=", "DockStyle`Fill"}], ";"}], "\n", 
 RowBox[{"calDate", "=", 
  RowBox[{"DoNETModal", "[", 
   RowBox[{"form", ",", 
    RowBox[{"cal", "@", "Value"}]}], "]"}]}]}], "Input",
 CellTags->"nlug:3.6.6",
 CellLabel->"In[3]:=",
 CellID->14731],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[LeftGuillemet]NETObject", "[", "\<\"System.DateTime\"\>", "]"}],
    "\[RightGuillemet]"}],
  NETLink`Objects`NETObject$70880026211385345]], "Output",
 CellTags->"nlug:3.6.6",
 CellLabel->"Out[7]=",
 CellID->8941]
}, Open  ]],

Cell[TextData[{
 "The .NET runtime has conveniently mapped the result of the ",
 StyleBox["Value", "MR"],
 " property to a ",
 StyleBox["DateTime", "MR"],
 " object. This is easily manipulated to get the selected date as a string."
}], "Text",
 CellTags->"nlug:3.6.6",
 CellID->24523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"calDate", "@", 
  RowBox[{"ToString", "[", "]"}]}]], "Input",
 CellTags->"nlug:3.6.6",
 CellLabel->"In[8]:=",
 CellID->1942],

Cell[BoxData["\<\"1/1/2007 12:00:00 AM\"\>"], "Output",
 CellTags->"nlug:3.6.6",
 CellLabel->"Out[8]=",
 CellID->22710]
}, Open  ]],

Cell[TextData[{
 "Now clean up by releasing the calendar object. Note that you do not call ",
 Cell[BoxData[
  ButtonBox["ReleaseCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseCOMObject"]], "InlineFormula"],
 " on the ",
 StyleBox["AxCalendar", "MR"],
 " object, because it is not a COM object\[LongDash]it is a pure .NET class \
that merely holds a reference to a COM object. The actual COM object is of \
class ",
 StyleBox["MSACAL.CalendarClass", "MR"],
 ", but you never directly create an instance of that class, just the ",
 StyleBox["AxCalendar", "MR"],
 " wrapper."
}], "Text",
 CellTags->"nlug:3.6.6",
 CellID->8388],

Cell[BoxData[
 RowBox[{"ReleaseNETObject", "[", "cal", "]"}]], "Input",
 CellTags->"nlug:3.6.6",
 CellLabel->"In[9]:=",
 CellID->6013]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example Files", "Subsection",
 CellTags->"nlug:3.6.7",
 CellID->788],

Cell[TextData[{
 "The following example program included with ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " demonstrates calling COM components from ",
 StyleBox["Mathematica.",
  FontSlant->"Italic"]
}], "Text",
 CellTags->"nlug:3.6.7",
 CellID->23479],

Cell[TextData[ButtonBox["ExcelPieChart.nb",
 BaseStyle->"Link",
 ButtonData->"paclet:NETLink/example/Part1/CallingCOM/ExcelPieChart"]], "Text",\

 CellTags->"nlug:3.6.7",
 CellID->8073]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Calling .NET from Mathematica - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "Calling .NET from Mathematica", "summary" -> 
    ".NET/Link provides Mathematica users with the ability to interact with \
arbitrary .NET types directly from Mathematica. You can create objects and \
call methods and properties directly in the Mathematica language. You do not \
need to write any .NET code, or prepare in any way the .NET types you want to \
use. You also do not need to know anything about MathLink. In effect, all of \
.NET becomes a transparent extension to Mathematica, almost as if every \
existing and future .NET type were written in the Mathematica language \
itself. We call this facility 'installable .NET' because it generalizes the \
ability that Mathematica has always had to plug in extensions written in \
other languages through the Install function. Compared to other languages \
like C or C++, however, .NET/Link makes the intermediate steps go away \
completely, which is why we say that .NET becomes a transparent extension to \
Mathematica. Although .NET is sometimes referred to as an interpreted \
environment, this is really a misnomer. To use .NET you must write a complete \
program in a language like C#, compile it, and then execute it. Mathematica \
users have the luxury of working in a true interpreted, interactive \
environment that lets them experiment with functions and build and test \
programs a line at a time. .NET/Link brings this same productive environment \
to .NET programmers. You could say that Mathematica becomes a scripting \
language for .NET.", "uri" -> "NETLink/tutorial/CallingNETFromMathematica", 
    "type" -> "Tutorial", "label" -> "N E T Link Tutorial", "paclet" -> 
    "NETLink", "context" -> "", "keywords" -> {}, "synonyms" -> {}, "status" -> 
    "None", "built" -> "{2007, 4, 18, 11, 15, 40.3095034}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "nlug:3.0"->{
  Cell[949, 43, 70, 2, 70, "Section",
   CellTags->"nlug:3.0",
   CellID->26930],
  Cell[1022, 47, 899, 27, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->3826],
  Cell[1924, 76, 782, 24, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->2852],
  Cell[2709, 102, 726, 18, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->5675],
  Cell[3438, 122, 622, 18, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->24177],
  Cell[4063, 142, 515, 15, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->20734],
  Cell[4581, 159, 112, 3, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->16620],
  Cell[4696, 164, 175, 4, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->23893],
  Cell[4874, 170, 109, 3, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->15023],
  Cell[4986, 175, 190, 5, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->25940],
  Cell[5179, 182, 192, 5, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->19959],
  Cell[5374, 189, 209, 6, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->2118],
  Cell[5586, 197, 196, 5, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->13028],
  Cell[5785, 204, 192, 5, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->17376],
  Cell[5980, 211, 109, 3, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->17945],
  Cell[6092, 216, 192, 5, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->10453],
  Cell[6287, 223, 181, 5, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->27035],
  Cell[6471, 230, 177, 4, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->15565],
  Cell[6651, 236, 116, 3, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->20826],
  Cell[6770, 241, 184, 5, 70, "Text",
   CellTags->"nlug:3.0",
   CellID->15670]},
 "nlug:3.1.0"->{
  Cell[6991, 251, 88, 2, 70, "Section",
   CellTags->"nlug:3.1.0",
   CellID->23489],
  Cell[7082, 255, 222, 10, 70, "Text",
   CellTags->"nlug:3.1.0",
   CellID->4497],
  Cell[7307, 267, 114, 3, 70, "Input",
   CellTags->"nlug:3.1.0",
   CellID->25338]},
 "nlug:3.1.1"->{
  Cell[7458, 275, 86, 2, 70, "Section",
   CellTags->"nlug:3.1.1",
   CellID->25576],
  Cell[7547, 279, 257, 9, 70, "Text",
   CellTags->"nlug:3.1.1",
   CellID->22674],
  Cell[7807, 290, 117, 4, 70, "Input",
   CellTags->"nlug:3.1.1",
   CellID->20325],
  Cell[7927, 296, 1107, 29, 70, "Text",
   CellTags->"nlug:3.1.1",
   CellID->31465],
  Cell[9037, 327, 958, 30, 70, "DefinitionBox",
   CellTags->"nlug:3.1.1",
   CellID->23829],
  Cell[9998, 359, 86, 2, 70, "Caption",
   CellTags->"nlug:3.1.1",
   CellID->2650]},
 "Loading .NET Assemblies and Types"->{
  Cell[10121, 366, 131, 2, 70, "Section",
   CellTags->{"Loading .NET Assemblies and Types", "nlug:3.1.2"},
   CellID->1113]},
 "nlug:3.1.2"->{
  Cell[10121, 366, 131, 2, 70, "Section",
   CellTags->{"Loading .NET Assemblies and Types", "nlug:3.1.2"},
   CellID->1113],
  Cell[10277, 372, 107, 2, 70, "Subsection",
   CellTags->{"Loading .NET Assemblies", "nlug:3.1.2"},
   CellID->20646],
  Cell[10387, 376, 1020, 19, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->25443],
  Cell[11410, 397, 777, 15, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->28914],
  Cell[12190, 414, 1297, 28, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->12515],
  Cell[13490, 444, 1160, 34, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->18787],
  Cell[14687, 483, 70, 2, 70, "Subsection",
   CellTags->"nlug:3.1.2",
   CellID->90],
  Cell[14760, 487, 473, 11, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->32197],
  Cell[15236, 500, 724, 22, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->29569],
  Cell[15997, 527, 77, 2, 70, "Subsection",
   CellTags->"nlug:3.1.2",
   CellID->2433],
  Cell[16077, 531, 866, 25, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->24148],
  Cell[16946, 558, 2070, 61, 70, "DefinitionBox",
   CellTags->"nlug:3.1.2",
   CellID->26130],
  Cell[19019, 621, 78, 2, 70, "Caption",
   CellTags->"nlug:3.1.2",
   CellID->7204],
  Cell[19100, 625, 302, 9, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->12862],
  Cell[19427, 638, 148, 4, 70, "Input",
   CellTags->"nlug:3.1.2",
   CellID->9836],
  Cell[19578, 644, 169, 5, 70, "Output",
   CellTags->"nlug:3.1.2",
   CellID->18460],
  Cell[19762, 652, 634, 19, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->17230],
  Cell[20399, 673, 613, 16, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->24611],
  Cell[21037, 693, 223, 6, 70, "Input",
   CellTags->"nlug:3.1.2",
   CellID->4309],
  Cell[21263, 701, 168, 5, 70, "Output",
   CellTags->"nlug:3.1.2",
   CellID->4568],
  Cell[21446, 709, 192, 5, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->7030],
  Cell[21641, 716, 600, 18, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->18138],
  Cell[22244, 736, 170, 5, 70, "Input",
   CellTags->"nlug:3.1.2",
   CellID->24932],
  Cell[22417, 743, 165, 5, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->7001],
  Cell[22585, 750, 1368, 40, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->29102],
  Cell[23956, 792, 174, 5, 70, "Input",
   CellTags->"nlug:3.1.2",
   CellID->16191],
  Cell[24133, 799, 274, 6, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->3406],
  Cell[24444, 810, 74, 2, 70, "Subsection",
   CellTags->"nlug:3.1.2",
   CellID->17804],
  Cell[24521, 814, 1480, 42, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->8579],
  Cell[26004, 858, 1604, 48, 70, "DefinitionBox",
   CellTags->"nlug:3.1.2",
   CellID->31673],
  Cell[27611, 908, 74, 2, 70, "Caption",
   CellTags->"nlug:3.1.2",
   CellID->28210],
  Cell[27688, 912, 239, 9, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->28965],
  Cell[27952, 925, 160, 5, 70, "Input",
   CellTags->"nlug:3.1.2",
   CellID->37],
  Cell[28115, 932, 180, 5, 70, "Output",
   CellTags->"nlug:3.1.2",
   CellID->22219],
  Cell[28310, 940, 606, 19, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->9818],
  Cell[28919, 961, 730, 19, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->25049],
  Cell[29686, 985, 96, 2, 70, "Subsection",
   CellTags->"nlug:3.1.2",
   CellID->712],
  Cell[29785, 989, 591, 17, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->28646],
  Cell[30379, 1008, 826, 26, 70, "DefinitionBox",
   CellTags->"nlug:3.1.2",
   CellID->6718],
  Cell[31208, 1036, 96, 2, 70, "Caption",
   CellTags->"nlug:3.1.2",
   CellID->25038],
  Cell[31341, 1043, 108, 2, 70, "Subsection",
   CellTags->"nlug:3.1.2",
   CellID->9289],
  Cell[31452, 1047, 1431, 34, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->2690],
  Cell[32886, 1083, 1949, 52, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->9033],
  Cell[34838, 1137, 1798, 51, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->14672],
  Cell[36639, 1190, 712, 17, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->19989],
  Cell[37354, 1209, 148, 6, 70, "Program",
   CellTags->"nlug:3.1.2",
   CellID->25453],
  Cell[37505, 1217, 559, 20, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->24544],
  Cell[38067, 1239, 310, 10, 70, "Text",
   CellTags->"nlug:3.1.2",
   CellID->20165],
  Cell[38380, 1251, 824, 25, 70, "DefinitionBox",
   CellTags->"nlug:3.1.2",
   CellID->18503],
  Cell[39207, 1278, 226, 9, 70, "Caption",
   CellTags->"nlug:3.1.2",
   CellID->28770]},
 "Loading .NET Assemblies"->{
  Cell[10277, 372, 107, 2, 70, "Subsection",
   CellTags->{"Loading .NET Assemblies", "nlug:3.1.2"},
   CellID->20646]},
 "Conversion of Types Between .NET and Mathematica"->{
  Cell[39482, 1293, 223, 8, 70, "Section",
   CellTags->{
    "Conversion of Types Between .NET and Mathematica", "nlug:3.1.3"},
   CellID->31571]},
 "nlug:3.1.3"->{
  Cell[39482, 1293, 223, 8, 70, "Section",
   CellTags->{
    "Conversion of Types Between .NET and Mathematica", "nlug:3.1.3"},
   CellID->31571],
  Cell[39708, 1303, 1193, 36, 70, "Text",
   CellTags->"nlug:3.1.3",
   CellID->15060],
  Cell[40904, 1341, 469, 14, 70, "Text",
   CellTags->"nlug:3.1.3",
   CellID->12104],
  Cell[41376, 1357, 1732, 57, 70, "DefinitionBox",
   CellTags->"nlug:3.1.3",
   CellID->1716],
  Cell[43111, 1416, 162, 7, 70, "Caption",
   CellTags->"nlug:3.1.3",
   CellID->14597],
  Cell[43276, 1425, 598, 19, 70, "Text",
   CellTags->"nlug:3.1.3",
   CellID->13188]},
 "nlug:3.1.4"->{
  Cell[43911, 1449, 75, 2, 70, "Section",
   CellTags->"nlug:3.1.4",
   CellID->7716],
  Cell[43989, 1453, 972, 26, 70, "Text",
   CellTags->"nlug:3.1.4",
   CellID->25756],
  Cell[44964, 1481, 878, 27, 70, "DefinitionBox",
   CellTags->"nlug:3.1.4",
   CellID->28],
  Cell[45845, 1510, 85, 2, 70, "Caption",
   CellTags->"nlug:3.1.4",
   CellID->6929],
  Cell[45933, 1514, 138, 6, 70, "Text",
   CellTags->"nlug:3.1.4",
   CellID->4930],
  Cell[46096, 1524, 184, 6, 70, "Input",
   CellTags->"nlug:3.1.4",
   CellID->23346],
  Cell[46283, 1532, 279, 9, 70, "Output",
   CellTags->"nlug:3.1.4",
   CellID->3787],
  Cell[46577, 1544, 956, 25, 70, "Text",
   CellTags->"nlug:3.1.4",
   CellID->15094],
  Cell[47536, 1571, 1034, 28, 70, "Text",
   CellTags->"nlug:3.1.4",
   CellID->26114],
  Cell[48573, 1601, 609, 16, 70, "Text",
   CellTags->"nlug:3.1.4",
   CellID->2278],
  Cell[49185, 1619, 309, 10, 70, "Input",
   CellTags->"nlug:3.1.4",
   CellID->23568],
  Cell[49497, 1631, 673, 20, 70, "Text",
   CellTags->"nlug:3.1.4",
   CellID->30533]},
 "nlug:3.1.5"->{
  Cell[50207, 1656, 98, 2, 70, "Section",
   CellTags->"nlug:3.1.5",
   CellID->9847],
  Cell[50330, 1662, 69, 2, 70, "Subsection",
   CellTags->"nlug:3.1.5",
   CellID->31622],
  Cell[50402, 1666, 829, 20, 70, "Text",
   CellTags->"nlug:3.1.5",
   CellID->13925],
  Cell[51234, 1688, 672, 17, 70, "Text",
   CellTags->"nlug:3.1.5",
   CellID->10002],
  Cell[51909, 1707, 2107, 74, 70, "DefinitionBox",
   CellTags->"nlug:3.1.5",
   CellID->17120],
  Cell[54019, 1783, 155, 7, 70, "Caption",
   CellTags->"nlug:3.1.5",
   CellID->28899],
  Cell[54177, 1792, 653, 20, 70, "Text",
   CellTags->"nlug:3.1.5",
   CellID->16834],
  Cell[54833, 1814, 395, 13, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.1.5",
   CellID->24804],
  Cell[55231, 1829, 259, 8, 70, "Text",
   CellTags->"nlug:3.1.5",
   CellID->9969],
  Cell[55493, 1839, 404, 12, 70, "Text",
   CellTags->"nlug:3.1.5",
   CellID->8283],
  Cell[55900, 1853, 1197, 34, 70, "Text",
   CellTags->"nlug:3.1.5",
   CellID->28568],
  Cell[57122, 1891, 174, 5, 70, "Input",
   CellTags->"nlug:3.1.5",
   CellID->13538],
  Cell[57299, 1898, 266, 9, 70, "Output",
   CellTags->"nlug:3.1.5",
   CellID->23474],
  Cell[57580, 1910, 458, 17, 70, "Text",
   CellTags->"nlug:3.1.5",
   CellID->5156],
  Cell[58041, 1929, 160, 5, 70, "Input",
   CellTags->"nlug:3.1.5",
   CellID->29017],
  Cell[58204, 1936, 211, 8, 70, "Text",
   CellTags->"nlug:3.1.5",
   CellID->24200],
  Cell[58418, 1946, 179, 7, 70, "Input",
   CellTags->"nlug:3.1.5",
   CellID->32579],
  Cell[58600, 1955, 784, 22, 70, "Text",
   CellTags->"nlug:3.1.5",
   CellID->16432],
  Cell[59387, 1979, 898, 20, 70, "Text",
   CellTags->"nlug:3.1.5",
   CellID->16448],
  Cell[60288, 2001, 225, 7, 70, "Input",
   CellTags->"nlug:3.1.5",
   CellID->13047],
  Cell[60516, 2010, 846, 21, 70, "Text",
   CellTags->"nlug:3.1.5",
   CellID->4044],
  Cell[61365, 2033, 148, 5, 70, "Input",
   CellTags->"nlug:3.1.5",
   CellID->29009],
  Cell[61550, 2043, 88, 2, 70, "Subsection",
   CellTags->"nlug:3.1.5",
   CellID->24546],
  Cell[61641, 2047, 667, 15, 70, "Text",
   CellTags->"nlug:3.1.5",
   CellID->10556],
  Cell[62311, 2064, 237, 7, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.1.5",
   CellID->25270],
  Cell[62551, 2073, 201, 5, 70, "Text",
   CellTags->"nlug:3.1.5",
   CellID->14241],
  Cell[62755, 2080, 149, 5, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.1.5",
   CellID->12039],
  Cell[62907, 2087, 243, 7, 70, "Text",
   CellTags->"nlug:3.1.5",
   CellID->14293],
  Cell[63153, 2096, 147, 5, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.1.5",
   CellID->7196]},
 "nlug:3.1.6"->{
  Cell[63349, 2107, 103, 2, 70, "Section",
   CellTags->"nlug:3.1.6",
   CellID->25375],
  Cell[63477, 2113, 72, 2, 70, "Subsection",
   CellTags->"nlug:3.1.6",
   CellID->667],
  Cell[63552, 2117, 462, 13, 70, "Text",
   CellTags->"nlug:3.1.6",
   CellID->25392],
  Cell[64017, 2132, 1606, 50, 70, "DefinitionBox",
   CellTags->"nlug:3.1.6",
   CellID->12032],
  Cell[65626, 2184, 104, 2, 70, "Caption",
   CellTags->"nlug:3.1.6",
   CellID->17108],
  Cell[65733, 2188, 258, 8, 70, "Text",
   CellTags->"nlug:3.1.6",
   CellID->8641],
  Cell[65994, 2198, 161, 6, 70, "Text",
   CellTags->"nlug:3.1.6",
   CellID->29998],
  Cell[66158, 2206, 141, 4, 70, "Input",
   CellTags->"nlug:3.1.6",
   CellID->11258],
  Cell[66302, 2212, 653, 22, 70, "Text",
   CellTags->"nlug:3.1.6",
   CellID->12113],
  Cell[66958, 2236, 244, 7, 70, "Input",
   CellTags->"nlug:3.1.6",
   CellID->15693],
  Cell[67205, 2245, 132, 4, 70, "Text",
   CellTags->"nlug:3.1.6",
   CellID->24001],
  Cell[67340, 2251, 206, 6, 70, "Input",
   CellTags->"nlug:3.1.6",
   CellID->9687],
  Cell[67549, 2259, 244, 7, 70, "Text",
   CellTags->"nlug:3.1.6",
   CellID->30516],
  Cell[67796, 2268, 225, 6, 70, "Input",
   CellTags->"nlug:3.1.6",
   CellID->21618],
  Cell[68024, 2276, 1032, 30, 70, "DefinitionBox3Col",
   CellTags->"nlug:3.1.6",
   CellID->7718],
  Cell[69059, 2308, 125, 6, 70, "Caption",
   CellTags->"nlug:3.1.6",
   CellID->23668],
  Cell[69187, 2316, 894, 25, 70, "Text",
   CellTags->"nlug:3.1.6",
   CellID->20536],
  Cell[70084, 2343, 167, 5, 70, "Input",
   CellTags->"nlug:3.1.6",
   CellID->9747],
  Cell[70254, 2350, 768, 26, 70, "Text",
   CellTags->"nlug:3.1.6",
   CellID->6523],
  Cell[71025, 2378, 295, 8, 70, "Input",
   CellTags->"nlug:3.1.6",
   CellID->1797],
  Cell[71357, 2391, 85, 2, 70, "Subsection",
   CellTags->"nlug:3.1.6",
   CellID->13073],
  Cell[71445, 2395, 1985, 68, 70, "DefinitionBox",
   CellTags->"nlug:3.1.6",
   CellID->11552],
  Cell[73433, 2465, 101, 2, 70, "Caption",
   CellTags->"nlug:3.1.6",
   CellID->28615],
  Cell[73537, 2469, 351, 9, 70, "Text",
   CellTags->"nlug:3.1.6",
   CellID->21256],
  Cell[73891, 2480, 102, 3, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.1.6",
   CellID->11928],
  Cell[73996, 2485, 1970, 62, 70, "Text",
   CellTags->"nlug:3.1.6",
   CellID->14115],
  Cell[75991, 2551, 184, 6, 70, "Input",
   CellTags->"nlug:3.1.6",
   CellID->2619],
  Cell[76178, 2559, 174, 5, 70, "Output",
   CellTags->"nlug:3.1.6",
   CellID->20343],
  Cell[76389, 2569, 165, 5, 70, "Input",
   CellTags->"nlug:3.1.6",
   CellID->30248],
  Cell[76557, 2576, 279, 9, 70, "Output",
   CellTags->"nlug:3.1.6",
   CellID->18710],
  Cell[76851, 2588, 810, 29, 70, "Text",
   CellTags->"nlug:3.1.6",
   CellID->15544],
  Cell[77664, 2619, 223, 8, 70, "Text",
   CellTags->"nlug:3.1.6",
   CellID->6210],
  Cell[77912, 2631, 130, 4, 70, "Input",
   CellTags->"nlug:3.1.6",
   CellID->302071484],
  Cell[78045, 2637, 118, 3, 70, "Output",
   CellTags->"nlug:3.1.6",
   CellID->18040],
  Cell[78200, 2645, 131, 4, 70, "Input",
   CellTags->"nlug:3.1.6",
   CellID->8337],
  Cell[78334, 2651, 95, 3, 70, "Output",
   CellTags->"nlug:3.1.6",
   CellID->22012]},
 "nlug:3.2.0"->{
  Cell[78490, 2661, 98, 2, 70, "Section",
   CellTags->"nlug:3.2.0",
   CellID->14400],
  Cell[78613, 2667, 146, 6, 70, "Subsection",
   CellTags->"nlug:3.2.0",
   CellID->861],
  Cell[78762, 2675, 1200, 34, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->13463],
  Cell[79965, 2711, 1349, 39, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->17255],
  Cell[81317, 2752, 789, 29, 70, "DefinitionBox",
   CellTags->"nlug:3.2.0",
   CellID->24814],
  Cell[82109, 2783, 134, 6, 70, "Caption",
   CellTags->"nlug:3.2.0",
   CellID->22050],
  Cell[82246, 2791, 76, 2, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->18968],
  Cell[82347, 2797, 227, 7, 70, "Input",
   CellTags->"nlug:3.2.0",
   CellID->31926],
  Cell[82577, 2806, 266, 9, 70, "Output",
   CellTags->"nlug:3.2.0",
   CellID->24017],
  Cell[82858, 2818, 239, 8, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->8785],
  Cell[83100, 2828, 302, 10, 70, "Input",
   CellTags->"nlug:3.2.0",
   CellID->25932],
  Cell[83405, 2840, 202, 6, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->21270],
  Cell[83610, 2848, 166, 6, 70, "Input",
   CellTags->"nlug:3.2.0",
   CellID->27894],
  Cell[83779, 2856, 704, 21, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->8012],
  Cell[84508, 2881, 146, 5, 70, "Input",
   CellTags->"nlug:3.2.0",
   CellID->19292],
  Cell[84657, 2888, 96, 3, 70, "Output",
   CellTags->"nlug:3.2.0",
   CellID->29984],
  Cell[84768, 2894, 606, 22, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->18536],
  Cell[85399, 2920, 182, 6, 70, "Input",
   CellTags->"nlug:3.2.0",
   CellID->3461],
  Cell[85584, 2928, 95, 3, 70, "Output",
   CellTags->"nlug:3.2.0",
   CellID->12102],
  Cell[85694, 2934, 426, 12, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->11499],
  Cell[86145, 2950, 178, 6, 70, "Input",
   CellTags->"nlug:3.2.0",
   CellID->10417],
  Cell[86326, 2958, 95, 3, 70, "Output",
   CellTags->"nlug:3.2.0",
   CellID->16109],
  Cell[86436, 2964, 672, 18, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->26752],
  Cell[87133, 2986, 193, 6, 70, "Input",
   CellTags->"nlug:3.2.0",
   CellID->19490],
  Cell[87329, 2994, 95, 3, 70, "Output",
   CellTags->"nlug:3.2.0",
   CellID->20638],
  Cell[87439, 3000, 345, 12, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->944],
  Cell[87787, 3014, 1102, 31, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->31966],
  Cell[88926, 3050, 78, 2, 70, "Subsection",
   CellTags->"nlug:3.2.0",
   CellID->7770],
  Cell[89007, 3054, 1881, 49, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->1603],
  Cell[90913, 3107, 183, 6, 70, "Input",
   CellTags->"nlug:3.2.0",
   CellID->20255],
  Cell[91099, 3115, 278, 9, 70, "Output",
   CellTags->"nlug:3.2.0",
   CellID->437],
  Cell[91392, 3127, 189, 7, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->21922],
  Cell[91584, 3136, 135, 4, 70, "Input",
   CellTags->"nlug:3.2.0",
   CellID->7487],
  Cell[91722, 3142, 346, 10, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->10477],
  Cell[92093, 3156, 118, 4, 70, "Input",
   CellTags->"nlug:3.2.0",
   CellID->6209],
  Cell[92214, 3162, 223, 8, 70, "Output",
   CellTags->"nlug:3.2.0",
   CellID->9563],
  Cell[92452, 3173, 2029, 68, 70, "DefinitionBox",
   CellTags->"nlug:3.2.0",
   CellID->30273],
  Cell[94484, 3243, 88, 2, 70, "Caption",
   CellTags->"nlug:3.2.0",
   CellID->16031],
  Cell[94575, 3247, 688, 19, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->2372],
  Cell[95266, 3268, 766, 23, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->32586],
  Cell[96035, 3293, 271, 9, 70, "Input",
   CellTags->"nlug:3.2.0",
   CellID->6091],
  Cell[96309, 3304, 596, 21, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->10558],
  Cell[96908, 3327, 753, 18, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->17392],
  Cell[97698, 3350, 70, 2, 70, "Subsection",
   CellTags->"nlug:3.2.0",
   CellID->9963],
  Cell[97771, 3354, 634, 16, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->17462],
  Cell[98408, 3372, 1848, 53, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->15183],
  Cell[100259, 3427, 853, 21, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->17415],
  Cell[101115, 3450, 959, 24, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->3848],
  Cell[102077, 3476, 283, 11, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->12535],
  Cell[102363, 3489, 228, 10, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->27397],
  Cell[102594, 3501, 447, 11, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.0",
   CellID->9025],
  Cell[103044, 3514, 492, 14, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->13707],
  Cell[103539, 3530, 885, 24, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.0",
   CellID->17184],
  Cell[104427, 3556, 2185, 64, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->11444],
  Cell[106615, 3622, 959, 31, 70, "DefinitionBox",
   CellTags->"nlug:3.2.0",
   CellID->23022],
  Cell[107577, 3655, 144, 6, 70, "Caption",
   CellTags->"nlug:3.2.0",
   CellID->29073],
  Cell[107724, 3663, 312, 9, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->29994],
  Cell[108039, 3674, 396, 15, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.0",
   CellID->20873],
  Cell[108438, 3691, 2121, 62, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->29404],
  Cell[110596, 3758, 79, 2, 70, "Subsection",
   CellTags->"nlug:3.2.0",
   CellID->26559],
  Cell[110678, 3762, 1672, 48, 70, "Text",
   CellTags->"nlug:3.2.0",
   CellID->18929]},
 "Enums"->{
  Cell[112399, 3816, 76, 2, 70, "Section",
   CellTags->{"Enums", "nlug:3.2.1"},
   CellID->27357]},
 "nlug:3.2.1"->{
  Cell[112399, 3816, 76, 2, 70, "Section",
   CellTags->{"Enums", "nlug:3.2.1"},
   CellID->27357],
  Cell[112478, 3820, 858, 20, 70, "Text",
   CellTags->"nlug:3.2.1",
   CellID->32532],
  Cell[113339, 3842, 588, 17, 70, "Text",
   CellTags->"nlug:3.2.1",
   CellID->16703],
  Cell[113952, 3863, 172, 5, 70, "Input",
   CellTags->"nlug:3.2.1",
   CellID->11962],
  Cell[114127, 3870, 192, 6, 70, "Output",
   CellTags->"nlug:3.2.1",
   CellID->30982],
  Cell[114334, 3879, 132, 4, 70, "Text",
   CellTags->"nlug:3.2.1",
   CellID->5596],
  Cell[114491, 3887, 107, 3, 70, "Input",
   CellTags->"nlug:3.2.1",
   CellID->28759],
  Cell[114601, 3892, 291, 10, 70, "Output",
   CellTags->"nlug:3.2.1",
   CellID->8541],
  Cell[114907, 3905, 525, 15, 70, "Text",
   CellTags->"nlug:3.2.1",
   CellID->4761],
  Cell[115457, 3924, 153, 4, 70, "Input",
   CellTags->"nlug:3.2.1",
   CellID->8425],
  Cell[115613, 3930, 97, 3, 70, "Output",
   CellTags->"nlug:3.2.1",
   CellID->117436566],
  Cell[115725, 3936, 84, 2, 70, "Text",
   CellTags->"nlug:3.2.1",
   CellID->23415],
  Cell[115812, 3940, 179, 7, 70, "Input",
   CellTags->"nlug:3.2.1",
   CellID->8752],
  Cell[115994, 3949, 303, 7, 70, "Text",
   CellTags->"nlug:3.2.1",
   CellID->14524],
  Cell[116300, 3958, 163, 6, 70, "Input",
   CellTags->"nlug:3.2.1",
   CellID->10018],
  Cell[116466, 3966, 441, 12, 70, "Text",
   CellTags->"nlug:3.2.1",
   CellID->12093],
  Cell[116910, 3980, 128, 5, 70, "Program",
   CellTags->"nlug:3.2.1",
   CellID->8374],
  Cell[117041, 3987, 519, 17, 70, "Text",
   CellTags->"nlug:3.2.1",
   CellID->25569],
  Cell[117563, 4006, 359, 11, 70, "Input",
   CellTags->"nlug:3.2.1",
   CellID->29899]},
 "Out and Ref Parameters"->{
  Cell[117959, 4022, 318, 11, 70, "Section",
   CellTags->{"Out and Ref Parameters", "nlug:3.2.2"},
   CellID->15993]},
 "nlug:3.2.2"->{
  Cell[117959, 4022, 318, 11, 70, "Section",
   CellTags->{"Out and Ref Parameters", "nlug:3.2.2"},
   CellID->15993],
  Cell[118280, 4035, 1200, 32, 70, "Text",
   CellTags->"nlug:3.2.2",
   CellID->13947],
  Cell[119483, 4069, 199, 8, 70, "Text",
   CellTags->"nlug:3.2.2",
   CellID->6361],
  Cell[119685, 4079, 247, 9, 70, "Program",
   CellTags->"nlug:3.2.2",
   CellID->28928],
  Cell[119935, 4090, 860, 24, 70, "Text",
   CellTags->"nlug:3.2.2",
   CellID->3959],
  Cell[120798, 4116, 563, 16, 70, "Text",
   CellTags->"nlug:3.2.2",
   CellID->4415],
  Cell[121364, 4134, 166, 5, 70, "Text",
   CellTags->"nlug:3.2.2",
   CellID->16016],
  Cell[121555, 4143, 309, 9, 70, "Input",
   CellTags->"nlug:3.2.2",
   CellID->15],
  Cell[121867, 4154, 94, 3, 70, "Output",
   CellTags->"nlug:3.2.2",
   CellID->31466],
  Cell[121976, 4160, 237, 7, 70, "Text",
   CellTags->"nlug:3.2.2",
   CellID->14662],
  Cell[122238, 4171, 94, 3, 70, "Input",
   CellTags->"nlug:3.2.2",
   CellID->27292],
  Cell[122335, 4176, 93, 3, 70, "Output",
   CellTags->"nlug:3.2.2",
   CellID->26058],
  Cell[122443, 4182, 218, 7, 70, "Text",
   CellTags->"nlug:3.2.2",
   CellID->2398],
  Cell[122686, 4193, 238, 7, 70, "Input",
   CellTags->"nlug:3.2.2",
   CellID->22331],
  Cell[122927, 4202, 244, 7, 70, "Message",
   CellTags->"nlug:3.2.2",
   CellID->7179],
  Cell[123174, 4211, 99, 3, 70, "Output",
   CellTags->"nlug:3.2.2",
   CellID->31188],
  Cell[123288, 4217, 600, 16, 70, "Text",
   CellTags->"nlug:3.2.2",
   CellID->30073],
  Cell[123891, 4235, 405, 12, 70, "Text",
   CellTags->"nlug:3.2.2",
   CellID->13946],
  Cell[124321, 4251, 172, 5, 70, "Input",
   CellTags->"nlug:3.2.2",
   CellID->16089],
  Cell[124496, 4258, 94, 3, 70, "Output",
   CellTags->"nlug:3.2.2",
   CellID->19980]},
 "nlug:3.2.3"->{
  Cell[124639, 4267, 290, 10, 70, "Section",
   CellTags->"nlug:3.2.3",
   CellID->18481],
  Cell[124954, 4281, 84, 2, 70, "Subsection",
   CellTags->"nlug:3.2.3",
   CellID->16500],
  Cell[125041, 4285, 1602, 52, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->18880],
  Cell[126646, 4339, 911, 21, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->9487],
  Cell[127560, 4362, 527, 14, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->1341],
  Cell[128090, 4378, 762, 24, 70, "DefinitionBox",
   CellTags->"nlug:3.2.3",
   CellID->18261],
  Cell[128855, 4404, 302, 11, 70, "Caption",
   CellTags->"nlug:3.2.3",
   CellID->28241],
  Cell[129194, 4420, 80, 2, 70, "Subsection",
   CellTags->"nlug:3.2.3",
   CellID->12798],
  Cell[129277, 4424, 578, 15, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->31689],
  Cell[129880, 4443, 391, 12, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.3",
   CellID->25573],
  Cell[130274, 4457, 180, 6, 70, "Output",
   CellTags->"nlug:3.2.3",
   CellID->3908],
  Cell[130469, 4466, 473, 16, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->1409],
  Cell[130967, 4486, 278, 10, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.3",
   CellID->3950],
  Cell[131248, 4498, 194, 7, 70, "Output",
   CellTags->"nlug:3.2.3",
   CellID->27308],
  Cell[131457, 4508, 1221, 32, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->28941],
  Cell[132681, 4542, 401, 11, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->19467],
  Cell[133107, 4557, 286, 10, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.3",
   CellID->3425],
  Cell[133396, 4569, 267, 8, 70, "Output",
   CellTags->"nlug:3.2.3",
   CellID->15450],
  Cell[133678, 4580, 263, 9, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->22704],
  Cell[133966, 4593, 327, 11, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.3",
   CellID->16736],
  Cell[134296, 4606, 194, 7, 70, "Output",
   CellTags->"nlug:3.2.3",
   CellID->25067],
  Cell[134505, 4616, 562, 17, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->30054],
  Cell[135070, 4635, 1071, 27, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->3285],
  Cell[136178, 4667, 84, 2, 70, "Subsection",
   CellTags->"nlug:3.2.3",
   CellID->32085],
  Cell[136265, 4671, 729, 20, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->16921],
  Cell[136997, 4693, 1358, 37, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->16628],
  Cell[138380, 4734, 238, 7, 70, "Input",
   CellTags->"nlug:3.2.3",
   CellID->27935],
  Cell[138621, 4743, 270, 8, 70, "Output",
   CellTags->"nlug:3.2.3",
   CellID->32215],
  Cell[138906, 4754, 173, 7, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->7604],
  Cell[139104, 4765, 138, 4, 70, "Input",
   CellTags->"nlug:3.2.3",
   CellID->21244],
  Cell[139245, 4771, 101, 3, 70, "Output",
   CellTags->"nlug:3.2.3",
   CellID->5050],
  Cell[139361, 4777, 663, 21, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->4655],
  Cell[140027, 4800, 1115, 31, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->28019],
  Cell[141145, 4833, 90, 2, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->19881],
  Cell[141260, 4839, 192, 6, 70, "Input",
   CellTags->"nlug:3.2.3",
   CellID->13619],
  Cell[141455, 4847, 282, 9, 70, "Output",
   CellTags->"nlug:3.2.3",
   CellID->2948],
  Cell[141752, 4859, 85, 2, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->12656],
  Cell[141840, 4863, 256, 9, 70, "Input",
   CellTags->"nlug:3.2.3",
   CellID->5631],
  Cell[142099, 4874, 269, 9, 70, "Text",
   CellTags->"nlug:3.2.3",
   CellID->12941],
  Cell[142393, 4887, 146, 4, 70, "Input",
   CellTags->"nlug:3.2.3",
   CellID->22178],
  Cell[142542, 4893, 225, 7, 70, "Output",
   CellTags->"nlug:3.2.3",
   CellID->13273]},
 "Overloaded Operators"->{
  Cell[142828, 4907, 106, 2, 70, "Section",
   CellTags->{"Overloaded Operators", "nlug:3.2.4"},
   CellID->18254]},
 "nlug:3.2.4"->{
  Cell[142828, 4907, 106, 2, 70, "Section",
   CellTags->{"Overloaded Operators", "nlug:3.2.4"},
   CellID->18254],
  Cell[142937, 4911, 660, 17, 70, "Text",
   CellTags->"nlug:3.2.4",
   CellID->618],
  Cell[143600, 4930, 238, 7, 70, "Program",
   CellTags->"nlug:3.2.4",
   CellID->16800],
  Cell[143841, 4939, 468, 11, 70, "Text",
   CellTags->"nlug:3.2.4",
   CellID->4429],
  Cell[144312, 4952, 398, 14, 70, "Text",
   CellTags->"nlug:3.2.4",
   CellID->7561],
  Cell[144735, 4970, 578, 19, 70, "Input",
   CellTags->"nlug:3.2.4",
   CellID->23932],
  Cell[145316, 4991, 108, 3, 70, "Output",
   CellTags->"nlug:3.2.4",
   CellID->11358],
  Cell[145439, 4997, 879, 22, 70, "Text",
   CellTags->"nlug:3.2.4",
   CellID->7546],
  Cell[146343, 5023, 137, 3, 70, "Input",
   CellTags->"nlug:3.2.4",
   CellID->21260],
  Cell[146483, 5028, 2084, 57, 70, "Output",
   CellTags->"nlug:3.2.4",
   CellID->28943],
  Cell[148582, 5088, 536, 17, 70, "Text",
   CellTags->"nlug:3.2.4",
   CellID->3723],
  Cell[149143, 5109, 217, 7, 70, "Input",
   CellTags->"nlug:3.2.4",
   CellID->29817],
  Cell[149363, 5118, 108, 3, 70, "Output",
   CellTags->"nlug:3.2.4",
   CellID->22712]},
 "Casting"->{
  Cell[149520, 5127, 80, 2, 70, "Section",
   CellTags->{"Casting", "nlug:3.2.5"},
   CellID->16712]},
 "nlug:3.2.5"->{
  Cell[149520, 5127, 80, 2, 70, "Section",
   CellTags->{"Casting", "nlug:3.2.5"},
   CellID->16712],
  Cell[149625, 5133, 75, 2, 70, "Subsection",
   CellTags->"nlug:3.2.5",
   CellID->20880],
  Cell[149703, 5137, 916, 20, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->12526],
  Cell[150622, 5159, 179, 8, 70, "Program",
   CellTags->"nlug:3.2.5",
   CellID->28959],
  Cell[150804, 5169, 787, 23, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->10460],
  Cell[151594, 5194, 274, 15, 70, "Program",
   CellTags->"nlug:3.2.5",
   CellID->7977],
  Cell[151871, 5211, 330, 11, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->4200],
  Cell[152204, 5224, 493, 14, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->31274],
  Cell[152700, 5240, 1735, 48, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->5783],
  Cell[154438, 5290, 717, 19, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->15781],
  Cell[155158, 5311, 709, 20, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->30506],
  Cell[155870, 5333, 122, 3, 70, "BulletedText",
   CellTags->"nlug:3.2.5",
   CellID->4987],
  Cell[155995, 5338, 199, 5, 70, "BulletedText",
   CellTags->"nlug:3.2.5",
   CellID->522560435],
  Cell[156219, 5347, 146, 4, 70, "BulletedText",
   CellTags->"nlug:3.2.5",
   CellID->803030715],
  Cell[156368, 5353, 535, 11, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->9501],
  Cell[156906, 5366, 979, 23, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->14568],
  Cell[157888, 5391, 923, 30, 70, "DefinitionBox",
   CellTags->"nlug:3.2.5",
   CellID->28192],
  Cell[158814, 5423, 148, 6, 70, "Caption",
   CellTags->"nlug:3.2.5",
   CellID->23714],
  Cell[158965, 5431, 302, 12, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->1741],
  Cell[159316, 5449, 104, 2, 70, "Subsection",
   CellTags->"nlug:3.2.5",
   CellID->1705],
  Cell[159423, 5453, 353, 9, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->11694],
  Cell[159779, 5464, 237, 11, 70, "Program",
   CellTags->"nlug:3.2.5",
   CellID->8130],
  Cell[160019, 5477, 487, 16, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->373435199],
  Cell[160509, 5495, 239, 7, 70, "Program",
   CellTags->"nlug:3.2.5",
   CellID->7614],
  Cell[160751, 5504, 564, 17, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->26598],
  Cell[161318, 5523, 564, 20, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->17139],
  Cell[161907, 5547, 183, 6, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.5",
   CellID->29546],
  Cell[162093, 5555, 261, 8, 70, "Output",
   CellTags->"nlug:3.2.5",
   CellID->4762],
  Cell[162391, 5568, 222, 7, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.5",
   CellID->767],
  Cell[162616, 5577, 263, 8, 70, "Output",
   CellTags->"nlug:3.2.5",
   CellID->26854],
  Cell[162916, 5590, 168, 6, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.5",
   CellID->28448],
  Cell[163087, 5598, 122, 4, 70, "Output",
   CellTags->"nlug:3.2.5",
   CellID->23828],
  Cell[163224, 5605, 111, 2, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->22530],
  Cell[163360, 5611, 184, 6, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.5",
   CellID->1224],
  Cell[163547, 5619, 94, 3, 70, "Output",
   CellTags->"nlug:3.2.5",
   CellID->8692],
  Cell[163690, 5628, 96, 2, 70, "Subsection",
   CellTags->"nlug:3.2.5",
   CellID->11114],
  Cell[163789, 5632, 1118, 27, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->18887],
  Cell[164910, 5661, 590, 31, 70, "Program",
   CellTags->"nlug:3.2.5",
   CellID->25960],
  Cell[165503, 5694, 505, 16, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->31114],
  Cell[166011, 5712, 216, 6, 70, "Program",
   CellTags->"nlug:3.2.5",
   CellID->26245],
  Cell[166230, 5720, 168, 7, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->18464],
  Cell[166401, 5729, 605, 18, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.5",
   CellID->31643],
  Cell[167009, 5749, 1096, 32, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->8819],
  Cell[168130, 5785, 224, 7, 70, "Input",
   CellTags->"nlug:3.2.5",
   CellID->19326],
  Cell[168357, 5794, 263, 8, 70, "Output",
   CellTags->"nlug:3.2.5",
   CellID->4948],
  Cell[168657, 5807, 152, 5, 70, "Input",
   CellTags->"nlug:3.2.5",
   CellID->3188015],
  Cell[168812, 5814, 265, 7, 70, "Message",
   CellTags->"nlug:3.2.5",
   CellID->1863],
  Cell[169080, 5823, 98, 3, 70, "Output",
   CellTags->"nlug:3.2.5",
   CellID->15970],
  Cell[169193, 5829, 144, 6, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->21455],
  Cell[169362, 5839, 246, 7, 70, "Input",
   CellTags->"nlug:3.2.5",
   CellID->23360],
  Cell[169611, 5848, 96, 3, 70, "Output",
   CellTags->"nlug:3.2.5",
   CellID->17908],
  Cell[169756, 5857, 94, 2, 70, "Subsection",
   CellTags->"nlug:3.2.5",
   CellID->14898],
  Cell[169853, 5861, 1056, 24, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->23063],
  Cell[170912, 5887, 372, 10, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->30584],
  Cell[171287, 5899, 176, 10, 70, "Program",
   CellTags->"nlug:3.2.5",
   CellID->3925],
  Cell[171466, 5911, 284, 8, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->558],
  Cell[171753, 5921, 163, 6, 70, "Program",
   CellTags->"nlug:3.2.5",
   CellID->6914],
  Cell[171941, 5931, 264, 8, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.5",
   CellID->23130],
  Cell[172208, 5941, 276, 9, 70, "Output",
   CellTags->"nlug:3.2.5",
   CellID->9479],
  Cell[172499, 5953, 310, 10, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->30803],
  Cell[172834, 5967, 140, 5, 70, "Input",
   CellTags->"nlug:3.2.5",
   CellID->15399],
  Cell[172977, 5974, 313, 9, 70, "Message",
   CellTags->"nlug:3.2.5",
   CellID->28785],
  Cell[173293, 5985, 98, 3, 70, "Output",
   CellTags->"nlug:3.2.5",
   CellID->27000],
  Cell[173406, 5991, 915, 25, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->15651],
  Cell[174324, 6018, 138, 6, 70, "Program",
   CellTags->"nlug:3.2.5",
   CellID->17554],
  Cell[174465, 6026, 427, 12, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->10980],
  Cell[174917, 6042, 297, 10, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.5",
   CellID->13888],
  Cell[175217, 6054, 93, 3, 70, "Output",
   CellTags->"nlug:3.2.5",
   CellID->31908],
  Cell[175325, 6060, 1003, 17, 70, "Text",
   CellTags->"nlug:3.2.5",
   CellID->17852]},
 "nlug:3.2.6"->{
  Cell[176377, 6083, 68, 2, 70, "Section",
   CellTags->"nlug:3.2.6",
   CellID->24524],
  Cell[176448, 6087, 492, 13, 70, "Text",
   CellTags->"nlug:3.2.6",
   CellID->18442],
  Cell[176943, 6102, 331, 18, 70, "Program",
   CellTags->"nlug:3.2.6",
   CellID->21154],
  Cell[177277, 6122, 646, 15, 70, "Text",
   CellTags->"nlug:3.2.6",
   CellID->19217],
  Cell[177926, 6139, 128, 8, 70, "Program",
   CellTags->"nlug:3.2.6",
   CellID->12940],
  Cell[178057, 6149, 210, 7, 70, "Text",
   CellTags->"nlug:3.2.6",
   CellID->32112],
  Cell[178270, 6158, 282, 9, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.6",
   CellID->32184],
  Cell[178555, 6169, 743, 21, 70, "Text",
   CellTags->"nlug:3.2.6",
   CellID->27449],
  Cell[179301, 6192, 325, 8, 70, "Text",
   CellTags->"nlug:3.2.6",
   CellID->25628],
  Cell[179651, 6204, 282, 8, 70, "Input",
   CellTags->"nlug:3.2.6",
   CellID->20463],
  Cell[179936, 6214, 282, 9, 70, "Output",
   CellTags->"nlug:3.2.6",
   CellID->30963],
  Cell[180233, 6226, 151, 5, 70, "Text",
   CellTags->"nlug:3.2.6",
   CellID->10397],
  Cell[180409, 6235, 124, 4, 70, "Input",
   CellTags->"nlug:3.2.6",
   CellID->2287],
  Cell[180536, 6241, 95, 3, 70, "Output",
   CellTags->"nlug:3.2.6",
   CellID->3000],
  Cell[180646, 6247, 784, 20, 70, "Text",
   CellTags->"nlug:3.2.6",
   CellID->786],
  Cell[181455, 6271, 150, 5, 70, "Input",
   CellTags->"nlug:3.2.6",
   CellID->7443],
  Cell[181608, 6278, 95, 3, 70, "Output",
   CellTags->"nlug:3.2.6",
   CellID->4438]},
 "Exceptions"->{
  Cell[181752, 6287, 85, 2, 70, "Section",
   CellTags->{"Exceptions", "nlug:3.2.7"},
   CellID->4946]},
 "nlug:3.2.7"->{
  Cell[181752, 6287, 85, 2, 70, "Section",
   CellTags->{"Exceptions", "nlug:3.2.7"},
   CellID->4946],
  Cell[181862, 6293, 89, 2, 70, "Subsection",
   CellTags->"nlug:3.2.7",
   CellID->11921],
  Cell[181954, 6297, 373, 10, 70, "Text",
   CellTags->"nlug:3.2.7",
   CellID->21680],
  Cell[182352, 6311, 229, 6, 70, "Input",
   CellTags->"nlug:3.2.7",
   CellID->14636],
  Cell[182584, 6319, 491, 10, 70, "Message",
   CellTags->"nlug:3.2.7",
   CellID->3036],
  Cell[183078, 6331, 99, 3, 70, "Output",
   CellTags->"nlug:3.2.7",
   CellID->17745],
  Cell[183192, 6337, 253, 9, 70, "Text",
   CellTags->"nlug:3.2.7",
   CellID->11925],
  Cell[183448, 6348, 361, 9, 70, "Text",
   CellTags->"nlug:3.2.7",
   CellID->29523],
  Cell[183846, 6362, 77, 2, 70, "Subsection",
   CellTags->"nlug:3.2.7",
   CellID->7976],
  Cell[183926, 6366, 1111, 29, 70, "Text",
   CellTags->"nlug:3.2.7",
   CellID->31342],
  Cell[185062, 6399, 152, 5, 70, "Input",
   CellTags->"nlug:3.2.7",
   CellID->9599],
  Cell[185217, 6406, 300, 10, 70, "Output",
   CellTags->"nlug:3.2.7",
   CellID->8724],
  Cell[185532, 6419, 179, 6, 70, "Text",
   CellTags->"nlug:3.2.7",
   CellID->21929],
  Cell[185736, 6429, 158, 5, 70, "Input",
   CellTags->"nlug:3.2.7",
   CellID->5851],
  Cell[185897, 6436, 303, 10, 70, "Output",
   CellTags->"nlug:3.2.7",
   CellID->30628],
  Cell[186215, 6449, 263, 6, 70, "Text",
   CellTags->"nlug:3.2.7",
   CellID->32667],
  Cell[186503, 6459, 134, 4, 70, "Input",
   CellTags->"nlug:3.2.7",
   CellID->25198],
  Cell[186640, 6465, 276, 9, 70, "Output",
   CellTags->"nlug:3.2.7",
   CellID->7357],
  Cell[186965, 6480, 87, 2, 70, "Subsection",
   CellTags->"nlug:3.2.7",
   CellID->3241],
  Cell[187055, 6484, 780, 23, 70, "Text",
   CellTags->"nlug:3.2.7",
   CellID->19150],
  Cell[187838, 6509, 868, 22, 70, "Text",
   CellTags->"nlug:3.2.7",
   CellID->26452],
  Cell[188709, 6533, 528, 16, 70, "Text",
   CellTags->"nlug:3.2.7",
   CellID->19149],
  Cell[189240, 6551, 316, 9, 70, "Input",
   CellTags->"nlug:3.2.7",
   CellID->31600],
  Cell[189559, 6562, 340, 10, 70, "Text",
   CellTags->"nlug:3.2.7",
   CellID->1491],
  Cell[189902, 6574, 207, 8, 70, "Input",
   CellTags->"nlug:3.2.7",
   CellID->18811],
  Cell[190112, 6584, 616, 17, 70, "Text",
   CellTags->"nlug:3.2.7",
   CellID->28414]},
 "nlug:3.2.8"->{
  Cell[190777, 6607, 72, 2, 70, "Section",
   CellTags->"nlug:3.2.8",
   CellID->25949],
  Cell[190852, 6611, 161, 5, 70, "Text",
   CellTags->"nlug:3.2.8",
   CellID->12926],
  Cell[191016, 6618, 352, 16, 70, "Program",
   CellTags->"nlug:3.2.8",
   CellID->224963599],
  Cell[191371, 6636, 525, 16, 70, "Text",
   CellTags->"nlug:3.2.8",
   CellID->21591],
  Cell[191921, 6656, 216, 7, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.8",
   CellID->12848],
  Cell[192140, 6665, 180, 5, 70, "Output",
   CellTags->"nlug:3.2.8",
   CellID->5035],
  Cell[192335, 6673, 312, 11, 70, "Text",
   CellTags->"nlug:3.2.8",
   CellID->17691],
  Cell[192672, 6688, 208, 7, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.8",
   CellID->6744],
  Cell[192883, 6697, 280, 9, 70, "Output",
   CellTags->"nlug:3.2.8",
   CellID->23658],
  Cell[193178, 6709, 403, 13, 70, "Text",
   CellTags->"nlug:3.2.8",
   CellID->5512],
  Cell[193584, 6724, 115, 5, 70, "Program",
   CellTags->"nlug:3.2.8",
   CellID->24098],
  Cell[193702, 6731, 474, 15, 70, "Text",
   CellTags->"nlug:3.2.8",
   CellID->4772],
  Cell[194179, 6748, 135, 4, 70, "Text",
   CellTags->"nlug:3.2.8",
   CellID->19355],
  Cell[194339, 6756, 150, 5, 70, "Input",
   CellTags->"nlug:3.2.8",
   CellID->22771],
  Cell[194492, 6763, 92, 3, 70, "Output",
   CellTags->"nlug:3.2.8",
   CellID->5409],
  Cell[194599, 6769, 345, 12, 70, "Text",
   CellTags->"nlug:3.2.8",
   CellID->19753],
  Cell[194969, 6785, 138, 4, 70, "Input",
   CellTags->"nlug:3.2.8",
   CellID->21448],
  Cell[195110, 6791, 92, 3, 70, "Output",
   CellTags->"nlug:3.2.8",
   CellID->5745],
  Cell[195217, 6797, 440, 9, 70, "Text",
   CellTags->"nlug:3.2.8",
   CellID->25304],
  Cell[195660, 6808, 883, 26, 70, "Text",
   CellTags->"nlug:3.2.8",
   CellID->14512],
  Cell[196546, 6836, 287, 10, 70, "Input",
   CellTags->"nlug:3.2.8",
   CellID->23916],
  Cell[196836, 6848, 363, 13, 70, "Text",
   CellTags->"nlug:3.2.8",
   CellID->13855],
  Cell[197224, 6865, 179, 5, 70, "Input",
   CellTags->"nlug:3.2.8",
   CellID->27198],
  Cell[197406, 6872, 152, 4, 70, "Output",
   CellTags->"nlug:3.2.8",
   CellID->6762],
  Cell[197573, 6879, 520, 16, 70, "Text",
   CellTags->"nlug:3.2.8",
   CellID->20157]},
 "nlug:3.2.9"->{
  Cell[198130, 6900, 73, 2, 70, "Section",
   CellTags->"nlug:3.2.9",
   CellID->17016],
  Cell[198206, 6904, 1034, 28, 70, "Text",
   CellTags->"nlug:3.2.9",
   CellID->18664],
  Cell[199265, 6936, 197, 6, 70, "Input",
   CellTags->"nlug:3.2.9",
   CellID->9859],
  Cell[199465, 6944, 264, 8, 70, "Output",
   CellTags->"nlug:3.2.9",
   CellID->22686],
  Cell[199744, 6955, 457, 15, 70, "Input",
   CellTags->"nlug:3.2.9",
   CellID->18551],
  Cell[200204, 6972, 254, 9, 70, "Text",
   CellTags->"nlug:3.2.9",
   CellID->29087],
  Cell[200483, 6985, 223, 7, 70, "Input",
   CellTags->"nlug:3.2.9",
   CellID->10872],
  Cell[200709, 6994, 264, 8, 70, "Output",
   CellTags->"nlug:3.2.9",
   CellID->18345],
  Cell[200988, 7005, 811, 25, 70, "DefinitionBox",
   CellTags->"nlug:3.2.9",
   CellID->10963],
  Cell[201802, 7032, 110, 5, 70, "Caption",
   CellTags->"nlug:3.2.9",
   CellID->23376],
  Cell[201915, 7039, 1049, 29, 70, "Text",
   CellTags->"nlug:3.2.9",
   CellID->23901],
  Cell[202967, 7070, 101, 2, 70, "Program",
   CellTags->"nlug:3.2.9",
   CellID->30813],
  Cell[203071, 7074, 497, 13, 70, "Text",
   CellTags->"nlug:3.2.9",
   CellID->28889],
  Cell[203571, 7089, 166, 5, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.9",
   CellID->25632],
  Cell[203762, 7098, 166, 5, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.9",
   CellID->2188],
  Cell[203931, 7105, 149, 5, 70, "Output",
   CellTags->"nlug:3.2.9",
   CellID->9012],
  Cell[204095, 7113, 301, 8, 70, "Text",
   CellTags->"nlug:3.2.9",
   CellID->29539],
  Cell[204399, 7123, 117, 5, 70, "Program",
   CellTags->"nlug:3.2.9",
   CellID->14990],
  Cell[204519, 7130, 809, 24, 70, "Text",
   CellTags->"nlug:3.2.9",
   CellID->13657],
  Cell[205331, 7156, 228, 7, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.9",
   CellID->11718],
  Cell[205562, 7165, 603, 17, 70, "Text",
   CellTags->"nlug:3.2.9",
   CellID->15615]},
 "nlug:3.2.10"->{
  Cell[206202, 7187, 76, 2, 70, "Section",
   CellTags->"nlug:3.2.10",
   CellID->21660],
  Cell[206281, 7191, 1042, 31, 70, "Text",
   CellTags->"nlug:3.2.10",
   CellID->27829],
  Cell[208048, 7247, 152, 5, 70, "Text",
   CellTags->"nlug:3.2.10",
   CellID->17065],
  Cell[208203, 7254, 179, 5, 70, "ItemizedText",
   CellTags->"nlug:3.2.10",
   CellID->29881],
  Cell[208407, 7263, 187, 5, 70, "ItemizedText",
   CellTags->"nlug:3.2.10",
   CellID->16474],
  Cell[208597, 7270, 997, 31, 70, "Program",
   CellTags->"nlug:3.2.10",
   CellID->19380],
  Cell[209597, 7303, 103, 2, 70, "Text",
   CellTags->"nlug:3.2.10",
   CellID->25570],
  Cell[209703, 7307, 414, 23, 70, "Program",
   CellTags->"nlug:3.2.10",
   CellID->7639],
  Cell[210120, 7332, 206, 6, 70, "Text",
   CellTags->"nlug:3.2.10",
   CellID->5352],
  Cell[210329, 7340, 310, 11, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.10",
   CellID->31641],
  Cell[210664, 7355, 230, 8, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.10",
   CellID->29644],
  Cell[210897, 7365, 279, 9, 70, "Output",
   CellTags->"nlug:3.2.10",
   CellID->5775],
  Cell[211191, 7377, 861, 28, 70, "Text",
   CellTags->"nlug:3.2.10",
   CellID->7072],
  Cell[212077, 7409, 160, 5, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.10",
   CellID->22033],
  Cell[212240, 7416, 176, 5, 70, "Output",
   CellTags->"nlug:3.2.10",
   CellID->21694],
  Cell[212431, 7424, 489, 16, 70, "Text",
   CellTags->"nlug:3.2.10",
   CellID->28141],
  Cell[212945, 7444, 165, 6, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.10",
   CellID->17709],
  Cell[213113, 7452, 175, 5, 70, "Output",
   CellTags->"nlug:3.2.10",
   CellID->28595],
  Cell[213325, 7462, 228, 8, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.10",
   CellID->21826],
  Cell[213556, 7472, 177, 5, 70, "Output",
   CellTags->"nlug:3.2.10",
   CellID->21345],
  Cell[213770, 7482, 166, 6, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.10",
   CellID->29204],
  Cell[213939, 7490, 175, 5, 70, "Output",
   CellTags->"nlug:3.2.10",
   CellID->6777],
  Cell[214129, 7498, 782, 21, 70, "Text",
   CellTags->"nlug:3.2.10",
   CellID->25789],
  Cell[214936, 7523, 180, 6, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.10",
   CellID->2250],
  Cell[215119, 7531, 175, 5, 70, "Output",
   CellTags->"nlug:3.2.10",
   CellID->27778],
  Cell[215309, 7539, 332, 10, 70, "Text",
   CellTags->"nlug:3.2.10",
   CellID->2160]},
 ".NET Console"->{
  Cell[215690, 7555, 101, 2, 70, "Section",
   CellTags->{".NET Console", "nlug:3.2.11"},
   CellID->9196]},
 "nlug:3.2.11"->{
  Cell[215690, 7555, 101, 2, 70, "Section",
   CellTags->{".NET Console", "nlug:3.2.11"},
   CellID->9196],
  Cell[215794, 7559, 1374, 39, 70, "Text",
   CellTags->"nlug:3.2.11",
   CellID->19418],
  Cell[217171, 7600, 1201, 36, 70, "DefinitionBox",
   CellTags->"nlug:3.2.11",
   CellID->9164],
  Cell[218375, 7638, 87, 2, 70, "Caption",
   CellTags->"nlug:3.2.11",
   CellID->6704],
  Cell[218487, 7644, 127, 4, 70, "Input",
   CellTags->"nlug:3.2.11",
   CellID->13318],
  Cell[218617, 7650, 292, 10, 70, "Output",
   CellTags->"nlug:3.2.11",
   CellID->18545],
  Cell[218924, 7663, 676, 19, 70, "Text",
   CellTags->"nlug:3.2.11",
   CellID->6813],
  Cell[219603, 7684, 470, 14, 70, "Text",
   CellTags->"nlug:3.2.11",
   CellID->5695],
  Cell[220076, 7700, 271, 7, 70, "Input",
   CellTags->"nlug:3.2.11",
   CellID->11154],
  Cell[220350, 7709, 311, 8, 70, "Text",
   CellTags->"nlug:3.2.11",
   CellID->30433]},
 "Distributing Applications"->{
  Cell[220698, 7722, 189, 6, 70, "Section",
   CellTags->{"Distributing Applications", "nlug:3.2.12"},
   CellID->20220]},
 "nlug:3.2.12"->{
  Cell[220698, 7722, 189, 6, 70, "Section",
   CellTags->{"Distributing Applications", "nlug:3.2.12"},
   CellID->20220],
  Cell[220890, 7730, 269, 10, 70, "Text",
   CellTags->"nlug:3.2.12",
   CellID->21891],
  Cell[221162, 7742, 672, 16, 70, "Text",
   CellTags->"nlug:3.2.12",
   CellID->15323],
  Cell[221837, 7760, 1493, 46, 70, "Text",
   CellTags->"nlug:3.2.12",
   CellID->29246],
  Cell[223333, 7808, 1141, 30, 70, "Text",
   CellTags->"nlug:3.2.12",
   CellID->19778],
  Cell[224477, 7840, 194, 7, 70, "Text",
   CellTags->"nlug:3.2.12",
   CellID->21089],
  Cell[224674, 7849, 243, 10, 70, "Program",
   CellTags->"nlug:3.2.12",
   CellID->3698],
  Cell[224920, 7861, 793, 17, 70, "Text",
   CellTags->"nlug:3.2.12",
   CellID->3616],
  Cell[225716, 7880, 324, 9, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.2.12",
   CellID->28900]},
 "nlug:3.2.13"->{
  Cell[226077, 7894, 80, 2, 70, "Section",
   CellTags->"nlug:3.2.13",
   CellID->12578],
  Cell[226160, 7898, 598, 17, 70, "Text",
   CellTags->"nlug:3.2.13",
   CellID->30959],
  Cell[226761, 7917, 865, 25, 70, "DefinitionBox",
   CellTags->"nlug:3.2.13",
   CellID->12953],
  Cell[227629, 7944, 144, 6, 70, "Caption",
   CellTags->"nlug:3.2.13",
   CellID->12059],
  Cell[227798, 7954, 119, 3, 70, "Input",
   CellTags->"nlug:3.2.13",
   CellID->26368],
  Cell[227920, 7959, 140, 3, 70, "Output",
   CellTags->"nlug:3.2.13",
   CellID->31041],
  Cell[228097, 7967, 124, 3, 70, "Input",
   CellTags->"nlug:3.2.13",
   CellID->3617],
  Cell[228224, 7972, 95, 3, 70, "Output",
   CellTags->"nlug:3.2.13",
   CellID->16460],
  Cell[228356, 7980, 124, 3, 70, "Input",
   CellTags->"nlug:3.2.13",
   CellID->7253],
  Cell[228483, 7985, 92, 3, 70, "Output",
   CellTags->"nlug:3.2.13",
   CellID->8650],
  Cell[228590, 7991, 695, 23, 70, "Text",
   CellTags->"nlug:3.2.13",
   CellID->12586]},
 "nlug:3.3.0"->{
  Cell[229406, 8024, 74, 2, 70, "Subsection",
   CellTags->"nlug:3.3.0",
   CellID->3744],
  Cell[229483, 8028, 1117, 24, 70, "Text",
   CellTags->"nlug:3.3.0",
   CellID->3217],
  Cell[230603, 8054, 565, 19, 70, "Text",
   CellTags->"nlug:3.3.0",
   CellID->26068],
  Cell[231171, 8075, 874, 32, 70, "Text",
   CellTags->"nlug:3.3.0",
   CellID->13235],
  Cell[232048, 8109, 846, 32, 70, "Text",
   CellTags->"nlug:3.3.0",
   CellID->1104],
  Cell[232897, 8143, 745, 25, 70, "Text",
   CellTags->"nlug:3.3.0",
   CellID->20032]},
 "Modal versus Modeless"->{
  Cell[233679, 8173, 121, 2, 70, "Subsection",
   CellTags->{"Modal versus Modeless", "nlug:3.3.1"},
   CellID->15816]},
 "nlug:3.3.1"->{
  Cell[233679, 8173, 121, 2, 70, "Subsection",
   CellTags->{"Modal versus Modeless", "nlug:3.3.1"},
   CellID->15816],
  Cell[233803, 8177, 701, 16, 70, "Text",
   CellTags->"nlug:3.3.1",
   CellID->876873929],
  Cell[234507, 8195, 2100, 54, 70, "Text",
   CellTags->"nlug:3.3.1",
   CellID->13197],
  Cell[236610, 8251, 855, 19, 70, "Text",
   CellTags->"nlug:3.3.1",
   CellID->2146],
  Cell[237468, 8272, 1104, 28, 70, "Text",
   CellTags->"nlug:3.3.1",
   CellID->24853],
  Cell[238575, 8302, 745, 21, 70, "Text",
   CellTags->"nlug:3.3.1",
   CellID->27223],
  Cell[239323, 8325, 716, 14, 70, "Text",
   CellTags->"nlug:3.3.1",
   CellID->2478],
  Cell[240042, 8341, 865, 19, 70, "Text",
   CellTags->"nlug:3.3.1",
   CellID->23233],
  Cell[240910, 8362, 930, 17, 70, "Text",
   CellTags->"nlug:3.3.1",
   CellID->30962],
  Cell[241843, 8381, 335, 9, 70, "Text",
   CellTags->"nlug:3.3.1",
   CellID->19990]},
 "Handling Events"->{
  Cell[242215, 8395, 99, 2, 70, "Subsection",
   CellTags->{"Handling Events", "nlug:3.3.2"},
   CellID->21428]},
 "nlug:3.3.2"->{
  Cell[242215, 8395, 99, 2, 70, "Subsection",
   CellTags->{"Handling Events", "nlug:3.3.2"},
   CellID->21428],
  Cell[242317, 8399, 797, 16, 70, "Text",
   CellTags->"nlug:3.3.2",
   CellID->14124],
  Cell[243117, 8417, 418, 13, 70, "Text",
   CellTags->"nlug:3.3.2",
   CellID->25981],
  Cell[243538, 8432, 227, 8, 70, "Program",
   CellTags->"nlug:3.3.2",
   CellID->28489],
  Cell[243768, 8442, 418, 10, 70, "Text",
   CellTags->"nlug:3.3.2",
   CellID->30425],
  Cell[244189, 8454, 428, 11, 70, "Text",
   CellTags->"nlug:3.3.2",
   CellID->1984],
  Cell[244620, 8467, 144, 4, 70, "Program",
   CellTags->"nlug:3.3.2",
   CellID->23286],
  Cell[244767, 8473, 195, 6, 70, "Text",
   CellTags->"nlug:3.3.2",
   CellID->6535],
  Cell[244965, 8481, 311, 8, 70, "Program",
   CellTags->"nlug:3.3.2",
   CellID->5996],
  Cell[245279, 8491, 324, 14, 70, "Text",
   CellTags->"nlug:3.3.2",
   CellID->2662],
  Cell[245606, 8507, 211, 7, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.3.2",
   CellID->24363],
  Cell[245820, 8516, 766, 20, 70, "Text",
   CellTags->"nlug:3.3.2",
   CellID->15535],
  Cell[246589, 8538, 404, 12, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.3.2",
   CellID->8667],
  Cell[246996, 8552, 1026, 31, 70, "DefinitionBox",
   CellTags->"nlug:3.3.2",
   CellID->1437],
  Cell[248025, 8585, 210, 7, 70, "Caption",
   CellTags->"nlug:3.3.2",
   CellID->15155],
  Cell[248238, 8594, 694, 14, 70, "Text",
   CellTags->"nlug:3.3.2",
   CellID->26575],
  Cell[248935, 8610, 1126, 33, 70, "Text",
   CellTags->"nlug:3.3.2",
   CellID->27154],
  Cell[250064, 8645, 177, 7, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.3.2",
   CellID->14970],
  Cell[250244, 8654, 1505, 42, 70, "Text",
   CellTags->"nlug:3.3.2",
   CellID->13663],
  Cell[251752, 8698, 667, 19, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.3.2",
   CellID->27460],
  Cell[252422, 8719, 1510, 41, 70, "Text",
   CellTags->"nlug:3.3.2",
   CellID->21763],
  Cell[253935, 8762, 294, 8, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.3.2",
   CellID->14316],
  Cell[254232, 8772, 159, 6, 70, "Text",
   CellTags->"nlug:3.3.2",
   CellID->10094],
  Cell[254394, 8780, 219, 6, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.3.2",
   CellID->26147],
  Cell[254616, 8788, 649, 23, 70, "Text",
   CellTags->"nlug:3.3.2",
   CellID->16518],
  Cell[255268, 8813, 1029, 30, 70, "DefinitionBox3Col",
   CellTags->"nlug:3.3.2",
   CellID->29509],
  Cell[256300, 8845, 88, 2, 70, "Caption",
   CellTags->"nlug:3.3.2",
   CellID->17664],
  Cell[256391, 8849, 1126, 36, 70, "Text",
   CellTags->"nlug:3.3.2",
   CellID->17112],
  Cell[257520, 8887, 2408, 66, 70, "Text",
   CellTags->"nlug:3.3.2",
   CellID->7524],
  Cell[259931, 8955, 1015, 31, 70, "DefinitionBox",
   CellTags->"nlug:3.3.2",
   CellID->18934],
  Cell[260949, 8988, 165, 7, 70, "Caption",
   CellTags->"nlug:3.3.2",
   CellID->9806],
  Cell[261117, 8997, 673, 19, 70, "Text",
   CellTags->"nlug:3.3.2",
   CellID->26381]},
 "Modal Windows"->{
  Cell[261827, 9021, 95, 2, 70, "Subsection",
   CellTags->{"Modal Windows", "nlug:3.3.3"},
   CellID->28590]},
 "nlug:3.3.3"->{
  Cell[261827, 9021, 95, 2, 70, "Subsection",
   CellTags->{"Modal Windows", "nlug:3.3.3"},
   CellID->28590],
  Cell[261925, 9025, 550, 14, 70, "Text",
   CellTags->"nlug:3.3.3",
   CellID->20634],
  Cell[262500, 9043, 183, 6, 70, "Input",
   CellTags->"nlug:3.3.3",
   CellID->27415],
  Cell[262686, 9051, 278, 9, 70, "Output",
   CellTags->"nlug:3.3.3",
   CellID->6862],
  Cell[262979, 9063, 841, 23, 70, "Text",
   CellTags->"nlug:3.3.3",
   CellID->10580],
  Cell[263823, 9088, 149, 5, 70, "Input",
   CellTags->"nlug:3.3.3",
   CellID->4919],
  Cell[263975, 9095, 591, 14, 70, "Text",
   CellTags->"nlug:3.3.3",
   CellID->2526],
  Cell[264569, 9111, 284, 10, 70, "Input",
   CellTags->"nlug:3.3.3",
   CellID->27370],
  Cell[264856, 9123, 214, 9, 70, "Text",
   CellTags->"nlug:3.3.3",
   CellID->4850],
  Cell[265073, 9134, 219, 8, 70, "Input",
   CellTags->"nlug:3.3.3",
   CellID->10944],
  Cell[265295, 9144, 386, 11, 70, "Text",
   CellTags->"nlug:3.3.3",
   CellID->8018],
  Cell[265684, 9157, 767, 23, 70, "Input",
   CellTags->"nlug:3.3.3",
   CellID->2716],
  Cell[266454, 9182, 740, 22, 70, "Text",
   CellTags->"nlug:3.3.3",
   CellID->14061],
  Cell[267197, 9206, 843, 20, 70, "Text",
   CellTags->"nlug:3.3.3",
   CellID->19422],
  Cell[268043, 9228, 929, 28, 70, "DefinitionBox",
   CellTags->"nlug:3.3.3",
   CellID->21006],
  Cell[268975, 9258, 82, 2, 70, "Caption",
   CellTags->"nlug:3.3.3",
   CellID->30826],
  Cell[269060, 9262, 144, 5, 70, "Text",
   CellTags->"nlug:3.3.3",
   CellID->703],
  Cell[269207, 9269, 130, 4, 70, "Input",
   CellTags->"nlug:3.3.3",
   CellID->13039],
  Cell[269340, 9275, 534, 15, 70, "Text",
   CellTags->"nlug:3.3.3",
   CellID->7810],
  Cell[269877, 9292, 1570, 42, 70, "Text",
   CellTags->"nlug:3.3.3",
   CellID->27214],
  Cell[271450, 9336, 137, 4, 70, "Text",
   CellTags->"nlug:3.3.3",
   CellID->4751],
  Cell[271590, 9342, 1684, 44, 70, "Input",
   CellTags->"nlug:3.3.3",
   CellID->4432],
  Cell[273277, 9388, 1320, 35, 70, "Text",
   CellTags->"nlug:3.3.3",
   CellID->7985],
  Cell[274600, 9425, 374, 10, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.3.3",
   CellID->17684],
  Cell[274977, 9437, 499, 18, 70, "Text",
   CellTags->"nlug:3.3.3",
   CellID->23301],
  Cell[275479, 9457, 1132, 35, 70, "Text",
   CellTags->"nlug:3.3.3",
   CellID->24535],
  Cell[276614, 9494, 660, 18, 70, "DefinitionBox3Col",
   CellTags->"nlug:3.3.3",
   CellID->9502],
  Cell[277277, 9514, 223, 9, 70, "Caption",
   CellTags->"nlug:3.3.3",
   CellID->8963]},
 "Modeless Windows"->{
  Cell[277537, 9528, 100, 2, 70, "Subsection",
   CellTags->{"Modeless Windows", "nlug:3.3.4"},
   CellID->9564]},
 "nlug:3.3.4"->{
  Cell[277537, 9528, 100, 2, 70, "Subsection",
   CellTags->{"Modeless Windows", "nlug:3.3.4"},
   CellID->9564],
  Cell[277640, 9532, 797, 19, 70, "Text",
   CellTags->"nlug:3.3.4",
   CellID->15012],
  Cell[278440, 9553, 659, 19, 70, "Text",
   CellTags->"nlug:3.3.4",
   CellID->13440],
  Cell[279102, 9574, 422, 13, 70, "DefinitionBox",
   CellTags->"nlug:3.3.4",
   CellID->11711],
  Cell[279527, 9589, 76, 2, 70, "Caption",
   CellTags->"nlug:3.3.4",
   CellID->4537],
  Cell[279606, 9593, 189, 6, 70, "Text",
   CellTags->"nlug:3.3.4",
   CellID->10778],
  Cell[279798, 9601, 1672, 46, 70, "Input",
   CellTags->"nlug:3.3.4",
   CellID->14781],
  Cell[281473, 9649, 329, 8, 70, "Text",
   CellTags->"nlug:3.3.4",
   CellID->20334],
  Cell[281805, 9659, 125, 4, 70, "Input",
   CellTags->"nlug:3.3.4",
   CellID->5051],
  Cell[281933, 9665, 1947, 58, 70, "Text",
   CellTags->"nlug:3.3.4",
   CellID->32040],
  Cell[283883, 9725, 1166, 28, 70, "Text",
   CellTags->"nlug:3.3.4",
   CellID->2710],
  Cell[285052, 9755, 1158, 33, 70, "DefinitionBox3Col",
   CellTags->"nlug:3.3.4",
   CellID->32538],
  Cell[286213, 9790, 85, 2, 70, "Caption",
   CellTags->"nlug:3.3.4",
   CellID->7507],
  Cell[286301, 9794, 1890, 56, 70, "Text",
   CellTags->"nlug:3.3.4",
   CellID->6349],
  Cell[288194, 9852, 1471, 41, 70, "Text",
   CellTags->"nlug:3.3.4",
   CellID->1951],
  Cell[289668, 9895, 1209, 31, 70, "Text",
   CellTags->"nlug:3.3.4",
   CellID->11350]},
 "Sharing the Kernel"->{
  Cell[290914, 9931, 138, 2, 70, "Subsection",
   CellTags->{"Sharing the Kernel", "nlug:3.3.5"},
   CellID->27606]},
 "nlug:3.3.5"->{
  Cell[290914, 9931, 138, 2, 70, "Subsection",
   CellTags->{"Sharing the Kernel", "nlug:3.3.5"},
   CellID->27606],
  Cell[291055, 9935, 797, 25, 70, "Text",
   CellTags->"nlug:3.3.5",
   CellID->24795],
  Cell[291855, 9962, 1339, 33, 70, "Text",
   CellTags->"nlug:3.3.5",
   CellID->29171],
  Cell[293197, 9997, 1510, 45, 70, "Text",
   CellTags->"nlug:3.3.5",
   CellID->3621],
  Cell[294710, 10044, 238, 9, 70, "Program",
   CellTags->"nlug:3.3.5",
   CellID->11088],
  Cell[294951, 10055, 717, 22, 70, "Text",
   CellTags->"nlug:3.3.5",
   CellID->7675],
  Cell[295671, 10079, 180, 6, 70, "Input",
   CellTags->"nlug:3.3.5",
   CellID->18725],
  Cell[295854, 10087, 197, 8, 70, "Text",
   CellTags->"nlug:3.3.5",
   CellID->22807],
  Cell[296054, 10097, 131, 4, 70, "Input",
   CellTags->"nlug:3.3.5",
   CellID->677939434],
  Cell[296188, 10103, 831, 25, 70, "Text",
   CellTags->"nlug:3.3.5",
   CellID->1265],
  Cell[297022, 10130, 732, 21, 70, "Text",
   CellTags->"nlug:3.3.5",
   CellID->17786]},
 "ShowNETWindow"->{
  Cell[297791, 10156, 194, 7, 70, "Subsection",
   CellTags->{"ShowNETWindow", "nlug:3.3.6"},
   CellID->8373],
  Cell[298893, 10197, 121, 2, 70, "Subsection",
   CellTags->{"ShowNETWindow", "nlug:3.3.7"},
   CellID->17185]},
 "nlug:3.3.6"->{
  Cell[297791, 10156, 194, 7, 70, "Subsection",
   CellTags->{"ShowNETWindow", "nlug:3.3.6"},
   CellID->8373],
  Cell[297988, 10165, 868, 27, 70, "Text",
   CellTags->"nlug:3.3.6",
   CellID->26289]},
 "nlug:3.3.7"->{
  Cell[298893, 10197, 121, 2, 70, "Subsection",
   CellTags->{"ShowNETWindow", "nlug:3.3.7"},
   CellID->17185],
  Cell[299017, 10201, 970, 27, 70, "Text",
   CellTags->"nlug:3.3.7",
   CellID->16981],
  Cell[299990, 10230, 1402, 41, 70, "Text",
   CellTags->"nlug:3.3.7",
   CellID->26655],
  Cell[301395, 10273, 455, 14, 70, "DefinitionBox",
   CellTags->"nlug:3.3.7",
   CellID->10687],
  Cell[301853, 10289, 101, 2, 70, "Caption",
   CellTags->"nlug:3.3.7",
   CellID->13394],
  Cell[301957, 10293, 1434, 46, 70, "Text",
   CellTags->"nlug:3.3.7",
   CellID->11506]},
 "nlug:3.3.8"->{
  Cell[303428, 10344, 75, 2, 70, "Subsection",
   CellTags->"nlug:3.3.8",
   CellID->9716],
  Cell[303506, 10348, 173, 6, 70, "Text",
   CellTags->"nlug:3.3.8",
   CellID->20091],
  Cell[303682, 10356, 191, 5, 70, "Text",
   CellTags->"nlug:3.3.8",
   CellID->9651],
  Cell[303876, 10363, 194, 5, 70, "Text",
   CellTags->"nlug:3.3.8",
   CellID->19287],
  Cell[304073, 10370, 212, 6, 70, "Text",
   CellTags->"nlug:3.3.8",
   CellID->16242],
  Cell[304288, 10378, 198, 5, 70, "Text",
   CellTags->"nlug:3.3.8",
   CellID->16182],
  Cell[304489, 10385, 194, 5, 70, "Text",
   CellTags->"nlug:3.3.8",
   CellID->18971]},
 "nlug:3.4.0"->{
  Cell[304896, 10405, 75, 2, 70, "Subsection",
   CellTags->"nlug:3.4.0",
   CellID->12190],
  Cell[304974, 10409, 365, 10, 70, "Text",
   CellTags->"nlug:3.4.0",
   CellID->1381],
  Cell[305342, 10421, 706, 19, 70, "Text",
   CellTags->"nlug:3.4.0",
   CellID->28910],
  Cell[306051, 10442, 1078, 27, 70, "Text",
   CellTags->"nlug:3.4.0",
   CellID->5798],
  Cell[307132, 10471, 866, 28, 70, "Text",
   CellTags->"nlug:3.4.0",
   CellID->8117],
  Cell[308001, 10501, 715, 20, 70, "Text",
   CellTags->"nlug:3.4.0",
   CellID->15444]},
 "nlug:3.4.1"->{
  Cell[308753, 10526, 157, 6, 70, "Subsection",
   CellTags->"nlug:3.4.1",
   CellID->3012],
  Cell[308913, 10534, 805, 20, 70, "Text",
   CellTags->"nlug:3.4.1",
   CellID->1914],
  Cell[309721, 10556, 803, 22, 70, "Text",
   CellTags->"nlug:3.4.1",
   CellID->2164],
  Cell[310527, 10580, 456, 24, 70, "Program",
   CellTags->"nlug:3.4.1",
   CellID->406552679],
  Cell[310986, 10606, 1072, 33, 70, "Text",
   CellTags->"nlug:3.4.1",
   CellID->20593],
  Cell[312061, 10641, 664, 21, 70, "Text",
   CellTags->"nlug:3.4.1",
   CellID->14059],
  Cell[312728, 10664, 661, 19, 70, "Text",
   CellTags->"nlug:3.4.1",
   CellID->17657],
  Cell[313392, 10685, 663, 20, 70, "Text",
   CellTags->"nlug:3.4.1",
   CellID->29386],
  Cell[314058, 10707, 1175, 37, 70, "Text",
   CellTags->"nlug:3.4.1",
   CellID->19479]},
 "nlug:3.4.2"->{
  Cell[315270, 10749, 152, 6, 70, "Subsection",
   CellTags->"nlug:3.4.2",
   CellID->6115],
  Cell[315425, 10757, 1120, 32, 70, "Text",
   CellTags->"nlug:3.4.2",
   CellID->28056],
  Cell[316548, 10791, 1429, 38, 70, "Text",
   CellTags->"nlug:3.4.2",
   CellID->16540],
  Cell[317980, 10831, 1323, 40, 70, "Text",
   CellTags->"nlug:3.4.2",
   CellID->3282],
  Cell[319306, 10873, 715, 23, 70, "Text",
   CellTags->"nlug:3.4.2",
   CellID->21339],
  Cell[320024, 10898, 110, 2, 70, "Program",
   CellTags->"nlug:3.4.2",
   CellID->19827],
  Cell[320137, 10902, 362, 14, 70, "Text",
   CellTags->"nlug:3.4.2",
   CellID->18566],
  Cell[320502, 10918, 88, 2, 70, "Program",
   CellTags->"nlug:3.4.2",
   CellID->25582],
  Cell[320593, 10922, 221, 8, 70, "Text",
   CellTags->"nlug:3.4.2",
   CellID->20931],
  Cell[320817, 10932, 162, 3, 70, "Program",
   CellTags->"nlug:3.4.2",
   CellID->22090],
  Cell[320982, 10937, 77, 2, 70, "Text",
   CellTags->"nlug:3.4.2",
   CellID->29713],
  Cell[321062, 10941, 370, 15, 70, "Program",
   CellTags->"nlug:3.4.2",
   CellID->6231],
  Cell[321435, 10958, 424, 16, 70, "Text",
   CellTags->"nlug:3.4.2",
   CellID->29604],
  Cell[321862, 10976, 138, 6, 70, "Text",
   CellTags->"nlug:3.4.2",
   CellID->1684],
  Cell[322025, 10986, 370, 12, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.4.2",
   CellID->10158],
  Cell[322398, 11000, 146, 5, 70, "Print",
   CellTags->"nlug:3.4.2",
   CellID->7504],
  Cell[322547, 11007, 312, 8, 70, "Message",
   CellTags->"nlug:3.4.2",
   CellID->15748],
  Cell[322862, 11017, 99, 3, 70, "Output",
   CellTags->"nlug:3.4.2",
   CellID->30158],
  Cell[322976, 11023, 416, 13, 70, "Text",
   CellTags->"nlug:3.4.2",
   CellID->28083],
  Cell[323395, 11038, 1831, 59, 70, "Text",
   CellTags->"nlug:3.4.2",
   CellID->8552],
  Cell[325229, 11099, 82, 2, 70, "Text",
   CellTags->"nlug:3.4.2",
   CellID->31498],
  Cell[325314, 11103, 874, 30, 70, "Program",
   CellTags->"nlug:3.4.2",
   CellID->31507]},
 "nlug:3.4.3"->{
  Cell[326225, 11138, 82, 2, 70, "Subsection",
   CellTags->"nlug:3.4.3",
   CellID->21153],
  Cell[326310, 11142, 895, 23, 70, "Text",
   CellTags->"nlug:3.4.3",
   CellID->2474]},
 "nlug:3.4.4"->{
  Cell[327242, 11170, 91, 2, 70, "Subsection",
   CellTags->"nlug:3.4.4",
   CellID->7522],
  Cell[327336, 11174, 685, 23, 70, "Text",
   CellTags->"nlug:3.4.4",
   CellID->8685],
  Cell[328024, 11199, 554, 15, 70, "Text",
   CellTags->"nlug:3.4.4",
   CellID->22184],
  Cell[328581, 11216, 317, 13, 70, "Program",
   CellTags->"nlug:3.4.4",
   CellID->11541],
  Cell[328901, 11231, 1477, 44, 70, "Text",
   CellTags->"nlug:3.4.4",
   CellID->22755],
  Cell[330381, 11277, 1887, 48, 70, "Text",
   CellTags->"nlug:3.4.4",
   CellID->24939],
  Cell[332271, 11327, 1660, 43, 70, "Text",
   CellTags->"nlug:3.4.4",
   CellID->6253],
  Cell[333934, 11372, 76, 2, 70, "Text",
   CellTags->"nlug:3.4.4",
   CellID->25676],
  Cell[334013, 11376, 386, 17, 70, "Program",
   CellTags->"nlug:3.4.4",
   CellID->17903]},
 "nlug:3.4.5"->{
  Cell[334436, 11398, 98, 2, 70, "Subsection",
   CellTags->"nlug:3.4.5",
   CellID->18803],
  Cell[334537, 11402, 2007, 54, 70, "Text",
   CellTags->"nlug:3.4.5",
   CellID->7434],
  Cell[336547, 11458, 203, 6, 70, "Text",
   CellTags->"nlug:3.4.5",
   CellID->16782],
  Cell[336753, 11466, 214, 7, 70, "BulletedText",
   CellTags->"nlug:3.4.5",
   CellID->2331],
  Cell[336970, 11475, 273, 10, 70, "BulletedText",
   CellTags->"nlug:3.4.5",
   CellID->6746],
  Cell[337246, 11487, 356, 11, 70, "BulletedText",
   CellTags->"nlug:3.4.5",
   CellID->22870],
  Cell[337605, 11500, 251, 8, 70, "BulletedText",
   CellTags->"nlug:3.4.5",
   CellID->1255],
  Cell[337859, 11510, 172, 6, 70, "BulletedText",
   CellTags->"nlug:3.4.5",
   CellID->18064],
  Cell[338056, 11520, 465, 15, 70, "BulletedText",
   CellTags->"nlug:3.4.5",
   CellID->31410],
  Cell[338524, 11537, 737, 19, 70, "Text",
   CellTags->"nlug:3.4.5",
   CellID->24680],
  Cell[339264, 11558, 135, 4, 70, "Text",
   CellTags->"nlug:3.4.5",
   CellID->8360],
  Cell[339402, 11564, 595, 18, 70, "Program",
   CellTags->"nlug:3.4.5",
   CellID->25778]},
 "nlug:3.4.6"->{
  Cell[340046, 11588, 90, 2, 70, "Subsection",
   CellTags->"nlug:3.4.6",
   CellID->16227],
  Cell[340139, 11592, 752, 20, 70, "Text",
   CellTags->"nlug:3.4.6",
   CellID->23382],
  Cell[340894, 11614, 986, 29, 70, "Text",
   CellTags->"nlug:3.4.6",
   CellID->25110],
  Cell[341883, 11645, 111, 3, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.4.6",
   CellID->25087],
  Cell[341997, 11650, 950, 30, 70, "Text",
   CellTags->"nlug:3.4.6",
   CellID->31230]},
 "Calling DLLS from Mathematica"->{
  Cell[343144, 11696, 110, 2, 70, "Subsection",
   CellTags->{"Calling DLLS from Mathematica", "nlug:3.5.0"},
   CellID->24729]},
 "nlug:3.5.0"->{
  Cell[343144, 11696, 110, 2, 70, "Subsection",
   CellTags->{"Calling DLLS from Mathematica", "nlug:3.5.0"},
   CellID->24729],
  Cell[343257, 11700, 980, 25, 70, "Text",
   CellTags->"nlug:3.5.0",
   CellID->5413],
  Cell[344240, 11727, 797, 21, 70, "Text",
   CellTags->"nlug:3.5.0",
   CellID->16603],
  Cell[345040, 11750, 441, 11, 70, "Text",
   CellTags->"nlug:3.5.0",
   CellID->29591],
  Cell[345484, 11763, 415, 11, 70, "Program",
   CellTags->"nlug:3.5.0",
   CellID->17403],
  Cell[345902, 11776, 440, 13, 70, "Text",
   CellTags->"nlug:3.5.0",
   CellID->14964],
  Cell[346367, 11793, 291, 9, 70, "Input",
   CellTags->"nlug:3.5.0",
   CellID->31695],
  Cell[346661, 11804, 519, 14, 70, "Output",
   CellTags->"nlug:3.5.0",
   CellID->30298],
  Cell[347195, 11821, 340, 10, 70, "Text",
   CellTags->"nlug:3.5.0",
   CellID->1042],
  Cell[347560, 11835, 126, 4, 70, "Input",
   CellTags->"nlug:3.5.0",
   CellID->30540],
  Cell[347689, 11841, 102, 3, 70, "Output",
   CellTags->"nlug:3.5.0",
   CellID->19245],
  Cell[347806, 11847, 1261, 30, 70, "Text",
   CellTags->"nlug:3.5.0",
   CellID->32464],
  Cell[350069, 11910, 1249, 28, 70, "Text",
   CellTags->"nlug:3.5.0",
   CellID->10860],
  Cell[351321, 11940, 737, 22, 70, "Text",
   CellTags->"nlug:3.5.0",
   CellID->21989],
  Cell[352061, 11964, 1384, 36, 70, "DefinitionBox3Col",
   CellTags->"nlug:3.5.0",
   CellID->13770],
  Cell[353448, 12002, 238, 9, 70, "Caption",
   CellTags->"nlug:3.5.0",
   CellID->14749]},
 "How DLLs are Found"->{
  Cell[353723, 12016, 104, 2, 70, "Subsection",
   CellTags->{"How DLLs are Found", "nlug:3.5.1"},
   CellID->9297]},
 "nlug:3.5.1"->{
  Cell[353723, 12016, 104, 2, 70, "Subsection",
   CellTags->{"How DLLs are Found", "nlug:3.5.1"},
   CellID->9297],
  Cell[353830, 12020, 1041, 26, 70, "Text",
   CellTags->"nlug:3.5.1",
   CellID->8091],
  Cell[354874, 12048, 1968, 55, 70, "Text",
   CellTags->"nlug:3.5.1",
   CellID->25024],
  Cell[356845, 12105, 553, 14, 70, "Text",
   CellTags->"nlug:3.5.1",
   CellID->3252]},
 "Specifying Arguments and Return Values"->{
  Cell[357435, 12124, 145, 2, 70, "Subsection",
   CellTags->{"Specifying Arguments and Return Values", "nlug:3.5.2"},
   CellID->20321]},
 "nlug:3.5.2"->{
  Cell[357435, 12124, 145, 2, 70, "Subsection",
   CellTags->{"Specifying Arguments and Return Values", "nlug:3.5.2"},
   CellID->20321],
  Cell[357605, 12130, 78, 2, 70, "Subsubsection",
   CellTags->"nlug:3.5.2",
   CellID->13740],
  Cell[357686, 12134, 1037, 19, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->19713],
  Cell[358726, 12155, 83, 2, 70, "Program",
   CellTags->"nlug:3.5.2",
   CellID->26835],
  Cell[358812, 12159, 684, 21, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->28316],
  Cell[359499, 12182, 320, 9, 70, "Input",
   CellTags->"nlug:3.5.2",
   CellID->5489],
  Cell[359844, 12195, 134, 4, 70, "Input",
   CellTags->"nlug:3.5.2",
   CellID->27796],
  Cell[359981, 12201, 96, 3, 70, "Output",
   CellTags->"nlug:3.5.2",
   CellID->26548],
  Cell[360092, 12207, 412, 10, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->2664],
  Cell[360507, 12219, 1408, 38, 70, "Input",
   CellTags->"nlug:3.5.2",
   CellID->25858],
  Cell[361918, 12259, 690, 15, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->20543],
  Cell[362611, 12276, 338, 10, 70, "Program",
   CellTags->"nlug:3.5.2",
   CellID->5081],
  Cell[362952, 12288, 820, 24, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->5580],
  Cell[363775, 12314, 136, 4, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->21407],
  Cell[363948, 12323, 80, 2, 70, "Subsubsection",
   CellTags->"nlug:3.5.2",
   CellID->4436],
  Cell[364031, 12327, 272, 8, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->27670],
  Cell[364306, 12337, 3366, 98, 70, "DefinitionBox",
   CellTags->"nlug:3.5.2",
   CellID->29662],
  Cell[367675, 12437, 275, 9, 70, "Caption",
   CellTags->"nlug:3.5.2",
   CellID->22863],
  Cell[367953, 12448, 535, 13, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->9166],
  Cell[368525, 12466, 94, 2, 70, "Subsubsection",
   CellTags->{"strings in DLLs", "nlug:3.5.2"},
   CellID->16463],
  Cell[368622, 12470, 1120, 25, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->29055],
  Cell[369745, 12497, 383, 10, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->6598],
  Cell[370131, 12509, 132, 6, 70, "Program",
   CellTags->"nlug:3.5.2",
   CellID->15772],
  Cell[370266, 12517, 427, 12, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->19331],
  Cell[370696, 12531, 637, 19, 70, "Input",
   CellTags->"nlug:3.5.2",
   CellID->1861],
  Cell[371336, 12552, 157, 5, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->28300],
  Cell[371518, 12561, 238, 7, 70, "Input",
   CellTags->"nlug:3.5.2",
   CellID->18493],
  Cell[371759, 12570, 97, 3, 70, "Output",
   CellTags->"nlug:3.5.2",
   CellID->12041],
  Cell[371871, 12576, 399, 9, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->30649],
  Cell[372295, 12589, 139, 4, 70, "Input",
   CellTags->"nlug:3.5.2",
   CellID->23644],
  Cell[372437, 12595, 103, 3, 70, "Output",
   CellTags->"nlug:3.5.2",
   CellID->4237],
  Cell[372555, 12601, 110, 2, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->13082],
  Cell[372690, 12607, 138, 4, 70, "Input",
   CellTags->"nlug:3.5.2",
   CellID->7619],
  Cell[372831, 12613, 108, 3, 70, "Output",
   CellTags->"nlug:3.5.2",
   CellID->30667],
  Cell[372954, 12619, 839, 21, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->10463],
  Cell[373796, 12642, 1418, 48, 70, "DefinitionBox",
   CellTags->"nlug:3.5.2",
   CellID->28816],
  Cell[375217, 12692, 293, 9, 70, "Caption",
   CellTags->"nlug:3.5.2",
   CellID->32610],
  Cell[375513, 12703, 509, 15, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->32042],
  Cell[376025, 12720, 2006, 57, 70, "Input",
   CellTags->"nlug:3.5.2",
   CellID->12619],
  Cell[378034, 12779, 957, 21, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->18413],
  Cell[378994, 12802, 130, 4, 70, "Program",
   CellTags->"nlug:3.5.2",
   CellID->30880],
  Cell[379127, 12808, 971, 23, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->8108],
  Cell[380101, 12833, 522, 12, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->31306],
  Cell[380626, 12847, 413, 12, 70, "Input",
   CellTags->"nlug:3.5.2",
   CellID->18847],
  Cell[381042, 12861, 683, 19, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->4806],
  Cell[381728, 12882, 337, 10, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->21452],
  Cell[382090, 12896, 325, 10, 70, "Input",
   CellTags->"nlug:3.5.2",
   CellID->13696],
  Cell[382418, 12908, 94, 3, 70, "Output",
   CellTags->"nlug:3.5.2",
   CellID->29571],
  Cell[382527, 12914, 205, 7, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->23500],
  Cell[382757, 12925, 145, 5, 70, "Input",
   CellTags->"nlug:3.5.2",
   CellID->6377],
  Cell[382905, 12932, 109, 3, 70, "Output",
   CellTags->"nlug:3.5.2",
   CellID->10456],
  Cell[383063, 12941, 85, 2, 70, "Subsubsection",
   CellTags->"nlug:3.5.2",
   CellID->26535],
  Cell[383151, 12945, 378, 9, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->21011],
  Cell[383532, 12956, 134, 4, 70, "BulletedText",
   CellTags->"nlug:3.5.2",
   CellID->1587],
  Cell[383669, 12962, 238, 6, 70, "BulletedText",
   CellTags->"nlug:3.5.2",
   CellID->225412227],
  Cell[383932, 12972, 250, 6, 70, "BulletedText",
   CellTags->"nlug:3.5.2",
   CellID->130001283],
  Cell[384185, 12980, 392, 11, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->6102],
  Cell[384580, 12993, 93, 2, 70, "Program",
   CellTags->"nlug:3.5.2",
   CellID->84],
  Cell[384676, 12997, 735, 19, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->14423],
  Cell[385414, 13018, 182, 6, 70, "Input",
   CellTags->"nlug:3.5.2",
   CellID->7883],
  Cell[385599, 13026, 1474, 39, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->22313],
  Cell[387098, 13069, 223, 7, 70, "Input",
   CellTags->"nlug:3.5.2",
   CellID->9003469],
  Cell[387324, 13078, 97, 3, 70, "Output",
   CellTags->"nlug:3.5.2",
   CellID->26079],
  Cell[387458, 13086, 103, 3, 70, "Input",
   CellTags->"nlug:3.5.2",
   CellID->12582],
  Cell[387564, 13091, 96, 3, 70, "Output",
   CellTags->"nlug:3.5.2",
   CellID->16000],
  Cell[387675, 13097, 510, 14, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->1616],
  Cell[388188, 13113, 364, 11, 70, "Input",
   CellTags->"nlug:3.5.2",
   CellID->26358],
  Cell[388577, 13128, 232, 6, 70, "Input",
   CellTags->"nlug:3.5.2",
   CellID->17843],
  Cell[388812, 13136, 97, 3, 70, "Output",
   CellTags->"nlug:3.5.2",
   CellID->27807],
  Cell[388912, 13141, 95, 3, 70, "Output",
   CellTags->"nlug:3.5.2",
   CellID->7909],
  Cell[389022, 13147, 1060, 27, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->415],
  Cell[390085, 13176, 812, 22, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->24765],
  Cell[390900, 13200, 150, 6, 70, "Program",
   CellTags->"nlug:3.5.2",
   CellID->4530],
  Cell[391053, 13208, 412, 12, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->10072],
  Cell[391468, 13222, 1211, 35, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.5.2",
   CellID->29317],
  Cell[392682, 13259, 255, 8, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->7058],
  Cell[392940, 13269, 308, 10, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->13281],
  Cell[393251, 13281, 367, 12, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.5.2",
   CellID->22272],
  Cell[393621, 13295, 115, 2, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->30257],
  Cell[393739, 13299, 256, 9, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.5.2",
   CellID->22757],
  Cell[393998, 13310, 1167, 30, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->8740],
  Cell[395168, 13342, 1466, 36, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.5.2",
   CellID->7107],
  Cell[396637, 13380, 115, 2, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->29311],
  Cell[396755, 13384, 255, 9, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.5.2",
   CellID->6257],
  Cell[397013, 13395, 356, 11, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->2393],
  Cell[397418, 13412, 83, 2, 70, "Subsubsection",
   CellTags->"nlug:3.5.2",
   CellID->10971],
  Cell[397504, 13416, 1568, 39, 70, "Text",
   CellTags->"nlug:3.5.2",
   CellID->21587]},
 "strings in DLLs"->{
  Cell[368525, 12466, 94, 2, 70, "Subsubsection",
   CellTags->{"strings in DLLs", "nlug:3.5.2"},
   CellID->16463]},
 "Declarations Requiring Special Attributes"->{
  Cell[399121, 13461, 151, 2, 70, "Subsection",
   CellTags->{"Declarations Requiring Special Attributes", "nlug:3.5.3"},
   CellID->11743]},
 "nlug:3.5.3"->{
  Cell[399121, 13461, 151, 2, 70, "Subsection",
   CellTags->{"Declarations Requiring Special Attributes", "nlug:3.5.3"},
   CellID->11743],
  Cell[399275, 13465, 1078, 26, 70, "Text",
   CellTags->"nlug:3.5.3",
   CellID->24468],
  Cell[400356, 13493, 291, 7, 70, "Program",
   CellTags->"nlug:3.5.3",
   CellID->3802],
  Cell[400650, 13502, 409, 11, 70, "Text",
   CellTags->"nlug:3.5.3",
   CellID->30088],
  Cell[401062, 13515, 419, 11, 70, "Input",
   CellTags->"nlug:3.5.3",
   CellID->24298],
  Cell[401484, 13528, 194, 7, 70, "Text",
   CellTags->"nlug:3.5.3",
   CellID->6582],
  Cell[401681, 13537, 232, 6, 70, "Text",
   CellTags->"nlug:3.5.3",
   CellID->22252],
  Cell[401916, 13545, 122, 2, 70, "Program",
   CellTags->"nlug:3.5.3",
   CellID->113305141],
  Cell[402041, 13549, 157, 6, 70, "Text",
   CellTags->"nlug:3.5.3",
   CellID->11457],
  Cell[402201, 13557, 363, 10, 70, "Input",
   CellTags->"nlug:3.5.3",
   CellID->24385],
  Cell[402567, 13569, 678, 17, 70, "Text",
   CellTags->"nlug:3.5.3",
   CellID->19293],
  Cell[403248, 13588, 491, 14, 70, "Input",
   CellTags->"nlug:3.5.3",
   CellID->31716]},
 "DLL Example Files"->{
  Cell[403776, 13607, 99, 2, 70, "Subsection",
   CellTags->{"DLL Example Files", "nlug:3.5.4"},
   CellID->19628]},
 "nlug:3.5.4"->{
  Cell[403776, 13607, 99, 2, 70, "Subsection",
   CellTags->{"DLL Example Files", "nlug:3.5.4"},
   CellID->19628],
  Cell[403878, 13611, 260, 9, 70, "Text",
   CellTags->"nlug:3.5.4",
   CellID->12394],
  Cell[404141, 13622, 194, 5, 70, "Text",
   CellTags->"nlug:3.5.4",
   CellID->19291],
  Cell[404338, 13629, 178, 4, 70, "Text",
   CellTags->"nlug:3.5.4",
   CellID->3771],
  Cell[404519, 13635, 182, 5, 70, "Text",
   CellTags->"nlug:3.5.4",
   CellID->5107]},
 "COM"->{
  Cell[404750, 13646, 139, 7, 70, "Section",
   CellTags->"COM",
   CellID->7475]},
 "COM Introduction"->{
  Cell[404914, 13657, 96, 2, 70, "Subsection",
   CellTags->{"COM Introduction", "nlug:3.6.0"},
   CellID->8879]},
 "nlug:3.6.0"->{
  Cell[404914, 13657, 96, 2, 70, "Subsection",
   CellTags->{"COM Introduction", "nlug:3.6.0"},
   CellID->8879],
  Cell[405013, 13661, 622, 15, 70, "Text",
   CellTags->"nlug:3.6.0",
   CellID->11858],
  Cell[405638, 13678, 346, 7, 70, "Text",
   CellTags->"nlug:3.6.0",
   CellID->18583],
  Cell[405987, 13687, 562, 10, 70, "Text",
   CellTags->"nlug:3.6.0",
   CellID->19946],
  Cell[406552, 13699, 791, 17, 70, "Text",
   CellTags->"nlug:3.6.0",
   CellID->24187]},
 "nlug:3.6.1"->{
  Cell[407380, 13721, 94, 2, 70, "Subsection",
   CellTags->"nlug:3.6.1",
   CellID->13407],
  Cell[407477, 13725, 884, 19, 70, "Text",
   CellTags->"nlug:3.6.1",
   CellID->8288],
  Cell[408364, 13746, 1023, 22, 70, "Text",
   CellTags->"nlug:3.6.1",
   CellID->17925],
  Cell[409390, 13770, 1243, 24, 70, "Text",
   CellTags->"nlug:3.6.1",
   CellID->16395],
  Cell[410636, 13796, 951, 22, 70, "Text",
   CellTags->"nlug:3.6.1",
   CellID->22860],
  Cell[411590, 13820, 1346, 38, 70, "DefinitionBox",
   CellTags->"nlug:3.6.1",
   CellID->24320],
  Cell[412939, 13860, 83, 2, 70, "Caption",
   CellTags->"nlug:3.6.1",
   CellID->25390],
  Cell[413025, 13864, 108, 2, 70, "Text",
   CellTags->"nlug:3.6.1",
   CellID->14767],
  Cell[413158, 13870, 178, 5, 70, "Input",
   CellTags->"nlug:3.6.1",
   CellID->25656],
  Cell[413339, 13877, 323, 9, 70, "Output",
   CellTags->"nlug:3.6.1",
   CellID->5354],
  Cell[413677, 13889, 907, 22, 70, "Text",
   CellTags->"nlug:3.6.1",
   CellID->672],
  Cell[414609, 13915, 201, 7, 70, "Input",
   CellTags->"nlug:3.6.1",
   CellID->18446],
  Cell[414813, 13924, 117, 3, 70, "Output",
   CellTags->"nlug:3.6.1",
   CellID->25156],
  Cell[414945, 13930, 1609, 39, 70, "Text",
   CellTags->"nlug:3.6.1",
   CellID->20879],
  Cell[416557, 13971, 335, 10, 70, "Text",
   CellTags->"nlug:3.6.1",
   CellID->4500],
  Cell[416917, 13985, 131, 4, 70, "Input",
   CellTags->"nlug:3.6.1",
   CellID->4293],
  Cell[417051, 13991, 260, 7, 70, "Message",
   CellTags->"nlug:3.6.1",
   CellID->23203],
  Cell[417314, 14000, 177, 7, 70, "Output",
   CellTags->"nlug:3.6.1",
   CellID->22309],
  Cell[417506, 14010, 555, 14, 70, "Text",
   CellTags->"nlug:3.6.1",
   CellID->508],
  Cell[418064, 14026, 189, 8, 70, "Text",
   CellTags->"nlug:3.6.1",
   CellID->21585],
  Cell[418278, 14038, 121, 4, 70, "Input",
   CellTags->"nlug:3.6.1",
   CellID->2289],
  Cell[418402, 14044, 94, 3, 70, "Output",
   CellTags->"nlug:3.6.1",
   CellID->15271],
  Cell[418511, 14050, 290, 10, 70, "Text",
   CellTags->"nlug:3.6.1",
   CellID->30580],
  Cell[418804, 14062, 158, 5, 70, "Program",
   CellTags->"nlug:3.6.1",
   CellID->14127],
  Cell[418965, 14069, 554, 14, 70, "Text",
   CellTags->"nlug:3.6.1",
   CellID->4550],
  Cell[419522, 14085, 249, 9, 70, "Input",
   CellTags->"nlug:3.6.1",
   CellID->6941],
  Cell[419774, 14096, 859, 16, 70, "Text",
   CellTags->"nlug:3.6.1",
   CellID->16502],
  Cell[420636, 14114, 303, 9, 70, "Input",
   CellTags->"nlug:3.6.1",
   CellID->9793],
  Cell[420964, 14127, 95, 2, 70, "Subsubsection",
   CellTags->"nlug:3.6.1",
   CellID->25994],
  Cell[421062, 14131, 323, 10, 70, "Text",
   CellTags->"nlug:3.6.1",
   CellID->16157],
  Cell[421388, 14143, 149, 4, 70, "BulletedText",
   CellTags->"nlug:3.6.1",
   CellID->28621],
  Cell[421540, 14149, 303, 9, 70, "BulletedText",
   CellTags->"nlug:3.6.1",
   CellID->300129566],
  Cell[421846, 14160, 115, 2, 70, "BulletedText",
   CellTags->"nlug:3.6.1",
   CellID->112225757],
  Cell[421986, 14166, 95, 2, 70, "BulletedText",
   CellTags->"nlug:3.6.1",
   CellID->716654330],
  Cell[422084, 14170, 293, 9, 70, "Text",
   CellTags->"nlug:3.6.1",
   CellID->23156]},
 "Interop Assembly"->{
  Cell[422438, 14186, 126, 2, 70, "Subsection",
   CellTags->{"Interop Assembly", "nlug:3.6.2"},
   CellID->17803]},
 "nlug:3.6.2"->{
  Cell[422438, 14186, 126, 2, 70, "Subsection",
   CellTags->{"Interop Assembly", "nlug:3.6.2"},
   CellID->17803],
  Cell[422567, 14190, 979, 21, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->24466],
  Cell[423549, 14213, 1264, 34, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->10828],
  Cell[424816, 14249, 373, 11, 70, "DefinitionBox",
   CellTags->"nlug:3.6.2",
   CellID->16288],
  Cell[425192, 14262, 92, 2, 70, "Caption",
   CellTags->"nlug:3.6.2",
   CellID->343302148],
  Cell[425287, 14266, 207, 5, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->24764],
  Cell[425519, 14275, 259, 8, 70, "Input",
   CellTags->"nlug:3.6.2",
   CellID->31935],
  Cell[425781, 14285, 177, 5, 70, "Output",
   CellTags->"nlug:3.6.2",
   CellID->17072],
  Cell[425973, 14293, 957, 23, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->12833],
  Cell[426955, 14320, 116, 3, 70, "Input",
   CellTags->"nlug:3.6.2",
   CellID->12920],
  Cell[427074, 14325, 4598, 150, 70, "Output",
   CellTags->"nlug:3.6.2",
   CellID->20002],
  Cell[431687, 14478, 715, 21, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->19202],
  Cell[432427, 14503, 179, 5, 70, "Input",
   CellTags->"nlug:3.6.2",
   CellID->13048],
  Cell[432609, 14510, 276, 9, 70, "Output",
   CellTags->"nlug:3.6.2",
   CellID->13506],
  Cell[432900, 14522, 356, 9, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->16913],
  Cell[433281, 14535, 241, 8, 70, "Input",
   CellTags->"nlug:3.6.2",
   CellID->25361],
  Cell[433525, 14545, 93, 3, 70, "Output",
   CellTags->"nlug:3.6.2",
   CellID->25210],
  Cell[433633, 14551, 423, 9, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->17784],
  Cell[434059, 14562, 409, 13, 70, "Input",
   CellTags->"nlug:3.6.2",
   CellID->8064],
  Cell[434471, 14577, 429, 12, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->18771],
  Cell[434925, 14593, 173, 5, 70, "Input",
   CellTags->"nlug:3.6.2",
   CellID->23392],
  Cell[435101, 14600, 2015, 63, 70, "Output",
   CellTags->"nlug:3.6.2",
   CellID->4012],
  Cell[437131, 14666, 803, 22, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->14938],
  Cell[437959, 14692, 179, 5, 70, "Input",
   CellTags->"nlug:3.6.2",
   CellID->3789],
  Cell[438141, 14699, 276, 9, 70, "Output",
   CellTags->"nlug:3.6.2",
   CellID->21101],
  Cell[438432, 14711, 1000, 29, 70, "DefinitionBox3Col",
   CellTags->"nlug:3.6.2",
   CellID->18769],
  Cell[439435, 14742, 239, 9, 70, "Caption",
   CellTags->"nlug:3.6.2",
   CellID->20809],
  Cell[439677, 14753, 2210, 59, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->7588],
  Cell[441890, 14814, 504, 12, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->19774],
  Cell[442419, 14830, 167, 5, 70, "Input",
   CellTags->"nlug:3.6.2",
   CellID->31774],
  Cell[442589, 14837, 1802, 52, 70, "Output",
   CellTags->"nlug:3.6.2",
   CellID->867],
  Cell[444406, 14892, 114, 2, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->2838],
  Cell[444545, 14898, 180, 5, 70, "Input",
   CellTags->"nlug:3.6.2",
   CellID->20456],
  Cell[444728, 14905, 95, 3, 70, "Output",
   CellTags->"nlug:3.6.2",
   CellID->4198],
  Cell[444860, 14913, 112, 2, 70, "Subsubsection",
   CellTags->"nlug:3.6.2",
   CellID->31228],
  Cell[444975, 14917, 1094, 27, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->29753],
  Cell[446072, 14946, 181, 5, 70, "Program",
   CellTags->"nlug:3.6.2",
   CellID->30709],
  Cell[446256, 14953, 132, 4, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->3864],
  Cell[446391, 14959, 167, 6, 70, "Input",
   CellTags->"nlug:3.6.2",
   CellID->13720],
  Cell[446595, 14970, 92, 2, 70, "Subsubsection",
   CellTags->"nlug:3.6.2",
   CellID->17809],
  Cell[446690, 14974, 889, 17, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->30125],
  Cell[447582, 14993, 795, 18, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->17905],
  Cell[448380, 15013, 968, 25, 70, "Text",
   CellTags->"nlug:3.6.2",
   CellID->29007],
  Cell[449373, 15042, 207, 7, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.6.2",
   CellID->8418],
  Cell[449583, 15051, 307, 10, 70, "Output",
   CellTags->"nlug:3.6.2",
   CellID->10900]},
 "nlug:3.6.3"->{
  Cell[449951, 15068, 86, 2, 70, "Subsection",
   CellTags->"nlug:3.6.3",
   CellID->31728],
  Cell[450040, 15072, 1180, 22, 70, "Text",
   CellTags->"nlug:3.6.3",
   CellID->21878],
  Cell[451223, 15096, 334, 10, 70, "DefinitionBox",
   CellTags->"nlug:3.6.3",
   CellID->21827],
  Cell[451560, 15108, 83, 2, 70, "Caption",
   CellTags->"nlug:3.6.3",
   CellID->4403],
  Cell[451646, 15112, 1192, 26, 70, "Text",
   CellTags->"nlug:3.6.3",
   CellID->18955],
  Cell[452841, 15140, 286, 6, 70, "Text",
   CellTags->"nlug:3.6.3",
   CellID->15739],
  Cell[453152, 15150, 187, 6, 70, "Input",
   CellTags->"nlug:3.6.3",
   CellID->7540],
  Cell[453342, 15158, 306, 10, 70, "Output",
   CellTags->"nlug:3.6.3",
   CellID->21019],
  Cell[453663, 15171, 823, 22, 70, "Text",
   CellTags->"nlug:3.6.3",
   CellID->27680],
  Cell[454489, 15195, 400, 13, 70, "Input",
   CellTags->"nlug:3.6.3",
   CellID->5393],
  Cell[454892, 15210, 773, 21, 70, "Text",
   CellTags->"nlug:3.6.3",
   CellID->42467692],
  Cell[455690, 15235, 294, 8, 70, "Input",
   CellTags->"nlug:3.6.3",
   CellID->10792],
  Cell[455987, 15245, 147, 5, 70, "Output",
   CellTags->"nlug:3.6.3",
   CellID->7726],
  Cell[456149, 15253, 1691, 41, 70, "Text",
   CellTags->"nlug:3.6.3",
   CellID->657145216],
  Cell[457843, 15296, 300, 14, 70, "Input",
   Evaluatable->False,
   CellTags->"nlug:3.6.3",
   CellID->12359]},
 "nlug:3.6.4"->{
  Cell[458180, 15315, 81, 2, 70, "Subsection",
   CellTags->"nlug:3.6.4",
   CellID->1539],
  Cell[458264, 15319, 707, 17, 70, "Text",
   CellTags->"nlug:3.6.4",
   CellID->22981],
  Cell[458996, 15340, 212, 7, 70, "Input",
   CellTags->"nlug:3.6.4",
   CellID->17552],
  Cell[459211, 15349, 307, 10, 70, "Output",
   CellTags->"nlug:3.6.4",
   CellID->25383],
  Cell[459533, 15362, 83, 2, 70, "Text",
   CellTags->"nlug:3.6.4",
   CellID->30442],
  Cell[459619, 15366, 194, 7, 70, "Input",
   CellTags->"nlug:3.6.4",
   CellID->1979],
  Cell[459816, 15375, 249, 8, 70, "Text",
   CellTags->"nlug:3.6.4",
   CellID->24807],
  Cell[460090, 15387, 160, 5, 70, "Input",
   CellTags->"nlug:3.6.4",
   CellID->8889],
  Cell[460253, 15394, 319, 9, 70, "Output",
   CellTags->"nlug:3.6.4",
   CellID->25780],
  Cell[460587, 15406, 771, 21, 70, "Text",
   CellTags->"nlug:3.6.4",
   CellID->31265],
  Cell[461383, 15431, 203, 6, 70, "Input",
   CellTags->"nlug:3.6.4",
   CellID->4783],
  Cell[461589, 15439, 760, 24, 70, "Output",
   CellTags->"nlug:3.6.4",
   CellID->15794],
  Cell[462364, 15466, 1190, 27, 70, "Text",
   CellTags->"nlug:3.6.4",
   CellID->8463],
  Cell[463557, 15495, 723, 15, 70, "Text",
   CellTags->"nlug:3.6.4",
   CellID->17013],
  Cell[464305, 15514, 288, 9, 70, "Input",
   CellTags->"nlug:3.6.4",
   CellID->20925],
  Cell[464596, 15525, 305, 10, 70, "Output",
   CellTags->"nlug:3.6.4",
   CellID->1961],
  Cell[464916, 15538, 202, 5, 70, "Text",
   CellTags->"nlug:3.6.4",
   CellID->16397],
  Cell[465121, 15545, 204, 6, 70, "Program",
   CellTags->"nlug:3.6.4",
   CellID->14361],
  Cell[465328, 15553, 455, 15, 70, "Text",
   CellTags->"nlug:3.6.4",
   CellID->7485],
  Cell[465786, 15570, 899, 21, 70, "Text",
   CellTags->"nlug:3.6.4",
   CellID->13095]},
 "Handling COM Events"->{
  Cell[466722, 15596, 107, 2, 70, "Subsection",
   CellTags->{"Handling COM Events", "nlug:3.6.5"},
   CellID->23007]},
 "nlug:3.6.5"->{
  Cell[466722, 15596, 107, 2, 70, "Subsection",
   CellTags->{"Handling COM Events", "nlug:3.6.5"},
   CellID->23007],
  Cell[466832, 15600, 523, 13, 70, "Text",
   CellTags->"nlug:3.6.5",
   CellID->17156],
  Cell[467358, 15615, 961, 19, 70, "Text",
   CellTags->"nlug:3.6.5",
   CellID->27544],
  Cell[468322, 15636, 345, 9, 70, "Text",
   CellTags->"nlug:3.6.5",
   CellID->4605],
  Cell[468692, 15649, 198, 7, 70, "Input",
   CellTags->"nlug:3.6.5",
   CellID->6624],
  Cell[468893, 15658, 323, 9, 70, "Output",
   CellTags->"nlug:3.6.5",
   CellID->16056],
  Cell[469231, 15670, 427, 9, 70, "Text",
   CellTags->"nlug:3.6.5",
   CellID->20892],
  Cell[469661, 15681, 82, 2, 70, "Text",
   CellTags->"nlug:3.6.5",
   CellID->12250],
  Cell[469746, 15685, 198, 7, 70, "Input",
   CellTags->"nlug:3.6.5",
   CellID->16085],
  Cell[469947, 15694, 148, 5, 70, "Text",
   CellTags->"nlug:3.6.5",
   CellID->2420],
  Cell[470098, 15701, 314, 11, 70, "Input",
   CellTags->"nlug:3.6.5",
   CellID->9431],
  Cell[470415, 15714, 202, 5, 70, "Text",
   CellTags->"nlug:3.6.5",
   CellID->31516],
  Cell[470642, 15723, 147, 5, 70, "Input",
   CellTags->"nlug:3.6.5",
   CellID->28786],
  Cell[470792, 15730, 280, 9, 70, "Output",
   CellTags->"nlug:3.6.5",
   CellID->5034],
  Cell[471087, 15742, 447, 8, 70, "Text",
   CellTags->"nlug:3.6.5",
   CellID->7491],
  Cell[471537, 15752, 610, 15, 70, "Text",
   CellTags->"nlug:3.6.5",
   CellID->28647],
  Cell[472172, 15771, 204, 6, 70, "Input",
   CellTags->"nlug:3.6.5",
   CellID->365266020],
  Cell[472379, 15779, 1210, 36, 70, "Output",
   CellTags->"nlug:3.6.5",
   CellID->947],
  Cell[473604, 15818, 940, 23, 70, "Text",
   CellTags->"nlug:3.6.5",
   CellID->14889],
  Cell[474547, 15843, 755, 21, 70, "Text",
   CellTags->"nlug:3.6.5",
   CellID->31092],
  Cell[475305, 15866, 253, 8, 70, "Input",
   CellTags->"nlug:3.6.5",
   CellID->23296],
  Cell[475561, 15876, 694, 18, 70, "Text",
   CellTags->"nlug:3.6.5",
   CellID->163936306],
  Cell[476258, 15896, 840, 22, 70, "Input",
   CellTags->"nlug:3.6.5",
   CellID->28223],
  Cell[477101, 15920, 1360, 37, 70, "Text",
   CellTags->"nlug:3.6.5",
   CellID->32172],
  Cell[478464, 15959, 204, 7, 70, "Input",
   CellTags->"nlug:3.6.5",
   CellID->11048],
  Cell[478671, 15968, 252, 6, 70, "Text",
   CellTags->"nlug:3.6.5",
   CellID->23],
  Cell[478926, 15976, 105, 2, 70, "Text",
   CellTags->"nlug:3.6.5",
   CellID->22291],
  Cell[479034, 15980, 242, 8, 70, "Input",
   CellTags->"nlug:3.6.5",
   CellID->18166],
  Cell[479279, 15990, 258, 8, 70, "Text",
   CellTags->"nlug:3.6.5",
   CellID->30261]},
 "nlug:3.6.6"->{
  Cell[479574, 16003, 89, 2, 70, "Subsection",
   CellTags->"nlug:3.6.6",
   CellID->4981],
  Cell[479666, 16007, 953, 19, 70, "Text",
   CellTags->"nlug:3.6.6",
   CellID->941],
  Cell[480622, 16028, 787, 19, 70, "Text",
   CellTags->"nlug:3.6.6",
   CellID->16461],
  Cell[481412, 16049, 105, 2, 70, "Program",
   CellTags->"nlug:3.6.6",
   CellID->29443],
  Cell[481520, 16053, 1407, 39, 70, "Text",
   CellTags->"nlug:3.6.6",
   CellID->12245],
  Cell[482930, 16094, 316, 10, 70, "Text",
   CellTags->"nlug:3.6.6",
   CellID->3696],
  Cell[483271, 16108, 159, 5, 70, "Input",
   CellTags->"nlug:3.6.6",
   CellID->14229],
  Cell[483433, 16115, 171, 5, 70, "Output",
   CellTags->"nlug:3.6.6",
   CellID->123827466],
  Cell[483619, 16123, 368, 9, 70, "Text",
   CellTags->"nlug:3.6.6",
   CellID->23900],
  Cell[484012, 16136, 173, 5, 70, "Input",
   CellTags->"nlug:3.6.6",
   CellID->3650],
  Cell[484188, 16143, 271, 9, 70, "Output",
   CellTags->"nlug:3.6.6",
   CellID->6703],
  Cell[484474, 16155, 478, 13, 70, "Text",
   CellTags->"nlug:3.6.6",
   CellID->24828],
  Cell[484977, 16172, 623, 20, 70, "Input",
   CellTags->"nlug:3.6.6",
   CellID->14731],
  Cell[485603, 16194, 272, 8, 70, "Output",
   CellTags->"nlug:3.6.6",
   CellID->8941],
  Cell[485890, 16205, 284, 8, 70, "Text",
   CellTags->"nlug:3.6.6",
   CellID->24523],
  Cell[486199, 16217, 148, 5, 70, "Input",
   CellTags->"nlug:3.6.6",
   CellID->1942],
  Cell[486350, 16224, 119, 3, 70, "Output",
   CellTags->"nlug:3.6.6",
   CellID->22710],
  Cell[486484, 16230, 654, 17, 70, "Text",
   CellTags->"nlug:3.6.6",
   CellID->8388],
  Cell[487141, 16249, 134, 4, 70, "Input",
   CellTags->"nlug:3.6.6",
   CellID->6013]},
 "nlug:3.6.7"->{
  Cell[487312, 16258, 74, 2, 70, "Subsection",
   CellTags->"nlug:3.6.7",
   CellID->788],
  Cell[487389, 16262, 260, 9, 70, "Text",
   CellTags->"nlug:3.6.7",
   CellID->23479],
  Cell[487652, 16273, 185, 5, 70, "Text",
   CellTags->"nlug:3.6.7",
   CellID->8073]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"nlug:3.0", 490328, 16327},
 {"nlug:3.1.0", 491985, 16388},
 {"nlug:3.1.1", 492258, 16398},
 {"Loading .NET Assemblies and Types", 492819, 16417},
 {"nlug:3.1.2", 492963, 16421},
 {"Loading .NET Assemblies", 497430, 16572},
 {"Conversion of Types Between .NET and Mathematica", 497606, 16576},
 {"nlug:3.1.3", 497772, 16581},
 {"nlug:3.1.4", 498385, 16601},
 {"nlug:3.1.5", 499452, 16638},
 {"nlug:3.1.6", 502099, 16730},
 {"nlug:3.2.0", 505313, 16840},
 {"Enums", 510758, 17027},
 {"nlug:3.2.1", 510876, 17031},
 {"Out and Ref Parameters", 512590, 17089},
 {"nlug:3.2.2", 512727, 17093},
 {"nlug:3.2.3", 514528, 17154},
 {"Overloaded Operators", 518281, 17282},
 {"nlug:3.2.4", 518415, 17286},
 {"Casting", 519604, 17326},
 {"nlug:3.2.5", 519724, 17330},
 {"nlug:3.2.6", 526063, 17545},
 {"Exceptions", 527598, 17598},
 {"nlug:3.2.7", 527720, 17602},
 {"nlug:3.2.8", 530051, 17681},
 {"nlug:3.2.9", 532319, 17759},
 {"nlug:3.2.10", 534272, 17826},
 {".NET Console", 536786, 17912},
 {"nlug:3.2.11", 536913, 17916},
 {"Distributing Applications", 537864, 17947},
 {"nlug:3.2.12", 538005, 17951},
 {"nlug:3.2.13", 538883, 17980},
 {"nlug:3.3.0", 539890, 18014},
 {"Modal versus Modeless", 540449, 18033},
 {"nlug:3.3.1", 540587, 18037},
 {"Handling Events", 541525, 18068},
 {"nlug:3.3.2", 541656, 18072},
 {"Modal Windows", 544698, 18175},
 {"nlug:3.3.3", 544827, 18179},
 {"Modeless Windows", 547378, 18265},
 {"nlug:3.3.4", 547510, 18269},
 {"Sharing the Kernel", 548994, 18318},
 {"nlug:3.3.5", 549129, 18322},
 {"ShowNETWindow", 550158, 18356},
 {"nlug:3.3.6", 550401, 18363},
 {"nlug:3.3.7", 550620, 18370},
 {"nlug:3.3.8", 551209, 18389},
 {"nlug:3.4.0", 551846, 18411},
 {"nlug:3.4.1", 552400, 18430},
 {"nlug:3.4.2", 553230, 18458},
 {"nlug:3.4.3", 555240, 18526},
 {"nlug:3.4.4", 555439, 18533},
 {"nlug:3.4.5", 556266, 18561},
 {"nlug:3.4.6", 557398, 18598},
 {"Calling DLLS from Mathematica", 557907, 18615},
 {"nlug:3.5.0", 558054, 18619},
 {"How DLLs are Found", 559566, 18668},
 {"nlug:3.5.1", 559701, 18672},
 {"Specifying Arguments and Return Values", 560131, 18685},
 {"nlug:3.5.2", 560287, 18689},
 {"strings in DLLs", 568322, 18956},
 {"Declarations Requiring Special Attributes", 568488, 18960},
 {"nlug:3.5.3", 568647, 18964},
 {"DLL Example Files", 569799, 19001},
 {"nlug:3.5.4", 569933, 19005},
 {"COM", 570410, 19021},
 {"COM Introduction", 570517, 19025},
 {"nlug:3.6.0", 570649, 19029},
 {"nlug:3.6.1", 571136, 19045},
 {"Interop Assembly", 574331, 19151},
 {"nlug:3.6.2", 574465, 19155},
 {"nlug:3.6.3", 578589, 19292},
 {"nlug:3.6.4", 579989, 19339},
 {"Handling COM Events", 581799, 19400},
 {"nlug:3.6.5", 581936, 19404},
 {"nlug:3.6.6", 584560, 19492},
 {"nlug:3.6.7", 586273, 19550}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 180, 7, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[805, 34, 119, 5, 70, "Title",
 CellID->509267359],
Cell[CellGroupData[{
Cell[949, 43, 70, 2, 70, "Section",
 CellTags->"nlug:3.0",
 CellID->26930],
Cell[1022, 47, 899, 27, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->3826],
Cell[1924, 76, 782, 24, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->2852],
Cell[2709, 102, 726, 18, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->5675],
Cell[3438, 122, 622, 18, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->24177],
Cell[4063, 142, 515, 15, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->20734],
Cell[4581, 159, 112, 3, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->16620],
Cell[4696, 164, 175, 4, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->23893],
Cell[4874, 170, 109, 3, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->15023],
Cell[4986, 175, 190, 5, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->25940],
Cell[5179, 182, 192, 5, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->19959],
Cell[5374, 189, 209, 6, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->2118],
Cell[5586, 197, 196, 5, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->13028],
Cell[5785, 204, 192, 5, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->17376],
Cell[5980, 211, 109, 3, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->17945],
Cell[6092, 216, 192, 5, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->10453],
Cell[6287, 223, 181, 5, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->27035],
Cell[6471, 230, 177, 4, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->15565],
Cell[6651, 236, 116, 3, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->20826],
Cell[6770, 241, 184, 5, 70, "Text",
 CellTags->"nlug:3.0",
 CellID->15670]
}, Open  ]],
Cell[CellGroupData[{
Cell[6991, 251, 88, 2, 70, "Section",
 CellTags->"nlug:3.1.0",
 CellID->23489],
Cell[7082, 255, 222, 10, 70, "Text",
 CellTags->"nlug:3.1.0",
 CellID->4497],
Cell[7307, 267, 114, 3, 70, "Input",
 CellTags->"nlug:3.1.0",
 CellID->25338]
}, Open  ]],
Cell[CellGroupData[{
Cell[7458, 275, 86, 2, 70, "Section",
 CellTags->"nlug:3.1.1",
 CellID->25576],
Cell[7547, 279, 257, 9, 70, "Text",
 CellTags->"nlug:3.1.1",
 CellID->22674],
Cell[7807, 290, 117, 4, 70, "Input",
 CellTags->"nlug:3.1.1",
 CellID->20325],
Cell[7927, 296, 1107, 29, 70, "Text",
 CellTags->"nlug:3.1.1",
 CellID->31465],
Cell[9037, 327, 958, 30, 70, "DefinitionBox",
 CellTags->"nlug:3.1.1",
 CellID->23829],
Cell[9998, 359, 86, 2, 70, "Caption",
 CellTags->"nlug:3.1.1",
 CellID->2650]
}, Open  ]],
Cell[CellGroupData[{
Cell[10121, 366, 131, 2, 70, "Section",
 CellTags->{"Loading .NET Assemblies and Types", "nlug:3.1.2"},
 CellID->1113],
Cell[CellGroupData[{
Cell[10277, 372, 107, 2, 70, "Subsection",
 CellTags->{"Loading .NET Assemblies", "nlug:3.1.2"},
 CellID->20646],
Cell[10387, 376, 1020, 19, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->25443],
Cell[11410, 397, 777, 15, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->28914],
Cell[12190, 414, 1297, 28, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->12515],
Cell[13490, 444, 1160, 34, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->18787]
}, Open  ]],
Cell[CellGroupData[{
Cell[14687, 483, 70, 2, 70, "Subsection",
 CellTags->"nlug:3.1.2",
 CellID->90],
Cell[14760, 487, 473, 11, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->32197],
Cell[15236, 500, 724, 22, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->29569]
}, Open  ]],
Cell[CellGroupData[{
Cell[15997, 527, 77, 2, 70, "Subsection",
 CellTags->"nlug:3.1.2",
 CellID->2433],
Cell[16077, 531, 866, 25, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->24148],
Cell[16946, 558, 2070, 61, 70, "DefinitionBox",
 CellTags->"nlug:3.1.2",
 CellID->26130],
Cell[19019, 621, 78, 2, 70, "Caption",
 CellTags->"nlug:3.1.2",
 CellID->7204],
Cell[19100, 625, 302, 9, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->12862],
Cell[CellGroupData[{
Cell[19427, 638, 148, 4, 70, "Input",
 CellTags->"nlug:3.1.2",
 CellID->9836],
Cell[19578, 644, 169, 5, 70, "Output",
 CellTags->"nlug:3.1.2",
 CellID->18460]
}, Open  ]],
Cell[19762, 652, 634, 19, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->17230],
Cell[20399, 673, 613, 16, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->24611],
Cell[CellGroupData[{
Cell[21037, 693, 223, 6, 70, "Input",
 CellTags->"nlug:3.1.2",
 CellID->4309],
Cell[21263, 701, 168, 5, 70, "Output",
 CellTags->"nlug:3.1.2",
 CellID->4568]
}, Open  ]],
Cell[21446, 709, 192, 5, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->7030],
Cell[21641, 716, 600, 18, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->18138],
Cell[22244, 736, 170, 5, 70, "Input",
 CellTags->"nlug:3.1.2",
 CellID->24932],
Cell[22417, 743, 165, 5, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->7001],
Cell[22585, 750, 1368, 40, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->29102],
Cell[23956, 792, 174, 5, 70, "Input",
 CellTags->"nlug:3.1.2",
 CellID->16191],
Cell[24133, 799, 274, 6, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->3406]
}, Open  ]],
Cell[CellGroupData[{
Cell[24444, 810, 74, 2, 70, "Subsection",
 CellTags->"nlug:3.1.2",
 CellID->17804],
Cell[24521, 814, 1480, 42, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->8579],
Cell[26004, 858, 1604, 48, 70, "DefinitionBox",
 CellTags->"nlug:3.1.2",
 CellID->31673],
Cell[27611, 908, 74, 2, 70, "Caption",
 CellTags->"nlug:3.1.2",
 CellID->28210],
Cell[27688, 912, 239, 9, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->28965],
Cell[CellGroupData[{
Cell[27952, 925, 160, 5, 70, "Input",
 CellTags->"nlug:3.1.2",
 CellID->37],
Cell[28115, 932, 180, 5, 70, "Output",
 CellTags->"nlug:3.1.2",
 CellID->22219]
}, Open  ]],
Cell[28310, 940, 606, 19, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->9818],
Cell[28919, 961, 730, 19, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->25049]
}, Open  ]],
Cell[CellGroupData[{
Cell[29686, 985, 96, 2, 70, "Subsection",
 CellTags->"nlug:3.1.2",
 CellID->712],
Cell[29785, 989, 591, 17, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->28646],
Cell[30379, 1008, 826, 26, 70, "DefinitionBox",
 CellTags->"nlug:3.1.2",
 CellID->6718],
Cell[31208, 1036, 96, 2, 70, "Caption",
 CellTags->"nlug:3.1.2",
 CellID->25038]
}, Open  ]],
Cell[CellGroupData[{
Cell[31341, 1043, 108, 2, 70, "Subsection",
 CellTags->"nlug:3.1.2",
 CellID->9289],
Cell[31452, 1047, 1431, 34, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->2690],
Cell[32886, 1083, 1949, 52, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->9033],
Cell[34838, 1137, 1798, 51, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->14672],
Cell[36639, 1190, 712, 17, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->19989],
Cell[37354, 1209, 148, 6, 70, "Program",
 CellTags->"nlug:3.1.2",
 CellID->25453],
Cell[37505, 1217, 559, 20, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->24544],
Cell[38067, 1239, 310, 10, 70, "Text",
 CellTags->"nlug:3.1.2",
 CellID->20165],
Cell[38380, 1251, 824, 25, 70, "DefinitionBox",
 CellTags->"nlug:3.1.2",
 CellID->18503],
Cell[39207, 1278, 226, 9, 70, "Caption",
 CellTags->"nlug:3.1.2",
 CellID->28770]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39482, 1293, 223, 8, 70, "Section",
 CellTags->{"Conversion of Types Between .NET and Mathematica", "nlug:3.1.3"},
 
 CellID->31571],
Cell[39708, 1303, 1193, 36, 70, "Text",
 CellTags->"nlug:3.1.3",
 CellID->15060],
Cell[40904, 1341, 469, 14, 70, "Text",
 CellTags->"nlug:3.1.3",
 CellID->12104],
Cell[41376, 1357, 1732, 57, 70, "DefinitionBox",
 CellTags->"nlug:3.1.3",
 CellID->1716],
Cell[43111, 1416, 162, 7, 70, "Caption",
 CellTags->"nlug:3.1.3",
 CellID->14597],
Cell[43276, 1425, 598, 19, 70, "Text",
 CellTags->"nlug:3.1.3",
 CellID->13188]
}, Open  ]],
Cell[CellGroupData[{
Cell[43911, 1449, 75, 2, 70, "Section",
 CellTags->"nlug:3.1.4",
 CellID->7716],
Cell[43989, 1453, 972, 26, 70, "Text",
 CellTags->"nlug:3.1.4",
 CellID->25756],
Cell[44964, 1481, 878, 27, 70, "DefinitionBox",
 CellTags->"nlug:3.1.4",
 CellID->28],
Cell[45845, 1510, 85, 2, 70, "Caption",
 CellTags->"nlug:3.1.4",
 CellID->6929],
Cell[45933, 1514, 138, 6, 70, "Text",
 CellTags->"nlug:3.1.4",
 CellID->4930],
Cell[CellGroupData[{
Cell[46096, 1524, 184, 6, 70, "Input",
 CellTags->"nlug:3.1.4",
 CellID->23346],
Cell[46283, 1532, 279, 9, 70, "Output",
 CellTags->"nlug:3.1.4",
 CellID->3787]
}, Open  ]],
Cell[46577, 1544, 956, 25, 70, "Text",
 CellTags->"nlug:3.1.4",
 CellID->15094],
Cell[47536, 1571, 1034, 28, 70, "Text",
 CellTags->"nlug:3.1.4",
 CellID->26114],
Cell[48573, 1601, 609, 16, 70, "Text",
 CellTags->"nlug:3.1.4",
 CellID->2278],
Cell[49185, 1619, 309, 10, 70, "Input",
 CellTags->"nlug:3.1.4",
 CellID->23568],
Cell[49497, 1631, 673, 20, 70, "Text",
 CellTags->"nlug:3.1.4",
 CellID->30533]
}, Open  ]],
Cell[CellGroupData[{
Cell[50207, 1656, 98, 2, 70, "Section",
 CellTags->"nlug:3.1.5",
 CellID->9847],
Cell[CellGroupData[{
Cell[50330, 1662, 69, 2, 70, "Subsection",
 CellTags->"nlug:3.1.5",
 CellID->31622],
Cell[50402, 1666, 829, 20, 70, "Text",
 CellTags->"nlug:3.1.5",
 CellID->13925],
Cell[51234, 1688, 672, 17, 70, "Text",
 CellTags->"nlug:3.1.5",
 CellID->10002],
Cell[51909, 1707, 2107, 74, 70, "DefinitionBox",
 CellTags->"nlug:3.1.5",
 CellID->17120],
Cell[54019, 1783, 155, 7, 70, "Caption",
 CellTags->"nlug:3.1.5",
 CellID->28899],
Cell[54177, 1792, 653, 20, 70, "Text",
 CellTags->"nlug:3.1.5",
 CellID->16834],
Cell[54833, 1814, 395, 13, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.1.5",
 CellID->24804],
Cell[55231, 1829, 259, 8, 70, "Text",
 CellTags->"nlug:3.1.5",
 CellID->9969],
Cell[55493, 1839, 404, 12, 70, "Text",
 CellTags->"nlug:3.1.5",
 CellID->8283],
Cell[55900, 1853, 1197, 34, 70, "Text",
 CellTags->"nlug:3.1.5",
 CellID->28568],
Cell[CellGroupData[{
Cell[57122, 1891, 174, 5, 70, "Input",
 CellTags->"nlug:3.1.5",
 CellID->13538],
Cell[57299, 1898, 266, 9, 70, "Output",
 CellTags->"nlug:3.1.5",
 CellID->23474]
}, Open  ]],
Cell[57580, 1910, 458, 17, 70, "Text",
 CellTags->"nlug:3.1.5",
 CellID->5156],
Cell[58041, 1929, 160, 5, 70, "Input",
 CellTags->"nlug:3.1.5",
 CellID->29017],
Cell[58204, 1936, 211, 8, 70, "Text",
 CellTags->"nlug:3.1.5",
 CellID->24200],
Cell[58418, 1946, 179, 7, 70, "Input",
 CellTags->"nlug:3.1.5",
 CellID->32579],
Cell[58600, 1955, 784, 22, 70, "Text",
 CellTags->"nlug:3.1.5",
 CellID->16432],
Cell[59387, 1979, 898, 20, 70, "Text",
 CellTags->"nlug:3.1.5",
 CellID->16448],
Cell[60288, 2001, 225, 7, 70, "Input",
 CellTags->"nlug:3.1.5",
 CellID->13047],
Cell[60516, 2010, 846, 21, 70, "Text",
 CellTags->"nlug:3.1.5",
 CellID->4044],
Cell[61365, 2033, 148, 5, 70, "Input",
 CellTags->"nlug:3.1.5",
 CellID->29009]
}, Open  ]],
Cell[CellGroupData[{
Cell[61550, 2043, 88, 2, 70, "Subsection",
 CellTags->"nlug:3.1.5",
 CellID->24546],
Cell[61641, 2047, 667, 15, 70, "Text",
 CellTags->"nlug:3.1.5",
 CellID->10556],
Cell[62311, 2064, 237, 7, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.1.5",
 CellID->25270],
Cell[62551, 2073, 201, 5, 70, "Text",
 CellTags->"nlug:3.1.5",
 CellID->14241],
Cell[62755, 2080, 149, 5, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.1.5",
 CellID->12039],
Cell[62907, 2087, 243, 7, 70, "Text",
 CellTags->"nlug:3.1.5",
 CellID->14293],
Cell[63153, 2096, 147, 5, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.1.5",
 CellID->7196]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63349, 2107, 103, 2, 70, "Section",
 CellTags->"nlug:3.1.6",
 CellID->25375],
Cell[CellGroupData[{
Cell[63477, 2113, 72, 2, 70, "Subsection",
 CellTags->"nlug:3.1.6",
 CellID->667],
Cell[63552, 2117, 462, 13, 70, "Text",
 CellTags->"nlug:3.1.6",
 CellID->25392],
Cell[64017, 2132, 1606, 50, 70, "DefinitionBox",
 CellTags->"nlug:3.1.6",
 CellID->12032],
Cell[65626, 2184, 104, 2, 70, "Caption",
 CellTags->"nlug:3.1.6",
 CellID->17108],
Cell[65733, 2188, 258, 8, 70, "Text",
 CellTags->"nlug:3.1.6",
 CellID->8641],
Cell[65994, 2198, 161, 6, 70, "Text",
 CellTags->"nlug:3.1.6",
 CellID->29998],
Cell[66158, 2206, 141, 4, 70, "Input",
 CellTags->"nlug:3.1.6",
 CellID->11258],
Cell[66302, 2212, 653, 22, 70, "Text",
 CellTags->"nlug:3.1.6",
 CellID->12113],
Cell[66958, 2236, 244, 7, 70, "Input",
 CellTags->"nlug:3.1.6",
 CellID->15693],
Cell[67205, 2245, 132, 4, 70, "Text",
 CellTags->"nlug:3.1.6",
 CellID->24001],
Cell[67340, 2251, 206, 6, 70, "Input",
 CellTags->"nlug:3.1.6",
 CellID->9687],
Cell[67549, 2259, 244, 7, 70, "Text",
 CellTags->"nlug:3.1.6",
 CellID->30516],
Cell[67796, 2268, 225, 6, 70, "Input",
 CellTags->"nlug:3.1.6",
 CellID->21618],
Cell[68024, 2276, 1032, 30, 70, "DefinitionBox3Col",
 CellTags->"nlug:3.1.6",
 CellID->7718],
Cell[69059, 2308, 125, 6, 70, "Caption",
 CellTags->"nlug:3.1.6",
 CellID->23668],
Cell[69187, 2316, 894, 25, 70, "Text",
 CellTags->"nlug:3.1.6",
 CellID->20536],
Cell[70084, 2343, 167, 5, 70, "Input",
 CellTags->"nlug:3.1.6",
 CellID->9747],
Cell[70254, 2350, 768, 26, 70, "Text",
 CellTags->"nlug:3.1.6",
 CellID->6523],
Cell[71025, 2378, 295, 8, 70, "Input",
 CellTags->"nlug:3.1.6",
 CellID->1797]
}, Open  ]],
Cell[CellGroupData[{
Cell[71357, 2391, 85, 2, 70, "Subsection",
 CellTags->"nlug:3.1.6",
 CellID->13073],
Cell[71445, 2395, 1985, 68, 70, "DefinitionBox",
 CellTags->"nlug:3.1.6",
 CellID->11552],
Cell[73433, 2465, 101, 2, 70, "Caption",
 CellTags->"nlug:3.1.6",
 CellID->28615],
Cell[73537, 2469, 351, 9, 70, "Text",
 CellTags->"nlug:3.1.6",
 CellID->21256],
Cell[73891, 2480, 102, 3, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.1.6",
 CellID->11928],
Cell[73996, 2485, 1970, 62, 70, "Text",
 CellTags->"nlug:3.1.6",
 CellID->14115],
Cell[CellGroupData[{
Cell[75991, 2551, 184, 6, 70, "Input",
 CellTags->"nlug:3.1.6",
 CellID->2619],
Cell[76178, 2559, 174, 5, 70, "Output",
 CellTags->"nlug:3.1.6",
 CellID->20343]
}, Open  ]],
Cell[CellGroupData[{
Cell[76389, 2569, 165, 5, 70, "Input",
 CellTags->"nlug:3.1.6",
 CellID->30248],
Cell[76557, 2576, 279, 9, 70, "Output",
 CellTags->"nlug:3.1.6",
 CellID->18710]
}, Open  ]],
Cell[76851, 2588, 810, 29, 70, "Text",
 CellTags->"nlug:3.1.6",
 CellID->15544],
Cell[77664, 2619, 223, 8, 70, "Text",
 CellTags->"nlug:3.1.6",
 CellID->6210],
Cell[CellGroupData[{
Cell[77912, 2631, 130, 4, 70, "Input",
 CellTags->"nlug:3.1.6",
 CellID->302071484],
Cell[78045, 2637, 118, 3, 70, "Output",
 CellTags->"nlug:3.1.6",
 CellID->18040]
}, Open  ]],
Cell[CellGroupData[{
Cell[78200, 2645, 131, 4, 70, "Input",
 CellTags->"nlug:3.1.6",
 CellID->8337],
Cell[78334, 2651, 95, 3, 70, "Output",
 CellTags->"nlug:3.1.6",
 CellID->22012]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[78490, 2661, 98, 2, 70, "Section",
 CellTags->"nlug:3.2.0",
 CellID->14400],
Cell[CellGroupData[{
Cell[78613, 2667, 146, 6, 70, "Subsection",
 CellTags->"nlug:3.2.0",
 CellID->861],
Cell[78762, 2675, 1200, 34, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->13463],
Cell[79965, 2711, 1349, 39, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->17255],
Cell[81317, 2752, 789, 29, 70, "DefinitionBox",
 CellTags->"nlug:3.2.0",
 CellID->24814],
Cell[82109, 2783, 134, 6, 70, "Caption",
 CellTags->"nlug:3.2.0",
 CellID->22050],
Cell[82246, 2791, 76, 2, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->18968],
Cell[CellGroupData[{
Cell[82347, 2797, 227, 7, 70, "Input",
 CellTags->"nlug:3.2.0",
 CellID->31926],
Cell[82577, 2806, 266, 9, 70, "Output",
 CellTags->"nlug:3.2.0",
 CellID->24017]
}, Open  ]],
Cell[82858, 2818, 239, 8, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->8785],
Cell[83100, 2828, 302, 10, 70, "Input",
 CellTags->"nlug:3.2.0",
 CellID->25932],
Cell[83405, 2840, 202, 6, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->21270],
Cell[83610, 2848, 166, 6, 70, "Input",
 CellTags->"nlug:3.2.0",
 CellID->27894],
Cell[83779, 2856, 704, 21, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->8012],
Cell[CellGroupData[{
Cell[84508, 2881, 146, 5, 70, "Input",
 CellTags->"nlug:3.2.0",
 CellID->19292],
Cell[84657, 2888, 96, 3, 70, "Output",
 CellTags->"nlug:3.2.0",
 CellID->29984]
}, Open  ]],
Cell[84768, 2894, 606, 22, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->18536],
Cell[CellGroupData[{
Cell[85399, 2920, 182, 6, 70, "Input",
 CellTags->"nlug:3.2.0",
 CellID->3461],
Cell[85584, 2928, 95, 3, 70, "Output",
 CellTags->"nlug:3.2.0",
 CellID->12102]
}, Open  ]],
Cell[85694, 2934, 426, 12, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->11499],
Cell[CellGroupData[{
Cell[86145, 2950, 178, 6, 70, "Input",
 CellTags->"nlug:3.2.0",
 CellID->10417],
Cell[86326, 2958, 95, 3, 70, "Output",
 CellTags->"nlug:3.2.0",
 CellID->16109]
}, Open  ]],
Cell[86436, 2964, 672, 18, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->26752],
Cell[CellGroupData[{
Cell[87133, 2986, 193, 6, 70, "Input",
 CellTags->"nlug:3.2.0",
 CellID->19490],
Cell[87329, 2994, 95, 3, 70, "Output",
 CellTags->"nlug:3.2.0",
 CellID->20638]
}, Open  ]],
Cell[87439, 3000, 345, 12, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->944],
Cell[87787, 3014, 1102, 31, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->31966]
}, Open  ]],
Cell[CellGroupData[{
Cell[88926, 3050, 78, 2, 70, "Subsection",
 CellTags->"nlug:3.2.0",
 CellID->7770],
Cell[89007, 3054, 1881, 49, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->1603],
Cell[CellGroupData[{
Cell[90913, 3107, 183, 6, 70, "Input",
 CellTags->"nlug:3.2.0",
 CellID->20255],
Cell[91099, 3115, 278, 9, 70, "Output",
 CellTags->"nlug:3.2.0",
 CellID->437]
}, Open  ]],
Cell[91392, 3127, 189, 7, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->21922],
Cell[91584, 3136, 135, 4, 70, "Input",
 CellTags->"nlug:3.2.0",
 CellID->7487],
Cell[91722, 3142, 346, 10, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->10477],
Cell[CellGroupData[{
Cell[92093, 3156, 118, 4, 70, "Input",
 CellTags->"nlug:3.2.0",
 CellID->6209],
Cell[92214, 3162, 223, 8, 70, "Output",
 CellTags->"nlug:3.2.0",
 CellID->9563]
}, Open  ]],
Cell[92452, 3173, 2029, 68, 70, "DefinitionBox",
 CellTags->"nlug:3.2.0",
 CellID->30273],
Cell[94484, 3243, 88, 2, 70, "Caption",
 CellTags->"nlug:3.2.0",
 CellID->16031],
Cell[94575, 3247, 688, 19, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->2372],
Cell[95266, 3268, 766, 23, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->32586],
Cell[96035, 3293, 271, 9, 70, "Input",
 CellTags->"nlug:3.2.0",
 CellID->6091],
Cell[96309, 3304, 596, 21, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->10558],
Cell[96908, 3327, 753, 18, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->17392]
}, Open  ]],
Cell[CellGroupData[{
Cell[97698, 3350, 70, 2, 70, "Subsection",
 CellTags->"nlug:3.2.0",
 CellID->9963],
Cell[97771, 3354, 634, 16, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->17462],
Cell[98408, 3372, 1848, 53, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->15183],
Cell[100259, 3427, 853, 21, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->17415],
Cell[101115, 3450, 959, 24, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->3848],
Cell[102077, 3476, 283, 11, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->12535],
Cell[102363, 3489, 228, 10, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->27397],
Cell[102594, 3501, 447, 11, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.0",
 CellID->9025],
Cell[103044, 3514, 492, 14, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->13707],
Cell[103539, 3530, 885, 24, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.0",
 CellID->17184],
Cell[104427, 3556, 2185, 64, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->11444],
Cell[106615, 3622, 959, 31, 70, "DefinitionBox",
 CellTags->"nlug:3.2.0",
 CellID->23022],
Cell[107577, 3655, 144, 6, 70, "Caption",
 CellTags->"nlug:3.2.0",
 CellID->29073],
Cell[107724, 3663, 312, 9, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->29994],
Cell[108039, 3674, 396, 15, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.0",
 CellID->20873],
Cell[108438, 3691, 2121, 62, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->29404]
}, Open  ]],
Cell[CellGroupData[{
Cell[110596, 3758, 79, 2, 70, "Subsection",
 CellTags->"nlug:3.2.0",
 CellID->26559],
Cell[110678, 3762, 1672, 48, 70, "Text",
 CellTags->"nlug:3.2.0",
 CellID->18929]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[112399, 3816, 76, 2, 70, "Section",
 CellTags->{"Enums", "nlug:3.2.1"},
 CellID->27357],
Cell[112478, 3820, 858, 20, 70, "Text",
 CellTags->"nlug:3.2.1",
 CellID->32532],
Cell[113339, 3842, 588, 17, 70, "Text",
 CellTags->"nlug:3.2.1",
 CellID->16703],
Cell[CellGroupData[{
Cell[113952, 3863, 172, 5, 70, "Input",
 CellTags->"nlug:3.2.1",
 CellID->11962],
Cell[114127, 3870, 192, 6, 70, "Output",
 CellTags->"nlug:3.2.1",
 CellID->30982]
}, Open  ]],
Cell[114334, 3879, 132, 4, 70, "Text",
 CellTags->"nlug:3.2.1",
 CellID->5596],
Cell[CellGroupData[{
Cell[114491, 3887, 107, 3, 70, "Input",
 CellTags->"nlug:3.2.1",
 CellID->28759],
Cell[114601, 3892, 291, 10, 70, "Output",
 CellTags->"nlug:3.2.1",
 CellID->8541]
}, Open  ]],
Cell[114907, 3905, 525, 15, 70, "Text",
 CellTags->"nlug:3.2.1",
 CellID->4761],
Cell[CellGroupData[{
Cell[115457, 3924, 153, 4, 70, "Input",
 CellTags->"nlug:3.2.1",
 CellID->8425],
Cell[115613, 3930, 97, 3, 70, "Output",
 CellTags->"nlug:3.2.1",
 CellID->117436566]
}, Open  ]],
Cell[115725, 3936, 84, 2, 70, "Text",
 CellTags->"nlug:3.2.1",
 CellID->23415],
Cell[115812, 3940, 179, 7, 70, "Input",
 CellTags->"nlug:3.2.1",
 CellID->8752],
Cell[115994, 3949, 303, 7, 70, "Text",
 CellTags->"nlug:3.2.1",
 CellID->14524],
Cell[116300, 3958, 163, 6, 70, "Input",
 CellTags->"nlug:3.2.1",
 CellID->10018],
Cell[116466, 3966, 441, 12, 70, "Text",
 CellTags->"nlug:3.2.1",
 CellID->12093],
Cell[116910, 3980, 128, 5, 70, "Program",
 CellTags->"nlug:3.2.1",
 CellID->8374],
Cell[117041, 3987, 519, 17, 70, "Text",
 CellTags->"nlug:3.2.1",
 CellID->25569],
Cell[117563, 4006, 359, 11, 70, "Input",
 CellTags->"nlug:3.2.1",
 CellID->29899]
}, Open  ]],
Cell[CellGroupData[{
Cell[117959, 4022, 318, 11, 70, "Section",
 CellTags->{"Out and Ref Parameters", "nlug:3.2.2"},
 CellID->15993],
Cell[118280, 4035, 1200, 32, 70, "Text",
 CellTags->"nlug:3.2.2",
 CellID->13947],
Cell[119483, 4069, 199, 8, 70, "Text",
 CellTags->"nlug:3.2.2",
 CellID->6361],
Cell[119685, 4079, 247, 9, 70, "Program",
 CellTags->"nlug:3.2.2",
 CellID->28928],
Cell[119935, 4090, 860, 24, 70, "Text",
 CellTags->"nlug:3.2.2",
 CellID->3959],
Cell[120798, 4116, 563, 16, 70, "Text",
 CellTags->"nlug:3.2.2",
 CellID->4415],
Cell[121364, 4134, 166, 5, 70, "Text",
 CellTags->"nlug:3.2.2",
 CellID->16016],
Cell[CellGroupData[{
Cell[121555, 4143, 309, 9, 70, "Input",
 CellTags->"nlug:3.2.2",
 CellID->15],
Cell[121867, 4154, 94, 3, 70, "Output",
 CellTags->"nlug:3.2.2",
 CellID->31466]
}, Open  ]],
Cell[121976, 4160, 237, 7, 70, "Text",
 CellTags->"nlug:3.2.2",
 CellID->14662],
Cell[CellGroupData[{
Cell[122238, 4171, 94, 3, 70, "Input",
 CellTags->"nlug:3.2.2",
 CellID->27292],
Cell[122335, 4176, 93, 3, 70, "Output",
 CellTags->"nlug:3.2.2",
 CellID->26058]
}, Open  ]],
Cell[122443, 4182, 218, 7, 70, "Text",
 CellTags->"nlug:3.2.2",
 CellID->2398],
Cell[CellGroupData[{
Cell[122686, 4193, 238, 7, 70, "Input",
 CellTags->"nlug:3.2.2",
 CellID->22331],
Cell[122927, 4202, 244, 7, 70, "Message",
 CellTags->"nlug:3.2.2",
 CellID->7179],
Cell[123174, 4211, 99, 3, 70, "Output",
 CellTags->"nlug:3.2.2",
 CellID->31188]
}, Open  ]],
Cell[123288, 4217, 600, 16, 70, "Text",
 CellTags->"nlug:3.2.2",
 CellID->30073],
Cell[123891, 4235, 405, 12, 70, "Text",
 CellTags->"nlug:3.2.2",
 CellID->13946],
Cell[CellGroupData[{
Cell[124321, 4251, 172, 5, 70, "Input",
 CellTags->"nlug:3.2.2",
 CellID->16089],
Cell[124496, 4258, 94, 3, 70, "Output",
 CellTags->"nlug:3.2.2",
 CellID->19980]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[124639, 4267, 290, 10, 70, "Section",
 CellTags->"nlug:3.2.3",
 CellID->18481],
Cell[CellGroupData[{
Cell[124954, 4281, 84, 2, 70, "Subsection",
 CellTags->"nlug:3.2.3",
 CellID->16500],
Cell[125041, 4285, 1602, 52, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->18880],
Cell[126646, 4339, 911, 21, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->9487],
Cell[127560, 4362, 527, 14, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->1341],
Cell[128090, 4378, 762, 24, 70, "DefinitionBox",
 CellTags->"nlug:3.2.3",
 CellID->18261],
Cell[128855, 4404, 302, 11, 70, "Caption",
 CellTags->"nlug:3.2.3",
 CellID->28241]
}, Open  ]],
Cell[CellGroupData[{
Cell[129194, 4420, 80, 2, 70, "Subsection",
 CellTags->"nlug:3.2.3",
 CellID->12798],
Cell[129277, 4424, 578, 15, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->31689],
Cell[CellGroupData[{
Cell[129880, 4443, 391, 12, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.3",
 CellID->25573],
Cell[130274, 4457, 180, 6, 70, "Output",
 CellTags->"nlug:3.2.3",
 CellID->3908]
}, Open  ]],
Cell[130469, 4466, 473, 16, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->1409],
Cell[CellGroupData[{
Cell[130967, 4486, 278, 10, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.3",
 CellID->3950],
Cell[131248, 4498, 194, 7, 70, "Output",
 CellTags->"nlug:3.2.3",
 CellID->27308]
}, Open  ]],
Cell[131457, 4508, 1221, 32, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->28941],
Cell[132681, 4542, 401, 11, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->19467],
Cell[CellGroupData[{
Cell[133107, 4557, 286, 10, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.3",
 CellID->3425],
Cell[133396, 4569, 267, 8, 70, "Output",
 CellTags->"nlug:3.2.3",
 CellID->15450]
}, Open  ]],
Cell[133678, 4580, 263, 9, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->22704],
Cell[CellGroupData[{
Cell[133966, 4593, 327, 11, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.3",
 CellID->16736],
Cell[134296, 4606, 194, 7, 70, "Output",
 CellTags->"nlug:3.2.3",
 CellID->25067]
}, Open  ]],
Cell[134505, 4616, 562, 17, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->30054],
Cell[135070, 4635, 1071, 27, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->3285]
}, Open  ]],
Cell[CellGroupData[{
Cell[136178, 4667, 84, 2, 70, "Subsection",
 CellTags->"nlug:3.2.3",
 CellID->32085],
Cell[136265, 4671, 729, 20, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->16921],
Cell[136997, 4693, 1358, 37, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->16628],
Cell[CellGroupData[{
Cell[138380, 4734, 238, 7, 70, "Input",
 CellTags->"nlug:3.2.3",
 CellID->27935],
Cell[138621, 4743, 270, 8, 70, "Output",
 CellTags->"nlug:3.2.3",
 CellID->32215]
}, Open  ]],
Cell[138906, 4754, 173, 7, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->7604],
Cell[CellGroupData[{
Cell[139104, 4765, 138, 4, 70, "Input",
 CellTags->"nlug:3.2.3",
 CellID->21244],
Cell[139245, 4771, 101, 3, 70, "Output",
 CellTags->"nlug:3.2.3",
 CellID->5050]
}, Open  ]],
Cell[139361, 4777, 663, 21, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->4655],
Cell[140027, 4800, 1115, 31, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->28019],
Cell[141145, 4833, 90, 2, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->19881],
Cell[CellGroupData[{
Cell[141260, 4839, 192, 6, 70, "Input",
 CellTags->"nlug:3.2.3",
 CellID->13619],
Cell[141455, 4847, 282, 9, 70, "Output",
 CellTags->"nlug:3.2.3",
 CellID->2948]
}, Open  ]],
Cell[141752, 4859, 85, 2, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->12656],
Cell[141840, 4863, 256, 9, 70, "Input",
 CellTags->"nlug:3.2.3",
 CellID->5631],
Cell[142099, 4874, 269, 9, 70, "Text",
 CellTags->"nlug:3.2.3",
 CellID->12941],
Cell[CellGroupData[{
Cell[142393, 4887, 146, 4, 70, "Input",
 CellTags->"nlug:3.2.3",
 CellID->22178],
Cell[142542, 4893, 225, 7, 70, "Output",
 CellTags->"nlug:3.2.3",
 CellID->13273]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[142828, 4907, 106, 2, 70, "Section",
 CellTags->{"Overloaded Operators", "nlug:3.2.4"},
 CellID->18254],
Cell[142937, 4911, 660, 17, 70, "Text",
 CellTags->"nlug:3.2.4",
 CellID->618],
Cell[143600, 4930, 238, 7, 70, "Program",
 CellTags->"nlug:3.2.4",
 CellID->16800],
Cell[143841, 4939, 468, 11, 70, "Text",
 CellTags->"nlug:3.2.4",
 CellID->4429],
Cell[144312, 4952, 398, 14, 70, "Text",
 CellTags->"nlug:3.2.4",
 CellID->7561],
Cell[CellGroupData[{
Cell[144735, 4970, 578, 19, 70, "Input",
 CellTags->"nlug:3.2.4",
 CellID->23932],
Cell[145316, 4991, 108, 3, 70, "Output",
 CellTags->"nlug:3.2.4",
 CellID->11358]
}, Open  ]],
Cell[145439, 4997, 879, 22, 70, "Text",
 CellTags->"nlug:3.2.4",
 CellID->7546],
Cell[CellGroupData[{
Cell[146343, 5023, 137, 3, 70, "Input",
 CellTags->"nlug:3.2.4",
 CellID->21260],
Cell[146483, 5028, 2084, 57, 70, "Output",
 CellTags->"nlug:3.2.4",
 CellID->28943]
}, Open  ]],
Cell[148582, 5088, 536, 17, 70, "Text",
 CellTags->"nlug:3.2.4",
 CellID->3723],
Cell[CellGroupData[{
Cell[149143, 5109, 217, 7, 70, "Input",
 CellTags->"nlug:3.2.4",
 CellID->29817],
Cell[149363, 5118, 108, 3, 70, "Output",
 CellTags->"nlug:3.2.4",
 CellID->22712]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[149520, 5127, 80, 2, 70, "Section",
 CellTags->{"Casting", "nlug:3.2.5"},
 CellID->16712],
Cell[CellGroupData[{
Cell[149625, 5133, 75, 2, 70, "Subsection",
 CellTags->"nlug:3.2.5",
 CellID->20880],
Cell[149703, 5137, 916, 20, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->12526],
Cell[150622, 5159, 179, 8, 70, "Program",
 CellTags->"nlug:3.2.5",
 CellID->28959],
Cell[150804, 5169, 787, 23, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->10460],
Cell[151594, 5194, 274, 15, 70, "Program",
 CellTags->"nlug:3.2.5",
 CellID->7977],
Cell[151871, 5211, 330, 11, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->4200],
Cell[152204, 5224, 493, 14, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->31274],
Cell[152700, 5240, 1735, 48, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->5783],
Cell[154438, 5290, 717, 19, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->15781],
Cell[155158, 5311, 709, 20, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->30506],
Cell[155870, 5333, 122, 3, 70, "BulletedText",
 CellTags->"nlug:3.2.5",
 CellID->4987],
Cell[155995, 5338, 199, 5, 70, "BulletedText",
 CellTags->"nlug:3.2.5",
 CellID->522560435],
Cell[CellGroupData[{
Cell[156219, 5347, 146, 4, 70, "BulletedText",
 CellTags->"nlug:3.2.5",
 CellID->803030715],
Cell[156368, 5353, 535, 11, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->9501],
Cell[156906, 5366, 979, 23, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->14568],
Cell[157888, 5391, 923, 30, 70, "DefinitionBox",
 CellTags->"nlug:3.2.5",
 CellID->28192],
Cell[158814, 5423, 148, 6, 70, "Caption",
 CellTags->"nlug:3.2.5",
 CellID->23714],
Cell[158965, 5431, 302, 12, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->1741]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[159316, 5449, 104, 2, 70, "Subsection",
 CellTags->"nlug:3.2.5",
 CellID->1705],
Cell[159423, 5453, 353, 9, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->11694],
Cell[159779, 5464, 237, 11, 70, "Program",
 CellTags->"nlug:3.2.5",
 CellID->8130],
Cell[160019, 5477, 487, 16, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->373435199],
Cell[160509, 5495, 239, 7, 70, "Program",
 CellTags->"nlug:3.2.5",
 CellID->7614],
Cell[160751, 5504, 564, 17, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->26598],
Cell[161318, 5523, 564, 20, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->17139],
Cell[CellGroupData[{
Cell[161907, 5547, 183, 6, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.5",
 CellID->29546],
Cell[162093, 5555, 261, 8, 70, "Output",
 CellTags->"nlug:3.2.5",
 CellID->4762]
}, Open  ]],
Cell[CellGroupData[{
Cell[162391, 5568, 222, 7, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.5",
 CellID->767],
Cell[162616, 5577, 263, 8, 70, "Output",
 CellTags->"nlug:3.2.5",
 CellID->26854]
}, Open  ]],
Cell[CellGroupData[{
Cell[162916, 5590, 168, 6, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.5",
 CellID->28448],
Cell[163087, 5598, 122, 4, 70, "Output",
 CellTags->"nlug:3.2.5",
 CellID->23828]
}, Open  ]],
Cell[163224, 5605, 111, 2, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->22530],
Cell[CellGroupData[{
Cell[163360, 5611, 184, 6, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.5",
 CellID->1224],
Cell[163547, 5619, 94, 3, 70, "Output",
 CellTags->"nlug:3.2.5",
 CellID->8692]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[163690, 5628, 96, 2, 70, "Subsection",
 CellTags->"nlug:3.2.5",
 CellID->11114],
Cell[163789, 5632, 1118, 27, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->18887],
Cell[164910, 5661, 590, 31, 70, "Program",
 CellTags->"nlug:3.2.5",
 CellID->25960],
Cell[165503, 5694, 505, 16, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->31114],
Cell[166011, 5712, 216, 6, 70, "Program",
 CellTags->"nlug:3.2.5",
 CellID->26245],
Cell[166230, 5720, 168, 7, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->18464],
Cell[166401, 5729, 605, 18, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.5",
 CellID->31643],
Cell[167009, 5749, 1096, 32, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->8819],
Cell[CellGroupData[{
Cell[168130, 5785, 224, 7, 70, "Input",
 CellTags->"nlug:3.2.5",
 CellID->19326],
Cell[168357, 5794, 263, 8, 70, "Output",
 CellTags->"nlug:3.2.5",
 CellID->4948]
}, Open  ]],
Cell[CellGroupData[{
Cell[168657, 5807, 152, 5, 70, "Input",
 CellTags->"nlug:3.2.5",
 CellID->3188015],
Cell[168812, 5814, 265, 7, 70, "Message",
 CellTags->"nlug:3.2.5",
 CellID->1863],
Cell[169080, 5823, 98, 3, 70, "Output",
 CellTags->"nlug:3.2.5",
 CellID->15970]
}, Open  ]],
Cell[169193, 5829, 144, 6, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->21455],
Cell[CellGroupData[{
Cell[169362, 5839, 246, 7, 70, "Input",
 CellTags->"nlug:3.2.5",
 CellID->23360],
Cell[169611, 5848, 96, 3, 70, "Output",
 CellTags->"nlug:3.2.5",
 CellID->17908]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[169756, 5857, 94, 2, 70, "Subsection",
 CellTags->"nlug:3.2.5",
 CellID->14898],
Cell[169853, 5861, 1056, 24, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->23063],
Cell[170912, 5887, 372, 10, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->30584],
Cell[171287, 5899, 176, 10, 70, "Program",
 CellTags->"nlug:3.2.5",
 CellID->3925],
Cell[171466, 5911, 284, 8, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->558],
Cell[171753, 5921, 163, 6, 70, "Program",
 CellTags->"nlug:3.2.5",
 CellID->6914],
Cell[CellGroupData[{
Cell[171941, 5931, 264, 8, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.5",
 CellID->23130],
Cell[172208, 5941, 276, 9, 70, "Output",
 CellTags->"nlug:3.2.5",
 CellID->9479]
}, Open  ]],
Cell[172499, 5953, 310, 10, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->30803],
Cell[CellGroupData[{
Cell[172834, 5967, 140, 5, 70, "Input",
 CellTags->"nlug:3.2.5",
 CellID->15399],
Cell[172977, 5974, 313, 9, 70, "Message",
 CellTags->"nlug:3.2.5",
 CellID->28785],
Cell[173293, 5985, 98, 3, 70, "Output",
 CellTags->"nlug:3.2.5",
 CellID->27000]
}, Open  ]],
Cell[173406, 5991, 915, 25, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->15651],
Cell[174324, 6018, 138, 6, 70, "Program",
 CellTags->"nlug:3.2.5",
 CellID->17554],
Cell[174465, 6026, 427, 12, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->10980],
Cell[CellGroupData[{
Cell[174917, 6042, 297, 10, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.5",
 CellID->13888],
Cell[175217, 6054, 93, 3, 70, "Output",
 CellTags->"nlug:3.2.5",
 CellID->31908]
}, Open  ]],
Cell[175325, 6060, 1003, 17, 70, "Text",
 CellTags->"nlug:3.2.5",
 CellID->17852]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[176377, 6083, 68, 2, 70, "Section",
 CellTags->"nlug:3.2.6",
 CellID->24524],
Cell[176448, 6087, 492, 13, 70, "Text",
 CellTags->"nlug:3.2.6",
 CellID->18442],
Cell[176943, 6102, 331, 18, 70, "Program",
 CellTags->"nlug:3.2.6",
 CellID->21154],
Cell[177277, 6122, 646, 15, 70, "Text",
 CellTags->"nlug:3.2.6",
 CellID->19217],
Cell[177926, 6139, 128, 8, 70, "Program",
 CellTags->"nlug:3.2.6",
 CellID->12940],
Cell[178057, 6149, 210, 7, 70, "Text",
 CellTags->"nlug:3.2.6",
 CellID->32112],
Cell[178270, 6158, 282, 9, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.6",
 CellID->32184],
Cell[178555, 6169, 743, 21, 70, "Text",
 CellTags->"nlug:3.2.6",
 CellID->27449],
Cell[179301, 6192, 325, 8, 70, "Text",
 CellTags->"nlug:3.2.6",
 CellID->25628],
Cell[CellGroupData[{
Cell[179651, 6204, 282, 8, 70, "Input",
 CellTags->"nlug:3.2.6",
 CellID->20463],
Cell[179936, 6214, 282, 9, 70, "Output",
 CellTags->"nlug:3.2.6",
 CellID->30963]
}, Open  ]],
Cell[180233, 6226, 151, 5, 70, "Text",
 CellTags->"nlug:3.2.6",
 CellID->10397],
Cell[CellGroupData[{
Cell[180409, 6235, 124, 4, 70, "Input",
 CellTags->"nlug:3.2.6",
 CellID->2287],
Cell[180536, 6241, 95, 3, 70, "Output",
 CellTags->"nlug:3.2.6",
 CellID->3000]
}, Open  ]],
Cell[180646, 6247, 784, 20, 70, "Text",
 CellTags->"nlug:3.2.6",
 CellID->786],
Cell[CellGroupData[{
Cell[181455, 6271, 150, 5, 70, "Input",
 CellTags->"nlug:3.2.6",
 CellID->7443],
Cell[181608, 6278, 95, 3, 70, "Output",
 CellTags->"nlug:3.2.6",
 CellID->4438]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[181752, 6287, 85, 2, 70, "Section",
 CellTags->{"Exceptions", "nlug:3.2.7"},
 CellID->4946],
Cell[CellGroupData[{
Cell[181862, 6293, 89, 2, 70, "Subsection",
 CellTags->"nlug:3.2.7",
 CellID->11921],
Cell[181954, 6297, 373, 10, 70, "Text",
 CellTags->"nlug:3.2.7",
 CellID->21680],
Cell[CellGroupData[{
Cell[182352, 6311, 229, 6, 70, "Input",
 CellTags->"nlug:3.2.7",
 CellID->14636],
Cell[182584, 6319, 491, 10, 70, "Message",
 CellTags->"nlug:3.2.7",
 CellID->3036],
Cell[183078, 6331, 99, 3, 70, "Output",
 CellTags->"nlug:3.2.7",
 CellID->17745]
}, Open  ]],
Cell[183192, 6337, 253, 9, 70, "Text",
 CellTags->"nlug:3.2.7",
 CellID->11925],
Cell[183448, 6348, 361, 9, 70, "Text",
 CellTags->"nlug:3.2.7",
 CellID->29523]
}, Open  ]],
Cell[CellGroupData[{
Cell[183846, 6362, 77, 2, 70, "Subsection",
 CellTags->"nlug:3.2.7",
 CellID->7976],
Cell[183926, 6366, 1111, 29, 70, "Text",
 CellTags->"nlug:3.2.7",
 CellID->31342],
Cell[CellGroupData[{
Cell[185062, 6399, 152, 5, 70, "Input",
 CellTags->"nlug:3.2.7",
 CellID->9599],
Cell[185217, 6406, 300, 10, 70, "Output",
 CellTags->"nlug:3.2.7",
 CellID->8724]
}, Open  ]],
Cell[185532, 6419, 179, 6, 70, "Text",
 CellTags->"nlug:3.2.7",
 CellID->21929],
Cell[CellGroupData[{
Cell[185736, 6429, 158, 5, 70, "Input",
 CellTags->"nlug:3.2.7",
 CellID->5851],
Cell[185897, 6436, 303, 10, 70, "Output",
 CellTags->"nlug:3.2.7",
 CellID->30628]
}, Open  ]],
Cell[186215, 6449, 263, 6, 70, "Text",
 CellTags->"nlug:3.2.7",
 CellID->32667],
Cell[CellGroupData[{
Cell[186503, 6459, 134, 4, 70, "Input",
 CellTags->"nlug:3.2.7",
 CellID->25198],
Cell[186640, 6465, 276, 9, 70, "Output",
 CellTags->"nlug:3.2.7",
 CellID->7357]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[186965, 6480, 87, 2, 70, "Subsection",
 CellTags->"nlug:3.2.7",
 CellID->3241],
Cell[187055, 6484, 780, 23, 70, "Text",
 CellTags->"nlug:3.2.7",
 CellID->19150],
Cell[187838, 6509, 868, 22, 70, "Text",
 CellTags->"nlug:3.2.7",
 CellID->26452],
Cell[188709, 6533, 528, 16, 70, "Text",
 CellTags->"nlug:3.2.7",
 CellID->19149],
Cell[189240, 6551, 316, 9, 70, "Input",
 CellTags->"nlug:3.2.7",
 CellID->31600],
Cell[189559, 6562, 340, 10, 70, "Text",
 CellTags->"nlug:3.2.7",
 CellID->1491],
Cell[189902, 6574, 207, 8, 70, "Input",
 CellTags->"nlug:3.2.7",
 CellID->18811],
Cell[190112, 6584, 616, 17, 70, "Text",
 CellTags->"nlug:3.2.7",
 CellID->28414]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[190777, 6607, 72, 2, 70, "Section",
 CellTags->"nlug:3.2.8",
 CellID->25949],
Cell[190852, 6611, 161, 5, 70, "Text",
 CellTags->"nlug:3.2.8",
 CellID->12926],
Cell[191016, 6618, 352, 16, 70, "Program",
 CellTags->"nlug:3.2.8",
 CellID->224963599],
Cell[191371, 6636, 525, 16, 70, "Text",
 CellTags->"nlug:3.2.8",
 CellID->21591],
Cell[CellGroupData[{
Cell[191921, 6656, 216, 7, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.8",
 CellID->12848],
Cell[192140, 6665, 180, 5, 70, "Output",
 CellTags->"nlug:3.2.8",
 CellID->5035]
}, Open  ]],
Cell[192335, 6673, 312, 11, 70, "Text",
 CellTags->"nlug:3.2.8",
 CellID->17691],
Cell[CellGroupData[{
Cell[192672, 6688, 208, 7, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.8",
 CellID->6744],
Cell[192883, 6697, 280, 9, 70, "Output",
 CellTags->"nlug:3.2.8",
 CellID->23658]
}, Open  ]],
Cell[193178, 6709, 403, 13, 70, "Text",
 CellTags->"nlug:3.2.8",
 CellID->5512],
Cell[193584, 6724, 115, 5, 70, "Program",
 CellTags->"nlug:3.2.8",
 CellID->24098],
Cell[193702, 6731, 474, 15, 70, "Text",
 CellTags->"nlug:3.2.8",
 CellID->4772],
Cell[194179, 6748, 135, 4, 70, "Text",
 CellTags->"nlug:3.2.8",
 CellID->19355],
Cell[CellGroupData[{
Cell[194339, 6756, 150, 5, 70, "Input",
 CellTags->"nlug:3.2.8",
 CellID->22771],
Cell[194492, 6763, 92, 3, 70, "Output",
 CellTags->"nlug:3.2.8",
 CellID->5409]
}, Open  ]],
Cell[194599, 6769, 345, 12, 70, "Text",
 CellTags->"nlug:3.2.8",
 CellID->19753],
Cell[CellGroupData[{
Cell[194969, 6785, 138, 4, 70, "Input",
 CellTags->"nlug:3.2.8",
 CellID->21448],
Cell[195110, 6791, 92, 3, 70, "Output",
 CellTags->"nlug:3.2.8",
 CellID->5745]
}, Open  ]],
Cell[195217, 6797, 440, 9, 70, "Text",
 CellTags->"nlug:3.2.8",
 CellID->25304],
Cell[195660, 6808, 883, 26, 70, "Text",
 CellTags->"nlug:3.2.8",
 CellID->14512],
Cell[196546, 6836, 287, 10, 70, "Input",
 CellTags->"nlug:3.2.8",
 CellID->23916],
Cell[196836, 6848, 363, 13, 70, "Text",
 CellTags->"nlug:3.2.8",
 CellID->13855],
Cell[CellGroupData[{
Cell[197224, 6865, 179, 5, 70, "Input",
 CellTags->"nlug:3.2.8",
 CellID->27198],
Cell[197406, 6872, 152, 4, 70, "Output",
 CellTags->"nlug:3.2.8",
 CellID->6762]
}, Open  ]],
Cell[197573, 6879, 520, 16, 70, "Text",
 CellTags->"nlug:3.2.8",
 CellID->20157]
}, Open  ]],
Cell[CellGroupData[{
Cell[198130, 6900, 73, 2, 70, "Section",
 CellTags->"nlug:3.2.9",
 CellID->17016],
Cell[198206, 6904, 1034, 28, 70, "Text",
 CellTags->"nlug:3.2.9",
 CellID->18664],
Cell[CellGroupData[{
Cell[199265, 6936, 197, 6, 70, "Input",
 CellTags->"nlug:3.2.9",
 CellID->9859],
Cell[199465, 6944, 264, 8, 70, "Output",
 CellTags->"nlug:3.2.9",
 CellID->22686]
}, Open  ]],
Cell[199744, 6955, 457, 15, 70, "Input",
 CellTags->"nlug:3.2.9",
 CellID->18551],
Cell[200204, 6972, 254, 9, 70, "Text",
 CellTags->"nlug:3.2.9",
 CellID->29087],
Cell[CellGroupData[{
Cell[200483, 6985, 223, 7, 70, "Input",
 CellTags->"nlug:3.2.9",
 CellID->10872],
Cell[200709, 6994, 264, 8, 70, "Output",
 CellTags->"nlug:3.2.9",
 CellID->18345]
}, Open  ]],
Cell[200988, 7005, 811, 25, 70, "DefinitionBox",
 CellTags->"nlug:3.2.9",
 CellID->10963],
Cell[201802, 7032, 110, 5, 70, "Caption",
 CellTags->"nlug:3.2.9",
 CellID->23376],
Cell[201915, 7039, 1049, 29, 70, "Text",
 CellTags->"nlug:3.2.9",
 CellID->23901],
Cell[202967, 7070, 101, 2, 70, "Program",
 CellTags->"nlug:3.2.9",
 CellID->30813],
Cell[203071, 7074, 497, 13, 70, "Text",
 CellTags->"nlug:3.2.9",
 CellID->28889],
Cell[203571, 7089, 166, 5, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.9",
 CellID->25632],
Cell[CellGroupData[{
Cell[203762, 7098, 166, 5, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.9",
 CellID->2188],
Cell[203931, 7105, 149, 5, 70, "Output",
 CellTags->"nlug:3.2.9",
 CellID->9012]
}, Open  ]],
Cell[204095, 7113, 301, 8, 70, "Text",
 CellTags->"nlug:3.2.9",
 CellID->29539],
Cell[204399, 7123, 117, 5, 70, "Program",
 CellTags->"nlug:3.2.9",
 CellID->14990],
Cell[204519, 7130, 809, 24, 70, "Text",
 CellTags->"nlug:3.2.9",
 CellID->13657],
Cell[205331, 7156, 228, 7, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.9",
 CellID->11718],
Cell[205562, 7165, 603, 17, 70, "Text",
 CellTags->"nlug:3.2.9",
 CellID->15615]
}, Open  ]],
Cell[CellGroupData[{
Cell[206202, 7187, 76, 2, 70, "Section",
 CellTags->"nlug:3.2.10",
 CellID->21660],
Cell[206281, 7191, 1042, 31, 70, "Text",
 CellTags->"nlug:3.2.10",
 CellID->27829],
Cell[207326, 7224, 639, 18, 70, "DefinitionBox",
 CellID->1790203360],
Cell[207968, 7244, 77, 1, 70, "Caption",
 CellID->1701977050],
Cell[208048, 7247, 152, 5, 70, "Text",
 CellTags->"nlug:3.2.10",
 CellID->17065],
Cell[208203, 7254, 179, 5, 70, "ItemizedText",
 CellTags->"nlug:3.2.10",
 CellID->29881],
Cell[CellGroupData[{
Cell[208407, 7263, 187, 5, 70, "ItemizedText",
 CellTags->"nlug:3.2.10",
 CellID->16474],
Cell[208597, 7270, 997, 31, 70, "Program",
 CellTags->"nlug:3.2.10",
 CellID->19380],
Cell[209597, 7303, 103, 2, 70, "Text",
 CellTags->"nlug:3.2.10",
 CellID->25570],
Cell[209703, 7307, 414, 23, 70, "Program",
 CellTags->"nlug:3.2.10",
 CellID->7639],
Cell[210120, 7332, 206, 6, 70, "Text",
 CellTags->"nlug:3.2.10",
 CellID->5352],
Cell[210329, 7340, 310, 11, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.10",
 CellID->31641],
Cell[CellGroupData[{
Cell[210664, 7355, 230, 8, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.10",
 CellID->29644],
Cell[210897, 7365, 279, 9, 70, "Output",
 CellTags->"nlug:3.2.10",
 CellID->5775]
}, Open  ]],
Cell[211191, 7377, 861, 28, 70, "Text",
 CellTags->"nlug:3.2.10",
 CellID->7072],
Cell[CellGroupData[{
Cell[212077, 7409, 160, 5, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.10",
 CellID->22033],
Cell[212240, 7416, 176, 5, 70, "Output",
 CellTags->"nlug:3.2.10",
 CellID->21694]
}, Open  ]],
Cell[212431, 7424, 489, 16, 70, "Text",
 CellTags->"nlug:3.2.10",
 CellID->28141],
Cell[CellGroupData[{
Cell[212945, 7444, 165, 6, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.10",
 CellID->17709],
Cell[213113, 7452, 175, 5, 70, "Output",
 CellTags->"nlug:3.2.10",
 CellID->28595]
}, Open  ]],
Cell[CellGroupData[{
Cell[213325, 7462, 228, 8, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.10",
 CellID->21826],
Cell[213556, 7472, 177, 5, 70, "Output",
 CellTags->"nlug:3.2.10",
 CellID->21345]
}, Open  ]],
Cell[CellGroupData[{
Cell[213770, 7482, 166, 6, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.10",
 CellID->29204],
Cell[213939, 7490, 175, 5, 70, "Output",
 CellTags->"nlug:3.2.10",
 CellID->6777]
}, Open  ]],
Cell[214129, 7498, 782, 21, 70, "Text",
 CellTags->"nlug:3.2.10",
 CellID->25789],
Cell[CellGroupData[{
Cell[214936, 7523, 180, 6, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.10",
 CellID->2250],
Cell[215119, 7531, 175, 5, 70, "Output",
 CellTags->"nlug:3.2.10",
 CellID->27778]
}, Open  ]],
Cell[215309, 7539, 332, 10, 70, "Text",
 CellTags->"nlug:3.2.10",
 CellID->2160]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[215690, 7555, 101, 2, 70, "Section",
 CellTags->{".NET Console", "nlug:3.2.11"},
 CellID->9196],
Cell[215794, 7559, 1374, 39, 70, "Text",
 CellTags->"nlug:3.2.11",
 CellID->19418],
Cell[217171, 7600, 1201, 36, 70, "DefinitionBox",
 CellTags->"nlug:3.2.11",
 CellID->9164],
Cell[218375, 7638, 87, 2, 70, "Caption",
 CellTags->"nlug:3.2.11",
 CellID->6704],
Cell[CellGroupData[{
Cell[218487, 7644, 127, 4, 70, "Input",
 CellTags->"nlug:3.2.11",
 CellID->13318],
Cell[218617, 7650, 292, 10, 70, "Output",
 CellTags->"nlug:3.2.11",
 CellID->18545]
}, Open  ]],
Cell[218924, 7663, 676, 19, 70, "Text",
 CellTags->"nlug:3.2.11",
 CellID->6813],
Cell[219603, 7684, 470, 14, 70, "Text",
 CellTags->"nlug:3.2.11",
 CellID->5695],
Cell[220076, 7700, 271, 7, 70, "Input",
 CellTags->"nlug:3.2.11",
 CellID->11154],
Cell[220350, 7709, 311, 8, 70, "Text",
 CellTags->"nlug:3.2.11",
 CellID->30433]
}, Open  ]],
Cell[CellGroupData[{
Cell[220698, 7722, 189, 6, 70, "Section",
 CellTags->{"Distributing Applications", "nlug:3.2.12"},
 CellID->20220],
Cell[220890, 7730, 269, 10, 70, "Text",
 CellTags->"nlug:3.2.12",
 CellID->21891],
Cell[221162, 7742, 672, 16, 70, "Text",
 CellTags->"nlug:3.2.12",
 CellID->15323],
Cell[221837, 7760, 1493, 46, 70, "Text",
 CellTags->"nlug:3.2.12",
 CellID->29246],
Cell[223333, 7808, 1141, 30, 70, "Text",
 CellTags->"nlug:3.2.12",
 CellID->19778],
Cell[224477, 7840, 194, 7, 70, "Text",
 CellTags->"nlug:3.2.12",
 CellID->21089],
Cell[224674, 7849, 243, 10, 70, "Program",
 CellTags->"nlug:3.2.12",
 CellID->3698],
Cell[224920, 7861, 793, 17, 70, "Text",
 CellTags->"nlug:3.2.12",
 CellID->3616],
Cell[225716, 7880, 324, 9, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.2.12",
 CellID->28900]
}, Open  ]],
Cell[CellGroupData[{
Cell[226077, 7894, 80, 2, 70, "Section",
 CellTags->"nlug:3.2.13",
 CellID->12578],
Cell[226160, 7898, 598, 17, 70, "Text",
 CellTags->"nlug:3.2.13",
 CellID->30959],
Cell[226761, 7917, 865, 25, 70, "DefinitionBox",
 CellTags->"nlug:3.2.13",
 CellID->12953],
Cell[227629, 7944, 144, 6, 70, "Caption",
 CellTags->"nlug:3.2.13",
 CellID->12059],
Cell[CellGroupData[{
Cell[227798, 7954, 119, 3, 70, "Input",
 CellTags->"nlug:3.2.13",
 CellID->26368],
Cell[227920, 7959, 140, 3, 70, "Output",
 CellTags->"nlug:3.2.13",
 CellID->31041]
}, Open  ]],
Cell[CellGroupData[{
Cell[228097, 7967, 124, 3, 70, "Input",
 CellTags->"nlug:3.2.13",
 CellID->3617],
Cell[228224, 7972, 95, 3, 70, "Output",
 CellTags->"nlug:3.2.13",
 CellID->16460]
}, Open  ]],
Cell[CellGroupData[{
Cell[228356, 7980, 124, 3, 70, "Input",
 CellTags->"nlug:3.2.13",
 CellID->7253],
Cell[228483, 7985, 92, 3, 70, "Output",
 CellTags->"nlug:3.2.13",
 CellID->8650]
}, Open  ]],
Cell[228590, 7991, 695, 23, 70, "Text",
 CellTags->"nlug:3.2.13",
 CellID->12586]
}, Open  ]],
Cell[CellGroupData[{
Cell[229322, 8019, 59, 1, 70, "Section",
 CellID->17034],
Cell[CellGroupData[{
Cell[229406, 8024, 74, 2, 70, "Subsection",
 CellTags->"nlug:3.3.0",
 CellID->3744],
Cell[229483, 8028, 1117, 24, 70, "Text",
 CellTags->"nlug:3.3.0",
 CellID->3217],
Cell[230603, 8054, 565, 19, 70, "Text",
 CellTags->"nlug:3.3.0",
 CellID->26068],
Cell[231171, 8075, 874, 32, 70, "Text",
 CellTags->"nlug:3.3.0",
 CellID->13235],
Cell[232048, 8109, 846, 32, 70, "Text",
 CellTags->"nlug:3.3.0",
 CellID->1104],
Cell[232897, 8143, 745, 25, 70, "Text",
 CellTags->"nlug:3.3.0",
 CellID->20032]
}, Open  ]],
Cell[CellGroupData[{
Cell[233679, 8173, 121, 2, 70, "Subsection",
 CellTags->{"Modal versus Modeless", "nlug:3.3.1"},
 CellID->15816],
Cell[233803, 8177, 701, 16, 70, "Text",
 CellTags->"nlug:3.3.1",
 CellID->876873929],
Cell[234507, 8195, 2100, 54, 70, "Text",
 CellTags->"nlug:3.3.1",
 CellID->13197],
Cell[236610, 8251, 855, 19, 70, "Text",
 CellTags->"nlug:3.3.1",
 CellID->2146],
Cell[237468, 8272, 1104, 28, 70, "Text",
 CellTags->"nlug:3.3.1",
 CellID->24853],
Cell[238575, 8302, 745, 21, 70, "Text",
 CellTags->"nlug:3.3.1",
 CellID->27223],
Cell[239323, 8325, 716, 14, 70, "Text",
 CellTags->"nlug:3.3.1",
 CellID->2478],
Cell[240042, 8341, 865, 19, 70, "Text",
 CellTags->"nlug:3.3.1",
 CellID->23233],
Cell[240910, 8362, 930, 17, 70, "Text",
 CellTags->"nlug:3.3.1",
 CellID->30962],
Cell[241843, 8381, 335, 9, 70, "Text",
 CellTags->"nlug:3.3.1",
 CellID->19990]
}, Open  ]],
Cell[CellGroupData[{
Cell[242215, 8395, 99, 2, 70, "Subsection",
 CellTags->{"Handling Events", "nlug:3.3.2"},
 CellID->21428],
Cell[242317, 8399, 797, 16, 70, "Text",
 CellTags->"nlug:3.3.2",
 CellID->14124],
Cell[243117, 8417, 418, 13, 70, "Text",
 CellTags->"nlug:3.3.2",
 CellID->25981],
Cell[243538, 8432, 227, 8, 70, "Program",
 CellTags->"nlug:3.3.2",
 CellID->28489],
Cell[243768, 8442, 418, 10, 70, "Text",
 CellTags->"nlug:3.3.2",
 CellID->30425],
Cell[244189, 8454, 428, 11, 70, "Text",
 CellTags->"nlug:3.3.2",
 CellID->1984],
Cell[244620, 8467, 144, 4, 70, "Program",
 CellTags->"nlug:3.3.2",
 CellID->23286],
Cell[244767, 8473, 195, 6, 70, "Text",
 CellTags->"nlug:3.3.2",
 CellID->6535],
Cell[244965, 8481, 311, 8, 70, "Program",
 CellTags->"nlug:3.3.2",
 CellID->5996],
Cell[245279, 8491, 324, 14, 70, "Text",
 CellTags->"nlug:3.3.2",
 CellID->2662],
Cell[245606, 8507, 211, 7, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.3.2",
 CellID->24363],
Cell[245820, 8516, 766, 20, 70, "Text",
 CellTags->"nlug:3.3.2",
 CellID->15535],
Cell[246589, 8538, 404, 12, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.3.2",
 CellID->8667],
Cell[246996, 8552, 1026, 31, 70, "DefinitionBox",
 CellTags->"nlug:3.3.2",
 CellID->1437],
Cell[248025, 8585, 210, 7, 70, "Caption",
 CellTags->"nlug:3.3.2",
 CellID->15155],
Cell[248238, 8594, 694, 14, 70, "Text",
 CellTags->"nlug:3.3.2",
 CellID->26575],
Cell[248935, 8610, 1126, 33, 70, "Text",
 CellTags->"nlug:3.3.2",
 CellID->27154],
Cell[250064, 8645, 177, 7, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.3.2",
 CellID->14970],
Cell[250244, 8654, 1505, 42, 70, "Text",
 CellTags->"nlug:3.3.2",
 CellID->13663],
Cell[251752, 8698, 667, 19, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.3.2",
 CellID->27460],
Cell[252422, 8719, 1510, 41, 70, "Text",
 CellTags->"nlug:3.3.2",
 CellID->21763],
Cell[253935, 8762, 294, 8, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.3.2",
 CellID->14316],
Cell[254232, 8772, 159, 6, 70, "Text",
 CellTags->"nlug:3.3.2",
 CellID->10094],
Cell[254394, 8780, 219, 6, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.3.2",
 CellID->26147],
Cell[254616, 8788, 649, 23, 70, "Text",
 CellTags->"nlug:3.3.2",
 CellID->16518],
Cell[255268, 8813, 1029, 30, 70, "DefinitionBox3Col",
 CellTags->"nlug:3.3.2",
 CellID->29509],
Cell[256300, 8845, 88, 2, 70, "Caption",
 CellTags->"nlug:3.3.2",
 CellID->17664],
Cell[256391, 8849, 1126, 36, 70, "Text",
 CellTags->"nlug:3.3.2",
 CellID->17112],
Cell[257520, 8887, 2408, 66, 70, "Text",
 CellTags->"nlug:3.3.2",
 CellID->7524],
Cell[259931, 8955, 1015, 31, 70, "DefinitionBox",
 CellTags->"nlug:3.3.2",
 CellID->18934],
Cell[260949, 8988, 165, 7, 70, "Caption",
 CellTags->"nlug:3.3.2",
 CellID->9806],
Cell[261117, 8997, 673, 19, 70, "Text",
 CellTags->"nlug:3.3.2",
 CellID->26381]
}, Open  ]],
Cell[CellGroupData[{
Cell[261827, 9021, 95, 2, 70, "Subsection",
 CellTags->{"Modal Windows", "nlug:3.3.3"},
 CellID->28590],
Cell[261925, 9025, 550, 14, 70, "Text",
 CellTags->"nlug:3.3.3",
 CellID->20634],
Cell[CellGroupData[{
Cell[262500, 9043, 183, 6, 70, "Input",
 CellTags->"nlug:3.3.3",
 CellID->27415],
Cell[262686, 9051, 278, 9, 70, "Output",
 CellTags->"nlug:3.3.3",
 CellID->6862]
}, Open  ]],
Cell[262979, 9063, 841, 23, 70, "Text",
 CellTags->"nlug:3.3.3",
 CellID->10580],
Cell[263823, 9088, 149, 5, 70, "Input",
 CellTags->"nlug:3.3.3",
 CellID->4919],
Cell[263975, 9095, 591, 14, 70, "Text",
 CellTags->"nlug:3.3.3",
 CellID->2526],
Cell[264569, 9111, 284, 10, 70, "Input",
 CellTags->"nlug:3.3.3",
 CellID->27370],
Cell[264856, 9123, 214, 9, 70, "Text",
 CellTags->"nlug:3.3.3",
 CellID->4850],
Cell[265073, 9134, 219, 8, 70, "Input",
 CellTags->"nlug:3.3.3",
 CellID->10944],
Cell[265295, 9144, 386, 11, 70, "Text",
 CellTags->"nlug:3.3.3",
 CellID->8018],
Cell[265684, 9157, 767, 23, 70, "Input",
 CellTags->"nlug:3.3.3",
 CellID->2716],
Cell[266454, 9182, 740, 22, 70, "Text",
 CellTags->"nlug:3.3.3",
 CellID->14061],
Cell[267197, 9206, 843, 20, 70, "Text",
 CellTags->"nlug:3.3.3",
 CellID->19422],
Cell[268043, 9228, 929, 28, 70, "DefinitionBox",
 CellTags->"nlug:3.3.3",
 CellID->21006],
Cell[268975, 9258, 82, 2, 70, "Caption",
 CellTags->"nlug:3.3.3",
 CellID->30826],
Cell[269060, 9262, 144, 5, 70, "Text",
 CellTags->"nlug:3.3.3",
 CellID->703],
Cell[269207, 9269, 130, 4, 70, "Input",
 CellTags->"nlug:3.3.3",
 CellID->13039],
Cell[269340, 9275, 534, 15, 70, "Text",
 CellTags->"nlug:3.3.3",
 CellID->7810],
Cell[269877, 9292, 1570, 42, 70, "Text",
 CellTags->"nlug:3.3.3",
 CellID->27214],
Cell[271450, 9336, 137, 4, 70, "Text",
 CellTags->"nlug:3.3.3",
 CellID->4751],
Cell[271590, 9342, 1684, 44, 70, "Input",
 CellTags->"nlug:3.3.3",
 CellID->4432],
Cell[273277, 9388, 1320, 35, 70, "Text",
 CellTags->"nlug:3.3.3",
 CellID->7985],
Cell[274600, 9425, 374, 10, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.3.3",
 CellID->17684],
Cell[274977, 9437, 499, 18, 70, "Text",
 CellTags->"nlug:3.3.3",
 CellID->23301],
Cell[275479, 9457, 1132, 35, 70, "Text",
 CellTags->"nlug:3.3.3",
 CellID->24535],
Cell[276614, 9494, 660, 18, 70, "DefinitionBox3Col",
 CellTags->"nlug:3.3.3",
 CellID->9502],
Cell[277277, 9514, 223, 9, 70, "Caption",
 CellTags->"nlug:3.3.3",
 CellID->8963]
}, Open  ]],
Cell[CellGroupData[{
Cell[277537, 9528, 100, 2, 70, "Subsection",
 CellTags->{"Modeless Windows", "nlug:3.3.4"},
 CellID->9564],
Cell[277640, 9532, 797, 19, 70, "Text",
 CellTags->"nlug:3.3.4",
 CellID->15012],
Cell[278440, 9553, 659, 19, 70, "Text",
 CellTags->"nlug:3.3.4",
 CellID->13440],
Cell[279102, 9574, 422, 13, 70, "DefinitionBox",
 CellTags->"nlug:3.3.4",
 CellID->11711],
Cell[279527, 9589, 76, 2, 70, "Caption",
 CellTags->"nlug:3.3.4",
 CellID->4537],
Cell[279606, 9593, 189, 6, 70, "Text",
 CellTags->"nlug:3.3.4",
 CellID->10778],
Cell[279798, 9601, 1672, 46, 70, "Input",
 CellTags->"nlug:3.3.4",
 CellID->14781],
Cell[281473, 9649, 329, 8, 70, "Text",
 CellTags->"nlug:3.3.4",
 CellID->20334],
Cell[281805, 9659, 125, 4, 70, "Input",
 CellTags->"nlug:3.3.4",
 CellID->5051],
Cell[281933, 9665, 1947, 58, 70, "Text",
 CellTags->"nlug:3.3.4",
 CellID->32040],
Cell[283883, 9725, 1166, 28, 70, "Text",
 CellTags->"nlug:3.3.4",
 CellID->2710],
Cell[285052, 9755, 1158, 33, 70, "DefinitionBox3Col",
 CellTags->"nlug:3.3.4",
 CellID->32538],
Cell[286213, 9790, 85, 2, 70, "Caption",
 CellTags->"nlug:3.3.4",
 CellID->7507],
Cell[286301, 9794, 1890, 56, 70, "Text",
 CellTags->"nlug:3.3.4",
 CellID->6349],
Cell[288194, 9852, 1471, 41, 70, "Text",
 CellTags->"nlug:3.3.4",
 CellID->1951],
Cell[289668, 9895, 1209, 31, 70, "Text",
 CellTags->"nlug:3.3.4",
 CellID->11350]
}, Open  ]],
Cell[CellGroupData[{
Cell[290914, 9931, 138, 2, 70, "Subsection",
 CellTags->{"Sharing the Kernel", "nlug:3.3.5"},
 CellID->27606],
Cell[291055, 9935, 797, 25, 70, "Text",
 CellTags->"nlug:3.3.5",
 CellID->24795],
Cell[291855, 9962, 1339, 33, 70, "Text",
 CellTags->"nlug:3.3.5",
 CellID->29171],
Cell[293197, 9997, 1510, 45, 70, "Text",
 CellTags->"nlug:3.3.5",
 CellID->3621],
Cell[294710, 10044, 238, 9, 70, "Program",
 CellTags->"nlug:3.3.5",
 CellID->11088],
Cell[294951, 10055, 717, 22, 70, "Text",
 CellTags->"nlug:3.3.5",
 CellID->7675],
Cell[295671, 10079, 180, 6, 70, "Input",
 CellTags->"nlug:3.3.5",
 CellID->18725],
Cell[295854, 10087, 197, 8, 70, "Text",
 CellTags->"nlug:3.3.5",
 CellID->22807],
Cell[296054, 10097, 131, 4, 70, "Input",
 CellTags->"nlug:3.3.5",
 CellID->677939434],
Cell[296188, 10103, 831, 25, 70, "Text",
 CellTags->"nlug:3.3.5",
 CellID->1265],
Cell[297022, 10130, 732, 21, 70, "Text",
 CellTags->"nlug:3.3.5",
 CellID->17786]
}, Open  ]],
Cell[CellGroupData[{
Cell[297791, 10156, 194, 7, 70, "Subsection",
 CellTags->{"ShowNETWindow", "nlug:3.3.6"},
 CellID->8373],
Cell[297988, 10165, 868, 27, 70, "Text",
 CellTags->"nlug:3.3.6",
 CellID->26289]
}, Open  ]],
Cell[CellGroupData[{
Cell[298893, 10197, 121, 2, 70, "Subsection",
 CellTags->{"ShowNETWindow", "nlug:3.3.7"},
 CellID->17185],
Cell[299017, 10201, 970, 27, 70, "Text",
 CellTags->"nlug:3.3.7",
 CellID->16981],
Cell[299990, 10230, 1402, 41, 70, "Text",
 CellTags->"nlug:3.3.7",
 CellID->26655],
Cell[301395, 10273, 455, 14, 70, "DefinitionBox",
 CellTags->"nlug:3.3.7",
 CellID->10687],
Cell[301853, 10289, 101, 2, 70, "Caption",
 CellTags->"nlug:3.3.7",
 CellID->13394],
Cell[301957, 10293, 1434, 46, 70, "Text",
 CellTags->"nlug:3.3.7",
 CellID->11506]
}, Open  ]],
Cell[CellGroupData[{
Cell[303428, 10344, 75, 2, 70, "Subsection",
 CellTags->"nlug:3.3.8",
 CellID->9716],
Cell[303506, 10348, 173, 6, 70, "Text",
 CellTags->"nlug:3.3.8",
 CellID->20091],
Cell[303682, 10356, 191, 5, 70, "Text",
 CellTags->"nlug:3.3.8",
 CellID->9651],
Cell[303876, 10363, 194, 5, 70, "Text",
 CellTags->"nlug:3.3.8",
 CellID->19287],
Cell[304073, 10370, 212, 6, 70, "Text",
 CellTags->"nlug:3.3.8",
 CellID->16242],
Cell[304288, 10378, 198, 5, 70, "Text",
 CellTags->"nlug:3.3.8",
 CellID->16182],
Cell[304489, 10385, 194, 5, 70, "Text",
 CellTags->"nlug:3.3.8",
 CellID->18971]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[304732, 10396, 139, 5, 70, "Section",
 CellID->18804],
Cell[CellGroupData[{
Cell[304896, 10405, 75, 2, 70, "Subsection",
 CellTags->"nlug:3.4.0",
 CellID->12190],
Cell[304974, 10409, 365, 10, 70, "Text",
 CellTags->"nlug:3.4.0",
 CellID->1381],
Cell[305342, 10421, 706, 19, 70, "Text",
 CellTags->"nlug:3.4.0",
 CellID->28910],
Cell[306051, 10442, 1078, 27, 70, "Text",
 CellTags->"nlug:3.4.0",
 CellID->5798],
Cell[307132, 10471, 866, 28, 70, "Text",
 CellTags->"nlug:3.4.0",
 CellID->8117],
Cell[308001, 10501, 715, 20, 70, "Text",
 CellTags->"nlug:3.4.0",
 CellID->15444]
}, Open  ]],
Cell[CellGroupData[{
Cell[308753, 10526, 157, 6, 70, "Subsection",
 CellTags->"nlug:3.4.1",
 CellID->3012],
Cell[308913, 10534, 805, 20, 70, "Text",
 CellTags->"nlug:3.4.1",
 CellID->1914],
Cell[309721, 10556, 803, 22, 70, "Text",
 CellTags->"nlug:3.4.1",
 CellID->2164],
Cell[310527, 10580, 456, 24, 70, "Program",
 CellTags->"nlug:3.4.1",
 CellID->406552679],
Cell[310986, 10606, 1072, 33, 70, "Text",
 CellTags->"nlug:3.4.1",
 CellID->20593],
Cell[312061, 10641, 664, 21, 70, "Text",
 CellTags->"nlug:3.4.1",
 CellID->14059],
Cell[312728, 10664, 661, 19, 70, "Text",
 CellTags->"nlug:3.4.1",
 CellID->17657],
Cell[313392, 10685, 663, 20, 70, "Text",
 CellTags->"nlug:3.4.1",
 CellID->29386],
Cell[314058, 10707, 1175, 37, 70, "Text",
 CellTags->"nlug:3.4.1",
 CellID->19479]
}, Open  ]],
Cell[CellGroupData[{
Cell[315270, 10749, 152, 6, 70, "Subsection",
 CellTags->"nlug:3.4.2",
 CellID->6115],
Cell[315425, 10757, 1120, 32, 70, "Text",
 CellTags->"nlug:3.4.2",
 CellID->28056],
Cell[316548, 10791, 1429, 38, 70, "Text",
 CellTags->"nlug:3.4.2",
 CellID->16540],
Cell[317980, 10831, 1323, 40, 70, "Text",
 CellTags->"nlug:3.4.2",
 CellID->3282],
Cell[319306, 10873, 715, 23, 70, "Text",
 CellTags->"nlug:3.4.2",
 CellID->21339],
Cell[320024, 10898, 110, 2, 70, "Program",
 CellTags->"nlug:3.4.2",
 CellID->19827],
Cell[320137, 10902, 362, 14, 70, "Text",
 CellTags->"nlug:3.4.2",
 CellID->18566],
Cell[320502, 10918, 88, 2, 70, "Program",
 CellTags->"nlug:3.4.2",
 CellID->25582],
Cell[320593, 10922, 221, 8, 70, "Text",
 CellTags->"nlug:3.4.2",
 CellID->20931],
Cell[320817, 10932, 162, 3, 70, "Program",
 CellTags->"nlug:3.4.2",
 CellID->22090],
Cell[320982, 10937, 77, 2, 70, "Text",
 CellTags->"nlug:3.4.2",
 CellID->29713],
Cell[321062, 10941, 370, 15, 70, "Program",
 CellTags->"nlug:3.4.2",
 CellID->6231],
Cell[321435, 10958, 424, 16, 70, "Text",
 CellTags->"nlug:3.4.2",
 CellID->29604],
Cell[321862, 10976, 138, 6, 70, "Text",
 CellTags->"nlug:3.4.2",
 CellID->1684],
Cell[CellGroupData[{
Cell[322025, 10986, 370, 12, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.4.2",
 CellID->10158],
Cell[322398, 11000, 146, 5, 70, "Print",
 CellTags->"nlug:3.4.2",
 CellID->7504],
Cell[322547, 11007, 312, 8, 70, "Message",
 CellTags->"nlug:3.4.2",
 CellID->15748],
Cell[322862, 11017, 99, 3, 70, "Output",
 CellTags->"nlug:3.4.2",
 CellID->30158]
}, Open  ]],
Cell[322976, 11023, 416, 13, 70, "Text",
 CellTags->"nlug:3.4.2",
 CellID->28083],
Cell[323395, 11038, 1831, 59, 70, "Text",
 CellTags->"nlug:3.4.2",
 CellID->8552],
Cell[325229, 11099, 82, 2, 70, "Text",
 CellTags->"nlug:3.4.2",
 CellID->31498],
Cell[325314, 11103, 874, 30, 70, "Program",
 CellTags->"nlug:3.4.2",
 CellID->31507]
}, Open  ]],
Cell[CellGroupData[{
Cell[326225, 11138, 82, 2, 70, "Subsection",
 CellTags->"nlug:3.4.3",
 CellID->21153],
Cell[326310, 11142, 895, 23, 70, "Text",
 CellTags->"nlug:3.4.3",
 CellID->2474]
}, Open  ]],
Cell[CellGroupData[{
Cell[327242, 11170, 91, 2, 70, "Subsection",
 CellTags->"nlug:3.4.4",
 CellID->7522],
Cell[327336, 11174, 685, 23, 70, "Text",
 CellTags->"nlug:3.4.4",
 CellID->8685],
Cell[328024, 11199, 554, 15, 70, "Text",
 CellTags->"nlug:3.4.4",
 CellID->22184],
Cell[328581, 11216, 317, 13, 70, "Program",
 CellTags->"nlug:3.4.4",
 CellID->11541],
Cell[328901, 11231, 1477, 44, 70, "Text",
 CellTags->"nlug:3.4.4",
 CellID->22755],
Cell[330381, 11277, 1887, 48, 70, "Text",
 CellTags->"nlug:3.4.4",
 CellID->24939],
Cell[332271, 11327, 1660, 43, 70, "Text",
 CellTags->"nlug:3.4.4",
 CellID->6253],
Cell[333934, 11372, 76, 2, 70, "Text",
 CellTags->"nlug:3.4.4",
 CellID->25676],
Cell[334013, 11376, 386, 17, 70, "Program",
 CellTags->"nlug:3.4.4",
 CellID->17903]
}, Open  ]],
Cell[CellGroupData[{
Cell[334436, 11398, 98, 2, 70, "Subsection",
 CellTags->"nlug:3.4.5",
 CellID->18803],
Cell[334537, 11402, 2007, 54, 70, "Text",
 CellTags->"nlug:3.4.5",
 CellID->7434],
Cell[336547, 11458, 203, 6, 70, "Text",
 CellTags->"nlug:3.4.5",
 CellID->16782],
Cell[336753, 11466, 214, 7, 70, "BulletedText",
 CellTags->"nlug:3.4.5",
 CellID->2331],
Cell[336970, 11475, 273, 10, 70, "BulletedText",
 CellTags->"nlug:3.4.5",
 CellID->6746],
Cell[337246, 11487, 356, 11, 70, "BulletedText",
 CellTags->"nlug:3.4.5",
 CellID->22870],
Cell[337605, 11500, 251, 8, 70, "BulletedText",
 CellTags->"nlug:3.4.5",
 CellID->1255],
Cell[337859, 11510, 172, 6, 70, "BulletedText",
 CellTags->"nlug:3.4.5",
 CellID->18064],
Cell[CellGroupData[{
Cell[338056, 11520, 465, 15, 70, "BulletedText",
 CellTags->"nlug:3.4.5",
 CellID->31410],
Cell[338524, 11537, 737, 19, 70, "Text",
 CellTags->"nlug:3.4.5",
 CellID->24680],
Cell[339264, 11558, 135, 4, 70, "Text",
 CellTags->"nlug:3.4.5",
 CellID->8360],
Cell[339402, 11564, 595, 18, 70, "Program",
 CellTags->"nlug:3.4.5",
 CellID->25778]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[340046, 11588, 90, 2, 70, "Subsection",
 CellTags->"nlug:3.4.6",
 CellID->16227],
Cell[340139, 11592, 752, 20, 70, "Text",
 CellTags->"nlug:3.4.6",
 CellID->23382],
Cell[340894, 11614, 986, 29, 70, "Text",
 CellTags->"nlug:3.4.6",
 CellID->25110],
Cell[341883, 11645, 111, 3, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.4.6",
 CellID->25087],
Cell[341997, 11650, 950, 30, 70, "Text",
 CellTags->"nlug:3.4.6",
 CellID->31230]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[342996, 11686, 123, 6, 70, "Section",
 CellID->32076],
Cell[CellGroupData[{
Cell[343144, 11696, 110, 2, 70, "Subsection",
 CellTags->{"Calling DLLS from Mathematica", "nlug:3.5.0"},
 CellID->24729],
Cell[343257, 11700, 980, 25, 70, "Text",
 CellTags->"nlug:3.5.0",
 CellID->5413],
Cell[344240, 11727, 797, 21, 70, "Text",
 CellTags->"nlug:3.5.0",
 CellID->16603],
Cell[345040, 11750, 441, 11, 70, "Text",
 CellTags->"nlug:3.5.0",
 CellID->29591],
Cell[345484, 11763, 415, 11, 70, "Program",
 CellTags->"nlug:3.5.0",
 CellID->17403],
Cell[345902, 11776, 440, 13, 70, "Text",
 CellTags->"nlug:3.5.0",
 CellID->14964],
Cell[CellGroupData[{
Cell[346367, 11793, 291, 9, 70, "Input",
 CellTags->"nlug:3.5.0",
 CellID->31695],
Cell[346661, 11804, 519, 14, 70, "Output",
 CellTags->"nlug:3.5.0",
 CellID->30298]
}, Open  ]],
Cell[347195, 11821, 340, 10, 70, "Text",
 CellTags->"nlug:3.5.0",
 CellID->1042],
Cell[CellGroupData[{
Cell[347560, 11835, 126, 4, 70, "Input",
 CellTags->"nlug:3.5.0",
 CellID->30540],
Cell[347689, 11841, 102, 3, 70, "Output",
 CellTags->"nlug:3.5.0",
 CellID->19245]
}, Open  ]],
Cell[347806, 11847, 1261, 30, 70, "Text",
 CellTags->"nlug:3.5.0",
 CellID->32464],
Cell[349070, 11879, 935, 26, 70, "DefinitionBox",
 CellID->28222],
Cell[350008, 11907, 58, 1, 70, "Caption",
 CellID->30815],
Cell[350069, 11910, 1249, 28, 70, "Text",
 CellTags->"nlug:3.5.0",
 CellID->10860],
Cell[351321, 11940, 737, 22, 70, "Text",
 CellTags->"nlug:3.5.0",
 CellID->21989],
Cell[352061, 11964, 1384, 36, 70, "DefinitionBox3Col",
 CellTags->"nlug:3.5.0",
 CellID->13770],
Cell[353448, 12002, 238, 9, 70, "Caption",
 CellTags->"nlug:3.5.0",
 CellID->14749]
}, Open  ]],
Cell[CellGroupData[{
Cell[353723, 12016, 104, 2, 70, "Subsection",
 CellTags->{"How DLLs are Found", "nlug:3.5.1"},
 CellID->9297],
Cell[353830, 12020, 1041, 26, 70, "Text",
 CellTags->"nlug:3.5.1",
 CellID->8091],
Cell[354874, 12048, 1968, 55, 70, "Text",
 CellTags->"nlug:3.5.1",
 CellID->25024],
Cell[356845, 12105, 553, 14, 70, "Text",
 CellTags->"nlug:3.5.1",
 CellID->3252]
}, Open  ]],
Cell[CellGroupData[{
Cell[357435, 12124, 145, 2, 70, "Subsection",
 CellTags->{"Specifying Arguments and Return Values", "nlug:3.5.2"},
 CellID->20321],
Cell[CellGroupData[{
Cell[357605, 12130, 78, 2, 70, "Subsubsection",
 CellTags->"nlug:3.5.2",
 CellID->13740],
Cell[357686, 12134, 1037, 19, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->19713],
Cell[358726, 12155, 83, 2, 70, "Program",
 CellTags->"nlug:3.5.2",
 CellID->26835],
Cell[358812, 12159, 684, 21, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->28316],
Cell[359499, 12182, 320, 9, 70, "Input",
 CellTags->"nlug:3.5.2",
 CellID->5489],
Cell[CellGroupData[{
Cell[359844, 12195, 134, 4, 70, "Input",
 CellTags->"nlug:3.5.2",
 CellID->27796],
Cell[359981, 12201, 96, 3, 70, "Output",
 CellTags->"nlug:3.5.2",
 CellID->26548]
}, Open  ]],
Cell[360092, 12207, 412, 10, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->2664],
Cell[360507, 12219, 1408, 38, 70, "Input",
 CellTags->"nlug:3.5.2",
 CellID->25858],
Cell[361918, 12259, 690, 15, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->20543],
Cell[362611, 12276, 338, 10, 70, "Program",
 CellTags->"nlug:3.5.2",
 CellID->5081],
Cell[362952, 12288, 820, 24, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->5580],
Cell[363775, 12314, 136, 4, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->21407]
}, Open  ]],
Cell[CellGroupData[{
Cell[363948, 12323, 80, 2, 70, "Subsubsection",
 CellTags->"nlug:3.5.2",
 CellID->4436],
Cell[364031, 12327, 272, 8, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->27670],
Cell[364306, 12337, 3366, 98, 70, "DefinitionBox",
 CellTags->"nlug:3.5.2",
 CellID->29662],
Cell[367675, 12437, 275, 9, 70, "Caption",
 CellTags->"nlug:3.5.2",
 CellID->22863],
Cell[367953, 12448, 535, 13, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->9166]
}, Open  ]],
Cell[CellGroupData[{
Cell[368525, 12466, 94, 2, 70, "Subsubsection",
 CellTags->{"strings in DLLs", "nlug:3.5.2"},
 CellID->16463],
Cell[368622, 12470, 1120, 25, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->29055],
Cell[369745, 12497, 383, 10, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->6598],
Cell[370131, 12509, 132, 6, 70, "Program",
 CellTags->"nlug:3.5.2",
 CellID->15772],
Cell[370266, 12517, 427, 12, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->19331],
Cell[370696, 12531, 637, 19, 70, "Input",
 CellTags->"nlug:3.5.2",
 CellID->1861],
Cell[371336, 12552, 157, 5, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->28300],
Cell[CellGroupData[{
Cell[371518, 12561, 238, 7, 70, "Input",
 CellTags->"nlug:3.5.2",
 CellID->18493],
Cell[371759, 12570, 97, 3, 70, "Output",
 CellTags->"nlug:3.5.2",
 CellID->12041]
}, Open  ]],
Cell[371871, 12576, 399, 9, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->30649],
Cell[CellGroupData[{
Cell[372295, 12589, 139, 4, 70, "Input",
 CellTags->"nlug:3.5.2",
 CellID->23644],
Cell[372437, 12595, 103, 3, 70, "Output",
 CellTags->"nlug:3.5.2",
 CellID->4237]
}, Open  ]],
Cell[372555, 12601, 110, 2, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->13082],
Cell[CellGroupData[{
Cell[372690, 12607, 138, 4, 70, "Input",
 CellTags->"nlug:3.5.2",
 CellID->7619],
Cell[372831, 12613, 108, 3, 70, "Output",
 CellTags->"nlug:3.5.2",
 CellID->30667]
}, Open  ]],
Cell[372954, 12619, 839, 21, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->10463],
Cell[373796, 12642, 1418, 48, 70, "DefinitionBox",
 CellTags->"nlug:3.5.2",
 CellID->28816],
Cell[375217, 12692, 293, 9, 70, "Caption",
 CellTags->"nlug:3.5.2",
 CellID->32610],
Cell[375513, 12703, 509, 15, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->32042],
Cell[376025, 12720, 2006, 57, 70, "Input",
 CellTags->"nlug:3.5.2",
 CellID->12619],
Cell[378034, 12779, 957, 21, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->18413],
Cell[378994, 12802, 130, 4, 70, "Program",
 CellTags->"nlug:3.5.2",
 CellID->30880],
Cell[379127, 12808, 971, 23, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->8108],
Cell[380101, 12833, 522, 12, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->31306],
Cell[380626, 12847, 413, 12, 70, "Input",
 CellTags->"nlug:3.5.2",
 CellID->18847],
Cell[381042, 12861, 683, 19, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->4806],
Cell[381728, 12882, 337, 10, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->21452],
Cell[CellGroupData[{
Cell[382090, 12896, 325, 10, 70, "Input",
 CellTags->"nlug:3.5.2",
 CellID->13696],
Cell[382418, 12908, 94, 3, 70, "Output",
 CellTags->"nlug:3.5.2",
 CellID->29571]
}, Open  ]],
Cell[382527, 12914, 205, 7, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->23500],
Cell[CellGroupData[{
Cell[382757, 12925, 145, 5, 70, "Input",
 CellTags->"nlug:3.5.2",
 CellID->6377],
Cell[382905, 12932, 109, 3, 70, "Output",
 CellTags->"nlug:3.5.2",
 CellID->10456]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[383063, 12941, 85, 2, 70, "Subsubsection",
 CellTags->"nlug:3.5.2",
 CellID->26535],
Cell[383151, 12945, 378, 9, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->21011],
Cell[383532, 12956, 134, 4, 70, "BulletedText",
 CellTags->"nlug:3.5.2",
 CellID->1587],
Cell[383669, 12962, 238, 6, 70, "BulletedText",
 CellTags->"nlug:3.5.2",
 CellID->225412227],
Cell[CellGroupData[{
Cell[383932, 12972, 250, 6, 70, "BulletedText",
 CellTags->"nlug:3.5.2",
 CellID->130001283],
Cell[384185, 12980, 392, 11, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->6102],
Cell[384580, 12993, 93, 2, 70, "Program",
 CellTags->"nlug:3.5.2",
 CellID->84],
Cell[384676, 12997, 735, 19, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->14423],
Cell[385414, 13018, 182, 6, 70, "Input",
 CellTags->"nlug:3.5.2",
 CellID->7883],
Cell[385599, 13026, 1474, 39, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->22313],
Cell[CellGroupData[{
Cell[387098, 13069, 223, 7, 70, "Input",
 CellTags->"nlug:3.5.2",
 CellID->9003469],
Cell[387324, 13078, 97, 3, 70, "Output",
 CellTags->"nlug:3.5.2",
 CellID->26079]
}, Open  ]],
Cell[CellGroupData[{
Cell[387458, 13086, 103, 3, 70, "Input",
 CellTags->"nlug:3.5.2",
 CellID->12582],
Cell[387564, 13091, 96, 3, 70, "Output",
 CellTags->"nlug:3.5.2",
 CellID->16000]
}, Open  ]],
Cell[387675, 13097, 510, 14, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->1616],
Cell[388188, 13113, 364, 11, 70, "Input",
 CellTags->"nlug:3.5.2",
 CellID->26358],
Cell[CellGroupData[{
Cell[388577, 13128, 232, 6, 70, "Input",
 CellTags->"nlug:3.5.2",
 CellID->17843],
Cell[388812, 13136, 97, 3, 70, "Output",
 CellTags->"nlug:3.5.2",
 CellID->27807],
Cell[388912, 13141, 95, 3, 70, "Output",
 CellTags->"nlug:3.5.2",
 CellID->7909]
}, Open  ]],
Cell[389022, 13147, 1060, 27, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->415],
Cell[390085, 13176, 812, 22, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->24765],
Cell[390900, 13200, 150, 6, 70, "Program",
 CellTags->"nlug:3.5.2",
 CellID->4530],
Cell[391053, 13208, 412, 12, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->10072],
Cell[391468, 13222, 1211, 35, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.5.2",
 CellID->29317],
Cell[392682, 13259, 255, 8, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->7058],
Cell[392940, 13269, 308, 10, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->13281],
Cell[393251, 13281, 367, 12, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.5.2",
 CellID->22272],
Cell[393621, 13295, 115, 2, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->30257],
Cell[393739, 13299, 256, 9, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.5.2",
 CellID->22757],
Cell[393998, 13310, 1167, 30, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->8740],
Cell[395168, 13342, 1466, 36, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.5.2",
 CellID->7107],
Cell[396637, 13380, 115, 2, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->29311],
Cell[396755, 13384, 255, 9, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.5.2",
 CellID->6257],
Cell[397013, 13395, 356, 11, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->2393]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[397418, 13412, 83, 2, 70, "Subsubsection",
 CellTags->"nlug:3.5.2",
 CellID->10971],
Cell[397504, 13416, 1568, 39, 70, "Text",
 CellTags->"nlug:3.5.2",
 CellID->21587]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[399121, 13461, 151, 2, 70, "Subsection",
 CellTags->{"Declarations Requiring Special Attributes", "nlug:3.5.3"},
 CellID->11743],
Cell[399275, 13465, 1078, 26, 70, "Text",
 CellTags->"nlug:3.5.3",
 CellID->24468],
Cell[400356, 13493, 291, 7, 70, "Program",
 CellTags->"nlug:3.5.3",
 CellID->3802],
Cell[400650, 13502, 409, 11, 70, "Text",
 CellTags->"nlug:3.5.3",
 CellID->30088],
Cell[401062, 13515, 419, 11, 70, "Input",
 CellTags->"nlug:3.5.3",
 CellID->24298],
Cell[401484, 13528, 194, 7, 70, "Text",
 CellTags->"nlug:3.5.3",
 CellID->6582],
Cell[401681, 13537, 232, 6, 70, "Text",
 CellTags->"nlug:3.5.3",
 CellID->22252],
Cell[401916, 13545, 122, 2, 70, "Program",
 CellTags->"nlug:3.5.3",
 CellID->113305141],
Cell[402041, 13549, 157, 6, 70, "Text",
 CellTags->"nlug:3.5.3",
 CellID->11457],
Cell[402201, 13557, 363, 10, 70, "Input",
 CellTags->"nlug:3.5.3",
 CellID->24385],
Cell[402567, 13569, 678, 17, 70, "Text",
 CellTags->"nlug:3.5.3",
 CellID->19293],
Cell[403248, 13588, 491, 14, 70, "Input",
 CellTags->"nlug:3.5.3",
 CellID->31716]
}, Open  ]],
Cell[CellGroupData[{
Cell[403776, 13607, 99, 2, 70, "Subsection",
 CellTags->{"DLL Example Files", "nlug:3.5.4"},
 CellID->19628],
Cell[403878, 13611, 260, 9, 70, "Text",
 CellTags->"nlug:3.5.4",
 CellID->12394],
Cell[404141, 13622, 194, 5, 70, "Text",
 CellTags->"nlug:3.5.4",
 CellID->19291],
Cell[404338, 13629, 178, 4, 70, "Text",
 CellTags->"nlug:3.5.4",
 CellID->3771],
Cell[404519, 13635, 182, 5, 70, "Text",
 CellTags->"nlug:3.5.4",
 CellID->5107]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[404750, 13646, 139, 7, 70, "Section",
 CellTags->"COM",
 CellID->7475],
Cell[CellGroupData[{
Cell[404914, 13657, 96, 2, 70, "Subsection",
 CellTags->{"COM Introduction", "nlug:3.6.0"},
 CellID->8879],
Cell[405013, 13661, 622, 15, 70, "Text",
 CellTags->"nlug:3.6.0",
 CellID->11858],
Cell[405638, 13678, 346, 7, 70, "Text",
 CellTags->"nlug:3.6.0",
 CellID->18583],
Cell[405987, 13687, 562, 10, 70, "Text",
 CellTags->"nlug:3.6.0",
 CellID->19946],
Cell[406552, 13699, 791, 17, 70, "Text",
 CellTags->"nlug:3.6.0",
 CellID->24187]
}, Open  ]],
Cell[CellGroupData[{
Cell[407380, 13721, 94, 2, 70, "Subsection",
 CellTags->"nlug:3.6.1",
 CellID->13407],
Cell[407477, 13725, 884, 19, 70, "Text",
 CellTags->"nlug:3.6.1",
 CellID->8288],
Cell[408364, 13746, 1023, 22, 70, "Text",
 CellTags->"nlug:3.6.1",
 CellID->17925],
Cell[409390, 13770, 1243, 24, 70, "Text",
 CellTags->"nlug:3.6.1",
 CellID->16395],
Cell[410636, 13796, 951, 22, 70, "Text",
 CellTags->"nlug:3.6.1",
 CellID->22860],
Cell[411590, 13820, 1346, 38, 70, "DefinitionBox",
 CellTags->"nlug:3.6.1",
 CellID->24320],
Cell[412939, 13860, 83, 2, 70, "Caption",
 CellTags->"nlug:3.6.1",
 CellID->25390],
Cell[413025, 13864, 108, 2, 70, "Text",
 CellTags->"nlug:3.6.1",
 CellID->14767],
Cell[CellGroupData[{
Cell[413158, 13870, 178, 5, 70, "Input",
 CellTags->"nlug:3.6.1",
 CellID->25656],
Cell[413339, 13877, 323, 9, 70, "Output",
 CellTags->"nlug:3.6.1",
 CellID->5354]
}, Open  ]],
Cell[413677, 13889, 907, 22, 70, "Text",
 CellTags->"nlug:3.6.1",
 CellID->672],
Cell[CellGroupData[{
Cell[414609, 13915, 201, 7, 70, "Input",
 CellTags->"nlug:3.6.1",
 CellID->18446],
Cell[414813, 13924, 117, 3, 70, "Output",
 CellTags->"nlug:3.6.1",
 CellID->25156]
}, Open  ]],
Cell[414945, 13930, 1609, 39, 70, "Text",
 CellTags->"nlug:3.6.1",
 CellID->20879],
Cell[416557, 13971, 335, 10, 70, "Text",
 CellTags->"nlug:3.6.1",
 CellID->4500],
Cell[CellGroupData[{
Cell[416917, 13985, 131, 4, 70, "Input",
 CellTags->"nlug:3.6.1",
 CellID->4293],
Cell[417051, 13991, 260, 7, 70, "Message",
 CellTags->"nlug:3.6.1",
 CellID->23203],
Cell[417314, 14000, 177, 7, 70, "Output",
 CellTags->"nlug:3.6.1",
 CellID->22309]
}, Open  ]],
Cell[417506, 14010, 555, 14, 70, "Text",
 CellTags->"nlug:3.6.1",
 CellID->508],
Cell[418064, 14026, 189, 8, 70, "Text",
 CellTags->"nlug:3.6.1",
 CellID->21585],
Cell[CellGroupData[{
Cell[418278, 14038, 121, 4, 70, "Input",
 CellTags->"nlug:3.6.1",
 CellID->2289],
Cell[418402, 14044, 94, 3, 70, "Output",
 CellTags->"nlug:3.6.1",
 CellID->15271]
}, Open  ]],
Cell[418511, 14050, 290, 10, 70, "Text",
 CellTags->"nlug:3.6.1",
 CellID->30580],
Cell[418804, 14062, 158, 5, 70, "Program",
 CellTags->"nlug:3.6.1",
 CellID->14127],
Cell[418965, 14069, 554, 14, 70, "Text",
 CellTags->"nlug:3.6.1",
 CellID->4550],
Cell[419522, 14085, 249, 9, 70, "Input",
 CellTags->"nlug:3.6.1",
 CellID->6941],
Cell[419774, 14096, 859, 16, 70, "Text",
 CellTags->"nlug:3.6.1",
 CellID->16502],
Cell[420636, 14114, 303, 9, 70, "Input",
 CellTags->"nlug:3.6.1",
 CellID->9793],
Cell[CellGroupData[{
Cell[420964, 14127, 95, 2, 70, "Subsubsection",
 CellTags->"nlug:3.6.1",
 CellID->25994],
Cell[421062, 14131, 323, 10, 70, "Text",
 CellTags->"nlug:3.6.1",
 CellID->16157],
Cell[421388, 14143, 149, 4, 70, "BulletedText",
 CellTags->"nlug:3.6.1",
 CellID->28621],
Cell[421540, 14149, 303, 9, 70, "BulletedText",
 CellTags->"nlug:3.6.1",
 CellID->300129566],
Cell[421846, 14160, 115, 2, 70, "BulletedText",
 CellTags->"nlug:3.6.1",
 CellID->112225757],
Cell[CellGroupData[{
Cell[421986, 14166, 95, 2, 70, "BulletedText",
 CellTags->"nlug:3.6.1",
 CellID->716654330],
Cell[422084, 14170, 293, 9, 70, "Text",
 CellTags->"nlug:3.6.1",
 CellID->23156]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[422438, 14186, 126, 2, 70, "Subsection",
 CellTags->{"Interop Assembly", "nlug:3.6.2"},
 CellID->17803],
Cell[422567, 14190, 979, 21, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->24466],
Cell[423549, 14213, 1264, 34, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->10828],
Cell[424816, 14249, 373, 11, 70, "DefinitionBox",
 CellTags->"nlug:3.6.2",
 CellID->16288],
Cell[425192, 14262, 92, 2, 70, "Caption",
 CellTags->"nlug:3.6.2",
 CellID->343302148],
Cell[425287, 14266, 207, 5, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->24764],
Cell[CellGroupData[{
Cell[425519, 14275, 259, 8, 70, "Input",
 CellTags->"nlug:3.6.2",
 CellID->31935],
Cell[425781, 14285, 177, 5, 70, "Output",
 CellTags->"nlug:3.6.2",
 CellID->17072]
}, Open  ]],
Cell[425973, 14293, 957, 23, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->12833],
Cell[CellGroupData[{
Cell[426955, 14320, 116, 3, 70, "Input",
 CellTags->"nlug:3.6.2",
 CellID->12920],
Cell[427074, 14325, 4598, 150, 70, "Output",
 CellTags->"nlug:3.6.2",
 CellID->20002]
}, Open  ]],
Cell[431687, 14478, 715, 21, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->19202],
Cell[CellGroupData[{
Cell[432427, 14503, 179, 5, 70, "Input",
 CellTags->"nlug:3.6.2",
 CellID->13048],
Cell[432609, 14510, 276, 9, 70, "Output",
 CellTags->"nlug:3.6.2",
 CellID->13506]
}, Open  ]],
Cell[432900, 14522, 356, 9, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->16913],
Cell[CellGroupData[{
Cell[433281, 14535, 241, 8, 70, "Input",
 CellTags->"nlug:3.6.2",
 CellID->25361],
Cell[433525, 14545, 93, 3, 70, "Output",
 CellTags->"nlug:3.6.2",
 CellID->25210]
}, Open  ]],
Cell[433633, 14551, 423, 9, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->17784],
Cell[434059, 14562, 409, 13, 70, "Input",
 CellTags->"nlug:3.6.2",
 CellID->8064],
Cell[434471, 14577, 429, 12, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->18771],
Cell[CellGroupData[{
Cell[434925, 14593, 173, 5, 70, "Input",
 CellTags->"nlug:3.6.2",
 CellID->23392],
Cell[435101, 14600, 2015, 63, 70, "Output",
 CellTags->"nlug:3.6.2",
 CellID->4012]
}, Open  ]],
Cell[437131, 14666, 803, 22, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->14938],
Cell[CellGroupData[{
Cell[437959, 14692, 179, 5, 70, "Input",
 CellTags->"nlug:3.6.2",
 CellID->3789],
Cell[438141, 14699, 276, 9, 70, "Output",
 CellTags->"nlug:3.6.2",
 CellID->21101]
}, Open  ]],
Cell[438432, 14711, 1000, 29, 70, "DefinitionBox3Col",
 CellTags->"nlug:3.6.2",
 CellID->18769],
Cell[439435, 14742, 239, 9, 70, "Caption",
 CellTags->"nlug:3.6.2",
 CellID->20809],
Cell[439677, 14753, 2210, 59, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->7588],
Cell[441890, 14814, 504, 12, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->19774],
Cell[CellGroupData[{
Cell[442419, 14830, 167, 5, 70, "Input",
 CellTags->"nlug:3.6.2",
 CellID->31774],
Cell[442589, 14837, 1802, 52, 70, "Output",
 CellTags->"nlug:3.6.2",
 CellID->867]
}, Open  ]],
Cell[444406, 14892, 114, 2, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->2838],
Cell[CellGroupData[{
Cell[444545, 14898, 180, 5, 70, "Input",
 CellTags->"nlug:3.6.2",
 CellID->20456],
Cell[444728, 14905, 95, 3, 70, "Output",
 CellTags->"nlug:3.6.2",
 CellID->4198]
}, Open  ]],
Cell[CellGroupData[{
Cell[444860, 14913, 112, 2, 70, "Subsubsection",
 CellTags->"nlug:3.6.2",
 CellID->31228],
Cell[444975, 14917, 1094, 27, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->29753],
Cell[446072, 14946, 181, 5, 70, "Program",
 CellTags->"nlug:3.6.2",
 CellID->30709],
Cell[446256, 14953, 132, 4, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->3864],
Cell[446391, 14959, 167, 6, 70, "Input",
 CellTags->"nlug:3.6.2",
 CellID->13720]
}, Open  ]],
Cell[CellGroupData[{
Cell[446595, 14970, 92, 2, 70, "Subsubsection",
 CellTags->"nlug:3.6.2",
 CellID->17809],
Cell[446690, 14974, 889, 17, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->30125],
Cell[447582, 14993, 795, 18, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->17905],
Cell[448380, 15013, 968, 25, 70, "Text",
 CellTags->"nlug:3.6.2",
 CellID->29007],
Cell[CellGroupData[{
Cell[449373, 15042, 207, 7, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.6.2",
 CellID->8418],
Cell[449583, 15051, 307, 10, 70, "Output",
 CellTags->"nlug:3.6.2",
 CellID->10900]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[449951, 15068, 86, 2, 70, "Subsection",
 CellTags->"nlug:3.6.3",
 CellID->31728],
Cell[450040, 15072, 1180, 22, 70, "Text",
 CellTags->"nlug:3.6.3",
 CellID->21878],
Cell[451223, 15096, 334, 10, 70, "DefinitionBox",
 CellTags->"nlug:3.6.3",
 CellID->21827],
Cell[451560, 15108, 83, 2, 70, "Caption",
 CellTags->"nlug:3.6.3",
 CellID->4403],
Cell[451646, 15112, 1192, 26, 70, "Text",
 CellTags->"nlug:3.6.3",
 CellID->18955],
Cell[452841, 15140, 286, 6, 70, "Text",
 CellTags->"nlug:3.6.3",
 CellID->15739],
Cell[CellGroupData[{
Cell[453152, 15150, 187, 6, 70, "Input",
 CellTags->"nlug:3.6.3",
 CellID->7540],
Cell[453342, 15158, 306, 10, 70, "Output",
 CellTags->"nlug:3.6.3",
 CellID->21019]
}, Open  ]],
Cell[453663, 15171, 823, 22, 70, "Text",
 CellTags->"nlug:3.6.3",
 CellID->27680],
Cell[454489, 15195, 400, 13, 70, "Input",
 CellTags->"nlug:3.6.3",
 CellID->5393],
Cell[454892, 15210, 773, 21, 70, "Text",
 CellTags->"nlug:3.6.3",
 CellID->42467692],
Cell[CellGroupData[{
Cell[455690, 15235, 294, 8, 70, "Input",
 CellTags->"nlug:3.6.3",
 CellID->10792],
Cell[455987, 15245, 147, 5, 70, "Output",
 CellTags->"nlug:3.6.3",
 CellID->7726]
}, Open  ]],
Cell[456149, 15253, 1691, 41, 70, "Text",
 CellTags->"nlug:3.6.3",
 CellID->657145216],
Cell[457843, 15296, 300, 14, 70, "Input",
 Evaluatable->False,
 CellTags->"nlug:3.6.3",
 CellID->12359]
}, Open  ]],
Cell[CellGroupData[{
Cell[458180, 15315, 81, 2, 70, "Subsection",
 CellTags->"nlug:3.6.4",
 CellID->1539],
Cell[458264, 15319, 707, 17, 70, "Text",
 CellTags->"nlug:3.6.4",
 CellID->22981],
Cell[CellGroupData[{
Cell[458996, 15340, 212, 7, 70, "Input",
 CellTags->"nlug:3.6.4",
 CellID->17552],
Cell[459211, 15349, 307, 10, 70, "Output",
 CellTags->"nlug:3.6.4",
 CellID->25383]
}, Open  ]],
Cell[459533, 15362, 83, 2, 70, "Text",
 CellTags->"nlug:3.6.4",
 CellID->30442],
Cell[459619, 15366, 194, 7, 70, "Input",
 CellTags->"nlug:3.6.4",
 CellID->1979],
Cell[459816, 15375, 249, 8, 70, "Text",
 CellTags->"nlug:3.6.4",
 CellID->24807],
Cell[CellGroupData[{
Cell[460090, 15387, 160, 5, 70, "Input",
 CellTags->"nlug:3.6.4",
 CellID->8889],
Cell[460253, 15394, 319, 9, 70, "Output",
 CellTags->"nlug:3.6.4",
 CellID->25780]
}, Open  ]],
Cell[460587, 15406, 771, 21, 70, "Text",
 CellTags->"nlug:3.6.4",
 CellID->31265],
Cell[CellGroupData[{
Cell[461383, 15431, 203, 6, 70, "Input",
 CellTags->"nlug:3.6.4",
 CellID->4783],
Cell[461589, 15439, 760, 24, 70, "Output",
 CellTags->"nlug:3.6.4",
 CellID->15794]
}, Open  ]],
Cell[462364, 15466, 1190, 27, 70, "Text",
 CellTags->"nlug:3.6.4",
 CellID->8463],
Cell[463557, 15495, 723, 15, 70, "Text",
 CellTags->"nlug:3.6.4",
 CellID->17013],
Cell[CellGroupData[{
Cell[464305, 15514, 288, 9, 70, "Input",
 CellTags->"nlug:3.6.4",
 CellID->20925],
Cell[464596, 15525, 305, 10, 70, "Output",
 CellTags->"nlug:3.6.4",
 CellID->1961]
}, Open  ]],
Cell[464916, 15538, 202, 5, 70, "Text",
 CellTags->"nlug:3.6.4",
 CellID->16397],
Cell[465121, 15545, 204, 6, 70, "Program",
 CellTags->"nlug:3.6.4",
 CellID->14361],
Cell[465328, 15553, 455, 15, 70, "Text",
 CellTags->"nlug:3.6.4",
 CellID->7485],
Cell[465786, 15570, 899, 21, 70, "Text",
 CellTags->"nlug:3.6.4",
 CellID->13095]
}, Open  ]],
Cell[CellGroupData[{
Cell[466722, 15596, 107, 2, 70, "Subsection",
 CellTags->{"Handling COM Events", "nlug:3.6.5"},
 CellID->23007],
Cell[466832, 15600, 523, 13, 70, "Text",
 CellTags->"nlug:3.6.5",
 CellID->17156],
Cell[467358, 15615, 961, 19, 70, "Text",
 CellTags->"nlug:3.6.5",
 CellID->27544],
Cell[468322, 15636, 345, 9, 70, "Text",
 CellTags->"nlug:3.6.5",
 CellID->4605],
Cell[CellGroupData[{
Cell[468692, 15649, 198, 7, 70, "Input",
 CellTags->"nlug:3.6.5",
 CellID->6624],
Cell[468893, 15658, 323, 9, 70, "Output",
 CellTags->"nlug:3.6.5",
 CellID->16056]
}, Open  ]],
Cell[469231, 15670, 427, 9, 70, "Text",
 CellTags->"nlug:3.6.5",
 CellID->20892],
Cell[469661, 15681, 82, 2, 70, "Text",
 CellTags->"nlug:3.6.5",
 CellID->12250],
Cell[469746, 15685, 198, 7, 70, "Input",
 CellTags->"nlug:3.6.5",
 CellID->16085],
Cell[469947, 15694, 148, 5, 70, "Text",
 CellTags->"nlug:3.6.5",
 CellID->2420],
Cell[470098, 15701, 314, 11, 70, "Input",
 CellTags->"nlug:3.6.5",
 CellID->9431],
Cell[470415, 15714, 202, 5, 70, "Text",
 CellTags->"nlug:3.6.5",
 CellID->31516],
Cell[CellGroupData[{
Cell[470642, 15723, 147, 5, 70, "Input",
 CellTags->"nlug:3.6.5",
 CellID->28786],
Cell[470792, 15730, 280, 9, 70, "Output",
 CellTags->"nlug:3.6.5",
 CellID->5034]
}, Open  ]],
Cell[471087, 15742, 447, 8, 70, "Text",
 CellTags->"nlug:3.6.5",
 CellID->7491],
Cell[471537, 15752, 610, 15, 70, "Text",
 CellTags->"nlug:3.6.5",
 CellID->28647],
Cell[CellGroupData[{
Cell[472172, 15771, 204, 6, 70, "Input",
 CellTags->"nlug:3.6.5",
 CellID->365266020],
Cell[472379, 15779, 1210, 36, 70, "Output",
 CellTags->"nlug:3.6.5",
 CellID->947]
}, Open  ]],
Cell[473604, 15818, 940, 23, 70, "Text",
 CellTags->"nlug:3.6.5",
 CellID->14889],
Cell[474547, 15843, 755, 21, 70, "Text",
 CellTags->"nlug:3.6.5",
 CellID->31092],
Cell[475305, 15866, 253, 8, 70, "Input",
 CellTags->"nlug:3.6.5",
 CellID->23296],
Cell[475561, 15876, 694, 18, 70, "Text",
 CellTags->"nlug:3.6.5",
 CellID->163936306],
Cell[476258, 15896, 840, 22, 70, "Input",
 CellTags->"nlug:3.6.5",
 CellID->28223],
Cell[477101, 15920, 1360, 37, 70, "Text",
 CellTags->"nlug:3.6.5",
 CellID->32172],
Cell[478464, 15959, 204, 7, 70, "Input",
 CellTags->"nlug:3.6.5",
 CellID->11048],
Cell[478671, 15968, 252, 6, 70, "Text",
 CellTags->"nlug:3.6.5",
 CellID->23],
Cell[478926, 15976, 105, 2, 70, "Text",
 CellTags->"nlug:3.6.5",
 CellID->22291],
Cell[479034, 15980, 242, 8, 70, "Input",
 CellTags->"nlug:3.6.5",
 CellID->18166],
Cell[479279, 15990, 258, 8, 70, "Text",
 CellTags->"nlug:3.6.5",
 CellID->30261]
}, Open  ]],
Cell[CellGroupData[{
Cell[479574, 16003, 89, 2, 70, "Subsection",
 CellTags->"nlug:3.6.6",
 CellID->4981],
Cell[479666, 16007, 953, 19, 70, "Text",
 CellTags->"nlug:3.6.6",
 CellID->941],
Cell[480622, 16028, 787, 19, 70, "Text",
 CellTags->"nlug:3.6.6",
 CellID->16461],
Cell[481412, 16049, 105, 2, 70, "Program",
 CellTags->"nlug:3.6.6",
 CellID->29443],
Cell[481520, 16053, 1407, 39, 70, "Text",
 CellTags->"nlug:3.6.6",
 CellID->12245],
Cell[482930, 16094, 316, 10, 70, "Text",
 CellTags->"nlug:3.6.6",
 CellID->3696],
Cell[CellGroupData[{
Cell[483271, 16108, 159, 5, 70, "Input",
 CellTags->"nlug:3.6.6",
 CellID->14229],
Cell[483433, 16115, 171, 5, 70, "Output",
 CellTags->"nlug:3.6.6",
 CellID->123827466]
}, Open  ]],
Cell[483619, 16123, 368, 9, 70, "Text",
 CellTags->"nlug:3.6.6",
 CellID->23900],
Cell[CellGroupData[{
Cell[484012, 16136, 173, 5, 70, "Input",
 CellTags->"nlug:3.6.6",
 CellID->3650],
Cell[484188, 16143, 271, 9, 70, "Output",
 CellTags->"nlug:3.6.6",
 CellID->6703]
}, Open  ]],
Cell[484474, 16155, 478, 13, 70, "Text",
 CellTags->"nlug:3.6.6",
 CellID->24828],
Cell[CellGroupData[{
Cell[484977, 16172, 623, 20, 70, "Input",
 CellTags->"nlug:3.6.6",
 CellID->14731],
Cell[485603, 16194, 272, 8, 70, "Output",
 CellTags->"nlug:3.6.6",
 CellID->8941]
}, Open  ]],
Cell[485890, 16205, 284, 8, 70, "Text",
 CellTags->"nlug:3.6.6",
 CellID->24523],
Cell[CellGroupData[{
Cell[486199, 16217, 148, 5, 70, "Input",
 CellTags->"nlug:3.6.6",
 CellID->1942],
Cell[486350, 16224, 119, 3, 70, "Output",
 CellTags->"nlug:3.6.6",
 CellID->22710]
}, Open  ]],
Cell[486484, 16230, 654, 17, 70, "Text",
 CellTags->"nlug:3.6.6",
 CellID->8388],
Cell[487141, 16249, 134, 4, 70, "Input",
 CellTags->"nlug:3.6.6",
 CellID->6013]
}, Open  ]],
Cell[CellGroupData[{
Cell[487312, 16258, 74, 2, 70, "Subsection",
 CellTags->"nlug:3.6.7",
 CellID->788],
Cell[487389, 16262, 260, 9, 70, "Text",
 CellTags->"nlug:3.6.7",
 CellID->23479],
Cell[487652, 16273, 185, 5, 70, "Text",
 CellTags->"nlug:3.6.7",
 CellID->8073]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[487876, 16283, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

