(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5697,        195]
NotebookOptionsPosition[      5036,        167]
NotebookOutlinePosition[      5430,        184]
CellTagsIndexPosition[      5387,        181]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 ".NET/Link Example: A \"Nice\" Function (Setting the Kernel Process \
Priority)\n\n",
 StyleBox["This is a very simple example demonstrating some basic .NET/Link \
programming. One nice use for .NET/Link is to get closer to the operating \
system level than ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" normally allows. Here we use some .NET classes for controlling \
processes.\n\nThis example presents a function called ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Nice", "Input",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[", which lowers the ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" kernel process' priority during the execution of its argument. It \
is reminiscent of the Unix command ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["nice",
  FontFamily->"Courier New",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[".\n\n",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["To try this example, evaluate all the initialization cells (you \
can do this with the menu command Kernel/Evaluation/Evaluate Initialization). \
Then go to the Example section.",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code and Explanation", "Section"],

Cell[TextData[{
 "This example demonstrates a typical structure for a .NET/Link program:\n    \
 - It does not need to return any .NET objects, so it wraps the entire \
computation in ",
 StyleBox["NETBlock",
  FontWeight->"Bold"],
 ", which allows all objects created during the running of the program to be \
released when it ends.\n     - It calls ",
 StyleBox["InstallNET",
  FontWeight->"Bold"],
 " at the start to ensure that .NET is running."
}], "Text"],

Cell["\<\
Needs[\"NETLink`\"];

SetAttributes[Nice, HoldFirst];

Nice[expr_] :=
\tNETBlock[
\t\tModule[{kernelProc, origPriority, result},
\t\t\tInstallNET[];
\t\t\t(* We need to call a static member from this class (the GetProcessById \
method),
\t\t\t   so we ned to use LoadNETType to load the class.
\t\t\t*)
\t\t\tLoadNETType[\"System.Diagnostics.Process\"];
\t\t\tkernelProc = Process`GetProcessById[$ProcessID];
\t\t\t(* Here we get the PriorityClass property of the kernel's Process \
object. *)
\t\t\torigPriority = kernelProc@PriorityClass;
\t\t\tCheckAbort[
\t\t\t\t(* Set the priortiy to Idle level. Although we are accessing a static \
member (the Idle value
\t\t\t\t   from the ProcessPriorityClass enum), we do not need to call \
LoadNETType on the enum class
\t\t\t\t   because it was already loaded when we returned the \
kernelProc@PriorityClass object above.
\t\t\t\t*)
\t\t\t\tkernelProc@PriorityClass = ProcessPriorityClass`Idle;
\t\t\t\t(* Perform the computation. *)
\t\t\t\tresult = expr;
\t\t\t\t(* Restore the original priority. *)
\t\t\t\tkernelProc@PriorityClass = origPriority;
\t\t\t\tresult,
\t\t\t(* If aborted *)
\t\t\t\t(* We are careful to restore the original priority if aborted. *)
\t\t\t\tkernelProc@PriorityClass = origPriority;
\t\t\t\t$Aborted
\t\t\t]
\t\t]
\t]\
\>", "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section"],

Cell[TextData[{
 "Here is a time-consuming call that we can wrap in ",
 StyleBox["Nice",
  FontWeight->"Bold"],
 ". The integration will eventually fail to converge after 5000000 \
iterations. The computer's CPU meter will remain pegged while this is \
running, but any other operations you perform on the computer will take \
priority over the computation."
}], "Text"],

Cell["\<\
Nice[
\tNIntegrate[x^2/(Cos[x + y + 1] + 5), {x, 0, 5}, {y, 0, 5}, PrecisionGoal \
\[Rule] 50, MaxPoints \[Rule] 5000000]
]\
\>", "Input"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1046, 643},
WindowMargins->{{1, Automatic}, {Automatic, 0}},
DockedCells->(None& ),
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 21, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 1955, 59, 319, "Title"],
Cell[CellGroupData[{
Cell[2570, 86, 39, 0, 67, "Section"],
Cell[2612, 88, 461, 11, 71, "Text"],
Cell[3076, 101, 1345, 40, 606, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[4458, 146, 26, 0, 37, "Section"],
Cell[4487, 148, 370, 8, 41, "Text"],
Cell[4860, 158, 148, 5, 50, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

