(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    357994,       6504]
NotebookOptionsPosition[    357192,       6468]
NotebookOutlinePosition[    358021,       6504]
CellTagsIndexPosition[    357978,       6501]
MenuPosition->1100
WindowFrame->Palette
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 TagBox[GridBox[{
    {""},
    {
     DynamicModuleBox[{$CellContext`gnames$$ = {
      "DarkRainbow", "Rainbow", "Pastel", "Aquamarine", "BrassTones", 
       "BrownCyanTones", "CherryTones", "CoffeeTones", "FuchsiaTones", 
       "GrayTones", "GrayYellowTones", "GreenPinkTones", "PigeonTones", 
       "RedBlueTones", "RustTones", "SiennaTones", "ValentineTones", 
       "AlpineColors", "ArmyColors", "AtlanticColors", "AuroraColors", 
       "AvocadoColors", "BeachColors", "CandyColors", "CMYKColors", 
       "DeepSeaColors", "FallColors", "FruitPunchColors", "IslandColors", 
       "LakeColors", "MintColors", "NeonColors", "PearlColors", "PlumColors", 
       "RoseColors", "SolarColors", "SouthwestColors", "StarryNightColors", 
       "SunsetColors", "ThermometerColors", "WatermelonColors", 
       "RedGreenSplit", "DarkTerrain", "GreenBrownTerrain", "LightTerrain", 
       "SandyTerrain", "BlueGreenYellow", "LightTemperatureMap", 
       "TemperatureMap", "BrightBands", 
       "DarkBands"}, $CellContext`gimages$$ = {
       Raster[CompressedData["
1:eJzlVPk71PsXVyiRpdFKZW1Dst2WK72mIlmTtCdRqchSShI3KimlXNwUIpSS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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVVHk01AsDRaKiT4RUKusj5VU8IukmirI8XtPykp3X9lVk6aOSLPUQoQUV
2bJE5LRIlmfJvsyMwYxtmPVnzJCE90Q83x/3nPvXvffcc89V97z6m88KMTEx
8WX4LOP//KtN5f60HUwYl4wVKTMqwFmKz3ccGkF+O7/70L1B5GanPAz/pRJK
AWfMQhJZcHOUvzzK7odSypGQiYRKWI9qd2YfZmNDt9nK+AN9iLo/7X5mvBLB
Z7+6d8yx0XnqjzTDp3RMh2VZNx6tQiGl8tvsaw6iBhKM+mZ64B3o+LNBbhWG
rP68q+bJxX63io5Qp27QLiwqpktUQ678+MZjyjxM7f6s2upHw7PkH6kN72qg
ETvVvf8VD3mqGxYzaV1Q2xLtsiCog56Ofvo1Qz5cVl0cDjbqQk6WorrhtgYY
1J87l1/Jh8J0ZY1TMhV6uhncC6QmmLll7WYeJtA0LJe1fY6C4tc78jOiW2A5
Pzi3nkzgZptnhLgzBQaGZZfo1W2wTd5Qf/T0KLimBrXGKyhYr5xo8sS8Ezoy
ddG5FaNYOLHwIYlDhk7h2XsT4RQwTg7a682NYo/JI2FZDRlWbb5T8gQV0Vmz
8sXGAvhs2qk2lEaGpzDSxciWhn0T63r3BAiQulBPkrhBRphMavPpkm4ITXc8
fV8qQCfTOVrnNBlpO14b3lzfi2dRh11NvwjwuGFXOHGGjKq1TKUWXzrIhZNb
hCpjUP5U1nS9kwyekY9LUjkDcR4OlJ+kx2BLfyElqU6BrKsox1miH7YbisI9
ZwS4T/Xa3n6GAqO7/iIt2wGs7lhtlM4RoL1Nx+7RIwpcir8bTjwcRGP4OaKP
KsDaRuGVs50URPbeuVE2OIRIk4ZUpRoB7GtKErVWUVG0uKo+THsYhyY07JyK
BQhqNGVf96WC2/bxnI/iCFa2xc0JnQVIb683aGNQcU1l/PKaJyNoyvsn9+5q
AZq67CO2WnRBzEc9oGQDCzGRXiT1slF8YdBpfgVdiCs9EUJKZcHeo1O80nsU
KsMeWg3yNGxejA6b28TGugOmJScVRmHBEwaohNBQcKz6bvpzNro25Zz9+heB
jSruldeWaHj/Yp2elAQHxG7tt7MOBMIkO8RC4rshsqsTl3TloE5yxaFWGh+j
k6aH72zpgeZ3/z7xTxykMUYoaaf5cBzKjf6zqAdn8rRLl5S4CC6qdvMb4qGs
ZX3nA7NeJJDof/7w44IU9nzCypOHrR/CFJJbe9EkHu0+38HFLlLILRWCiwtv
tCskL9NxXJk89vMmHkiTwil/by5SPko0MzQYMEoq0Ek5yUMd6avDqX4OGmuG
u4sYDGz4T6S3+EMedpXPvtrnyMF0cyUrLL4Pc9GumRfJPKRtWZDa2siGBjV1
gmTVj4GVpkyaDB+y4eJe4vvZcOwLmtf93o+qO+s3m9vwEcKX+otbyoJHtPQj
+/IBDLP72qtD+bgSS57M387C5j1vyV6PBtHwzWsoOpuPf76ysuXyRtDNcJUJ
uTqEQsmJcVIzH+Gnp08GaY0gLmyNdcIxJhKU/re4bZwPldC1ip8sh3FY90N4
7vI+gn6SkBPKE9C3NQi5d4CJJWK3m6vYCJz33t/2wZjAQZVTIyTTIQxWSN0S
XB6BhY3y7jvOBEi8G0c0fhkE3/XHjsuCEZCULKWTLxOYkn8tGj87gEnx6f5J
bxb+YF9lFt0m8OAAM6k8qh/zOWPRASMsBJc8f1+XuOx7Sc40qrgPK21YJv84
sxF7s+U+I5tAa/LBYUc6A3JCOnGDzkb60VmvifcEzn/2i1IVY2BjfOeTpd84
eKOsaSbZTGDl16wdo7p0FGag5jmVg1cm4QpX2ggEGmdFWIf2QjGi79whJy6e
qU8JvrUQiOhLqA1n9+CWj7/cKIWL+2s8a4OXdeJv3l6qOtIDwnptWZwjD7e+
UVOWGgmkbrtiPveqG056ea6GFB6uDFr4RjUQyKk7e+MXuW5UyFpI9f3Kh1tD
qbXMZwIlPrblV/1puKhu5nCilQ//WIVTh5bzx4ppwv5bF1zOPzbOB4GCn73T
9VIJmDzkyHbEd8Gx5MvW+XcEmNT3PIVbBLjaOf12el2wmj0q7aA3CsVAaf15
dwKJH73z2xuo2Gue8yXjxSiOqfwewLEiYG6rHWTnsfyzkYv0b4oChFW8qmjT
JTA2xLNsX6BgSOe8XGyEAA6SSTv3riCgSPVRi8qkoIO1ZPhlSACB+b5NO2v5
+MjT3C7woKDqWfLp4yZjiLzOlla/zYfzd9Yeew0KXp/YdassaQzbSmNmlMz5
+LHlYKBnAxnpck2Zm8fHUD5mwFkzz4OldeVdvSNkxLe4Nt62FoKkNUBZ+shD
jK9JylRjJ25HzI5xMoWYcImong7igZL6ruCTdScekM3CZGhCxB+OtitZwUNt
KedJLbMD6ZvvKBlKirBL/0H/hQQuSlsUIpsDO1B8rvHVGSMRyIqPz2tt4SKL
ZeFHlu1A1VuZg+F/iHB14ekss4CDpDlf197sdnQsOfYUJIuwjpsRmWrMQYR8
hu3QvnYM2j65SG0W4U1brgKpng3/7WQTLrUNvsMPVcd6RbBKWXmvR4cNXmLW
IcNTbRiICdY/3idCqFR42kQoC/pKEief9rbiiLHbgcoBESoCFt9K947georH
BfGTrShlWf2qzRRhhh3SqqY/gr82194839MC1Tg99/gREdyzJmr9Vw1D+oVa
ApnUgnsm6/z+ZovQE0pMvPwwhF81wrKNu5tx6SVhM00TQcVM89Aas0FYxa6u
OmjRjGbaGyLyrQh69MyKjMf94PVVDo4/a4K2RMhdpYci7PdXM9o7ycA9Xd/l
RhpxZ7eldu41ERzkXhR3HKND97qmqo1TI5iusp+Nf1vOU7hF1/tlD1oaes1m
ChuwL67Hs2mPCNesn2d+X/7vS4oxzllSDVi9U9IzT0GEH+4Mm5Lfu9An0I0I
8fmMXape4YF/CzEzZRdc/YaCwuMxdTRKPUiydVmWg0JwV0ccfya3vIMqobj+
/nqELKjVy9cK0a3/33flVa1w0rG3uJtXhxei25zhl0LUO51QYlxqgmZicdiw
Qh0aBpkrimOEeBt4IGh242fMfJerMQmtxVi7udbNq0JkperQFZtr0OTtt5Qo
qMG/ZUbp9w==
        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVlnk4lVkcx5GISpZQERWZpEmaKEN9UaK9JCldoa7lylJZomTJrbSIMpIt
ZZAlZSmpaCcqJNV0Q9x9ed9XRpYozTt/nOc5z3nOH7/zO5/v55y5PiEuzAly
cnLy9GDS4/+5+0Xbj8PeYgjso8/oz+vGbJFVr+dMCrIKmXDsnBh+ZqWPx752
YzG51bjZmMLxt5lDv2rEkEzvHOI8+oJVAyw/yyUU1PvXKSnyxLCMPanDcOrB
lu+JJXk2FPLVv2tPUpNgaCC34nV5D/b+yiUnO1GwWnJj/hRrCWr8azba6vQi
dGLtkkgXCk1bdlqq75fgSFerqDSmF3GT3x3mMih4hCg5Tr8ggbWLOEFP0ItU
DfLupgAKVPId1xn3JRhtkDM4u5GL67rKo/fCKMSX79+vL5Dggc3M2tEqLipn
z11pHEeBsYrckKorRf+VVOGyr1wQ06znJRIkpg4cvPV8vRSCwag+/QU8pPpK
Y344k6grGtIciZHi0zafEUUvHqzqsj6FFRAI2nM0wqxCipab6+XJyzxwtDZZ
kvIEZmvIcTz5UjxV+UP1fSsPsazxFKanDG9eJK68qCtDDVNPq06ZD+Mnt4iu
+1LERKtce7FehtInE/QLwMdLXW9nN7q+382TFb/HyJA3mzA+H8lHULDm3y2H
JejiafovqpAhLarj9/BbfGi+ePZrbZsYaivTFhtwZOAzfvY/+cJHhb022eMm
RsXA52Mv5Qgwryz7wVATYCkvqOCjUATXEqNXh34jIOgIVBq1FaA6sYHREiHC
sFfgzNmbCfiq56unBwpgZWKo80JJhEzdKr/GMALCDZxZSzMFqGmMbHmQLsTK
ltE7B7MI+J3SmN/yUgDrgLaTlSZC9CQ6KOo/JSB66mzOGhbggaopiu8KkGBz
xqVBTMB/PNZaid5nWxY/fHWtAPP/fZsXOo2ExLpm9XVXIeo3cW6lf+DjvdXZ
FTMXkThtlEUqnBMiJ5QJ+ww+mtVbzeQdSRxq2bv9ZoMQ4yfyceEAH/VSTUMJ
g8SeKOPanfIi7L3ciy47Pqqeu2m+jSCx1lhioGArwuMSQzszbT6KcjMn1l4g
YdF6M7GMPv/ceoZdlISH7CPdI3k3SOhFH5K6VYiQ8DbLrrGOhxSXecTpJyQm
zl++VZ4Qgcf/ZKd9kQf2It8voRwSX1vH7pSaiLFmRNd+ny8PUUol7e4DJDjR
j/Xc6JwVTnazr/iTB0PF1AnHlSjcmJ67xiFfDPdJgj1qxjxc7nc45q5D4T2Z
JO8qEaNIf9essJk8qH/59m2pCQWFxvB6pjmdpyVvPn5S4+H068KgqVYUFud5
H40Ml8DR0f4vKPIgf99dKHKkcxO1aUXSAwnSdt1xKfjORVSR6t6nOyiccrEe
zJSXghdkqj65j4v+tIcfs5kUqs3mV5Y5SWGRkPMmlM8FKyF4a2Q4hR5FjZD6
81LEpWuc/fCJC27InKZtbApTu3+Ytb2TorWE7WzbykVzYHGZTQqFOieiqVJH
BteG3Cetb7hQW5dSr3yZAqfY04hyk8GiTmenSgcXLiaRbe9yKAxPfnvM9LIM
U6uTCQcOF+kTPLlX/6YwPXj1h/0fZZCWKCUc6+Hic8+ab4GlFCza7pjn6RJo
vHZc966QC8N6M6UVlRQ2L12Q9HkngfyMobI+got9WZozFGspHEjL5OpkEIi7
EOxgOsBF0ZHvpm2PKCQNTbF1+YfAnpPCjz50f2Q7emyyGygUusf+dX4GCesY
z6DsX1y0++seufScQoejKrN3A+0Fnx9SLy0enPt6q/praC8ejh28F0Ii39e7
krmch0fhZX1b6DoXXPvGTrlE88tqiGJ50P74EWFWnkvhbUuAjn8NieBgM/uQ
WB7KEuz9plykEP2juxCfSWw/lDIpLJ8HI5Up+Sy6z8YLXZfr/qLriRhsPdLI
w5ULH7pfHqHwZmdTIzWPgmH07ssxMpoTnWuzfjtAIZK9yr1hLYWJxx95Jkzj
42R2oBt7L4U5VVXiHBYFabyxyak/+FB9dLGqaQ1d52YWEo9TUDxhXV3kz0fB
v3qvvDQoXPLXOpgYQfs6VqH73gM+7EwKuMNdJMYTHl5PDKYQcPSVcjPtFc6u
xaPJJSQCcpgdib4UsiPTLD57CxB+vkbDJJJER42aEtuTQuthhgdRLYD6EzvT
utUk0F6znO1Gcx1qwv6pLETptyY7V3USJYRXAHszhWUH+srVPIRwWrDdXdZJ
QFtZNYtNn8vX/94/huVC9Hp0hiQU0/c6t+o1exWFK/vjFSzo3P9hfntPsS+9
vjL0S/VCCsmZa4bPMkQILBtcVDBKe5gxddBrmMQZ1khVabsI101tfuYly0DG
lKhOfU6C/WdZ6CsnMTiFcW+y58lgnOs0pzaFRLyq1++yh2JoGjfkZNyVwqOe
b8mkfRPD0ZKqLpVg3bXJwWn0O3KxO36DxkISUSWNhQuLJIg32LYqpVuCpnED
77ohAmHRR/et15eiNitd7dwhCX4ZPIwIeEYgdL35HFaqFF9ndHafUpLACrvO
aacQODCL15mkJMP55mXLl6aKMWmTTfMYzXlVCm8sL0KGfhFvgOwXQfP09jo/
VQJbB2x3aLTJsHPipdvFLiLMfhZ4+91DGYgd6eXxpgQezHMIYlYJ8dv/4gyR
Ielen/K/CQQM7fpN504XwsI6O710rgwmeuu8fei+JzLyhJ1hAtiGVSfpdkjx
LOb6/XZLEuLoLfkZ7/lYe+v1sRMnpfDuGdNaTft0Y8b4XlcrPrZK+SF9K6QY
d9gRVCUmcfvOTX11+r3cPf+nj4dMgqyC8gYjBwpFcaxDohEuIiwz/9meI8Fr
8xnpBqkU3LVuP21ncoEMP7+m9RK8dzRSSIikoFI4qFnf3guVsWVDq0bE6PZY
HCyg/wn3V9jsK0Yv3jEU2NUFYggPWnOcab4DX8VVpZX1IOdxq9bC7WL0nVqz
tozmwsCzYULczB74GeVcvyonxkjOlsppNPdXe3VvfJjyBRYnWRba5SLIV+82
OEzzIq+c73xT2IUx8fLHZzxEUG1mnvlA52H/osWSE4878XzDxC1yKvQ99IQO
WdMcNWyrTdqd+RnJ5e1d4XeF0Bs66pND5+Q/ydrkXw==
        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVlXs41dkexl1HUjEVJiXXQvuMIbdye2emiXMw5YiQTCK5RCnlEiPFuEWh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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVVXk81IkbJoWiJeVoiawrQtrdbApPB4YdchWSXK0jRFqpqOTIlkpZ69jo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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwdlXk41YkXxoksTWgSGktRuFq1oBlMr7FUg5L1SkYlJSENMUkrSotpIZQt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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJxllHk4FQgXxq/IVkJqBkMNaSJjyV7Uq0SpsUR2SRJaLJVBySRNNWJajMmV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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVlHk4FQgXxi8SoiyDRmRvIZWtkVIvaSzRhBjZSsmSJsZ2tSDJJA2hyIR0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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJxdVHk01YkXJ2lQSYsQlSWS6hFxyk99kq2xpLGUEGKIkX2pFO0vy5iQaow0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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJxdVWk4FQgbJVslO1kaIyVJJhExDGdqCFNhSEZEqkuUZYxK9A1ZImUpLcMk
MUJGspXKfru2iOtyrfdyF3e/kUpJi898P7/3ec7znvfH+5w/5zlH/2iEB0FK
QkJCchmEZfzL83L/naf4/11qcod62KIB26yNZF/FNoAteH0yntiA2pYilQ39
jSAOP4760a8JJjbO9gRRE1o9SvdzQ5rhddpxKseuBTbtbmmbVreC+4bq4LWi
FfOrhPd+z2pFQFjcb39+24awH0aP1ve3wt7HzE83oQ1JGqWH5HcQ8TZlPEE7
vw1pZTGqnZFElDVRfvrD6Tli+2l34kKJoHxo6YoMfI5ewleTOV8SJLSnGulW
z/GNk1y8jgcJcwrGa49HtuPiUeY4ZEgIuulqSdrdDo3HXkvDyR1YU8FeKKSQ
UMW5IQrb0QEb/wt8l9xO5Mxz1krfbceiBb1Q06AT/rIPBhofdEEbfIugsA44
JBv82qbehcTK0WemxG4UpAk9umw6kTl4UvGkTDdKD0oXFw2/gCFFHGm8sguj
G2pJ6u+70fPVNEND1IOKdbOZV6hd0I9ajG3mvsBsie+ZtKVemBPmKmaKunGy
bZfZiZEeqLulBnxS68PTyrcv3CNf4JHyJZ5KVy++/1DjHG7UDyzM82vserAU
QM5vePISlW6zf0Z+S0b7rgVZDfleuDzUPEC434e2jSkK5WVk7Lu8aHB2tBc5
X/1XK+X1Y/CDTiLbfACBPUyXtksvsUaRs/jddjKm4281n781gLPy3eHytn3o
v50XeSCHjHk59U8anweQsbcqx0vch6tb3bmx78mQzc62eniEgqLLt54U5Pfj
wDMZv0KfAazVUoh2bqeARmiZid5MhqZLw0Bn4wA2371UxdwyCJ7MDkmdBDLG
RiKdZvQo+J+9Mgfx5l6JWssoGbeDDJvUkyhwqUrcov52EF8cdQyPmw0gYH7C
3JZLwSHrJcID7yHIcTOsV6UPQD/5almgyyBCW+OK9jQOQfWi5N5K1gCmVZ2+
TasYRJzzwuTUeip0DU8f9rSloLTwc06l0hCukKPXnUuhYnMHP2Ihh4KQ7TWr
qFFDyP91zltVSIV5kF9ivpgCk5bg+E/UIVQywq7/4zoMO1ny9d2Og5jdrzuv
/z0VLSeEZIfaYTiX/FTKyx9EDY0S6nybCvLrIIVJzRF47Kl/euX9IKJPpjHC
l6hgxLBdzp4fwWGuca+Z2xCsFu0O3jg6jDmJIxeVmSM4cfHO5HDpED6mve1p
aB/Giks04n3HUfxuqDoXJ0FFo+b9XSyjEaip+CztLh/FHx0pUvo+VMSX+Nev
vDICg1yqLU1xDLEk/tOUGSpKT7fqrNEZBf+75waSWWM4Q9wbKUwaRp/Dhj+U
ykZRTqxSMFQaR1RrpaGb9gg+qCUzVXeOIdz7zvufs8YR3qxCr60cgR6b47CW
NAYz8eWpCKUJhDZG52g5jMKpxqlM22Mc8wnnuq5nTSD42YjLf8ZGEXHhvrwu
YxxPNYKrnyrRcOyJjQQrfAy33OUj1odP4Hz5gbzJLBr8H+c/3iM9jma9MMrG
zxMAdidJKdPhWycR9k/uOLgzfZab02lYMWR6yiibDu+aYxuVTSeg2Lw911iL
jo4Tul77lSfhWdUxFk2agFXGtc/fldCR/mW1fVT2JNwrt2SP+dAQ4PcuwMxi
EvuvLRjeUp7Cvoore+xnaUjdevC5BXESKpu5So3ZU3Aun/1clEzHw8V6Q2v3
KQjpIecjVzLgUOZRK6cziZFu7XTbyeX/MsbrRGcGdpU8Cjn1cBIJvU1n9HYy
UBnlTbiRxoBdsdb6AYcpqNeFG+n/hwElu76x0i4GrIrihi3Hp1D6l974BhID
kXKOrs9WMqHjHrHnpRUDtknkywbyTFAGGoi9zkxo9d8tjE9koD/0gp2hBxMW
t82tptKY8NS0aaWzGVgrLLhJLWeCKG3gXjvMRGbA4KStIxOHQ5pnk6VYcAvT
CEk1YKG79NSX3BImivk0Zws/FuhU2UTfKBakX8t8syDHgij4UyG7joVQ+4U8
01YWYF1gczCEBXOe9qdrCmwslAhqpRTZiE2w9ql7wcK5IOsDu4PYuKg00Tvi
y8ajroGzqiZstHIOPphrZkMtppfzz302XiufvBmZwYYc4bRsoeY0ChlNX+M/
sGHiI/2ob4YN1+mcAPfIaWz7N7gcpxFcmD9o4j6Nm8dqnix1TaOx+u52o5xp
3BXsfJNePQ0ai6zyUJ8DF51rLp8Zy7cZWVmgysHGo7Oh/rEcDCcmHSVv40Az
NsTUKZqDUKYCSWGQg+Oi6Lji8xx4EFe43qNyUH3ERLdpKxdznkHXY15wkLH6
9ikpKy4Wpn4+cyqZi/hG7wf7tLjo8rC8HPgnFwgI6V9H50Jhk0vH+iAupP7q
u9/ykYuLk6lGPZY85GXYTL2r5cKeHdyl68vDy8MlF2IzeTB6v3WhS5KHc1sl
eXGNPKjTSeNbeDw88tdVyXfjoe73PJlxXT58/dg7xsDHT52Kxr/l89Cjmk9Y
G8jHfiOB7MNEPvgJ3eYhozywqgvaPYr5wLuZseR2PjJskm0D1fhYcC/alMXj
w6z1XcWhlQKYv7N38HHlQ/F1cUqPsQAbrizGb98rwPCDj/t+ucTHpqxSjly4
AOq/SnjKZgoQF1zn5ULi44dt5Y4O1QLIGsga0sgCrNeP8N+1xIfny4p7Ce8E
WJiV/1itJkT7+Jbg720EWDa/TJOVEMIGld7Ug0KEXp+OMDstQIJ8DeFjrBC0
VM2Cw7lCKLkWxGypEuBWeV27ZbMQfZ66UTtoQtTJHbqgLxKg0qV+U5SkCC16
Gx1X6YmwXLbp2obLOssxVukgQrXISGsqUIQvsf3XVAKFmEht5AhTRfi7fpuo
rliEIov0v1bdFuKNYYvj5h4RbiRZNKfzRHCacSiWHBFiVUfbvWOKYqS62Vw9
YiyGuHSp4qOKCHoEkszdX8SIWffj8Z1hYmQHPns0t0+EndKdBNp1MUJ5jlZr
qsSwXHe6WbCst+/v7natUTH8aveuZr0RY3zItJNJFOHY7t5NXutewTX+F3q9
5SvEZwr7x76IEMvsS7nq/wo/7vWuyoh5BQPne6MD1mL8FzQ602o=
        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVUXk81YketY2SF+GiXnZpESmUaugkjfYSMh7KXjRCKI9kulkmy5AoWULT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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJw1Vnk01YkXV7LUME1Rivy8ahJjiRQV5qOSpqKFaRGVjLVMkVAqDE1ECD9Z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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJxllGk0FYgbxlVU1rQQI5WMMpREspSeKEtZSjRkGmIwSllSiqJoVBqRmIZo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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwV1Hk41WkbB/BjSjIqS71FGpMkKR0mjiZL30pmSk0GI5U1orJEaOFMEkKD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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJw1lns0FGgfxw1KRVLZTcjlzVabBmWjNvmK1ZKylnJd3Y0SRe5tbZtahWhd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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVlHk41QkbhpVRUaGF7KJFVJ9pE8IzllFyjq2yjEmWzERfolL2LNmKyDLS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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVlHk4FIoCxWkhPCSNUCLVLbcFZb/lJOF1kbKVQkou6iJjCRG5RQtp4/bs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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwdlHk4FXgXxy+ylIpMWUJRZqgZZYlK9LWHFrmkZUjWmTKWJqRUI6PIriyT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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVVXk0lWkcrjFlT6mImJGUiiwlIvXYXREVoYmU0ghJamIs2WeUfWgZTTRF
2bWoaCEzliS0TNF89+N+73fdqyJRypr55o/fOe95znve87y/3/M8vyW+h7f7
ScyYMWMmV35c/X+e7SR4RZvTGFxvax86RqBq9MklxFAAA0cv69hNNCSHhXF+
owThRV27daUE+GFzV6WmBQ2N0sT7nl8Iyk0jqKcPepDo4KbWaElj/X6tL46f
CQI0rcd4gT2o4D1N/tGaxjb1BkOMECyXlVOuX9SDLnunEWlbGgdf7Qta84mA
/fiPkWlTN76xf7S3zI5GXIbE1WUfCfL5F7ZfP9oNHTubdmcejVzeZWbRMIFX
44GQlUu6scP2odmQA40bM63V5IYIFlXop//ZTiPGxvxqtiON1rvEfXqQ4OWZ
0VKVKBrF1tXzjbfQYI/GZw2/J/gtpr4layWNF1ZGsV3ONCZ0NZ/0DhA4+58S
S3fyMWV5rT9iK40FovrZr/sJZLe5zopP5MNzHkl+cJCG9T6T6F853Fprg7rf
Vj6E11rcLubSOFUQrz/E4V8YS/2bZnyEbL2ukdBK41lvG/MD935ZPs9y5jI+
JgfP9ftN0likrZLTwOF7vF1cXRT4SM6Ireat7oaP/347PY7ngsXufhfGKCzQ
90/U2d2NK8WVo2c5vKXLK+wdSyG/3WXrnIxuDLwdL5nJ/Tf6zL6Tpu0UdIJN
1IbqumGka+cdyOGGbgHnf62mcEf++74XH7oReShL4SWHi+YdKX95iYJ1+eyq
20t68FcFv37TB4LcjrC6pWkUOpzex/y+vQfSH7SPFXG4c9qJZ0fCKOzqf+kY
ldCDrYZHlyty/ZdwTGLr9lIQpzxQ9qnqwdnQ2q5IDr8jlToi70QhxZbarDja
A6nw61VR3Bx3SgRKvtlM4VzMZC1RFyA8uiAzmpv7xJSDSoMDhQCvFM/7EOBN
/NmgE5xOLoyu0MnnUTA3VR0+vZfTY/IpXgynq00fJTdG2FOYo1SccjhBgMdp
0VqxnA4FAyLnHXYUmGGTZQ6FAmzIDpkRx+k2vq9xj4EthZsdTbWazQKUntvH
j+N0rsUWhMraUEgq2+E52SeAWp57dTzniyY6IVFkRcHjpHDopQyDtMsOOQnj
BP5dvmfqLSmsOnA0pVKXwVSReUjiBIH0C8uiPywoTFp9s+ykM4PgCn2npEmC
0jaNu2Gg0P59Vq1vCIOem5orfpki2PJounX7JgqXQmSfnk5lMFbiGFXA8eyz
NZEz2EghfN2RnZqXGTzILuEJ3hJE2jVHKJhTcB5/RSpqGMRGSS9U6yZQsPd4
896MgladedCGpwxs/PwZj2cEl+3FHu2mFMYSLo00ixhIOTeXZzcQGPPCmsrX
c/PlScW4TTFoNV4e0XGH4DFPcl2aCYVC+WApZj5BxvdJdrKlBN4OZy8HGVOI
fP4i69AqAlcpoaJ9HsGQg7ai0zoK286aLh63IFAasuqJzyJI2nwnVseIgrZX
fsEvHgT/vv6ztDaR86mj/aDMWq4/GrP05gcT5P01I3w8jPOFY6f3W0MKz3sD
7uRz9/aW+tgYBxLA6ccnLQYUikqeWuieJ1iWUzs3dDfBC6cvZsX6FEZMMz2n
CwnIkWyHTy4EVtOPA//cQMGyxSXk+TWCiy7+8cctCa5fz/vjd04n6Z4KyYX3
uP+s3nhvdA3Bkv2hbVmuFP4Vt+eHN3E5KKv4KUKLIFPJ7utJH45/WPodR66P
XX0i3amFBNOPVPTjAykcne3c8R2f4HTTPb8YSYLgyAGfCM4XD0/Li4dEBNsL
MvNmjjGgV9dnhiZQkFvW9rWB88PceL/OhLcMtghy6gMyKOysSlU6x+mjzcds
7mw+g/u/+Q/7nqdwxdpJL1CSRcpGBYfkNgY6tuZLd12lMPxc1m6TIgveYmGc
TB2D3C8Kbq43KcC31XueOotZY9V3U68xkC5hEx3rKKwYZP3TdVmETM16knaT
QdDrHJkKQqHy5x0/3rJgkbyi9Zb8IwZ/JS3tjVDnw/jbZj++G4uLrpn5aRwf
5TU36uw9+XiQvn6/xEEW1Sd2nJQfYnCo2yJ3QTYfNiolvquiWXQUqx5Nm0Xw
96mOY0wbH62XF+/dlsVC/E+Pl7wqgYrJbpcKKW4f6KX5hBeymJ4usEvT4/rG
9q+M5PZEV/VX7/waFso6AQby1gQNGZHf8k7Q8LEO8WpqY6Hvrq+axulIxVym
Z0ENDdH/ccqwsIv7JCEfRHC471wN85FGkKfrzgWfWewuqxlIjSVozNHOqdDr
xkfS4LFBRojjnSc65U5zc7a8HRx5sBsRh4zdfb8TIv0bm/rUYoKQARsHXkE3
DlWMXJzYIsTh7yaU53K55BGho5qo1oM9g1XvcqKFcDG7EZxtzgKSiu/qcnrg
anDMWK9cCAP3g41Kv7CYv3mSjp4tgP2RtXHNfCHmhWqo5Xaw+DXzcNN5KwHM
bgy37pHrxVBaZ6i6ihAT/9v5hACrP15XGt/Qi+fF6S0XfYUIVnc/23lXAA2j
I3uzA3txo9FWQ6tMCLKvJWbkswDzfzIo0z3fi2xm8vjVESHcS8z9569lMPv2
4OfGx704OnWzbRV60fKhcqvhYS5fPldY+oz3wlUlUKsiuRcbTZaaupQy6DcJ
Th1dKYLROs1Iw+e9uBZ9ZskhMZdT4as7s3aKsHDb62dVi0XQapCWSVlK8PBW
Rn9Ukghtt13yhG4izHtfuMvcm8uL9zlPaspF8DqQJHgYLULYRIBSXA7Bbu3c
ss8vRXi38J7mhSsi0FIGzxpbCVbvyU9d+1WEyMYP+3/uEMFKaSRFRoLF5LmC
oJDlYsj8tPzqjlERipbetXMxY9H6rNip3FmM37W83hguEWOOYczMnCMscmUq
dd8eF2PlP1k6czaLcWyTzf2uIhYHravktPPFqE5oPvQ2VIx/HaXD1AUs1kfV
9O9rFsN+7VRl03kxsLPd0FdZCMlbtU8uDorxiqwZvtQgRuGB7P4rzkK8Gvi7
jFbug99v/kYxAxyvY55X3yUJUbi8JVXVog8jlnnHdyn1ISRO3dfggRDHfNqD
PPz7kDj0otoEfXiVTtR++iTEf5en48c=
        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVVGk81QkbNbYie4SyTiqakEoyqmOdTFnvJEuWNGNMUbKNaKNexUykREgh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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJxdk3k81Qkbxck2b0YMskSWYsgSQ/vgZE2aLNVIoaQYGpJqUHcqGmVtsk5Z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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJyFlXk01Hsfx21d2jeidEnZWkUKpd6hrqLFlVApSdy4IUqJspTsslXIckt2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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJxlVXk81Ikbdq2oaS1FG0nW1GLRqpAOD20HW7nSIiSGtkXoIg0pIkeuji10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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVUnk4lQkfTRmKhMnY8jFU1jZlS3LIVoOIoaiURMoeLYQRoxjTp7rGrhn7
UqIJUwaN0ljTjdyu5eLe673Ley+SRBTf/f44z/N7zh/nOb9zjuaZMDf/NatW
rRITwV+E/99u/TvKcqYGIdz9pXyTbhcYWXuGv1scQMnR1it1b4egGTO9FO3Y
BYO5WqvUdTTMDbsfet04DM9Wlgs9tAvRbjvKvijT4HCao0r+MYK0tbRik7td
aK+5Lx2uS0P2xFWh+E0G/nHpnM+o78J3MnoRbFMayEDpFo2QUcxlNjnO0rvg
d6GM5ulAg8VkQbq5+xj0R2t+P/KlC4/aN1t0edLQbpZdW6U2jlNbi2drNLqx
vKWwcH8ADdMxvipP0seREZzpsMGmG06J6pKPLtGg3Kyf+HI1E52PU/OCA7qR
O5YXvCWZBuuVWbLvEhPLi7HTXand4Fmo9GVl0HDButl9nMfEngPhNnrV3TDJ
zTSVLqGBknSjafI4C4Gpflk3qd34eX5jQfxjGgYaNBYMO1mY4gWoXdbsAUW6
1LeFQYPhcIpE9S42Xp6O6fv4ew/8aIeSu7Te4dbKjIJuNhv59FspkeqvsKdw
qoJ27h14m49vLl5hI9K10PJD/iusCab0sB68g+3BNkP1cxP4oaPuY/imXvSb
mL2fmnmHP4K3W+X0TkDTqqNqOqcXxWKMjUsmdHy5nXlYwYTAwl/Dp0OVXyOq
57qpZCwdx+pXTqQXEHi9c1pxMvM1bLO0j29spaNuMDBI6hsO+t2vc+qlqFA4
0x2vITEI2eU30cnBHLTIplnPHaJiYlt4kYHjIIK09qWsestBVXdGvlEqFXXz
Cv+a3h5Eu31J5rV9XPx28958ZAcVPz9/yrcZGMTmIJnST0VcXLepcHss+QY/
3vKRcVUdwuLNSvFPo1ws7StcqK5+g5z2iG/l6oZALbE7O6fKwyWj3HsV7n1g
iCUrUZ2HUd7KfPHRk4fpbRTb4s990LLIVrvNHUbcaNzmj3d5CNz6K1nwez8C
Lt/XdL0+gh+XVJJme3lg/Sf5drbdW1TVtmjLbWLAQLmB9UGKjxOK8SYUwVtM
k28MqHUMrDZ2O/DBno+BDVdGbt0ZwJ6txK7bh0dBPzJVOJPIh4tkeGKKaK9X
Ty0Yu/JGURP6i9hMCx+dK4G6SaK+m3Ok98kljuFGmrbv+0U+bBZ8e+OS3kHs
guz3PJlxnKh4/s+0CYmm995RV/Xo2CyZo9XhPY49L32+n75IwoTvrhr5mg67
Eq2tFeXjoLSaefxwh4TDgd0uUfGDKA25ekR7aRxxBa6nxO6SeL80922syRBs
/HLLD3gwERAdeP6JiM+pf0pLmhoC61jTV58aJlw9EiLDKCQOhMXlppUNI+Hw
qPu1dSyYG2bHaWeQIHWtfSg+I1C3XVWV5cfCFpnamwwRT2GJa+UpMtC0V2tV
XTMLMvz2Oxm/kbDI7yCKehnw3mnrSVViY75tLM8xkwTh8Wtl1Y1RLGwJeCCM
YIP5x3zp6iwS/5V1DfnTcgxZqimr1/Ww0R0rW/tUxJt0bjRs/DQGY7mqY1u1
J1B3TKcxPJtEWGvQ4umj4+j/puehdcIE7hmhTSeHhO0955Gzj8cRsTQp7jM0
gRS5o72jIl752s6WQFkmZGdkj8cYEUhSiC/cEUbixfyyxKQol0Q9tZIfEwjE
K5dGxduSCInqdYnIZ+Kjr+7kjh4C0Wo9Dr0qIp2Zguw5FhPnco1M1ilzEPn9
rKr6NB/PQ0KY0XosDPVZ/cT24yB0i+pUSBsfIaSF/nIYC07Szh3NNRyc17Vu
bc7hQ+nc+sjEBhae2XjJZy9xcHZbYIZMmEiHPfy3xFcWDGP9vS86cHFqV/q5
k7Z8BJ++L55mw0ZxXUSxE4ULb6MG82oVPhQZMc6yv7ChOBkn1B7jwsOMIfN1
iodWrx8yKVQ2Urb+YixmwIOrhTjTqY2HIJrKmJLSBJZOZsYPX+bB0cqgLj+H
B0V3vk7+yQmEZha11z/nQaJ3rNQ1hIfzWZW6rIIJxIyvnQ9bw0cSodkQCB78
i72Z/HcT0LDoXC+1l4+VL37/Jsjz4FsjnTsjT6AtK1WrJJSPWIUyWjabi5N/
N7l9diRwfvaQmWUJH58NeJzaei682kOkxW4QkHWROkwf5OOSjf58x03RH/3q
bWv/IVBX1eV3UZbEB+9gSaYXF0fGXsfKLRLwkkiLXm9HIvTiQ6XPBlw4CxKM
lY04WPZ1TC+LISFMfa8jv8zBoXnDKY1QDoqbpUutakkEFu4206NyYLeGXaZT
wcFBlZ7GIUK0yydRB62LOLCWzTi1k8XBZNSv1KhNAvhSG455RXGwf5Odsqka
FxSqE2fDEQFGuQuBEfYc7NX5RLX05MJsm8yXihsCeEjurI0z5aDQfHuVdA4X
advtPRbLBOjW9p9P1eVg7eGzSfRhLsZ2/PTQsV2AA/Z5lpkqHIT75p0oVedh
964nkgVcAZ76v0kukuKAHtVnfNGXhxuGM6enJIXYlSz56uESAaSsk0UJD4O7
9RuhK0RZyX6Fv4UEyvOseNJcHrYb+W28c1CI/7RFHm9niPKtudJK1+MjwTg/
mBUoRAa7sqi/l8Dl5w9zS4P5eGsy8HJPqhDSa8b5Y88IMAaIyIs1fOiYbdBI
rhTiupaiobCWgB1fzRkf+IjZ63CV1inEgrXT1YVCAtVf3LXXG5PoNU94o0MK
Eeab+EycQkBBLm2FfoWEpsVT/WipSbikdRp9FfUdcNRtoLCMRJ52GVkkP4ns
Z5p0ZhyBor7K8oBWEuaL9vKlK0KwZqOv/RtFYNRZLMZghMTQK65p+aQQBrp9
6veDCKh2HnN6/4lETGGKT+WwEJdO6D9PP0PA07ZWvV5eAJVLesn3RT5bbif6
R3kRuPtMciZ6myjfg133q/8SYu3LobVeroTI96kXlg4CeKkF9dWUCnHk8+4H
+x0ISDU0/LbmjAAL09KfH1GEyNue5qJlScDecENgR6wA2S8eaNRdF2LCl/1B
wphA4gN/81tZAphlOds3hAmxI3NfpsCAQItO83q3PwWgX5gKfnJSiCtdlL1U
LQKLRQpjiq8EuGKZTml0FKJ1WTBSp0LARD340bBoB0rf7mps2ivE/wDqnt/f

        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwtlXk41QkfxS1hrgojipqSMG/2NUTNkZiExjrlnZKEbCUx0oKpMTVImkZS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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJw1VAk01QkXfxJFNUjJ0qa0G1skRn5NlkhjG8akSLaMV8oyfKIISZs9S48p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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwV1Xk01QkbB3Ax9qa6oiS9SkUII5QlfQtRVIgZEhW5RKVGTJNCtFCSlKXF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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJw1VAs01AkXZ1uirahIq1ryqJBEKYSfkCTvIbJUyFJEG83qhejb9BAiVJjJ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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVlXk41dkfxwlZSrgqjUqobC1MUUzqjTL9VDIllSWhSJaQrmIuJSbaF0vR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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwdlHk4lQkbxkMTomSpMZV9LUskReLOViNLyGixHg1pkZSlRNlCSUMlWzVN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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwllXs0lXkXxxnDxLhFIh2SQkUjjDIlX/fLJJdcSo4yQso1r1uaTClSaMj9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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwd1Hk4lQkbBnDZlWGIM0llqyhFRJPQbZlKJEs1lGRUqISJFqJNJFsMjUKi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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVlXk4lmkbxsmWkC8pbZaieltMaFGKU1FCTEQ+oaSkmYqQwiBLIZUSsmep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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJx1k3s01Okfx11WSEmhJJJSlC1lbWzkzdq0ZaWQNlZEdNEVhZLkVlJIRUnW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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVk3k4FAgYxuVKZaNsiXQIOUqrKCp5I0NCh0htoRydrnJFIYTKZqSDSkSO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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJxF1Q0w1NsbB3DpopSISulVXrqlVNQtkm8porRXSSnJy62upJQkukIIea2I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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVVXs81IkXnUJNnpFHS0laSyqll1I5yRIieWwlm0d5lI1Cu8qKJSmiFIpN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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwtknk41QkXx1MiJck2cTPKVLxkKoPI6FsqFapJb2SkyFLZoqxlLUopKkZ5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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJx11Xk0VXsbB3BKryENlFBm1SUqDaTxy2uI5PI2kFQ0KKGk3KIrmUtcQ0ho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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVVWk4lQkYJcVoQkYzhSmKxtaU7VJNnLI1o1RSWm6ImCyVrRTJKPRY24YM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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJxdVXk41YsWdTVSkgxRqSuSikqKHrGkul2zSzelFA0iJJKII27InMiUsaQM
lUp5pqKMHYljOsd85unnkG7KkFz3/fn2961v7z/X2t9ae6uc8bI9v0BMTOyX
eZyfx7/zvfR/qwL/3zvGXhTJjVfjjDnlvYX/W3DtA8cL8quwSJUzeFitFsnB
C7/dKH4HbQVH0/IXb6Bi5e2yqP0dAuxzo3vX1IPUZXS/6U0NDANmR98H1sFx
574NOtGNOGeaEESwa+HwMOpayOYGmEjQSmOnmhGtEarxt/AdrrbJixl1NmIT
88rvXNcWPF/i0zX9+T0Sp+9HzgQ3Q7JKehC0VvRwz4SIf6/Ds03bZSq2kvH9
Q3f5R9V2zDTYaUrO1oNsU5nu19MCtzLVmwEnKFDJP0iTWdAIbuBvG3f/1Yr+
B96W6kkdOBy2J0xJognijzuKxrXaYHm7ZnUnuROeZ9V3qkg3Q9qtJJ3q0Y6a
QCnmDfFuJJqsHtCQ/4Cs4AnHMhMKtF1PPNHU70G5ytLInWvJ2HbXYGOyYgfy
jhT69XpTMSQ2pbNXpQXvUztL3rZ0YH1aYkZqAA0n2HwDCd2P+O4Uu3mxdycW
pNkFb7nUi5kd+a71Nq3Q3Hoox1KhC/xUOeeqM33IDHROvuH+CU5/zyokV3Wh
NbX7gKV9P/Y1Kb/Xj2hDcnVZ/IBTN16mpqgPmw/gkoTn9+s27SCHey1WW9yD
tFR7CW/jQRjtaImjDbZjzkoj2L24B0GpiiPie4aw4s8tarruFOgoMiZe2lDh
nNr76e6WYQxdv1WZNEmBKyPdc3qCijzz1mOy0nSU5HJsxsM7kFVky9mfQUNK
i5bZySg6ghsP8KxkO9FxZZljlHEvIs3jDfIXMGA9cp/0JLcTiw3ru9o5vQhs
GdUcJTGwYZWYnOT2LhgsJlkoxvThkrn1er1JBsb0ThVdmNd5uW1P/emd/XBq
KZEO8WGixrHauOH3bqz1Cl7k3N2PiiJr7iCdiaUaoTHK3G5Uaw4ULLw+gEMS
B9PtwcLERrV19Wk9cBT+x6Jg/SAoF/ZaULJYYCg3PbloTsXs49Qx87pBODZq
zpn9YOGT4kVDmZ9UZJ+fSBy7MASBmsrLegc2KmWlPv33OQ1Gqna6ScuH4XdT
/rxRBRuPVzw/depsL4bpz3t1XwxDnCmhWL6agyQJu7GFCn2A9S0j0VY64ox/
krX9OPhfbJr7sHK77kqQ6FDK+UIq7uLAfS5tpW1gP+jLOYyENjoezXJ3btLh
wn7a4P6k1gCeE0mlTBUGdp3sZ2Xf4eLgxJB2Dn0AoWST8N2+DLytbEtR/MzF
zs+h7w8lDeKPwvGjEY0MmCnVmyZa8aBMqNmNHBqCSmSuBk2RiZ5r5T+WPeVh
KbeJlTg5BLc9mqen3ZkwHFuac3cxH3xXv+OqT4cRXMH+8rOOibqZ0EE/Ez7e
Sr1OSdWl465hVsSCdSyYLp1ZezyYDwnes5CsFDoK3/25ZqkvC+1yvg4GlXzY
1RZczPtGR82hFc+Wf2ThqIooTfkbH9npD44UHmWg60Pjfhk1Nga0XKhz2gLw
fTKNSsoYEFje6JYPYuOM/rA801OAXRYpGq8VmJij6Lmt6WJD8NuxI/WFApA2
Jayq8mNC7ujnH+s1OfCyoyQ+4gjQ9DPqR20PE1v7ChJUwziYOG1GiVQRQoZ2
k9uoywJOOatpDHAQ5FEn7e4oxMkXpPaPKSz8yVQq19zNhXjAPivLdCEeRV+r
7PjGwkWXDnPtWC4iw1/H7ugWYvys90PaUTZChNHDe9hcSCdub5GRIWBg6B4/
VMZG8qUDV/T38ZCc/VjiqwWBCIXz/mwFDjYoORtz4nl42cw4nudAYJV8VNyD
kxzImlW+K6bzINvq8leOE4GtXlFH5rI4WBIoe8BnFx++FKIow4WAyYeotSeH
OZgp9qjfG8ZHT/flzlQPAg6q0czyX7kYHWg4NNfNh17fxEySDwEfUnSh/Bku
mFIbmho2C5A2dF0twZ9ANDX6sk8eFz1G/r/HBggwxZyziA0m8EA7Rq9tXg/Z
i/LBtkWAE7ywq5FhBCpjYn5uU+fhTe5WcyVlIaoJieywaAIdnJiGyAs8vKDc
/Dh8SQjlz/GNIQkEhIiN5RTwkC8+aPmoVojgr7JjQSkExO/F2pkIeUjX0W3z
WEWAPpm2OiCTwJqvsWtytvERd+62jc45AvtnlY2vPiCwyyqOMePBx41kPmXq
9Ty/X/JcvQsImBbEFRx7xkf/+QOblf4moJ7y9Nhl0vzemJPkP+Z9V++Zs7bq
1xHUHT156oUWgeEDX7WNs/l4cnVG2tFqBE6rl537MihEcv5Y2va/+Egm2S+c
CxzBLLXCTSdeCLMlxNw6Fz6Cw0sncwtHcC/N1cvXSAgxN67LMjM+XOKkRSbU
EegdX3319agAZWRG65QWH9bJ7gz2QhG6lRqvf8sWwF1zcDdfho+9WU3dEbtE
8OnzDdGzFkAlnpbRM8Gb/0uqZA0nEaQzVCP85/igjnWKN/TyIPH0xltynAhP
TnTEVJTwEftHm1vpGx6+vOp/6VElgum60DvTp/kwKSW337/PQ3+13uMVAhG4
AztSDVby8V2uUS8hnIe6+qSM5wqjCMsaygyq5eGp37vsYDcennwcu217cBQq
p+IevLnMw1la9SJPSx5Gqcmkr8dHEWq7t7hzhgsskbx+bZaL24SvQ4rOKA43
Hzf4uYWLn2V50s3b5u/NnJ3eXqlRSBkFtmgc4+CNi2G+ogMHlFU6cn1cEbpK
M0/YRbARpEDVd4tk44r6qvHAWhHubXlLkF6xYNB4ub2ijAU5/fFW5XsiOOcM
BxYwmZi6KukiyWHitWV7Uc0VETbL/7K8cyUT5ZsezjjIMmHvXHLL2VKE0eiN
mbNGDFzrNrxTvJ+BSd/4cws2i/BK7KCmhicduuFU9R9edKRHeu7PFxNhYoTs
n687DKEb0z993zAMMi3WH+4bwS2aVPp04iA8Psg/1E8fxEDJthl+6Qjk6m0q
rMf6IdQwbeuf6AepTpIWHTeC3JKk3ofmfXCNDJoOsu3DBqrgleaFEWhl9ExN
PaaBwyvZtL6Ehlph851PxiOojFBaY72QirOHWTY1y6j4B06f7kc=
        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJxt1n001XcAx/Fr2qpZk1Szaqo1U+YhJCr6oM6pQ6lVVq60RYyaTEkouTRs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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJxllnk01ekfx5E09pBCypZBC4kS0VsbSqSibINJhpkoLaTxyy7GTjdlSYmS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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJx1Vmk0lQsXNqXMKSncSIoypKskUk/pRG7DLTQo0TVkpiTOQSp1zS59qXQr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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJxllXk41fkXx22JtClbZGyhRg39siV5UwoxMuLOEEKusoSmUJKlDRWjMkUb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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVVHk01AsbVsiSQkmLbNGqbiW3T6SnRYulSGRJyXotlYpUfFm6KXcUIi3W
0igJV+VykbjcfGNsM/OzLzXGLL8Z8+ukriyRb+4fzznvec/7nuec53nOY+gT
6uQvLycnN0cGfxn+nfl5HtZaiwX40Tn8rtOiA2qX3IbuJzNRuCLsTryrADNB
Ty10GR3ILdWv2TnBxPnUxK5vmQJMz/iU+7l0YptU+JB3uhnbVen6gVwBvt9d
ZVrE60Tj2pLwhKZmTMe9Dew1FmJqNa/4a2gX3H0vOf5k2oL6yY5XtkGyfeWT
9ZYzXZDm7NzYkdGChAvUVHWxEJOHvfOv07oR2yevHCnfiiNiRetNX4SYGDIw
ZC7twWLt5mH9M63Q8ta7k7NdhPFL3CzN/B48O5pa+76jFX0927vUo0T4pvJ4
mbtpLyzuuGeGWLXhsaODflytCGPZXvce1/ailWFwWfNZG8a35xnoypOIPPfE
RLOgD/LhCkumFNtxRHfMsPIAidldw/VxKf0w1ydf8/zbkS9/yMiFRuKG+mqP
L1cGcI7Z7Nj8vh3T4gzj0VYSKtyAUR/vQXCqXMd7F7HgxKJW39EU405pQQJh
8wFnU2wOtO1l4UX57rXrXcRYFCfRtzb9COUAy/T6iyzIZaete/9QjJZ19094
LOAiz3ITvzyPBddfheu9B8RYqPmf56lxXFhp6m97yWGhJGiHyYy+BI6T3V+Y
Y1z0CDWu585lQ9Hx9sZHvhKkDV3ZJR88hLC3c9lppmx4/tW/zjVbgoUDA19d
h4cgCfh5cb07G2WmJquXdEtA69r9osiTB2/NQJfPsWzMp0caEhojUGTTT83p
4qG3OuOBXgEbvkuYundtRxDbrKx13GEYjgGtvfbtbFTdXL7C4cYIpt+faSpk
DON/GnIro76xoTkRqL3g3Qiu1LGiZ/fwsava9NQLXQ6Cgv5c1Dw+gq9VZmbO
1Xz84e//uNuag7o+JfXftkoR+sdDcYGZAJs0HvIUz3CwzN51/sEQKcS/T+fM
FAtAr2Iam6VxEFrzTEkxXwr/wtPOTmuF0PGfCfCp4iBJz+9HxDsprPI/lHzx
EmLreMzf/s0cFMcYjpHdUmg99lRJeyjEwd/mrgoa4KCF+2HEY1QKaUaf7za2
ECd14mPOUByM7MnitahS+Dvd7R2hIkJYsdJg6A8OVJ+69+4yppCZ0rUsfK8I
NNAswtQJrFNYyiq1onAx0TlMS5bHx2y1hxEGBA76dzSucqVge5PTWvZGhHLf
5LGrWwkENN6tuXeewqo4x3UuUhFaxjSPXdtLIH6tQ9k8GoXJqLbrY8YkeLfu
lcYeI0BPUHt55SkFdoT9YPpJEhPLly684UfA68Lgjh0FFEK8BJeCAkncn2rg
vvyFgI5HCWOyiILCoeiFVmEkzPrPvyGCCXTtjXGtekUhZ8vS5xrRJIhq3Zvf
zxK4a+IojCynYL68FPwEEheymG5GFwjYaxlesqymwJlj01ORRkL92mUTu3AC
yjOj8tO1Ml7J0PnEHBLFJ41/XLxMoEFQn/r2bwqKRKSK1wsSdrvYrIxIAtFt
aYbXmijkVi/OMy0jIdGLflp/jYBFhV+pVZuMl15kMa+WRMLshghJLIGx3J/x
gyPjvb2f6G0isYbbfWjRDZkO9T17UxoovDXy/WNSdn9RkKdRcZWAsyDqwKoy
CvlVsQ+Wl5OolZztORFKQF5Z37aMTiH5aM7VHUUk5n82fyznT+D1hvrDB9Ip
XCWrT7jnkXAbkw/M9yDgfdj/aE88BZ+YXqurD0nQp9o22zoS0Dyv7BIcQcFe
e1z/URKJ0dlH45/2E6hLfek2HUBhe7HW3MobJKwU/WvTLAlZjo94Jsl8N7A2
5fdEkqCpbrllLvNdv2fUy+AQBZV+h8aJ8yS61b8fGVxDoG3qnu9rcwpfL5wt
WPYLCaMljdrXVxLwMwoJPCWWonRzdK2VGYlX7U6B6hIOpuz2nFXNkOIcldTl
M4cEaB8rsyo4SAlferHcVgqTl7nUrTYRWq3PzN8Qz8GabCrC5/sIyMBSheJM
EU7MTnhWOHFQ874hamHRCJ6t+UuHEyiCuDK+xNqAg2OfHsVWeY7Al882Hf9Z
hMvhi+Q4FBti7fPxAQtGYJDHs1kpL4Li5tyjXtVsxOAAbdE7CT54fT29hyVE
mtjkqTSBjSWBK5PfnZMgU1fhSkC2EAb0P/+5epyNwpQvacGyHnPr10pODBai
5NT+A0rGbLgtneOlEyXGro20BS1yQlw+qfLpaBML8jnqG1q6ZLpcm01UeyAA
PFvTs87J+tBYb+y/piSU28JVD28SQOnEXSvRYhY8Xm6s25QkAqUnSbjTwEfO
m0Km78V2zDO1TPwgFoIT6qXU5s7HT69MV0y+bcOrP22OJ+8XoqKuI37h52HU
lFQFJSm1wRNuhrufCJClaavgcHMYh4v2Vho5tUK5MUD6eZqPOJ/a68krhzH4
gqlcmdWCMvtLFU/c+Ah4YzaH9ZqHs8+d3I6ImuFF/HrdqWwYdgqFMRo2PMzQ
+54Pb22GRnHVG51Vw1i/mQyji4fQwHx9YSHJRN3NUT4/mQcljzWB5rQh0D7T
LHfkMHHh9DrtkpkhCG74ebZsGIKjtq+inzMTRhZeBy+HyP5/z3M83czF0p2W
7UmqTHQsvn9ldy8XT/q41v+EcDHovfhRZV0T4qmWFyoHuYhR1N+RoMYF/daI
Dz+iCSFJSuX5QR9RdbrKw9zjI4KLGzaqb2pCy55Ly8z3f0BE+fZ9pzM/YAuR
+W3HMAM/jfEimQaD2Kr2xiRhYBDjE2F1fo8YSC5wHPSc7gflvVmrVHcQNXr2
tGQHBt4lfeoi5/dj2U7778LoAQTNs7dMcWSACr/NCtfpwz7tIJ4utx9LPtlJ
U44yoHtiA1POpBehn+ObnPf0o77TLvuuEwP2exgNty16kMHMK03M68O5Grsj
qccYiFobULPMthvv6bUP6uX7sCLfbjbVmYHiBQoVdPcufIkeiJ7060XjbbvS
NBcGBr4+Kd0S1Ald90n/LY09uBhu533vOANqfSh8e6UDNtu0D/+ytgf6nnaL
0l0ZsKwbfHoogUD4gm1mOQndaN5n15DuxkDws6jsjgcc5IocdDrFXfi3Je+7
M/B/IyPQiw==
        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwtVHk01YkfpUehwtgipaJVmqZsqbimkUoZxpiixhbGpA0xGiPbSFGTZFKG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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVlGk0lXsbxg3RgFDSoUilaMAxRCRXFImUIVEqkQzF4SBlyEZFRa8xSULG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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVlXk41ekbxm1xECkpYkjIMBGpyNKdlLJEStnGFJLslGwVKalUZJKlmqiQ
SEmJojJZsjv2cBzHcnC279fWRKl+5/fHc73vP891P8/9Xp/7VfUMPuAtLCAg
IMgvb379/1539Xn4yok6XDLPtLx1rRPVMtvOmQ3xQGXh+nVmPX4MJLT0pndh
tVjWr7hxHvqtqA9ExhpxOjzMUSmnG/4/RC7U8XgYe3K07OxIM7gyngNHi3vw
YdZPRPILD4T4dPMcoxXHCu09cyt7IcumJtgv8rD4akfo62AqaLvNWKz6z/Bh
bBVPFSYgyKScnQlqhyNDO0S3uw8VPfeufZYgICbXnqAb1IHmaPmvJ4f7saxF
SPq3FQQkd2em+AV2wkJONKaMNwCv6hM3PRQI2LsEMRdju6Dc8JO2i0ODnKnF
jl5VAi+HGtyN73XjqfiPx+HDg/jvS28CU5vAquMaPRHlPdhm/f1kfi8dvc8D
WmYNCERzz9uVdvWiLnHBrL9lCOW+giuFzAjQT9LqZqY+o4B5RkTUk4EMtTRX
GUsC5guG0JPqx9SS7yzlQQaiBrUfKNsTyIm9VRaoNQDD9dFths7DcE3/MLHB
mQBFlNxYuJuGc5YLr/Z3DsPEwVHXxIPAyD5bB6nYQVA8ZSMLnUYwUGyyWiOA
wGP5opryGToUwrz+u0qM4Jtb/a66aAJl06JKmwwY0E54GXbi0ijkxQ6d9LlK
YI1TWbcYjwGTDOFZS6UxGJYMZ1EyCJyr9EkezBuGbcHBUI2XYzjsHtTyJI8A
Q1Xe6uXREbhXPiKFrZkIo3z/Zl1KwOJyvdDVNaMIbp0NHGEwcevl5d+51QTy
uJGVf3WN4jzDglsVMY4Xf608fKODgPgBrfDNSWNImbnllyU9Aar4g4u6w3zd
W3nm7aZMBLq4iVDSJyDPUh+6PUNgpktNKojDhHXVuvshKpM4Wp9v/EOYxPFV
Dz5L3BnHek22Yd/jSTx5vCHtmByJfiflnMd7JyCU9KLdXI+F6YTi6ab1JOwy
7wbv+joB+lykf0E5C9uOb95nYESiul/eZDh3EhVuO5bImrMRt7s8/44VCUOl
NNEYRxbSP4plnWlgo0HdVETIjcRTd9mONcJshGm1GY05cLBCpOqIbwCJ5EH7
XvWrbIQ7xwR0VXAgVdCkfzKKxJNF/yjmNzau+asGXlnFhaeB4gebeL6u4hXF
vAAOsmJqAk1DuSir9LPVSCYxaJzz7jidg1cpPkFTTVwstXzb9zOTxLxL1RHN
/Vw05kgE56znwbNN3OdzDokVUTTByX+5GCorCnaO46HM2WXuxXMSOhnzj/IN
eJhr3B+ylMbD0pH8uGtvSewpW2npm8uDOH02pGorAQ//eWnvWhJa2RXsdYIE
hEz371oRS+C2l9zo2xck7ilFprbqEajbqPIu6yGB+G0tu8Q9SEhnbt4efZRA
ohqxRaeOQNiyS3lOMiTi5KYnNG4S2Lf63bO3LAJeTFNK3gcCcylFKe38c7nk
dc29UiQOVsz5zgUROC7tZ3KOJND10zW7W4+ERcrTpp3KBPoS1zN/VyGRMaOl
4OVIwsDnmE5KCw82YqNJXXYk3MbnU6YiSKwzU0oeOsvD+4tZRudjSKj0f5KI
ucv3RbZrSmcDD8lNQUo+V0ksfZuqIZBNwlbC7GlcBBcestsF7FJJLGR67LjA
9/GyYJ5P90cONrlJjW3OIjEepesm8oTEv/PSalrSHAg/on1SLCDR6fL9dEIR
ie9kBP2sCxvd7MJCoVISVdvqb1JKSGyZYGRSc1jI23QmmfWBRJHC7cLE1yRC
6FaH1KcmERltfYraSOLOgkfd0goSBd0lMpEmk7D6qMAnkj9Hn+5wEr9vvFmx
uSlhAms8md6Xe/m6Djwn7XckkhSfazrFj4Ojs1GiuYvEvrScswfKSLBvOx38
6cpE5ULkM5kOEp/63R5E899vj4xAbK7+GG7UfjxwqI3EThXZuoeFJB4l5hfY
UkbxV8rSr5nNJCq9GtmNuSQEljj0zNKHsdH98F16A5+D/Lhls3w//oxdELxb
yoCAVjbUPpF4wTXarHiHROishVu8/BDa51ijPjUk/tCfcrbg+6o9mVrSUUvD
jwCE3ePvHzX3PPqbD4lTEQrdjrR+DJs9pRX/ze8vPZ/WRhBoN1mStL22D7XS
Crtrg0j4hjuU5JwmoCcwbfn7s8/IH7pU1GdNwsNwXWsU/59IqqH9Wp7ei+vF
M3IEn2+3+RmW3UUepq/Ul3+P7UFI3JEYIX5OHHxTvURdggf7fa9CmSe64Xig
eXzVEAGb6FTVhZtcPFuerd3m0AVDtW32f1Tw88zE26x1NZ+7nmuj5cadUJzL
LUM6AZPFLS6P7nPgfyfi3kO1DqQcMuZ5HePnltMVQ4FuNuSOXLjR2N4OSlnr
uiv6BN6X9Mu5S7LxQe1GzExsO2LkvZyf/uRBQFpn7o05C76T6cFrdNvxJerr
DWoTD+a+sR2rIichW/Tw6E4aFf4D16rnMni4WNNefOrZBN6HFjn4JVIxbLp2
Qf44DzUq6snUsXGc2Fq+828jKpzvv9I14/MueiY8UEdxHGr/XfIJa2lD66+9
xzwEeNjTU2+T6MBEZOxdqxqtNkxJmrR6t3NBlc5aPn9pDAuajzcsJLXCh+d2
wDWHi/kthjZBb0YhzdC5mT3fAnrr2R47Pjeq7m3xY9wRqGW8mt3j2YJDxf+4
WlhzYRXv89517QiM9ps4kU3NaEp5Tzf8jYvQwl9fqQeHYUf5+DZtSzN2nhry
3DDFQWZHuv6eywx4Ve1V3p7VhDeOAhNrqzmInz3SE316CJGRbXFMShP0tqr6
y6Vx0GV+08qHNogbeoeZ1082QitEzijdj4N/xEZtyxcHoC94TruqvwGabsVp
Bjs5cKmMDulI7sOs0NgmyR0NULe0+dKmwMGq0BWp3HW9KBWxMTmcWw9V/fGD
AdNsdGoUlIm+7kK4aInFA4l6qCjFlVD4uZ/ebz6w1qoDxhQFW27wJ/wmprQ8
N5uNfOWXP06Xt2FR/LyjYXcd1sy8DjaPZEP1ysiuAnoj3klO/HnBuA7ygw6t
g/Zs3J1efp0uUodYKTvvlqxayNVzN0RrsrHSzbxzxR//wnxZaaD8klr8D6qA
3nM=
        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJxF1Xk01ekfB3DSQkTTwiCDiCyhbULyboosLUTSpDSUolEiWWOs0TZGyYkW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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJwVlWk4FQgbhk+NrdUI2cnSYKTChCRPRB1SispQSIhSokVFKoO0zdgVRZE1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        "], {{0, 0}, {1, 0.18}}]}, $CellContext`gs$$ = 
      1, $CellContext`gsel$$ = 1, $CellContext`glen$$ = 
      51, $CellContext`gropts$$ = {
      ImageSize -> {110, 20}, ImageMargins -> {{0, 0}, {6, 0}}, ImagePadding -> 
       0, PlotRangePadding -> 0}, $CellContext`gdopts$$ = {
      Alignment -> {Left, {Center, Top}}, Frame -> None, ItemSize -> Full, 
       Spacings -> {0, 0}}}, 
      TagBox[
       DynamicModuleBox[{Typeset`var$$ = True}, 
        InterpretationBox[
         StyleBox[
          PaneBox[
           TagBox[GridBox[{
              {
               ItemBox[
                OpenerBox[Dynamic[Typeset`var$$],
                 Enabled->Automatic],
                Alignment->Top,
                StripOnInput->False], 
               ItemBox[
                StyleBox[
                 PaneSelectorBox[{False->
                  PaneBox[
                   StyleBox["\<\"  Gradients\"\>",
                    StripOnInput->False,
                    FontSize->11],
                   ImageSize->{180, 12}], True->
                  TagBox[GridBox[{
                    {
                    PaneBox[
                    StyleBox["\<\"  Gradients\"\>",
                    StripOnInput->False,
                    FontSize->11],
                    ImageSize->{180, 12}]},
                    {
                    PanelBox[
                    TagBox[GridBox[{
                    {
                    PaneBox[
                    DynamicBox[ToBoxes[
                    Column[
                    Map[EventHandler[
                    If[# == $CellContext`gsel$$, 
                    Grid[{{
                    Spacer[10], 
                    Pane[
                    Style[
                    Part[$CellContext`gnames$$, #], Bold], {110, 14}, 
                    Alignment -> {Left, Center}, ImageSizeAction -> 
                    "ShrinkToFit"], 
                    Spacer[10]}, {
                    Spacer[10], 
                    Graphics[
                    Part[$CellContext`gimages$$, #], $CellContext`gropts$$], 
                    Spacer[10]}}, Background -> RGBColor[0.93, 0.93, 0.95], 
                    Dividers -> {False, {
                    1 -> GrayLevel[0.8], 3 -> 
                    GrayLevel[0.8]}}, $CellContext`gdopts$$], 
                    Grid[{{
                    Spacer[10], 
                    Pane[
                    Part[$CellContext`gnames$$, #], {110, 14}, 
                    Alignment -> {Left, Center}, ImageSizeAction -> 
                    "ShrinkToFit"], 
                    Spacer[10]}, {
                    Spacer[10], 
                    Graphics[
                    Part[$CellContext`gimages$$, #], $CellContext`gropts$$], 
                    Spacer[10]}}, $CellContext`gdopts$$]], {
                    "MouseClicked" :> ($CellContext`gsel$$ = #)}]& , 
                    Range[$CellContext`gs$$, $CellContext`gs$$ + 4]], 
                    Spacings -> {0, 0}], StandardForm],
                    ImageSizeCache->{130., {101., 106.}}],
                    ImageSize->{142, All}], 
                    PaneBox[
                    SliderBox[Dynamic[$CellContext`gs$$], {47, 1, 1},
                    Appearance->{"Vertical", Small},
                    ImageSize->Full],
                    Alignment->{Center, Center},
                    ImageSize->{22, 200}]}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxAlignment->{
                    "Columns" -> {Left, Right}, "Rows" -> {{Center}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{All}}, "Rows" -> {{All}}},
                    GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}},
                    RowsEqual->False],
                    "Grid"],
                    Alignment->{Center, Center},
                    
                    BaseStyle->{
                    ImageMargins -> 0, FontSize -> 10, FontFamily -> 
                    "Helvetica", CacheGraphics -> False},
                    FrameMargins->5,
                    ImageSize->{180, All}]},
                    {
                    PanelBox[
                    TagBox[GridBox[{
                    {
                    StyleBox[
                    DynamicBox[ToBoxes[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$], 
                    StandardForm],
                    ImageSizeCache->{66., {0., 7.}}],
                    StripOnInput->False,
                    FontWeight->Bold]},
                    {
                    GraphicsBox[
                    DynamicBox[Typeset`ToBoxes[
                    Part[$CellContext`gimages$$, $CellContext`gsel$$], 
                    StandardForm, Graphics],
                    ImageSizeCache->{{2.5, 151.5}, {-23.75, 3.0625}}],
                    Frame->True,
                    FrameStyle->GrayLevel[0.9],
                    FrameTicks->{{False, False}, {{{0, 
                    FormBox["0", TraditionalForm]}, {0.5, 
                    FormBox["0.5`", TraditionalForm]}, {1, 
                    FormBox["1", TraditionalForm]}}, False}},
                    FrameTicksStyle->GrayLevel[0],
                    ImagePadding->Automatic,
                    ImageSize->{155, Automatic},
                    PlotRangePadding->0]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    Alignment->{Center, Top},
                    
                    BaseStyle->{
                    ImageMargins -> 0, FontSize -> 10, FontFamily -> 
                    "Helvetica", CacheGraphics -> False},
                    FrameMargins->{{0, 0}, {7, 7}},
                    ImageSize->{180, All}]},
                    {
                    TagBox[
                    TooltipBox[
                    DynamicBox[ToBoxes[
                    Button[
                    Style["Insert", 11], 
                    FrontEndExecute[{
                    FrontEnd`NotebookApply[
                    FrontEnd`InputNotebook[], 
                    BoxData[
                    RowBox[{"ColorData", "[", 
                    ToBoxes[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$]], "]"}]],
                     Placeholder]}], ImageSize -> {180, Automatic}], 
                    StandardForm],
                    ImageSizeCache->{180., {7., 16.}}],
                    InterpretationBox[
                    RowBox[{"\"ColorData[\\\"\"", "\[InvisibleSpace]", 
                    DynamicBox[
                    ToBoxes[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$], 
                    StandardForm]], "\[InvisibleSpace]", "\"\\\"]\""}], 
                    Row[{"ColorData[\"", 
                    Dynamic[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$]], 
                    "\"]"}]],
                    ActionDelay->0.3],
                    Annotation[#, 
                    Row[{"ColorData[\"", 
                    Dynamic[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$]], 
                    "\"]"}], "Tooltip"]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                   "Column"]}, Dynamic[Typeset`var$$],
                  Alignment->Automatic,
                  ImageMargins->{{0, 10}, {0, 0}},
                  ImageSize->Automatic],
                 Deployed->False,
                 StripOnInput->False],
                Background->Automatic,
                StripOnInput->False]}
             },
             ColumnsEqual->False,
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Top}}, "RowsIndexed" -> {}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}},
             RowsEqual->False],
            "Grid"],
           BaselinePosition->Automatic,
           DefaultBaseStyle->"OpenerView",
           ImageMargins->0],
          Deployed->True,
          StripOnInput->False],
         OpenerView[{
           Pane[
            Style["  Gradients", 11], {180, 12}], 
           Column[{
             Pane[
              Style["  Gradients", 11], {180, 12}], 
             Panel[
              Grid[{{
                 Pane[
                  Dynamic[
                   Column[
                    Map[EventHandler[
                    If[# == $CellContext`gsel$$, 
                    Grid[{{
                    Spacer[10], 
                    Pane[
                    Style[
                    Part[$CellContext`gnames$$, #], Bold], {110, 14}, 
                    Alignment -> {Left, Center}, ImageSizeAction -> 
                    "ShrinkToFit"], 
                    Spacer[10]}, {
                    Spacer[10], 
                    Graphics[
                    Part[$CellContext`gimages$$, #], $CellContext`gropts$$], 
                    Spacer[10]}}, Background -> RGBColor[0.93, 0.93, 0.95], 
                    Dividers -> {
                    False, {
                    1 -> GrayLevel[0.8], 3 -> 
                    GrayLevel[0.8]}}, $CellContext`gdopts$$], 
                    Grid[{{
                    Spacer[10], 
                    Pane[
                    Part[$CellContext`gnames$$, #], {110, 14}, 
                    Alignment -> {Left, Center}, ImageSizeAction -> 
                    "ShrinkToFit"], 
                    Spacer[10]}, {
                    Spacer[10], 
                    Graphics[
                    Part[$CellContext`gimages$$, #], $CellContext`gropts$$], 
                    Spacer[10]}}, $CellContext`gdopts$$]], {
                    "MouseClicked" :> ($CellContext`gsel$$ = #)}]& , 
                    Range[$CellContext`gs$$, $CellContext`gs$$ + 4]], 
                    Spacings -> {0, 0}]], ImageSize -> {142, All}], 
                 Pane[
                  VerticalSlider[
                   Dynamic[$CellContext`gs$$], {47, 1, 1}, Appearance -> 
                   Small, ImageSize -> Full], {22, 200}, 
                  Alignment -> {Center, Center}]}}, 
               Alignment -> {{Left, Right}, Center}, ItemSize -> Full, 
               Spacings -> {0, 0}], Alignment -> {Center, Center}, 
              BaseStyle -> {
               ImageMargins -> 0, FontSize -> 10, FontFamily -> "Helvetica", 
                CacheGraphics -> False}, FrameMargins -> 5, 
              ImageSize -> {180, All}], 
             Panel[
              Column[{
                Style[
                 Dynamic[
                  Part[$CellContext`gnames$$, $CellContext`gsel$$]], Bold], 
                Graphics[
                 Dynamic[
                  Part[$CellContext`gimages$$, $CellContext`gsel$$]], 
                 ImageSize -> {155, Automatic}, Frame -> True, FrameStyle -> 
                 GrayLevel[0.9], 
                 FrameTicks -> {{False, False}, {{0, 0.5, 1}, False}}, 
                 FrameTicksStyle -> GrayLevel[0], ImagePadding -> Automatic, 
                 PlotRangePadding -> 0]}], Alignment -> {Center, Top}, 
              FrameMargins -> {{0, 0}, {7, 7}}, ImageSize -> {180, All}, 
              BaseStyle -> {
               ImageMargins -> 0, FontSize -> 10, FontFamily -> "Helvetica", 
                CacheGraphics -> False}], 
             Tooltip[
              Dynamic[
               Button[
                Style["Insert", 11], 
                FrontEndExecute[{
                  FrontEnd`NotebookApply[
                   FrontEnd`InputNotebook[], 
                   BoxData[
                    RowBox[{"ColorData", "[", 
                    ToBoxes[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$]], "]"}]],
                    Placeholder]}], ImageSize -> {180, Automatic}]], 
              Row[{"ColorData[\"", 
                Dynamic[
                 Part[$CellContext`gnames$$, $CellContext`gsel$$]], "\"]"}], 
              ActionDelay -> 0.3]}]}, True, 
          FrameMargins -> {{0, 10}, {0, 0}}]],
        DynamicModuleValues:>{}],
       Setting[#, {0}]& ],
      DynamicModuleValues:>{}]},
    {
     DynamicModuleBox[{$CellContext`gnames$$ = {
      "BlackBodySpectrum", "HypsometricTints", 
       "VisibleSpectrum"}, $CellContext`gimages$$ = {
       Raster[CompressedData["
1:eJxl1Qk4lHkcB/CxxbbOTlmPVbmfKLSOivpR2+FKCclRotmQknQgLVu60GxF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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJyFVnk4Vfsa1ngaiGMqSYqSElGOTsl5iaRJkZwylTHplFvJORW6oVOEdEpE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        "], {{0, 0}, {1, 0.18}}], 
       Raster[CompressedData["
1:eJzN1f1P00ccB/AvT0UYD6KIVRgbINhIdDKUKnYcCshwIlaEOQQljGInD4WU
AAJDhIGMbUARyoMSM7PBkIRnLDIoz+IQR8tqgVKwPJVCW6hmQ0DE4dM16fkH
+Ekuubx+uNzl3vc5iyDaKYoGhmFq64OyPl7NvdzvlEc2sQD2tuqrSF96MTjA
4HgKJ96HDd3RzOyysxUPhBDKEo7EdUBvzXjeYNcwCHi79LN7uruhn/5PILN0
HwEZlbl1G/17oYcEHix3shWBvsMc7m1mP/SW8NIjpE2TIGMOF3eLOgB9S8Jm
4cHlaeDbYzq2IuVB/5dqSGhgSYCfXnpW8KFB6C/ddCOtrKXAh6xw+jtzWOmW
Wo2MXDnwYvotEAUj0N+UAjBXTnif1xciPnrOhZXujPqOTqJpJR31GtdPPWxT
0fULlw2SJjAB4smVL2qLkoYQv9Zxqa1C8gjxJrKRq6MtF3F5OzmbMXIf8d42
td0B7WzEPczF8ceuNgAjy9GfIo0qwDvPepbHoBX/8db/hD5/P6aBUJQBbg9P
U409u6C/W5Finp6/+LQPPApLqrTmzENnfJ9DaXf9B1A/sV0K3yCHrpAGJGtv
HAKr3MHDd5yl0K8zG6l2e4RAsrOG7k2bhb5ia/J87ckYqIrGogszZ6CXie4e
FQtE4HK7V/To79PQT1ZIDB+SJsAJg5vRlu2T0Om/GBJHGJMgx23A1HX7BPR8
msO5WfEU4CZqdVLoIuhsckDas0NigKdG8QyKRqHb7LWvm701A8w8t9skLyhz
JiSyF/s2zYKh4JckfTwfeiHwcKxOmQM/JE55Fzsr823feaPnqlAKMoZI2/Kd
+qCn5TWfdtGVA5BDCPmWp3xvfRTh+BpxHjBeey10c+JqRBNlQeWeMazJYmxA
PQ91H702h686UH+y+GvxNQXqb0rxwXrwUbOz5eR7QJ3ipl3zWLl/jdfOB1q9
mQZBrUq/vs9HE7SIgPZnnC2bbyq91C2Xb/rjFBAUFBz/GKd03Qss5l+RM6BN
uypAsFeZ7/AMoW/smTlQGnsvouCsMt/px3S6YspkILxY40wuRQa91g43tNwl
B9OaQTvU9yhzz8NryBIn5gGV1qaIWpxVOa8CiIbNW8bZEsRPVoamb8XPIN6f
0ujlGTWNOPhaa1tq7yTiFgD/lPRgHHH/6FpePHiMeOzFfd0JErSfEXipPfgS
tG/pRfqdj+H2IZ5De+XNiGPvrQ/HQ3Q5kio++k7cAy4YsvxQ31m9tp89No+4
ngbTvzsI9QZNK85iswzxMFy1C2GrFHHjDV+wvolSzQ2G/UzPypYOqOYDw3bR
3A/sPiBG+8VFbDyiZArxjxZau/brq+YGwyLsmzx1clVzg2Hc2Hq+0ESE+JW4
gNZA4ijidi9WlgqWVPO0/s9fKfy8/67q/4hhv+EcwnAJfMQb+YMF34XyEDer
k3kE0gcQp2WrrfomcBC3FqcpbKgPEdfpCD314EYv4vIScj2N24P43CWiiTGu
G/H/ARV7Ius=
        "], {{0, 0}, {1, 0.18}}]}, $CellContext`rs$$ = {1000, -6000, 
      380}, $CellContext`re$$ = {10000, 6000, 750}, $CellContext`tips$$ = {
      "BlackBodySpectrum is a series of colors emitted by the heated black \
body object at certain temperatures. The temperatures are given by Kelvin, \
ranging from 1,000 to 10,000 K.", 
       "HypsometricTints is a set of colors which is used in mapmaking. The \
colors are associated with elevation, ranging from -6000 m to 6000 m.", 
       "VisibleSpectrum is the part of the electromagnetic spectrum that is \
visible to the human eye. Its wavelength is ranging from from 380 nm to 750 \
nm."}, $CellContext`gs$$ = 1, $CellContext`gsel$$ = 1, $CellContext`glen$$ = 
      3, $CellContext`gropts$$ = {
      ImageSize -> {110, 20}, ImageMargins -> {{0, 0}, {6, 0}}, ImagePadding -> 
       0, PlotRangePadding -> 0}, $CellContext`gdopts$$ = {
      Alignment -> {Left, {Center, Top}}, Frame -> None, ItemSize -> Full, 
       Spacings -> {0, 0}}}, 
      TagBox[
       DynamicModuleBox[{Typeset`var$$ = False}, 
        InterpretationBox[
         StyleBox[
          PaneBox[
           TagBox[GridBox[{
              {
               ItemBox[
                OpenerBox[Dynamic[Typeset`var$$],
                 Enabled->Automatic],
                Alignment->Top,
                StripOnInput->False], 
               ItemBox[
                StyleBox[
                 PaneSelectorBox[{False->
                  PaneBox[
                   StyleBox["\<\"  Physical\"\>",
                    StripOnInput->False,
                    FontSize->11],
                   ImageSize->{180, 12}], True->
                  TagBox[GridBox[{
                    {
                    PaneBox[
                    StyleBox["\<\"  Physical\"\>",
                    StripOnInput->False,
                    FontSize->11],
                    ImageSize->{180, 12}]},
                    {
                    PanelBox[
                    TagBox[GridBox[{
                    {
                    PaneBox[
                    DynamicBox[ToBoxes[
                    Column[
                    Map[EventHandler[
                    If[# == $CellContext`gsel$$, 
                    Grid[{{
                    Spacer[10], 
                    Pane[
                    If[# <= $CellContext`glen$$, 
                    Style[
                    Part[$CellContext`gnames$$, #], Bold]], {110, 14}, 
                    Alignment -> {Left, Center}, ImageSizeAction -> 
                    "ShrinkToFit"], 
                    Spacer[10]}, {
                    Spacer[10], 
                    If[# <= $CellContext`glen$$, 
                    Graphics[
                    Part[$CellContext`gimages$$, #], $CellContext`gropts$$]], 
                    
                    Spacer[10]}}, Background -> RGBColor[0.93, 0.93, 0.95], 
                    Dividers -> {False, {
                    1 -> GrayLevel[0.8], 3 -> 
                    GrayLevel[0.8]}}, $CellContext`gdopts$$], 
                    Grid[{{
                    Spacer[10], 
                    Pane[
                    If[# <= $CellContext`glen$$, 
                    Part[$CellContext`gnames$$, #]], {110, 14}, 
                    Alignment -> {Left, Center}, ImageSizeAction -> 
                    "ShrinkToFit"], 
                    Spacer[10]}, {
                    Spacer[10], 
                    If[# <= $CellContext`glen$$, 
                    Graphics[
                    Part[$CellContext`gimages$$, #], $CellContext`gropts$$]], 
                    
                    Spacer[10]}}, $CellContext`gdopts$$]], {
                    "MouseClicked" :> 
                    If[# <= $CellContext`glen$$, $CellContext`gsel$$ = #]}]& ,
                     
                    Range[$CellContext`gs$$, $CellContext`gs$$ + 2]], 
                    Spacings -> {0, 0}], StandardForm]],
                    ImageSize->{142, All}], 
                    PaneBox[
                    SliderBox[Dynamic[$CellContext`gs$$], {1, 1, 1},
                    Appearance->{"Vertical", Small},
                    Enabled->False,
                    ImageSize->Full],
                    Alignment->{Center, Center},
                    ImageSize->{22, 120}]}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxAlignment->{
                    "Columns" -> {Left, Right}, "Rows" -> {{Center}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{All}}, "Rows" -> {{All}}},
                    GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}},
                    RowsEqual->False],
                    "Grid"],
                    Alignment->{Center, Center},
                    
                    BaseStyle->{
                    ImageMargins -> 0, FontSize -> 10, FontFamily -> 
                    "Helvetica", CacheGraphics -> False},
                    FrameMargins->5,
                    ImageSize->{180, All}]},
                    {
                    PanelBox[
                    TagBox[GridBox[{
                    {
                    StyleBox[
                    DynamicBox[ToBoxes[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$], 
                    StandardForm]],
                    StripOnInput->False,
                    FontWeight->Bold]},
                    {
                    TagBox[
                    TooltipBox[
                    GraphicsBox[
                    DynamicBox[Typeset`ToBoxes[
                    Part[$CellContext`gimages$$, $CellContext`gsel$$], 
                    StandardForm, Graphics]],
                    Frame->True,
                    FrameStyle->GrayLevel[0.9],
                    FrameTicks->{{None, None}, {{{0, 
                    FormBox[
                    DynamicBox[
                    ToBoxes[
                    Part[$CellContext`rs$$, $CellContext`gsel$$], 
                    TraditionalForm]], TraditionalForm]}, {0.5, 
                    FormBox[
                    DynamicBox[
                    
                    ToBoxes[(Part[$CellContext`re$$, $CellContext`gsel$$] + 
                    Part[$CellContext`rs$$, $CellContext`gsel$$])/2, 
                    TraditionalForm]], TraditionalForm]}, {1, 
                    FormBox[
                    DynamicBox[
                    ToBoxes[
                    Part[$CellContext`re$$, $CellContext`gsel$$], 
                    TraditionalForm]], TraditionalForm]}}, None}},
                    FrameTicksStyle->GrayLevel[0],
                    ImagePadding->Automatic,
                    ImageSize->{155, Automatic},
                    PlotRangePadding->0],
                    PaneBox[
                    DynamicBox[
                    ToBoxes[
                    Part[$CellContext`tips$$, $CellContext`gsel$$], 
                    StandardForm]], ImageSize -> 300],
                    ActionDelay->0.5],
                    Annotation[#, 
                    Pane[
                    Dynamic[
                    Part[$CellContext`tips$$, $CellContext`gsel$$]], 300], 
                    "Tooltip"]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    Alignment->{Center, Top},
                    
                    BaseStyle->{
                    ImageMargins -> 0, FontSize -> 10, FontFamily -> 
                    "Helvetica", CacheGraphics -> False},
                    FrameMargins->{{0, 0}, {7, 7}},
                    ImageSize->{180, All}]},
                    {
                    TagBox[
                    TooltipBox[
                    DynamicBox[ToBoxes[
                    Button[
                    Style["Insert", 11], 
                    FrontEndExecute[{
                    FrontEnd`NotebookApply[
                    FrontEnd`InputNotebook[], 
                    BoxData[
                    RowBox[{"ColorData", "[", 
                    ToBoxes[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$]], "]"}]],
                     Placeholder]}], ImageSize -> 180], StandardForm]],
                    InterpretationBox[
                    RowBox[{"\"ColorData[\\\"\"", "\[InvisibleSpace]", 
                    DynamicBox[
                    ToBoxes[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$], 
                    StandardForm]], "\[InvisibleSpace]", "\"\\\"]\""}], 
                    Row[{"ColorData[\"", 
                    Dynamic[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$]], 
                    "\"]"}]],
                    ActionDelay->0.3],
                    Annotation[#, 
                    Row[{"ColorData[\"", 
                    Dynamic[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$]], 
                    "\"]"}], "Tooltip"]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                   "Column"]}, Dynamic[Typeset`var$$],
                  Alignment->Automatic,
                  ImageMargins->{{0, 10}, {0, 0}},
                  ImageSize->Automatic],
                 Deployed->False,
                 StripOnInput->False],
                Background->Automatic,
                StripOnInput->False]}
             },
             ColumnsEqual->False,
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Top}}, "RowsIndexed" -> {}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}},
             RowsEqual->False],
            "Grid"],
           BaselinePosition->Automatic,
           DefaultBaseStyle->"OpenerView",
           ImageMargins->0],
          Deployed->True,
          StripOnInput->False],
         OpenerView[{
           Pane[
            Style["  Physical", 11], {180, 12}], 
           Column[{
             Pane[
              Style["  Physical", 11], {180, 12}], 
             Panel[
              Grid[{{
                 Pane[
                  Dynamic[
                   Column[
                    Map[EventHandler[
                    If[# == $CellContext`gsel$$, 
                    Grid[{{
                    Spacer[10], 
                    Pane[
                    If[# <= $CellContext`glen$$, 
                    Style[
                    Part[$CellContext`gnames$$, #], Bold]], {110, 14}, 
                    Alignment -> {Left, Center}, ImageSizeAction -> 
                    "ShrinkToFit"], 
                    Spacer[10]}, {
                    Spacer[10], 
                    If[# <= $CellContext`glen$$, 
                    Graphics[
                    Part[$CellContext`gimages$$, #], $CellContext`gropts$$]], 
                    
                    Spacer[10]}}, Background -> RGBColor[0.93, 0.93, 0.95], 
                    Dividers -> {
                    False, {
                    1 -> GrayLevel[0.8], 3 -> 
                    GrayLevel[0.8]}}, $CellContext`gdopts$$], 
                    Grid[{{
                    Spacer[10], 
                    Pane[
                    If[# <= $CellContext`glen$$, 
                    Part[$CellContext`gnames$$, #]], {110, 14}, 
                    Alignment -> {Left, Center}, ImageSizeAction -> 
                    "ShrinkToFit"], 
                    Spacer[10]}, {
                    Spacer[10], 
                    If[# <= $CellContext`glen$$, 
                    Graphics[
                    Part[$CellContext`gimages$$, #], $CellContext`gropts$$]], 
                    
                    Spacer[10]}}, $CellContext`gdopts$$]], {
                    "MouseClicked" :> 
                    If[# <= $CellContext`glen$$, $CellContext`gsel$$ = #]}]& ,
                     
                    Range[$CellContext`gs$$, $CellContext`gs$$ + 2]], 
                    Spacings -> {0, 0}]], ImageSize -> {142, All}], 
                 Pane[
                  VerticalSlider[
                   Dynamic[$CellContext`gs$$], {1, 1, 1}, Appearance -> Small,
                    Enabled -> False, ImageSize -> Full], {22, 120}, 
                  Alignment -> {Center, Center}]}}, 
               Alignment -> {{Left, Right}, Center}, ItemSize -> Full, 
               Spacings -> {0, 0}], Alignment -> {Center, Center}, 
              BaseStyle -> {
               ImageMargins -> 0, FontSize -> 10, FontFamily -> "Helvetica", 
                CacheGraphics -> False}, FrameMargins -> 5, 
              ImageSize -> {180, All}], 
             Panel[
              Column[{
                Style[
                 Dynamic[
                  Part[$CellContext`gnames$$, $CellContext`gsel$$]], Bold], 
                Tooltip[
                 Graphics[
                  Dynamic[
                   Part[$CellContext`gimages$$, $CellContext`gsel$$]], 
                  ImageSize -> {155, Automatic}, Frame -> True, FrameStyle -> 
                  GrayLevel[0.9], FrameTicks -> {{None, None}, {{{0, 
                    Dynamic[
                    Part[$CellContext`rs$$, $CellContext`gsel$$]]}, {0.5, 
                    
                    Dynamic[(Part[$CellContext`re$$, $CellContext`gsel$$] + 
                    Part[$CellContext`rs$$, $CellContext`gsel$$])/2]}, {1, 
                    Dynamic[
                    Part[$CellContext`re$$, $CellContext`gsel$$]]}}, None}}, 
                  FrameTicksStyle -> GrayLevel[0], ImagePadding -> Automatic, 
                  PlotRangePadding -> 0], 
                 Pane[
                  Dynamic[
                   Part[$CellContext`tips$$, $CellContext`gsel$$]], 300], 
                 ActionDelay -> 0.5]}], Alignment -> {Center, Top}, 
              FrameMargins -> {{0, 0}, {7, 7}}, ImageSize -> {180, All}, 
              BaseStyle -> {
               ImageMargins -> 0, FontSize -> 10, FontFamily -> "Helvetica", 
                CacheGraphics -> False}], 
             Tooltip[
              Dynamic[
               Button[
                Style["Insert", 11], 
                FrontEndExecute[{
                  FrontEnd`NotebookApply[
                   FrontEnd`InputNotebook[], 
                   BoxData[
                    RowBox[{"ColorData", "[", 
                    ToBoxes[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$]], "]"}]],
                    Placeholder]}], ImageSize -> 180]], 
              Row[{"ColorData[\"", 
                Dynamic[
                 Part[$CellContext`gnames$$, $CellContext`gsel$$]], "\"]"}], 
              ActionDelay -> 0.3]}]}, False, 
          FrameMargins -> {{0, 10}, {0, 0}}]],
        DynamicModuleValues:>{}],
       Setting[#, {0}]& ],
      DynamicModuleValues:>{}]},
    {
     DynamicModuleBox[{$CellContext`names$$ = {
      "System", "Atoms", "GeologicAges", "HTML", "Legacy", 
       "WebSafe"}, $CellContext`nlen$$ = 6, $CellContext`menu$$ = {
      1 -> Style["System", 10], 2 -> Style["Atoms", 10], 3 -> 
       Style["GeologicAges", 10], 4 -> Style["HTML", 10], 5 -> 
       Style["Legacy", 10], 6 -> 
       Style["WebSafe", 10]}, $CellContext`rules$$ = {{{
        "White" -> RGBColor[1, 1, 1], "LightGray" -> 
         RGBColor[0.85, 0.85, 0.85], "Gray" -> RGBColor[0.5, 0.5, 0.5], 
         "Black" -> RGBColor[0, 0, 0], "LightPink" -> 
         RGBColor[1, 0.925, 0.925], "LightRed" -> RGBColor[1, 0.85, 0.85], 
         "Pink" -> RGBColor[1, 0.5, 0.5], "Red" -> RGBColor[1, 0, 0], 
         "LightBrown" -> RGBColor[0.94, 0.91, 0.88], "LightOrange" -> 
         RGBColor[1, 0.9, 0.8], "Brown" -> RGBColor[0.6, 0.4, 0.2], "Orange" -> 
         RGBColor[1, 0.5, 0], "LightYellow" -> RGBColor[1, 1, 0.85], "Yellow" -> 
         RGBColor[1, 1, 0], "LightGreen" -> RGBColor[0.88, 1, 0.88], "Green" -> 
         RGBColor[0, 1, 0], "LightCyan" -> RGBColor[0.9, 1, 1], "Cyan" -> 
         RGBColor[0, 1, 1], "LightBlue" -> RGBColor[0.87, 0.94, 1], "Blue" -> 
         RGBColor[0, 0, 1], "LightPurple" -> RGBColor[0.94, 0.88, 0.94], 
         "LightMagenta" -> RGBColor[1, 0.9, 1], "Magenta" -> 
         RGBColor[1, 0, 1], "Purple" -> RGBColor[0.5, 0, 0.5]}, {
        "H" -> RGBColor[0.65, 0.7, 0.7], "He" -> RGBColor[0.836713, 1., 1.], 
         "Li" -> RGBColor[0.799435, 0.543572, 0.997559], "Be" -> 
         RGBColor[0.770565, 0.964309, 0.0442359], "B" -> 
         RGBColor[1., 0.709804, 0.709804], "C" -> RGBColor[0.4, 0.4, 0.4], 
         "N" -> RGBColor[0.291989, 0.437977, 0.888609], "O" -> 
         RGBColor[0.800498, 0.201504, 0.192061], "F" -> 
         RGBColor[0.578462, 0.85539, 0.408855], "Ne" -> 
         RGBColor[0.677263, 0.928423, 0.955287], "Na" -> 
         RGBColor[0.658708, 0.492173, 0.842842], "Mg" -> 
         RGBColor[0.628274, 0.850553, 0.0782731], "Al" -> 
         RGBColor[0.8913, 0.631904, 0.627399], "Si" -> 
         RGBColor[0.941176, 0.784314, 0.627451], "P" -> 
         RGBColor[1., 0.501961, 0], "S" -> 
         RGBColor[0.90443, 0.97015, 0.13504], "Cl" -> 
         RGBColor[0.412698, 0.932689, 0.166398], "Ar" -> 
         RGBColor[0.546138, 0.844244, 0.892092], "K" -> 
         RGBColor[0.534026, 0.420729, 0.705621], "Ca" -> 
         RGBColor[0.480072, 0.744591, 0.0955222], "Sc" -> 
         RGBColor[0.901961, 0.901961, 0.901961], "Ti" -> 
         RGBColor[0.74902, 0.760784, 0.780392], "V" -> 
         RGBColor[0.65098, 0.65098, 0.670588], "Cr" -> 
         RGBColor[0.541176, 0.6, 0.780392], "Mn" -> 
         RGBColor[0.611765, 0.478431, 0.780392], "Fe" -> 
         RGBColor[0.878431, 0.4, 0.2], "Co" -> 
         RGBColor[0.941176, 0.564706, 0.627451], "Ni" -> 
         RGBColor[0.313725, 0.815686, 0.313725], "Cu" -> 
         RGBColor[0.784314, 0.501961, 0.2], "Zn" -> 
         RGBColor[0.490196, 0.501961, 0.690196], "Ga" -> 
         RGBColor[0.800757, 0.542666, 0.533513], "Ge" -> 
         RGBColor[0.60508, 0.632465, 0.576489], "As" -> 
         RGBColor[0.741176, 0.501961, 0.890196], "Se" -> 
         RGBColor[0.917248, 0.657833, 0.0706628], "Br" -> 
         RGBColor[0.58847, 0.22163, 0.16064], "Kr" -> 
         RGBColor[0.426019, 0.747462, 0.810413], "Rb" -> 
         RGBColor[0.425391, 0.329242, 0.585895], "Sr" -> 
         RGBColor[0.325959, 0.646423, 0.095983], "Y" -> 
         RGBColor[0.531014, 1., 1.], "Zr" -> 
         RGBColor[0.458599, 0.917466, 0.918573], "Nb" -> 
         RGBColor[0.385036, 0.834854, 0.841681], "Mo" -> 
         RGBColor[0.310325, 0.752163, 0.769323], "Tc" -> 
         RGBColor[0.234466, 0.669394, 0.701499], "Ru" -> 
         RGBColor[0.157459, 0.586546, 0.638209], "Rh" -> 
         RGBColor[0.0793033, 0.50362, 0.579453], "Pd" -> 
         RGBColor[0., 0.420615, 0.525231], "Ag" -> 
         RGBColor[0.752941, 0.752941, 0.752941], "Cd" -> 
         RGBColor[1., 0.85098, 0.560784], "In" -> 
         RGBColor[0.728371, 0.440594, 0.422196], "Sn" -> 
         RGBColor[0.39799, 0.491477, 0.495586], "Sb" -> 
         RGBColor[0.619608, 0.388235, 0.709804], "Te" -> 
         RGBColor[0.816706, 0.451332, 0.0100947], "I" -> 
         RGBColor[0.580392, 0, 0.580392], "Xe" -> 
         RGBColor[0.316906, 0.638078, 0.710252], "Cs" -> 
         RGBColor[0.332803, 0.217712, 0.483666], "Ba" -> 
         RGBColor[0.165935, 0.55605, 0.0796556], "La" -> 
         RGBColor[0.928084, 0.716075, 0.329427], "Ce" -> 
         RGBColor[0.894824, 0.731424, 0.325131], "Pr" -> 
         RGBColor[0.86523, 0.707999, 0.315261], "Nd" -> 
         RGBColor[0.837836, 0.662974, 0.301635], "Pm" -> 
         RGBColor[0.811992, 0.607859, 0.285626], "Sm" -> 
         RGBColor[0.787563, 0.549894, 0.268279], "Eu" -> 
         RGBColor[0.764628, 0.493261, 0.250405], "Gd" -> 
         RGBColor[0.743177, 0.440115, 0.23269], "Tb" -> 
         RGBColor[0.72281, 0.39143, 0.215783], "Dy" -> 
         RGBColor[0.702434, 0.347663, 0.200392], "Ho" -> 
         RGBColor[0.679962, 0.309234, 0.187368], "Er" -> 
         RGBColor[0.652012, 0.276823, 0.17779], "Tm" -> 
         RGBColor[0.613603, 0.251489, 0.173042], "Yb" -> 
         RGBColor[0.557855, 0.234598, 0.17489], "Lu" -> 
         RGBColor[0.475685, 0.227573, 0.18555], "Hf" -> 
         RGBColor[0.781537, 0.717388, 0.716579], "Ta" -> 
         RGBColor[0.734443, 0.544489, 0.683471], "W" -> 
         RGBColor[0.681179, 0.360409, 0.63675], "Re" -> 
         RGBColor[0.605181, 0.367584, 0.556343], "Os" -> 
         RGBColor[0.521806, 0.382125, 0.469204], "Ir" -> 
         RGBColor[0.445624, 0.373159, 0.399069], "Pt" -> 
         RGBColor[0.815686, 0.815686, 0.878431], "Au" -> 
         RGBColor[1., 0.819608, 0.137255], "Hg" -> 
         RGBColor[0.721569, 0.721569, 0.815686], "Tl" -> 
         RGBColor[0.65098, 0.329412, 0.301961], "Pb" -> 
         RGBColor[0.341176, 0.34902, 0.380392], "Bi" -> 
         RGBColor[0.619608, 0.309804, 0.709804], "Po" -> 
         RGBColor[0.670588, 0.360784, 0], "At" -> 
         RGBColor[0.458824, 0.309804, 0.270588], "Rn" -> 
         RGBColor[0.218799, 0.516091, 0.591608], "Fr" -> 
         RGBColor[0.25626, 0.0861372, 0.398932], "Ra" -> 
         RGBColor[0., 0.473472, 0.04654], "Ac" -> 
         RGBColor[0.322042, 0.71693, 0.988479], "Th" -> 
         RGBColor[0.3608, 0.67166, 0.943003], "Pa" -> 
         RGBColor[0.397469, 0.628, 0.898853], "U" -> 
         RGBColor[0.43205, 0.58595, 0.856029], "Np" -> 
         RGBColor[0.464542, 0.54551, 0.814532], "Pu" -> 
         RGBColor[0.494945, 0.506679, 0.774361], "Am" -> 
         RGBColor[0.52326, 0.469458, 0.735517], "Cm" -> 
         RGBColor[0.549486, 0.433847, 0.697999], "Bk" -> 
         RGBColor[0.573624, 0.399845, 0.661808], "Cf" -> 
         RGBColor[0.595673, 0.367454, 0.626942], "Es" -> 
         RGBColor[0.615633, 0.336672, 0.593404], "Fm" -> 
         RGBColor[0.633505, 0.307499, 0.561191], "Md" -> 
         RGBColor[0.649288, 0.279937, 0.530305], "No" -> 
         RGBColor[0.662982, 0.253984, 0.500746], "Lr" -> 
         RGBColor[0.674588, 0.22964, 0.472513], "Rf" -> 
         RGBColor[0.684106, 0.206907, 0.445606], "Db" -> 
         RGBColor[0.691534, 0.185783, 0.420025], "Sg" -> 
         RGBColor[0.696874, 0.166269, 0.395772], "Bh" -> 
         RGBColor[0.700126, 0.148365, 0.372844], "Hs" -> 
         RGBColor[0.701289, 0.13207, 0.351243], "Mt" -> 
         RGBColor[0.700363, 0.117385, 0.330968], "Ds" -> 
         RGBColor[0.697348, 0.10431, 0.31202], "Rg" -> 
         RGBColor[0.692245, 0.0928444, 0.294398], "Uub" -> 
         RGBColor[0.685054, 0.0829886, 0.278102], "Uut" -> 
         RGBColor[0.675773, 0.0747426, 0.263133], "Uuq" -> 
         RGBColor[0.664405, 0.0681063, 0.249491], "Uup" -> 
         RGBColor[0.650947, 0.0630797, 0.237174], "Uuh" -> 
         RGBColor[0.635401, 0.0596628, 0.226184], "Uus" -> 
         RGBColor[0.635401, 0.0596628, 0.226184], "Uuo" -> 
         RGBColor[0.635401, 0.0596628, 0.226184]}, {
        "Phanerozoic" -> RGBColor[0.690196, 0.886275, 0.819608], "Cenozoic" -> 
         RGBColor[1., 1., 0.], "Quaternary" -> RGBColor[1., 1., 0.301961], 
         "Holocene" -> RGBColor[1., 1., 0.701961], "Pleistocene" -> 
         RGBColor[1., 0.921569, 0.384314], "Neogene" -> 
         RGBColor[0.992157, 0.8, 0.541176], "Pliocene" -> 
         RGBColor[0.996078, 0.921569, 0.67451], "Miocene" -> 
         RGBColor[1., 0.870588, 0.], "Paleogene" -> 
         RGBColor[1., 0.701961, 0.], "Oligocene" -> 
         RGBColor[0.917647, 0.776471, 0.447059], "Eocene" -> 
         RGBColor[0.917647, 0.678431, 0.262745], "Paleocene" -> 
         RGBColor[0.921569, 0.576471, 0.00392157], "Mesozoic" -> 
         RGBColor[0.498039, 0.678431, 0.317647], "Cretaceous" -> 
         RGBColor[0.498039, 0.764706, 0.109804], "UpperCretaceous" -> 
         RGBColor[0.870588, 0.945098, 0.592157], "LowerCretaceous" -> 
         RGBColor[0.701961, 0.87451, 0.498039], "Jurassic" -> 
         RGBColor[0.301961, 0.705882, 0.494118], "UpperJurassic" -> 
         RGBColor[0.8, 0.921569, 0.772549], "MiddleJurassic" -> 
         RGBColor[0.498039, 0.792157, 0.576471], "LowerJurassic" -> 
         RGBColor[0.4, 0.752941, 0.572549], "Triassic" -> 
         RGBColor[0.403922, 0.764706, 0.717647], "UpperTriassic" -> 
         RGBColor[0.8, 0.92549, 0.882353], "MiddleTriassic" -> 
         RGBColor[0.6, 0.843137, 0.745098], "LowerTriassic" -> 
         RGBColor[0.403922, 0.701961, 0.623529], "Paleozoic" -> 
         RGBColor[0.501961, 0.709804, 0.835294], "Permian" -> 
         RGBColor[0.403922, 0.776471, 0.866667], "Lopingian" -> 
         RGBColor[0.701961, 0.890196, 0.933333], "Guadalupian" -> 
         RGBColor[0.6, 0.847059, 0.847059], "Cisuralian" -> 
         RGBColor[0.501961, 0.807843, 0.788235], "Carboniferous" -> 
         RGBColor[0.6, 0.741176, 0.854902], "Pennsylvanian" -> 
         RGBColor[0.407843, 0.623529, 0.792157], "Mississippian" -> 
         RGBColor[0.501961, 0.568627, 0.678431], "Devonian" -> 
         RGBColor[0.6, 0.6, 0.788235], "UpperDevonian" -> 
         RGBColor[0.796078, 0.741176, 0.862745], "MiddleDevonian" -> 
         RGBColor[0.6, 0.513725, 0.745098], "LowerDevonian" -> 
         RGBColor[0.501961, 0.490196, 0.729412], "Silurian" -> 
         RGBColor[0.694118, 0.447059, 0.713725], "Pridoli" -> 
         RGBColor[0.913725, 0.780392, 0.886275], "Ludlow" -> 
         RGBColor[0.792157, 0.654902, 0.819608], "Wenlock" -> 
         RGBColor[0.694118, 0.537255, 0.701961], "Llandovery" -> 
         RGBColor[0.596078, 0.345098, 0.658824], "Ordovician" -> 
         RGBColor[0.976471, 0.505882, 0.65098], "UpperOrdovician" -> 
         RGBColor[0.984314, 0.705882, 0.741176], "MiddleOrdovician" -> 
         RGBColor[0.980392, 0.603922, 0.694118], "LowerOrdovician" -> 
         RGBColor[0.901961, 0.490196, 0.643137], "Cambrian" -> 
         RGBColor[0.984314, 0.501961, 0.372549], "UpperCambrian" -> 
         RGBColor[0.992157, 0.803922, 0.721569], "MiddleCambrian" -> 
         RGBColor[0.909804, 0.682353, 0.592157], "LowerCambrian" -> 
         RGBColor[0.905882, 0.486275, 0.447059], "Precambrian" -> 
         RGBColor[0.698039, 0.52549, 0.32549], "Proterozoic" -> 
         RGBColor[0.8, 0.847059, 0.568627], "Neoproterozoic" -> 
         RGBColor[0.792157, 0.647059, 0.584314], "Ediacaran" -> 
         RGBColor[0.917647, 0.847059, 0.737255], "Cryogenian" -> 
         RGBColor[0.862745, 0.670588, 0.666667], "Tonian" -> 
         RGBColor[0.796078, 0.643137, 0.423529], "Mesoproterozoic" -> 
         RGBColor[0.866667, 0.760784, 0.533333], "Stenian" -> 
         RGBColor[0.866667, 0.760784, 0.533333], "Ectasian" -> 
         RGBColor[0.866667, 0.760784, 0.533333], "Calymmian" -> 
         RGBColor[0.866667, 0.760784, 0.533333], "Paleoproterozoic" -> 
         RGBColor[0.701961, 0.698039, 0.368627], "Statherian" -> 
         RGBColor[0.701961, 0.698039, 0.368627], "Orosirian" -> 
         RGBColor[0.701961, 0.698039, 0.368627], "Rhyacian" -> 
         RGBColor[0.701961, 0.698039, 0.368627], "Siderian" -> 
         RGBColor[0.701961, 0.698039, 0.368627], "Archean" -> 
         RGBColor[0.6, 0.678431, 0.67451], "Neoarchean" -> 
         RGBColor[0.796078, 0.803922, 0.784314], "Mesoarchean" -> 
         RGBColor[0.698039, 0.709804, 0.686275], "Paleoarchean" -> 
         RGBColor[0.6, 0.592157, 0.568627], "Eoarchean" -> 
         RGBColor[0.501961, 0.564706, 0.564706], "Hadean" -> 
         RGBColor[0.5, 0.5, 0.56]}, {
        "White" -> RGBColor[1., 1., 1.], "WhiteSmoke" -> 
         RGBColor[0.9607843137254902, 0.9607843137254902, 0.9607843137254902],
          "Gainsboro" -> 
         RGBColor[0.8627450980392157, 0.8627450980392157, 0.8627450980392157],
          "LightGrey" -> 
         RGBColor[0.8274509803921568, 0.8274509803921568, 0.8274509803921568],
          "LightGray" -> 
         RGBColor[0.8274509803921568, 0.8274509803921568, 0.8274509803921568],
          "Silver" -> 
         RGBColor[0.7529411764705882, 0.7529411764705882, 0.7529411764705882],
          "DarkGrey" -> 
         RGBColor[0.6627450980392157, 0.6627450980392157, 0.6627450980392157],
          "DarkGray" -> 
         RGBColor[0.6627450980392157, 0.6627450980392157, 0.6627450980392157],
          "Grey" -> RGBColor[
          0.5019607843137255, 0.5019607843137255, 0.5019607843137255], "Gray" -> 
         RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255],
          "DimGrey" -> 
         RGBColor[0.4117647058823529, 0.4117647058823529, 0.4117647058823529],
          "DimGray" -> 
         RGBColor[0.4117647058823529, 0.4117647058823529, 0.4117647058823529],
          "Black" -> RGBColor[0., 0., 0.], "Snow" -> 
         RGBColor[1., 0.9803921568627451, 0.9803921568627451], "RosyBrown" -> 
         RGBColor[0.7372549019607844, 0.5607843137254902, 0.5607843137254902],
          "LightCoral" -> 
         RGBColor[0.9411764705882353, 0.5019607843137255, 0.5019607843137255],
          "IndianRed" -> 
         RGBColor[0.803921568627451, 0.3607843137254902, 0.3607843137254902], 
         "Brown" -> RGBColor[
          0.6470588235294118, 0.16470588235294117`, 0.16470588235294117`], 
         "FireBrick" -> 
         RGBColor[
          0.6980392156862745, 0.13333333333333333`, 0.13333333333333333`], 
         "Red" -> RGBColor[1., 0., 0.], "DarkRed" -> 
         RGBColor[0.5450980392156862, 0., 0.], "Maroon" -> 
         RGBColor[0.5019607843137255, 0., 0.], "MistyRose" -> 
         RGBColor[1., 0.8941176470588236, 0.8823529411764706], "Salmon" -> 
         RGBColor[0.9803921568627451, 0.5019607843137255, 0.4470588235294118],
          "Tomato" -> RGBColor[1., 0.38823529411764707`, 0.2784313725490196], 
         "DarkSalmon" -> 
         RGBColor[
          0.9137254901960784, 0.5882352941176471, 0.47843137254901963`], 
         "Coral" -> RGBColor[1., 0.4980392156862745, 0.3137254901960784], 
         "OrangeRed" -> RGBColor[1., 0.27058823529411763`, 0.], "LightSalmon" -> 
         RGBColor[1., 0.6274509803921569, 0.47843137254901963`], "Sienna" -> 
         RGBColor[
          0.6274509803921569, 0.3215686274509804, 0.17647058823529413`], 
         "SeaShell" -> RGBColor[1., 0.9607843137254902, 0.9333333333333333], 
         "Chocolate" -> 
         RGBColor[
          0.8235294117647058, 0.4117647058823529, 0.11764705882352941`], 
         "SaddleBrown" -> 
         RGBColor[
          0.5450980392156862, 0.27058823529411763`, 0.07450980392156863], 
         "SandyBrown" -> 
         RGBColor[0.9568627450980393, 0.6431372549019608, 0.3764705882352941],
          "PeachPuff" -> RGBColor[1., 0.8549019607843137, 0.7254901960784313],
          "Peru" -> RGBColor[
          0.803921568627451, 0.5215686274509804, 0.24705882352941178`], 
         "Linen" -> RGBColor[
          0.9803921568627451, 0.9411764705882353, 0.9019607843137255], 
         "Bisque" -> RGBColor[1., 0.8941176470588236, 0.7686274509803922], 
         "DarkOrange" -> RGBColor[1., 0.5490196078431373, 0.], "BurlyWood" -> 
         RGBColor[0.8705882352941177, 0.7215686274509804, 0.5294117647058824],
          "AntiqueWhite" -> 
         RGBColor[0.9803921568627451, 0.9215686274509803, 0.8431372549019608],
          "Tan" -> RGBColor[
          0.8235294117647058, 0.7058823529411765, 0.5490196078431373], 
         "NavajoWhite" -> 
         RGBColor[1., 0.8705882352941177, 0.6784313725490196], 
         "BlanchedAlmond" -> 
         RGBColor[1., 0.9215686274509803, 0.803921568627451], "PapayaWhip" -> 
         RGBColor[1., 0.9372549019607843, 0.8352941176470589], "Moccasin" -> 
         RGBColor[1., 0.8941176470588236, 0.7098039215686275], "Orange" -> 
         RGBColor[1., 0.6470588235294118, 0.], "Wheat" -> 
         RGBColor[0.9607843137254902, 0.8705882352941177, 0.7019607843137254],
          "OldLace" -> 
         RGBColor[0.9921568627450981, 0.9607843137254902, 0.9019607843137255],
          "FloralWhite" -> 
         RGBColor[1., 0.9803921568627451, 0.9411764705882353], 
         "DarkGoldenRod" -> 
         RGBColor[
          0.7215686274509804, 0.5254901960784314, 0.043137254901960784`], 
         "GoldenRod" -> 
         RGBColor[
          0.8549019607843137, 0.6470588235294118, 0.12549019607843137`], 
         "Cornsilk" -> RGBColor[1., 0.9725490196078431, 0.8627450980392157], 
         "Gold" -> RGBColor[1., 0.8431372549019608, 0.], "LemonChiffon" -> 
         RGBColor[1., 0.9803921568627451, 0.803921568627451], "Khaki" -> 
         RGBColor[0.9411764705882353, 0.9019607843137255, 0.5490196078431373],
          "PaleGoldenRod" -> 
         RGBColor[0.9333333333333333, 0.9098039215686274, 0.6666666666666666],
          "DarkKhaki" -> 
         RGBColor[0.7411764705882353, 0.7176470588235294, 0.4196078431372549],
          "Ivory" -> RGBColor[1., 1., 0.9411764705882353], "Beige" -> 
         RGBColor[0.9607843137254902, 0.9607843137254902, 0.8627450980392157],
          "LightYellow" -> RGBColor[1., 1., 0.8784313725490196], 
         "LightGoldenRodYellow" -> 
         RGBColor[0.9803921568627451, 0.9803921568627451, 0.8235294117647058],
          "Yellow" -> RGBColor[1., 1., 0.], "Olive" -> 
         RGBColor[0.5019607843137255, 0.5019607843137255, 0.], "OliveDrab" -> 
         RGBColor[
          0.4196078431372549, 0.5568627450980392, 0.13725490196078433`], 
         "YellowGreen" -> 
         RGBColor[
          0.6039215686274509, 0.803921568627451, 0.19607843137254902`], 
         "DarkOliveGreen" -> 
         RGBColor[0.3333333333333333, 0.4196078431372549, 0.1843137254901961],
          "GreenYellow" -> 
         RGBColor[0.6784313725490196, 1., 0.1843137254901961], "Chartreuse" -> 
         RGBColor[0.4980392156862745, 1., 0.], "LawnGreen" -> 
         RGBColor[0.48627450980392156`, 0.9882352941176471, 0.], "HoneyDew" -> 
         RGBColor[0.9411764705882353, 1., 0.9411764705882353], "DarkSeaGreen" -> 
         RGBColor[0.5607843137254902, 0.7372549019607844, 0.5607843137254902],
          "PaleGreen" -> 
         RGBColor[0.596078431372549, 0.984313725490196, 0.596078431372549], 
         "LightGreen" -> 
         RGBColor[0.5647058823529412, 0.9333333333333333, 0.5647058823529412],
          "ForestGreen" -> 
         RGBColor[
          0.13333333333333333`, 0.5450980392156862, 0.13333333333333333`], 
         "LimeGreen" -> 
         RGBColor[
          0.19607843137254902`, 0.803921568627451, 0.19607843137254902`], 
         "Lime" -> RGBColor[0., 1., 0.], "Green" -> 
         RGBColor[0., 0.5019607843137255, 0.], "DarkGreen" -> 
         RGBColor[0., 0.39215686274509803`, 0.], "SeaGreen" -> 
         RGBColor[0.1803921568627451, 0.5450980392156862, 0.3411764705882353],
          "MediumSeaGreen" -> 
         RGBColor[
          0.23529411764705882`, 0.7019607843137254, 0.44313725490196076`], 
         "SpringGreen" -> RGBColor[0., 1., 0.4980392156862745], "MintCream" -> 
         RGBColor[0.9607843137254902, 1., 0.9803921568627451], 
         "MediumSpringGreen" -> 
         RGBColor[0., 0.9803921568627451, 0.6039215686274509], 
         "MediumAquaMarine" -> 
         RGBColor[0.4, 0.803921568627451, 0.6666666666666666], "Aquamarine" -> 
         RGBColor[0.4980392156862745, 1., 0.8313725490196079], "Turquoise" -> 
         RGBColor[
          0.25098039215686274`, 0.8784313725490196, 0.8156862745098039], 
         "LightSeaGreen" -> 
         RGBColor[
          0.12549019607843137`, 0.6980392156862745, 0.6666666666666666], 
         "MediumTurquoise" -> 
         RGBColor[0.2823529411764706, 0.8196078431372549, 0.8], "Azure" -> 
         RGBColor[0.9411764705882353, 1., 1.], "LightCyan" -> 
         RGBColor[0.8784313725490196, 1., 1.], "PaleTurquoise" -> 
         RGBColor[0.6862745098039216, 0.9333333333333333, 0.9333333333333333],
          "DarkSlateGrey" -> 
         RGBColor[
          0.1843137254901961, 0.30980392156862746`, 0.30980392156862746`], 
         "DarkSlateGray" -> 
         RGBColor[
          0.1843137254901961, 0.30980392156862746`, 0.30980392156862746`], 
         "Cyan" -> RGBColor[0., 1., 1.], "Aqua" -> RGBColor[0., 1., 1.], 
         "DarkCyan" -> RGBColor[0., 0.5450980392156862, 0.5450980392156862], 
         "Teal" -> RGBColor[0., 0.5019607843137255, 0.5019607843137255], 
         "DarkTurquoise" -> 
         RGBColor[0., 0.807843137254902, 0.8196078431372549], "CadetBlue" -> 
         RGBColor[
          0.37254901960784315`, 0.6196078431372549, 0.6274509803921569], 
         "PowderBlue" -> 
         RGBColor[0.6901960784313725, 0.8784313725490196, 0.9019607843137255],
          "LightBlue" -> 
         RGBColor[0.6784313725490196, 0.8470588235294118, 0.9019607843137255],
          "DeepSkyBlue" -> RGBColor[0., 0.7490196078431373, 1.], "SkyBlue" -> 
         RGBColor[0.5294117647058824, 0.807843137254902, 0.9215686274509803], 
         "LightSkyBlue" -> 
         RGBColor[0.5294117647058824, 0.807843137254902, 0.9803921568627451], 
         "SteelBlue" -> 
         RGBColor[
          0.27450980392156865`, 0.5098039215686274, 0.7058823529411765], 
         "AliceBlue" -> RGBColor[0.9411764705882353, 0.9725490196078431, 1.], 
         "DodgerBlue" -> 
         RGBColor[0.11764705882352941`, 0.5647058823529412, 1.], 
         "LightSlateGrey" -> 
         RGBColor[0.4666666666666667, 0.5333333333333333, 0.6], 
         "LightSlateGray" -> 
         RGBColor[0.4666666666666667, 0.5333333333333333, 0.6], "SlateGrey" -> 
         RGBColor[0.4392156862745098, 0.5019607843137255, 0.5647058823529412],
          "SlateGray" -> 
         RGBColor[0.4392156862745098, 0.5019607843137255, 0.5647058823529412],
          "LightSteelBlue" -> 
         RGBColor[0.6901960784313725, 0.7686274509803922, 0.8705882352941177],
          "CornflowerBlue" -> 
         RGBColor[
          0.39215686274509803`, 0.5843137254901961, 0.9294117647058824], 
         "RoyalBlue" -> 
         RGBColor[0.2549019607843137, 0.4117647058823529, 0.8823529411764706],
          "GhostWhite" -> 
         RGBColor[0.9725490196078431, 0.9725490196078431, 1.], "Lavender" -> 
         RGBColor[0.9019607843137255, 0.9019607843137255, 0.9803921568627451],
          "MidnightBlue" -> 
         RGBColor[
          0.09803921568627451, 0.09803921568627451, 0.4392156862745098], 
         "Blue" -> RGBColor[0., 0., 1.], "MediumBlue" -> 
         RGBColor[0., 0., 0.803921568627451], "DarkBlue" -> 
         RGBColor[0., 0., 0.5450980392156862], "Navy" -> 
         RGBColor[0., 0., 0.5019607843137255], "SlateBlue" -> 
         RGBColor[
          0.41568627450980394`, 0.35294117647058826`, 0.803921568627451], 
         "DarkSlateBlue" -> 
         RGBColor[
          0.2823529411764706, 0.23921568627450981`, 0.5450980392156862], 
         "MediumSlateBlue" -> 
         RGBColor[
          0.4823529411764706, 0.40784313725490196`, 0.9333333333333333], 
         "MediumPurple" -> 
         RGBColor[0.5764705882352941, 0.4392156862745098, 0.8470588235294118],
          "BlueViolet" -> 
         RGBColor[
          0.5411764705882353, 0.16862745098039217`, 0.8862745098039215], 
         "Indigo" -> RGBColor[0.29411764705882354`, 0., 0.5098039215686274], 
         "DarkOrchid" -> RGBColor[0.6, 0.19607843137254902`, 0.8], 
         "DarkViolet" -> RGBColor[0.5803921568627451, 0., 0.8274509803921568],
          "MediumOrchid" -> 
         RGBColor[0.7294117647058823, 0.3333333333333333, 0.8274509803921568],
          "Thistle" -> 
         RGBColor[0.8470588235294118, 0.7490196078431373, 0.8470588235294118],
          "Plum" -> RGBColor[
          0.8666666666666667, 0.6274509803921569, 0.8666666666666667], 
         "Violet" -> 
         RGBColor[0.9333333333333333, 0.5098039215686274, 0.9333333333333333],
          "Magenta" -> RGBColor[1., 0., 1.], "Fuchsia" -> 
         RGBColor[1., 0., 1.], "DarkMagenta" -> 
         RGBColor[0.5450980392156862, 0., 0.5450980392156862], "Purple" -> 
         RGBColor[0.5019607843137255, 0., 0.5019607843137255], "Orchid" -> 
         RGBColor[0.8549019607843137, 0.4392156862745098, 0.8392156862745098],
          "MediumVioletRed" -> 
         RGBColor[
          0.7803921568627451, 0.08235294117647059, 0.5215686274509804], 
         "DeepPink" -> RGBColor[1., 0.0784313725490196, 0.5764705882352941], 
         "HotPink" -> RGBColor[1., 0.4117647058823529, 0.7058823529411765], 
         "PaleVioletRed" -> 
         RGBColor[0.8470588235294118, 0.4392156862745098, 0.5764705882352941],
          "LavenderBlush" -> 
         RGBColor[1., 0.9411764705882353, 0.9607843137254902], "Crimson" -> 
         RGBColor[
          0.8627450980392157, 0.0784313725490196, 0.23529411764705882`], 
         "Pink" -> RGBColor[1., 0.7529411764705882, 0.796078431372549], 
         "LightPink" -> 
         RGBColor[1., 0.7137254901960784, 0.7568627450980392]}, {
        "White" -> RGBColor[1, 1, 1], "Smoke" -> 
         RGBColor[0.960799, 0.960799, 0.960799], "Gainsboro" -> 
         RGBColor[0.862697, 0.862697, 0.862697], "LightGray" -> 
         RGBColor[0.666666, 0.666666, 0.666666], "Gray" -> 
         RGBColor[0.5, 0.5, 0.5], "DimGray" -> 
         RGBColor[0.333333, 0.333333, 0.333333], "Black" -> RGBColor[0, 0, 0],
          "Snow" -> RGBColor[1., 0.980407, 0.980407], "RosyBrown" -> 
         RGBColor[0.737297, 0.560793, 0.560793], "Peach" -> 
         RGBColor[0.44, 0.26, 0.26], "LightCoral" -> 
         RGBColor[0.941206, 0.501999, 0.501999], "Pink" -> 
         RGBColor[1, 0.5, 0.5], "Firebrick" -> 
         RGBColor[0.698004, 0.133305, 0.133305], "BrownMadder" -> 
         RGBColor[0.859996, 0.159993, 0.159993], "Red" -> RGBColor[1, 0, 0], 
         "DeepCadmiumRed" -> RGBColor[0.889996, 0.089999, 0.050005], 
         "MistyRose" -> RGBColor[1., 0.894101, 0.882397], "Salmon" -> 
         RGBColor[0.980407, 0.501999, 0.447096], "BurntUmber" -> 
         RGBColor[0.539994, 0.200003, 0.140004], "Tomato" -> 
         RGBColor[1., 0.388195, 0.278405], "EnglishRed" -> 
         RGBColor[0.829997, 0.239998, 0.099994], "GreenishUmber" -> 
         RGBColor[1., 0.239998, 0.050005], "Apricot" -> 
         RGBColor[1., 0.340007, 0.129994], "Sepia" -> 
         RGBColor[0.370006, 0.149998, 0.069994], "Coral" -> 
         RGBColor[1., 0.498001, 0.3137], "OrangeRed" -> 
         RGBColor[1., 0.270608, 0.], "LightSalmon" -> 
         RGBColor[1., 0.627506, 0.478393], "BurntSienna" -> 
         RGBColor[0.539994, 0.209998, 0.059999], "Oak" -> 
         RGBColor[1., 0.490005, 0.250008], "Sienna" -> 
         RGBColor[0.627506, 0.321604, 0.176504], "YellowBrown" -> 
         RGBColor[0.86, 0.58, 0.44], "IvoryBlack" -> 
         RGBColor[0.159993, 0.140004, 0.129994], "BrownOchre" -> 
         RGBColor[0.53, 0.260002, 0.119999], "VanDykeBrown" -> 
         RGBColor[0.370006, 0.149998, 0.020005], "MarsOrange" -> 
         RGBColor[0.589999, 0.269997, 0.080004], "CadmiumOrange" -> 
         RGBColor[1., 0.380001, 0.009995], "DeepOchre" -> 
         RGBColor[0.449995, 0.239998, 0.099994], "Seashell" -> 
         RGBColor[1., 0.960799, 0.933302], "SaddleBrown" -> 
         RGBColor[0.545106, 0.270608, 0.074496], "Chocolate" -> 
         RGBColor[0.823496, 0.411802, 0.117603], "RawSienna" -> 
         RGBColor[0.780007, 0.380001, 0.080004], "MarsYellow" -> 
         RGBColor[0.889996, 0.440001, 0.099994], "SandyBrown" -> 
         RGBColor[0.956893, 0.643101, 0.376507], "PeachPuff" -> 
         RGBColor[1., 0.8549, 0.725501], "Peru" -> 
         RGBColor[0.803903, 0.521607, 0.247093], "Linen" -> 
         RGBColor[0.980407, 0.941206, 0.902005], "Brown" -> 
         RGBColor[0.6, 0.4, 0.2], "Orange" -> RGBColor[1, 0.5, 0], 
         "GoldOchre" -> RGBColor[0.780007, 0.47, 0.149998], "Melon" -> 
         RGBColor[0.889996, 0.659993, 0.410001], "YellowOchre" -> 
         RGBColor[0.889996, 0.509995, 0.089999], "DarkOrange" -> 
         RGBColor[1., 0.548997, 0.], "Carrot" -> 
         RGBColor[0.930006, 0.569994, 0.129994], "Eggshell" -> 
         RGBColor[0.990005, 0.900006, 0.790002], "Bisque" -> 
         RGBColor[1., 0.898053, 0.771844], "Burlywood" -> 
         RGBColor[0.870602, 0.721595, 0.529405], "CadmiumYellow" -> 
         RGBColor[1., 0.599994, 0.069994], "Brick" -> 
         RGBColor[0.610004, 0.400006, 0.119999], "Beige" -> 
         RGBColor[0.640004, 0.580004, 0.5], "Antique" -> 
         RGBColor[0.980575, 0.92233, 0.844661], "RawUmber" -> 
         RGBColor[0.449995, 0.290002, 0.069994], "Navajo" -> 
         RGBColor[1., 0.870602, 0.678396], "BlanchedAlmond" -> 
         RGBColor[1., 0.921598, 0.803903], "AureolineYellow" -> 
         RGBColor[1., 0.659993, 0.140004], "PapayaWhip" -> 
         RGBColor[1., 0.9373, 0.835307], "DeepNaplesYellow" -> 
         RGBColor[1., 0.659993, 0.069994], "Moccasin" -> 
         RGBColor[1., 0.894101, 0.709799], "Wheat" -> 
         RGBColor[0.960799, 0.870602, 0.702002], "OldLace" -> 
         RGBColor[0.992203, 0.960799, 0.902005], "Floral" -> 
         RGBColor[1., 0.980407, 0.941206], "LightCadmiumYellow" -> 
         RGBColor[1., 0.689993, 0.059999], "DarkGoldenrod" -> 
         RGBColor[0.721595, 0.525498, 0.043107], "Goldenrod" -> 
         RGBColor[0.8549, 0.647099, 0.125507], "Cornsilk" -> 
         RGBColor[1., 0.972503, 0.862697], "LightGoldenrod" -> 
         RGBColor[0.933302, 0.866695, 0.509796], "Gold" -> 
         RGBColor[1., 0.843104, 0.], "Banana" -> 
         RGBColor[0.889996, 0.810007, 0.340007], "CadmiumLemon" -> 
         RGBColor[1., 0.889996, 0.009995], "Khaki" -> 
         RGBColor[0.941206, 0.902005, 0.548997], "LemonChiffon" -> 
         RGBColor[1., 0.980407, 0.803903], "PaleGoldenrod" -> 
         RGBColor[0.933302, 0.909803, 0.666707], "DarkKhaki" -> 
         RGBColor[0.741203, 0.717597, 0.419599], "Ivory" -> 
         RGBColor[1., 1., 0.941206], "LightBeige" -> 
         RGBColor[0.960799, 0.960799, 0.862697], "LightYellow" -> 
         RGBColor[1., 1., 0.878399], "WarmGray" -> 
         RGBColor[0.5, 0.5, 0.410001], "Yellow" -> RGBColor[1, 1, 0], 
         "Titanium" -> RGBColor[0.990005, 1., 0.940001], "ChromeOxideGreen" -> 
         RGBColor[0.400006, 0.5, 0.080004], "OliveDrab" -> 
         RGBColor[0.419599, 0.556902, 0.137303], "YellowGreen" -> 
         RGBColor[0.6039, 0.803903, 0.196097], "DarkOliveGreen" -> 
         RGBColor[0.333293, 0.419599, 0.184301], "GreenYellow" -> 
         RGBColor[0.678396, 1., 0.184301], "TerreVerte" -> 
         RGBColor[0.219993, 0.370006, 0.059999], "Chartreuse" -> 
         RGBColor[0.498001, 1., 0.], "LawnGreen" -> 
         RGBColor[0.486297, 0.988205, 0.], "CinnabarGreen" -> 
         RGBColor[0.380001, 0.700003, 0.159993], "Olive" -> 
         RGBColor[0.230003, 0.370006, 0.170003], "SapGreen" -> 
         RGBColor[0.189993, 0.5, 0.080004], "Honeydew" -> 
         RGBColor[0.941206, 1., 0.941206], "DarkSeaGreen" -> 
         RGBColor[0.560793, 0.737297, 0.560793], "PaleGreen" -> 
         RGBColor[0.596103, 0.984298, 0.596103], "ForestGreen" -> 
         RGBColor[0.133305, 0.545106, 0.133305], "LimeGreen" -> 
         RGBColor[0.196097, 0.803903, 0.196097], "Green" -> RGBColor[0, 1, 0],
          "DarkGreen" -> RGBColor[0., 0.392193, 0.], "LightViridian" -> 
         RGBColor[0.430006, 1., 0.440001], "CobaltGreen" -> 
         RGBColor[0.239998, 0.569994, 0.250008], "PermanentGreen" -> 
         RGBColor[0.039995, 0.790002, 0.170003], "Mint" -> 
         RGBColor[0.739998, 0.990005, 0.790002], "EmeraldGreen" -> 
         RGBColor[0., 0.790002, 0.340007], "SeaGreen" -> 
         RGBColor[0.180395, 0.545106, 0.341197], "MediumSeaGreen" -> 
         RGBColor[0.235298, 0.702002, 0.443098], "SpringGreen" -> 
         RGBColor[0., 1., 0.498001], "LampBlack" -> 
         RGBColor[0.179998, 0.280007, 0.230003], "MintCream" -> 
         RGBColor[0.960799, 1., 0.980407], "MediumSpringGreen" -> 
         RGBColor[0., 0.980407, 0.6039], "MediumAquamarine" -> 
         RGBColor[0.400006, 0.803903, 0.666707], "Aquamarine" -> 
         RGBColor[0.498001, 1., 0.831401], "TurquoiseBlue" -> 
         RGBColor[0., 0.780007, 0.550005], "ColdGray" -> 
         RGBColor[0.5, 0.539994, 0.53], "Turquoise" -> 
         RGBColor[0.250999, 0.878399, 0.815699], "ManganeseBlue" -> 
         RGBColor[0.009995, 0.659993, 0.619999], "LightSeaGreen" -> 
         RGBColor[0.125507, 0.698004, 0.666707], "MediumTurquoise" -> 
         RGBColor[0.282403, 0.819605, 0.799997], "Azure" -> 
         RGBColor[0.94174, 1., 1.], "CyanWhite" -> RGBColor[0.878399, 1., 1.],
          "PaleTurquoise" -> RGBColor[0.6863, 0.933302, 0.933302], 
         "DarkSlateGray" -> RGBColor[0.184301, 0.309793, 0.309793], "Cyan" -> 
         RGBColor[0, 1, 1], "DarkTurquoise" -> 
         RGBColor[0., 0.807794, 0.819605], "CadetBlue" -> 
         RGBColor[0.372494, 0.619602, 0.627506], "Cerulean" -> 
         RGBColor[0.020005, 0.719993, 0.799997], "PowderBlue" -> 
         RGBColor[0.690207, 0.878399, 0.902005], "LightBlue" -> 
         RGBColor[0.678396, 0.847102, 0.902005], "DeepSkyBlue" -> 
         RGBColor[0., 0.749, 1.], "Peacock" -> 
         RGBColor[0.200003, 0.629994, 0.790002], "SkyBlue" -> 
         RGBColor[0.529405, 0.807794, 0.921598], "LightSkyBlue" -> 
         RGBColor[0.529405, 0.807794, 0.980407], "SteelBlue" -> 
         RGBColor[0.274499, 0.509796, 0.705893], "AliceBlue" -> 
         RGBColor[0.941206, 0.972503, 1.], "DodgerBlue" -> 
         RGBColor[0.117603, 0.564699, 1.], "SlateGray" -> 
         RGBColor[0.439207, 0.501999, 0.564699], "Indigo" -> 
         RGBColor[0.03, 0.179998, 0.329997], "LightSlateGray" -> 
         RGBColor[0.466704, 0.533296, 0.599994], "LightSteelBlue" -> 
         RGBColor[0.690207, 0.768593, 0.870602], "CornflowerBlue" -> 
         RGBColor[0.392193, 0.584307, 0.929395], "Cobalt" -> 
         RGBColor[0.239998, 0.350002, 0.670003], "RoyalBlue" -> 
         RGBColor[0.254906, 0.411802, 0.882397], "Ghost" -> 
         RGBColor[0.972503, 0.972503, 1.], "Lavender" -> 
         RGBColor[0.902005, 0.902005, 0.980407], "PrussianBlue" -> 
         RGBColor[0.18, 0.18, 0.31], "MidnightBlue" -> 
         RGBColor[0.097995, 0.097995, 0.439207], "Blue" -> RGBColor[0, 0, 1], 
         "MediumBlue" -> RGBColor[0., 0., 0.803903], "NavyBlue" -> 
         RGBColor[0., 0., 0.501999], "Navy" -> RGBColor[0., 0., 0.501999], 
         "Ultramarine" -> RGBColor[0.069994, 0.039995, 0.559999], "SlateBlue" -> 
         RGBColor[0.415693, 0.352901, 0.803903], "LightSlateBlue" -> 
         RGBColor[0.517594, 0.439207, 1.], "DarkSlateBlue" -> 
         RGBColor[0.282403, 0.239204, 0.545106], "MediumSlateBlue" -> 
         RGBColor[0.482406, 0.407804, 0.933302], "MediumPurple" -> 
         RGBColor[0.576495, 0.439207, 0.858806], "BlueViolet" -> 
         RGBColor[0.5412, 0.1686, 0.886303], "Zinc" -> 
         RGBColor[0.990005, 0.97, 1.], "DarkOrchid" -> 
         RGBColor[0.599994, 0.196097, 0.799997], "DarkViolet" -> 
         RGBColor[0.580401, 0., 0.827494], "UltramarineViolet" -> 
         RGBColor[0.359996, 0.140004, 0.430006], "MediumOrchid" -> 
         RGBColor[0.729408, 0.333293, 0.827494], "Violet" -> 
         RGBColor[0.559999, 0.370006, 0.599994], "DeepCobaltViolet" -> 
         RGBColor[0.569994, 0.129994, 0.619999], "Thistle" -> 
         RGBColor[0.847102, 0.749, 0.847102], "Plum" -> 
         RGBColor[0.866695, 0.627506, 0.866695], "Magenta" -> 
         RGBColor[1, 0, 1], "Purple" -> RGBColor[0.5, 0, 0.5], "Orchid" -> 
         RGBColor[0.8549, 0.439207, 0.839198], "VioletRed" -> 
         RGBColor[0.815699, 0.125507, 0.564699], "MediumVioletRed" -> 
         RGBColor[0.780404, 0.0824, 0.521607], "DeepPink" -> 
         RGBColor[1., 0.078402, 0.576495], "Raspberry" -> 
         RGBColor[0.53, 0.149998, 0.340007], "HotPink" -> 
         RGBColor[1., 0.411802, 0.705893], "Maroon" -> 
         RGBColor[0.690207, 0.188192, 0.376507], "LavenderBlush" -> 
         RGBColor[1., 0.941206, 0.960799], "PaleVioletRed" -> 
         RGBColor[0.858806, 0.439207, 0.576495], "PermanentRedViolet" -> 
         RGBColor[0.859996, 0.149998, 0.269997], "LightPink" -> 
         RGBColor[1., 0.713706, 0.756905], "GeraniumLake" -> 
         RGBColor[0.889996, 0.069994, 0.189993], "AlizarinCrimson" -> 
         RGBColor[0.889996, 0.149998, 0.209998], "IndianRed" -> 
         RGBColor[0.689993, 0.089999, 0.119999], "LightCadmiumRed" -> 
         RGBColor[1., 0.009995, 0.050005], "VenetianRed" -> 
         RGBColor[0.829997, 0.099994, 0.119999], "RoseMadder" -> 
         RGBColor[0.889996, 0.209998, 0.219993], "DeepMadderLake" -> 
         RGBColor[0.889996, 0.179998, 0.189993]}, {
        "#FFFFFF" -> RGBColor[1., 1., 1.], "#FFFFCC" -> RGBColor[1., 1., 0.8],
          "#FFFF99" -> RGBColor[1., 1., 0.6], "#FFFF66" -> 
         RGBColor[1., 1., 0.4], "#FFFF33" -> RGBColor[1., 1., 0.2], "#FFFF00" -> 
         RGBColor[1., 1., 0.], "#FFCCFF" -> RGBColor[1., 0.8, 1.], "#FFCCCC" -> 
         RGBColor[1., 0.8, 0.8], "#FFCC99" -> RGBColor[1., 0.8, 0.6], 
         "#FFCC66" -> RGBColor[1., 0.8, 0.4], "#FFCC33" -> 
         RGBColor[1., 0.8, 0.2], "#FFCC00" -> RGBColor[1., 0.8, 0.], 
         "#FF99FF" -> RGBColor[1., 0.6, 1.], "#FF99CC" -> 
         RGBColor[1., 0.6, 0.8], "#FF9999" -> RGBColor[1., 0.6, 0.6], 
         "#FF9966" -> RGBColor[1., 0.6, 0.4], "#FF9933" -> 
         RGBColor[1., 0.6, 0.2], "#FF9900" -> RGBColor[1., 0.6, 0.], 
         "#FF66FF" -> RGBColor[1., 0.4, 1.], "#FF66CC" -> 
         RGBColor[1., 0.4, 0.8], "#FF6699" -> RGBColor[1., 0.4, 0.6], 
         "#FF6666" -> RGBColor[1., 0.4, 0.4], "#FF6633" -> 
         RGBColor[1., 0.4, 0.2], "#FF6600" -> RGBColor[1., 0.4, 0.], 
         "#FF33FF" -> RGBColor[1., 0.2, 1.], "#FF33CC" -> 
         RGBColor[1., 0.2, 0.8], "#FF3399" -> RGBColor[1., 0.2, 0.6], 
         "#FF3366" -> RGBColor[1., 0.2, 0.4], "#FF3333" -> 
         RGBColor[1., 0.2, 0.2], "#FF3300" -> RGBColor[1., 0.2, 0.], 
         "#FF00FF" -> RGBColor[1., 0., 1.], "#FF00CC" -> 
         RGBColor[1., 0., 0.8], "#FF0099" -> RGBColor[1., 0., 0.6], "#FF0066" -> 
         RGBColor[1., 0., 0.4], "#FF0033" -> RGBColor[1., 0., 0.2], "#FF0000" -> 
         RGBColor[1., 0., 0.], "#CCFFFF" -> RGBColor[0.8, 1., 1.], "#CCFFCC" -> 
         RGBColor[0.8, 1., 0.8], "#CCFF99" -> RGBColor[0.8, 1., 0.6], 
         "#CCFF66" -> RGBColor[0.8, 1., 0.4], "#CCFF33" -> 
         RGBColor[0.8, 1., 0.2], "#CCFF00" -> RGBColor[0.8, 1., 0.], 
         "#CCCCFF" -> RGBColor[0.8, 0.8, 1.], "#CCCCCC" -> 
         RGBColor[0.8, 0.8, 0.8], "#CCCC99" -> RGBColor[0.8, 0.8, 0.6], 
         "#CCCC66" -> RGBColor[0.8, 0.8, 0.4], "#CCCC33" -> 
         RGBColor[0.8, 0.8, 0.2], "#CCCC00" -> RGBColor[0.8, 0.8, 0.], 
         "#CC99FF" -> RGBColor[0.8, 0.6, 1.], "#CC99CC" -> 
         RGBColor[0.8, 0.6, 0.8], "#CC9999" -> RGBColor[0.8, 0.6, 0.6], 
         "#CC9966" -> RGBColor[0.8, 0.6, 0.4], "#CC9933" -> 
         RGBColor[0.8, 0.6, 0.2], "#CC9900" -> RGBColor[0.8, 0.6, 0.], 
         "#CC66FF" -> RGBColor[0.8, 0.4, 1.], "#CC66CC" -> 
         RGBColor[0.8, 0.4, 0.8], "#CC6699" -> RGBColor[0.8, 0.4, 0.6], 
         "#CC6666" -> RGBColor[0.8, 0.4, 0.4], "#CC6633" -> 
         RGBColor[0.8, 0.4, 0.2], "#CC6600" -> RGBColor[0.8, 0.4, 0.], 
         "#CC33FF" -> RGBColor[0.8, 0.2, 1.], "#CC33CC" -> 
         RGBColor[0.8, 0.2, 0.8], "#CC3399" -> RGBColor[0.8, 0.2, 0.6], 
         "#CC3366" -> RGBColor[0.8, 0.2, 0.4], "#CC3333" -> 
         RGBColor[0.8, 0.2, 0.2], "#CC3300" -> RGBColor[0.8, 0.2, 0.], 
         "#CC00FF" -> RGBColor[0.8, 0., 1.], "#CC00CC" -> 
         RGBColor[0.8, 0., 0.8], "#CC0099" -> RGBColor[0.8, 0., 0.6], 
         "#CC0066" -> RGBColor[0.8, 0., 0.4], "#CC0033" -> 
         RGBColor[0.8, 0., 0.2], "#CC0000" -> RGBColor[0.8, 0., 0.], 
         "#99FFFF" -> RGBColor[0.6, 1., 1.], "#99FFCC" -> 
         RGBColor[0.6, 1., 0.8], "#99FF99" -> RGBColor[0.6, 1., 0.6], 
         "#99FF66" -> RGBColor[0.6, 1., 0.4], "#99FF33" -> 
         RGBColor[0.6, 1., 0.2], "#99FF00" -> RGBColor[0.6, 1., 0.], 
         "#99CCFF" -> RGBColor[0.6, 0.8, 1.], "#99CCCC" -> 
         RGBColor[0.6, 0.8, 0.8], "#99CC99" -> RGBColor[0.6, 0.8, 0.6], 
         "#99CC66" -> RGBColor[0.6, 0.8, 0.4], "#99CC33" -> 
         RGBColor[0.6, 0.8, 0.2], "#99CC00" -> RGBColor[0.6, 0.8, 0.], 
         "#9999FF" -> RGBColor[0.6, 0.6, 1.], "#9999CC" -> 
         RGBColor[0.6, 0.6, 0.8], "#999999" -> RGBColor[0.6, 0.6, 0.6], 
         "#999966" -> RGBColor[0.6, 0.6, 0.4], "#999933" -> 
         RGBColor[0.6, 0.6, 0.2], "#999900" -> RGBColor[0.6, 0.6, 0.], 
         "#9966FF" -> RGBColor[0.6, 0.4, 1.], "#9966CC" -> 
         RGBColor[0.6, 0.4, 0.8], "#996699" -> RGBColor[0.6, 0.4, 0.6], 
         "#996666" -> RGBColor[0.6, 0.4, 0.4], "#996633" -> 
         RGBColor[0.6, 0.4, 0.2], "#996600" -> RGBColor[0.6, 0.4, 0.], 
         "#9933FF" -> RGBColor[0.6, 0.2, 1.], "#9933CC" -> 
         RGBColor[0.6, 0.2, 0.8], "#993399" -> RGBColor[0.6, 0.2, 0.6], 
         "#993366" -> RGBColor[0.6, 0.2, 0.4], "#993333" -> 
         RGBColor[0.6, 0.2, 0.2], "#993300" -> RGBColor[0.6, 0.2, 0.], 
         "#9900FF" -> RGBColor[0.6, 0., 1.], "#9900CC" -> 
         RGBColor[0.6, 0., 0.8], "#990099" -> RGBColor[0.6, 0., 0.6], 
         "#990066" -> RGBColor[0.6, 0., 0.4], "#990033" -> 
         RGBColor[0.6, 0., 0.2], "#990000" -> RGBColor[0.6, 0., 0.], 
         "#66FFFF" -> RGBColor[0.4, 1., 1.], "#66FFCC" -> 
         RGBColor[0.4, 1., 0.8], "#66FF99" -> RGBColor[0.4, 1., 0.6], 
         "#66FF66" -> RGBColor[0.4, 1., 0.4], "#66FF33" -> 
         RGBColor[0.4, 1., 0.2], "#66FF00" -> RGBColor[0.4, 1., 0.], 
         "#66CCFF" -> RGBColor[0.4, 0.8, 1.], "#66CCCC" -> 
         RGBColor[0.4, 0.8, 0.8], "#66CC99" -> RGBColor[0.4, 0.8, 0.6], 
         "#66CC66" -> RGBColor[0.4, 0.8, 0.4], "#66CC33" -> 
         RGBColor[0.4, 0.8, 0.2], "#66CC00" -> RGBColor[0.4, 0.8, 0.], 
         "#6699FF" -> RGBColor[0.4, 0.6, 1.], "#6699CC" -> 
         RGBColor[0.4, 0.6, 0.8], "#669999" -> RGBColor[0.4, 0.6, 0.6], 
         "#669966" -> RGBColor[0.4, 0.6, 0.4], "#669933" -> 
         RGBColor[0.4, 0.6, 0.2], "#669900" -> RGBColor[0.4, 0.6, 0.], 
         "#6666FF" -> RGBColor[0.4, 0.4, 1.], "#6666CC" -> 
         RGBColor[0.4, 0.4, 0.8], "#666699" -> RGBColor[0.4, 0.4, 0.6], 
         "#666666" -> RGBColor[0.4, 0.4, 0.4], "#666633" -> 
         RGBColor[0.4, 0.4, 0.2], "#666600" -> RGBColor[0.4, 0.4, 0.], 
         "#6633FF" -> RGBColor[0.4, 0.2, 1.], "#6633CC" -> 
         RGBColor[0.4, 0.2, 0.8], "#663399" -> RGBColor[0.4, 0.2, 0.6], 
         "#663366" -> RGBColor[0.4, 0.2, 0.4], "#663333" -> 
         RGBColor[0.4, 0.2, 0.2], "#663300" -> RGBColor[0.4, 0.2, 0.], 
         "#6600FF" -> RGBColor[0.4, 0., 1.], "#6600CC" -> 
         RGBColor[0.4, 0., 0.8], "#660099" -> RGBColor[0.4, 0., 0.6], 
         "#660066" -> RGBColor[0.4, 0., 0.4], "#660033" -> 
         RGBColor[0.4, 0., 0.2], "#660000" -> RGBColor[0.4, 0., 0.], 
         "#33FFFF" -> RGBColor[0.2, 1., 1.], "#33FFCC" -> 
         RGBColor[0.2, 1., 0.8], "#33FF99" -> RGBColor[0.2, 1., 0.6], 
         "#33FF66" -> RGBColor[0.2, 1., 0.4], "#33FF33" -> 
         RGBColor[0.2, 1., 0.2], "#33FF00" -> RGBColor[0.2, 1., 0.], 
         "#33CCFF" -> RGBColor[0.2, 0.8, 1.], "#33CCCC" -> 
         RGBColor[0.2, 0.8, 0.8], "#33CC99" -> RGBColor[0.2, 0.8, 0.6], 
         "#33CC66" -> RGBColor[0.2, 0.8, 0.4], "#33CC33" -> 
         RGBColor[0.2, 0.8, 0.2], "#33CC00" -> RGBColor[0.2, 0.8, 0.], 
         "#3399FF" -> RGBColor[0.2, 0.6, 1.], "#3399CC" -> 
         RGBColor[0.2, 0.6, 0.8], "#339999" -> RGBColor[0.2, 0.6, 0.6], 
         "#339966" -> RGBColor[0.2, 0.6, 0.4], "#339933" -> 
         RGBColor[0.2, 0.6, 0.2], "#339900" -> RGBColor[0.2, 0.6, 0.], 
         "#3366FF" -> RGBColor[0.2, 0.4, 1.], "#3366CC" -> 
         RGBColor[0.2, 0.4, 0.8], "#336699" -> RGBColor[0.2, 0.4, 0.6], 
         "#336666" -> RGBColor[0.2, 0.4, 0.4], "#336633" -> 
         RGBColor[0.2, 0.4, 0.2], "#336600" -> RGBColor[0.2, 0.4, 0.], 
         "#3333FF" -> RGBColor[0.2, 0.2, 1.], "#3333CC" -> 
         RGBColor[0.2, 0.2, 0.8], "#333399" -> RGBColor[0.2, 0.2, 0.6], 
         "#333366" -> RGBColor[0.2, 0.2, 0.4], "#333333" -> 
         RGBColor[0.2, 0.2, 0.2], "#333300" -> RGBColor[0.2, 0.2, 0.], 
         "#3300FF" -> RGBColor[0.2, 0., 1.], "#3300CC" -> 
         RGBColor[0.2, 0., 0.8], "#330099" -> RGBColor[0.2, 0., 0.6], 
         "#330066" -> RGBColor[0.2, 0., 0.4], "#330033" -> 
         RGBColor[0.2, 0., 0.2], "#330000" -> RGBColor[0.2, 0., 0.], 
         "#00FFFF" -> RGBColor[0., 1., 1.], "#00FFCC" -> 
         RGBColor[0., 1., 0.8], "#00FF99" -> RGBColor[0., 1., 0.6], "#00FF66" -> 
         RGBColor[0., 1., 0.4], "#00FF33" -> RGBColor[0., 1., 0.2], "#00FF00" -> 
         RGBColor[0., 1., 0.], "#00CCFF" -> RGBColor[0., 0.8, 1.], "#00CCCC" -> 
         RGBColor[0., 0.8, 0.8], "#00CC99" -> RGBColor[0., 0.8, 0.6], 
         "#00CC66" -> RGBColor[0., 0.8, 0.4], "#00CC33" -> 
         RGBColor[0., 0.8, 0.2], "#00CC00" -> RGBColor[0., 0.8, 0.], 
         "#0099FF" -> RGBColor[0., 0.6, 1.], "#0099CC" -> 
         RGBColor[0., 0.6, 0.8], "#009999" -> RGBColor[0., 0.6, 0.6], 
         "#009966" -> RGBColor[0., 0.6, 0.4], "#009933" -> 
         RGBColor[0., 0.6, 0.2], "#009900" -> RGBColor[0., 0.6, 0.], 
         "#0066FF" -> RGBColor[0., 0.4, 1.], "#0066CC" -> 
         RGBColor[0., 0.4, 0.8], "#006699" -> RGBColor[0., 0.4, 0.6], 
         "#006666" -> RGBColor[0., 0.4, 0.4], "#006633" -> 
         RGBColor[0., 0.4, 0.2], "#006600" -> RGBColor[0., 0.4, 0.], 
         "#0033FF" -> RGBColor[0., 0.2, 1.], "#0033CC" -> 
         RGBColor[0., 0.2, 0.8], "#003399" -> RGBColor[0., 0.2, 0.6], 
         "#003366" -> RGBColor[0., 0.2, 0.4], "#003333" -> 
         RGBColor[0., 0.2, 0.2], "#003300" -> RGBColor[0., 0.2, 0.], 
         "#0000FF" -> RGBColor[0., 0., 1.], "#0000CC" -> 
         RGBColor[0., 0., 0.8], "#000099" -> RGBColor[0., 0., 0.6], "#000066" -> 
         RGBColor[0., 0., 0.4], "#000033" -> RGBColor[0., 0., 0.2], "#000000" -> 
         RGBColor[0., 0., 0.]}}, {{
        "Black" -> RGBColor[0, 0, 0], "Blue" -> RGBColor[0, 0, 1], "Brown" -> 
         RGBColor[0.6, 0.4, 0.2], "Cyan" -> RGBColor[0, 1, 1], "Gray" -> 
         RGBColor[0.5, 0.5, 0.5], "Green" -> RGBColor[0, 1, 0], "LightBlue" -> 
         RGBColor[0.87, 0.94, 1], "LightBrown" -> RGBColor[0.94, 0.91, 0.88], 
         "LightCyan" -> RGBColor[0.9, 1, 1], "LightGray" -> 
         RGBColor[0.85, 0.85, 0.85], "LightGreen" -> RGBColor[0.88, 1, 0.88], 
         "LightMagenta" -> RGBColor[1, 0.9, 1], "LightOrange" -> 
         RGBColor[1, 0.9, 0.8], "LightPink" -> RGBColor[1, 0.925, 0.925], 
         "LightPurple" -> RGBColor[0.94, 0.88, 0.94], "LightRed" -> 
         RGBColor[1, 0.85, 0.85], "LightYellow" -> RGBColor[1, 1, 0.85], 
         "Magenta" -> RGBColor[1, 0, 1], "Orange" -> RGBColor[1, 0.5, 0], 
         "Pink" -> RGBColor[1, 0.5, 0.5], "Purple" -> RGBColor[0.5, 0, 0.5], 
         "Red" -> RGBColor[1, 0, 0], "White" -> RGBColor[1, 1, 1], "Yellow" -> 
         RGBColor[1, 1, 0]}, {
        "H" -> RGBColor[0.65, 0.7, 0.7], "He" -> RGBColor[0.836713, 1., 1.], 
         "Li" -> RGBColor[0.799435, 0.543572, 0.997559], "Be" -> 
         RGBColor[0.770565, 0.964309, 0.0442359], "B" -> 
         RGBColor[1., 0.709804, 0.709804], "C" -> RGBColor[0.4, 0.4, 0.4], 
         "N" -> RGBColor[0.291989, 0.437977, 0.888609], "O" -> 
         RGBColor[0.800498, 0.201504, 0.192061], "F" -> 
         RGBColor[0.578462, 0.85539, 0.408855], "Ne" -> 
         RGBColor[0.677263, 0.928423, 0.955287], "Na" -> 
         RGBColor[0.658708, 0.492173, 0.842842], "Mg" -> 
         RGBColor[0.628274, 0.850553, 0.0782731], "Al" -> 
         RGBColor[0.8913, 0.631904, 0.627399], "Si" -> 
         RGBColor[0.941176, 0.784314, 0.627451], "P" -> 
         RGBColor[1., 0.501961, 0], "S" -> 
         RGBColor[0.90443, 0.97015, 0.13504], "Cl" -> 
         RGBColor[0.412698, 0.932689, 0.166398], "Ar" -> 
         RGBColor[0.546138, 0.844244, 0.892092], "K" -> 
         RGBColor[0.534026, 0.420729, 0.705621], "Ca" -> 
         RGBColor[0.480072, 0.744591, 0.0955222], "Sc" -> 
         RGBColor[0.901961, 0.901961, 0.901961], "Ti" -> 
         RGBColor[0.74902, 0.760784, 0.780392], "V" -> 
         RGBColor[0.65098, 0.65098, 0.670588], "Cr" -> 
         RGBColor[0.541176, 0.6, 0.780392], "Mn" -> 
         RGBColor[0.611765, 0.478431, 0.780392], "Fe" -> 
         RGBColor[0.878431, 0.4, 0.2], "Co" -> 
         RGBColor[0.941176, 0.564706, 0.627451], "Ni" -> 
         RGBColor[0.313725, 0.815686, 0.313725], "Cu" -> 
         RGBColor[0.784314, 0.501961, 0.2], "Zn" -> 
         RGBColor[0.490196, 0.501961, 0.690196], "Ga" -> 
         RGBColor[0.800757, 0.542666, 0.533513], "Ge" -> 
         RGBColor[0.60508, 0.632465, 0.576489], "As" -> 
         RGBColor[0.741176, 0.501961, 0.890196], "Se" -> 
         RGBColor[0.917248, 0.657833, 0.0706628], "Br" -> 
         RGBColor[0.58847, 0.22163, 0.16064], "Kr" -> 
         RGBColor[0.426019, 0.747462, 0.810413], "Rb" -> 
         RGBColor[0.425391, 0.329242, 0.585895], "Sr" -> 
         RGBColor[0.325959, 0.646423, 0.095983], "Y" -> 
         RGBColor[0.531014, 1., 1.], "Zr" -> 
         RGBColor[0.458599, 0.917466, 0.918573], "Nb" -> 
         RGBColor[0.385036, 0.834854, 0.841681], "Mo" -> 
         RGBColor[0.310325, 0.752163, 0.769323], "Tc" -> 
         RGBColor[0.234466, 0.669394, 0.701499], "Ru" -> 
         RGBColor[0.157459, 0.586546, 0.638209], "Rh" -> 
         RGBColor[0.0793033, 0.50362, 0.579453], "Pd" -> 
         RGBColor[0., 0.420615, 0.525231], "Ag" -> 
         RGBColor[0.752941, 0.752941, 0.752941], "Cd" -> 
         RGBColor[1., 0.85098, 0.560784], "In" -> 
         RGBColor[0.728371, 0.440594, 0.422196], "Sn" -> 
         RGBColor[0.39799, 0.491477, 0.495586], "Sb" -> 
         RGBColor[0.619608, 0.388235, 0.709804], "Te" -> 
         RGBColor[0.816706, 0.451332, 0.0100947], "I" -> 
         RGBColor[0.580392, 0, 0.580392], "Xe" -> 
         RGBColor[0.316906, 0.638078, 0.710252], "Cs" -> 
         RGBColor[0.332803, 0.217712, 0.483666], "Ba" -> 
         RGBColor[0.165935, 0.55605, 0.0796556], "La" -> 
         RGBColor[0.928084, 0.716075, 0.329427], "Ce" -> 
         RGBColor[0.894824, 0.731424, 0.325131], "Pr" -> 
         RGBColor[0.86523, 0.707999, 0.315261], "Nd" -> 
         RGBColor[0.837836, 0.662974, 0.301635], "Pm" -> 
         RGBColor[0.811992, 0.607859, 0.285626], "Sm" -> 
         RGBColor[0.787563, 0.549894, 0.268279], "Eu" -> 
         RGBColor[0.764628, 0.493261, 0.250405], "Gd" -> 
         RGBColor[0.743177, 0.440115, 0.23269], "Tb" -> 
         RGBColor[0.72281, 0.39143, 0.215783], "Dy" -> 
         RGBColor[0.702434, 0.347663, 0.200392], "Ho" -> 
         RGBColor[0.679962, 0.309234, 0.187368], "Er" -> 
         RGBColor[0.652012, 0.276823, 0.17779], "Tm" -> 
         RGBColor[0.613603, 0.251489, 0.173042], "Yb" -> 
         RGBColor[0.557855, 0.234598, 0.17489], "Lu" -> 
         RGBColor[0.475685, 0.227573, 0.18555], "Hf" -> 
         RGBColor[0.781537, 0.717388, 0.716579], "Ta" -> 
         RGBColor[0.734443, 0.544489, 0.683471], "W" -> 
         RGBColor[0.681179, 0.360409, 0.63675], "Re" -> 
         RGBColor[0.605181, 0.367584, 0.556343], "Os" -> 
         RGBColor[0.521806, 0.382125, 0.469204], "Ir" -> 
         RGBColor[0.445624, 0.373159, 0.399069], "Pt" -> 
         RGBColor[0.815686, 0.815686, 0.878431], "Au" -> 
         RGBColor[1., 0.819608, 0.137255], "Hg" -> 
         RGBColor[0.721569, 0.721569, 0.815686], "Tl" -> 
         RGBColor[0.65098, 0.329412, 0.301961], "Pb" -> 
         RGBColor[0.341176, 0.34902, 0.380392], "Bi" -> 
         RGBColor[0.619608, 0.309804, 0.709804], "Po" -> 
         RGBColor[0.670588, 0.360784, 0], "At" -> 
         RGBColor[0.458824, 0.309804, 0.270588], "Rn" -> 
         RGBColor[0.218799, 0.516091, 0.591608], "Fr" -> 
         RGBColor[0.25626, 0.0861372, 0.398932], "Ra" -> 
         RGBColor[0., 0.473472, 0.04654], "Ac" -> 
         RGBColor[0.322042, 0.71693, 0.988479], "Th" -> 
         RGBColor[0.3608, 0.67166, 0.943003], "Pa" -> 
         RGBColor[0.397469, 0.628, 0.898853], "U" -> 
         RGBColor[0.43205, 0.58595, 0.856029], "Np" -> 
         RGBColor[0.464542, 0.54551, 0.814532], "Pu" -> 
         RGBColor[0.494945, 0.506679, 0.774361], "Am" -> 
         RGBColor[0.52326, 0.469458, 0.735517], "Cm" -> 
         RGBColor[0.549486, 0.433847, 0.697999], "Bk" -> 
         RGBColor[0.573624, 0.399845, 0.661808], "Cf" -> 
         RGBColor[0.595673, 0.367454, 0.626942], "Es" -> 
         RGBColor[0.615633, 0.336672, 0.593404], "Fm" -> 
         RGBColor[0.633505, 0.307499, 0.561191], "Md" -> 
         RGBColor[0.649288, 0.279937, 0.530305], "No" -> 
         RGBColor[0.662982, 0.253984, 0.500746], "Lr" -> 
         RGBColor[0.674588, 0.22964, 0.472513], "Rf" -> 
         RGBColor[0.684106, 0.206907, 0.445606], "Db" -> 
         RGBColor[0.691534, 0.185783, 0.420025], "Sg" -> 
         RGBColor[0.696874, 0.166269, 0.395772], "Bh" -> 
         RGBColor[0.700126, 0.148365, 0.372844], "Hs" -> 
         RGBColor[0.701289, 0.13207, 0.351243], "Mt" -> 
         RGBColor[0.700363, 0.117385, 0.330968], "Ds" -> 
         RGBColor[0.697348, 0.10431, 0.31202], "Rg" -> 
         RGBColor[0.692245, 0.0928444, 0.294398], "Uub" -> 
         RGBColor[0.685054, 0.0829886, 0.278102], "Uut" -> 
         RGBColor[0.675773, 0.0747426, 0.263133], "Uuq" -> 
         RGBColor[0.664405, 0.0681063, 0.249491], "Uup" -> 
         RGBColor[0.650947, 0.0630797, 0.237174], "Uuh" -> 
         RGBColor[0.635401, 0.0596628, 0.226184], "Uus" -> 
         RGBColor[0.635401, 0.0596628, 0.226184], "Uuo" -> 
         RGBColor[0.635401, 0.0596628, 0.226184]}, {
        "Phanerozoic" -> RGBColor[0.690196, 0.886275, 0.819608], "Cenozoic" -> 
         RGBColor[1., 1., 0.], "Quaternary" -> RGBColor[1., 1., 0.301961], 
         "Holocene" -> RGBColor[1., 1., 0.701961], "Pleistocene" -> 
         RGBColor[1., 0.921569, 0.384314], "Neogene" -> 
         RGBColor[0.992157, 0.8, 0.541176], "Pliocene" -> 
         RGBColor[0.996078, 0.921569, 0.67451], "Miocene" -> 
         RGBColor[1., 0.870588, 0.], "Paleogene" -> 
         RGBColor[1., 0.701961, 0.], "Oligocene" -> 
         RGBColor[0.917647, 0.776471, 0.447059], "Eocene" -> 
         RGBColor[0.917647, 0.678431, 0.262745], "Paleocene" -> 
         RGBColor[0.921569, 0.576471, 0.00392157], "Mesozoic" -> 
         RGBColor[0.498039, 0.678431, 0.317647], "Cretaceous" -> 
         RGBColor[0.498039, 0.764706, 0.109804], "UpperCretaceous" -> 
         RGBColor[0.870588, 0.945098, 0.592157], "LowerCretaceous" -> 
         RGBColor[0.701961, 0.87451, 0.498039], "Jurassic" -> 
         RGBColor[0.301961, 0.705882, 0.494118], "UpperJurassic" -> 
         RGBColor[0.8, 0.921569, 0.772549], "MiddleJurassic" -> 
         RGBColor[0.498039, 0.792157, 0.576471], "LowerJurassic" -> 
         RGBColor[0.4, 0.752941, 0.572549], "Triassic" -> 
         RGBColor[0.403922, 0.764706, 0.717647], "UpperTriassic" -> 
         RGBColor[0.8, 0.92549, 0.882353], "MiddleTriassic" -> 
         RGBColor[0.6, 0.843137, 0.745098], "LowerTriassic" -> 
         RGBColor[0.403922, 0.701961, 0.623529], "Paleozoic" -> 
         RGBColor[0.501961, 0.709804, 0.835294], "Permian" -> 
         RGBColor[0.403922, 0.776471, 0.866667], "Lopingian" -> 
         RGBColor[0.701961, 0.890196, 0.933333], "Guadalupian" -> 
         RGBColor[0.6, 0.847059, 0.847059], "Cisuralian" -> 
         RGBColor[0.501961, 0.807843, 0.788235], "Carboniferous" -> 
         RGBColor[0.6, 0.741176, 0.854902], "Pennsylvanian" -> 
         RGBColor[0.407843, 0.623529, 0.792157], "Mississippian" -> 
         RGBColor[0.501961, 0.568627, 0.678431], "Devonian" -> 
         RGBColor[0.6, 0.6, 0.788235], "UpperDevonian" -> 
         RGBColor[0.796078, 0.741176, 0.862745], "MiddleDevonian" -> 
         RGBColor[0.6, 0.513725, 0.745098], "LowerDevonian" -> 
         RGBColor[0.501961, 0.490196, 0.729412], "Silurian" -> 
         RGBColor[0.694118, 0.447059, 0.713725], "Pridoli" -> 
         RGBColor[0.913725, 0.780392, 0.886275], "Ludlow" -> 
         RGBColor[0.792157, 0.654902, 0.819608], "Wenlock" -> 
         RGBColor[0.694118, 0.537255, 0.701961], "Llandovery" -> 
         RGBColor[0.596078, 0.345098, 0.658824], "Ordovician" -> 
         RGBColor[0.976471, 0.505882, 0.65098], "UpperOrdovician" -> 
         RGBColor[0.984314, 0.705882, 0.741176], "MiddleOrdovician" -> 
         RGBColor[0.980392, 0.603922, 0.694118], "LowerOrdovician" -> 
         RGBColor[0.901961, 0.490196, 0.643137], "Cambrian" -> 
         RGBColor[0.984314, 0.501961, 0.372549], "UpperCambrian" -> 
         RGBColor[0.992157, 0.803922, 0.721569], "MiddleCambrian" -> 
         RGBColor[0.909804, 0.682353, 0.592157], "LowerCambrian" -> 
         RGBColor[0.905882, 0.486275, 0.447059], "Precambrian" -> 
         RGBColor[0.698039, 0.52549, 0.32549], "Proterozoic" -> 
         RGBColor[0.8, 0.847059, 0.568627], "Neoproterozoic" -> 
         RGBColor[0.792157, 0.647059, 0.584314], "Ediacaran" -> 
         RGBColor[0.917647, 0.847059, 0.737255], "Cryogenian" -> 
         RGBColor[0.862745, 0.670588, 0.666667], "Tonian" -> 
         RGBColor[0.796078, 0.643137, 0.423529], "Mesoproterozoic" -> 
         RGBColor[0.866667, 0.760784, 0.533333], "Stenian" -> 
         RGBColor[0.866667, 0.760784, 0.533333], "Ectasian" -> 
         RGBColor[0.866667, 0.760784, 0.533333], "Calymmian" -> 
         RGBColor[0.866667, 0.760784, 0.533333], "Paleoproterozoic" -> 
         RGBColor[0.701961, 0.698039, 0.368627], "Statherian" -> 
         RGBColor[0.701961, 0.698039, 0.368627], "Orosirian" -> 
         RGBColor[0.701961, 0.698039, 0.368627], "Rhyacian" -> 
         RGBColor[0.701961, 0.698039, 0.368627], "Siderian" -> 
         RGBColor[0.701961, 0.698039, 0.368627], "Archean" -> 
         RGBColor[0.6, 0.678431, 0.67451], "Neoarchean" -> 
         RGBColor[0.796078, 0.803922, 0.784314], "Mesoarchean" -> 
         RGBColor[0.698039, 0.709804, 0.686275], "Paleoarchean" -> 
         RGBColor[0.6, 0.592157, 0.568627], "Eoarchean" -> 
         RGBColor[0.501961, 0.564706, 0.564706], "Hadean" -> 
         RGBColor[0.5, 0.5, 0.56]}, {
        "AliceBlue" -> RGBColor[0.9411764705882353, 0.9725490196078431, 1.], 
         "AntiqueWhite" -> 
         RGBColor[0.9803921568627451, 0.9215686274509803, 0.8431372549019608],
          "Aqua" -> RGBColor[0., 1., 1.], "Aquamarine" -> 
         RGBColor[0.4980392156862745, 1., 0.8313725490196079], "Azure" -> 
         RGBColor[0.9411764705882353, 1., 1.], "Beige" -> 
         RGBColor[0.9607843137254902, 0.9607843137254902, 0.8627450980392157],
          "Bisque" -> RGBColor[1., 0.8941176470588236, 0.7686274509803922], 
         "Black" -> RGBColor[0., 0., 0.], "BlanchedAlmond" -> 
         RGBColor[1., 0.9215686274509803, 0.803921568627451], "Blue" -> 
         RGBColor[0., 0., 1.], "BlueViolet" -> 
         RGBColor[
          0.5411764705882353, 0.16862745098039217`, 0.8862745098039215], 
         "Brown" -> RGBColor[
          0.6470588235294118, 0.16470588235294117`, 0.16470588235294117`], 
         "BurlyWood" -> 
         RGBColor[0.8705882352941177, 0.7215686274509804, 0.5294117647058824],
          "CadetBlue" -> 
         RGBColor[
          0.37254901960784315`, 0.6196078431372549, 0.6274509803921569], 
         "Chartreuse" -> RGBColor[0.4980392156862745, 1., 0.], "Chocolate" -> 
         RGBColor[
          0.8235294117647058, 0.4117647058823529, 0.11764705882352941`], 
         "Coral" -> RGBColor[1., 0.4980392156862745, 0.3137254901960784], 
         "CornflowerBlue" -> 
         RGBColor[
          0.39215686274509803`, 0.5843137254901961, 0.9294117647058824], 
         "Cornsilk" -> RGBColor[1., 0.9725490196078431, 0.8627450980392157], 
         "Crimson" -> 
         RGBColor[
          0.8627450980392157, 0.0784313725490196, 0.23529411764705882`], 
         "Cyan" -> RGBColor[0., 1., 1.], "DarkBlue" -> 
         RGBColor[0., 0., 0.5450980392156862], "DarkCyan" -> 
         RGBColor[0., 0.5450980392156862, 0.5450980392156862], 
         "DarkGoldenRod" -> 
         RGBColor[
          0.7215686274509804, 0.5254901960784314, 0.043137254901960784`], 
         "DarkGray" -> 
         RGBColor[0.6627450980392157, 0.6627450980392157, 0.6627450980392157],
          "DarkGreen" -> RGBColor[0., 0.39215686274509803`, 0.], "DarkGrey" -> 
         RGBColor[0.6627450980392157, 0.6627450980392157, 0.6627450980392157],
          "DarkKhaki" -> 
         RGBColor[0.7411764705882353, 0.7176470588235294, 0.4196078431372549],
          "DarkMagenta" -> 
         RGBColor[0.5450980392156862, 0., 0.5450980392156862], 
         "DarkOliveGreen" -> 
         RGBColor[0.3333333333333333, 0.4196078431372549, 0.1843137254901961],
          "DarkOrange" -> RGBColor[1., 0.5490196078431373, 0.], "DarkOrchid" -> 
         RGBColor[0.6, 0.19607843137254902`, 0.8], "DarkRed" -> 
         RGBColor[0.5450980392156862, 0., 0.], "DarkSalmon" -> 
         RGBColor[
          0.9137254901960784, 0.5882352941176471, 0.47843137254901963`], 
         "DarkSeaGreen" -> 
         RGBColor[0.5607843137254902, 0.7372549019607844, 0.5607843137254902],
          "DarkSlateBlue" -> 
         RGBColor[
          0.2823529411764706, 0.23921568627450981`, 0.5450980392156862], 
         "DarkSlateGray" -> 
         RGBColor[
          0.1843137254901961, 0.30980392156862746`, 0.30980392156862746`], 
         "DarkSlateGrey" -> 
         RGBColor[
          0.1843137254901961, 0.30980392156862746`, 0.30980392156862746`], 
         "DarkTurquoise" -> 
         RGBColor[0., 0.807843137254902, 0.8196078431372549], "DarkViolet" -> 
         RGBColor[0.5803921568627451, 0., 0.8274509803921568], "DeepPink" -> 
         RGBColor[1., 0.0784313725490196, 0.5764705882352941], "DeepSkyBlue" -> 
         RGBColor[0., 0.7490196078431373, 1.], "DimGray" -> 
         RGBColor[0.4117647058823529, 0.4117647058823529, 0.4117647058823529],
          "DimGrey" -> 
         RGBColor[0.4117647058823529, 0.4117647058823529, 0.4117647058823529],
          "DodgerBlue" -> 
         RGBColor[0.11764705882352941`, 0.5647058823529412, 1.], "FireBrick" -> 
         RGBColor[
          0.6980392156862745, 0.13333333333333333`, 0.13333333333333333`], 
         "FloralWhite" -> 
         RGBColor[1., 0.9803921568627451, 0.9411764705882353], "ForestGreen" -> 
         RGBColor[
          0.13333333333333333`, 0.5450980392156862, 0.13333333333333333`], 
         "Fuchsia" -> RGBColor[1., 0., 1.], "Gainsboro" -> 
         RGBColor[0.8627450980392157, 0.8627450980392157, 0.8627450980392157],
          "GhostWhite" -> 
         RGBColor[0.9725490196078431, 0.9725490196078431, 1.], "Gold" -> 
         RGBColor[1., 0.8431372549019608, 0.], "GoldenRod" -> 
         RGBColor[
          0.8549019607843137, 0.6470588235294118, 0.12549019607843137`], 
         "Gray" -> RGBColor[
          0.5019607843137255, 0.5019607843137255, 0.5019607843137255], 
         "Green" -> RGBColor[0., 0.5019607843137255, 0.], "GreenYellow" -> 
         RGBColor[0.6784313725490196, 1., 0.1843137254901961], "Grey" -> 
         RGBColor[0.5019607843137255, 0.5019607843137255, 0.5019607843137255],
          "HoneyDew" -> RGBColor[0.9411764705882353, 1., 0.9411764705882353], 
         "HotPink" -> RGBColor[1., 0.4117647058823529, 0.7058823529411765], 
         "IndianRed" -> 
         RGBColor[0.803921568627451, 0.3607843137254902, 0.3607843137254902], 
         "Indigo" -> RGBColor[0.29411764705882354`, 0., 0.5098039215686274], 
         "Ivory" -> RGBColor[1., 1., 0.9411764705882353], "Khaki" -> 
         RGBColor[0.9411764705882353, 0.9019607843137255, 0.5490196078431373],
          "Lavender" -> 
         RGBColor[0.9019607843137255, 0.9019607843137255, 0.9803921568627451],
          "LavenderBlush" -> 
         RGBColor[1., 0.9411764705882353, 0.9607843137254902], "LawnGreen" -> 
         RGBColor[0.48627450980392156`, 0.9882352941176471, 0.], 
         "LemonChiffon" -> 
         RGBColor[1., 0.9803921568627451, 0.803921568627451], "LightBlue" -> 
         RGBColor[0.6784313725490196, 0.8470588235294118, 0.9019607843137255],
          "LightCoral" -> 
         RGBColor[0.9411764705882353, 0.5019607843137255, 0.5019607843137255],
          "LightCyan" -> RGBColor[0.8784313725490196, 1., 1.], 
         "LightGoldenRodYellow" -> 
         RGBColor[0.9803921568627451, 0.9803921568627451, 0.8235294117647058],
          "LightGray" -> 
         RGBColor[0.8274509803921568, 0.8274509803921568, 0.8274509803921568],
          "LightGreen" -> 
         RGBColor[0.5647058823529412, 0.9333333333333333, 0.5647058823529412],
          "LightGrey" -> 
         RGBColor[0.8274509803921568, 0.8274509803921568, 0.8274509803921568],
          "LightPink" -> RGBColor[1., 0.7137254901960784, 0.7568627450980392],
          "LightSalmon" -> 
         RGBColor[1., 0.6274509803921569, 0.47843137254901963`], 
         "LightSeaGreen" -> 
         RGBColor[
          0.12549019607843137`, 0.6980392156862745, 0.6666666666666666], 
         "LightSkyBlue" -> 
         RGBColor[0.5294117647058824, 0.807843137254902, 0.9803921568627451], 
         "LightSlateGray" -> 
         RGBColor[0.4666666666666667, 0.5333333333333333, 0.6], 
         "LightSlateGrey" -> 
         RGBColor[0.4666666666666667, 0.5333333333333333, 0.6], 
         "LightSteelBlue" -> 
         RGBColor[0.6901960784313725, 0.7686274509803922, 0.8705882352941177],
          "LightYellow" -> RGBColor[1., 1., 0.8784313725490196], "Lime" -> 
         RGBColor[0., 1., 0.], "LimeGreen" -> 
         RGBColor[
          0.19607843137254902`, 0.803921568627451, 0.19607843137254902`], 
         "Linen" -> RGBColor[
          0.9803921568627451, 0.9411764705882353, 0.9019607843137255], 
         "Magenta" -> RGBColor[1., 0., 1.], "Maroon" -> 
         RGBColor[0.5019607843137255, 0., 0.], "MediumAquaMarine" -> 
         RGBColor[0.4, 0.803921568627451, 0.6666666666666666], "MediumBlue" -> 
         RGBColor[0., 0., 0.803921568627451], "MediumOrchid" -> 
         RGBColor[0.7294117647058823, 0.3333333333333333, 0.8274509803921568],
          "MediumPurple" -> 
         RGBColor[0.5764705882352941, 0.4392156862745098, 0.8470588235294118],
          "MediumSeaGreen" -> 
         RGBColor[
          0.23529411764705882`, 0.7019607843137254, 0.44313725490196076`], 
         "MediumSlateBlue" -> 
         RGBColor[
          0.4823529411764706, 0.40784313725490196`, 0.9333333333333333], 
         "MediumSpringGreen" -> 
         RGBColor[0., 0.9803921568627451, 0.6039215686274509], 
         "MediumTurquoise" -> 
         RGBColor[0.2823529411764706, 0.8196078431372549, 0.8], 
         "MediumVioletRed" -> 
         RGBColor[
          0.7803921568627451, 0.08235294117647059, 0.5215686274509804], 
         "MidnightBlue" -> 
         RGBColor[
          0.09803921568627451, 0.09803921568627451, 0.4392156862745098], 
         "MintCream" -> RGBColor[0.9607843137254902, 1., 0.9803921568627451], 
         "MistyRose" -> RGBColor[1., 0.8941176470588236, 0.8823529411764706], 
         "Moccasin" -> RGBColor[1., 0.8941176470588236, 0.7098039215686275], 
         "NavajoWhite" -> 
         RGBColor[1., 0.8705882352941177, 0.6784313725490196], "Navy" -> 
         RGBColor[0., 0., 0.5019607843137255], "OldLace" -> 
         RGBColor[0.9921568627450981, 0.9607843137254902, 0.9019607843137255],
          "Olive" -> RGBColor[0.5019607843137255, 0.5019607843137255, 0.], 
         "OliveDrab" -> 
         RGBColor[
          0.4196078431372549, 0.5568627450980392, 0.13725490196078433`], 
         "Orange" -> RGBColor[1., 0.6470588235294118, 0.], "OrangeRed" -> 
         RGBColor[1., 0.27058823529411763`, 0.], "Orchid" -> 
         RGBColor[0.8549019607843137, 0.4392156862745098, 0.8392156862745098],
          "PaleGoldenRod" -> 
         RGBColor[0.9333333333333333, 0.9098039215686274, 0.6666666666666666],
          "PaleGreen" -> 
         RGBColor[0.596078431372549, 0.984313725490196, 0.596078431372549], 
         "PaleTurquoise" -> 
         RGBColor[0.6862745098039216, 0.9333333333333333, 0.9333333333333333],
          "PaleVioletRed" -> 
         RGBColor[0.8470588235294118, 0.4392156862745098, 0.5764705882352941],
          "PapayaWhip" -> 
         RGBColor[1., 0.9372549019607843, 0.8352941176470589], "PeachPuff" -> 
         RGBColor[1., 0.8549019607843137, 0.7254901960784313], "Peru" -> 
         RGBColor[
          0.803921568627451, 0.5215686274509804, 0.24705882352941178`], 
         "Pink" -> RGBColor[1., 0.7529411764705882, 0.796078431372549], 
         "Plum" -> RGBColor[
          0.8666666666666667, 0.6274509803921569, 0.8666666666666667], 
         "PowderBlue" -> 
         RGBColor[0.6901960784313725, 0.8784313725490196, 0.9019607843137255],
          "Purple" -> RGBColor[0.5019607843137255, 0., 0.5019607843137255], 
         "Red" -> RGBColor[1., 0., 0.], "RosyBrown" -> 
         RGBColor[0.7372549019607844, 0.5607843137254902, 0.5607843137254902],
          "RoyalBlue" -> 
         RGBColor[0.2549019607843137, 0.4117647058823529, 0.8823529411764706],
          "SaddleBrown" -> 
         RGBColor[
          0.5450980392156862, 0.27058823529411763`, 0.07450980392156863], 
         "Salmon" -> 
         RGBColor[0.9803921568627451, 0.5019607843137255, 0.4470588235294118],
          "SandyBrown" -> 
         RGBColor[0.9568627450980393, 0.6431372549019608, 0.3764705882352941],
          "SeaGreen" -> 
         RGBColor[0.1803921568627451, 0.5450980392156862, 0.3411764705882353],
          "SeaShell" -> RGBColor[1., 0.9607843137254902, 0.9333333333333333], 
         "Sienna" -> 
         RGBColor[
          0.6274509803921569, 0.3215686274509804, 0.17647058823529413`], 
         "Silver" -> 
         RGBColor[0.7529411764705882, 0.7529411764705882, 0.7529411764705882],
          "SkyBlue" -> 
         RGBColor[0.5294117647058824, 0.807843137254902, 0.9215686274509803], 
         "SlateBlue" -> 
         RGBColor[
          0.41568627450980394`, 0.35294117647058826`, 0.803921568627451], 
         "SlateGray" -> 
         RGBColor[0.4392156862745098, 0.5019607843137255, 0.5647058823529412],
          "SlateGrey" -> 
         RGBColor[0.4392156862745098, 0.5019607843137255, 0.5647058823529412],
          "Snow" -> RGBColor[1., 0.9803921568627451, 0.9803921568627451], 
         "SpringGreen" -> RGBColor[0., 1., 0.4980392156862745], "SteelBlue" -> 
         RGBColor[
          0.27450980392156865`, 0.5098039215686274, 0.7058823529411765], 
         "Tan" -> RGBColor[
          0.8235294117647058, 0.7058823529411765, 0.5490196078431373], "Teal" -> 
         RGBColor[0., 0.5019607843137255, 0.5019607843137255], "Thistle" -> 
         RGBColor[0.8470588235294118, 0.7490196078431373, 0.8470588235294118],
          "Tomato" -> RGBColor[1., 0.38823529411764707`, 0.2784313725490196], 
         "Turquoise" -> 
         RGBColor[
          0.25098039215686274`, 0.8784313725490196, 0.8156862745098039], 
         "Violet" -> 
         RGBColor[0.9333333333333333, 0.5098039215686274, 0.9333333333333333],
          "Wheat" -> 
         RGBColor[0.9607843137254902, 0.8705882352941177, 0.7019607843137254],
          "White" -> RGBColor[1., 1., 1.], "WhiteSmoke" -> 
         RGBColor[0.9607843137254902, 0.9607843137254902, 0.9607843137254902],
          "Yellow" -> RGBColor[1., 1., 0.], "YellowGreen" -> 
         RGBColor[
          0.6039215686274509, 0.803921568627451, 0.19607843137254902`]}, {
        "AliceBlue" -> RGBColor[0.941206, 0.972503, 1.], "AlizarinCrimson" -> 
         RGBColor[0.889996, 0.149998, 0.209998], "Antique" -> 
         RGBColor[0.980575, 0.92233, 0.844661], "Apricot" -> 
         RGBColor[1., 0.340007, 0.129994], "Aquamarine" -> 
         RGBColor[0.498001, 1., 0.831401], "AureolineYellow" -> 
         RGBColor[1., 0.659993, 0.140004], "Azure" -> 
         RGBColor[0.94174, 1., 1.], "Banana" -> 
         RGBColor[0.889996, 0.810007, 0.340007], "Beige" -> 
         RGBColor[0.640004, 0.580004, 0.5], "Bisque" -> 
         RGBColor[1., 0.898053, 0.771844], "Black" -> RGBColor[0, 0, 0], 
         "BlanchedAlmond" -> RGBColor[1., 0.921598, 0.803903], "Blue" -> 
         RGBColor[0, 0, 1], "BlueViolet" -> 
         RGBColor[0.5412, 0.1686, 0.886303], "Brick" -> 
         RGBColor[0.610004, 0.400006, 0.119999], "Brown" -> 
         RGBColor[0.6, 0.4, 0.2], "BrownMadder" -> 
         RGBColor[0.859996, 0.159993, 0.159993], "BrownOchre" -> 
         RGBColor[0.53, 0.260002, 0.119999], "Burlywood" -> 
         RGBColor[0.870602, 0.721595, 0.529405], "BurntSienna" -> 
         RGBColor[0.539994, 0.209998, 0.059999], "BurntUmber" -> 
         RGBColor[0.539994, 0.200003, 0.140004], "CadetBlue" -> 
         RGBColor[0.372494, 0.619602, 0.627506], "CadmiumLemon" -> 
         RGBColor[1., 0.889996, 0.009995], "CadmiumOrange" -> 
         RGBColor[1., 0.380001, 0.009995], "CadmiumYellow" -> 
         RGBColor[1., 0.599994, 0.069994], "Carrot" -> 
         RGBColor[0.930006, 0.569994, 0.129994], "Cerulean" -> 
         RGBColor[0.020005, 0.719993, 0.799997], "Chartreuse" -> 
         RGBColor[0.498001, 1., 0.], "Chocolate" -> 
         RGBColor[0.823496, 0.411802, 0.117603], "ChromeOxideGreen" -> 
         RGBColor[0.400006, 0.5, 0.080004], "CinnabarGreen" -> 
         RGBColor[0.380001, 0.700003, 0.159993], "Cobalt" -> 
         RGBColor[0.239998, 0.350002, 0.670003], "CobaltGreen" -> 
         RGBColor[0.239998, 0.569994, 0.250008], "ColdGray" -> 
         RGBColor[0.5, 0.539994, 0.53], "Coral" -> 
         RGBColor[1., 0.498001, 0.3137], "CornflowerBlue" -> 
         RGBColor[0.392193, 0.584307, 0.929395], "Cornsilk" -> 
         RGBColor[1., 0.972503, 0.862697], "Cyan" -> RGBColor[0, 1, 1], 
         "CyanWhite" -> RGBColor[0.878399, 1., 1.], "DarkGoldenrod" -> 
         RGBColor[0.721595, 0.525498, 0.043107], "DarkGreen" -> 
         RGBColor[0., 0.392193, 0.], "DarkKhaki" -> 
         RGBColor[0.741203, 0.717597, 0.419599], "DarkOliveGreen" -> 
         RGBColor[0.333293, 0.419599, 0.184301], "DarkOrange" -> 
         RGBColor[1., 0.548997, 0.], "DarkOrchid" -> 
         RGBColor[0.599994, 0.196097, 0.799997], "DarkSeaGreen" -> 
         RGBColor[0.560793, 0.737297, 0.560793], "DarkSlateBlue" -> 
         RGBColor[0.282403, 0.239204, 0.545106], "DarkSlateGray" -> 
         RGBColor[0.184301, 0.309793, 0.309793], "DarkTurquoise" -> 
         RGBColor[0., 0.807794, 0.819605], "DarkViolet" -> 
         RGBColor[0.580401, 0., 0.827494], "DeepCadmiumRed" -> 
         RGBColor[0.889996, 0.089999, 0.050005], "DeepCobaltViolet" -> 
         RGBColor[0.569994, 0.129994, 0.619999], "DeepMadderLake" -> 
         RGBColor[0.889996, 0.179998, 0.189993], "DeepNaplesYellow" -> 
         RGBColor[1., 0.659993, 0.069994], "DeepOchre" -> 
         RGBColor[0.449995, 0.239998, 0.099994], "DeepPink" -> 
         RGBColor[1., 0.078402, 0.576495], "DeepSkyBlue" -> 
         RGBColor[0., 0.749, 1.], "DimGray" -> 
         RGBColor[0.333333, 0.333333, 0.333333], "DodgerBlue" -> 
         RGBColor[0.117603, 0.564699, 1.], "Eggshell" -> 
         RGBColor[0.990005, 0.900006, 0.790002], "EmeraldGreen" -> 
         RGBColor[0., 0.790002, 0.340007], "EnglishRed" -> 
         RGBColor[0.829997, 0.239998, 0.099994], "Firebrick" -> 
         RGBColor[0.698004, 0.133305, 0.133305], "Floral" -> 
         RGBColor[1., 0.980407, 0.941206], "ForestGreen" -> 
         RGBColor[0.133305, 0.545106, 0.133305], "Gainsboro" -> 
         RGBColor[0.862697, 0.862697, 0.862697], "GeraniumLake" -> 
         RGBColor[0.889996, 0.069994, 0.189993], "Ghost" -> 
         RGBColor[0.972503, 0.972503, 1.], "Gold" -> 
         RGBColor[1., 0.843104, 0.], "Goldenrod" -> 
         RGBColor[0.8549, 0.647099, 0.125507], "GoldOchre" -> 
         RGBColor[0.780007, 0.47, 0.149998], "Gray" -> 
         RGBColor[0.5, 0.5, 0.5], "Green" -> RGBColor[0, 1, 0], 
         "GreenishUmber" -> RGBColor[1., 0.239998, 0.050005], "GreenYellow" -> 
         RGBColor[0.678396, 1., 0.184301], "Honeydew" -> 
         RGBColor[0.941206, 1., 0.941206], "HotPink" -> 
         RGBColor[1., 0.411802, 0.705893], "IndianRed" -> 
         RGBColor[0.689993, 0.089999, 0.119999], "Indigo" -> 
         RGBColor[0.03, 0.179998, 0.329997], "Ivory" -> 
         RGBColor[1., 1., 0.941206], "IvoryBlack" -> 
         RGBColor[0.159993, 0.140004, 0.129994], "Khaki" -> 
         RGBColor[0.941206, 0.902005, 0.548997], "LampBlack" -> 
         RGBColor[0.179998, 0.280007, 0.230003], "Lavender" -> 
         RGBColor[0.902005, 0.902005, 0.980407], "LavenderBlush" -> 
         RGBColor[1., 0.941206, 0.960799], "LawnGreen" -> 
         RGBColor[0.486297, 0.988205, 0.], "LemonChiffon" -> 
         RGBColor[1., 0.980407, 0.803903], "LightBeige" -> 
         RGBColor[0.960799, 0.960799, 0.862697], "LightBlue" -> 
         RGBColor[0.678396, 0.847102, 0.902005], "LightCadmiumRed" -> 
         RGBColor[1., 0.009995, 0.050005], "LightCadmiumYellow" -> 
         RGBColor[1., 0.689993, 0.059999], "LightCoral" -> 
         RGBColor[0.941206, 0.501999, 0.501999], "LightGoldenrod" -> 
         RGBColor[0.933302, 0.866695, 0.509796], "LightGray" -> 
         RGBColor[0.666666, 0.666666, 0.666666], "LightPink" -> 
         RGBColor[1., 0.713706, 0.756905], "LightSalmon" -> 
         RGBColor[1., 0.627506, 0.478393], "LightSeaGreen" -> 
         RGBColor[0.125507, 0.698004, 0.666707], "LightSkyBlue" -> 
         RGBColor[0.529405, 0.807794, 0.980407], "LightSlateBlue" -> 
         RGBColor[0.517594, 0.439207, 1.], "LightSlateGray" -> 
         RGBColor[0.466704, 0.533296, 0.599994], "LightSteelBlue" -> 
         RGBColor[0.690207, 0.768593, 0.870602], "LightViridian" -> 
         RGBColor[0.430006, 1., 0.440001], "LightYellow" -> 
         RGBColor[1., 1., 0.878399], "LimeGreen" -> 
         RGBColor[0.196097, 0.803903, 0.196097], "Linen" -> 
         RGBColor[0.980407, 0.941206, 0.902005], "Magenta" -> 
         RGBColor[1, 0, 1], "ManganeseBlue" -> 
         RGBColor[0.009995, 0.659993, 0.619999], "Maroon" -> 
         RGBColor[0.690207, 0.188192, 0.376507], "MarsOrange" -> 
         RGBColor[0.589999, 0.269997, 0.080004], "MarsYellow" -> 
         RGBColor[0.889996, 0.440001, 0.099994], "MediumAquamarine" -> 
         RGBColor[0.400006, 0.803903, 0.666707], "MediumBlue" -> 
         RGBColor[0., 0., 0.803903], "MediumOrchid" -> 
         RGBColor[0.729408, 0.333293, 0.827494], "MediumPurple" -> 
         RGBColor[0.576495, 0.439207, 0.858806], "MediumSeaGreen" -> 
         RGBColor[0.235298, 0.702002, 0.443098], "MediumSlateBlue" -> 
         RGBColor[0.482406, 0.407804, 0.933302], "MediumSpringGreen" -> 
         RGBColor[0., 0.980407, 0.6039], "MediumTurquoise" -> 
         RGBColor[0.282403, 0.819605, 0.799997], "MediumVioletRed" -> 
         RGBColor[0.780404, 0.0824, 0.521607], "Melon" -> 
         RGBColor[0.889996, 0.659993, 0.410001], "MidnightBlue" -> 
         RGBColor[0.097995, 0.097995, 0.439207], "Mint" -> 
         RGBColor[0.739998, 0.990005, 0.790002], "MintCream" -> 
         RGBColor[0.960799, 1., 0.980407], "MistyRose" -> 
         RGBColor[1., 0.894101, 0.882397], "Moccasin" -> 
         RGBColor[1., 0.894101, 0.709799], "Navajo" -> 
         RGBColor[1., 0.870602, 0.678396], "Navy" -> 
         RGBColor[0., 0., 0.501999], "NavyBlue" -> RGBColor[0., 0., 0.501999],
          "Oak" -> RGBColor[1., 0.490005, 0.250008], "OldLace" -> 
         RGBColor[0.992203, 0.960799, 0.902005], "Olive" -> 
         RGBColor[0.230003, 0.370006, 0.170003], "OliveDrab" -> 
         RGBColor[0.419599, 0.556902, 0.137303], "Orange" -> 
         RGBColor[1, 0.5, 0], "OrangeRed" -> RGBColor[1., 0.270608, 0.], 
         "Orchid" -> RGBColor[0.8549, 0.439207, 0.839198], "PaleGoldenrod" -> 
         RGBColor[0.933302, 0.909803, 0.666707], "PaleGreen" -> 
         RGBColor[0.596103, 0.984298, 0.596103], "PaleTurquoise" -> 
         RGBColor[0.6863, 0.933302, 0.933302], "PaleVioletRed" -> 
         RGBColor[0.858806, 0.439207, 0.576495], "PapayaWhip" -> 
         RGBColor[1., 0.9373, 0.835307], "Peach" -> 
         RGBColor[0.44, 0.26, 0.26], "PeachPuff" -> 
         RGBColor[1., 0.8549, 0.725501], "Peacock" -> 
         RGBColor[0.200003, 0.629994, 0.790002], "PermanentGreen" -> 
         RGBColor[0.039995, 0.790002, 0.170003], "PermanentRedViolet" -> 
         RGBColor[0.859996, 0.149998, 0.269997], "Peru" -> 
         RGBColor[0.803903, 0.521607, 0.247093], "Pink" -> 
         RGBColor[1, 0.5, 0.5], "Plum" -> 
         RGBColor[0.866695, 0.627506, 0.866695], "PowderBlue" -> 
         RGBColor[0.690207, 0.878399, 0.902005], "PrussianBlue" -> 
         RGBColor[0.18, 0.18, 0.31], "Purple" -> RGBColor[0.5, 0, 0.5], 
         "Raspberry" -> RGBColor[0.53, 0.149998, 0.340007], "RawSienna" -> 
         RGBColor[0.780007, 0.380001, 0.080004], "RawUmber" -> 
         RGBColor[0.449995, 0.290002, 0.069994], "Red" -> RGBColor[1, 0, 0], 
         "RoseMadder" -> RGBColor[0.889996, 0.209998, 0.219993], "RosyBrown" -> 
         RGBColor[0.737297, 0.560793, 0.560793], "RoyalBlue" -> 
         RGBColor[0.254906, 0.411802, 0.882397], "SaddleBrown" -> 
         RGBColor[0.545106, 0.270608, 0.074496], "Salmon" -> 
         RGBColor[0.980407, 0.501999, 0.447096], "SandyBrown" -> 
         RGBColor[0.956893, 0.643101, 0.376507], "SapGreen" -> 
         RGBColor[0.189993, 0.5, 0.080004], "SeaGreen" -> 
         RGBColor[0.180395, 0.545106, 0.341197], "Seashell" -> 
         RGBColor[1., 0.960799, 0.933302], "Sepia" -> 
         RGBColor[0.370006, 0.149998, 0.069994], "Sienna" -> 
         RGBColor[0.627506, 0.321604, 0.176504], "SkyBlue" -> 
         RGBColor[0.529405, 0.807794, 0.921598], "SlateBlue" -> 
         RGBColor[0.415693, 0.352901, 0.803903], "SlateGray" -> 
         RGBColor[0.439207, 0.501999, 0.564699], "Smoke" -> 
         RGBColor[0.960799, 0.960799, 0.960799], "Snow" -> 
         RGBColor[1., 0.980407, 0.980407], "SpringGreen" -> 
         RGBColor[0., 1., 0.498001], "SteelBlue" -> 
         RGBColor[0.274499, 0.509796, 0.705893], "TerreVerte" -> 
         RGBColor[0.219993, 0.370006, 0.059999], "Thistle" -> 
         RGBColor[0.847102, 0.749, 0.847102], "Titanium" -> 
         RGBColor[0.990005, 1., 0.940001], "Tomato" -> 
         RGBColor[1., 0.388195, 0.278405], "Turquoise" -> 
         RGBColor[0.250999, 0.878399, 0.815699], "TurquoiseBlue" -> 
         RGBColor[0., 0.780007, 0.550005], "Ultramarine" -> 
         RGBColor[0.069994, 0.039995, 0.559999], "UltramarineViolet" -> 
         RGBColor[0.359996, 0.140004, 0.430006], "VanDykeBrown" -> 
         RGBColor[0.370006, 0.149998, 0.020005], "VenetianRed" -> 
         RGBColor[0.829997, 0.099994, 0.119999], "Violet" -> 
         RGBColor[0.559999, 0.370006, 0.599994], "VioletRed" -> 
         RGBColor[0.815699, 0.125507, 0.564699], "WarmGray" -> 
         RGBColor[0.5, 0.5, 0.410001], "Wheat" -> 
         RGBColor[0.960799, 0.870602, 0.702002], "White" -> RGBColor[1, 1, 1],
          "Yellow" -> RGBColor[1, 1, 0], "YellowBrown" -> 
         RGBColor[0.86, 0.58, 0.44], "YellowGreen" -> 
         RGBColor[0.6039, 0.803903, 0.196097], "YellowOchre" -> 
         RGBColor[0.889996, 0.509995, 0.089999], "Zinc" -> 
         RGBColor[0.990005, 0.97, 1.]}, {
        "#FFFFFF" -> RGBColor[1., 1., 1.], "#FFFFCC" -> RGBColor[1., 1., 0.8],
          "#FFFF99" -> RGBColor[1., 1., 0.6], "#FFFF66" -> 
         RGBColor[1., 1., 0.4], "#FFFF33" -> RGBColor[1., 1., 0.2], "#FFFF00" -> 
         RGBColor[1., 1., 0.], "#FFCCFF" -> RGBColor[1., 0.8, 1.], "#FFCCCC" -> 
         RGBColor[1., 0.8, 0.8], "#FFCC99" -> RGBColor[1., 0.8, 0.6], 
         "#FFCC66" -> RGBColor[1., 0.8, 0.4], "#FFCC33" -> 
         RGBColor[1., 0.8, 0.2], "#FFCC00" -> RGBColor[1., 0.8, 0.], 
         "#FF99FF" -> RGBColor[1., 0.6, 1.], "#FF99CC" -> 
         RGBColor[1., 0.6, 0.8], "#FF9999" -> RGBColor[1., 0.6, 0.6], 
         "#FF9966" -> RGBColor[1., 0.6, 0.4], "#FF9933" -> 
         RGBColor[1., 0.6, 0.2], "#FF9900" -> RGBColor[1., 0.6, 0.], 
         "#FF66FF" -> RGBColor[1., 0.4, 1.], "#FF66CC" -> 
         RGBColor[1., 0.4, 0.8], "#FF6699" -> RGBColor[1., 0.4, 0.6], 
         "#FF6666" -> RGBColor[1., 0.4, 0.4], "#FF6633" -> 
         RGBColor[1., 0.4, 0.2], "#FF6600" -> RGBColor[1., 0.4, 0.], 
         "#FF33FF" -> RGBColor[1., 0.2, 1.], "#FF33CC" -> 
         RGBColor[1., 0.2, 0.8], "#FF3399" -> RGBColor[1., 0.2, 0.6], 
         "#FF3366" -> RGBColor[1., 0.2, 0.4], "#FF3333" -> 
         RGBColor[1., 0.2, 0.2], "#FF3300" -> RGBColor[1., 0.2, 0.], 
         "#FF00FF" -> RGBColor[1., 0., 1.], "#FF00CC" -> 
         RGBColor[1., 0., 0.8], "#FF0099" -> RGBColor[1., 0., 0.6], "#FF0066" -> 
         RGBColor[1., 0., 0.4], "#FF0033" -> RGBColor[1., 0., 0.2], "#FF0000" -> 
         RGBColor[1., 0., 0.], "#CCFFFF" -> RGBColor[0.8, 1., 1.], "#CCFFCC" -> 
         RGBColor[0.8, 1., 0.8], "#CCFF99" -> RGBColor[0.8, 1., 0.6], 
         "#CCFF66" -> RGBColor[0.8, 1., 0.4], "#CCFF33" -> 
         RGBColor[0.8, 1., 0.2], "#CCFF00" -> RGBColor[0.8, 1., 0.], 
         "#CCCCFF" -> RGBColor[0.8, 0.8, 1.], "#CCCCCC" -> 
         RGBColor[0.8, 0.8, 0.8], "#CCCC99" -> RGBColor[0.8, 0.8, 0.6], 
         "#CCCC66" -> RGBColor[0.8, 0.8, 0.4], "#CCCC33" -> 
         RGBColor[0.8, 0.8, 0.2], "#CCCC00" -> RGBColor[0.8, 0.8, 0.], 
         "#CC99FF" -> RGBColor[0.8, 0.6, 1.], "#CC99CC" -> 
         RGBColor[0.8, 0.6, 0.8], "#CC9999" -> RGBColor[0.8, 0.6, 0.6], 
         "#CC9966" -> RGBColor[0.8, 0.6, 0.4], "#CC9933" -> 
         RGBColor[0.8, 0.6, 0.2], "#CC9900" -> RGBColor[0.8, 0.6, 0.], 
         "#CC66FF" -> RGBColor[0.8, 0.4, 1.], "#CC66CC" -> 
         RGBColor[0.8, 0.4, 0.8], "#CC6699" -> RGBColor[0.8, 0.4, 0.6], 
         "#CC6666" -> RGBColor[0.8, 0.4, 0.4], "#CC6633" -> 
         RGBColor[0.8, 0.4, 0.2], "#CC6600" -> RGBColor[0.8, 0.4, 0.], 
         "#CC33FF" -> RGBColor[0.8, 0.2, 1.], "#CC33CC" -> 
         RGBColor[0.8, 0.2, 0.8], "#CC3399" -> RGBColor[0.8, 0.2, 0.6], 
         "#CC3366" -> RGBColor[0.8, 0.2, 0.4], "#CC3333" -> 
         RGBColor[0.8, 0.2, 0.2], "#CC3300" -> RGBColor[0.8, 0.2, 0.], 
         "#CC00FF" -> RGBColor[0.8, 0., 1.], "#CC00CC" -> 
         RGBColor[0.8, 0., 0.8], "#CC0099" -> RGBColor[0.8, 0., 0.6], 
         "#CC0066" -> RGBColor[0.8, 0., 0.4], "#CC0033" -> 
         RGBColor[0.8, 0., 0.2], "#CC0000" -> RGBColor[0.8, 0., 0.], 
         "#99FFFF" -> RGBColor[0.6, 1., 1.], "#99FFCC" -> 
         RGBColor[0.6, 1., 0.8], "#99FF99" -> RGBColor[0.6, 1., 0.6], 
         "#99FF66" -> RGBColor[0.6, 1., 0.4], "#99FF33" -> 
         RGBColor[0.6, 1., 0.2], "#99FF00" -> RGBColor[0.6, 1., 0.], 
         "#99CCFF" -> RGBColor[0.6, 0.8, 1.], "#99CCCC" -> 
         RGBColor[0.6, 0.8, 0.8], "#99CC99" -> RGBColor[0.6, 0.8, 0.6], 
         "#99CC66" -> RGBColor[0.6, 0.8, 0.4], "#99CC33" -> 
         RGBColor[0.6, 0.8, 0.2], "#99CC00" -> RGBColor[0.6, 0.8, 0.], 
         "#9999FF" -> RGBColor[0.6, 0.6, 1.], "#9999CC" -> 
         RGBColor[0.6, 0.6, 0.8], "#999999" -> RGBColor[0.6, 0.6, 0.6], 
         "#999966" -> RGBColor[0.6, 0.6, 0.4], "#999933" -> 
         RGBColor[0.6, 0.6, 0.2], "#999900" -> RGBColor[0.6, 0.6, 0.], 
         "#9966FF" -> RGBColor[0.6, 0.4, 1.], "#9966CC" -> 
         RGBColor[0.6, 0.4, 0.8], "#996699" -> RGBColor[0.6, 0.4, 0.6], 
         "#996666" -> RGBColor[0.6, 0.4, 0.4], "#996633" -> 
         RGBColor[0.6, 0.4, 0.2], "#996600" -> RGBColor[0.6, 0.4, 0.], 
         "#9933FF" -> RGBColor[0.6, 0.2, 1.], "#9933CC" -> 
         RGBColor[0.6, 0.2, 0.8], "#993399" -> RGBColor[0.6, 0.2, 0.6], 
         "#993366" -> RGBColor[0.6, 0.2, 0.4], "#993333" -> 
         RGBColor[0.6, 0.2, 0.2], "#993300" -> RGBColor[0.6, 0.2, 0.], 
         "#9900FF" -> RGBColor[0.6, 0., 1.], "#9900CC" -> 
         RGBColor[0.6, 0., 0.8], "#990099" -> RGBColor[0.6, 0., 0.6], 
         "#990066" -> RGBColor[0.6, 0., 0.4], "#990033" -> 
         RGBColor[0.6, 0., 0.2], "#990000" -> RGBColor[0.6, 0., 0.], 
         "#66FFFF" -> RGBColor[0.4, 1., 1.], "#66FFCC" -> 
         RGBColor[0.4, 1., 0.8], "#66FF99" -> RGBColor[0.4, 1., 0.6], 
         "#66FF66" -> RGBColor[0.4, 1., 0.4], "#66FF33" -> 
         RGBColor[0.4, 1., 0.2], "#66FF00" -> RGBColor[0.4, 1., 0.], 
         "#66CCFF" -> RGBColor[0.4, 0.8, 1.], "#66CCCC" -> 
         RGBColor[0.4, 0.8, 0.8], "#66CC99" -> RGBColor[0.4, 0.8, 0.6], 
         "#66CC66" -> RGBColor[0.4, 0.8, 0.4], "#66CC33" -> 
         RGBColor[0.4, 0.8, 0.2], "#66CC00" -> RGBColor[0.4, 0.8, 0.], 
         "#6699FF" -> RGBColor[0.4, 0.6, 1.], "#6699CC" -> 
         RGBColor[0.4, 0.6, 0.8], "#669999" -> RGBColor[0.4, 0.6, 0.6], 
         "#669966" -> RGBColor[0.4, 0.6, 0.4], "#669933" -> 
         RGBColor[0.4, 0.6, 0.2], "#669900" -> RGBColor[0.4, 0.6, 0.], 
         "#6666FF" -> RGBColor[0.4, 0.4, 1.], "#6666CC" -> 
         RGBColor[0.4, 0.4, 0.8], "#666699" -> RGBColor[0.4, 0.4, 0.6], 
         "#666666" -> RGBColor[0.4, 0.4, 0.4], "#666633" -> 
         RGBColor[0.4, 0.4, 0.2], "#666600" -> RGBColor[0.4, 0.4, 0.], 
         "#6633FF" -> RGBColor[0.4, 0.2, 1.], "#6633CC" -> 
         RGBColor[0.4, 0.2, 0.8], "#663399" -> RGBColor[0.4, 0.2, 0.6], 
         "#663366" -> RGBColor[0.4, 0.2, 0.4], "#663333" -> 
         RGBColor[0.4, 0.2, 0.2], "#663300" -> RGBColor[0.4, 0.2, 0.], 
         "#6600FF" -> RGBColor[0.4, 0., 1.], "#6600CC" -> 
         RGBColor[0.4, 0., 0.8], "#660099" -> RGBColor[0.4, 0., 0.6], 
         "#660066" -> RGBColor[0.4, 0., 0.4], "#660033" -> 
         RGBColor[0.4, 0., 0.2], "#660000" -> RGBColor[0.4, 0., 0.], 
         "#33FFFF" -> RGBColor[0.2, 1., 1.], "#33FFCC" -> 
         RGBColor[0.2, 1., 0.8], "#33FF99" -> RGBColor[0.2, 1., 0.6], 
         "#33FF66" -> RGBColor[0.2, 1., 0.4], "#33FF33" -> 
         RGBColor[0.2, 1., 0.2], "#33FF00" -> RGBColor[0.2, 1., 0.], 
         "#33CCFF" -> RGBColor[0.2, 0.8, 1.], "#33CCCC" -> 
         RGBColor[0.2, 0.8, 0.8], "#33CC99" -> RGBColor[0.2, 0.8, 0.6], 
         "#33CC66" -> RGBColor[0.2, 0.8, 0.4], "#33CC33" -> 
         RGBColor[0.2, 0.8, 0.2], "#33CC00" -> RGBColor[0.2, 0.8, 0.], 
         "#3399FF" -> RGBColor[0.2, 0.6, 1.], "#3399CC" -> 
         RGBColor[0.2, 0.6, 0.8], "#339999" -> RGBColor[0.2, 0.6, 0.6], 
         "#339966" -> RGBColor[0.2, 0.6, 0.4], "#339933" -> 
         RGBColor[0.2, 0.6, 0.2], "#339900" -> RGBColor[0.2, 0.6, 0.], 
         "#3366FF" -> RGBColor[0.2, 0.4, 1.], "#3366CC" -> 
         RGBColor[0.2, 0.4, 0.8], "#336699" -> RGBColor[0.2, 0.4, 0.6], 
         "#336666" -> RGBColor[0.2, 0.4, 0.4], "#336633" -> 
         RGBColor[0.2, 0.4, 0.2], "#336600" -> RGBColor[0.2, 0.4, 0.], 
         "#3333FF" -> RGBColor[0.2, 0.2, 1.], "#3333CC" -> 
         RGBColor[0.2, 0.2, 0.8], "#333399" -> RGBColor[0.2, 0.2, 0.6], 
         "#333366" -> RGBColor[0.2, 0.2, 0.4], "#333333" -> 
         RGBColor[0.2, 0.2, 0.2], "#333300" -> RGBColor[0.2, 0.2, 0.], 
         "#3300FF" -> RGBColor[0.2, 0., 1.], "#3300CC" -> 
         RGBColor[0.2, 0., 0.8], "#330099" -> RGBColor[0.2, 0., 0.6], 
         "#330066" -> RGBColor[0.2, 0., 0.4], "#330033" -> 
         RGBColor[0.2, 0., 0.2], "#330000" -> RGBColor[0.2, 0., 0.], 
         "#00FFFF" -> RGBColor[0., 1., 1.], "#00FFCC" -> 
         RGBColor[0., 1., 0.8], "#00FF99" -> RGBColor[0., 1., 0.6], "#00FF66" -> 
         RGBColor[0., 1., 0.4], "#00FF33" -> RGBColor[0., 1., 0.2], "#00FF00" -> 
         RGBColor[0., 1., 0.], "#00CCFF" -> RGBColor[0., 0.8, 1.], "#00CCCC" -> 
         RGBColor[0., 0.8, 0.8], "#00CC99" -> RGBColor[0., 0.8, 0.6], 
         "#00CC66" -> RGBColor[0., 0.8, 0.4], "#00CC33" -> 
         RGBColor[0., 0.8, 0.2], "#00CC00" -> RGBColor[0., 0.8, 0.], 
         "#0099FF" -> RGBColor[0., 0.6, 1.], "#0099CC" -> 
         RGBColor[0., 0.6, 0.8], "#009999" -> RGBColor[0., 0.6, 0.6], 
         "#009966" -> RGBColor[0., 0.6, 0.4], "#009933" -> 
         RGBColor[0., 0.6, 0.2], "#009900" -> RGBColor[0., 0.6, 0.], 
         "#0066FF" -> RGBColor[0., 0.4, 1.], "#0066CC" -> 
         RGBColor[0., 0.4, 0.8], "#006699" -> RGBColor[0., 0.4, 0.6], 
         "#006666" -> RGBColor[0., 0.4, 0.4], "#006633" -> 
         RGBColor[0., 0.4, 0.2], "#006600" -> RGBColor[0., 0.4, 0.], 
         "#0033FF" -> RGBColor[0., 0.2, 1.], "#0033CC" -> 
         RGBColor[0., 0.2, 0.8], "#003399" -> RGBColor[0., 0.2, 0.6], 
         "#003366" -> RGBColor[0., 0.2, 0.4], "#003333" -> 
         RGBColor[0., 0.2, 0.2], "#003300" -> RGBColor[0., 0.2, 0.], 
         "#0000FF" -> RGBColor[0., 0., 1.], "#0000CC" -> 
         RGBColor[0., 0., 0.8], "#000099" -> RGBColor[0., 0., 0.6], "#000066" -> 
         RGBColor[0., 0., 0.4], "#000033" -> RGBColor[0., 0., 0.2], "#000000" -> 
         RGBColor[0., 0., 0.]}}}, $CellContext`s$$ = {1, 1, 1, 1, 1, 
      1}, $CellContext`sel$$ = {1, 1, 1, 1, 1, 1}, $CellContext`len$$ = {24, 
      118, 70, 147, 193, 216}, $CellContext`sort$$ = {1, 1, 1, 1, 1, 
      1}, $CellContext`sortQ$$ = {
      True, False, False, True, True, False}, $CellContext`gropts$$ = {
      ImagePadding -> 1, ImageSize -> 20, ImageMargins -> {{0, 0}, {3, 3}}, 
       Frame -> True, FrameTicks -> False, PlotRangePadding -> 
       0}, $CellContext`gdopts$$ = {
      Alignment -> {Center, Center}, Frame -> None, ItemSize -> Full, 
       Spacings -> {0, 0}}, $CellContext`i$$ = 1}, 
      TagBox[
       DynamicModuleBox[{Typeset`var$$ = False}, 
        InterpretationBox[
         StyleBox[
          PaneBox[
           TagBox[GridBox[{
              {
               ItemBox[
                OpenerBox[Dynamic[Typeset`var$$],
                 Enabled->Automatic],
                Alignment->Top,
                StripOnInput->False], 
               ItemBox[
                StyleBox[
                 PaneSelectorBox[{False->
                  PaneBox[
                   StyleBox["\<\"  Named\"\>",
                    StripOnInput->False,
                    FontSize->11],
                   ImageSize->{180, 12}], True->
                  TagBox[GridBox[{
                    {
                    PaneBox[
                    StyleBox["\<\"  Named\"\>",
                    StripOnInput->False,
                    FontSize->11],
                    ImageSize->{180, 12}]},
                    {
                    PopupMenuBox[Dynamic[$CellContext`i$$], {1->
                    StyleBox["\<\"System\"\>",
                    StripOnInput->False,
                    FontSize->10], 2->
                    StyleBox["\<\"Atoms\"\>",
                    StripOnInput->False,
                    FontSize->10], 3->
                    StyleBox["\<\"GeologicAges\"\>",
                    StripOnInput->False,
                    FontSize->10], 4->
                    StyleBox["\<\"HTML\"\>",
                    StripOnInput->False,
                    FontSize->10], 5->
                    StyleBox["\<\"Legacy\"\>",
                    StripOnInput->False,
                    FontSize->10], 6->
                    StyleBox["\<\"WebSafe\"\>",
                    StripOnInput->False,
                    FontSize->10]}]},
                    {
                    TagBox[GridBox[{
                    {
                    PanelBox[
                    TagBox[GridBox[{
                    {
                    PaneBox[
                    DynamicBox[ToBoxes[
                    Column[
                    Map[EventHandler[
                    If[# == Part[$CellContext`sel$$, $CellContext`i$$], 
                    Grid[{{
                    Spacer[5], 
                    Graphics[{
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$, #, 2], 
                    Rectangle[]}, FrameStyle -> 
                    GrayLevel[0], $CellContext`gropts$$], 
                    Spacer[5], 
                    Pane[
                    Style[
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$, #, 1], Bold], {104, 14}, Alignment -> {Left, Center}, 
                    ImageSizeAction -> "ShrinkToFit"], 
                    Spacer[5]}}, Background -> RGBColor[0.93, 0.93, 0.95], 
                    Dividers -> {False, {
                    1 -> GrayLevel[0.8], 2 -> 
                    GrayLevel[0.8]}}, $CellContext`gdopts$$], 
                    Grid[{{
                    Spacer[5], 
                    Graphics[{
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$, #, 2], 
                    Rectangle[]}, FrameStyle -> 
                    GrayLevel[0.8], $CellContext`gropts$$], 
                    Spacer[5], 
                    Pane[
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$, #, 1], {104, 14}, Alignment -> {Left, Center}, 
                    ImageSizeAction -> "ShrinkToFit"], 
                    Spacer[5]}}, $CellContext`gdopts$$]], {
                    "MouseClicked" :> (
                    Part[$CellContext`sel$$, $CellContext`i$$] = #)}]& , 
                    Range[
                    Part[$CellContext`s$$, $CellContext`i$$], 
                    Part[$CellContext`s$$, $CellContext`i$$] + 6]], 
                    Spacings -> {0, 0}], StandardForm]],
                    ImageSize->{142, All}], 
                    PaneBox[
                    SliderBox[Dynamic[
                    Part[$CellContext`s$$, $CellContext`i$$]], {
                    Dynamic[Part[$CellContext`len$$, $CellContext`i$$] - 6], 
                    1, 1},
                    Appearance->{"Vertical", Small},
                    ImageSize->Full],
                    Alignment->{Center, Center},
                    ImageSize->{22, 182}]}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxAlignment->{
                    "Columns" -> {Left, Right}, "Rows" -> {{Center}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{All}}, "Rows" -> {{All}}},
                    GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}},
                    RowsEqual->False],
                    "Grid"],
                    Alignment->{Center, Center},
                    
                    BaseStyle->{
                    ImageMargins -> 0, FontSize -> 10, FontFamily -> 
                    "Helvetica", CacheGraphics -> False},
                    FrameMargins->5,
                    ImageSize->{180, All}]},
                    {
                    PanelBox[
                    InterpretationBox[
                    RowBox[{"\<\"Sort\"\>", "\[InvisibleSpace]", 
                    InterpretationBox[
                    StyleBox[
                    GraphicsBox[{},
                    BaselinePosition->Baseline,
                    ImageSize->{5, 0}],
                    CacheGraphics->False],
                    Spacer[5]], "\[InvisibleSpace]", 
                    StyleBox[
                    InterpretationBox[
                    StyleBox[
                    RowBox[{
                    TagBox[GridBox[{
                    {
                    RadioButtonBox[Dynamic[
                    Part[$CellContext`sort$$, $CellContext`i$$]], {1},
                    Appearance->Small,
                    Enabled->Dynamic[
                    
                    Part[$CellContext`sortQ$$, $CellContext`i$$]]], \
"\<\"color\"\>"}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}},
                    RowsEqual->False],
                    "Grid"], "  ", 
                    TagBox[GridBox[{
                    {
                    RadioButtonBox[Dynamic[
                    Part[$CellContext`sort$$, $CellContext`i$$]], {2},
                    Appearance->Small,
                    Enabled->Dynamic[
                    
                    Part[$CellContext`sortQ$$, $CellContext`i$$]]], "\<\"name\
\"\>"}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}},
                    RowsEqual->False],
                    "Grid"]}],
                    Deployed->True],
                    RadioButtonBar[
                    Dynamic[
                    Part[$CellContext`sort$$, $CellContext`i$$]], {
                    1 -> "color", 2 -> "name"}, Appearance -> Small, Enabled -> 
                    Dynamic[
                    Part[$CellContext`sortQ$$, $CellContext`i$$]]]],
                    StripOnInput->False,
                    FontFamily->"Helvetica",
                    FontSize->10]}],
                    Row[{"Sort", 
                    Spacer[5], 
                    Style[
                    RadioButtonBar[
                    Dynamic[
                    Part[$CellContext`sort$$, $CellContext`i$$]], {
                    1 -> "color", 2 -> "name"}, Appearance -> Small, Enabled -> 
                    Dynamic[
                    Part[$CellContext`sortQ$$, $CellContext`i$$]]], 10, 
                    FontFamily -> "Helvetica"]}]],
                    Alignment->{Left, Center},
                    FrameMargins->{{7, 7}, {5, 5}},
                    ImageSize->{180, All}]},
                    {
                    PanelBox[
                    InterpretationBox[
                    RowBox[{
                    DynamicBox[ToBoxes[
                    Graphics[{
                    Part[
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$], 
                    Part[$CellContext`sel$$, $CellContext`i$$], 2], 
                    Rectangle[]}, Frame -> True, FrameTicks -> False, 
                    ImageSize -> 30, ImagePadding -> 1, PlotRangePadding -> 
                    0], StandardForm]], "\[InvisibleSpace]", 
                    InterpretationBox[
                    StyleBox[
                    GraphicsBox[{},
                    BaselinePosition->Baseline,
                    ImageSize->{5, 0}],
                    CacheGraphics->False],
                    Spacer[5]], "\[InvisibleSpace]", 
                    TagBox[GridBox[{
                    {
                    PaneBox[
                    StyleBox[
                    DynamicBox[ToBoxes[
                    Part[
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$], 
                    Part[$CellContext`sel$$, $CellContext`i$$], 1], 
                    StandardForm]],
                    StripOnInput->False,
                    FontWeight->Bold],
                    Alignment->{Left, Center},
                    ImageSize->{125, 14},
                    ImageSizeAction->"ShrinkToFit"]},
                    {
                    PaneBox[
                    DynamicBox[ToBoxes[
                    Map[Round[#, 0.01]& , 
                    Part[
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$], 
                    Part[$CellContext`sel$$, $CellContext`i$$], 2]], 
                    StandardForm]],
                    Alignment->{Left, Center},
                    ImageSize->{125, 14},
                    ImageSizeAction->"ShrinkToFit"]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}},
                    RowsEqual->False],
                    "Column"]}],
                    Row[{
                    Dynamic[
                    Graphics[{
                    Part[
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$], 
                    Part[$CellContext`sel$$, $CellContext`i$$], 2], 
                    Rectangle[]}, Frame -> True, FrameTicks -> False, 
                    ImageSize -> 30, ImagePadding -> 1, PlotRangePadding -> 
                    0]], 
                    Spacer[5], 
                    Column[{
                    Pane[
                    Style[
                    Dynamic[
                    Part[
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$], 
                    Part[$CellContext`sel$$, $CellContext`i$$], 1]], Bold], {
                    125, 14}, Alignment -> {Left, Center}, ImageSizeAction -> 
                    "ShrinkToFit"], 
                    Pane[
                    Dynamic[
                    Map[Round[#, 0.01]& , 
                    Part[
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$], 
                    Part[$CellContext`sel$$, $CellContext`i$$], 2]]], {125, 
                    14}, Alignment -> {Left, Center}, ImageSizeAction -> 
                    "ShrinkToFit"]}, Left, {0, 0}]}]],
                    Alignment->Left,
                    
                    BaseStyle->{
                    ImageMargins -> 0, FontSize -> 10, FontFamily -> 
                    "Helvetica", CacheGraphics -> False},
                    FrameMargins->{{7, 0}, {7, 7}},
                    ImageSize->{180, All}]},
                    {
                    TagBox[
                    TooltipBox[
                    DynamicBox[ToBoxes[
                    Button[
                    Style["Insert", 11], 
                    FrontEndExecute[{
                    FrontEnd`NotebookApply[
                    FrontEnd`InputNotebook[], 
                    With[{$CellContext`in$ = Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$, 
                    Part[$CellContext`sel$$, $CellContext`i$$], 1]}, 
                    If[$CellContext`i$$ == 1, 
                    BoxData[$CellContext`in$], 
                    BoxData[
                    RowBox[{
                    RowBox[{"ColorData", "[", 
                    ToBoxes[
                    Part[$CellContext`names$$, $CellContext`i$$]], "]"}], "[",
                     
                    ToBoxes[$CellContext`in$], "]"}]], Placeholder]]]}], 
                    ImageSize -> 180], StandardForm]],
                    DynamicBox[
                    ToBoxes[
                    With[{$CellContext`in$ = Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$, 
                    Part[$CellContext`sel$$, $CellContext`i$$], 1]}, 
                    If[$CellContext`i$$ == 1, $CellContext`in$, 
                    Row[{"ColorData[\"", 
                    Part[$CellContext`names$$, $CellContext`i$$], 
                    "\"][\"", $CellContext`in$, "\"]"}]]], StandardForm]],
                    ActionDelay->0.3],
                    Annotation[#, 
                    Dynamic[
                    With[{$CellContext`in$ = Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$, 
                    Part[$CellContext`sel$$, $CellContext`i$$], 1]}, 
                    If[$CellContext`i$$ == 1, $CellContext`in$, 
                    Row[{"ColorData[\"", 
                    Part[$CellContext`names$$, $CellContext`i$$], 
                    "\"][\"", $CellContext`in$, "\"]"}]]]], "Tooltip"]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                   "Column"]}, Dynamic[Typeset`var$$],
                  Alignment->Automatic,
                  ImageMargins->{{0, 10}, {0, 0}},
                  ImageSize->Automatic],
                 Deployed->False,
                 StripOnInput->False],
                Background->Automatic,
                StripOnInput->False]}
             },
             ColumnsEqual->False,
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Top}}, "RowsIndexed" -> {}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}},
             RowsEqual->False],
            "Grid"],
           BaselinePosition->Automatic,
           DefaultBaseStyle->"OpenerView",
           ImageMargins->0],
          Deployed->True,
          StripOnInput->False],
         OpenerView[{
           Pane[
            Style["  Named", 11], {180, 12}], 
           Column[{
             Pane[
              Style["  Named", 11], {180, 12}], 
             PopupMenu[
              Dynamic[$CellContext`i$$], {
              1 -> Style["System", 10], 2 -> Style["Atoms", 10], 3 -> 
               Style["GeologicAges", 10], 4 -> Style["HTML", 10], 5 -> 
               Style["Legacy", 10], 6 -> Style["WebSafe", 10]}], 
             Column[{
               Panel[
                Grid[{{
                   Pane[
                    Dynamic[
                    Column[
                    Map[EventHandler[
                    If[# == Part[$CellContext`sel$$, $CellContext`i$$], 
                    Grid[{{
                    Spacer[5], 
                    Graphics[{
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$, #, 2], 
                    Rectangle[]}, FrameStyle -> 
                    GrayLevel[0], $CellContext`gropts$$], 
                    Spacer[5], 
                    Pane[
                    Style[
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$, #, 1], Bold], {104, 14}, Alignment -> {Left, Center}, 
                    ImageSizeAction -> "ShrinkToFit"], 
                    Spacer[5]}}, Background -> RGBColor[0.93, 0.93, 0.95], 
                    Dividers -> {
                    False, {
                    1 -> GrayLevel[0.8], 2 -> 
                    GrayLevel[0.8]}}, $CellContext`gdopts$$], 
                    Grid[{{
                    Spacer[5], 
                    Graphics[{
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$, #, 2], 
                    Rectangle[]}, FrameStyle -> 
                    GrayLevel[0.8], $CellContext`gropts$$], 
                    Spacer[5], 
                    Pane[
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$, #, 1], {104, 14}, Alignment -> {Left, Center}, 
                    ImageSizeAction -> "ShrinkToFit"], 
                    Spacer[5]}}, $CellContext`gdopts$$]], {
                    "MouseClicked" :> (
                    Part[$CellContext`sel$$, $CellContext`i$$] = #)}]& , 
                    Range[
                    Part[$CellContext`s$$, $CellContext`i$$], 
                    Part[$CellContext`s$$, $CellContext`i$$] + 6]], 
                    Spacings -> {0, 0}]], ImageSize -> {142, All}], 
                   Pane[
                    VerticalSlider[
                    Dynamic[
                    Part[$CellContext`s$$, $CellContext`i$$]], {
                    Dynamic[Part[$CellContext`len$$, $CellContext`i$$] - 6], 
                    1, 1}, Appearance -> Small, ImageSize -> Full], {22, 182},
                     Alignment -> {Center, Center}]}}, 
                 Alignment -> {{Left, Right}, Center}, ItemSize -> Full, 
                 Spacings -> {0, 0}], Alignment -> {Center, Center}, 
                BaseStyle -> {
                 ImageMargins -> 0, FontSize -> 10, FontFamily -> "Helvetica",
                   CacheGraphics -> False}, FrameMargins -> 5, 
                ImageSize -> {180, All}], 
               Panel[
                Row[{"Sort", 
                  Spacer[5], 
                  Style[
                   RadioButtonBar[
                    Dynamic[
                    Part[$CellContext`sort$$, $CellContext`i$$]], {
                    1 -> "color", 2 -> "name"}, Appearance -> Small, Enabled -> 
                    Dynamic[
                    Part[$CellContext`sortQ$$, $CellContext`i$$]]], 10, 
                   FontFamily -> "Helvetica"]}], Alignment -> {Left, Center}, 
                FrameMargins -> {{7, 7}, {5, 5}}, ImageSize -> {180, All}], 
               Panel[
                Row[{
                  Dynamic[
                   Graphics[{
                    Part[
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$], 
                    Part[$CellContext`sel$$, $CellContext`i$$], 2], 
                    Rectangle[]}, Frame -> True, FrameTicks -> False, 
                    ImageSize -> 30, ImagePadding -> 1, PlotRangePadding -> 
                    0]], 
                  Spacer[5], 
                  Column[{
                    Pane[
                    Style[
                    Dynamic[
                    Part[
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$], 
                    Part[$CellContext`sel$$, $CellContext`i$$], 1]], Bold], {
                    125, 14}, Alignment -> {Left, Center}, ImageSizeAction -> 
                    "ShrinkToFit"], 
                    Pane[
                    Dynamic[
                    Map[Round[#, 0.01]& , 
                    Part[
                    Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$], 
                    Part[$CellContext`sel$$, $CellContext`i$$], 2]]], {125, 
                    14}, Alignment -> {Left, Center}, ImageSizeAction -> 
                    "ShrinkToFit"]}, Left, {0, 0}]}], Alignment -> Left, 
                FrameMargins -> {{7, 0}, {7, 7}}, ImageSize -> {180, All}, 
                BaseStyle -> {
                 ImageMargins -> 0, FontSize -> 10, FontFamily -> "Helvetica",
                   CacheGraphics -> False}], 
               Tooltip[
                Dynamic[
                 Button[
                  Style["Insert", 11], 
                  FrontEndExecute[{
                    FrontEnd`NotebookApply[
                    FrontEnd`InputNotebook[], 
                    With[{$CellContext`in$ = Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$, 
                    Part[$CellContext`sel$$, $CellContext`i$$], 1]}, 
                    If[$CellContext`i$$ == 1, 
                    BoxData[$CellContext`in$], 
                    BoxData[
                    RowBox[{
                    RowBox[{"ColorData", "[", 
                    ToBoxes[
                    Part[$CellContext`names$$, $CellContext`i$$]], "]"}], "[",
                     
                    ToBoxes[$CellContext`in$], "]"}]], Placeholder]]]}], 
                  ImageSize -> 180]], 
                Dynamic[
                 With[{$CellContext`in$ = Part[$CellContext`rules$$, 
                    
                    Part[$CellContext`sort$$, $CellContext`i$$], \
$CellContext`i$$, 
                    Part[$CellContext`sel$$, $CellContext`i$$], 1]}, 
                  If[$CellContext`i$$ == 1, $CellContext`in$, 
                   Row[{"ColorData[\"", 
                    Part[$CellContext`names$$, $CellContext`i$$], 
                    "\"][\"", $CellContext`in$, "\"]"}]]]], ActionDelay -> 
                0.3]}]}]}, False, FrameMargins -> {{0, 10}, {0, 0}}]],
        DynamicModuleValues:>{}],
       Setting[#, {0}]& ],
      DynamicModuleValues:>{}]},
    {
     DynamicModuleBox[{$CellContext`gnames$$ = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
       11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
       29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 
      43}, $CellContext`glen$$ = 43, $CellContext`grange$$ = {{1, 
        DirectedInfinity[1], 1}, {1, 9, 1}, {1, 10, 1}, {1, 10, 1}, {1, 10, 
       1}, {1, 11, 1}, {1, 11, 1}, {1, 9, 1}, {1, 9, 1}, {1, 11, 1}, {1, 8, 
       1}, {1, 10, 1}, {1, 10, 1}, {1, 10, 1}, {1, 11, 1}, {1, 9, 1}, {1, 10, 
       1}, {1, 9, 1}, {1, 9, 1}, {1, 10, 1}, {1, 10, 1}, {1, 9, 1}, {1, 8, 
       1}, {1, 10, 1}, {1, 9, 1}, {1, 8, 1}, {1, 10, 1}, {1, 9, 1}, {1, 10, 
       1}, {1, 9, 1}, {1, 9, 1}, {1, 9, 1}, {1, 8, 1}, {1, 6, 1}, {1, 10, 
       1}, {1, 8, 1}, {1, 11, 1}, {1, 8, 1}, {1, 8, 1}, {1, 10, 1}, {1, 7, 
       1}, {1, 4, 1}, {1, 9, 1}}, $CellContext`glist$$ = {
       Graphics[
        Raster[CompressedData["
1:eJzt0jFKQ0EQh/EH3sLOUwyCg0WCjSBoIcF0D5IuiJXYWIhNFgvLzAU9hM1z
9u0F/lsIYr7lC1jMYEZ/Z+Pj3XgyDMNpfr7zU3/++v03TdM/+BV/83F478ql
h17OF9uGP4nlcK7Eh+vlvJUbj3u9unJb/CHEcrh+K//Uq4ePFjsXy+FcWYTr
1St2xV9CLIdz5d1D79nmw/OvK5fzq2JjuFgO54ofQi/n11Y2HmLrdoVf66Ed
7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3t
aEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGO9iPXfm5F
r2nvqq68ml7T3lXT3tV8yJte095VrlwU02vau8qVBNxVPeTK9Jr2ruoh+6LX
tHc1//uWek07j3c87welhNJ1
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0iEPAWEcx/HbKXQTJDZNuWKCCUwhCIKmXDHpiiZ5BV6CyaJMFERVkZ4X
oTz+t+ct/Oxm9/3ve5v025192mm2SCtRFDXt+diT/3b/cN77ol+hmCvth//i
wp/5imNh+e4w8hNZtpa/6nYkzG0GtrlLasLyD39s/XuvytZs8nJ7Cjudr7bZ
Gy6E2WC9NW50pqpszTaX66MwtKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1o
Rzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhH
O9rRjna0ox3taEc72tFecu33OBYWtIuzM5/anMu6VWFBuzjnzKc220z6M2FB
uzbbnK8OwoJ2jivPfQG6sLQy
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0jFqwmAYxvGPBBK9QqCFIMVLuPUGdunQKTgWxCHQQRcHB/feoGfoLYRO
XkBSJy9QxPQJnzd4X0T0//IPZHoI4VdW03GVhhAKPX96uvdf7uLXtu0VTt38
xX8VnE5Tp7fcnnaaXe907NvT1PwrW3/n9jRVTl6fppU9TSX1NlkerNVbTQ0f
FvYGxUxTH8+f9t5HK03t0oW9Tdp91T4v7aEd7WhHO9rRjna0ox3taEc72tGO
drSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52
tKMd7WhHO9rRjna0ox3taEc72tGOdrR7aW9eMntRu0tRu0tRu0tn7R5pSlBd
0pSguqQpQXVJUz/Zo72onePu5/4Bnp5DKA==
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0jFKw2AYxvFAbxEoVHqBllBBnEq3iktLqIFWYgJVRHBw7QHaqaODQ+ku
CB7BEzh6gdbR3cH4yHeE90XE/F/+H2R6hvA7KG5HRSOKoljvU+/ne8/9+lVV
9Qen/v2Ff3XkcUmSaOqw3bSnncXZ8aro29PUxUnnZtyzp6m3p9nHy6U9Te1e
s6/30phGNLW5n9tbL6eaen48t7d9SDV1fZfby68mmkrLoT20ox3taEc72tGO
drSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52
tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0V5z7YnTaarbiu0F7S4F
7S4F7S4F7S5pSlBd0pSguqQpQXVJU6fZwF7QznH1uW8zyf4g
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0jFKw2AYxvGAdyjilEIXB8ElQ8mgXWpxyNChDlmSQB3SQYq4d9PRLHXU
3qAX6CV6AxfvYJf4yHeE96WU9v/y/yDTM4Rft3oaV2dRFF3o7fT+v3+4vV/b
tgc4dfQX/tVLr2evjmNNfaWpPe083F6Xd4k9Tb0+Zsv5xJ6m3srBx2xkT1Ob
5852cW5MI5r6XY/tfX/ea2o6vbKX55eaquvMXlEMNbVa3dhDO9rRjna0ox3t
aEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1o
Rzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe0nrl1QXdLUe5LYC9pd
CtpdCtpdCtpd0pSguqQpQXVJU4Lqkqaapm8vaOe407k/qxXvPw==
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0jFLAnEcxvEDIaVAQkSODsEbHAKXZqemaClyafY2EdHBoaG1IaKtQcQl
aLA5aPEdtPQuehEu1xP/zfGeIdHvj++Byz3I8UmzcS8rRVF0omet5+/3z3Zc
nuf//Rd27fikGxc+yK13WniJD9+So8LpdY2cJcdOnbiqka/VwkkLq8eD71m5
cHpdI8n5qZMWmhdZ63rkpJFaellv3xROr2tkOf9w0sJdf/AwnBZOr2vkvhI7
oR3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSj
He1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y72Pdd+
5V3QbqYRcTXTyOf7s1PQbqaRuNt2CtrNgnYzjcyeXp2CdjONTMoNp6Cd4/bn
fgHL9Aw/
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0r1KQnEcxvED3kVbNyBBSA3ZUJOLiou1OLgULoFv6/F1aqncHARbGoSC
CMSxOboNL6Ll9MR/czzPkOj3x/eAy3mQw+ewflepZ6IoOtDzo+fv93o7LkmS
//4Lu3Z80o0LH6QXx05aWHZbX8M4dXpdI7fnOafa6ZFGvt+mTlq4OMkW8sep
0+sa+fyYOGlh/jJ4Xz04aaQxbncm/dTpdY08zRdOWiiWytWr69TpdY1cVptO
aEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1o
Rzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKN9z7W3
vAvazTQirmYaWc3unYJ2M428Po+dgnazoN1MI6PHqVPQbqaRs+KNU9DOcftz
v4U9w6s=
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0rFKw2AYheGAi87Fxc3FQbo0S3TRxSBiQFq6dsno0kHc7QUUR5eStWPu
wE1xly4VOmbqFXT5PeG/hSNF8n68gU6HpDyn5XRUHiRJcqJnp6f93fyHCyHs
+xX2c5398L+4+Gcuintj7e7He1h/u9KaJn9en419zh61uSyOjWnwa5Vutpkr
rWnzpT4y9lQdajObnBvT4MXd7dXwwZXWtFkPro2hHe1oRzva0Y52tKMd7WhH
O9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc7
2tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjvaOa5/nN8aidnNNI5/etPmW94xF
7d60KZ/etJmOz4xF7d60WfUvjUXtHNed+wWUWvUk
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0qFqQmEchvEPbDOJTERhsEuwWEUGIhbB5LAdMYrVLiYxCLNsRm1eh9dg
EGxW42Dl+I7vFl4ROc+f54Dp5Rz5vSeTXpILIVT0/On5/315hkvT9NGv8JjL
7Iff4+Kfed1tjWnwp/CyL+ZdaU2bp3nf2GHa1ebvdzCmwc9kMByPXGlNm2/V
xFi13Ndm+bVjTIPNWqNdb7nSmjZ3q40xtKMd7WhHO9rRjna0ox3taEc72tGO
drSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52
tKMd7WhHO9rRjna0ox3taEc72tGece3H9ZexqN2bNuXTmzbPi2AsavemTfn0
ps1S8cNY1O5Nm+vZ0ljUznHZuRuv2uBb
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0jFLAmEAxvEXcteOIGprKshREAShtTFdpUEXp0KdQi7QIdryI9TU7qTQ
R2hoaPADSEtDuyDXE+/WeM9g5P/lf3DL+3Acv6P2daO9E0I41LPS8/P+8TdO
lmWb/oT/dvilv078IdNCcNLCe7/zeXuVO13XyNfjqdNicqyR9VvqpIXnWWn+
muRO1zVyke45aeGkWSq3EieNNC+Hre597nRdI7X6wEkL+8Xawe5Z7nRdIw93
Eye0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGO
drSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0b7l
2p8KwSlqN9OIuJppZPnSc4razTRy3kuconazqN1MI5Vq1ylqN9PI6GbsFLVz
ONtzvgFwPL9C
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0jFKA1EUhtEBd5HOBQQhuAI7IaSQQCqbNClt3IBNduBES0GSkEYYMJWV
YCEiCK4gCBYuwWZyw9uAzS0k5/I9mOovhnM4vjgbH1RV1Yn3G2/3/f1vr21b
4+7vV377cjTM6GbQj/HN6XFGbydHMf71Ok8qxm8vu6urXka78bvzVTPJKMan
zeD6ZZRRjN8/fK6ffzKK8Vn9tJh/ZEQ77bTTTjvttNNOO+2000477bTTTjvt
tNNOO+2000477bTTTjvttNNOO+2000477bTTTjvttNNOO+2000477bTTTjvt
tNNOO+2000477bTvufZgmVSMB8ukYvz9sU6qaE+qaE+qaE+qaE+qaE+qaHdu
f24LdCsl3g==
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0r9KQmEcxvED7bkbhWeQCj1DDv4ZyqlcQsHBxuggbnIQJxe9gSBoagtc
dOkCWsKuQQi6gXZXl9MT7yX8XiQ83x/fF870DIdPGCfd+CAIgrzeVu/v+4fb
+aVp+g+n9v7cv3otFuw9hceaWrbL9rRTPzq8OsnZ09T32/NmNbenqc/hxdek
ak9TH4v++j0xphFNjWaP9gbjqaaanXt7jVZPU6XLB3untTtN3UYVe2hHO9rR
jna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGO
drSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjPePaBdVLmnq5
ObPntHvJafeS0+4lp91LmhJUL2lKUL2kKUH1kqauzyN7TjvHZed+AaPKiLc=

         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0jFLAnEYx/GD1nwDba0tuTg1uN0sIZhDgzfWICLRdBwugkiEgnBbKBi1
tWXQG3AQnF3aegGNLdcv/i/heZDovg/fP9z0G47PcdI9Tw6iKDrS+9b7/f7k
9n5FUfzBqX9/4V89Zam9vN/T1Oq0Yk87b+nVZnxjT1PvD5Pty9yepnbr5dfH
qz1NtS6mnWRhTCOaOqvd2atVM03N7p/tDQe5pm7jtr3rekNTeXxpD+1oRzva
0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rR
jna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0l1y7oLqkqceT
Q3tBu0tBu0tBu0tBu0uaElSXNCWoLmlKUF3S1KjetBe0c1x57gedqidh
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0iFrAnEYx/EDWdsYqyLIwLCiyIZ5RS1i8RWMC4YDGRbbgmFpYWHdsCCY
LAbBYjGbLHb3AowLO3/n/yU8D0P0+/A9uPTjOD738WsnzkVRlNfzqyd7/+H+
/dI0PcGps7/wrzZfn/aW70NN7Vs39rIvm1TSxZM9Le223b99356mvkeN2bRt
T1Mvb4Xko2hMI5q6qg0cqiaams7X9kbjhaZ6dw/24tuSpraPTXtoRzva0Y52
tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0
ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0o/3CtQuqS9mH1a/t
Be0+HbW7FLS7FLS7lGmvJi5pSlBd0pSguqSpVfnZXtDOcZdzB9/yT54=
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0iFrAmEAxvGDfQth4iHDsCIIc4JaRFgcYnXBGcSgScvCWFsR6/LS4mDL
WxCMFg37AGJdX7k98rbFe4Iy/y//gyvvw3H84u6o1T2Joiij50fP7n17GCdJ
kn1/wn87/NI/J/yQfiHvpIWnh7uX2WPqdF0j61Hs9NnLamSzmjtp4evt6ntx
nTpd10itOXHSwkU8qJ6NnTTSLt92asPU6bpGLnNFJy3cZ0vTuJI6XdfIe6Pp
hHa0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGO
drSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzvaj1z7
TT7nFLSbaURczTSy/Hh1CtrNNFKuD5yCdrOg3UwjpdNzp6DdTCPP1bpT0M7h
HM/5BZXLoGM=
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0q2KAmEchfGXEU0Ky0Y/mbAGr8QoXoHYtFjcC9AbMFhtpg1ewZYtdqMI
1rFaLJbxyHsLR2SZ588zYDrMyC8dz4bjUgihrueu5/k7+w+X5/m7X+E9V9gP
f8XFP3NeqxjT4KYfdgNbWtPmZftp7LD+0GZv2jamwf05O91yV1rTdZa/xprf
P9rcrv6MaTCtd79aPVda0+Y1JMbQjna0ox3taEc72tGOdrSjHe1oRzva0Y52
tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0
ox3taEc72tGOdrSjHe1oR3vBtU+qZWNRuzdtyqc3bXZHDWNRuzedfHrT5nqx
Mxa1e9PmMSTGonaOK849AN3WX44=
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0jFLAmEcx/GD3oVbOAguDiVxakS4tEgQCHHjcUPcIiIJDS6G0VZS0FZD
a4OLs+Ag+ApcpNGX4NBy/eR5Cf8Hie775/vATb/h+BzGnav4IAiCgt6P3u57
w+39siz7g1P//ty/uqiF9s6PjzT1XC/Z085L1PpM2vY0tXhqrN+b9jT1Pb3b
Lh/saSp9TG/f+sY0oqnT3pm9k5tQU9evE3uXow9NVZKBvXLU1dR4trKHdrSj
He1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd
7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9pzrl1QvaSp
YbVoz2n3ktPuJafdS067lzQlqF7SlKB6SVOC6iVN3X/N7TntHJef+wUZfksv

         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0jFqwnAYhvGAl5A6dTaDuYBIiZQScOjgWghCx0Dp6FBXh16hhO5FhByg
dNEeQhzEQwglvuF/hVek5Pl4Ak4vifxu8+Ix70RRdKPnpKf5ffwPV9f1tV/h
OtfaD7/EhT/z531pTIOH6utv++1Ka9rMkp6xNO5q8+k+MabBdNjPxgNXWtNm
tV4Y+yxftbnbr4xpcDi5G08fXGlNm+vixRja0Y52tKMd7WhHO9rRjna0ox3t
aEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1o
Rzva0Y52tKMd7WhHO9rRjna0ox3taG+59tXb3FjQ7q2BFHe9aXM6io0F7d60
KZ/etLn5/TAWtHvTZjl7Nha0c1x77gybA1jY
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0qFqQmEchvEPXJpBlmS2KWg5iDItK7Y1i2CThRMMgpgUjDJYHWKxm4y7
hnkRuwIvwnJ8D98tvEPkPH+eA6aX4+H3ki5GaSmEUNNz0ZP/Pt/DZVl261e4
zRX2j//HxY+5LQdjGtz02t9vr660ps3jOBjbD/P3/DvMjWnwZ1Y/rZqutKbN
h+6zs6Sqze7HuzENTtaz6dfSlda0+dTqG0M72tGOdrSjHe1oRzva0Y52tKMd
7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3t
aEc72tGOdrSjHe1oRzva0Y52tKMd7QXX/vkYjEXt3rQpn960+btLjUXt3nLt
SdWbNpPxwFjU7k2blUbHWNTOccW5K32gJ5Y=
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt1KFqQmEYxvEjs+oUxDBw7FyAxWzyEmRBkME4cWVtN7BmsomgYDOIFrus
CRYt61v5vAfL2XP4LuF9GWP+X/4HTE8454dp9trPbpIkudNz0VP8DtyvX57n
f3Dq3198V7t6yd7qtlQsdlKHQuhXysOqQ5qaPyebF4c09TFufC6a9jT1ve1e
9j1jGik+4nlpL5wmmsqmX/YGo4Omar13e9Xum6Yentb20I52tKMd7WhHO9rR
jna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGO
drSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEf7lWsXVJc0dWzf24vaXYra
XYraXYraXSr+YQTVpRAE1SVNCapLmmo9zuxF7Rx3PfcDEIuSIQ==
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0rFKw1AYhuFA76A4lUDo3MEOvYcuhVKRCi5tg4PYIWApmezkpuAFOMRL
sOBg76CFuji56SS4dRSX45eeS/gPRez78wYyfYTw1NPsKK1EUVTT86OnfP/k
dn7OuT849e/P/6vNbGLv7fJcU+/5sb3yy3qxO03saenj+ep7fWNPU6+L26+X
e3uaeiry5eO1MY1oajpo2rvoNzQ1L0b2Hu5ONJV1h/bO2uVU6yCxh3a0ox3t
aEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1o
Rzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva91y7oAZJU6tx
x57XHqat9iB57UHy2oOkKUENkqYENUiaEtQgaeqwGtvz2jluf+4XyTPQTQ==

         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0yFLA3EcxvE/CN6CIqbBlbEZ9hpMVqMIxl244povwGDVYDoG9kOjxSKY
Vg7bVcNY2+q65XyO/1t4xiH3/fE9WHrYjs/G+d11fhBCSPX86mk/b//DNU3T
9Vfo5nr7w/dx8WXOTwfGNFjNDle3iSutaXNXBWM/H+3fvFxujGnw8mZxlb26
0po2X55rY08PX9qcHqfGNPh9X6wfS1da0+bn5MIY2tGOdrSjHe1oRzva0Y52
tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0
ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WjvufbsJDEWtXvTpnx602bxXhuL
2r1pUz69afPsaGgsavemzbfRubGoneP6c3/ZvmME
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt06FOw2AUhuEmZGaEXcDUCAZBMDOoXQHJMjJBkBU4QtCYyqleBm5mChxi
k2iCwE7iMJhylv8GMEeQPSdvk6pPNE+P6/ur+qCqqmE8P/Hs3rf/9rquM+7+
fuWz3xxWGc36u1/p4ayX0e1pL8bvxoOkYnzdXH6084xi/HPZfL+2GcX4qrnY
tJOMYvzlcfS2OMkoxt+fpl/P1xnRTjvttNNOO+2000477bTTTjvttNNOO+20
00477bTTTjvttNNOO+2000477bTTTjvttNNOO+2000477bTTTjvttNNOO+20
00477bTTTjvte649WCYV48EyqRivz4+SKtqTKtqTKtqTKtqTKtqTKtqd25/7
BeKGFlU=
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0qFqQmEYxvEDXoMMDILXMJAF88AiaNgFqHnCKQvDkwyCySTYdLCFzbbB
2kwGw9LCEINhWAyDRcvxcd8lvC8i+n/5f3DSEw6/Qr1Vq2eiKMrpbfX232vu
4Jem6RFOnfyFf7VJbu19xY394PuVPe0sZs2/Zcuepobz7+fVrz1NlQeT6tPU
nqbyd/1CZ2RMI5q6uEnsZSuxpl6Tnr1x3NZUt1Sxd1+81tTP24c9tKMd7WhH
O9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc7
2tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tF+5toF1SVNrR8v
HfrX7lLQ7lLQ7lLQ7pKmBNUlTQmqS5oSVJc09fnwYi9o57jzuR1Zvm+J
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0jFqwnAYhvEE0VoL0lJEcNPBoUiL6KCL3sBBBzs4ZXBxEFwcCj2AN6hX
6AE8RO7RQ7jEN/yv8JYgeT6egNNLDL9usl8mlSiKOnquevLff/dwWZYV/QrF
XGn/+H9c+Jjjx9iYBk/9l5+3V1da0+b6OTa2aObvmW7bxjR42Q/Sr6ErrWnz
9zg3dt5NtZnMHoxp8LCqfm9qrrSmzf7oyRja0Y52tKMd7WhHO9rRjna0ox3t
aEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1o
Rzva0Y52tKMd7WhHO9rRjna0ox3taC+59o96bCxo96ZN+fSW49y0jAXt3rQp
n960+TmpGQvavWmz994wFrRzXHnuBhCtCm8=
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0qFKQ2EYx+ED1okIw2DT4AWsGNcsLnmMSwODsDHDwrwMb0AwmYZ5zSKs
LIhYDEYR8QosZ698N7DyhrHn5ffBSf9weI4G44vBTlVVh/H+4v1/f23sNU1j
3K1/5bdPTw4yGh63Y/y7f5rRa92J8c/+blIxPn+8W84fMorxq+7ezdl+RjH+
/jL7/XjOKMbf7ns/T5cZxfj59aie3GZEO+2000477bTTTjvttNNOO+200047
7bTTTjvttNNOO+2000477bTTTjvttNNOO+2000477bTTTjvttNNOO+200047
7bTTTjvttNNOO+20b7n2YJlUjAfLpGJ8UbeSKtqTKtqTKtqTKtqTKtqTKtqd
255bAe0F5fc=
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt07FqwlAYhuFAr0Jx8RpcvI6CjhbEXTI5lDp1UBAyNuCQSWzBvSUXoB20
Y4dKhVKarUtHh55+4VzCfyhi3p83kOkbwpNmf3jZv4iiqK7nqKd8L7h/P+fc
CU6d/flvtWxE9u5q5Y9zzGf2tPM2bf2kbXua+irWv25vT1Pd687VpGdPU5vX
3fv3pzGNaOrmMbMXL5Jy6mFlL07nmspeDvaS/FlT2+GtPbSjHe1oRzva0Y52
tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0
ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRXnHtghokTX3cj+157UHy
2oPktQfJaw+SpgQ1SOVUOg+SpgQ1SJp6Gozsee0cV537A/JiOSs=
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0q9uwmAcheEvwWy3gJub4AZQKFBTQ2AwbbKZhT+bWwUoJK7JfLOEZLq2
YgK/GQQCud3BxEw5S3cJhzSk7y9vE9RJS56reHYbt0IIbT2/ev5+f53DlWVZ
9yvUc4398FNc9Wd+RwNjGnxfTnfrxJXWtLmZj4293A21+ZN3jGmweOt/Fjeu
tKbNy0Vu7OIp02bvMTWmwTDZhue9rclWm68PiTG0ox3taEc72tGOdrSjHe1o
Rzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhH
O9rRjna0ox3taEc72tGOdrSjHe1oRzva0d5w7R+jnrFKuzdtyqc3bR6ya2OV
dm/alE9v2uzer4z9a7emzTSaGqu0c1xz7ghdG8Hq
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0rFKQmEYxvEDXoMIbuEgEUYhNAoFB0w8hxDUUThbkwiuTl2AtYe0tATq
Eri4BA3dQjfQRbgcH/ku4X2R8Pxf/h+c6RkOv7Ns3MtKURRV9XZ6h+8/7uiX
5/k/nDr5C//q6/7K3uruQlPbUdOedj6fJz9vM3ua+l7Uftd1e5pK4vN+t2FP
U6/v8+VmYUwjmrrpvdi77jxpKqoMHSqnmpomD/Ye47amZnHbHtrRjna0ox3t
aEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1o
Rzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oL7h2QXVJUx+DS3tB
u0tBu0tBu0tBu0uaElSXDtrLqUuaElSXNDVp3doL2jmuOLcHHw5wpw==
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0j1qAmEYReEBdyEI2gQU1EKsQjpXIJaKYBGxsopRAhb+YWFpJVPaiY17
CNi4BRshi0gz3vBt4YqEOS9nwOoyI0+hN2z2MlEUZfX86vn7/fMfLkmSZ7/C
cy61H/6IC3/ma7lkTIOtUq5TzbvSmjbXjZyxr7esNvfLmjENni/x9XZ0pTVt
Hr8PxuLTTpuD1caYBtud7nt/4Epr2lzM5sbQjna0ox3taEc72tGOdrSjHe1o
Rzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhH
O9rRjna0ox3taEc72tGOdrSjHe1oR3vKtdeLL8aCdm/alE9v2tyOK8aCdm/a
lE9v2uxOpsaCdm/a/PwYGQvaOS49dweDAcau
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0iFrAnEcxvED34VporIyBBHUYl4UDFa5S4LBIIJRBINBs2Fgtol1DFYG
a2KwCobtRVjOR/5v4Rky7vvje2B6uJNPIRl2klwURXk9Vz3337//4dI0ffQr
POYy++F/ceHPPLfLxjR46b5ce1VXWtPmoF4yFleftPnzNjKmwf24+DV7dqU1
bZ7ea8Y+txVtro87YxqsTbvNVc+V1rTZGsyNoR3taEc72tGOdrSjHe1oRzva
0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rR
jna0ox3taEc72tGOdrSjHe1oRzva0Y72jGv/fi0YC9q9aVM+vWnzsOwbC9q9
aVM+vWlz8bExFrR702YjnhgL2jkuO3cD1KTuJQ==
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0r1Kw2AchfEXehFChIKXURcFN6eiUyFTKA6CZLGDo7M3IN5BpVs3P7BT
RkEhk1OX0KFXkCU96XsLpwTJ8+cJdDq06e8ky6+yQQgh0VPraT9X/+Gapun6
K3Rzvf3hh7j4Mm+SYEyD67d5/f3uSmva/MrPjC2mI23+vkyMafDu+vghHbrS
mjbLj0djq9f79n/fzI1psCiXf9vClda0OTu/NIZ2tKMd7WhHO9rRjna0ox3t
aEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1o
Rzva0Y52tKMd7WhHO9rRjna0ox3taEc72nuuPT0KxqJ2b9qUT2/a/HwaG4va
vWlTPr1ps/p5drbX7k2bt6cXxqJ2juvP7QCEQFy+
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0jFKw3AYxuFALyHt5A1ceoXiJOIkjiF79h7ACs5V6AVEHZylFErp1E4K
Dm66eIgu8Sv/C7h8g/T5+AUyvYTwHNftRd2rqqofzy6e/fvPv72u64y7v1/5
7Xdnw4wmo5MYX0zqjJ7GlzH+Ob9Pav/lD1fvr01GMb5d3H6/zTKK8eXm5eNr
lVGMX8+a6XObUYyfNkfn7SAj2mmnnXbaaaeddtppp5122mmnnXbaaaeddtpp
p5122mmnnXbaaaeddtppp5122mmnnXbaaaeddtppp5122mmnnXbaaaeddtpp
p5122mmn/cC1B8ukYjxYJhXj68ebpIr2pIr2pIr2pIr2pIr2pIp25w7nfgE5
l6R9
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0jFqAlEUBdCB7MIua0mnnWlTWdgKLsAliLUg2FhZBGzEVhAEcQNTCCK4
AEsJTJ78PcwrPJf7Ybr7/3A+B6P+4KOqqk6cZ5zX911aT9M02VfISe7Dy/rw
u5vSmJ7PxuvlpP3GbqyfzoeUxvSxXl0e2/Ybu7G+3i9SGtP19fZ4/rVf2mmn
nXbaaaeddtppp5122mmnnXbaaaeddtppp5122mmnnXbaaaeddtppp5122mmn
nXbaaaeddtppp5122mmnnXbaaaeddtppp5122mmn/c21//S+Ulq0ZzXWt7tN
Sov2rL5+++80pUV7Sot2kffJP9VoGvA=
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0rFKQmEYxvED7mYKGk5GW4surg6CSCAcaLEhKBwEIWh1cmpwcHLxErqE
8hZSr0CHWrwBm1yOz/G7hPclQv8v/w/O9AyH33Xv9b6XiaKorLfXS7+33J9f
kiT/cOrkL/yrVZy3N2/n0sH5lT3tbD4qv4sbe5pa/7zt9lN7mnoaPw5mfXua
ar/E8fDBmEY01bmb2Gs1R5pqVZ/tNW67mvou1+19lWqaWl4U7KEd7WhHO9rR
jna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGO
drSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGO9jPXLqguaWr7XnTo
qN2loN2loN2loN2llGhz5JKmBNUlTQmqS5r6zF7aC9o57nzuAFYwjR0=
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0jFKA1EUhtGB7MLOhaSztrCwSBFwmCJIZESwCIogkhBEDIIgEpLeKgsQ
N5FFZBE245W3AZtbSM7lezDVXwznsG5P6l5VVQfxvuP9fu/+7XVdZ9z9/cpv
335uMvr6WMf46OIoo2Hdj/HV5japGD9uBqdtk1GMT+aPs7f3jGL87LwdX99k
FOODq4fm7iWjGH+6ny4XrxnRTjvttNNOO+2000477bTTTjvttNNOO+200047
7bTTTjvttNNOO+2000477bTTTjvttNNOO+2000477bTTTjvttNNOO+200047
7bTTTjvte649WCYV48EyqRh/Xl8mVbQnVbQnVbQnVbQnVbQnVbQ7tz/3Awp/
JYI=
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0qFPAmEYx/HbSPAn0CQQLczEJkkD8aJJb6abk2YgUR3OzDQZ3GiGC25o
uo1dQxIy/4AzuZEpx/P6NuP9ggy+z763XXmf3Xv7HES9MKoEQVC3Z22Pe8+3
Y4qi+O9P2LXhl/4Z/0O+LptKbtGgW9yHpbPjtuP1tKb03Km6G81ulGzD+93R
/LFdOjtuS8ajEyXbsJgnP9+Zki15e7n+SPuls+PuLtlKyTZcDNOrh8/S2XFb
0ooTJbSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva
0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rR
vufap2cNJa9dLc+Nq5j7kkks9atdzJaMbo+VvHYxr13M3SVZKnntYrbk8PxJ
yWtnmP2ZDQ/XzYk=
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0qFKQ2EYx+ED3oVBOMFmEQ4MDhhtJqMsjbHFwXYBDgS7QYNNwxAMwjAN
LF6Awbg8vACj5eyV7wYsb5A9L78PTvqHw1MPJueDvaqq9uP9xPv9/vq313Wd
cff3K7/95uwwo6vTOsZfl5cZPT7MYnzx3iYV4xdP18PVbUYx/vax/tx8ZxTj
zVG/PR5lFOOz3nh+Ms0oxu8Pmue6zYh22mmnnXbaaaeddtppp5122mmnnXba
aaeddtppp5122mmnnXbaaaeddtppp5122mmnnXbaaaeddtppp5122mmnnXba
aaeddtppp5122mnfce3BMqkYD5ZJxfjdS5NU0Z5U0Z5U0Z5U0Z5U0Z5U0e7c
7twWbqdo1Q==
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0qFKQ2EYx+EDsjqsjsFwwZtY2ZKwYDgwbAsrRmEsniJoOcGgedFrMHgD
a6smo9VuOb7y3cDKG8ael98HJ/3D4blc3ders6qqBvF+4/1/fx/tdV1n3B1+
5bd/3fYy2t30Yny/PM/oY9GP8Z/3q6RifDS9GF8PM4rxSTOftXVGMT7fPNcP
24xifHH3tFy/ZhTjTfPYti8Z0U477bTTTjvttNNOO+2000477bTTTjvttNNO
O+2000477bTTTjvttNNOO+2000477bTTTjvttNNOO+2000477bTTTjvttNNO
O+2000477SeuPVgmFePBMqkY/3wbJ1W0J1W0J1W0J1W0J1W0J1W0O3c69wfm
2xd9
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0zFKw3AYhvFAbyBSxK1CCrlEcAlO7SBoNoVMdQq03QreoEuh0EEJCIIg
SGYLXqBQB0/QxUO4xDf8j/B9SLHPxxPo9BLCr72ivCw6URSd6vnR0/7+5v78
mqbZw6l/f+FbfQwie69Z+8fZ3Z/Ya19pfff1ObWnqcdq+VY/29PUvBo+1Lk9
TaWjYTbJjWlEU8nFrb34/FpT/Wxm7ywtNXWc3Ng7iq809fK0tYd2tKMd7WhH
O9rRjna0ox3taEc72tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc7
2tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72g9cu6C6pKnNuGsv
aHcpaHcpaHcpaHdJU4LqkqYE1SVNCapLmlot3u0F7Rx3OPcLiRPqvA==
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0jFqAlEUhtGBlLqCBAQ3YGEKCQgBwUKYSuyCjWKZRIiNoJC02rkEy6wh
63ERacYbZg1zU3gu34PX/c3pLt6ni7uiKO7j/cb7+1+c+7+rqip562f7mFAM
bUatr0m76WIltp7LUUIx9LJfro5vTRcrsXX4PCcUQ/2HctCZNV2sxNa8XCdE
O+2000477bTTTjvttNNOO+2000477bTTTjvttNNOO+2000477bTTTjvttNNO
O+2000477bTTTjvttNNOO+2000477bTTTjvttNNOO+2037j279deQrX2nGLr
aTxMqNaeU2ztPk4J1dpziq3ZeJVQrd2527krfnb6HQ==
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0iFuAmEUhdFJugtcV4JjAWyABFfFAopuGvyImrqKIugCUFWsAFmLYgU1
w09mB2P6bnpevj8ZeTM5j+vNcv3Qdd2svd/27t+X2BuG4a8nTLzc5dE3/vbr
z3dc59OhLT/ud4m15S/Pq/71Ka62/L2ff30s4qKddtojop122iOinXba60c7
7bTXj3baaY+Idtppj4h22mmvH+20014/2mmnPSLaaac9Itppp71+tNNOe/1o
p532iGinnfaIaKed9vrRTjvt9aOddtojop32adqbnMTa8s+3bWKj9sRG7YmN
2p37P3cDu+1XUQ==
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, PlotRange -> {{0, 250}, {0, 26}}}], 
       Graphics[
        Raster[CompressedData["
1:eJzt0iFLA3EcxvE/d12OY2nNKMJhWZrNrGEga4ZLNrtdZlfwBdjMA4svQHBh
sNWVhRNcXrH8fc7/W3jkkPv++B4sPdyNz2F9M6nzEMJQz7ee9nfzHy7G2PUr
dHO9/fC/uPRnxo8zYxpcL+532ydXWtPm/isztlll2qyKR2MaPMrPq/zSlda0
Obt+NnZ79aDNt5OpMQ3Oi9F7OXalNW1+hoExtKMd7WhHO9rRjna0ox3taEc7
2tGOdrSjHe1oRzva0Y52tKMd7WhHO9rRjna0ox3taEc72tGOdrSjHe1oRzva
0Y52tKMd7WhHO9rRjna0ox3taEc72tHec+3N66mzX+3etCmf3lqcB3fGknZv
2pRPb9p8Ob4wlrR70+YylMaSdo7rz/0AKxB1wg==
         "], {{0, 0}, {250, 26}}, {0, 255}, ColorFunction -> RGBColor], {
        ImageSize -> {250, 26}, 
         PlotRange -> {{0, 250}, {0, 26}}}]}, $CellContext`gs$$ = 
      1, $CellContext`gsel$$ = 1, $CellContext`gdopts$$ = {
      Alignment -> {Left, {Center, Top}}, Frame -> None, ItemSize -> Full, 
       Spacings -> {0, 0}}}, 
      TagBox[
       DynamicModuleBox[{Typeset`var$$ = False}, 
        InterpretationBox[
         StyleBox[
          PaneBox[
           TagBox[GridBox[{
              {
               ItemBox[
                OpenerBox[Dynamic[Typeset`var$$],
                 Enabled->Automatic],
                Alignment->Top,
                StripOnInput->False], 
               ItemBox[
                StyleBox[
                 PaneSelectorBox[{False->
                  PaneBox[
                   StyleBox["\<\"  Indexed\"\>",
                    StripOnInput->False,
                    FontSize->11],
                   ImageSize->{180, 12}], True->
                  TagBox[GridBox[{
                    {
                    PaneBox[
                    StyleBox["\<\"  Indexed\"\>",
                    StripOnInput->False,
                    FontSize->11],
                    ImageSize->{180, 12}]},
                    {
                    PanelBox[
                    TagBox[GridBox[{
                    {
                    PaneBox[
                    DynamicBox[ToBoxes[
                    Column[
                    Map[EventHandler[
                    If[# == $CellContext`gsel$$, 
                    Grid[{{
                    Spacer[10], 
                    Pane[
                    Style[
                    Part[$CellContext`gnames$$, #], Bold], {100, 14}, 
                    Alignment -> {Left, Center}], 
                    Spacer[10]}, {
                    Spacer[10], 
                    Show[
                    Part[$CellContext`glist$$, #], ImageSize -> 100, 
                    ImageMargins -> {{0, 0}, {6, 0}}], 
                    Spacer[10]}}, Background -> RGBColor[0.93, 0.93, 0.95], 
                    Dividers -> {False, {
                    1 -> GrayLevel[0.8], 3 -> 
                    GrayLevel[0.8]}}, $CellContext`gdopts$$], 
                    Grid[{{
                    Spacer[10], 
                    Pane[
                    Part[$CellContext`gnames$$, #], {100, 14}, 
                    Alignment -> {Left, Center}], 
                    Spacer[10]}, {
                    Spacer[10], 
                    Show[
                    Part[$CellContext`glist$$, #], ImageSize -> 100, 
                    ImageMargins -> {{0, 0}, {6, 0}}], 
                    Spacer[10]}}, $CellContext`gdopts$$]], {
                    "MouseClicked" :> ($CellContext`gsel$$ = #)}]& , 
                    Range[$CellContext`gs$$, $CellContext`gs$$ + 4]]], 
                    StandardForm]],
                    ImageSize->{142, All}], 
                    PaneBox[
                    SliderBox[Dynamic[$CellContext`gs$$], {39, 1, 1},
                    Appearance->{"Vertical", Small},
                    ImageSize->Full],
                    Alignment->{Center, Center},
                    ImageSize->{22, 164}]}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxAlignment->{
                    "Columns" -> {Left, Right}, "Rows" -> {{Center}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{All}}, "Rows" -> {{All}}},
                    GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}},
                    RowsEqual->False],
                    "Grid"],
                    Alignment->{Center, Center},
                    
                    BaseStyle->{
                    ImageMargins -> 0, FontSize -> 10, FontFamily -> 
                    "Helvetica", CacheGraphics -> False},
                    FrameMargins->5,
                    ImageSize->{180, All}]},
                    {
                    PanelBox[
                    TagBox[GridBox[{
                    {
                    StyleBox[
                    DynamicBox[ToBoxes[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$], 
                    StandardForm]],
                    StripOnInput->False,
                    FontWeight->Bold]},
                    {
                    DynamicBox[ToBoxes[
                    Show[
                    Part[$CellContext`glist$$, $CellContext`gsel$$], 
                    ImageSize -> 155], StandardForm]]},
                    {
                    DynamicBox[ToBoxes[
                    With[{$CellContext`gap$ = Max[77.5/ReplaceAll[
                    Part[$CellContext`grange$$, $CellContext`gsel$$, 2], 
                    Infinity -> 15], 5]}, 
                    Style[
                    Graphics[{
                    Text[1, {$CellContext`gap$, 0}], 
                    Text[
                    Part[$CellContext`grange$$, $CellContext`gsel$$, 2], {
                    155. - $CellContext`gap$, 0}]}, 
                    PlotRange -> {{0, 155}, All}, ImageSize -> 155], 
                    FontFamily -> "Times"]], StandardForm]]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    Alignment->{Center, Center},
                    
                    BaseStyle->{
                    ImageMargins -> 0, FontSize -> 10, FontFamily -> 
                    "Helvetica", CacheGraphics -> False},
                    FrameMargins->{{0, 0}, {7, 7}},
                    ImageSize->{180, All}]},
                    {
                    TagBox[
                    TooltipBox[
                    DynamicBox[ToBoxes[
                    Button[
                    Style["Insert", 11], 
                    FrontEndExecute[{
                    FrontEnd`NotebookApply[
                    FrontEnd`InputNotebook[], 
                    BoxData[
                    RowBox[{"ColorData", "[", 
                    ToBoxes[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$]], "]"}]],
                     Placeholder]}], ImageSize -> {180, Automatic}], 
                    StandardForm]],
                    InterpretationBox[
                    RowBox[{"\"ColorData[\"", "\[InvisibleSpace]", 
                    DynamicBox[
                    ToBoxes[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$], 
                    StandardForm]], "\[InvisibleSpace]", "\"]\""}], 
                    Row[{"ColorData[", 
                    Dynamic[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$]], "]"}]],
                    
                    ActionDelay->0.3],
                    Annotation[#, 
                    Row[{"ColorData[", 
                    Dynamic[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$]], "]"}], 
                    "Tooltip"]& ]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                   "Column"]}, Dynamic[Typeset`var$$],
                  Alignment->Automatic,
                  ImageMargins->{{0, 10}, {0, 0}},
                  ImageSize->Automatic],
                 Deployed->False,
                 StripOnInput->False],
                Background->Automatic,
                StripOnInput->False]}
             },
             ColumnsEqual->False,
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Top}}, "RowsIndexed" -> {}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
             GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}},
             RowsEqual->False],
            "Grid"],
           BaselinePosition->Automatic,
           DefaultBaseStyle->"OpenerView",
           ImageMargins->0],
          Deployed->True,
          StripOnInput->False],
         OpenerView[{
           Pane[
            Style["  Indexed", 11], {180, 12}], 
           Column[{
             Pane[
              Style["  Indexed", 11], {180, 12}], 
             Panel[
              Grid[{{
                 Pane[
                  Dynamic[
                   Column[
                    Map[EventHandler[
                    If[# == $CellContext`gsel$$, 
                    Grid[{{
                    Spacer[10], 
                    Pane[
                    Style[
                    Part[$CellContext`gnames$$, #], Bold], {100, 14}, 
                    Alignment -> {Left, Center}], 
                    Spacer[10]}, {
                    Spacer[10], 
                    Show[
                    Part[$CellContext`glist$$, #], ImageSize -> 100, 
                    ImageMargins -> {{0, 0}, {6, 0}}], 
                    Spacer[10]}}, Background -> RGBColor[0.93, 0.93, 0.95], 
                    Dividers -> {
                    False, {
                    1 -> GrayLevel[0.8], 3 -> 
                    GrayLevel[0.8]}}, $CellContext`gdopts$$], 
                    Grid[{{
                    Spacer[10], 
                    Pane[
                    Part[$CellContext`gnames$$, #], {100, 14}, 
                    Alignment -> {Left, Center}], 
                    Spacer[10]}, {
                    Spacer[10], 
                    Show[
                    Part[$CellContext`glist$$, #], ImageSize -> 100, 
                    ImageMargins -> {{0, 0}, {6, 0}}], 
                    Spacer[10]}}, $CellContext`gdopts$$]], {
                    "MouseClicked" :> ($CellContext`gsel$$ = #)}]& , 
                    Range[$CellContext`gs$$, $CellContext`gs$$ + 4]]]], 
                  ImageSize -> {142, All}], 
                 Pane[
                  VerticalSlider[
                   Dynamic[$CellContext`gs$$], {39, 1, 1}, Appearance -> 
                   Small, ImageSize -> Full], {22, 164}, 
                  Alignment -> {Center, Center}]}}, 
               Alignment -> {{Left, Right}, Center}, ItemSize -> Full, 
               Spacings -> {0, 0}], Alignment -> {Center, Center}, 
              BaseStyle -> {
               ImageMargins -> 0, FontSize -> 10, FontFamily -> "Helvetica", 
                CacheGraphics -> False}, FrameMargins -> 5, 
              ImageSize -> {180, All}], 
             Panel[
              Column[{
                Style[
                 Dynamic[
                  Part[$CellContext`gnames$$, $CellContext`gsel$$]], Bold], 
                Dynamic[
                 Show[
                  Part[$CellContext`glist$$, $CellContext`gsel$$], ImageSize -> 
                  155]], 
                Dynamic[
                 With[{$CellContext`gap$ = Max[77.5/ReplaceAll[
                    Part[$CellContext`grange$$, $CellContext`gsel$$, 2], 
                    Infinity -> 15], 5]}, 
                  Style[
                   Graphics[{
                    Text[1, {$CellContext`gap$, 0}], 
                    Text[
                    Part[$CellContext`grange$$, $CellContext`gsel$$, 2], {
                    155. - $CellContext`gap$, 0}]}, 
                    PlotRange -> {{0, 155}, All}, ImageSize -> 155], 
                   FontFamily -> "Times"]]]}], Alignment -> {Center, Center}, 
              FrameMargins -> {{0, 0}, {7, 7}}, ImageSize -> {180, All}, 
              BaseStyle -> {
               ImageMargins -> 0, FontSize -> 10, FontFamily -> "Helvetica", 
                CacheGraphics -> False}], 
             Tooltip[
              Dynamic[
               Button[
                Style["Insert", 11], 
                FrontEndExecute[{
                  FrontEnd`NotebookApply[
                   FrontEnd`InputNotebook[], 
                   BoxData[
                    RowBox[{"ColorData", "[", 
                    ToBoxes[
                    Part[$CellContext`gnames$$, $CellContext`gsel$$]], "]"}]],
                    Placeholder]}], ImageSize -> {180, Automatic}]], 
              Row[{"ColorData[", 
                Dynamic[
                 Part[$CellContext`gnames$$, $CellContext`gsel$$]], "]"}], 
              ActionDelay -> 0.3]}]}, False, 
          FrameMargins -> {{0, 10}, {0, 0}}]],
        DynamicModuleValues:>{}],
       Setting[#, {0}]& ],
      DynamicModuleValues:>{}]},
    {""}
   },
   BaseStyle->{
    ImageMargins -> 0, FontSize -> 10, FontFamily -> "Helvetica", 
     CacheGraphics -> False},
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxDividers->{"Columns" -> {{None}}, "Rows" -> {None, None, 
       GrayLevel[0.5], 
       GrayLevel[0.5], 
       GrayLevel[0.5], None, None}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {0, 0, {1}, 0, 0}},
   RowsEqual->False],
  "Column"]],
 CellMargins->{{0, 0}, {0, 0}},
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellHorizontalScrolling->True,
 PageBreakAbove->True,
 PageBreakWithin->False,
 ShowAutoStyles->True,
 LineSpacing->{1.25, 0},
 AutoItalicWords->{},
 ScriptMinSize->9,
 ShowStringCharacters->False,
 FontFamily:>CurrentValue["PanelFontFamily"],
 FontSize:>CurrentValue["PanelFontSize"]]
},
ClosingAutoSave->False,
Editable->False,
Saveable->False,
WindowToolbars->{},
WindowSize->All,
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
WindowFrame->"Palette",
WindowElements->{},
WindowFrameElements->"CloseBox",
WindowFloating->True,
WindowClickSelect->False,
WindowTitle->"Color Schemes",
ScrollingOptions->{"VerticalScrollRange"->Fit},
ShowCellBracket->False,
CellMargins->{{0, 0}, {0, 0}},
Active->True,
Deployed->True,
CellOpen->True,
ShowCellLabel->False,
ShowCellTags->False,
ImageMargins->{{0, 0}, {0, 0}},
MenuPosition->1100,
Magnification->1.,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (March 23, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[588, 22, 356600, 6444, 443, InheritFromParent,
 PageBreakAbove->True,
 PageBreakWithin->False]
}
]
*)

(* End of internal cache information *)

