(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20082,        513]
NotebookOptionsPosition[     19122,        475]
NotebookOutlinePosition[     19957,        510]
CellTagsIndexPosition[     19914,        507]
MenuPosition->1100
WindowFrame->Palette
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Slide", " ", "Show", "    ", 
  TooltipBox[
   ButtonBox[
    RowBox[{
     StyleBox["?",
      FontSize->12], " "}],
    BaseStyle->"PaletteButton",
    ButtonFunction:>(Documentation`HelpLookup[
     "paclet:guide/PresentationsWithMathematica"]& ),
    Evaluator->Automatic,
    ImageSize->Large],
   "Working with Slide Shows"]}]], NotebookDefault,
 CellFrame->{{0, 0}, {1, 0}},
 CellMargins->{{0, 0}, {0, 0}},
 FontFamily->"Helvetica",
 FontSize->14,
 FontWeight->"Bold",
 FontColor->GrayLevel[1],
 Background->RGBColor[0, 0.32549, 0.537255]],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      TooltipBox[
       ButtonBox["\<\"New Template\"\>",
        Appearance->Automatic,
        BaseStyle->"PaletteButton",
        ButtonFrame->"DialogBox",
        ButtonFunction:>(NotebookPut[
          FEPrivate`FrontEndResource[
          "FEExpressions", "SlideshowTemplate"]]& ),
        Evaluator->None,
        Method->"Preemptive"],
       "\"New Slide Show Template\""],
      Annotation[#, "New Slide Show Template", "Tooltip"]& ]},
    {
     TagBox[
      TooltipBox[
       ButtonBox["\<\"New Slide\"\>",
        Appearance->Automatic,
        BaseStyle->"PaletteButton",
        ButtonFrame->"DialogBox",
        ButtonFunction:>((NotebookWrite[
           InputNotebook[], 
           FEPrivate`FrontEndResource[
           "FEExpressions", "SlideshowNavigationCell"], After]; 
         NotebookWrite[
           InputNotebook[], 
           Cell["New Slide", "Section"], After]; NotebookWrite[
           InputNotebook[], 
           FEPrivate`FrontEndResource[
           "FEExpressions", "SlideshowPrevNextCell"], After])& ),
        Evaluator->None,
        Method->"Preemptive"],
       "\"Insert a New Slide\""],
      Annotation[#, "Insert a New Slide", "Tooltip"]& ]},
    {
     TagBox[
      TooltipBox[
       ButtonBox["\<\"Convert Notebook\"\>",
        Appearance->Automatic,
        BaseStyle->"PaletteButton",
        ButtonFrame->"DialogBox",
        ButtonFunction:>CreatePalette[
          
          DynamicModule[{
           FE`Palettes`SlideShow`styles, FE`Palettes`SlideShow`nbO}, 
           FE`Palettes`SlideShow`nbO = InputNotebook[]; 
           FE`Palettes`SlideShow`styles = If[
              ReplaceAll["ModifiedInMemory", 
               NotebookInformation[FE`Palettes`SlideShow`nbO]], 
              Intersection[
               Cases[
                Developer`CellInformation[
                SelectionMove[
                  FE`Palettes`SlideShow`nbO, All, Notebook, AutoScroll -> 
                   False]; FE`Palettes`SlideShow`nbO], ("Style" -> 
                 Pattern[FE`Palettes`x, 
                   Blank[]]) :> FE`Palettes`x, Infinity]], 
              Needs["AuthorTools`"]; Intersection[
                Cases[
                 Apply[Flatten, 
                  FE`Palettes`SlideShow`NotebookFileOutline[
                  FE`Palettes`SlideShow`nbO]], Cell[
                   Blank[Integer], 
                   Pattern[FE`Palettes`SlideShow`b, 
                    BlankNullSequence[]]] :> 
                 Part[{FE`Palettes`SlideShow`b}, 5], Infinity]]]; 
           Clear[FE`Palettes`vars]; Evaluate[
              Map[FE`Palettes`vars, FE`Palettes`SlideShow`styles]] = 
            Array[False& , 
              Length[FE`Palettes`SlideShow`styles]]; Grid[{{
               Style[
               "\n Choose the styles to use:", FontFamily -> "Verdana"]}, {
               Grid[
                ReplaceAll[
                 Partition[
                  Map[Grid[{{
                    Checkbox[
                    Dynamic[
                    FE`Palettes`vars[#]], {False, True}], 
                    Toggler[
                    Dynamic[
                    FE`Palettes`vars[#]], {
                    False -> Style[#, FontColor -> GrayLevel[0.3], FontWeight -> 
                    "Bold"], True -> Style[#, FontWeight -> "Bold"]}]}}]& , 
                   FE`Palettes`SlideShow`styles], 1], {} -> {{Space}}], 
                Alignment -> Left]}, {
               Grid[{{
                  Button[
                  "Convert", 
                   Module[{
                    FE`Palettes`SlideShow`$SlideBreakCell, 
                    FE`Palettes`SlideShow`its, FE`Palettes`SlideShow`nbObj, 
                    FE`Palettes`SlideShow`cellStyles}, 
                    FE`Palettes`SlideShow`nbObj = InputNotebook[]; 
                    FE`Palettes`SlideShow`cellStyles = Flatten[
                    Map[Part[FE`Palettes`SlideShow`styles, #]& , 
                    Position[
                    Map[FE`Palettes`vars, FE`Palettes`SlideShow`styles], 
                    True]]]; 
                    FE`Palettes`SlideShow`$SlideBreakCell = 
                    FrontEndResource[
                    "FEExpressions", "SlideshowNavigationCell"]; 
                    FE`Palettes`SlideShow`its = Map[Length, 
                    Map[MathLink`CallFrontEnd[
                    FrontEnd`CellInformation[
                    NotebookFind[
                    FE`Palettes`SlideShow`nbObj, #, All, CellStyle]]]& , 
                    FE`Palettes`SlideShow`cellStyles]]; 
                    MapThread[(
                    SelectionMove[
                    FE`Palettes`SlideShow`nbObj, Before, Notebook, AutoScroll -> 
                    False]; Do[
                    NotebookFind[
                    FE`Palettes`SlideShow`nbObj, #, Before, CellStyle, 
                    AutoScroll -> False]; 
                    SelectionMove[
                    FE`Palettes`SlideShow`nbObj, Previous, Cell, AutoScroll -> 
                    False]; If[
                    And[Options[
                    NotebookSelection[FE`Palettes`SlideShow`nbObj], 
                    CellTags] =!= $Failed, Cases[{
                    Part[
                    Options[
                    NotebookSelection[FE`Palettes`SlideShow`nbObj], CellTags],
                     1, 2]}, "SlideShowHeader", Infinity] === {
                    "SlideShowHeader"}], 
                    SelectionMove[
                    FE`Palettes`SlideShow`nbObj, Next, Cell, AutoScroll -> 
                    False], 
                    SelectionMove[
                    FE`Palettes`SlideShow`nbObj, After, Cell, AutoScroll -> 
                    False]; NotebookWrite[
                    FE`Palettes`SlideShow`nbObj, 
                    FE`Palettes`SlideShow`$SlideBreakCell, AutoScroll -> 
                    False]; SelectionMove[
                    FE`Palettes`SlideShow`nbObj, Next, Cell, AutoScroll -> 
                    False]], {#2}])& , {
                    FE`Palettes`SlideShow`cellStyles, 
                    FE`Palettes`SlideShow`its}]]; NotebookClose[
                    ButtonNotebook[]]], 
                  Button["Cancel", 
                   NotebookClose[
                    ButtonNotebook[]]]}}]}}, Alignment -> Left]], WindowTitle -> 
          "Notebook->Slideshow", WindowSize -> Fit, 
          WindowMargins -> {{Automatic, 0}, {Automatic, 0}}],
        Evaluator->Automatic,
        Method->"Preemptive"],
       "\"Convert Notebook to Slide Show\""],
      Annotation[#, "Convert Notebook to Slide Show", "Tooltip"]& ]},
    {
     TagBox[
      TooltipBox[
       ButtonBox["\<\"Table of Contents\"\>",
        Appearance->Automatic,
        BaseStyle->"PaletteButton",
        ButtonFrame->"DialogBox",
        ButtonFunction:>CreatePalette[
          Flatten[{
            Cell[
             BoxData[
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "SlideshowPaletteTOCGraphics"]]], "Text", 
             Editable -> False, Selectable -> False, 
             CellFrame -> {{0, 0}, {2, 0}}, ShowCellBracket -> False, 
             CellMargins -> {{4, 0}, {0, 6}}, Active -> False, Evaluatable -> 
             False, CellFrameMargins -> False, ImageMargins -> 0, 
             ImageRegion -> {{0, 1}, {0, 1}}, CellTags -> "ShortTab"], 
            Cell[
             BoxData[
              RowBox[{"Slide", " ", "Show", "    ", 
                TooltipBox[
                 ButtonBox[
                  RowBox[{
                    StyleBox["?", FontSize -> 12], " "}], 
                  ButtonFunction :> (Documentation`HelpLookup[
                   "paclet:guide/PresentationsWithMathematica"]& ), BaseStyle -> 
                  "PaletteButton", Evaluator -> Automatic, ImageSize -> 
                  Large], "Working with Slide Shows"]}]], "PaletteTitle", 
             FontFamily -> "Helvetica", 
             CellMargins -> {{4, 0}, {Inherited, Inherited}}], 
            Cell[
             BoxData[
              GridBox[{{
                 ButtonBox[
                  StyleBox["\[FirstPage]", "SR"], 
                  ButtonFunction :> (FrontEndExecute[{
                    FrontEndToken[
                    FrontEnd`InputNotebook[], "ScrollPageFirst"]}]& ), 
                  ButtonStyle -> "SlideHyperlink"], 
                 ButtonBox[
                  StyleBox["\[LeftPointer]", "SR"], 
                  ButtonFunction :> (FrontEndExecute[{
                    FrontEndToken[
                    FrontEnd`InputNotebook[], "ScrollPagePrevious"]}]& ), 
                  ButtonStyle -> "SlideHyperlink"], 
                 ButtonBox[
                  StyleBox["\[RightPointer]", "SR"], 
                  ButtonFunction :> (FrontEndExecute[{
                    FrontEndToken[
                    FrontEnd`InputNotebook[], "ScrollPageNext"]}]& ), 
                  ButtonStyle -> "SlideHyperlink"], 
                 ButtonBox[
                  StyleBox["\[LastPage]", "SR"], 
                  ButtonFunction :> (FrontEndExecute[{
                    FrontEndToken[
                    FrontEnd`InputNotebook[], "ScrollPageLast"]}]& ), 
                  ButtonStyle -> "SlideHyperlink"]}}, ColumnSpacings -> 0, 
               ColumnWidths -> 2.95]], "Text", 
             CellMargins -> {{0, 0}, {12, 6}}], 
            Apply[Sequence, 
             Map[Cell[
               BoxData[#], "SlideTOC", CellMargins -> 3]& , 
              MapIndexed[RowBox[
                Riffle[{
                  ButtonBox[
                   RowBox[{"Slide", " ", 
                    Apply[ToString, #2]}], ButtonData -> #2, 
                   ButtonFunction :> (FrontEndExecute[{
                    SelectionMove[
                    InputNotebook[], Before, Notebook, AutoScroll -> False], 
                    FEPrivate`Table[
                    NotebookFind[
                    InputNotebook[], "SlideShowNavigationBar", Next, 
                    CellStyle, AutoScroll -> False], #2], 
                    SelectionMove[
                    InputNotebook[], After, Cell]}]& ), ButtonFrame -> None], 
                  
                  Apply[Sequence, #]}, "\n     "]]& , 
               Map[ButtonBox[#, ButtonFunction :> (FrontEndExecute[{
                    NotebookFind[
                    InputNotebook[], #]}]& ), ButtonFrame -> None]& , 
                Map[Map[First, 
                  Cases[#, 
                   Cell[
                    Blank[], "Section", 
                    BlankNullSequence[]], Infinity]]& , 
                 DeleteCases[
                  First[
                   NotebookGet[
                    InputNotebook[]]], 
                  Cell[
                   Blank[], 
                   Except[
                    Alternatives["SlideShowNavigationBar", "Section"]], 
                   BlankNullSequence[]], Infinity]], {-1}]]]]}], 
          WindowClickSelect -> False, WindowFrame -> "Palette", 
          WindowElements -> {"VerticalScrollBar"}, 
          WindowFrameElements -> {"CloseBox", "ResizeArea"}, WindowTitle -> 
          "Contents", Editable -> False, Deletable -> False, ShowCellBracket -> 
          False, WindowSize -> {Fit, Automatic}, 
          WindowMargins -> {{Automatic, 265}, {Automatic, 2}}, Background -> 
          GrayLevel[0.85098], StyleDefinitions -> "HelpBrowser.nb"],
        Evaluator->Automatic,
        Method->"Preemptive"],
       "\"Table of Contents Palette\"",
       ActionDelay->0.7],
      Annotation[#, "Table of Contents Palette", "Tooltip"]& ]}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{10}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}},
   RowsEqual->False],
  "Column"]], "Text",
 CellMargins->{{5, 5}, {4, Inherited}},
 ButtonBoxOptions->{BaseStyle->"PaletteButton"}],

Cell[TextData[StyleBox["View Environment", "SR"]], "Text",
 CellMargins->{{5, Inherited}, {-3, 3}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      TooltipBox[
       ButtonBox["\<\"Normal\"\>",
        Appearance->Automatic,
        BaseStyle->"PaletteButton",
        ButtonFrame->"DialogBox",
        ButtonFunction:>FrontEndExecute[{
           FrontEndToken[
            FrontEnd`InputNotebook[], "ScreenStyleEnvironment", "Brackets", 
            "NotebookDefault"]}],
        Evaluator->None,
        ImageSize->Full,
        Method->"Preemptive"],
       "\"View Normal Environment\""],
      Annotation[#, "View Normal Environment", "Tooltip"]& ]},
    {
     TagBox[
      TooltipBox[
       ButtonBox["\<\"Slide Show\"\>",
        Appearance->Automatic,
        BaseStyle->"PaletteButton",
        ButtonFrame->"DialogBox",
        ButtonFunction:>(FrontEndExecute[{
           FrontEndToken[
            FrontEnd`InputNotebook[], "ScreenStyleEnvironment", "SlideShow", 
            "NotebookDefault"]}]& ),
        Evaluator->None,
        ImageSize->Full,
        Method->"Preemptive"],
       "\"View Slide Show Environment\""],
      Annotation[#, "View Slide Show Environment", "Tooltip"]& ]}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{10}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}},
   RowsEqual->False],
  "Column"]], "Text",
 CellMargins->{{5, 5}, {Inherited, Inherited}}],

Cell[BoxData[
 DynamicModuleBox[{Global`dyn$$ = False}, 
  PaneSelectorBox[{True->
   TagBox[GridBox[{
      {
       InterpretationBox[
        RowBox[{
         OpenerBox[Dynamic[Global`dyn$$],
          BaselinePosition->(Baseline -> Center)], "\[InvisibleSpace]", 
         StyleBox["\<\"Extras...\"\>", "SR",
          StripOnInput->False]}],
        Row[{
          Opener[
           Dynamic[Global`dyn$$], BaselinePosition -> (Baseline -> Center)], 
          Style["Extras...", "SR"]}]]},
      {
       TagBox[
        TooltipBox[
         PopupMenuBox[Dynamic[0, NotebookWrite[
            InputNotebook[], #]& ], {Cell[
          "", "SlideShowNavigationBar", CellTags -> 
           "SlideShowHeader"]->"\<\"Navigation Bar\"\>", {
           Cell["", "SlideShowNavigationBar", CellTags -> "SlideShowHeader"], 
           
           Cell["New Slide", "Section"]}->"\<\"New Slide\"\>", Cell[
           TextData[{
             ButtonBox[
             "\[FilledLeftTriangle]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
              ButtonFrame -> "None", ButtonFunction :> FrontEndExecute[{
                 FrontEndToken[
                  FrontEnd`ButtonNotebook[], "ScrollPagePrevious"]}], 
              ButtonNote -> 
              FEPrivate`FrontEndResource[
               "FEStrings", "SlideshowPrevSlideText"], BaseStyle -> 
              "SlidePreviousNextLink"], 
             "\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]", 
             ButtonBox[
             "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[FilledRightTriangle]", 
              ButtonFrame -> "None", ButtonFunction :> FrontEndExecute[{
                 FrontEndToken[
                  FrontEnd`ButtonNotebook[], "ScrollPageNext"]}], ButtonNote -> 
              FEPrivate`FrontEndResource[
               "FEStrings", "SlideshowNextSlideText"], BaseStyle -> 
              "SlidePreviousNextLink"]}], 
           "PreviousNext"]->"\<\"Previous/Next \"\>"}, "\<\"Paste...\"\>",
          BaseStyle:>{
            CurrentValue["PanelFontSize"]},
          ImageSize->{128, 20}],
         "\" Paste... \"",
         ActionDelay->0.7],
        Annotation[#, " Paste... ", "Tooltip"]& ]},
      {
       TagBox[
        TooltipBox[
         DynamicBox[ToBoxes[
           PopupMenu[
            Dynamic[0, FrontEndExecute[
              FrontEnd`SetOptions[
               FrontEnd`InputNotebook[], StyleDefinitions -> #]]& ], 
            MathLink`CallFrontEnd[
             FrontEnd`Value[
              FEPrivate`GetPopupList["MenuListStyleDefinitions"]]], 
            "Style Sheet...", ImageSize -> {128, 20}, BaseStyle :> {
              CurrentValue["PanelFontSize"]}], StandardForm],
          ImageSizeCache->{128., {6., 14.}}],
         "\" Select style sheet...\"",
         ActionDelay->0.7],
        Annotation[#, " Select style sheet...", "Tooltip"]& ]},
      {
       TagBox[
        TooltipBox[
         PopupMenuBox[Dynamic[0, SetOptions[
            InputNotebook[], WindowSize -> #]& ], {
          Full->"\<\"Full Screen\"\>", {800, 600}->"\<\"800 x 600\"\>", {1024,
           768}->"\<\"1024 x 768\"\>", {1280, 
          960}->"\<\"1280 x 960\"\>"}, "\<\"Presentation Size:\"\>",
          BaseStyle:>{
            CurrentValue["PanelFontSize"]},
          ImageSize->{128, 20}],
         "\" Set Presentation Size\"",
         ActionDelay->0.7],
        Annotation[#, " Set Presentation Size", "Tooltip"]& ]},
      {
       TagBox[
        TooltipBox[
         PopupMenuBox[Dynamic[0, SetOptions[
            InputNotebook[], Magnification -> #]& ], {1->"\<\"100%\"\>", 
          1.25->"\<\"125%\"\>", 
          1.5->"\<\"150%\"\>"}, "\<\"Magnification:\"\>",
          BaseStyle:>{
            CurrentValue["PanelFontSize"]},
          ImageSize->{128, 20}],
         "\" Set Magnification\"",
         ActionDelay->0.7],
        Annotation[#, " Set Magnification", "Tooltip"]& ]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}}],
    "Column"], False->
   InterpretationBox[
    RowBox[{
     OpenerBox[Dynamic[Global`dyn$$],
      BaselinePosition->(Baseline -> Axis)], "\[InvisibleSpace]", 
     StyleBox["\<\"Extras...\"\>", "SR",
      StripOnInput->False]}],
    Row[{
      Opener[
       Dynamic[Global`dyn$$], BaselinePosition -> (Baseline -> Axis)], 
      Style["Extras...", "SR"]}]]}, Dynamic[Global`dyn$$],
   ImageSize->{All, Automatic}],
  DynamicModuleValues:>{}]], "Output",
 ShowCellBracket->False,
 CellMargins->{{5, 0}, {5, 10}}],

Cell[""]
},
ClosingAutoSave->True,
WindowToolbars->{},
WindowSize->FitAll,
WindowMargins->{{Automatic, 29}, {Automatic, 106}},
WindowFrame->"Palette",
WindowElements->{},
WindowFrameElements->"CloseBox",
WindowFloating->True,
WindowClickSelect->False,
WindowTitle->"Create Slide Show",
ScrollingOptions->{"VerticalScrollRange"->Fit},
ShowCellBracket->False,
CellMargins->{{0, 0}, {0, 0}},
Active->True,
Deployed->True,
CellOpen->True,
ShowCellLabel->False,
ShowCellTags->False,
ShowStringCharacters->False,
ImageMargins->{{0, 0}, {0, 0}},
MenuPosition->1100,
Magnification->1.,
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (February 12, 2007)",
StyleDefinitions->"HelpBrowser.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[588, 22, 570, 19, 40, NotebookDefault],
Cell[1161, 43, 11966, 269, 133, "Text"],
Cell[13130, 314, 99, 1, 12, "Text"],
Cell[13232, 317, 1395, 41, 69, "Text"],
Cell[14630, 360, 4477, 111, 31, "Output"],
Cell[19110, 473, 8, 0, 12, InheritFromParent]
}
]
*)

(* End of internal cache information *)
