(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    216263,       6963]
NotebookOptionsPosition[    130150,       4874]
NotebookOutlinePosition[    130760,       4898]
CellTagsIndexPosition[    130672,       4893]
MenuPosition->1100
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[StyleData[StyleDefinitions -> "PublicationDefault.nb"]],

Cell["\<\
Modify the definitions below to change the default appearance of all cells in \
a given style. 
Make modifications to any definition using commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Notebook Options Settings", "Section"],

Cell["\<\
The options defined for the style below will be used at the Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
 ReturnCreatesNewCell->True,
 DefaultNewCellStyle->"Title"]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input and Output Cells", "Section"],

Cell["\<\
The cells in this section define styles used for input and output to the \
kernel.  Be careful when modifying, renaming, or removing these styles, \
because the front end associates special meanings with these style names. \
Some attributes for these styles are actually set in FormatType Styles (in \
the last section of this stylesheet). \
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
 ReturnCreatesNewCell->False,
 MenuPosition->1650,
 MenuCommandKey->"9"],

Cell[StyleData["Input", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Input", "Printout", StyleDefinitions -> None]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InputOnly"],
 ReturnCreatesNewCell->False],

Cell[StyleData["InputOnly", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["InputOnly", "Printout", StyleDefinitions -> None]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Code"],
 ReturnCreatesNewCell->False,
 MenuPosition->1600,
 MenuCommandKey->"8"],

Cell[StyleData["Code", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Code", "Printout", StyleDefinitions -> None]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
 ReturnCreatesNewCell->False,
 MenuPosition->1700],

Cell[StyleData["Output", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Output", "Printout", StyleDefinitions -> None]]
}, Closed]],

Cell[StyleData["CellLabel"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Title and Section Cells", "Section"],

Cell[CellGroupData[{

Cell["Title", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
 CellMargins->{{12, 12}, {4, 36}},
 CellGroupingRules->{"TitleGrouping", 10},
 ConversionRules:>{"TeX" -> {"\n\\title{", Automatic, "}"}},
 PageBreakBelow->False,
 DefaultNewCellStyle->"Author",
 DefaultReturnCreatedCellStyle->"Subtitle",
 TextAlignment->Center,
 LineSpacing->{1, 2},
 MenuPosition->1100,
 FontSize->32,
 FontWeight->"Bold"],

Cell[StyleData["Title", "FlushLeft"],
 CellFrame->{{0, 0}, {2, 0}},
 CellMargins->{{12, 12}, {4, 36}},
 CellFrameMargins->{{0, 0}, {2, 8}},
 TextAlignment->Left,
 LineSpacing->{1, 2},
 FontSize->32,
 FontWeight->"Bold"],

Cell[StyleData["Title", "Presentation"],
 CellFrame->False,
 ShowGroupOpener->False,
 CellMargins->{{12, 12}, {6, 54}},
 FontSize->48,
 FontWeight->"Bold"],

Cell[StyleData["Title", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Title", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Title", "FlushLeftPrintout"],
 CellFrame->{{0, 0}, {1.5, 0}},
 CellMargins->{{2, 2}, {3, 32}},
 TextAlignment->Left,
 FontSize->28,
 FontWeight->"Bold"],

Cell[StyleData["Title", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {3, 32}},
 FontSize->28]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
 CellMargins->{{12, 12}, {4, 2}},
 CellGroupingRules->{"TitleGrouping", 20},
 ConversionRules:>{"TeX" -> {"\n\\subtitle{", Automatic, "}"}},
 PageBreakBelow->False,
 DefaultNewCellStyle->"Author",
 DefaultReturnCreatedCellStyle->"Author",
 TextAlignment->Center,
 LineSpacing->{1, 0},
 MenuPosition->1150,
 FontSize->20,
 FontSlant->"Italic"],

Cell[StyleData["Subtitle", "FlushLeft"],
 CellMargins->{{12, 12}, {4, 2}},
 TextAlignment->Left,
 FontSize->20,
 FontSlant->"Italic"],

Cell[StyleData["Subtitle", "Presentation"],
 CellMargins->{{12, 12}, {6, 3}},
 FontSize->30,
 FontSlant->"Italic"],

Cell[StyleData["Subtitle", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Subtitle", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Subtitle", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {3, 1}},
 TextAlignment->Left,
 FontSize->18,
 FontSlant->"Italic"],

Cell[StyleData["Subtitle", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {3, 1}},
 FontSize->18,
 FontWeight->"Plain",
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Section", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Section"],
 CellFrame->{{0, 0}, {0.5, 0}},
 CellMargins->{{12, 12}, {3, 24}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{
  "TeX" -> {"\n\\section{", Automatic, "}"}, 
   "HTML" -> {"<h3 class=\"Section\">", Automatic, "</h3>"}},
 TaggingRules:>{
  "CounterSettings" -> {"CounterTarget" -> "Cell", "XRefPrefix" -> "Section"},
    "StyleSheetApplicability" -> False},
 PageBreakBelow->False,
 TextAlignment->Center,
 TabSpacings->2.1,
 CounterIncrements->{
  "Section", "SectionHeader", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}, {
   "Subsubsubsection", 0}},
 MenuPosition->1200,
 MenuCommandKey->"1",
 FontSize->20,
 FontWeight->"Bold"],

Cell[StyleData["Section", "FlushLeft"],
 CellMargins->{{12, 12}, {3, 24}},
 TextAlignment->Left,
 ParagraphIndent->-32,
 TabSpacings->2.1,
 CounterIncrements->"Section",
 FontSize->20,
 FontWeight->"Bold"],

Cell[StyleData["Section", "Presentation"],
 CellMargins->{{12, 12}, {5, 36}},
 ParagraphIndent->-48,
 FontSize->30],

Cell[StyleData["Section", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Section", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Section", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 21}},
 TextAlignment->Left,
 ParagraphIndent->0,
 FontSize->18,
 FontWeight->"Bold"],

Cell[StyleData["Section", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 21}},
 ParagraphIndent->-29,
 FontSize->18,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
 CellDingbat->None,
 CellMargins->{{12, 12}, {3, 12}},
 CellElementSpacings->{"ClosedGroupTopMargin"->12},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{
  "TeX" -> {"\n\\subsection{", Automatic, "}"}, 
   "HTML" -> {"<h4 class=\"Subsection\">", Automatic, "</h4>"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"Section", ".", "Subsection"}, "CounterTarget" -> 
     "Cell", "XRefPrefix" -> "Section"}, "StyleSheetApplicability" -> False},
 PageBreakBelow->False,
 TextAlignment->Center,
 TabSpacings->1.7,
 CounterIncrements->{
  "Subsection", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsubsection", 0}, {"Subsubsubsection", 0}},
 MenuPosition->1250,
 MenuCommandKey->"2",
 FontSize->17,
 FontWeight->"Bold"],

Cell[StyleData["Subsection", "FlushLeft"],
 CellMargins->{{12, 12}, {3, 12}},
 CellElementSpacings->{"ClosedGroupTopMargin"->12},
 TextAlignment->Left,
 ParagraphIndent->-50,
 TabSpacings->1.7,
 FontSize->17,
 FontWeight->"Bold"],

Cell[StyleData["Subsection", "Presentation"],
 CellMargins->{{12, 12}, {5, 18}},
 ParagraphIndent->-75,
 FontSize->25],

Cell[StyleData["Subsection", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Subsection", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Subsection", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 10}},
 TextAlignment->Left,
 ParagraphIndent->0,
 FontSize->15,
 FontWeight->"Bold"],

Cell[StyleData["Subsection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 10}},
 ParagraphIndent->-43,
 FontSize->15,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
 CellMargins->{{12, 12}, {3, 6}},
 CellElementSpacings->{"ClosedGroupTopMargin"->12},
 CellGroupingRules->{"SectionGrouping", 50},
 ConversionRules:>{
  "TeX" -> {"\n\\subsubsection{", Automatic, "}"}, 
   "HTML" -> {"<h5 class=\"Subsubsection\">", Automatic, "</h5>"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"Section", ".", "Subsection", ".", "Subsubsection"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Section"}, 
   "StyleSheetApplicability" -> False},
 PageBreakBelow->False,
 TextAlignment->Center,
 CounterIncrements->{
  "Subsubsection", "SubsubsectionHeader", "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsubsubsection", 0}},
 MenuPosition->1300,
 MenuCommandKey->"3",
 FontSize->14,
 FontWeight->"Bold",
 FontColor->GrayLevel[0.333333],
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Subsubsection", "FlushLeft"],
 CellMargins->{{12, 12}, {3, 6}},
 CellElementSpacings->{"ClosedGroupTopMargin"->12},
 TextAlignment->Left,
 ParagraphIndent->-60,
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Presentation"],
 CellMargins->{{12, 12}, {5, 9}},
 ParagraphIndent->-90,
 FontSize->21],

Cell[StyleData["Subsubsection", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Subsubsection", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Subsubsection", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextAlignment->Left,
 ParagraphIndent->0,
 FontSize->12,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]],

Cell[StyleData["Subsubsection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 5}},
 ParagraphIndent->-50,
 FontSize->12,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsubsection"],
 CellMargins->{{12, 12}, {3, 6}},
 CellGroupingRules->{"SectionGrouping", 60},
 ConversionRules:>{
  "TeX" -> {"\n\\subsubsubsection{", Automatic, "}"}, 
   "HTML" -> {"<h6 class=\"Subsubsubsection\">", "</h6>"}},
 CounterIncrements->{"Subsubsubsection", "SubsubsubsectionHeader"},
 MenuPosition->1350,
 MenuCommandKey->"4",
 FontSize->14,
 FontWeight->"Bold",
 FontSlant->"Italic",
 FontColor->GrayLevel[0.333333]],

Cell[StyleData["Subsubsubsection", "FlushLeft"]],

Cell[StyleData["Subsubsubsection", "Presentation"],
 CellMargins->{{23, 12}, {5, 9}},
 FontSize->21],

Cell[StyleData["Subsubsubsection", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Subsubsubsection", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Subsubsubsection", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 5}},
 FontSize->12,
 FontColor->GrayLevel[0]],

Cell[StyleData["Subsubsubsection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 5}},
 FontSize->12,
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell["Standard", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
 CellMargins->{{18, 10}, {3, 5}},
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TextAlignment->Left,
 TextJustification->1,
 LineSpacing->{1, 3},
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}},
 MenuPosition->1500,
 MenuCommandKey->"7"],

Cell[StyleData["Text", "FlushLeft"]],

Cell[StyleData["Text", "Presentation"],
 CellMargins->{{23, 10}, {5, 8}},
 FontSize->17],

Cell[StyleData["Text", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Text", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Text", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10],

Cell[StyleData["Text", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Styles for Publication\[Hyphen]ready Documents\
\>", "Section"],

Cell[CellGroupData[{

Cell["Styles for Title and Section Cells", "Subsection"],

Cell[CellGroupData[{

Cell["Section", "Subsubsection"],

Cell[CellGroupData[{

Cell["Special Section", "Subsubsubsection"],

Cell[CellGroupData[{

Cell["Section Heading Inline Cells", "Subsubsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["SectionLabel"],
 Editable->False,
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{32, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["SectionLabel", "FlushLeft"],
 CellSize->{32, Inherited},
 TextAlignment->Left],

Cell[StyleData["SectionLabel", "Presentation"],
 CellSize->{48, Inherited}],

Cell[StyleData["SectionLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["SectionLabel", "FlushLeftPrintout"],
 CellSize->{29, Inherited},
 TextAlignment->Left],

Cell[StyleData["SectionLabel", "DoubleSpacedPrintout"],
 CellSize->{29, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsectionLabel"],
 Editable->False,
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{50, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["SubsectionLabel", "FlushLeft"],
 CellSize->{50, Inherited},
 TextAlignment->Left],

Cell[StyleData["SubsectionLabel", "Presentation"],
 CellSize->{75, Inherited}],

Cell[StyleData["SubsectionLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["SubsectionLabel", "FlushLeftPrintout"],
 CellSize->{43, Inherited},
 TextAlignment->Left],

Cell[StyleData["SubsectionLabel", "DoubleSpacedPrintout"],
 CellSize->{43, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsubsectionLabel"],
 Editable->False,
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{60, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["SubsubsectionLabel", "FlushLeft"],
 CellSize->{60, Inherited},
 TextAlignment->Left],

Cell[StyleData["SubsubsectionLabel", "Presentation"],
 CellSize->{90, Inherited}],

Cell[StyleData["SubsubsectionLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["SubsubsectionLabel", "FlushLeftPrintout"],
 CellSize->{50, Inherited},
 TextAlignment->Left],

Cell[StyleData["SubsubsectionLabel", "DoubleSpacedPrintout"],
 CellSize->{50, Inherited}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Alternate Headings", "Subsubsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["SectionAlt"],
 CellMargins->{{12, 12}, {3, 24}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{
  "TeX" -> {"\n\\section*{", Automatic, "}"}, 
   "HTML" -> {"<h3 class=\"Section\">", Automatic, "</h3>"}},
 PageBreakBelow->False,
 TextAlignment->Center,
 TabSpacings->2.1,
 StyleMenuListing->None,
 FontSize->20,
 FontWeight->"Bold"],

Cell[StyleData["SectionAlt", "FlushLeft"],
 CellMargins->{{12, 12}, {3, 24}},
 TextAlignment->Left,
 TabSpacings->2.1,
 FontSize->20,
 FontWeight->"Bold"],

Cell[StyleData["SectionAlt", "Presentation"],
 CellMargins->{{12, 12}, {5, 36}},
 FontSize->30],

Cell[StyleData["SectionAlt", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["SectionAlt", "Printout", StyleDefinitions -> None]],

Cell[StyleData["SectionAlt", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 21}},
 TextAlignment->Left,
 FontSize->18,
 FontWeight->"Bold"],

Cell[StyleData["SectionAlt", "DoubleSpacedPrintout"],
 CellMargins->{{2, 12}, {3, 18}},
 FontSize->18,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsectionAlt"],
 CellDingbat->None,
 CellMargins->{{12, 12}, {3, 12}},
 CellElementSpacings->{"ClosedGroupTopMargin"->12},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{
  "TeX" -> {"\n\\subsection*{", Automatic, "}"}, 
   "HTML" -> {"<h4 class=\"Subsection\">", Automatic, "</h4>"}},
 PageBreakBelow->False,
 TextAlignment->Center,
 TabSpacings->1.7,
 StyleMenuListing->None,
 FontSize->17,
 FontWeight->"Bold"],

Cell[StyleData["SubsectionAlt", "FlushLeft"],
 CellMargins->{{12, 12}, {3, 12}},
 CellElementSpacings->{"ClosedGroupTopMargin"->12},
 TextAlignment->Left,
 TabSpacings->1.7,
 FontSize->17,
 FontWeight->"Bold"],

Cell[StyleData["SubsectionAlt", "Presentation"],
 CellMargins->{{12, 12}, {5, 18}},
 FontSize->25],

Cell[StyleData["SubsectionAlt", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["SubsectionAlt", "Printout", StyleDefinitions -> None]],

Cell[StyleData["SubsectionAlt", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 10}},
 TextAlignment->Left,
 FontSize->15,
 FontWeight->"Bold"],

Cell[StyleData["SubsectionAlt", "DoubleSpacedPrintout"],
 CellMargins->{{2, 12}, {2, 5}},
 FontSize->15,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsubsectionAlt"],
 CellMargins->{{12, 12}, {3, 6}},
 CellElementSpacings->{"ClosedGroupTopMargin"->12},
 CellGroupingRules->{"SectionGrouping", 50},
 ConversionRules:>{
  "TeX" -> {"\n\\subsubsection*{", Automatic, "}"}, 
   "HTML" -> {"<h5 class=\"Subsubsection\">", Automatic, "</h5>"}},
 PageBreakBelow->False,
 TextAlignment->Center,
 StyleMenuListing->None,
 FontSize->14,
 FontWeight->"Bold",
 FontColor->GrayLevel[0.333333],
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["SubsubsectionAlt", "FlushLeft"],
 CellMargins->{{12, 12}, {3, 6}},
 CellElementSpacings->{"ClosedGroupTopMargin"->12},
 TextAlignment->Left,
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["SubsubsectionAlt", "Presentation"],
 CellMargins->{{12, 12}, {5, 9}},
 FontSize->21],

Cell[StyleData["SubsubsectionAlt", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["SubsubsectionAlt", "Printout", StyleDefinitions -> None]],

Cell[StyleData["SubsubsectionAlt", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextAlignment->Left,
 FontSize->12,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]],

Cell[StyleData["SubsubsectionAlt", "DoubleSpacedPrintout"],
 CellMargins->{{2, 12}, {1, 4}},
 FontSize->12,
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Subsection"],

Cell[CellGroupData[{

Cell["Standard", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TextNoIndent"],
 CellMargins->{{18, 10}, {3, 5}},
 ConversionRules:>{
  "TeX" -> {{"\\noindent ", Automatic, ""}, {
     "\n\n\\noindent ", Automatic, ""}}},
 TaggingRules:>{"CounterSettings" -> {"CounterTarget" -> "CellGroup"}},
 TextAlignment->Left,
 TextJustification->1,
 LineSpacing->{1, 3},
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}},
 StyleMenuListing->None],

Cell[StyleData["TextNoIndent", "FlushLeft"]],

Cell[StyleData["TextNoIndent", "Presentation"],
 CellMargins->{{23, 10}, {5, 8}},
 FontSize->17],

Cell[StyleData["TextNoIndent", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TextNoIndent", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TextNoIndent", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10],

Cell[StyleData["TextNoIndent", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextContinuation"],
 CellMargins->{{18, 10}, {3, 5}},
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n", Automatic, ""}}},
 TaggingRules:>{"CounterSettings" -> {"CounterTarget" -> "CellGroup"}},
 TextAlignment->Left,
 TextJustification->1,
 LineSpacing->{1, 3},
 CounterIncrements->"TextContinuation",
 CounterAssignments->{{"Item1Numbered", 0}},
 StyleMenuListing->None],

Cell[StyleData["TextContinuation", "FlushLeft"]],

Cell[StyleData["TextContinuation", "Presentation"],
 CellMargins->{{23, 10}, {5, 8}},
 FontSize->17],

Cell[StyleData["TextContinuation", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TextContinuation", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10],

Cell[StyleData["TextContinuation", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Display", "Subsubsection"],

Cell[CellGroupData[{

Cell["Lists", "Subsubsubsection"],

Cell[CellGroupData[{

Cell["Bulleted", "Subsubsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Item1"],
 CellDingbat->Cell["\[FilledSmallCircle]"],
 CellMargins->{{42, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 30}, 
     "TeX" -> {"CellGroupEnvironment" -> "itemize"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ul"}}},
 CellFrameLabels->{{None, None}, {None, None}},
 CounterIncrements->"Item1",
 MenuPosition->1710],

Cell[StyleData["Item1", "FlushLeft"]],

Cell[StyleData["Item1", "Presentation"],
 CellMargins->{{21, 12}, {2, 3}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item1", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Item1", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Item1", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item1", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 LineSpacing->{2, 1},
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2"],
 CellDingbat->Cell["\[FilledSmallCircle]"],
 CellMargins->{{66, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 40}, 
     "TeX" -> {"CellGroupEnvironment" -> "itemize"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ul"}}},
 CellFrameLabels->{{None, None}, {None, None}},
 CounterIncrements->"Item2",
 MenuPosition->1720],

Cell[StyleData["Item2", "FlushLeft"]],

Cell[StyleData["Item2", "Presentation"],
 CellMargins->{{59, 12}, {2, 3}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item2", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Item2", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Item2", "FlushLeftPrintout"],
 CellMargins->{{20, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item2", "DoubleSpacedPrintout"],
 CellMargins->{{20, 2}, {1, 1}},
 LineSpacing->{2, 1},
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3"],
 CellDingbat->Cell["\[FilledSmallCircle]"],
 CellMargins->{{90, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 50}, 
     "TeX" -> {"CellGroupEnvironment" -> "itemize"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ul"}}},
 CellFrameMargins->0,
 CellFrameLabels->{{None, None}, {None, None}},
 CounterIncrements->"Item3",
 MenuPosition->1730],

Cell[StyleData["Item3", "FlushLeft"]],

Cell[StyleData["Item3", "Presentation"],
 CellMargins->{{95, 12}, {2, 3}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item3", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Item3", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Item3", "FlushLeftPrintout"],
 CellMargins->{{40, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item3", "DoubleSpacedPrintout"],
 CellMargins->{{40, 2}, {1, 1}},
 LineSpacing->{2, 1},
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item1Label"],
 ConversionRules:>{{"TeX" -> {"", 
      NoOutput[], ""}}, {"HTML" -> {"", 
      NoOutput[], ""}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Plain"],

Cell[StyleData["Item1Label", "FlushLeft"]],

Cell[StyleData["Item1Label", "Presentation"],
 CellSize->{36, Inherited},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item1Label", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Item1Label", "FlushLeftPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item1Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Label"],
 ConversionRules:>{{"TeX" -> {"", 
      NoOutput[], ""}}, {"HTML" -> {"", 
      NoOutput[], ""}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["Item2Label", "FlushLeft"]],

Cell[StyleData["Item2Label", "Presentation"],
 CellSize->{36, Inherited},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item2Label", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Item2Label", "FlushLeftPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None],

Cell[StyleData["Item2Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Label"],
 ConversionRules:>{{"TeX" -> {"", 
      NoOutput[], ""}}, {"HTML" -> {"", 
      NoOutput[], ""}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["Item3Label", "FlushLeft"]],

Cell[StyleData["Item3Label", "Presentation"],
 CellSize->{36, Inherited},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item3Label", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Item3Label", "FlushLeftPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None],

Cell[StyleData["Item3Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numbered Lists", "Subsubsubsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Item1Numbered"],
 CellDingbat->Cell[
   TextData[{
     CounterBox["Item1Numbered"], "."}], FontWeight -> "Bold"],
 CellMargins->{{42, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 30}, 
     "TeX" -> {"CellGroupEnvironment" -> "enumerate"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ol"}}},
 CellFrameLabels->{{None, None}, {None, None}},
 CounterIncrements->"Item1Numbered",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}},
 MenuPosition->1740],

Cell[StyleData["Item1Numbered", "FlushLeft"]],

Cell[StyleData["Item1Numbered", "Presentation"],
 CellMargins->{{23, 12}, {2, 3}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item1Numbered", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Item1Numbered", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Item1Numbered", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item1Numbered", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 LineSpacing->{2, 1},
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Numbered"],
 CellDingbat->Cell[
   TextData[{
     CounterBox["Item2Numbered"], "."}], FontWeight -> "Bold"],
 CellMargins->{{66, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 40}, 
     "TeX" -> {"CellGroupEnvironment" -> "enumerate"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ol"}}},
 CellFrameLabels->{{None, None}, {None, None}},
 CounterIncrements->"Item2Numbered",
 MenuPosition->1750,
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["a", "z"], #]& )}],

Cell[StyleData["Item2Numbered", "FlushLeft"]],

Cell[StyleData["Item2Numbered", "Presentation"],
 CellMargins->{{59, 12}, {2, 2}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item2Numbered", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Item2Numbered", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Item2Numbered", "FlushLeftPrintout"],
 CellMargins->{{20, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item2Numbered", "DoubleSpacedPrintout"],
 CellMargins->{{20, 2}, {1, 1}},
 LineSpacing->{2, 1},
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Numbered"],
 CellDingbat->Cell[
   TextData[{
     CounterBox["Item3Numbered"], "."}], FontWeight -> "Bold"],
 CellMargins->{{90, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 50}, 
     "TeX" -> {"CellGroupEnvironment" -> "enumerate"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ol"}}},
 CellFrameLabels->{{None, None}, {None, None}},
 CounterIncrements->"Item3Numbered",
 MenuPosition->1760,
 CounterBoxOptions->{CounterFunction:>RomanNumeral}],

Cell[StyleData["Item3Numbered", "FlushLeft"]],

Cell[StyleData["Item3Numbered", "Presentation"],
 CellMargins->{{95, 12}, {2, 3}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item3Numbered", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Item3Numbered", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Item3Numbered", "FlushLeftPrintout"],
 CellMargins->{{40, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item3Numbered", "DoubleSpacedPrintout"],
 CellMargins->{{40, 2}, {1, 1}},
 LineSpacing->{2, 1},
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item1NumberedLabel"],
 ConversionRules:>{{"TeX" -> {"", 
      NoOutput[], ""}}, {"HTML" -> {"<!--", "-->"}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["Item1NumberedLabel", "FlushLeft"]],

Cell[StyleData["Item1NumberedLabel", "Presentation"],
 CellSize->{36, Inherited},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item1NumberedLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Item1NumberedLabel", "FlushLeftPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item1NumberedLabel", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2NumberedLabel"],
 ConversionRules:>{{"TeX" -> {"", 
      NoOutput[], ""}}, {"HTML" -> {"<!--", "-->"}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["Item2NumberedLabel", "FlushLeft"]],

Cell[StyleData["Item2NumberedLabel", "Presentation"],
 CellSize->{36, Inherited},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item2NumberedLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Item2NumberedLabel", "FlushLeftPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None],

Cell[StyleData["Item2NumberedLabel", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3NumberedLabel"],
 ConversionRules:>{{"TeX" -> {"", 
      NoOutput[], ""}}, {"HTML" -> {"<!--", "-->"}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["Item3NumberedLabel", "FlushLeft"]],

Cell[StyleData["Item3NumberedLabel", "Presentation"],
 CellSize->{36, Inherited},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item3NumberedLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Item3NumberedLabel", "FlushLeftPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None],

Cell[StyleData["Item3NumberedLabel", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Continuation Paragraphs", "Subsubsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Item1Paragraph"],
 CellMargins->{{42, 12}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {"General" -> {"RestartList" -> False}}},
 MenuPosition->1770],

Cell[StyleData["Item1Paragraph", "FlushLeft"]],

Cell[StyleData["Item1Paragraph", "Presentation"],
 CellMargins->{{23, 12}, {2, 2}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item1Paragraph", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Item1Paragraph", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Item1Paragraph", "FlushLeftPrintout"],
 CellMargins->{{24, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item1Paragraph", "DoubleSpacedPrintout"],
 CellMargins->{{24, 2}, {1, 1}},
 LineSpacing->{2, 1},
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Paragraph"],
 CellMargins->{{66, 12}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {"General" -> {"RestartList" -> False}}},
 MenuPosition->1780],

Cell[StyleData["Item2Paragraph", "FlushLeft"]],

Cell[StyleData["Item2Paragraph", "Presentation"],
 CellMargins->{{59, 12}, {2, 2}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item2Paragraph", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Item2Paragraph", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Item2Paragraph", "FlushLeftPrintout"],
 CellMargins->{{42, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item2Paragraph", "DoubleSpacedPrintout"],
 CellMargins->{{42, 2}, {1, 1}},
 LineSpacing->{2, 1},
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Paragraph"],
 CellMargins->{{90, 12}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {"General" -> {"RestartList" -> False}}},
 MenuPosition->1790],

Cell[StyleData["Item3Paragraph", "FlushLeft"]],

Cell[StyleData["Item3Paragraph", "Presentation"],
 CellMargins->{{95, 12}, {2, 2}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item3Paragraph", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Item3Paragraph", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Item3Paragraph", "FlushLeftPrintout"],
 CellMargins->{{62, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item3Paragraph", "DoubleSpacedPrintout"],
 CellMargins->{{62, 2}, {1, 1}},
 LineSpacing->{2, 1},
 StyleMenuListing->None,
 FontSize->10]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Mathematics", "Subsection"],

Cell[CellGroupData[{

Cell["Equations", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Equation"],
 CellMargins->{{60, 12}, {7, 7}},
 ConversionRules:>{"HTML" -> {{"", ""}, {"<p class=\"Equation\">", "</p>"}}},
 CellHorizontalScrolling->True,
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 DefaultFormatType->TraditionalForm,
 InputAutoReplacements->{},
 TextAlignment->Center,
 CounterIncrements->"Equation",
 MenuPosition->1400,
 MenuCommandKey->"5",
 FontFamily->"Times",
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["Equation", "FlushLeft"],
 CellMargins->{{36, 12}, {7, 7}},
 TextAlignment->Left],

Cell[StyleData["Equation", "Presentation"],
 CellMargins->{{72, 12}, {11, 11}},
 FontSize->19],

Cell[StyleData["Equation", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Equation", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Equation", "FlushLeftPrintout"],
 CellMargins->{{21, 2}, {5, 5}},
 TextAlignment->Left,
 FontSize->10],

Cell[StyleData["Equation", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {5, 5}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroup"],
 CellMargins->{{12, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 1, "Numbered" -> False}, 
     "TeX" -> {"CellGroupEnvironment" -> "gather*"}}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 StyleMenuListing->None,
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["EquationGroup", "FlushLeft"],
 CellMargins->{{36, 12}, {0, 2}},
 TextAlignment->Left],

Cell[StyleData["EquationGroup", "Presentation"],
 CellMargins->{{22, 12}, {0, 3}},
 FontSize->19],

Cell[StyleData["EquationGroup", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["EquationGroup", "Printout", StyleDefinitions -> None]],

Cell[StyleData["EquationGroup", "FlushLeftPrintout"],
 CellMargins->{{21, 2}, {0, 1}},
 TextAlignment->Left,
 FontSize->10],

Cell[StyleData["EquationGroup", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroupAligned"],
 CellMargins->{{12, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 1, "Numbered" -> False}, 
     "TeX" -> {"CellGroupEnvironment" -> "align*"}}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 StyleMenuListing->None,
 ButtonBoxOptions->{ButtonFrame->"None"},
 UnderoverscriptBoxOptions->{LimitsPositioning->False},
 UnderscriptBoxOptions->{LimitsPositioning->False},
 OverscriptBoxOptions->{LimitsPositioning->False},
 GridBoxOptions->{AllowScriptLevelChange->False}],

Cell[StyleData["EquationGroupAligned", "FlushLeft"],
 CellMargins->{{12, 6}, {0, 2}},
 TextAlignment->Left],

Cell[StyleData["EquationGroupAligned", "Presentation"],
 CellMargins->{{22, 12}, {0, 3}},
 FontSize->19],

Cell[StyleData["EquationGroupAligned", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["EquationGroupAligned", "Printout", StyleDefinitions -> None]],

Cell[StyleData["EquationGroupAligned", "FlushLeftPrintout"],
 CellMargins->{{21, 2}, {0, 1}},
 TextAlignment->Left,
 FontSize->10],

Cell[StyleData["EquationGroupAligned", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 1}},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numbered Equations", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["EquationNumbered"],
 CellMargins->{{60, 12}, {7, 7}},
 ConversionRules:>{
  "HTML" -> {{"", ""}, {
     "<table class='EquationNumbered'><tr><td>", Automatic, 
      IncludeCount[
      "</td><td class='EquationNumberedLabel'>(`1`)</td></tr></table>", 
       "EquationNumbered"]}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"EquationNumbered"}, "CounterTarget" -> "Cell", 
     "XRefPrefix" -> "Equation"}},
 CellHorizontalScrolling->True,
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["EquationNumbered"], ")"}], "EquationNumber"]}, {
   None, None}},
 DefaultFormatType->TraditionalForm,
 InputAutoReplacements->{},
 TextAlignment->Center,
 CounterIncrements->"EquationNumbered",
 MenuPosition->1450,
 MenuCommandKey->"6",
 StyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["EquationNumbered", "FlushLeft"],
 CellMargins->{{36, 12}, {7, 7}},
 TextAlignment->Left],

Cell[StyleData["EquationNumbered", "Presentation"],
 CellMargins->{{72, 12}, {11, 11}},
 FontSize->19],

Cell[StyleData["EquationNumbered", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["EquationNumbered", "Printout", StyleDefinitions -> None]],

Cell[StyleData["EquationNumbered", "FlushLeftPrintout"],
 CellMargins->{{21, 6}, {5, 5}},
 TextAlignment->Left,
 FontSize->10],

Cell[StyleData["EquationNumbered", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {5, 5}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroupNumbered"],
 CellMargins->{{12, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{
  "HTML" -> {{"", ""}, {
     "<table class='EquationGroupNumbered'><tr><td>", Automatic, 
      IncludeCount[
      "</td><td class='EquationGroupNumberedLabel'>(`1`)</td></tr></table>", 
       "EquationNumbered"]}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"EquationNumbered"}, "CounterTarget" -> "Cell", 
     "XRefPrefix" -> "Equation"}, 
   "ExtraConversionRules" -> {
    "General" -> {"Numbered" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> "gather"}}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["EquationNumbered"], ")"}], "EquationNumber"]}, {
   None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 CounterIncrements->"EquationNumbered",
 StyleMenuListing->None,
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["EquationGroupNumbered", "FlushLeft"],
 CellMargins->{{36, 6}, {0, 2}},
 TextAlignment->Left],

Cell[StyleData["EquationGroupNumbered", "Presentation"],
 CellMargins->{{22, 12}, {0, 3}},
 FontSize->19],

Cell[StyleData["EquationGroupNumbered", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["EquationGroupNumbered", "Printout", StyleDefinitions -> None]],

Cell[StyleData["EquationGroupNumbered", "FlushLeftPrintout"],
 CellMargins->{{21, 6}, {0, 1}},
 TextAlignment->Left,
 FontSize->10],

Cell[StyleData["EquationGroupNumbered", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroupAlignedNumbered"],
 CellMargins->{{12, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{
  "HTML" -> {{"", ""}, {
     "<table class='EquationGroupAlignedNumbered'><tr><td>", Automatic, 
      IncludeCount[
      "</td><td \
class='EquationGroupAlignedNumberedLabel'>(`1`)</td></tr></table>", 
       "EquationNumbered"]}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"EquationNumbered"}, "CounterTarget" -> "Cell", 
     "XRefPrefix" -> "Equation"}, 
   "ExtraConversionRules" -> {
    "General" -> {"Numbered" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> "align"}}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["EquationNumbered"], ")"}], "EquationNumber"]}, {
   None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 CounterIncrements->"EquationNumbered",
 StyleMenuListing->None,
 ButtonBoxOptions->{ButtonFrame->"None"},
 UnderoverscriptBoxOptions->{LimitsPositioning->False},
 UnderscriptBoxOptions->{LimitsPositioning->False},
 OverscriptBoxOptions->{LimitsPositioning->False},
 GridBoxOptions->{AllowScriptLevelChange->False}],

Cell[StyleData["EquationGroupAlignedNumbered", "FlushLeft"],
 CellMargins->{{12, 6}, {0, 2}},
 TextAlignment->Left],

Cell[StyleData["EquationGroupAlignedNumbered", "Presentation"],
 CellMargins->{{22, 12}, {0, 3}},
 FontSize->19],

Cell[StyleData["EquationGroupAlignedNumbered", "Condensed", StyleDefinitions -> \
None]],

Cell[StyleData["EquationGroupAlignedNumbered", "Printout", StyleDefinitions -> \
None]],

Cell[StyleData["EquationGroupAlignedNumbered", "FlushLeftPrintout"],
 CellMargins->{{21, 6}, {0, 1}},
 TextAlignment->Left,
 FontSize->10],

Cell[StyleData["EquationGroupAlignedNumbered", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationNumber"],
 CellSize->{27, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["EquationNumber", "FlushLeft"],
 CellSize->{27, Inherited}],

Cell[StyleData["EquationNumber", "Presentation"],
 CellSize->{40, Inherited}],

Cell[StyleData["EquationNumber", "Printout", StyleDefinitions -> None]],

Cell[StyleData["EquationNumber", "FlushLeftPrintout"],
 CellSize->{24, Inherited}],

Cell[StyleData["EquationNumber", "DoubleSpacedPrintout"],
 CellSize->{24, Inherited}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Equation Grid Tag Styles", "Subsubsection"],

Cell[StyleData["EquationGrid"],
 StyleMenuListing->None],

Cell[StyleData["SplitEquation"],
 StyleMenuListing->None],

Cell[StyleData["Piecewise"],
 StyleMenuListing->None],

Cell[StyleData["Matrix"],
 StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Illustrations and Examples", "Subsection"],

Cell[CellGroupData[{

Cell["Figure", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Figure"],
 Editable->True,
 CellMargins->{{12, 12}, {8, 6}},
 CellGroupingRules->"InputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\begin{center}", 
     ExtractFigure[], "\n\\end{center}"}},
 TaggingRules:>{
  "CounterSettings" -> {"CounterTarget" -> "Style:FigureCaption"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90, "AlwaysStartEnvironment" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 PageBreakAbove->False,
 DefaultReturnCreatedCellStyle->"FigureCaption",
 TextAlignment->Center,
 Hyphenation->True,
 CounterIncrements->"Figure",
 MenuPosition->1800,
 FontFamily->"Helvetica",
 FontSize->9],

Cell[StyleData["Figure", "FlushLeft"],
 TextAlignment->Left],

Cell[StyleData["Figure", "Presentation"],
 CellMargins->{{12, Inherited}, {12, 9}},
 FontSize->13,
 Magnification->1.5],

Cell[StyleData["Figure", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Figure", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Figure", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {6, 4}},
 TextAlignment->Left,
 Magnification->0.8],

Cell[StyleData["Figure", "DoubleSpacedPrintout"],
 CellMargins->{{2, Inherited}, {6, 4}},
 Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FigureCaption"],
 CellMargins->{{48, 48}, {6, 2}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\\caption{", "}\n"}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"Figure"}, "CounterTarget" -> "Cell", "XRefPrefix" -> 
     "Figure"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 PageBreakAbove->False,
 TextAlignment->Center,
 Hyphenation->True,
 CounterIncrements->"FigureCaption",
 CounterAssignments->{{"Nil", 0}},
 MenuPosition->1810,
 FontFamily->"Helvetica",
 FontSize->9],

Cell[StyleData["FigureCaption", "FlushLeft"],
 CellMargins->{{12, 12}, {6, 2}},
 TextAlignment->Left],

Cell[StyleData["FigureCaption", "Presentation"],
 CellMargins->{{48, 48}, {9, 3}},
 FontSize->13],

Cell[StyleData["FigureCaption", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["FigureCaption", "Printout", StyleDefinitions -> None]],

Cell[StyleData["FigureCaption", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {4, 1}},
 TextAlignment->Left,
 FontSize->7],

Cell[StyleData["FigureCaption", "DoubleSpacedPrintout"],
 CellMargins->{{42, 42}, {4, 1}},
 LineSpacing->{2, 1},
 FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FigureCaptionLabel"],
 Editable->False,
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 TextAlignment->Left,
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["FigureCaptionLabel", "Printout", StyleDefinitions -> None]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Picture", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Picture"],
 Editable->False,
 CellMargins->{{12, 12}, {8, 6}},
 CellGroupingRules->"InputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\begin{center}", 
     ExtractFigure[], "\n\\end{center}"}},
 TaggingRules:>{
  "CounterSettings" -> {"CounterTarget" -> "Style:PictureCaption"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90, "AlwaysStartEnvironment" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 TextAlignment->Center,
 CounterIncrements->"Picture",
 StyleMenuListing->None],

Cell[StyleData["Picture", "FlushLeft"],
 TextAlignment->Left],

Cell[StyleData["Picture", "Presentation"],
 CellMargins->{{12, Inherited}, {12, 9}},
 Magnification->1.5],

Cell[StyleData["Picture", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Picture", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Picture", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {6, 4}},
 TextAlignment->Left,
 Magnification->0.8],

Cell[StyleData["Picture", "DoubleSpacedPrintout"],
 CellMargins->{{2, Inherited}, {6, 4}},
 Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureCaption"],
 CellMargins->{{48, 48}, {6, 2}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\\caption{", "}\n"}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"Picture"}, "CounterTarget" -> "Cell", "XRefPrefix" -> 
     "Picture"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 PageBreakAbove->False,
 TextAlignment->Center,
 Hyphenation->True,
 CounterIncrements->"PictureCaption",
 CounterAssignments->{{"Nil", 0}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9],

Cell[StyleData["PictureCaption", "FlushLeft"],
 CellMargins->{{12, 12}, {6, 2}},
 TextAlignment->Left],

Cell[StyleData["PictureCaption", "Presentation"],
 CellMargins->{{48, 48}, {9, 3}},
 FontSize->13],

Cell[StyleData["PictureCaption", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["PictureCaption", "Printout", StyleDefinitions -> None]],

Cell[StyleData["PictureCaption", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {4, 1}},
 TextAlignment->Left,
 FontSize->7],

Cell[StyleData["PictureCaption", "DoubleSpacedPrintout"],
 CellMargins->{{42, 42}, {4, 1}},
 LineSpacing->{2, 1},
 FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureCaptionLabel"],
 Editable->False,
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["PictureCaptionLabel", "Printout", StyleDefinitions -> None]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Program/Script", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Program"],
 CellMargins->{{18, 10}, {2, 5}},
 ReturnCreatesNewCell->False,
 CellGroupingRules->"InputGrouping",
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"Program"}, "CounterTarget" -> "Cell", "XRefPrefix" -> 
     "Program"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90, "AlwaysStartEnvironment" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 CounterIncrements->"Program",
 MenuPosition->1850,
 FontFamily->"Courier"],

Cell[StyleData["Program", "FlushLeft"]],

Cell[StyleData["Program", "Presentation"],
 CellMargins->{{23, 10}, {3, 8}},
 FontSize->19],

Cell[StyleData["Program", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Program", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Program", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {1, 4}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Program", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 4}},
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ProgramCaption"],
 CellMargins->{{18, 10}, {6, 2}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\\caption{", "}\n"}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"Program"}, "CounterTarget" -> "CellGroup"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 PageBreakAbove->False,
 Hyphenation->True,
 CounterIncrements->"ProgramCaption",
 CounterAssignments->{{"Nil", 0}},
 MenuPosition->1860,
 FontFamily->"Helvetica",
 FontSize->9],

Cell[StyleData["ProgramCaption", "FlushLeft"]],

Cell[StyleData["ProgramCaption", "Presentation"],
 CellMargins->{{48, 48}, {9, 3}},
 FontSize->14],

Cell[StyleData["ProgramCaption", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["ProgramCaption", "Printout", StyleDefinitions -> None]],

Cell[StyleData["ProgramCaption", "FlushLeftPrintout"],
 CellMargins->{{2, 12}, {2, 4}},
 FontSize->7],

Cell[StyleData["ProgramCaption", "DoubleSpacedPrintout"],
 CellMargins->{{42, 42}, {2, 4}},
 FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ProgramCaptionLabel"],
 Editable->False,
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["ProgramCaptionLabel", "Printout", StyleDefinitions -> None]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ProgramText"],
 CellMargins->{{26, 10}, {12, 0}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\programtext{", Automatic, "}"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"Program"}, "CounterTarget" -> "CellGroup"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> "program"}}},
 PageBreakAbove->False,
 TextJustification->1,
 Hyphenation->True,
 CounterIncrements->"ProgramText",
 StyleMenuListing->None,
 FontSize->9],

Cell[StyleData["ProgramText", "FlushLeft"]],

Cell[StyleData["ProgramText", "Presentation"],
 CellMargins->{{26, 10}, {18, 0}},
 FontSize->14],

Cell[StyleData["ProgramText", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["ProgramText", "Printout", StyleDefinitions -> None]],

Cell[StyleData["ProgramText", "FlushLeftPrintout"],
 CellMargins->{{22, 2}, {12, 0}},
 FontSize->7],

Cell[StyleData["ProgramText", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {12, 0}},
 FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Tables", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TableTitle"],
 PageWidth->WindowWidth,
 CellDingbat->Cell[
   TextData[{"Table ", 
     CounterBox["TableTitle"], "."}], FontWeight -> "Bold"],
 CellMargins->{{18, 10}, {1, 7}},
 CellGroupingRules->"InputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\caption{", Automatic, "} "}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90, "AlwaysStartEnvironment" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> "table"}}, 
   "CounterSettings" -> {
    "CounterFormat" -> {"TableTitle"}, "CounterTarget" -> "Cell", 
     "XRefPrefix" -> "Table"}},
 DefaultNewCellStyle->"Table",
 LineSpacing->{1, 2},
 CounterIncrements->"TableTitle",
 CounterAssignments->{{"Nil", 0}},
 MenuPosition->1900,
 FontWeight->"Plain",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{40}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["TableTitle", "FlushLeft"]],

Cell[StyleData["TableTitle", "Presentation"],
 CellMargins->{{23, 10}, {2, 11}},
 FontSize->17],

Cell[StyleData["TableTitle", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TableTitle", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TableTitle", "FlushLeftPrintout"],
 CellMargins->{{2, 10}, {1, 5}},
 FontSize->10],

Cell[StyleData["TableTitle", "DoubleSpacedPrintout"],
 CellMargins->{{2, 10}, {1, 5}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableTitleLabel"],
 Editable->True,
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 LineSpacing->{1, 2},
 CounterIncrements->"TableTitleLabel",
 StyleMenuListing->None,
 FontWeight->"Bold",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{40}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["TableTitleLabel", "Printout", StyleDefinitions -> None]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Table"],
 Editable->True,
 PageWidth->WindowWidth,
 CellMargins->{{18, 10}, {4, 1}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{
  "TeX" -> {"\n\\begin{tabular}\n", Automatic, "\n\\end{tabular}"}, 
   "HTML" -> {{"", Automatic, ""}, {"", Automatic, ""}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> "table"}}, 
   "CounterSettings" -> {
    "CounterFormat" -> {"TableTitle"}, "CounterTarget" -> "CellGroup"}},
 CellHorizontalScrolling->True,
 CounterIncrements->"Table",
 CounterAssignments->{{"TableNote", 0}},
 MenuPosition->1910,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {False, {False}, False}, "ColumnsIndexed" -> {}, "Rows" -> {
     AbsoluteThickness[2], {False}, 
     AbsoluteThickness[0.5]}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.503]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridDefaultElement:>Cell["Data", "TableText"]}],

Cell[StyleData["Table", "FlushLeft"]],

Cell[StyleData["Table", "Presentation"],
 CellMargins->{{23, 10}, {6, 2}},
 FontSize->17],

Cell[StyleData["Table", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Table", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Table", "FlushLeftPrintout"],
 PageWidth->PaperWidth,
 CellMargins->{{2, 10}, {3, 1}},
 FontSize->10],

Cell[StyleData["Table", "DoubleSpacedPrintout"],
 PageWidth->PaperWidth,
 CellMargins->{{2, 10}, {3, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableNote"],
 Editable->True,
 PageWidth->WindowWidth,
 CellMargins->{{18, 10}, {7, -3}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"Table"}, "CounterTarget" -> "CellGroup"}},
 LineSpacing->{1, 1},
 ParagraphSpacing->{0.3, 0},
 CounterIncrements->"TableNote",
 MenuPosition->1920,
 FontSize->10,
 FontColor->GrayLevel[0.300008]],

Cell[StyleData["TableNote", "FlushLeft"]],

Cell[StyleData["TableNote", "Presentation"],
 Editable->False,
 CellMargins->{{23, 10}, {11, -5}},
 FontSize->15],

Cell[StyleData["TableNote", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TableNote", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TableNote", "FlushLeftPrintout"],
 CellMargins->{{2, 10}, {5, -2}},
 FontSize->9],

Cell[StyleData["TableNote", "DoubleSpacedPrintout"],
 CellMargins->{{2, 10}, {5, -2}},
 LineSpacing->{2, 1},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Table Styles", "Subsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TableColumnHead"],
 Editable->True,
 ConversionRules:>{
  "TeX" -> {{"\\textit{", Automatic, "}"}, {"", Automatic, ""}}},
 StyleMenuListing->None,
 FontSlant->"Italic",
 GridBoxOptions->{BaselinePosition->Axis,
 ColumnsEqual->False,
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>"\[Placeholder]",
 RowsEqual->False}],

Cell[StyleData["TableColumnHead", "FlushLeft"]],

Cell[StyleData["TableColumnHead", "Presentation"],
 FontSize->17],

Cell[StyleData["TableColumnHead", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TableColumnHead", "FlushLeftPrintout"],
 FontSize->10],

Cell[StyleData["TableColumnHead", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableSpanHead"],
 Editable->True,
 ConversionRules:>{
  "TeX" -> {{"\\textit{", Automatic, "}"}, {"", Automatic, ""}}},
 TextAlignment->Center,
 StyleMenuListing->None,
 FontSlant->"Italic",
 GridBoxOptions->{BaselinePosition->Axis,
 ColumnsEqual->False,
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>"\[Placeholder]",
 RowsEqual->False}],

Cell[StyleData["TableSpanHead", "FlushLeft"]],

Cell[StyleData["TableSpanHead", "Presentation"],
 FontSize->17],

Cell[StyleData["TableSpanHead", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TableSpanHead", "FlushLeftPrintout"],
 FontSize->10],

Cell[StyleData["TableSpanHead", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableText"],
 Editable->True,
 TextAlignment->Left,
 LineSpacing->{1, 1},
 StyleMenuListing->None,
 GridBoxOptions->{BaselinePosition->Axis,
 ColumnsEqual->False,
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>"\[Placeholder]",
 RowsEqual->False}],

Cell[StyleData["TableText", "FlushLeft"]],

Cell[StyleData["TableText", "Presentation"],
 FontSize->17],

Cell[StyleData["TableText", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TableText", "FlushLeftPrintout"],
 FontSize->10],

Cell[StyleData["TableText", "DoubleSpacedPrintout"],
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableSpanText"],
 Editable->True,
 TextAlignment->Center,
 LineSpacing->{1, 1},
 StyleMenuListing->None,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["TableSpanText", "FlushLeft"]],

Cell[StyleData["TableSpanText", "Presentation"],
 FontSize->17],

Cell[StyleData["TableSpanText", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TableSpanText", "FlushLeftPrintout"],
 FontSize->10],

Cell[StyleData["TableSpanText", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[StyleData["TableSubGrid"],
 StyleMenuListing->None,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Left, {Center}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{0.1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.27999999999999997`]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>Cell["Data", "TableText"]}],

Cell[StyleData["TableMasterGrid"],
 StyleMenuListing->None,
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.004]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["TableLineElement"],
 Editable->False,
 CellFrame->{{0, 0}, {0.5, 0}},
 CellElementSpacings->{"CellMinHeight"->1},
 ConversionRules:>{"HTML" -> {{"&nbsp;", 
      NoOutput[], ""}, {"", Automatic, ""}}},
 CellSize->{Inherited, 1.25},
 TabFilling->" ",
 TabSpacings->1000,
 StyleMenuListing->None,
 FontSize->1],

Cell[StyleData["TableBlankElement"],
 Editable->False,
 CellElementSpacings->{"CellMinHeight"->1},
 CellSize->{Inherited, 1.25},
 StyleMenuListing->None,
 FontSize->1],

Cell[CellGroupData[{

Cell[StyleData["SpanLeft"],
 Editable->False,
 StyleMenuListing->None,
 FontSize->16,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SpanLeft", "FlushLeft"]],

Cell[StyleData["SpanLeft", "Presentation"],
 FontSize->24],

Cell[StyleData["SpanLeft", "Printout", StyleDefinitions -> None]],

Cell[StyleData["SpanLeft", "FlushLeftPrintout"],
 FontSize->14],

Cell[StyleData["SpanLeft", "DoubleSpacedPrintout"],
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SpanCenter"],
 Editable->False,
 StyleMenuListing->None,
 FontSize->16,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SpanCenter", "FlushLeft"]],

Cell[StyleData["SpanCenter", "Presentation"],
 FontSize->24],

Cell[StyleData["SpanCenter", "Printout", StyleDefinitions -> None]],

Cell[StyleData["SpanCenter", "FlushLeftPrintout"],
 FontSize->14],

Cell[StyleData["SpanCenter", "DoubleSpacedPrintout"],
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SpanRight"],
 Editable->False,
 StyleMenuListing->None,
 FontSize->16,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SpanRight", "FlushLeft"]],

Cell[StyleData["SpanRight", "Presentation"],
 FontSize->24],

Cell[StyleData["SpanRight", "Printout", StyleDefinitions -> None]],

Cell[StyleData["SpanRight", "FlushLeftPrintout"],
 FontSize->14],

Cell[StyleData["SpanRight", "DoubleSpacedPrintout"],
 FontSize->14]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Caption", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
 CellMargins->{{48, 48}, {6, 2}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\\caption{", "}\n"}}},
 TaggingRules:>{"CounterSettings" -> {"CounterTarget" -> "CellGroup"}},
 PageBreakAbove->False,
 Hyphenation->True,
 CounterIncrements->"Caption",
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9],

Cell[StyleData["Caption", "FlushLeft"],
 CellMargins->{{12, 12}, {6, 2}},
 TextAlignment->Left],

Cell[StyleData["Caption", "Presentation"],
 CellMargins->{{48, 48}, {9, 3}},
 FontSize->13],

Cell[StyleData["Caption", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Caption", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Caption", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {4, 1}},
 TextAlignment->Left,
 FontSize->7],

Cell[StyleData["Caption", "DoubleSpacedPrintout"],
 CellMargins->{{42, 42}, {4, 1}},
 LineSpacing->{2, 1},
 FontSize->7]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Frontmatter", "Subsection"],

Cell[CellGroupData[{

Cell["Date", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Date"],
 CellMargins->{{54, 54}, {6, 12}},
 CellGroupingRules->"NormalGrouping",
 ConversionRules:>{"TeX" -> {"\n\\date{", Automatic, "}"}},
 TextAlignment->Center,
 ParagraphSpacing->{0, 8},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9,
 FontColor->RGBColor[0, 0, 0.500008]],

Cell[StyleData["Date", "FlushLeft"],
 CellMargins->{{54, 54}, {6, 12}},
 TextAlignment->Left],

Cell[StyleData["Date", "Presentation"],
 CellMargins->{{54, 54}, {9, 18}},
 CellGroupingRules->"NormalGrouping",
 TextAlignment->Center,
 ParagraphSpacing->{0, 8},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->15,
 FontColor->RGBColor[0, 0, 0.500008]],

Cell[StyleData["Date", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Date", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Date", "FlushLeftPrintout"],
 CellMargins->{{48, 48}, {5, 10}},
 TextAlignment->Left,
 LineSpacing->{1, 1},
 FontSize->7,
 FontColor->GrayLevel[0]],

Cell[StyleData["Date", "DoubleSpacedPrintout"],
 CellMargins->{{48, 48}, {5, 10}},
 LineSpacing->{1, 1},
 FontSize->7,
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Author", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Author"],
 CellMargins->{{54, 54}, {2, 24}},
 CellGroupingRules->{"SectionGrouping", 50},
 ConversionRules:>{"TeX" -> {"", 
     ExtractCellTaggingRules["AuthorData", "TeX", 1], ""}},
 DefaultNewCellStyle->"Section",
 DefaultReturnCreatedCellStyle->"Institution",
 TextAlignment->Center,
 ParagraphSpacing->{0, 0},
 MenuPosition->2000,
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["Author", "Presentation"],
 CellMargins->{{47, 47}, {0, 36}},
 TextAlignment->Center],

Cell[StyleData["Author", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Author", "Printout", StyleDefinitions -> None]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AuthorData"],
 Selectable->False,
 ConversionRules:>{"HTML" -> {"<sup class=\"AuthorDataSup\">", 
     GetAuthorData[], "</sup>"}},
 ScriptMinSize->10,
 StyleMenuListing->None],

Cell[StyleData["AuthorData", "Printout", StyleDefinitions -> None]],

Cell[StyleData["AuthorData", "FlushLeftPrintout"],
 Selectable->False,
 ScriptMinSize->8],

Cell[StyleData["AuthorData", "DoubleSpacedPrintout"],
 Selectable->False,
 ScriptMinSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AuthorGroup"],
 Editable->False,
 CellMargins->{{54, 54}, {2, 24}},
 CellGroupingRules->"InputGrouping",
 ConversionRules:>{"TeX" -> {"\n", Automatic, ""}},
 TextAlignment->Center,
 StyleMenuListing->None,
 FontSize->14,
 FontColor->RGBColor[0, 0, 0.500008]],

Cell[StyleData["AuthorGroup", "FlushLeft"],
 Editable->False,
 CellMargins->{{54, 54}, {2, 24}},
 TextAlignment->Left,
 FontSize->14],

Cell[StyleData["AuthorGroup", "Presentation"],
 Editable->False,
 ShowGroupOpener->False,
 CellMargins->{{54, 54}, {3, 36}},
 FontSize->21],

Cell[StyleData["AuthorGroup", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["AuthorGroup", "Printout", StyleDefinitions -> None]],

Cell[StyleData["AuthorGroup", "FlushLeftPrintout"],
 Editable->False,
 CellMargins->{{48, 48}, {1, 21}},
 TextAlignment->Left,
 FontSize->12,
 FontColor->GrayLevel[0]],

Cell[StyleData["AuthorGroup", "DoubleSpacedPrintout"],
 CellMargins->{{48, 48}, {1, 20}},
 FontSize->12,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[StyleData["AuthorFirstName"],
 StyleMenuListing->None,
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FillInAuthorForm[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["AuthorMiddleName"],
 StyleMenuListing->None,
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FillInAuthorForm[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["AuthorLastName"],
 Editable->True,
 StyleMenuListing->None,
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FillInAuthorForm[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["AuthorNameSuffix"],
 StyleMenuListing->None,
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FillInAuthorForm[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["AuthorAffiliation"],
 StyleMenuListing->None,
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FillInAuthorForm[#]& ),
 Evaluator->Automatic}],

Cell[CellGroupData[{

Cell[StyleData["AuthorEmail"],
 SingleLetterItalics->False,
 StyleMenuListing->None,
 FontSize->18,
 FontWeight->"Plain",
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["AuthorEmail", "FlushLeft"]],

Cell[StyleData["AuthorEmail", "Presentation"],
 FontSize->26],

Cell[StyleData["AuthorEmail", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["AuthorEmail", "Printout", StyleDefinitions -> None]],

Cell[StyleData["AuthorEmail", "FlushLeftPrintout"],
 FontSize->1,
 FontColor->GrayLevel[1]],

Cell[StyleData["AuthorEmail", "DoubleSpacedPrintout"],
 FontSize->1,
 FontColor->GrayLevel[1]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Author Form Customization", "Subsubsection"],

Cell["\<\
Field Correlations:

AUTHORNAME -> \\author{}
Email -> \\email{}
Home Page -> \\homepage{}
Institution -> \\institution{}\
\>", "AuthorFormCustomizationTemplate",
 FontFamily->"Courier",
 CellTags->"AuthorFormCustomization"]
}, Closed]],

Cell[CellGroupData[{

Cell["Institution", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Institution"],
 CellMargins->{{54, 54}, {0, 0}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 DefaultNewCellStyle->"Section",
 DefaultReturnCreatedCellStyle->"Author",
 TextAlignment->Center,
 CounterIncrements->"Institution",
 MenuPosition->2010,
 FontColor->RGBColor[0, 0, 0.500008]],

Cell[StyleData["Institution", "FlushLeft"],
 Editable->False,
 CellMargins->{{54, 54}, {0, 0}},
 TextAlignment->Left,
 ParagraphIndent->-18,
 FontSize->12,
 FontColor->RGBColor[0, 0, 0.500008]],

Cell[StyleData["Institution", "Presentation"],
 Editable->False,
 CellMargins->{{54, 54}, {1, 1}},
 FontSize->18],

Cell[StyleData["Institution", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Institution", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Institution", "FlushLeftPrintout"],
 Editable->False,
 CellMargins->{{48, 48}, {0, 0}},
 TextAlignment->Left,
 ParagraphIndent->-16,
 FontSize->10,
 FontColor->GrayLevel[0]],

Cell[StyleData["Institution", "DoubleSpacedPrintout"],
 CellMargins->{{48, 48}, {0, 0}},
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Abstract", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Abstract"],
 CellMargins->{{54, 54}, {3, 24}},
 CellGroupingRules->{"SectionGrouping", 50},
 ConversionRules:>{"TeX" -> {"\n\n", Automatic, ""}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> "abstract"}}},
 CellFrameMargins->5,
 TextAlignment->Left,
 TextJustification->1,
 LineSpacing->{1, 1},
 StyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008]],

Cell[StyleData["Abstract", "FlushLeft"]],

Cell[StyleData["Abstract", "Presentation"],
 CellMargins->{{54, 54}, {5, 36}},
 FontSize->17],

Cell[StyleData["Abstract", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Abstract", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Abstract", "FlushLeftPrintout"],
 CellMargins->{{48, 48}, {2, 14}},
 CellFrameMargins->3,
 FontSize->10],

Cell[StyleData["Abstract", "DoubleSpacedPrintout"],
 CellMargins->{{48, 48}, {2, 14}},
 CellFrameMargins->3,
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Table of Contents", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell["Article", "Subsubsubsection"],

Cell[CellGroupData[{

Cell["Title Headings", "Subsubsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TOCHeading"],
 CellMargins->{{12, 12}, {3, 24}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {"<h3 class=\"TOCHeading\">", "</h3>"}},
 PageBreakBelow->False,
 CellFrameMargins->{{0, 0}, {3, 0}},
 TextAlignment->Center,
 LineSpacing->{1, 2},
 StyleMenuListing->None,
 FontSize->20,
 FontWeight->"Bold"],

Cell[StyleData["TOCHeading", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TOCHeading", "FlushLeft"],
 TextAlignment->Left],

Cell[StyleData["TOCHeading", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCHeading", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 21}},
 TextAlignment->Left,
 FontSize->18],

Cell[StyleData["TOCHeading", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 21}},
 FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCIllustrations"],
 CellMargins->{{12, 12}, {3, 24}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {"<h3 class=\"TOCIllustrations\">", "</h3>"}},
 
 PageBreakBelow->False,
 CellFrameMargins->{{0, 0}, {3, 0}},
 TextAlignment->Center,
 LineSpacing->{1, 2},
 CounterAssignments->{{"TOCItem", 0}},
 StyleMenuListing->None,
 FontSize->20,
 FontWeight->"Bold"],

Cell[StyleData["TOCIllustrations", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TOCIllustrations", "FlushLeft"],
 TextAlignment->Left],

Cell[StyleData["TOCIllustrations", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCIllustrations", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 21}},
 TextAlignment->Left,
 FontSize->18],

Cell[StyleData["TOCIllustrations", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 21}},
 FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCTables"],
 CellMargins->{{12, 12}, {3, 24}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {"<h3 class=\"TOCTables\">", "</h3>"}},
 PageBreakBelow->False,
 CellFrameMargins->{{0, 0}, {3, 0}},
 TextAlignment->Center,
 LineSpacing->{1, 2},
 CounterAssignments->{{"TOCItem", 0}},
 StyleMenuListing->None,
 FontSize->20,
 FontWeight->"Bold"],

Cell[StyleData["TOCTables", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TOCTables", "FlushLeft"],
 TextAlignment->Left],

Cell[StyleData["TOCTables", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCTables", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 21}},
 TextAlignment->Left,
 FontSize->18],

Cell[StyleData["TOCTables", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 21}},
 FontSize->18]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Contents Headings", "Subsubsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TOCFrontmatterHeading"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, 
   "HTML" -> {
    "<table class=\"TOC\"><tr><td><p class=\"TOCFrontmatterHeading\">", 
     "</td></tr></table>"}},
 TabSpacings->54,
 StyleMenuListing->None,
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["TOCFrontmatterHeading", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TOCFrontmatterHeading", "FlushLeft"]],

Cell[StyleData["TOCFrontmatterHeading", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCFrontmatterHeading", "FlushLeftPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->55.9,
 FontSize->12],

Cell[StyleData["TOCFrontmatterHeading", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->55.9,
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBackmatterHeading"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, 
   "HTML" -> {
    "<table class=\"TOC\"><tr><td><p class=\"TOCBackmatterHeading\">", 
     "</td></tr></table>"}},
 TabSpacings->54,
 StyleMenuListing->None,
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["TOCBackmatterHeading", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TOCBackmatterHeading", "FlushLeft"]],

Cell[StyleData["TOCBackmatterHeading", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCBackmatterHeading", "FlushLeftPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->55.9,
 FontSize->12],

Cell[StyleData["TOCBackmatterHeading", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->55.9,
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCFrontBackHeading"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, 
   "HTML" -> {
    "<table class=\"TOC\"><tr><td><p class=\"TOCFrontBackHeading\">", 
     "</td></tr></table>"}},
 TabSpacings->54,
 StyleMenuListing->None,
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["TOCFrontBackHeading", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TOCFrontBackHeading", "FlushLeft"]],

Cell[StyleData["TOCFrontBackHeading", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCFrontBackHeading", "FlushLeftPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->55.9,
 FontSize->12],

Cell[StyleData["TOCFrontBackHeading", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->55.9,
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSection"],
 CellMargins->{{12, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {
     IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCSection'><span \
class='Ignore'>`1` &nbsp;</span>", "TOCSection"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["TOCSection"]}], "TOCSectionLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->54,
 CounterIncrements->"TOCSection",
 CounterAssignments->{{"TOCSubsection", 0}},
 StyleMenuListing->None,
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["TOCSection", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TOCSection", "FlushLeft"]],

Cell[StyleData["TOCSection", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCSection", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->55.9,
 FontSize->12],

Cell[StyleData["TOCSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->55.9,
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSubsection"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 50},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {
     IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCSubsection'><span \
class='Ignore'>`1`.`2` &nbsp;</span>", "TOCSection", "TOCSubsection"], 
     "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["TOCSection"], ".", 
       CounterBox["TOCSubsection"]}], "TOCSubsectionLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->49.87,
 CounterIncrements->"TOCSubsection",
 CounterAssignments->{{"TOCSubsubsection", 0}},
 StyleMenuListing->None],

Cell[StyleData["TOCSubsection", "FlushLeft"]],

Cell[StyleData["TOCSubsection", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCSubsection", "FlushLeftPrintout"],
 CellMargins->{{24, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->51.7,
 FontSize->10],

Cell[StyleData["TOCSubsection", "DoubleSpacedPrintout"],
 CellMargins->{{24, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->51.7,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSubsubsection"],
 CellMargins->{{60, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 60},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {
     IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCSubsubsection'><span \
class='Ignore'>`1`.`2`.`3` &nbsp;</span>", "TOCSection", "TOCSubsection", 
      "TOCSubsubsection"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["TOCSection"], ".", 
       CounterBox["TOCSubsection"], ".", 
       CounterBox["TOCSubsubsection"]}], "TOCSubsubsectionLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->45.8,
 CounterIncrements->"TOCSubsubsection",
 StyleMenuListing->None],

Cell[StyleData["TOCSubsubsection", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TOCSubsubsection", "FlushLeft"]],

Cell[StyleData["TOCSubsubsection", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCSubsubsection", "FlushLeftPrintout"],
 CellMargins->{{48, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->46.6,
 FontSize->10],

Cell[StyleData["TOCSubsubsection", "DoubleSpacedPrintout"],
 CellMargins->{{48, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->46.6,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCFigure"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {
     IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCFigure'><span \
class='Ignore'>Fig. `1`. &nbsp;</span>", "TOCFigure"], "</td></tr></table>"}},
 
 CellFrameLabels->{{
    Cell[
     TextData[{"Fig. ", 
       CounterBox["TOCFigure"], "."}], "TOCFigureLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->50.2,
 CounterIncrements->"TOCFigure",
 StyleMenuListing->None],

Cell[StyleData["TOCFigure", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TOCFigure", "FlushLeft"]],

Cell[StyleData["TOCFigure", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCFigure", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->52.2,
 FontSize->10],

Cell[StyleData["TOCFigure", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->52.2,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSupplemental"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {
     IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCSupplemental'><span \
class='Ignore'>Supp. `1`. &nbsp;</span>", "TOCSupplemental"], 
     "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Supp. ", 
       CounterBox["TOCSupplemental"], "."}], "TOCSupplementalLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->50.2,
 CounterIncrements->"TOCSupplemental",
 StyleMenuListing->None],

Cell[StyleData["TOCSupplemental", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TOCSupplemental", "FlushLeft"]],

Cell[StyleData["TOCSupplemental", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCSupplemental", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->52.2,
 FontSize->10],

Cell[StyleData["TOCSupplemental", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->52.2,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCPicture"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {
     IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCPicture'><span \
class='Ignore'>Pict. `1`. &nbsp;</span>", "TOCPicture"], 
     "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Pict. ", 
       CounterBox["TOCPicture"], "."}], "TOCPictureLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->50.2,
 CounterIncrements->"TOCPicture",
 StyleMenuListing->None],

Cell[StyleData["TOCPicture", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TOCPicture", "FlushLeft"]],

Cell[StyleData["TOCPicture", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCPicture", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->52.2,
 FontSize->10],

Cell[StyleData["TOCPicture", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->52.2,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCIllustration"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {
     IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCIllustration'><span \
class='Ignore'>Illus. `1`. &nbsp;</span>", "TOCIllustration"], 
     "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Illus. ", 
       CounterBox["TOCIllustration"], "."}], "TOCIllustrationLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->50.2,
 CounterIncrements->"TOCIllustration",
 StyleMenuListing->None],

Cell[StyleData["TOCIllustration", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TOCIllustration", "FlushLeft"]],

Cell[StyleData["TOCIllustration", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCIllustration", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->52.2,
 FontSize->10],

Cell[StyleData["TOCIllustration", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->52.2,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCProgram"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {
     IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCProgram'><span \
class='Ignore'>Pgm. `1`. &nbsp;</span>", "TOCProgram"], 
     "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Pgm. ", 
       CounterBox["TOCProgram"], "."}], "TOCProgramLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->50.2,
 CounterIncrements->"TOCProgram",
 StyleMenuListing->None],

Cell[StyleData["TOCProgram", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TOCProgram", "FlushLeft"]],

Cell[StyleData["TOCProgram", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCProgram", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->52.2,
 FontSize->10],

Cell[StyleData["TOCProgram", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->52.2,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCTable"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {
     IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCTable'><span \
class='Ignore'>Table `1`. &nbsp;</span>", "TOCTable"], "</td></tr></table>"}},
 
 CellFrameLabels->{{
    Cell[
     TextData[{"Table ", 
       CounterBox["TOCTable"], "."}], "TOCTableLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->50.2,
 CounterIncrements->"TOCTable",
 StyleMenuListing->None],

Cell[StyleData["TOCTable", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TOCTable", "FlushLeft"]],

Cell[StyleData["TOCTable", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCTable", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->52.2,
 FontSize->10],

Cell[StyleData["TOCTable", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->52.2,
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Labels and misc", "Subsubsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TOCSpacer"],
 CellMargins->{{12, 12}, {0, 0}},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 StyleMenuListing->None],

Cell[StyleData["TOCSpacer", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TOCSpacer", "FlushLeft"],
 CellMargins->{{12, 12}, {0, 0}},
 StyleMenuListing->None],

Cell[StyleData["TOCSpacer", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCSpacer", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {0, 0}}],

Cell[StyleData["TOCSpacer", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 0}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSectionLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{18, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["TOCSectionLabel", "FlushLeft"]],

Cell[StyleData["TOCSectionLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCSectionLabel", "FlushLeftPrintout"],
 CellSize->{14, Inherited}],

Cell[StyleData["TOCSectionLabel", "DoubleSpacedPrintout"],
 CellSize->{14, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSubsectionLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{32, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["TOCSubsectionLabel", "FlushLeft"]],

Cell[StyleData["TOCSubsectionLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCSubsectionLabel", "FlushLeftPrintout"],
 CellSize->{24, Inherited}],

Cell[StyleData["TOCSubsectionLabel", "DoubleSpacedPrintout"],
 CellSize->{24, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSubsubsectionLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{44, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["TOCSubsubsectionLabel", "FlushLeft"]],

Cell[StyleData["TOCSubsubsectionLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCSubsubsectionLabel", "FlushLeftPrintout"],
 CellSize->{38, Inherited}],

Cell[StyleData["TOCSubsubsectionLabel", "DoubleSpacedPrintout"],
 CellSize->{38, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCFigureLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{53, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["TOCFigureLabel", "FlushLeft"]],

Cell[StyleData["TOCFigureLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCFigureLabel", "FlushLeftPrintout"],
 CellSize->{42, Inherited}],

Cell[StyleData["TOCFigureLabel", "DoubleSpacedPrintout"],
 CellSize->{42, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSupplementalLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{53, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["TOCSupplementalLabel", "FlushLeft"]],

Cell[StyleData["TOCSupplementalLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCSupplementalLabel", "FlushLeftPrintout"],
 CellSize->{42, Inherited}],

Cell[StyleData["TOCSupplementalLabel", "DoubleSpacedPrintout"],
 CellSize->{42, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCPictureLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{53, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["TOCPictureLabel", "FlushLeft"]],

Cell[StyleData["TOCPictureLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCPictureLabel", "FlushLeftPrintout"],
 CellSize->{42, Inherited}],

Cell[StyleData["TOCPictureLabel", "DoubleSpacedPrintout"],
 CellSize->{42, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCIllustrationLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{53, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["TOCIllustrationLabel", "FlushLeft"]],

Cell[StyleData["TOCIllustrationLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCIllustrationLabel", "FlushLeftPrintout"],
 CellSize->{42, Inherited}],

Cell[StyleData["TOCIllustrationLabel", "DoubleSpacedPrintout"],
 CellSize->{42, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCProgramLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{53, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["TOCProgramLabel", "FlushLeft"]],

Cell[StyleData["TOCProgramLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCProgramLabel", "FlushLeftPrintout"],
 CellSize->{42, Inherited}],

Cell[StyleData["TOCProgramLabel", "DoubleSpacedPrintout"],
 CellSize->{42, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCTableLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{53, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["TOCTableLabel", "FlushLeft"]],

Cell[StyleData["TOCTableLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCTableLabel", "FlushLeftPrintout"],
 CellSize->{42, Inherited}],

Cell[StyleData["TOCTableLabel", "DoubleSpacedPrintout"],
 CellSize->{42, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCLeader"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 TabFilling->". ",
 StyleMenuListing->None,
 FontSize->12,
 FontWeight->"Plain"],

Cell[StyleData["TOCLeader", "FlushLeft"]],

Cell[StyleData["TOCLeader", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCLeader", "FlushLeftPrintout"],
 FontSize->10],

Cell[StyleData["TOCLeader", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCPageNumber"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, 
   "HTML" -> {
    "</p></td><td class=\"TOCPage\"><p class=\"TOCPageNumber\">", "</p>"}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["TOCPageNumber", "FlushLeft"]],

Cell[StyleData["TOCPageNumber", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TOCPageNumber", "FlushLeftPrintout"],
 CellSize->{21, Inherited}],

Cell[StyleData["TOCPageNumber", "DoubleSpacedPrintout"],
 CellSize->{21, Inherited}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Acknowledgments", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["AcknowledgmentsSection"],
 CellMargins->{{12, 12}, {3, 24}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{
  "TeX" -> {"\n\\acknowledgmentssection{", "}"}, 
   "HTML" -> {"<h3 class=\"AcknowledgmentsSection\">", "</h3>"}},
 PageBreakBelow->False,
 DefaultNewCellStyle->"Acknowledgments",
 TextAlignment->Center,
 CounterIncrements->"Acknowledgments",
 MenuPosition->2100,
 FontSize->20,
 FontWeight->"Bold"],

Cell[StyleData["AcknowledgmentsSection", "FlushLeft"],
 CellMargins->{{12, 12}, {3, 24}},
 TextAlignment->Left],

Cell[StyleData["AcknowledgmentsSection", "Presentation"],
 CellMargins->{{12, 12}, {5, 36}},
 FontSize->30],

Cell[StyleData["AcknowledgmentsSection", "Condensed", StyleDefinitions -> \
None]],

Cell[StyleData["AcknowledgmentsSection", "Printout", StyleDefinitions -> None]],

Cell[StyleData["AcknowledgmentsSection", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {3, 18}},
 TextAlignment->Left,
 FontSize->17],

Cell[StyleData["AcknowledgmentsSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {3, 18}},
 FontSize->17]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Acknowledgments"],
 CellMargins->{{18, 10}, {3, 5}},
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TextAlignment->Left,
 TextJustification->1,
 LineSpacing->{1, 3},
 CounterIncrements->"Acknowledgments",
 CounterAssignments->{{"Item1Numbered", 0}},
 MenuPosition->2110],

Cell[StyleData["Acknowledgments", "FlushLeft"]],

Cell[StyleData["Acknowledgments", "Presentation"],
 CellMargins->{{23, 10}, {5, 8}},
 FontSize->17],

Cell[StyleData["Acknowledgments", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Acknowledgments", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Acknowledgments", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10],

Cell[StyleData["Acknowledgments", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Appendix", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["AppendixSection"],
 CellMargins->{{12, 12}, {3, 24}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{
  "TeX" -> {"\n\\section{", "}"}, 
   "HTML" -> {"<h3 class=\"AppendixSection\">", "</h3>"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"AppendixSection"}, "XRefPrefix" -> "Appendix", 
     "CounterTarget" -> "Cell"}},
 PageBreakBelow->False,
 DefaultNewCellStyle->"Appendix",
 TextAlignment->Center,
 CounterIncrements->{
  "AppendixSection", "SectionHeader", "SubsectionHeader", 
   "SubsubsectionHeader", "SubsubsubsectionHeader"},
 CounterAssignments->{{"AppendixEquation", 0}},
 MenuPosition->2150,
 FontSize->20,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["A", "Z"], #]& )}],

Cell[StyleData["AppendixSection", "FlushLeft"],
 CellMargins->{{12, 12}, {3, 24}},
 TextAlignment->Left],

Cell[StyleData["AppendixSection", "Presentation"],
 CellMargins->{{12, 12}, {5, 36}},
 FontSize->30],

Cell[StyleData["AppendixSection", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["AppendixSection", "Printout", StyleDefinitions -> None]],

Cell[StyleData["AppendixSection", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {3, 18}},
 TextAlignment->Left,
 FontSize->17],

Cell[StyleData["AppendixSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {3, 18}},
 FontSize->17]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AppendixSectionLabel"],
 Editable->False,
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{32, Inherited},
 TextAlignment->Left,
 StyleMenuListing->None],

Cell[StyleData["AppendixSectionLabel", "FlushLeft"],
 CellSize->{32, Inherited}],

Cell[StyleData["AppendixSectionLabel", "Presentation"],
 CellSize->{48, Inherited}],

Cell[StyleData["AppendixSectionLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["AppendixSectionLabel", "FlushLeftPrintout"],
 CellSize->{29, Inherited}],

Cell[StyleData["AppendixSectionLabel", "DoubleSpacedPrintout"],
 CellSize->{29, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Appendix"],
 CellMargins->{{18, 10}, {3, 5}},
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TextAlignment->Left,
 TextJustification->1,
 LineSpacing->{1, 3},
 CounterIncrements->"Appendix",
 CounterAssignments->{{"Item1Numbered", 0}},
 MenuPosition->2160],

Cell[StyleData["Appendix", "FlushLeft"]],

Cell[StyleData["Appendix", "Presentation"],
 CellMargins->{{23, 10}, {5, 8}},
 FontSize->17],

Cell[StyleData["Appendix", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Appendix", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Appendix", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10],

Cell[StyleData["Appendix", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AppendixEquation"],
 CellMargins->{{60, 12}, {7, 7}},
 ConversionRules:>{
  "HTML" -> {{"", ""}, {
     "<table class='AppendixEquation'><tr><td>", Automatic, 
      IncludeCount[
      "</td><td class='AppendixEquationLabel'>(`1`.`2`)</td></tr></table>", 
       "AppendixSection", "AppendixEquation"]}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"AppendixSection", ".", "AppendixEquation"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Equation"}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["AppendixEquation"], ")"}]]}, {None, None}},
 DefaultFormatType->TraditionalForm,
 TextAlignment->Center,
 CounterIncrements->"AppendixEquation",
 MenuPosition->2170],

Cell[StyleData["AppendixEquation", "FlushLeft"],
 CellMargins->{{36, 6}, {7, 7}},
 TextAlignment->Left],

Cell[StyleData["AppendixEquation", "Presentation"],
 CellMargins->{{72, 12}, {11, 11}},
 FontSize->19],

Cell[StyleData["AppendixEquation", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["AppendixEquation", "Printout", StyleDefinitions -> None]],

Cell[StyleData["AppendixEquation", "FlushLeftPrintout"],
 CellMargins->{{21, 6}, {5, 5}},
 TextAlignment->Left,
 FontSize->10],

Cell[StyleData["AppendixEquation", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {5, 5}},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Endnotes", "Subsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["EndnoteSection"],
 CellMargins->{{12, 12}, {3, 24}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{{"TeX" -> {"", 
      NoOutput[], ""}}, {
   "HTML" -> {"<h3 class=\"EndnoteSection\">", "</h3>"}}},
 PageBreakBelow->False,
 DefaultNewCellStyle->"Endnote",
 DefaultNewInlineCellStyle->"None",
 TextAlignment->Center,
 LineSpacing->{1, 7},
 LanguageCategory->"NaturalLanguage",
 CounterIncrements->{
  "Section", "SectionHeader", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}, {
   "Endnote", 0}},
 MenuPosition->2200,
 FontSize->20,
 FontWeight->"Bold"],

Cell[StyleData["EndnoteSection", "FlushLeft"],
 CellMargins->{{12, 12}, {3, 24}},
 TextAlignment->Left,
 FontSize->20,
 FontWeight->"Bold"],

Cell[StyleData["EndnoteSection", "Presentation"],
 CellMargins->{{12, 12}, {5, 36}},
 FontSize->30],

Cell[StyleData["EndnoteSection", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["EndnoteSection", "Printout", StyleDefinitions -> None]],

Cell[StyleData["EndnoteSection", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 21}},
 TextAlignment->Left,
 FontSize->18,
 FontWeight->"Bold"],

Cell[StyleData["EndnoteSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {3, 18}},
 FontSize->17]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Endnote"],
 CellMargins->{{18, 8}, {2, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"", 
      NoOutput[], ""}}, {
   "HTML" -> {
     "<table class=\"Endnote\"><tr valign=\"top\">", "</td></tr></table>"}}},
 LineSpacing->{1, 2},
 ParagraphSpacing->{0, 0},
 ParagraphIndent->-36,
 TabSpacings->5.5,
 CounterIncrements->"Endnote",
 MenuPosition->2210],

Cell[StyleData["Endnote", "FlushLeft"]],

Cell[StyleData["Endnote", "Presentation"],
 CellMargins->{{23, 8}, {3, 3}},
 ParagraphIndent->-54,
 FontSize->17],

Cell[StyleData["Endnote", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Endnote", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Endnote", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TextJustification->0.5,
 FontSize->10],

Cell[StyleData["Endnote", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EndnoteLabel"],
 ConversionRules:>{"HTML" -> {"<td class=\"EndnoteLabel\" align=\"left\">", 
     ConvertTextSubOrSuperscriptToHTML["sup"], "&nbsp;</td><td>"}},
 CellSize->{36, Inherited},
 TextAlignment->Right,
 SpanMaxSize->1,
 CounterIncrements->"EndnoteLabel",
 StyleMenuListing->None],

Cell[StyleData["EndnoteLabel", "FlushLeft"]],

Cell[StyleData["EndnoteLabel", "Presentation"],
 CellSize->{54, Inherited}],

Cell[StyleData["EndnoteLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["EndnoteLabel", "FlushLeftPrintout"],
 CellSize->{24, Inherited}],

Cell[StyleData["EndnoteLabel", "DoubleSpacedPrintout"],
 CellSize->{24, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EndnoteNumber"],
 CellSize->{36, Inherited},
 TextAlignment->Right,
 CounterIncrements->"EndnoteNumber",
 StyleMenuListing->None],

Cell[StyleData["EndnoteNumber", "FlushLeft"]],

Cell[StyleData["EndnoteNumber", "Presentation"]],

Cell[StyleData["EndnoteNumber", "Printout", StyleDefinitions -> None]],

Cell[StyleData["EndnoteNumber", "FlushLeftPrintout"]],

Cell[StyleData["EndnoteNumber", "DoubleSpacedPrintout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NoteKey"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(EditNote[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["NoteKey", "FlushLeft"]],

Cell[StyleData["NoteKey", "Presentation"]],

Cell[StyleData["NoteKey", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["NoteKey", "Printout", StyleDefinitions -> None]],

Cell[StyleData["NoteKey", "FlushLeftPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["NoteKey", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EndnoteReturnLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["EndnoteReturnLink", "FlushLeft"]],

Cell[StyleData["EndnoteReturnLink", "Presentation"]],

Cell[StyleData["EndnoteReturnLink", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["EndnoteReturnLink", "Printout", StyleDefinitions -> None]],

Cell[StyleData["EndnoteReturnLink", "FlushLeftPrintout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]],

Cell[StyleData["EndnoteReturnLink", "DoubleSpacedPrintout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableNoteKey"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(EditTableNote[#, #2]& ),
 ButtonSource->ButtonContents,
 Evaluator->Automatic}],

Cell[StyleData["TableNoteKey", "FlushLeft"]],

Cell[StyleData["TableNoteKey", "Presentation"]],

Cell[StyleData["TableNoteKey", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["TableNoteKey", "Printout", StyleDefinitions -> None]],

Cell[StyleData["TableNoteKey", "FlushLeftPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["TableNoteKey", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["PageRef", "FlushLeft"],
 StyleMenuListing->None],

Cell[StyleData["PageRef", "Presentation"],
 StyleMenuListing->None],

Cell[StyleData["PageRef", "Printout", StyleDefinitions -> None]],

Cell[StyleData["PageRef", "FlushLeftPrintout"],
 StyleMenuListing->None],

Cell[StyleData["PageRef", "DoubleSpacedPrintout"],
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Note"],
 Editable->False,
 Deletable->False,
 ConversionRules:>{"TeX" -> {{"\\footnote{", Convert[
       ExtractButtonData[1][#]]& , "}"}, {"", Automatic, ""}}, 
   "HTML" -> {"", 
     ConvertTextSubOrSuperscriptToHTML["sup"], ""}},
 ScriptMinSize->10,
 SpanMaxSize->1,
 StyleMenuListing->None,
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Note", "FlushLeft"]],

Cell[StyleData["Note", "Presentation"]],

Cell[StyleData["Note", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Note", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Note", "FlushLeftPrintout"],
 ScriptMinSize->8],

Cell[StyleData["Note", "DoubleSpacedPrintout"],
 ScriptMinSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["References", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["ReferenceSection"],
 CellMargins->{{12, 12}, {3, 24}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{{"TeX" -> {"", 
      NoOutput[], ""}}, {
   "HTML" -> {"<h3 class=\"ReferenceSection\">", "</h3>"}}},
 PageBreakBelow->False,
 DefaultNewCellStyle->"Reference",
 DefaultNewInlineCellStyle->"None",
 TextAlignment->Center,
 LineSpacing->{1, 7},
 LanguageCategory->"NaturalLanguage",
 CounterIncrements->{
  "SectionHeader", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Reference", 0}},
 MenuPosition->2250,
 FontSize->20,
 FontWeight->"Bold"],

Cell[StyleData["ReferenceSection", "FlushLeft"],
 CellMargins->{{12, 12}, {3, 24}},
 TextAlignment->Left,
 FontSize->20,
 FontWeight->"Bold"],

Cell[StyleData["ReferenceSection", "Presentation"],
 CellMargins->{{12, 12}, {5, 36}},
 FontSize->30],

Cell[StyleData["ReferenceSection", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["ReferenceSection", "Printout", StyleDefinitions -> None]],

Cell[StyleData["ReferenceSection", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {2, 21}},
 TextAlignment->Left,
 FontSize->18,
 FontWeight->"Bold"],

Cell[StyleData["ReferenceSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 12}, {3, 18}},
 StyleMenuListing->None,
 FontSize->17]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Reference"],
 CellMargins->{{18, 10}, {2, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"", ""}}, {
   "HTML" -> {
     "<table class=\"Reference\"><tr valign=\"top\">", 
      "</td></tr></table>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "TeX" -> {
      "NestingLevel" -> 1, 
       "CellGroupEnvironment" -> {"thebibliography", "{000}"}}}},
 Hyphenation->True,
 LineSpacing->{1, 2},
 ParagraphIndent->-24,
 CounterIncrements->"Reference",
 MenuPosition->2260],

Cell[StyleData["Reference", "FlushLeft"]],

Cell[StyleData["Reference", "Presentation"],
 CellMargins->{{23, 10}, {3, 3}},
 ParagraphIndent->-36,
 FontSize->17],

Cell[StyleData["Reference", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Reference", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Reference", "FlushLeftPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 ParagraphIndent->-18,
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Reference", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 LineSpacing->{2, 1},
 ParagraphIndent->-18,
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceLabel"],
 ConversionRules:>{
  "HTML" -> {
    "<td class=\"ReferenceLabel\" align=\"left\">", "&nbsp;</td><td>"}},
 CellSize->{72, Inherited},
 TextAlignment->Left,
 SpanMaxSize->1,
 CounterIncrements->"ReferenceLabel",
 StyleMenuListing->None],

Cell[StyleData["ReferenceLabel", "FlushLeft"],
 TextAlignment->Left],

Cell[StyleData["ReferenceLabel", "Presentation"],
 CellSize->{108, Inherited},
 TextAlignment->Left],

Cell[StyleData["ReferenceLabel", "Printout", StyleDefinitions -> None]],

Cell[StyleData["ReferenceLabel", "FlushLeftPrintout"],
 CellSize->{60, Inherited},
 TextAlignment->Left],

Cell[StyleData["ReferenceLabel", "DoubleSpacedPrintout"],
 CellSize->{60, Inherited},
 TextAlignment->Left]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefSep"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 StyleMenuListing->None],

Cell[StyleData["RefSep", "FlushLeft"]],

Cell[StyleData["RefSep", "Presentation"]],

Cell[StyleData["RefSep", "Printout", StyleDefinitions -> None]],

Cell[StyleData["RefSep", "FlushLeftPrintout"]],

Cell[StyleData["RefSep", "DoubleSpacedPrintout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefReturnLink"],
 ConversionRules:>{"TeX" -> {"\n\\bibitem{", 
     ExtractRefLinkData[], "}"}, "HTML" -> {"<td>", ""}},
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& )}],

Cell[StyleData["RefReturnLink", "FlushLeft"]],

Cell[StyleData["RefReturnLink", "Presentation"]],

Cell[StyleData["RefReturnLink", "Printout"],
 StyleMenuListing->None,
 FontColor->GrayLevel[0]],

Cell[StyleData["RefReturnLink", "FlushLeftPrintout"],
 StyleMenuListing->None,
 FontColor->GrayLevel[0]],

Cell[StyleData["RefReturnLink", "DoubleSpacedPrintout"],
 StyleMenuListing->None,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefReturnPointer"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {"<td>", 
     NoOutput[], ""}},
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontFamily->"Mathematica4",
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& )}],

Cell[StyleData["RefReturnPointer", "FlushLeft"]],

Cell[StyleData["RefReturnPointer", "Presentation"]],

Cell[StyleData["RefReturnPointer", "Printout", StyleDefinitions -> None]],

Cell[StyleData["RefReturnPointer", "FlushLeftPrintout"],
 StyleMenuListing->None,
 FontColor->GrayLevel[0]],

Cell[StyleData["RefReturnPointer", "DoubleSpacedPrintout"],
 StyleMenuListing->None,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceSourceLink"],
 ConversionRules:>{{"TeX" -> {"", 
      NoOutput[], ""}}, {"HTML" -> {"<!--", "-->"}}},
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontFamily->"Mathematica4",
 FontSize->1,
 FontColor->GrayLevel[1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["ReferenceSourceLink", "Printout", StyleDefinitions -> None]]
}, Closed]],

Cell[StyleData["ReferenceSourceURL"],
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Citation"],
 ConversionRules:>{"TeX" -> {{"", 
      ExtractCitationData[], ""}, {"", Automatic, ""}}},
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(ListDataLink[#2]& ),
 Evaluator->Automatic}],

Cell[StyleData["Citation", "FlushLeft"]],

Cell[StyleData["Citation", "Presentation"]],

Cell[StyleData["Citation", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Citation", "FlushLeftPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["Citation", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefKey"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(EditRef[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["RefKey", "FlushLeft"]],

Cell[StyleData["RefKey", "Presentation"]],

Cell[StyleData["RefKey", "Printout", StyleDefinitions -> None]],

Cell[StyleData["RefKey", "FlushLeftPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["RefKey", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell["References Templates", "Subsubsection",
 StyleMenuListing->None],

Cell["FirstAuthor:<Last>, <FirstInitial>. <MiddleInitial>.", \
"ReferenceTemplate"],

Cell["OtherAuthors:, <Last>, <FirstInitial>. <MiddleInitial>.", \
"ReferenceTemplate"],

Cell["LastAuthor:, & <Last>, <FirstInitial>. <MiddleInitial>.", \
"ReferenceTemplate"],

Cell["FirstEditor:<FirstInitial>. <MiddleInitial>. <Last>", \
"ReferenceTemplate"],

Cell["OtherEditors:, <FirstInitial>. <MiddleInitial>. <Last>", \
"ReferenceTemplate"],

Cell["LastEditor: & <FirstInitial>. <MiddleInitial>. <Last>", \
"ReferenceTemplate"],

Cell["Sorting:Key", "ReferenceTemplate"],

Cell["ReferenceAuthorMax:4", "ReferenceTemplate"],

Cell["ReferenceEditorMax:4", "ReferenceTemplate"],

Cell["ReferenceAuthorMin:1", "ReferenceTemplate"],

Cell["ReferenceEditorMin:1", "ReferenceTemplate"],

Cell["AbbreviatedAuthors:, et al.", "ReferenceTemplate"],

Cell["AbbreviatedEditors:, et al.", "ReferenceTemplate"],

Cell[CellGroupData[{

Cell["Article Templates", "Subsubsubsection"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).  Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>, <PageRange>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>, <PageRange>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).  Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>. \
Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>. \
\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).  Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>. \
Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>. \
\>", "ReferenceTemplate"],

Cell["\<\
(The following template is the default template for \"Article\" references \
that don't match any of the above templates.)\
\>", "Text"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["In Book Templates", "Subsubsubsection"],

Cell["\<\
(The following template is the default template for \"InBook\" references.)\
\>", "Text"],

Cell["\<\
InBook:<Author> (<Year>). <Title>. In <Editor> (Ed.), <BookTitle> (pp. \
<PageRange>). <City>: <Publisher>.\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Whole Book Templates", "Subsubsubsection"],

Cell["\<\
WholeBook:<Author> (<Year>). <BookTitle>. <City>: <Publisher>. Retrieved \
<RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
WholeBook:<Author> (<Year>). <BookTitle>. <City>: <Publisher>.\
\>", "ReferenceTemplate"],

Cell["\<\
WholeBook:<Author> (<Year>). <BookTitle>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
(The following template is the default template for \"Book\" references that \
don't match any of the above templates.)\
\>", "Text"],

Cell["WholeBook:<Author> (<Year>). <BookTitle>. <Publisher>.", \
"ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Thesis Templates", "Subsubsubsection"],

Cell["\<\
PhdThesis:<Author> (<Year>). <Title> (Doctoral Dissertation, <School>, \
<City>). <SourceOfAbstract>, <JournalVolume>, <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
PhdThesis:<Author> (<Year>). <BookTitle>. Unpublished doctoral dissertation, \
<School>, <City>.\
\>", "ReferenceTemplate"],

Cell["\<\
(The following template is the default template for \"PhdThesis\" references \
that don't match any of the above templates.)\
\>", "Text"],

Cell["\<\
PhdThesis:<Author> (<Year>). <Title> (Doctoral Dissertation, <School>, \
<City>). <SourceOfAbstract>, <JournalVolume>, <PageRange>.\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Technical Report Templates", "Subsubsubsection"],

Cell["\<\
(The following template is the default template for \"TechReport\" \
references.)\
\>", "Text"],

Cell["\<\
TechReport:<Author> (<Year>). <Title>. <School>, <City>. <ReportNumber>, \
<Submittedby>\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Online Source Templates", "Subsubsubsection"],

Cell["\<\
(The following template is the default template for \"OnlineSource\" \
references.)\
\>", "Text"],

Cell["\<\
OnlineSource:<Author>, <Title>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Preprint Templates", "Subsubsubsection"],

Cell["\<\
(The following template is the default template for \"Preprint\" references.)\
\
\>", "Text"],

Cell["Preprint:<Author> (<Year>). <Title>. <PublicationStatus>", \
"ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Plain Insertion Template", "Subsubsubsection"],

Cell["\<\
(The following template is the default template for \
\[OpenCurlyDoubleQuote]PlainInsert\" references.)\
\>", "Text"],

Cell["PlainInsert:<InsertedBibText>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Note Templates", "Subsubsubsection"],

Cell["\<\
(The following template is the default template for \"Note\" references.)\
\>", "Text"],

Cell["Note:<NoteText>", "ReferenceTemplate"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Common Data Field Styles", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefTitle"],
 ConversionRules:>{"TeX" -> {"\\textit{", "}"}},
 StyleMenuListing->None,
 FontSlant->"Italic"],

Cell[StyleData["RefType"],
 CellSize->{0.1, 12},
 StyleMenuListing->None],

Cell[StyleData["RefURL"],
 StyleMenuListing->None],

Cell[StyleData["RefRetrievalDate"],
 StyleMenuListing->None],

Cell[StyleData["RefSourceOfAbstract"],
 StyleMenuListing->None],

Cell[StyleData["RefInsertedBibText"],
 StyleMenuListing->None],

Cell[StyleData["RefNote"],
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Book Data Field Styles", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefBookTitle"],
 ConversionRules:>{"TeX" -> {"\\textit{", "}"}},
 StyleMenuListing->None,
 FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell["Journal Data Field Styles", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefJournalTitle"],
 StyleMenuListing->None],

Cell[StyleData["RefJournalVolume"],
 ConversionRules:>{"TeX" -> {"\\textbf{", "}"}},
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["RefJournalNumber"],
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Publisher Data Field Styles", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefPublisher"],
 StyleMenuListing->None],

Cell[StyleData["RefCity"],
 ParagraphIndent->0,
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Author Data Field Styles", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefAuthorGroup"],
 StyleMenuListing->None],

Cell[StyleData["RefAuthorFN"],
 StyleMenuListing->None],

Cell[StyleData["RefAuthorLN"],
 StyleMenuListing->None],

Cell[StyleData["RefAuthorMN"],
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Editor Data Field Styles", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefEditorGroup"],
 StyleMenuListing->None],

Cell[StyleData["RefEditorFN"],
 StyleMenuListing->None],

Cell[StyleData["RefEditorMN"],
 StyleMenuListing->None],

Cell[StyleData["RefEditorLN"],
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["School Data Field Styles", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefSchool"],
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Publication Date Data Field Styles", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefDay"],
 StyleMenuListing->None],

Cell[StyleData["RefMonth"],
 StyleMenuListing->None],

Cell[StyleData["RefYear"],
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Page Data Field Styles: Auto Generated and Contiguous Pages", \
"Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefFirstPage"],
 ParagraphIndent->0,
 StyleMenuListing->None],

Cell[StyleData["RefLastPage"],
 ParagraphIndent->0,
 StyleMenuListing->None]
}, Closed]]
}, Closed]]
}, Closed]]
},
AutoGeneratedPackage->None,
WindowSize->{733, 680},
WindowMargins->{{17, Automatic}, {Automatic, 2}},
TrackCellChangeTimes->False,
MenuPosition->1100,
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (April 3, 2007)",
StyleDefinitions->"StylesheetFormatting.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "AuthorFormCustomization"->{
  Cell[73728, 2734, 234, 9, 70, "AuthorFormCustomizationTemplate",
   CellTags->"AuthorFormCustomization"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"AuthorFormCustomization", 130540, 4887}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[587, 22, 60, 0, 35, 60, 0, "StyleData", "StyleDefinitions", ""],
Cell[650, 24, 191, 4, 57, "Text"],
Cell[CellGroupData[{
Cell[866, 32, 44, 0, 50, "Section"],
Cell[913, 34, 99, 2, 70, "Text"],
Cell[1015, 38, 87, 2, 70, 27, 0, "StyleData", "Notebook", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[1139, 45, 52, 0, 34, "Section"],
Cell[1194, 47, 364, 6, 70, "Text"],
Cell[CellGroupData[{
Cell[1583, 57, 97, 3, 70, 24, 0, "StyleData", "Input", "All",
 MenuPosition->1650,
 MenuCommandKey->"9"],
Cell[1683, 62, 63, 0, 70, 63, 0, "StyleData", "Input", "Condensed"],
Cell[1749, 64, 62, 0, 70, 62, 0, "StyleData", "Input", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[1848, 69, 58, 1, 70, 28, 0, "StyleData", "InputOnly", "All"],
Cell[1909, 72, 67, 0, 70, 67, 0, "StyleData", "InputOnly", "Condensed"],
Cell[1979, 74, 66, 0, 70, 66, 0, "StyleData", "InputOnly", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[2082, 79, 96, 3, 70, 23, 0, "StyleData", "Code", "All",
 MenuPosition->1600,
 MenuCommandKey->"8"],
Cell[2181, 84, 62, 0, 70, 62, 0, "StyleData", "Code", "Condensed"],
Cell[2246, 86, 61, 0, 70, 61, 0, "StyleData", "Code", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[2344, 91, 76, 2, 70, 25, 0, "StyleData", "Output", "All",
 MenuPosition->1700],
Cell[2423, 95, 64, 0, 70, 64, 0, "StyleData", "Output", "Condensed"],
Cell[2490, 97, 63, 0, 70, 63, 0, "StyleData", "Output", "Printout"]
}, Closed]],
Cell[2568, 100, 28, 0, 70, 28, 0, "StyleData", "CellLabel", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[2633, 105, 53, 0, 34, "Section"],
Cell[CellGroupData[{
Cell[2711, 109, 27, 0, 70, "Subsection"],
Cell[CellGroupData[{
Cell[2763, 113, 366, 11, 70, 24, 0, "StyleData", "Title", "All",
 MenuPosition->1100],
Cell[3132, 126, 219, 7, 70, 37, 0, "StyleData", "Title", "FlushLeft"],
Cell[3354, 135, 155, 5, 70, 40, 0, "StyleData", "Title", "Presentation"],
Cell[3512, 142, 63, 0, 70, 63, 0, "StyleData", "Title", "Condensed"],
Cell[3578, 144, 62, 0, 70, 62, 0, "StyleData", "Title", "Printout"],
Cell[3643, 146, 168, 5, 70, 45, 0, "StyleData", "Title", \
"FlushLeftPrintout"],
Cell[3814, 153, 96, 2, 70, 48, 0, "StyleData", "Title", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[3947, 160, 370, 11, 70, 27, 0, "StyleData", "Subtitle", "All",
 MenuPosition->1150],
Cell[4320, 173, 133, 4, 70, 40, 0, "StyleData", "Subtitle", "FlushLeft"],
Cell[4456, 179, 114, 3, 70, 43, 0, "StyleData", "Subtitle", "Presentation"],
Cell[4573, 184, 66, 0, 70, 66, 0, "StyleData", "Subtitle", "Condensed"],
Cell[4642, 186, 65, 0, 70, 65, 0, "StyleData", "Subtitle", "Printout"],
Cell[4710, 188, 139, 4, 70, 48, 0, "StyleData", "Subtitle", \
"FlushLeftPrintout"],
Cell[4852, 194, 146, 4, 70, 51, 0, "StyleData", "Subtitle", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[5047, 204, 29, 0, 70, "Subsection"],
Cell[CellGroupData[{
Cell[5101, 208, 768, 21, 70, 26, 0, "StyleData", "Section", "All",
 CounterIncrements->{
  "Section", "SectionHeader", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}, {
   "Subsubsubsection", 0}},
 MenuPosition->1200,
 MenuCommandKey->"1"],
Cell[5872, 231, 205, 7, 70, 39, 0, "StyleData", "Section", "FlushLeft",
 CounterIncrements->"Section"],
Cell[6080, 240, 115, 3, 70, 42, 0, "StyleData", "Section", "Presentation"],
Cell[6198, 245, 65, 0, 70, 65, 0, "StyleData", "Section", "Condensed"],
Cell[6266, 247, 64, 0, 70, 64, 0, "StyleData", "Section", "Printout"],
Cell[6333, 249, 159, 5, 70, 47, 0, "StyleData", "Section", \
"FlushLeftPrintout"],
Cell[6495, 256, 147, 4, 70, 50, 0, "StyleData", "Section", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[6679, 265, 838, 22, 70, 29, 0, "StyleData", "Subsection", "All",
 CounterIncrements->{
  "Subsection", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsubsection", 0}, {"Subsubsubsection", 0}},
 MenuPosition->1250,
 MenuCommandKey->"2"],
Cell[7520, 289, 229, 7, 70, 42, 0, "StyleData", "Subsection", "FlushLeft"],
Cell[7752, 298, 118, 3, 70, 45, 0, "StyleData", "Subsection", \
"Presentation"],
Cell[7873, 303, 68, 0, 70, 68, 0, "StyleData", "Subsection", "Condensed"],
Cell[7944, 305, 67, 0, 70, 67, 0, "StyleData", "Subsection", "Printout"],
Cell[8014, 307, 162, 5, 70, 50, 0, "StyleData", "Subsection", \
"FlushLeftPrintout"],
Cell[8179, 314, 150, 4, 70, 53, 0, "StyleData", "Subsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[8366, 323, 872, 22, 70, 32, 0, "StyleData", "Subsubsection", "All",
 CounterIncrements->{
  "Subsubsection", "SubsubsectionHeader", "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsubsubsection", 0}},
 MenuPosition->1300,
 MenuCommandKey->"3"],
Cell[9241, 347, 212, 6, 70, 45, 0, "StyleData", "Subsubsection", \
"FlushLeft"],
Cell[9456, 355, 120, 3, 70, 48, 0, "StyleData", "Subsubsection", \
"Presentation"],
Cell[9579, 360, 71, 0, 70, 71, 0, "StyleData", "Subsubsection", "Condensed"],
Cell[9653, 362, 70, 0, 70, 70, 0, "StyleData", "Subsubsection", "Printout"],
Cell[9726, 364, 190, 6, 70, 53, 0, "StyleData", "Subsubsection", \
"FlushLeftPrintout"],
Cell[9919, 372, 152, 4, 70, 56, 0, "StyleData", "Subsubsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[10108, 381, 451, 12, 70, 35, 0, "StyleData", "Subsubsubsection", "All",
 CounterIncrements->{"Subsubsubsection", "SubsubsubsectionHeader"},
 MenuPosition->1350,
 MenuCommandKey->"4"],
Cell[10562, 395, 48, 0, 70, 48, 0, "StyleData", "Subsubsubsection", \
"FlushLeft"],
Cell[10613, 397, 100, 2, 70, 51, 0, "StyleData", "Subsubsubsection", \
"Presentation"],
Cell[10716, 401, 74, 0, 70, 74, 0, "StyleData", "Subsubsubsection", \
"Condensed"],
Cell[10793, 403, 73, 0, 70, 73, 0, "StyleData", "Subsubsubsection", \
"Printout"],
Cell[10869, 405, 129, 3, 70, 56, 0, "StyleData", "Subsubsubsection", \
"FlushLeftPrintout"],
Cell[11001, 410, 132, 3, 70, 59, 0, "StyleData", "Subsubsubsection", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[11194, 420, 39, 0, 34, "Section"],
Cell[CellGroupData[{
Cell[11258, 424, 30, 0, 70, "Subsection"],
Cell[CellGroupData[{
Cell[11313, 428, 317, 9, 70, 23, 0, "StyleData", "Text", "All",
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}},
 MenuPosition->1500,
 MenuCommandKey->"7"],
Cell[11633, 439, 36, 0, 70, 36, 0, "StyleData", "Text", "FlushLeft"],
Cell[11672, 441, 88, 2, 70, 39, 0, "StyleData", "Text", "Presentation"],
Cell[11763, 445, 62, 0, 70, 62, 0, "StyleData", "Text", "Condensed"],
Cell[11828, 447, 61, 0, 70, 61, 0, "StyleData", "Text", "Printout"],
Cell[11892, 449, 136, 4, 70, 44, 0, "StyleData", "Text", \
"FlushLeftPrintout"],
Cell[12031, 455, 139, 4, 70, 47, 0, "StyleData", "Text", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[12231, 466, 73, 2, 34, "Section"],
Cell[CellGroupData[{
Cell[12329, 472, 56, 0, 70, "Subsection"],
Cell[CellGroupData[{
Cell[12410, 476, 32, 0, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[12467, 480, 43, 0, 70, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[12535, 484, 59, 0, 70, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[12619, 488, 182, 6, 70, 31, 0, "StyleData", "SectionLabel", "All",
 StyleMenuListing->None],
Cell[12804, 496, 94, 2, 70, 44, 0, "StyleData", "SectionLabel", "FlushLeft"],
Cell[12901, 500, 75, 1, 70, 47, 0, "StyleData", "SectionLabel", \
"Presentation"],
Cell[12979, 503, 69, 0, 70, 69, 0, "StyleData", "SectionLabel", "Printout"],
Cell[13051, 505, 102, 2, 70, 52, 0, "StyleData", "SectionLabel", \
"FlushLeftPrintout"],
Cell[13156, 509, 83, 1, 70, 55, 0, "StyleData", "SectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[13276, 515, 185, 6, 70, 34, 0, "StyleData", "SubsectionLabel", "All",
 StyleMenuListing->None],
Cell[13464, 523, 97, 2, 70, 47, 0, "StyleData", "SubsectionLabel", \
"FlushLeft"],
Cell[13564, 527, 78, 1, 70, 50, 0, "StyleData", "SubsectionLabel", \
"Presentation"],
Cell[13645, 530, 72, 0, 70, 72, 0, "StyleData", "SubsectionLabel", \
"Printout"],
Cell[13720, 532, 105, 2, 70, 55, 0, "StyleData", "SubsectionLabel", \
"FlushLeftPrintout"],
Cell[13828, 536, 86, 1, 70, 58, 0, "StyleData", "SubsectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[13951, 542, 188, 6, 70, 37, 0, "StyleData", "SubsubsectionLabel", "All",
 StyleMenuListing->None],
Cell[14142, 550, 100, 2, 70, 50, 0, "StyleData", "SubsubsectionLabel", \
"FlushLeft"],
Cell[14245, 554, 81, 1, 70, 53, 0, "StyleData", "SubsubsectionLabel", \
"Presentation"],
Cell[14329, 557, 75, 0, 70, 75, 0, "StyleData", "SubsubsectionLabel", \
"Printout"],
Cell[14407, 559, 108, 2, 70, 58, 0, "StyleData", "SubsubsectionLabel", \
"FlushLeftPrintout"],
Cell[14518, 563, 89, 1, 70, 61, 0, "StyleData", "SubsubsectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[14656, 570, 49, 0, 70, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[14730, 574, 366, 11, 70, 29, 0, "StyleData", "SectionAlt", "All",
 StyleMenuListing->None],
Cell[15099, 587, 154, 5, 70, 42, 0, "StyleData", "SectionAlt", "FlushLeft"],
Cell[15256, 594, 95, 2, 70, 45, 0, "StyleData", "SectionAlt", \
"Presentation"],
Cell[15354, 598, 68, 0, 70, 68, 0, "StyleData", "SectionAlt", "Condensed"],
Cell[15425, 600, 67, 0, 70, 67, 0, "StyleData", "SectionAlt", "Printout"],
Cell[15495, 602, 141, 4, 70, 50, 0, "StyleData", "SectionAlt", \
"FlushLeftPrintout"],
Cell[15639, 608, 128, 3, 70, 53, 0, "StyleData", "SectionAlt", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[15804, 616, 447, 13, 70, 32, 0, "StyleData", "SubsectionAlt", "All",
 StyleMenuListing->None],
Cell[16254, 631, 209, 6, 70, 45, 0, "StyleData", "SubsectionAlt", \
"FlushLeft"],
Cell[16466, 639, 98, 2, 70, 48, 0, "StyleData", "SubsectionAlt", \
"Presentation"],
Cell[16567, 643, 71, 0, 70, 71, 0, "StyleData", "SubsectionAlt", \
"Condensed"],
Cell[16641, 645, 70, 0, 70, 70, 0, "StyleData", "SubsectionAlt", "Printout"],
Cell[16714, 647, 144, 4, 70, 53, 0, "StyleData", "SubsectionAlt", \
"FlushLeftPrintout"],
Cell[16861, 653, 130, 3, 70, 56, 0, "StyleData", "SubsectionAlt", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[17028, 661, 498, 13, 70, 35, 0, "StyleData", "SubsubsectionAlt", "All",
 StyleMenuListing->None],
Cell[17529, 676, 192, 5, 70, 48, 0, "StyleData", "SubsubsectionAlt", \
"FlushLeft"],
Cell[17724, 683, 100, 2, 70, 51, 0, "StyleData", "SubsubsectionAlt", \
"Presentation"],
Cell[17827, 687, 74, 0, 70, 74, 0, "StyleData", "SubsubsectionAlt", \
"Condensed"],
Cell[17904, 689, 73, 0, 70, 73, 0, "StyleData", "SubsubsectionAlt", \
"Printout"],
Cell[17980, 691, 172, 5, 70, 56, 0, "StyleData", "SubsubsectionAlt", \
"FlushLeftPrintout"],
Cell[18155, 698, 133, 3, 70, 59, 0, "StyleData", "SubsubsectionAlt", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[18373, 710, 42, 0, 70, "Subsection"],
Cell[CellGroupData[{
Cell[18440, 714, 33, 0, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[18498, 718, 410, 11, 70, 31, 0, "StyleData", "TextNoIndent", "All",
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}},
 StyleMenuListing->None],
Cell[18911, 731, 44, 0, 70, 44, 0, "StyleData", "TextNoIndent", "FlushLeft"],
Cell[18958, 733, 96, 2, 70, 47, 0, "StyleData", "TextNoIndent", \
"Presentation"],
Cell[19057, 737, 70, 0, 70, 70, 0, "StyleData", "TextNoIndent", "Condensed"],
Cell[19130, 739, 69, 0, 70, 69, 0, "StyleData", "TextNoIndent", "Printout"],
Cell[19202, 741, 144, 4, 70, 52, 0, "StyleData", "TextNoIndent", \
"FlushLeftPrintout"],
Cell[19349, 747, 147, 4, 70, 55, 0, "StyleData", "TextNoIndent", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[19533, 756, 393, 9, 70, 35, 0, "StyleData", "TextContinuation", "All",
 CounterIncrements->"TextContinuation",
 CounterAssignments->{{"Item1Numbered", 0}},
 StyleMenuListing->None],
Cell[19929, 767, 48, 0, 70, 48, 0, "StyleData", "TextContinuation", \
"FlushLeft"],
Cell[19980, 769, 100, 2, 70, 51, 0, "StyleData", "TextContinuation", \
"Presentation"],
Cell[20083, 773, 74, 0, 70, 74, 0, "StyleData", "TextContinuation", \
"Condensed"],
Cell[20160, 775, 148, 4, 70, 56, 0, "StyleData", "TextContinuation", \
"FlushLeftPrintout"],
Cell[20311, 781, 151, 4, 70, 59, 0, "StyleData", "TextContinuation", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[20511, 791, 32, 0, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[20568, 795, 33, 0, 70, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[20626, 799, 39, 0, 70, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[20690, 803, 519, 13, 70, 24, 0, "StyleData", "Item1", "All",
 CounterIncrements->"Item1",
 MenuPosition->1710],
Cell[21212, 818, 37, 0, 70, 37, 0, "StyleData", "Item1", "FlushLeft"],
Cell[21252, 820, 114, 3, 70, 40, 0, "StyleData", "Item1", "Presentation",
 StyleMenuListing->None],
Cell[21369, 825, 63, 0, 70, 63, 0, "StyleData", "Item1", "Condensed"],
Cell[21435, 827, 62, 0, 70, 62, 0, "StyleData", "Item1", "Printout"],
Cell[21500, 829, 117, 3, 70, 45, 0, "StyleData", "Item1", "FlushLeftPrintout",
 
 StyleMenuListing->None],
Cell[21620, 834, 142, 4, 70, 48, 0, "StyleData", "Item1", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[21799, 843, 519, 13, 70, 24, 0, "StyleData", "Item2", "All",
 CounterIncrements->"Item2",
 MenuPosition->1720],
Cell[22321, 858, 37, 0, 70, 37, 0, "StyleData", "Item2", "FlushLeft"],
Cell[22361, 860, 114, 3, 70, 40, 0, "StyleData", "Item2", "Presentation",
 StyleMenuListing->None],
Cell[22478, 865, 63, 0, 70, 63, 0, "StyleData", "Item2", "Condensed"],
Cell[22544, 867, 62, 0, 70, 62, 0, "StyleData", "Item2", "Printout"],
Cell[22609, 869, 118, 3, 70, 45, 0, "StyleData", "Item2", "FlushLeftPrintout",
 
 StyleMenuListing->None],
Cell[22730, 874, 143, 4, 70, 48, 0, "StyleData", "Item2", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[22910, 883, 541, 14, 70, 24, 0, "StyleData", "Item3", "All",
 CounterIncrements->"Item3",
 MenuPosition->1730],
Cell[23454, 899, 37, 0, 70, 37, 0, "StyleData", "Item3", "FlushLeft"],
Cell[23494, 901, 114, 3, 70, 40, 0, "StyleData", "Item3", "Presentation",
 StyleMenuListing->None],
Cell[23611, 906, 63, 0, 70, 63, 0, "StyleData", "Item3", "Condensed"],
Cell[23677, 908, 62, 0, 70, 62, 0, "StyleData", "Item3", "Printout"],
Cell[23742, 910, 118, 3, 70, 45, 0, "StyleData", "Item3", "FlushLeftPrintout",
 
 StyleMenuListing->None],
Cell[23863, 915, 143, 4, 70, 48, 0, "StyleData", "Item3", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[24043, 924, 228, 7, 70, 29, 0, "StyleData", "Item1Label", "All",
 StyleMenuListing->None],
Cell[24274, 933, 42, 0, 70, 42, 0, "StyleData", "Item1Label", "FlushLeft"],
Cell[24319, 935, 113, 3, 70, 45, 0, "StyleData", "Item1Label", "Presentation",
 
 StyleMenuListing->None],
Cell[24435, 940, 67, 0, 70, 67, 0, "StyleData", "Item1Label", "Printout"],
Cell[24505, 942, 118, 3, 70, 50, 0, "StyleData", "Item1Label", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[24626, 947, 121, 3, 70, 53, 0, "StyleData", "Item1Label", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[24784, 955, 206, 6, 70, 29, 0, "StyleData", "Item2Label", "All",
 StyleMenuListing->None],
Cell[24993, 963, 42, 0, 70, 42, 0, "StyleData", "Item2Label", "FlushLeft"],
Cell[25038, 965, 113, 3, 70, 45, 0, "StyleData", "Item2Label", "Presentation",
 
 StyleMenuListing->None],
Cell[25154, 970, 67, 0, 70, 67, 0, "StyleData", "Item2Label", "Printout"],
Cell[25224, 972, 103, 2, 70, 50, 0, "StyleData", "Item2Label", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[25330, 976, 106, 2, 70, 53, 0, "StyleData", "Item2Label", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[25473, 983, 206, 6, 70, 29, 0, "StyleData", "Item3Label", "All",
 StyleMenuListing->None],
Cell[25682, 991, 42, 0, 70, 42, 0, "StyleData", "Item3Label", "FlushLeft"],
Cell[25727, 993, 113, 3, 70, 45, 0, "StyleData", "Item3Label", "Presentation",
 
 StyleMenuListing->None],
Cell[25843, 998, 67, 0, 70, 67, 0, "StyleData", "Item3Label", "Printout"],
Cell[25913, 1000, 103, 2, 70, 50, 0, "StyleData", "Item3Label", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[26019, 1004, 106, 2, 70, 53, 0, "StyleData", "Item3Label", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26174, 1012, 70, 1, 70, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[26269, 1017, 658, 16, 70, 32, 0, "StyleData", "Item1Numbered", "All",
 CounterIncrements->"Item1Numbered",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}},
 MenuPosition->1740],
Cell[26930, 1035, 45, 0, 70, 45, 0, "StyleData", "Item1Numbered", \
"FlushLeft"],
Cell[26978, 1037, 122, 3, 70, 48, 0, "StyleData", "Item1Numbered", \
"Presentation",
 StyleMenuListing->None],
Cell[27103, 1042, 71, 0, 70, 71, 0, "StyleData", "Item1Numbered", \
"Condensed"],
Cell[27177, 1044, 70, 0, 70, 70, 0, "StyleData", "Item1Numbered", \
"Printout"],
Cell[27250, 1046, 125, 3, 70, 53, 0, "StyleData", "Item1Numbered", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[27378, 1051, 150, 4, 70, 56, 0, "StyleData", "Item1Numbered", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[27565, 1060, 673, 17, 70, 32, 0, "StyleData", "Item2Numbered", "All",
 CounterIncrements->"Item2Numbered",
 MenuPosition->1750],
Cell[28241, 1079, 45, 0, 70, 45, 0, "StyleData", "Item2Numbered", \
"FlushLeft"],
Cell[28289, 1081, 122, 3, 70, 48, 0, "StyleData", "Item2Numbered", \
"Presentation",
 StyleMenuListing->None],
Cell[28414, 1086, 71, 0, 70, 71, 0, "StyleData", "Item2Numbered", \
"Condensed"],
Cell[28488, 1088, 70, 0, 70, 70, 0, "StyleData", "Item2Numbered", \
"Printout"],
Cell[28561, 1090, 126, 3, 70, 53, 0, "StyleData", "Item2Numbered", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[28690, 1095, 151, 4, 70, 56, 0, "StyleData", "Item2Numbered", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[28878, 1104, 644, 16, 70, 32, 0, "StyleData", "Item3Numbered", "All",
 CounterIncrements->"Item3Numbered",
 MenuPosition->1760],
Cell[29525, 1122, 45, 0, 70, 45, 0, "StyleData", "Item3Numbered", \
"FlushLeft"],
Cell[29573, 1124, 122, 3, 70, 48, 0, "StyleData", "Item3Numbered", \
"Presentation",
 StyleMenuListing->None],
Cell[29698, 1129, 71, 0, 70, 71, 0, "StyleData", "Item3Numbered", \
"Condensed"],
Cell[29772, 1131, 70, 0, 70, 70, 0, "StyleData", "Item3Numbered", \
"Printout"],
Cell[29845, 1133, 126, 3, 70, 53, 0, "StyleData", "Item3Numbered", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[29974, 1138, 151, 4, 70, 56, 0, "StyleData", "Item3Numbered", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[30162, 1147, 223, 6, 70, 37, 0, "StyleData", "Item1NumberedLabel", "All",
 
 StyleMenuListing->None],
Cell[30388, 1155, 50, 0, 70, 50, 0, "StyleData", "Item1NumberedLabel", \
"FlushLeft"],
Cell[30441, 1157, 121, 3, 70, 53, 0, "StyleData", "Item1NumberedLabel", \
"Presentation",
 StyleMenuListing->None],
Cell[30565, 1162, 75, 0, 70, 75, 0, "StyleData", "Item1NumberedLabel", \
"Printout"],
Cell[30643, 1164, 126, 3, 70, 58, 0, "StyleData", "Item1NumberedLabel", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[30772, 1169, 129, 3, 70, 61, 0, "StyleData", "Item1NumberedLabel", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[30938, 1177, 223, 6, 70, 37, 0, "StyleData", "Item2NumberedLabel", "All",
 
 StyleMenuListing->None],
Cell[31164, 1185, 50, 0, 70, 50, 0, "StyleData", "Item2NumberedLabel", \
"FlushLeft"],
Cell[31217, 1187, 121, 3, 70, 53, 0, "StyleData", "Item2NumberedLabel", \
"Presentation",
 StyleMenuListing->None],
Cell[31341, 1192, 75, 0, 70, 75, 0, "StyleData", "Item2NumberedLabel", \
"Printout"],
Cell[31419, 1194, 111, 2, 70, 58, 0, "StyleData", "Item2NumberedLabel", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[31533, 1198, 114, 2, 70, 61, 0, "StyleData", "Item2NumberedLabel", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[31684, 1205, 223, 6, 70, 37, 0, "StyleData", "Item3NumberedLabel", "All",
 
 StyleMenuListing->None],
Cell[31910, 1213, 50, 0, 70, 50, 0, "StyleData", "Item3NumberedLabel", \
"FlushLeft"],
Cell[31963, 1215, 121, 3, 70, 53, 0, "StyleData", "Item3NumberedLabel", \
"Presentation",
 StyleMenuListing->None],
Cell[32087, 1220, 75, 0, 70, 75, 0, "StyleData", "Item3NumberedLabel", \
"Printout"],
Cell[32165, 1222, 111, 2, 70, 58, 0, "StyleData", "Item3NumberedLabel", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[32279, 1226, 114, 2, 70, 61, 0, "StyleData", "Item3NumberedLabel", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[32442, 1234, 54, 0, 70, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[32521, 1238, 292, 6, 70, 33, 0, "StyleData", "Item1Paragraph", "All",
 MenuPosition->1770],
Cell[32816, 1246, 46, 0, 70, 46, 0, "StyleData", "Item1Paragraph", \
"FlushLeft"],
Cell[32865, 1248, 123, 3, 70, 49, 0, "StyleData", "Item1Paragraph", \
"Presentation",
 StyleMenuListing->None],
Cell[32991, 1253, 72, 0, 70, 72, 0, "StyleData", "Item1Paragraph", \
"Condensed"],
Cell[33066, 1255, 71, 0, 70, 71, 0, "StyleData", "Item1Paragraph", \
"Printout"],
Cell[33140, 1257, 127, 3, 70, 54, 0, "StyleData", "Item1Paragraph", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[33270, 1262, 152, 4, 70, 57, 0, "StyleData", "Item1Paragraph", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[33459, 1271, 292, 6, 70, 33, 0, "StyleData", "Item2Paragraph", "All",
 MenuPosition->1780],
Cell[33754, 1279, 46, 0, 70, 46, 0, "StyleData", "Item2Paragraph", \
"FlushLeft"],
Cell[33803, 1281, 123, 3, 70, 49, 0, "StyleData", "Item2Paragraph", \
"Presentation",
 StyleMenuListing->None],
Cell[33929, 1286, 72, 0, 70, 72, 0, "StyleData", "Item2Paragraph", \
"Condensed"],
Cell[34004, 1288, 71, 0, 70, 71, 0, "StyleData", "Item2Paragraph", \
"Printout"],
Cell[34078, 1290, 127, 3, 70, 54, 0, "StyleData", "Item2Paragraph", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[34208, 1295, 152, 4, 70, 57, 0, "StyleData", "Item2Paragraph", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[34397, 1304, 292, 6, 70, 33, 0, "StyleData", "Item3Paragraph", "All",
 MenuPosition->1790],
Cell[34692, 1312, 46, 0, 70, 46, 0, "StyleData", "Item3Paragraph", \
"FlushLeft"],
Cell[34741, 1314, 123, 3, 70, 49, 0, "StyleData", "Item3Paragraph", \
"Presentation",
 StyleMenuListing->None],
Cell[34867, 1319, 72, 0, 70, 72, 0, "StyleData", "Item3Paragraph", \
"Condensed"],
Cell[34942, 1321, 71, 0, 70, 71, 0, "StyleData", "Item3Paragraph", \
"Printout"],
Cell[35016, 1323, 127, 3, 70, 54, 0, "StyleData", "Item3Paragraph", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[35146, 1328, 152, 4, 70, 57, 0, "StyleData", "Item3Paragraph", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[35383, 1341, 33, 0, 70, "Subsection"],
Cell[CellGroupData[{
Cell[35441, 1345, 34, 0, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[35500, 1349, 474, 13, 70, 27, 0, "StyleData", "Equation", "All",
 CounterIncrements->"Equation",
 MenuPosition->1400,
 MenuCommandKey->"5"],
Cell[35977, 1364, 96, 2, 70, 40, 0, "StyleData", "Equation", "FlushLeft"],
Cell[36076, 1368, 94, 2, 70, 43, 0, "StyleData", "Equation", "Presentation"],
Cell[36173, 1372, 66, 0, 70, 66, 0, "StyleData", "Equation", "Condensed"],
Cell[36242, 1374, 65, 0, 70, 65, 0, "StyleData", "Equation", "Printout"],
Cell[36310, 1376, 118, 3, 70, 48, 0, "StyleData", "Equation", \
"FlushLeftPrintout"],
Cell[36431, 1381, 98, 2, 70, 51, 0, "StyleData", "Equation", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[36566, 1388, 479, 12, 70, 32, 0, "StyleData", "EquationGroup", "All",
 StyleMenuListing->None],
Cell[37048, 1402, 101, 2, 70, 45, 0, "StyleData", "EquationGroup", \
"FlushLeft"],
Cell[37152, 1406, 97, 2, 70, 48, 0, "StyleData", "EquationGroup", \
"Presentation"],
Cell[37252, 1410, 71, 0, 70, 71, 0, "StyleData", "EquationGroup", \
"Condensed"],
Cell[37326, 1412, 70, 0, 70, 70, 0, "StyleData", "EquationGroup", \
"Printout"],
Cell[37399, 1414, 123, 3, 70, 53, 0, "StyleData", "EquationGroup", \
"FlushLeftPrintout"],
Cell[37525, 1419, 103, 2, 70, 56, 0, "StyleData", "EquationGroup", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[37665, 1426, 694, 16, 70, 39, 0, "StyleData", "EquationGroupAligned", \
"All",
 StyleMenuListing->None],
Cell[38362, 1444, 107, 2, 70, 52, 0, "StyleData", "EquationGroupAligned", \
"FlushLeft"],
Cell[38472, 1448, 104, 2, 70, 55, 0, "StyleData", "EquationGroupAligned", \
"Presentation"],
Cell[38579, 1452, 78, 0, 70, 78, 0, "StyleData", "EquationGroupAligned", \
"Condensed"],
Cell[38660, 1454, 77, 0, 70, 77, 0, "StyleData", "EquationGroupAligned", \
"Printout"],
Cell[38740, 1456, 130, 3, 70, 60, 0, "StyleData", "EquationGroupAligned", \
"FlushLeftPrintout"],
Cell[38873, 1461, 110, 2, 70, 63, 0, "StyleData", "EquationGroupAligned", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[39032, 1469, 43, 0, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[39100, 1473, 868, 25, 70, 35, 0, "StyleData", "EquationNumbered", "All",
 CounterIncrements->"EquationNumbered",
 MenuPosition->1450,
 MenuCommandKey->"6",
 StyleMenuListing->Automatic],
Cell[39971, 1500, 104, 2, 70, 48, 0, "StyleData", "EquationNumbered", \
"FlushLeft"],
Cell[40078, 1504, 102, 2, 70, 51, 0, "StyleData", "EquationNumbered", \
"Presentation"],
Cell[40183, 1508, 74, 0, 70, 74, 0, "StyleData", "EquationNumbered", \
"Condensed"],
Cell[40260, 1510, 73, 0, 70, 73, 0, "StyleData", "EquationNumbered", \
"Printout"],
Cell[40336, 1512, 126, 3, 70, 56, 0, "StyleData", "EquationNumbered", \
"FlushLeftPrintout"],
Cell[40465, 1517, 106, 2, 70, 59, 0, "StyleData", "EquationNumbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[40608, 1524, 946, 25, 70, 40, 0, "StyleData", "EquationGroupNumbered", \
"All",
 CounterIncrements->"EquationNumbered",
 StyleMenuListing->None],
Cell[41557, 1551, 108, 2, 70, 53, 0, "StyleData", "EquationGroupNumbered", \
"FlushLeft"],
Cell[41668, 1555, 105, 2, 70, 56, 0, "StyleData", "EquationGroupNumbered", \
"Presentation"],
Cell[41776, 1559, 79, 0, 70, 79, 0, "StyleData", "EquationGroupNumbered", \
"Condensed"],
Cell[41858, 1561, 78, 0, 70, 78, 0, "StyleData", "EquationGroupNumbered", \
"Printout"],
Cell[41939, 1563, 131, 3, 70, 61, 0, "StyleData", "EquationGroupNumbered", \
"FlushLeftPrintout"],
Cell[42073, 1568, 111, 2, 70, 64, 0, "StyleData", "EquationGroupNumbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[42221, 1575, 1177, 30, 70, 47, 0, "StyleData", \
"EquationGroupAlignedNumbered", "All",
 CounterIncrements->"EquationNumbered",
 StyleMenuListing->None],
Cell[43401, 1607, 115, 2, 70, 60, 0, "StyleData", \
"EquationGroupAlignedNumbered", "FlushLeft"],
Cell[43519, 1611, 112, 2, 70, 63, 0, "StyleData", \
"EquationGroupAlignedNumbered", "Presentation"],
Cell[43634, 1615, 88, 1, 70, 88, 1, "StyleData", \
"EquationGroupAlignedNumbered", "Condensed"],
Cell[43725, 1618, 87, 1, 70, 87, 1, "StyleData", \
"EquationGroupAlignedNumbered", "Printout"],
Cell[43815, 1621, 138, 3, 70, 68, 0, "StyleData", \
"EquationGroupAlignedNumbered", "FlushLeftPrintout"],
Cell[43956, 1626, 118, 2, 70, 71, 0, "StyleData", \
"EquationGroupAlignedNumbered", "DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[44111, 1633, 109, 3, 70, 33, 0, "StyleData", "EquationNumber", "All",
 StyleMenuListing->None],
Cell[44223, 1638, 74, 1, 70, 46, 0, "StyleData", "EquationNumber", \
"FlushLeft"],
Cell[44300, 1641, 77, 1, 70, 49, 0, "StyleData", "EquationNumber", \
"Presentation"],
Cell[44380, 1644, 71, 0, 70, 71, 0, "StyleData", "EquationNumber", \
"Printout"],
Cell[44454, 1646, 82, 1, 70, 54, 0, "StyleData", "EquationNumber", \
"FlushLeftPrintout"],
Cell[44539, 1649, 85, 1, 70, 57, 0, "StyleData", "EquationNumber", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[44673, 1656, 49, 0, 70, "Subsubsection"],
Cell[44725, 1658, 56, 1, 70, 31, 0, "StyleData", "EquationGrid", "All",
 StyleMenuListing->None],
Cell[44784, 1661, 57, 1, 70, 32, 0, "StyleData", "SplitEquation", "All",
 StyleMenuListing->None],
Cell[44844, 1664, 53, 1, 70, 28, 0, "StyleData", "Piecewise", "All",
 StyleMenuListing->None],
Cell[44900, 1667, 50, 1, 70, 25, 0, "StyleData", "Matrix", "All",
 StyleMenuListing->None]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[44999, 1674, 48, 0, 70, "Subsection"],
Cell[CellGroupData[{
Cell[45072, 1678, 31, 0, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[45128, 1682, 670, 18, 70, 25, 0, "StyleData", "Figure", "All",
 CounterIncrements->"Figure",
 MenuPosition->1800],
Cell[45801, 1702, 60, 1, 70, 38, 0, "StyleData", "Figure", "FlushLeft"],
Cell[45864, 1705, 119, 3, 70, 41, 0, "StyleData", "Figure", "Presentation"],
Cell[45986, 1710, 64, 0, 70, 64, 0, "StyleData", "Figure", "Condensed"],
Cell[46053, 1712, 63, 0, 70, 63, 0, "StyleData", "Figure", "Printout"],
Cell[46119, 1714, 121, 3, 70, 46, 0, "StyleData", "Figure", \
"FlushLeftPrintout"],
Cell[46243, 1719, 110, 2, 70, 49, 0, "StyleData", "Figure", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[46390, 1726, 656, 18, 70, 32, 0, "StyleData", "FigureCaption", "All",
 CounterIncrements->"FigureCaption",
 CounterAssignments->{{"Nil", 0}},
 MenuPosition->1810],
Cell[47049, 1746, 101, 2, 70, 45, 0, "StyleData", "FigureCaption", \
"FlushLeft"],
Cell[47153, 1750, 97, 2, 70, 48, 0, "StyleData", "FigureCaption", \
"Presentation"],
Cell[47253, 1754, 71, 0, 70, 71, 0, "StyleData", "FigureCaption", \
"Condensed"],
Cell[47327, 1756, 70, 0, 70, 70, 0, "StyleData", "FigureCaption", \
"Printout"],
Cell[47400, 1758, 121, 3, 70, 53, 0, "StyleData", "FigureCaption", \
"FlushLeftPrintout"],
Cell[47524, 1763, 126, 3, 70, 56, 0, "StyleData", "FigureCaption", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[47687, 1771, 180, 6, 70, 37, 0, "StyleData", "FigureCaptionLabel", "All",
 
 StyleMenuListing->None],
Cell[47870, 1779, 75, 0, 70, 75, 0, "StyleData", "FigureCaptionLabel", \
"Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[47994, 1785, 32, 0, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[48051, 1789, 545, 13, 70, 26, 0, "StyleData", "Picture", "All",
 CounterIncrements->"Picture",
 StyleMenuListing->None],
Cell[48599, 1804, 61, 1, 70, 39, 0, "StyleData", "Picture", "FlushLeft"],
Cell[48663, 1807, 105, 2, 70, 42, 0, "StyleData", "Picture", "Presentation"],
Cell[48771, 1811, 65, 0, 70, 65, 0, "StyleData", "Picture", "Condensed"],
Cell[48839, 1813, 64, 0, 70, 64, 0, "StyleData", "Picture", "Printout"],
Cell[48906, 1815, 122, 3, 70, 47, 0, "StyleData", "Picture", \
"FlushLeftPrintout"],
Cell[49031, 1820, 111, 2, 70, 50, 0, "StyleData", "Picture", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[49179, 1827, 664, 18, 70, 33, 0, "StyleData", "PictureCaption", "All",
 CounterIncrements->"PictureCaption",
 CounterAssignments->{{"Nil", 0}},
 StyleMenuListing->None],
Cell[49846, 1847, 102, 2, 70, 46, 0, "StyleData", "PictureCaption", \
"FlushLeft"],
Cell[49951, 1851, 98, 2, 70, 49, 0, "StyleData", "PictureCaption", \
"Presentation"],
Cell[50052, 1855, 72, 0, 70, 72, 0, "StyleData", "PictureCaption", \
"Condensed"],
Cell[50127, 1857, 71, 0, 70, 71, 0, "StyleData", "PictureCaption", \
"Printout"],
Cell[50201, 1859, 122, 3, 70, 54, 0, "StyleData", "PictureCaption", \
"FlushLeftPrintout"],
Cell[50326, 1864, 127, 3, 70, 57, 0, "StyleData", "PictureCaption", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[50490, 1872, 159, 5, 70, 38, 0, "StyleData", "PictureCaptionLabel", \
"All",
 StyleMenuListing->None],
Cell[50652, 1879, 76, 0, 70, 76, 0, "StyleData", "PictureCaptionLabel", \
"Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[50777, 1885, 39, 0, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[50841, 1889, 513, 13, 70, 26, 0, "StyleData", "Program", "All",
 CounterIncrements->"Program",
 MenuPosition->1850],
Cell[51357, 1904, 39, 0, 70, 39, 0, "StyleData", "Program", "FlushLeft"],
Cell[51399, 1906, 91, 2, 70, 42, 0, "StyleData", "Program", "Presentation"],
Cell[51493, 1910, 65, 0, 70, 65, 0, "StyleData", "Program", "Condensed"],
Cell[51561, 1912, 64, 0, 70, 64, 0, "StyleData", "Program", "Printout"],
Cell[51628, 1914, 119, 3, 70, 47, 0, "StyleData", "Program", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[51750, 1919, 122, 3, 70, 50, 0, "StyleData", "Program", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[51909, 1927, 608, 16, 70, 33, 0, "StyleData", "ProgramCaption", "All",
 CounterIncrements->"ProgramCaption",
 CounterAssignments->{{"Nil", 0}},
 MenuPosition->1860],
Cell[52520, 1945, 46, 0, 70, 46, 0, "StyleData", "ProgramCaption", \
"FlushLeft"],
Cell[52569, 1947, 98, 2, 70, 49, 0, "StyleData", "ProgramCaption", \
"Presentation"],
Cell[52670, 1951, 72, 0, 70, 72, 0, "StyleData", "ProgramCaption", \
"Condensed"],
Cell[52745, 1953, 71, 0, 70, 71, 0, "StyleData", "ProgramCaption", \
"Printout"],
Cell[52819, 1955, 101, 2, 70, 54, 0, "StyleData", "ProgramCaption", \
"FlushLeftPrintout"],
Cell[52923, 1959, 105, 2, 70, 57, 0, "StyleData", "ProgramCaption", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[53065, 1966, 159, 5, 70, 38, 0, "StyleData", "ProgramCaptionLabel", \
"All",
 StyleMenuListing->None],
Cell[53227, 1973, 76, 0, 70, 76, 0, "StyleData", "ProgramCaptionLabel", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[53340, 1978, 551, 15, 70, 30, 0, "StyleData", "ProgramText", "All",
 CounterIncrements->"ProgramText",
 StyleMenuListing->None],
Cell[53894, 1995, 43, 0, 70, 43, 0, "StyleData", "ProgramText", "FlushLeft"],
Cell[53940, 1997, 96, 2, 70, 46, 0, "StyleData", "ProgramText", \
"Presentation"],
Cell[54039, 2001, 69, 0, 70, 69, 0, "StyleData", "ProgramText", "Condensed"],
Cell[54111, 2003, 68, 0, 70, 68, 0, "StyleData", "ProgramText", "Printout"],
Cell[54182, 2005, 99, 2, 70, 51, 0, "StyleData", "ProgramText", \
"FlushLeftPrintout"],
Cell[54284, 2009, 102, 2, 70, 54, 0, "StyleData", "ProgramText", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[54435, 2017, 31, 0, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[54491, 2021, 1011, 27, 70, 29, 0, "StyleData", "TableTitle", "All",
 CounterIncrements->"TableTitle",
 CounterAssignments->{{"Nil", 0}},
 MenuPosition->1900],
Cell[55505, 2050, 42, 0, 70, 42, 0, "StyleData", "TableTitle", "FlushLeft"],
Cell[55550, 2052, 95, 2, 70, 45, 0, "StyleData", "TableTitle", \
"Presentation"],
Cell[55648, 2056, 68, 0, 70, 68, 0, "StyleData", "TableTitle", "Condensed"],
Cell[55719, 2058, 67, 0, 70, 67, 0, "StyleData", "TableTitle", "Printout"],
Cell[55789, 2060, 98, 2, 70, 50, 0, "StyleData", "TableTitle", \
"FlushLeftPrintout"],
Cell[55890, 2064, 101, 2, 70, 53, 0, "StyleData", "TableTitle", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[56028, 2071, 466, 14, 70, 34, 0, "StyleData", "TableTitleLabel", "All",
 CounterIncrements->"TableTitleLabel",
 StyleMenuListing->None],
Cell[56497, 2087, 72, 0, 70, 72, 0, "StyleData", "TableTitleLabel", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[56606, 2092, 1146, 29, 70, 24, 0, "StyleData", "Table", "All",
 CounterIncrements->"Table",
 CounterAssignments->{{"TableNote", 0}},
 MenuPosition->1910],
Cell[57755, 2123, 37, 0, 70, 37, 0, "StyleData", "Table", "FlushLeft"],
Cell[57795, 2125, 89, 2, 70, 40, 0, "StyleData", "Table", "Presentation"],
Cell[57887, 2129, 63, 0, 70, 63, 0, "StyleData", "Table", "Condensed"],
Cell[57953, 2131, 62, 0, 70, 62, 0, "StyleData", "Table", "Printout"],
Cell[58018, 2133, 117, 3, 70, 45, 0, "StyleData", "Table", \
"FlushLeftPrintout"],
Cell[58138, 2138, 120, 3, 70, 48, 0, "StyleData", "Table", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[58295, 2146, 463, 15, 70, 28, 0, "StyleData", "TableNote", "All",
 CounterIncrements->"TableNote",
 MenuPosition->1920],
Cell[58761, 2163, 41, 0, 70, 41, 0, "StyleData", "TableNote", "FlushLeft"],
Cell[58805, 2165, 113, 3, 70, 44, 0, "StyleData", "TableNote", \
"Presentation"],
Cell[58921, 2170, 67, 0, 70, 67, 0, "StyleData", "TableNote", "Condensed"],
Cell[58991, 2172, 66, 0, 70, 66, 0, "StyleData", "TableNote", "Printout"],
Cell[59060, 2174, 97, 2, 70, 49, 0, "StyleData", "TableNote", \
"FlushLeftPrintout"],
Cell[59160, 2178, 122, 3, 70, 52, 0, "StyleData", "TableNote", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[59319, 2186, 47, 0, 70, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[59391, 2190, 924, 25, 70, 34, 0, "StyleData", "TableColumnHead", "All",
 StyleMenuListing->None],
Cell[60318, 2217, 47, 0, 70, 47, 0, "StyleData", "TableColumnHead", \
"FlushLeft"],
Cell[60368, 2219, 65, 1, 70, 50, 0, "StyleData", "TableColumnHead", \
"Presentation"],
Cell[60436, 2222, 72, 0, 70, 72, 0, "StyleData", "TableColumnHead", \
"Printout"],
Cell[60511, 2224, 70, 1, 70, 55, 0, "StyleData", "TableColumnHead", \
"FlushLeftPrintout"],
Cell[60584, 2227, 73, 1, 70, 58, 0, "StyleData", "TableColumnHead", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[60694, 2233, 946, 26, 70, 32, 0, "StyleData", "TableSpanHead", "All",
 StyleMenuListing->None],
Cell[61643, 2261, 45, 0, 70, 45, 0, "StyleData", "TableSpanHead", \
"FlushLeft"],
Cell[61691, 2263, 63, 1, 70, 48, 0, "StyleData", "TableSpanHead", \
"Presentation"],
Cell[61757, 2266, 70, 0, 70, 70, 0, "StyleData", "TableSpanHead", \
"Printout"],
Cell[61830, 2268, 68, 1, 70, 53, 0, "StyleData", "TableSpanHead", \
"FlushLeftPrintout"],
Cell[61901, 2271, 71, 1, 70, 56, 0, "StyleData", "TableSpanHead", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[62009, 2277, 854, 24, 70, 28, 0, "StyleData", "TableText", "All",
 StyleMenuListing->None],
Cell[62866, 2303, 41, 0, 70, 41, 0, "StyleData", "TableText", "FlushLeft"],
Cell[62910, 2305, 59, 1, 70, 44, 0, "StyleData", "TableText", \
"Presentation"],
Cell[62972, 2308, 66, 0, 70, 66, 0, "StyleData", "TableText", "Printout"],
Cell[63041, 2310, 64, 1, 70, 49, 0, "StyleData", "TableText", \
"FlushLeftPrintout"],
Cell[63108, 2313, 89, 2, 70, 52, 0, "StyleData", "TableText", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[63234, 2320, 624, 18, 70, 32, 0, "StyleData", "TableSpanText", "All",
 StyleMenuListing->None],
Cell[63861, 2340, 45, 0, 70, 45, 0, "StyleData", "TableSpanText", \
"FlushLeft"],
Cell[63909, 2342, 63, 1, 70, 48, 0, "StyleData", "TableSpanText", \
"Presentation"],
Cell[63975, 2345, 70, 0, 70, 70, 0, "StyleData", "TableSpanText", \
"Printout"],
Cell[64048, 2347, 68, 1, 70, 53, 0, "StyleData", "TableSpanText", \
"FlushLeftPrintout"],
Cell[64119, 2350, 71, 1, 70, 56, 0, "StyleData", "TableSpanText", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[64205, 2354, 760, 19, 70, 31, 0, "StyleData", "TableSubGrid", "All",
 StyleMenuListing->None],
Cell[64968, 2375, 466, 11, 70, 34, 0, "StyleData", "TableMasterGrid", "All",
 StyleMenuListing->None],
Cell[65437, 2388, 324, 10, 70, 35, 0, "StyleData", "TableLineElement", "All",
 StyleMenuListing->None],
Cell[65764, 2400, 167, 5, 70, 36, 0, "StyleData", "TableBlankElement", "All",
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[65956, 2409, 128, 5, 70, 27, 0, "StyleData", "SpanLeft", "All",
 StyleMenuListing->None],
Cell[66087, 2416, 40, 0, 70, 40, 0, "StyleData", "SpanLeft", "FlushLeft"],
Cell[66130, 2418, 58, 1, 70, 43, 0, "StyleData", "SpanLeft", "Presentation"],
Cell[66191, 2421, 65, 0, 70, 65, 0, "StyleData", "SpanLeft", "Printout"],
Cell[66259, 2423, 63, 1, 70, 48, 0, "StyleData", "SpanLeft", \
"FlushLeftPrintout"],
Cell[66325, 2426, 66, 1, 70, 51, 0, "StyleData", "SpanLeft", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[66428, 2432, 130, 5, 70, 29, 0, "StyleData", "SpanCenter", "All",
 StyleMenuListing->None],
Cell[66561, 2439, 42, 0, 70, 42, 0, "StyleData", "SpanCenter", "FlushLeft"],
Cell[66606, 2441, 60, 1, 70, 45, 0, "StyleData", "SpanCenter", \
"Presentation"],
Cell[66669, 2444, 67, 0, 70, 67, 0, "StyleData", "SpanCenter", "Printout"],
Cell[66739, 2446, 65, 1, 70, 50, 0, "StyleData", "SpanCenter", \
"FlushLeftPrintout"],
Cell[66807, 2449, 68, 1, 70, 53, 0, "StyleData", "SpanCenter", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[66912, 2455, 129, 5, 70, 28, 0, "StyleData", "SpanRight", "All",
 StyleMenuListing->None],
Cell[67044, 2462, 41, 0, 70, 41, 0, "StyleData", "SpanRight", "FlushLeft"],
Cell[67088, 2464, 59, 1, 70, 44, 0, "StyleData", "SpanRight", \
"Presentation"],
Cell[67150, 2467, 66, 0, 70, 66, 0, "StyleData", "SpanRight", "Printout"],
Cell[67219, 2469, 64, 1, 70, 49, 0, "StyleData", "SpanRight", \
"FlushLeftPrintout"],
Cell[67286, 2472, 67, 1, 70, 52, 0, "StyleData", "SpanRight", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[67414, 2480, 32, 0, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[67471, 2484, 387, 10, 70, 26, 0, "StyleData", "Caption", "All",
 CounterIncrements->"Caption",
 StyleMenuListing->None],
Cell[67861, 2496, 95, 2, 70, 39, 0, "StyleData", "Caption", "FlushLeft"],
Cell[67959, 2500, 91, 2, 70, 42, 0, "StyleData", "Caption", "Presentation"],
Cell[68053, 2504, 65, 0, 70, 65, 0, "StyleData", "Caption", "Condensed"],
Cell[68121, 2506, 64, 0, 70, 64, 0, "StyleData", "Caption", "Printout"],
Cell[68188, 2508, 115, 3, 70, 47, 0, "StyleData", "Caption", \
"FlushLeftPrintout"],
Cell[68306, 2513, 120, 3, 70, 50, 0, "StyleData", "Caption", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[68487, 2523, 33, 0, 70, "Subsection"],
Cell[CellGroupData[{
Cell[68545, 2527, 54, 1, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[68624, 2532, 310, 9, 70, 23, 0, "StyleData", "Date", "All",
 StyleMenuListing->None],
Cell[68937, 2543, 93, 2, 70, 36, 0, "StyleData", "Date", "FlushLeft"],
Cell[69033, 2547, 267, 8, 70, 39, 0, "StyleData", "Date", "Presentation",
 StyleMenuListing->None],
Cell[69303, 2557, 62, 0, 70, 62, 0, "StyleData", "Date", "Condensed"],
Cell[69368, 2559, 61, 0, 70, 61, 0, "StyleData", "Date", "Printout"],
Cell[69432, 2561, 163, 5, 70, 44, 0, "StyleData", "Date", \
"FlushLeftPrintout"],
Cell[69598, 2568, 144, 4, 70, 47, 0, "StyleData", "Date", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[69791, 2578, 56, 1, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[69872, 2583, 387, 11, 70, 25, 0, "StyleData", "Author", "All",
 MenuPosition->2000],
Cell[70262, 2596, 100, 2, 70, 41, 0, "StyleData", "Author", "Presentation"],
Cell[70365, 2600, 64, 0, 70, 64, 0, "StyleData", "Author", "Condensed"],
Cell[70432, 2602, 63, 0, 70, 63, 0, "StyleData", "Author", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[70532, 2607, 192, 5, 70, 29, 0, "StyleData", "AuthorData", "All",
 StyleMenuListing->None],
Cell[70727, 2614, 67, 0, 70, 67, 0, "StyleData", "AuthorData", "Printout"],
Cell[70797, 2616, 89, 2, 70, 50, 0, "StyleData", "AuthorData", \
"FlushLeftPrintout"],
Cell[70889, 2620, 92, 2, 70, 53, 0, "StyleData", "AuthorData", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[71018, 2627, 274, 8, 70, 30, 0, "StyleData", "AuthorGroup", "All",
 StyleMenuListing->None],
Cell[71295, 2637, 133, 4, 70, 43, 0, "StyleData", "AuthorGroup", \
"FlushLeft"],
Cell[71431, 2643, 139, 4, 70, 46, 0, "StyleData", "AuthorGroup", \
"Presentation"],
Cell[71573, 2649, 69, 0, 70, 69, 0, "StyleData", "AuthorGroup", "Condensed"],
Cell[71645, 2651, 68, 0, 70, 68, 0, "StyleData", "AuthorGroup", "Printout"],
Cell[71716, 2653, 167, 5, 70, 51, 0, "StyleData", "AuthorGroup", \
"FlushLeftPrintout"],
Cell[71886, 2660, 130, 3, 70, 54, 0, "StyleData", "AuthorGroup", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[72031, 2666, 159, 4, 70, 34, 0, "StyleData", "AuthorFirstName", "All",
 StyleMenuListing->None],
Cell[72193, 2672, 160, 4, 70, 35, 0, "StyleData", "AuthorMiddleName", "All",
 StyleMenuListing->None],
Cell[72356, 2678, 175, 5, 70, 33, 0, "StyleData", "AuthorLastName", "All",
 StyleMenuListing->None],
Cell[72534, 2685, 160, 4, 70, 35, 0, "StyleData", "AuthorNameSuffix", "All",
 StyleMenuListing->None],
Cell[72697, 2691, 183, 5, 70, 36, 0, "StyleData", "AuthorAffiliation", "All",
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[72905, 2700, 277, 9, 70, 30, 0, "StyleData", "AuthorEmail", "All",
 StyleMenuListing->None],
Cell[73185, 2711, 43, 0, 70, 43, 0, "StyleData", "AuthorEmail", "FlushLeft"],
Cell[73231, 2713, 61, 1, 70, 46, 0, "StyleData", "AuthorEmail", \
"Presentation"],
Cell[73295, 2716, 69, 0, 70, 69, 0, "StyleData", "AuthorEmail", "Condensed"],
Cell[73367, 2718, 68, 0, 70, 68, 0, "StyleData", "AuthorEmail", "Printout"],
Cell[73438, 2720, 91, 2, 70, 51, 0, "StyleData", "AuthorEmail", \
"FlushLeftPrintout"],
Cell[73532, 2724, 94, 2, 70, 54, 0, "StyleData", "AuthorEmail", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[73675, 2732, 50, 0, 70, "Subsubsection"],
Cell[73728, 2734, 234, 9, 70, "AuthorFormCustomizationTemplate",
 CellTags->"AuthorFormCustomization"]
}, Closed]],
Cell[CellGroupData[{
Cell[73999, 2748, 61, 1, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[74085, 2753, 352, 10, 70, 30, 0, "StyleData", "Institution", "All",
 CounterIncrements->"Institution",
 MenuPosition->2010],
Cell[74440, 2765, 193, 6, 70, 43, 0, "StyleData", "Institution", \
"FlushLeft"],
Cell[74636, 2773, 113, 3, 70, 46, 0, "StyleData", "Institution", \
"Presentation"],
Cell[74752, 2778, 69, 0, 70, 69, 0, "StyleData", "Institution", "Condensed"],
Cell[74824, 2780, 68, 0, 70, 68, 0, "StyleData", "Institution", "Printout"],
Cell[74895, 2782, 189, 6, 70, 51, 0, "StyleData", "Institution", \
"FlushLeftPrintout"],
Cell[75087, 2790, 129, 3, 70, 54, 0, "StyleData", "Institution", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[75265, 2799, 58, 1, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[75348, 2804, 458, 13, 70, 27, 0, "StyleData", "Abstract", "All",
 StyleMenuListing->None],
Cell[75809, 2819, 40, 0, 70, 40, 0, "StyleData", "Abstract", "FlushLeft"],
Cell[75852, 2821, 93, 2, 70, 43, 0, "StyleData", "Abstract", "Presentation"],
Cell[75948, 2825, 66, 0, 70, 66, 0, "StyleData", "Abstract", "Condensed"],
Cell[76017, 2827, 65, 0, 70, 65, 0, "StyleData", "Abstract", "Printout"],
Cell[76085, 2829, 120, 3, 70, 48, 0, "StyleData", "Abstract", \
"FlushLeftPrintout"],
Cell[76208, 2834, 123, 3, 70, 51, 0, "StyleData", "Abstract", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[76380, 2843, 67, 1, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[76472, 2848, 35, 0, 70, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[76532, 2852, 45, 0, 70, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[76602, 2856, 384, 11, 70, 29, 0, "StyleData", "TOCHeading", "All",
 StyleMenuListing->None],
Cell[76989, 2869, 68, 0, 70, 68, 0, "StyleData", "TOCHeading", "Condensed"],
Cell[77060, 2871, 64, 1, 70, 42, 0, "StyleData", "TOCHeading", "FlushLeft"],
Cell[77127, 2874, 67, 0, 70, 67, 0, "StyleData", "TOCHeading", "Printout"],
Cell[77197, 2876, 120, 3, 70, 50, 0, "StyleData", "TOCHeading", \
"FlushLeftPrintout"],
Cell[77320, 2881, 101, 2, 70, 53, 0, "StyleData", "TOCHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[77458, 2888, 437, 13, 70, 35, 0, "StyleData", "TOCIllustrations", "All",
 CounterAssignments->{{"TOCItem", 0}},
 StyleMenuListing->None],
Cell[77898, 2903, 74, 0, 70, 74, 0, "StyleData", "TOCIllustrations", \
"Condensed"],
Cell[77975, 2905, 70, 1, 70, 48, 0, "StyleData", "TOCIllustrations", \
"FlushLeft"],
Cell[78048, 2908, 73, 0, 70, 73, 0, "StyleData", "TOCIllustrations", \
"Printout"],
Cell[78124, 2910, 126, 3, 70, 56, 0, "StyleData", "TOCIllustrations", \
"FlushLeftPrintout"],
Cell[78253, 2915, 107, 2, 70, 59, 0, "StyleData", "TOCIllustrations", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[78397, 2922, 421, 12, 70, 28, 0, "StyleData", "TOCTables", "All",
 CounterAssignments->{{"TOCItem", 0}},
 StyleMenuListing->None],
Cell[78821, 2936, 67, 0, 70, 67, 0, "StyleData", "TOCTables", "Condensed"],
Cell[78891, 2938, 63, 1, 70, 41, 0, "StyleData", "TOCTables", "FlushLeft"],
Cell[78957, 2941, 66, 0, 70, 66, 0, "StyleData", "TOCTables", "Printout"],
Cell[79026, 2943, 119, 3, 70, 49, 0, "StyleData", "TOCTables", \
"FlushLeftPrintout"],
Cell[79148, 2948, 100, 2, 70, 52, 0, "StyleData", "TOCTables", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[79297, 2956, 48, 0, 70, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[79370, 2960, 372, 11, 70, 40, 0, "StyleData", "TOCFrontmatterHeading", \
"All",
 StyleMenuListing->None],
Cell[79745, 2973, 79, 0, 70, 79, 0, "StyleData", "TOCFrontmatterHeading", \
"Condensed"],
Cell[79827, 2975, 53, 0, 70, 53, 0, "StyleData", "TOCFrontmatterHeading", \
"FlushLeft"],
Cell[79883, 2977, 78, 0, 70, 78, 0, "StyleData", "TOCFrontmatterHeading", \
"Printout"],
Cell[79964, 2979, 129, 3, 70, 61, 0, "StyleData", "TOCFrontmatterHeading", \
"FlushLeftPrintout"],
Cell[80096, 2984, 132, 3, 70, 64, 0, "StyleData", "TOCFrontmatterHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[80265, 2992, 370, 11, 70, 39, 0, "StyleData", "TOCBackmatterHeading", \
"All",
 StyleMenuListing->None],
Cell[80638, 3005, 78, 0, 70, 78, 0, "StyleData", "TOCBackmatterHeading", \
"Condensed"],
Cell[80719, 3007, 52, 0, 70, 52, 0, "StyleData", "TOCBackmatterHeading", \
"FlushLeft"],
Cell[80774, 3009, 77, 0, 70, 77, 0, "StyleData", "TOCBackmatterHeading", \
"Printout"],
Cell[80854, 3011, 128, 3, 70, 60, 0, "StyleData", "TOCBackmatterHeading", \
"FlushLeftPrintout"],
Cell[80985, 3016, 131, 3, 70, 63, 0, "StyleData", "TOCBackmatterHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[81153, 3024, 368, 11, 70, 38, 0, "StyleData", "TOCFrontBackHeading", \
"All",
 StyleMenuListing->None],
Cell[81524, 3037, 77, 0, 70, 77, 0, "StyleData", "TOCFrontBackHeading", \
"Condensed"],
Cell[81604, 3039, 51, 0, 70, 51, 0, "StyleData", "TOCFrontBackHeading", \
"FlushLeft"],
Cell[81658, 3041, 76, 0, 70, 76, 0, "StyleData", "TOCFrontBackHeading", \
"Printout"],
Cell[81737, 3043, 127, 3, 70, 59, 0, "StyleData", "TOCFrontBackHeading", \
"FlushLeftPrintout"],
Cell[81867, 3048, 130, 3, 70, 62, 0, "StyleData", "TOCFrontBackHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[82034, 3056, 663, 18, 70, 29, 0, "StyleData", "TOCSection", "All",
 CounterIncrements->"TOCSection",
 CounterAssignments->{{"TOCSubsection", 0}},
 StyleMenuListing->None],
Cell[82700, 3076, 68, 0, 70, 68, 0, "StyleData", "TOCSection", "Condensed"],
Cell[82771, 3078, 42, 0, 70, 42, 0, "StyleData", "TOCSection", "FlushLeft"],
Cell[82816, 3080, 67, 0, 70, 67, 0, "StyleData", "TOCSection", "Printout"],
Cell[82886, 3082, 141, 4, 70, 50, 0, "StyleData", "TOCSection", \
"FlushLeftPrintout"],
Cell[83030, 3088, 144, 4, 70, 53, 0, "StyleData", "TOCSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[83211, 3097, 714, 18, 70, 32, 0, "StyleData", "TOCSubsection", "All",
 CounterIncrements->"TOCSubsection",
 CounterAssignments->{{"TOCSubsubsection", 0}},
 StyleMenuListing->None],
Cell[83928, 3117, 45, 0, 70, 45, 0, "StyleData", "TOCSubsection", \
"FlushLeft"],
Cell[83976, 3119, 70, 0, 70, 70, 0, "StyleData", "TOCSubsection", \
"Printout"],
Cell[84049, 3121, 145, 4, 70, 53, 0, "StyleData", "TOCSubsection", \
"FlushLeftPrintout"],
Cell[84197, 3127, 148, 4, 70, 56, 0, "StyleData", "TOCSubsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[84382, 3136, 747, 18, 70, 35, 0, "StyleData", "TOCSubsubsection", "All",
 CounterIncrements->"TOCSubsubsection",
 StyleMenuListing->None],
Cell[85132, 3156, 74, 0, 70, 74, 0, "StyleData", "TOCSubsubsection", \
"Condensed"],
Cell[85209, 3158, 48, 0, 70, 48, 0, "StyleData", "TOCSubsubsection", \
"FlushLeft"],
Cell[85260, 3160, 73, 0, 70, 73, 0, "StyleData", "TOCSubsubsection", \
"Printout"],
Cell[85336, 3162, 148, 4, 70, 56, 0, "StyleData", "TOCSubsubsection", \
"FlushLeftPrintout"],
Cell[85487, 3168, 151, 4, 70, 59, 0, "StyleData", "TOCSubsubsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[85675, 3177, 555, 15, 70, 28, 0, "StyleData", "TOCFigure", "All",
 CounterIncrements->"TOCFigure",
 StyleMenuListing->None],
Cell[86233, 3194, 67, 0, 70, 67, 0, "StyleData", "TOCFigure", "Condensed"],
Cell[86303, 3196, 41, 0, 70, 41, 0, "StyleData", "TOCFigure", "FlushLeft"],
Cell[86347, 3198, 66, 0, 70, 66, 0, "StyleData", "TOCFigure", "Printout"],
Cell[86416, 3200, 116, 3, 70, 49, 0, "StyleData", "TOCFigure", \
"FlushLeftPrintout"],
Cell[86535, 3205, 119, 3, 70, 52, 0, "StyleData", "TOCFigure", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[86691, 3213, 597, 15, 70, 34, 0, "StyleData", "TOCSupplemental", "All",
 CounterIncrements->"TOCSupplemental",
 StyleMenuListing->None],
Cell[87291, 3230, 73, 0, 70, 73, 0, "StyleData", "TOCSupplemental", \
"Condensed"],
Cell[87367, 3232, 47, 0, 70, 47, 0, "StyleData", "TOCSupplemental", \
"FlushLeft"],
Cell[87417, 3234, 72, 0, 70, 72, 0, "StyleData", "TOCSupplemental", \
"Printout"],
Cell[87492, 3236, 122, 3, 70, 55, 0, "StyleData", "TOCSupplemental", \
"FlushLeftPrintout"],
Cell[87617, 3241, 125, 3, 70, 58, 0, "StyleData", "TOCSupplemental", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[87779, 3249, 567, 15, 70, 29, 0, "StyleData", "TOCPicture", "All",
 CounterIncrements->"TOCPicture",
 StyleMenuListing->None],
Cell[88349, 3266, 68, 0, 70, 68, 0, "StyleData", "TOCPicture", "Condensed"],
Cell[88420, 3268, 42, 0, 70, 42, 0, "StyleData", "TOCPicture", "FlushLeft"],
Cell[88465, 3270, 67, 0, 70, 67, 0, "StyleData", "TOCPicture", "Printout"],
Cell[88535, 3272, 117, 3, 70, 50, 0, "StyleData", "TOCPicture", \
"FlushLeftPrintout"],
Cell[88655, 3277, 120, 3, 70, 53, 0, "StyleData", "TOCPicture", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[88812, 3285, 599, 15, 70, 34, 0, "StyleData", "TOCIllustration", "All",
 CounterIncrements->"TOCIllustration",
 StyleMenuListing->None],
Cell[89414, 3302, 73, 0, 70, 73, 0, "StyleData", "TOCIllustration", \
"Condensed"],
Cell[89490, 3304, 47, 0, 70, 47, 0, "StyleData", "TOCIllustration", \
"FlushLeft"],
Cell[89540, 3306, 72, 0, 70, 72, 0, "StyleData", "TOCIllustration", \
"Printout"],
Cell[89615, 3308, 122, 3, 70, 55, 0, "StyleData", "TOCIllustration", \
"FlushLeftPrintout"],
Cell[89740, 3313, 125, 3, 70, 58, 0, "StyleData", "TOCIllustration", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[89902, 3321, 565, 15, 70, 29, 0, "StyleData", "TOCProgram", "All",
 CounterIncrements->"TOCProgram",
 StyleMenuListing->None],
Cell[90470, 3338, 68, 0, 70, 68, 0, "StyleData", "TOCProgram", "Condensed"],
Cell[90541, 3340, 42, 0, 70, 42, 0, "StyleData", "TOCProgram", "FlushLeft"],
Cell[90586, 3342, 67, 0, 70, 67, 0, "StyleData", "TOCProgram", "Printout"],
Cell[90656, 3344, 117, 3, 70, 50, 0, "StyleData", "TOCProgram", \
"FlushLeftPrintout"],
Cell[90776, 3349, 120, 3, 70, 53, 0, "StyleData", "TOCProgram", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[90933, 3357, 551, 15, 70, 27, 0, "StyleData", "TOCTable", "All",
 CounterIncrements->"TOCTable",
 StyleMenuListing->None],
Cell[91487, 3374, 66, 0, 70, 66, 0, "StyleData", "TOCTable", "Condensed"],
Cell[91556, 3376, 40, 0, 70, 40, 0, "StyleData", "TOCTable", "FlushLeft"],
Cell[91599, 3378, 65, 0, 70, 65, 0, "StyleData", "TOCTable", "Printout"],
Cell[91667, 3380, 115, 3, 70, 48, 0, "StyleData", "TOCTable", \
"FlushLeftPrintout"],
Cell[91785, 3385, 118, 3, 70, 51, 0, "StyleData", "TOCTable", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[91952, 3394, 46, 0, 70, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[92023, 3398, 144, 4, 70, 28, 0, "StyleData", "TOCSpacer", "All",
 StyleMenuListing->None],
Cell[92170, 3404, 67, 0, 70, 67, 0, "StyleData", "TOCSpacer", "Condensed"],
Cell[92240, 3406, 100, 2, 70, 41, 0, "StyleData", "TOCSpacer", "FlushLeft",
 StyleMenuListing->None],
Cell[92343, 3410, 66, 0, 70, 66, 0, "StyleData", "TOCSpacer", "Printout"],
Cell[92412, 3412, 81, 1, 70, 49, 0, "StyleData", "TOCSpacer", \
"FlushLeftPrintout"],
Cell[92496, 3415, 84, 1, 70, 52, 0, "StyleData", "TOCSpacer", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[92617, 3421, 167, 5, 70, 34, 0, "StyleData", "TOCSectionLabel", "All",
 StyleMenuListing->None],
Cell[92787, 3428, 47, 0, 70, 47, 0, "StyleData", "TOCSectionLabel", \
"FlushLeft"],
Cell[92837, 3430, 72, 0, 70, 72, 0, "StyleData", "TOCSectionLabel", \
"Printout"],
Cell[92912, 3432, 83, 1, 70, 55, 0, "StyleData", "TOCSectionLabel", \
"FlushLeftPrintout"],
Cell[92998, 3435, 86, 1, 70, 58, 0, "StyleData", "TOCSectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[93121, 3441, 170, 5, 70, 37, 0, "StyleData", "TOCSubsectionLabel", "All",
 
 StyleMenuListing->None],
Cell[93294, 3448, 50, 0, 70, 50, 0, "StyleData", "TOCSubsectionLabel", \
"FlushLeft"],
Cell[93347, 3450, 75, 0, 70, 75, 0, "StyleData", "TOCSubsectionLabel", \
"Printout"],
Cell[93425, 3452, 86, 1, 70, 58, 0, "StyleData", "TOCSubsectionLabel", \
"FlushLeftPrintout"],
Cell[93514, 3455, 89, 1, 70, 61, 0, "StyleData", "TOCSubsectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[93640, 3461, 173, 5, 70, 40, 0, "StyleData", "TOCSubsubsectionLabel", \
"All",
 StyleMenuListing->None],
Cell[93816, 3468, 53, 0, 70, 53, 0, "StyleData", "TOCSubsubsectionLabel", \
"FlushLeft"],
Cell[93872, 3470, 78, 0, 70, 78, 0, "StyleData", "TOCSubsubsectionLabel", \
"Printout"],
Cell[93953, 3472, 89, 1, 70, 61, 0, "StyleData", "TOCSubsubsectionLabel", \
"FlushLeftPrintout"],
Cell[94045, 3475, 92, 1, 70, 64, 0, "StyleData", "TOCSubsubsectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[94174, 3481, 166, 5, 70, 33, 0, "StyleData", "TOCFigureLabel", "All",
 StyleMenuListing->None],
Cell[94343, 3488, 46, 0, 70, 46, 0, "StyleData", "TOCFigureLabel", \
"FlushLeft"],
Cell[94392, 3490, 71, 0, 70, 71, 0, "StyleData", "TOCFigureLabel", \
"Printout"],
Cell[94466, 3492, 82, 1, 70, 54, 0, "StyleData", "TOCFigureLabel", \
"FlushLeftPrintout"],
Cell[94551, 3495, 85, 1, 70, 57, 0, "StyleData", "TOCFigureLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[94673, 3501, 172, 5, 70, 39, 0, "StyleData", "TOCSupplementalLabel", \
"All",
 StyleMenuListing->None],
Cell[94848, 3508, 52, 0, 70, 52, 0, "StyleData", "TOCSupplementalLabel", \
"FlushLeft"],
Cell[94903, 3510, 77, 0, 70, 77, 0, "StyleData", "TOCSupplementalLabel", \
"Printout"],
Cell[94983, 3512, 88, 1, 70, 60, 0, "StyleData", "TOCSupplementalLabel", \
"FlushLeftPrintout"],
Cell[95074, 3515, 91, 1, 70, 63, 0, "StyleData", "TOCSupplementalLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[95202, 3521, 167, 5, 70, 34, 0, "StyleData", "TOCPictureLabel", "All",
 StyleMenuListing->None],
Cell[95372, 3528, 47, 0, 70, 47, 0, "StyleData", "TOCPictureLabel", \
"FlushLeft"],
Cell[95422, 3530, 72, 0, 70, 72, 0, "StyleData", "TOCPictureLabel", \
"Printout"],
Cell[95497, 3532, 83, 1, 70, 55, 0, "StyleData", "TOCPictureLabel", \
"FlushLeftPrintout"],
Cell[95583, 3535, 86, 1, 70, 58, 0, "StyleData", "TOCPictureLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[95706, 3541, 172, 5, 70, 39, 0, "StyleData", "TOCIllustrationLabel", \
"All",
 StyleMenuListing->None],
Cell[95881, 3548, 52, 0, 70, 52, 0, "StyleData", "TOCIllustrationLabel", \
"FlushLeft"],
Cell[95936, 3550, 77, 0, 70, 77, 0, "StyleData", "TOCIllustrationLabel", \
"Printout"],
Cell[96016, 3552, 88, 1, 70, 60, 0, "StyleData", "TOCIllustrationLabel", \
"FlushLeftPrintout"],
Cell[96107, 3555, 91, 1, 70, 63, 0, "StyleData", "TOCIllustrationLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[96235, 3561, 167, 5, 70, 34, 0, "StyleData", "TOCProgramLabel", "All",
 StyleMenuListing->None],
Cell[96405, 3568, 47, 0, 70, 47, 0, "StyleData", "TOCProgramLabel", \
"FlushLeft"],
Cell[96455, 3570, 72, 0, 70, 72, 0, "StyleData", "TOCProgramLabel", \
"Printout"],
Cell[96530, 3572, 83, 1, 70, 55, 0, "StyleData", "TOCProgramLabel", \
"FlushLeftPrintout"],
Cell[96616, 3575, 86, 1, 70, 58, 0, "StyleData", "TOCProgramLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[96739, 3581, 165, 5, 70, 32, 0, "StyleData", "TOCTableLabel", "All",
 StyleMenuListing->None],
Cell[96907, 3588, 45, 0, 70, 45, 0, "StyleData", "TOCTableLabel", \
"FlushLeft"],
Cell[96955, 3590, 70, 0, 70, 70, 0, "StyleData", "TOCTableLabel", \
"Printout"],
Cell[97028, 3592, 81, 1, 70, 53, 0, "StyleData", "TOCTableLabel", \
"FlushLeftPrintout"],
Cell[97112, 3595, 84, 1, 70, 56, 0, "StyleData", "TOCTableLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[97233, 3601, 166, 6, 70, 28, 0, "StyleData", "TOCLeader", "All",
 StyleMenuListing->None],
Cell[97402, 3609, 41, 0, 70, 41, 0, "StyleData", "TOCLeader", "FlushLeft"],
Cell[97446, 3611, 66, 0, 70, 66, 0, "StyleData", "TOCLeader", "Printout"],
Cell[97515, 3613, 64, 1, 70, 49, 0, "StyleData", "TOCLeader", \
"FlushLeftPrintout"],
Cell[97582, 3616, 67, 1, 70, 52, 0, "StyleData", "TOCLeader", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[97686, 3622, 299, 9, 70, 32, 0, "StyleData", "TOCPageNumber", "All",
 StyleMenuListing->None],
Cell[97988, 3633, 45, 0, 70, 45, 0, "StyleData", "TOCPageNumber", \
"FlushLeft"],
Cell[98036, 3635, 70, 0, 70, 70, 0, "StyleData", "TOCPageNumber", \
"Printout"],
Cell[98109, 3637, 81, 1, 70, 53, 0, "StyleData", "TOCPageNumber", \
"FlushLeftPrintout"],
Cell[98193, 3640, 84, 1, 70, 56, 0, "StyleData", "TOCPageNumber", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[98362, 3650, 37, 0, 70, "Subsection"],
Cell[CellGroupData[{
Cell[98424, 3654, 442, 12, 70, 41, 0, "StyleData", "AcknowledgmentsSection", \
"All",
 CounterIncrements->"Acknowledgments",
 MenuPosition->2100],
Cell[98869, 3668, 111, 2, 70, 54, 0, "StyleData", "AcknowledgmentsSection", \
"FlushLeft"],
Cell[98983, 3672, 107, 2, 70, 57, 0, "StyleData", "AcknowledgmentsSection", \
"Presentation"],
Cell[99093, 3676, 82, 1, 70, 82, 1, "StyleData", "AcknowledgmentsSection", \
"Condensed"],
Cell[99178, 3679, 79, 0, 70, 79, 0, "StyleData", "AcknowledgmentsSection", \
"Printout"],
Cell[99260, 3681, 132, 3, 70, 62, 0, "StyleData", "AcknowledgmentsSection", \
"FlushLeftPrintout"],
Cell[99395, 3686, 113, 2, 70, 65, 0, "StyleData", "AcknowledgmentsSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[99545, 3693, 317, 8, 70, 34, 0, "StyleData", "Acknowledgments", "All",
 CounterIncrements->"Acknowledgments",
 CounterAssignments->{{"Item1Numbered", 0}},
 MenuPosition->2110],
Cell[99865, 3703, 47, 0, 70, 47, 0, "StyleData", "Acknowledgments", \
"FlushLeft"],
Cell[99915, 3705, 99, 2, 70, 50, 0, "StyleData", "Acknowledgments", \
"Presentation"],
Cell[100017, 3709, 73, 0, 70, 73, 0, "StyleData", "Acknowledgments", \
"Condensed"],
Cell[100093, 3711, 72, 0, 70, 72, 0, "StyleData", "Acknowledgments", \
"Printout"],
Cell[100168, 3713, 147, 4, 70, 55, 0, "StyleData", "Acknowledgments", \
"FlushLeftPrintout"],
Cell[100318, 3719, 150, 4, 70, 58, 0, "StyleData", "Acknowledgments", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[100517, 3729, 30, 0, 70, "Subsection"],
Cell[CellGroupData[{
Cell[100572, 3733, 780, 21, 70, 34, 0, "StyleData", "AppendixSection", "All",
 CounterIncrements->{
  "AppendixSection", "SectionHeader", "SubsectionHeader", 
   "SubsubsectionHeader", "SubsubsubsectionHeader"},
 CounterAssignments->{{"AppendixEquation", 0}},
 MenuPosition->2150],
Cell[101355, 3756, 104, 2, 70, 47, 0, "StyleData", "AppendixSection", \
"FlushLeft"],
Cell[101462, 3760, 100, 2, 70, 50, 0, "StyleData", "AppendixSection", \
"Presentation"],
Cell[101565, 3764, 73, 0, 70, 73, 0, "StyleData", "AppendixSection", \
"Condensed"],
Cell[101641, 3766, 72, 0, 70, 72, 0, "StyleData", "AppendixSection", \
"Printout"],
Cell[101716, 3768, 125, 3, 70, 55, 0, "StyleData", "AppendixSection", \
"FlushLeftPrintout"],
Cell[101844, 3773, 106, 2, 70, 58, 0, "StyleData", "AppendixSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[101987, 3780, 189, 6, 70, 39, 0, "StyleData", "AppendixSectionLabel", \
"All",
 StyleMenuListing->None],
Cell[102179, 3788, 80, 1, 70, 52, 0, "StyleData", "AppendixSectionLabel", \
"FlushLeft"],
Cell[102262, 3791, 83, 1, 70, 55, 0, "StyleData", "AppendixSectionLabel", \
"Presentation"],
Cell[102348, 3794, 77, 0, 70, 77, 0, "StyleData", "AppendixSectionLabel", \
"Printout"],
Cell[102428, 3796, 88, 1, 70, 60, 0, "StyleData", "AppendixSectionLabel", \
"FlushLeftPrintout"],
Cell[102519, 3799, 91, 1, 70, 63, 0, "StyleData", "AppendixSectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[102647, 3805, 303, 8, 70, 27, 0, "StyleData", "Appendix", "All",
 CounterIncrements->"Appendix",
 CounterAssignments->{{"Item1Numbered", 0}},
 MenuPosition->2160],
Cell[102953, 3815, 40, 0, 70, 40, 0, "StyleData", "Appendix", "FlushLeft"],
Cell[102996, 3817, 92, 2, 70, 43, 0, "StyleData", "Appendix", \
"Presentation"],
Cell[103091, 3821, 66, 0, 70, 66, 0, "StyleData", "Appendix", "Condensed"],
Cell[103160, 3823, 65, 0, 70, 65, 0, "StyleData", "Appendix", "Printout"],
Cell[103228, 3825, 140, 4, 70, 48, 0, "StyleData", "Appendix", \
"FlushLeftPrintout"],
Cell[103371, 3831, 143, 4, 70, 51, 0, "StyleData", "Appendix", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[103551, 3840, 739, 19, 70, 35, 0, "StyleData", "AppendixEquation", "All",
 
 CounterIncrements->"AppendixEquation",
 MenuPosition->2170],
Cell[104293, 3861, 103, 2, 70, 48, 0, "StyleData", "AppendixEquation", \
"FlushLeft"],
Cell[104399, 3865, 102, 2, 70, 51, 0, "StyleData", "AppendixEquation", \
"Presentation"],
Cell[104504, 3869, 74, 0, 70, 74, 0, "StyleData", "AppendixEquation", \
"Condensed"],
Cell[104581, 3871, 73, 0, 70, 73, 0, "StyleData", "AppendixEquation", \
"Printout"],
Cell[104657, 3873, 126, 3, 70, 56, 0, "StyleData", "AppendixEquation", \
"FlushLeftPrintout"],
Cell[104786, 3878, 106, 2, 70, 59, 0, "StyleData", "AppendixEquation", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[104941, 3886, 55, 1, 70, "Subsection"],
Cell[CellGroupData[{
Cell[105021, 3891, 677, 19, 70, 33, 0, "StyleData", "EndnoteSection", "All",
 CounterIncrements->{
  "Section", "SectionHeader", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}, {
   "Endnote", 0}},
 MenuPosition->2200],
Cell[105701, 3912, 139, 4, 70, 46, 0, "StyleData", "EndnoteSection", \
"FlushLeft"],
Cell[105843, 3918, 99, 2, 70, 49, 0, "StyleData", "EndnoteSection", \
"Presentation"],
Cell[105945, 3922, 72, 0, 70, 72, 0, "StyleData", "EndnoteSection", \
"Condensed"],
Cell[106020, 3924, 71, 0, 70, 71, 0, "StyleData", "EndnoteSection", \
"Printout"],
Cell[106094, 3926, 145, 4, 70, 54, 0, "StyleData", "EndnoteSection", \
"FlushLeftPrintout"],
Cell[106242, 3932, 105, 2, 70, 57, 0, "StyleData", "EndnoteSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[106384, 3939, 396, 12, 70, 26, 0, "StyleData", "Endnote", "All",
 CounterIncrements->"Endnote",
 MenuPosition->2210],
Cell[106783, 3953, 39, 0, 70, 39, 0, "StyleData", "Endnote", "FlushLeft"],
Cell[106825, 3955, 113, 3, 70, 42, 0, "StyleData", "Endnote", \
"Presentation"],
Cell[106941, 3960, 65, 0, 70, 65, 0, "StyleData", "Endnote", "Condensed"],
Cell[107009, 3962, 64, 0, 70, 64, 0, "StyleData", "Endnote", "Printout"],
Cell[107076, 3964, 119, 3, 70, 47, 0, "StyleData", "Endnote", \
"FlushLeftPrintout"],
Cell[107198, 3969, 119, 3, 70, 50, 0, "StyleData", "Endnote", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[107354, 3977, 305, 7, 70, 31, 0, "StyleData", "EndnoteLabel", "All",
 CounterIncrements->"EndnoteLabel",
 StyleMenuListing->None],
Cell[107662, 3986, 44, 0, 70, 44, 0, "StyleData", "EndnoteLabel", \
"FlushLeft"],
Cell[107709, 3988, 75, 1, 70, 47, 0, "StyleData", "EndnoteLabel", \
"Presentation"],
Cell[107787, 3991, 69, 0, 70, 69, 0, "StyleData", "EndnoteLabel", \
"Printout"],
Cell[107859, 3993, 80, 1, 70, 52, 0, "StyleData", "EndnoteLabel", \
"FlushLeftPrintout"],
Cell[107942, 3996, 83, 1, 70, 55, 0, "StyleData", "EndnoteLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[108062, 4002, 145, 4, 70, 32, 0, "StyleData", "EndnoteNumber", "All",
 CounterIncrements->"EndnoteNumber",
 StyleMenuListing->None],
Cell[108210, 4008, 45, 0, 70, 45, 0, "StyleData", "EndnoteNumber", \
"FlushLeft"],
Cell[108258, 4010, 48, 0, 70, 48, 0, "StyleData", "EndnoteNumber", \
"Presentation"],
Cell[108309, 4012, 70, 0, 70, 70, 0, "StyleData", "EndnoteNumber", \
"Printout"],
Cell[108382, 4014, 53, 0, 70, 53, 0, "StyleData", "EndnoteNumber", \
"FlushLeftPrintout"],
Cell[108438, 4016, 56, 0, 70, 56, 0, "StyleData", "EndnoteNumber", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[108531, 4021, 234, 7, 70, 26, 0, "StyleData", "NoteKey", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[108768, 4030, 39, 0, 70, 39, 0, "StyleData", "NoteKey", "FlushLeft"],
Cell[108810, 4032, 42, 0, 70, 42, 0, "StyleData", "NoteKey", "Presentation"],
Cell[108855, 4034, 65, 0, 70, 65, 0, "StyleData", "NoteKey", "Condensed"],
Cell[108923, 4036, 64, 0, 70, 64, 0, "StyleData", "NoteKey", "Printout"],
Cell[108990, 4038, 73, 1, 70, 47, 0, "StyleData", "NoteKey", \
"FlushLeftPrintout"],
Cell[109066, 4041, 76, 1, 70, 50, 0, "StyleData", "NoteKey", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[109179, 4047, 264, 7, 70, 36, 0, "StyleData", "EndnoteReturnLink", "All",
 
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[109446, 4056, 49, 0, 70, 49, 0, "StyleData", "EndnoteReturnLink", \
"FlushLeft"],
Cell[109498, 4058, 52, 0, 70, 52, 0, "StyleData", "EndnoteReturnLink", \
"Presentation"],
Cell[109553, 4060, 75, 0, 70, 75, 0, "StyleData", "EndnoteReturnLink", \
"Condensed"],
Cell[109631, 4062, 74, 0, 70, 74, 0, "StyleData", "EndnoteReturnLink", \
"Printout"],
Cell[109708, 4064, 122, 2, 70, 57, 0, "StyleData", "EndnoteReturnLink", \
"FlushLeftPrintout"],
Cell[109833, 4068, 125, 2, 70, 60, 0, "StyleData", "EndnoteReturnLink", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[109995, 4075, 279, 8, 70, 31, 0, "StyleData", "TableNoteKey", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[110277, 4085, 44, 0, 70, 44, 0, "StyleData", "TableNoteKey", \
"FlushLeft"],
Cell[110324, 4087, 47, 0, 70, 47, 0, "StyleData", "TableNoteKey", \
"Presentation"],
Cell[110374, 4089, 70, 0, 70, 70, 0, "StyleData", "TableNoteKey", \
"Condensed"],
Cell[110447, 4091, 69, 0, 70, 69, 0, "StyleData", "TableNoteKey", \
"Printout"],
Cell[110519, 4093, 78, 1, 70, 52, 0, "StyleData", "TableNoteKey", \
"FlushLeftPrintout"],
Cell[110600, 4096, 81, 1, 70, 55, 0, "StyleData", "TableNoteKey", \
"DoubleSpacedPrintout"],
Cell[110684, 4099, 64, 1, 70, 39, 0, "StyleData", "PageRef", "FlushLeft",
 StyleMenuListing->None],
Cell[110751, 4102, 67, 1, 70, 42, 0, "StyleData", "PageRef", "Presentation",
 StyleMenuListing->None],
Cell[110821, 4105, 64, 0, 70, 64, 0, "StyleData", "PageRef", "Printout"],
Cell[110888, 4107, 72, 1, 70, 47, 0, "StyleData", "PageRef", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[110963, 4110, 75, 1, 70, 50, 0, "StyleData", "PageRef", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[111075, 4116, 361, 10, 70, 23, 0, "StyleData", "Note", "All",
 StyleMenuListing->None],
Cell[111439, 4128, 36, 0, 70, 36, 0, "StyleData", "Note", "FlushLeft"],
Cell[111478, 4130, 39, 0, 70, 39, 0, "StyleData", "Note", "Presentation"],
Cell[111520, 4132, 62, 0, 70, 62, 0, "StyleData", "Note", "Condensed"],
Cell[111585, 4134, 61, 0, 70, 61, 0, "StyleData", "Note", "Printout"],
Cell[111649, 4136, 63, 1, 70, 44, 0, "StyleData", "Note", \
"FlushLeftPrintout"],
Cell[111715, 4139, 66, 1, 70, 47, 0, "StyleData", "Note", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[111830, 4146, 32, 0, 70, "Subsection"],
Cell[CellGroupData[{
Cell[111887, 4150, 629, 18, 70, 35, 0, "StyleData", "ReferenceSection", "All",
 
 CounterIncrements->{
  "SectionHeader", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Reference", 0}},
 MenuPosition->2250],
Cell[112519, 4170, 141, 4, 70, 48, 0, "StyleData", "ReferenceSection", \
"FlushLeft"],
Cell[112663, 4176, 101, 2, 70, 51, 0, "StyleData", "ReferenceSection", \
"Presentation"],
Cell[112767, 4180, 74, 0, 70, 74, 0, "StyleData", "ReferenceSection", \
"Condensed"],
Cell[112844, 4182, 73, 0, 70, 73, 0, "StyleData", "ReferenceSection", \
"Printout"],
Cell[112920, 4184, 147, 4, 70, 56, 0, "StyleData", "ReferenceSection", \
"FlushLeftPrintout"],
Cell[113070, 4190, 133, 3, 70, 59, 0, "StyleData", "ReferenceSection", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[113240, 4198, 521, 16, 70, 28, 0, "StyleData", "Reference", "All",
 CounterIncrements->"Reference",
 MenuPosition->2260],
Cell[113764, 4216, 41, 0, 70, 41, 0, "StyleData", "Reference", "FlushLeft"],
Cell[113808, 4218, 116, 3, 70, 44, 0, "StyleData", "Reference", \
"Presentation"],
Cell[113927, 4223, 67, 0, 70, 67, 0, "StyleData", "Reference", "Condensed"],
Cell[113997, 4225, 66, 0, 70, 66, 0, "StyleData", "Reference", "Printout"],
Cell[114066, 4227, 144, 4, 70, 49, 0, "StyleData", "Reference", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[114213, 4233, 169, 5, 70, 52, 0, "StyleData", "Reference", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[114419, 4243, 270, 8, 70, 33, 0, "StyleData", "ReferenceLabel", "All",
 CounterIncrements->"ReferenceLabel",
 StyleMenuListing->None],
Cell[114692, 4253, 68, 1, 70, 46, 0, "StyleData", "ReferenceLabel", \
"FlushLeft"],
Cell[114763, 4256, 100, 2, 70, 49, 0, "StyleData", "ReferenceLabel", \
"Presentation"],
Cell[114866, 4260, 71, 0, 70, 71, 0, "StyleData", "ReferenceLabel", \
"Printout"],
Cell[114940, 4262, 104, 2, 70, 54, 0, "StyleData", "ReferenceLabel", \
"FlushLeftPrintout"],
Cell[115047, 4266, 107, 2, 70, 57, 0, "StyleData", "ReferenceLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[115191, 4273, 107, 3, 70, 25, 0, "StyleData", "RefSep", "All",
 StyleMenuListing->None],
Cell[115301, 4278, 38, 0, 70, 38, 0, "StyleData", "RefSep", "FlushLeft"],
Cell[115342, 4280, 41, 0, 70, 41, 0, "StyleData", "RefSep", "Presentation"],
Cell[115386, 4282, 63, 0, 70, 63, 0, "StyleData", "RefSep", "Printout"],
Cell[115452, 4284, 46, 0, 70, 46, 0, "StyleData", "RefSep", \
"FlushLeftPrintout"],
Cell[115501, 4286, 49, 0, 70, 49, 0, "StyleData", "RefSep", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[115587, 4291, 361, 9, 70, 32, 0, "StyleData", "RefReturnLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[115951, 4302, 45, 0, 70, 45, 0, "StyleData", "RefReturnLink", \
"FlushLeft"],
Cell[115999, 4304, 48, 0, 70, 48, 0, "StyleData", "RefReturnLink", \
"Presentation"],
Cell[116050, 4306, 95, 2, 70, 44, 0, "StyleData", "RefReturnLink", "Printout",
 
 StyleMenuListing->None],
Cell[116148, 4310, 104, 2, 70, 53, 0, "StyleData", "RefReturnLink", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[116255, 4314, 107, 2, 70, 56, 0, "StyleData", "RefReturnLink", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[116399, 4321, 388, 11, 70, 35, 0, "StyleData", "RefReturnPointer", "All",
 
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[116790, 4334, 48, 0, 70, 48, 0, "StyleData", "RefReturnPointer", \
"FlushLeft"],
Cell[116841, 4336, 51, 0, 70, 51, 0, "StyleData", "RefReturnPointer", \
"Presentation"],
Cell[116895, 4338, 73, 0, 70, 73, 0, "StyleData", "RefReturnPointer", \
"Printout"],
Cell[116971, 4340, 107, 2, 70, 56, 0, "StyleData", "RefReturnPointer", \
"FlushLeftPrintout",
 StyleMenuListing->None],
Cell[117081, 4344, 110, 2, 70, 59, 0, "StyleData", "RefReturnPointer", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[117228, 4351, 386, 11, 70, 38, 0, "StyleData", "ReferenceSourceLink", \
"All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[117617, 4364, 76, 0, 70, 76, 0, "StyleData", "ReferenceSourceLink", \
"Printout"]
}, Closed]],
Cell[117708, 4367, 62, 1, 70, 37, 0, "StyleData", "ReferenceSourceURL", "All",
 
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[117795, 4372, 332, 9, 70, 27, 0, "StyleData", "Citation", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[118130, 4383, 40, 0, 70, 40, 0, "StyleData", "Citation", "FlushLeft"],
Cell[118173, 4385, 43, 0, 70, 43, 0, "StyleData", "Citation", \
"Presentation"],
Cell[118219, 4387, 65, 0, 70, 65, 0, "StyleData", "Citation", "Printout"],
Cell[118287, 4389, 74, 1, 70, 48, 0, "StyleData", "Citation", \
"FlushLeftPrintout"],
Cell[118364, 4392, 77, 1, 70, 51, 0, "StyleData", "Citation", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[118478, 4398, 232, 7, 70, 25, 0, "StyleData", "RefKey", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[118713, 4407, 38, 0, 70, 38, 0, "StyleData", "RefKey", "FlushLeft"],
Cell[118754, 4409, 41, 0, 70, 41, 0, "StyleData", "RefKey", "Presentation"],
Cell[118798, 4411, 63, 0, 70, 63, 0, "StyleData", "RefKey", "Printout"],
Cell[118864, 4413, 72, 1, 70, 46, 0, "StyleData", "RefKey", \
"FlushLeftPrintout"],
Cell[118939, 4416, 75, 1, 70, 49, 0, "StyleData", "RefKey", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[119051, 4422, 70, 1, 70, "Subsubsection"],
Cell[119124, 4425, 83, 1, 70, "ReferenceTemplate"],
Cell[119210, 4428, 86, 1, 70, "ReferenceTemplate"],
Cell[119299, 4431, 86, 1, 70, "ReferenceTemplate"],
Cell[119388, 4434, 82, 1, 70, "ReferenceTemplate"],
Cell[119473, 4437, 85, 1, 70, "ReferenceTemplate"],
Cell[119561, 4440, 84, 1, 70, "ReferenceTemplate"],
Cell[119648, 4443, 40, 0, 70, "ReferenceTemplate"],
Cell[119691, 4445, 49, 0, 70, "ReferenceTemplate"],
Cell[119743, 4447, 49, 0, 70, "ReferenceTemplate"],
Cell[119795, 4449, 49, 0, 70, "ReferenceTemplate"],
Cell[119847, 4451, 49, 0, 70, "ReferenceTemplate"],
Cell[119899, 4453, 56, 0, 70, "ReferenceTemplate"],
Cell[119958, 4455, 56, 0, 70, "ReferenceTemplate"],
Cell[CellGroupData[{
Cell[120039, 4459, 45, 0, 70, "Subsubsubsection"],
Cell[120087, 4461, 191, 4, 70, "ReferenceTemplate"],
Cell[120281, 4467, 152, 3, 70, "ReferenceTemplate"],
Cell[120436, 4472, 177, 3, 70, "ReferenceTemplate"],
Cell[120616, 4477, 139, 3, 70, "ReferenceTemplate"],
Cell[120758, 4482, 172, 3, 70, "ReferenceTemplate"],
Cell[120933, 4487, 136, 3, 70, "ReferenceTemplate"],
Cell[121072, 4492, 159, 3, 70, "ReferenceTemplate"],
Cell[121234, 4497, 123, 3, 70, "ReferenceTemplate"],
Cell[121360, 4502, 185, 4, 70, "ReferenceTemplate"],
Cell[121548, 4508, 146, 3, 70, "ReferenceTemplate"],
Cell[121697, 4513, 171, 3, 70, "ReferenceTemplate"],
Cell[121871, 4518, 133, 3, 70, "ReferenceTemplate"],
Cell[122007, 4523, 166, 3, 70, "ReferenceTemplate"],
Cell[122176, 4528, 130, 3, 70, "ReferenceTemplate"],
Cell[122309, 4533, 153, 3, 70, "ReferenceTemplate"],
Cell[122465, 4538, 117, 3, 70, "ReferenceTemplate"],
Cell[122585, 4543, 176, 4, 70, "ReferenceTemplate"],
Cell[122764, 4549, 137, 3, 70, "ReferenceTemplate"],
Cell[122904, 4554, 162, 3, 70, "ReferenceTemplate"],
Cell[123069, 4559, 124, 3, 70, "ReferenceTemplate"],
Cell[123196, 4564, 157, 3, 70, "ReferenceTemplate"],
Cell[123356, 4569, 121, 3, 70, "ReferenceTemplate"],
Cell[123480, 4574, 144, 3, 70, "ReferenceTemplate"],
Cell[123627, 4579, 106, 2, 70, "ReferenceTemplate"],
Cell[123736, 4583, 146, 3, 70, "Text"],
Cell[123885, 4588, 152, 3, 70, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[124074, 4596, 45, 0, 70, "Subsubsubsection"],
Cell[124122, 4598, 99, 2, 70, "Text"],
Cell[124224, 4602, 144, 3, 70, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[124405, 4610, 48, 0, 70, "Subsubsubsection"],
Cell[124456, 4612, 138, 3, 70, "ReferenceTemplate"],
Cell[124597, 4617, 99, 2, 70, "ReferenceTemplate"],
Cell[124699, 4621, 117, 3, 70, "ReferenceTemplate"],
Cell[124819, 4626, 143, 3, 70, "Text"],
Cell[124965, 4631, 85, 1, 70, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[125087, 4637, 44, 0, 70, "Subsubsubsection"],
Cell[125134, 4639, 168, 3, 70, "ReferenceTemplate"],
Cell[125305, 4644, 133, 3, 70, "ReferenceTemplate"],
Cell[125441, 4649, 148, 3, 70, "Text"],
Cell[125592, 4654, 168, 3, 70, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[125797, 4662, 54, 0, 70, "Subsubsubsection"],
Cell[125854, 4664, 105, 3, 70, "Text"],
Cell[125962, 4669, 125, 3, 70, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[126124, 4677, 51, 0, 70, "Subsubsubsection"],
Cell[126178, 4679, 107, 3, 70, "Text"],
Cell[126288, 4684, 105, 2, 70, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[126430, 4691, 46, 0, 70, "Subsubsubsection"],
Cell[126479, 4693, 103, 3, 70, "Text"],
Cell[126585, 4698, 87, 1, 70, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[126709, 4704, 52, 0, 70, "Subsubsubsection"],
Cell[126764, 4706, 127, 3, 70, "Text"],
Cell[126894, 4711, 58, 0, 70, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[126989, 4716, 42, 0, 70, "Subsubsubsection"],
Cell[127034, 4718, 97, 2, 70, "Text"],
Cell[127134, 4722, 44, 0, 70, "ReferenceTemplate"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[127227, 4728, 74, 1, 70, "Subsubsection"],
Cell[127304, 4731, 123, 3, 70, 27, 0, "StyleData", "RefTitle", "All",
 StyleMenuListing->None],
Cell[127430, 4736, 73, 2, 70, 26, 0, "StyleData", "RefType", "All",
 StyleMenuListing->None],
Cell[127506, 4740, 50, 1, 70, 25, 0, "StyleData", "RefURL", "All",
 StyleMenuListing->None],
Cell[127559, 4743, 60, 1, 70, 35, 0, "StyleData", "RefRetrievalDate", "All",
 StyleMenuListing->None],
Cell[127622, 4746, 63, 1, 70, 38, 0, "StyleData", "RefSourceOfAbstract", \
"All",
 StyleMenuListing->None],
Cell[127688, 4749, 62, 1, 70, 37, 0, "StyleData", "RefInsertedBibText", "All",
 
 StyleMenuListing->None],
Cell[127753, 4752, 51, 1, 70, 26, 0, "StyleData", "RefNote", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[127841, 4758, 72, 1, 70, "Subsubsection"],
Cell[127916, 4761, 127, 3, 70, 31, 0, "StyleData", "RefBookTitle", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[128080, 4769, 75, 1, 70, "Subsubsection"],
Cell[128158, 4772, 59, 1, 70, 34, 0, "StyleData", "RefJournalTitle", "All",
 StyleMenuListing->None],
Cell[128220, 4775, 130, 3, 70, 35, 0, "StyleData", "RefJournalVolume", "All",
 StyleMenuListing->None],
Cell[128353, 4780, 60, 1, 70, 35, 0, "StyleData", "RefJournalNumber", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[128450, 4786, 77, 1, 70, "Subsubsection"],
Cell[128530, 4789, 56, 1, 70, 31, 0, "StyleData", "RefPublisher", "All",
 StyleMenuListing->None],
Cell[128589, 4792, 72, 2, 70, 26, 0, "StyleData", "RefCity", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[128698, 4799, 74, 1, 70, "Subsubsection"],
Cell[128775, 4802, 58, 1, 70, 33, 0, "StyleData", "RefAuthorGroup", "All",
 StyleMenuListing->None],
Cell[128836, 4805, 55, 1, 70, 30, 0, "StyleData", "RefAuthorFN", "All",
 StyleMenuListing->None],
Cell[128894, 4808, 55, 1, 70, 30, 0, "StyleData", "RefAuthorLN", "All",
 StyleMenuListing->None],
Cell[128952, 4811, 55, 1, 70, 30, 0, "StyleData", "RefAuthorMN", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[129044, 4817, 74, 1, 70, "Subsubsection"],
Cell[129121, 4820, 58, 1, 70, 33, 0, "StyleData", "RefEditorGroup", "All",
 StyleMenuListing->None],
Cell[129182, 4823, 55, 1, 70, 30, 0, "StyleData", "RefEditorFN", "All",
 StyleMenuListing->None],
Cell[129240, 4826, 55, 1, 70, 30, 0, "StyleData", "RefEditorMN", "All",
 StyleMenuListing->None],
Cell[129298, 4829, 55, 1, 70, 30, 0, "StyleData", "RefEditorLN", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[129390, 4835, 74, 1, 70, "Subsubsection"],
Cell[129467, 4838, 53, 1, 70, 28, 0, "StyleData", "RefSchool", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[129557, 4844, 84, 1, 70, "Subsubsection"],
Cell[129644, 4847, 50, 1, 70, 25, 0, "StyleData", "RefDay", "All",
 StyleMenuListing->None],
Cell[129697, 4850, 52, 1, 70, 27, 0, "StyleData", "RefMonth", "All",
 StyleMenuListing->None],
Cell[129752, 4853, 51, 1, 70, 26, 0, "StyleData", "RefYear", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[129840, 4859, 111, 2, 70, "Subsubsection"],
Cell[129954, 4863, 77, 2, 70, 31, 0, "StyleData", "RefFirstPage", "All",
 StyleMenuListing->None],
Cell[130034, 4867, 76, 2, 70, 30, 0, "StyleData", "RefLastPage", "All",
 StyleMenuListing->None]
}, Closed]]
}, Closed]]
}, Closed]]
}
]
*)

(* End of internal cache information *)
