(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     60463,       2010]
NotebookOptionsPosition[     42315,       1560]
NotebookOutlinePosition[     42657,       1576]
CellTagsIndexPosition[     42614,       1573]
MenuPosition->0
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Title"],

Cell["\<\
Modify the definitions below to change the default appearance of all cells in \
a given style. Make modifications to any definition using commands in the \
Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
 ShowAutoStyles->False,
 ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
 ShowAutoStyles->False,
 ScriptMinSize->9],

Cell[StyleData[All, "SlideShow"],
 PageWidth->WindowWidth,
 ScrollingOptions->{"PagewiseDisplay"->True,
 "VerticalScrollRange"->Fit},
 ShowCellBracket->False,
 ShowAutoStyles->False,
 ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
 PageWidth->PaperWidth,
 ShowCellLabel->False,
 CellFrameLabelMargins->6,
 ShowAutoStyles->False,
 ImageSize->{200, 200},
 PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
 PageHeaders->{{
    Cell[
     TextData[{
       CounterBox["Page"]}], "PageNumber"], None, 
    Cell[
     TextData[{
       ValueBox["FileName"]}], "Header"]}, {
    Cell[
     TextData[{
       ValueBox["FileName"]}], "Header"], None, 
    Cell[
     TextData[{
       CounterBox["Page"]}], "PageNumber"]}},
 PageHeaderLines->{True, True},
 PrintingOptions->{"FacingPages"->True,
 "FirstPageHeader"->False},
 CellLabelAutoDelete->False,
 CellFrameLabelMargins->6,
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{18, 10}, {4, 20}},
 CellGroupingRules->{"TitleGrouping", 0},
 PageBreakBelow->False,
 CellFrameMargins->9,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 LineSpacing->{0.95, 12},
 CounterIncrements->"Title",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
 FontFamily->"Helvetica",
 FontSize->36,
 FontWeight->"Bold"],

Cell[StyleData["Title", "Presentation"],
 CellMargins->{{25, 10}, {15, 30}},
 CellFrameMargins->{{0, 0}, {0, 15}},
 FontSize->54],

Cell[StyleData["Title", "Printout"],
 CellMargins->{{18, 4}, {0, 0}},
 CellFrameMargins->4,
 FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
 CellMargins->{{18, 10}, {0, 10}},
 CellGroupingRules->{"TitleGrouping", 10},
 PageBreakBelow->False,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 LineSpacing->{1, 0},
 CounterIncrements->"Subtitle",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
 FontFamily->"Helvetica",
 FontSize->24],

Cell[StyleData["Subtitle", "Presentation"],
 CellMargins->{{25, 10}, {25, 10}},
 FontSize->36],

Cell[StyleData["Subtitle", "Printout"],
 FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SectionFirst"],
 CellFrame->{{0, 0}, {0, 3}},
 CellMargins->{{18, 10}, {10, 30}},
 CellGroupingRules->{"SectionGrouping", 40},
 PageBreakBelow->False,
 CellFrameMargins->5,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 FontFamily->"Helvetica",
 FontSize->18,
 FontWeight->"Bold"],

Cell[StyleData["SectionFirst", "Presentation"],
 CellFrame->{{0, 0}, {0, 5}},
 CellMargins->{{25, 10}, {40, 20}},
 FontSize->27],

Cell[StyleData["SectionFirst", "Printout"],
 CellMargins->{{18, 4}, {10, 30}},
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
 CellMargins->{{18, 10}, {10, 30}},
 CellGroupingRules->{"SectionGrouping", 40},
 PageBreakBelow->False,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 FontFamily->"Helvetica",
 FontSize->18,
 FontWeight->"Bold"],

Cell[StyleData["Section", "Presentation"],
 CellMargins->{{25, 10}, {30, 22}},
 FontSize->27],

Cell[StyleData["Section", "Printout"],
 CellMargins->{{18, 4}, {10, 30}},
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
 CellDingbat->"\[FilledSquare]",
 CellMargins->{{18, 50}, {10, 26}},
 CellGroupingRules->{"SectionGrouping", 50},
 PageBreakBelow->False,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"Subsection",
 CounterAssignments->{{"Subsubsection", 0}},
 FontFamily->"Helvetica",
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["Subsection", "Presentation"],
 CellMargins->{{25, 10}, {25, 25}},
 FontSize->21],

Cell[StyleData["Subsection", "Printout"],
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{18, 50}, {6, 20}},
 CellGroupingRules->{"SectionGrouping", 60},
 PageBreakBelow->False,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"Subsubsection",
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Presentation"],
 CellMargins->{{25, 10}, {10, 20}},
 FontSize->18],

Cell[StyleData["Subsubsection", "Printout"],
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
 CellMargins->{{18, 10}, {Inherited, 4}},
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 TextJustification->1,
 LineSpacing->{1, 3},
 CounterIncrements->"Text"],

Cell[StyleData["Text", "Presentation"],
 CellMargins->{{25, 10}, {8, 8}},
 FontSize->18],

Cell[StyleData["Text", "Printout"],
 CellMargins->{{18, 4}, {Inherited, 0}},
 Hyphenation->True,
 LineSpacing->{1, 3},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
 CellMargins->{{55, 55}, {5, 4}},
 PageBreakAbove->False,
 FontFamily->"Helvetica",
 FontSize->9],

Cell[StyleData["Caption", "Presentation"],
 CellMargins->{{75, 55}, {5, 5}},
 FontSize->14],

Cell[StyleData["Caption", "Printout"],
 Hyphenation->True,
 FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output to the \
kernel.  Be careful when modifying, renaming, or removing these styles, \
because the front end associates special meanings with these style names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
 CellFrame->{{1, 1}, {0, 1}},
 CellMargins->{{55, 10}, {0, 10}},
 Evaluatable->True,
 CellGroupingRules->"InputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultInputFormatType,
 ShowAutoStyles->True,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->"Formula",
 FormatType->InputForm,
 ShowStringCharacters->True,
 NumberMarks->True,
 LinebreakAdjustments->{0.85, 2, 10, 0, 1},
 CounterIncrements->"Input",
 FontWeight->"Bold",
 Background->GrayLevel[0.850004]],

Cell[StyleData["Input", "Presentation"],
 CellFrame->{{2, 2}, {0, 2}},
 CellMargins->{{75, 10}, {0, 10}},
 CellFrameMargins->12,
 FontSize->18],

Cell[StyleData["Input", "Printout"],
 CellMargins->{{55, 55}, {0, 10}},
 ShowCellLabel->False,
 LinebreakAdjustments->{0.85, 2, 10, 1, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InlineInput"],
 Evaluatable->True,
 CellGroupingRules->"InputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 DefaultFormatType->DefaultInputFormatType,
 ShowAutoStyles->True,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 FormatType->InputForm,
 ShowStringCharacters->True,
 NumberMarks->True,
 CounterIncrements->"Input",
 FontWeight->"Bold"],

Cell[StyleData["InlineInput", "Presentation"],
 CellMargins->{{8, 8}, {4, 4}},
 FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
 CellFrame->{{1, 1}, {1, 0}},
 CellMargins->{{55, 10}, {10, 0}},
 CellEditDuplicate->True,
 CellGroupingRules->"OutputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultOutputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->"Formula",
 FormatType->InputForm,
 CounterIncrements->"Output",
 Background->GrayLevel[0.850004]],

Cell[StyleData["Output", "Presentation"],
 CellFrame->{{2, 2}, {2, 0}},
 CellMargins->{{75, 10}, {15, 0}},
 CellFrameMargins->12,
 FontSize->18],

Cell[StyleData["Output", "Printout"],
 CellMargins->{{55, 55}, {10, 0}},
 ShowCellLabel->False,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InputOnly"],
 CellFrame->1,
 CellMargins->{{55, 10}, {0, 10}},
 Evaluatable->True,
 CellGroupingRules->"InputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultInputFormatType,
 ShowAutoStyles->True,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->"Formula",
 FormatType->InputForm,
 ShowStringCharacters->True,
 NumberMarks->True,
 LinebreakAdjustments->{0.85, 2, 10, 0, 1},
 CounterIncrements->"Input",
 FontWeight->"Bold",
 Background->GrayLevel[0.850004]],

Cell[StyleData["InputOnly", "Presentation"],
 CellFrame->2,
 CellMargins->{{75, 10}, {0, 15}},
 CellFrameMargins->12,
 FontSize->18],

Cell[StyleData["InputOnly", "Printout"],
 CellMargins->{{55, 55}, {0, 10}},
 ShowCellLabel->False,
 LinebreakAdjustments->{0.85, 2, 10, 1, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
 CellFrame->{{1, 1}, {0, 0}},
 CellDingbat->"\[LongDash]",
 CellMargins->{{55, 10}, {0, 0}},
 CellGroupingRules->"OutputGrouping",
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultOutputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 AutoStyleOptions->{"SyntaxErrorStyle"->None},
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 FormatType->InputForm,
 CounterIncrements->"Message",
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10,
 FontSlant->"Oblique"],

Cell[StyleData["Message", "Presentation"],
 CellFrame->{{2, 2}, {0, 0}},
 CellMargins->{{75, 10}, {0, 0}},
 FontSize->15],

Cell[StyleData["Message", "Printout"],
 CellMargins->{{55, 55}, {0, 0}},
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
 CellMargins->{{55, 26}, {1, 6}},
 CellGroupingRules->"OutputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultOutputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 TextAlignment->Left,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 FormatType->InputForm,
 CounterIncrements->"Print",
 StyleMenuListing->None,
 Background->GrayLevel[0.700008]],

Cell[StyleData["Print", "Presentation"],
 CellMargins->{{75, 34}, {0, 8}},
 CellFrameMargins->12,
 FontSize->18],

Cell[StyleData["Print", "Printout"],
 CellMargins->{{54, 72}, {2, 6}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
 CellFrame->{{1, 1}, {0, 0}},
 CellMargins->{{55, 10}, {0, 0}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 DefaultFormatType->DefaultOutputFormatType,
 FormatType->InputForm,
 CounterIncrements->"Graphics",
 ImageMargins->{{35, Inherited}, {Inherited, 0}},
 StyleMenuListing->None,
 Background->GrayLevel[0.850004]],

Cell[StyleData["Graphics", "Presentation"],
 CellFrame->{{2, 2}, {0, 0}},
 CellMargins->{{75, 10}, {0, 0}},
 CellFrameMargins->12,
 FontSize->18],

Cell[StyleData["Graphics", "Printout"],
 CellMargins->{{55, 55}, {0, 0}},
 ImageSize->{0.0625, 0.0625}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9,
 FontSlant->"Oblique"],

Cell[StyleData["CellLabel", "Presentation"],
 FontSize->14],

Cell[StyleData["CellLabel", "Printout"],
 CellMargins->{{0, Inherited}, {Inherited, Inherited}},
 FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Formatting", "Section"],

Cell["\<\
These styles are for modifying individual words or letters in a cell \
exclusive of the cell tag.\
\>", "Text"],

Cell[StyleData["RM"],
 StyleMenuListing->None,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["BF"],
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["IT"],
 StyleMenuListing->None,
 FontSlant->"Italic"],

Cell[StyleData["TR"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["TI"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["TB"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["TBI"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["MR"],
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["MO"],
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["MB"],
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["MBO"],
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["SR"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SO"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["SB"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["SBO"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[StyleData["SO10"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["SO10", "Printout"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->7,
 FontWeight->"Plain",
 FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Inert"],
 StyleMenuListing->None,
 Background->RGBColor[0.870588235294118, 0.905882352941176, 0.972549019607843]
  ],

Cell[StyleData["Inert", "Printout"],
 StyleMenuListing->None,
 Background->GrayLevel[1]]
}, Closed]],

Cell[StyleData["Small"],
 StyleMenuListing->None,
 FontSize->9],

Cell[StyleData["Medium"],
 StyleMenuListing->None,
 FontSize->12],

Cell[StyleData["Large"],
 StyleMenuListing->None,
 FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell["Unique Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Author"],
 CellMargins->{{20, Inherited}, {2, 20}},
 CellGroupingRules->{"TitleGrouping", 20},
 PageBreakBelow->False,
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
 FontFamily->"Helvetica",
 FontSize->14,
 FontSlant->"Italic"],

Cell[StyleData["Author", "Presentation"],
 CellMargins->{{25, 10}, {4, 30}},
 FontSize->21],

Cell[StyleData["Author", "Printout"],
 CellMargins->{{36, Inherited}, {2, 30}},
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Address"],
 CellMargins->{{18, Inherited}, {2, 2}},
 CellGroupingRules->{"TitleGrouping", 30},
 PageBreakBelow->False,
 LineSpacing->{1, 1},
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
 FontFamily->"Helvetica",
 FontSlant->"Italic"],

Cell[StyleData["Address", "Presentation"],
 CellMargins->{{25, 10}, {15, 4}},
 FontSize->18],

Cell[StyleData["Address", "Printout"],
 CellMargins->{{36, Inherited}, {2, 2}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Abstract"],
 CellFrame->False,
 CellMargins->{{45, 75}, {Inherited, 30}},
 LineSpacing->{1, 1}],

Cell[StyleData["Abstract", "Presentation"],
 CellMargins->{{60, 75}, {4, 35}},
 FontSize->18],

Cell[StyleData["Abstract", "Printout"],
 CellMargins->{{36, 67}, {Inherited, 50}},
 Hyphenation->True,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Reference"],
 CellMargins->{{18, 40}, {Inherited, 0}},
 TextJustification->1,
 LineSpacing->{1, 0}],

Cell[StyleData["Reference", "Presentation"],
 CellMargins->{{18, 40}, {2, 2}},
 FontSize->18],

Cell[StyleData["Reference", "Printout"],
 Hyphenation->True,
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureGroup"],
 CellFrame->{{1, 1}, {0, 0}},
 CellMargins->{{55, Inherited}, {0, 0}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 ShowCellLabel->False,
 CounterIncrements->"Graphics",
 ImageMargins->{{35, Inherited}, {Inherited, 0}},
 StyleMenuListing->None,
 Background->GrayLevel[0.850004]],

Cell[StyleData["PictureGroup", "Presentation"],
 CellFrame->{{2, 2}, {0, 0}},
 CellMargins->{{75, 10}, {0, 0}},
 CellFrameMargins->12,
 FontSize->18],

Cell[StyleData["PictureGroup", "Printout"],
 CellMargins->{{55, Inherited}, {0, 0}},
 ImageSize->{0.0625, 0.0625}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext ButtonBoxes.  The \
\"Hyperlink\" style is for links within the same Notebook, or between \
Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line help \
system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["MainBook", #]}]& )}],

Cell[StyleData["MainBookLink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Courier",
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["AddOns", #]}]& )}],

Cell[StyleData["AddOnsLink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Courier",
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["RefGuide", #]}]& )}],

Cell[StyleData["RefGuideLink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["GettingStarted", #]}]& )}],

Cell[StyleData["GettingStartedLink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DemosLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["Demos", #]}]& )}],

Cell[StyleData["DemosLink", "Printout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TourLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["Tour", #]}]& )}],

Cell[StyleData["TourLink", "Printout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["OtherInformation", #]}]& )}],

Cell[StyleData["OtherInformationLink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MasterIndexLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["MasterIndex", #]}]& )}],

Cell[StyleData["MasterIndexLink", "Printout"],
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, for use \
in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, After]}]& )}],

Cell[StyleData["Evaluate"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionEvaluate[
     FrontEnd`InputNotebook[], All]}]& )}],

Cell[StyleData["EvaluateCell"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionMove[
     FrontEnd`InputNotebook[], All, Cell, 1], 
    FrontEnd`SelectionEvaluateCreateCell[
     FrontEnd`InputNotebook[], All]}]& )}],

Cell[StyleData["CopyEvaluate"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionCreateCell[
     FrontEnd`InputNotebook[], All], 
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionEvaluate[
     FrontEnd`InputNotebook[], All]}]& )}],

Cell[StyleData["CopyEvaluateCell"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionCreateCell[
     FrontEnd`InputNotebook[], All], 
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionEvaluateCreateCell[
     FrontEnd`InputNotebook[], All]}]& )}]
}, Closed]],

Cell[CellGroupData[{

Cell["Slide Show Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["SlideShowNavigationBar"],
 Editable->False,
 CellFrame->True,
 CellMargins->{{0, 0}, {3, 3}},
 CellElementSpacings->{"CellMinHeight"->0.8125},
 CellGroupingRules->{"SectionGrouping", -5},
 CellFrameMargins->False,
 CellFrameColor->GrayLevel[1],
 CellFrameLabelMargins->False,
 TextAlignment->Center,
 CounterIncrements->"SlideShowNavigationBar",
 StyleMenuListing->None,
 FontSize->10,
 Magnification->1,
 Background->GrayLevel[0.8],
 GridBoxOptions->{
 ColumnAlignments->{
  Center, Center, Center, Center, Center, Center, Right, Center},
 ColumnSpacings->0,
 ColumnWidths->{3.5, 3.5, 3.5, 3.5, 13, 5, 4},
 GridBaseline->Center,
 RowAlignments->Baseline,
 RowSpacings->0}],

Cell[StyleData["SlideShowNavigationBar", "Presentation"]],

Cell[StyleData["SlideShowNavigationBar", "SlideShow"],
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{-1, -1}, {-1, -1}},
 PageBreakAbove->True,
 CellFrameMargins->{{1, 1}, {0, 0}}],

Cell[StyleData["SlideShowNavigationBar", "Printout"],
 CellMargins->{{18, 4}, {4, 4}},
 LineSpacing->{1, 3},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideShowSection"],
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{0, 0}, {10, 0}},
 CellGroupingRules->{"SectionGrouping", 40},
 PageBreakBelow->False,
 CellFrameMargins->{{12, 4}, {6, 12}},
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->18,
 FontWeight->"Plain",
 FontColor->GrayLevel[1],
 Background->RGBColor[0.408011, 0.440726, 0.8]],

Cell[StyleData["SlideShowSection", "Presentation"],
 CellFrameMargins->{{18, 10}, {10, 18}},
 FontSize->27],

Cell[StyleData["SlideShowSection", "SlideShow"],
 ShowCellBracket->False,
 PageBreakAbove->True],

Cell[StyleData["SlideShowSection", "Printout"],
 CellMargins->{{18, 30}, {0, 30}},
 CellFrameMargins->5,
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideHyperlink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontSize->26,
 FontColor->GrayLevel[0.400015],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonMargins->0.5,
 ButtonMinHeight->0.85,
 ButtonNote->None}],

Cell[StyleData["SlideHyperlink", "Presentation"],
 CellMargins->{{10, 10}, {10, 12}},
 FontSize->36],

Cell[StyleData["SlideHyperlink", "SlideShow"]],

Cell[StyleData["SlideHyperlink", "Printout"],
 FontSize->10,
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PreviousNext"],
 CellMargins->{{60, 10}, {7, 7}},
 TextAlignment->0.75,
 LineSpacing->{1, 3},
 CounterIncrements->"PreviousNext",
 FontFamily->"Helvetica",
 FontSize->10,
 FontColor->GrayLevel[0.500008]],

Cell[StyleData["PreviousNext", "Presentation"],
 CellMargins->{{24, 50}, {10, 10}},
 LineSpacing->{1, 5},
 FontSize->12],

Cell[StyleData["PreviousNext", "SlideShow"],
 CellMargins->{{50, 50}, {50, 15}},
 FontSize->12],

Cell[StyleData["PreviousNext", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->0.5,
 Hyphenation->True,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlidePreviousNextLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontVariations->{"Underline"->False},
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonMargins->0.5,
 ButtonMinHeight->0.85,
 ButtonNote->None}],

Cell[StyleData["SlidePreviousNextLink", "Presentation"]],

Cell[StyleData["SlidePreviousNextLink", "SlideShow"]],

Cell[StyleData["SlidePreviousNextLink", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOCLink"],
 CellMargins->{{24, Inherited}, {Inherited, Inherited}},
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Helvetica",
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonMargins->1.5,
 ButtonNote->ButtonData}],

Cell[StyleData["SlideTOCLink", "Presentation"],
 CellMargins->{{35, 10}, {5, 10}},
 FontSize->18],

Cell[StyleData["SlideTOCLink", "SlideShow"]],

Cell[StyleData["SlideTOCLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOC"],
 CellDingbat->"\[Bullet]",
 CellMargins->{{18, Inherited}, {Inherited, Inherited}},
 StyleMenuListing->None,
 FontFamily->"Helvetica"],

Cell[StyleData["SlideTOC", "Presentation"],
 CellMargins->{{25, 10}, {10, 5}},
 FontSize->18],

Cell[StyleData["SlideTOC", "SlideShow"],
 FontSize->14],

Cell[StyleData["SlideTOC", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Automatic Numbering", "Section"],

Cell["\<\
The following styles are useful for numbered equations, figures, etc.  They \
automatically give the cell a FrameLabel containing a reference to a \
particular counter, and also increment that counter.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["NumberedEquation"],
 CellMargins->{{55, 10}, {2, 10}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["NumberedEquation"], ")"}], FontFamily -> "Helvetica", 
     FontSize -> 10, FontWeight -> "Bold"]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 CounterIncrements->"NumberedEquation",
 FormatTypeAutoConvert->False],

Cell[StyleData["NumberedEquation", "Presentation"],
 CellMargins->{{80, 10}, {2, 10}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["NumberedEquation"], ")"}], FontFamily -> "Helvetica", 
     FontSize -> 16, FontWeight -> "Bold"]}, {None, None}},
 FontSize->18],

Cell[StyleData["NumberedEquation", "Printout"],
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["NumberedEquation"], ")"}], FontFamily -> "Helvetica", 
     FontSize -> 8, FontWeight -> "Bold"]}, {None, None}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedFigure"],
 CellMargins->{{55, 145}, {2, 10}},
 CellFrameLabels->{{None, None}, {
    Cell[
     TextData[{"Figure ", 
       CounterBox["NumberedFigure"]}], FontFamily -> "Helvetica", FontSize -> 
     10, FontWeight -> "Bold"], None}},
 TextAlignment->Left,
 CounterIncrements->"NumberedFigure",
 FormatTypeAutoConvert->False],

Cell[StyleData["NumberedFigure", "Presentation"],
 CellMargins->{{80, 145}, {2, 10}},
 CellFrameLabels->{{None, None}, {
    Cell[
     TextData[{"Figure ", 
       CounterBox["NumberedFigure"]}], FontFamily -> "Helvetica", FontSize -> 
     16, FontWeight -> "Bold"], None}},
 TextAlignment->Left,
 FontSize->18],

Cell[StyleData["NumberedFigure", "Printout"],
 CellFrameLabels->{{None, None}, {
    Cell[
     TextData[{"Figure ", 
       CounterBox["NumberedFigure"]}], FontFamily -> "Helvetica", FontSize -> 
     8, FontWeight -> "Bold"], None}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedTable"],
 CellMargins->{{55, 145}, {2, 10}},
 CellFrameLabels->{{None, None}, {
    Cell[
     TextData[{"Table ", 
       CounterBox["NumberedTable"]}], FontFamily -> "Helvetica", FontSize -> 
     10, FontWeight -> "Bold"], None}},
 TextAlignment->Center,
 CounterIncrements->"NumberedTable",
 FormatTypeAutoConvert->False],

Cell[StyleData["NumberedTable", "Presentation"],
 CellMargins->{{80, 145}, {10, 10}},
 CellFrameLabels->{{None, None}, {
    Cell[
     TextData[{"Table ", 
       CounterBox["NumberedTable"]}], FontFamily -> "Helvetica", FontSize -> 
     16, FontWeight -> "Bold"], None}},
 FontSize->18],

Cell[StyleData["NumberedTable", "Printout"],
 CellFrameLabels->{{None, None}, {
    Cell[
     TextData[{"Table ", 
       CounterBox["NumberedTable"]}], FontFamily -> "Helvetica", FontSize -> 
     8, FontWeight -> "Bold"], None}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
 CellMargins->{{55, 10}, {2, 10}},
 CellHorizontalScrolling->True,
 DefaultFormatType->DefaultInputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 LanguageCategory->"Formula",
 ScriptLevel->0,
 SingleLetterItalics->True,
 UnderoverscriptBoxOptions->{LimitsPositioning->True}],

Cell[StyleData["DisplayFormula", "Presentation"],
 CellMargins->{{80, 10}, {5, 20}},
 FontSize->18],

Cell[StyleData["DisplayFormula", "Printout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ChemicalFormula"],
 CellMargins->{{55, 10}, {2, 10}},
 DefaultFormatType->DefaultInputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 LanguageCategory->"Formula",
 AutoSpacing->False,
 ScriptBaselineShifts->{0.6, Automatic},
 ScriptLevel->1,
 SingleLetterItalics->False,
 ZeroWidthTimes->True],

Cell[StyleData["ChemicalFormula", "Presentation"],
 CellMargins->{{80, 10}, {10, 10}},
 FontSize->18],

Cell[StyleData["ChemicalFormula", "Printout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
 CellMargins->{{18, 10}, {Inherited, 6}},
 Hyphenation->False,
 LanguageCategory->"Formula",
 FontFamily->"Courier"],

Cell[StyleData["Program", "Presentation"],
 CellMargins->{{25, 10}, {10, 6}},
 FontSize->18],

Cell[StyleData["Program", "Printout"],
 CellMargins->{{18, 30}, {Inherited, 4}},
 FontSize->9.5]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headers and Footers", "Section"],

Cell[StyleData["Header"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9],

Cell[StyleData["PageNumber"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9,
 FontWeight->"Bold"],

Cell[StyleData["Footer"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->7]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit)",
WindowSize->{500, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
MenuPosition->None,
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[606, 24, 34, 0, 76, "Title"],
Cell[643, 26, 192, 4, 56, "Text"],
Cell[CellGroupData[{
Cell[860, 34, 42, 0, 67, "Section"],
Cell[905, 36, 74, 2, 70, 31, 0, "StyleData", "All", "Working"],
Cell[982, 40, 79, 2, 70, 36, 0, "StyleData", "All", "Presentation"],
Cell[1064, 44, 201, 6, 70, 33, 0, "StyleData", "All", "SlideShow"],
Cell[1268, 52, 200, 6, 70, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[1505, 63, 35, 0, 37, "Section"],
Cell[1543, 65, 99, 2, 70, "Text"],
Cell[1645, 69, 520, 19, 70, 27, 0, "StyleData", "Notebook", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[2202, 93, 38, 0, 37, "Section"],
Cell[CellGroupData[{
Cell[2265, 97, 1334, 34, 70, 24, 0, "StyleData", "Title", "All",
 CounterIncrements->"Title",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[3602, 133, 129, 3, 70, 40, 0, "StyleData", "Title", "Presentation"],
Cell[3734, 138, 106, 3, 70, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[3877, 146, 1262, 31, 70, 27, 0, "StyleData", "Subtitle", "All",
 CounterIncrements->"Subtitle",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[5142, 179, 94, 2, 70, 43, 0, "StyleData", "Subtitle", "Presentation"],
Cell[5239, 183, 54, 1, 70, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[5330, 189, 1312, 33, 70, 31, 0, "StyleData", "SectionFirst", "All",
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[6645, 224, 128, 3, 70, 47, 0, "StyleData", "SectionFirst", \
"Presentation"],
Cell[6776, 229, 93, 2, 70, 43, 0, "StyleData", "SectionFirst", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[6906, 236, 1255, 31, 70, 26, 0, "StyleData", "Section", "All",
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[8164, 269, 93, 2, 70, 42, 0, "StyleData", "Section", "Presentation"],
Cell[8260, 273, 88, 2, 70, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[8385, 280, 1275, 32, 70, 29, 0, "StyleData", "Subsection", "All",
 CounterIncrements->"Subsection",
 CounterAssignments->{{"Subsubsection", 0}}],
Cell[9663, 314, 96, 2, 70, 45, 0, "StyleData", "Subsection", "Presentation"],
Cell[9762, 318, 56, 1, 70, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[9855, 324, 1240, 31, 70, 32, 0, "StyleData", "Subsubsection", "All",
 CounterIncrements->"Subsubsection"],
Cell[11098, 357, 99, 2, 70, 48, 0, "StyleData", "Subsubsection", \
"Presentation"],
Cell[11200, 361, 59, 1, 70, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[11308, 368, 39, 0, 37, "Section"],
Cell[CellGroupData[{
Cell[11372, 372, 1105, 27, 70, 23, 0, "StyleData", "Text", "All",
 CounterIncrements->"Text"],
Cell[12480, 401, 88, 2, 70, 39, 0, "StyleData", "Text", "Presentation"],
Cell[12571, 405, 133, 4, 70, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[12741, 414, 124, 4, 70, 26, 0, "StyleData", "Caption", "All"],
Cell[12868, 420, 91, 2, 70, 42, 0, "StyleData", "Caption", "Presentation"],
Cell[12962, 424, 72, 2, 70, 38, 0, "StyleData", "Caption", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[13083, 432, 42, 0, 37, "Section"],
Cell[13128, 434, 246, 4, 70, "Text"],
Cell[CellGroupData[{
Cell[13399, 442, 729, 21, 70, 24, 0, "StyleData", "Input", "All",
 CounterIncrements->"Input"],
Cell[14131, 465, 143, 4, 70, 40, 0, "StyleData", "Input", "Presentation"],
Cell[14277, 471, 153, 4, 70, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[14467, 480, 500, 15, 70, 30, 0, "StyleData", "InlineInput", "All",
 CounterIncrements->"Input"],
Cell[14970, 497, 93, 2, 70, 46, 0, "StyleData", "InlineInput", \
"Presentation"]
}, Closed]],
Cell[CellGroupData[{
Cell[15100, 504, 650, 18, 70, 25, 0, "StyleData", "Output", "All",
 CounterIncrements->"Output"],
Cell[15753, 524, 144, 4, 70, 41, 0, "StyleData", "Output", "Presentation"],
Cell[15900, 530, 110, 3, 70, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[16047, 538, 718, 21, 70, 28, 0, "StyleData", "InputOnly", "All",
 CounterIncrements->"Input"],
Cell[16768, 561, 132, 4, 70, 44, 0, "StyleData", "InputOnly", \
"Presentation"],
Cell[16903, 567, 157, 4, 70, 40, 0, "StyleData", "InputOnly", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[17097, 576, 717, 21, 70, 26, 0, "StyleData", "Message", "All",
 CounterIncrements->"Message",
 StyleMenuListing->None],
Cell[17817, 599, 121, 3, 70, 42, 0, "StyleData", "Message", "Presentation"],
Cell[17941, 604, 86, 2, 70, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[18064, 611, 631, 18, 70, 24, 0, "StyleData", "Print", "All",
 CounterIncrements->"Print",
 StyleMenuListing->None],
Cell[18698, 631, 112, 3, 70, 40, 0, "StyleData", "Print", "Presentation"],
Cell[18813, 636, 85, 2, 70, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[18935, 643, 469, 14, 70, 27, 0, "StyleData", "Graphics", "All",
 CounterIncrements->"Graphics",
 StyleMenuListing->None],
Cell[19407, 659, 145, 4, 70, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[19555, 665, 103, 2, 70, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[19695, 672, 116, 4, 70, 28, 0, "StyleData", "CellLabel", "All",
 StyleMenuListing->None],
Cell[19814, 678, 59, 1, 70, 44, 0, "StyleData", "CellLabel", "Presentation"],
Cell[19876, 681, 110, 2, 70, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[20035, 689, 36, 0, 37, "Section"],
Cell[20074, 691, 121, 3, 70, "Text"],
Cell[20198, 696, 89, 3, 70, 21, 0, "StyleData", "RM", "All",
 StyleMenuListing->None],
Cell[20290, 701, 67, 2, 70, 21, 0, "StyleData", "BF", "All",
 StyleMenuListing->None],
Cell[20360, 705, 68, 2, 70, 21, 0, "StyleData", "IT", "All",
 StyleMenuListing->None],
Cell[20431, 709, 111, 4, 70, 21, 0, "StyleData", "TR", "All",
 StyleMenuListing->None],
Cell[20545, 715, 112, 4, 70, 21, 0, "StyleData", "TI", "All",
 StyleMenuListing->None],
Cell[20660, 721, 110, 4, 70, 21, 0, "StyleData", "TB", "All",
 StyleMenuListing->None],
Cell[20773, 727, 112, 4, 70, 22, 0, "StyleData", "TBI", "All",
 StyleMenuListing->None],
Cell[20888, 733, 227, 6, 70, 21, 0, "StyleData", "MR", "All",
 StyleMenuListing->None],
Cell[21118, 741, 228, 6, 70, 21, 0, "StyleData", "MO", "All",
 StyleMenuListing->None],
Cell[21349, 749, 226, 6, 70, 21, 0, "StyleData", "MB", "All",
 StyleMenuListing->None],
Cell[21578, 757, 228, 6, 70, 22, 0, "StyleData", "MBO", "All",
 StyleMenuListing->None],
Cell[21809, 765, 115, 4, 70, 21, 0, "StyleData", "SR", "All",
 StyleMenuListing->None],
Cell[21927, 771, 116, 4, 70, 21, 0, "StyleData", "SO", "All",
 StyleMenuListing->None],
Cell[22046, 777, 114, 4, 70, 21, 0, "StyleData", "SB", "All",
 StyleMenuListing->None],
Cell[22163, 783, 116, 4, 70, 22, 0, "StyleData", "SBO", "All",
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[22304, 791, 133, 5, 70, 23, 0, "StyleData", "SO10", "All",
 StyleMenuListing->None],
Cell[22440, 798, 144, 5, 70, 35, 0, "StyleData", "SO10", "Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[22621, 808, 132, 3, 70, 24, 0, "StyleData", "Inert", "All",
 StyleMenuListing->None],
Cell[22756, 813, 88, 2, 70, 36, 0, "StyleData", "Inert", "Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[22859, 818, 63, 2, 70, 24, 0, "StyleData", "Small", "All",
 StyleMenuListing->None],
Cell[22925, 822, 65, 2, 70, 25, 0, "StyleData", "Medium", "All",
 StyleMenuListing->None],
Cell[22993, 826, 64, 2, 70, 24, 0, "StyleData", "Large", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[23094, 833, 32, 0, 37, "Section"],
Cell[CellGroupData[{
Cell[23151, 837, 268, 7, 70, 25, 0, "StyleData", "Author", "All",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[23422, 846, 91, 2, 70, 41, 0, "StyleData", "Author", "Presentation"],
Cell[23516, 850, 94, 2, 70, 37, 0, "StyleData", "Author", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[23647, 857, 275, 7, 70, 26, 0, "StyleData", "Address", "All",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[23925, 866, 92, 2, 70, 42, 0, "StyleData", "Address", "Presentation"],
Cell[24020, 870, 94, 2, 70, 38, 0, "StyleData", "Address", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[24151, 877, 111, 3, 70, 27, 0, "StyleData", "Abstract", "All"],
Cell[24265, 882, 93, 2, 70, 43, 0, "StyleData", "Abstract", "Presentation"],
Cell[24361, 886, 117, 3, 70, 39, 0, "StyleData", "Abstract", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[24515, 894, 115, 3, 70, 28, 0, "StyleData", "Reference", "All"],
Cell[24633, 899, 93, 2, 70, 44, 0, "StyleData", "Reference", "Presentation"],
Cell[24729, 903, 74, 2, 70, 40, 0, "StyleData", "Reference", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[24840, 910, 363, 10, 70, 31, 0, "StyleData", "PictureGroup", "All",
 CounterIncrements->"Graphics",
 StyleMenuListing->None],
Cell[25206, 922, 149, 4, 70, 47, 0, "StyleData", "PictureGroup", \
"Presentation"],
Cell[25358, 928, 114, 2, 70, 43, 0, "StyleData", "PictureGroup", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[25521, 936, 35, 0, 37, "Section"],
Cell[25559, 938, 184, 4, 70, "Text"],
Cell[CellGroupData[{
Cell[25768, 946, 254, 7, 70, 28, 0, "StyleData", "Hyperlink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[26025, 955, 81, 2, 70, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[26121, 960, 104, 3, 70, "Text"],
Cell[CellGroupData[{
Cell[26250, 967, 268, 7, 70, 31, 0, "StyleData", "MainBookLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[26521, 976, 84, 2, 70, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[26642, 983, 288, 8, 70, 29, 0, "StyleData", "AddOnsLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[26933, 993, 82, 2, 70, 41, 0, "StyleData", "AddOnsLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[27052, 1000, 292, 8, 70, 31, 0, "StyleData", "RefGuideLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[27347, 1010, 84, 2, 70, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[27468, 1017, 280, 7, 70, 37, 0, "StyleData", "GettingStartedLink", "All",
 
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[27751, 1026, 90, 2, 70, 49, 0, "StyleData", "GettingStartedLink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[27878, 1033, 262, 7, 70, 28, 0, "StyleData", "DemosLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[28143, 1042, 66, 1, 70, 40, 0, "StyleData", "DemosLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[28246, 1048, 260, 7, 70, 27, 0, "StyleData", "TourLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[28509, 1057, 65, 1, 70, 39, 0, "StyleData", "TourLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[28611, 1063, 284, 7, 70, 39, 0, "StyleData", "OtherInformationLink", \
"All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[28898, 1072, 92, 2, 70, 51, 0, "StyleData", "OtherInformationLink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[29027, 1079, 274, 7, 70, 34, 0, "StyleData", "MasterIndexLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[29304, 1088, 72, 1, 70, 46, 0, "StyleData", "MasterIndexLink", \
"Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[29425, 1095, 33, 0, 37, "Section"],
Cell[29461, 1097, 121, 3, 70, "Text"],
Cell[29585, 1102, 216, 5, 70, 24, 0, "StyleData", "Paste", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[29804, 1109, 287, 7, 70, 27, 0, "StyleData", "Evaluate", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[30094, 1118, 376, 9, 70, 31, 0, "StyleData", "EvaluateCell", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[30473, 1129, 363, 9, 70, 31, 0, "StyleData", "CopyEvaluate", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[30839, 1140, 377, 9, 70, 35, 0, "StyleData", "CopyEvaluateCell", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic]
}, Closed]],
Cell[CellGroupData[{
Cell[31253, 1154, 36, 0, 37, "Section"],
Cell[CellGroupData[{
Cell[31314, 1158, 689, 22, 70, 41, 0, "StyleData", "SlideShowNavigationBar", \
"All",
 CounterIncrements->"SlideShowNavigationBar",
 StyleMenuListing->None],
Cell[32006, 1182, 57, 0, 70, 57, 0, "StyleData", "SlideShowNavigationBar", \
"Presentation"],
Cell[32066, 1184, 194, 5, 70, 54, 0, "StyleData", "SlideShowNavigationBar", \
"SlideShow"],
Cell[32263, 1191, 123, 3, 70, 53, 0, "StyleData", "SlideShowNavigationBar", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[32423, 1199, 1432, 36, 70, 35, 0, "StyleData", "SlideShowSection", "All",
 
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 StyleMenuListing->None],
Cell[33858, 1237, 107, 2, 70, 51, 0, "StyleData", "SlideShowSection", \
"Presentation"],
Cell[33968, 1241, 96, 2, 70, 48, 0, "StyleData", "SlideShowSection", \
"SlideShow"],
Cell[34067, 1245, 119, 3, 70, 47, 0, "StyleData", "SlideShowSection", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[34223, 1253, 315, 10, 70, 33, 0, "StyleData", "SlideHyperlink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[34541, 1265, 100, 2, 70, 49, 0, "StyleData", "SlideHyperlink", \
"Presentation"],
Cell[34644, 1269, 46, 0, 70, 46, 0, "StyleData", "SlideHyperlink", \
"SlideShow"],
Cell[34693, 1271, 125, 3, 70, 45, 0, "StyleData", "SlideHyperlink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[34855, 1279, 219, 7, 70, 31, 0, "StyleData", "PreviousNext", "All",
 CounterIncrements->"PreviousNext"],
Cell[35077, 1288, 120, 3, 70, 47, 0, "StyleData", "PreviousNext", \
"Presentation"],
Cell[35200, 1293, 95, 2, 70, 44, 0, "StyleData", "PreviousNext", \
"SlideShow"],
Cell[35298, 1297, 135, 4, 70, 43, 0, "StyleData", "PreviousNext", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[35470, 1306, 313, 9, 70, 40, 0, "StyleData", "SlidePreviousNextLink", \
"All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[35786, 1317, 56, 0, 70, 56, 0, "StyleData", "SlidePreviousNextLink", \
"Presentation"],
Cell[35845, 1319, 53, 0, 70, 53, 0, "StyleData", "SlidePreviousNextLink", \
"SlideShow"],
Cell[35901, 1321, 52, 0, 70, 52, 0, "StyleData", "SlidePreviousNextLink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[35990, 1326, 330, 9, 70, 31, 0, "StyleData", "SlideTOCLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[36323, 1337, 97, 2, 70, 47, 0, "StyleData", "SlideTOCLink", \
"Presentation"],
Cell[36423, 1341, 44, 0, 70, 44, 0, "StyleData", "SlideTOCLink", \
"SlideShow"],
Cell[36470, 1343, 108, 2, 70, 43, 0, "StyleData", "SlideTOCLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[36615, 1350, 162, 4, 70, 27, 0, "StyleData", "SlideTOC", "All",
 StyleMenuListing->None],
Cell[36780, 1356, 93, 2, 70, 43, 0, "StyleData", "SlideTOC", "Presentation"],
Cell[36876, 1360, 55, 1, 70, 40, 0, "StyleData", "SlideTOC", "SlideShow"],
Cell[36934, 1363, 80, 2, 70, 39, 0, "StyleData", "SlideTOC", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[37063, 1371, 49, 0, 37, "Section"],
Cell[37115, 1373, 225, 4, 70, "Text"],
Cell[CellGroupData[{
Cell[37365, 1381, 491, 11, 70, 35, 0, "StyleData", "NumberedEquation", "All",
 CounterIncrements->"NumberedEquation"],
Cell[37859, 1394, 293, 7, 70, 51, 0, "StyleData", "NumberedEquation", \
"Presentation"],
Cell[38155, 1403, 238, 5, 70, 47, 0, "StyleData", "NumberedEquation", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[38430, 1413, 351, 9, 70, 33, 0, "StyleData", "NumberedFigure", "All",
 CounterIncrements->"NumberedFigure"],
Cell[38784, 1424, 313, 8, 70, 49, 0, "StyleData", "NumberedFigure", \
"Presentation"],
Cell[39100, 1434, 235, 5, 70, 45, 0, "StyleData", "NumberedFigure", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[39372, 1444, 349, 9, 70, 32, 0, "StyleData", "NumberedTable", "All",
 CounterIncrements->"NumberedTable"],
Cell[39724, 1455, 289, 7, 70, 48, 0, "StyleData", "NumberedTable", \
"Presentation"],
Cell[40016, 1464, 232, 5, 70, 44, 0, "StyleData", "NumberedTable", \
"Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[40297, 1475, 43, 0, 23, "Section"],
Cell[CellGroupData[{
Cell[40365, 1479, 388, 9, 70, 33, 0, "StyleData", "DisplayFormula", "All"],
Cell[40756, 1490, 99, 2, 70, 49, 0, "StyleData", "DisplayFormula", \
"Presentation"],
Cell[40858, 1494, 60, 1, 70, 45, 0, "StyleData", "DisplayFormula", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[40955, 1500, 388, 10, 70, 34, 0, "StyleData", "ChemicalFormula", "All"],
Cell[41346, 1512, 101, 2, 70, 50, 0, "StyleData", "ChemicalFormula", \
"Presentation"],
Cell[41450, 1516, 61, 1, 70, 46, 0, "StyleData", "ChemicalFormula", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[41548, 1522, 143, 4, 70, 26, 0, "StyleData", "Program", "All"],
Cell[41694, 1528, 92, 2, 70, 42, 0, "StyleData", "Program", "Presentation"],
Cell[41789, 1532, 96, 2, 70, 38, 0, "StyleData", "Program", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[41934, 1540, 49, 0, 23, "Section"],
Cell[41986, 1542, 90, 3, 70, 25, 0, "StyleData", "Header", "All",
 StyleMenuListing->None],
Cell[42079, 1547, 115, 4, 70, 29, 0, "StyleData", "PageNumber", "All",
 StyleMenuListing->None],
Cell[42197, 1553, 90, 3, 70, 25, 0, "StyleData", "Footer", "All",
 StyleMenuListing->None]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
