(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    194257,       6564]
NotebookOptionsPosition[    116519,       4727]
NotebookOutlinePosition[    116967,       4745]
CellTagsIndexPosition[    116924,       4742]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[StyleData[StyleDefinitions -> "PublicationDefault.nb"]],

Cell["\<\
Modify the definitions below to change the default appearance of all cells in \
a given style. 
Make modifications to any definition using commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
 ReturnCreatesNewCell->True,
 DefaultNewCellStyle->"BookChapterTitle"]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Title and Section Cells", "Section"],

Cell[CellGroupData[{

Cell["Title", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
 CellMargins->{{12, 12}, {4, 36}},
 CellGroupingRules->{"TitleGrouping", 10},
 ConversionRules:>{"TeX" -> {"\n\\title{", Automatic, "}"}},
 PageBreakBelow->False,
 DefaultNewCellStyle->"Section",
 DefaultReturnCreatedCellStyle->"Subtitle",
 TextAlignment->Center,
 LineSpacing->{1, 2},
 MenuPosition->None,
 FontSize->32,
 FontWeight->"Bold"],

Cell[StyleData["Title", "Presentation"],
 CellFrame->False,
 ShowGroupOpener->False,
 CellMargins->{{12, 12}, {6, 54}},
 FontSize->48,
 FontWeight->"Bold"],

Cell[StyleData["Title", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Title", "Printout", StyleDefinitions -> None]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
 CellMargins->{{12, 12}, {4, 2}},
 CellGroupingRules->{"TitleGrouping", 20},
 ConversionRules:>{"TeX" -> {"\n\\subtitle{", Automatic, "}"}},
 PageBreakBelow->False,
 DefaultNewCellStyle->"Text",
 DefaultReturnCreatedCellStyle->"Section",
 TextAlignment->Center,
 LineSpacing->{1, 0},
 MenuPosition->None,
 FontSize->20,
 FontSlant->"Italic"],

Cell[StyleData["Subtitle", "Presentation"],
 CellMargins->{{12, 12}, {6, 3}},
 FontSize->30,
 FontSlant->"Italic"],

Cell[StyleData["Subtitle", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Subtitle", "Printout", StyleDefinitions -> None]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Styles for Publication\[Hyphen]ready Documents\
\>", "Section"],

Cell[CellGroupData[{

Cell["Frontmatter", "Subsection"],

Cell[CellGroupData[{

Cell["Author", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Author"],
 CellMargins->{{54, 54}, {2, 24}},
 CellGroupingRules->{"SectionGrouping", 50},
 ConversionRules:>{"TeX" -> {"", 
     ExtractCellTaggingRules["AuthorData", "TeX", 1], ""}},
 DefaultNewCellStyle->"Section",
 DefaultReturnCreatedCellStyle->"Institution",
 TextAlignment->Center,
 ParagraphSpacing->{0, 0},
 MenuPosition->2000,
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["Author", "Presentation"],
 CellMargins->{{47, 47}, {0, 36}},
 TextAlignment->Center],

Cell[StyleData["Author", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Author", "Printout", StyleDefinitions -> None]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Institution", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Institution"],
 CellMargins->{{54, 54}, {0, 0}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 DefaultNewCellStyle->"Section",
 DefaultReturnCreatedCellStyle->"Author",
 TextAlignment->Center,
 CounterIncrements->"Institution",
 MenuPosition->2010],

Cell[StyleData["Institution", "FlushLeft"],
 Editable->False,
 CellMargins->{{54, 54}, {0, 0}},
 TextAlignment->Left,
 ParagraphIndent->-18,
 FontSize->12,
 FontColor->RGBColor[0, 0, 0.500008]],

Cell[StyleData["Institution", "Presentation"],
 Editable->False,
 CellMargins->{{54, 54}, {1, 1}},
 FontSize->18],

Cell[StyleData["Institution", "Condensed", StyleDefinitions -> None]],

Cell[StyleData["Institution", "Printout", StyleDefinitions -> None]],

Cell[StyleData["Institution", "FlushLeftPrintout"],
 Editable->False,
 CellMargins->{{48, 48}, {0, 0}},
 TextAlignment->Left,
 ParagraphIndent->-16,
 FontSize->10,
 FontColor->GrayLevel[0]],

Cell[StyleData["Institution", "DoubleSpacedPrintout"],
 CellMargins->{{48, 48}, {0, 0}},
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Table of Contents", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell["Book", "Subsubsubsection"],

Cell[CellGroupData[{

Cell["Title Headings", "Subsubsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TOCBookHeading"],
 CellMargins->{{12, 12}, {98, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 PageBreakAbove->True,
 PageBreakBelow->False,
 TextAlignment->Center,
 LineSpacing->{1, 2},
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}},
 FontFamily->"Helvetica",
 FontSize->24,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookHeading", "Centered"],
 CellMargins->{{12, 12}, {98, 72}},
 TextAlignment->Center],

Cell[StyleData["TOCBookHeading", "Printout"],
 CellMargins->{{2, 2}, {78, 60}},
 TextAlignment->Center,
 FontSize->21],

Cell[StyleData["TOCBookHeading", "CenteredPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 TextAlignment->Center,
 FontSize->21],

Cell[StyleData["TOCBookHeading", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 FontSize->21]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookIllustrations"],
 CellMargins->{{12, 12}, {98, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 PageBreakAbove->True,
 TextAlignment->Center,
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}},
 FontFamily->"Helvetica",
 FontSize->24,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookIllustrations", "Centered"],
 CellMargins->{{12, 12}, {98, 72}},
 TextAlignment->Center],

Cell[StyleData["TOCIllustrations", "Printout"],
 CellMargins->{{2, 2}, {78, 60}},
 FontSize->21],

Cell[StyleData["TOCBookIllustrations", "CenteredPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 TextAlignment->Center,
 FontSize->21],

Cell[StyleData["TOCBookIllustrations", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 PageBreakAbove->True,
 FontSize->21]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookTables"],
 CellMargins->{{12, 12}, {98, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 PageBreakAbove->True,
 TextAlignment->Center,
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}},
 FontFamily->"Helvetica",
 FontSize->24,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookTables", "Centered"],
 CellMargins->{{12, 12}, {98, 72}},
 TextAlignment->Center],

Cell[StyleData["TOCBookTables", "Printout"],
 CellMargins->{{2, 2}, {78, 60}},
 TextAlignment->Center,
 FontSize->21],

Cell[StyleData["TOCBookTables", "CenteredPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 TextAlignment->Center,
 FontSize->21],

Cell[StyleData["TOCBookTables", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 FontSize->21]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Contents Headings", "Subsubsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TOCBookFrontmatterHeading"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 TabSpacings->54,
 CounterIncrements->"TOCBookFrontmatterHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}},
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookFrontmatterHeading", "Centered"]],

Cell[StyleData["TOCBookFrontmatterHeading", "Printout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12],

Cell[StyleData["TOCBookFrontmatterHeading", "CenteredPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12],

Cell[StyleData["TOCBookFrontmatterHeading", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookBackmatterHeading"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 TabSpacings->54,
 CounterIncrements->"TOCBookBackmatterHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}},
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookBackmatterHeading", "Centered"]],

Cell[StyleData["TOCBookBackmatterHeading", "Printout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12],

Cell[StyleData["TOCBookBackmatterHeading", "CenteredPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12],

Cell[StyleData["TOCBookBackmatterHeading", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookFrontBackHeading"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 TabSpacings->54,
 CounterIncrements->"TOCBookFrontBackHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}},
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookFrontBackHeading", "Centered"]],

Cell[StyleData["TOCBookFrontBackHeading", "Printout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12],

Cell[StyleData["TOCBookFrontBackHeading", "CenteredPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12],

Cell[StyleData["TOCBookFrontBackHeading", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPartTitle"],
 CellMargins->{{36, 12}, {1, 12}},
 CellGroupingRules->{"SectionGrouping", 30},
 CellFrameLabels->{{
    Cell[
     TextData[{"Part ", 
       CounterBox["TOCBookPartTitle"]}], "TOCBookPartTitleLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"TOCBookPartTitle",
 CounterAssignments->{{"TOCBookChapterTitle", 0}},
 FontSize->16,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookPartTitle", "Centered"]],

Cell[StyleData["TOCBookPartTitle", "Printout"],
 CellMargins->{{22, 2}, {0, 10}},
 FontSize->14],

Cell[StyleData["TOCBookPartTitle", "CenteredPrintout"],
 CellMargins->{{22, 2}, {0, 10}},
 FontSize->14],

Cell[StyleData["TOCBookPartTitle", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 10}},
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookChapterTitle"],
 CellMargins->{{12, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["TOCBookChapterTitle"]}], "TOCBookChapterTitleLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->54,
 CounterIncrements->"TOCBookChapterTitle",
 CounterAssignments->{{"TOCBookSection", 0}},
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookChapterTitle", "Centered"]],

Cell[StyleData["TOCBookChapterTitle", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->46,
 FontSize->12],

Cell[StyleData["TOCBookChapterTitle", "CenteredPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->46,
 FontSize->12],

Cell[StyleData["TOCBookChapterTitle", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->46,
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSection"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["TOCBookChapterTitle"], ".", 
       CounterBox["TOCBookSection"]}], "TOCBookSectionLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->49.87,
 CounterIncrements->"TOCBookSection",
 CounterAssignments->{{"TOCBookSubsection", 0}}],

Cell[StyleData["TOCBookSection", "Centered"]],

Cell[StyleData["TOCBookSection", "Printout"],
 CellMargins->{{24, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->41.8,
 FontSize->10],

Cell[StyleData["TOCBookSection", "CenteredPrintout"],
 CellMargins->{{24, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->41.8,
 FontSize->10],

Cell[StyleData["TOCBookSection", "DoubleSpacedPrintout"],
 CellMargins->{{24, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->41.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSubsection"],
 CellMargins->{{60, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 60},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["TOCBookChapterTitle"], ".", 
       CounterBox["TOCBookSection"], ".", 
       CounterBox["TOCBookSubsection"]}], "TOCBookSubsectionLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->45.8,
 CounterIncrements->"TOCBookSubsection"],

Cell[StyleData["TOCBookSubsection", "Centered"]],

Cell[StyleData["TOCBookSubsection", "Printout"],
 CellMargins->{{48, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->36.7,
 FontSize->10],

Cell[StyleData["TOCBookSubsection", "CenteredPrintout"],
 CellMargins->{{48, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->36.7,
 FontSize->10],

Cell[StyleData["TOCBookSubsection", "DoubleSpacedPrintout"],
 CellMargins->{{48, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->36.7,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookFigure"],
 CellMargins->{{12, 12}, {1, 1}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Fig. ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookFigure"], "."}], "TOCBookFigureLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookFigure"],

Cell[StyleData["TOCBookFigure", "Centered"]],

Cell[StyleData["TOCBookFigure", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookFigure", "CenteredPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookFigure", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSupplemental"],
 CellMargins->{{12, 12}, {1, 1}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Supp. ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookSupplemental"], "."}], "TOCBookSupplementalLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookSupplemental"],

Cell[StyleData["TOCBookSupplemental", "Centered"]],

Cell[StyleData["TOCBookSupplemental", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookSupplemental", "CenteredPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookSupplemental", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPicture"],
 CellMargins->{{12, 12}, {1, 1}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Pict. ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookPicture"], "."}], "TOCBookPictureLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookPicture"],

Cell[StyleData["TOCBookPicture", "Centered"]],

Cell[StyleData["TOCBookPicture", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookPicture", "CenteredPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookPicture", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookIllustration"],
 CellMargins->{{12, 12}, {1, 1}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Illus. ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookIllustration"], "."}], "TOCBookIllustrationLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookIllustration"],

Cell[StyleData["TOCBookIllustration", "Centered"]],

Cell[StyleData["TOCBookIllustration", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookIllustration", "CenteredPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookIllustration", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookProgram"],
 CellMargins->{{12, 12}, {1, 1}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Pgm. ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookProgram"], "."}], "TOCBookProgramLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookProgram"],

Cell[StyleData["TOCBookProgram", "Centered"]],

Cell[StyleData["TOCBookProgram", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookProgram", "CenteredPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookProgram", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookTable"],
 CellMargins->{{12, 12}, {1, 1}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Table ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookTable"], "."}], "TOCBookTableLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookTable"],

Cell[StyleData["TOCBookTable", "Centered"]],

Cell[StyleData["TOCBookTable", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookTable", "CenteredPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookTable", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Labels and misc", "Subsubsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSpacer"],
 CellMargins->{{12, 12}, {0, 0}}],

Cell[StyleData["TOCBookSpacer", "Centered"],
 CellMargins->{{12, 12}, {0, 0}}],

Cell[StyleData["TOCBookSpacer", "Printout"],
 CellMargins->{{2, 2}, {0, 0}}],

Cell[StyleData["TOCBookSpacer", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 0}}],

Cell[StyleData["TOCBookSpacer", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 0}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPartTitleLabel"],
 CellSize->{42, Inherited}],

Cell[StyleData["TOCBookPartTitleLabel", "Centered"]],

Cell[StyleData["TOCBookPartTitleLabel", "Printout"],
 CellSize->{38, Inherited}],

Cell[StyleData["TOCBookPartTitleLabel", "CenteredPrintout"],
 CellSize->{38, Inherited}],

Cell[StyleData["TOCBookPartTitleLabel", "DoubleSpacedPrintout"],
 CellSize->{38, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookChapterTitleLabel"],
 CellSize->{18, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookChapterTitleLabel", "Centered"]],

Cell[StyleData["TOCBookChapterTitleLabel", "Printout"],
 CellSize->{14, Inherited}],

Cell[StyleData["TOCBookChapterTitleLabel", "CenteredPrintout"],
 CellSize->{14, Inherited}],

Cell[StyleData["TOCBookChapterTitleLabel", "DoubleSpacedPrintout"],
 CellSize->{14, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSectionLabel"],
 CellSize->{32, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookSectionLabel", "Centered"]],

Cell[StyleData["TOCBookSectionLabel", "Printout"],
 CellSize->{24, Inherited}],

Cell[StyleData["TOCBookSectionLabel", "CenteredPrintout"],
 CellSize->{24, Inherited}],

Cell[StyleData["TOCBookSectionLabel", "DoubleSpacedPrintout"],
 CellSize->{24, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSubsectionLabel"],
 CellSize->{44, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookSubsectionLabel", "Centered"]],

Cell[StyleData["TOCBookSubsectionLabel", "Printout"],
 CellSize->{38, Inherited}],

Cell[StyleData["TOCBookSubsectionLabel", "CenteredPrintout"],
 CellSize->{38, Inherited}],

Cell[StyleData["TOCBookSubsectionLabel", "DoubleSpacedPrintout"],
 CellSize->{38, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookFigureLabel"],
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookFigureLabel", "Centered"]],

Cell[StyleData["TOCBookFigureLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookFigureLabel", "CenteredPrintout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookFigureLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSupplementalLabel"],
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookSupplementalLabel", "Centered"]],

Cell[StyleData["TOCBookSupplementalLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookSupplementalLabel", "CenteredPrintout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookSupplementalLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPictureLabel"],
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookPictureLabel", "Centered"]],

Cell[StyleData["TOCBookPictureLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookPictureLabel", "CenteredPrintout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookPictureLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookIllustrationLabel"],
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookIllustrationLabel", "Centered"]],

Cell[StyleData["TOCBookIllustrationLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookIllustrationLabel", "CenteredPrintout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookIllustrationLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookProgramLabel"],
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookProgramLabel", "Centered"]],

Cell[StyleData["TOCBookProgramLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookProgramLabel", "CenteredPrintout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookProgramLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookTableLabel"],
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookTableLabel", "Centered"]],

Cell[StyleData["TOCBookTableLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookTableLabel", "CenteredPrintout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookTableLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookLeader"],
 TabFilling->". ",
 FontSize->12,
 FontWeight->"Plain"],

Cell[StyleData["TOCBookLeader", "Centered"]],

Cell[StyleData["TOCBookLeader", "Printout"],
 FontSize->10],

Cell[StyleData["TOCBookLeader", "CenteredPrintout"],
 FontSize->10],

Cell[StyleData["TOCBookLeader", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPageNumber"],
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["TOCBookPageNumber", "Centered"]],

Cell[StyleData["TOCBookPageNumber", "Printout"],
 CellSize->{21, Inherited}],

Cell[StyleData["TOCBookPageNumber", "CenteredPrintout"],
 CellSize->{21, Inherited}],

Cell[StyleData["TOCBookPageNumber", "DoubleSpacedPrintout"],
 CellSize->{21, Inherited}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Mainmatter", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Section"],
 CellMargins->{{12, 12}, {8, 24}},
 CellGroupingRules->{"SectionGrouping", 30},
 PageBreakBelow->False,
 TextAlignment->Center,
 CounterIncrements->{
  "Section", "SectionHeader", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 FontFamily->"Times",
 FontSize->17,
 FontWeight->"Bold"],

Cell[StyleData["Section", "Centered"],
 CellMargins->{{12, 12}, {8, 24}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->17,
 FontWeight->"Bold"],

Cell[StyleData["Section", "Printout"],
 CellMargins->{{2, 2}, {6, 21}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->15],

Cell[StyleData["Section", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 21}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->15],

Cell[StyleData["Section", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {6, 21}},
 LineSpacing->{2, 1},
 FontSize->13]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
 CellMargins->{{12, 12}, {8, 20}},
 CellGroupingRules->{"SectionGrouping", 40},
 PageBreakBelow->False,
 CellFrameLabelMargins->0,
 TextAlignment->Center,
 CounterIncrements->{
  "Subsection", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsubsection", 0}},
 FontFamily->"Times",
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["Subsection", "Centered"],
 CellMargins->{{12, 12}, {8, 20}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["Subsection", "Printout"],
 CellMargins->{{2, 2}, {6, 18}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->12],

Cell[StyleData["Subsection", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 18}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->12],

Cell[StyleData["Subsection", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {6, 18}},
 LineSpacing->{2, 1},
 FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
 CellMargins->{{12, 12}, {8, 18}},
 CellGroupingRules->{"SectionGrouping", 50},
 PageBreakBelow->False,
 CellFrameLabelMargins->0,
 TextAlignment->Center,
 CounterIncrements->{
  "Subsubsection", "SubsubsectionHeader", "SubsubsubsectionHeader"},
 FontFamily->"Times",
 FontSize->11,
 FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Centered"],
 CellMargins->{{12, 12}, {8, 18}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Printout"],
 CellMargins->{{2, 2}, {6, 16}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->10],

Cell[StyleData["Subsubsection", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 16}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->10],

Cell[StyleData["Subsubsection", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {4, 16}},
 LineSpacing->{2, 1},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsubsection"],
 CellMargins->{{12, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 60},
 CellFrameLabelMargins->0,
 TextAlignment->Center,
 CounterIncrements->{"Subsubsubsection", "SubsubsubsectionHeader"},
 FontFamily->"Times",
 FontSize->11,
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["Subsubsubsection", "Centered"],
 CellMargins->{{12, 12}, {7, 7}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["Subsubsubsection", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->10],

Cell[StyleData["Subsubsubsection", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->10],

Cell[StyleData["Subsubsubsection", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {4, 6}},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell["Section Heading Inline Cells", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["SectionLabel"],
 Editable->False,
 TextAlignment->Left],

Cell[StyleData["SectionLabel", "Centered"]],

Cell[StyleData["SectionLabel", "Printout"]],

Cell[StyleData["SectionLabel", "CenteredPrintout"]],

Cell[StyleData["SectionLabel", "DoubleSpacedPrintout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsectionLabel"],
 Editable->False,
 TextAlignment->Left],

Cell[StyleData["SubsectionLabel", "Centered"]],

Cell[StyleData["SubsectionLabel", "Printout"]],

Cell[StyleData["SubsectionLabel", "CenteredPrintout"]],

Cell[StyleData["SubsectionLabel", "DoubleSpacedPrintout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Alternate Headings", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["SectionAlt"],
 CellMargins->{{12, 12}, {8, 24}},
 CellGroupingRules->{"SectionGrouping", 30},
 PageBreakBelow->False,
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->17,
 FontWeight->"Bold"],

Cell[StyleData["SectionAlt", "Centered"],
 CellMargins->{{12, 12}, {8, 24}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->17,
 FontWeight->"Bold"],

Cell[StyleData["SectionAlt", "Printout"],
 CellMargins->{{2, 2}, {6, 21}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->15],

Cell[StyleData["SectionAlt", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 21}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->15],

Cell[StyleData["SectionAlt", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {6, 21}},
 LineSpacing->{2, 1},
 FontSize->13]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsectionAlt"],
 CellMargins->{{12, 12}, {8, 20}},
 CellGroupingRules->{"SectionGrouping", 40},
 PageBreakBelow->False,
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["SubsectionAlt", "Centered"],
 CellMargins->{{12, 12}, {8, 20}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["SubsectionAlt", "Printout"],
 CellMargins->{{2, 2}, {6, 18}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->12],

Cell[StyleData["SubsectionAlt", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 18}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->12],

Cell[StyleData["SubsectionAlt", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {6, 18}},
 LineSpacing->{2, 1},
 FontSize->11]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Body Text", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
 CellMargins->{{12, 10}, {1, 1}},
 InputAutoReplacements->{"-" -> "\[Hyphen]", Inherited},
 TextJustification->1,
 Hyphenation->True,
 ParagraphIndent->24,
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}}],

Cell[StyleData["Text", "Centered"]],

Cell[StyleData["Text", "Printout"],
 CellMargins->{{2, 2}, {0, 0}},
 ParagraphIndent->10,
 FontSize->10],

Cell[StyleData["Text", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 0}},
 ParagraphIndent->10,
 FontSize->10],

Cell[StyleData["Text", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 0}},
 LineSpacing->{2, 1},
 ParagraphIndent->16,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextNoIndent"],
 CellMargins->{{12, 10}, {1, 1}},
 InputAutoReplacements->{"-" -> "\[Hyphen]", Inherited},
 TextJustification->1,
 Hyphenation->True,
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}}],

Cell[StyleData["TextNoIndent", "Centered"]],

Cell[StyleData["TextNoIndent", "Printout"],
 CellMargins->{{2, 2}, {0, 0}},
 FontSize->10],

Cell[StyleData["TextNoIndent", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 0}},
 FontSize->10],

Cell[StyleData["TextNoIndent", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 0}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextContinuation"],
 CellMargins->{{12, 10}, {1, 1}},
 InputAutoReplacements->{"-" -> "\[Hyphen]", Inherited},
 TextAlignment->Left,
 TextJustification->1,
 Hyphenation->True,
 CounterIncrements->"TextContinuation",
 CounterAssignments->{{"Item1Numbered", 0}}],

Cell[StyleData["TextContinuation", "Centered"]],

Cell[StyleData["TextContinuation", "Printout"],
 CellMargins->{{2, 2}, {0, 0}},
 FontSize->10],

Cell[StyleData["TextContinuation", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 0}},
 FontSize->10],

Cell[StyleData["TextContinuation", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Itemized Lists", "Subsection"],

Cell[CellGroupData[{

Cell["Bulleted Lists", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Item1"],
 CellMargins->{{36, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellFrameLabels->{{
    Cell["\[FilledSmallCircle]", "Item1Label", CellBaseline -> Baseline], 
    Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item1",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}}],

Cell[StyleData["Item1", "Centered"]],

Cell[StyleData["Item1", "Printout"],
 CellMargins->{{18, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item1", "CenteredPrintout"],
 CellMargins->{{18, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item1", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2"],
 CellMargins->{{60, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellFrameLabels->{{
    Cell["\[FilledSmallCircle]", "Item2Label", CellBaseline -> Baseline], 
    Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item2",
 CounterAssignments->{{"Item3Numbered", 0}}],

Cell[StyleData["Item2", "Centered"]],

Cell[StyleData["Item2", "Printout"],
 CellMargins->{{36, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item2", "CenteredPrintout"],
 CellMargins->{{36, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item2", "DoubleSpacedPrintout"],
 CellMargins->{{36, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3"],
 CellMargins->{{84, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellFrameLabels->{{
    Cell["\[FilledSmallCircle]", "Item3Label", CellBaseline -> Baseline], 
    Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item3"],

Cell[StyleData["Item3", "Centered"]],

Cell[StyleData["Item3", "Printout"],
 CellMargins->{{56, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item3", "CenteredPrintout"],
 CellMargins->{{56, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item3", "DoubleSpacedPrintout"],
 CellMargins->{{56, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item1Label"],
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Plain"],

Cell[StyleData["Item1Label", "Centered"]],

Cell[StyleData["Item1Label", "Printout"],
 CellSize->{18, Inherited},
 FontSize->10],

Cell[StyleData["Item1Label", "CenteredPrintout"],
 CellSize->{18, Inherited},
 FontSize->10],

Cell[StyleData["Item1Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Label"],
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Plain"],

Cell[StyleData["Item2Label", "Centered"]],

Cell[StyleData["Item2Label", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item2Label", "CenteredPrintout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item2Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Label"],
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Plain"],

Cell[StyleData["Item3Label", "Centered"]],

Cell[StyleData["Item3Label", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item3Label", "CenteredPrintout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item3Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numbered Lists", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Item1Numbered"],
 CellMargins->{{36, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Item1Numbered"], "."}], "Item1NumberedLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item1Numbered",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}}],

Cell[StyleData["Item1Numbered", "Centered"]],

Cell[StyleData["Item1Numbered", "Printout"],
 CellMargins->{{18, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item1Numbered", "CenteredPrintout"],
 CellMargins->{{18, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item1Numbered", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Numbered"],
 CellMargins->{{60, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellFrameLabels->{{
    Cell[
     TextData[{"(", 
       CounterBox["Item2Numbered"], ")"}], "Item2NumberedLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item2Numbered",
 CounterAssignments->{{"Item3Numbered", 0}},
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["a", "z"], #]& )}],

Cell[StyleData["Item2Numbered", "Centered"]],

Cell[StyleData["Item2Numbered", "Printout"],
 CellMargins->{{36, 2}, {1, 2}},
 FontSize->10],

Cell[StyleData["Item2Numbered", "CenteredPrintout"],
 CellMargins->{{36, 2}, {1, 2}},
 FontSize->10],

Cell[StyleData["Item2Numbered", "DoubleSpacedPrintout"],
 CellMargins->{{36, 2}, {1, 2}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Numbered"],
 CellMargins->{{84, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Item3Numbered"], "."}], "Item3NumberedLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item3Numbered",
 CounterBoxOptions->{CounterFunction:>RomanNumeral}],

Cell[StyleData["Item3Numbered", "Centered"]],

Cell[StyleData["Item3Numbered", "Printout"],
 CellMargins->{{56, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item3Numbered", "CenteredPrintout"],
 CellMargins->{{56, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item3Numbered", "DoubleSpacedPrintout"],
 CellMargins->{{56, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item1NumberedLabel"],
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Item1NumberedLabel", "Centered"]],

Cell[StyleData["Item1NumberedLabel", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item1NumberedLabel", "CenteredPrintout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item1NumberedLabel", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2NumberedLabel"],
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Item2NumberedLabel", "Centered"]],

Cell[StyleData["Item2NumberedLabel", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item2NumberedLabel", "CenteredPrintout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item2NumberedLabel", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3NumberedLabel"],
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Item3NumberedLabel", "Centered"]],

Cell[StyleData["Item3NumberedLabel", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item3NumberedLabel", "CenteredPrintout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item3NumberedLabel", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["List Paragraphs", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Item1Paragraph"],
 CellMargins->{{64, 12}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping"],

Cell[StyleData["Item1Paragraph", "Centered"]],

Cell[StyleData["Item1Paragraph", "Printout"],
 CellMargins->{{40, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item1Paragraph", "CenteredPrintout"],
 CellMargins->{{40, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item1Paragraph", "DoubleSpacedPrintout"],
 CellMargins->{{40, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Paragraph"],
 CellMargins->{{88, 12}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping"],

Cell[StyleData["Item2Paragraph", "Centered"]],

Cell[StyleData["Item2Paragraph", "Printout"],
 CellMargins->{{58, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item2Paragraph", "CenteredPrintout"],
 CellMargins->{{58, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item2Paragraph", "DoubleSpacedPrintout"],
 CellMargins->{{58, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Paragraph"],
 CellMargins->{{112, 12}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping"],

Cell[StyleData["Item3Paragraph", "Centered"]],

Cell[StyleData["Item3Paragraph", "Printout"],
 CellMargins->{{78, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item3Paragraph", "CenteredPrintout"],
 CellMargins->{{78, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item3Paragraph", "DoubleSpacedPrintout"],
 CellMargins->{{78, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Illustrations and Examples", "Subsection"],

Cell[CellGroupData[{

Cell["Figure", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Figure"],
 Editable->False,
 CellMargins->{{36, 12}, {7, 7}},
 CellGroupingRules->"InputGrouping",
 PageBreakWithin->False,
 ShowCellLabel->False,
 DefaultFormatType->DefaultOutputFormatType,
 TextAlignment->Center,
 LanguageCategory->None,
 CounterIncrements->"Figure",
 ImageMargins->{{43, Inherited}, {Inherited, 0}},
 FontFamily->"Courier",
 FontSize->10],

Cell[StyleData["Figure", "Centered"],
 TextAlignment->Center],

Cell[StyleData["Figure", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextAlignment->Center,
 Magnification->0.8],

Cell[StyleData["Figure", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextAlignment->Center,
 Magnification->0.8],

Cell[StyleData["Figure", "DoubleSpacedPrintout"],
 CellMargins->{{23, 2}, {6, 6}},
 Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FigureCaption"],
 CellMargins->{{54, 54}, {Inherited, Inherited}},
 CellGroupingRules->"OutputGrouping",
 PageBreakAbove->False,
 TextAlignment->Center,
 TextJustification->1,
 CounterIncrements->"FigureCaption",
 CounterAssignments->{{"Nil", 0}},
 FontSize->10],

Cell[StyleData["FigureCaption", "Centered"],
 CellMargins->{{54, 54}, {Inherited, Inherited}},
 TextAlignment->Center],

Cell[StyleData["FigureCaption", "Printout"],
 CellMargins->{{48, 48}, {6, 2}},
 TextAlignment->Center,
 TextJustification->1,
 FontSize->9],

Cell[StyleData["FigureCaption", "CenteredPrintout"],
 CellMargins->{{48, 48}, {6, 2}},
 TextAlignment->Center,
 TextJustification->1,
 FontSize->9],

Cell[StyleData["FigureCaption", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {6, 2}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->9]
}, Closed]],

Cell[StyleData["FigureCaptionLabel"],
 Editable->False,
 CellGroupingRules->{"GraphicsGrouping", 0}]
}, Closed]],

Cell[CellGroupData[{

Cell["Picture", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Picture"],
 Editable->False,
 CellMargins->{{36, 12}, {7, 7}},
 CellGroupingRules->"InputGrouping",
 PageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 DefaultFormatType->DefaultOutputFormatType,
 TextAlignment->Center,
 LanguageCategory->None,
 CounterIncrements->"Picture",
 ImageMargins->{{43, Inherited}, {Inherited, 0}},
 FontFamily->"Courier",
 FontSize->10],

Cell[StyleData["Picture", "Centered"],
 TextAlignment->Center],

Cell[StyleData["Picture", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextAlignment->Center,
 Magnification->0.8],

Cell[StyleData["Picture", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextAlignment->Center,
 Magnification->0.8],

Cell[StyleData["Picture", "DoubleSpacedPrintout"],
 CellMargins->{{23, 2}, {6, 6}},
 Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureCaption"],
 CellMargins->{{54, 54}, {Inherited, Inherited}},
 CellGroupingRules->"OutputGrouping",
 PageBreakAbove->False,
 TextAlignment->Center,
 TextJustification->1,
 CounterIncrements->"PictureCaption",
 CounterAssignments->{{"Nil", 0}},
 FontSize->10],

Cell[StyleData["PictureCaption", "Centered"],
 CellMargins->{{54, 54}, {Inherited, Inherited}},
 TextAlignment->Center],

Cell[StyleData["PictureCaption", "Printout"],
 CellMargins->{{48, 48}, {6, 2}},
 TextAlignment->Center,
 TextJustification->1,
 FontSize->9],

Cell[StyleData["PictureCaption", "CenteredPrintout"],
 CellMargins->{{48, 48}, {6, 2}},
 TextAlignment->Center,
 TextJustification->1,
 FontSize->9],

Cell[StyleData["PictureCaption", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {6, 2}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->9]
}, Closed]],

Cell[StyleData["PictureCaptionLabel"],
 Editable->False,
 CellGroupingRules->{"GraphicsGrouping", 0}]
}, Closed]],

Cell[CellGroupData[{

Cell["Program/Script", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Program"],
 CellMargins->{{54, 54}, {2, 5}},
 CellGroupingRules->"InputGrouping",
 CounterIncrements->"Program",
 FontFamily->"Courier"],

Cell[StyleData["Program", "Centered"],
 CellMargins->{{54, 54}, {2, 5}}],

Cell[StyleData["Program", "Printout"],
 CellMargins->{{48, 48}, {1, 4}},
 FontSize->10],

Cell[StyleData["Program", "CenteredPrintout"],
 CellMargins->{{48, 48}, {1, 4}},
 FontSize->10],

Cell[StyleData["Program", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {1, 4}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ProgramCaption"],
 CellMargins->{{54, 54}, {Inherited, Inherited}},
 CellGroupingRules->"OutputGrouping",
 PageBreakAbove->False,
 Hyphenation->True,
 CounterIncrements->"ProgramCaption",
 CounterAssignments->{{"Nil", 0}},
 FontSize->10],

Cell[StyleData["ProgramCaption", "Centered"],
 CellMargins->{{54, 54}, {Inherited, Inherited}}],

Cell[StyleData["ProgramCaption", "Printout"],
 CellMargins->{{48, 48}, {6, 2}},
 TextJustification->1,
 FontSize->9],

Cell[StyleData["ProgramCaption", "CenteredPrintout"],
 CellMargins->{{48, 48}, {6, 2}},
 TextJustification->1,
 FontSize->9],

Cell[StyleData["ProgramCaption", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {6, 2}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->9]
}, Closed]],

Cell[StyleData["ProgramCaptionLabel"],
 Editable->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Tables", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TableTitle"],
 PageWidth->WindowWidth,
 CellMargins->{{12, Inherited}, {Inherited, Inherited}},
 CellGroupingRules->"InputGrouping",
 LineSpacing->{1, 2},
 CounterIncrements->"TableTitle",
 CounterAssignments->{{"Nil", 0}},
 FontWeight->"Plain",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{40}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["TableTitle", "Centered"],
 CellMargins->{{12, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["TableTitle", "Printout"],
 CellMargins->{{2, 2}, {1, 5}},
 FontSize->10],

Cell[StyleData["TableTitle", "CenteredPrintout"],
 CellMargins->{{2, 2}, {1, 5}},
 FontSize->10],

Cell[StyleData["TableTitle", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {1, 5}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableTitleLabel"],
 Editable->False,
 LineSpacing->{1, 2},
 CounterIncrements->"TableTitleLabel",
 FontWeight->"Bold",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{40}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["TableTitleLabel", "Centered"]],

Cell[StyleData["TableTitleLabel", "Printout"],
 FontSize->10],

Cell[StyleData["TableTitleLabel", "CenteredPrintout"],
 FontSize->10],

Cell[StyleData["TableTitleLabel", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Table"],
 Editable->False,
 PageWidth->WindowWidth,
 CellMargins->{{36, 12}, {4, 1}},
 CellGroupingRules->"OutputGrouping",
 CellHorizontalScrolling->True,
 CounterIncrements->"Table",
 CounterAssignments->{{"TableNote", 0}},
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {False, {False}, False}, "ColumnsIndexed" -> {}, "Rows" -> {
     AbsoluteThickness[2], {False}, 
     AbsoluteThickness[0.5]}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.503]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridDefaultElement:>Cell["Data", "TableText"]}],

Cell[StyleData["Table", "Centered"],
 CellMargins->{{12, 12}, {4, 1}}],

Cell[StyleData["Table", "Printout"],
 PageWidth->PaperWidth,
 CellMargins->{{18, 2}, {3, 1}},
 FontSize->10],

Cell[StyleData["Table", "CenteredPrintout"],
 PageWidth->PaperWidth,
 CellMargins->{{2, 2}, {3, 1}},
 FontSize->10],

Cell[StyleData["Table", "DoubleSpacedPrintout"],
 PageWidth->PaperWidth,
 CellMargins->{{18, 2}, {3, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableNote"],
 Editable->False,
 CellMargins->{{12, 12}, {7, -3}},
 CellGroupingRules->"OutputGrouping",
 LineSpacing->{1, 1},
 ParagraphSpacing->{0.3, 0},
 CounterIncrements->"TableNote",
 FontSize->10,
 FontColor->GrayLevel[0.300008]],

Cell[StyleData["TableNote", "Centered"],
 CellMargins->{{12, 12}, {7, -3}}],

Cell[StyleData["TableNote", "Printout"],
 CellMargins->{{18, 2}, {5, 1}},
 FontSize->9],

Cell[StyleData["TableNote", "Printout"],
 CellMargins->{{2, 2}, {5, -2}},
 FontSize->9],

Cell[StyleData["TableNote", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {5, -2}},
 LineSpacing->{2, 1},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Table Styles", "Subsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TableColumnHead"],
 Editable->True,
 FontSlant->"Italic",
 GridBoxOptions->{BaselinePosition->Axis,
 ColumnsEqual->False,
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>"\[Placeholder]",
 RowsEqual->False}],

Cell[StyleData["TableColumnHead", "Centered"]],

Cell[StyleData["TableColumnHead", "Printout"],
 FontSize->10],

Cell[StyleData["TableColumnHead", "CenteredPrintout"],
 FontSize->10],

Cell[StyleData["TableColumnHead", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableSpanHead"],
 Editable->True,
 TextAlignment->Center,
 FontSlant->"Italic",
 GridBoxOptions->{BaselinePosition->Axis,
 ColumnsEqual->False,
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>"\[Placeholder]",
 RowsEqual->False}],

Cell[StyleData["TableSpanHead", "Printout"],
 FontSize->10],

Cell[StyleData["TableSpanHead", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableText"],
 Editable->True,
 TextAlignment->Left,
 LineSpacing->{1, 1},
 GridBoxOptions->{BaselinePosition->Axis,
 ColumnsEqual->False,
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>"\[Placeholder]",
 RowsEqual->False}],

Cell[StyleData["TableText", "Centered"]],

Cell[StyleData["TableText", "Printout"],
 FontSize->10],

Cell[StyleData["TableText", "CenteredPrintout"],
 FontSize->10],

Cell[StyleData["TableText", "DoubleSpacedPrintout"],
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableSpanText"],
 Editable->True,
 TextAlignment->Center,
 LineSpacing->{1, 1},
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["TableSpanText", "Printout"],
 FontSize->10],

Cell[StyleData["TableSpanText", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[StyleData["TableSubGrid"],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Left, {Center}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{0.1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.27999999999999997`]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>Cell["Data", "TableText"]}],

Cell[StyleData["TableMasterGrid"],
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.004]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["TableLineElement"],
 Editable->False,
 CellFrame->{{0, 0}, {0.5, 0}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellSize->{Inherited, 1.25},
 TabFilling->" ",
 TabSpacings->1000,
 FontSize->1],

Cell[StyleData["TableBlankElement"],
 Editable->False,
 CellElementSpacings->{"CellMinHeight"->1},
 CellSize->{Inherited, 1.25},
 FontSize->1],

Cell[CellGroupData[{

Cell[StyleData["SpanLeft"],
 Editable->False,
 FontSize->16,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SpanLeft", "Printout"],
 FontSize->14],

Cell[StyleData["SpanLeft", "DoubleSpacedPrintout"],
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SpanCenter"],
 Editable->False,
 FontSize->16,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SpanCenter", "Printout"],
 FontSize->14],

Cell[StyleData["SpanCenter", "DoubleSpacedPrintout"],
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SpanRight"],
 Editable->False,
 FontSize->16,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SpanRight", "Printout"],
 FontSize->14],

Cell[StyleData["SpanRight", "DoubleSpacedPrintout"],
 FontSize->14]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Caption", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
 CellMargins->{{54, 54}, {Inherited, Inherited}},
 CellGroupingRules->"OutputGrouping",
 PageBreakAbove->False,
 TextJustification->1,
 CounterIncrements->"Caption",
 FontSize->10],

Cell[StyleData["Caption", "Centered"],
 CellMargins->{{54, 54}, {Inherited, Inherited}}],

Cell[StyleData["Caption", "Printout"],
 CellMargins->{{48, 48}, {6, 2}},
 TextJustification->1,
 FontSize->9],

Cell[StyleData["Caption", "CenteredPrintout"],
 CellMargins->{{48, 48}, {6, 2}},
 TextJustification->1,
 FontSize->9],

Cell[StyleData["Caption", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {6, 2}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->9]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Mathematics", "Subsection"],

Cell[CellGroupData[{

Cell["Equations", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Equation"],
 CellMargins->{{12, 12}, {7, 7}},
 CellHorizontalScrolling->True,
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 InputAutoReplacements->{},
 TextAlignment->Center,
 CounterIncrements->"Equation",
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["Equation", "Centered"],
 CellMargins->{{12, 12}, {7, 7}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 TextAlignment->Center],

Cell[StyleData["Equation", "Printout"],
 CellMargins->{{2, 2}, {5, 5}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["Equation", "CenteredPrintout"],
 CellMargins->{{2, 2}, {5, 5}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["Equation", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {5, 5}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroup"],
 CellMargins->{{12, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["EquationGroup", "Centered"],
 CellMargins->{{12, 6}, {0, 2}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 TextAlignment->Center],

Cell[StyleData["EquationGroup", "Printout"],
 CellMargins->{{2, 2}, {0, 1}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["EquationGroup", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 1}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["EquationGroup", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {0, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroupAligned"],
 CellMargins->{{12, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 SpanMinSize->2,
 ButtonBoxOptions->{ButtonFrame->"None"},
 UnderoverscriptBoxOptions->{LimitsPositioning->False},
 UnderscriptBoxOptions->{LimitsPositioning->False},
 OverscriptBoxOptions->{LimitsPositioning->False},
 GridBoxOptions->{AllowScriptLevelChange->False}],

Cell[StyleData["EquationGroupAligned", "Centered"],
 CellMargins->{{12, 6}, {0, 2}},
 TextAlignment->Center],

Cell[StyleData["EquationGroupAligned", "Printout"],
 CellMargins->{{2, 2}, {0, 1}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["EquationGroupAligned", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 1}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["EquationGroupAligned", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {0, 1}},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numbered Equations", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["EquationNumbered"],
 CellMargins->{{12, 12}, {7, 7}},
 CellHorizontalScrolling->True,
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["BookChapterLabel"], ".", 
       CounterBox["EquationNumbered"], ")"}], "EquationNumber"]}, {
   None, None}},
 DefaultFormatType->DefaultInputFormatType,
 InputAutoReplacements->{},
 TextAlignment->Center,
 CounterIncrements->"EquationNumbered",
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["EquationNumbered", "Centered"],
 CellMargins->{{12, 12}, {7, 7}},
 TextAlignment->Center],

Cell[StyleData["EquationNumbered", "Printout"],
 CellMargins->{{2, 2}, {5, 5}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["EquationNumbered", "CenteredPrintout"],
 CellMargins->{{2, 2}, {5, 5}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["EquationNumbered", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {5, 5}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroupNumbered"],
 CellMargins->{{12, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["BookChapterLabel"], ".", 
       CounterBox["EquationNumbered"], ")"}], "EquationNumber"]}, {
   None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 CounterIncrements->"EquationNumbered",
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["EquationGroupNumbered", "Centered"],
 CellMargins->{{12, 6}, {0, 2}},
 TextAlignment->Center],

Cell[StyleData["EquationGroupNumbered", "Printout"],
 CellMargins->{{2, 2}, {0, 1}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["EquationGroupNumbered", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 1}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["EquationGroupNumbered", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {0, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroupAlignedNumbered"],
 CellMargins->{{12, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["BookChapterLabel"], ".", 
       CounterBox["EquationNumbered"], ")"}], "EquationNumber"]}, {
   None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 SpanMinSize->2,
 CounterIncrements->"EquationNumbered",
 ButtonBoxOptions->{ButtonFrame->"None"},
 UnderoverscriptBoxOptions->{LimitsPositioning->False},
 UnderscriptBoxOptions->{LimitsPositioning->False},
 OverscriptBoxOptions->{LimitsPositioning->False},
 GridBoxOptions->{AllowScriptLevelChange->False}],

Cell[StyleData["EquationGroupAlignedNumbered", "Centered"],
 CellMargins->{{12, 6}, {0, 2}},
 TextAlignment->Center],

Cell[StyleData["EquationGroupAlignedNumbered", "Printout"],
 CellMargins->{{2, 2}, {0, 1}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["EquationGroupAlignedNumbered", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 1}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["EquationGroupAlignedNumbered", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {0, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationNumber"],
 CellSize->{36, Inherited},
 TextAlignment->Right],

Cell[StyleData["EquationNumber", "Centered"],
 CellSize->{36, Inherited}],

Cell[StyleData["EquationNumber", "Printout"],
 CellSize->{32, Inherited}],

Cell[StyleData["EquationNumber", "CenteredPrintout"],
 CellSize->{32, Inherited}],

Cell[StyleData["EquationNumber", "DoubleSpacedPrintout"],
 CellSize->{32, Inherited}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Equation Grid Tag Styles", "Subsubsection"],

Cell[StyleData["EquationGrid"]],

Cell[StyleData["SplitEquation"]],

Cell[StyleData["Piecewise"]],

Cell[StyleData["Matrix"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cross-References", "Subsection"],

Cell[StyleData["XRef"],
 ConversionRules:>{"TeX" -> {"\\ref{", 
     $CellContext`ExtractButtonData["CounterTag"], "}"}, 
   "HTML" -> {"", $CellContext`XRefToHtmlHyperlink, ""}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Backmatter", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["BackmatterGroup"],
 Editable->False,
 CellMargins->{{12, 10}, {7, 24}},
 CellGroupingRules->{"SectionGrouping", 5},
 FontFamily->"Helvetica",
 FontSize->9,
 FontColor->GrayLevel[0.500008]],

Cell[StyleData["BackmatterGroup", "Centered"]],

Cell[StyleData["BackmatterGroup", "Printout"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]],

Cell[StyleData["BackmatterGroup", "CenteredPrintout"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]],

Cell[StyleData["BackmatterGroup", "DoubleSpacedPrintout"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell["Appendix", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["AppendixSectionLabel"],
 CellFrame->{{0, 0}, {0.5, 0}},
 CellMargins->{{12, 12}, {3, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 PageBreakAbove->True,
 PageBreakBelow->False,
 CellFrameMargins->4,
 TextAlignment->Center,
 LineSpacing->{1, 2},
 CounterIncrements->"AppendixSectionLabel",
 CounterAssignments->{{"Section", 0}, {"AppendixEquation", 0}, {
   "FigureCaption", 0}, {"TableTitle", 0}},
 FontFamily->"Times",
 FontSize->13,
 FontWeight->"Plain",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["A", "Z"], #]& )}],

Cell[StyleData["AppendixSectionLabel", "Centered"],
 CellMargins->{{12, 12}, {3, 72}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->13,
 FontWeight->"Plain"],

Cell[StyleData["AppendixSectionLabel", "Printout"],
 CellMargins->{{2, 2}, {2, 60}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->11],

Cell[StyleData["AppendixSectionLabel", "CenteredPrintout"],
 CellMargins->{{2, 2}, {2, 60}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->11],

Cell[StyleData["AppendixSectionLabel", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 60}},
 FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AppendixSectionNumber"],
 FontFamily->"Times",
 FontSize->21,
 FontWeight->"Bold"],

Cell[StyleData["AppendixSectionNumber", "Centered"],
 FontFamily->"Times",
 FontSize->21,
 FontWeight->"Bold"],

Cell[StyleData["AppendixSectionNumber", "Printout"],
 FontFamily->"Times",
 FontSize->17],

Cell[StyleData["AppendixSectionNumber", "CenteredPrintout"],
 FontFamily->"Times",
 FontSize->17],

Cell[StyleData["AppendixSectionNumber", "DoubleSpacedPrintout"],
 FontSize->17]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AppendixSection"],
 CellMargins->{{54, 54}, {98, 12}},
 PageBreakAbove->False,
 PageBreakBelow->False,
 TextAlignment->Center,
 LineSpacing->{1, 2},
 FontFamily->"Times",
 FontSize->27,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["A", "Z"], #]& )}],

Cell[StyleData["AppendixSection", "Centered"],
 CellMargins->{{54, 54}, {98, 12}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["AppendixSection", "Printout"],
 CellMargins->{{48, 48}, {78, 10}},
 TextAlignment->Center,
 LineSpacing->{1, 2},
 FontFamily->"Times",
 FontSize->21],

Cell[StyleData["AppendixSection", "CenteredPrintout"],
 CellMargins->{{48, 48}, {78, 10}},
 TextAlignment->Center,
 LineSpacing->{1, 2},
 FontFamily->"Times",
 FontSize->21],

Cell[StyleData["AppendixSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 10}},
 LineSpacing->{1, 2},
 FontSize->21]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Appendix"],
 CellMargins->{{12, 10}, {1, 1}},
 InputAutoReplacements->{"-" -> "\[Hyphen]", Inherited},
 TextJustification->1,
 Hyphenation->True,
 ParagraphIndent->24,
 CounterIncrements->"Appendix",
 CounterAssignments->{{"Item1Numbered", 0}}],

Cell[StyleData["Appendix", "Centered"]],

Cell[StyleData["Appendix", "Printout"],
 CellMargins->{{2, 2}, {0, 0}},
 ParagraphIndent->10,
 FontSize->10],

Cell[StyleData["Appendix", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 0}},
 ParagraphIndent->10,
 FontSize->10],

Cell[StyleData["Appendix", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 0}},
 LineSpacing->{2, 1},
 ParagraphIndent->16,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AppendixEquation"],
 CellMargins->{{12, 12}, {7, 7}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["AppendixSection"], ".", 
       CounterBox["AppendixEquation"], ")"}]]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 CounterIncrements->"AppendixEquation"],

Cell[StyleData["AppendixEquation", "Centered"],
 CellMargins->{{12, 12}, {7, 7}},
 TextAlignment->Center],

Cell[StyleData["AppendixEquation", "Printout"],
 CellMargins->{{2, 2}, {Inherited, Inherited}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["AppendixEquation", "CenteredPrintout"],
 CellMargins->{{2, 2}, {Inherited, Inherited}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["AppendixEquation", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {5, 5}},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Endnotes", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["EndnoteSection"],
 CellMargins->{{12, 12}, {98, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], "\n"}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["EndnoteSection", "Centered"],
 CellMargins->{{12, 12}, {98, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], "\n"}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["EndnoteSection", "Printout"],
 CellMargins->{{2, 2}, {78, 60}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->21],

Cell[StyleData["EndnoteSection", "CenteredPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->21],

Cell[StyleData["EndnoteSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 FontSize->21]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Endnote"],
 CellMargins->{{12, 10}, {2, 2}},
 Hyphenation->True,
 LineSpacing->{1, 2},
 ParagraphIndent->-38,
 CounterIncrements->"Endnote"],

Cell[StyleData["Endnote", "Centered"]],

Cell[StyleData["Endnote", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->0.5,
 FontSize->10],

Cell[StyleData["Endnote", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->0.5,
 FontSize->10],

Cell[StyleData["Endnote", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EndnoteLabel"],
 CellSize->{36, Inherited},
 TextAlignment->Right,
 SpanMaxSize->1,
 CounterIncrements->"EndnoteLabel"],

Cell[StyleData["EndnoteLabel", "Centered"]],

Cell[StyleData["EndnoteLabel", "Printout"],
 CellSize->{32, Inherited}],

Cell[StyleData["EndnoteLabel", "CenteredPrintout"],
 CellSize->{32, Inherited}],

Cell[StyleData["EndnoteLabel", "DoubleSpacedPrintout"],
 CellSize->{32, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EndnoteNumber"],
 CellSize->{36, Inherited},
 TextAlignment->Right,
 CounterIncrements->"EndnoteNumber"],

Cell[StyleData["EndnoteNumber", "Centered"]],

Cell[StyleData["EndnoteNumber", "Printout"],
 CellSize->{32, Inherited}],

Cell[StyleData["EndnoteNumber", "CenteredPrintout"],
 CellSize->{32, Inherited}],

Cell[StyleData["EndnoteNumber", "DoubleSpacedPrintout"],
 CellSize->{32, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NoteKey"],
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>($CellContext`EditNote[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["NoteKey", "Centered"]],

Cell[StyleData["NoteKey", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["NoteKey", "CenteredPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["NoteKey", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EndnoteReturnLink"],
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["EndnoteReturnLink", "Centered"]],

Cell[StyleData["EndnoteReturnLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]],

Cell[StyleData["EndnoteReturnLink", "CenteredPrintout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]],

Cell[StyleData["EndnoteReturnLink", "DoubleSpacedPrintout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Note"],
 Editable->False,
 Deletable->False,
 ConversionRules:>{"TeX" -> {{"\\footnote{", Convert[
       ExtractButtonData[1][#]]& , "}"}, {"", Automatic, ""}}, 
   "HTML" -> {"", 
     ConvertTextSubOrSuperscriptToHTML["sup"], ""}},
 ScriptMinSize->10,
 SpanMaxSize->1,
 StyleMenuListing->None,
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Note", "Printout"],
 ScriptMinSize->8],

Cell[StyleData["Note", "DoubleSpacedPrintout"],
 ScriptMinSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["References", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["ReferenceSection"],
 CellMargins->{{12, 12}, {98, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 PageBreakAbove->True,
 PageBreakBelow->False,
 TextAlignment->Center,
 CounterIncrements->"ReferenceSection",
 CounterAssignments->{{"ReferenceText", 0}, {"BiblioEquation", 0}},
 FontFamily->"Times",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["ReferenceSection", "Centered"],
 CellMargins->{{12, 12}, {98, 72}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["ReferenceSection", "Printout"],
 CellMargins->{{2, 2}, {78, 60}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->21],

Cell[StyleData["ReferenceSection", "CenteredPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->21],

Cell[StyleData["ReferenceSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 FontSize->21]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Reference"],
 CellMargins->{{18, 10}, {1, 1}},
 TextAlignment->Left,
 LineSpacing->{1, 3},
 ParagraphIndent->-8,
 CounterIncrements->"BibliographyItem",
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Reference", "Centered"]],

Cell[StyleData["Reference", "Printout"],
 CellMargins->{{2, 2}, {2, 0}},
 LineSpacing->{1, 2},
 ParagraphIndent->-5,
 FontSize->10],

Cell[StyleData["Reference", "CenteredPrintout"],
 CellMargins->{{2, 2}, {2, 0}},
 LineSpacing->{1, 2},
 ParagraphIndent->-5,
 FontSize->10],

Cell[StyleData["Reference", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 0}},
 LineSpacing->{2, 1},
 ParagraphIndent->-5,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceLabel"],
 CellSize->{36, Inherited},
 TextAlignment->Right,
 SpanMaxSize->1,
 CounterIncrements->"RefDingbat"],

Cell[StyleData["ReferenceLabel", "Centered"]],

Cell[StyleData["ReferenceLabel", "Printout"],
 CellSize->{32, Inherited}],

Cell[StyleData["ReferenceLabel", "CenteredPrintout"],
 CellSize->{32, Inherited}],

Cell[StyleData["ReferenceLabel", "DoubleSpacedPrintout"],
 CellSize->{32, Inherited}]
}, Closed]],

Cell[StyleData["RefSep"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}}],

Cell[CellGroupData[{

Cell[StyleData["RefReturnPointer"],
 ButtonStyleMenuListing->None,
 FontFamily->"Mathematica4",
 FontColor->RGBColor[0.300008, 0.300008, 0.549996],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& )}],

Cell[StyleData["RefReturnPointer", "Printout"],
 FontColor->GrayLevel[1]],

Cell[StyleData["RefReturnPointer", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefReturnLink"],
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& )}],

Cell[StyleData["RefReturnLink", "Centered"]],

Cell[StyleData["RefReturnLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["RefReturnLink", "CenteredPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["RefReturnLink", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceSourceLink"],
 ButtonStyleMenuListing->None,
 FontFamily->"Mathematica4",
 FontSize->1,
 FontColor->GrayLevel[1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["ReferenceSourceLink", "Centered"]],

Cell[StyleData["ReferenceSourceLink", "Printout"],
 FontColor->GrayLevel[1]],

Cell[StyleData["ReferenceSourceLink", "CenteredPrintout"],
 FontColor->GrayLevel[1]],

Cell[StyleData["ReferenceSourceLink", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[1]]
}, Closed]],

Cell[StyleData["ReferenceSourceURL"]],

Cell[CellGroupData[{

Cell[StyleData["Citation"],
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>($CellContext`ListDataLink[#2]& ),
 Evaluator->Automatic}],

Cell[StyleData["Citation", "Centered"]],

Cell[StyleData["Citation", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["Citation", "CenteredPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["Citation", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefKey"],
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(Symbol["EditRef"][#]& ),
 Evaluator->Automatic}],

Cell[StyleData["RefKey", "Centered"],
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(Symbol["EditRef"][#]& ),
 Evaluator->Automatic}],

Cell[StyleData["RefKey", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["RefKey", "CenteredPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["RefKey", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell["References Templates", "Subsubsubsection",
 StyleMenuListing->None],

Cell["FirstAuthor:<Last>, <FirstInitial>. <MiddleInitial>.", \
"ReferenceTemplate"],

Cell["OtherAuthors:, <Last>, <FirstInitial>. <MiddleInitial>.", \
"ReferenceTemplate"],

Cell["LastAuthor:, & <Last>, <FirstInitial>. <MiddleInitial>.", \
"ReferenceTemplate"],

Cell["FirstEditor:<FirstInitial>. <MiddleInitial>. <Last>", \
"ReferenceTemplate"],

Cell["OtherEditors:, <FirstInitial>. <MiddleInitial>. <Last>", \
"ReferenceTemplate"],

Cell["LastEditor: & <FirstInitial>. <MiddleInitial>. <Last>", \
"ReferenceTemplate"],

Cell["Sorting:Author", "ReferenceTemplate"],

Cell["ReferenceAuthorMax:4", "ReferenceTemplate"],

Cell["ReferenceEditorMax:4", "ReferenceTemplate"],

Cell["ReferenceAuthorMin:1", "ReferenceTemplate"],

Cell["ReferenceEditorMin:1", "ReferenceTemplate"],

Cell["AbbreviatedAuthors:, et al.", "ReferenceTemplate"],

Cell["AbbreviatedEditors:, et al.", "ReferenceTemplate"],

Cell[CellGroupData[{

Cell["Article Templates", "Subsubsubsubsection"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).  Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>, <PageRange>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>, <PageRange>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).  Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>. \
Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>. \
\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).  Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>. \
Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>. \
\>", "ReferenceTemplate"],

Cell["\<\
(The following template is the default template for \"Article\" references \
that don't match any of the above templates.)\
\>", "Text"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["In Book Templates", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \"InBook\" references.)\
\>", "Text"],

Cell["\<\
InBook:<Author> (<Year>). <Title>. In <Editor> (Ed.), <BookTitle> (pp. \
<PageRange>). <City>: <Publisher>.\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Whole Book Templates", "Subsubsubsubsection"],

Cell["\<\
WholeBook:<Author> (<Year>). <BookTitle>. <City>: <Publisher>. Retrieved \
<RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
WholeBook:<Author> (<Year>). <BookTitle>. <City>: <Publisher>.\
\>", "ReferenceTemplate"],

Cell["\<\
WholeBook:<Author> (<Year>). <BookTitle>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
(The following template is the default template for \"Book\" references that \
don't match any of the above templates.)\
\>", "Text"],

Cell["WholeBook:<Author> (<Year>). <BookTitle>. <Publisher>.", \
"ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Thesis Templates", "Subsubsubsubsection"],

Cell["\<\
PhdThesis:<Author> (<Year>). <Title> (Doctoral Dissertation, <School>, \
<City>). <SourceOfAbstract>, <JournalVolume>, <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
PhdThesis:<Author> (<Year>). <BookTitle>. Unpublished doctoral dissertation, \
<School>, <City>.\
\>", "ReferenceTemplate"],

Cell["\<\
(The following template is the default template for \"PhdThesis\" references \
that don't match any of the above templates.)\
\>", "Text"],

Cell["\<\
PhdThesis:<Author> (<Year>). <Title> (Doctoral Dissertation, <School>, \
<City>). <SourceOfAbstract>, <JournalVolume>, <PageRange>.\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Technical Report Templates", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \"TechReport\" \
references.)\
\>", "Text"],

Cell["\<\
TechReport:<Author> (<Year>). <Title>. <School>, <City>. <ReportNumber>, \
<Submittedby>\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Online Source Templates", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \"OnlineSource\" \
references.)\
\>", "Text"],

Cell["\<\
OnlineSource:<Author>, <Title>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Preprint Templates", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \"Preprint\" references.)\
\
\>", "Text"],

Cell["Preprint:<Author> (<Year>). <Title>. <PublicationStatus>", \
"ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Plain Insertion Template", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \
\[OpenCurlyDoubleQuote]PlainInsert\" references.)\
\>", "Text"],

Cell["PlainInsert:<InsertedBibText>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Note Templates", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \"Note\" references.)\
\>", "Text"],

Cell["Note:<NoteText>", "ReferenceTemplate"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Common Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefTitle"],
 FontSlant->"Italic"],

Cell[StyleData["RefType"],
 CellSize->{1, 12}],

Cell[StyleData["RefURL"]],

Cell[StyleData["RefRetrievalDate"]],

Cell[StyleData["RefSourceOfAbstract"]],

Cell[StyleData["RefInsertedBibText"]],

Cell[StyleData["RefNote"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Book Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefBookTitle"],
 FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell["Journal Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefJournalTitle"]],

Cell[StyleData["RefJournalVolume"],
 FontWeight->"Bold"],

Cell[StyleData["RefJournalNumber"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Publisher Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefPublisher"]],

Cell[StyleData["RefCity"],
 ParagraphIndent->0]
}, Closed]],

Cell[CellGroupData[{

Cell["Author Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefAuthorGroup"]],

Cell[StyleData["RefAuthorFN"]],

Cell[StyleData["RefAuthorLN"]],

Cell[StyleData["RefAuthorMN"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Editor Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefEditorGroup"]],

Cell[StyleData["RefEditorFN"]],

Cell[StyleData["RefEditorMN"]],

Cell[StyleData["RefEditorLN"]]
}, Closed]],

Cell[CellGroupData[{

Cell["School Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefSchool"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Publication Date Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefDay"]],

Cell[StyleData["RefMonth"]],

Cell[StyleData["RefYear"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Page Data Field Styles: Auto Generated and Contiguous Pages", \
"Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefFirstPage"],
 ParagraphIndent->0],

Cell[StyleData["RefLastPage"],
 ParagraphIndent->0,
 StyleMenuListing->None]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Book Elements", "Subsection"],

Cell[CellGroupData[{

Cell["Chapter", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["BookChapterLabel"],
 CellFrame->{{0, 0}, {0.5, 0}},
 CellMargins->{{12, 12}, {3, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 PageBreakAbove->True,
 PageBreakBelow->False,
 CellFrameMargins->4,
 TextAlignment->Center,
 LineSpacing->{1, 2},
 CounterIncrements->"BookChapterLabel",
 CounterAssignments->{{"Section", 0}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"EquationNumbered", 0}, {"FigureCaption", 0}, {
   "PictureCaption", 0}, {"ProgramCaption", 0}, {"TableTitle", 0}, {
   "Figure", 0}, {"Picture", 0}, {"Program", 0}, {"Table", 0}},
 FontFamily->"Times",
 FontSize->13,
 FontWeight->"Plain"],

Cell[StyleData["BookChapterLabel", "Centered"],
 CellMargins->{{12, 12}, {3, 72}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->13,
 FontWeight->"Plain"],

Cell[StyleData["BookChapterLabel", "Printout"],
 CellMargins->{{2, 2}, {2, 60}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->11],

Cell[StyleData["BookChapterLabel", "CenteredPrintout"],
 CellMargins->{{2, 2}, {2, 60}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->11],

Cell[StyleData["BookChapterLabel", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 60}},
 FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BookChapterNumber"],
 FontFamily->"Times",
 FontSize->21,
 FontWeight->"Bold"],

Cell[StyleData["BookChapterNumber", "Centered"],
 FontFamily->"Times",
 FontSize->21,
 FontWeight->"Bold"],

Cell[StyleData["BookChapterNumber", "Printout"],
 FontFamily->"Times",
 FontSize->17],

Cell[StyleData["BookChapterNumber", "CenteredPrintout"],
 FontFamily->"Times",
 FontSize->17],

Cell[StyleData["BookChapterNumber", "DoubleSpacedPrintout"],
 FontSize->17]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BookChapterTitle"],
 CellMargins->{{54, 54}, {98, 12}},
 CellGroupingRules->"TitleGrouping",
 PageBreakAbove->False,
 PageBreakBelow->False,
 DefaultReturnCreatedCellStyle->"Section",
 TextAlignment->Center,
 LineSpacing->{1, 2},
 MenuPosition->1100,
 FontFamily->"Times",
 FontSize->27,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["BookChapterTitle", "Centered"],
 CellMargins->{{54, 54}, {98, 12}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["BookChapterTitle", "Printout"],
 CellMargins->{{48, 48}, {78, 10}},
 TextAlignment->Center,
 LineSpacing->{1, 2},
 FontFamily->"Times",
 FontSize->21],

Cell[StyleData["BookChapterTitle", "CenteredPrintout"],
 CellMargins->{{48, 48}, {78, 10}},
 TextAlignment->Center,
 LineSpacing->{1, 2},
 FontFamily->"Times",
 FontSize->21],

Cell[StyleData["BookChapterTitle", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 10}},
 LineSpacing->{1, 2},
 FontSize->21]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Epigraph", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Epigraph"],
 CellMargins->{{36, 54}, {0, 24}},
 CellGroupingRules->"GraphicsGrouping",
 TextAlignment->Center,
 TextJustification->1,
 FontSlant->"Italic"],

Cell[StyleData["Epigraph", "Centered"]],

Cell[StyleData["Epigraph", "Printout"],
 CellMargins->{{48, 48}, {0, 21}},
 FontSize->10],

Cell[StyleData["Epigraph", "CenteredPrintout"],
 CellMargins->{{48, 48}, {0, 21}},
 FontSize->10],

Cell[StyleData["Epigraph", "DoubleSpacedPrintout"],
 CellMargins->{{18, 48}, {0, 21}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EpigraphAuthor"],
 CellMargins->{{36, 54}, {24, 12}},
 CellGroupingRules->"GraphicsGrouping",
 TextAlignment->Center],

Cell[StyleData["EpigraphAuthor", "Centered"]],

Cell[StyleData["EpigraphAuthor", "Printout"],
 CellMargins->{{48, 48}, {21, 10}},
 FontSize->10],

Cell[StyleData["EpigraphAuthor", "CenteredPrintout"],
 CellMargins->{{48, 48}, {21, 10}},
 FontSize->10],

Cell[StyleData["EpigraphAuthor", "DoubleSpacedPrintout"],
 CellMargins->{{18, 48}, {21, 10}},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Acknowledgments", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["AcknowledgmentsSection"],
 CellMargins->{{54, 54}, {98, 12}},
 PageBreakAbove->False,
 PageBreakBelow->False,
 TextAlignment->Center,
 LineSpacing->{1, 2},
 FontFamily->"Times",
 FontSize->27,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["A", "Z"], #]& )}],

Cell[StyleData["AcknowledgmentsSection", "Centered"],
 CellMargins->{{54, 54}, {98, 12}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["AcknowledgmentsSection", "Printout"],
 CellMargins->{{48, 48}, {78, 10}},
 TextAlignment->Center,
 LineSpacing->{1, 2},
 FontFamily->"Times",
 FontSize->21],

Cell[StyleData["AcknowledgmentsSection", "CenteredPrintout"],
 CellMargins->{{48, 48}, {78, 10}},
 TextAlignment->Center,
 LineSpacing->{1, 2},
 FontFamily->"Times",
 FontSize->21],

Cell[StyleData["AcknowledgmentsSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 10}},
 LineSpacing->{1, 2},
 FontSize->21]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Acknowledgment"],
 CellMargins->{{12, 10}, {1, 1}},
 InputAutoReplacements->{"-" -> "\[Hyphen]", Inherited},
 TextJustification->1,
 Hyphenation->True,
 ParagraphIndent->24,
 CounterIncrements->"Acknowledgment",
 CounterAssignments->{{"Item1Numbered", 0}}],

Cell[StyleData["Acknowledgment", "Centered"]],

Cell[StyleData["Acknowledgment", "Printout"],
 CellMargins->{{2, 2}, {0, 0}},
 ParagraphIndent->10,
 FontSize->10],

Cell[StyleData["Acknowledgment", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 0}},
 ParagraphIndent->10,
 FontSize->10],

Cell[StyleData["Acknowledgment", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 0}},
 LineSpacing->{2, 1},
 ParagraphIndent->16,
 FontSize->10]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Headers and Footers", "Subsection"],

Cell[StyleData["Header"],
 CellMargins->{{0, 0}, {4, 1}},
 FontSize->10,
 FontSlant->"Italic"],

Cell[StyleData["Footer"],
 CellMargins->{{0, 0}, {0, 4}},
 FontSize->9,
 FontSlant->"Italic"],

Cell[StyleData["PageNumber"],
 CellMargins->{{0, 0}, {4, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell["Miscellaneous", "Subsection"],

Cell[StyleData["TextSuperscript"],
 ScriptMinSize->10,
 SingleLetterItalics->False],

Cell[StyleData["TextSubscript"],
 ScriptMinSize->10,
 SingleLetterItalics->False],

Cell[StyleData["Nil"]],

Cell[StyleData["Verbatim"]],

Cell[StyleData["TeXName"],
 ConversionRules:>{"TeX" -> {"\\TeX\\", 
     $CellContext`NoOutput[], ""}}],

Cell[StyleData["LaTeXName"],
 ConversionRules:>{"TeX" -> {"\\LaTeX\\", 
     $CellContext`NoOutput[], ""}}],

Cell[StyleData["LaTeXeName"],
 ConversionRules:>{"TeX" -> {"\\LaTeXe\\", 
     $CellContext`NoOutput[], ""}}],

Cell[StyleData["ChemicalElement"],
 SingleLetterItalics->False,
 ZeroWidthTimes->True],

Cell[StyleData["CustomCharacter"],
 SingleLetterItalics->False],

Cell[StyleData["Palette"]],

Cell[CellGroupData[{

Cell[StyleData["PageBreak"],
 Editable->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellBracketOptions->{"Color"->RGBColor[0.500008, 0.500008, 1],
 "Margins"->{Inherited, 3},
 "Thickness"->1,
 "Widths"->{5, 5}},
 CellElementSpacings->{"CellMinHeight"->1},
 PageBreakAbove->True,
 CellSize->{Inherited, 6},
 TabFilling->"- ",
 TabSpacings->1000,
 FontSize->6,
 FontColor->GrayLevel[0.700008]],

Cell[StyleData["PageBreak", "Printout"],
 CellMargins->{{0, 0}, {0, 0}},
 CellSize->{Inherited, 2},
 TabFilling->""]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CreationDate"],
 CellFrame->0.5,
 CellMargins->{{10, 10}, {4, 4}},
 TextAlignment->Center,
 FontFamily->"Helvetica",
 FontSize->10],

Cell[StyleData["CreationDate", "Printout"],
 CellMargins->{{0, 0}, {0, 0}},
 LineSpacing->{1, 1},
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell["Lines and Spacers", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["SingleLine"],
 CellMargins->{{2, 10}, {1, 1}},
 CellGroupingRules->{"GraphicsGrouping", 0},
 FontSize->2],

Cell[StyleData["SingleLine", "Printout"],
 CellMargins->{{2, 10}, {1, 1}},
 CellGroupingRules->{"GraphicsGrouping", 0},
 FontSize->2]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DoubleLine"],
 Editable->False,
 PageWidth->400,
 CellFrame->{{0, 0}, {0.25, 0.25}},
 CellMargins->{{12, 10}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->0},
 CellFrameMargins->{{2, 10}, {0, 0}},
 FontSize->4],

Cell[StyleData["DoubleLine", "Printout"],
 CellMargins->{{2, 10}, {1, 1}},
 FontSize->2]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ThinLine"],
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 0.5}},
 ShowCellBracket->False,
 CellMargins->{{12, 10}, {2, 2}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->False,
 CellSize->{Inherited, 8}],

Cell[StyleData["ThinLine", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MediumLine"],
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{12, 10}, {2, 2}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->False,
 CellSize->{Inherited, 8}],

Cell[StyleData["MediumLine", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ThickLine"],
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 3}},
 ShowCellBracket->False,
 CellMargins->{{12, 10}, {2, 2}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->False,
 CellSize->{Inherited, 8}],

Cell[StyleData["ThickLine", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Spacer"],
 CellMargins->{{Inherited, Inherited}, {4, 4}}],

Cell[StyleData["Spacer", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextSpacer"]],

Cell[StyleData["TextSpacer", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SectionSpacer"]],

Cell[StyleData["SectionSpacer", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GraphicsSpacer"]],

Cell[StyleData["GraphicsSpacer", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Outline", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Outline1"],
 CellMargins->{{12, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 30},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Outline1"], ". "}], "Outline1Label", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"Outline1",
 CounterAssignments->{{"Outline2", 0}},
 FontSize->18,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[StyleData["Outline1", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 FontSize->16],

Cell[StyleData["Outline1", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline1Label"],
 CellSize->{40, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Outline1Label", "Printout"],
 CellSize->{36, Inherited}],

Cell[StyleData["Outline1Label", "DoubleSpacedPrintout"],
 CellSize->{36, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline2"],
 CellMargins->{{32, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 40},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Outline2"], ". "}], "Outline2Label", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"Outline2",
 CounterAssignments->{{"Outline3", 0}},
 FontSize->16,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["A", "Z"], #]& )}],

Cell[StyleData["Outline2", "Printout"],
 CellMargins->{{22, 2}, {6, 6}},
 FontSize->14],

Cell[StyleData["Outline2", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {6, 6}},
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline2Label"],
 CellSize->{30, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Outline2Label", "Printout"],
 CellSize->{27, Inherited}],

Cell[StyleData["Outline2Label", "DoubleSpacedPrintout"],
 CellSize->{27, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline3"],
 CellMargins->{{52, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Outline3"], ". "}], "Outline3Label", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"Outline3",
 CounterAssignments->{{"Outline4", 0}},
 FontSize->14,
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Outline3", "Printout"],
 CellMargins->{{42, 2}, {6, 6}},
 FontSize->12],

Cell[StyleData["Outline3", "DoubleSpacedPrintout"],
 CellMargins->{{42, 2}, {6, 6}},
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline3Label"],
 CellSize->{21, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Outline3Label", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Outline3Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline4"],
 CellMargins->{{67, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 60},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Outline4"], ". "}], "Outline4Label", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"Outline4",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["a", "z"], #]& )}],

Cell[StyleData["Outline4", "Printout"],
 CellMargins->{{57, 2}, {6, 6}},
 FontSize->10],

Cell[StyleData["Outline4", "DoubleSpacedPrintout"],
 CellMargins->{{57, 2}, {6, 6}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline4Label"],
 CellSize->{18, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Outline4Label", "Printout"],
 CellSize->{16, Inherited}],

Cell[StyleData["Outline4Label", "DoubleSpacedPrintout"],
 CellSize->{16, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OutlineText"],
 CellMargins->{{91, 12}, {3, 5}},
 TextAlignment->Left,
 LineSpacing->{1, 3},
 CounterIncrements->"Text"],

Cell[StyleData["OutlineText", "Printout"],
 CellMargins->{{79, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10],

Cell[StyleData["OutlineText", "DoubleSpacedPrintout"],
 CellMargins->{{79, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Slide Show", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["SlideShowNavigationBar"],
 Editable->False,
 CellFrame->True,
 CellMargins->{{0, 0}, {3, 3}},
 CellElementSpacings->{"CellMinHeight"->0.8125},
 CellGroupingRules->{"SectionGrouping", 30},
 CellFrameMargins->False,
 CellFrameColor->GrayLevel[1],
 CellFrameLabelMargins->False,
 TextAlignment->Center,
 CounterIncrements->"SlideShowNavigationBar",
 CounterAssignments->{{"Item1Numbered", 0}},
 FontSize->10,
 Magnification->1,
 Background->GrayLevel[0.8],
 GridBoxOptions->{BaselinePosition->Center,
 GridBoxAlignment->{
  "Columns" -> {
    Center, Center, Center, Center, Center, Center, Right, {Center}}, 
   "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {3.5, 3.5, 3.5, 3.5, 13, 5, {4}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{1.}}, "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["SlideShowNavigationBar", "Printout"],
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{-1, -1}, {-1, -1}},
 PageBreakAbove->True,
 CellFrameMargins->{{1, 1}, {0, 0}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideHyperlink"],
 ButtonStyleMenuListing->None,
 FontSize->26,
 FontColor->GrayLevel[0.400015],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonMargins->0.5,
 ButtonMinHeight->0.85,
 ButtonNote->None}],

Cell[StyleData["SlideHyperlink", "Printout"],
 FontColor->GrayLevel[0.8],
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["SlideHyperlink", "CenteredPrintout"],
 FontColor->GrayLevel[0.8],
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["SlideHyperlink", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0.8],
 ButtonBoxOptions->{ButtonFrame->"None"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Common Inline", "Subsection"],

Cell[CellGroupData[{

Cell["General Text Attributes", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["RM"],
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["BF"],
 FontWeight->"Bold"],

Cell[StyleData["IT"],
 FontSlant->"Italic"],

Cell[StyleData["SmallCaps"],
 Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell["Font Specific Text Attributes", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["TR"],
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["TI"],
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["TB"],
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["TBI"],
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["MR"],
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["MO"],
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["MB"],
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["MBO"],
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["SR"],
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SO"],
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["SB"],
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["SBO"],
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["PlainGreekWin"],
 CharacterEncoding->"Unicode"],

Cell[StyleData["PlainGreekMac"],
 FontFamily->"Symbol"],

Cell[StyleData["PlainGreekLin"],
 FontFamily->"Symbol"]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlinks", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
 ButtonStyleMenuListing->None,
 FontVariations->{"Underline"->True},
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Printout"],
 FontSize->10,
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["XMLWebLink"],
 ButtonStyleMenuListing->None,
 FontVariations->{"Underline"->True},
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>($CellContext`OpenAllTypes[#]& ),
 ButtonNote->ButtonData,
 Evaluator->Automatic}],

Cell[StyleData["XMLWebLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell["On-line Help System Links", "Subsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["UserGuideLink"],
 ButtonStyleMenuListing->None,
 FontVariations->{"Underline"->True},
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["UserGuide", #]}]& )}],

Cell[StyleData["UserGuideLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceLink"],
 ButtonStyleMenuListing->None,
 FontVariations->{"Underline"->True},
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["Reference", #]}]& )}],

Cell[StyleData["ReferenceLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["System", "Subsection"],

Cell[CellGroupData[{

Cell["Format Type Style", "Subsubsection",
 StyleMenuListing->None],

Cell["\<\

The cells below define styles that are mixed in with the styles of 
most cells.  If a cell's FormatType matches the name of one of the styles 
defined below, then that style is applied between the cell's style and its 
own options. This is particularly true of Input and Output.
\
\>", "Text"],

Cell[StyleData["CellExpression"],
 PageWidth->DirectedInfinity[1],
 CellMargins->{{6, Inherited}, {Inherited, Inherited}},
 ShowCellLabel->False,
 ShowSpecialCharacters->False,
 AllowInlineCells->False,
 AutoItalicWords->{},
 FontFamily->"Courier",
 FontSize->12,
 Background->GrayLevel[1]],

Cell[StyleData["InputForm"],
 AllowInlineCells->False,
 FontFamily->"Courier"],

Cell[StyleData["OutputForm"],
 PageWidth->DirectedInfinity[1],
 TextAlignment->Left,
 LineSpacing->{0.6, 1},
 FontFamily->"Courier"],

Cell[StyleData["StandardForm"],
 LineSpacing->{1.25, 0},
 FontFamily->"Courier"],

Cell[StyleData["TraditionalForm"],
 LineSpacing->{1.25, 0},
 SingleLetterItalics->True,
 TraditionalFunctionNotation->True,
 DelimiterMatching->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Document Settings and Templates", "Subsubsection"],

Cell[StyleData["ReferenceTemplate"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["AuthorFormCustomizationTemplate"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["CSSDefinitions"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["LaTeXPreamble"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["DOCTYPEFormat"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["ValidationSetting"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["XRefPaletteSettings"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["MiscSettings"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Cells", "Subsubsection",
 StyleMenuListing->None],

Cell["\<\

The style defined below is mixed in to any cell that is in an 
inline cell within another.
\
\>", "Text"],

Cell[StyleData["InlineCell"],
 InputAutoReplacements->{"-" -> "-"},
 ScriptLevel->1],

Cell[StyleData["InlineCellEditing"],
 Background->RGBColor[0.880003, 0.899992, 0.959991]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette", "Subsubsection",
 StyleMenuListing->None],

Cell["\<\

The cells below define styles that define standard ButtonFunctions, 
for use in palette buttons.
\
\>", "Text"],

Cell[StyleData["Paste"],
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, After]}]& )}],

Cell[StyleData["StyleApply"],
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>($CellContext`CellWriteStyle[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["StyleApplyWithVerification"],
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{
 ButtonFunction:>(($CellContext`CheckDocStyleMatch[]; \
$CellContext`CellWriteStyle[#])& ),
 Evaluator->Automatic}],

Cell[StyleData["ConvertCharacter"],
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFrame->"None",
 Evaluator->Automatic}]
}, Closed]],

Cell[CellGroupData[{

Cell["Automatic", "Subsubsection",
 StyleMenuListing->None],

Cell["\<\

The cells below define styles that are used to affect the display 
of certain types of objects in typeset expressions.  For example, 
\"UnmatchedBracket\" style defines how unmatched bracket, curly bracket, and 
parenthesis characters are displayed (typically by coloring them to make them \

stand out).
\
\>", "Text"],

Cell[StyleData["UnmatchedBracket"],
 FontColor->RGBColor[0.760006, 0.330007, 0.8]]
}, Closed]],

Cell[CellGroupData[{

Cell["DialogEffects", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["DialogStyleSheetMisapplicationEscape"],
 ShowCellBracket->False,
 CellMargins->{{12, 12}, {2000, 40}},
 CellOpen->True,
 TextAlignment->Center]
}, Closed]]
}, Closed]]
}, Closed]]
},
WindowSize->{687, 679},
WindowMargins->{{Automatic, 1}, {Automatic, 0}},
TaggingRules:>("StyleSheetName" -> "Book1.nb"),
ShowCellTags->True,
TrackCellChangeTimes->False,
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (April 3, 2007)",
StyleDefinitions->"StylesheetFormatting.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 60, 0, 35, 60, 0, "StyleData", "StyleDefinitions", ""],
Cell[631, 23, 191, 4, 57, "Text"],
Cell[CellGroupData[{
Cell[847, 31, 35, 0, 50, "Section"],
Cell[885, 33, 99, 2, 42, "Text"],
Cell[987, 37, 98, 2, 35, 27, 0, "StyleData", "Notebook", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[1122, 44, 53, 0, 34, "Section"],
Cell[CellGroupData[{
Cell[1200, 48, 27, 0, 46, "Subsection"],
Cell[CellGroupData[{
Cell[1252, 52, 367, 11, 90, 24, 0, "StyleData", "Title", "All",
 MenuPosition->None],
Cell[1622, 65, 155, 5, 123, 40, 0, "StyleData", "Title", "Presentation"],
Cell[1780, 72, 63, 0, 35, 63, 0, "StyleData", "Title", "Condensed"],
Cell[1846, 74, 62, 0, 35, 62, 0, "StyleData", "Title", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[1945, 79, 369, 11, 43, 27, 0, "StyleData", "Subtitle", "All",
 MenuPosition->None],
Cell[2317, 92, 114, 3, 54, 43, 0, "StyleData", "Subtitle", "Presentation"],
Cell[2434, 97, 66, 0, 35, 66, 0, "StyleData", "Subtitle", "Condensed"],
Cell[2503, 99, 65, 0, 35, 65, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[2629, 106, 73, 2, 34, "Section"],
Cell[CellGroupData[{
Cell[2727, 112, 33, 0, 46, "Subsection"],
Cell[CellGroupData[{
Cell[2785, 116, 31, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[2841, 120, 387, 11, 57, 25, 0, "StyleData", "Author", "All",
 MenuPosition->2000],
Cell[3231, 133, 100, 2, 69, 41, 0, "StyleData", "Author", "Presentation"],
Cell[3334, 137, 64, 0, 35, 64, 0, "StyleData", "Author", "Condensed"],
Cell[3401, 139, 63, 0, 35, 63, 0, "StyleData", "Author", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[3513, 145, 61, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[3599, 150, 314, 9, 27, 30, 0, "StyleData", "Institution", "All",
 CounterIncrements->"Institution",
 MenuPosition->2010],
Cell[3916, 161, 193, 6, 27, 43, 0, "StyleData", "Institution", "FlushLeft"],
Cell[4112, 169, 113, 3, 35, 46, 0, "StyleData", "Institution", \
"Presentation"],
Cell[4228, 174, 69, 0, 35, 69, 0, "StyleData", "Institution", "Condensed"],
Cell[4300, 176, 68, 0, 35, 68, 0, "StyleData", "Institution", "Printout"],
Cell[4371, 178, 189, 6, 26, 51, 0, "StyleData", "Institution", \
"FlushLeftPrintout"],
Cell[4563, 186, 129, 3, 26, 54, 0, "StyleData", "Institution", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[4741, 195, 67, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[4833, 200, 32, 0, 43, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[4890, 204, 45, 0, 42, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[4960, 208, 372, 11, 211, 33, 0, "StyleData", "TOCBookHeading", "All",
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}}],
Cell[5335, 221, 105, 2, 197, 45, 0, "StyleData", "TOCBookHeading", \
"Centered"],
Cell[5443, 225, 118, 3, 174, 45, 0, "StyleData", "TOCBookHeading", \
"Printout"],
Cell[5564, 230, 126, 3, 174, 53, 0, "StyleData", "TOCBookHeading", \
"CenteredPrintout"],
Cell[5693, 235, 106, 2, 174, 57, 0, "StyleData", "TOCBookHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[5836, 242, 332, 9, 211, 39, 0, "StyleData", "TOCBookIllustrations", \
"All",
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}}],
Cell[6171, 253, 111, 2, 197, 51, 0, "StyleData", "TOCBookIllustrations", \
"Centered"],
Cell[6285, 257, 96, 2, 174, 47, 0, "StyleData", "TOCIllustrations", \
"Printout"],
Cell[6384, 261, 132, 3, 174, 59, 0, "StyleData", "TOCBookIllustrations", \
"CenteredPrintout"],
Cell[6519, 266, 135, 3, 174, 63, 0, "StyleData", "TOCBookIllustrations", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[6691, 274, 325, 9, 211, 32, 0, "StyleData", "TOCBookTables", "All",
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}}],
Cell[7019, 285, 104, 2, 197, 44, 0, "StyleData", "TOCBookTables", \
"Centered"],
Cell[7126, 289, 117, 3, 174, 44, 0, "StyleData", "TOCBookTables", \
"Printout"],
Cell[7246, 294, 125, 3, 174, 52, 0, "StyleData", "TOCBookTables", \
"CenteredPrintout"],
Cell[7374, 299, 105, 2, 174, 56, 0, "StyleData", "TOCBookTables", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[7528, 307, 48, 0, 42, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[7601, 311, 422, 9, 31, 44, 0, "StyleData", "TOCBookFrontmatterHeading", \
"All",
 CounterIncrements->"TOCBookFrontmatterHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}}],
Cell[8026, 322, 56, 0, 31, 56, 0, "StyleData", "TOCBookFrontmatterHeading", \
"Centered"],
Cell[8085, 324, 122, 3, 27, 56, 0, "StyleData", "TOCBookFrontmatterHeading", \
"Printout"],
Cell[8210, 329, 130, 3, 27, 64, 0, "StyleData", "TOCBookFrontmatterHeading", \
"CenteredPrintout"],
Cell[8343, 334, 134, 3, 27, 68, 0, "StyleData", "TOCBookFrontmatterHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[8514, 342, 420, 9, 31, 43, 0, "StyleData", "TOCBookBackmatterHeading", \
"All",
 CounterIncrements->"TOCBookBackmatterHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}}],
Cell[8937, 353, 55, 0, 31, 55, 0, "StyleData", "TOCBookBackmatterHeading", \
"Centered"],
Cell[8995, 355, 121, 3, 27, 55, 0, "StyleData", "TOCBookBackmatterHeading", \
"Printout"],
Cell[9119, 360, 129, 3, 27, 63, 0, "StyleData", "TOCBookBackmatterHeading", \
"CenteredPrintout"],
Cell[9251, 365, 133, 3, 27, 67, 0, "StyleData", "TOCBookBackmatterHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[9421, 373, 418, 9, 31, 42, 0, "StyleData", "TOCBookFrontBackHeading", \
"All",
 CounterIncrements->"TOCBookFrontBackHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}}],
Cell[9842, 384, 54, 0, 31, 54, 0, "StyleData", "TOCBookFrontBackHeading", \
"Centered"],
Cell[9899, 386, 120, 3, 27, 54, 0, "StyleData", "TOCBookFrontBackHeading", \
"Printout"],
Cell[10022, 391, 128, 3, 27, 62, 0, "StyleData", "TOCBookFrontBackHeading", \
"CenteredPrintout"],
Cell[10153, 396, 132, 3, 27, 66, 0, "StyleData", "TOCBookFrontBackHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[10322, 404, 434, 11, 44, 35, 0, "StyleData", "TOCBookPartTitle", "All",
 CounterIncrements->"TOCBookPartTitle",
 CounterAssignments->{{"TOCBookChapterTitle", 0}}],
Cell[10759, 417, 47, 0, 44, 47, 0, "StyleData", "TOCBookPartTitle", \
"Centered"],
Cell[10809, 419, 96, 2, 33, 47, 0, "StyleData", "TOCBookPartTitle", \
"Printout"],
Cell[10908, 423, 104, 2, 39, 55, 0, "StyleData", "TOCBookPartTitle", \
"CenteredPrintout"],
Cell[11015, 427, 108, 2, 39, 59, 0, "StyleData", "TOCBookPartTitle", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[11160, 434, 449, 12, 31, 38, 0, "StyleData", "TOCBookChapterTitle", \
"All",
 CounterIncrements->"TOCBookChapterTitle",
 CounterAssignments->{{"TOCBookSection", 0}}],
Cell[11612, 448, 50, 0, 31, 50, 0, "StyleData", "TOCBookChapterTitle", \
"Centered"],
Cell[11665, 450, 139, 4, 29, 50, 0, "StyleData", "TOCBookChapterTitle", \
"Printout"],
Cell[11807, 456, 147, 4, 29, 58, 0, "StyleData", "TOCBookChapterTitle", \
"CenteredPrintout"],
Cell[11957, 462, 151, 4, 29, 62, 0, "StyleData", "TOCBookChapterTitle", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[12145, 471, 447, 11, 29, 33, 0, "StyleData", "TOCBookSection", "All",
 CounterIncrements->"TOCBookSection",
 CounterAssignments->{{"TOCBookSubsection", 0}}],
Cell[12595, 484, 45, 0, 29, 45, 0, "StyleData", "TOCBookSection", \
"Centered"],
Cell[12643, 486, 137, 4, 28, 45, 0, "StyleData", "TOCBookSection", \
"Printout"],
Cell[12783, 492, 145, 4, 28, 53, 0, "StyleData", "TOCBookSection", \
"CenteredPrintout"],
Cell[12931, 498, 149, 4, 28, 57, 0, "StyleData", "TOCBookSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[13117, 507, 452, 11, 29, 36, 0, "StyleData", "TOCBookSubsection", "All",
 CounterIncrements->"TOCBookSubsection"],
Cell[13572, 520, 48, 0, 29, 48, 0, "StyleData", "TOCBookSubsection", \
"Centered"],
Cell[13623, 522, 140, 4, 28, 48, 0, "StyleData", "TOCBookSubsection", \
"Printout"],
Cell[13766, 528, 148, 4, 28, 56, 0, "StyleData", "TOCBookSubsection", \
"CenteredPrintout"],
Cell[13917, 534, 152, 4, 28, 60, 0, "StyleData", "TOCBookSubsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[14106, 543, 366, 9, 29, 32, 0, "StyleData", "TOCBookFigure", "All",
 CounterIncrements->"TOCBookFigure"],
Cell[14475, 554, 44, 0, 29, 44, 0, "StyleData", "TOCBookFigure", "Centered"],
Cell[14522, 556, 111, 3, 28, 44, 0, "StyleData", "TOCBookFigure", \
"Printout"],
Cell[14636, 561, 119, 3, 28, 52, 0, "StyleData", "TOCBookFigure", \
"CenteredPrintout"],
Cell[14758, 566, 123, 3, 28, 56, 0, "StyleData", "TOCBookFigure", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[14918, 574, 391, 9, 29, 38, 0, "StyleData", "TOCBookSupplemental", "All",
 
 CounterIncrements->"TOCBookSupplemental"],
Cell[15312, 585, 50, 0, 29, 50, 0, "StyleData", "TOCBookSupplemental", \
"Centered"],
Cell[15365, 587, 117, 3, 28, 50, 0, "StyleData", "TOCBookSupplemental", \
"Printout"],
Cell[15485, 592, 125, 3, 28, 58, 0, "StyleData", "TOCBookSupplemental", \
"CenteredPrintout"],
Cell[15613, 597, 129, 3, 28, 62, 0, "StyleData", "TOCBookSupplemental", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[15779, 605, 371, 9, 29, 33, 0, "StyleData", "TOCBookPicture", "All",
 CounterIncrements->"TOCBookPicture"],
Cell[16153, 616, 45, 0, 29, 45, 0, "StyleData", "TOCBookPicture", \
"Centered"],
Cell[16201, 618, 112, 3, 28, 45, 0, "StyleData", "TOCBookPicture", \
"Printout"],
Cell[16316, 623, 120, 3, 28, 53, 0, "StyleData", "TOCBookPicture", \
"CenteredPrintout"],
Cell[16439, 628, 124, 3, 28, 57, 0, "StyleData", "TOCBookPicture", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[16600, 636, 392, 9, 29, 38, 0, "StyleData", "TOCBookIllustration", "All",
 
 CounterIncrements->"TOCBookIllustration"],
Cell[16995, 647, 50, 0, 29, 50, 0, "StyleData", "TOCBookIllustration", \
"Centered"],
Cell[17048, 649, 117, 3, 28, 50, 0, "StyleData", "TOCBookIllustration", \
"Printout"],
Cell[17168, 654, 125, 3, 28, 58, 0, "StyleData", "TOCBookIllustration", \
"CenteredPrintout"],
Cell[17296, 659, 129, 3, 28, 62, 0, "StyleData", "TOCBookIllustration", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[17462, 667, 370, 9, 29, 33, 0, "StyleData", "TOCBookProgram", "All",
 CounterIncrements->"TOCBookProgram"],
Cell[17835, 678, 45, 0, 29, 45, 0, "StyleData", "TOCBookProgram", \
"Centered"],
Cell[17883, 680, 112, 3, 28, 45, 0, "StyleData", "TOCBookProgram", \
"Printout"],
Cell[17998, 685, 120, 3, 28, 53, 0, "StyleData", "TOCBookProgram", \
"CenteredPrintout"],
Cell[18121, 690, 124, 3, 28, 57, 0, "StyleData", "TOCBookProgram", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[18282, 698, 363, 9, 29, 31, 0, "StyleData", "TOCBookTable", "All",
 CounterIncrements->"TOCBookTable"],
Cell[18648, 709, 43, 0, 29, 43, 0, "StyleData", "TOCBookTable", "Centered"],
Cell[18694, 711, 110, 3, 28, 43, 0, "StyleData", "TOCBookTable", "Printout"],
Cell[18807, 716, 118, 3, 28, 51, 0, "StyleData", "TOCBookTable", \
"CenteredPrintout"],
Cell[18928, 721, 122, 3, 28, 55, 0, "StyleData", "TOCBookTable", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[19099, 730, 46, 0, 42, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[19170, 734, 66, 1, 27, 32, 0, "StyleData", "TOCBookSpacer", "All"],
Cell[19239, 737, 78, 1, 27, 44, 0, "StyleData", "TOCBookSpacer", "Centered"],
Cell[19320, 740, 76, 1, 27, 44, 0, "StyleData", "TOCBookSpacer", "Printout"],
Cell[19399, 743, 84, 1, 27, 52, 0, "StyleData", "TOCBookSpacer", \
"CenteredPrintout"],
Cell[19486, 746, 88, 1, 27, 56, 0, "StyleData", "TOCBookSpacer", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[19611, 752, 68, 1, 35, 40, 0, "StyleData", "TOCBookPartTitleLabel", \
"All"],
Cell[19682, 755, 52, 0, 35, 52, 0, "StyleData", "TOCBookPartTitleLabel", \
"Centered"],
Cell[19737, 757, 80, 1, 35, 52, 0, "StyleData", "TOCBookPartTitleLabel", \
"Printout"],
Cell[19820, 760, 88, 1, 35, 60, 0, "StyleData", "TOCBookPartTitleLabel", \
"CenteredPrintout"],
Cell[19911, 763, 92, 1, 35, 64, 0, "StyleData", "TOCBookPartTitleLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[20040, 769, 94, 2, 35, 43, 0, "StyleData", "TOCBookChapterTitleLabel", \
"All"],
Cell[20137, 773, 55, 0, 35, 55, 0, "StyleData", "TOCBookChapterTitleLabel", \
"Centered"],
Cell[20195, 775, 83, 1, 35, 55, 0, "StyleData", "TOCBookChapterTitleLabel", \
"Printout"],
Cell[20281, 778, 91, 1, 35, 63, 0, "StyleData", "TOCBookChapterTitleLabel", \
"CenteredPrintout"],
Cell[20375, 781, 95, 1, 35, 67, 0, "StyleData", "TOCBookChapterTitleLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[20507, 787, 89, 2, 35, 38, 0, "StyleData", "TOCBookSectionLabel", \
"All"],
Cell[20599, 791, 50, 0, 35, 50, 0, "StyleData", "TOCBookSectionLabel", \
"Centered"],
Cell[20652, 793, 78, 1, 35, 50, 0, "StyleData", "TOCBookSectionLabel", \
"Printout"],
Cell[20733, 796, 86, 1, 35, 58, 0, "StyleData", "TOCBookSectionLabel", \
"CenteredPrintout"],
Cell[20822, 799, 90, 1, 35, 62, 0, "StyleData", "TOCBookSectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[20949, 805, 92, 2, 35, 41, 0, "StyleData", "TOCBookSubsectionLabel", \
"All"],
Cell[21044, 809, 53, 0, 35, 53, 0, "StyleData", "TOCBookSubsectionLabel", \
"Centered"],
Cell[21100, 811, 81, 1, 35, 53, 0, "StyleData", "TOCBookSubsectionLabel", \
"Printout"],
Cell[21184, 814, 89, 1, 35, 61, 0, "StyleData", "TOCBookSubsectionLabel", \
"CenteredPrintout"],
Cell[21276, 817, 93, 1, 35, 65, 0, "StyleData", "TOCBookSubsectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[21406, 823, 88, 2, 35, 37, 0, "StyleData", "TOCBookFigureLabel", "All"],
Cell[21497, 827, 49, 0, 35, 49, 0, "StyleData", "TOCBookFigureLabel", \
"Centered"],
Cell[21549, 829, 77, 1, 35, 49, 0, "StyleData", "TOCBookFigureLabel", \
"Printout"],
Cell[21629, 832, 85, 1, 35, 57, 0, "StyleData", "TOCBookFigureLabel", \
"CenteredPrintout"],
Cell[21717, 835, 89, 1, 35, 61, 0, "StyleData", "TOCBookFigureLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[21843, 841, 94, 2, 35, 43, 0, "StyleData", "TOCBookSupplementalLabel", \
"All"],
Cell[21940, 845, 55, 0, 35, 55, 0, "StyleData", "TOCBookSupplementalLabel", \
"Centered"],
Cell[21998, 847, 83, 1, 35, 55, 0, "StyleData", "TOCBookSupplementalLabel", \
"Printout"],
Cell[22084, 850, 91, 1, 35, 63, 0, "StyleData", "TOCBookSupplementalLabel", \
"CenteredPrintout"],
Cell[22178, 853, 95, 1, 35, 67, 0, "StyleData", "TOCBookSupplementalLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[22310, 859, 89, 2, 35, 38, 0, "StyleData", "TOCBookPictureLabel", \
"All"],
Cell[22402, 863, 50, 0, 35, 50, 0, "StyleData", "TOCBookPictureLabel", \
"Centered"],
Cell[22455, 865, 78, 1, 35, 50, 0, "StyleData", "TOCBookPictureLabel", \
"Printout"],
Cell[22536, 868, 86, 1, 35, 58, 0, "StyleData", "TOCBookPictureLabel", \
"CenteredPrintout"],
Cell[22625, 871, 90, 1, 35, 62, 0, "StyleData", "TOCBookPictureLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[22752, 877, 94, 2, 35, 43, 0, "StyleData", "TOCBookIllustrationLabel", \
"All"],
Cell[22849, 881, 55, 0, 35, 55, 0, "StyleData", "TOCBookIllustrationLabel", \
"Centered"],
Cell[22907, 883, 83, 1, 35, 55, 0, "StyleData", "TOCBookIllustrationLabel", \
"Printout"],
Cell[22993, 886, 91, 1, 35, 63, 0, "StyleData", "TOCBookIllustrationLabel", \
"CenteredPrintout"],
Cell[23087, 889, 95, 1, 35, 67, 0, "StyleData", "TOCBookIllustrationLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[23219, 895, 89, 2, 35, 38, 0, "StyleData", "TOCBookProgramLabel", \
"All"],
Cell[23311, 899, 50, 0, 35, 50, 0, "StyleData", "TOCBookProgramLabel", \
"Centered"],
Cell[23364, 901, 78, 1, 35, 50, 0, "StyleData", "TOCBookProgramLabel", \
"Printout"],
Cell[23445, 904, 86, 1, 35, 58, 0, "StyleData", "TOCBookProgramLabel", \
"CenteredPrintout"],
Cell[23534, 907, 90, 1, 35, 62, 0, "StyleData", "TOCBookProgramLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[23661, 913, 87, 2, 35, 36, 0, "StyleData", "TOCBookTableLabel", "All"],
Cell[23751, 917, 48, 0, 35, 48, 0, "StyleData", "TOCBookTableLabel", \
"Centered"],
Cell[23802, 919, 76, 1, 35, 48, 0, "StyleData", "TOCBookTableLabel", \
"Printout"],
Cell[23881, 922, 84, 1, 35, 56, 0, "StyleData", "TOCBookTableLabel", \
"CenteredPrintout"],
Cell[23968, 925, 88, 1, 35, 60, 0, "StyleData", "TOCBookTableLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[24093, 931, 88, 3, 35, 32, 0, "StyleData", "TOCBookLeader", "All"],
Cell[24184, 936, 44, 0, 35, 44, 0, "StyleData", "TOCBookLeader", "Centered"],
Cell[24231, 938, 59, 1, 34, 44, 0, "StyleData", "TOCBookLeader", "Printout"],
Cell[24293, 941, 67, 1, 34, 52, 0, "StyleData", "TOCBookLeader", \
"CenteredPrintout"],
Cell[24363, 944, 71, 1, 34, 56, 0, "StyleData", "TOCBookLeader", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[24471, 950, 130, 4, 35, 36, 0, "StyleData", "TOCBookPageNumber", "All"],
Cell[24604, 956, 48, 0, 35, 48, 0, "StyleData", "TOCBookPageNumber", \
"Centered"],
Cell[24655, 958, 76, 1, 35, 48, 0, "StyleData", "TOCBookPageNumber", \
"Printout"],
Cell[24734, 961, 84, 1, 35, 56, 0, "StyleData", "TOCBookPageNumber", \
"CenteredPrintout"],
Cell[24821, 964, 88, 1, 35, 60, 0, "StyleData", "TOCBookPageNumber", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[24994, 974, 32, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[25051, 978, 402, 11, 69, 26, 0, "StyleData", "Section", "All",
 CounterIncrements->{
  "Section", "SectionHeader", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[25456, 991, 155, 5, 64, 38, 0, "StyleData", "Section", "Centered"],
Cell[25614, 998, 132, 4, 57, 38, 0, "StyleData", "Section", "Printout"],
Cell[25749, 1004, 140, 4, 57, 46, 0, "StyleData", "Section", \
"CenteredPrintout"],
Cell[25892, 1010, 121, 3, 55, 50, 0, "StyleData", "Section", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[26050, 1018, 399, 12, 57, 29, 0, "StyleData", "Subsection", "All",
 CounterIncrements->{
  "Subsection", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsubsection", 0}}],
Cell[26452, 1032, 158, 5, 57, 41, 0, "StyleData", "Subsection", "Centered"],
Cell[26613, 1039, 135, 4, 51, 41, 0, "StyleData", "Subsection", "Printout"],
Cell[26751, 1045, 143, 4, 51, 49, 0, "StyleData", "Subsection", \
"CenteredPrintout"],
Cell[26897, 1051, 124, 3, 50, 53, 0, "StyleData", "Subsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[27058, 1059, 336, 10, 38, 32, 0, "StyleData", "Subsubsection", "All",
 CounterIncrements->{
  "Subsubsection", "SubsubsectionHeader", "SubsubsubsectionHeader"}],
Cell[27397, 1071, 146, 4, 53, 44, 0, "StyleData", "Subsubsection", \
"Centered"],
Cell[27546, 1077, 138, 4, 48, 44, 0, "StyleData", "Subsubsection", \
"Printout"],
Cell[27687, 1083, 146, 4, 48, 52, 0, "StyleData", "Subsubsection", \
"CenteredPrintout"],
Cell[27836, 1089, 126, 3, 45, 56, 0, "StyleData", "Subsubsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[27999, 1097, 313, 9, 37, 35, 0, "StyleData", "Subsubsubsection", "All",
 CounterIncrements->{"Subsubsubsection", "SubsubsubsectionHeader"}],
Cell[28315, 1108, 170, 5, 41, 47, 0, "StyleData", "Subsubsubsection", \
"Centered"],
Cell[28488, 1115, 140, 4, 38, 47, 0, "StyleData", "Subsubsubsection", \
"Printout"],
Cell[28631, 1121, 148, 4, 38, 55, 0, "StyleData", "Subsubsubsection", \
"CenteredPrintout"],
Cell[28782, 1127, 106, 2, 35, 59, 0, "StyleData", "Subsubsubsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[28925, 1134, 53, 0, 29, "Subsubsection"],
Cell[CellGroupData[{
Cell[29003, 1138, 71, 2, 35, 31, 0, "StyleData", "SectionLabel", "All"],
Cell[29077, 1142, 43, 0, 35, 43, 0, "StyleData", "SectionLabel", "Centered"],
Cell[29123, 1144, 43, 0, 35, 43, 0, "StyleData", "SectionLabel", "Printout"],
Cell[29169, 1146, 51, 0, 35, 51, 0, "StyleData", "SectionLabel", \
"CenteredPrintout"],
Cell[29223, 1148, 55, 0, 35, 55, 0, "StyleData", "SectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[29315, 1153, 74, 2, 35, 34, 0, "StyleData", "SubsectionLabel", "All"],
Cell[29392, 1157, 46, 0, 35, 46, 0, "StyleData", "SubsectionLabel", \
"Centered"],
Cell[29441, 1159, 46, 0, 35, 46, 0, "StyleData", "SubsectionLabel", \
"Printout"],
Cell[29490, 1161, 54, 0, 35, 54, 0, "StyleData", "SubsectionLabel", \
"CenteredPrintout"],
Cell[29547, 1163, 58, 0, 35, 58, 0, "StyleData", "SubsectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[29654, 1169, 43, 0, 29, "Subsubsection"],
Cell[CellGroupData[{
Cell[29722, 1173, 215, 7, 67, 29, 0, "StyleData", "SectionAlt", "All"],
Cell[29940, 1182, 158, 5, 64, 41, 0, "StyleData", "SectionAlt", "Centered"],
Cell[30101, 1189, 135, 4, 57, 41, 0, "StyleData", "SectionAlt", "Printout"],
Cell[30239, 1195, 143, 4, 57, 49, 0, "StyleData", "SectionAlt", \
"CenteredPrintout"],
Cell[30385, 1201, 124, 3, 55, 53, 0, "StyleData", "SectionAlt", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[30546, 1209, 218, 7, 57, 32, 0, "StyleData", "SubsectionAlt", "All"],
Cell[30767, 1218, 161, 5, 57, 44, 0, "StyleData", "SubsectionAlt", \
"Centered"],
Cell[30931, 1225, 138, 4, 51, 44, 0, "StyleData", "SubsectionAlt", \
"Printout"],
Cell[31072, 1231, 146, 4, 51, 52, 0, "StyleData", "SubsectionAlt", \
"CenteredPrintout"],
Cell[31221, 1237, 127, 3, 50, 56, 0, "StyleData", "SubsectionAlt", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[31397, 1246, 34, 0, 29, "Subsubsection"],
Cell[CellGroupData[{
Cell[31456, 1250, 252, 7, 29, 23, 0, "StyleData", "Text", "All",
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}}],
Cell[31711, 1259, 35, 0, 29, 35, 0, "StyleData", "Text", "Centered"],
Cell[31749, 1261, 104, 3, 26, 35, 0, "StyleData", "Text", "Printout"],
Cell[31856, 1266, 112, 3, 26, 43, 0, "StyleData", "Text", \
"CenteredPrintout"],
Cell[31971, 1271, 138, 4, 26, 47, 0, "StyleData", "Text", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[32146, 1280, 238, 6, 29, 31, 0, "StyleData", "TextNoIndent", "All",
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}}],
Cell[32387, 1288, 43, 0, 29, 43, 0, "StyleData", "TextNoIndent", "Centered"],
Cell[32433, 1290, 90, 2, 26, 43, 0, "StyleData", "TextNoIndent", "Printout"],
Cell[32526, 1294, 98, 2, 26, 51, 0, "StyleData", "TextNoIndent", \
"CenteredPrintout"],
Cell[32627, 1298, 124, 3, 26, 55, 0, "StyleData", "TextNoIndent", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[32788, 1306, 276, 7, 29, 35, 0, "StyleData", "TextContinuation", "All",
 CounterIncrements->"TextContinuation",
 CounterAssignments->{{"Item1Numbered", 0}}],
Cell[33067, 1315, 47, 0, 29, 47, 0, "StyleData", "TextContinuation", \
"Centered"],
Cell[33117, 1317, 94, 2, 26, 47, 0, "StyleData", "TextContinuation", \
"Printout"],
Cell[33214, 1321, 102, 2, 26, 55, 0, "StyleData", "TextContinuation", \
"CenteredPrintout"],
Cell[33319, 1325, 128, 3, 32, 59, 0, "StyleData", "TextContinuation", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[33508, 1335, 36, 0, 46, "Subsection"],
Cell[CellGroupData[{
Cell[33569, 1339, 64, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[33658, 1344, 358, 8, 30, 24, 0, "StyleData", "Item1", "All",
 CounterIncrements->"Item1",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}}],
Cell[34019, 1354, 36, 0, 30, 36, 0, "StyleData", "Item1", "Centered"],
Cell[34058, 1356, 84, 2, 28, 36, 0, "StyleData", "Item1", "Printout"],
Cell[34145, 1360, 92, 2, 28, 44, 0, "StyleData", "Item1", \
"CenteredPrintout"],
Cell[34240, 1364, 118, 3, 28, 48, 0, "StyleData", "Item1", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[34395, 1372, 336, 8, 30, 24, 0, "StyleData", "Item2", "All",
 CounterIncrements->"Item2",
 CounterAssignments->{{"Item3Numbered", 0}}],
Cell[34734, 1382, 36, 0, 30, 36, 0, "StyleData", "Item2", "Centered"],
Cell[34773, 1384, 84, 2, 28, 36, 0, "StyleData", "Item2", "Printout"],
Cell[34860, 1388, 92, 2, 28, 44, 0, "StyleData", "Item2", \
"CenteredPrintout"],
Cell[34955, 1392, 118, 3, 28, 48, 0, "StyleData", "Item2", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[35110, 1400, 291, 7, 30, 24, 0, "StyleData", "Item3", "All",
 CounterIncrements->"Item3"],
Cell[35404, 1409, 36, 0, 30, 36, 0, "StyleData", "Item3", "Centered"],
Cell[35443, 1411, 84, 2, 28, 36, 0, "StyleData", "Item3", "Printout"],
Cell[35530, 1415, 92, 2, 28, 44, 0, "StyleData", "Item3", \
"CenteredPrintout"],
Cell[35625, 1419, 118, 3, 28, 48, 0, "StyleData", "Item3", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[35780, 1427, 102, 3, 35, 29, 0, "StyleData", "Item1Label", "All"],
Cell[35885, 1432, 41, 0, 35, 41, 0, "StyleData", "Item1Label", "Centered"],
Cell[35929, 1434, 84, 2, 34, 41, 0, "StyleData", "Item1Label", "Printout"],
Cell[36016, 1438, 92, 2, 34, 49, 0, "StyleData", "Item1Label", \
"CenteredPrintout"],
Cell[36111, 1442, 96, 2, 34, 53, 0, "StyleData", "Item1Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[36244, 1449, 102, 3, 35, 29, 0, "StyleData", "Item2Label", "All"],
Cell[36349, 1454, 41, 0, 35, 41, 0, "StyleData", "Item2Label", "Centered"],
Cell[36393, 1456, 69, 1, 35, 41, 0, "StyleData", "Item2Label", "Printout"],
Cell[36465, 1459, 77, 1, 35, 49, 0, "StyleData", "Item2Label", \
"CenteredPrintout"],
Cell[36545, 1462, 81, 1, 35, 53, 0, "StyleData", "Item2Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[36663, 1468, 102, 3, 35, 29, 0, "StyleData", "Item3Label", "All"],
Cell[36768, 1473, 41, 0, 35, 41, 0, "StyleData", "Item3Label", "Centered"],
Cell[36812, 1475, 69, 1, 35, 41, 0, "StyleData", "Item3Label", "Printout"],
Cell[36884, 1478, 77, 1, 35, 49, 0, "StyleData", "Item3Label", \
"CenteredPrintout"],
Cell[36964, 1481, 81, 1, 35, 53, 0, "StyleData", "Item3Label", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[37094, 1488, 64, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[37183, 1493, 419, 10, 30, 32, 0, "StyleData", "Item1Numbered", "All",
 CounterIncrements->"Item1Numbered",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}}],
Cell[37605, 1505, 44, 0, 30, 44, 0, "StyleData", "Item1Numbered", \
"Centered"],
Cell[37652, 1507, 92, 2, 28, 44, 0, "StyleData", "Item1Numbered", \
"Printout"],
Cell[37747, 1511, 100, 2, 28, 52, 0, "StyleData", "Item1Numbered", \
"CenteredPrintout"],
Cell[37850, 1515, 126, 3, 28, 56, 0, "StyleData", "Item1Numbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[38013, 1523, 484, 12, 30, 32, 0, "StyleData", "Item2Numbered", "All",
 CounterIncrements->"Item2Numbered",
 CounterAssignments->{{"Item3Numbered", 0}}],
Cell[38500, 1537, 44, 0, 30, 44, 0, "StyleData", "Item2Numbered", \
"Centered"],
Cell[38547, 1539, 92, 2, 29, 44, 0, "StyleData", "Item2Numbered", \
"Printout"],
Cell[38642, 1543, 100, 2, 29, 52, 0, "StyleData", "Item2Numbered", \
"CenteredPrintout"],
Cell[38745, 1547, 126, 3, 29, 56, 0, "StyleData", "Item2Numbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[38908, 1555, 405, 10, 30, 32, 0, "StyleData", "Item3Numbered", "All",
 CounterIncrements->"Item3Numbered"],
Cell[39316, 1567, 44, 0, 30, 44, 0, "StyleData", "Item3Numbered", \
"Centered"],
Cell[39363, 1569, 92, 2, 28, 44, 0, "StyleData", "Item3Numbered", \
"Printout"],
Cell[39458, 1573, 100, 2, 28, 52, 0, "StyleData", "Item3Numbered", \
"CenteredPrintout"],
Cell[39561, 1577, 126, 3, 28, 56, 0, "StyleData", "Item3Numbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[39724, 1585, 109, 3, 35, 37, 0, "StyleData", "Item1NumberedLabel", \
"All"],
Cell[39836, 1590, 49, 0, 35, 49, 0, "StyleData", "Item1NumberedLabel", \
"Centered"],
Cell[39888, 1592, 77, 1, 34, 49, 0, "StyleData", "Item1NumberedLabel", \
"Printout"],
Cell[39968, 1595, 85, 1, 35, 57, 0, "StyleData", "Item1NumberedLabel", \
"CenteredPrintout"],
Cell[40056, 1598, 89, 1, 35, 61, 0, "StyleData", "Item1NumberedLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[40182, 1604, 109, 3, 35, 37, 0, "StyleData", "Item2NumberedLabel", \
"All"],
Cell[40294, 1609, 49, 0, 35, 49, 0, "StyleData", "Item2NumberedLabel", \
"Centered"],
Cell[40346, 1611, 77, 1, 35, 49, 0, "StyleData", "Item2NumberedLabel", \
"Printout"],
Cell[40426, 1614, 85, 1, 35, 57, 0, "StyleData", "Item2NumberedLabel", \
"CenteredPrintout"],
Cell[40514, 1617, 89, 1, 35, 61, 0, "StyleData", "Item2NumberedLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[40640, 1623, 109, 3, 35, 37, 0, "StyleData", "Item3NumberedLabel", \
"All"],
Cell[40752, 1628, 49, 0, 35, 49, 0, "StyleData", "Item3NumberedLabel", \
"Centered"],
Cell[40804, 1630, 77, 1, 35, 49, 0, "StyleData", "Item3NumberedLabel", \
"Printout"],
Cell[40884, 1633, 85, 1, 35, 57, 0, "StyleData", "Item3NumberedLabel", \
"CenteredPrintout"],
Cell[40972, 1636, 89, 1, 35, 61, 0, "StyleData", "Item3NumberedLabel", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[41110, 1643, 65, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[41200, 1648, 107, 2, 29, 33, 0, "StyleData", "Item1Paragraph", "All"],
Cell[41310, 1652, 45, 0, 29, 45, 0, "StyleData", "Item1Paragraph", \
"Centered"],
Cell[41358, 1654, 93, 2, 28, 45, 0, "StyleData", "Item1Paragraph", \
"Printout"],
Cell[41454, 1658, 101, 2, 28, 53, 0, "StyleData", "Item1Paragraph", \
"CenteredPrintout"],
Cell[41558, 1662, 127, 3, 28, 57, 0, "StyleData", "Item1Paragraph", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[41722, 1670, 107, 2, 29, 33, 0, "StyleData", "Item2Paragraph", "All"],
Cell[41832, 1674, 45, 0, 29, 45, 0, "StyleData", "Item2Paragraph", \
"Centered"],
Cell[41880, 1676, 93, 2, 28, 45, 0, "StyleData", "Item2Paragraph", \
"Printout"],
Cell[41976, 1680, 101, 2, 28, 53, 0, "StyleData", "Item2Paragraph", \
"CenteredPrintout"],
Cell[42080, 1684, 127, 3, 28, 57, 0, "StyleData", "Item2Paragraph", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[42244, 1692, 108, 2, 29, 33, 0, "StyleData", "Item3Paragraph", "All"],
Cell[42355, 1696, 45, 0, 29, 45, 0, "StyleData", "Item3Paragraph", \
"Centered"],
Cell[42403, 1698, 93, 2, 28, 45, 0, "StyleData", "Item3Paragraph", \
"Printout"],
Cell[42499, 1702, 101, 2, 28, 53, 0, "StyleData", "Item3Paragraph", \
"CenteredPrintout"],
Cell[42603, 1706, 127, 3, 28, 57, 0, "StyleData", "Item3Paragraph", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[42791, 1716, 48, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[42864, 1720, 31, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[42920, 1724, 375, 12, 40, 25, 0, "StyleData", "Figure", "All",
 CounterIncrements->"Figure"],
Cell[43298, 1738, 61, 1, 35, 37, 0, "StyleData", "Figure", "Centered"],
Cell[43362, 1741, 114, 3, 34, 37, 0, "StyleData", "Figure", "Printout"],
Cell[43479, 1746, 122, 3, 34, 45, 0, "StyleData", "Figure", \
"CenteredPrintout"],
Cell[43604, 1751, 103, 2, 34, 49, 0, "StyleData", "Figure", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[43744, 1758, 278, 8, 34, 32, 0, "StyleData", "FigureCaption", "All",
 CounterIncrements->"FigureCaption",
 CounterAssignments->{{"Nil", 0}}],
Cell[44025, 1768, 118, 2, 35, 44, 0, "StyleData", "FigureCaption", \
"Centered"],
Cell[44146, 1772, 139, 4, 33, 44, 0, "StyleData", "FigureCaption", \
"Printout"],
Cell[44288, 1778, 147, 4, 33, 52, 0, "StyleData", "FigureCaption", \
"CenteredPrintout"],
Cell[44438, 1784, 148, 4, 33, 56, 0, "StyleData", "FigureCaption", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[44601, 1791, 100, 2, 35, 37, 0, "StyleData", "FigureCaptionLabel", \
"All"]
}, Closed]],
Cell[CellGroupData[{
Cell[44738, 1798, 32, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[44795, 1802, 425, 14, 40, 26, 0, "StyleData", "Picture", "All",
 CounterIncrements->"Picture"],
Cell[45223, 1818, 62, 1, 35, 38, 0, "StyleData", "Picture", "Centered"],
Cell[45288, 1821, 115, 3, 34, 38, 0, "StyleData", "Picture", "Printout"],
Cell[45406, 1826, 123, 3, 34, 46, 0, "StyleData", "Picture", \
"CenteredPrintout"],
Cell[45532, 1831, 104, 2, 34, 50, 0, "StyleData", "Picture", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[45673, 1838, 280, 8, 34, 33, 0, "StyleData", "PictureCaption", "All",
 CounterIncrements->"PictureCaption",
 CounterAssignments->{{"Nil", 0}}],
Cell[45956, 1848, 119, 2, 35, 45, 0, "StyleData", "PictureCaption", \
"Centered"],
Cell[46078, 1852, 140, 4, 33, 45, 0, "StyleData", "PictureCaption", \
"Printout"],
Cell[46221, 1858, 148, 4, 33, 53, 0, "StyleData", "PictureCaption", \
"CenteredPrintout"],
Cell[46372, 1864, 149, 4, 33, 57, 0, "StyleData", "PictureCaption", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[46536, 1871, 101, 2, 35, 38, 0, "StyleData", "PictureCaptionLabel", \
"All"]
}, Closed]],
Cell[CellGroupData[{
Cell[46674, 1878, 39, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[46738, 1882, 152, 4, 52, 26, 0, "StyleData", "Program", "All",
 CounterIncrements->"Program"],
Cell[46893, 1888, 72, 1, 34, 38, 0, "StyleData", "Program", "Centered"],
Cell[46968, 1891, 87, 2, 31, 38, 0, "StyleData", "Program", "Printout"],
Cell[47058, 1895, 95, 2, 31, 46, 0, "StyleData", "Program", \
"CenteredPrintout"],
Cell[47156, 1899, 98, 2, 31, 50, 0, "StyleData", "Program", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[47291, 1906, 253, 7, 34, 33, 0, "StyleData", "ProgramCaption", "All",
 CounterIncrements->"ProgramCaption",
 CounterAssignments->{{"Nil", 0}}],
Cell[47547, 1915, 95, 1, 35, 45, 0, "StyleData", "ProgramCaption", \
"Centered"],
Cell[47645, 1918, 116, 3, 33, 45, 0, "StyleData", "ProgramCaption", \
"Printout"],
Cell[47764, 1923, 124, 3, 33, 53, 0, "StyleData", "ProgramCaption", \
"CenteredPrintout"],
Cell[47891, 1928, 149, 4, 33, 57, 0, "StyleData", "ProgramCaption", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[48055, 1935, 56, 1, 35, 38, 0, "StyleData", "ProgramCaptionLabel", \
"All"]
}, Closed]],
Cell[CellGroupData[{
Cell[48148, 1941, 31, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[48204, 1945, 512, 14, 35, 29, 0, "StyleData", "TableTitle", "All",
 CounterIncrements->"TableTitle",
 CounterAssignments->{{"Nil", 0}}],
Cell[48719, 1961, 98, 1, 35, 41, 0, "StyleData", "TableTitle", "Centered"],
Cell[48820, 1964, 88, 2, 32, 41, 0, "StyleData", "TableTitle", "Printout"],
Cell[48911, 1968, 96, 2, 32, 49, 0, "StyleData", "TableTitle", \
"CenteredPrintout"],
Cell[49010, 1972, 101, 2, 32, 53, 0, "StyleData", "TableTitle", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[49148, 1979, 385, 11, 35, 34, 0, "StyleData", "TableTitleLabel", "All",
 CounterIncrements->"TableTitleLabel"],
Cell[49536, 1992, 46, 0, 35, 46, 0, "StyleData", "TableTitleLabel", \
"Centered"],
Cell[49585, 1994, 61, 1, 34, 46, 0, "StyleData", "TableTitleLabel", \
"Printout"],
Cell[49649, 1997, 69, 1, 34, 54, 0, "StyleData", "TableTitleLabel", \
"CenteredPrintout"],
Cell[49721, 2000, 73, 1, 34, 58, 0, "StyleData", "TableTitleLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[49831, 2006, 738, 19, 32, 24, 0, "StyleData", "Table", "All",
 CounterIncrements->"Table",
 CounterAssignments->{{"TableNote", 0}}],
Cell[50572, 2027, 70, 1, 32, 36, 0, "StyleData", "Table", "Centered"],
Cell[50645, 2030, 108, 3, 30, 36, 0, "StyleData", "Table", "Printout"],
Cell[50756, 2035, 115, 3, 30, 44, 0, "StyleData", "Table", \
"CenteredPrintout"],
Cell[50874, 2040, 120, 3, 30, 48, 0, "StyleData", "Table", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[51031, 2048, 251, 8, 30, 28, 0, "StyleData", "TableNote", "All",
 CounterIncrements->"TableNote"],
Cell[51285, 2058, 75, 1, 31, 40, 0, "StyleData", "TableNote", "Centered"],
Cell[51363, 2061, 87, 2, 31, 40, 0, "StyleData", "TableNote", "Printout"],
Cell[51453, 2065, 87, 2, 28, 40, 0, "StyleData", "TableNote", "Printout"],
Cell[51543, 2069, 122, 3, 28, 52, 0, "StyleData", "TableNote", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[51702, 2077, 47, 0, 43, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[51774, 2081, 813, 22, 35, 34, 0, "StyleData", "TableColumnHead", "All"],
Cell[52590, 2105, 46, 0, 35, 46, 0, "StyleData", "TableColumnHead", \
"Centered"],
Cell[52639, 2107, 61, 1, 34, 46, 0, "StyleData", "TableColumnHead", \
"Printout"],
Cell[52703, 2110, 69, 1, 34, 54, 0, "StyleData", "TableColumnHead", \
"CenteredPrintout"],
Cell[52775, 2113, 73, 1, 34, 58, 0, "StyleData", "TableColumnHead", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[52885, 2119, 835, 23, 35, 32, 0, "StyleData", "TableSpanHead", "All"],
Cell[53723, 2144, 59, 1, 34, 44, 0, "StyleData", "TableSpanHead", \
"Printout"],
Cell[53785, 2147, 71, 1, 34, 56, 0, "StyleData", "TableSpanHead", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[53893, 2153, 829, 23, 35, 28, 0, "StyleData", "TableText", "All"],
Cell[54725, 2178, 40, 0, 35, 40, 0, "StyleData", "TableText", "Centered"],
Cell[54768, 2180, 55, 1, 34, 40, 0, "StyleData", "TableText", "Printout"],
Cell[54826, 2183, 63, 1, 34, 48, 0, "StyleData", "TableText", \
"CenteredPrintout"],
Cell[54892, 2186, 89, 2, 34, 52, 0, "StyleData", "TableText", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[55018, 2193, 599, 17, 35, 32, 0, "StyleData", "TableSpanText", "All"],
Cell[55620, 2212, 59, 1, 34, 44, 0, "StyleData", "TableSpanText", \
"Printout"],
Cell[55682, 2215, 71, 1, 34, 56, 0, "StyleData", "TableSpanText", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[55768, 2219, 735, 18, 35, 31, 0, "StyleData", "TableSubGrid", "All"],
Cell[56506, 2239, 441, 10, 35, 34, 0, "StyleData", "TableMasterGrid", "All"],
Cell[56950, 2251, 211, 7, 17, 35, 0, "StyleData", "TableLineElement", "All"],
Cell[57164, 2260, 142, 4, 9, 36, 0, "StyleData", "TableBlankElement", "All"],
Cell[CellGroupData[{
Cell[57331, 2268, 103, 4, 39, 27, 0, "StyleData", "SpanLeft", "All"],
Cell[57437, 2274, 54, 1, 37, 39, 0, "StyleData", "SpanLeft", "Printout"],
Cell[57494, 2277, 66, 1, 37, 51, 0, "StyleData", "SpanLeft", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[57597, 2283, 105, 4, 39, 29, 0, "StyleData", "SpanCenter", "All"],
Cell[57705, 2289, 56, 1, 37, 41, 0, "StyleData", "SpanCenter", "Printout"],
Cell[57764, 2292, 68, 1, 37, 53, 0, "StyleData", "SpanCenter", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[57869, 2298, 104, 4, 39, 28, 0, "StyleData", "SpanRight", "All"],
Cell[57976, 2304, 55, 1, 37, 40, 0, "StyleData", "SpanRight", "Printout"],
Cell[58034, 2307, 67, 1, 37, 52, 0, "StyleData", "SpanRight", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[58162, 2315, 32, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[58219, 2319, 207, 6, 34, 26, 0, "StyleData", "Caption", "All",
 CounterIncrements->"Caption"],
Cell[58429, 2327, 88, 1, 35, 38, 0, "StyleData", "Caption", "Centered"],
Cell[58520, 2330, 109, 3, 33, 38, 0, "StyleData", "Caption", "Printout"],
Cell[58632, 2335, 117, 3, 33, 46, 0, "StyleData", "Caption", \
"CenteredPrintout"],
Cell[58752, 2340, 142, 4, 33, 50, 0, "StyleData", "Caption", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[58955, 2351, 33, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[59013, 2355, 34, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[59072, 2359, 338, 9, 41, 27, 0, "StyleData", "Equation", "All",
 CounterIncrements->"Equation"],
Cell[59413, 2370, 172, 4, 41, 39, 0, "StyleData", "Equation", "Centered"],
Cell[59588, 2376, 185, 5, 36, 39, 0, "StyleData", "Equation", "Printout"],
Cell[59776, 2383, 193, 5, 36, 47, 0, "StyleData", "Equation", \
"CenteredPrintout"],
Cell[59972, 2390, 99, 2, 36, 51, 0, "StyleData", "Equation", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[60108, 2397, 290, 7, 29, 32, 0, "StyleData", "EquationGroup", "All"],
Cell[60401, 2406, 176, 4, 29, 44, 0, "StyleData", "EquationGroup", \
"Centered"],
Cell[60580, 2412, 190, 5, 27, 44, 0, "StyleData", "EquationGroup", \
"Printout"],
Cell[60773, 2419, 198, 5, 27, 52, 0, "StyleData", "EquationGroup", \
"CenteredPrintout"],
Cell[60974, 2426, 104, 2, 27, 56, 0, "StyleData", "EquationGroup", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[61115, 2433, 523, 12, 29, 39, 0, "StyleData", "EquationGroupAligned", \
"All"],
Cell[61641, 2447, 108, 2, 29, 51, 0, "StyleData", "EquationGroupAligned", \
"Centered"],
Cell[61752, 2451, 122, 3, 27, 51, 0, "StyleData", "EquationGroupAligned", \
"Printout"],
Cell[61877, 2456, 130, 3, 27, 59, 0, "StyleData", "EquationGroupAligned", \
"CenteredPrintout"],
Cell[62010, 2461, 111, 2, 27, 63, 0, "StyleData", "EquationGroupAligned", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[62170, 2469, 43, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[62238, 2473, 467, 13, 41, 35, 0, "StyleData", "EquationNumbered", "All",
 CounterIncrements->"EquationNumbered"],
Cell[62708, 2488, 105, 2, 41, 47, 0, "StyleData", "EquationNumbered", \
"Centered"],
Cell[62816, 2492, 118, 3, 36, 47, 0, "StyleData", "EquationNumbered", \
"Printout"],
Cell[62937, 2497, 126, 3, 36, 55, 0, "StyleData", "EquationNumbered", \
"CenteredPrintout"],
Cell[63066, 2502, 107, 2, 36, 59, 0, "StyleData", "EquationNumbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[63210, 2509, 451, 12, 29, 40, 0, "StyleData", "EquationGroupNumbered", \
"All",
 CounterIncrements->"EquationNumbered"],
Cell[63664, 2523, 109, 2, 29, 52, 0, "StyleData", "EquationGroupNumbered", \
"Centered"],
Cell[63776, 2527, 123, 3, 27, 52, 0, "StyleData", "EquationGroupNumbered", \
"Printout"],
Cell[63902, 2532, 131, 3, 27, 60, 0, "StyleData", "EquationGroupNumbered", \
"CenteredPrintout"],
Cell[64036, 2537, 112, 2, 27, 64, 0, "StyleData", "EquationGroupNumbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[64185, 2544, 684, 17, 29, 47, 0, "StyleData", \
"EquationGroupAlignedNumbered", "All",
 CounterIncrements->"EquationNumbered"],
Cell[64872, 2563, 116, 2, 29, 59, 0, "StyleData", \
"EquationGroupAlignedNumbered", "Centered"],
Cell[64991, 2567, 130, 3, 27, 59, 0, "StyleData", \
"EquationGroupAlignedNumbered", "Printout"],
Cell[65124, 2572, 138, 3, 27, 67, 0, "StyleData", \
"EquationGroupAlignedNumbered", "CenteredPrintout"],
Cell[65265, 2577, 119, 2, 27, 71, 0, "StyleData", \
"EquationGroupAlignedNumbered", "DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[65421, 2584, 84, 2, 35, 33, 0, "StyleData", "EquationNumber", "All"],
Cell[65508, 2588, 73, 1, 35, 45, 0, "StyleData", "EquationNumber", \
"Centered"],
Cell[65584, 2591, 73, 1, 35, 45, 0, "StyleData", "EquationNumber", \
"Printout"],
Cell[65660, 2594, 81, 1, 35, 53, 0, "StyleData", "EquationNumber", \
"CenteredPrintout"],
Cell[65744, 2597, 85, 1, 35, 57, 0, "StyleData", "EquationNumber", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[65878, 2604, 49, 0, 45, "Subsubsection"],
Cell[65930, 2606, 31, 0, 35, 31, 0, "StyleData", "EquationGrid", "All"],
Cell[65964, 2608, 32, 0, 35, 32, 0, "StyleData", "SplitEquation", "All"],
Cell[65999, 2610, 28, 0, 35, 28, 0, "StyleData", "Piecewise", "All"],
Cell[66030, 2612, 25, 0, 35, 25, 0, "StyleData", "Matrix", "All"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[66104, 2618, 38, 0, 30, "Subsection"],
Cell[66145, 2620, 179, 3, 35, 23, 0, "StyleData", "XRef", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[66361, 2628, 32, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[66418, 2632, 204, 6, 56, 34, 0, "StyleData", "BackmatterGroup", "All"],
Cell[66625, 2640, 46, 0, 56, 46, 0, "StyleData", "BackmatterGroup", \
"Centered"],
Cell[66674, 2642, 118, 3, 16, 46, 0, "StyleData", "BackmatterGroup", \
"Printout"],
Cell[66795, 2647, 126, 3, 16, 54, 0, "StyleData", "BackmatterGroup", \
"CenteredPrintout"],
Cell[66924, 2652, 130, 3, 16, 58, 0, "StyleData", "BackmatterGroup", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[67091, 2660, 33, 0, 29, "Subsubsection"],
Cell[CellGroupData[{
Cell[67149, 2664, 560, 16, 107, 39, 0, "StyleData", "AppendixSectionLabel", \
"All",
 CounterIncrements->"AppendixSectionLabel",
 CounterAssignments->{{"Section", 0}, {"AppendixEquation", 0}, {
   "FigureCaption", 0}, {"TableTitle", 0}}],
Cell[67712, 2682, 169, 5, 103, 51, 0, "StyleData", "AppendixSectionLabel", \
"Centered"],
Cell[67884, 2689, 145, 4, 88, 51, 0, "StyleData", "AppendixSectionLabel", \
"Printout"],
Cell[68032, 2695, 153, 4, 88, 59, 0, "StyleData", "AppendixSectionLabel", \
"CenteredPrintout"],
Cell[68188, 2701, 111, 2, 88, 63, 0, "StyleData", "AppendixSectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[68336, 2708, 98, 3, 44, 40, 0, "StyleData", "AppendixSectionNumber", \
"All"],
Cell[68437, 2713, 110, 3, 44, 52, 0, "StyleData", "AppendixSectionNumber", \
"Centered"],
Cell[68550, 2718, 89, 2, 40, 52, 0, "StyleData", "AppendixSectionNumber", \
"Printout"],
Cell[68642, 2722, 97, 2, 40, 60, 0, "StyleData", "AppendixSectionNumber", \
"CenteredPrintout"],
Cell[68742, 2726, 79, 1, 40, 64, 0, "StyleData", "AppendixSectionNumber", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[68858, 2732, 304, 10, 155, 34, 0, "StyleData", "AppendixSection", \
"All"],
Cell[69165, 2744, 164, 5, 152, 46, 0, "StyleData", "AppendixSection", \
"Centered"],
Cell[69332, 2751, 165, 5, 124, 46, 0, "StyleData", "AppendixSection", \
"Printout"],
Cell[69500, 2758, 173, 5, 124, 54, 0, "StyleData", "AppendixSection", \
"CenteredPrintout"],
Cell[69676, 2765, 129, 3, 124, 58, 0, "StyleData", "AppendixSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[69842, 2773, 260, 7, 29, 27, 0, "StyleData", "Appendix", "All",
 CounterIncrements->"Appendix",
 CounterAssignments->{{"Item1Numbered", 0}}],
Cell[70105, 2782, 39, 0, 29, 39, 0, "StyleData", "Appendix", "Centered"],
Cell[70147, 2784, 108, 3, 26, 39, 0, "StyleData", "Appendix", "Printout"],
Cell[70258, 2789, 116, 3, 26, 47, 0, "StyleData", "Appendix", \
"CenteredPrintout"],
Cell[70377, 2794, 142, 4, 26, 51, 0, "StyleData", "Appendix", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[70556, 2803, 342, 9, 38, 35, 0, "StyleData", "AppendixEquation", "All",
 CounterIncrements->"AppendixEquation"],
Cell[70901, 2814, 105, 2, 41, 47, 0, "StyleData", "AppendixEquation", \
"Centered"],
Cell[71009, 2818, 134, 3, 34, 47, 0, "StyleData", "AppendixEquation", \
"Printout"],
Cell[71146, 2823, 142, 3, 34, 55, 0, "StyleData", "AppendixEquation", \
"CenteredPrintout"],
Cell[71291, 2828, 107, 2, 36, 59, 0, "StyleData", "AppendixEquation", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[71447, 2836, 58, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[71530, 2841, 315, 10, 215, 33, 0, "StyleData", "EndnoteSection", "All"],
Cell[71848, 2853, 314, 10, 212, 45, 0, "StyleData", "EndnoteSection", \
"Centered"],
Cell[72165, 2865, 140, 4, 118, 45, 0, "StyleData", "EndnoteSection", \
"Printout"],
Cell[72308, 2871, 148, 4, 174, 53, 0, "StyleData", "EndnoteSection", \
"CenteredPrintout"],
Cell[72459, 2877, 106, 2, 174, 57, 0, "StyleData", "EndnoteSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[72602, 2884, 156, 5, 31, 26, 0, "StyleData", "Endnote", "All",
 CounterIncrements->"Endnote"],
Cell[72761, 2891, 38, 0, 31, 38, 0, "StyleData", "Endnote", "Centered"],
Cell[72802, 2893, 110, 3, 38, 38, 0, "StyleData", "Endnote", "Printout"],
Cell[72915, 2898, 118, 3, 38, 46, 0, "StyleData", "Endnote", \
"CenteredPrintout"],
Cell[73036, 2903, 119, 3, 38, 50, 0, "StyleData", "Endnote", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[73192, 2911, 135, 4, 35, 31, 0, "StyleData", "EndnoteLabel", "All",
 CounterIncrements->"EndnoteLabel"],
Cell[73330, 2917, 43, 0, 35, 43, 0, "StyleData", "EndnoteLabel", "Centered"],
Cell[73376, 2919, 71, 1, 35, 43, 0, "StyleData", "EndnoteLabel", "Printout"],
Cell[73450, 2922, 79, 1, 35, 51, 0, "StyleData", "EndnoteLabel", \
"CenteredPrintout"],
Cell[73532, 2925, 83, 1, 35, 55, 0, "StyleData", "EndnoteLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[73652, 2931, 120, 3, 35, 32, 0, "StyleData", "EndnoteNumber", "All",
 CounterIncrements->"EndnoteNumber"],
Cell[73775, 2936, 44, 0, 35, 44, 0, "StyleData", "EndnoteNumber", \
"Centered"],
Cell[73822, 2938, 72, 1, 35, 44, 0, "StyleData", "EndnoteNumber", \
"Printout"],
Cell[73897, 2941, 80, 1, 35, 52, 0, "StyleData", "EndnoteNumber", \
"CenteredPrintout"],
Cell[73980, 2944, 84, 1, 35, 56, 0, "StyleData", "EndnoteNumber", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[74101, 2950, 222, 6, 35, 26, 0, "StyleData", "NoteKey", "All",
 ButtonStyleMenuListing->None],
Cell[74326, 2958, 38, 0, 35, 38, 0, "StyleData", "NoteKey", "Centered"],
Cell[74367, 2960, 64, 1, 35, 38, 0, "StyleData", "NoteKey", "Printout"],
Cell[74434, 2963, 72, 1, 35, 46, 0, "StyleData", "NoteKey", \
"CenteredPrintout"],
Cell[74509, 2966, 76, 1, 35, 50, 0, "StyleData", "NoteKey", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[74622, 2972, 232, 6, 35, 36, 0, "StyleData", "EndnoteReturnLink", "All",
 ButtonStyleMenuListing->None],
Cell[74857, 2980, 48, 0, 35, 48, 0, "StyleData", "EndnoteReturnLink", \
"Centered"],
Cell[74908, 2982, 113, 2, 35, 48, 0, "StyleData", "EndnoteReturnLink", \
"Printout"],
Cell[75024, 2986, 121, 2, 35, 56, 0, "StyleData", "EndnoteReturnLink", \
"CenteredPrintout"],
Cell[75148, 2990, 125, 2, 35, 60, 0, "StyleData", "EndnoteReturnLink", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[75310, 2997, 361, 10, 35, 23, 0, "StyleData", "Note", "All",
 StyleMenuListing->None],
Cell[75674, 3009, 54, 1, 35, 35, 0, "StyleData", "Note", "Printout"],
Cell[75731, 3012, 66, 1, 35, 47, 0, "StyleData", "Note", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[75846, 3019, 35, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[75906, 3023, 353, 10, 215, 35, 0, "StyleData", "ReferenceSection", "All",
 
 CounterIncrements->"ReferenceSection",
 CounterAssignments->{{"ReferenceText", 0}, {"BiblioEquation", 0}}],
Cell[76262, 3035, 165, 5, 212, 47, 0, "StyleData", "ReferenceSection", \
"Centered"],
Cell[76430, 3042, 142, 4, 174, 47, 0, "StyleData", "ReferenceSection", \
"Printout"],
Cell[76575, 3048, 150, 4, 174, 55, 0, "StyleData", "ReferenceSection", \
"CenteredPrintout"],
Cell[76728, 3054, 108, 2, 174, 59, 0, "StyleData", "ReferenceSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[76873, 3061, 217, 6, 29, 28, 0, "StyleData", "Reference", "All",
 CounterIncrements->"BibliographyItem"],
Cell[77093, 3069, 40, 0, 29, 40, 0, "StyleData", "Reference", "Centered"],
Cell[77136, 3071, 131, 4, 28, 40, 0, "StyleData", "Reference", "Printout"],
Cell[77270, 3077, 139, 4, 28, 48, 0, "StyleData", "Reference", \
"CenteredPrintout"],
Cell[77412, 3083, 143, 4, 28, 52, 0, "StyleData", "Reference", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[77592, 3092, 135, 4, 35, 33, 0, "StyleData", "ReferenceLabel", "All",
 CounterIncrements->"RefDingbat"],
Cell[77730, 3098, 45, 0, 35, 45, 0, "StyleData", "ReferenceLabel", \
"Centered"],
Cell[77778, 3100, 73, 1, 35, 45, 0, "StyleData", "ReferenceLabel", \
"Printout"],
Cell[77854, 3103, 81, 1, 35, 53, 0, "StyleData", "ReferenceLabel", \
"CenteredPrintout"],
Cell[77938, 3106, 85, 1, 35, 57, 0, "StyleData", "ReferenceLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[78038, 3110, 95, 2, 35, 25, 0, "StyleData", "RefSep", "All"],
Cell[CellGroupData[{
Cell[78158, 3116, 278, 7, 37, 35, 0, "StyleData", "RefReturnPointer", "All",
 ButtonStyleMenuListing->None],
Cell[78439, 3125, 73, 1, 35, 47, 0, "StyleData", "RefReturnPointer", \
"Printout"],
Cell[78515, 3128, 85, 1, 35, 59, 0, "StyleData", "RefReturnPointer", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[78637, 3134, 232, 6, 35, 32, 0, "StyleData", "RefReturnLink", "All",
 ButtonStyleMenuListing->None],
Cell[78872, 3142, 44, 0, 35, 44, 0, "StyleData", "RefReturnLink", \
"Centered"],
Cell[78919, 3144, 70, 1, 35, 44, 0, "StyleData", "RefReturnLink", \
"Printout"],
Cell[78992, 3147, 78, 1, 35, 52, 0, "StyleData", "RefReturnLink", \
"CenteredPrintout"],
Cell[79073, 3150, 82, 1, 35, 56, 0, "StyleData", "RefReturnLink", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[79192, 3156, 272, 8, 24, 38, 0, "StyleData", "ReferenceSourceLink", \
"All",
 ButtonStyleMenuListing->None],
Cell[79467, 3166, 50, 0, 24, 50, 0, "StyleData", "ReferenceSourceLink", \
"Centered"],
Cell[79520, 3168, 76, 1, 35, 50, 0, "StyleData", "ReferenceSourceLink", \
"Printout"],
Cell[79599, 3171, 84, 1, 35, 58, 0, "StyleData", "ReferenceSourceLink", \
"CenteredPrintout"],
Cell[79686, 3174, 88, 1, 35, 62, 0, "StyleData", "ReferenceSourceLink", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[79789, 3178, 37, 0, 35, 37, 0, "StyleData", "ReferenceSourceURL", \
"All"],
Cell[CellGroupData[{
Cell[79851, 3182, 228, 6, 35, 27, 0, "StyleData", "Citation", "All",
 ButtonStyleMenuListing->None],
Cell[80082, 3190, 39, 0, 35, 39, 0, "StyleData", "Citation", "Centered"],
Cell[80124, 3192, 65, 1, 35, 39, 0, "StyleData", "Citation", "Printout"],
Cell[80192, 3195, 73, 1, 35, 47, 0, "StyleData", "Citation", \
"CenteredPrintout"],
Cell[80268, 3198, 77, 1, 35, 51, 0, "StyleData", "Citation", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[80382, 3204, 217, 6, 35, 25, 0, "StyleData", "RefKey", "All",
 ButtonStyleMenuListing->None],
Cell[80602, 3212, 229, 6, 35, 37, 0, "StyleData", "RefKey", "Centered",
 ButtonStyleMenuListing->None],
Cell[80834, 3220, 63, 1, 35, 37, 0, "StyleData", "RefKey", "Printout"],
Cell[80900, 3223, 71, 1, 35, 45, 0, "StyleData", "RefKey", \
"CenteredPrintout"],
Cell[80974, 3226, 75, 1, 35, 49, 0, "StyleData", "RefKey", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[81086, 3232, 73, 1, 27, "Subsubsubsection"],
Cell[81162, 3235, 83, 1, 20, "ReferenceTemplate"],
Cell[81248, 3238, 86, 1, 20, "ReferenceTemplate"],
Cell[81337, 3241, 86, 1, 20, "ReferenceTemplate"],
Cell[81426, 3244, 82, 1, 20, "ReferenceTemplate"],
Cell[81511, 3247, 85, 1, 20, "ReferenceTemplate"],
Cell[81599, 3250, 84, 1, 20, "ReferenceTemplate"],
Cell[81686, 3253, 43, 0, 20, "ReferenceTemplate"],
Cell[81732, 3255, 49, 0, 20, "ReferenceTemplate"],
Cell[81784, 3257, 49, 0, 20, "ReferenceTemplate"],
Cell[81836, 3259, 49, 0, 20, "ReferenceTemplate"],
Cell[81888, 3261, 49, 0, 20, "ReferenceTemplate"],
Cell[81940, 3263, 56, 0, 20, "ReferenceTemplate"],
Cell[81999, 3265, 56, 0, 20, "ReferenceTemplate"],
Cell[CellGroupData[{
Cell[82080, 3269, 48, 0, 42, "Subsubsubsubsection"],
Cell[82131, 3271, 191, 4, 33, "ReferenceTemplate"],
Cell[82325, 3277, 152, 3, 33, "ReferenceTemplate"],
Cell[82480, 3282, 177, 3, 33, "ReferenceTemplate"],
Cell[82660, 3287, 139, 3, 20, "ReferenceTemplate"],
Cell[82802, 3292, 172, 3, 33, "ReferenceTemplate"],
Cell[82977, 3297, 136, 3, 20, "ReferenceTemplate"],
Cell[83116, 3302, 159, 3, 33, "ReferenceTemplate"],
Cell[83278, 3307, 123, 3, 20, "ReferenceTemplate"],
Cell[83404, 3312, 185, 4, 33, "ReferenceTemplate"],
Cell[83592, 3318, 146, 3, 20, "ReferenceTemplate"],
Cell[83741, 3323, 171, 3, 33, "ReferenceTemplate"],
Cell[83915, 3328, 133, 3, 20, "ReferenceTemplate"],
Cell[84051, 3333, 166, 3, 33, "ReferenceTemplate"],
Cell[84220, 3338, 130, 3, 20, "ReferenceTemplate"],
Cell[84353, 3343, 153, 3, 33, "ReferenceTemplate"],
Cell[84509, 3348, 117, 3, 20, "ReferenceTemplate"],
Cell[84629, 3353, 176, 4, 33, "ReferenceTemplate"],
Cell[84808, 3359, 137, 3, 20, "ReferenceTemplate"],
Cell[84948, 3364, 162, 3, 33, "ReferenceTemplate"],
Cell[85113, 3369, 124, 3, 20, "ReferenceTemplate"],
Cell[85240, 3374, 157, 3, 33, "ReferenceTemplate"],
Cell[85400, 3379, 121, 3, 20, "ReferenceTemplate"],
Cell[85524, 3384, 144, 3, 20, "ReferenceTemplate"],
Cell[85671, 3389, 106, 2, 20, "ReferenceTemplate"],
Cell[85780, 3393, 146, 3, 57, "Text"],
Cell[85929, 3398, 152, 3, 33, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[86118, 3406, 48, 0, 42, "Subsubsubsubsection"],
Cell[86169, 3408, 99, 2, 42, "Text"],
Cell[86271, 3412, 144, 3, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[86452, 3420, 51, 0, 42, "Subsubsubsubsection"],
Cell[86506, 3422, 138, 3, 20, "ReferenceTemplate"],
Cell[86647, 3427, 99, 2, 20, "ReferenceTemplate"],
Cell[86749, 3431, 117, 3, 20, "ReferenceTemplate"],
Cell[86869, 3436, 143, 3, 57, "Text"],
Cell[87015, 3441, 85, 1, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[87137, 3447, 47, 0, 42, "Subsubsubsubsection"],
Cell[87187, 3449, 168, 3, 33, "ReferenceTemplate"],
Cell[87358, 3454, 133, 3, 20, "ReferenceTemplate"],
Cell[87494, 3459, 148, 3, 57, "Text"],
Cell[87645, 3464, 168, 3, 33, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[87850, 3472, 57, 0, 42, "Subsubsubsubsection"],
Cell[87910, 3474, 105, 3, 42, "Text"],
Cell[88018, 3479, 125, 3, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[88180, 3487, 54, 0, 42, "Subsubsubsubsection"],
Cell[88237, 3489, 107, 3, 42, "Text"],
Cell[88347, 3494, 105, 2, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[88489, 3501, 49, 0, 42, "Subsubsubsubsection"],
Cell[88541, 3503, 103, 3, 42, "Text"],
Cell[88647, 3508, 87, 1, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[88771, 3514, 55, 0, 42, "Subsubsubsubsection"],
Cell[88829, 3516, 127, 3, 42, "Text"],
Cell[88959, 3521, 58, 0, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[89054, 3526, 45, 0, 42, "Subsubsubsubsection"],
Cell[89102, 3528, 97, 2, 42, "Text"],
Cell[89202, 3532, 44, 0, 20, "ReferenceTemplate"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[89295, 3538, 77, 1, 27, "Subsubsubsection"],
Cell[89375, 3541, 49, 1, 35, 27, 0, "StyleData", "RefTitle", "All"],
Cell[89427, 3544, 46, 1, 20, 26, 0, "StyleData", "RefType", "All"],
Cell[89476, 3547, 25, 0, 35, 25, 0, "StyleData", "RefURL", "All"],
Cell[89504, 3549, 35, 0, 35, 35, 0, "StyleData", "RefRetrievalDate", "All"],
Cell[89542, 3551, 38, 0, 35, 38, 0, "StyleData", "RefSourceOfAbstract", \
"All"],
Cell[89583, 3553, 37, 0, 35, 37, 0, "StyleData", "RefInsertedBibText", \
"All"],
Cell[89623, 3555, 26, 0, 35, 26, 0, "StyleData", "RefNote", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[89686, 3560, 75, 1, 27, "Subsubsubsection"],
Cell[89764, 3563, 53, 1, 35, 31, 0, "StyleData", "RefBookTitle", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[89854, 3569, 78, 1, 27, "Subsubsubsection"],
Cell[89935, 3572, 34, 0, 35, 34, 0, "StyleData", "RefJournalTitle", "All"],
Cell[89972, 3574, 56, 1, 35, 35, 0, "StyleData", "RefJournalVolume", "All"],
Cell[90031, 3577, 35, 0, 35, 35, 0, "StyleData", "RefJournalNumber", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[90103, 3582, 80, 1, 27, "Subsubsubsection"],
Cell[90186, 3585, 31, 0, 35, 31, 0, "StyleData", "RefPublisher", "All"],
Cell[90220, 3587, 47, 1, 35, 26, 0, "StyleData", "RefCity", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[90304, 3593, 77, 1, 27, "Subsubsubsection"],
Cell[90384, 3596, 33, 0, 35, 33, 0, "StyleData", "RefAuthorGroup", "All"],
Cell[90420, 3598, 30, 0, 35, 30, 0, "StyleData", "RefAuthorFN", "All"],
Cell[90453, 3600, 30, 0, 35, 30, 0, "StyleData", "RefAuthorLN", "All"],
Cell[90486, 3602, 30, 0, 35, 30, 0, "StyleData", "RefAuthorMN", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[90553, 3607, 77, 1, 27, "Subsubsubsection"],
Cell[90633, 3610, 33, 0, 35, 33, 0, "StyleData", "RefEditorGroup", "All"],
Cell[90669, 3612, 30, 0, 35, 30, 0, "StyleData", "RefEditorFN", "All"],
Cell[90702, 3614, 30, 0, 35, 30, 0, "StyleData", "RefEditorMN", "All"],
Cell[90735, 3616, 30, 0, 35, 30, 0, "StyleData", "RefEditorLN", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[90802, 3621, 77, 1, 27, "Subsubsubsection"],
Cell[90882, 3624, 28, 0, 35, 28, 0, "StyleData", "RefSchool", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[90947, 3629, 87, 1, 27, "Subsubsubsection"],
Cell[91037, 3632, 25, 0, 35, 25, 0, "StyleData", "RefDay", "All"],
Cell[91065, 3634, 27, 0, 35, 27, 0, "StyleData", "RefMonth", "All"],
Cell[91095, 3636, 26, 0, 35, 26, 0, "StyleData", "RefYear", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[91158, 3641, 114, 2, 27, "Subsubsubsection"],
Cell[91275, 3645, 52, 1, 35, 31, 0, "StyleData", "RefFirstPage", "All"],
Cell[91330, 3648, 76, 2, 35, 30, 0, "StyleData", "RefLastPage", "All",
 StyleMenuListing->None]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[91467, 3657, 35, 0, 46, "Subsection"],
Cell[CellGroupData[{
Cell[91527, 3661, 32, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[91584, 3665, 626, 16, 107, 35, 0, "StyleData", "BookChapterLabel", "All",
 
 CounterIncrements->"BookChapterLabel",
 CounterAssignments->{{"Section", 0}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"EquationNumbered", 0}, {"FigureCaption", 0}, {
   "PictureCaption", 0}, {"ProgramCaption", 0}, {"TableTitle", 0}, {
   "Figure", 0}, {"Picture", 0}, {"Program", 0}, {"Table", 0}}],
Cell[92213, 3683, 165, 5, 103, 47, 0, "StyleData", "BookChapterLabel", \
"Centered"],
Cell[92381, 3690, 141, 4, 88, 47, 0, "StyleData", "BookChapterLabel", \
"Printout"],
Cell[92525, 3696, 149, 4, 88, 55, 0, "StyleData", "BookChapterLabel", \
"CenteredPrintout"],
Cell[92677, 3702, 107, 2, 88, 59, 0, "StyleData", "BookChapterLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[92821, 3709, 94, 3, 44, 36, 0, "StyleData", "BookChapterNumber", "All"],
Cell[92918, 3714, 106, 3, 44, 48, 0, "StyleData", "BookChapterNumber", \
"Centered"],
Cell[93027, 3719, 85, 2, 40, 48, 0, "StyleData", "BookChapterNumber", \
"Printout"],
Cell[93115, 3723, 93, 2, 40, 56, 0, "StyleData", "BookChapterNumber", \
"CenteredPrintout"],
Cell[93211, 3727, 75, 1, 40, 60, 0, "StyleData", "BookChapterNumber", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[93323, 3733, 373, 12, 144, 35, 0, "StyleData", "BookChapterTitle", "All",
 
 MenuPosition->1100],
Cell[93699, 3747, 165, 5, 152, 47, 0, "StyleData", "BookChapterTitle", \
"Centered"],
Cell[93867, 3754, 166, 5, 124, 47, 0, "StyleData", "BookChapterTitle", \
"Printout"],
Cell[94036, 3761, 174, 5, 124, 55, 0, "StyleData", "BookChapterTitle", \
"CenteredPrintout"],
Cell[94213, 3768, 130, 3, 124, 59, 0, "StyleData", "BookChapterTitle", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[94392, 3777, 58, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[94475, 3782, 171, 5, 51, 27, 0, "StyleData", "Epigraph", "All"],
Cell[94649, 3789, 39, 0, 51, 39, 0, "StyleData", "Epigraph", "Centered"],
Cell[94691, 3791, 89, 2, 47, 39, 0, "StyleData", "Epigraph", "Printout"],
Cell[94783, 3795, 97, 2, 47, 47, 0, "StyleData", "Epigraph", \
"CenteredPrintout"],
Cell[94883, 3799, 123, 3, 47, 51, 0, "StyleData", "Epigraph", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[95043, 3807, 133, 3, 63, 33, 0, "StyleData", "EpigraphAuthor", "All"],
Cell[95179, 3812, 45, 0, 63, 45, 0, "StyleData", "EpigraphAuthor", \
"Centered"],
Cell[95227, 3814, 96, 2, 57, 45, 0, "StyleData", "EpigraphAuthor", \
"Printout"],
Cell[95326, 3818, 104, 2, 57, 53, 0, "StyleData", "EpigraphAuthor", \
"CenteredPrintout"],
Cell[95433, 3822, 108, 2, 57, 57, 0, "StyleData", "EpigraphAuthor", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[95590, 3830, 40, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[95655, 3834, 311, 10, 155, 41, 0, "StyleData", "AcknowledgmentsSection", \
"All"],
Cell[95969, 3846, 171, 5, 152, 53, 0, "StyleData", "AcknowledgmentsSection", \
"Centered"],
Cell[96143, 3853, 172, 5, 124, 53, 0, "StyleData", "AcknowledgmentsSection", \
"Printout"],
Cell[96318, 3860, 180, 5, 124, 61, 0, "StyleData", "AcknowledgmentsSection", \
"CenteredPrintout"],
Cell[96501, 3867, 136, 3, 124, 65, 0, "StyleData", "AcknowledgmentsSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[96674, 3875, 272, 7, 29, 33, 0, "StyleData", "Acknowledgment", "All",
 CounterIncrements->"Acknowledgment",
 CounterAssignments->{{"Item1Numbered", 0}}],
Cell[96949, 3884, 45, 0, 29, 45, 0, "StyleData", "Acknowledgment", \
"Centered"],
Cell[96997, 3886, 114, 3, 26, 45, 0, "StyleData", "Acknowledgment", \
"Printout"],
Cell[97114, 3891, 122, 3, 26, 53, 0, "StyleData", "Acknowledgment", \
"CenteredPrintout"],
Cell[97239, 3896, 148, 4, 26, 57, 0, "StyleData", "Acknowledgment", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[97448, 3907, 41, 0, 46, "Subsection"],
Cell[97492, 3909, 94, 3, 32, 25, 0, "StyleData", "Header", "All"],
Cell[97589, 3914, 93, 3, 30, 25, 0, "StyleData", "Footer", "All"],
Cell[97685, 3919, 76, 2, 32, 29, 0, "StyleData", "PageNumber", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[97798, 3926, 35, 0, 30, "Subsection"],
Cell[97836, 3928, 83, 2, 35, 34, 0, "StyleData", "TextSuperscript", "All"],
Cell[97922, 3932, 81, 2, 35, 32, 0, "StyleData", "TextSubscript", "All"],
Cell[98006, 3936, 22, 0, 35, 22, 0, "StyleData", "Nil", "All"],
Cell[98031, 3938, 27, 0, 35, 27, 0, "StyleData", "Verbatim", "All"],
Cell[98061, 3940, 103, 2, 35, 26, 0, "StyleData", "TeXName", "All"],
Cell[98167, 3944, 107, 2, 35, 28, 0, "StyleData", "LaTeXName", "All"],
Cell[98277, 3948, 109, 2, 35, 29, 0, "StyleData", "LaTeXeName", "All"],
Cell[98389, 3952, 86, 2, 35, 34, 0, "StyleData", "ChemicalElement", "All"],
Cell[98478, 3956, 63, 1, 35, 34, 0, "StyleData", "CustomCharacter", "All"],
Cell[98544, 3959, 26, 0, 35, 26, 0, "StyleData", "Palette", "All"],
Cell[CellGroupData[{
Cell[98595, 3963, 387, 13, 7, 28, 0, "StyleData", "PageBreak", "All"],
Cell[98985, 3978, 116, 3, 12, 40, 0, "StyleData", "PageBreak", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[99138, 3986, 147, 5, 51, 31, 0, "StyleData", "CreationDate", "All"],
Cell[99288, 3993, 111, 3, 23, 43, 0, "StyleData", "CreationDate", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[99436, 4001, 42, 0, 29, "Subsubsection"],
Cell[CellGroupData[{
Cell[99503, 4005, 121, 3, 19, 29, 0, "StyleData", "SingleLine", "All"],
Cell[99627, 4010, 133, 3, 19, 41, 0, "StyleData", "SingleLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[99797, 4018, 230, 7, 21, 29, 0, "StyleData", "DoubleLine", "All"],
Cell[100030, 4027, 88, 2, 19, 41, 0, "StyleData", "DoubleLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[100155, 4034, 253, 8, 12, 27, 0, "StyleData", "ThinLine", "All"],
Cell[100411, 4044, 39, 0, 12, 39, 0, "StyleData", "ThinLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[100487, 4049, 253, 8, 14, 29, 0, "StyleData", "MediumLine", "All"],
Cell[100743, 4059, 41, 0, 14, 41, 0, "StyleData", "MediumLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[100821, 4064, 252, 8, 15, 28, 0, "StyleData", "ThickLine", "All"],
Cell[101076, 4074, 40, 0, 15, 40, 0, "StyleData", "ThickLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[101153, 4079, 73, 1, 35, 25, 0, "StyleData", "Spacer", "All"],
Cell[101229, 4082, 37, 0, 35, 37, 0, "StyleData", "Spacer", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[101303, 4087, 29, 0, 35, 29, 0, "StyleData", "TextSpacer", "All"],
Cell[101335, 4089, 41, 0, 35, 41, 0, "StyleData", "TextSpacer", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[101413, 4094, 32, 0, 35, 32, 0, "StyleData", "SectionSpacer", "All"],
Cell[101448, 4096, 44, 0, 35, 44, 0, "StyleData", "SectionSpacer", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[101529, 4101, 33, 0, 35, 33, 0, "StyleData", "GraphicsSpacer", "All"],
Cell[101565, 4103, 45, 0, 35, 45, 0, "StyleData", "GraphicsSpacer", \
"Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[101659, 4109, 32, 0, 29, "Subsubsection"],
Cell[CellGroupData[{
Cell[101716, 4113, 447, 12, 47, 27, 0, "StyleData", "Outline1", "All",
 CounterIncrements->"Outline1",
 CounterAssignments->{{"Outline2", 0}}],
Cell[102166, 4127, 86, 2, 43, 39, 0, "StyleData", "Outline1", "Printout"],
Cell[102255, 4131, 98, 2, 43, 51, 0, "StyleData", "Outline1", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[102390, 4138, 104, 3, 35, 32, 0, "StyleData", "Outline1Label", "All"],
Cell[102497, 4143, 72, 1, 35, 44, 0, "StyleData", "Outline1Label", \
"Printout"],
Cell[102572, 4146, 84, 1, 35, 56, 0, "StyleData", "Outline1Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[102693, 4152, 469, 13, 45, 27, 0, "StyleData", "Outline2", "All",
 CounterIncrements->"Outline2",
 CounterAssignments->{{"Outline3", 0}}],
Cell[103165, 4167, 87, 2, 41, 39, 0, "StyleData", "Outline2", "Printout"],
Cell[103255, 4171, 99, 2, 41, 51, 0, "StyleData", "Outline2", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[103391, 4178, 104, 3, 35, 32, 0, "StyleData", "Outline2Label", "All"],
Cell[103498, 4183, 72, 1, 35, 44, 0, "StyleData", "Outline2Label", \
"Printout"],
Cell[103573, 4186, 84, 1, 35, 56, 0, "StyleData", "Outline2Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[103694, 4192, 415, 11, 43, 27, 0, "StyleData", "Outline3", "All",
 CounterIncrements->"Outline3",
 CounterAssignments->{{"Outline4", 0}}],
Cell[104112, 4205, 87, 2, 39, 39, 0, "StyleData", "Outline3", "Printout"],
Cell[104202, 4209, 99, 2, 39, 51, 0, "StyleData", "Outline3", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[104338, 4216, 104, 3, 35, 32, 0, "StyleData", "Outline3Label", "All"],
Cell[104445, 4221, 72, 1, 35, 44, 0, "StyleData", "Outline3Label", \
"Printout"],
Cell[104520, 4224, 84, 1, 35, 56, 0, "StyleData", "Outline3Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[104641, 4230, 393, 10, 41, 27, 0, "StyleData", "Outline4", "All",
 CounterIncrements->"Outline4"],
Cell[105037, 4242, 87, 2, 38, 39, 0, "StyleData", "Outline4", "Printout"],
Cell[105127, 4246, 99, 2, 38, 51, 0, "StyleData", "Outline4", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[105263, 4253, 104, 3, 35, 32, 0, "StyleData", "Outline4Label", "All"],
Cell[105370, 4258, 72, 1, 35, 44, 0, "StyleData", "Outline4Label", \
"Printout"],
Cell[105445, 4261, 84, 1, 35, 56, 0, "StyleData", "Outline4Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[105566, 4267, 136, 4, 35, 30, 0, "StyleData", "OutlineText", "All",
 CounterIncrements->"Text"],
Cell[105705, 4273, 135, 4, 32, 42, 0, "StyleData", "OutlineText", \
"Printout"],
Cell[105843, 4279, 147, 4, 32, 54, 0, "StyleData", "OutlineText", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[106039, 4289, 35, 0, 29, "Subsubsection"],
Cell[CellGroupData[{
Cell[106099, 4293, 1077, 29, 11, 41, 0, "StyleData", \
"SlideShowNavigationBar", "All",
 CounterIncrements->"SlideShowNavigationBar",
 CounterAssignments->{{"Item1Numbered", 0}}],
Cell[107179, 4324, 193, 5, 25, 53, 0, "StyleData", "SlideShowNavigationBar", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[107409, 4334, 285, 9, 49, 33, 0, "StyleData", "SlideHyperlink", "All",
 ButtonStyleMenuListing->None],
Cell[107697, 4345, 115, 2, 35, 45, 0, "StyleData", "SlideHyperlink", \
"Printout"],
Cell[107815, 4349, 123, 2, 35, 53, 0, "StyleData", "SlideHyperlink", \
"CenteredPrintout"],
Cell[107941, 4353, 127, 2, 35, 57, 0, "StyleData", "SlideHyperlink", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[108129, 4362, 35, 0, 46, "Subsection"],
Cell[CellGroupData[{
Cell[108189, 4366, 73, 1, 45, "Subsubsection"],
Cell[108265, 4369, 64, 2, 35, 21, 0, "StyleData", "RM", "All"],
Cell[108332, 4373, 42, 1, 35, 21, 0, "StyleData", "BF", "All"],
Cell[108377, 4376, 43, 1, 35, 21, 0, "StyleData", "IT", "All"],
Cell[108423, 4379, 49, 1, 31, 28, 0, "StyleData", "SmallCaps", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[108509, 4385, 79, 1, 29, "Subsubsection"],
Cell[108591, 4388, 86, 3, 35, 21, 0, "StyleData", "TR", "All"],
Cell[108680, 4393, 87, 3, 35, 21, 0, "StyleData", "TI", "All"],
Cell[108770, 4398, 85, 3, 35, 21, 0, "StyleData", "TB", "All"],
Cell[108858, 4403, 87, 3, 35, 22, 0, "StyleData", "TBI", "All"],
Cell[108948, 4408, 174, 5, 36, 21, 0, "StyleData", "MR", "All"],
Cell[109125, 4415, 175, 5, 36, 21, 0, "StyleData", "MO", "All"],
Cell[109303, 4422, 173, 5, 36, 21, 0, "StyleData", "MB", "All"],
Cell[109479, 4429, 175, 5, 36, 22, 0, "StyleData", "MBO", "All"],
Cell[109657, 4436, 90, 3, 35, 21, 0, "StyleData", "SR", "All"],
Cell[109750, 4441, 91, 3, 36, 21, 0, "StyleData", "SO", "All"],
Cell[109844, 4446, 89, 3, 36, 21, 0, "StyleData", "SB", "All"],
Cell[109936, 4451, 91, 3, 36, 22, 0, "StyleData", "SBO", "All"],
Cell[110030, 4456, 63, 1, 35, 32, 0, "StyleData", "PlainGreekWin", "All"],
Cell[110096, 4459, 55, 1, 39, 32, 0, "StyleData", "PlainGreekMac", "All"],
Cell[110154, 4462, 55, 1, 39, 32, 0, "StyleData", "PlainGreekLin", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[110246, 4468, 35, 0, 29, "Subsubsection"],
Cell[CellGroupData[{
Cell[110306, 4472, 262, 7, 35, 28, 0, "StyleData", "Hyperlink", "All",
 ButtonStyleMenuListing->None],
Cell[110571, 4481, 120, 3, 34, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[110728, 4489, 263, 7, 35, 29, 0, "StyleData", "XMLWebLink", "All",
 ButtonStyleMenuListing->None],
Cell[110994, 4498, 106, 2, 35, 41, 0, "StyleData", "XMLWebLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[111137, 4505, 53, 0, 43, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[111215, 4509, 278, 7, 35, 32, 0, "StyleData", "UserGuideLink", "All",
 ButtonStyleMenuListing->None],
Cell[111496, 4518, 109, 2, 35, 44, 0, "StyleData", "UserGuideLink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[111642, 4525, 278, 7, 35, 32, 0, "StyleData", "ReferenceLink", "All",
 ButtonStyleMenuListing->None],
Cell[111923, 4534, 109, 2, 35, 44, 0, "StyleData", "ReferenceLink", \
"Printout"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[112105, 4544, 28, 0, 46, "Subsection"],
Cell[CellGroupData[{
Cell[112158, 4548, 67, 1, 45, "Subsubsection"],
Cell[112228, 4551, 304, 7, 117, "Text"],
Cell[112535, 4560, 290, 9, 52, 33, 0, "StyleData", "CellExpression", "All"],
Cell[112828, 4571, 78, 2, 36, 28, 0, "StyleData", "InputForm", "All"],
Cell[112909, 4575, 132, 4, 41, 29, 0, "StyleData", "OutputForm", "All"],
Cell[113044, 4581, 80, 2, 36, 31, 0, "StyleData", "StandardForm", "All"],
Cell[113127, 4585, 149, 4, 35, 34, 0, "StyleData", "TraditionalForm", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[113313, 4594, 56, 0, 45, "Subsubsection"],
Cell[113372, 4596, 122, 3, 42, 36, 0, "StyleData", "ReferenceTemplate", \
"All"],
Cell[113497, 4601, 136, 3, 42, 50, 0, "StyleData", \
"AuthorFormCustomizationTemplate", "All"],
Cell[113636, 4606, 119, 3, 42, 33, 0, "StyleData", "CSSDefinitions", "All"],
Cell[113758, 4611, 118, 3, 42, 32, 0, "StyleData", "LaTeXPreamble", "All"],
Cell[113879, 4616, 118, 3, 42, 32, 0, "StyleData", "DOCTYPEFormat", "All"],
Cell[114000, 4621, 122, 3, 42, 36, 0, "StyleData", "ValidationSetting", \
"All"],
Cell[114125, 4626, 124, 3, 42, 38, 0, "StyleData", "XRefPaletteSettings", \
"All"],
Cell[114252, 4631, 117, 3, 42, 31, 0, "StyleData", "MiscSettings", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[114406, 4639, 62, 1, 45, "Subsubsection"],
Cell[114471, 4642, 116, 5, 87, "Text"],
Cell[114590, 4649, 84, 2, 35, 29, 0, "StyleData", "InlineCell", "All"],
Cell[114677, 4653, 89, 1, 51, 36, 0, "StyleData", "InlineCellEditing", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[114803, 4659, 57, 1, 45, "Subsubsection"],
Cell[114863, 4662, 122, 5, 87, "Text"],
Cell[114988, 4669, 191, 4, 39, 24, 0, "StyleData", "Paste", "All",
 ButtonStyleMenuListing->Automatic],
Cell[115182, 4675, 161, 3, 35, 29, 0, "StyleData", "StyleApply", "All",
 ButtonStyleMenuListing->Automatic],
Cell[115346, 4680, 218, 5, 35, 45, 0, "StyleData", \
"StyleApplyWithVerification", "All",
 ButtonStyleMenuListing->Automatic],
Cell[115567, 4687, 136, 3, 35, 35, 0, "StyleData", "ConvertCharacter", "All",
 ButtonStyleMenuListing->Automatic]
}, Closed]],
Cell[CellGroupData[{
Cell[115740, 4695, 59, 1, 45, "Subsubsection"],
Cell[115802, 4698, 330, 9, 132, "Text"],
Cell[116135, 4709, 82, 1, 35, 35, 0, "StyleData", "UnmatchedBracket", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[116254, 4715, 63, 1, 45, "Subsubsection"],
Cell[116320, 4718, 159, 4, 2067, 55, 0, "StyleData", \
"DialogStyleSheetMisapplicationEscape", "All"]
}, Closed]]
}, Closed]]
}, Closed]]
}
]
*)

(* End of internal cache information *)
