(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     43792,       1424]
NotebookOptionsPosition[     29962,       1101]
NotebookOutlinePosition[     30304,       1117]
CellTagsIndexPosition[     30261,       1114]
MenuPosition->0
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Title"],

Cell["\<\
Modify the definitions below to change the default appearance of all cells in \
a given style.  Make modifications to any definition using commands in the \
Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
 PageWidth->WindowWidth,
 ShowAutoStyles->False,
 ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
 PageWidth->WindowWidth,
 ShowAutoStyles->False,
 ScriptMinSize->9],

Cell[StyleData[All, "SansSerif"],
 PageWidth->WindowWidth,
 ShowAutoStyles->False,
 ScriptMinSize->7,
 FontFamily->"Helvetica",
 FontSize->10],

Cell[StyleData[All, "Printout"],
 PageWidth->PaperWidth,
 ShowAutoStyles->False,
 ScriptMinSize->7,
 FontSize->10,
 PrivateFontOptions->{"FontType"->"Outline"}],

Cell[StyleData[All, "SansSerifPrintout"],
 PageWidth->PaperWidth,
 ShowAutoStyles->False,
 ScriptMinSize->5,
 FontFamily->"Helvetica",
 FontSize->8,
 PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
 PageHeaders->{{
    Cell[
     TextData[{
       CounterBox["Page"]}], "PageNumber"], None, 
    Cell[
     TextData[{
       ValueBox["FileName"]}], "Header"]}, {
    Cell[
     TextData[{
       ValueBox["FileName"]}], "Header"], None, 
    Cell[
     TextData[{
       CounterBox["Page"]}], "PageNumber"]}},
 CellFrameLabelMargins->6,
 DefaultNewCellStyle->"Text",
 DefaultDuplicateCellStyle->"Text",
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["H1"],
 CellMargins->{{12, Inherited}, {20, 40}},
 CellGroupingRules->{"TitleGrouping", 0},
 ConversionRules:>{
  "HTML" -> {{"<span class='H1'>", "</span>"}, {"<h1 class='H1'>", "</h1>"}}},
 
 PageBreakBelow->False,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 LineSpacing->{1, 13},
 CounterIncrements->"H1",
 CounterAssignments->{{"H2", 0}, {"H3", 0}, {"Equation", 0}, {"Figure", 0}, {
   "H4", 0}, {"H5", 0}, {"H6", 0}},
 FontSize->36,
 FontWeight->"Bold"],

Cell[StyleData["H1", "Presentation"],
 CellMargins->{{18, 10}, {40, 62}},
 FontSize->54],

Cell[StyleData["H1", "SansSerif"],
 FontSize->30,
 FontWeight->"Bold"],

Cell[StyleData["H1", "Printout"],
 CellMargins->{{2, 10}, {15, 30}},
 FontSize->30],

Cell[StyleData["H1", "SansSerifPrintout"],
 CellMargins->{{2, 10}, {15, 30}},
 FontSize->26]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["H2"],
 CellMargins->{{12, Inherited}, {10, 15}},
 CellGroupingRules->{"TitleGrouping", 10},
 ConversionRules:>{
  "HTML" -> {{"<span class='H2'>", "</span>"}, {"<h2 class='H2'>", "</h2>"}}},
 
 PageBreakBelow->False,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"H2",
 CounterAssignments->{{"H3", 0}, {"H4", 0}, {"Equation", 0}, {"Figure", 0}, {
   "H5", 0}, {"H6", 0}},
 FontSize->24,
 FontWeight->"Bold"],

Cell[StyleData["H2", "Presentation"],
 CellMargins->{{18, 10}, {24, 18}},
 FontSize->36],

Cell[StyleData["H2", "SansSerif"],
 FontSize->20],

Cell[StyleData["H2", "Printout"],
 CellMargins->{{2, 10}, {10, 15}},
 FontSize->20],

Cell[StyleData["H2", "SansSerifPrintout"],
 CellMargins->{{2, 10}, {10, 15}},
 FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["H3"],
 CellMargins->{{12, Inherited}, {10, 20}},
 CellGroupingRules->{"TitleGrouping", 20},
 ConversionRules:>{
  "HTML" -> {{"<span class='H3'>", "</span>"}, {"<h3 class='H3'>", "</h3>"}}},
 
 PageBreakBelow->False,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"H3",
 CounterAssignments->{{"H4", 0}, {"H5", 0}, {"Equation", 0}, {"Figure", 0}, {
   "H6", 0}},
 FontSize->18,
 FontWeight->"Bold"],

Cell[StyleData["H3", "Presentation"],
 CellMargins->{{18, 10}, {20, 22}},
 FontSize->27],

Cell[StyleData["H3", "SansSerif"],
 FontSize->16],

Cell[StyleData["H3", "Printout"],
 CellMargins->{{2, 10}, {8, 10}},
 FontSize->16],

Cell[StyleData["H3", "SansSerifPrintout"],
 CellMargins->{{2, 10}, {8, 10}},
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["H4"],
 CellMargins->{{12, Inherited}, {10, 20}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{
  "HTML" -> {{"<span class='H4'>", "</span>"}, {"<h4 class='H4'>", "</h4>"}}},
 
 PageBreakBelow->False,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"H4",
 CounterAssignments->{{"H5", 0}, {"H6", 0}, {"Equation", 0}, {"Figure", 0}},
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["H4", "Presentation"],
 CellMargins->{{16, 10}, {18, 22}},
 FontSize->21],

Cell[StyleData["H4", "SansSerif"],
 FontSize->12],

Cell[StyleData["H4", "Printout"],
 CellMargins->{{2, 10}, {8, 10}},
 FontSize->12],

Cell[StyleData["H4", "SansSerifPrintout"],
 CellMargins->{{2, 10}, {8, 10}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["H5"],
 CellMargins->{{12, Inherited}, {10, 20}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{
  "HTML" -> {{"<span class='H5'>", "</span>"}, {"<h5 class='H5'>", "</h5>"}}},
 
 PageBreakBelow->False,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"H5",
 CounterAssignments->{{"H6", 0}},
 FontWeight->"Bold"],

Cell[StyleData["H5", "Presentation"],
 CellMargins->{{18, 10}, {20, 26}},
 FontSize->18],

Cell[StyleData["H5", "SansSerif"]],

Cell[StyleData["H5", "Printout"],
 CellMargins->{{2, 10}, {8, 10}}],

Cell[StyleData["H5", "SansSerifPrintout"],
 CellMargins->{{2, 10}, {8, 10}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["H6"],
 CellMargins->{{12, Inherited}, {10, 20}},
 CellGroupingRules->{"SectionGrouping", 50},
 ConversionRules:>{
  "HTML" -> {{"<span class='H6'>", "</span>"}, {"<h6 class='H6'>", "</h6>"}}},
 
 PageBreakBelow->False,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"H6",
 FontSize->10,
 FontWeight->"Bold"],

Cell[StyleData["H6", "Presentation"],
 CellMargins->{{18, 10}, {20, 26}},
 FontSize->15],

Cell[StyleData["H6", "SansSerif"],
 FontSize->9,
 FontTracking->"Extended"],

Cell[StyleData["H6", "Printout"],
 CellMargins->{{2, 10}, {8, 10}},
 FontSize->8.5],

Cell[StyleData["H6", "SansSerifPrintout"],
 CellMargins->{{2, 10}, {8, 10}},
 FontSize->7.5]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Body"],
 CellMargins->{{14, 10}, {7, 7}},
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 LineSpacing->{1, 3},
 CounterIncrements->"Body"],

Cell[StyleData["Body", "Presentation"],
 CellMargins->{{20, 10}, {10, 10}},
 FontSize->18],

Cell[StyleData["Body", "SansSerif"]],

Cell[StyleData["Body", "Printout"],
 CellMargins->{{2, 2}, {6, 6}}],

Cell[StyleData["Body", "SansSerifPrintout"],
 CellMargins->{{2, 2}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["LI"],
 CellDingbat->"\[FilledSmallCircle]",
 CellMargins->{{23, 10}, {7, 7}},
 ConversionRules:>{
  "HTML" -> {{"<span class='LI'>", "</span>"}, {
     "<ul class='LI'><li class='LI'>", "</li></ul>"}}},
 LineSpacing->{1, 3},
 CounterIncrements->"LI"],

Cell[StyleData["LI", "Presentation"],
 CellMargins->{{32, 10}, {10, 10}},
 FontSize->18],

Cell[StyleData["LI", "SansSerif"],
 CellMargins->{{25, 10}, {7, 7}}],

Cell[StyleData["LI", "Printout"],
 CellMargins->{{12, 2}, {6, 6}}],

Cell[StyleData["LI", "SansSerifPrintout"],
 CellMargins->{{12, 2}, {6, 6}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output to the \
kernel.  Be careful when modifying, renaming, or removing these styles, \
because the front end associates special meanings with these style names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
 CellMargins->{{45, 10}, {5, 7}},
 Evaluatable->True,
 CellGroupingRules->"InputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultInputFormatType,
 ShowAutoStyles->True,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->"Formula",
 FormatType->InputForm,
 ShowStringCharacters->True,
 NumberMarks->True,
 LinebreakAdjustments->{0.85, 2, 10, 0, 1},
 CounterIncrements->"Input",
 FontWeight->"Bold"],

Cell[StyleData["Input", "Presentation"],
 CellMargins->{{64, 10}, {6, 10}},
 FontSize->18],

Cell[StyleData["Input", "SansSerif"],
 FontSize->12],

Cell[StyleData["Input", "Printout"],
 CellMargins->{{39, 0}, {4, 6}},
 LinebreakAdjustments->{0.85, 2, 10, 1, 1},
 FontSize->9],

Cell[StyleData["Input", "SansSerifPrintout"],
 CellMargins->{{39, 0}, {4, 6}},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
 CellMargins->{{47, 10}, {7, 5}},
 CellEditDuplicate->True,
 CellGroupingRules->"OutputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultOutputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->"Formula",
 FormatType->InputForm,
 CounterIncrements->"Output"],

Cell[StyleData["Output", "Presentation"],
 CellMargins->{{66, 10}, {10, 6}},
 FontSize->18],

Cell[StyleData["Output", "SansSerif"],
 FontSize->12],

Cell[StyleData["Output", "Printout"],
 CellMargins->{{39, 0}, {6, 4}},
 FontSize->9],

Cell[StyleData["Output", "SansSerifPrintout"],
 CellMargins->{{39, 0}, {6, 4}},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
 CellMargins->{{45, Inherited}, {Inherited, Inherited}},
 CellGroupingRules->"OutputGrouping",
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultOutputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 AutoStyleOptions->{"SyntaxErrorStyle"->None},
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 FormatType->InputForm,
 CounterIncrements->"Message",
 StyleMenuListing->None,
 FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Message", "Presentation"],
 CellMargins->{{64, 10}, {6, 6}},
 FontSize->18],

Cell[StyleData["Message", "SansSerif"],
 FontSize->12],

Cell[StyleData["Message", "Printout"],
 CellMargins->{{39, Inherited}, {Inherited, Inherited}},
 FontSize->8,
 FontColor->GrayLevel[0]],

Cell[StyleData["Message", "SansSerifPrintout"],
 CellMargins->{{39, Inherited}, {Inherited, Inherited}},
 FontSize->8,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
 CellMargins->{{45, Inherited}, {Inherited, Inherited}},
 CellGroupingRules->"OutputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultOutputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 FormatType->InputForm,
 CounterIncrements->"Print",
 StyleMenuListing->None],

Cell[StyleData["Print", "Presentation"],
 CellMargins->{{64, 10}, {6, 6}},
 FontSize->18],

Cell[StyleData["Print", "SansSerif"],
 FontSize->12],

Cell[StyleData["Print", "Printout"],
 CellMargins->{{39, Inherited}, {Inherited, Inherited}},
 FontSize->8],

Cell[StyleData["Print", "SansSerifPrintout"],
 CellMargins->{{39, Inherited}, {Inherited, Inherited}},
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
 CellMargins->{{45, Inherited}, {Inherited, Inherited}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 DefaultFormatType->DefaultOutputFormatType,
 FormatType->InputForm,
 CounterIncrements->"Graphics",
 ImageMargins->{{43, Inherited}, {Inherited, 0}},
 StyleMenuListing->None],

Cell[StyleData["Graphics", "Presentation"],
 CellMargins->{{64, 10}, {6, 6}},
 FontSize->18],

Cell[StyleData["Graphics", "SansSerif"],
 FontSize->12],

Cell[StyleData["Graphics", "Printout"],
 CellMargins->{{39, Inherited}, {Inherited, Inherited}},
 ImageSize->{250, 250},
 FontSize->9],

Cell[StyleData["Graphics", "SansSerifPrintout"],
 CellMargins->{{39, Inherited}, {Inherited, Inherited}},
 ImageSize->{250, 250},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9,
 FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["CellLabel", "Presentation"],
 FontSize->14],

Cell[StyleData["CellLabel", "SansSerif"]],

Cell[StyleData["CellLabel", "Printout"],
 FontFamily->"Courier",
 FontSize->8,
 FontSlant->"Italic",
 FontColor->GrayLevel[0]],

Cell[StyleData["CellLabel", "SansSerifPrintout"],
 FontSize->7,
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Formatting", "Section"],

Cell["\<\
These styles are for modifying individual words or letters in a cell \
exclusive of the cell tag.\
\>", "Text"],

Cell[StyleData["RM"],
 StyleMenuListing->None,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["BF"],
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["IT"],
 StyleMenuListing->None,
 FontSlant->"Italic"],

Cell[StyleData["TR"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["TI"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["TB"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["TBI"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["MR"],
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["MO"],
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["MB"],
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["MBO"],
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["SR"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SO"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["SB"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["SBO"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[StyleData["SO10"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["SO10", "Printout"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->7,
 FontWeight->"Plain",
 FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Inert"],
 StyleMenuListing->None,
 Background->RGBColor[0.870588235294118, 0.905882352941176, 0.972549019607843]
  ],

Cell[StyleData["Inert", "Printout"],
 StyleMenuListing->None,
 Background->GrayLevel[1]]
}, Closed]],

Cell[StyleData["Small"],
 StyleMenuListing->None,
 FontSize->9],

Cell[StyleData["Medium"],
 StyleMenuListing->None,
 FontSize->12],

Cell[StyleData["Large"],
 StyleMenuListing->None,
 FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext ButtonBoxes.  The \
\"Hyperlink\" style is for links within the same Notebook, or between \
Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "SansSerif"]],

Cell[StyleData["Hyperlink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["Hyperlink", "SansSerifPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line help \
system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["MainBook", #]}]& )}],

Cell[StyleData["MainBookLink", "SansSerif"]],

Cell[StyleData["MainBookLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["MainBookLink", "SansSerifPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Courier",
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["AddOns", #]}]& )}],

Cell[StyleData["AddOnsLink", "SansSerif"]],

Cell[StyleData["AddOnLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["AddOnLink", "SansSerifPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Courier",
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["RefGuideLink", #]}]& )}],

Cell[StyleData["RefGuideLink", "SansSerif"]],

Cell[StyleData["RefGuideLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["RefGuideLink", "SansSerifPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["GettingStarted", #]}]& )}],

Cell[StyleData["GettingStartedLink", "SansSerif"]],

Cell[StyleData["GettingStartedLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["GettingStartedLink", "SansSerifPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["OtherInformation", #]}]& )}],

Cell[StyleData["OtherInformationLink", "SansSerif"]],

Cell[StyleData["OtherInformationLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["OtherInformationLink", "SansSerifPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DemosLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["Demos", #]}]& )}],

Cell[StyleData["DemosLink", "Printout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TourLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["Tour", #]}]& )}],

Cell[StyleData["TourLink", "Printout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MasterIndexLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["MasterIndex", #]}]& )}],

Cell[StyleData["MasterIndexLink", "Printout"],
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, for use \
in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, After]}]& )}],

Cell[StyleData["Evaluate"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionEvaluate[
     FrontEnd`InputNotebook[], All]}]& )}],

Cell[StyleData["EvaluateCell"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionMove[
     FrontEnd`InputNotebook[], All, Cell, 1], 
    FrontEnd`SelectionEvaluateCreateCell[
     FrontEnd`InputNotebook[], All]}]& )}],

Cell[StyleData["CopyEvaluate"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionCreateCell[
     FrontEnd`InputNotebook[], All], 
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionEvaluate[
     FrontEnd`InputNotebook[], All]}]& )}],

Cell[StyleData["CopyEvaluateCell"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionCreateCell[
     FrontEnd`InputNotebook[], All], 
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionEvaluateCreateCell[
     FrontEnd`InputNotebook[], All]}]& )}]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit)",
WindowSize->{500, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
MenuPosition->None,
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[606, 24, 34, 0, 76, "Title"],
Cell[643, 26, 193, 4, 56, "Text"],
Cell[CellGroupData[{
Cell[861, 34, 42, 0, 67, "Section"],
Cell[906, 36, 99, 3, 70, 31, 0, "StyleData", "All", "Working"],
Cell[1008, 41, 104, 3, 70, 36, 0, "StyleData", "All", "Presentation"],
Cell[1115, 46, 142, 5, 70, 33, 0, "StyleData", "All", "SansSerif"],
Cell[1260, 53, 160, 5, 70, 32, 0, "StyleData", "All", "Printout"],
Cell[1423, 60, 194, 6, 70, 41, 0, "StyleData", "All", "SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[1654, 71, 35, 0, 37, "Section"],
Cell[1692, 73, 99, 2, 70, "Text"],
Cell[1794, 77, 457, 17, 70, 27, 0, "StyleData", "Notebook", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[2288, 99, 38, 0, 37, "Section"],
Cell[CellGroupData[{
Cell[2351, 103, 1397, 35, 70, 21, 0, "StyleData", "H1", "All",
 CounterIncrements->"H1",
 CounterAssignments->{{"H2", 0}, {"H3", 0}, {"Equation", 0}, {"Figure", 0}, {
   "H4", 0}, {"H5", 0}, {"H6", 0}}],
Cell[3751, 140, 88, 2, 70, 37, 0, "StyleData", "H1", "Presentation"],
Cell[3842, 144, 70, 2, 70, 34, 0, "StyleData", "H1", "SansSerif"],
Cell[3915, 148, 83, 2, 70, 33, 0, "StyleData", "H1", "Printout"],
Cell[4001, 152, 92, 2, 70, 42, 0, "StyleData", "H1", "SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[4130, 159, 1364, 34, 70, 21, 0, "StyleData", "H2", "All",
 CounterIncrements->"H2",
 CounterAssignments->{{"H3", 0}, {"H4", 0}, {"Equation", 0}, {"Figure", 0}, {
   "H5", 0}, {"H6", 0}}],
Cell[5497, 195, 88, 2, 70, 37, 0, "StyleData", "H2", "Presentation"],
Cell[5588, 199, 49, 1, 70, 34, 0, "StyleData", "H2", "SansSerif"],
Cell[5640, 202, 83, 2, 70, 33, 0, "StyleData", "H2", "Printout"],
Cell[5726, 206, 92, 2, 70, 42, 0, "StyleData", "H2", "SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[5855, 213, 1353, 34, 70, 21, 0, "StyleData", "H3", "All",
 CounterIncrements->"H3",
 CounterAssignments->{{"H4", 0}, {"H5", 0}, {"Equation", 0}, {"Figure", 0}, {
   "H6", 0}}],
Cell[7211, 249, 88, 2, 70, 37, 0, "StyleData", "H3", "Presentation"],
Cell[7302, 253, 49, 1, 70, 34, 0, "StyleData", "H3", "SansSerif"],
Cell[7354, 256, 82, 2, 70, 33, 0, "StyleData", "H3", "Printout"],
Cell[7439, 260, 91, 2, 70, 42, 0, "StyleData", "H3", "SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[7567, 267, 1340, 33, 70, 21, 0, "StyleData", "H4", "All",
 CounterIncrements->"H4",
 CounterAssignments->{{"H5", 0}, {"H6", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[8910, 302, 88, 2, 70, 37, 0, "StyleData", "H4", "Presentation"],
Cell[9001, 306, 49, 1, 70, 34, 0, "StyleData", "H4", "SansSerif"],
Cell[9053, 309, 82, 2, 70, 33, 0, "StyleData", "H4", "Printout"],
Cell[9138, 313, 91, 2, 70, 42, 0, "StyleData", "H4", "SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[9266, 320, 1282, 32, 70, 21, 0, "StyleData", "H5", "All",
 CounterIncrements->"H5",
 CounterAssignments->{{"H6", 0}}],
Cell[10551, 354, 88, 2, 70, 37, 0, "StyleData", "H5", "Presentation"],
Cell[10642, 358, 34, 0, 70, 34, 0, "StyleData", "H5", "SansSerif"],
Cell[10679, 360, 67, 1, 70, 33, 0, "StyleData", "H5", "Printout"],
Cell[10749, 363, 76, 1, 70, 42, 0, "StyleData", "H5", "SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[10862, 369, 1263, 32, 70, 21, 0, "StyleData", "H6", "All",
 CounterIncrements->"H6"],
Cell[12128, 403, 88, 2, 70, 37, 0, "StyleData", "H6", "Presentation"],
Cell[12219, 407, 75, 2, 70, 34, 0, "StyleData", "H6", "SansSerif"],
Cell[12297, 411, 83, 2, 70, 33, 0, "StyleData", "H6", "Printout"],
Cell[12383, 415, 92, 2, 70, 42, 0, "StyleData", "H6", "SansSerifPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[12524, 423, 39, 0, 37, "Section"],
Cell[CellGroupData[{
Cell[12588, 427, 1074, 26, 70, 23, 0, "StyleData", "Body", "All",
 CounterIncrements->"Body"],
Cell[13665, 455, 90, 2, 70, 39, 0, "StyleData", "Body", "Presentation"],
Cell[13758, 459, 36, 0, 70, 36, 0, "StyleData", "Body", "SansSerif"],
Cell[13797, 461, 67, 1, 70, 35, 0, "StyleData", "Body", "Printout"],
Cell[13867, 464, 76, 1, 70, 44, 0, "StyleData", "Body", "SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[13980, 470, 266, 7, 70, 21, 0, "StyleData", "LI", "All",
 CounterIncrements->"LI"],
Cell[14249, 479, 88, 2, 70, 37, 0, "StyleData", "LI", "Presentation"],
Cell[14340, 483, 68, 1, 70, 34, 0, "StyleData", "LI", "SansSerif"],
Cell[14411, 486, 66, 1, 70, 33, 0, "StyleData", "LI", "Printout"],
Cell[14480, 489, 75, 1, 70, 42, 0, "StyleData", "LI", "SansSerifPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[14604, 496, 42, 0, 37, "Section"],
Cell[14649, 498, 246, 4, 70, "Text"],
Cell[CellGroupData[{
Cell[14920, 506, 664, 19, 70, 24, 0, "StyleData", "Input", "All",
 CounterIncrements->"Input"],
Cell[15587, 527, 90, 2, 70, 40, 0, "StyleData", "Input", "Presentation"],
Cell[15680, 531, 52, 1, 70, 37, 0, "StyleData", "Input", "SansSerif"],
Cell[15735, 534, 127, 3, 70, 36, 0, "StyleData", "Input", "Printout"],
Cell[15865, 539, 92, 2, 70, 45, 0, "StyleData", "Input", "SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[15994, 546, 585, 16, 70, 25, 0, "StyleData", "Output", "All",
 CounterIncrements->"Output"],
Cell[16582, 564, 91, 2, 70, 41, 0, "StyleData", "Output", "Presentation"],
Cell[16676, 568, 53, 1, 70, 38, 0, "StyleData", "Output", "SansSerif"],
Cell[16732, 571, 84, 2, 70, 37, 0, "StyleData", "Output", "Printout"],
Cell[16819, 575, 93, 2, 70, 46, 0, "StyleData", "Output", \
"SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[16949, 582, 648, 17, 70, 26, 0, "StyleData", "Message", "All",
 CounterIncrements->"Message",
 StyleMenuListing->None],
Cell[17600, 601, 91, 2, 70, 42, 0, "StyleData", "Message", "Presentation"],
Cell[17694, 605, 54, 1, 70, 39, 0, "StyleData", "Message", "SansSerif"],
Cell[17751, 608, 135, 3, 70, 38, 0, "StyleData", "Message", "Printout"],
Cell[17889, 613, 144, 3, 70, 47, 0, "StyleData", "Message", \
"SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[18070, 621, 598, 16, 70, 24, 0, "StyleData", "Print", "All",
 CounterIncrements->"Print",
 StyleMenuListing->None],
Cell[18671, 639, 89, 2, 70, 40, 0, "StyleData", "Print", "Presentation"],
Cell[18763, 643, 52, 1, 70, 37, 0, "StyleData", "Print", "SansSerif"],
Cell[18818, 646, 107, 2, 70, 36, 0, "StyleData", "Print", "Printout"],
Cell[18928, 650, 116, 2, 70, 45, 0, "StyleData", "Print", \
"SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[19081, 657, 428, 12, 70, 27, 0, "StyleData", "Graphics", "All",
 CounterIncrements->"Graphics",
 StyleMenuListing->None],
Cell[19512, 671, 92, 2, 70, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[19607, 675, 55, 1, 70, 40, 0, "StyleData", "Graphics", "SansSerif"],
Cell[19665, 678, 134, 3, 70, 39, 0, "StyleData", "Graphics", "Printout"],
Cell[19802, 683, 143, 3, 70, 48, 0, "StyleData", "Graphics", \
"SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[19982, 691, 124, 4, 70, 28, 0, "StyleData", "CellLabel", "All",
 StyleMenuListing->None],
Cell[20109, 697, 59, 1, 70, 44, 0, "StyleData", "CellLabel", "Presentation"],
Cell[20171, 700, 41, 0, 70, 41, 0, "StyleData", "CellLabel", "SansSerif"],
Cell[20215, 702, 126, 4, 70, 40, 0, "StyleData", "CellLabel", "Printout"],
Cell[20344, 708, 89, 2, 70, 49, 0, "StyleData", "CellLabel", \
"SansSerifPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[20482, 716, 36, 0, 37, "Section"],
Cell[20521, 718, 121, 3, 70, "Text"],
Cell[20645, 723, 89, 3, 70, 21, 0, "StyleData", "RM", "All",
 StyleMenuListing->None],
Cell[20737, 728, 67, 2, 70, 21, 0, "StyleData", "BF", "All",
 StyleMenuListing->None],
Cell[20807, 732, 68, 2, 70, 21, 0, "StyleData", "IT", "All",
 StyleMenuListing->None],
Cell[20878, 736, 111, 4, 70, 21, 0, "StyleData", "TR", "All",
 StyleMenuListing->None],
Cell[20992, 742, 112, 4, 70, 21, 0, "StyleData", "TI", "All",
 StyleMenuListing->None],
Cell[21107, 748, 110, 4, 70, 21, 0, "StyleData", "TB", "All",
 StyleMenuListing->None],
Cell[21220, 754, 112, 4, 70, 22, 0, "StyleData", "TBI", "All",
 StyleMenuListing->None],
Cell[21335, 760, 227, 6, 70, 21, 0, "StyleData", "MR", "All",
 StyleMenuListing->None],
Cell[21565, 768, 228, 6, 70, 21, 0, "StyleData", "MO", "All",
 StyleMenuListing->None],
Cell[21796, 776, 226, 6, 70, 21, 0, "StyleData", "MB", "All",
 StyleMenuListing->None],
Cell[22025, 784, 228, 6, 70, 22, 0, "StyleData", "MBO", "All",
 StyleMenuListing->None],
Cell[22256, 792, 115, 4, 70, 21, 0, "StyleData", "SR", "All",
 StyleMenuListing->None],
Cell[22374, 798, 116, 4, 70, 21, 0, "StyleData", "SO", "All",
 StyleMenuListing->None],
Cell[22493, 804, 114, 4, 70, 21, 0, "StyleData", "SB", "All",
 StyleMenuListing->None],
Cell[22610, 810, 116, 4, 70, 22, 0, "StyleData", "SBO", "All",
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[22751, 818, 133, 5, 70, 23, 0, "StyleData", "SO10", "All",
 StyleMenuListing->None],
Cell[22887, 825, 144, 5, 70, 35, 0, "StyleData", "SO10", "Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[23068, 835, 132, 3, 70, 24, 0, "StyleData", "Inert", "All",
 StyleMenuListing->None],
Cell[23203, 840, 88, 2, 70, 36, 0, "StyleData", "Inert", "Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[23306, 845, 63, 2, 70, 24, 0, "StyleData", "Small", "All",
 StyleMenuListing->None],
Cell[23372, 849, 65, 2, 70, 25, 0, "StyleData", "Medium", "All",
 StyleMenuListing->None],
Cell[23440, 853, 64, 2, 70, 24, 0, "StyleData", "Large", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[23541, 860, 35, 0, 37, "Section"],
Cell[23579, 862, 184, 4, 70, "Text"],
Cell[CellGroupData[{
Cell[23788, 870, 254, 7, 70, 28, 0, "StyleData", "Hyperlink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[24045, 879, 41, 0, 70, 41, 0, "StyleData", "Hyperlink", "SansSerif"],
Cell[24089, 881, 66, 1, 70, 40, 0, "StyleData", "Hyperlink", "Printout"],
Cell[24158, 884, 75, 1, 70, 49, 0, "StyleData", "Hyperlink", \
"SansSerifPrintout"]
}, Closed]],
Cell[24248, 888, 104, 3, 70, "Text"],
Cell[CellGroupData[{
Cell[24377, 895, 268, 7, 70, 31, 0, "StyleData", "MainBookLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[24648, 904, 44, 0, 70, 44, 0, "StyleData", "MainBookLink", "SansSerif"],
Cell[24695, 906, 69, 1, 70, 43, 0, "StyleData", "MainBookLink", "Printout"],
Cell[24767, 909, 78, 1, 70, 52, 0, "StyleData", "MainBookLink", \
"SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[24882, 915, 288, 8, 70, 29, 0, "StyleData", "AddOnsLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[25173, 925, 42, 0, 70, 42, 0, "StyleData", "AddOnsLink", "SansSerif"],
Cell[25218, 927, 66, 1, 70, 40, 0, "StyleData", "AddOnLink", "Printout"],
Cell[25287, 930, 75, 1, 70, 49, 0, "StyleData", "AddOnLink", \
"SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[25399, 936, 296, 8, 70, 31, 0, "StyleData", "RefGuideLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[25698, 946, 44, 0, 70, 44, 0, "StyleData", "RefGuideLink", "SansSerif"],
Cell[25745, 948, 69, 1, 70, 43, 0, "StyleData", "RefGuideLink", "Printout"],
Cell[25817, 951, 78, 1, 70, 52, 0, "StyleData", "RefGuideLink", \
"SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[25932, 957, 280, 7, 70, 37, 0, "StyleData", "GettingStartedLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[26215, 966, 50, 0, 70, 50, 0, "StyleData", "GettingStartedLink", \
"SansSerif"],
Cell[26268, 968, 75, 1, 70, 49, 0, "StyleData", "GettingStartedLink", \
"Printout"],
Cell[26346, 971, 84, 1, 70, 58, 0, "StyleData", "GettingStartedLink", \
"SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[26467, 977, 284, 7, 70, 39, 0, "StyleData", "OtherInformationLink", \
"All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[26754, 986, 52, 0, 70, 52, 0, "StyleData", "OtherInformationLink", \
"SansSerif"],
Cell[26809, 988, 77, 1, 70, 51, 0, "StyleData", "OtherInformationLink", \
"Printout"],
Cell[26889, 991, 86, 1, 70, 60, 0, "StyleData", "OtherInformationLink", \
"SansSerifPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[27012, 997, 262, 7, 70, 28, 0, "StyleData", "DemosLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[27277, 1006, 66, 1, 70, 40, 0, "StyleData", "DemosLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[27380, 1012, 260, 7, 70, 27, 0, "StyleData", "TourLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[27643, 1021, 65, 1, 70, 39, 0, "StyleData", "TourLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[27745, 1027, 274, 7, 70, 34, 0, "StyleData", "MasterIndexLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[28022, 1036, 72, 1, 70, 46, 0, "StyleData", "MasterIndexLink", \
"Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[28143, 1043, 33, 0, 37, "Section"],
Cell[28179, 1045, 121, 3, 70, "Text"],
Cell[28303, 1050, 216, 5, 70, 24, 0, "StyleData", "Paste", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[28522, 1057, 287, 7, 70, 27, 0, "StyleData", "Evaluate", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[28812, 1066, 376, 9, 70, 31, 0, "StyleData", "EvaluateCell", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[29191, 1077, 363, 9, 70, 31, 0, "StyleData", "CopyEvaluate", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[29557, 1088, 377, 9, 70, 35, 0, "StyleData", "CopyEvaluateCell", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
