Notebook[{
Cell[BoxData[
 DynamicModuleBox[{Global`title$$ = "", Global`author$$ = "", Global`text$$ = 
  "", Global`email$$ = "", Global`deleteTempFile$$, Global`buttonsRow$$ = 
  Row[{
    Apply[Sequence, 
     Switch[
      Internal`CachedSystemInformation["FrontEnd", "OperatingSystem"], 
      "Windows", Reverse, 
      Alternatives["MacOSX", 
       Blank[]], Identity][#]], Space}]& }, 
  TagBox[GridBox[{
     {
      ItemBox[
       StyleBox["\<\"Publish to Wolfram Notebook Player through Wolfram \
Webspace\"\>", "Subsection",
        StripOnInput->False],
       Alignment->Center,
       StripOnInput->False], "\[SpanFromLeft]"},
     {
      InterpretationBox[Cell[TextData[{
        "Notebooks with Manipulate and other dynamic content can be published \
to ",
        Cell[BoxData[
         TagBox[
          ButtonBox[
           PaneSelectorBox[{False->"\<\"Wolfram Webspace\"\>", True->
            StyleBox["\<\"Wolfram Webspace\"\>", "HyperlinkActive"]}, Dynamic[
            
             CurrentValue["MouseOver"]],
            FrameMargins->0,
            ImageSize->Automatic],
           BaseStyle->"Hyperlink",
           ButtonData->{
             URL["http://www.wolfram.com/webspace"], None},
           ButtonNote->"http://www.wolfram.com/webspace"],
          Annotation[#, "http://www.wolfram.com/webspace", "Hyperlink"]& ]]],
        " pages for use with Wolfram Mathematica Player."
       }],
        FontFamily:>CurrentValue["ControlsFontFamily"],
        FontSize:>CurrentValue["ControlsFontSize"]],
       TextCell[
        Row[{
         "Notebooks with Manipulate and other dynamic content can be \
published to ", 
          Hyperlink["Wolfram Webspace", "http://www.wolfram.com/webspace"], 
          " pages for use with Wolfram Mathematica Player."}], FontSize :> 
        CurrentValue["ControlsFontSize"], FontFamily :> 
        CurrentValue["ControlsFontFamily"]]], "\[SpanFromLeft]"},
     {
      InterpretationBox[Cell["\<\
(All notebooks can be opened with Mathematica Player; Mathematica Player does \
not support keyboard input.)\
\>",
        FontFamily:>CurrentValue["ControlsFontFamily"],
        FontSize:>CurrentValue["ControlsFontSize"]],
       TextCell[
       "(All notebooks can be opened with Mathematica Player; Mathematica \
Player does not support keyboard input.)", FontSize :> 
        CurrentValue["ControlsFontSize"], FontFamily :> 
        CurrentValue["ControlsFontFamily"]]], "\[SpanFromLeft]"},
     {
      InterpretationBox[Cell["\<\
Enter information to be included on the Wolfram Webspace page for your \
notebook:\
\>",
        FontFamily:>CurrentValue["ControlsFontFamily"],
        FontSize:>CurrentValue["ControlsFontSize"]],
       TextCell[
       "Enter information to be included on the Wolfram Webspace page for \
your notebook:", FontSize :> CurrentValue["ControlsFontSize"], FontFamily :> 
        CurrentValue["ControlsFontFamily"]]], "\[SpanFromLeft]"},
     {
      ItemBox["\<\"Title:\"\>",
       Alignment->Right,
       StripOnInput->False], 
      InputFieldBox[Dynamic[Global`title$$], String,
       FieldSize->{20, 1}]},
     {
      ItemBox["\<\"Additional text:\"\>",
       Alignment->Right,
       StripOnInput->False], 
      InputFieldBox[Dynamic[Global`text$$], String,
       FieldSize->{20, 5}]},
     {
      InterpretationBox[Cell[TextData[{
        "A link to the ",
        Cell[BoxData[
         TagBox[
          ButtonBox[
           PaneSelectorBox[{False->"\<\"Wolfram Webspace\"\>", True->
            StyleBox["\<\"Wolfram Webspace\"\>", "HyperlinkActive"]}, Dynamic[
            
             CurrentValue["MouseOver"]],
            FrameMargins->0,
            ImageSize->Automatic],
           BaseStyle->"Hyperlink",
           ButtonData->{
             URL["http://www.wolfram.com/webspace"], None},
           ButtonNote->"http://www.wolfram.com/webspace"],
          Annotation[#, "http://www.wolfram.com/webspace", "Hyperlink"]& ]]],
        " page for this notebook will be mailed when the notebook has been \
processed."
       }],
        FontFamily:>CurrentValue["ControlsFontFamily"],
        FontSize:>CurrentValue["ControlsFontSize"]],
       TextCell[
        Row[{"A link to the ", 
          Hyperlink["Wolfram Webspace", "http://www.wolfram.com/webspace"], 
          " page for this notebook will be mailed when the notebook has been \
processed."}], FontSize :> CurrentValue["ControlsFontSize"], FontFamily :> 
        CurrentValue["ControlsFontFamily"]]], "\[SpanFromLeft]"},
     {
      ItemBox["\<\"Email address:\"\>",
       Alignment->Right,
       StripOnInput->False], 
      InputFieldBox[Dynamic[Global`email$$], String,
       FieldSize->{20, 1}]},
     {
      InterpretationBox[Cell[TextData[{
        "Note:\tNotebooks uploaded to Wolfram Webspace are placed on \
publicly-accessible webpages.\n\tSee ",
        Cell[BoxData[
         TagBox[
          ButtonBox[
           PaneSelectorBox[{False->"\<\"Terms of Use\"\>", True->
            StyleBox["\<\"Terms of Use\"\>", "HyperlinkActive"]}, Dynamic[
             CurrentValue["MouseOver"]],
            FrameMargins->0,
            ImageSize->Automatic],
           BaseStyle->"Hyperlink",
           ButtonData->{
             URL["http://www.wolfram.com/webspace"], None},
           ButtonNote->"http://www.wolfram.com/webspace"],
          Annotation[#, "http://www.wolfram.com/webspace", "Hyperlink"]& ]]],
        " for information on Wolfram Webspace use.\n\tSee ",
        Cell[BoxData[
         TagBox[
          ButtonBox[
           PaneSelectorBox[{False->"\<\"Additional Services\"\>", True->
            StyleBox["\<\"Additional Services\"\>", "HyperlinkActive"]}, 
            Dynamic[
             CurrentValue["MouseOver"]],
            FrameMargins->0,
            ImageSize->Automatic],
           BaseStyle->"Hyperlink",
           ButtonData->{
             URL["http://www.wolfram.com/webspace"], None},
           ButtonNote->"http://www.wolfram.com/webspace"],
          Annotation[#, "http://www.wolfram.com/webspace", "Hyperlink"]& ]]],
        " for information on other options."
       }],
        FontFamily:>CurrentValue["ControlsFontFamily"],
        FontSize:>CurrentValue["ControlsFontSize"]],
       TextCell[
        Row[{
         "Note:\tNotebooks uploaded to Wolfram Webspace are placed on \
publicly-accessible webpages.\n\tSee ", 
          Hyperlink["Terms of Use", "http://www.wolfram.com/webspace"], 
          " for information on Wolfram Webspace use.\n\tSee ", 
          Hyperlink["Additional Services", "http://www.wolfram.com/webspace"],
           " for information on other options."}], FontSize :> 
        CurrentValue["ControlsFontSize"], FontFamily :> 
        CurrentValue["ControlsFontFamily"]]], "\[SpanFromLeft]"},
     {
      ItemBox[
       DynamicBox[ToBoxes[
         Global`buttonsRow$$[{
           Button[
           "Cancel", Global`deleteTempFile$$[]; DialogReturn[], Appearance -> 
            "CancelButton", ImageSize -> Automatic], 
           Button["Publish", 
            With[{FE`Global`nb$ = ButtonNotebook[]}, 
             CreateDialog[
              
              Grid[{{"Review information for correctness   ", SpanFromLeft}, {
                "Title:", Global`title$$}, 
                Replace[
                Global`text$$, {
                 "" -> Sequence[], Blank[] -> {"Text:", Global`text$$}}], {
                "Email:", Global`email$$}, {Space, 
                 Item[
                  Global`buttonsRow$$[{
                    CancelButton[
                    ImageSize -> CurrentValue["DefaultButtonSize"]], 
                    DefaultButton[
                    Global`deleteTempFile$$[]; DialogReturn[]; 
                    NotebookClose[FE`Global`nb$], ImageSize -> 
                    CurrentValue["DefaultButtonSize"]], Space}], Alignment -> 
                  Right]}}, Alignment -> {{Left, Left}, Baseline}, 
               Spacings -> {Automatic, {-2 -> 2}}], WindowTitle -> "Verify", 
              Modal -> True]], ImageSize -> Automatic, Enabled -> Dynamic[
              And[
               StringMatchQ[Global`email$$, 
                StringExpression["*@*.", 
                 Blank[], 
                 Blank[], 
                 Blank[]]], Global`title$$ =!= ""]]]}], StandardForm],
        ImageSizeCache->{144., 26.4375}],
       Alignment->Right,
       StripOnInput->False], "\[SpanFromLeft]"}
    },
    BaseStyle->{
     FontSize :> CurrentValue["ControlsFontSize"], FontFamily :> 
      CurrentValue["ControlsFontFamily"]},
    ColumnsEqual->False,
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxItemSize->{"Columns" -> {16, 30}, "Rows" -> {{Automatic}}},
    GridBoxSpacings->{
     "Columns" -> {{Automatic}}, "Rows" -> {1, 1, 1, 1, 1, 0.5, 2, 1, 2, 3}},
    RowsEqual->False],
   "Grid"],
  DynamicModuleValues:>{{DownValues[Global`deleteTempFile$$] = {HoldPattern[
         Global`deleteTempFile$$[]] :> (If[FileType[#] === File, 
         DeleteFile[#]]& )[
         CurrentValue["PublishToPlayerFileName"]]}}}]], "Output",
 CellMargins->{{8, 8}, {8, 8}},
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellHorizontalScrolling->True,
 PageBreakAbove->True,
 PageBreakWithin->False,
 ShowAutoStyles->True,
 LineSpacing->{1.25, 0},
 AutoItalicWords->{},
 ScriptMinSize->9,
 ShowStringCharacters->False,
 FontFamily:>CurrentValue["PanelFontFamily"],
 FontSize:>CurrentValue["PanelFontSize"]]
},
ClosingAutoSave->False,
Editable->False,
Saveable->False,
WindowToolbars->{},
NotebookEventActions->{"EscapeKeyDown" :> (FE`Evaluate[
     FEPrivate`FindAndClickCancelButton[]]; DialogReturn[$Failed]), 
  "WindowClose" :> (FE`Evaluate[
     FEPrivate`FindAndClickCancelButton[]]; DialogReturn[$Failed])},
Selectable->False,
WindowSize->All,
WindowMargins->Automatic,
WindowFrame->"ModalDialog",
WindowElements->{},
WindowFrameElements->"CloseBox",
WindowFloating->False,
WindowTitle->"Publish",
ScrollingOptions->{"VerticalScrollRange"->Fit},
PrivateNotebookOptions->{"FileOutlineCache"->False},
ShowCellBracket->False,
CellMargins->{{8, 8}, {8, 8}},
Active->True,
Deployed->True,
Evaluatable->False,
ShowCellLabel->False,
ShowCellTags->False,
ImageMargins->{{0, 0}, {0, 0}},
Modal -> True,
Magnification->1.,
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (January 9, 2007)",
StyleDefinitions->"Default.nb"
]

