(* Mathematica Package *)

(* Created by the Mathematica IDE May 17, 2005 *)



BeginPackage["ResourceLocator`"]
(* Exported symbols added here with SymbolName::usage *) 

ResourcesLocate::usage = "ResourcesLocate[type] returns a list of locations of resources of type found in \
in Mathematica applications."

ResourceAdd::usage = "ResourceAdd[ dir, type] adds a resource of type. \
ResourceAdd[ dir, type, app] associates the resource with an application."

ApplicationDirectoryAdd::usage = "ApplicationDirectoryAdd[ dir] adds dir to the list \
of directories that are searched for Mathematica applications."

ApplicationDirectoriesLocate::usage = "ApplicationDirectoriesLocate[ ] returns a list of the applications directories."

ApplicationAdd::usage = "ApplicationAdd[dir] adds an application."
ApplicationsLocate::usage = "ApplicationsLocate[ ] returns a list of applications."




Begin["`Private`"]
(* Implementation of the package *)

If[!ValueQ[appDirectoryList], appDirectoryList = {}];
If[!ValueQ[appList], appList = {}];
resourceTable[_] = {};


ApplicationDirectoryAdd[ dir_] :=
	(
		If[ !MemberQ[ appDirectoryList, dir],
			PrependTo[ appDirectoryList, dir]];
		(* Until there are other hooks into the kernel, add app dirs to $Path
           so that Get["App`"] will find them. It is a hack to prepend them,
           done just so that a newer paclet downloaded will take precedence
           over an older one.
        *) 
		If[ !MemberQ[ $Path, dir],
			PrependTo[ $Path, dir]];
		appDirectoryList
	)

ApplicationDirectoriesLocate[] :=
	appDirectoryList
	
ApplicationAdd[ dir_String] :=
	(
		If[ !MemberQ[ appList, dir],
			PrependTo[ appList, dir]];
		(* Until there are other hooks into the kernel, add app dirs to $Path
           so that Get["App`"] will find them.
        *) 
		If[!MemberQ[$Path, dir],
			PrependTo[$Path, ParentDirectory[dir]]
		]
	)

ApplicationsLocate[] :=
	Module[ {appPaths, paths},
		appPaths = ApplicationDirectoriesLocate[];
		paths = Select[Flatten[FileNames["*", #]& /@ appPaths], (FileType[#] === Directory)&];
		Join[ paths, appList] 
	]
		

ResourcesLocate[ type_String] :=
	Module[ {apps},
		apps = ApplicationsLocate[];
		Join[
			Select[{ToFileName[{#, type}], getSegment[#]}& /@ apps, (FileType[First[#]] === Directory)&],
			resourceTable[type]
			]
	]

ResourceAdd[ dir_, type_, app_:None] :=
	resourceTable[ type] = Append[ resourceTable[type], {dir, app}];
	

Clear[getSegment];
getSegment[ path_, level_:1] :=
	Module[{dir}, 
    	dir = Nest[
		DirectoryName, path, level - 1];
    	If[StringMatchQ[dir, "*" <> $PathnameSeparator], 
        	dir = StringDrop[dir, -StringLength[$PathnameSeparator]]];
    	StringDrop[ dir, StringLength[ DirectoryName[ dir]]]
	]


(* Add these so their order reflects the traditional order in $Path. Ones
   added later come earlier in search path.
*)

ApplicationDirectoryAdd[ 
	ToFileName[{$InstallationDirectory, "SystemFiles"}, "Links"]]

ApplicationDirectoryAdd[ 
	ToFileName[{$InstallationDirectory, "AddOns"}, "Applications"]]
	
ApplicationDirectoryAdd[ 
	ToFileName[{$InstallationDirectory, "AddOns"}, "Autoload"]]
	
ApplicationDirectoryAdd[ 
	ToFileName[$BaseDirectory, "Applications"]]
	
ApplicationDirectoryAdd[ 
	ToFileName[$BaseDirectory, "Autoload"]]
	
ApplicationDirectoryAdd[ 
	ToFileName[$UserBaseDirectory, "Applications"]]
	
ApplicationDirectoryAdd[ 
	ToFileName[$UserBaseDirectory, "Autoload"]]


End[]

EndPackage[]

