(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34148,       1121]
NotebookOptionsPosition[     29240,        954]
NotebookOutlinePosition[     30621,        993]
CellTagsIndexPosition[     30536,        988]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["ANOVA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Analysis of Variance Package" :> 
          Documentation`HelpLookup["paclet:ANOVA/tutorial/ANOVA"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Analysis of Variance Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regress" :> 
          Documentation`HelpLookup["paclet:LinearRegression/ref/Regress"], 
          "Fit" :> Documentation`HelpLookup["paclet:ref/Fit"], "LeastSquares" :> 
          Documentation`HelpLookup["paclet:ref/LeastSquares"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Regress\"\>", 2->"\<\"Fit\"\>", 
       3->"\<\"LeastSquares\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ANOVA", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ANOVA", "[", 
       StyleBox["data", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]performs a one\[Hyphen]way analysis of variance."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ANOVA", "[", 
       RowBox[{
        StyleBox["data", "TI"], ",", 
        StyleBox["model", "TI"], ",", 
        StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]performs an analysis of variance for ",
     Cell[BoxData[
      StyleBox["model", "TI"]], "InlineFormula"],
     " as a function of the categorical variables ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The data can have the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["x", "1"], ",", 
       SubscriptBox["y", "1"], ",", "\[Ellipsis]", " ", ",", 
       SubscriptBox["f", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["x", "2"], ",", 
       SubscriptBox["y", "2"], ",", "\[Ellipsis]", " ", ",", 
       SubscriptBox["f", "2"]}], "}"}], ",", "\[Ellipsis]"}], "}"}], 
   TraditionalForm]], "InlineMath"],
 ", where the number of coordinates ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", "y", ",", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 " is equal to the number of variables in the list ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5773236],

Cell[TextData[{
 "For data of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["1", "TR"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], ",", "\[Ellipsis]"}], "}"}]], 
  "InlineFormula"],
 " a one\[Hyphen]way analysis of variance can be obtained without explicitly \
specifying the model and variable."
}], "Notes",
 CellID->148787488],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["model", "TI"]], "InlineFormula"],
 " argument can be a list containing main effects and interactions. Main \
effects are elements of ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 " and interactions are products of main effects."
}], "Notes",
 CellID->68853755],

Cell[TextData[{
 "A full factorial model including all interactions between variables ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ",", 
   StyleBox["y", "TI"], ",", "\[Ellipsis]"}]], "InlineFormula"],
 " can be specified as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", "\[Ellipsis]", ",", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->79466880],

Cell["The following options can be given: ", "Notes",
 CellID->26940],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CellMeans",
     BaseStyle->"Link",
     ButtonData->"paclet:ANOVA/ref/CellMeans"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether cell means should be included in the output", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "the precision used in internal computations", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PostTests",
     BaseStyle->"Link",
     ButtonData->"paclet:ANOVA/ref/PostTests"], 
    RowBox[{"{", "}"}], Cell["significance tests to perform", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SignificanceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/SignificanceLevel"], "0.05", 
    RowBox[{
    Cell["significance level for performed tests", "TableText"], " "}]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->219868454],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["PostTests",
   BaseStyle->"Link",
   ButtonData->"paclet:ANOVA/ref/PostTests"]], "InlineFormula"],
 " include ",
 Cell[BoxData[
  ButtonBox["Bonferroni",
   BaseStyle->"Link",
   ButtonData->"paclet:ANOVA/ref/Bonferroni"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Duncan",
   BaseStyle->"Link",
   ButtonData->"paclet:ANOVA/ref/Duncan"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dunnett",
   BaseStyle->"Link",
   ButtonData->"paclet:ANOVA/ref/Dunnett"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StudentNewmanKeuls",
   BaseStyle->"Link",
   ButtonData->"paclet:ANOVA/ref/StudentNewmanKeuls"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Tukey",
   BaseStyle->"Link",
   ButtonData->"paclet:ANOVA/ref/Tukey"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24902]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->258394426],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->67036461],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ANOVA`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->570938726],

Cell["\<\
A one\[Hyphen]way analysis of variance:\
\>", "ExampleText",
 CellID->661075337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13078971],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "4.`", "4.`", "8.`", "0.10557280900008414`"},
       {"\<\"Error\"\>", "2", "1.`", "0.5`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "3", "5.`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{1, 4., 4., 8., 0.105572809000084}, {2, 1., 0.5}, {3, 5.}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", 
    TagBox[GridBox[{
       {"\<\"All\"\>", "2.5`"},
       {
        RowBox[{"\<\"Model\"\>", "[", "1", "]"}], "1.5`"},
       {
        RowBox[{"\<\"Model\"\>", "[", "2", "]"}], "3.5`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{435, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->111151446]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->839249],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ANOVA`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->3931136],

Cell["\<\
A two\[Hyphen]way analysis of variance:\
\>", "ExampleText",
 CellID->264417349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->210694152],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"x", "1", "1.125`", "1.125`", "0.8490566037735848`", 
        "0.39909862197230705`"},
       {"y", "1", "0.125`", "0.125`", "0.09433962264150943`", 
        "0.7711118563588939`"},
       {"\<\"Error\"\>", "5", "6.625000000000001`", 
        "1.3250000000000002`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "7", "7.875`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{1, 1.125, 1.125, 0.849056603773585, 0.399098621972307}, {
       1, 0.125, 0.125, 0.0943396226415094, 0.771111856358894}, {
       5, 6.625, 1.325}, {7, 7.875}}, 
      TableHeadings -> {{$CellContext`x, $CellContext`y, "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", 
    TagBox[GridBox[{
       {"\<\"All\"\>", "3.375`"},
       {
        RowBox[{"x", "[", "1", "]"}], "3.`"},
       {
        RowBox[{"x", "[", "2", "]"}], "3.75`"},
       {
        RowBox[{"y", "[", "1", "]"}], "3.5`"},
       {
        RowBox[{"y", "[", "2", "]"}], "3.25`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{456, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->332494141]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2061341341],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "CellMeans",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1757724783],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ANOVA`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->872783931],

Cell["Omit cell means from output:", "ExampleText",
 CellID->797094157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"CellMeans", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->236451249],

Cell[BoxData[
 RowBox[{"ANOVA", "\[Rule]", 
  InterpretationBox[GridBox[{
     {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
     {"\<\"Model\"\>", "1", "4.`", "4.`", "8.`", "0.10557280900008414`"},
     {"\<\"Error\"\>", "2", "1.`", "0.5`", "\<\"\"\>", "\<\"\"\>"},
     {"\<\"Total\"\>", "3", "5.`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.28], {
         Offset[2.1]}, 
        Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   TableForm[{{1, 4., 4., 8., 0.105572809000084}, {2, 1., 0.5}, {3, 5.}}, 
    TableHeadings -> {{"Model", "Error", "Total"}, {
      "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]], "Output",
 ImageSize->{421, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81914929]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1295379749],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ANOVA`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->813960923],

Cell["Computation at precision 20:", "ExampleText",
 CellID->22470828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->268610060],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "4.`17.904239159136004", 
        "4.`17.904239159136004", "8.`17.281209103851037", 
        "0.1055728092323988676`7.712611636257049"},
       {"\<\"Error\"\>", "2", "1.`17.399376949604342", 
        "0.5`17.399376949604342", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "3", 
        "5.`18.69897000433602", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       1, 4.`17.904239159136004, 4.`17.904239159136004, 8.`17.281209103851037,
         0.105572809`7.712611636257054}, {
       2, 1.`17.399376949604342, 0.5`17.399376949604342}, {
       3, 5.`18.69897000433602}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", 
    TagBox[GridBox[{
       {"\<\"All\"\>", "2.5`20."},
       {
        RowBox[{"\<\"Model\"\>", "[", "1", "]"}], "1.5`20."},
       {
        RowBox[{"\<\"Model\"\>", "[", "2", "]"}], "3.5`20."}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     Function[BoxForm`e$, 
      TableForm[BoxForm`e$]]]}]}], "}"}]], "Output",
 ImageSize->{1036, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->299114146]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PostTests",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->933705163],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ANOVA`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->251559848],

Cell["Analysis of variance with Bonferroni test:", "ExampleText",
 CellID->392528177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "20"}], "}"}]}], "}"}], ",", 
   RowBox[{"PostTests", "\[Rule]", "Bonferroni"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->488874901],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "256.`", "256.`", "39.38461538461539`", 
        "0.024462782640492176`"},
       {"\<\"Error\"\>", "2", "13.`", "6.5`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "3", "269.`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{1, 256., 256., 39.3846153846154, 0.0244627826404922}, {
       2, 13., 6.5}, {3, 269.}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", 
    TagBox[GridBox[{
       {"\<\"All\"\>", "9.5`"},
       {
        RowBox[{"\<\"Model\"\>", "[", "1", "]"}], "1.5`"},
       {
        RowBox[{"\<\"Model\"\>", "[", "2", "]"}], "17.5`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ",", 
   RowBox[{"PostTests", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Model\"\>", "\[Rule]", 
      TagBox[GridBox[{
         {"Bonferroni", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.28], {
             Offset[0.7]}, 
            Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[1.2]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$, TableSpacing -> {3, 1}, TableDepth -> 2]]]}], 
     "}"}]}]}], "}"}]], "Output",
 ImageSize->{468, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->160052151]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SignificanceLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->326409280],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ANOVA`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->526669636],

Cell["Bonferroni test at significance level .01:", "ExampleText",
 CellID->242970196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "20"}], "}"}]}], "}"}], ",", 
   RowBox[{"PostTests", "\[Rule]", "Bonferroni"}], ",", 
   RowBox[{"SignificanceLevel", "\[Rule]", ".01"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->351680800],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "256.`", "256.`", "39.38461538461539`", 
        "0.024462782640492176`"},
       {"\<\"Error\"\>", "2", "13.`", "6.5`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "3", "269.`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{1, 256., 256., 39.3846153846154, 0.0244627826404922}, {
       2, 13., 6.5}, {3, 269.}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", 
    TagBox[GridBox[{
       {"\<\"All\"\>", "9.5`"},
       {
        RowBox[{"\<\"Model\"\>", "[", "1", "]"}], "1.5`"},
       {
        RowBox[{"\<\"Model\"\>", "[", "2", "]"}], "17.5`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ",", 
   RowBox[{"PostTests", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Model\"\>", "\[Rule]", 
      TagBox[GridBox[{
         {"Bonferroni", 
          RowBox[{"{", "\<\"\"\>", "}"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.28], {
             Offset[0.7]}, 
            Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[1.2]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$, TableSpacing -> {3, 1}, TableDepth -> 2]]]}], 
     "}"}]}]}], "}"}]], "Output",
 ImageSize->{449, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->391332096]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Regress",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/Regress"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LeastSquares",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LeastSquares"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Analysis of Variance Package",
 BaseStyle->"Link",
 ButtonData->"paclet:ANOVA/tutorial/ANOVA"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ANOVA - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 42.2069142}", "context" -> "ANOVA`", 
    "keywords" -> {
     "analysis of variance", "ANOVA", "linear models", 
      "categorical linear regression"}, "index" -> True, "label" -> 
    "ANOVA Package Symbol", "language" -> "en", "paclet" -> "ANOVA Package", 
    "status" -> "None", "summary" -> 
    "ANOVA[data] performs a one-way analysis of variance. ANOVA[data, model, \
vars] performs an analysis of variance for model as a function of the \
categorical variables vars.", "synonyms" -> {}, "title" -> "ANOVA", "type" -> 
    "Symbol", "uri" -> "ANOVA/ref/ANOVA"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8210, 276, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->258394426]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30393, 981}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1366, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1989, 60, 48, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2040, 63, 908, 27, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2985, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3463, 112, 823, 27, 70, "Notes",
 CellID->5773236],
Cell[4289, 141, 695, 25, 70, "Notes",
 CellID->148787488],
Cell[4987, 168, 330, 10, 70, "Notes",
 CellID->68853755],
Cell[5320, 180, 506, 17, 70, "Notes",
 CellID->79466880],
Cell[5829, 199, 69, 1, 70, "Notes",
 CellID->26940],
Cell[5901, 202, 1383, 34, 70, "3ColumnTableMod",
 CellID->219868454],
Cell[7287, 238, 886, 33, 70, "Notes",
 CellID->24902]
}, Closed]],
Cell[CellGroupData[{
Cell[8210, 276, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->258394426],
Cell[CellGroupData[{
Cell[8595, 290, 147, 5, 70, "ExampleSection",
 CellID->67036461],
Cell[8745, 297, 128, 3, 70, "Input",
 CellID->570938726],
Cell[8876, 302, 90, 3, 70, "ExampleText",
 CellID->661075337],
Cell[CellGroupData[{
Cell[8991, 309, 371, 13, 28, "Input",
 CellID->13078971],
Cell[9365, 324, 1904, 50, 123, "Output",
 CellID->111151446]
}, Open  ]],
Cell[11284, 377, 122, 3, 70, "ExampleDelimiter",
 CellID->839249],
Cell[11409, 382, 126, 3, 70, "Input",
 CellID->3931136],
Cell[11538, 387, 90, 3, 70, "ExampleText",
 CellID->264417349],
Cell[CellGroupData[{
Cell[11653, 394, 845, 26, 70, "Input",
 CellID->210694152],
Cell[12501, 422, 2277, 60, 170, "Output",
 CellID->332494141]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14827, 488, 223, 7, 70, "ExampleSection",
 CellID->2061341341],
Cell[CellGroupData[{
Cell[15075, 499, 231, 7, 70, "ExampleSubsection",
 CellID->1757724783],
Cell[15309, 508, 128, 3, 70, "Input",
 CellID->872783931],
Cell[15440, 513, 71, 1, 70, "ExampleText",
 CellID->797094157],
Cell[CellGroupData[{
Cell[15536, 518, 447, 15, 70, "Input",
 CellID->236451249],
Cell[15986, 535, 1094, 26, 78, "Output",
 CellID->81914929]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17129, 567, 238, 7, 70, "ExampleSubsection",
 CellID->1295379749],
Cell[17370, 576, 128, 3, 70, "Input",
 CellID->813960923],
Cell[17501, 581, 70, 1, 70, "ExampleText",
 CellID->22470828],
Cell[CellGroupData[{
Cell[17596, 586, 451, 15, 70, "Input",
 CellID->268610060],
Cell[18050, 603, 2184, 56, 78, "Output",
 CellID->299114146]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20283, 665, 230, 7, 70, "ExampleSubsection",
 CellID->933705163],
Cell[20516, 674, 128, 3, 70, "Input",
 CellID->251559848],
Cell[20647, 679, 85, 1, 70, "ExampleText",
 CellID->392528177],
Cell[CellGroupData[{
Cell[20757, 684, 454, 15, 70, "Input",
 CellID->488874901],
Cell[21214, 701, 2673, 71, 123, "Output",
 CellID->160052151]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23936, 778, 238, 7, 70, "ExampleSubsection",
 CellID->326409280],
Cell[24177, 787, 128, 3, 70, "Input",
 CellID->526669636],
Cell[24308, 792, 85, 1, 70, "ExampleText",
 CellID->242970196],
Cell[CellGroupData[{
Cell[24418, 797, 512, 16, 70, "Input",
 CellID->351680800],
Cell[24933, 815, 2648, 70, 123, "Output",
 CellID->391332096]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27654, 893, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[27973, 904, 713, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[28723, 935, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[29044, 946, 154, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[29213, 952, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

