(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12394,        410]
NotebookOptionsPosition[      9794,        325]
NotebookOutlinePosition[     11077,        362]
CellTagsIndexPosition[     10992,        357]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["ANOVA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Analysis of Variance Package" :> 
          Documentation`HelpLookup["paclet:ANOVA/tutorial/ANOVA"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Analysis of Variance Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CellMeans" :> 
          Documentation`HelpLookup["paclet:ANOVA/ref/CellMeans"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CellMeans\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PostTests", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PostTests"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["ANOVA",
       BaseStyle->"Link",
       ButtonData->"paclet:ANOVA/ref/ANOVA"]], "InlineFormula"],
     " that specifies which significance tests to perform."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The setting may be a single test or a list of tests.", "Notes",
 CellID->71653639],

Cell["Possible tests include:", "Notes",
 CellID->1067943069],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Bonferroni",
     BaseStyle->"Link",
     ButtonData->"paclet:ANOVA/ref/Bonferroni"], Cell[TextData[{
     "mean comparison based on the Student ",
     Cell[BoxData[
      RowBox[{
       StyleBox["t", "TI"], " "}]], "InlineFormula"],
     "distribution"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Duncan",
     BaseStyle->"Link",
     ButtonData->"paclet:ANOVA/ref/Duncan"], Cell["\<\
liberal range test based on the Studentized range distribution\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["StudentNewmanKeuls",
     BaseStyle->"Link",
     ButtonData->"paclet:ANOVA/ref/StudentNewmanKeuls"], Cell["\<\
conservative range test based on the Studentized range distribution\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Tukey",
     BaseStyle->"Link",
     ButtonData->"paclet:ANOVA/ref/Tukey"], Cell["\<\
mean comparison test based on the Studentized range distribution\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Dunnett",
     BaseStyle->"Link",
     ButtonData->"paclet:ANOVA/ref/Dunnett"], Cell[
    "comparison test of group means against a control", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->27088]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->39069096],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->437208485],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ANOVA`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->541479787],

Cell[TextData[{
 "Analysis of variance with ",
 Cell[BoxData[
  ButtonBox["Tukey",
   BaseStyle->"Link",
   ButtonData->"paclet:ANOVA/ref/Tukey"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Bonferroni",
   BaseStyle->"Link",
   ButtonData->"paclet:ANOVA/ref/Bonferroni"]], "InlineFormula"],
 " tests:"
}], "ExampleText",
 CellID->392528177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"PostTests", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Tukey", ",", "Bonferroni"}], "}"}]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->258866397],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "2", "10.333333333333334`", "5.166666666666667`", 
        "15.5`", "0.026209787902323756`"},
       {"\<\"Error\"\>", "3", "1.`", 
        "0.3333333333333333`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "5", 
        "11.333333333333334`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       2, 10.3333333333333, 5.16666666666667, 15.5, 0.0262097879023238}, {
       3, 1., 0.333333333333333}, {5, 11.3333333333333}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"PostTests", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Model\"\>", "\[Rule]", 
      TagBox[GridBox[{
         {"Bonferroni", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}]},
         {"Tukey", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3"}], "}"}]}], "}"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.28], {
             Offset[0.7]}, 
            Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[1.2]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$, TableSpacing -> {3, 1}, TableDepth -> 2]]]}], 
     "}"}]}]}], "}"}]], "Output",
 ImageSize->{456, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->125620285]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["CellMeans",
   BaseStyle->"Link",
   ButtonData->"paclet:ANOVA/ref/CellMeans"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Analysis of Variance Package",
 BaseStyle->"Link",
 ButtonData->"paclet:ANOVA/tutorial/ANOVA"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PostTests - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 45.4413720}", "context" -> "ANOVA`", 
    "keywords" -> {
     "Bonferroni", "Tukey", "Student-Newman-Keuls", "Duncan", "Dunnett"}, 
    "index" -> True, "label" -> "ANOVA Package Symbol", "language" -> "en", 
    "paclet" -> "ANOVA Package", "status" -> "None", "summary" -> 
    "PostTests is an option for ANOVA that specifies which significance tests \
to perform.", "synonyms" -> {}, "title" -> "PostTests", "type" -> "Symbol", 
    "uri" -> "ANOVA/ref/PostTests"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4606, 149, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->39069096]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10850, 350}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1170, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1793, 58, 52, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1848, 61, 516, 15, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2401, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2879, 98, 88, 1, 70, "Notes",
 CellID->71653639],
Cell[2970, 101, 61, 1, 70, "Notes",
 CellID->1067943069],
Cell[3034, 104, 1535, 40, 70, "2ColumnTableMod",
 CellID->27088]
}, Closed]],
Cell[CellGroupData[{
Cell[4606, 149, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->39069096],
Cell[CellGroupData[{
Cell[4990, 163, 148, 5, 70, "ExampleSection",
 CellID->437208485],
Cell[5141, 170, 128, 3, 70, "Input",
 CellID->541479787],
Cell[5272, 175, 354, 13, 70, "ExampleText",
 CellID->392528177],
Cell[CellGroupData[{
Cell[5651, 192, 685, 22, 47, "Input",
 CellID->258866397],
Cell[6339, 216, 2313, 61, 116, "Output",
 CellID->125620285]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8713, 284, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[9032, 295, 208, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[9277, 306, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[9598, 317, 154, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[9767, 323, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

