(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11953,        403]
NotebookOptionsPosition[      9365,        319]
NotebookOutlinePosition[     10697,        357]
CellTagsIndexPosition[     10612,        352]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["ANOVA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Analysis of Variance Package" :> 
          Documentation`HelpLookup["paclet:ANOVA/tutorial/ANOVA"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Analysis of Variance Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bonferroni" :> 
          Documentation`HelpLookup["paclet:ANOVA/ref/Bonferroni"], "Duncan" :> 
          Documentation`HelpLookup["paclet:ANOVA/ref/Duncan"], "Dunnett" :> 
          Documentation`HelpLookup["paclet:ANOVA/ref/Dunnett"], "Tukey" :> 
          Documentation`HelpLookup["paclet:ANOVA/ref/Tukey"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Bonferroni\"\>", 
       2->"\<\"Duncan\"\>", 3->"\<\"Dunnett\"\>", 
       4->"\<\"Tukey\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StudentNewmanKeuls", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["StudentNewmanKeuls"], "InlineFormula"],
     " \[LineSeparator]is a possible value for the ",
     Cell[BoxData[
      ButtonBox["PostTests",
       BaseStyle->"Link",
       ButtonData->"paclet:ANOVA/ref/PostTests"]], "InlineFormula"],
     " option for ",
     Cell[BoxData[
      ButtonBox["ANOVA",
       BaseStyle->"Link",
       ButtonData->"paclet:ANOVA/ref/ANOVA"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData["StudentNewmanKeuls"], "InlineFormula"],
 " test compares all cell means pairwise."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "The individual paired comparisons are similar to the ",
 Cell[BoxData[
  ButtonBox["Tukey",
   BaseStyle->"Link",
   ButtonData->"paclet:ANOVA/ref/Tukey"]], "InlineFormula"],
 " test."
}], "Notes",
 CellID->275948104]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->151811342],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->171480220],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ANOVA`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->603854427],

Cell[TextData[{
 "Analysis of variance with ",
 Cell[BoxData["StudentNewmanKeuls"], "InlineFormula"],
 " test:"
}], "ExampleText",
 CellID->392528177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"PostTests", "\[Rule]", "StudentNewmanKeuls"}], ",", 
   RowBox[{"CellMeans", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->258866397],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "2", "10.333333333333334`", "5.166666666666667`", 
        "15.5`", "0.026209787902323756`"},
       {"\<\"Error\"\>", "3", "1.`", 
        "0.3333333333333333`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "5", 
        "11.333333333333334`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[2.1]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       2, 10.3333333333333, 5.16666666666667, 15.5, 0.0262097879023238}, {
       3, 1., 0.333333333333333}, {5, 11.3333333333333}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"PostTests", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Model\"\>", "\[Rule]", 
      TagBox[GridBox[{
         {"StudentNewmanKeuls", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3"}], "}"}]}], "}"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.28], {
             Offset[0.7]}, 
            Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[1.2]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$, TableSpacing -> {3, 1}, TableDepth -> 2]]]}], 
     "}"}]}]}], "}"}]], "Output",
 ImageSize->{456, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->328735409]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bonferroni",
    BaseStyle->"Link",
    ButtonData->"paclet:ANOVA/ref/Bonferroni"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Duncan",
    BaseStyle->"Link",
    ButtonData->"paclet:ANOVA/ref/Duncan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dunnett",
    BaseStyle->"Link",
    ButtonData->"paclet:ANOVA/ref/Dunnett"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tukey",
    BaseStyle->"Link",
    ButtonData->"paclet:ANOVA/ref/Tukey"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Analysis of Variance Package",
 BaseStyle->"Link",
 ButtonData->"paclet:ANOVA/tutorial/ANOVA"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StudentNewmanKeuls - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 46.2226420}", "context" -> "ANOVA`", 
    "keywords" -> {
     "Newman-Keuls's test", "Newman-Keuls's method", "Newman Keuls test", 
      "Newman Keuls method"}, "index" -> True, "label" -> 
    "ANOVA Package Symbol", "language" -> "en", "paclet" -> "ANOVA Package", 
    "status" -> "None", "summary" -> 
    "StudentNewmanKeuls is a possible value for the PostTests option for \
ANOVA.", "synonyms" -> {}, "title" -> "StudentNewmanKeuls", "type" -> 
    "Symbol", "uri" -> "ANOVA/ref/StudentNewmanKeuls"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3754, 127, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->151811342]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10469, 345}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1472, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2095, 62, 61, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2159, 65, 649, 20, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2845, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3323, 107, 156, 5, 70, "Notes",
 CellID->1067943069],
Cell[3482, 114, 235, 8, 70, "Notes",
 CellID->275948104]
}, Closed]],
Cell[CellGroupData[{
Cell[3754, 127, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->151811342],
Cell[CellGroupData[{
Cell[4139, 141, 148, 5, 70, "ExampleSection",
 CellID->171480220],
Cell[4290, 148, 128, 3, 70, "Input",
 CellID->603854427],
Cell[4421, 153, 150, 5, 70, "ExampleText",
 CellID->392528177],
Cell[CellGroupData[{
Cell[4596, 162, 638, 20, 47, "Input",
 CellID->258866397],
Cell[5237, 184, 2233, 58, 101, "Output",
 CellID->328735409]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7531, 249, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7850, 260, 961, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[8848, 300, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[9169, 311, 154, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[9338, 317, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

