(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     43370,       1306]
NotebookOptionsPosition[     39007,       1173]
NotebookOutlinePosition[     40959,       1218]
CellTagsIndexPosition[     40916,       1215]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["ANOVA PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ANOVA" :> Documentation`HelpLookup["paclet:ANOVA/ref/ANOVA"], 
         "Bonferroni" :> 
         Documentation`HelpLookup["paclet:ANOVA/ref/Bonferroni"], "Duncan" :> 
         Documentation`HelpLookup["paclet:ANOVA/ref/Duncan"], "Dunnett" :> 
         Documentation`HelpLookup["paclet:ANOVA/ref/Dunnett"], 
         "StudentNewmanKeuls" :> 
         Documentation`HelpLookup["paclet:ANOVA/ref/StudentNewmanKeuls"], 
         "Tukey" :> Documentation`HelpLookup["paclet:ANOVA/ref/Tukey"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"ANOVA\"\>", 
      2->"\<\"Bonferroni\"\>", 3->"\<\"Duncan\"\>", 4->"\<\"Dunnett\"\>", 
      5->"\<\"StudentNewmanKeuls\"\>", 
      6->"\<\"Tukey\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Analysis of Variance Package", "Title",
 CellID->27995],

Cell[TextData[{
 "This package provides functions for performing a univariate Analysis of \
Variance (ANOVA) to examine the differences between groups of means. The \
function ",
 Cell[BoxData[
  ButtonBox["ANOVA",
   BaseStyle->"Link",
   ButtonData->"paclet:ANOVA/ref/ANOVA"]], "InlineFormula"],
 " can handle models with any number of fixed factors in a crossed design. It \
can handle both balanced and unbalanced data with or without missing \
elements. All results are given as type I sums of squares. ",
 Cell[BoxData[
  ButtonBox["ANOVA",
   BaseStyle->"Link",
   ButtonData->"paclet:ANOVA/ref/ANOVA"]], "InlineFormula"],
 " also provides a number of post\[Hyphen]hoc tests for comparisons. "
}], "Text",
 CellID->24946],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ANOVA",
      BaseStyle->"Link",
      ButtonData->"paclet:ANOVA/ref/ANOVA"], "[", 
     StyleBox["data", "TI"], "]"}], Cell["\<\
performs a one\[Hyphen]way analysis of variance\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ANOVA",
      BaseStyle->"Link",
      ButtonData->"paclet:ANOVA/ref/ANOVA"], "[", 
     StyleBox["data", "TI"], ",", " ", 
     StyleBox["model", "TI"], ",", " ", 
     StyleBox["vars", "TI"], "]"}], Cell[TextData[{
     "performs a general ANOVA specified by the given ",
     Cell[BoxData[
      StyleBox["model", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->29578],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ANOVA",
   BaseStyle->"Link",
   ButtonData->"paclet:ANOVA/ref/ANOVA"]], "InlineFormula"],
 " function."
}], "Caption",
 CellID->1754],

Cell[TextData[{
 "The ",
 StyleBox["data", "TI"],
 " must be of the form ",
 StyleBox["{{", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", "1"], TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", "1"], TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox["\[Ellipsis]", TraditionalForm]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["y", "TI"], "1"], TraditionalForm]], "InlineFormula"],
 StyleBox["},", "MR"],
 " ",
 StyleBox["{", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", "2"], TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", "2"], TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox["\[Ellipsis]", TraditionalForm]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["y", "TI"], "2"], TraditionalForm]], "InlineFormula"],
 StyleBox["},", "MR"],
 " ",
 Cell[BoxData[
  FormBox["\[Ellipsis]", TraditionalForm]], "InlineFormula"],
 StyleBox["}", "MR"],
 " where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Alpha]", 
    StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula"],
 ", and so on are the values of the categorical variables ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 " associated with the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["i", "TI"], "th"], TraditionalForm]], "InlineFormula"],
 " response, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["y", "TI"], 
    StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula"],
 ". "
}], "Text",
 CellID->29201],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 " argument is a list of symbols representing the categorical variables in \
the model. "
}], "Text",
 CellID->31523],

Cell[TextData[{
 "The ",
 StyleBox["model", "TI"],
 " argument is a list of main effects and interactions that together specify \
the model. The interaction terms are given as the product of variables. For \
example, the full factorial model for a three\[Hyphen]way analysis of \
variance can be written as ",
 StyleBox["{", "MR"],
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula"],
 StyleBox["}", "MR"],
 ", where ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula"],
 " are the main effects, ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula"],
 " are the two\[Hyphen]way interactions, and ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula"],
 " is the three\[Hyphen]way interaction. Models can also be written using ",
 StyleBox["All", "TI"],
 " to represent all main effects and interactions between the specified \
categorical variables. The full factorial model for a three\[Hyphen]way \
analysis of variance can therefore also be written as ",
 StyleBox["{", "MR"],
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox["\[Beta]", TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineFormula"],
 StyleBox[",", "MR"],
 " ",
 StyleBox["All", "TI"],
 StyleBox["}", "MR"],
 ". "
}], "Text",
 CellID->4413],

Cell["This loads the package. ", "MathCaption",
 CellID->18098],

Cell[BoxData[
 RowBox[{"<<", "ANOVA`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23546],

Cell["This defines data of one categorical variable. ", "MathCaption",
 CellID->25687],

Cell[BoxData[
 RowBox[{
  RowBox[{"onewaydata", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "7.0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "6.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4.4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "6.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "7.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "8.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "6.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "8.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "10.4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "8.0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "6.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "6.2"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30478],

Cell["\<\
This performs a one\[Hyphen]way ANOVA on the data. \
\>", "MathCaption",
 CellID->28212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", "onewaydata", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8918],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "3", "26.293499999999995`", "8.764499999999998`", 
        "6.127949659150497`", "0.005616104919811349`"},
       {"\<\"Error\"\>", "16", "22.884`", 
        "1.43025`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "19", 
        "49.177499999999995`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{
       "Columns" -> {0.28, {2.1}, 0.28}, "ColumnsIndexed" -> {}, 
        "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
     TableForm[{{3, 26.2935, 8.7645, 6.1279496591505, 0.00561610491981135}, {
       16, 22.884, 1.43025}, {19, 49.1775}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", 
    TagBox[GridBox[{
       {"\<\"All\"\>", "6.675`"},
       {
        RowBox[{"\<\"Model\"\>", "[", "1", "]"}], "5.94`"},
       {
        RowBox[{"\<\"Model\"\>", "[", "2", "]"}], "6.76`"},
       {
        RowBox[{"\<\"Model\"\>", "[", "3", "]"}], "8.5`"},
       {
        RowBox[{"\<\"Model\"\>", "[", "4", "]"}], "5.5`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{
       "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
        "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}]}], "}"}]], "Output",
 ImageSize->{456, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->398184965]
}, Open  ]],

Cell["\<\
This defines data of a categorical variable with two levels and a categorical \
variable with three levels. \
\>", "MathCaption",
 CellID->25684],

Cell[BoxData[
 RowBox[{
  RowBox[{"twowaydata", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "10.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "10.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "11.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "13.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "14.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "14.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "12.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "10.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "15.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "17.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "18.0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "28.7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "16.0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "9.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "12.1"}], "}"}]}], "}"}]}], ";"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->20714],

Cell["\<\
This performs a full factorial two\[Hyphen]way ANOVA. \
\>", "MathCaption",
 CellID->22356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{"twowaydata", ",", 
   RowBox[{"{", 
    RowBox[{"factor1", ",", "factor2", ",", "All"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"factor1", ",", "factor2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->14019],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"factor1", "1", "49.59144047619043`", "49.59144047619043`", 
        "7.254236799486078`", "0.02466005901056123`"},
       {"factor2", "2", "110.31823328267481`", "55.159116641337405`", 
        "8.068676568466415`", "0.009832259544792832`"},
       {
        RowBox[{"factor1", " ", "factor2"}], "2", "105.88182624113469`", 
        "52.940913120567345`", "7.744197717789645`", 
        "0.011060373917016864`"},
       {"\<\"Error\"\>", "9", "61.52583333333334`", 
        "6.836203703703704`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "14", 
        "327.3173333333333`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{
       "Columns" -> {0.28, {2.1}, 0.28}, "ColumnsIndexed" -> {}, 
        "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
     TableForm[{{
       1, 49.5914404761904, 49.5914404761904, 7.25423679948608, 
        0.0246600590105612}, {
       2, 110.318233282675, 55.1591166413374, 8.06867656846642, 
        0.00983225954479283}, {
       2, 105.881826241135, 52.9409131205673, 7.74419771778965, 
        0.0110603739170169}, {9, 61.5258333333333, 6.8362037037037}, {
       14, 327.317333333333}}, 
      TableHeadings -> {{$CellContext`factor1, $CellContext`factor2, \
$CellContext`factor1 $CellContext`factor2, "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", 
    TagBox[GridBox[{
       {"\<\"All\"\>", "14.286666666666667`"},
       {
        RowBox[{"factor1", "[", "1", "]"}], "12.342857142857143`"},
       {
        RowBox[{"factor1", "[", "2", "]"}], "15.987499999999999`"},
       {
        RowBox[{"factor2", "[", "1", "]"}], "13.400000000000002`"},
       {
        RowBox[{"factor2", "[", "2", "]"}], "18.833333333333332`"},
       {
        RowBox[{"factor2", "[", "3", "]"}], "12.8`"},
       {
        RowBox[{
         RowBox[{"factor1", "[", "1", "]"}], " ", 
         RowBox[{"factor2", "[", "1", "]"}]}], "10.633333333333333`"},
       {
        RowBox[{
         RowBox[{"factor1", "[", "1", "]"}], " ", 
         RowBox[{"factor2", "[", "2", "]"}]}], "13.899999999999999`"},
       {
        RowBox[{
         RowBox[{"factor1", "[", "1", "]"}], " ", 
         RowBox[{"factor2", "[", "3", "]"}]}], "13.35`"},
       {
        RowBox[{
         RowBox[{"factor1", "[", "2", "]"}], " ", 
         RowBox[{"factor2", "[", "1", "]"}]}], "15.475`"},
       {
        RowBox[{
         RowBox[{"factor1", "[", "2", "]"}], " ", 
         RowBox[{"factor2", "[", "2", "]"}]}], "28.7`"},
       {
        RowBox[{
         RowBox[{"factor1", "[", "2", "]"}], " ", 
         RowBox[{"factor2", "[", "3", "]"}]}], "12.433333333333332`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{
       "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
        "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}]}], "}"}]], "Output",
 ImageSize->{529, 273},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->184243502]
}, Open  ]],

Cell[TextData[{
 "Dropping the point ",
 StyleBox["{2,", "MR"],
 " ",
 StyleBox["2,", "MR"],
 " ",
 StyleBox["28.7}", "MR"],
 " gives an unbalanced two\[Hyphen]way ANOVA with an empty cell. "
}], "MathCaption",
 CellID->6127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{
   RowBox[{"Drop", "[", 
    RowBox[{"twowaydata", ",", 
     RowBox[{"{", 
      RowBox[{"-", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"factor1", ",", "factor2", ",", "All"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"factor1", ",", "factor2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->4730],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"factor1", "1", "11.702857142857141`", "11.702857142857141`", 
        "1.71189415208865`", "0.22316503901533946`"},
       {"factor2", "2", "8.099663865546205`", "4.0498319327731025`", 
        "0.5924094875316535`", "0.5731936603055153`"},
       {
        RowBox[{"factor1", " ", "factor2"}], "1", "23.40593137254902`", 
        "23.40593137254902`", "3.4238200596433668`", "0.09729572033085232`"},
       {"\<\"Error\"\>", "9", "61.52583333333334`", 
        "6.836203703703704`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "13", 
        "104.7342857142857`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{
       "Columns" -> {0.28, {2.1}, 0.28}, "ColumnsIndexed" -> {}, 
        "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
     TableForm[{{
       1, 11.7028571428571, 11.7028571428571, 1.71189415208865, 
        0.223165039015339}, {
       2, 8.09966386554621, 4.0498319327731, 0.592409487531653, 
        0.573193660305515}, {
       1, 23.405931372549, 23.405931372549, 3.42382005964337, 
        0.0972957203308523}, {9, 61.5258333333333, 6.8362037037037}, {
       13, 104.734285714286}}, 
      TableHeadings -> {{$CellContext`factor1, $CellContext`factor2, \
$CellContext`factor1 $CellContext`factor2, "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", 
    TagBox[GridBox[{
       {"\<\"All\"\>", "13.257142857142856`"},
       {
        RowBox[{"factor1", "[", "1", "]"}], "12.342857142857143`"},
       {
        RowBox[{"factor1", "[", "2", "]"}], "14.171428571428569`"},
       {
        RowBox[{"factor2", "[", "1", "]"}], "13.400000000000002`"},
       {
        RowBox[{"factor2", "[", "2", "]"}], "13.899999999999999`"},
       {
        RowBox[{"factor2", "[", "3", "]"}], "12.8`"},
       {
        RowBox[{
         RowBox[{"factor1", "[", "1", "]"}], " ", 
         RowBox[{"factor2", "[", "1", "]"}]}], "10.633333333333333`"},
       {
        RowBox[{
         RowBox[{"factor1", "[", "1", "]"}], " ", 
         RowBox[{"factor2", "[", "2", "]"}]}], "13.899999999999999`"},
       {
        RowBox[{
         RowBox[{"factor1", "[", "1", "]"}], " ", 
         RowBox[{"factor2", "[", "3", "]"}]}], "13.35`"},
       {
        RowBox[{
         RowBox[{"factor1", "[", "2", "]"}], " ", 
         RowBox[{"factor2", "[", "1", "]"}]}], "15.475`"},
       {
        RowBox[{
         RowBox[{"factor1", "[", "2", "]"}], " ", 
         RowBox[{"factor2", "[", "3", "]"}]}], "12.433333333333332`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{
       "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
        "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}]}], "}"}]], "Output",
 ImageSize->{529, 258},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->384628248]
}, Open  ]],

Cell["\<\
Here is a balanced three\[Hyphen]way data set. \
\>", "MathCaption",
 CellID->18826],

Cell[BoxData[
 RowBox[{
  RowBox[{"threewaydata", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "50"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "50"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "54"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "2", ",", "40"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "2", ",", "36"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "2", ",", "40"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1", ",", "48"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1", ",", "48"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1", ",", "44"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "2", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "2", ",", "18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "2", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "1", ",", "40"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "1", ",", "36"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "1", ",", "36"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "2", ",", "18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "2", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "2", ",", "18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "20"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->12892],

Cell["\<\
Here is a three\[Hyphen]way ANOVA with main effects and two\[Hyphen]way \
interactions. \
\>", "MathCaption",
 CellID->29766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{"threewaydata", ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", 
     RowBox[{"\[Alpha]", " ", "\[Beta]"}], ",", 
     RowBox[{"\[Alpha]", " ", "\[Gamma]"}], ",", 
     RowBox[{"\[Beta]", " ", "\[Gamma]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->16024],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\[Alpha]", "1", "2166.`", "2166.`", "30.532338308457707`", 
        "0.00003705699705391918`"},
       {"\[Beta]", "1", "1350.`", "1350.`", "19.029850746268654`", 
        "0.0004241469507222373`"},
       {"\[Gamma]", "1", "912.6666666666661`", "912.6666666666661`", 
        "12.865118850193467`", "0.0022731109550425677`"},
       {
        RowBox[{"\[Alpha]", " ", "\[Beta]"}], "1", "6.0000000000009095`", 
        "6.0000000000009095`", "0.08457711442787351`", 
        "0.7747060407679582`"},
       {
        RowBox[{"\[Alpha]", " ", "\[Gamma]"}], "1", "560.666666666667`", 
        "560.666666666667`", "7.903261470425653`", "0.012016762171042639`"},
       {
        RowBox[{"\[Beta]", " ", "\[Gamma]"}], "1", "112.66666666666606`", 
        "112.66666666666606`", "1.5881702598120422`", 
        "0.22461261582845715`"},
       {"\<\"Error\"\>", "17", "1206.0000000000002`", 
        "70.94117647058825`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "23", "6314.`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{
       "Columns" -> {0.28, {2.1}, 0.28}, "ColumnsIndexed" -> {}, 
        "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
     TableForm[{{1, 2166., 2166., 30.5323383084577, 0.0000370569970539192}, {
       1, 1350., 1350., 19.0298507462687, 0.000424146950722237}, {
       1, 912.666666666666, 912.666666666666, 12.8651188501935, 
        0.00227311095504257}, {
       1, 6.00000000000091, 6.00000000000091, 0.0845771144278735, 
        0.774706040767958}, {
       1, 560.666666666667, 560.666666666667, 7.90326147042565, 
        0.0120167621710426}, {
       1, 112.666666666666, 112.666666666666, 1.58817025981204, 
        0.224612615828457}, {17, 1206., 70.9411764705882}, {23, 6314.}}, 
      TableHeadings -> {{$CellContext`\[Alpha], $CellContext`\[Beta], \
$CellContext`\[Gamma], $CellContext`\[Alpha] $CellContext`\[Beta], \
$CellContext`\[Alpha] $CellContext`\[Gamma], $CellContext`\[Beta] \
$CellContext`\[Gamma], "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", 
    TagBox[GridBox[{
       {"\<\"All\"\>", "28.5`"},
       {
        RowBox[{"\[Alpha]", "[", "1", "]"}], "38.`"},
       {
        RowBox[{"\[Alpha]", "[", "2", "]"}], "19.`"},
       {
        RowBox[{"\[Beta]", "[", "1", "]"}], "36.`"},
       {
        RowBox[{"\[Beta]", "[", "2", "]"}], "21.`"},
       {
        RowBox[{"\[Gamma]", "[", "1", "]"}], "34.666666666666664`"},
       {
        RowBox[{"\[Gamma]", "[", "2", "]"}], "22.333333333333332`"},
       {
        RowBox[{
         RowBox[{"\[Alpha]", "[", "1", "]"}], " ", 
         RowBox[{"\[Beta]", "[", "1", "]"}]}], "45.`"},
       {
        RowBox[{
         RowBox[{"\[Alpha]", "[", "1", "]"}], " ", 
         RowBox[{"\[Beta]", "[", "2", "]"}]}], "31.`"},
       {
        RowBox[{
         RowBox[{"\[Alpha]", "[", "2", "]"}], " ", 
         RowBox[{"\[Beta]", "[", "1", "]"}]}], "27.`"},
       {
        RowBox[{
         RowBox[{"\[Alpha]", "[", "2", "]"}], " ", 
         RowBox[{"\[Beta]", "[", "2", "]"}]}], "11.`"},
       {
        RowBox[{
         RowBox[{"\[Alpha]", "[", "1", "]"}], " ", 
         RowBox[{"\[Gamma]", "[", "1", "]"}]}], "49.`"},
       {
        RowBox[{
         RowBox[{"\[Alpha]", "[", "1", "]"}], " ", 
         RowBox[{"\[Gamma]", "[", "2", "]"}]}], "27.`"},
       {
        RowBox[{
         RowBox[{"\[Alpha]", "[", "2", "]"}], " ", 
         RowBox[{"\[Gamma]", "[", "1", "]"}]}], "20.333333333333332`"},
       {
        RowBox[{
         RowBox[{"\[Alpha]", "[", "2", "]"}], " ", 
         RowBox[{"\[Gamma]", "[", "2", "]"}]}], "17.666666666666668`"},
       {
        RowBox[{
         RowBox[{"\[Beta]", "[", "1", "]"}], " ", 
         RowBox[{"\[Gamma]", "[", "1", "]"}]}], "44.333333333333336`"},
       {
        RowBox[{
         RowBox[{"\[Beta]", "[", "1", "]"}], " ", 
         RowBox[{"\[Gamma]", "[", "2", "]"}]}], "27.666666666666668`"},
       {
        RowBox[{
         RowBox[{"\[Beta]", "[", "2", "]"}], " ", 
         RowBox[{"\[Gamma]", "[", "1", "]"}]}], "25.`"},
       {
        RowBox[{
         RowBox[{"\[Beta]", "[", "2", "]"}], " ", 
         RowBox[{"\[Gamma]", "[", "2", "]"}]}], "17.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{
       "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
        "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}]}], "}"}]], "Output",
 ImageSize->{484, 427},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->175378037]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["CellMeans",
     BaseStyle->"Link",
     ButtonData->"paclet:ANOVA/ref/CellMeans"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to give a list of means for each group", "TableText"]},
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "precision of the arithmetic to use in calculations", "TableText"]},
   {
    ButtonBox["PostTests",
     BaseStyle->"Link",
     ButtonData->"paclet:ANOVA/ref/PostTests"], 
    RowBox[{"{", "}"}], Cell["\<\
list of post\[Hyphen]hoc tests to perform\
\>", "TableText"]},
   {
    ButtonBox["SignificanceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/SignificanceLevel"], "0.05", 
    Cell["\<\
significance level criteria for post\[Hyphen]hoc tests\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->10755],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["ANOVA",
   BaseStyle->"Link",
   ButtonData->"paclet:ANOVA/ref/ANOVA"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->30102],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Bonferroni",
     BaseStyle->"Link",
     ButtonData->"paclet:ANOVA/ref/Bonferroni"], Cell[TextData[{
     "mean comparison test based on the Student ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " distribution with modified ",
     Cell[BoxData["\[Alpha]"], "InlineFormula"],
     " based on the number of groups"
    }], "TableText"]},
   {
    ButtonBox["Duncan",
     BaseStyle->"Link",
     ButtonData->"paclet:ANOVA/ref/Duncan"], Cell["\<\
liberal range test based on the Studentized range distribution\
\>", "TableText"]},
   {
    ButtonBox["StudentNewmanKeuls",
     BaseStyle->"Link",
     ButtonData->"paclet:ANOVA/ref/StudentNewmanKeuls"], Cell["\<\
conservative range test based on the Studentized range distribution\
\>", "TableText"]},
   {
    ButtonBox["Tukey",
     BaseStyle->"Link",
     ButtonData->"paclet:ANOVA/ref/Tukey"], Cell["\<\
mean comparison test based on the Studentized range distribution\
\>", "TableText"]},
   {
    ButtonBox["Dunnett",
     BaseStyle->"Link",
     ButtonData->"paclet:ANOVA/ref/Dunnett"], Cell["\<\
comparison test of group means against a control, taken to be the first group\
\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->14619],

Cell[TextData[{
 "Available tests for the ",
 Cell[BoxData[
  ButtonBox["PostTests",
   BaseStyle->"Link",
   ButtonData->"paclet:ANOVA/ref/PostTests"]], "InlineFormula"],
 " option."
}], "Caption",
 CellID->20288],

Cell["\<\
Tukey's test finds groups 1 and 4 significantly different from group 3 at the \
5% level. \
\>", "MathCaption",
 CellID->12384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{"onewaydata", ",", 
   RowBox[{"PostTests", "\[Rule]", "Tukey"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->4421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "3", "26.293499999999995`", "8.764499999999998`", 
        "6.127949659150497`", "0.005616104919811349`"},
       {"\<\"Error\"\>", "16", "22.884`", 
        "1.43025`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "19", 
        "49.177499999999995`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{
       "Columns" -> {0.28, {2.1}, 0.28}, "ColumnsIndexed" -> {}, 
        "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
     TableForm[{{3, 26.2935, 8.7645, 6.1279496591505, 0.00561610491981135}, {
       16, 22.884, 1.43025}, {19, 49.1775}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"CellMeans", "\[Rule]", 
    TagBox[GridBox[{
       {"\<\"All\"\>", "6.675`"},
       {
        RowBox[{"\<\"Model\"\>", "[", "1", "]"}], "5.94`"},
       {
        RowBox[{"\<\"Model\"\>", "[", "2", "]"}], "6.76`"},
       {
        RowBox[{"\<\"Model\"\>", "[", "3", "]"}], "8.5`"},
       {
        RowBox[{"\<\"Model\"\>", "[", "4", "]"}], "5.5`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{
       "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
        "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ",", 
   RowBox[{"PostTests", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Model\"\>", "\[Rule]", 
      TagBox[GridBox[{
         {"Tukey", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{
         "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
          "Rows" -> {0.2, {1.2}, 0.2}, "RowsIndexed" -> {}}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$, TableSpacing -> {3, 1}, TableDepth -> 2]]]}], 
     "}"}]}]}], "}"}]], "Output",
 ImageSize->{504, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->96345189]
}, Open  ]],

Cell["\<\
Bonferroni and Tukey's tests find groups 3 and 4 significantly different at \
the 1% level. \
\>", "MathCaption",
 CellID->15635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ANOVA", "[", 
  RowBox[{"onewaydata", ",", 
   RowBox[{"PostTests", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Tukey", ",", "Bonferroni"}], "}"}]}], ",", 
   RowBox[{"SignificanceLevel", "\[Rule]", ".01"}], ",", 
   RowBox[{"CellMeans", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->30668],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ANOVA", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "3", "26.293499999999995`", "8.764499999999998`", 
        "6.127949659150497`", "0.005616104919811349`"},
       {"\<\"Error\"\>", "16", "22.884`", 
        "1.43025`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "19", 
        "49.177499999999995`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{
       "Columns" -> {0.28, {2.1}, 0.28}, "ColumnsIndexed" -> {}, 
        "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
     TableForm[{{3, 26.2935, 8.7645, 6.1279496591505, 0.00561610491981135}, {
       16, 22.884, 1.43025}, {19, 49.1775}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}], ",", 
   RowBox[{"PostTests", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Model\"\>", "\[Rule]", 
      TagBox[GridBox[{
         {"Bonferroni", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4"}], "}"}]},
         {"Tukey", 
          RowBox[{"{", 
           RowBox[{"3", ",", "4"}], "}"}]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{
         "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
          "Rows" -> {0.2, {1.2}, 0.2}, "RowsIndexed" -> {}}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$, TableSpacing -> {3, 1}, TableDepth -> 2]]]}], 
     "}"}]}]}], "}"}]], "Output",
 ImageSize->{456, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->266959860]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Analysis of Variance Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 47.2851692}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "ANOVA Package Tutorial", 
    "language" -> "en", "paclet" -> "ANOVA Package", "status" -> "None", 
    "summary" -> 
    "This package provides functions for performing a univariate Analysis of \
Variance (ANOVA) to examine the differences between groups of means. The \
function ANOVA can handle models with any number of fixed factors in a \
crossed design. It can handle both balanced and unbalanced data with or \
without missing elements. All results are given as type I sums of squares. \
ANOVA also provides a number of post-hoc tests for comparisons. The ANOVA \
function. The data must be of the form {{\\[Alpha]_1, \\[Beta]_1, ... y_1}, {\
\\[Alpha]_2, \\[Beta]_2, ... y_2}, ...} where \\[Alpha]_i, \\[Beta]_i, and so \
on are the values of the categorical variables vars associated with the i^th \
response, y_i. ", "synonyms" -> {}, "title" -> "Analysis of Variance Package",
     "type" -> "Tutorial", "uri" -> "ANOVA/tutorial/ANOVA"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1112, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1737, 50, 61, 1, 70, "Title",
 CellID->27995],
Cell[1801, 53, 728, 17, 70, "Text",
 CellID->24946],
Cell[2532, 72, 912, 29, 70, "DefinitionBox",
 CellID->29578],
Cell[3447, 103, 187, 8, 70, "Caption",
 CellID->1754],
Cell[3637, 113, 1860, 73, 70, "Text",
 CellID->29201],
Cell[5500, 188, 202, 7, 70, "Text",
 CellID->31523],
Cell[5705, 197, 3262, 112, 70, "Text",
 CellID->4413],
Cell[8970, 311, 63, 1, 70, "MathCaption",
 CellID->18098],
Cell[9036, 314, 89, 3, 70, "Input",
 CellID->23546],
Cell[9128, 319, 86, 1, 70, "MathCaption",
 CellID->25687],
Cell[9217, 322, 1445, 46, 70, "Input",
 CellID->30478],
Cell[10665, 370, 98, 3, 70, "MathCaption",
 CellID->28212],
Cell[CellGroupData[{
Cell[10788, 377, 105, 3, 70, "Input",
 CellID->8918],
Cell[10896, 382, 1945, 48, 154, "Output",
 CellID->398184965]
}, Open  ]],
Cell[12856, 433, 155, 4, 70, "MathCaption",
 CellID->25684],
Cell[13014, 439, 1285, 37, 70, "Input",
 CellID->20714],
Cell[14302, 478, 101, 3, 70, "MathCaption",
 CellID->22356],
Cell[CellGroupData[{
Cell[14428, 485, 273, 8, 70, "Input",
 CellID->14019],
Cell[14704, 495, 3548, 87, 294, "Output",
 CellID->184243502]
}, Open  ]],
Cell[18267, 585, 225, 9, 70, "MathCaption",
 CellID->6127],
Cell[CellGroupData[{
Cell[18517, 598, 377, 12, 70, "Input",
 CellID->4730],
Cell[18897, 612, 3397, 82, 279, "Output",
 CellID->384628248]
}, Open  ]],
Cell[22309, 697, 94, 3, 70, "MathCaption",
 CellID->18826],
Cell[22406, 702, 2162, 55, 70, "Input",
 CellID->12892],
Cell[24571, 759, 135, 4, 70, "MathCaption",
 CellID->29766],
Cell[CellGroupData[{
Cell[24731, 767, 450, 12, 70, "Input",
 CellID->16024],
Cell[25184, 781, 5104, 125, 448, "Output",
 CellID->175378037]
}, Open  ]],
Cell[30303, 909, 1305, 38, 70, "DefinitionBox3Col",
 CellID->10755],
Cell[31611, 949, 187, 8, 70, "Caption",
 CellID->30102],
Cell[31801, 959, 1399, 42, 70, "DefinitionBox",
 CellID->14619],
Cell[33203, 1003, 214, 8, 70, "Caption",
 CellID->20288],
Cell[33420, 1013, 137, 4, 70, "MathCaption",
 CellID->12384],
Cell[CellGroupData[{
Cell[33582, 1021, 170, 5, 70, "Input",
 CellID->4421],
Cell[33755, 1028, 2720, 69, 154, "Output",
 CellID->96345189]
}, Open  ]],
Cell[36490, 1100, 139, 4, 70, "MathCaption",
 CellID->15635],
Cell[CellGroupData[{
Cell[36654, 1108, 342, 9, 70, "Input",
 CellID->30668],
Cell[36999, 1119, 1954, 48, 116, "Output",
 CellID->266959860]
}, Open  ]]
}, Open  ]],
Cell[38980, 1171, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

