(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6100,        207]
NotebookOptionsPosition[      3974,        144]
NotebookOutlinePosition[      5195,        176]
CellTagsIndexPosition[      5152,        173]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Audio Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["Waveform",
  BaseStyle->"Link",
  ButtonData->"paclet:Audio/ref/Waveform"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[TextData[ButtonBox["Sound",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sound"]], "InlineFunctionSans"],
 " object representing a wave of given type, frequency, and duration"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sinusoid",
  BaseStyle->"Link",
  ButtonData->"paclet:Audio/ref/Sinusoid"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Square",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:Audio/ref/Square"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Triangle",
  BaseStyle->"Link",
  ButtonData->"paclet:Audio/ref/Triangle"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sawtooth",
  BaseStyle->"Link",
  ButtonData->"paclet:Audio/ref/Sawtooth"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Overtones",
  BaseStyle->"Link",
  ButtonData->"paclet:Audio/ref/Overtones"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->160096249],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListWaveform",
  BaseStyle->"Link",
  ButtonData->"paclet:Audio/ref/ListWaveform"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " waveform of a specified frequency spectrum"
}], "GuideText",
 CellID->28785710],

Cell["\t", "GuideDelimiter",
 CellID->247012644],

Cell[TextData[{
 Cell[TextData[ButtonBox["AmplitudeModulation",
  BaseStyle->"Link",
  ButtonData->"paclet:Audio/ref/AmplitudeModulation"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " amplitude-modulated sinusoidal waveform"
}], "GuideText",
 CellID->961166144],

Cell[TextData[{
 Cell[TextData[ButtonBox["FrequencyModulation",
  BaseStyle->"Link",
  ButtonData->"paclet:Audio/ref/FrequencyModulation"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " frequency-modulated sinusoidal waveform"
}], "GuideText",
 CellID->418199141]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Audio Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Audio/tutorial/Audio"]], "GuideTutorial",
 CellID->122143074]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Sound and Sonification",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SoundAndSonification"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/guide/MusicPackage"]], "GuideMoreAbout",
 CellID->112749043]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Audio Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 50.3008714}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Audio Package Guide", 
    "language" -> "en", "paclet" -> "Audio Package", "status" -> "None", 
    "summary" -> 
    "Waveform -- Sound object representing a wave of given type, frequency, \
and duration, ListWaveform -- waveform of a specified frequency spectrum, \
AmplitudeModulation -- amplitude-modulated sinusoidal waveform, \
FrequencyModulation -- frequency-modulated sinusoidal waveform", 
    "synonyms" -> {}, "title" -> "Audio Package", "type" -> "Guide", "uri" -> 
    "Audio/guide/AudioPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 55, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[677, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[736, 31, 415, 12, 70, "GuideText",
 CellID->203374175],
Cell[1154, 45, 1193, 32, 70, "InlineGuideFunctionListing",
 CellID->160096249],
Cell[2350, 79, 279, 8, 70, "GuideText",
 CellID->28785710],
Cell[2632, 89, 48, 1, 70, "GuideDelimiter",
 CellID->247012644],
Cell[2683, 92, 294, 9, 70, "GuideText",
 CellID->961166144],
Cell[2980, 103, 294, 9, 70, "GuideText",
 CellID->418199141]
}, Open  ]],
Cell[CellGroupData[{
Cell[3311, 117, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[3376, 120, 143, 3, 70, "GuideTutorial",
 CellID->122143074]
}, Open  ]],
Cell[CellGroupData[{
Cell[3556, 128, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[3621, 131, 160, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[3784, 136, 148, 3, 70, "GuideMoreAbout",
 CellID->112749043]
}, Open  ]],
Cell[3947, 142, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

