(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6725,        235]
NotebookOptionsPosition[      5016,        179]
NotebookOutlinePosition[      6029,        208]
CellTagsIndexPosition[      5986,        205]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["AUDIO PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Audio Package" :> 
          Documentation`HelpLookup["paclet:Audio/tutorial/Audio"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Audio Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FrequencyModulation" :> 
          Documentation`HelpLookup["paclet:Audio/ref/FrequencyModulation"], 
          "ModulationType" :> 
          Documentation`HelpLookup["paclet:Audio/ref/ModulationType"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"FrequencyModulation\"\>", 
       2->"\<\"ModulationType\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Cascade", "ObjectName",
 CellID->4124],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Cascade"], "InlineFormula"],
     " \[LineSeparator]is a setting of ",
     Cell[BoxData[
      ButtonBox["ModulationType",
       BaseStyle->"Link",
       ButtonData->"paclet:Audio/ref/ModulationType"]], "InlineFormula"],
     ", an option of function ",
     Cell[BoxData[
      ButtonBox["FrequencyModulation",
       BaseStyle->"Link",
       ButtonData->"paclet:Audio/ref/FrequencyModulation"]], "InlineFormula"],
     
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32443]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ModulationType",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/ModulationType"], "->", "Cascade"}]], 
  "InlineFormula"],
 " specifies to use cascade frequency modulation."
}], "Notes",
 CellID->12482],

Cell["\<\
In cascade frequency modulation, the modulating frequency is itself modulated \
by a second frequency, which may be modulated by a third frequency, and so \
on.\
\>", "Notes",
 CellID->7859]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23642],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrequencyModulation",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/FrequencyModulation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ModulationType",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/ModulationType"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20670]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4035],

Cell[TextData[ButtonBox["Audio Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Audio/tutorial/Audio"]], "Tutorials",
 CellID->30495]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cascade - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 50.6915064}", "context" -> "Audio`", 
    "keywords" -> {}, "index" -> True, "label" -> "Audio Package Symbol", 
    "language" -> "en", "paclet" -> "Audio Package", "status" -> "None", 
    "summary" -> 
    "Cascade is a setting of ModulationType, an option of function \
FrequencyModulation. ", "synonyms" -> {}, "title" -> "Cascade", "type" -> 
    "Symbol", "uri" -> "Audio/ref/Cascade"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1303, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1926, 60, 44, 1, 70, "ObjectName",
 CellID->4124],
Cell[1973, 63, 679, 21, 70, "Usage",
 CellID->32443]
}, Open  ]],
Cell[CellGroupData[{
Cell[2689, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3167, 106, 268, 9, 70, "Notes",
 CellID->12482],
Cell[3438, 117, 200, 5, 70, "Notes",
 CellID->7859]
}, Closed]],
Cell[CellGroupData[{
Cell[3675, 127, 311, 9, 70, "SeeAlsoSection",
 CellID->23642],
Cell[3989, 138, 497, 17, 70, "SeeAlso",
 CellID->20670]
}, Open  ]],
Cell[CellGroupData[{
Cell[4523, 160, 313, 9, 70, "TutorialsSection",
 CellID->4035],
Cell[4839, 171, 135, 3, 70, "Tutorials",
 CellID->30495]
}, Open  ]],
Cell[4989, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

