(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6458,        227]
NotebookOptionsPosition[      4728,        172]
NotebookOutlinePosition[      5813,        202]
CellTagsIndexPosition[      5770,        199]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["AUDIO PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Audio Package" :> 
          Documentation`HelpLookup["paclet:Audio/tutorial/Audio"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Audio Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Waveform" :> 
          Documentation`HelpLookup["paclet:Audio/ref/Waveform"], "Fourier" :> 
          Documentation`HelpLookup["paclet:ref/Fourier"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Waveform\"\>", 
       2->"\<\"Fourier\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Overtones", "ObjectName",
 CellID->10863],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Overtones"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["Waveform",
       BaseStyle->"Link",
       ButtonData->"paclet:Audio/ref/Waveform"]], "InlineFormula"],
     " that specifies the number of overtones to be present in a standard \
waveform when created with ",
     Cell[BoxData[
      ButtonBox["Fourier",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Fourier"]], "InlineFormula"],
     " summation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11559]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Overtones", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " a standard waveform is created with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " overtones."
}], "Notes",
 CellID->29707]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17993],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Waveform",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/Waveform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fourier",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fourier"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3682]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21803],

Cell[TextData[ButtonBox["Audio Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Audio/tutorial/Audio"]], "Tutorials",
 CellID->26519]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Overtones - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 51.9259130}", "context" -> "Audio`", 
    "keywords" -> {}, "index" -> True, "label" -> "Audio Package Symbol", 
    "language" -> "en", "paclet" -> "Audio Package", "status" -> "None", 
    "summary" -> 
    "Overtones is an option to Waveform that specifies the number of \
overtones to be present in a standard waveform when created with Fourier \
summation.", "synonyms" -> {}, "title" -> "Overtones", "type" -> "Symbol", 
    "uri" -> "Audio/ref/Overtones"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1231, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1854, 59, 47, 1, 70, "ObjectName",
 CellID->10863],
Cell[1904, 62, 715, 21, 70, "Usage",
 CellID->11559]
}, Open  ]],
Cell[CellGroupData[{
Cell[2656, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3134, 105, 258, 10, 70, "Notes",
 CellID->29707]
}, Closed]],
Cell[CellGroupData[{
Cell[3429, 120, 311, 9, 70, "SeeAlsoSection",
 CellID->17993],
Cell[3743, 131, 454, 17, 70, "SeeAlso",
 CellID->3682]
}, Open  ]],
Cell[CellGroupData[{
Cell[4234, 153, 314, 9, 70, "TutorialsSection",
 CellID->21803],
Cell[4551, 164, 135, 3, 70, "Tutorials",
 CellID->26519]
}, Open  ]],
Cell[4701, 170, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

