(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6685,        234]
NotebookOptionsPosition[      4971,        178]
NotebookOutlinePosition[      5988,        207]
CellTagsIndexPosition[      5945,        204]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["AUDIO PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Audio Package" :> 
          Documentation`HelpLookup["paclet:Audio/tutorial/Audio"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Audio Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FrequencyModulation" :> 
          Documentation`HelpLookup["paclet:Audio/ref/FrequencyModulation"], 
          "ModulationType" :> 
          Documentation`HelpLookup["paclet:Audio/ref/ModulationType"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"FrequencyModulation\"\>", 
       2->"\<\"ModulationType\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Parallel", "ObjectName",
 CellID->11983],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Parallel"], "InlineFormula"],
     " \[LineSeparator]is a setting of ",
     Cell[BoxData[
      ButtonBox["ModulationType",
       BaseStyle->"Link",
       ButtonData->"paclet:Audio/ref/ModulationType"]], "InlineFormula"],
     ", an option of function ",
     Cell[BoxData[
      ButtonBox["FrequencyModulation",
       BaseStyle->"Link",
       ButtonData->"paclet:Audio/ref/FrequencyModulation"]], "InlineFormula"],
     
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1792]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ModulationType",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/ModulationType"], "->", "Parallel"}]], 
  "InlineFormula"],
 " specifies to use parallel frequency modulation."
}], "Notes",
 CellID->27307],

Cell["\<\
In parallel frequency modulation, the carrier frequency is modulated by two \
or more frequencies in parallel.\
\>", "Notes",
 CellID->14693]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19824],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrequencyModulation",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/FrequencyModulation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ModulationType",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/ModulationType"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25786],

Cell[TextData[ButtonBox["Audio Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Audio/tutorial/Audio"]], "Tutorials",
 CellID->19999]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Parallel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 52.6915576}", "context" -> "Audio`", 
    "keywords" -> {}, "index" -> True, "label" -> "Audio Package Symbol", 
    "language" -> "en", "paclet" -> "Audio Package", "status" -> "None", 
    "summary" -> 
    "Parallel is a setting of ModulationType, an option of function \
FrequencyModulation. ", "synonyms" -> {}, "title" -> "Parallel", "type" -> 
    "Symbol", "uri" -> "Audio/ref/Parallel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1303, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1926, 60, 46, 1, 70, "ObjectName",
 CellID->11983],
Cell[1975, 63, 679, 21, 70, "Usage",
 CellID->1792]
}, Open  ]],
Cell[CellGroupData[{
Cell[2691, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3169, 106, 270, 9, 70, "Notes",
 CellID->27307],
Cell[3442, 117, 151, 4, 70, "Notes",
 CellID->14693]
}, Closed]],
Cell[CellGroupData[{
Cell[3630, 126, 311, 9, 70, "SeeAlsoSection",
 CellID->19824],
Cell[3944, 137, 496, 17, 70, "SeeAlso",
 CellID->4990]
}, Open  ]],
Cell[CellGroupData[{
Cell[4477, 159, 314, 9, 70, "TutorialsSection",
 CellID->25786],
Cell[4794, 170, 135, 3, 70, "Tutorials",
 CellID->19999]
}, Open  ]],
Cell[4944, 176, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

