(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7222,        256]
NotebookOptionsPosition[      5567,        202]
NotebookOutlinePosition[      6524,        229]
CellTagsIndexPosition[      6481,        226]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["AUDIO PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Audio Package" :> 
          Documentation`HelpLookup["paclet:Audio/tutorial/Audio"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Audio Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sin" :> Documentation`HelpLookup["paclet:ref/Sin"], "Cos" :> 
          Documentation`HelpLookup["paclet:ref/Cos"], "Exp" :> 
          Documentation`HelpLookup["paclet:ref/Exp"], "Waveform" :> 
          Documentation`HelpLookup["paclet:Audio/ref/Waveform"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Sin\"\>", 2->"\<\"Cos\"\>", 
       3->"\<\"Exp\"\>", 4->"\<\"Waveform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Sinusoid", "ObjectName",
 CellID->14955],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Sinusoid"], "InlineFormula"],
     " \[LineSeparator]is a type of waveform."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21902]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Sinusoid"], "InlineFormula"],
 " represents a waveform described mathematically by ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 ", and the real part of exponentials of imaginary quantities."
}], "Notes",
 CellID->17021],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Waveform",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/Waveform"], "[", 
   RowBox[{"Sinusoid", ",", 
    StyleBox["freq", "TI"], ",", 
    StyleBox["dur", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " object of a sinusoidal waveform."
}], "Notes",
 CellID->8347]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13070],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cos",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cos"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Exp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Waveform",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/Waveform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5389]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14258],

Cell[TextData[ButtonBox["Audio Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Audio/tutorial/Audio"]], "Tutorials",
 CellID->15754]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sinusoid - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 59.1604732}", "context" -> "Audio`", 
    "keywords" -> {}, "index" -> True, "label" -> "Audio Package Symbol", 
    "language" -> "en", "paclet" -> "Audio Package", "status" -> "None", 
    "summary" -> "Sinusoid is a type of waveform.", "synonyms" -> {}, "title" -> 
    "Sinusoid", "type" -> "Symbol", "uri" -> "Audio/ref/Sinusoid"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1372, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1995, 60, 46, 1, 70, "ObjectName",
 CellID->14955],
Cell[2044, 63, 320, 10, 70, "Usage",
 CellID->21902]
}, Open  ]],
Cell[CellGroupData[{
Cell[2401, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2879, 95, 434, 14, 70, "Notes",
 CellID->17021],
Cell[3316, 111, 453, 16, 70, "Notes",
 CellID->8347]
}, Closed]],
Cell[CellGroupData[{
Cell[3806, 132, 311, 9, 70, "SeeAlsoSection",
 CellID->13070],
Cell[4120, 143, 916, 35, 70, "SeeAlso",
 CellID->5389]
}, Open  ]],
Cell[CellGroupData[{
Cell[5073, 183, 314, 9, 70, "TutorialsSection",
 CellID->14258],
Cell[5390, 194, 135, 3, 70, "Tutorials",
 CellID->15754]
}, Open  ]],
Cell[5540, 200, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

