(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10112,        339]
NotebookOptionsPosition[      8122,        276]
NotebookOutlinePosition[      9223,        306]
CellTagsIndexPosition[      9180,        303]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["AUDIO PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Audio Package" :> 
          Documentation`HelpLookup["paclet:Audio/tutorial/Audio"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Audio Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sound" :> Documentation`HelpLookup["paclet:ref/Sound"], 
          "ListWaveform" :> 
          Documentation`HelpLookup["paclet:Audio/ref/ListWaveform"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Sound\"\>", 
       2->"\<\"ListWaveform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Waveform", "ObjectName",
 CellID->7339],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Waveform", "[", 
       RowBox[{
        StyleBox["type", "TI"], ",", 
        StyleBox["freq", "TI"], ",", 
        StyleBox["dur", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates a ",
     Cell[BoxData[
      ButtonBox["Sound",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
     " object that is a standard waveform of type ",
     Cell[BoxData[
      StyleBox["type", "TI"]], "InlineFormula"],
     ", having a fundamental frequency of ",
     Cell[BoxData[
      StyleBox["freq", "TI"]], "InlineFormula"],
     " hertz, and a duration of ",
     Cell[BoxData[
      StyleBox["dur", "TI"]], "InlineFormula"],
     " seconds."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21374]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The type ",
 Cell[BoxData[
  StyleBox["type", "TI"]], "InlineFormula"],
 " must be one of the following:"
}], "Notes",
 CellID->26206],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Sinusoid",
     BaseStyle->"Link",
     ButtonData->"paclet:Audio/ref/Sinusoid"], Cell[
    "sinusoidal waveform type", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Sawtooth",
     BaseStyle->"Link",
     ButtonData->"paclet:Audio/ref/Sawtooth"], Cell[
    "sawtooth waveform type", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Square",
     BaseStyle->"Link",
     ButtonData->"paclet:Audio/ref/Square"], Cell[
    "square waveform type", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Triangle",
     BaseStyle->"Link",
     ButtonData->"paclet:Audio/ref/Triangle"], Cell[
    "triangular waveform type", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->680480612],

Cell["The following options can be given:", "Notes",
 CellID->20028],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DisplayFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DisplayFunction"], 
    ButtonBox["Identity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Identity"], Cell[
    "function to apply to sound before returning it", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Overtones",
     BaseStyle->"Link",
     ButtonData->"paclet:Audio/ref/Overtones"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the number of overtones", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlayRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlayRange"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "range of sound amplitude levels to include", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SampleDepth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SampleDepth"], "8", Cell[
    "number of bits used to encode sound amplitude", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SampleRate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SampleRate"], "8192", Cell[
    "sampling rate per second", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->8342],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Waveform", "[", 
   StyleBox["type", "TI"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["freq", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["dur", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Overtones",
     BaseStyle->"Link",
     ButtonData->"paclet:Audio/ref/Overtones"], "->", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " creates a standard waveform with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " overtones."
}], "Notes",
 CellID->1783]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6263],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sound",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sound"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListWaveform",
    BaseStyle->"Link",
    ButtonData->"paclet:Audio/ref/ListWaveform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->311531743]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14201],

Cell[TextData[ButtonBox["Audio Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Audio/tutorial/Audio"]], "Tutorials",
 CellID->18228]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Waveform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 1.0823974}", "context" -> "Audio`", 
    "keywords" -> {}, "index" -> True, "label" -> "Audio Package Symbol", 
    "language" -> "en", "paclet" -> "Audio Package", "status" -> "None", 
    "summary" -> 
    "Waveform[type, freq, dur] creates a Sound object that is a standard \
waveform of type type, having a fundamental frequency of freq hertz, and a \
duration of dur seconds.", "synonyms" -> {}, "title" -> "Waveform", "type" -> 
    "Symbol", "uri" -> "Audio/ref/Waveform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1237, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1860, 59, 45, 1, 70, "ObjectName",
 CellID->7339],
Cell[1908, 62, 944, 29, 70, "Usage",
 CellID->21374]
}, Open  ]],
Cell[CellGroupData[{
Cell[2889, 96, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3367, 113, 152, 6, 70, "Notes",
 CellID->26206],
Cell[3522, 121, 1024, 27, 70, "2ColumnTableMod",
 CellID->680480612],
Cell[4549, 150, 68, 1, 70, "Notes",
 CellID->20028],
Cell[4620, 153, 1573, 41, 70, "3ColumnTableMod",
 CellID->8342],
Cell[6196, 196, 582, 23, 70, "Notes",
 CellID->1783]
}, Closed]],
Cell[CellGroupData[{
Cell[6815, 224, 310, 9, 70, "SeeAlsoSection",
 CellID->6263],
Cell[7128, 235, 463, 17, 70, "SeeAlso",
 CellID->311531743]
}, Open  ]],
Cell[CellGroupData[{
Cell[7628, 257, 314, 9, 70, "TutorialsSection",
 CellID->14201],
Cell[7945, 268, 135, 3, 70, "Tutorials",
 CellID->18228]
}, Open  ]],
Cell[8095, 274, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

