(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23202,        615]
NotebookOptionsPosition[     20568,        534]
NotebookOutlinePosition[     22085,        574]
CellTagsIndexPosition[     22000,        569]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BAR CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart"], "Cuboid" :> 
         Documentation`HelpLookup["paclet:ref/Cuboid"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"BarChart\"\>", 
      2->"\<\"Cuboid\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BarChart3D", "ObjectName",
 CellID->5809],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BarChart3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["z", "TI"], 
            StyleBox["11", "TR"]], ",", 
           SubscriptBox[
            StyleBox["z", "TI"], 
            StyleBox["12", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["z", "TI"], 
            StyleBox["21", "TR"]], ",", 
           SubscriptBox[
            StyleBox["z", "TI"], 
            StyleBox["22", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a three-dimensional bar chart using the \
matrix of heights ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["ij", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BarChart3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["z", "TI"], 
              StyleBox["11", "TR"]], ",", 
             SubscriptBox[
              StyleBox["style", "TI"], 
              StyleBox["11", "TR"]]}], "}"}], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses a specific style for each bar."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BarChart3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["x", "TI"], 
              StyleBox["1", "TR"]], ",", 
             SubscriptBox[
              StyleBox["y", "TI"], 
              StyleBox["1", "TR"]], ",", 
             SubscriptBox[
              StyleBox["z", "TI"], 
              StyleBox["1", "TR"]]}], "}"}], ",", 
           SubscriptBox[
            StyleBox["style", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a bar chart of bars scattered at specific ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " coordinates with height ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " and a specific ",
     Cell[BoxData[
      StyleBox["style", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->6025]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["BarChart3D"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ", with the following additions and changes: "
}], "Notes",
 CellID->23000],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarSpacing",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarSpacing"], "0", Cell[TextData[{
     "space between bars in the ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " directions"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarEdges",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarEdges"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw the edges of bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarEdgeStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarEdgeStyle"], 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", "0", "]"}], Cell[
    "style for edges of bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarStyle"], 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", "1", "]"}], Cell[
    "style for faces of bars", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->23965]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->213634305],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->198991003],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->654625820],

Cell["Chart of an array of heights:", "ExampleText",
 CellID->236946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "6", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "7", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->141381441],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[1, 2], Rational[1, 2], 0}, {0.5, 0.5, 0}], 
     NCache[{Rational[3, 2], Rational[3, 2], 1}, {1.5, 1.5, 1}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[1, 2], Rational[3, 2], 0}, {0.5, 1.5, 0}], 
     NCache[{Rational[3, 2], Rational[5, 2], 6}, {1.5, 2.5, 6}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[1, 2], Rational[5, 2], 0}, {0.5, 2.5, 0}], 
     NCache[{Rational[3, 2], Rational[7, 2], 8}, {1.5, 3.5, 8}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[3, 2], Rational[1, 2], 0}, {1.5, 0.5, 0}], 
     NCache[{Rational[5, 2], Rational[3, 2], 2}, {2.5, 1.5, 2}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[3, 2], Rational[3, 2], 0}, {1.5, 1.5, 0}], 
     NCache[{Rational[5, 2], Rational[5, 2], 7}, {2.5, 2.5, 7}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[3, 2], Rational[5, 2], 0}, {1.5, 2.5, 0}], 
     NCache[{Rational[5, 2], Rational[7, 2], 1}, {2.5, 3.5, 1}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[5, 2], Rational[1, 2], 0}, {2.5, 0.5, 0}], 
     NCache[{Rational[7, 2], Rational[3, 2], 3}, {3.5, 1.5, 3}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[5, 2], Rational[3, 2], 0}, {2.5, 1.5, 0}], 
     NCache[{Rational[7, 2], Rational[5, 2], 1}, {3.5, 2.5, 1}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{Rational[5, 2], Rational[5, 2], 0}, {2.5, 2.5, 0}], 
     NCache[{Rational[7, 2], Rational[7, 2], 4}, {3.5, 3.5, 4}]]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->Automatic,
  AxesEdge->Automatic,
  AxesLabel->None,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  BoxRatios->{1, 1, 1},
  BoxStyle->{},
  Boxed->True,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  ControllerLinking->Automatic,
  ControllerMethod->Automatic,
  ControllerPath->Automatic,
  DefaultAxesStyle->{},
  DefaultBaseStyle->"Graphics3D",
  DefaultBoxStyle->{},
  DefaultLabelStyle->"Graphics3DLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FaceGrids->None,
  FaceGridsStyle->{},
  FormatType:>TraditionalForm,
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Lighting->Automatic,
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  SphericalRegion->False,
  Ticks->Automatic,
  TicksStyle->{},
  ViewAngle->Automatic,
  ViewCenter->NCache[{
     Rational[1, 2], 
     Rational[1, 2], 
     Rational[1, 2]}, {0.5, 0.5, 0.5}],
  ViewMatrix->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewRange->All,
  ViewVector->Automatic,
  ViewVertical->{0, 0, 1}]], "Output",
 ImageSize->{364, 383},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->202350788,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27702],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cuboid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cuboid"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10394]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BarChart3D - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 6.7387922}", "context" -> "BarCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Bar Charts Package Symbol",
     "language" -> "en", "paclet" -> "BarCharts Package", "status" -> "None", 
    "summary" -> 
    "BarChart3D[{{z_11, z_12, ...}, {z_21, z_22, ...}, ...}] generates a \
three-dimensional bar chart using the matrix of heights z_ij. \
BarChart3D[{{{z_11, style_11}, ...}, ...}] uses a specific style for each \
bar. BarChart3D[{{{x_1, y_1, z_1}, style_1}, ...}] generates a bar chart of \
bars scattered at specific x and y coordinates with height z and a specific \
style.", "synonyms" -> {}, "title" -> "BarChart3D", "type" -> "Symbol", "uri" -> 
    "BarCharts/ref/BarChart3D"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6774, 222, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->213634305]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21857, 562}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 663, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1286, 43, 47, 1, 70, "ObjectName",
 CellID->5809],
Cell[1336, 46, 2999, 93, 70, "Usage",
 CellID->6025]
}, Open  ]],
Cell[CellGroupData[{
Cell[4372, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4850, 161, 292, 9, 70, "Notes",
 CellID->23000],
Cell[5145, 172, 1592, 45, 70, "3ColumnTableMod",
 CellID->23965]
}, Closed]],
Cell[CellGroupData[{
Cell[6774, 222, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->213634305],
Cell[CellGroupData[{
Cell[7159, 236, 148, 5, 70, "ExampleSection",
 CellID->198991003],
Cell[7310, 243, 132, 3, 70, "Input",
 CellID->654625820],
Cell[7445, 248, 69, 1, 70, "ExampleText",
 CellID->236946],
Cell[CellGroupData[{
Cell[7539, 253, 346, 11, 28, "Input",
 CellID->141381441],
Cell[7888, 266, 11806, 228, 404, 2917, 78, "CachedBoxData", "BoxData", \
"Output",
 CellID->202350788]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19755, 501, 311, 9, 70, "SeeAlsoSection",
 CellID->27702],
Cell[20069, 512, 457, 17, 70, "SeeAlso",
 CellID->10394]
}, Open  ]],
Cell[20541, 532, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

