(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14401,        465]
NotebookOptionsPosition[     11418,        363]
NotebookOutlinePosition[     12652,        399]
CellTagsIndexPosition[     12567,        394]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BAR CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart"], 
         "BarChart3D" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart3D"], 
         "BarStyle" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarStyle"], 
         "BarEdges" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarEdges"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"BarChart\"\>", 
      2->"\<\"BarChart3D\"\>", 3->"\<\"BarStyle\"\>", 
      4->"\<\"BarEdges\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BarEdgeStyle", "ObjectName",
 CellID->31667],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BarEdgeStyle"], "InlineFormula"],
     " \[LineSeparator]is an option for bar charts that determines the style \
for the edges."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->257]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Styles can be specified using graphics directives such as ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->248958800],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->371783223],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->318647610],

Cell["A single style can be used:", "ExampleText",
 CellID->1356556859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", " ", 
   RowBox[{"BarEdgeStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1117931153],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW8FOwzAMTdd2u4I4wHFfAuICJwZI24SEOEwT0IIQaOyK+Bv+ixvaT5S4
a2jrJmvapVsXPKlJvNrPrp05TttdTObB/ctkHk4n/fPZ5C0Ip+/9s9cZ/8p1
GHMCxtj3EePjiI/iAz4hP5ZDPBrw1uVsj7z3eB8k9Gl89hJaV6BEMZegecue
0fljqVSA6CctqVCiu6O0DHNjnSdSqQdovJRWXdEg0R1m+tRLe0gGmnHJGeYm
LhTDDBdo8NWSOXu9whV4xiQPeDPi5CHvh6jXQ4P+hh9Obf3gi+u7269Oohf6
qxX0xrRk4tdNOHDM6iHjObNtFADZtg2EQhEmFIowoVCEy1FUtRXQwGVmnc5X
FT2E2bFIh8/JfQPYfmSyTipiZzHNV3m9hMMMcpt+L5Q//gMKRdh2FIqw7SgU
4RRluRCLD66FgM9MnYGR45KggTtKenpELTZq2P4m8T+3iqtz504PCc/jpqVA
qJ2W2SpFHieP2y5lk8fVNUFMs7qZHq9FXUTj8+ZQYb3/aJGNXrTOiilDW0Vr
Rl3jLk375qptv73dkCKPk8d3R4p8Bxs+nb29HpqoDzLExnaqYiUfKnEK7wFp
2WcSb6HwWkGmDorGvlsuiWfOulzAtBlNbeUiD9jsgd27NpzlIUfo54d8Vi97
Si7H0N2L/UilcabFduvZgFHcqEqWrPY8vDxHq3ZSNIfJA3RtNnnAZXrvoOtl
rbpVprFqNZPDfCmGyOPpu+zVnzUtcvLVbYdm/Od9VT2ccuFIpmdghP/VwZxf
+nXoSQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->307013906]
}, Open  ]],

Cell["For a single set of data, styles are repeated cyclically:", \
"ExampleText",
 CellID->1964732661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"Range", "[", "5", "]"}], ",", " ", 
   RowBox[{"BarEdgeStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Thick"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->347805520],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXMtOwkAUHSgkxueWuGJndOMj6hJQE90oiW6NJg0xgYXRID+iH+EPGX/B
36j3Mi2Py7QUQum0nIbOzO3MPed0HmU6bXrn9tovr26v03KrN133vd1pfVSv
37p0yCkoVWgrpf4qitIepfo7bx3adVKmDil0qFid4pIfs33FuU7g76maf/yg
73UkcusjNoXqUuQ3hH0h7D0j6jSvmq9ZspnRTN5FMkePK8OZx0Ore5PaA/Ri
aL2xBlUa2pPnUjeo5OT+oPVGWRohrReo0V58SLf+mijHwbMW4vjVQVs5vNSY
9tKc5ZoUnJN578cPIT4cu1pSJN5G36acp8dv+qljDhxvkL/p18YJHed4e8Hl
t2KcsyUaI1rZDoWyh0IVVC1KFYuyR42ddQRVUAVVUIWrJ1RBFVRlTxWuU1AF
VVBluypcp6AKqpavSi/NBpud67RFocqByoWqLJO5TvGpp1HSr6vmCqlQEU8h
lqNAXpnAmh9WJs37OYIVrFlnxTgFK1jBiqsDWMGaVVaMU7BmkZVf1jS9l5o8
c7D+OGJYsQ7Ea2K3nn4jNxlWudokVTRTZf9KqLWHDJOtnRBnxPpaMoxyDIMl
7n9n1s8BLGDJBwtGI1jAgnECFrBgnIDFVhZnaXd16dwxp3SfLu6ZeTXk05vv
DaF479r8JlI7c6Ia+tR8SHIMAGX8HyFtDUCxHwX9BCjobUCxCwX9xE6UZOaZ
yaAGT115dv3jxXvaF8zPNbcKmanOguTDGJA42F0iyrRajo8k+1KePQNHu1XC
E+24Gp5ox1X3RA8weZpW1WbwFp5yrmALUtk3K7SfUZmdfslp86Pxr05yGF6K
WYoq6nuTpjbSOZyS30BVhX9iwauq\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->919249408]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 " can be used to combine styles:"
}], "ExampleText",
 CellID->1416519629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"Range", "[", "5", "]"}], ",", " ", 
   RowBox[{"BarEdgeStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->441693961],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW8FOg0AQ3QJNNMaeG0+9Gb1oPPRYqiZ60f6A0YQ0Ju3BaGo/xPgR/pDx
F/wN3CnQ0ukuULIg0EfCssPOvDfsDO0shHtvPnl+8ebTsde7nXlvk+n4vXfz
OpOn7JYQrYkQ4rcrZN+XvcVO21TuQZf3zmRrSzVXHp3wSPI1jdqRvS8G4fnT
hdU5G3VjsmzFFRsfMvmSycdK1DSrQegzZ1OjqawtKcbPC8WVZ0Nz/U3fI3RL
O2/kg3BW8ua1uAovqXuyjF6cZaiJXuRNYEWngujvMT1qngJH7HA65NbWa635
7uTUO5BNXw4chseORu5osOjoBa6m8lhy4OLx4csK8eNyZ8txnT8lcCZEpxhG
nilgqQ4LkdT9GsAClmaw4G4EC1hwn4AFLLhPwFJVlmCpGm3lrFstxmJXhrVf
KFtbivuFs8TlUY1Ykp5mmGHgdxRQzaESaNV9BCpQkadA3V1UZD9Q64CKPN1N
VEexBjWDHK1zY0Ip6yRa8935qzfX26Py1RZnGRWK/plztpPehufETFgf5kPk
OdwMFAL5bx+AsisoyDagIE+AgjxpNoptrOoqpuLMgprlvYu61qQq/mMrhLR3
Jj9GriojiiJ22Sx57jTJioyq6RmsEKddsUJ062GFOOWzMlMHmEGJnq5SNfPt
q58aRvXP8lGpsnJIsvTXKqe4JTVHBq3SZkVvyWNZZc1Isar+1UUT84h5rKdm
M2ZctQpN0Gaa/Le+LMt2KHb9ta9PM/xfbWpTq/+KltgskfT9rGqugxHq8W+6
ResP/U7/zw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->241781075]
}, Open  ]],

Cell["For multiple sets of data, styles are used per set:", "ExampleText",
 CellID->1553277155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"BarEdgeStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Dashed"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1728259984],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXMFu1DAQ9TbZ9ooQoD32QKF8RAlwgBPlViFVHFYVkIAQqPQX+JX+FzfE
TwSPN1a8EztxUuKMk4l2nUzsGT9PPGN71pu325v847ftTXG1PX5zvf2RF1c/
j19/v5a3kpUQq1wI8Xsj5HUpr9QXjkJ+d5f46lymiSz2WZ5Tec4r+qXKfQdp
oqWUqpSmZSq+ovznVq4c0V+8uApL3QdOZLg0rjOzcn2CJK1pV4vOq7oL41xr
6R7igeSiI0cklQr1pVEKali7Offwpo0WpBNxwvm9/K4G1fVA0TLnw+Wt/IgT
SNLS4Hh6e/lr879LxYPT6C+H5a4X4j7Sje2JlGdyPPJCYHI8HMbRsAQr1qSW
g6VYkRrlT/vhlEf8OOEmZXx99HjqsgefMg08G38MAWyXcdwVB/utpfmDWHCy
32IcVP0W+wPGyX6LcbT6AkL+ao52xjjbcbriYEB7xzhG9mv7EaEjhOjAB2Hw
SFa8KNeSvE8CHfS92OJszRaYZbyimcS8wlH1FGLBHovnpTJj9JuZzH+GFicO
njEu1R9Qj3TyCpdxsN9if0ABH4V5Vpx2yjjYby3bH8SCc85+axd80AeOpQ2L
EY2DFGNTgRSSO9r8kOpo4DOTQ8qALvt4Ml/YX8tZ2bSzUJbMaMNEKl37MgFf
CO+Yabqyj5Mgc5ZwtUIlNNo4neexIaMyQ2Asbizzsn86lsj2T6ufM5aw9r90
S2T7p9XPGcu+Xc5r3F9Kre54j6IdazwaHgKvnw8RjfMzSz+eaq1vwwoRoDPi
GKnqE7pxyIiErf42OtP0uNbssZssDBKaPnTa2YweKXnmQB8Lz2ZirdW2TuRV
DGPph4Xtf06xU7Z/xtIPC0cx51Qr2z9gga0FPjt6psSo41EGQXZHhP++njOV
DUJ2h1qXSzJtOSdV7673Aw3jb29Zm4SGJNF4f1vn8/nb8SxejCq37zvPPKV6
7ITxk4S9w9hcwEQT2Vy5WOOs8Xi4WHd4jqRH22H+fX820/WmAj+Zvr8k/fGS
hkde3M5hGLFUoO+iRXPM7vqnf/8x3PVLCb3eyTbKGo+Li3XHGh/OlQi/d4ZP
u8ocbfVqjFFrq0w9zkOM4JW63f8/JZBcDGyHwduyFq5L4V5Q58AVfmO/WP0D
aPPx+A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->16038409]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13635],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart3D",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarEdges",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarEdges"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15677]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BarEdgeStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 7.7544432}", "context" -> "BarCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Bar Charts Package Symbol",
     "language" -> "en", "paclet" -> "BarCharts Package", "status" -> "None", 
    "summary" -> 
    "BarEdgeStyle is an option for bar charts that determines the style for \
the edges.", "synonyms" -> {}, "title" -> "BarEdgeStyle", "type" -> "Symbol", 
    "uri" -> "BarCharts/ref/BarEdgeStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3019, 108, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->248958800]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12424, 387}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 934, 22, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1557, 49, 50, 1, 70, "ObjectName",
 CellID->31667],
Cell[1610, 52, 370, 11, 70, "Usage",
 CellID->257]
}, Open  ]],
Cell[CellGroupData[{
Cell[2017, 68, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2495, 85, 487, 18, 70, "Notes",
 CellID->10069]
}, Closed]],
Cell[CellGroupData[{
Cell[3019, 108, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->248958800],
Cell[CellGroupData[{
Cell[3404, 122, 148, 5, 70, "ExampleSection",
 CellID->371783223],
Cell[3555, 129, 132, 3, 70, "Input",
 CellID->318647610],
Cell[3690, 134, 71, 1, 70, "ExampleText",
 CellID->1356556859],
Cell[CellGroupData[{
Cell[3786, 139, 237, 7, 28, "Input",
 CellID->1117931153],
Cell[4026, 148, 1014, 21, 246, "Output",
 Evaluatable->False,
 CellID->307013906]
}, Open  ]],
Cell[5055, 172, 103, 2, 70, "ExampleText",
 CellID->1964732661],
Cell[CellGroupData[{
Cell[5183, 178, 263, 8, 28, "Input",
 CellID->347805520],
Cell[5449, 188, 1095, 22, 251, "Output",
 Evaluatable->False,
 CellID->919249408]
}, Open  ]],
Cell[6559, 213, 211, 7, 70, "ExampleText",
 CellID->1416519629],
Cell[CellGroupData[{
Cell[6795, 224, 276, 8, 28, "Input",
 CellID->441693961],
Cell[7074, 234, 1018, 21, 251, "Output",
 Evaluatable->False,
 CellID->241781075]
}, Open  ]],
Cell[8107, 258, 95, 1, 70, "ExampleText",
 CellID->1553277155],
Cell[CellGroupData[{
Cell[8227, 263, 407, 13, 28, "Input",
 CellID->1728259984],
Cell[8637, 278, 1379, 27, 246, "Output",
 Evaluatable->False,
 CellID->16038409]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10077, 312, 311, 9, 70, "SeeAlsoSection",
 CellID->13635],
Cell[10391, 323, 985, 35, 70, "SeeAlso",
 CellID->15677]
}, Open  ]],
Cell[11391, 361, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

