(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10406,        342]
NotebookOptionsPosition[      7884,        258]
NotebookOutlinePosition[      9135,        294]
CellTagsIndexPosition[      9051,        289]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BAR CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart"], 
         "BarSpacing" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarSpacing"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"BarChart\"\>", 
      2->"\<\"BarSpacing\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BarGroupSpacing", "ObjectName",
 CellID->7628],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BarGroupSpacing"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["BarChart",
       BaseStyle->"Link",
       ButtonData->"paclet:BarCharts/ref/BarChart"]], "InlineFormula"],
     " that determines the spacing between groups of bars."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13198]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["BarGroupSpacing"], "InlineFormula"],
 " should be a number between 0 and 1."
}], "Notes",
 CellID->1399463768]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1555433],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->102309748],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->315119111],

Cell[TextData[{
 "Small values for ",
 Cell[BoxData["BarGroupSpacing"], "InlineFormula"],
 " place the groups of bars close together:"
}], "ExampleText",
 CellID->1351242136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"BarGroupSpacing", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1750816417],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnU+O0zAUh50mkTgCyzJUCLEIOwSIxSAkWKDJZpYVSNUIqV0gZtoeoBtO
wX7OgTgM1wjvNUmbmqTNFIXGni9S/Sex3/t9dhO3sdtcTJbTL18ny9nVZPhh
Prmezq4Ww/ff5rIrDIwJpsaY3w+NpDNJrV+6zeSVJ+3UuYShFLuROCpizb9Z
H32rYVhaydZHy7yEZmkdf1Vba27lF61q2aWuJRg0KrNL31j517W11KaJtvkm
ovPC96KI5zuttG3NB1ZtDT7nhsOiyWSLm0vtaIk6KKfxJJfRaON5cmnOPo1v
TSyprNwuk3fm7Hb83cSS2u5NE9n7Yyx702Szt3sLq9XqLwuB7AwkHxxoI0/4
Gt5RftBVzySIIILoeCIF8oPEv76BCCKIIILIRSJGVogggggiiBiH6BuIIIII
ovtKxDgEEUQQ+UqUTyOXm39zyoMK0ToJoReEsWQfSamcVqyJLTU3dJyrmn8C
Wy/Z9q18cpnLXusFCyyw7GdRFNcZfOoPWGCBBRbXWRhXYIEFFlhggYUxEhZY
YIEFlu5ZGFdggQUWF1mimn9PcJmnXJ9SyXhC1rSqYSTxSAwVKxvSRGqq+6EG
UVXDSFx3tf7hsH57Rt/muajTH240mKcov7Py/f+S0mPde1ZM9Fe1PS6g9L4p
VaH9VuhOW6IUpShFab+VcsVHKUpRilKuoyhFKUpRynXUj7ZEKUr7rjR06g65
uzMp7iq351J0zvCjxCMp9ayIW8wdrpp+O33czGU1/+uotvv3PuvMb8052ZUv
+0qFn/75UTc+cOAHP5w3+MEPfjg/8YMfzhv89NPPqb5zn8pvuY5d7278zHRF
dJro3Y3Hequk1V2SzaLx2qcTvqzR3X7N6v+ycKj121mx36M+1Sor9U8Ztegn
92rRTz7Xonfr7uW3rGnVssfmU1uJi+yLTD8lpcndPovsPtNZw+ZS6m1g9j2l
ua5v8iOasp/YbYI/J8lnbg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->61596522]
}, Open  ]],

Cell[TextData[{
 "Values for ",
 Cell[BoxData["BarGroupSpacing"], "InlineFormula"],
 " closer to 1 place the groups of bars far apart:"
}], "ExampleText",
 CellID->687012727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"BarGroupSpacing", "\[Rule]", "0.75"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1150589325],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnd9u0zAUh90kRVwhLrncE4SHmNgQYtWgXIyFIUXTpPYCgcYeoDc8xe57
jXgoXmMcxzFJvPzpNnVz3K9K7TjxOef3xXHcJq56lF8tLr7lV8vzfO/wMv+x
WJ7/3Dv4fimb4olSk4VS6u8rJes3sla89Wspb7Pqrp1IGku1z5Inkp+W5Xmx
V29VsfVy0yhLqs6c/cetVqdO+ctGVllL7KhTmVvbjfmh1UrTq6QqdxGdlLGz
Wl4dpepoPnesdfLVOI7LQyavaXethpZkC/V0nhsZvT7eFOXX6fwsW8uiIp3E
q9VKtkuqknX2SyXzdN/Ul03J+jpT8XyWlh4OCg+yo+4hEY9mv5gaH8an3jJL
jY//W0ofD1axW6w9Z1pYpG5vgw466B6HTsOFRxV2m0EHHXTQQQcdozh00EEH
HXTh0zHOQQcddNBBFzId4xx00EEHXT+dmQJgX2HPB4gcuhjaoGmnUtR2U7GK
rFbxp11Go6erl99D5y1d3yykcZO5IyM00ECz+ffT8VOE1SbQQAMNNCHRMM5A
Aw000EADDaMmNNBAAw00PtAwzkADDTRjp0la5o6Mm8jOi6kVgmHrmivxzmoU
F7KIYbpfzZu4zrSzqItLZMlSyDM2Ytw4Oo9B5s4ccEk/DdDMUH6PnlKpvN1T
PNbdMy/DX9XuuIHSXVOqhfqtcDzHEqUoRSlK/VbKFR+lKEUpSrmOohSlKEUp
19EwjiVKUeq70nhUd8jH+yRlvMrdZyn6aeJHyZ+JxXGZl08FZ2lDfVPLA36p
Pfgr4j8D8Y/uGXeo1bYWt6VXbiuWe60ijn9xdJgQOIhDHPoNcYhDHPoncYhD
vyGOn3Ge6jv3U8W189z1/Y3fOpcKrX7vOoNaWfX2DkqdRicvN/RSuvDAy1Ab
be7JPZtDtrSGfqvEknbcDUvacdctOQPaLNuePtzB2rF0Pyv44mlaFl9YD2JU
fOST5G1hteG/mZe1dNpdS0eM1O3fUFU12trL7NFr7j/aq8k/Axdy6A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->374746847]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29350],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarSpacing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5776]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BarGroupSpacing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 8.2544560}", "context" -> "BarCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Bar Charts Package Symbol",
     "language" -> "en", "paclet" -> "BarCharts Package", "status" -> "None", 
    "summary" -> 
    "BarGroupSpacing is an option for BarChart that determines the spacing \
between groups of bars.", "synonyms" -> {}, "title" -> "BarGroupSpacing", 
    "type" -> "Symbol", "uri" -> "BarCharts/ref/BarGroupSpacing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2595, 93, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1555433]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8911, 282}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 696, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1319, 44, 52, 1, 70, "ObjectName",
 CellID->7628],
Cell[1374, 47, 528, 15, 70, "Usage",
 CellID->13198]
}, Open  ]],
Cell[CellGroupData[{
Cell[1939, 67, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2417, 84, 141, 4, 70, "Notes",
 CellID->1399463768]
}, Closed]],
Cell[CellGroupData[{
Cell[2595, 93, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1555433],
Cell[CellGroupData[{
Cell[2978, 107, 148, 5, 70, "ExampleSection",
 CellID->102309748],
Cell[3129, 114, 132, 3, 70, "Input",
 CellID->315119111],
Cell[3264, 119, 174, 5, 70, "ExampleText",
 CellID->1351242136],
Cell[CellGroupData[{
Cell[3463, 128, 425, 13, 28, "Input",
 CellID->1750816417],
Cell[3891, 143, 1212, 24, 251, "Output",
 Evaluatable->False,
 CellID->61596522]
}, Open  ]],
Cell[5118, 170, 174, 5, 70, "ExampleText",
 CellID->687012727],
Cell[CellGroupData[{
Cell[5317, 179, 428, 13, 28, "Input",
 CellID->1150589325],
Cell[5748, 194, 1245, 24, 251, "Output",
 Evaluatable->False,
 CellID->374746847]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7054, 225, 311, 9, 70, "SeeAlsoSection",
 CellID->29350],
Cell[7368, 236, 474, 17, 70, "SeeAlso",
 CellID->5776]
}, Open  ]],
Cell[7857, 256, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

