(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28560,        751]
NotebookOptionsPosition[     25388,        644]
NotebookOutlinePosition[     26662,        681]
CellTagsIndexPosition[     26577,        676]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BAR CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart"], 
         "BarChart3D" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart3D"], 
         "BarGroupSpacing" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarGroupSpacing"]}, #,
         2]& , Evaluator -> Automatic], {1->"\<\"BarChart\"\>", 
      2->"\<\"BarChart3D\"\>", 
      3->"\<\"BarGroupSpacing\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BarSpacing", "ObjectName",
 CellID->776],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BarSpacing"], "InlineFormula"],
     " \[LineSeparator]is an option for bar charts that determines the \
fraction of the bar width to space the bars in a group of bars."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22060]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["BarSpacing"], "InlineFormula"],
 " sets the distance between bars within a group of bars in ",
 Cell[BoxData[
  ButtonBox["BarChart",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarChart"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->163600738],

Cell[TextData[{
 Cell[BoxData["BarSpacing"], "InlineFormula"],
 " sets the distance between groups of bars in ",
 Cell[BoxData[
  ButtonBox["PercentileBarChart",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/PercentileBarChart"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StackedBarChart",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/StackedBarChart"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->461944449],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["BarChart3D",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarChart3D"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"BarSpacing", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"]}], "}"}]}]], "InlineFormula"],
 " specifies distances between bars in the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " directions."
}], "Notes",
 CellID->858535406]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->355053700],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->49441916],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->227696189],

Cell["The bars within a group are tightly packed:", "ExampleText",
 CellID->677782903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"BarSpacing", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1243987033],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztncFu0zAYx926lbgikDa1Kpo4oR4KghcomgSbxLj0WIEUTUjtxgQae4Be
eArufQfE+/Aa5XMSL63lpJ3Ukjj5VYkTL/78/X92HLexs1xEd7MvN9Hd/DI6
eX8bfZ/NL3+cvPt2K3/SLaVaM6XU32Ml+yvZi1fzmcua7Lp7ZxJqSWZiHdle
pfHT+Oi5CbXNZRWnsnEJ1Y1zfOy1unLiX3eyuvb4bucqc1O7Pt96rWYm6GTx
PKKz1Pf12jYrpaw0HznWJvicZKzTIpNPNz/VhpbOAdKZbZTIKMzjSRx/OZp8
mi5lUT0T6OOj4XL6UxbVM4EeHj1f/prKovom0IvFotB+MjrdsJ98HKX2vdhe
4hv2kl+O/77XPvP/dIdyqgljwZlVD0K3VUEFFVT7oTJQ9aGpZx1BBRVUUEFV
Nyp6X6igggoqqKpMRT8FFVRQQQVVlanop6CCCqqmUSVD2/ZTz3HutkOloawV
ZVeij2U7kMRKj8fj4InW46+sF6hKpyqaMRMmkdurQQEFFNlvwnDV16MOoIAC
CiiqTEE/AQUUUEABRf0p6O2ggAIKKKCgn4ACCihCouh45jmESWLnbqxFgmfK
G98f2dxFkCyqZ4ItNAOB+f8E7ki3S3RxXy9+5Um9oXq3FlD0XzoqqrlgDkE1
FbvXfVQ2QaURWV11YZQhKlGJSlSWr5KrOSpRiUpUcp1EJSpRiUquk6hEJSrX
Vepg7kqHOWIRpmp3zMKMyH1YJU/cvlnZJ2+LVbhP5+7nOdI/SXnkenZHQfdT
Swfy6ml7h/HkXovwUh0vxknoDHjBC+0EL3hpihdaI17wQjvBSzleyvmdXI5X
O4Pb3IX4LdtnYvDa5pTOD+7H84O339e4nz7tfbfe0Kt/292RMnPZViO75+Se
t3W2tIbVVokl9dgMS+qx6ZacAT5L3wjBA6wdS/e7QlVy6qbRF7IOJIOHf1fa
fHOyCfNTGY9tVfQuZF99JUfMnvtebNX6By4tt38=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->186753521]
}, Open  ]],

Cell["The bars within a group are widely spaced:", "ExampleText",
 CellID->2030242086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"BarSpacing", "\[Rule]", "0.2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1177626940],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnctu00AUhiexrWaPkFgg6BI2YYFYIDagSiFd0E0XIEVUsiqkpKUClT5A
NjwF+z4J4lF4jXCOL9iZ+NaqhPHki5yxJzPnnPk/T+ypPU7fxVfzTxfx1eI0
3n97GX+dL06/7U++XMpHwcCYwdwY8/uBke2VbCVvfS3knW7aW1NJA6mmuVDW
Z1n+ICk91DTIvaySWnleUnNhlb+utDqz8p87WZ1XxB7Wtsyubcd8U2k11yQs
8nWKplns89K6oFTQHFnWmpykjoMMmbyi+lprbQn/QT1dx2kzGn08SvLPxscf
Z9eymFATzWfl95Ly5XJ5Pfsuiwk1CY7HBxvlP2aymEgTzWflT/LyzH+U+C/K
U3vxt+Z/o/xonPkPE/+Sz8qfWv7b2h918l+UP+6wH2DYiWHDNwOCXQjaRx2o
QQ1qUPOBmkKDFn0MalCDGtSgBjWoQc0Paoxu6WNQgxrUoAY1qEHNTWqM0+hj
UIMa1KAGNahBzU1qjNPoY1CDGtSgBrXu1NKpy/mLecy3YTi0qAVQhKJDFCPJ
PpT1SCrfh1KHvvYKSlDqegZteIoFQquKkRlUoAIVqNwFFYUCDfoIVKACFahA
BSouUmGcQh+BClSgAhWoQAUqfaLC6I0+AhWoQAUqUIGKq1QYp9BHoAIVqEBl
m1TCirnjkFmV5teXMjCyGNXNWX6ZexcBsphIkmL+cgsRaaQsJtKkd0TsmbY2
oQ8tFCaodEZl838K8ERjwxxoPxTa531Uoer//H3vjxo/9xGqUIUqVKHKN1Wc
fVGFKlShClUuq+I8hSpUoQpVqHJZFecpVKEKVbumKvD2Lulu3NHfDZX2PX2d
kfNe1ntS8XBV/jXB5pZW/erg3c0TKud/tbRmspW9v6VWVBxDthPZPiYT1Z+o
GtR3jUQlat+j8j0lKlGJytGBqETta1S+p0TtY1Q3rsO40Yr8yUe9OvZT1iMx
mOaeS8+t3eb629/HBjeu9GjyoqOXzIUDXtr2WHdPdr/32TI3dLuVWLIfd8OS
/bjrlvSAKsuqO1I3sLYs7bGCK56iLPtc3nvi4OZjpZO1WprW19KIQ7P51HhR
o2p/pSW6tbC2zOAPCg28bw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->709129951]
}, Open  ]],

Cell["The columns are widely spaced:", "ExampleText",
 CellID->911072219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PercentileBarChart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"BarSpacing", "\[Rule]", "0.8"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->832381623],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnE9v0zAYxt82aQMc+bOictkXQNzhDpdxQ2JSxSGqkNoDAo0d2MaVT8F9
n4rvEuwkrv8soUlsx154pvZNHCf5PXFk+5Fr731+ufv8Jb/cb/PTdxf5t91+
+/307dcLdiiZEc12RPTnObH9gu2VX/63Z99qt33vI4sJu+CKbdN6y9PPytxz
HhNxv6LMFWkW6aeR/7jxqmsjfdPpKvOsHyzMW5WZZ18Z6SflVWvj6JsGBqUy
3faE5n1e19pu6u21Vorm2Tycech5Wmv+wL6zxnNfifSnzS370AkPSn5u5K+O
5JvXL0AFFVRQQQUVVE/UZVG5i3lRuY3EUMGPLYIoy3jU/BPXSA8PR6qDaqT0
XildsO3LkAozqUeVN4+tJFNVHleXxaQuI/3d1iW6DKJxWch6rG7nhhqznk+5
jQMVVFBdUdcsufX7TLebX+xDJzyMV5ITpPKY0kB351VZ2TsuzD7TwuF5VevU
i3pV+kChHkr0iM/TfOj46rq7O+91hZbqO1bedF+P573uWHm86Fq6Fw19iuN2
tM5fHXlmUEG1o65FC+bvmVqu91ySoP6HVB4To69Rz7JykFbKGr2EH0cWQGcv
T2alT7iJUtdC5kqPWL103TOOX47WY4Pjv2XXrtF5TXbqGu9h6wYqqKCCCmpY
qtG3F7F5zVHH/6yUihHfOikFV6V5Z8R1XK+pvj2i+D2n5o0zU6dUF8Zzauoe
NasTMYznbK/XcJ6gggoqqKBipBE6u/5Grc0+sVJh7+1+b9iH3Z0F52Wkzo84
CBs4quhTZ6aU4jBv51Nde0sGKqiguqVqszg8PVOVvzryzKBOhyrnUzTNe1LP
/rdDtH3u5us7zB0b6MCgt6PeXrMbfatMyKejtFE3pqO00enfUdqo89euggoq
qKCCGi/V7BGHrasJ1MtH6OucrJwOoXDIyukQOnvMjozAv2vvOYz7bPp/CHCf
oIIKKqigtq/AVM/CSORU9Q5bLTPuGGRrecINOqjncIOgggoqqKCGpPIo/EVc
HtTtapkxRnv6rJaJ1i9pYuE84Tyn1uKBCiqooIIallrZIPFn/lIWjw9VnUel
WO09hfYYfakr5eaqGTFDW86p7Ujq8Xs3D2d97n3UG/a+Y0cnJ+8rxmyJ7jqu
rs5L3s2slXY5NPsLw5yanQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 220},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->181850209]
}, Open  ]],

Cell[TextData[{
 "This leaves space in the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " direction, but not in the ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " direction:"
}], "ExampleText",
 CellID->1717127823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"BarSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{".5", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1882072775],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{0.75, Rational[1, 2], 0}, {0.75, 0.5, 0}], 
     NCache[{1.25, Rational[3, 2], 1}, {1.25, 1.5, 1}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{0.75, Rational[3, 2], 0}, {0.75, 1.5, 0}], 
     NCache[{1.25, Rational[5, 2], 2}, {1.25, 2.5, 2}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{0.75, Rational[5, 2], 0}, {0.75, 2.5, 0}], 
     NCache[{1.25, Rational[7, 2], 3}, {1.25, 3.5, 3}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{1.75, Rational[1, 2], 0}, {1.75, 0.5, 0}], 
     NCache[{2.25, Rational[3, 2], 2}, {2.25, 1.5, 2}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{1.75, Rational[3, 2], 0}, {1.75, 1.5, 0}], 
     NCache[{2.25, Rational[5, 2], 3}, {2.25, 2.5, 3}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{1.75, Rational[5, 2], 0}, {1.75, 2.5, 0}], 
     NCache[{2.25, Rational[7, 2], 4}, {2.25, 3.5, 4}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{2.75, Rational[1, 2], 0}, {2.75, 0.5, 0}], 
     NCache[{3.25, Rational[3, 2], 3}, {3.25, 1.5, 3}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{2.75, Rational[3, 2], 0}, {2.75, 1.5, 0}], 
     NCache[{3.25, Rational[5, 2], 4}, {3.25, 2.5, 4}]]}, 
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    CuboidBox[NCache[{2.75, Rational[5, 2], 0}, {2.75, 2.5, 0}], 
     NCache[{3.25, Rational[7, 2], 5}, {3.25, 3.5, 5}]]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->Automatic,
  AxesEdge->Automatic,
  AxesLabel->None,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  BoxRatios->{1, 1, 1},
  BoxStyle->{},
  Boxed->True,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  ControllerLinking->Automatic,
  ControllerMethod->Automatic,
  ControllerPath->Automatic,
  DefaultAxesStyle->{},
  DefaultBaseStyle->"Graphics3D",
  DefaultBoxStyle->{},
  DefaultLabelStyle->"Graphics3DLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FaceGrids->None,
  FaceGridsStyle->{},
  FormatType:>TraditionalForm,
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Lighting->Automatic,
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  SphericalRegion->False,
  Ticks->Automatic,
  TicksStyle->{},
  ViewAngle->Automatic,
  ViewCenter->NCache[{
     Rational[1, 2], 
     Rational[1, 2], 
     Rational[1, 2]}, {0.5, 0.5, 0.5}],
  ViewMatrix->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewRange->All,
  ViewVector->Automatic,
  ViewVertical->{0, 0, 1}]], "Output",
 ImageSize->{364, 396},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->257816009,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14270],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart3D",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarGroupSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarGroupSpacing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->746970438]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BarSpacing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 9.1451038}", "context" -> "BarCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Bar Charts Package Symbol",
     "language" -> "en", "paclet" -> "BarCharts Package", "status" -> "None", 
    "summary" -> 
    "BarSpacing is an option for bar charts that determines the fraction of \
the bar width to space the bars in a group of bars.", "synonyms" -> {}, 
    "title" -> "BarSpacing", "type" -> "Symbol", "uri" -> 
    "BarCharts/ref/BarSpacing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3773, 136, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->355053700]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26434, 669}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 840, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1463, 47, 46, 1, 70, "ObjectName",
 CellID->776],
Cell[1512, 50, 413, 11, 70, "Usage",
 CellID->22060]
}, Open  ]],
Cell[CellGroupData[{
Cell[1962, 66, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2440, 83, 292, 9, 70, "Notes",
 CellID->163600738],
Cell[2735, 94, 452, 14, 70, "Notes",
 CellID->461944449],
Cell[3190, 110, 546, 21, 70, "Notes",
 CellID->858535406]
}, Closed]],
Cell[CellGroupData[{
Cell[3773, 136, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->355053700],
Cell[CellGroupData[{
Cell[4158, 150, 147, 5, 70, "ExampleSection",
 CellID->49441916],
Cell[4308, 157, 132, 3, 70, "Input",
 CellID->227696189],
Cell[4443, 162, 86, 1, 70, "ExampleText",
 CellID->677782903],
Cell[CellGroupData[{
Cell[4554, 167, 420, 13, 28, "Input",
 CellID->1243987033],
Cell[4977, 182, 1229, 24, 251, "Output",
 Evaluatable->False,
 CellID->186753521]
}, Open  ]],
Cell[6221, 209, 86, 1, 70, "ExampleText",
 CellID->2030242086],
Cell[CellGroupData[{
Cell[6332, 214, 422, 13, 28, "Input",
 CellID->1177626940],
Cell[6757, 229, 1335, 26, 251, "Output",
 Evaluatable->False,
 CellID->709129951]
}, Open  ]],
Cell[8107, 258, 73, 1, 70, "ExampleText",
 CellID->911072219],
Cell[CellGroupData[{
Cell[8205, 263, 431, 13, 28, "Input",
 CellID->832381623],
Cell[8639, 278, 1396, 27, 241, "Output",
 Evaluatable->False,
 CellID->181850209]
}, Open  ]],
Cell[10050, 308, 246, 9, 70, "ExampleText",
 CellID->1717127823],
Cell[CellGroupData[{
Cell[10321, 321, 474, 15, 70, "Input",
 CellID->1882072775],
Cell[10798, 338, 13425, 257, 417, 2755, 78, "CachedBoxData", "BoxData", \
"Output",
 CellID->257816009]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24284, 602, 311, 9, 70, "SeeAlsoSection",
 CellID->14270],
Cell[24598, 613, 748, 26, 70, "SeeAlso",
 CellID->746970438]
}, Open  ]],
Cell[25361, 642, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

