(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17972,        551]
NotebookOptionsPosition[     14842,        448]
NotebookOutlinePosition[     16224,        486]
CellTagsIndexPosition[     16139,        481]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BAR CHARTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/BarChart"], 
         "StackedBarChart" :> 
         Documentation`HelpLookup["paclet:BarCharts/ref/StackedBarChart"], 
         "Normalize" :> Documentation`HelpLookup["paclet:ref/Normalize"], 
         "Rectangle" :> Documentation`HelpLookup["paclet:ref/Rectangle"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"BarChart\"\>", 
      2->"\<\"StackedBarChart\"\>", 3->"\<\"Normalize\"\>", 
      4->"\<\"Rectangle\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PercentileBarChart", "ObjectName",
 CellID->12549],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PercentileBarChart", "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a stacked bar chart of the data in the \
lists. The data for each group of bars is scaled so that the sum of the \
absolute values in a group of bars is 1."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7724]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["PercentileBarChart"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " with the following additions:"
}], "Notes",
 CellID->20425],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style for the bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarSpacing",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarSpacing"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "fraction of bar width to space bars in a group", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarGroupSpacing",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarGroupSpacing"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "spacing between groups of bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarLabels",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarLabels"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "labels at tick marks for each bar (or group) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarValues",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarValues"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to show the length of each bar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarEdges",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarEdges"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether edges are drawn around each bar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarEdgeStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarEdgeStyle"], 
    RowBox[{
     ButtonBox["Opacity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Opacity"], "[", "0.5", "]"}], Cell[
    "style for the bar edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarOrientation",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarOrientation"], "Vertical", Cell[
    "determines horizontal or vertical orientation", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->1300],

Cell[TextData[{
 "Each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is a list of numbers, or numeric values. For example: ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "7", ",", 
    RowBox[{"-", "4"}], ",", "2", ",", "3"}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11121],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " need not have the same length."
}], "Notes",
 CellID->1599734575],

Cell[TextData[{
 "The heights of all the groups of bars in an ",
 Cell[BoxData["PercentileBarChart"], "InlineFormula"],
 " are the same."
}], "Notes",
 CellID->16979]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->682338345],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->116337656],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->578353654],

Cell["Chart sets of values:", "ExampleText",
 CellID->925491420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PercentileBarChart", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "9", ",", "16", ",", "25"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1101372124],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnc2O0zAUhW9/AwPsWCA0SBW8wSyQQJqWYQGbYTe7EYtqhNQuEGiYV+BV
5ql4l2Ance26bpq4SXydnqp14p+434nT2KdJ3W/Lh9WPn8uH9d1y9vV++Xu1
vvsz+/LrXiSNBkSDFRH9e0ViPRVr2Us+1uKVr+5f+yDCkdhgIZZjsZwX8c8y
d6RqSumySH+XbfXRyl0YcRHSVUm+XP1kxWfOWu1SdvyyYLbfzV2bXUpuPRRR
s1ZyKK9W29yhWNU+3Oy311apN65axjq+q23uoJarb531nxelr4rlYk/rKlp3
LTK4biHnZaHxRrwGzrJjFf9++yiedCEDI//sQP6zlrefgBrUoAY1qEENalCD
GtSgbph6muauZZjmLmVkqZBpkyiVJRmqTs010tNNSp5ohlrZSSidqJKxKky0
HlPesG8tOTblSXVJn9QltH1sFi06jVLjNNXnUXO5+ZwVpe3zbBzq4uzjQA1q
UIMa1Byo31MxEmBJl8Ufb/+KJ13IIIp92ldqGcoBY5TutFRZNrqdkDXmjdih
lqrtlRcvVfrEoN606AGf2pUPl2feF/4q+LjQPezVzyk0NY9F44jk5kWPUsre
ix6lLliPBmpQgxrUJf7mOVu6snflu09BDWpQ+452ZaI5BjRLteqgW1Xm9Chh
HCVDnY16ylb1KZeS0U50bi5H5uQHrY7H2Y7Br+12f5R27aY7P5N26qbRu50w
dZXv7gLvU893BTWoQQ1qUIOaO7U1hk9b8NSc9FGrrjqoUnVnQRHVgvPW3Lky
X9tTB1enUok68dZB9W59h5DYOrU6b2/NR92ZW50Kvb01p/NO2pLDRo8HalCD
GtSgBjWoT5K61SvCQZV1eEUYOkPprHgvdRN3YTHxpi3RNafO+GbB3VJbx+Je
h8paZ2K0opc3Za1ub08GalCDGtSgBjWoQQ3qkhG+l6Nmraz0t5J+jhN6Y9Fb
51fL7FWOCA5ctSYcOD91cfZ8oAY1qEENalCDGtRBx8BGqtd8YfwVukf5PfSl
jcxoHaNCnxmtY9RZ/VfPrNU1OpcYa6Wu/wmA+wY1qEENalCDGtSgPpYaV5LT
nfFynL7n1PT6zeIVj18vbU+42ciUHj0zNmt1cfZ9oAY1qEENalCDGtQhR8HK
n/TLgzc6uxdrpepqVZ3ZveJTeTp3b8N5734y4bz5qYuzxwM1qEENalCDGtSg
DkWdY6qHfadhf3y46VxyxeboV2nvoy9vSrk9y5f6dxRXPKnzzjXuv5bBdZ26
D3rV2jVWdIa6XnUNnmjXgVV1Yro2+yxzXA4N/gPVQy43\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 220},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->162001886]
}, Open  ]],

Cell["\<\
The total height is always the same, but negative values will display below \
the axis:\
\>", "ExampleText",
 CellID->1425284444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PercentileBarChart", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", 
      RowBox[{"-", "3"}], ",", "4", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "9", ",", 
      RowBox[{"-", "16"}], ",", "25"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1422587914],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnE9v0zAUwN2kadkGt3UrG0iFDbjvwJGxCxOaJg4cJw7VhNQeEGjsK4C4
Ib7EvsvEkQ8U7CRunVd3cfwnee1e1dp1XL/3e479bMdpzsfXk89fxtfTy/Ho
9Gr8bTK9/D569/WKH4o7jHUmjLF/Q8a/p/xb9hGvKf8wti/CWB5Ls+gsQE6f
hxHPiJVY/aU4liwt3RNhb56TfeFhJKKN2XE1Kw9Zd6nMHCF/Ce0Z4qIKQx0J
j295/JrH70sWZ+UTKDjTGJfTkPWvTN9c/OBvdiQCJf+0um66KmskjfSrow/q
o6iVnpUmXTuZ1aLya9h+zKTD9kmlqNS6l7LxvB68Qi2vbKbPr8cO5gVLyqRf
l+ODmZYYSIUm2HvyrFQC6iaAH3+Qzv02+XEqRaXaKSX6oZwF5i+/YwCQ36T3
h+lkpqTIyH6QePT98VxKvVm9ufcvrRqCeP+Z9E29dBna+319eyPvT6XWu9Sv
NF//P7IunaU/XdzwNzsSgZK/1aJU4Qu6rDybqxo//GhW56vA+9YaY/zQwDEn
S1qMfsKgn16INhQ7ZzVTsRbxXy9aisprT/7apuu1KX9t1ebaFeaeT1JXWeqT
NL+WcJzm/vsl0DLggUjuVWjbkdqK9GOg/Vmh50BL8RSkj5U001ANJU2R3nWk
OwT6R0aUb0H6hSPlNg/EOdjzQncC0oeAbocHkcGZ3VbqTpyL/UbodkHdDSso
BzyINHTP09zDmrW7NyIojdauLe8uroW0tneK0idF/ArQ+OqdB4V8PcUq+TPM
UgdFm/rIPx2tnm6Fnk3T/CUcW47yE6ImaqImaqImaqImaqImaqK+B9Ri16KP
lu6u8nmd2uxPrIZlvvY/VsNa27sJEqZcZQ9ooegnD40scd2XCX2+zu2tqNzX
wcHuY18IhyW2+0o46JseUYiKqIiKqIgKJ5XJHCpwnSyR2vKZuodU9ncno+Rn
QVdmQS2RK2jbu6jxWCGPMmZzl7bxKjKoHbZ3geM4Cy53meOwwO0udhw24PT4
REVURIWPymRWHrhOLLUSFVER1TpQ2TypAAe5vychkD2N22Pw5IYIjRUxc1gV
tt673Z48gcMO2ydb4KDH6fmJiqiIiqiIiqhWl0pcQ/nQivbfiLW2saozI8Oz
ymmC18c6pt4Zt3/yKYL6NL/LsT3GhtZN9v28iXURZt9HWkkraSWtpJW0NqVV
jLcxW7w+iWfeveSpacXvGMM7A/dFLufictddxH9S9X94hppq/KNIBGd1ZFfO
gGtLNJyvzuXq2nCdueVcEuyLbjms8x+aoGLV\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 211},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->210755803]
}, Open  ]],

Cell["The sets need not have the same length:", "ExampleText",
 CellID->713561762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PercentileBarChart", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2.1", ",", "0.5", ",", "0.9", ",", "1.7"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "2", ",", "1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1313504266],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnM9u0zAcx92mbWDAjQNCIFXwBjsggbSO7QCXceNWcagmpPaAQGOvwFNw
31PxLsFO4tpxneafE/+cfqfWif/E/XzrzPG3Tvxlc7/9/mNzv7vdLD/fbX5t
d7e/l59+3vGkaMLYZMsY+/eC8f2E76Vv8bfj72y3fO89DyN+wCXfzvh2lcev
RW4ka0rYRZ7+Nj3qg5F7qcV5yK6O5Ivdj0Z8aa3VLGXGL3Jm89PstZmlxNFT
HtVrZRbl9WpbWRTL2qf77+2lUeq1rZaZih9qW1moxe4ba/2v8tJX+faypHUl
rb0WEdz0kPM81/iVvyfWsjMZ/7Z+4C92LgIt/6wi/0nPx89BDWpQgxrUoAY1
qEENalA7pl4kmWuZJplLiQwVIm0epLI4RVWpmUb2eJ+SJeqhUnYSSueyZKgK
Y6VHlzcdW0vOdHlCXTwmdTErnpt5iy6C1LhIVD+qb/f/Z3lps58NQ12Y1zhQ
g3p46nc8+pQsXRp/WP/hL3YugiC+U1CDGtSnQy1CMWD04k57VZaObufMGPN6
dKi9qiXlxXtV+kij3rdohU+VPrzRiGF4FfVdaFe23vsUttDPRe2MbOpFSSvt
7EVJqyu9ooEa1KAGNai1TxVji2dk6Y7l0/1OQQ1q6tQiFIn6GFAvddRBk1Zm
9SjtHOUIdRbmdknrky4lpZ2r3EyOyMlOWhUPsx07z+2SVlfxu0fh/Gztpsn1
pE7dNK5uoAY1qEENalCDGtTBUBtj+2RsXtvp/C1ppfKOgzyqBGeteTBjXzp/
612FTGXMjbf+u+YvzssDcq1W+A0hNnUqdeXeOhh1Z3Z1Miz31pQVlvefzRw2
ZY3lVzZQgxrUoAY1qEE9FHXhjghydLWOr/QAIrHdzC9lZS5nfqGTqM6a90zT
V9enN210V1dnFdovCPaWKpyL7Z2oPX+Y1oq11urHg/pU1/5KBmpQgxrUoAY1
qEF9itS25+n0Ut0ctU9lR5+J7MlxQi8RvU6dtm+VEetzFth37wMHrkrDgYMa
1KAGNahBDWpQj5/aHNG2WheMvkL7KH+EvtTJytUhKmyzcnWIOhs83UxZnds1
w9orbfSEQWU/EzGfLrvjPRuerm6gBjWoQQ1qUIMa1JRnjPtURnEGFXrd6W23
KpdbX+6tPQd0rd40Dj5nPHQ/CzcLalCDGtSgBjWoQX2a1CKU/mRcHtztqlyU
lcrZqiarcoWnks5d2nDecN5w3qFe8UANalCDGtSgBjWofVFnmPLPvNNwPD5c
dy6ZYn30K7WP0Ze7Um6uoC3XtbLF4yaf3OA+axHcNKm70qs2rrGmM1T1yjl4
xg4dWF0npmoze5luOWzyHxTsJI8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 220},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->129082909]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31898],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/BarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StackedBarChart",
    BaseStyle->"Link",
    ButtonData->"paclet:BarCharts/ref/StackedBarChart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Normalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normalize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rectangle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rectangle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26289]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PercentileBarChart - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 15.5983940}", "context" -> "BarCharts`", 
    "keywords" -> {}, "index" -> True, "label" -> "Bar Charts Package Symbol",
     "language" -> "en", "paclet" -> "BarCharts Package", "status" -> "None", 
    "summary" -> 
    "PercentileBarChart[{list_1, list_2, ...}] generates a stacked bar chart \
of the data in the lists. The data for each group of bars is scaled so that \
the sum of the absolute values in a group of bars is 1.", "synonyms" -> {}, 
    "title" -> "PercentileBarChart", "type" -> "Symbol", "uri" -> 
    "BarCharts/ref/PercentileBarChart"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6623, 213, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->682338345]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15996, 474}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 916, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1539, 47, 56, 1, 70, "ObjectName",
 CellID->12549],
Cell[1598, 50, 779, 22, 70, "Usage",
 CellID->7724]
}, Open  ]],
Cell[CellGroupData[{
Cell[2414, 77, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2892, 94, 282, 9, 70, "Notes",
 CellID->20425],
Cell[3177, 105, 2681, 71, 70, "3ColumnTableMod",
 CellID->1300],
Cell[5861, 178, 357, 13, 70, "Notes",
 CellID->11121],
Cell[6221, 193, 196, 8, 70, "Notes",
 CellID->1599734575],
Cell[6420, 203, 166, 5, 70, "Notes",
 CellID->16979]
}, Closed]],
Cell[CellGroupData[{
Cell[6623, 213, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->682338345],
Cell[CellGroupData[{
Cell[7008, 227, 148, 5, 70, "ExampleSection",
 CellID->116337656],
Cell[7159, 234, 132, 3, 70, "Input",
 CellID->578353654],
Cell[7294, 239, 64, 1, 70, "ExampleText",
 CellID->925491420],
Cell[CellGroupData[{
Cell[7383, 244, 329, 10, 28, "Input",
 CellID->1101372124],
Cell[7715, 256, 1538, 29, 241, "Output",
 Evaluatable->False,
 CellID->162001886]
}, Open  ]],
Cell[9268, 288, 139, 4, 70, "ExampleText",
 CellID->1425284444],
Cell[CellGroupData[{
Cell[9432, 296, 370, 11, 28, "Input",
 CellID->1422587914],
Cell[9805, 309, 1530, 29, 232, "Output",
 Evaluatable->False,
 CellID->210755803]
}, Open  ]],
Cell[11350, 341, 82, 1, 70, "ExampleText",
 CellID->713561762],
Cell[CellGroupData[{
Cell[11457, 346, 403, 12, 28, "Input",
 CellID->1313504266],
Cell[11863, 360, 1583, 30, 241, "Output",
 Evaluatable->False,
 CellID->129082909]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13507, 397, 311, 9, 70, "SeeAlsoSection",
 CellID->31898],
Cell[13821, 408, 979, 35, 70, "SeeAlso",
 CellID->26289]
}, Open  ]],
Cell[14815, 446, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

