(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13334,        459]
NotebookOptionsPosition[     10314,        365]
NotebookOutlinePosition[     11888,        406]
CellTagsIndexPosition[     11803,        401]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BENCHMARKING PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Benchmarking Package" :> 
          Documentation`HelpLookup[
           "paclet:Benchmarking/tutorial/Benchmark"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Benchmarking Package\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Benchmark" :> 
          Documentation`HelpLookup["paclet:Benchmarking/ref/Benchmark"], 
          "$BenchmarkSystems" :> 
          Documentation`HelpLookup[
           "paclet:Benchmarking/ref/$BenchmarkSystems"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Benchmark\"\>", 
       2->"\<\"$BenchmarkSystems\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BenchmarkReport", "ObjectName",
 CellID->17243],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BenchmarkReport", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]runs the ",
     StyleBox["MathematicaMark6",
      FontSlant->"Italic"],
     " benchmark and produces a report in a separate notebook comparing this \
system to a selection of reference systems. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BenchmarkReport", "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"system\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"system\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["data", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["data", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]produces a custom report comparing the specified \
systems from ",
     Cell[BoxData[
      ButtonBox["$BenchmarkSystems",
       BaseStyle->"Link",
       ButtonData->"paclet:Benchmarking/ref/$BenchmarkSystems"]], 
      "InlineFormula"],
     " and the specified data returned from ",
     Cell[BoxData[
      ButtonBox["Benchmark",
       BaseStyle->"Link",
       ButtonData->"paclet:Benchmarking/ref/Benchmark"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->28679]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
If no front end is available, then the report is returned as text.\
\>", "Notes",
 CellID->1948787042],

Cell[TextData[{
 "The ",
 StyleBox["MathematicaMark6",
  FontSlant->"Italic"],
 " benchmark should take about 100 seconds to run on an Intel 2.4 GHz Pentium \
4."
}], "Notes",
 CellID->12106]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->165229978],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->226055495],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Benchmarking`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->515347935],

Cell[TextData[{
 "Running the ",
 StyleBox["MathematicaMark6",
  FontSlant->"Italic"],
 " benchmark:"
}], "ExampleText",
 CellID->1671718169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BenchmarkReport", "[", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "ManipulatePasteIcon"],
           ImageSizeCache->{13., {4., 9.}}],
          DynamicUpdating->True],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["2ye_shm", 1, 1]], 29]]}],
         Evaluator->None,
         Method->"Queued"],
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEStrings", "NotebookObjectToTheFront"]]], 
       StyleBox["\<\"MathematicaMark6 Report\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}],
    FrameMargins->{{4, 5}, {4, 4}}], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["2ye_shm", 1, 1]], 29],
  Editable->False]], "Output",
 ImageSize->{278, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1092167492]
}, Open  ]],

Cell[TextData[{
 "Creating a custom comparison report from two systems in ",
 Cell[BoxData[
  ButtonBox["$BenchmarkSystems",
   BaseStyle->"Link",
   ButtonData->"paclet:Benchmarking/ref/$BenchmarkSystems"]], 
  "InlineFormula"],
 " and the result of ",
 Cell[BoxData[
  ButtonBox["Benchmark",
   BaseStyle->"Link",
   ButtonData->"paclet:Benchmarking/ref/Benchmark"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1458975603],

Cell[BoxData[
 RowBox[{
  RowBox[{"myBenchmarkResult", " ", "=", " ", 
   RowBox[{"Benchmark", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BenchmarkReport", "[", 
  RowBox[{
  "\"\<2p 2.4 GHz Opteron 250 (Sun Solaris 10 (64-bit))\>\"", ",", 
   "\"\<2.4 GHz Pentium 4 (Microsoft Windows XP (32-bit))\>\"", ",", 
   "myBenchmarkResult"}], "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "ManipulatePasteIcon"],
           ImageSizeCache->{13., {4., 9.}}],
          DynamicUpdating->True],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["2ye_shm", 1, 1]], 30]]}],
         Evaluator->None,
         Method->"Queued"],
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEStrings", "NotebookObjectToTheFront"]]], 
       StyleBox["\<\"MathematicaMark6 Report\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}],
    FrameMargins->{{4, 5}, {4, 4}}], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["2ye_shm", 1, 1]], 30],
  Editable->False]], "Output",
 ImageSize->{278, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1431898319]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21020],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Benchmark",
    BaseStyle->"Link",
    ButtonData->"paclet:Benchmarking/ref/Benchmark"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$BenchmarkSystems",
    BaseStyle->"Link",
    ButtonData->"paclet:Benchmarking/ref/$BenchmarkSystems"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24809]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20825],

Cell[TextData[ButtonBox["Benchmarking Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Benchmarking/tutorial/Benchmark"]], "Tutorials",
 CellID->31893]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BenchmarkReport - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 22.3798176}", "context" -> 
    "Benchmarking`", "keywords" -> {}, "index" -> True, "label" -> 
    "Benchmarking Package Symbol", "language" -> "en", "paclet" -> 
    "Benchmarking Package", "status" -> "None", "summary" -> 
    "BenchmarkReport[] runs the MathematicaMark6 benchmark and produces a \
report in a separate notebook comparing this system to a selection of \
reference systems. BenchmarkReport[\"SubscriptBox[ system, 1]\", \
\"SubscriptBox[ system, 2]\", ..., data_1, data_2, ...] produces a custom \
report comparing the specified systems from $BenchmarkSystems and the \
specified data returned from Benchmark.", "synonyms" -> {}, "title" -> 
    "BenchmarkReport", "type" -> "Symbol", "uri" -> 
    "Benchmarking/ref/BenchmarkReport"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4486, 149, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->165229978]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11660, 394}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1351, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1974, 62, 53, 1, 70, "ObjectName",
 CellID->17243],
Cell[2030, 65, 1598, 45, 70, "Usage",
 CellID->28679]
}, Open  ]],
Cell[CellGroupData[{
Cell[3665, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4143, 132, 112, 3, 70, "Notes",
 CellID->1948787042],
Cell[4258, 137, 191, 7, 70, "Notes",
 CellID->12106]
}, Closed]],
Cell[CellGroupData[{
Cell[4486, 149, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->165229978],
Cell[CellGroupData[{
Cell[4871, 163, 148, 5, 70, "ExampleSection",
 CellID->226055495],
Cell[5022, 170, 135, 3, 70, "Input",
 CellID->515347935],
Cell[5160, 175, 141, 6, 70, "ExampleText",
 CellID->1671718169],
Cell[CellGroupData[{
Cell[5326, 185, 86, 2, 28, "Input"],
Cell[5415, 189, 1295, 41, 52, "Output",
 CellID->1092167492]
}, Open  ]],
Cell[6725, 233, 432, 14, 70, "ExampleText",
 CellID->1458975603],
Cell[7160, 249, 148, 4, 70, "Input"],
Cell[CellGroupData[{
Cell[7333, 257, 262, 6, 70, "Input"],
Cell[7598, 265, 1295, 41, 70, "Output",
 CellID->1431898319]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8954, 313, 311, 9, 70, "SeeAlsoSection",
 CellID->21020],
Cell[9268, 324, 497, 17, 70, "SeeAlso",
 CellID->24809]
}, Open  ]],
Cell[CellGroupData[{
Cell[9802, 346, 314, 9, 70, "TutorialsSection",
 CellID->20825],
Cell[10119, 357, 153, 3, 70, "Tutorials",
 CellID->31893]
}, Open  ]],
Cell[10287, 363, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

