(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13097,        411]
NotebookOptionsPosition[      9607,        317]
NotebookOutlinePosition[     11918,        367]
CellTagsIndexPosition[     11875,        364]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BENCHMARKING PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Benchmark" :> 
         Documentation`HelpLookup["paclet:Benchmarking/ref/Benchmark"], 
         "BenchmarkReport" :> 
         Documentation`HelpLookup["paclet:Benchmarking/ref/BenchmarkReport"], 
         "$BenchmarkSystems" :> 
         Documentation`HelpLookup[
          "paclet:Benchmarking/ref/$BenchmarkSystems"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Benchmark\"\>", 2->"\<\"BenchmarkReport\"\>", 
      3->"\<\"$BenchmarkSystems\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Benchmarking Package", "Title",
 CellID->23494],

Cell[TextData[{
 "This package contains functions for measuring the performance of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on your computer and for producing a comparison report that includes \
benchmark results for other computers. The ",
 StyleBox["MathematicaMark6",
  FontSlant->"Italic"],
 " benchmark, a collection of typical numeric and symbolic computations, is \
used for evaluating the performance of the computer system on which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is run.\nThe overall ",
 StyleBox["MathematicaMark6",
  FontSlant->"Italic"],
 " result is computed as the geometric mean of the reciprocal of individual \
timings, normalized with respect to a reference system. The timings for the \
individual computations are measured with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Timing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Timing"], "[", "]"}]], "InlineFormula"],
 ", which returns the CPU time. Running the ",
 StyleBox["MathematicaMark6",
  FontSlant->"Italic"],
 " benchmark takes about one minute on the reference system and requires 512 \
MB of free memory."
}], "Text",
 CellID->30254],

Cell["This loads the package.", "MathCaption",
 CellID->18126],

Cell[BoxData[
 RowBox[{"<<", "Benchmarking`"}]], "Input",
 CellID->1113],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BenchmarkReport",
    BaseStyle->"Link",
    ButtonData->"paclet:Benchmarking/ref/BenchmarkReport"], "[", "]"}]], 
  "InlineFormula"],
 " runs the ",
 StyleBox["MathematicaMark6",
  FontSlant->"Italic"],
 " benchmark and produces a notebook report that compares the performance of \
your computer with results from several known systems. If no front end is \
available, a plain text version of the report is returned."
}], "Text",
 CellID->20646],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BenchmarkReport",
      BaseStyle->"Link",
      ButtonData->"paclet:Benchmarking/ref/BenchmarkReport"], "[", "]"}], 
    Cell[TextData[{
     "run the ",
     StyleBox["MathematicaMark6",
      FontSlant->"Italic"],
     " benchmark and produce a comparison report"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->25443],

Cell["Generating a benchmark report.", "Caption",
 CellID->28914],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Benchmark",
    BaseStyle->"Link",
    ButtonData->"paclet:Benchmarking/ref/Benchmark"], "[", "]"}]], 
  "InlineFormula"],
 " runs the ",
 StyleBox["MathematicaMark6",
  FontSlant->"Italic"],
 " benchmark and returns the results as raw data. This package includes a \
collection of benchmark results for a variety of systems as given in ",
 Cell[BoxData[
  ButtonBox["$BenchmarkSystems",
   BaseStyle->"Link",
   ButtonData->"paclet:Benchmarking/ref/$BenchmarkSystems"]], 
  "InlineFormula"],
 "."
}], "Text",
 CellID->12515],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Benchmark",
      BaseStyle->"Link",
      ButtonData->"paclet:Benchmarking/ref/Benchmark"], "[", "]"}], Cell[
    "raw benchmark data", "TableText"]},
   {
    ButtonBox["$BenchmarkSystems",
     BaseStyle->"Link",
     ButtonData->"paclet:Benchmarking/ref/$BenchmarkSystems"], Cell[
    TextData[{
     "systems for which ",
     StyleBox["MathematicaMark6",
      FontSlant->"Italic"],
     " benchmark data is known"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->18787],

Cell["Benchmark utilities.", "Caption",
 CellID->90],

Cell[TextData[{
 "This gives raw benchmark data in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ". (The data shown here was produced on the reference system.)"
}], "MathCaption",
 CellID->32197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Benchmark", "[", "]"}]], "Input",
 CellID->29569],

Cell["\<\
{\"MachineName\" -> \"reference\", 
 \"System\" -> \"Microsoft Windows XP (32-bit)\", 
 \"BenchmarkName\" -> \"MathematicaMark6\", \"FullVersionNumber\" -> \
\"6.0.0\", 
 \"Date\" -> \"February 6, 2007\", \"BenchmarkResult\" -> 1., 
 \"TotalTime\" -> 86.19, \"Results\" -> {{\"Data Fitting\", 5.046}, 
   {\"Digits of Pi\", 1.234}, {\"Discrete Fourier Transform\", 3.}, 
   {\"Eigenvalues of a Matrix\", 8.843}, {\"Elementary Functions\", 7.499}, 
   {\"Gamma Function\", 0.922}, {\"Large Integer Multiplication\", 1.625}, 
   {\"Matrix Arithmetic\", 9.171}, {\"Matrix Multiplication\", 8.781}, 
   {\"Matrix Transpose\", 5.39}, {\"Numerical Integration\", 6.171}, 
   {\"Polynomial Expansion\", 5.671}, {\"Random Number Sort\", 4.514}, 
   {\"Singular Value Decomposition\", 9.419}, {\"Solving a Linear System\", 
    8.904}}}\
\>", "Output",
 ImageSize->{504, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->1958841920]
}, Open  ]],

Cell[TextData[{
 "You can create a customized comparison report using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BenchmarkReport",
    BaseStyle->"Link",
    ButtonData->"paclet:Benchmarking/ref/BenchmarkReport"], "[", "]"}]], 
  "InlineFormula"],
 " by specifying computer systems from ",
 Cell[BoxData[
  ButtonBox["$BenchmarkSystems",
   BaseStyle->"Link",
   ButtonData->"paclet:Benchmarking/ref/$BenchmarkSystems"]], 
  "InlineFormula"],
 " and raw benchmark data as returned by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Benchmark",
    BaseStyle->"Link",
    ButtonData->"paclet:Benchmarking/ref/Benchmark"], "[", "]"}]], 
  "InlineFormula"],
 "."
}], "Text",
 ShowCellBracket->True,
 CellID->24148],

Cell[BoxData[GridBox[{
   {
    RowBox[{"BenchmarkReport", "[", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"system\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"system\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["data", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["data", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
produce a custom comparison report with the specified systems and raw data\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->26130],

Cell["Produce a customized notebook report.", "Caption",
 CellID->7204],

Cell["This gives a report for two known systems and your computer.", \
"MathCaption",
 CellID->12862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BenchmarkReport", "[", 
  RowBox[{
  "\"\<2p 2.4 GHz Opteron 250 (Sun Solaris 10 (64-bit))\>\"", ",", "  ", 
   "\"\<2p dual-core 3.0 GHz Intel Xeon 5160 (Microsoft Windows \
(32-bit))\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->9836],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "ManipulatePasteIcon"],
           ImageSizeCache->{13., {4., 9.}}],
          DynamicUpdating->True],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["2ye_shm", 1, 1]], 34]]}],
         Evaluator->None,
         Method->"Queued"],
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEStrings", "NotebookObjectToTheFront"]]], 
       StyleBox["\<\"MathematicaMark6 Report\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}],
    FrameMargins->{{4, 5}, {4, 4}}], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["2ye_shm", 1, 1]], 34],
  Editable->False]], "Output",
 ImageSize->{278, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->1036735897]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Benchmarking Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 22.7704526}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Benchmarking Package Tutorial", "language" -> "en", "paclet" -> 
    "Benchmarking Package", "status" -> "None", "summary" -> 
    "This package contains functions for measuring the performance of \
Mathematica on your computer and for producing a comparison report that \
includes benchmark results for other computers. The MathematicaMark6 \
benchmark, a collection of typical numeric and symbolic computations, is used \
for evaluating the performance of the computer system on which Mathematica is \
run. The overall MathematicaMark6 result is computed as the geometric mean of \
the reciprocal of individual timings, normalized with respect to a reference \
system. The timings for the individual computations are measured with \
Timing[], which returns the CPU time. Running the MathematicaMark6 benchmark \
takes about one minute on the reference system and requires 512 MB of free \
memory. This loads the package. BenchmarkReport[] runs the MathematicaMark6 \
benchmark and produces a notebook report that compares the performance of \
your computer with results from several known systems. If no front end is \
available, a plain text version of the report is returned.", "synonyms" -> {},
     "title" -> "Benchmarking Package", "type" -> "Tutorial", "uri" -> 
    "Benchmarking/tutorial/Benchmark"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 882, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1507, 47, 53, 1, 70, "Title",
 CellID->23494],
Cell[1563, 50, 1157, 29, 70, "Text",
 CellID->30254],
Cell[2723, 81, 62, 1, 70, "MathCaption",
 CellID->18126],
Cell[2788, 84, 72, 2, 70, "Input",
 CellID->1113],
Cell[2863, 88, 502, 14, 70, "Text",
 CellID->20646],
Cell[3368, 104, 385, 13, 70, "DefinitionBox",
 CellID->25443],
Cell[3756, 119, 65, 1, 70, "Caption",
 CellID->28914],
Cell[3824, 122, 581, 19, 70, "Text",
 CellID->12515],
Cell[4408, 143, 539, 18, 70, "DefinitionBox",
 CellID->18787],
Cell[4950, 163, 52, 1, 70, "Caption",
 CellID->90],
Cell[5005, 166, 274, 8, 70, "MathCaption",
 CellID->32197],
Cell[CellGroupData[{
Cell[5304, 178, 73, 2, 70, "Input",
 CellID->29569],
Cell[5380, 182, 963, 19, 228, "Output",
 CellID->1958841920]
}, Open  ]],
Cell[6358, 204, 706, 24, 70, "Text",
 CellID->24148],
Cell[7067, 230, 702, 20, 70, "DefinitionBox",
 CellID->26130],
Cell[7772, 252, 71, 1, 70, "Caption",
 CellID->7204],
Cell[7846, 255, 101, 2, 70, "MathCaption",
 CellID->12862],
Cell[CellGroupData[{
Cell[7972, 261, 282, 7, 70, "Input",
 CellID->9836],
Cell[8257, 270, 1296, 41, 70, "Output",
 CellID->1036735897]
}, Open  ]]
}, Open  ]],
Cell[9580, 315, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

