(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7646,        269]
NotebookOptionsPosition[      5732,        210]
NotebookOutlinePosition[      6895,        240]
CellTagsIndexPosition[      6852,        237]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BLACK BODY RADIATION PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Black-Body Radiation Package" :> 
          Documentation`HelpLookup[
           "paclet:BlackBodyRadiation/tutorial/BlackBodyRadiation"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Black-Body Radiation Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plot" :> Documentation`HelpLookup["paclet:ref/Plot"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Plot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BlackBodyProfile", "ObjectName",
 CellID->31098],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BlackBodyProfile", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["temp", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["temp", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a plot of black-body spectral distribution \
profiles at the specified temperatures ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["temp", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["temp", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The temperatures ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["temp", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are typically measured in degrees Kelvin ",
 Cell[BoxData[
  RowBox[{"(", 
   ButtonBox["Kelvin",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kelvin"]}]], "InlineFormula"],
 "). For example: ",
 Cell[BoxData[
  RowBox[{"5000", " ", 
   ButtonBox["Kelvin",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kelvin"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23711],

Cell[TextData[{
 Cell[BoxData["BlackBodyProfile"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21942],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["style", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["style", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " can be used to specify different styles for each profile curve."
}], "Notes",
 CellID->24314]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7797],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->31032]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->128],

Cell[TextData[ButtonBox["Black-Body Radiation Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:BlackBodyRadiation/tutorial/BlackBodyRadiation"]], "Tutorials",
 CellID->21289]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BlackBodyProfile - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 23.2235892}", "context" -> 
    "BlackBodyRadiation`", "keywords" -> {}, "index" -> True, "label" -> 
    "Black Body Radiation Package Symbol", "language" -> "en", "paclet" -> 
    "BlackBodyRadiation Package", "status" -> "None", "summary" -> 
    "BlackBodyProfile[temp_1, temp_2, ...] generates a plot of black-body \
spectral distribution profiles at the specified temperatures temp_1, temp_2, \
....", "synonyms" -> {}, "title" -> "BlackBodyProfile", "type" -> "Symbol", 
    "uri" -> "BlackBodyRadiation/ref/BlackBodyProfile"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1188, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1811, 58, 54, 1, 70, "ObjectName",
 CellID->31098],
Cell[1868, 61, 954, 30, 70, "Usage",
 CellID->16376]
}, Open  ]],
Cell[CellGroupData[{
Cell[2859, 96, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3337, 113, 534, 20, 70, "Notes",
 CellID->23711],
Cell[3874, 135, 243, 9, 70, "Notes",
 CellID->21942],
Cell[4120, 146, 501, 17, 70, "Notes",
 CellID->24314]
}, Closed]],
Cell[CellGroupData[{
Cell[4658, 168, 310, 9, 70, "SeeAlsoSection",
 CellID->7797],
Cell[4971, 179, 188, 6, 70, "SeeAlso",
 CellID->31032]
}, Open  ]],
Cell[CellGroupData[{
Cell[5196, 190, 312, 9, 70, "TutorialsSection",
 CellID->128],
Cell[5511, 201, 179, 4, 70, "Tutorials",
 CellID->21289]
}, Open  ]],
Cell[5705, 208, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

