(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7580,        263]
NotebookOptionsPosition[      5723,        206]
NotebookOutlinePosition[      6882,        236]
CellTagsIndexPosition[      6839,        233]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BLACK BODY RADIATION PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Black-Body Radiation Package" :> 
          Documentation`HelpLookup[
           "paclet:BlackBodyRadiation/tutorial/BlackBodyRadiation"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Black-Body Radiation Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PeakWavelength" :> 
          Documentation`HelpLookup[
           "paclet:BlackBodyRadiation/ref/PeakWavelength"], "TotalPower" :> 
          Documentation`HelpLookup[
           "paclet:BlackBodyRadiation/ref/TotalPower"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PeakWavelength\"\>", 
       2->"\<\"TotalPower\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MaxPower", "ObjectName",
 CellID->31576],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MaxPower", "[", 
       RowBox[{
        StyleBox["temp", "TI"], ",", 
        StyleBox["band", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the radiative power emitted by a black body in \
the specified wavelength band ",
     Cell[BoxData[
      StyleBox["band", "TI"]], "InlineFormula"],
     " about the peak wavelength, at the specified temperature ",
     Cell[BoxData[
      StyleBox["temp", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The temperature ",
 Cell[BoxData[
  StyleBox["temp", "TI"]], "InlineFormula"],
 " is typically measured in degrees Kelvin (",
 Cell[BoxData[
  ButtonBox["Kelvin",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Kelvin"]], "InlineFormula"],
 "). For example: ",
 Cell[BoxData[
  RowBox[{"5000", " ", 
   ButtonBox["Kelvin",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kelvin"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2398],

Cell[TextData[{
 "The wavelength band ",
 Cell[BoxData[
  StyleBox["band", "TI"]], "InlineFormula"],
 " is typically measured in meters ",
 Cell[BoxData[
  RowBox[{"(", 
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"]}]], "InlineFormula"],
 "). For example: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"10", "^", 
    RowBox[{"-", "7"}]}], " ", 
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22387]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15809],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PeakWavelength",
    BaseStyle->"Link",
    ButtonData->"paclet:BlackBodyRadiation/ref/PeakWavelength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TotalPower",
    BaseStyle->"Link",
    ButtonData->"paclet:BlackBodyRadiation/ref/TotalPower"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15327]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24086],

Cell[TextData[ButtonBox["Black-Body Radiation Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:BlackBodyRadiation/tutorial/BlackBodyRadiation"]], "Tutorials",
 CellID->8568]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MaxPower - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 23.3798432}", "context" -> 
    "BlackBodyRadiation`", "keywords" -> {}, "index" -> True, "label" -> 
    "Black Body Radiation Package Symbol", "language" -> "en", "paclet" -> 
    "BlackBodyRadiation Package", "status" -> "None", "summary" -> 
    "MaxPower[temp, band] gives the radiative power emitted by a black body \
in the specified wavelength band band about the peak wavelength, at the \
specified temperature temp.", "synonyms" -> {}, "title" -> "MaxPower", "type" -> 
    "Symbol", "uri" -> "BlackBodyRadiation/ref/MaxPower"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1402, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2025, 63, 46, 1, 70, "ObjectName",
 CellID->31576],
Cell[2074, 66, 710, 21, 70, "Usage",
 CellID->5995]
}, Open  ]],
Cell[CellGroupData[{
Cell[2821, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3299, 109, 468, 17, 70, "Notes",
 CellID->2398],
Cell[3770, 128, 523, 20, 70, "Notes",
 CellID->22387]
}, Closed]],
Cell[CellGroupData[{
Cell[4330, 153, 311, 9, 70, "SeeAlsoSection",
 CellID->15809],
Cell[4644, 164, 505, 17, 70, "SeeAlso",
 CellID->15327]
}, Open  ]],
Cell[CellGroupData[{
Cell[5186, 186, 314, 9, 70, "TutorialsSection",
 CellID->24086],
Cell[5503, 197, 178, 4, 70, "Tutorials",
 CellID->8568]
}, Open  ]],
Cell[5696, 204, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

