(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8708,        306]
NotebookOptionsPosition[      5790,        223]
NotebookOutlinePosition[      7217,        257]
CellTagsIndexPosition[      7174,        254]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Calendar Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["DayOfWeek",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/DayOfWeek"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " day of the week for a given date"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["DaysPlus",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/DaysPlus"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " add a number of days to a given date"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["DaysBetween",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/DaysBetween"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " number of days between two dates"
}], "GuideText",
 CellID->238456100],

Cell[TextData[{
 Cell[TextData[ButtonBox["CalendarChange",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/CalendarChange"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert a date from one calendar to another"
}], "GuideText",
 CellID->527187398],

Cell["\t", "GuideDelimiter",
 CellID->2068554311],

Cell[TextData[{
 Cell[TextData[ButtonBox["EasterSunday",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/EasterSunday"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " date of Easter Sunday for a given year"
}], "GuideText",
 CellID->1552525913],

Cell[TextData[{
 Cell[TextData[ButtonBox["EasterSundayGreekOrthodox",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/EasterSundayGreekOrthodox"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Easter Sunday according to the Greek Orthodox Church "
}], "GuideText",
 CellID->1376708741],

Cell[TextData[{
 Cell[TextData[ButtonBox["JewishNewYear",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/JewishNewYear"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " date of the Jewish New Year"
}], "GuideText",
 CellID->1354997209],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["DateQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/DateQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether a date is valid in the current calendar system"
}], "GuideText",
 CellID->875577994],

Cell["\t", "GuideDelimiter",
 CellID->1521498875],

Cell[TextData[{
 ButtonBox["Sunday",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/Sunday"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 ButtonBox["Monday",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/Monday"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 ButtonBox["Tuesday",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/Tuesday"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 ButtonBox["Wednesday",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/Wednesday"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 ButtonBox["Thursday",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/Thursday"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 ButtonBox["Friday",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/Friday"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 ButtonBox["Saturday",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/Saturday"]
}], "InlineGuideFunctionListing",
 CellID->1589416377],

Cell["\t", "GuideDelimiterSubsection",
 CellID->1425404266],

Cell[CellGroupData[{

Cell["Calendars", "GuideFunctionsSubsection",
 CellID->1459893263],

Cell[TextData[{
 ButtonBox["Gregorian",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/Gregorian"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 ButtonBox["Julian",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/Julian"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 ButtonBox["Islamic",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/Islamic"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 ButtonBox["Jewish",
  BaseStyle->"Link",
  ButtonData->"paclet:Calendar/ref/Jewish"]
}], "InlineGuideFunctionListing",
 CellID->1743807296]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Calendar Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Calendar/tutorial/Calendar"]], "GuideTutorial",
 CellID->1038258004]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Date and Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Calendar Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 30.3800224}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Calendar Package Guide", 
    "language" -> "en", "paclet" -> "Calendar Package", "status" -> "None", 
    "summary" -> 
    "DayOfWeek -- day of the week for a given date, DaysPlus -- add a number \
of days to a given date, DaysBetween -- number of days between two dates, \
CalendarChange -- convert a date from one calendar to another, EasterSunday \
-- date of Easter Sunday for a given year, EasterSundayGreekOrthodox -- \
Easter Sunday according to the Greek Orthodox Church , JewishNewYear -- date \
of the Jewish New Year, DateQ -- whether a date is valid in the current \
calendar system", "synonyms" -> {}, "title" -> "Calendar Package", "type" -> 
    "Guide", "uri" -> "Calendar/guide/CalendarPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 58, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[680, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[739, 31, 267, 8, 70, "GuideText",
 CellID->203374175],
Cell[1009, 41, 270, 8, 70, "GuideText",
 CellID->1463276848],
Cell[1282, 51, 271, 8, 70, "GuideText",
 CellID->238456100],
Cell[1556, 61, 288, 8, 70, "GuideText",
 CellID->527187398],
Cell[1847, 71, 49, 1, 70, "GuideDelimiter",
 CellID->2068554311],
Cell[1899, 74, 280, 8, 70, "GuideText",
 CellID->1552525913],
Cell[2182, 84, 324, 9, 70, "GuideText",
 CellID->1376708741],
Cell[2509, 95, 271, 8, 70, "GuideText",
 CellID->1354997209],
Cell[2783, 105, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2834, 108, 281, 8, 70, "GuideText",
 CellID->875577994],
Cell[3118, 118, 49, 1, 70, "GuideDelimiter",
 CellID->1521498875],
Cell[3170, 121, 1222, 41, 70, "InlineGuideFunctionListing",
 CellID->1589416377],
Cell[4395, 164, 59, 1, 70, "GuideDelimiterSubsection",
 CellID->1425404266],
Cell[CellGroupData[{
Cell[4479, 169, 66, 1, 70, "GuideFunctionsSubsection",
 CellID->1459893263],
Cell[4548, 172, 689, 23, 70, "InlineGuideFunctionListing",
 CellID->1743807296]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5286, 201, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[5351, 204, 153, 3, 70, "GuideTutorial",
 CellID->1038258004]
}, Open  ]],
Cell[CellGroupData[{
Cell[5541, 212, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[5606, 215, 142, 3, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[5763, 221, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

