(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14280,        516]
NotebookOptionsPosition[      9870,        364]
NotebookOutlinePosition[     11838,        426]
CellTagsIndexPosition[     11726,        420]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["CALENDAR PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calendar Package" :> 
          Documentation`HelpLookup["paclet:Calendar/tutorial/Calendar"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calendar Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CalendarChange" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/CalendarChange"], 
          "DateQ" :> Documentation`HelpLookup[
           "paclet:Calendar/ref/DateQ"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"CalendarChange\"\>", 2->"\<\"DateQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Calendar", "ObjectName",
 CellID->475804437],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Calendar"], "InlineFormula"],
     " \[LineSeparator]is an option for calendar functions which specifies \
which calendar system to use."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->45399471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Calendar", "->", 
   StyleBox["system", "TI"]}]], "InlineFormula"],
 " specifies to use calendar system ",
 Cell[BoxData[
  StyleBox["system", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->69224797],

Cell["The following settings can be given:", "Notes",
 CellID->133937151],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Gregorian",
     BaseStyle->"Link",
     ButtonData->"paclet:Calendar/ref/Gregorian"], Cell[
    "Gregorian calendar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Julian",
     BaseStyle->"Link",
     ButtonData->"paclet:Calendar/ref/Julian"], Cell[
    "Julian calendar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Islamic",
     BaseStyle->"Link",
     ButtonData->"paclet:Calendar/ref/Islamic"], Cell[
    "Islamic calendar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Jewish",
     BaseStyle->"Link",
     ButtonData->"paclet:Calendar/ref/Jewish"], Cell[
    "Jewish calendar", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->2313386],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Calendar", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " the ",
 Cell[BoxData[
  ButtonBox["Julian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Julian"]], "InlineFormula"],
 " calendar is used before September 3, 1752, and the ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 " calendar after September 13, 1752."
}], "Notes",
 CellID->331256432]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->472402122],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->18629899],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->518473573],

Cell["Compute the number of days in the Islamic year 1420:", "ExampleText",
 CellID->794124818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1420", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1421", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Islamic"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->331849883],

Cell[BoxData["355"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->271207190]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70249561],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->76283237],

Cell["Compute the number of days in the Jewish year 5760:", "ExampleText",
 CellID->103198695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5760", ",", " ", "7", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"5761", ",", " ", "7", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->19980287],

Cell[BoxData["385"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->13981649]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->135619569],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->95577151],

Cell["In the Julian calendar, the year 1900 was a leap year:", "ExampleText",
 CellID->297621952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1900", ",", " ", "2", ",", " ", "29"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Julian"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->45170507],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->41875730]
}, Open  ]],

Cell["\<\
This is not true in the standard (Gregorian) Western calendar:\
\>", "ExampleText",
 CellID->348374174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateQ", "[", 
  RowBox[{"{", 
   RowBox[{"1900", ",", " ", "2", ",", " ", "29"}], "}"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->214754149],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->644276573]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12972814],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CalendarChange",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/CalendarChange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/DateQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->636284255]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->919622803],

Cell[TextData[ButtonBox["Calendar Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Calendar/tutorial/Calendar"]], "Tutorials",
 CellID->620152656]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Calendar - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 31.0675400}", "context" -> "Calendar`", 
    "keywords" -> {}, "index" -> True, "label" -> "Calendar Package Symbol", 
    "language" -> "en", "paclet" -> "Calendar Package", "status" -> "None", 
    "summary" -> 
    "Calendar is an option for calendar functions which specifies which \
calendar system to use.", "synonyms" -> {}, "title" -> "Calendar", "type" -> 
    "Symbol", "uri" -> "Calendar/ref/Calendar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4792, 162, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->472402122]},
 "CellTags"->{
  Cell[5581, 193, 365, 10, 28, "Input",
   CellTags->"CellTags",
   CellID->331849883],
  Cell[5949, 205, 183, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->271207190],
  Cell[6526, 229, 363, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->19980287],
  Cell[6892, 241, 182, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->13981649],
  Cell[7472, 265, 271, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->45170507],
  Cell[7746, 275, 183, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->41875730],
  Cell[8082, 291, 195, 6, 70, "Input",
   CellTags->"CellTags",
   CellID->214754149],
  Cell[8280, 299, 185, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->644276573]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10869, 388},
 {"CellTags", 11004, 392}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1274, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1897, 59, 50, 1, 70, "ObjectName",
 CellID->475804437],
Cell[1950, 62, 384, 11, 70, "Usage",
 CellID->45399471]
}, Open  ]],
Cell[CellGroupData[{
Cell[2371, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2849, 95, 247, 9, 70, "Notes",
 CellID->69224797],
Cell[3099, 106, 73, 1, 70, "Notes",
 CellID->133937151],
Cell[3175, 109, 1004, 27, 70, "2ColumnTableMod",
 CellID->2313386],
Cell[4182, 138, 573, 19, 70, "Notes",
 CellID->331256432]
}, Closed]],
Cell[CellGroupData[{
Cell[4792, 162, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->472402122],
Cell[CellGroupData[{
Cell[5177, 176, 147, 5, 70, "ExampleSection",
 CellID->18629899],
Cell[5327, 183, 131, 3, 70, "Input",
 CellID->518473573],
Cell[5461, 188, 95, 1, 70, "ExampleText",
 CellID->794124818],
Cell[CellGroupData[{
Cell[5581, 193, 365, 10, 28, "Input",
 CellTags->"CellTags",
 CellID->331849883],
Cell[5949, 205, 183, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->271207190]
}, Open  ]],
Cell[6147, 214, 124, 3, 70, "ExampleDelimiter",
 CellID->70249561],
Cell[6274, 219, 130, 3, 70, "Input",
 CellID->76283237],
Cell[6407, 224, 94, 1, 70, "ExampleText",
 CellID->103198695],
Cell[CellGroupData[{
Cell[6526, 229, 363, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->19980287],
Cell[6892, 241, 182, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->13981649]
}, Open  ]],
Cell[7089, 250, 125, 3, 70, "ExampleDelimiter",
 CellID->135619569],
Cell[7217, 255, 130, 3, 70, "Input",
 CellID->95577151],
Cell[7350, 260, 97, 1, 70, "ExampleText",
 CellID->297621952],
Cell[CellGroupData[{
Cell[7472, 265, 271, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->45170507],
Cell[7746, 275, 183, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->41875730]
}, Open  ]],
Cell[7944, 284, 113, 3, 70, "ExampleText",
 CellID->348374174],
Cell[CellGroupData[{
Cell[8082, 291, 195, 6, 70, "Input",
 CellTags->"CellTags",
 CellID->214754149],
Cell[8280, 299, 185, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->644276573]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8526, 312, 314, 9, 70, "SeeAlsoSection",
 CellID->12972814],
Cell[8843, 323, 479, 17, 70, "SeeAlso",
 CellID->636284255]
}, Open  ]],
Cell[CellGroupData[{
Cell[9359, 345, 318, 9, 70, "TutorialsSection",
 CellID->919622803],
Cell[9680, 356, 148, 3, 70, "Tutorials",
 CellID->620152656]
}, Open  ]],
Cell[9843, 362, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

