(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29710,       1068]
NotebookOptionsPosition[     20518,        753]
NotebookOutlinePosition[     24234,        869]
CellTagsIndexPosition[     24122,        863]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["CALENDAR PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calendar Package" :> 
          Documentation`HelpLookup["paclet:Calendar/tutorial/Calendar"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calendar Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calendar" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Calendar"], "DateQ" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/DateQ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Calendar\"\>", 
       2->"\<\"DateQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CalendarChange", "ObjectName",
 CellID->343817930],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CalendarChange", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["year", "TI"], ",", 
          StyleBox["month", "TI"], ",", 
          StyleBox["day", "TI"]}], "}"}], ",", 
        SubscriptBox[
         StyleBox["calendar", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["calendar", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts the date ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["year", "TI"], ",", 
        StyleBox["month", "TI"], ",", 
        StyleBox["day", "TI"]}], "}"}]], "InlineFormula"],
     " given in calendar ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["calendar", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " into a date given in calendar ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["calendar", "TI"], 
        StyleBox["2", "TR"]], "."}]], "InlineFormula"]
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CalendarChange", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["year", "TI"], ",", 
          StyleBox["month", "TI"], ",", 
          StyleBox["day", "TI"], ",", 
          StyleBox["hour", "TI"], ",", 
          StyleBox["minute", "TI"], ",", 
          StyleBox["second", "TI"]}], "}"}], ",", 
        SubscriptBox[
         StyleBox["calendar", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["calendar", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts the given date ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["year", "TI"], ",", 
        StyleBox["month", "TI"], ",", 
        StyleBox["day", "TI"], ",", 
        StyleBox["hour", "TI"], ",", 
        StyleBox["minute", "TI"], ",", 
        StyleBox["second", "TI"]}], "}"}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->236710245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The following settings can be given for ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["calendar", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["calendar", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 ":"
}], "Notes",
 CellID->719043182],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Gregorian",
     BaseStyle->"Link",
     ButtonData->"paclet:Calendar/ref/Gregorian"], Cell[
    "Gregorian calendar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Julian",
     BaseStyle->"Link",
     ButtonData->"paclet:Calendar/ref/Julian"], Cell[
    "Julian calendar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Islamic",
     BaseStyle->"Link",
     ButtonData->"paclet:Calendar/ref/Islamic"], Cell[
    "Islamic calendar", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Jewish",
     BaseStyle->"Link",
     ButtonData->"paclet:Calendar/ref/Jewish"], Cell[
    "Jewish calendar", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->695713190]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->455626081],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(8)", "ExampleCount"]
}], "ExampleSection",
 CellID->68082077],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->518473573],

Cell[TextData[{
 "The Western calendar in current use is the Gregorian calendar. To convert a \
contemporary Western date to another calendar, one uses ",
 Cell[BoxData["Gregorian"], "InlineFormula"],
 " for the contemporary Western date. \n",
 "Israel obtained its independence on May 14, 1948. This finds the Jewish \
date:"
}], "ExampleText",
 CellID->379447964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1948", ",", " ", "5", ",", " ", "14"}], "}"}], ",", " ", 
   "Gregorian", ",", " ", "Jewish"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->18580967],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5708", ",", "2", ",", "5"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->213690269]
}, Open  ]],

Cell[TextData[{
 "Because the Jewish calendar has a leap month preceding Passover, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a numbering starting with Nissan, the month of Passover:"
}], "ExampleText",
 CellID->49877700],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Nissan", ",", " ", "Iyar", ",", " ", "Sivan", ",", " ", "Tammuz", ",", " ",
    "Av", ",", " ", "Elul", ",", " ", "Tishrei", ",", " ", "Chesvan", ",", 
   " ", "Kislev", ",", " ", "Tevet", ",", " ", "Shvat", ",", " ", "Adar", ",",
    " ", "AdarII"}], "}"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->97955787],

Cell["Israel's independence was declared on the 5th of Iyar, 5708.", \
"ExampleText",
 CellID->624113567],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->217378],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->395945258],

Cell["\<\
This finds the Western date corresponding to the 50th Jewish anniversary:\
\>", "ExampleText",
 CellID->127048626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5758", ",", " ", "2", ",", " ", "5"}], "}"}], ",", " ", "Jewish",
    ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->158844725],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1998", ",", "5", ",", "1"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->613120499]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->48072830],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->507637001],

Cell["\<\
Between 1582 and 1752, Catholic countries used the Gregorian calendar while \
Britain and her colonies used the Julian calendar. To convert British and \
Catholic dates occurring between 1582 and 1752 , one needs to change \
calendars from Julian to Gregorian. \
\>", "ExampleText",
 CellID->66607446],

Cell["\<\
 George Washington was born February 22nd, 1732. In France, the date was:\
\>", "ExampleText",
 CellID->676974723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1732", ",", " ", "2", ",", " ", "22"}], "}"}], ",", " ", 
   "Julian", ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->70308628],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1732", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->517168462]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->181254200],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->104589693],

Cell["\<\
Voltaire was born on November 21st, 1694. In Great Britain the date was:\
\>", "ExampleText",
 CellID->47093215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1694", ",", " ", "11", ",", " ", "21"}], "}"}], ",", " ", 
   "Gregorian", ",", " ", "Julian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->764142385],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1694", ",", "11", ",", "11"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->458923266]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->218154043],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->539152727],

Cell["\<\
The Russian Orthodox Church still uses the Julian calendar. This finds the \
Western (Gregorian) date of Greek Orthodox Christmas 2000:\
\>", "ExampleText",
 CellID->281146606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "12", ",", " ", "25"}], "}"}], ",", " ", 
   "Julian", ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->8871282],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2001", ",", "1", ",", "7"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->396516378]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->241024524],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->129537172],

Cell["\<\
One can find Islamic dates corresponding to Western (Gregorian) dates:\
\>", "ExampleText",
 CellID->42743007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   "Gregorian", ",", " ", "Islamic"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->73426230],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1420", ",", "9", ",", "24"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->456567466]
}, Open  ]],

Cell["The Islamic calendar has the following months:", "ExampleText",
 CellID->28102292],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Muharram", ",", " ", "Safar", ",", " ", "RabiaI", ",", " ", "RabiaII", ",",
    " ", "JumadaI", ",", " ", "JumadaII", ",", " ", "Rajab", ",", " ", 
   "Shaban", ",", " ", "Ramadan", ",", " ", "Shawwal", ",", " ", "DhualQada", 
   ",", " ", "DhualHijah"}], "}"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->15070897],

Cell["The above date is therefore 24th of Ramadan, 1420. ", "ExampleText",
 CellID->21800917],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91632068],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->38054474],

Cell["\<\
The Western date for the beginning of Ramadan of the Islamic year 1420:\
\>", "ExampleText",
 CellID->549054921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1420", ",", " ", "9", ",", " ", "1"}], "}"}], ",", " ", 
   "Islamic", ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->63492160],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1999", ",", "12", ",", "9"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->130935395]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->348136524],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->12147087],

Cell[TextData[{
 "Hours, minutes, seconds, are left unchanged by ",
 Cell[BoxData["CalendarChange"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->23987893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1694", ",", " ", "11", ",", " ", "21", ",", " ", "0", ",", " ", "0", ",",
      " ", "0"}], "}"}], ",", " ", "Gregorian", ",", " ", "Julian"}], 
  "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->411704726],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1694", ",", "11", ",", "11", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->660771848]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1694", ",", " ", "11", ",", " ", "21", ",", " ", "23", ",", " ", "59", 
     ",", " ", "59"}], "}"}], ",", " ", "Gregorian", ",", " ", "Julian"}], 
  "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->298240395],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1694", ",", "11", ",", "11", ",", "23", ",", "59", ",", "59"}], 
  "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->180848961]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->61691061],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->402280214],

Cell["\<\
Because it is a solar and lunar calendar (the year follows the seasons and \
the months keep track of the phases of the moon), the Jewish calendar has an \
extra leap month 7 times every 19 years. This leap month occurs in Spring the \
month preceding Passover, so it is appropriate to count the Jewish months \
starting with Nissan, the month of Passover as follows: \
\>", "ExampleText",
 CellID->415413496],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"{", 
   RowBox[{
   "Nissan", ",", " ", "Iyar", ",", " ", "Sivan", ",", " ", "Tammuz", ",", 
    " ", "Av", ",", " ", "Elul", ",", " ", "Tishrei", ",", " ", "Chesvan", 
    ",", " ", "Kislev", ",", " ", "Tevet", ",", " ", "Shvat", ",", " ", 
    "Adar", ",", " ", "AdarII"}], "}"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->625184194],

Cell["\<\
Since the Jewish year begins in the Fall, this numeration of months will not \
always follow an increasing order, that is, later dates in the same year may \
have a smaller number for the month:\
\>", "ExampleText",
 CellID->210204165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2006", ",", "3", ",", "29"}], "}"}], ",", "Gregorian", ",", 
   "Jewish"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->219762919],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5766", ",", "12", ",", "29"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->29356726]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2006", ",", "3", ",", "30"}], "}"}], ",", "Gregorian", ",", 
   "Jewish"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[4]:=",
 CellID->476444314],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5766", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[4]=",
 CellID->39801684]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->441102140],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Calendar",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Calendar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/DateQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->84973779]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->503260418],

Cell[TextData[ButtonBox["Calendar Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Calendar/tutorial/Calendar"]], "Tutorials",
 CellID->620152656]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CalendarChange - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 30.7237812}", "context" -> "Calendar`", 
    "keywords" -> {}, "index" -> True, "label" -> "Calendar Package Symbol", 
    "language" -> "en", "paclet" -> "Calendar Package", "status" -> "None", 
    "summary" -> 
    "CalendarChange[{year, month, day}, calendar_1, calendar_2] converts the \
date {year, month, day} given in calendar calendar_1 into a date given in \
calendar calendar_2. CalendarChange[{year, month, day, hour, minute, second}, \
calendar_1, calendar_2] converts the given date {year, month, day, hour, \
minute, second}.", "synonyms" -> {}, "title" -> "CalendarChange", "type" -> 
    "Symbol", "uri" -> "Calendar/ref/CalendarChange"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6067, 201, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->455626081]},
 "CellTags"->{
  Cell[7126, 239, 265, 8, 28, "Input",
   CellTags->"CellTags",
   CellID->18580967],
  Cell[7394, 249, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->213690269],
  Cell[7889, 268, 376, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->97955787],
  Cell[8784, 300, 265, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->158844725],
  Cell[9052, 310, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->613120499],
  Cell[10030, 346, 265, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->70308628],
  Cell[10298, 356, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->517168462],
  Cell[10961, 384, 267, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->764142385],
  Cell[11231, 394, 241, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->458923266],
  Cell[11960, 423, 265, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->8871282],
  Cell[12228, 433, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->396516378],
  Cell[12889, 461, 265, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->73426230],
  Cell[13157, 471, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->456567466],
  Cell[13503, 485, 380, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->15070897],
  Cell[14389, 516, 265, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->63492160],
  Cell[14657, 526, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->130935395],
  Cell[15359, 556, 322, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->411704726],
  Cell[15684, 568, 275, 9, 36, "Output",
   CellTags->"CellTags",
   CellID->660771848],
  Cell[15996, 582, 325, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->298240395],
  Cell[16324, 594, 278, 9, 36, "Output",
   CellTags->"CellTags",
   CellID->180848961],
  Cell[17439, 632, 400, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->625184194],
  Cell[18112, 653, 246, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->219762919],
  Cell[18361, 663, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->29356726],
  Cell[18638, 676, 246, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->476444314],
  Cell[18887, 686, 238, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->39801684]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21764, 780},
 {"CellTags", 21899, 784}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1253, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1876, 59, 56, 1, 70, "ObjectName",
 CellID->343817930],
Cell[1935, 62, 2249, 70, 70, "Usage",
 CellID->236710245]
}, Open  ]],
Cell[CellGroupData[{
Cell[4221, 137, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4699, 154, 322, 13, 70, "Notes",
 CellID->719043182],
Cell[5024, 169, 1006, 27, 70, "2ColumnTableMod",
 CellID->695713190]
}, Closed]],
Cell[CellGroupData[{
Cell[6067, 201, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->455626081],
Cell[CellGroupData[{
Cell[6452, 215, 147, 5, 70, "ExampleSection",
 CellID->68082077],
Cell[6602, 222, 131, 3, 70, "Input",
 CellID->518473573],
Cell[6736, 227, 365, 8, 70, "ExampleText",
 CellID->379447964],
Cell[CellGroupData[{
Cell[7126, 239, 265, 8, 28, "Input",
 CellTags->"CellTags",
 CellID->18580967],
Cell[7394, 249, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->213690269]
}, Open  ]],
Cell[7648, 260, 238, 6, 70, "ExampleText",
 CellID->49877700],
Cell[7889, 268, 376, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->97955787],
Cell[8268, 279, 105, 2, 70, "ExampleText",
 CellID->624113567],
Cell[8376, 283, 122, 3, 70, "ExampleDelimiter",
 CellID->217378],
Cell[8501, 288, 131, 3, 70, "Input",
 CellID->395945258],
Cell[8635, 293, 124, 3, 70, "ExampleText",
 CellID->127048626],
Cell[CellGroupData[{
Cell[8784, 300, 265, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->158844725],
Cell[9052, 310, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->613120499]
}, Open  ]],
Cell[9306, 321, 124, 3, 70, "ExampleDelimiter",
 CellID->48072830],
Cell[9433, 326, 131, 3, 70, "Input",
 CellID->507637001],
Cell[9567, 331, 311, 6, 70, "ExampleText",
 CellID->66607446],
Cell[9881, 339, 124, 3, 70, "ExampleText",
 CellID->676974723],
Cell[CellGroupData[{
Cell[10030, 346, 265, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->70308628],
Cell[10298, 356, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->517168462]
}, Open  ]],
Cell[10552, 367, 125, 3, 70, "ExampleDelimiter",
 CellID->181254200],
Cell[10680, 372, 131, 3, 70, "Input",
 CellID->104589693],
Cell[10814, 377, 122, 3, 70, "ExampleText",
 CellID->47093215],
Cell[CellGroupData[{
Cell[10961, 384, 267, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->764142385],
Cell[11231, 394, 241, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->458923266]
}, Open  ]],
Cell[11487, 405, 125, 3, 70, "ExampleDelimiter",
 CellID->218154043],
Cell[11615, 410, 131, 3, 70, "Input",
 CellID->539152727],
Cell[11749, 415, 186, 4, 70, "ExampleText",
 CellID->281146606],
Cell[CellGroupData[{
Cell[11960, 423, 265, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->8871282],
Cell[12228, 433, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->396516378]
}, Open  ]],
Cell[12482, 444, 125, 3, 70, "ExampleDelimiter",
 CellID->241024524],
Cell[12610, 449, 131, 3, 70, "Input",
 CellID->129537172],
Cell[12744, 454, 120, 3, 70, "ExampleText",
 CellID->42743007],
Cell[CellGroupData[{
Cell[12889, 461, 265, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->73426230],
Cell[13157, 471, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->456567466]
}, Open  ]],
Cell[13412, 482, 88, 1, 70, "ExampleText",
 CellID->28102292],
Cell[13503, 485, 380, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->15070897],
Cell[13886, 496, 93, 1, 70, "ExampleText",
 CellID->21800917],
Cell[13982, 499, 124, 3, 70, "ExampleDelimiter",
 CellID->91632068],
Cell[14109, 504, 130, 3, 70, "Input",
 CellID->38054474],
Cell[14242, 509, 122, 3, 70, "ExampleText",
 CellID->549054921],
Cell[CellGroupData[{
Cell[14389, 516, 265, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->63492160],
Cell[14657, 526, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->130935395]
}, Open  ]],
Cell[14912, 537, 125, 3, 70, "ExampleDelimiter",
 CellID->348136524],
Cell[15040, 542, 130, 3, 70, "Input",
 CellID->12147087],
Cell[15173, 547, 161, 5, 70, "ExampleText",
 CellID->23987893],
Cell[CellGroupData[{
Cell[15359, 556, 322, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->411704726],
Cell[15684, 568, 275, 9, 36, "Output",
 CellTags->"CellTags",
 CellID->660771848]
}, Open  ]],
Cell[CellGroupData[{
Cell[15996, 582, 325, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->298240395],
Cell[16324, 594, 278, 9, 36, "Output",
 CellTags->"CellTags",
 CellID->180848961]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16651, 609, 229, 7, 70, "ExampleSection",
 CellID->61691061],
Cell[16883, 618, 131, 3, 70, "Input",
 CellID->402280214],
Cell[17017, 623, 419, 7, 70, "ExampleText",
 CellID->415413496],
Cell[17439, 632, 400, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->625184194],
Cell[17842, 644, 245, 5, 70, "ExampleText",
 CellID->210204165],
Cell[CellGroupData[{
Cell[18112, 653, 246, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->219762919],
Cell[18361, 663, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->29356726]
}, Open  ]],
Cell[CellGroupData[{
Cell[18638, 676, 246, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->476444314],
Cell[18887, 686, 238, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->39801684]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19186, 701, 315, 9, 70, "SeeAlsoSection",
 CellID->441102140],
Cell[19504, 712, 466, 17, 70, "SeeAlso",
 CellID->84973779]
}, Open  ]],
Cell[CellGroupData[{
Cell[20007, 734, 318, 9, 70, "TutorialsSection",
 CellID->503260418],
Cell[20328, 745, 148, 3, 70, "Tutorials",
 CellID->620152656]
}, Open  ]],
Cell[20491, 751, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

