(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33026,       1219]
NotebookOptionsPosition[     22418,        842]
NotebookOutlinePosition[     26707,        984]
CellTagsIndexPosition[     26595,        978]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["CALENDAR PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calendar Package" :> 
          Documentation`HelpLookup["paclet:Calendar/tutorial/Calendar"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calendar Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CalendarChange" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/CalendarChange"], 
          "Calendar" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Calendar"], 
          "Gregorian" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Gregorian"], "Julian" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Julian"], "Islamic" :> 
          Documentation`HelpLookup["paclet:Calendar/ref/Islamic"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CalendarChange\"\>", 
       2->"\<\"Calendar\"\>", 3->"\<\"Gregorian\"\>", 4->"\<\"Julian\"\>", 
       5->"\<\"Islamic\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Jewish", "ObjectName",
 CellID->109375029],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Jewish"], "InlineFormula"],
     " \[LineSeparator]represents the Jewish calendar system. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->58082033]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Jewish"], "InlineFormula"],
 " is a value for the ",
 Cell[BoxData[
  ButtonBox["Calendar",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Calendar"]], "InlineFormula"],
 " option, and can be used as an argument to ",
 Cell[BoxData[
  ButtonBox["CalendarChange",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/CalendarChange"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->165142104]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->461832535],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->47358410],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->518473573],

Cell[TextData[{
 "The argument ",
 Cell[BoxData["Jewish"], "InlineFormula"],
 " to ",
 Cell[BoxData["CalendarChange"], "InlineFormula"],
 " converts between Western (Gregorian) dates and Jewish dates. The Gregorian \
date of Israel's independence is May 14, 1948:"
}], "ExampleText",
 CellID->103938469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1948", ",", " ", "5", ",", " ", "14"}], "}"}], ",", " ", 
   "Gregorian", ",", " ", "Jewish"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->103321483],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5708", ",", "2", ",", "5"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->165963138]
}, Open  ]],

Cell[TextData[{
 "Because the Jewish calendar has a leap month preceding Passover, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a numbering starting with Nissan, the month of Passover:"
}], "ExampleText",
 CellID->222427260],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"{", 
   RowBox[{
   "Nissan", ",", " ", "Iyar", ",", " ", "Sivan", ",", " ", "Tammuz", ",", 
    " ", "Av", ",", " ", "Elul", ",", " ", "Tishrei", ",", " ", "Chesvan", 
    ",", " ", "Kislev", ",", " ", "Tevet", ",", " ", "Shvat", ",", " ", 
    "Adar", ",", " ", "AdarII"}], "}"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->18739997],

Cell["Israel's independence was declared on the 5th of Iyar, 5708.", \
"ExampleText",
 CellID->397810317],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172789189],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->63767863],

Cell[TextData[{
 "In the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " numbering Tishrei, the first month of the Jewish year, is number 7."
}], "ExampleText",
 CellID->522729017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JewishNewYear", "[", "2006", "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->37230472],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2006", ",", "9", ",", "23"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->540146778]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{"%", ",", " ", "Gregorian", ",", " ", "Jewish"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->315125117],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5767", ",", "7", ",", "1"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->56062083]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->126689519],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->2018250],

Cell["By definition, Yom Kippur cannot fall on a Friday or Sunday:", \
"ExampleText",
 CellID->351213125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"DayOfWeek", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", "7", ",", " ", "10"}], "}"}], ",", " ", 
      RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}], "&"}], " ", "/@",
    " ", 
   RowBox[{"Range", "[", 
    RowBox[{"5700", ",", " ", "5800"}], "]"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->781436486],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Monday", ",", "Saturday", ",", "Thursday", ",", "Wednesday"}], 
  "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->664571197]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->350842421],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->20791152],

Cell["\<\
Because of the leap month, Jewish dates can vary by up to a month in the \
Western calendar. The Western and Jewish anniversaries of Israel's \
independence differ greatly, in general:\
\>", "ExampleText",
 CellID->207527185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5709", ",", " ", "2", ",", " ", "5"}], "}"}], ",", " ", "Jewish",
    ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->183729451],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1949", ",", "5", ",", "4"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->693150096]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5710", ",", " ", "2", ",", " ", "5"}], "}"}], ",", " ", "Jewish",
    ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->160936118],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1950", ",", "4", ",", "22"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->2045171]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13200875],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->235917457],

Cell["\<\
The Jewish calendar follows a 19 year cycle. Western and Jewish anniversaries \
will correspond almost exactly every 19 years:\
\>", "ExampleText",
 CellID->80894640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5727", ",", " ", "2", ",", " ", "5"}], "}"}], ",", " ", "Jewish",
    ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->113060734],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1967", ",", "5", ",", "15"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->270161135]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5746", ",", " ", "2", ",", " ", "5"}], "}"}], ",", " ", "Jewish",
    ",", " ", "Gregorian"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->3187171],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1986", ",", "5", ",", "14"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->377102646]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->219552897],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->221120506],

Cell["\<\
A program which returns the Western (Gregorian) date of Passover for a given \
Western year:\
\>", "ExampleText",
 CellID->112854515],

Cell[BoxData[
 RowBox[{
  RowBox[{"Passover", "[", "year_", "]"}], ":=", " ", 
  RowBox[{"CalendarChange", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"First", "[", " ", 
       RowBox[{"CalendarChange", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"year", ",", " ", "4", ",", " ", "1"}], "}"}], ",", " ", 
         "Gregorian", ",", " ", "Jewish"}], "]"}], "]"}], ",", " ", "1", ",", 
      " ", "15"}], "}"}], ",", " ", "Jewish", ",", " ", "Gregorian"}], 
   "]"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->371100966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Passover", "[", "2006", "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->44199209],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2006", ",", "4", ",", "13"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->572816665]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37896188],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->245870056],

Cell["\<\
A program which returns the Western (Gregorian) date of Yom Kippur for a \
given Western year:\
\>", "ExampleText",
 CellID->415469536],

Cell[BoxData[
 RowBox[{
  RowBox[{"YomKippur", "[", "year_", "]"}], ":=", " ", 
  RowBox[{"CalendarChange", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"First", "[", " ", 
       RowBox[{"CalendarChange", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"year", ",", " ", "11", ",", " ", "1"}], "}"}], ",", " ", 
         "Gregorian", ",", " ", "Jewish"}], "]"}], "]"}], ",", " ", "7", ",", 
      " ", "10"}], "}"}], ",", " ", "Jewish", ",", " ", "Gregorian"}], 
   "]"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->1399731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"YomKippur", "[", "2006", "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->646325710],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2006", ",", "10", ",", "2"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->93647021]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->179364964],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->251302911],

Cell["\<\
A program which returns the Western date of the Jewish Holiday Lag Ba'Omer \
for a given Western year:\
\>", "ExampleText",
 CellID->100637423],

Cell[BoxData[
 RowBox[{
  RowBox[{"LagBaOmer", "[", "year_", "]"}], ":=", " ", 
  RowBox[{"CalendarChange", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"First", "[", " ", 
       RowBox[{"CalendarChange", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"year", ",", " ", "4", ",", " ", "1"}], "}"}], ",", " ", 
         "Gregorian", ",", " ", "Jewish"}], "]"}], "]"}], ",", " ", "2", ",", 
      " ", "18"}], "}"}], ",", " ", "Jewish", ",", " ", "Gregorian"}], 
   "]"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->619031145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LagBaOmer", "[", "2006", "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->681300172],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2006", ",", "5", ",", "16"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->215745238]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->532047795],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Calendar`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->77731659],

Cell["\<\
Because it is a solar and lunar calendar (the year follows the seasons and \
the months keep track of the phases of the moon), the Jewish calendar has an \
extra leap month 7 times every 19 years. This leap month occurs in Spring the \
month preceding Passover, so it is appropriate to count the Jewish months \
starting with Nissan, the month of Passover as follows: \
\>", "ExampleText",
 CellID->447441648],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"{", 
   RowBox[{
   "Nissan", ",", " ", "Iyar", ",", " ", "Sivan", ",", " ", "Tammuz", ",", 
    " ", "Av", ",", " ", "Elul", ",", " ", "Tishrei", ",", " ", "Chesvan", 
    ",", " ", "Kislev", ",", " ", "Tevet", ",", " ", "Shvat", ",", " ", 
    "Adar", ",", " ", "AdarII"}], "}"}]}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->10937821],

Cell["\<\
Since the Jewish year begins in the Fall, this numeration of months will not \
always follow an increasing order, that is, later dates in the same year may \
have a smaller number for the month:\
\>", "ExampleText",
 CellID->120636592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2006", ",", "3", ",", "29"}], "}"}], ",", "Gregorian", ",", 
   "Jewish"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[3]:=",
 CellID->37921544],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5766", ",", "12", ",", "29"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[3]=",
 CellID->426501719]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2006", ",", "3", ",", "30"}], "}"}], ",", "Gregorian", ",", 
   "Jewish"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[4]:=",
 CellID->10413467],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5766", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[4]=",
 CellID->16693735]
}, Open  ]],

Cell[TextData[{
 "For this reason, some calendar functions will still work with the ",
 Cell[BoxData[
  RowBox[{"Calendar", " ", "->", " ", "Jewish"}]], "InlineFormula"],
 " option, but will not follow the same rules.",
 " ",
 Cell[BoxData["DaysBetween"], "InlineFormula"],
 " can return a positive number even if the second date is lexicographically \
smaller (smaller in the canonical ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ordering): "
}], "ExampleText",
 CellID->146536495],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5766", ",", " ", "12", ",", " ", "29"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"5766", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[5]:=",
 CellID->28083268],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[5]=",
 CellID->849305653]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["DaysPlus"], "InlineFormula"],
 " can return a lexicographically smaller (smaller in the canonical ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ordering) result for a later date: "
}], "ExampleText",
 CellID->33584418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5766", ",", " ", "12", ",", " ", "29"}], "}"}], ",", " ", "1", 
   ",", " ", 
   RowBox[{"Calendar", " ", "->", " ", "Jewish"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[6]:=",
 CellID->470504520],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5766", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[6]=",
 CellID->4642552]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->435604409],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CalendarChange",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/CalendarChange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Calendar",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Calendar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gregorian",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Gregorian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Julian",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Julian"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Islamic",
    BaseStyle->"Link",
    ButtonData->"paclet:Calendar/ref/Islamic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->41589160]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32514548],

Cell[TextData[ButtonBox["Calendar Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Calendar/tutorial/Calendar"]], "Tutorials",
 CellID->620152656]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Jewish - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 39.0833702}", "context" -> "Calendar`", 
    "keywords" -> {}, "index" -> True, "label" -> "Calendar Package Symbol", 
    "language" -> "en", "paclet" -> "Calendar Package", "status" -> "None", 
    "summary" -> "Jewish represents the Jewish calendar system. ", 
    "synonyms" -> {}, "title" -> "Jewish", "type" -> "Symbol", "uri" -> 
    "Calendar/ref/Jewish"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3623, 119, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->461832535]},
 "CellTags"->{
  Cell[4620, 157, 266, 8, 28, "Input",
   CellTags->"CellTags",
   CellID->103321483],
  Cell[4889, 167, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->165963138],
  Cell[5385, 186, 399, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->18739997],
  Cell[6368, 222, 134, 4, 70, "Input",
   CellTags->"CellTags",
   CellID->37230472],
  Cell[6505, 228, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->540146778],
  Cell[6782, 241, 189, 5, 70, "Input",
   CellTags->"CellTags",
   CellID->315125117],
  Cell[6974, 248, 238, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->56062083],
  Cell[7617, 275, 440, 14, 70, "Input",
   CellTags->"CellTags",
   CellID->781436486],
  Cell[8060, 291, 277, 9, 36, "Output",
   CellTags->"CellTags",
   CellID->664571197],
  Cell[8873, 322, 265, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->183729451],
  Cell[9141, 332, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->693150096],
  Cell[9417, 345, 265, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->160936118],
  Cell[9685, 355, 238, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->2045171],
  Cell[10400, 384, 265, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->113060734],
  Cell[10668, 394, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->270161135],
  Cell[10945, 407, 263, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->3187171],
  Cell[11211, 417, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->377102646],
  Cell[12010, 451, 584, 17, 70, "Input",
   CellTags->"CellTags",
   CellID->371100966],
  Cell[12619, 472, 129, 4, 70, "Input",
   CellTags->"CellTags",
   CellID->44199209],
  Cell[12751, 478, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->572816665],
  Cell[13415, 505, 584, 17, 70, "Input",
   CellTags->"CellTags",
   CellID->1399731],
  Cell[14024, 526, 131, 4, 70, "Input",
   CellTags->"CellTags",
   CellID->646325710],
  Cell[14158, 532, 239, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->93647021],
  Cell[14830, 559, 585, 17, 70, "Input",
   CellTags->"CellTags",
   CellID->619031145],
  Cell[15440, 580, 131, 4, 70, "Input",
   CellTags->"CellTags",
   CellID->681300172],
  Cell[15574, 586, 240, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->215745238],
  Cell[16651, 623, 399, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->10937821],
  Cell[17323, 644, 245, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->37921544],
  Cell[17571, 654, 241, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->426501719],
  Cell[17849, 667, 245, 8, 70, "Input",
   CellTags->"CellTags",
   CellID->10413467],
  Cell[18097, 677, 238, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->16693735],
  Cell[18868, 705, 365, 10, 70, "Input",
   CellTags->"CellTags",
   CellID->28083268],
  Cell[19236, 717, 181, 6, 36, "Output",
   CellTags->"CellTags",
   CellID->849305653],
  Cell[19715, 737, 295, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->470504520],
  Cell[20013, 748, 237, 8, 36, "Output",
   CellTags->"CellTags",
   CellID->4642552]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23365, 865},
 {"CellTags", 23500, 869}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1622, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2245, 65, 48, 1, 70, "ObjectName",
 CellID->109375029],
Cell[2296, 68, 338, 10, 70, "Usage",
 CellID->58082033]
}, Open  ]],
Cell[CellGroupData[{
Cell[2671, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3149, 100, 437, 14, 70, "Notes",
 CellID->165142104]
}, Closed]],
Cell[CellGroupData[{
Cell[3623, 119, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->461832535],
Cell[CellGroupData[{
Cell[4008, 133, 147, 5, 70, "ExampleSection",
 CellID->47358410],
Cell[4158, 140, 131, 3, 70, "Input",
 CellID->518473573],
Cell[4292, 145, 303, 8, 70, "ExampleText",
 CellID->103938469],
Cell[CellGroupData[{
Cell[4620, 157, 266, 8, 28, "Input",
 CellTags->"CellTags",
 CellID->103321483],
Cell[4889, 167, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->165963138]
}, Open  ]],
Cell[5143, 178, 239, 6, 70, "ExampleText",
 CellID->222427260],
Cell[5385, 186, 399, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->18739997],
Cell[5787, 198, 105, 2, 70, "ExampleText",
 CellID->397810317],
Cell[5895, 202, 125, 3, 70, "ExampleDelimiter",
 CellID->172789189],
Cell[6023, 207, 130, 3, 70, "Input",
 CellID->63767863],
Cell[6156, 212, 187, 6, 70, "ExampleText",
 CellID->522729017],
Cell[CellGroupData[{
Cell[6368, 222, 134, 4, 70, "Input",
 CellTags->"CellTags",
 CellID->37230472],
Cell[6505, 228, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->540146778]
}, Open  ]],
Cell[CellGroupData[{
Cell[6782, 241, 189, 5, 70, "Input",
 CellTags->"CellTags",
 CellID->315125117],
Cell[6974, 248, 238, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->56062083]
}, Open  ]],
Cell[7227, 259, 125, 3, 70, "ExampleDelimiter",
 CellID->126689519],
Cell[7355, 264, 129, 3, 70, "Input",
 CellID->2018250],
Cell[7487, 269, 105, 2, 70, "ExampleText",
 CellID->351213125],
Cell[CellGroupData[{
Cell[7617, 275, 440, 14, 70, "Input",
 CellTags->"CellTags",
 CellID->781436486],
Cell[8060, 291, 277, 9, 36, "Output",
 CellTags->"CellTags",
 CellID->664571197]
}, Open  ]],
Cell[8352, 303, 125, 3, 70, "ExampleDelimiter",
 CellID->350842421],
Cell[8480, 308, 130, 3, 70, "Input",
 CellID->20791152],
Cell[8613, 313, 235, 5, 70, "ExampleText",
 CellID->207527185],
Cell[CellGroupData[{
Cell[8873, 322, 265, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->183729451],
Cell[9141, 332, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->693150096]
}, Open  ]],
Cell[CellGroupData[{
Cell[9417, 345, 265, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->160936118],
Cell[9685, 355, 238, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->2045171]
}, Open  ]],
Cell[9938, 366, 124, 3, 70, "ExampleDelimiter",
 CellID->13200875],
Cell[10065, 371, 131, 3, 70, "Input",
 CellID->235917457],
Cell[10199, 376, 176, 4, 70, "ExampleText",
 CellID->80894640],
Cell[CellGroupData[{
Cell[10400, 384, 265, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->113060734],
Cell[10668, 394, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->270161135]
}, Open  ]],
Cell[CellGroupData[{
Cell[10945, 407, 263, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->3187171],
Cell[11211, 417, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->377102646]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11500, 431, 227, 7, 70, "ExampleSection",
 CellID->219552897],
Cell[11730, 440, 131, 3, 70, "Input",
 CellID->221120506],
Cell[11864, 445, 143, 4, 70, "ExampleText",
 CellID->112854515],
Cell[12010, 451, 584, 17, 70, "Input",
 CellTags->"CellTags",
 CellID->371100966],
Cell[CellGroupData[{
Cell[12619, 472, 129, 4, 70, "Input",
 CellTags->"CellTags",
 CellID->44199209],
Cell[12751, 478, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->572816665]
}, Open  ]],
Cell[13006, 489, 124, 3, 70, "ExampleDelimiter",
 CellID->37896188],
Cell[13133, 494, 131, 3, 70, "Input",
 CellID->245870056],
Cell[13267, 499, 145, 4, 70, "ExampleText",
 CellID->415469536],
Cell[13415, 505, 584, 17, 70, "Input",
 CellTags->"CellTags",
 CellID->1399731],
Cell[CellGroupData[{
Cell[14024, 526, 131, 4, 70, "Input",
 CellTags->"CellTags",
 CellID->646325710],
Cell[14158, 532, 239, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->93647021]
}, Open  ]],
Cell[14412, 543, 125, 3, 70, "ExampleDelimiter",
 CellID->179364964],
Cell[14540, 548, 131, 3, 70, "Input",
 CellID->251302911],
Cell[14674, 553, 153, 4, 70, "ExampleText",
 CellID->100637423],
Cell[14830, 559, 585, 17, 70, "Input",
 CellTags->"CellTags",
 CellID->619031145],
Cell[CellGroupData[{
Cell[15440, 580, 131, 4, 70, "Input",
 CellTags->"CellTags",
 CellID->681300172],
Cell[15574, 586, 240, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->215745238]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15863, 600, 230, 7, 70, "ExampleSection",
 CellID->532047795],
Cell[16096, 609, 130, 3, 70, "Input",
 CellID->77731659],
Cell[16229, 614, 419, 7, 70, "ExampleText",
 CellID->447441648],
Cell[16651, 623, 399, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->10937821],
Cell[17053, 635, 245, 5, 70, "ExampleText",
 CellID->120636592],
Cell[CellGroupData[{
Cell[17323, 644, 245, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->37921544],
Cell[17571, 654, 241, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->426501719]
}, Open  ]],
Cell[CellGroupData[{
Cell[17849, 667, 245, 8, 70, "Input",
 CellTags->"CellTags",
 CellID->10413467],
Cell[18097, 677, 238, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->16693735]
}, Open  ]],
Cell[18350, 688, 493, 13, 70, "ExampleText",
 CellID->146536495],
Cell[CellGroupData[{
Cell[18868, 705, 365, 10, 70, "Input",
 CellTags->"CellTags",
 CellID->28083268],
Cell[19236, 717, 181, 6, 36, "Output",
 CellTags->"CellTags",
 CellID->849305653]
}, Open  ]],
Cell[19432, 726, 258, 7, 70, "ExampleText",
 CellID->33584418],
Cell[CellGroupData[{
Cell[19715, 737, 295, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->470504520],
Cell[20013, 748, 237, 8, 36, "Output",
 CellTags->"CellTags",
 CellID->4642552]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20311, 763, 315, 9, 70, "SeeAlsoSection",
 CellID->435604409],
Cell[20629, 774, 1242, 44, 70, "SeeAlso",
 CellID->41589160]
}, Open  ]],
Cell[CellGroupData[{
Cell[21908, 823, 317, 9, 70, "TutorialsSection",
 CellID->32514548],
Cell[22228, 834, 148, 3, 70, "Tutorials",
 CellID->620152656]
}, Open  ]],
Cell[22391, 840, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

