(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24365,        850]
NotebookOptionsPosition[     19829,        697]
NotebookOutlinePosition[     21412,        738]
CellTagsIndexPosition[     21369,        735]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["CALENDAR PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Calendar" :> 
         Documentation`HelpLookup["paclet:Calendar/ref/Calendar"], 
         "CalendarChange" :> 
         Documentation`HelpLookup["paclet:Calendar/ref/CalendarChange"], 
         "DayOfWeek" :> 
         Documentation`HelpLookup["paclet:Calendar/ref/DayOfWeek"], 
         "DaysBetween" :> 
         Documentation`HelpLookup["paclet:Calendar/ref/DaysBetween"], 
         "DaysPlus" :> 
         Documentation`HelpLookup["paclet:Calendar/ref/DaysPlus"], 
         "EasterSunday" :> 
         Documentation`HelpLookup["paclet:Calendar/ref/EasterSunday"], 
         "EasterSundayGreekOrthodox" :> 
         Documentation`HelpLookup[
          "paclet:Calendar/ref/EasterSundayGreekOrthodox"], "Gregorian" :> 
         Documentation`HelpLookup["paclet:Calendar/ref/Gregorian"], 
         "JewishNewYear" :> 
         Documentation`HelpLookup["paclet:Calendar/ref/JewishNewYear"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Calendar\"\>", 
      2->"\<\"CalendarChange\"\>", 3->"\<\"DayOfWeek\"\>", 
      4->"\<\"DaysBetween\"\>", 5->"\<\"DaysPlus\"\>", 
      6->"\<\"EasterSunday\"\>", 7->"\<\"EasterSundayGreekOrthodox\"\>", 
      8->"\<\"Gregorian\"\>", 
      9->"\<\"JewishNewYear\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Calendar Package", "Title",
 CellID->17659],

Cell["\<\
This package provides a unified treatment of the basic calendar operations. \
The main idea is to treat the calendar as a generalized number system, so \
that days, weeks, months, and years are thought of as generalizing the digits \
of a number in a given base.\
\>", "Text",
 CellID->12504],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DayOfWeek",
      BaseStyle->"Link",
      ButtonData->"paclet:Calendar/ref/DayOfWeek"], "[", "{", 
     StyleBox["year", "TI"], ",", 
     StyleBox["month", "TI"], ",", 
     StyleBox["day", "TI"], "}", "]"}], Cell[
    "give the day of the week on which the given date occurred", 
     "TableText"]},
   {
    StyleBox[
     RowBox[{
      ButtonBox["DaysBetween",
       BaseStyle->"Link",
       ButtonData->"paclet:Calendar/ref/DaysBetween"], "[", "{", 
      SubscriptBox[
       StyleBox["year", "TI"], "1"], ",", 
      SubscriptBox[
       StyleBox["month", "TI"], "1"], ",", 
      SubscriptBox[
       StyleBox["day", "TI"], "1"], "}", ",", "{", 
      SubscriptBox[
       StyleBox["year", "TI"], "2"], ",", 
      SubscriptBox[
       StyleBox["month", "TI"], "2"], ",", 
      SubscriptBox[
       StyleBox["day", "TI"], "2"], "}", "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[
    "give the number of days between the given dates", "TableText"]},
   {
    RowBox[{
     ButtonBox["DaysPlus",
      BaseStyle->"Link",
      ButtonData->"paclet:Calendar/ref/DaysPlus"], "[", "{", 
     StyleBox["year", "TI"], ",", 
     StyleBox["month", "TI"], ",", 
     StyleBox["day", "TI"], "}", ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give the date ",
     StyleBox["n", "TI"],
     " days after the given date"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->4116],

Cell["Calendar computations using the standard calendar. ", "Caption",
 CellID->10322],

Cell["This loads the package. ", "MathCaption",
 CellID->8822],

Cell[BoxData[
 RowBox[{"<<", "Calendar`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32102],

Cell["The basic calendar utility is finding the day of the week. ", \
"MathCaption",
 CellID->6831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayOfWeek", "[", 
  RowBox[{"{", 
   RowBox[{"1988", ",", "6", ",", "23"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23031],

Cell[BoxData["Thursday"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->471200096]
}, Open  ]],

Cell["\<\
This computes the number of days between the given dates. The year 1900 was \
not a leap year. \
\>", "MathCaption",
 CellID->4915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1900", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1901", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27559],

Cell[BoxData["365"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1457647]
}, Open  ]],

Cell[TextData[{
 "January 2, 1901 is ",
 Cell[BoxData[
  FormBox["366", TraditionalForm]], "InlineFormula"],
 " days after January 1, 1900. "
}], "MathCaption",
 CellID->19881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysPlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1900", ",", "1", ",", "1"}], "}"}], ",", "366"}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->27132],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1901", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->397010146]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    StyleBox[
     RowBox[{
      ButtonBox["DayOfWeek",
       BaseStyle->"Link",
       ButtonData->"paclet:Calendar/ref/DayOfWeek"], "[", "{", 
      StyleBox["year", "TI"], ",", 
      StyleBox["month", "TI"], ",", 
      StyleBox["day", "TI"], "}", ",", 
      ButtonBox["Calendar",
       BaseStyle->"Link",
       ButtonData->"paclet:Calendar/ref/Calendar"], 
      StyleBox["->", "MR"], 
      StyleBox["cal", "TI"], "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the day of the week on which the given date occurred using the \
calendar system ",
     StyleBox["cal", "TI"]
    }], "TableText"]},
   {
    StyleBox[
     RowBox[{
      ButtonBox["DaysBetween",
       BaseStyle->"Link",
       ButtonData->"paclet:Calendar/ref/DaysBetween"], "[", "{", 
      SubscriptBox[
       StyleBox["year", "TI"], "1"], ",", 
      SubscriptBox[
       StyleBox["month", "TI"], "1"], ",", 
      SubscriptBox[
       StyleBox["day", "TI"], "1"], "}", ",", "{", 
      SubscriptBox[
       StyleBox["year", "TI"], "2"], ",", 
      SubscriptBox[
       StyleBox["month", "TI"], "2"], ",", 
      SubscriptBox[
       StyleBox["day", "TI"], "2"], "}", ",", 
      ButtonBox["Calendar",
       BaseStyle->"Link",
       ButtonData->"paclet:Calendar/ref/Calendar"], "->", 
      StyleBox["cal", "TI"], "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the number of days between the given dates using the calendar \
system ",
     StyleBox["cal", "TI"]
    }], "TableText"]},
   {
    StyleBox[
     RowBox[{
      ButtonBox["DaysPlus",
       BaseStyle->"Link",
       ButtonData->"paclet:Calendar/ref/DaysPlus"], "[", "{", 
      StyleBox["year", "TI"], ",", 
      StyleBox["month", "TI"], ",", 
      StyleBox["day", "TI"], "}", ",", 
      StyleBox["n", "TI"], ",", 
      ButtonBox["Calendar",
       BaseStyle->"Link",
       ButtonData->"paclet:Calendar/ref/Calendar"], "->", 
      StyleBox["cal", "TI"], "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the date ",
     StyleBox["n", "TI"],
     " days after the given date using the calendar system ",
     StyleBox["cal", "TI"]
    }], "TableText"]},
   {
    StyleBox[
     RowBox[{
      ButtonBox["CalendarChange",
       BaseStyle->"Link",
       ButtonData->"paclet:Calendar/ref/CalendarChange"], "[", "{", 
      StyleBox["year", "TI"], ",", 
      StyleBox["month", "TI"], ",", 
      StyleBox["day", "TI"], "}", ",", " ", 
      SubscriptBox[
       StyleBox["cal", "TI"], "1"], ",", 
      SubscriptBox[
       StyleBox["cal", "TI"], "2"], "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "convert the date given in ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["cal", "TI"], "1"]], "InlineFormula"],
     " into a date given in ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["cal", "TI"], "2"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, True, {False}, False},
    "RowsIndexed" -> {}}},
 CellID->19495],

Cell["Calendar computations using specified systems. ", "Caption",
 CellID->6197],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 " calendar has been in use in the Western world since 1582 by Roman Catholic \
countries, and since 1752 by English\[Hyphen]speaking countries. The ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 " calendar counts leap years every year divisible by 4, except for centuries \
not divisible by ",
 Cell[BoxData[
  FormBox["400", TraditionalForm]], "InlineFormula"],
 ", which are not leap years. "
}], "Text",
 CellID->20779],

Cell[TextData[{
 "The calendar used before the ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 " calendar was the ",
 Cell[BoxData[
  ButtonBox["Julian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Julian"]], "InlineFormula"],
 " calendar. This system counts ",
 StyleBox["every",
  FontSlant->"Italic"],
 " year divisible by 4 as a leap year. At present there is a disparity of 13 \
days between the calendars. The changeover between these two calendars was \
done by omitting a number of days, therefore one must account for this in \
computations. "
}], "Text",
 CellID->30231],

Cell[TextData[{
 "The default calendar used in this package is the one used by England and \
her former colonies (e.g., the United\[NonBreakingSpace]States). It uses the \
",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 " calendar for dates starting with September\[NonBreakingSpace]14, 1752, and \
the ",
 Cell[BoxData[
  ButtonBox["Julian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Julian"]], "InlineFormula"],
 " calendar for dates up to September\[NonBreakingSpace]2, 1752. If you do \
not specify a system, this is the calendar used by ",
 Cell[BoxData[
  ButtonBox["DayOfWeek",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/DayOfWeek"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["DaysBetween",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/DaysBetween"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["DaysPlus",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/DaysPlus"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->25172],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Julian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Julian"]], "InlineFormula"],
 " calendar is valid to March\[NonBreakingSpace]1, year 4, but not before \
then since the year 4 was ",
 StyleBox["not",
  FontSlant->"Italic"],
 " a leap year. "
}], "Text",
 CellID->27982],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Islamic",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Islamic"]], "InlineFormula"],
 " calendar is used mainly to keep track of Islamic holy days. It is a purely \
lunar calendar and a year has either 354 or 355 days. The months do not \
correspond to the solar year and migrate over the solar year following a 30\
\[Hyphen]year cycle. The ",
 Cell[BoxData[
  ButtonBox["Islamic",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Islamic"]], "InlineFormula"],
 " calendar began on the Hejira, which was July\[NonBreakingSpace]16, 622, in \
the ",
 Cell[BoxData[
  ButtonBox["Julian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Julian"]], "InlineFormula"],
 " calendar. "
}], "Text",
 CellID->31556],

Cell[TextData[{
 "In the ",
 Cell[BoxData[
  ButtonBox["Julian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Julian"]], "InlineFormula"],
 " calendar, the year beginning a century not divisible by 400 is a leap \
year. "
}], "MathCaption",
 CellID->10982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DaysBetween", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1900", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1901", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"Calendar", "\[Rule]", "Julian"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->7393],

Cell[BoxData["366"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->86892847]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 " calendar is 13 days ahead of the ",
 Cell[BoxData[
  ButtonBox["Julian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Julian"]], "InlineFormula"],
 " calendar. "
}], "MathCaption",
 CellID->22655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1992", ",", "2", ",", "29"}], "}"}], ",", "Gregorian", ",", 
   "Julian"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2728],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1992", ",", "2", ",", "16"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->305611856]
}, Open  ]],

Cell[TextData[{
 "Here is a conversion into the ",
 Cell[BoxData[
  ButtonBox["Islamic",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Islamic"]], "InlineFormula"],
 " system. "
}], "MathCaption",
 CellID->18362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1992", ",", "2", ",", "29"}], "}"}], ",", "Gregorian", ",", 
   "Islamic"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1207],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1412", ",", "8", ",", "25"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->44351051]
}, Open  ]],

Cell[TextData[{
 "This gives the first day in the ",
 Cell[BoxData[
  ButtonBox["Islamic",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Islamic"]], "InlineFormula"],
 " system, the date of the Hejira. The date is given in the ",
 Cell[BoxData[
  ButtonBox["Julian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Julian"]], "InlineFormula"],
 " calendar because the ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 " calendar was not used before 1582. "
}], "MathCaption",
 CellID->28774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalendarChange", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", "Islamic", ",", "Julian"}],
   "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->371],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"622", ",", "7", ",", "16"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->644753566]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["EasterSunday",
      BaseStyle->"Link",
      ButtonData->"paclet:Calendar/ref/EasterSunday"], "[", 
     StyleBox["year", "TI"], "]"}], Cell[TextData[{
     "give the date of Easter Sunday in the ",
     StyleBox[ButtonBox["Gregorian",
      BaseStyle->"Link",
      ButtonData->"paclet:Calendar/ref/Gregorian"], "InlineCode"],
     " system"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EasterSundayGreekOrthodox",
      BaseStyle->"Link",
      ButtonData->"paclet:Calendar/ref/EasterSundayGreekOrthodox"], "[", 
     StyleBox["year", "TI"], "]"}], Cell[TextData[{
     "give the date of Easter Sunday according to the Greek Orthodox Church \
using the ",
     StyleBox[ButtonBox["Gregorian",
      BaseStyle->"Link",
      ButtonData->"paclet:Calendar/ref/Gregorian"], "InlineCode"],
     " system"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["JewishNewYear",
      BaseStyle->"Link",
      ButtonData->"paclet:Calendar/ref/JewishNewYear"], "[", 
     StyleBox["year", "TI"], "]"}], Cell[TextData[{
     "give the date of the Jewish New Year occurring in ",
     StyleBox[ButtonBox["Gregorian",
      BaseStyle->"Link",
      ButtonData->"paclet:Calendar/ref/Gregorian"], "InlineCode"],
     " years between 1900 and 2099"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->13279],

Cell["Dates of holidays. ", "Caption",
 CellID->6809],

Cell["In 1945, Easter Sunday was on April 1. ", "MathCaption",
 CellID->27819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EasterSunday", "[", "1945", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->3490],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1945", ",", "4", ",", "1"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->556004050]
}, Open  ]],

Cell[TextData[{
 "This uses the pre\[Hyphen]",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 " computation, but the result is given as a ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 " date. "
}], "MathCaption",
 CellID->23916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EasterSundayGreekOrthodox", "[", "1984", "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1274],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1984", ",", "4", ",", "22"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->745156130]
}, Open  ]],

Cell[TextData[{
 "This gives the date of the Jewish New Year in the ",
 Cell[BoxData[
  ButtonBox["Gregorian",
   BaseStyle->"Link",
   ButtonData->"paclet:Calendar/ref/Gregorian"]], "InlineFormula"],
 " year 1997. "
}], "MathCaption",
 CellID->23047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JewishNewYear", "[", "1997", "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->29508],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1997", ",", "10", ",", "2"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->61073599]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Calendar Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 46.9116956}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Calendar Package Tutorial",
     "language" -> "en", "paclet" -> "Calendar Package", "status" -> "None", 
    "summary" -> 
    "This package provides a unified treatment of the basic calendar \
operations. The main idea is to treat the calendar as a generalized number \
system, so that days, weeks, months, and years are thought of as generalizing \
the digits of a number in a given base. Calendar computations using the \
standard calendar. This loads the package. ", "synonyms" -> {}, "title" -> 
    "Calendar Package", "type" -> "Tutorial", "uri" -> 
    "Calendar/tutorial/Calendar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1635, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2260, 62, 49, 1, 70, "Title",
 CellID->17659],
Cell[2312, 65, 302, 6, 70, "Text",
 CellID->12504],
Cell[2617, 73, 1514, 47, 70, "DefinitionBox",
 CellID->4116],
Cell[4134, 122, 86, 1, 70, "Caption",
 CellID->10322],
Cell[4223, 125, 62, 1, 70, "MathCaption",
 CellID->8822],
Cell[4288, 128, 92, 3, 70, "Input",
 CellID->32102],
Cell[4383, 133, 99, 2, 70, "MathCaption",
 CellID->6831],
Cell[CellGroupData[{
Cell[4507, 139, 162, 5, 28, "Input",
 CellID->23031],
Cell[4672, 146, 165, 5, 36, "Output",
 CellID->471200096]
}, Open  ]],
Cell[4852, 154, 141, 4, 70, "MathCaption",
 CellID->4915],
Cell[CellGroupData[{
Cell[5018, 162, 250, 8, 70, "Input",
 CellID->27559],
Cell[5271, 172, 158, 5, 36, "Output",
 CellID->1457647]
}, Open  ]],
Cell[5444, 180, 176, 6, 70, "MathCaption",
 CellID->19881],
Cell[CellGroupData[{
Cell[5645, 190, 189, 7, 70, "Input",
 CellID->27132],
Cell[5837, 199, 216, 7, 36, "Output",
 CellID->397010146]
}, Open  ]],
Cell[6068, 209, 3399, 104, 70, "DefinitionBox",
 CellID->19495],
Cell[9470, 315, 81, 1, 70, "Caption",
 CellID->6197],
Cell[9554, 318, 665, 18, 70, "Text",
 CellID->20779],
Cell[10222, 338, 680, 19, 70, "Text",
 CellID->30231],
Cell[10905, 359, 1090, 32, 70, "Text",
 CellID->25172],
Cell[11998, 393, 340, 12, 70, "Text",
 CellID->27982],
Cell[12341, 407, 789, 22, 70, "Text",
 CellID->31556],
Cell[13133, 431, 269, 9, 70, "MathCaption",
 CellID->10982],
Cell[CellGroupData[{
Cell[13427, 444, 301, 9, 70, "Input",
 CellID->7393],
Cell[13731, 455, 159, 5, 36, "Output",
 CellID->86892847]
}, Open  ]],
Cell[13905, 463, 367, 13, 70, "MathCaption",
 CellID->22655],
Cell[CellGroupData[{
Cell[14297, 480, 218, 7, 70, "Input",
 CellID->2728],
Cell[14518, 489, 217, 7, 36, "Output",
 CellID->305611856]
}, Open  ]],
Cell[14750, 499, 224, 8, 70, "MathCaption",
 CellID->18362],
Cell[CellGroupData[{
Cell[14999, 511, 219, 7, 70, "Input",
 CellID->1207],
Cell[15221, 520, 216, 7, 36, "Output",
 CellID->44351051]
}, Open  ]],
Cell[15452, 530, 597, 18, 70, "MathCaption",
 CellID->28774],
Cell[CellGroupData[{
Cell[16074, 552, 210, 7, 70, "Input",
 CellID->371],
Cell[16287, 561, 216, 7, 36, "Output",
 CellID->644753566]
}, Open  ]],
Cell[16518, 571, 1369, 39, 70, "DefinitionBox",
 CellID->13279],
Cell[17890, 612, 53, 1, 70, "Caption",
 CellID->6809],
Cell[17946, 615, 78, 1, 70, "MathCaption",
 CellID->27819],
Cell[CellGroupData[{
Cell[18049, 620, 106, 3, 70, "Input",
 CellID->3490],
Cell[18158, 625, 216, 7, 36, "Output",
 CellID->556004050]
}, Open  ]],
Cell[18389, 635, 400, 13, 70, "MathCaption",
 CellID->23916],
Cell[CellGroupData[{
Cell[18814, 652, 120, 3, 70, "Input",
 CellID->1274],
Cell[18937, 657, 218, 7, 36, "Output",
 CellID->745156130]
}, Open  ]],
Cell[19170, 667, 251, 8, 70, "MathCaption",
 CellID->23047],
Cell[CellGroupData[{
Cell[19446, 679, 109, 3, 70, "Input",
 CellID->29508],
Cell[19558, 684, 217, 7, 36, "Output",
 CellID->61073599]
}, Open  ]]
}, Open  ]],
Cell[19802, 695, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

