(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20086,        674]
NotebookOptionsPosition[     15657,        550]
NotebookOutlinePosition[     17434,        589]
CellTagsIndexPosition[     17391,        586]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " Package"
}], "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Subsets and Permutations \[RightGuillemet]",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/SubsetsAndPermutations"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->291519260],

Cell[TextData[{
 Cell[TextData[ButtonBox["Permutations",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Permutations"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "get a list of permutations"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinarySubsets",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/BinarySubsets"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "enumerate subsets using binary representation "
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["InversePermutation",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/InversePermutation"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KSubsets",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/KSubsets"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomSubset"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ToCycles",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ToCycles"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CycleIndex",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CycleIndex"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/SubsetsAndPermutations"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->223432585]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Partitions and Compositions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->789053025],

Cell[TextData[{
 Cell[TextData[ButtonBox["Partitions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Partitions"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list partitions of a positive integer"
}], "GuideText",
 CellID->179146833],

Cell[TextData[{
 Cell[TextData[ButtonBox["Compositions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Compositions"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list all compositions of integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " into ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " parts"
}], "GuideText",
 CellID->537382875],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tableaux",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Tableaux"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct Young tableaux from integer partition"
}], "GuideText",
 CellID->902031408],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomPartition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomPartition"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FerrersDiagram",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FerrersDiagram"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KSetPartitions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/KSetPartitions"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TableauClasses",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TableauClasses"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/PartitionsAndCompositions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->3895184]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox[ButtonBox["Graph Construction and Representations",
  BaseStyle->"Link",
  ButtonData->
   "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"], 
  "GuideFunctionsSubsection"],
 StyleBox[ButtonBox[" \[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->
   "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"], 
  "GuideFunctionsSubsection"]
}], "GuideFunctionsSubsection",
 CellID->74479324],

Cell[TextData[{
 Cell[TextData[ButtonBox["Graph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Graph"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Edges",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Edges"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Vertices",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Vertices"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "basic graph elements"
}], "GuideText",
 CellID->39359584],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShowGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ShowGraph"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display a graph"
}], "GuideText",
 CellID->575371407],

Cell[TextData[{
 Cell[TextData[ButtonBox["MakeGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MakeGraph"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a graph"
}], "GuideText",
 CellID->278421529],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphJoin",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphJoin"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "join two graphs"
}], "GuideText",
 CellID->541595220],

Cell[TextData[{
 Cell[TextData[ButtonBox["FromOrderedPairs",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FromOrderedPairs"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IncidenceMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/IncidenceMatrix"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphOptions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphOptions"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RadialEmbedding",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RadialEmbedding"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->384380006],

Cell[TextData[{
 Cell[TextData[ButtonBox["EdgeStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EdgeStyle"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VertexStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/VertexStyle"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Highlight",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Highlight"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->
   "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->88600997]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Graph Properties \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphProperties"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->137069814],

Cell[TextData[{
 Cell[TextData[ButtonBox["DegreeSequence",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DegreeSequence"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list number of edges for each vertex"
}], "GuideText",
 CellID->146852818],

Cell[TextData[{
 Cell[TextData[ButtonBox["OrientGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/OrientGraph"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find strongly connected orientation of a graph"
}], "GuideText",
 CellID->765960676],

Cell[TextData[{
 Cell[TextData[ButtonBox["ChromaticPolynomial",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ChromaticPolynomial"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "compute chromatic polynomial for a graph"
}], "GuideText",
 CellID->268516296],

Cell[TextData[{
 Cell[TextData[ButtonBox["NecklacePolynomial",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NecklacePolynomial"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HamiltonianCycle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/HamiltonianCycle"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ConnectedComponents",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ConnectedComponents"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EdgeColoring",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EdgeColoring"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->483332925],

Cell[TextData[{
 Cell[TextData[ButtonBox["EdgeConnectivity",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EdgeConnectivity"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Girth",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Girth"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Bridges",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Bridges"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/GraphProperties"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->198367767]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Graph Algorithms \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphAlgorithms"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->181899765],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dijkstra",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Dijkstra"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find single-source shortest path"
}], "GuideText",
 CellID->266349823],

Cell[TextData[{
 Cell[TextData[ButtonBox["MinimumSpanningTree",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MinimumSpanningTree"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a minimum spanning tree of a graph"
}], "GuideText",
 CellID->183029240],

Cell[TextData[{
 Cell[TextData[ButtonBox["NetworkFlow",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NetworkFlow"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "maximum flow through a graph"
}], "GuideText",
 CellID->947340222],

Cell[TextData[{
 Cell[TextData[ButtonBox["Isomorphism",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Isomorphism"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Equivalences",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Equivalences"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ShortestPath",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ShortestPath"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->235460859],

Cell[TextData[{
 Cell[TextData[ButtonBox["StableMarriage",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/StableMarriage"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DepthFirstTraversal",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DepthFirstTraversal"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TransitiveClosure",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TransitiveClosure"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->68744025]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"]], "GuideTutorial",\

 CellID->14586202]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "GuideMoreAbout",
 CellID->311584766],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "GuideMoreAbout",
 CellID->1240030776]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Combinatorica Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 47.3335814}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Guide", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Permutations -- get a list of permutations, BinarySubsets -- enumerate \
subsets using binary representation , Partitions -- list partitions of a \
positive integer, Compositions -- list all compositions of integer n into k \
parts, Tableaux -- construct Young tableaux from integer partition, Graph, \
Edges, Vertices -- basic graph elements, ShowGraph -- display a graph, \
MakeGraph -- construct a graph, GraphJoin -- join two graphs, DegreeSequence \
-- list number of edges for each vertex, OrientGraph -- find strongly \
connected orientation of a graph, ChromaticPolynomial -- compute chromatic \
polynomial for a graph, Dijkstra -- find single-source shortest path, \
MinimumSpanningTree -- find a minimum spanning tree of a graph, NetworkFlow \
-- maximum flow through a graph", "synonyms" -> {}, "title" -> 
    "Combinatorica Package", "type" -> "Guide", "uri" -> 
    "Combinatorica/guide/CombinatoricaPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 116, 5, 70, "GuideTitle",
 CellID->942062912],
Cell[738, 32, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[819, 37, 250, 6, 70, "GuideFunctionsSubsection",
 CellID->291519260],
Cell[1072, 45, 263, 9, 70, "GuideText",
 CellID->203374175],
Cell[1338, 56, 303, 10, 70, "GuideText",
 CellID->1463276848],
Cell[1644, 68, 1364, 38, 70, "InlineGuideFunctionListing",
 CellID->223432585]
}, Open  ]],
Cell[CellGroupData[{
Cell[3045, 111, 256, 6, 70, "GuideFunctionsSubsection",
 CellID->789053025],
Cell[3304, 119, 284, 9, 70, "GuideText",
 CellID->179146833],
Cell[3591, 130, 432, 15, 70, "GuideText",
 CellID->537382875],
Cell[4026, 147, 290, 9, 70, "GuideText",
 CellID->902031408],
Cell[4319, 158, 1167, 34, 70, "InlineGuideFunctionListing",
 CellID->3895184]
}, Open  ]],
Cell[CellGroupData[{
Cell[5523, 197, 445, 12, 70, "GuideFunctionsSubsection",
 CellID->74479324],
Cell[5971, 211, 532, 17, 70, "GuideText",
 CellID->39359584],
Cell[6506, 230, 260, 9, 70, "GuideText",
 CellID->575371407],
Cell[6769, 241, 262, 9, 70, "GuideText",
 CellID->278421529],
Cell[7034, 252, 260, 9, 70, "GuideText",
 CellID->541595220],
Cell[7297, 263, 932, 27, 70, "InlineGuideFunctionListing",
 CellID->384380006],
Cell[8232, 292, 911, 26, 70, "InlineGuideFunctionListing",
 CellID->88600997]
}, Open  ]],
Cell[CellGroupData[{
Cell[9180, 323, 233, 5, 70, "GuideFunctionsSubsection",
 CellID->137069814],
Cell[9416, 330, 294, 10, 70, "GuideText",
 CellID->146852818],
Cell[9713, 342, 298, 10, 70, "GuideText",
 CellID->765960676],
Cell[10014, 354, 308, 10, 70, "GuideText",
 CellID->268516296],
Cell[10325, 366, 946, 27, 70, "InlineGuideFunctionListing",
 CellID->483332925],
Cell[11274, 395, 886, 25, 70, "InlineGuideFunctionListing",
 CellID->198367767]
}, Open  ]],
Cell[CellGroupData[{
Cell[12197, 425, 233, 5, 70, "GuideFunctionsSubsection",
 CellID->181899765],
Cell[12433, 432, 275, 9, 70, "GuideText",
 CellID->266349823],
Cell[12711, 443, 307, 10, 70, "GuideText",
 CellID->183029240],
Cell[13021, 455, 280, 10, 70, "GuideText",
 CellID->947340222],
Cell[13304, 467, 677, 20, 70, "InlineGuideFunctionListing",
 CellID->235460859],
Cell[13984, 489, 935, 27, 70, "InlineGuideFunctionListing",
 CellID->68744025]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14968, 522, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[15033, 525, 160, 4, 70, "GuideTutorial",
 CellID->14586202]
}, Open  ]],
Cell[CellGroupData[{
Cell[15230, 534, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[15295, 537, 160, 3, 70, "GuideMoreAbout",
 CellID->311584766],
Cell[15458, 542, 157, 3, 70, "GuideMoreAbout",
 CellID->1240030776]
}, Open  ]],
Cell[15630, 548, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

