(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24578,        826]
NotebookOptionsPosition[     18696,        668]
NotebookOutlinePosition[     20813,        711]
CellTagsIndexPosition[     20770,        708]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Constructing Graphs", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["MakeGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MakeGraph"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a graph using a binary predicate"
}], "GuideText",
 CellID->469508323],

Cell[TextData[{
 Cell[TextData[ButtonBox["FunctionalGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FunctionalGraph"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a graph with edges defined by functional relations"
}], "GuideText",
 CellID->305375185],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntervalGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/IntervalGraph"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a graph defined by the list of intervals"
}], "GuideText",
 CellID->428446500],

Cell[TextData[{
 Cell[TextData[ButtonBox["LineGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/LineGraph"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NonLineGraphs",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NonLineGraphs"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Path",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Path"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->178414867],

Cell[TextData[{
 Cell[TextData[ButtonBox["SmallestCyclicGroupGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SmallestCyclicGroupGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ResidualFlowGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ResidualFlowGraph"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->569631593],

Cell["\t", "GuideDelimiterSubsection",
 CellID->148834550],

Cell[CellGroupData[{

Cell["Graph Modifications", "GuideFunctionsSubsection",
 CellID->219193252],

Cell[TextData[{
 Cell[TextData[ButtonBox["AddEdge",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/AddEdge"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["AddEdges",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/AddEdges"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "add edges to a graph"
}], "GuideText",
 CellID->138880028],

Cell[TextData[{
 Cell[TextData[ButtonBox["DeleteEdge",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DeleteEdge"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["DeleteEdges",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DeleteEdges"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "remove edges from a graph"
}], "GuideText",
 CellID->283802616],

Cell[TextData[{
 Cell[TextData[ButtonBox["RemoveSelfLoops",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RemoveSelfLoops"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "delete self-loops in a graph"
}], "GuideText",
 CellID->70084476],

Cell[TextData[{
 Cell[TextData[ButtonBox["RemoveMultipleEdges",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RemoveMultipleEdges"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "delete multiple edges"
}], "GuideText",
 CellID->184839617],

Cell[TextData[{
 Cell[TextData[ButtonBox["MakeSimple",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MakeSimple"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "simplify the graph"
}], "GuideText",
 CellID->8183228],

Cell[TextData[{
 Cell[TextData[ButtonBox["MakeDirected",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MakeDirected"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MakeUndirected",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MakeUndirected"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NormalizeVertices",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NormalizeVertices"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->378380565],

Cell[TextData[{
 Cell[TextData[ButtonBox["AddVertex",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/AddVertex"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AddVertices",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/AddVertices"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DeleteVertex",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DeleteVertex"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DeleteVertices",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DeleteVertices"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->361397138],

Cell[TextData[{
 Cell[TextData[ButtonBox["ChangeVertices",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ChangeVertices"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChangeEdges",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ChangeEdges"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReverseEdges",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ReverseEdges"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DeleteCycle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DeleteCycle"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->194388712],

Cell["\t", "GuideDelimiter",
 CellID->105296249],

Cell[TextData[{
 Cell[TextData[ButtonBox["Contract",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Contract"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "merge vertices into one"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["InduceSubgraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/InduceSubgraph"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " make graph with a subset of edges and vertices"
}], "GuideText",
 CellID->305186852],

Cell[TextData[{
 Cell[TextData[ButtonBox["PermuteSubgraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PermuteSubgraph"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "permute selected vertices"
}], "GuideText",
 CellID->353014308],

Cell[TextData[{
 Cell[TextData[ButtonBox["VertexCover",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/VertexCover"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "vertex cover of the graph"
}], "GuideText",
 CellID->105043964],

Cell[TextData[{
 Cell[TextData[ButtonBox["MaximumClique",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MaximumClique"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MinimumVertexCover",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MinimumVertexCover"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VertexCoverQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/VertexCoverQ"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->94758937],

Cell[TextData[{
 Cell[TextData[ButtonBox["GreedyVertexCover",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GreedyVertexCover"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ApproximateVertexCover",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ApproximateVertexCover"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MaximalMatching",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MaximalMatching"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->21068002],

Cell[TextData[{
 Cell[TextData[ButtonBox["IndependentSetQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/IndependentSetQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MaximumIndependentSet",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MaximumIndependentSet"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->256804001],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegularGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RegularGraph"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "create a regular graph"
}], "GuideText",
 CellID->339896158],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegularQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RegularQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DegreeSequence",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DegreeSequence"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RealizeDegreeSequence",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RealizeDegreeSequence"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->453014577],

Cell["\t", "GuideDelimiter",
 CellID->143898627],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphUnion",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphUnion"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "merge graphs together"
}], "GuideText",
 CellID->589829389],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphIntersection",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphIntersection"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a common subgraph"
}], "GuideText",
 CellID->371598583],

Cell[TextData[{
 Cell[TextData[ButtonBox["TransitiveClosure",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TransitiveClosure"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find the transitive closure of a graph"
}], "GuideText",
 CellID->58997281],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphComplement",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphComplement"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphDifference",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphDifference"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->186998428],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphSum",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphSum"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphJoin",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphJoin"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphProduct",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphProduct"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CartesianProduct",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CartesianProduct"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]],

Cell[CellGroupData[{

Cell["Random Graphs", "GuideFunctionsSubsection",
 CellID->526955153],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomGraph"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "generate a random graph"
}], "GuideText",
 CellID->102864953],

Cell[TextData[{
 Cell[TextData[ButtonBox["NthPair",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NthPair"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "get a pair of vertices from enumeration"
}], "GuideText",
 CellID->267352250],

Cell[TextData[{
 Cell[TextData[ButtonBox["DegreeSequence",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DegreeSequence"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list number of edges for each vertex"
}], "GuideText",
 CellID->24741262],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExactRandomGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ExactRandomGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphicQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphicQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RealizeDegreeSequence",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RealizeDegreeSequence"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomVertices",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomVertices"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->50099366]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trees", "GuideFunctionsSubsection",
 CellID->288004470],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomTree",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomTree"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "generate a random tree"
}], "GuideText",
 CellID->371094643],

Cell[TextData[{
 Cell[TextData[ButtonBox["LabeledTreeToCode",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/LabeledTreeToCode"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert tree to Pr\[UDoubleDot]fer code"
}], "GuideText",
 CellID->353394429],

Cell[TextData[{
 Cell[TextData[ButtonBox["CompleteBinaryTree",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CompleteBinaryTree"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "tree with two branches for each node"
}], "GuideText",
 CellID->403630609],

Cell[TextData[{
 Cell[TextData[ButtonBox["CodeToLabeledTree",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CodeToLabeledTree"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CompleteKaryTree",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CompleteKaryTree"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TreeIsomorphismQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TreeIsomorphismQ"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->224019986],

Cell[TextData[{
 Cell[TextData[ButtonBox["TreeToCertificate",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TreeToCertificate"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TreeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TreeQ"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->154521669]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"]], "GuideTutorial",\

 CellID->14586202]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Graph Construction and Representation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "GuideMoreAbout",\

 CellID->872882804],

Cell[TextData[ButtonBox["Cycles and Connectivity",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/CyclesAndConnectivity"]], "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Constructing Graphs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 47.6460894}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Guide", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "MakeGraph -- construct a graph using a binary predicate, FunctionalGraph \
-- construct a graph with edges defined by functional relations, \
IntervalGraph -- construct a graph defined by the list of intervals, AddEdge, \
AddEdges -- add edges to a graph, DeleteEdge, DeleteEdges -- remove edges \
from a graph, RemoveSelfLoops -- delete self-loops in a graph, \
RemoveMultipleEdges -- delete multiple edges, MakeSimple -- simplify the \
graph, Contract -- merge vertices into one, InduceSubgraph -- make graph with \
a subset of edges and vertices, PermuteSubgraph -- permute selected vertices, \
VertexCover -- vertex cover of the graph, RegularGraph -- create a regular \
graph, GraphUnion -- merge graphs together, GraphIntersection -- find a \
common subgraph, TransitiveClosure -- find the transitive closure of a graph, \
RandomGraph -- generate a random graph, NthPair -- get a pair of vertices \
from enumeration, DegreeSequence -- list number of edges for each vertex, \
RandomTree -- generate a random tree, LabeledTreeToCode -- convert tree to \
Pru\"fer code, CompleteBinaryTree -- tree with two branches for each node", 
    "synonyms" -> {}, "title" -> "Constructing Graphs", "type" -> "Guide", 
    "uri" -> "Combinatorica/guide/ConstructingGraphs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 61, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[683, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[742, 31, 287, 9, 70, "GuideText",
 CellID->469508323],
Cell[1032, 42, 320, 10, 70, "GuideText",
 CellID->305375185],
Cell[1355, 54, 306, 10, 70, "GuideText",
 CellID->428446500],
Cell[1664, 66, 653, 18, 70, "InlineGuideFunctionListing",
 CellID->178414867],
Cell[2320, 86, 480, 13, 70, "InlineGuideFunctionListing",
 CellID->569631593],
Cell[2803, 101, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->148834550],
Cell[CellGroupData[{
Cell[2886, 106, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->219193252],
Cell[2964, 109, 402, 13, 70, "GuideText",
 CellID->138880028],
Cell[3369, 124, 422, 14, 70, "GuideText",
 CellID->283802616],
Cell[3794, 140, 287, 10, 70, "GuideText",
 CellID->70084476],
Cell[4084, 152, 289, 10, 70, "GuideText",
 CellID->184839617],
Cell[4376, 164, 263, 9, 70, "GuideText",
 CellID->8183228],
Cell[4642, 175, 693, 20, 70, "InlineGuideFunctionListing",
 CellID->378380565],
Cell[5338, 197, 905, 26, 70, "InlineGuideFunctionListing",
 CellID->361397138],
Cell[6246, 225, 909, 26, 70, "InlineGuideFunctionListing",
 CellID->194388712],
Cell[7158, 253, 48, 1, 70, "GuideDelimiter",
 CellID->105296249],
Cell[7209, 256, 266, 9, 70, "GuideText",
 CellID->203374175],
Cell[7478, 267, 299, 9, 70, "GuideText",
 CellID->305186852],
Cell[7780, 278, 285, 10, 70, "GuideText",
 CellID->353014308],
Cell[8068, 290, 277, 10, 70, "GuideText",
 CellID->105043964],
Cell[8348, 302, 692, 20, 70, "InlineGuideFunctionListing",
 CellID->94758937],
Cell[9043, 324, 714, 20, 70, "InlineGuideFunctionListing",
 CellID->21068002],
Cell[9760, 346, 470, 13, 70, "InlineGuideFunctionListing",
 CellID->256804001],
Cell[10233, 361, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[10284, 364, 276, 10, 70, "GuideText",
 CellID->339896158],
Cell[10563, 376, 690, 19, 70, "InlineGuideFunctionListing",
 CellID->453014577],
Cell[11256, 397, 48, 1, 70, "GuideDelimiter",
 CellID->143898627],
Cell[11307, 400, 268, 9, 70, "GuideText",
 CellID->589829389],
Cell[11578, 411, 286, 10, 70, "GuideText",
 CellID->371598583],
Cell[11867, 423, 301, 10, 70, "GuideText",
 CellID->58997281],
Cell[12171, 435, 458, 13, 70, "InlineGuideFunctionListing",
 CellID->186998428],
Cell[12632, 450, 899, 25, 70, "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]],
Cell[CellGroupData[{
Cell[13568, 480, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->526955153],
Cell[13640, 483, 275, 10, 70, "GuideText",
 CellID->102864953],
Cell[13918, 495, 280, 9, 70, "GuideText",
 CellID->267352250],
Cell[14201, 506, 288, 9, 70, "GuideText",
 CellID->24741262],
Cell[14492, 517, 930, 26, 70, "InlineGuideFunctionListing",
 CellID->50099366]
}, Open  ]],
Cell[CellGroupData[{
Cell[15459, 548, 61, 1, 70, "GuideFunctionsSubsection",
 CellID->288004470],
Cell[15523, 551, 269, 9, 70, "GuideText",
 CellID->371094643],
Cell[15795, 562, 303, 10, 70, "GuideText",
 CellID->353394429],
Cell[16101, 574, 302, 10, 70, "GuideText",
 CellID->403630609],
Cell[16406, 586, 705, 20, 70, "InlineGuideFunctionListing",
 CellID->224019986],
Cell[17114, 608, 439, 12, 70, "InlineGuideFunctionListing",
 CellID->154521669]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17602, 626, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[17667, 629, 160, 4, 70, "GuideTutorial",
 CellID->14586202]
}, Open  ]],
Cell[CellGroupData[{
Cell[17864, 638, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[17929, 641, 209, 5, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[18141, 648, 159, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[18303, 653, 166, 4, 70, "GuideMoreAbout",
 CellID->872882804],
Cell[18472, 659, 182, 4, 70, "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],
Cell[18669, 666, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

