(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20870,        711]
NotebookOptionsPosition[     15623,        566]
NotebookOutlinePosition[     17682,        608]
CellTagsIndexPosition[     17639,        605]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Graph Construction and Representations", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Graphs and Components", "GuideFunctionsSubsection",
 CellID->526430661],

Cell[TextData[{
 Cell[TextData[ButtonBox["Graph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Graph"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a graph object"
}], "GuideText",
 CellID->17630603],

Cell[TextData[{
 Cell[TextData[ButtonBox["Edges",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Edges"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Vertices",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Vertices"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list of edges and vertices in a graph"
}], "GuideText",
 CellID->572414569],

Cell[TextData[{
 Cell[TextData[ButtonBox["M",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/M"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["V",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/V"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "number of edges and vertices in a graph"
}], "GuideText",
 CellID->3932096]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graph Representations", "GuideFunctionsSubsection",
 CellID->464121664],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToOrderedPairs",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ToOrderedPairs"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "get a list of edges"
}], "GuideText",
 CellID->105061959],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToAdjacencyLists",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ToAdjacencyLists"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "represent a graph as adjacency lists"
}], "GuideText",
 CellID->302972119],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToAdjacencyMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ToAdjacencyMatrix"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " represent a graph as an adjacency matrix"
}], "GuideText",
 CellID->602230492],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToUnorderedPairs",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ToUnorderedPairs"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FromOrderedPairs",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FromOrderedPairs"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FromUnorderedPairs",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FromUnorderedPairs"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->690040673],

Cell[TextData[{
 Cell[TextData[ButtonBox["FromAdjacencyLists",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FromAdjacencyLists"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FromAdjacencyMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FromAdjacencyMatrix"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IncidenceMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/IncidenceMatrix"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->149428972],

Cell["\t", "GuideDelimiter",
 CellID->51873473],

Cell[TextData[{
 Cell[TextData[ButtonBox["SymmetricQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SymmetricQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test if a square matrix represents a symmetric relation"
}], "GuideText",
 CellID->487685236],

Cell[TextData[{
 Cell[TextData[ButtonBox["EquivalenceRelationQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EquivalenceRelationQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test if a matrix defines an equivalence relation"
}], "GuideText",
 CellID->65110692],

Cell[TextData[{
 Cell[TextData[ButtonBox["AntiSymmetricQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/AntiSymmetricQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EquivalenceClasses",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EquivalenceClasses"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Equivalences",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Equivalences"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1595032]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Displaying Graphs \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/DisplayingGraphs"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->84552316],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShowGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ShowGraph"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display a graph"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShowGraphArray",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ShowGraphArray"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display several graphs"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphOptions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphOptions"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ShowLabeledGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ShowLabeledGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->623516182]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Constructing Graphs \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/ConstructingGraphs"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->219958842],

Cell[TextData[{
 Cell[TextData[ButtonBox["MakeGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MakeGraph"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a graph using a binary predicate"
}], "GuideText",
 CellID->448034119],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomGraph"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "generate a random graph"
}], "GuideText",
 CellID->45056803],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphUnion",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphUnion"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct the union of two graphs"
}], "GuideText",
 CellID->65927830],

Cell[TextData[{
 Cell[TextData[ButtonBox["LineGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/LineGraph"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AddEdges",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/AddEdges"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MakeUndirected",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MakeUndirected"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PermuteSubgraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PermuteSubgraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752],

Cell["\t", "GuideDelimiter",
 CellID->833880379],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetEdgeWeights",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SetEdgeWeights"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "assign weights to edges"
}], "GuideText",
 CellID->76870394],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetVertexWeights",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SetVertexWeights"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "assign weights to vertices"
}], "GuideText",
 CellID->512543232],

Cell[TextData[{
 Cell[TextData[ButtonBox["GetEdgeWeights",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GetEdgeWeights"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GetVertexWeights",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GetVertexWeights"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GetEdgeLabels",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GetEdgeLabels"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GetVertexLabels",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GetVertexLabels"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->31661845],

Cell[TextData[{
 Cell[TextData[ButtonBox["CostOfPath",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CostOfPath"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DilateVertices",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DilateVertices"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WeightingFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/WeightingFunction"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WeightRange",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/WeightRange"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->275094380]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graph Input and Output", "GuideFunctionsSubsection",
 CellID->411521915],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReadGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ReadGraph"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "read graph specification from a file"
}], "GuideText",
 CellID->41570802],

Cell[TextData[{
 Cell[TextData[ButtonBox["WriteGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/WriteGraph"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "write graph specification into a file"
}], "GuideText",
 CellID->363318255]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Built-in Graphs \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/BuiltinGraphs"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->129754929],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cycle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Cycle"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a circular chain of edges "
}], "GuideText",
 CellID->63440970],

Cell[TextData[{
 Cell[TextData[ButtonBox["GridGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GridGraph"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "graph with nodes on a grid"
}], "GuideText",
 CellID->467407019],

Cell[TextData[{
 Cell[TextData[ButtonBox["FiniteGraphs",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FiniteGraphs"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list of all built-in finite parameterless graphs"
}], "GuideText",
 CellID->165881469],

Cell[TextData[{
 Cell[TextData[ButtonBox["Wheel",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Wheel"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hypercube",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Hypercube"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Harary",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Harary"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->74725802]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"]], "GuideTutorial",\

 CellID->14586202]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "GuideMoreAbout",\

 CellID->1567025153],

Cell[TextData[ButtonBox["Cycles and Connectivity",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/CyclesAndConnectivity"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Graph Construction and Representations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 54.3806368}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Guide", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Graph -- a graph object, Edges, Vertices -- list of edges and vertices \
in a graph, M, V -- number of edges and vertices in a graph, ToOrderedPairs \
-- get a list of edges, ToAdjacencyLists -- represent a graph as adjacency \
lists, ToAdjacencyMatrix -- represent a graph as an adjacency matrix, \
SymmetricQ -- test if a square matrix represents a symmetric relation, \
EquivalenceRelationQ -- test if a matrix defines an equivalence relation, \
ShowGraph -- display a graph, ShowGraphArray -- display several graphs, \
MakeGraph -- construct a graph using a binary predicate, RandomGraph -- \
generate a random graph, GraphUnion -- construct the union of two graphs, \
SetEdgeWeights -- assign weights to edges, SetVertexWeights -- assign weights \
to vertices, ReadGraph -- read graph specification from a file, WriteGraph -- \
write graph specification into a file, Cycle -- a circular chain of edges , \
GridGraph -- graph with nodes on a grid, FiniteGraphs -- list of all built-in \
finite parameterless graphs", "synonyms" -> {}, "title" -> 
    "Graph Construction and Representations", "type" -> "Guide", "uri" -> 
    "Combinatorica/guide/GraphConstructionAndRepresentations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 80, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[702, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[783, 33, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->526430661],
Cell[863, 36, 250, 9, 70, "GuideText",
 CellID->17630603],
Cell[1116, 47, 415, 13, 70, "GuideText",
 CellID->572414569],
Cell[1534, 62, 393, 13, 70, "GuideText",
 CellID->3932096]
}, Open  ]],
Cell[CellGroupData[{
Cell[1964, 80, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->464121664],
Cell[2044, 83, 277, 10, 70, "GuideText",
 CellID->105061959],
Cell[2324, 95, 298, 10, 70, "GuideText",
 CellID->302972119],
Cell[2625, 107, 299, 9, 70, "GuideText",
 CellID->602230492],
Cell[2927, 118, 707, 20, 70, "InlineGuideFunctionListing",
 CellID->690040673],
Cell[3637, 140, 711, 20, 70, "InlineGuideFunctionListing",
 CellID->149428972],
Cell[4351, 162, 47, 1, 70, "GuideDelimiter",
 CellID->51873473],
Cell[4401, 165, 302, 9, 70, "GuideText",
 CellID->487685236],
Cell[4706, 176, 317, 10, 70, "GuideText",
 CellID->65110692],
Cell[5026, 188, 693, 20, 70, "InlineGuideFunctionListing",
 CellID->1595032]
}, Open  ]],
Cell[CellGroupData[{
Cell[5756, 213, 234, 5, 70, "GuideFunctionsSubsection",
 CellID->84552316],
Cell[5993, 220, 260, 9, 70, "GuideText",
 CellID->203374175],
Cell[6256, 231, 281, 10, 70, "GuideText",
 CellID->1463276848],
Cell[6540, 243, 684, 20, 70, "InlineGuideFunctionListing",
 CellID->623516182]
}, Open  ]],
Cell[CellGroupData[{
Cell[7261, 268, 239, 5, 70, "GuideFunctionsSubsection",
 CellID->219958842],
Cell[7503, 275, 287, 9, 70, "GuideText",
 CellID->448034119],
Cell[7793, 286, 274, 10, 70, "GuideText",
 CellID->45056803],
Cell[8070, 298, 279, 9, 70, "GuideText",
 CellID->65927830],
Cell[8352, 309, 1133, 32, 70, "InlineGuideFunctionListing",
 CellID->58033752],
Cell[9488, 343, 48, 1, 70, "GuideDelimiter",
 CellID->833880379],
Cell[9539, 346, 280, 10, 70, "GuideText",
 CellID->76870394],
Cell[9822, 358, 288, 10, 70, "GuideText",
 CellID->512543232],
Cell[10113, 370, 931, 27, 70, "InlineGuideFunctionListing",
 CellID->31661845],
Cell[11047, 399, 1149, 33, 70, "InlineGuideFunctionListing",
 CellID->275094380]
}, Open  ]],
Cell[CellGroupData[{
Cell[12233, 437, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->411521915],
Cell[12314, 440, 280, 9, 70, "GuideText",
 CellID->41570802],
Cell[12597, 451, 284, 9, 70, "GuideText",
 CellID->363318255]
}, Open  ]],
Cell[CellGroupData[{
Cell[12918, 465, 230, 5, 70, "GuideFunctionsSubsection",
 CellID->129754929],
Cell[13151, 472, 262, 9, 70, "GuideText",
 CellID->63440970],
Cell[13416, 483, 271, 9, 70, "GuideText",
 CellID->467407019],
Cell[13690, 494, 302, 10, 70, "GuideText",
 CellID->165881469],
Cell[13995, 506, 864, 24, 70, "InlineGuideFunctionListing",
 CellID->74725802]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14908, 536, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[14973, 539, 160, 4, 70, "GuideTutorial",
 CellID->14586202]
}, Open  ]],
Cell[CellGroupData[{
Cell[15170, 548, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[15235, 551, 165, 4, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[15403, 557, 178, 4, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[15596, 564, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

