(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18838,        635]
NotebookOptionsPosition[     14178,        507]
NotebookOutlinePosition[     16106,        548]
CellTagsIndexPosition[     16063,        545]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Graph Properties", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["Degrees",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Degrees"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list of degrees of vertices"
}], "GuideText",
 CellID->33115384],

Cell[TextData[{
 Cell[TextData[ButtonBox["InDegree",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/InDegree"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "number of incoming edges"
}], "GuideText",
 CellID->191055401],

Cell[TextData[{
 Cell[TextData[ButtonBox["DegreeSequence",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DegreeSequence"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list number of edges for each vertex"
}], "GuideText",
 CellID->327605976],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphicQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphicQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test if a list of integers is a graphic sequence"
}], "GuideText",
 CellID->593509437],

Cell[TextData[{
 Cell[TextData[ButtonBox["OutDegree",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/OutDegree"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RealizeDegreeSequence",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RealizeDegreeSequence"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Spectrum",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Spectrum"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->464642645],

Cell["\t", "GuideDelimiter",
 CellID->281862531],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListGraphs",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ListGraphs"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list of nonisomorphic undirected graphs"
}], "GuideText",
 CellID->267522762],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberOfGraphs",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NumberOfGraphs"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " number of nonisomorphic undirected graphs with ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " vertices"
}], "GuideText",
 CellID->10820995],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphPolynomial",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GraphPolynomial"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberOfDirectedGraphs",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NumberOfDirectedGraphs"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->24436004],

Cell["\t", "GuideDelimiter",
 CellID->367908456],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListNecklaces",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ListNecklaces"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list distinct necklaces"
}], "GuideText",
 CellID->223848219],

Cell[TextData[{
 Cell[TextData[ButtonBox["NecklacePolynomial",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NecklacePolynomial"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberOfNecklaces",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NumberOfNecklaces"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->60461689],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Cycles and Connectivity \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/CyclesAndConnectivity"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->171509423],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindCycle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FindCycle"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find cycle in a graph"
}], "GuideText",
 CellID->251891531],

Cell[TextData[{
 Cell[TextData[ButtonBox["HamiltonianCycle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/HamiltonianCycle"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a Hamiltonian cycle"
}], "GuideText",
 CellID->12923998],

Cell[TextData[{
 Cell[TextData[ButtonBox["ConnectedComponents",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ConnectedComponents"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "get lists of connected components"
}], "GuideText",
 CellID->325113906],

Cell[TextData[{
 Cell[TextData[ButtonBox["OrientGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/OrientGraph"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Bridges",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Bridges"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExtractCycles",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ExtractCycles"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TravelingSalesman",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TravelingSalesman"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/CyclesAndConnectivity"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->60706471]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graph Coloring", "GuideFunctionsSubsection",
 CellID->198465327],

Cell[TextData[{
 Cell[TextData[ButtonBox["TwoColoring",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TwoColoring"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "color vertices of a bipartite graph"
}], "GuideText",
 CellID->90488593],

Cell[TextData[{
 Cell[TextData[ButtonBox["ChromaticPolynomial",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ChromaticPolynomial"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "compute chromatic polynomial for a graph"
}], "GuideText",
 CellID->4258294],

Cell[TextData[{
 Cell[TextData[ButtonBox["ChromaticNumber",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ChromaticNumber"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "smallest number of colors to color the graph"
}], "GuideText",
 CellID->1658007],

Cell[TextData[{
 Cell[TextData[ButtonBox["MinimumVertexColoring",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MinimumVertexColoring"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "color a graph with the fewest colors"
}], "GuideText",
 CellID->591388939],

Cell[TextData[{
 Cell[TextData[ButtonBox["EdgeColoring",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EdgeColoring"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BipartiteQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/BipartiteQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Backtrack",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Backtrack"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->941737],

Cell[TextData[{
 Cell[TextData[ButtonBox["VertexColoring",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/VertexColoring"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BrelazColoring",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/BrelazColoring"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EdgeChromaticNumber",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EdgeChromaticNumber"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PerfectQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PerfectQ"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->248285531]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graph Predicates", "GuideFunctionsSubsection",
 CellID->193282011],

Cell[TextData[{
 Cell[TextData[ButtonBox["IdenticalQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/IdenticalQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "compare two graphs"
}], "GuideText",
 CellID->145763186],

Cell[TextData[{
 Cell[TextData[ButtonBox["IsomorphicQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/IsomorphicQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test if two graphs are isomorphic"
}], "GuideText",
 CellID->453713803],

Cell[TextData[{
 Cell[TextData[ButtonBox["PseudographQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PseudographQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test if a graph is a pseudograph"
}], "GuideText",
 CellID->59052277],

Cell[TextData[{
 Cell[TextData[ButtonBox["AcyclicQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/AcyclicQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test if a graph is acyclic"
}], "GuideText",
 CellID->300162941],

Cell[TextData[{
 Cell[TextData[ButtonBox["EmptyQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EmptyQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CompleteQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CompleteQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SimpleQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SimpleQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MultipleEdgesQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MultipleEdgesQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UndirectedQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/UndirectedQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UnweightedQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/UnweightedQ"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->21023658],

Cell[TextData[{
 Cell[TextData[ButtonBox["PlanarQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PlanarQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CliqueQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CliqueQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BipartiteQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/BipartiteQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SelfLoopsQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SelfLoopsQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TriangleInequalityQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TriangleInequalityQ"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->351573411]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"]], "GuideTutorial",\

 CellID->14586202]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "GuideMoreAbout",\

 CellID->1567025153],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/ConstructingGraphs"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Graph Properties - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 54.5681416}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Guide", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Degrees -- list of degrees of vertices, InDegree -- number of incoming \
edges, DegreeSequence -- list number of edges for each vertex, GraphicQ -- \
test if a list of integers is a graphic sequence, ListGraphs -- list of \
nonisomorphic undirected graphs, NumberOfGraphs -- number of nonisomorphic \
undirected graphs with n vertices, ListNecklaces -- list distinct necklaces, \
FindCycle -- find cycle in a graph, HamiltonianCycle -- find a Hamiltonian \
cycle, ConnectedComponents -- get lists of connected components, TwoColoring \
-- color vertices of a bipartite graph, ChromaticPolynomial -- compute \
chromatic polynomial for a graph, ChromaticNumber -- smallest number of \
colors to color the graph, MinimumVertexColoring -- color a graph with the \
fewest colors, IdenticalQ -- compare two graphs, IsomorphicQ -- test if two \
graphs are isomorphic, PseudographQ -- test if a graph is a pseudograph, \
AcyclicQ -- test if a graph is acyclic", "synonyms" -> {}, "title" -> 
    "Graph Properties", "type" -> "Guide", "uri" -> 
    "Combinatorica/guide/GraphProperties"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 58, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[680, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[739, 31, 267, 9, 70, "GuideText",
 CellID->33115384],
Cell[1009, 42, 267, 9, 70, "GuideText",
 CellID->191055401],
Cell[1279, 53, 294, 10, 70, "GuideText",
 CellID->327605976],
Cell[1576, 65, 291, 9, 70, "GuideText",
 CellID->593509437],
Cell[1870, 76, 677, 18, 70, "InlineGuideFunctionListing",
 CellID->464642645],
Cell[2550, 96, 48, 1, 70, "GuideDelimiter",
 CellID->281862531],
Cell[2601, 99, 286, 9, 70, "GuideText",
 CellID->267522762],
Cell[2890, 110, 377, 12, 70, "GuideText",
 CellID->10820995],
Cell[3270, 124, 471, 13, 70, "InlineGuideFunctionListing",
 CellID->24436004],
Cell[3744, 139, 48, 1, 70, "GuideDelimiter",
 CellID->367908456],
Cell[3795, 142, 279, 10, 70, "GuideText",
 CellID->223848219],
Cell[4077, 154, 467, 13, 70, "InlineGuideFunctionListing",
 CellID->60461689],
Cell[CellGroupData[{
Cell[4569, 171, 246, 5, 70, "GuideFunctionsSubsection",
 CellID->171509423],
Cell[4818, 178, 266, 9, 70, "GuideText",
 CellID->251891531],
Cell[5087, 189, 285, 10, 70, "GuideText",
 CellID->12923998],
Cell[5375, 201, 301, 10, 70, "GuideText",
 CellID->325113906],
Cell[5679, 213, 1143, 33, 70, "InlineGuideFunctionListing",
 CellID->60706471]
}, Open  ]],
Cell[CellGroupData[{
Cell[6859, 251, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->198465327],
Cell[6932, 254, 286, 10, 70, "GuideText",
 CellID->90488593],
Cell[7221, 266, 306, 10, 70, "GuideText",
 CellID->4258294],
Cell[7530, 278, 302, 10, 70, "GuideText",
 CellID->1658007],
Cell[7835, 290, 308, 10, 70, "GuideText",
 CellID->591388939],
Cell[8146, 302, 660, 18, 70, "InlineGuideFunctionListing",
 CellID->941737],
Cell[8809, 322, 923, 26, 70, "InlineGuideFunctionListing",
 CellID->248285531]
}, Open  ]],
Cell[CellGroupData[{
Cell[9769, 353, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->193282011],
Cell[9844, 356, 265, 9, 70, "GuideText",
 CellID->145763186],
Cell[10112, 367, 285, 10, 70, "GuideText",
 CellID->453713803],
Cell[10400, 379, 285, 10, 70, "GuideText",
 CellID->59052277],
Cell[10688, 391, 269, 9, 70, "GuideText",
 CellID->300162941],
Cell[10960, 402, 1337, 37, 70, "InlineGuideFunctionListing",
 CellID->21023658],
Cell[12300, 441, 1119, 30, 70, "InlineGuideFunctionListing",
 CellID->351573411]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13468, 477, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[13533, 480, 160, 4, 70, "GuideTutorial",
 CellID->14586202]
}, Open  ]],
Cell[CellGroupData[{
Cell[13730, 489, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[13795, 492, 167, 4, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[13965, 498, 171, 4, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[14151, 505, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

