(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19605,        667]
NotebookOptionsPosition[     14368,        525]
NotebookOutlinePosition[     16471,        568]
CellTagsIndexPosition[     16428,        565]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Partitions and Compositions", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Integer Partitions", "GuideFunctionsSubsection",
 CellID->446927982],

Cell[TextData[{
 Cell[TextData[ButtonBox["Partitions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Partitions"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list partitions of a positive integer"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["NextPartition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NextPartition"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "next partition in lexicographic ordering"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["FerrersDiagram",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FerrersDiagram"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "visualize a partition"
}], "GuideText",
 CellID->122675127],

Cell[TextData[{
 Cell[TextData[ButtonBox["PartitionQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PartitionQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomPartition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomPartition"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TransposePartition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TransposePartition"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberOfPartitions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NumberOfPartitions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752],

Cell["\t", "GuideDelimiter",
 CellID->782260976],

Cell[TextData[{
 Cell[TextData[ButtonBox["Distribution",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Distribution"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list the frequency of each element in a list"
}], "GuideText",
 CellID->637307771]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compositions", "GuideFunctionsSubsection",
 CellID->844174025],

Cell[TextData[{
 Cell[TextData[ButtonBox["Compositions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Compositions"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list all compositions of integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " into ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " parts"
}], "GuideText",
 CellID->537382875],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomComposition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomComposition"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a random composition"
}], "GuideText",
 CellID->100929952],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberOfCompositions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NumberOfCompositions"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NextComposition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NextComposition"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->16452306]
}, Open  ]],

Cell[CellGroupData[{

Cell["Set Partitions", "GuideFunctionsSubsection",
 CellID->426880098],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetPartitions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SetPartitions"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "partition a set"
}], "GuideText",
 CellID->94726894],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToCanonicalSetPartition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ToCanonicalSetPartition"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "reorder a set partition into a canonical order"
}], "GuideText",
 CellID->705982196],

Cell[TextData[{
 Cell[TextData[ButtonBox["KSetPartitions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/KSetPartitions"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " partition a set into ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " parts"
}], "GuideText",
 CellID->133466647],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetPartitionQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SetPartitionQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomSetPartition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomSetPartition"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomKSetPartition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomKSetPartition"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->37134518],

Cell[TextData[{
 Cell[TextData[ButtonBox["CoarserSetPartitionQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CoarserSetPartitionQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SetPartitionToRGF",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SetPartitionToRGF"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SetPartitionListViaRGF",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SetPartitionListViaRGF"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->30671624],

Cell["\t", "GuideDelimiter",
 CellID->26878385],

Cell[TextData[{
 Cell[TextData[ButtonBox["RankSetPartition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RankSetPartition"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "rank the set partition in a list of all partitions of a given set"
}], "GuideText",
 CellID->302852496],

Cell[TextData[{
 Cell[TextData[ButtonBox["UnrankSetPartition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/UnrankSetPartition"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RankKSetPartition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RankKSetPartition"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UnrankKSetPartition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/UnrankKSetPartition"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->432721594],

Cell["\t", "GuideDelimiter",
 CellID->331535631],

Cell[TextData[{
 Cell[TextData[ButtonBox["RGFs",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RGFs"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list restricted growth functions"
}], "GuideText",
 CellID->365069774],

Cell[TextData[{
 Cell[TextData[ButtonBox["RankRGF",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RankRGF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find the rank of a restricted growth function"
}], "GuideText",
 CellID->25979694],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomRGF",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomRGF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "random restricted growth function "
}], "GuideText",
 CellID->310271633],

Cell[TextData[{
 Cell[TextData[ButtonBox["RGFToSetPartition",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RGFToSetPartition"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SetPartitionToRGF",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SetPartitionToRGF"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RGFQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RGFQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UnrankRGF",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/UnrankRGF"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->503297303]
}, Open  ]],

Cell[CellGroupData[{

Cell["Young tableaux", "GuideFunctionsSubsection",
 CellID->382466990],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tableaux",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Tableaux"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct Young tableaux from integer partition"
}], "GuideText",
 CellID->902031408],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomTableau",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomTableau"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a random tableau"
}], "GuideText",
 CellID->665418695],

Cell[TextData[{
 Cell[TextData[ButtonBox["PermutationToTableaux",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PermutationToTableaux"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct tableaux from a permutation"
}], "GuideText",
 CellID->554727894],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberOfTableaux",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NumberOfTableaux"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ConstructTableau",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ConstructTableau"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NextTableau",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NextTableau"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58891543],

Cell[TextData[{
 Cell[TextData[ButtonBox["TableauxToPermutation",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TableauxToPermutation"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TableauClasses",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TableauClasses"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->172964716],

Cell["\t", "GuideDelimiter",
 CellID->92686473],

Cell[TextData[{
 Cell[TextData[ButtonBox["InsertIntoTableau",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/InsertIntoTableau"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "insert an integer into a tableau"
}], "GuideText",
 CellID->33323205],

Cell[TextData[{
 Cell[TextData[ButtonBox["TransposeTableau",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TransposeTableau"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "transpose a tableau"
}], "GuideText",
 CellID->191677762],

Cell[TextData[{
 Cell[TextData[ButtonBox["FirstLexicographicTableau",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FirstLexicographicTableau"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "first Young tableau in lexicographic ordering"
}], "GuideText",
 CellID->486727951],

Cell[TextData[{
 Cell[TextData[ButtonBox["TableauQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TableauQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DeleteFromTableau",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DeleteFromTableau"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->99408391],

Cell[TextData[{
 Cell[TextData[ButtonBox["LastLexicographicTableau",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/LastLexicographicTableau"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LongestIncreasingSubsequence",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/LongestIncreasingSubsequence"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->6648153]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"]], "GuideTutorial",\

 CellID->14586202]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Subsets and Permutations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/SubsetsAndPermutations"]], "GuideMoreAbout",
 CellID->313428926]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Partitions and Compositions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 54.8493988}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Guide", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Partitions -- list partitions of a positive integer, NextPartition -- \
next partition in lexicographic ordering, FerrersDiagram -- visualize a \
partition, Distribution -- list the frequency of each element in a list, \
Compositions -- list all compositions of integer n into k parts, \
RandomComposition -- construct a random composition, SetPartitions -- \
partition a set, ToCanonicalSetPartition -- reorder a set partition into a \
canonical order, KSetPartitions -- partition a set into k parts, \
RankSetPartition -- rank the set partition in a list of all partitions of a \
given set, RGFs -- list restricted growth functions, RankRGF -- find the rank \
of a restricted growth function, RandomRGF -- random restricted growth \
function , Tableaux -- construct Young tableaux from integer partition, \
RandomTableau -- construct a random tableau, PermutationToTableaux -- \
construct tableaux from a permutation, InsertIntoTableau -- insert an integer \
into a tableau, TransposeTableau -- transpose a tableau, \
FirstLexicographicTableau -- first Young tableau in lexicographic ordering", 
    "synonyms" -> {}, "title" -> "Partitions and Compositions", "type" -> 
    "Guide", "uri" -> "Combinatorica/guide/PartitionsAndCompositions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 69, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[691, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[772, 33, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->446927982],
Cell[849, 36, 284, 9, 70, "GuideText",
 CellID->203374175],
Cell[1136, 47, 297, 10, 70, "GuideText",
 CellID->1463276848],
Cell[1436, 59, 279, 10, 70, "GuideText",
 CellID->122675127],
Cell[1718, 71, 934, 26, 70, "InlineGuideFunctionListing",
 CellID->58033752],
Cell[2655, 99, 48, 1, 70, "GuideDelimiter",
 CellID->782260976],
Cell[2706, 102, 298, 10, 70, "GuideText",
 CellID->637307771]
}, Open  ]],
Cell[CellGroupData[{
Cell[3041, 117, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->844174025],
Cell[3112, 120, 432, 15, 70, "GuideText",
 CellID->537382875],
Cell[3547, 137, 294, 10, 70, "GuideText",
 CellID->100929952],
Cell[3844, 149, 467, 13, 70, "InlineGuideFunctionListing",
 CellID->16452306]
}, Open  ]],
Cell[CellGroupData[{
Cell[4348, 167, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->426880098],
Cell[4421, 170, 270, 10, 70, "GuideText",
 CellID->94726894],
Cell[4694, 182, 322, 10, 70, "GuideText",
 CellID->705982196],
Cell[5019, 194, 349, 12, 70, "GuideText",
 CellID->133466647],
Cell[5371, 208, 706, 20, 70, "InlineGuideFunctionListing",
 CellID->37134518],
Cell[6080, 230, 724, 20, 70, "InlineGuideFunctionListing",
 CellID->30671624],
Cell[6807, 252, 47, 1, 70, "GuideDelimiter",
 CellID->26878385],
Cell[6857, 255, 327, 10, 70, "GuideText",
 CellID->302852496],
Cell[7187, 267, 715, 20, 70, "InlineGuideFunctionListing",
 CellID->432721594],
Cell[7905, 289, 48, 1, 70, "GuideDelimiter",
 CellID->331535631],
Cell[7956, 292, 267, 9, 70, "GuideText",
 CellID->365069774],
Cell[8226, 303, 285, 9, 70, "GuideText",
 CellID->25979694],
Cell[8514, 314, 279, 9, 70, "GuideText",
 CellID->310271633],
Cell[8796, 325, 904, 25, 70, "InlineGuideFunctionListing",
 CellID->503297303]
}, Open  ]],
Cell[CellGroupData[{
Cell[9737, 355, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->382466990],
Cell[9810, 358, 290, 9, 70, "GuideText",
 CellID->902031408],
Cell[10103, 369, 282, 10, 70, "GuideText",
 CellID->665418695],
Cell[10388, 381, 309, 10, 70, "GuideText",
 CellID->554727894],
Cell[10700, 393, 689, 19, 70, "InlineGuideFunctionListing",
 CellID->58891543],
Cell[11392, 414, 468, 13, 70, "InlineGuideFunctionListing",
 CellID->172964716],
Cell[11863, 429, 47, 1, 70, "GuideDelimiter",
 CellID->92686473],
Cell[11913, 432, 295, 10, 70, "GuideText",
 CellID->33323205],
Cell[12211, 444, 281, 10, 70, "GuideText",
 CellID->191677762],
Cell[12495, 456, 325, 10, 70, "GuideText",
 CellID->486727951],
Cell[12823, 468, 444, 12, 70, "InlineGuideFunctionListing",
 CellID->99408391],
Cell[13270, 482, 500, 13, 70, "InlineGuideFunctionListing",
 CellID->6648153]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13819, 501, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[13884, 504, 160, 4, 70, "GuideTutorial",
 CellID->14586202]
}, Open  ]],
Cell[CellGroupData[{
Cell[14081, 513, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[14146, 516, 180, 4, 70, "GuideMoreAbout",
 CellID->313428926]
}, Open  ]],
Cell[14341, 523, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

