(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11704,        397]
NotebookOptionsPosition[      8451,        307]
NotebookOutlinePosition[      9963,        342]
CellTagsIndexPosition[      9920,        339]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Permutation Groups", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["PermutationGroupQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PermutationGroupQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test if a list of permutations forms a permutation group"
}], "GuideText",
 CellID->2046840],

Cell[TextData[{
 Cell[TextData[ButtonBox["MultiplicationTable",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MultiplicationTable"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SamenessRelation",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SamenessRelation"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->9697595],

Cell["\t", "GuideDelimiter",
 CellID->96831500],

Cell[TextData[{
 Cell[TextData[ButtonBox["CyclicGroup",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CyclicGroup"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "group ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "n"], TraditionalForm]], "InlineMath"],
 " of circular shift permutations"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["DihedralGroup",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DihedralGroup"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "dihedral group ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["D", 
    RowBox[{"2", "n"}]], TraditionalForm]], "InlineMath"]
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["Automorphisms",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Automorphisms"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "group of automorphisms of a graph"
}], "GuideText",
 CellID->6389848],

Cell[TextData[{
 Cell[TextData[ButtonBox["SymmetricGroup",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SymmetricGroup"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AlternatingGroup",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/AlternatingGroup"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KSubsetGroup",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/KSubsetGroup"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KSubsetGroupIndex",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/KSubsetGroupIndex"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752],

Cell["\t", "GuideDelimiter",
 CellID->312227198],

Cell[TextData[{
 Cell[TextData[ButtonBox["MultiplicationTable",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MultiplicationTable"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "obtain a table of group multiplications"
}], "GuideText",
 CellID->215515260],

Cell[TextData[{
 Cell[TextData[ButtonBox["Orbits",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Orbits"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find orbits induced by the action of the group"
}], "GuideText",
 CellID->71522881],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReflexiveQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ReflexiveQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SymmetricQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SymmetricQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TransitiveQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/TransitiveQ"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->399626146],

Cell[TextData[{
 Cell[TextData[ButtonBox["OrbitRepresentatives",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/OrbitRepresentatives"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OrbitInventory",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/OrbitInventory"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->69548467],

Cell["\t", "GuideDelimiter",
 CellID->522101665],

Cell[TextData[{
 Cell[TextData[ButtonBox["CycleStructure",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CycleStructure"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "compute cycle structure of a permutation"
}], "GuideText",
 CellID->465943920],

Cell[TextData[{
 Cell[TextData[ButtonBox["CycleIndex",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CycleIndex"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "cycle index of a group of permutations"
}], "GuideText",
 CellID->20618546],

Cell[TextData[{
 Cell[TextData[ButtonBox["SymmetricGroupIndex",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SymmetricGroupIndex"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "cycle index of a symmetric group"
}], "GuideText",
 CellID->489576558],

Cell[TextData[{
 Cell[TextData[ButtonBox["CyclicGroupIndex",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CyclicGroupIndex"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DihedralGroupIndex",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DihedralGroupIndex"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AlternatingGroupIndex",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/AlternatingGroupIndex"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->292120310],

Cell[TextData[{
 Cell[TextData[ButtonBox["SymmetricGroupIndex",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SymmetricGroupIndex"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PairGroup",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PairGroup"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PairGroupIndex",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PairGroupIndex"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->775571876]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"]], "GuideTutorial",\

 CellID->14586202]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Subsets and Permutations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/SubsetsAndPermutations"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "GuideMoreAbout",\

 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Permutation Groups - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 55.0212782}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Guide", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "PermutationGroupQ -- test if a list of permutations forms a permutation \
group, CyclicGroup -- group C_n of circular shift permutations, DihedralGroup \
-- dihedral group D_2n, Automorphisms -- group of automorphisms of a graph, \
MultiplicationTable -- obtain a table of group multiplications, Orbits -- \
find orbits induced by the action of the group, CycleStructure -- compute \
cycle structure of a permutation, CycleIndex -- cycle index of a group of \
permutations, SymmetricGroupIndex -- cycle index of a symmetric group", 
    "synonyms" -> {}, "title" -> "Permutation Groups", "type" -> "Guide", 
    "uri" -> "Combinatorica/guide/PermutationGroups"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 60, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[682, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[741, 31, 318, 10, 70, "GuideText",
 CellID->2046840],
Cell[1062, 43, 466, 13, 70, "InlineGuideFunctionListing",
 CellID->9697595],
Cell[1531, 58, 47, 1, 70, "GuideDelimiter",
 CellID->96831500],
Cell[1581, 61, 381, 14, 70, "GuideText",
 CellID->203374175],
Cell[1965, 77, 379, 14, 70, "GuideText",
 CellID->1463276848],
Cell[2347, 93, 287, 10, 70, "GuideText",
 CellID->6389848],
Cell[2637, 105, 933, 27, 70, "InlineGuideFunctionListing",
 CellID->58033752],
Cell[3573, 134, 48, 1, 70, "GuideDelimiter",
 CellID->312227198],
Cell[3624, 137, 307, 10, 70, "GuideText",
 CellID->215515260],
Cell[3934, 149, 279, 8, 70, "GuideText",
 CellID->71522881],
Cell[4216, 159, 660, 17, 70, "InlineGuideFunctionListing",
 CellID->399626146],
Cell[4879, 178, 465, 13, 70, "InlineGuideFunctionListing",
 CellID->69548467],
Cell[5347, 193, 48, 1, 70, "GuideDelimiter",
 CellID->522101665],
Cell[5398, 196, 298, 10, 70, "GuideText",
 CellID->465943920],
Cell[5699, 208, 284, 9, 70, "GuideText",
 CellID->20618546],
Cell[5986, 219, 300, 10, 70, "GuideText",
 CellID->489576558],
Cell[6289, 231, 717, 20, 70, "InlineGuideFunctionListing",
 CellID->292120310],
Cell[7009, 253, 688, 19, 70, "InlineGuideFunctionListing",
 CellID->775571876]
}, Open  ]],
Cell[CellGroupData[{
Cell[7734, 277, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[7799, 280, 160, 4, 70, "GuideTutorial",
 CellID->14586202]
}, Open  ]],
Cell[CellGroupData[{
Cell[7996, 289, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[8061, 292, 181, 4, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[8245, 298, 164, 4, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[8424, 305, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

