(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15294,        523]
NotebookOptionsPosition[     11076,        408]
NotebookOutlinePosition[     12895,        448]
CellTagsIndexPosition[     12852,        445]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Permutations", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["Permutations",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Permutations"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list permutations of a set of integers"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Permute",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Permute"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "permute a list given a permutation"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["SignaturePermutation",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SignaturePermutation"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "sign or parity of a permutation"
}], "GuideText",
 CellID->280287058],

Cell[TextData[{
 Cell[TextData[ButtonBox["IdentityPermutation",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/IdentityPermutation"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "identity permutation of a given size"
}], "GuideText",
 CellID->54241119],

Cell[TextData[{
 Cell[TextData[ButtonBox["PermutationQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PermutationQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LexicographicPermutations",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/LexicographicPermutations"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MinimumChangePermutations",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/MinimumChangePermutations"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->876798037],

Cell["\t", "GuideDelimiter",
 CellID->145780294],

Cell[TextData[{
 Cell[TextData[ButtonBox["NextPermutation",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NextPermutation"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "next permutation in lexicographic ordering"
}], "GuideText",
 CellID->396714627],

Cell[TextData[{
 Cell[TextData[ButtonBox["RankPermutation",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RankPermutation"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "associate a permutation with a unique rank"
}], "GuideText",
 CellID->296330991],

Cell[TextData[{
 Cell[TextData[ButtonBox["InversePermutation",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/InversePermutation"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UnrankPermutation",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/UnrankPermutation"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomPermutation",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomPermutation"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Josephus",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Josephus"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752],

Cell["\t", "GuideDelimiter",
 CellID->65841277],

Cell[TextData[{
 Cell[TextData[ButtonBox["PermutationType",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PermutationType"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "type of a permutation"
}], "GuideText",
 CellID->628758482],

Cell[TextData[{
 Cell[TextData[ButtonBox["PermutationGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PermutationGraph"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "graph for a permutation"
}], "GuideText",
 CellID->32370111],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberOfPermutationsByType",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NumberOfPermutationsByType"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberOfPermutationsByCycles",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NumberOfPermutationsByCycles"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->73597233],

Cell["\t", "GuideDelimiter",
 CellID->187557406],

Cell[TextData[{
 Cell[TextData[ButtonBox["SelectionSort",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SelectionSort"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "sort a list given an ordering function"
}], "GuideText",
 CellID->19694652],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinarySearch",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/BinarySearch"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "search a sorted list for a key"
}], "GuideText",
 CellID->14810513],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomHeap",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomHeap"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a random heap"
}], "GuideText",
 CellID->248569486],

Cell[TextData[{
 Cell[TextData[ButtonBox["Heapify",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Heapify"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HeapSort",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/HeapSort"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->847637590],

Cell["\t", "GuideDelimiter",
 CellID->36500989],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToInversionVector",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ToInversionVector"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "inversion vector of a permutation"
}], "GuideText",
 CellID->466765462],

Cell[TextData[{
 Cell[TextData[ButtonBox["Inversions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Inversions"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "number of inversions"
}], "GuideText",
 CellID->593921058],

Cell[TextData[{
 Cell[TextData[ButtonBox["Index",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Index"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "index of a permutation"
}], "GuideText",
 CellID->198614181],

Cell[TextData[{
 Cell[TextData[ButtonBox["FromInversionVector",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FromInversionVector"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Runs",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Runs"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Eulerian",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Eulerian"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->182730812],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberOfPermutationsByInversions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NumberOfPermutationsByInversions"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InversionPoset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/InversionPoset"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->267995463],

Cell["\t", "GuideDelimiter",
 CellID->25522109],

Cell[TextData[{
 Cell[TextData[ButtonBox["Involutions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Involutions"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list permutations with cycles of length at most 2"
}], "GuideText",
 CellID->185184764],

Cell[TextData[{
 Cell[TextData[ButtonBox["Derangements",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Derangements"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list permutations leaving no element untouched"
}], "GuideText",
 CellID->459018149],

Cell[TextData[{
 Cell[TextData[ButtonBox["InvolutionQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/InvolutionQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberOfInvolutions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NumberOfInvolutions"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DerangementQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DerangementQ"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberOfDerangements",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NumberOfDerangements"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->117852412]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"]], "GuideTutorial",\

 CellID->14586202]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Permutation Groups",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PermutationGroups"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Subsets and Cycles",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/SubsetsAndCycles"]], "GuideMoreAbout",\

 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Permutations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 55.1775322}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Guide", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Permutations -- list permutations of a set of integers, Permute -- \
permute a list given a permutation, SignaturePermutation -- sign or parity of \
a permutation, IdentityPermutation -- identity permutation of a given size, \
NextPermutation -- next permutation in lexicographic ordering, \
RankPermutation -- associate a permutation with a unique rank, \
PermutationType -- type of a permutation, PermutationGraph -- graph for a \
permutation, SelectionSort -- sort a list given an ordering function, \
BinarySearch -- search a sorted list for a key, RandomHeap -- construct a \
random heap, ToInversionVector -- inversion vector of a permutation, \
Inversions -- number of inversions, Index -- index of a permutation, \
Involutions -- list permutations with cycles of length at most 2, \
Derangements -- list permutations leaving no element untouched", 
    "synonyms" -> {}, "title" -> "Permutations", "type" -> "Guide", "uri" -> 
    "Combinatorica/guide/Permutations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 54, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[676, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[735, 31, 275, 9, 70, "GuideText",
 CellID->203374175],
Cell[1013, 42, 276, 9, 70, "GuideText",
 CellID->1463276848],
Cell[1292, 53, 301, 10, 70, "GuideText",
 CellID->280287058],
Cell[1596, 65, 303, 10, 70, "GuideText",
 CellID->54241119],
Cell[1902, 77, 731, 20, 70, "InlineGuideFunctionListing",
 CellID->876798037],
Cell[2636, 99, 48, 1, 70, "GuideDelimiter",
 CellID->145780294],
Cell[2687, 102, 302, 10, 70, "GuideText",
 CellID->396714627],
Cell[2992, 114, 302, 10, 70, "GuideText",
 CellID->296330991],
Cell[3297, 126, 932, 26, 70, "InlineGuideFunctionListing",
 CellID->58033752],
Cell[4232, 154, 47, 1, 70, "GuideDelimiter",
 CellID->65841277],
Cell[4282, 157, 281, 10, 70, "GuideText",
 CellID->628758482],
Cell[4566, 169, 284, 10, 70, "GuideText",
 CellID->32370111],
Cell[4853, 181, 505, 13, 70, "InlineGuideFunctionListing",
 CellID->73597233],
Cell[5361, 196, 48, 1, 70, "GuideDelimiter",
 CellID->187557406],
Cell[5412, 199, 293, 10, 70, "GuideText",
 CellID->19694652],
Cell[5708, 211, 283, 10, 70, "GuideText",
 CellID->14810513],
Cell[5994, 223, 270, 9, 70, "GuideText",
 CellID->248569486],
Cell[6267, 234, 422, 11, 70, "InlineGuideFunctionListing",
 CellID->847637590],
Cell[6692, 247, 47, 1, 70, "GuideDelimiter",
 CellID->36500989],
Cell[6742, 250, 297, 10, 70, "GuideText",
 CellID->466765462],
Cell[7042, 262, 267, 9, 70, "GuideText",
 CellID->593921058],
Cell[7312, 273, 259, 9, 70, "GuideText",
 CellID->198614181],
Cell[7574, 284, 663, 18, 70, "InlineGuideFunctionListing",
 CellID->182730812],
Cell[8240, 304, 490, 13, 70, "InlineGuideFunctionListing",
 CellID->267995463],
Cell[8733, 319, 47, 1, 70, "GuideDelimiter",
 CellID->25522109],
Cell[8783, 322, 301, 10, 70, "GuideText",
 CellID->185184764],
Cell[9087, 334, 300, 10, 70, "GuideText",
 CellID->459018149],
Cell[9390, 346, 940, 27, 70, "InlineGuideFunctionListing",
 CellID->117852412]
}, Open  ]],
Cell[CellGroupData[{
Cell[10367, 378, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[10432, 381, 160, 4, 70, "GuideTutorial",
 CellID->14586202]
}, Open  ]],
Cell[CellGroupData[{
Cell[10629, 390, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[10694, 393, 170, 4, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[10867, 399, 167, 4, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[11049, 406, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

