(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12734,        437]
NotebookOptionsPosition[      9340,        340]
NotebookOutlinePosition[     10770,        374]
CellTagsIndexPosition[     10727,        371]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Subsets and Cycles", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Subsets", "GuideFunctionsSubsection",
 CellID->118218032],

Cell[TextData[{
 Cell[TextData[ButtonBox["Subsets",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Subsets"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "give all subsets of a set"
}], "GuideText",
 CellID->436050958],

Cell[TextData[{
 Cell[TextData[ButtonBox["Strings",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Strings"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "subsets with repeating elements"
}], "GuideText",
 CellID->120861883],

Cell[TextData[{
 Cell[TextData[ButtonBox["NextSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NextSubset"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct the next subset in canonical order"
}], "GuideText",
 CellID->599233238],

Cell[TextData[{
 Cell[TextData[ButtonBox["RankSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RankSubset"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UnrankSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/UnrankSubset"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomSubset"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NthSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NthSubset"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->39743717],

Cell["\t", "GuideDelimiter",
 CellID->380287543],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinarySubsets",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/BinarySubsets"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "enumerate subsets using binary representation"
}], "GuideText",
 CellID->56766333],

Cell[TextData[{
 Cell[TextData[ButtonBox["GrayCodeSubsets",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GrayCodeSubsets"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "enumerate subsets using Gray code"
}], "GuideText",
 CellID->16619813],

Cell[TextData[{
 Cell[TextData[ButtonBox["RankBinarySubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RankBinarySubset"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UnrankBinarySubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/UnrankBinarySubset"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NextBinarySubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NextBinarySubset"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->653500982],

Cell[TextData[{
 Cell[TextData[ButtonBox["LexicographicSubsets",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/LexicographicSubsets"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NextLexicographicSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NextLexicographicSubset"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->251065790],

Cell[TextData[{
 Cell[TextData[ButtonBox["RankGrayCodeSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RankGrayCodeSubset"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NextGrayCodeSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NextGrayCodeSubset"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UnrankGrayCodeSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/UnrankGrayCodeSubset"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->183633424],

Cell["\t", "GuideDelimiter",
 CellID->57331466],

Cell[TextData[{
 Cell[TextData[ButtonBox["KSubsets",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/KSubsets"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "subsets with ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " elements"
}], "GuideText",
 CellID->163986411],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomKSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomKSubset"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "random subset with ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " elements"
}], "GuideText",
 CellID->754041792],

Cell[TextData[{
 Cell[TextData[ButtonBox["NextKSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NextKSubset"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RankKSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RankKSubset"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UnrankKSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/UnrankKSubset"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GrayCodeKSubsets",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/GrayCodeKSubsets"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->503941233]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cycles", "GuideFunctionsSubsection",
 CellID->240898064],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToCycles",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ToCycles"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find cycles for a permutation"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["HideCycles",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/HideCycles"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "represent the cycle in a canonical form"
}], "GuideText",
 CellID->205557044],

Cell[TextData[{
 Cell[TextData[ButtonBox["FromCycles",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FromCycles"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RevealCycles",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RevealCycles"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PermutationWithCycle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PermutationWithCycle"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DeBruijnSequence",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DeBruijnSequence"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"]], "GuideTutorial",\

 CellID->14586202]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Subsets and Permutations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/SubsetsAndPermutations"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Permutation Groups",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PermutationGroups"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Partitions and Compositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"]], \
"GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Subsets and Cycles - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 55.3337862}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Guide", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Subsets -- give all subsets of a set, Strings -- subsets with repeating \
elements, NextSubset -- construct the next subset in canonical order, \
BinarySubsets -- enumerate subsets using binary representation, \
GrayCodeSubsets -- enumerate subsets using Gray code, KSubsets -- subsets \
with k elements, RandomKSubset -- random subset with k elements, ToCycles -- \
find cycles for a permutation, HideCycles -- represent the cycle in a \
canonical form", "synonyms" -> {}, "title" -> "Subsets and Cycles", "type" -> 
    "Guide", "uri" -> "Combinatorica/guide/SubsetsAndCycles"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 60, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[682, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[763, 33, 63, 1, 70, "GuideFunctionsSubsection",
 CellID->118218032],
Cell[829, 36, 252, 9, 70, "GuideText",
 CellID->436050958],
Cell[1084, 47, 272, 9, 70, "GuideText",
 CellID->120861883],
Cell[1359, 58, 291, 9, 70, "GuideText",
 CellID->599233238],
Cell[1653, 69, 895, 25, 70, "InlineGuideFunctionListing",
 CellID->39743717],
Cell[2551, 96, 48, 1, 70, "GuideDelimiter",
 CellID->380287543],
Cell[2602, 99, 300, 10, 70, "GuideText",
 CellID->56766333],
Cell[2905, 111, 292, 10, 70, "GuideText",
 CellID->16619813],
Cell[3200, 123, 707, 20, 70, "InlineGuideFunctionListing",
 CellID->653500982],
Cell[3910, 145, 484, 13, 70, "InlineGuideFunctionListing",
 CellID->251065790],
Cell[4397, 160, 719, 20, 70, "InlineGuideFunctionListing",
 CellID->183633424],
Cell[5119, 182, 47, 1, 70, "GuideDelimiter",
 CellID->57331466],
Cell[5169, 185, 334, 12, 70, "GuideText",
 CellID->163986411],
Cell[5506, 199, 353, 13, 70, "GuideText",
 CellID->754041792],
Cell[5862, 214, 918, 27, 70, "InlineGuideFunctionListing",
 CellID->503941233]
}, Open  ]],
Cell[CellGroupData[{
Cell[6817, 246, 62, 1, 70, "GuideFunctionsSubsection",
 CellID->240898064],
Cell[6882, 249, 272, 9, 70, "GuideText",
 CellID->203374175],
Cell[7157, 260, 286, 9, 70, "GuideText",
 CellID->205557044],
Cell[7446, 271, 928, 26, 70, "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8423, 303, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[8488, 306, 160, 4, 70, "GuideTutorial",
 CellID->14586202]
}, Open  ]],
Cell[CellGroupData[{
Cell[8685, 315, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[8750, 318, 181, 4, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[8934, 324, 169, 4, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[9106, 330, 192, 5, 70, "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],
Cell[9313, 338, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

