(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16118,        551]
NotebookOptionsPosition[     11968,        435]
NotebookOutlinePosition[     13631,        472]
CellTagsIndexPosition[     13588,        469]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Subsets and Permutations", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Permutations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/Permutations"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->370565224],

Cell[TextData[{
 Cell[TextData[ButtonBox["Permutations",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Permutations"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list permutations of a set of integers"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["SignaturePermutation",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/SignaturePermutation"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "sign or parity of a permutation"
}], "GuideText",
 CellID->280287058],

Cell[TextData[{
 Cell[TextData[ButtonBox["InversePermutation",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/InversePermutation"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "apply an inverse permutation"
}], "GuideText",
 CellID->295108987],

Cell[TextData[{
 Cell[TextData[ButtonBox["DistinctPermutations",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DistinctPermutations"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IdentityPermutation",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/IdentityPermutation"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->247890778],

Cell[TextData[{
 Cell[TextData[ButtonBox["NextPermutation",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NextPermutation"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RankPermutation",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RankPermutation"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomPermutation",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomPermutation"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/Permutations"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->328072039],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Inversions",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Inversions"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "number of inversions"
}], "GuideText",
 CellID->251838943],

Cell[TextData[{
 Cell[TextData[ButtonBox["Index",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Index"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "index of a permutation"
}], "GuideText",
 CellID->505139901],

Cell[TextData[{
 Cell[TextData[ButtonBox["PermutationGraph",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PermutationGraph"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "graph for a permutation"
}], "GuideText",
 CellID->32370111],

Cell[TextData[{
 Cell[TextData[ButtonBox["DurfeeSquare",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DurfeeSquare"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EncroachingListSet",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/EncroachingListSet"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->220333524],

Cell[TextData[{
 Cell[TextData[ButtonBox["PermutationType",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PermutationType"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Runs",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Runs"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Eulerian",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Runs"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/Permutations"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Permutation Groups \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PermutationGroups"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->403101210],

Cell[TextData[{
 Cell[TextData[ButtonBox["CyclicGroup",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CyclicGroup"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "group of circular shift permutations"
}], "GuideText",
 CellID->284271895],

Cell[TextData[{
 Cell[TextData[ButtonBox["Orbits",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Orbits"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "orbits induced by the action of the group"
}], "GuideText",
 CellID->195937369],

Cell[TextData[{
 Cell[TextData[ButtonBox["CycleIndex",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/CycleIndex"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "cycle index of a group of permutations"
}], "GuideText",
 CellID->480462543],

Cell[TextData[{
 Cell[TextData[ButtonBox["DihedralGroup",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/DihedralGroup"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OrbitRepresentatives",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/OrbitRepresentatives"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Automorphisms",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Automorphisms"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/PermutationGroups"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->593200881]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Subsets and Cycles \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/SubsetsAndCycles"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->197763210],

Cell[TextData[{
 Cell[TextData[ButtonBox["Strings",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/Strings"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "subsets with repeating elements"
}], "GuideText",
 CellID->218562695],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinarySubsets",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/BinarySubsets"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "enumerate subsets"
}], "GuideText",
 CellID->172328660],

Cell[TextData[{
 Cell[TextData[ButtonBox["KSubsets",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/KSubsets"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "subsets with ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " elements"
}], "GuideText",
 CellID->618274653],

Cell[TextData[{
 Cell[TextData[ButtonBox["NextBinarySubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/NextBinarySubset"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RankBinarySubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RankBinarySubset"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->252755692],

Cell[TextData[{
 Cell[TextData[ButtonBox["LexicographicSubsets",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/LexicographicSubsets"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/RandomSubset"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/SubsetsAndCycles"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->296384132],

Cell["\t", "GuideDelimiter",
 CellID->488978520],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToCycles",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/ToCycles"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find cycles for a permutation"
}], "GuideText",
 CellID->202910092],

Cell[TextData[{
 Cell[TextData[ButtonBox["HideCycles",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/HideCycles"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "represent the cycle in canonical form"
}], "GuideText",
 CellID->1695205],

Cell[TextData[{
 Cell[TextData[ButtonBox["FromCycles",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/FromCycles"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PermutationWithCycle",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/ref/PermutationWithCycle"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/SubsetsAndCycles"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->402185829]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"]], "GuideTutorial",\

 CellID->14586202]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Partitions and Compositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Cycles and Connectivity",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/CyclesAndConnectivity"]], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Subsets and Permutations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 55.5056656}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Guide", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Permutations -- list permutations of a set of integers, \
SignaturePermutation -- sign or parity of a permutation, InversePermutation \
-- apply an inverse permutation, Inversions -- number of inversions, Index -- \
index of a permutation, PermutationGraph -- graph for a permutation, \
CyclicGroup -- group of circular shift permutations, Orbits -- orbits induced \
by the action of the group, CycleIndex -- cycle index of a group of \
permutations, Strings -- subsets with repeating elements, BinarySubsets -- \
enumerate subsets, KSubsets -- subsets with k elements, ToCycles -- find \
cycles for a permutation, HideCycles -- represent the cycle in canonical \
form", "synonyms" -> {}, "title" -> "Subsets and Permutations", "type" -> 
    "Guide", "uri" -> "Combinatorica/guide/SubsetsAndPermutations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 66, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[688, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[769, 33, 226, 5, 70, "GuideFunctionsSubsection",
 CellID->370565224],
Cell[998, 40, 275, 9, 70, "GuideText",
 CellID->203374175],
Cell[1276, 51, 301, 10, 70, "GuideText",
 CellID->280287058],
Cell[1580, 63, 294, 10, 70, "GuideText",
 CellID->295108987],
Cell[1877, 75, 476, 13, 70, "InlineGuideFunctionListing",
 CellID->247890778],
Cell[2356, 90, 927, 27, 70, "InlineGuideFunctionListing",
 CellID->328072039],
Cell[3286, 119, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[3337, 122, 267, 9, 70, "GuideText",
 CellID->251838943],
Cell[3607, 133, 259, 9, 70, "GuideText",
 CellID->505139901],
Cell[3869, 144, 284, 10, 70, "GuideText",
 CellID->32370111],
Cell[4156, 156, 458, 13, 70, "InlineGuideFunctionListing",
 CellID->220333524],
Cell[4617, 171, 876, 25, 70, "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]],
Cell[CellGroupData[{
Cell[5530, 201, 237, 5, 70, "GuideFunctionsSubsection",
 CellID->403101210],
Cell[5770, 208, 288, 10, 70, "GuideText",
 CellID->284271895],
Cell[6061, 220, 280, 9, 70, "GuideText",
 CellID->195937369],
Cell[6344, 231, 285, 9, 70, "GuideText",
 CellID->480462543],
Cell[6632, 242, 930, 27, 70, "InlineGuideFunctionListing",
 CellID->593200881]
}, Open  ]],
Cell[CellGroupData[{
Cell[7599, 274, 236, 5, 70, "GuideFunctionsSubsection",
 CellID->197763210],
Cell[7838, 281, 272, 9, 70, "GuideText",
 CellID->218562695],
Cell[8113, 292, 273, 10, 70, "GuideText",
 CellID->172328660],
Cell[8389, 304, 334, 12, 70, "GuideText",
 CellID->618274653],
Cell[8726, 318, 462, 13, 70, "InlineGuideFunctionListing",
 CellID->252755692],
Cell[9191, 333, 692, 20, 70, "InlineGuideFunctionListing",
 CellID->296384132],
Cell[9886, 355, 48, 1, 70, "GuideDelimiter",
 CellID->488978520],
Cell[9937, 358, 272, 9, 70, "GuideText",
 CellID->202910092],
Cell[10212, 369, 282, 9, 70, "GuideText",
 CellID->1695205],
Cell[10497, 380, 685, 19, 70, "InlineGuideFunctionListing",
 CellID->402185829]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11231, 405, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[11296, 408, 160, 4, 70, "GuideTutorial",
 CellID->14586202]
}, Open  ]],
Cell[CellGroupData[{
Cell[11493, 417, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[11558, 420, 186, 4, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[11747, 426, 179, 4, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[11941, 433, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

