(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7331,        247]
NotebookOptionsPosition[      5625,        194]
NotebookOutlinePosition[      6703,        223]
CellTagsIndexPosition[      6660,        220]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AddVertex" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/AddVertex"], 
          "DeleteEdge" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/DeleteEdge"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"AddVertex\"\>", 
       2->"\<\"DeleteEdge\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Constructing Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AddEdge", "ObjectName",
 CellID->29247],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AddEdge", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["e", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " with the new edge ",
     Cell[BoxData[
      FormBox["e", TraditionalForm]], "InlineMath"],
     " added. ",
     Cell[BoxData[
      FormBox["e", TraditionalForm]], "InlineMath"],
     " can have the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], TraditionalForm]], "InlineMath"],
     " or the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], ",", 
         StyleBox["options", "TI"]}], "}"}], TraditionalForm]], "InlineMath"],
     
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28099]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18805],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AddVertex",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/AddVertex"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeleteEdge",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/DeleteEdge"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28051]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->140705814],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->24472179]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->323221192]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AddEdge - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 56.4588150}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "AddEdge[g, e] returns a graph g with the new edge e added. e can have \
the form {a, b} or the form {{a, b}, options}.", "synonyms" -> {}, "title" -> 
    "AddEdge", "type" -> "Symbol", "uri" -> "Combinatorica/ref/AddEdge"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1910, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2533, 77, 45, 1, 70, "ObjectName",
 CellID->29247],
Cell[2581, 80, 1100, 37, 70, "Usage",
 CellID->28099]
}, Open  ]],
Cell[CellGroupData[{
Cell[3718, 122, 311, 9, 70, "SeeAlsoSection",
 CellID->18805],
Cell[4032, 133, 485, 17, 70, "SeeAlso",
 CellID->28051]
}, Open  ]],
Cell[CellGroupData[{
Cell[4554, 155, 318, 9, 70, "TutorialsSection",
 CellID->140705814],
Cell[4875, 166, 186, 4, 70, "Tutorials",
 CellID->24472179]
}, Open  ]],
Cell[CellGroupData[{
Cell[5098, 175, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5420, 186, 163, 3, 70, "MoreAbout",
 CellID->323221192]
}, Open  ]],
Cell[5598, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

